--
-- file prepared:  2025 22:48:04.884, using fd659b
--
--Ammunition DEFA554
local tracer_on_time = 0.01

--
-- DEFA554 round 1 (30.0)
--
declare_weapon({category = CAT_SHELLS,name = "DEFA552_30A",
  user_name		= _("DEFA552_30_APT"),
  model_name    = "tracer_bullet_yellow",
  v0    = 820.0,
  Dv0   = 0.0040,
  Da0     = 0.0008,
  Da1     = 0.0,
  mass      = 0.242,
  round_mass = 0.567,
  explosive     = 0.0000,
  life_time     = 5,
  caliber     = 30.0,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,0.75,0.78,0.270,1.65},
  k1        = 2.0e-08,
  tracer_off    = 4,
  
  tracer_on		= tracer_on_time,
  smoke_tail_life_time = 0.7,
  scale_tracer  = 1,
  cartridge 	= 0,
})

--
-- DEFA554 cannon (30.0)
--
function DEFA_554_A(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "DEFA_554_A"
	tbl.supply 	 =
	{
		shells = {"DEFA552_30A"},
		--mixes  = {{1,2,1,1,2,1}},
		count  = 1000,		--MG20 250,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {1200},  --1800 DEFA554
		recoil_coeff 	 = 1,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1800		--MG20 1500
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 		 or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	return declare_weapon(tbl)
end

--
--	note: the above is modelled after the example for the DEFA_554 cannon as found in Scripts\Database\Weapons\aircraft_gun_mounts.lua, and
--  the example for DEFA552_30 as found in Scripts\Database\Weapons\shell_table.lua
--
