dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")

local gear_system = GetSelf()

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local sensor_data = get_base_data()

--local iCommandPlaneGear
local gear_switch = 68  --定义起落架按键
local gear_up = 430
local gear_down = 431

local nose_gear_status = 1   --起落架状态 0 收起, 1 放下
local launchBarPos = 0
local r_main_gear_status = 1

local weightOnWheel = 0

gear_system:listen_command(gear_switch)
gear_system:listen_command(Keys.PlaneRightMFD_OSB6_Off)
gear_system:listen_command(gear_up)
gear_system:listen_command(gear_down)

local function InitGearSounds()
	GearUp = sndhost:create_sound("Aircrafts/J-20A/Cockpit/Sounds/J-20A_GearUp")
	GearDown = sndhost:create_sound("Aircrafts/J-20A/Cockpit/Sounds/J-20A_GearDown")
end

function post_initialize()
    sndhost = create_sound_host("COCKPIT", "3D", 0, 0, 0)
    InitGearSounds()
    local birth = LockOn_Options.init_conditions.birth_place
    if birth=="GROUND_HOT" then
        nose_gear_status = 1   --起落架状态 0 收起, 1 放下
    elseif birth=="AIR_HOT" then
        nose_gear_status = 0   --起落架状态 0 收起, 1 放下
    elseif birth=="GROUND_COLD" then
        nose_gear_status = 1   --起落架状态 0 收起, 1 放下
    end
end

function SetCommand(command,value)
    if (command == click_cmd.GearLevel) then
        if weightOnWheel~=0 then
            return
        end
        nose_gear_status = 1-value
        if (nose_gear_status == 1) then
            GearDown:play_once()
            GearUp:stop()
        else
            GearUp:play_once()
            GearDown:stop()
        end
    elseif (command == gear_switch) then
        gear_system:performClickableAction(click_cmd.GearLevel,nose_gear_status)
    elseif (command == gear_down) then
        gear_system:performClickableAction(click_cmd.GearLevel,0)
    elseif (command == gear_up) then
        gear_system:performClickableAction(click_cmd.GearLevel,1)
    elseif command == Keys.PlaneRightMFD_OSB6_Off then
        launchBarPos = 1 - launchBarPos
        gear_system:performClickableAction(click_cmd.LaunchBarSw,launchBarPos)
	end
end

function update()
    
end

function release()
    --DebugPrint('gear_system release')
end

need_to_be_closed = false