dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
--dofile(LockOn_Options.script_path.."Systems/device_header.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."utils.lua")

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local LIGHT = GetSelf()
local params_h = {
    cptBackLgt = {get_param_handle('cockpitBackgroundLight'),0,0,0.02},
    cptFloodLgt = {get_param_handle('cockpitFloodLight'),0,0,0.02},
}
local aircraftArgVal = {
    taxiLight = {208,0,0,0.02},
    landingLight = {209,0,0,0.02},
    LeftWingTip = {190,0,0,0.02},
    RightWingTip = {191,0,0,0.02},
    TailBano = {192,0,0,0.02},
    AntiCollision = {193,0,0,0.02},
    wingtip_light = {194,0,0,0.02},
    formation_light = {88,0,0,0.02}
}

--local banoStatus = 0
local antiCollisionStatus = 0
local flood_light_value = 0
local background_light_value = 0

function post_initialize()
	LIGHT:listen_command(Keys.PlaneAirRefuel)
	LIGHT:listen_command(Keys.PlaneHeadingLightOnOff)
	LIGHT:listen_command(Keys.PlaneNavLightOnOff)
	LIGHT:listen_command(Keys.PlaneAntiCollisionLightOnOff)
	LIGHT:listen_command(Keys.flood_light_BRT_Increase)
	LIGHT:listen_command(Keys.flood_light_BRT_Decrease)
	LIGHT:listen_command(Keys.background_light_BRT_Increase)
	LIGHT:listen_command(Keys.background_light_BRT_Decrease)
	LIGHT:listen_command(JoyCmd.Flood_Light_Axis)
	LIGHT:listen_command(JoyCmd.Background_Light_Axis)
	LIGHT:listen_command(click_cmd.flood_light)
	LIGHT:listen_command(click_cmd.background_light)
	local birth_time_hours = LockOn_Options.time.hours	--获取初始化时间（小时）
	local birth = LockOn_Options.init_conditions.birth_place --获取出生状态

    LIGHT:performClickableAction(click_cmd.strobe_light,-1,true)
	if (birth=="GROUND_HOT" or birth=="AIR_HOT") then
		if birth_time_hours>=18 or birth_time_hours<=6 then
			LIGHT:performClickableAction(click_cmd.flood_light,0.8,true)
			LIGHT:performClickableAction(click_cmd.background_light,0.5,true)
        else
			LIGHT:performClickableAction(click_cmd.flood_light,0,true)
			LIGHT:performClickableAction(click_cmd.background_light,0,true)
		end
	elseif birth=="GROUND_COLD" then
		if birth_time_hours>=18 or birth_time_hours<=6 then
			LIGHT:performClickableAction(click_cmd.flood_light,0.8,true)
			LIGHT:performClickableAction(click_cmd.background_light,0.5,true)
		else
			LIGHT:performClickableAction(click_cmd.flood_light,0,true)
			LIGHT:performClickableAction(click_cmd.background_light,0,true)
		end
	end
end

function SetCommand(command,value)
	--DebugPrint('灯光系统：'..Get_command_name(command)..'..........'..value)
	if command == Keys.PlaneAirRefuel then
        aircraftArgVal.airRefuel[2] = 1 - aircraftArgVal.airRefuel[2]
    elseif command == Keys.PlaneHeadingLightOnOff then
        if aircraftArgVal.taxiLight[2] == 0 and aircraftArgVal.landingLight[2]==0 then
            LIGHT:performClickableAction(click_cmd.taxi_light,1)
        elseif aircraftArgVal.taxiLight[2] == 1 and aircraftArgVal.landingLight[2]==0 then
            LIGHT:performClickableAction(click_cmd.taxi_light,-1)
        elseif aircraftArgVal.taxiLight[2] == 0 and aircraftArgVal.landingLight[2]==1 then
            LIGHT:performClickableAction(click_cmd.taxi_light,0)
        end
    elseif command == Keys.PlaneNavLightOnOff then
        LIGHT:performClickableAction(click_cmd.strobe_light,1 - aircraftArgVal.LeftWingTip[2])
    elseif command == Keys.PlaneAntiCollisionLightOnOff then
        LIGHT:performClickableAction(click_cmd.antiCollision_light,1 - antiCollisionStatus)
    elseif command == click_cmd.strobe_light then
        aircraftArgVal.LeftWingTip[2] = value
        aircraftArgVal.RightWingTip[2] = value
        aircraftArgVal.TailBano[2] = value
    elseif command == click_cmd.formation_light then
        aircraftArgVal.formation_light[2] = value
    elseif command == click_cmd.wingtip_light then
        aircraftArgVal.wingtip_light[2] = value
    elseif command == click_cmd.antiCollision_light then
        antiCollisionStatus = value

	elseif command == Keys.background_light_BRT_Increase then
        if background_light_value~=params_h.cptBackLgt[2] then
            background_light_value = params_h.cptBackLgt[2]
        end
		background_light_value = background_light_value + 0.1
		background_light_value = Limit(background_light_value,0,1)
		LIGHT:performClickableAction(click_cmd.background_light,background_light_value,true)
	elseif command == Keys.background_light_BRT_Decrease then
        if background_light_value~=params_h.cptBackLgt[2] then
            background_light_value = params_h.cptBackLgt[2]
        end
		background_light_value = background_light_value - 0.1
		background_light_value = Limit(background_light_value,0,1)
		LIGHT:performClickableAction(click_cmd.background_light,background_light_value,true)

	elseif command == JoyCmd.Background_Light_Axis then
		value = Limit(value,0,1)
        LIGHT:performClickableAction(click_cmd.background_light,value,true)
    elseif command == click_cmd.background_light then
		value = Limit(value,0,1)
        params_h.cptBackLgt[2] = value

	elseif command == Keys.flood_light_BRT_Increase then
		if flood_light_value~=params_h.cptFloodLgt[2] then
            flood_light_value = params_h.cptFloodLgt[2]
        end
        flood_light_value = flood_light_value + 0.1
		flood_light_value = Limit(flood_light_value,0,1)
		LIGHT:performClickableAction(click_cmd.flood_light,flood_light_value,true)
	elseif command == Keys.flood_light_BRT_Decrease then
		if flood_light_value~=params_h.cptFloodLgt[2] then
            flood_light_value = params_h.cptFloodLgt[2]
        end
        flood_light_value = flood_light_value - 0.1
		flood_light_value = Limit(flood_light_value,0,1)
		LIGHT:performClickableAction(click_cmd.flood_light,flood_light_value,true)

    elseif command == JoyCmd.Flood_Light_Axis then
		value = Limit(value,0,1)
        LIGHT:performClickableAction(click_cmd.flood_light,value,true)
	elseif command == click_cmd.flood_light then
        value = Limit(value,0,1)
		params_h.cptFloodLgt[2] = value

	elseif command == click_cmd.taxi_light then
        if value == 1 then
            aircraftArgVal.taxiLight[2] = 1
            aircraftArgVal.landingLight[2] = 0
        elseif value == -1 then
            aircraftArgVal.landingLight[2] = 1
            aircraftArgVal.taxiLight[2] = 0
        else
            aircraftArgVal.landingLight[2] = 0
            aircraftArgVal.taxiLight[2] = 0
        end
    end
end

function update()
    if antiCollisionStatus == 1 then
        aircraftArgVal.AntiCollision[4] = 0
        aircraftArgVal.AntiCollision[3] = LoopPlayAnimal(aircraftArgVal.AntiCollision[3],0.02,-1,0.6)
        aircraftArgVal.AntiCollision[2] = aircraftArgVal.AntiCollision[3]
    else
        aircraftArgVal.AntiCollision[2] = 0
        aircraftArgVal.AntiCollision[4] = 0.02
    end

    if get_elec_primary_dc_ok() then
        for k, v in pairs(aircraftArgVal) do
            v[3] = v[2]
            v[4] = 0.02
        end
        for k, v in pairs(params_h) do
            if type(v[3])~="nil" then
                v[3] = v[2]
                v[4] = 0.02
            end
        end
    else
        for k, v in pairs(aircraftArgVal) do
            v[3] = 0
            v[4] = 0
        end
        for k, v in pairs(params_h) do
            if type(v[3])~="nil" then
                v[3] = 0
                v[4] = 0
            end
        end
    end
	for k, v in pairs(params_h) do
        if type(v[3])~="nil" then
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],0,1)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],0,1)
            end
            v[1]:set(v[3])
        else
            v[1]:set(v[2])
        end
    end
    for k, v in pairs(aircraftArgVal) do
        if v[2]>v[3] then
            if v[2]-v[3]<v[4] then
                v[3]=v[2]
            else
                v[3]=v[3] + v[4]
            end
        elseif v[2]<v[3] then
            if v[3]-v[2]<v[4] then
                v[3]=v[2]
            else
                v[3]=v[3] - v[4]
            end
        end
        set_aircraft_draw_argument_value(v[1],v[3])
    end
end

need_to_be_closed = false
