local Enable_MP3Player = get_aircraft_property("MP3Player")
if Enable_MP3Player~=1 then
	return
end

dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/mp3List.lua")

local mp3_system = GetSelf()

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)
local modPath=LockOn_Options.script_path.."../../"



--local iCommandPlaneGear
local pauseOrPlay = Keys.mp3Player_pauseOrPlay  --暂停/播放
local _next = Keys.mp3Player_next --下一首
local last = Keys.mp3Player_last --上一首
local fastForward = Keys.mp3Player_fastForward --快进
local fastBack = Keys.mp3Player_fastBack --快退

local playbackPro = 0 --歌曲进度,秒为单位
local view_mode = 0 --0光盘，1歌词
local lrcLineIndex=1--歌词进度，歌词当前行数
local loopMode = 2 --循环模式，0单曲，1，歌单循环，2歌单放完就结束
local playStatus = 0 -- 播放状态 0暂停 1播放
local currentIndex = 1 --当前播放曲目索引
local fastStatus = 0 --快退/快进状态 0正常 1快进 -1快退
local mp3_disk_rot_val=0

mp3_system:listen_command(pauseOrPlay)
mp3_system:listen_command(_next)
mp3_system:listen_command(last)
mp3_system:listen_command(fastForward)
mp3_system:listen_command(fastBack)
mp3_system:listen_command(Keys.mp3LrcViewTrigger)
mp3_system:listen_command(Keys.mp3PlayMode)
local mp3_music_list_enable = get_param_handle("MP3_MUSIC_LIST_ENABLE")
local mp3_play_enable = get_param_handle("MP3_PLAY_ENABLE")
local mp3_playback_pro_text = get_param_handle("MP3_PLAYBACK_PRO_TEXT")
local mp3_song_length_text = get_param_handle('MP3_SONG_LENGTH_TEXT')
local mp3_name_next_text = get_param_handle("MP3_NAME_NEXT_TEXT")
local mp3_name_text = get_param_handle("MP3_NAME_TEXT")
local mp3_name_last_text = get_param_handle("MP3_NAME_LAST_TEXT")
local mp3_playback_pro_bar = get_param_handle("MP3_PLAYBACK_PRO_BAR")
local mp3_fast_mag =1 --快进倍率
local mp3_last_lrc_text = get_param_handle("MP3_LAST_LRC_TEXT")
local mp3_cur_lrc_text = get_param_handle("MP3_CUR_LRC_TEXT")
local mp3_next_lrc_text = get_param_handle("MP3_NEXT_LRC_TEXT")
local mp3_lrc_enable = get_param_handle("MP3_LRC_ENABLE")
local mp3_disk_rot = get_param_handle("MP3_DISK_ROT")
local MP3_Index = get_param_handle('MP3_Index')

local params_h = {
    MAGNETIC_HEADER = {get_param_handle('MAGNETIC_HEADER'),0,0,0.05}
}

local sndSourceList = {}

local testSnd=nil
function post_initialize()
    sndhost = create_sound_host("MP3 Player", "HEADPHONES", 0, 0, 0)
    for k, v in pairs(mp3List) do
        sndSourceList[#sndSourceList+1] = sndhost:create_sound(v.path)
    end
    testSnd=sndhost:create_sound('Aircrafts/F-16/Afterburner')
    --testSnd:play_continue()
end

function SetCommand(command,value)
    if (command == pauseOrPlay) then
        fastStatus = 0
        if playStatus == 0 then
            print_message_to_user("播放")
            print_message_to_user(mp3List[currentIndex].name)
            if sndSourceList[currentIndex]:is_playing() and playbackPro<= mp3List[currentIndex].length then
                -- 暂停是通过设置播放速度为0的方式实现的，因此需要检测是播放中暂停还是本来就没播放过
                sndSourceList[currentIndex]:update(1,1,1)
            else
                sndSourceList[currentIndex]:play_once(playbackPro)
            end
            if mp3List[currentIndex].length <= playbackPro then
                playbackPro=0
                lrcLineIndex=1--重置歌词进度
            end
        else
            print_message_to_user("暂停")
            sndSourceList[currentIndex]:update(0.0001,nil,nil)
        end
        playStatus = 1 - playStatus
    elseif (command == _next) then
        print_message_to_user("下一首")
		playbackPro=0--重置进度条
        lrcLineIndex=1--重置歌词进度
        fastStatus = 0
        playStatus = 1
        mp3_disk_rot_val=0
        sndSourceList[currentIndex]:stop()
        if (currentIndex >= length) then
            print_message_to_user("回到第一首")
            currentIndex = 1
        else
            currentIndex = currentIndex + 1
        end
        if loopMode == 0 then
            sndSourceList[currentIndex]:play_continue()
        else
            sndSourceList[currentIndex]:play_once()
        end
    elseif (command == last) then
        print_message_to_user("上一首")
		playbackPro=0--重置进度条
        lrcLineIndex=1--重置歌词进度
        fastStatus = 0
        playStatus = 1
        mp3_disk_rot_val=0
        sndSourceList[currentIndex]:stop()
        if (currentIndex <= 1) then
            print_message_to_user("回到最后一首")
            currentIndex = length
        else
            currentIndex = currentIndex - 1
        end
        if loopMode == 0 then
            sndSourceList[currentIndex]:play_continue()
        else
            sndSourceList[currentIndex]:play_once()
        end
    elseif (command == fastForward) then
        mp3_fast_mag=2*mp3_fast_mag
        if mp3_fast_mag>12 then
            fastStatus = 0
            playStatus = 1
            mp3_fast_mag=1
        else
            print_message_to_user(string.format( "快进X%d",mp3_fast_mag ))
            fastStatus = 1
            playStatus = 0
            sndSourceList[currentIndex]:update(6,0,nil)
        end
    elseif (command == fastBack) then
        mp3_fast_mag=2*mp3_fast_mag
        if mp3_fast_mag>12 then
            fastStatus = 0
            playStatus = 1
            mp3_fast_mag=1
        else
            print_message_to_user(string.format( "快退X%d",mp3_fast_mag ))
            fastStatus = -1
            playStatus = 0
        end
    elseif (command == Keys.mp3LrcViewTrigger) then
        view_mode = view_mode+1
        if view_mode > 2 then
            view_mode = 0
        end
    elseif command == Keys.mp3PlayMode then
        loopMode = loopMode + 1
        if loopMode == 3 then
            loopMode = 0
        end
	end
end
-- 显示歌单的函数
local function showMusicList()
    local name1,name_1,name2,name_2,name3,name_3;
    if currentIndex<4 then
        name1=mp3List[currentIndex+1].name;
        name2=mp3List[currentIndex+2].name;
        name3=mp3List[currentIndex+3].name;
        if currentIndex==1 then
            name_1=''
            name_2=''
            name_3=''
        elseif currentIndex==2 then
            name_1=''
            name_2=''
            name_3=mp3List[currentIndex-1].name
        elseif currentIndex == 3 then
            name_1=''
            name_2=mp3List[currentIndex-2].name
            name_3=mp3List[currentIndex-1].name
        else
            name_1=mp3List[currentIndex-3].name
            name_2=mp3List[currentIndex-2].name
            name_3=mp3List[currentIndex-1].name
        end
    elseif currentIndex > length-4 then
        name_1=mp3List[currentIndex-3].name
        name_2=mp3List[currentIndex-2].name
        name_3=mp3List[currentIndex-1].name
        if currentIndex==length then
            name1='';
            name2='';
            name3='';
        elseif currentIndex==length-1 then
            name1=mp3List[currentIndex+1].name;
            name2='';
            name3='';
        elseif currentIndex == length-2 then
            name1=mp3List[currentIndex+1].name;
            name2=mp3List[currentIndex+2].name;
            name3='';
        else
            name1=mp3List[currentIndex+1].name;
            name2=mp3List[currentIndex+2].name;
            name3=mp3List[currentIndex+3].name;
        end
    else
        name_1=mp3List[currentIndex-3].name
        name_2=mp3List[currentIndex-2].name
        name_3=mp3List[currentIndex-1].name
        name1=mp3List[currentIndex+1].name;
        name2=mp3List[currentIndex+2].name;
        name3=mp3List[currentIndex+3].name;
    end
    mp3_playback_pro_bar:set(playbackPro/mp3List[currentIndex].length)
    mp3_name_last_text:set(string.format( "%s\r\n%s\r\n%s",name_1,name_2,name_3))
    mp3_name_text:set(mp3List[currentIndex].name)
    mp3_name_next_text:set(string.format( "%s\r\n%s\r\n%s",name1,name2,name3))
end


local function showMusicLrc()
    local cur_lrc=''
    local last_lrc=''
    local next_lrc=''
    local filePath=modPath.."sounds/effects/"..mp3List[currentIndex].path..".lua"
    local F,err=io.open(filePath,"r+");
    local _lrc=nil
    if err==nil then
        dofile(filePath)
        _lrc=lrc
    end
    if _lrc==nil then
        mp3_last_lrc_text:set('')
        mp3_cur_lrc_text:set("No Lrc")
        mp3_next_lrc_text:set('')
    else
        for k, v in pairs(_lrc.data) do
            local pos = v.pos
            local next = _lrc.data[k + 1]
            local nextPos
            if next then
                nextPos = next.pos
            else
                nextPos = pos + 1
            end
            if playbackPro > v.pos and playbackPro < nextPos then
                if k-5>0 then
                    last_lrc=last_lrc..'\r\n'.._lrc.data[k-5].lrcText
                end
                if k-4>0 then
                    last_lrc=last_lrc..'\r\n'.._lrc.data[k-4].lrcText
                end
                if k-3>0 then
                    last_lrc=last_lrc..'\r\n'.._lrc.data[k-3].lrcText
                end
                if k-2>0 then
                    last_lrc=last_lrc..'\r\n'.._lrc.data[k-2].lrcText
                end
                if k-1>0 then
                    last_lrc=last_lrc..'\r\n'.._lrc.data[k-1].lrcText
                end
                cur_lrc=v.lrcText
                
                if k+1<=_lrc.lrcNo then
                    next_lrc=next_lrc..'\r\n'.._lrc.data[k+1].lrcText
                end
                if k+2<=_lrc.lrcNo then
                    next_lrc=next_lrc..'\r\n'.._lrc.data[k+2].lrcText
                end
                if k+3<=_lrc.lrcNo then
                    next_lrc=next_lrc..'\r\n'.._lrc.data[k+3].lrcText
                end
                if k+4<=_lrc.lrcNo then
                    next_lrc=next_lrc..'\r\n'.._lrc.data[k+4].lrcText
                end
                if k+5<=_lrc.lrcNo then
                    next_lrc=next_lrc..'\r\n'.._lrc.data[k+5].lrcText
                end
                --]]
                mp3_last_lrc_text:set(last_lrc)
                mp3_cur_lrc_text:set(cur_lrc)
                mp3_next_lrc_text:set(next_lrc)
            end
        end
    end
end
--local time=0;

function update()
    mp3_playback_pro_text:set(SecondsFormat_mmss(playbackPro))
    mp3_song_length_text:set(SecondsFormat_mmss(mp3List[currentIndex].length))
    if playbackPro > mp3List[currentIndex].length then
        if loopMode==1 then
            -- 歌单循环
            if currentIndex==length then
                -- 最后一首，播放第一首
                currentIndex=1
            else
                currentIndex=currentIndex+1
            end
            playbackPro = 0
            sndSourceList[currentIndex]:play_once()
        elseif loopMode==2 then
            --播放完就结束
            if currentIndex>#sndSourceList then
                playStatus=0
                currentIndex = 1
            else
                currentIndex=currentIndex+1
                playbackPro = 0
                sndSourceList[currentIndex]:play_once()
            end
        else
            playbackPro = 0
            sndSourceList[currentIndex]:play_once()
        end
    end
    params_h.MAGNETIC_HEADER[2] = playStatus
    mp3_lrc_enable:set(view_mode)
    mp3_music_list_enable:set(view_mode)
    mp3_disk_rot:set(mp3_disk_rot_val)
    MP3_Index:set(currentIndex)
    showMusicList()
    showMusicLrc()
    if playStatus == 1 then
        mp3_play_enable:set(1)
        sndSourceList[currentIndex]:update(1,1,1)
        mp3_fast_mag=1
        playbackPro = playbackPro + update_time_step --正常计算进度
        if mp3_disk_rot_val <360 then
			mp3_disk_rot_val = mp3_disk_rot_val+0.1
		else
			mp3_disk_rot_val = 0
		end
    else
        mp3_play_enable:set(0)
        if fastStatus == 1 then
            playbackPro = playbackPro + update_time_step*mp3_fast_mag --快进
            if mp3_disk_rot_val <360 then
				mp3_disk_rot_val = mp3_disk_rot_val+0.1*mp3_fast_mag
			else
				mp3_disk_rot_val = 0
			end
            sndSourceList[currentIndex]:update(mp3_fast_mag,0.001,mp3_fast_mag)
            if playbackPro>mp3List[currentIndex].length then
                --如果快进进度超过歌曲长度，自动播放下一首
                fastStatus=0
                playStatus=1
                playbackPro=0--进度清零
                mp3_fast_mag=1--快进倍率变为正常
                currentIndex=currentIndex+1--下一首
                sndSourceList[currentIndex]:play_once()
            end
        elseif fastStatus == -1 then
            playbackPro = playbackPro - update_time_step*mp3_fast_mag --快退
			if mp3_disk_rot_val <360 then
				mp3_disk_rot_val = mp3_disk_rot_val-0.1*mp3_fast_mag
			else
				mp3_disk_rot_val = 0
			end
            sndSourceList[currentIndex]:update(-mp3_fast_mag,0.001,-mp3_fast_mag)
            if playbackPro>mp3List[currentIndex].length then
                --如果快进进度超过歌曲长度，自动播放下一首
                fastStatus=0
                playStatus=1
                playbackPro=0--进度清零
                mp3_fast_mag=1--快进倍率变为正常
                currentIndex=currentIndex+1--下一首
                sndSourceList[currentIndex]:play_once()
            end
        end
    end
    for k, v in pairs(params_h) do
        if type(v[3])~="nil" then
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],0,1)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],0,1)
            end
            v[1]:set(v[3])
        else
            v[1]:set(v[2])
        end
    end
end

need_to_be_closed = false