dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")
dofile(LockOn_Options.script_path.."utils.lua")

local dev = GetSelf()

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local params_h = {
    EADI_ROLL = {get_param_handle('EADI_ROLL'),0},
    EADI_PITCH = {get_param_handle('EADI_PITCH'),0},
    IAS_KMH = {get_param_handle('IAS_KMH'),0},
    TAS_KMH = {get_param_handle('TAS_KMH'),0},
    IAS_KNOT = {get_param_handle('IAS_KNOT'),0},
    TAS_KNOT = {get_param_handle('TAS_KNOT'),0},
    VS = {get_param_handle('VS',0)},
    VS_FT = {get_param_handle('VS_FT',0)},
    AS = {get_param_handle('AS'),0},
    TAS = {get_param_handle('TAS'),0},
    ALT_FT = {get_param_handle('ALT_FT'),0},
    RALT_FT = {get_param_handle('RALT_FT'),0},
    RALT = {get_param_handle('RALT'),0},
    ALT = {get_param_handle('ALT'),0},
    HDG_DEG = {get_param_handle('HDG_DEG'),0},
    HDG = {get_param_handle('HDG'),0},
    NET_HDG = {get_param_handle('NET_HDG'),0}, --按初始航向校准后的净航向，度
    MHDG_DEG = {get_param_handle('MHDG_DEG'),0},
    MAG_VAR = {get_param_handle('MAG_VAR'),0},
    AOA_DEG = {get_param_handle('AOA_DEG'),0},
    AOS_DEG = {get_param_handle('AOS_DEG'),0},
    OVER_G = {get_param_handle('OVER_G'),0},
    AOA_DEROD_RUD_POSTG = {get_param_handle('ROD_RUD_POST'),1},
    L_ENG_RPM = {get_param_handle('L_ENG_RPM'),0},
    R_ENG_RPM = {get_param_handle('R_ENG_RPM'),0},
    L_ENG_TMP = {get_param_handle('L_ENG_TMP'),0},
    R_ENG_TMP = {get_param_handle('R_ENG_TMP'),0},
    L_ENG_FUEL = {get_param_handle('L_ENG_FUEL'),0},
    R_ENG_FUEL = {get_param_handle('R_ENG_FUEL'),0},
    FUEL_TOTAL = {get_param_handle('FUEL_TOTAL'),0},
    MAX_G = {get_param_handle('MAX_G'),0},
}
local unit = get_param_handle('UNIT')
local hdgType = get_param_handle('HDG_TYPE')
local HEAD_AZ_RAD=get_param_handle('HEAD_AZ_RAD')
local HEAD_EL_RAD=get_param_handle('HEAD_EL_RAD')

local runonce,init_MHDG_DEG,init_HDG_DEG,init_heading
function post_initialize()
    runonce = 1
end

function SetCommand(command,value)

end

function update()

    HEAD_AZ_RAD:set(math.rad(get_param_handle('HEAD_AZ'):get()))
    HEAD_EL_RAD:set(math.rad(get_param_handle('HEAD_EL'):get()))
    params_h.EADI_PITCH[2] = BASE_SENSOR.PITCH:get()
    params_h.EADI_ROLL[2] = BASE_SENSOR.ROLL:get()
    -- 获取当前表空速，如果表速度读取为0，则使用地速代替
    if BASE_SENSOR.IAS:get()==0 then
        params_h.IAS_KMH[2] = GetGroundSpeed()*MS_TO_KMH
        params_h.IAS_KNOT[2] = GetGroundSpeed()*MS_TO_KNOTS
    else
        params_h.IAS_KMH[2] = BASE_SENSOR.IAS:get()*MS_TO_KMH
        params_h.IAS_KNOT[2] = BASE_SENSOR.IAS:get()*MS_TO_KNOTS
    end
    -- 获取当前真空速，如果真空速读取为0，则使用地速代替
    if BASE_SENSOR.TAS:get()==0 then
        params_h.TAS_KMH[2] = GetGroundSpeed()*MS_TO_KMH
        params_h.TAS_KNOT[2] = GetGroundSpeed()*MS_TO_KNOTS
    else
        params_h.TAS_KMH[2] = BASE_SENSOR.TAS:get()*MS_TO_KMH
        params_h.TAS_KNOT[2] = BASE_SENSOR.TAS:get()*MS_TO_KNOTS
    end
    params_h.ALT_FT[2] = BASE_SENSOR.BAROALT:get()*METER_TO_FEET --气压高度，米转换为英尺
    params_h.RALT_FT[2] = BASE_SENSOR.RADALT:get()*METER_TO_FEET --雷达高度，米转换为英尺
    params_h.VS[2] = BASE_SENSOR.VERTICAL_SPEED:get()
    params_h.VS_FT[2] = BASE_SENSOR.VERTICAL_SPEED:get()*METER_TO_FEET
    params_h.HDG_DEG[2] = 360-math.deg(BASE_SENSOR.HEADING:get())
    params_h.MHDG_DEG[2] = math.deg(BASE_SENSOR.MAG_HEADING:get())
    if params_h.MHDG_DEG[2]<0 then
        params_h.MHDG_DEG[2] = 360 + params_h.MHDG_DEG[2]
    end
    params_h.MAG_VAR[2] = params_h.HDG_DEG[2] - params_h.MHDG_DEG[2]
    params_h.AOA_DEG[2] = math.deg(BASE_SENSOR.AOA:get())
    params_h.AOS_DEG[2] = math.deg(BASE_SENSOR.AOS:get())
    params_h.OVER_G[2] = BASE_SENSOR.VERTICAL_ACCEL:get()
    params_h.L_ENG_RPM[2] = BASE_SENSOR.LEFT_ENGINE_RPM:get()*100
    params_h.R_ENG_RPM[2] = BASE_SENSOR.RIGHT_ENGINE_RPM:get()*100
    params_h.L_ENG_TMP[2] = BASE_SENSOR.LEFT_ENGINE_TEMP_BEFORE_TURBINE:get()
    params_h.R_ENG_TMP[2] = BASE_SENSOR.RIGHT_ENGINE_TEMP_BEFORE_TURBINE:get()
    if unit:get()==0 then
        params_h.AS[2] = params_h.IAS_KMH[2]
        params_h.TAS[2] = params_h.TAS_KMH[2]
        params_h.RALT[2] = BASE_SENSOR.RADALT:get()
        params_h.ALT[2] = BASE_SENSOR.BAROALT:get()
        params_h.L_ENG_FUEL[2] = BASE_SENSOR.LEFT_ENGINE_FUEL_CONSUPMTION:get()
        params_h.R_ENG_FUEL[2] = BASE_SENSOR.RIGHT_ENGINE_FUEL_CONSUPMTION:get()
        params_h.FUEL_TOTAL[2] = BASE_SENSOR.FUEL_TOTAL:get()
    else
        params_h.AS[2] = params_h.IAS_KNOT[2]
        params_h.TAS[2] = params_h.TAS_KNOT[2]
        params_h.ALT[2] = params_h.ALT_FT[2]
        params_h.RALT[2] = params_h.RALT_FT[2]
        params_h.L_ENG_FUEL[2] = BASE_SENSOR.LEFT_ENGINE_FUEL_CONSUPMTION:get()*KG_TO_LBS
        params_h.R_ENG_FUEL[2] = BASE_SENSOR.RIGHT_ENGINE_FUEL_CONSUPMTION:get()*KG_TO_LBS
        params_h.FUEL_TOTAL[2] = BASE_SENSOR.FUEL_TOTAL:get()*KG_TO_LBS
    end
    if runonce~=0 then
        init_MHDG_DEG = params_h.MHDG_DEG[2]
        init_HDG_DEG = params_h.HDG_DEG[2]
        runonce=0
    end
    if hdgType:get()==0 then
        params_h.HDG[2]=params_h.MHDG_DEG[2]
        init_heading = init_MHDG_DEG
    else
        params_h.HDG[2]=params_h.HDG_DEG[2]
        init_heading = init_HDG_DEG
    end
    params_h.NET_HDG[2] = params_h.HDG[2]-init_heading
    if BASE_SENSOR.VERTICAL_ACCEL:get() > params_h.MAX_G[2] then
        params_h.MAX_G[2]= BASE_SENSOR.VERTICAL_ACCEL:get()
    end
    for k, v in pairs(params_h) do
        v[1]:set(v[2])
    end
end

need_to_be_closed = false