dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")
dofile(LockOn_Options.script_path.."utils.lua")

local dev = GetSelf()

local sensor_data = get_base_data()
local Terrain = require('terrain')

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)

local scanerPixel = {}
local maxRange_h = get_param_handle('MAX_RANGE')
local hsiMap_h = get_param_handle('HSI_MAP')

function post_initialize()
--    for i = 1, 200, 1 do
--        scanerPixel[i] = {}
--        for j = 1, 200, 1 do
--            scanerPixel[i][j] = {
--                land=get_param_handle(string.format('TERRAIN_PIX_%.0f_%.0f_LAND',i,j))
--            }
--        end
--    end
end

function SetCommand(command,value)
    
end
local line = 1
local function terrainScan()
    local pos_x_loc, alt, pos_y_loc= sensor_data.getSelfCoordinates()--获取本机坐标
    local coord = lo_to_geo_coords(pos_x_loc, pos_y_loc)--地理经纬度转换成米坐标
    local lat_m,lon_m = Terrain.convertLatLonToMeters(coord.lat,coord.lon)--本机当前坐标，米
    local scale = 40/maxRange_h:get()--比例尺
    local range_scale = (1.2/40000)*scale--这是每一米在显示器的距离
    local backRange = 200/2*0.4--这个0.4是本机在显示器距离显示器底部的距离像素数
    line = line + 1
    if line > 200 then
        line = 1
    end
    for i = 1, 200, 1 do
        local y_range = (line - backRange) * (1 / (200 / 2)) / range_scale --这是距离本机的纬度距离
        local x_range = (i - (200 / 2)) * (1 / (200 / 2)) / range_scale--这是距离本机的经度距离
        local targetLat = lat_m + y_range--要扫描的地形维度
        local targetLon = lon_m + x_range--要扫描的地形经度
        local terrainType = Terrain.GetSurfaceType(targetLat, targetLon)--获取目标地形类型
        if terrainType == 'land' then
            scanerPixel[line][i].land:set(1)--陆地
        elseif terrainType == 'sea' then
            scanerPixel[line][i].land:set(2)--海洋
        end
    end
end

function update()
    if get_elec_primary_ac_ok() and hsiMap_h:get()==1 then
        terrainScan()
    end
end

need_to_be_closed = false