dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")

local gettext = require("i_18n")
_ = gettext.translate

cursor_mode =
{
    CUMODE_CLICKABLE = 0,
    CUMODE_CLICKABLE_AND_CAMERA  = 1,
    CUMODE_CAMERA = 2,
};

clickable_mode_initial_status  = cursor_mode.CUMODE_CLICKABLE
use_pointer_name			   = true

function default_button(hint_, device_, command_, upcommand_, arg_, arg_val_, arg_lim_)
    local arg_val = arg_val_ or 1
    local arg_lim = arg_lim_ or {0, 1}

    return {
        class                = {class_type.BTN},
        hint                 = hint_,
        device               = device_,
        action               = {command_},
        stop_action          = {upcommand_},
        arg                  = {arg_},
        arg_value            = {arg_val},
        arg_lim              = {arg_lim},
        use_release_message  = {true}
    }
end

function default_button2(hint_,device_,command_,upcommand_,arg_,arg_val_,arg_lim_)

	local   arg_val = arg_val_ or 1
	local   arg_lim = arg_lim_ or {-1,1}

	return  {
				class 				= {class_type.BTN,class_type.BTN},
				hint  				= hint_,
				device 				= device_,
				action 				= {command_,command_},
				stop_action 		= {upcommand_,upcommand_},
				arg 				= {arg_},
				arg_value			= {arg_val,-arg_val},
				arg_lim 			= {arg_lim},
				use_release_message = {true}
			}
end

function default_1_position_tumb(hint_, device_, command_, arg_, arg_val_, arg_lim_)
	local   arg_val = arg_val_ or 1
	local   arg_lim = arg_lim_ or {0,1}
	return  {
				class 		= {class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {arg_val},
				arg_lim   	= {arg_lim},
				updatable 	= true,
				use_OBB 	= true
			}
end

function default_2_position_tumb(hint_, device_, command_, arg_,arg_val_,arg_lim_)
	local _arg_val
	local _arg_lim
	if arg_val_ == nil then
		_arg_val = {1,-1}
	else
		_arg_val = arg_val_
	end
	if arg_lim_ == nil then
		_arg_lim = {{0,1},{0,1}}
	else
		_arg_lim = arg_lim_
	end
	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= _arg_val,
				arg_lim   	= _arg_lim,
				updatable 	= true,
				use_OBB 	= true
			}
end

function default_3_position_tumb(hint_,device_,command_,arg_,cycled_,inversed_)
	local cycled = true


	local val =  1
	if inversed_ then
	      val = -1
	end
	if cycled_ ~= nil then
	   cycled = cycled_
	end
	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {val,-val},
				arg_lim   	= {{-1,1},{-1,1}},
				updatable 	= true,
				use_OBB 	= true,
				cycle       = cycled
			}
end

function default_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)

	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false

	return  {
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {{0,1}},
				updatable 	= updatable,
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative},
			}
end

function default_movable_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)

	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false

	return  {
				class 		= {class_type.MOVABLE_LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {{0,1}},
				updatable 	= updatable,
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative},
			}
end

function default_axis_limited(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)

	local relative = false
	local default = default_ or 0
	local updatable = updatable_ or false
	if relative_ ~= nil then
		relative = relative_
	end

	local gain = gain_ or 0.1
	return  {
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {arg_lim_},
				updatable 	= updatable,
				use_OBB 	= false,
				gain		= {gain},
				relative    = {relative},
				cycle       = false
			}
end


function multiposition_switch(hint_,device_,command_,arg_,count_,delta_,inversed_, min_)
    local min   = min_ or 0
	local delta = delta_ or 0.5

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta * inversed,delta * inversed},
				arg_lim   	= {{min, min + delta * (count_ -1)},
							   {min, min + delta * (count_ -1)}},
				updatable 	= true,
				use_OBB 	= true
			}
end

function multiposition_switch_limited(hint_,device_,command_,arg_,count_,delta_,inversed_,min_)
    local min   = min_ or 0
	local delta = delta_ or 0.5

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta * inversed,delta * inversed},
				arg_lim   	= {{min, min + delta * (count_ -1)},
							   {min, min + delta * (count_ -1)}},
				updatable 	= true,
				use_OBB 	= true,
				cycle     	= false,
	}
end

function default_button_axis(hint_, device_,command_1, command_2, arg_1, arg_2, limit_1, limit_2)
	local limit_1_   = limit_1 or 1.0
	local limit_2_   = limit_2 or 1.0
	return {
			class		=	{class_type.BTN, class_type.LEV},
			hint		=	hint_,
			device		=	device_,
			action		=	{command_1, command_2},
			stop_action =   {command_1, 0},
			arg			=	{arg_1, arg_2},
			arg_value	= 	{1, 0.5},
			arg_lim		= 	{{0, limit_1_}, {0,limit_2_}},
			animated        = {false,true},
			animation_speed = {0, 0.4},
			gain = {0, 0.1},
			relative	= 	{false, false},
			updatable 	= 	true,
			use_OBB 	= 	true,
			use_release_message = {true, false}
	}
end

function default_animated_lever(hint_, device_, command_, arg_, animation_speed_,arg_lim_)
	local arg_lim = arg_lim_ or {0.0,1.0}
	return  {
		class  = {class_type.TUMB, class_type.TUMB},
		hint   	= hint_,
		device 	= device_,
		action 	= {command_, command_},
		arg 		= {arg_, arg_},
		arg_value 	= {1, 0},
		arg_lim 	= {arg_lim, arg_lim},
		updatable  = true,
		gain 		= {0.1, 0.1},
		animated 	= {true, true},
		animation_speed = {animation_speed_, 0},
		cycle = true
	}
end

function default_button_tumb(hint_, device_, command1_, command2_, arg_)
	return  {
				class 		= {class_type.BTN,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_,command2_},
				stop_action = {command1_,0},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-1,1},
				arg_lim   	= {{-1,0},{0,1}},
				updatable 	= true,
				use_OBB 	= true,
				use_release_message = {true,false}
	}
end

elements = {}

--SWITCHOFF elements["POINTER"] = default_2_position_tumb(LOCALIZE("Test Command"),devices.TEST, device_commands.Button_1,444) -- 44 arg number
-- 起降面板
elements["PNT_000"] = default_2_position_tumb(_("Landing Gear Handle"), devices.GEAR_SYSTEM, click_cmd.GearLevel, 0)
-- 加油面板
elements["PNT_001"] = default_2_position_tumb(_("Dump Left Fuel"), devices.FUEL, click_cmd.drain_oil_L, 1)
elements["PNT_002"] = default_2_position_tumb(_("Dump Right Fuel"), devices.FUEL, click_cmd.drain_oil_R, 2)
elements["PNT_003"] = default_3_position_tumb(_("Taxi/Landing Light"), devices.LIGHT, click_cmd.taxi_light, 3)
elements["PNT_004"] = default_3_position_tumb(_("Extend tank pump"), devices.FUEL, click_cmd.ext_tank_pump, 4)
elements["PNT_005"] = default_2_position_tumb(_("Air Refuel"), devices.FUEL, click_cmd.air_refuel, 5)
elements["PNT_006"]	= default_2_position_tumb(_("Launch Bar Control Switch, EXTEND/RETRACT"),	devices.GEAR_SYSTEM, click_cmd.LaunchBarSw, 6)
-- 电力系统
elements["PNT_010"] = default_2_position_tumb(_("Battry Switch"), devices.ELECTRIC_SYSTEM, click_cmd.Battery, 10)
elements["PNT_011"] = default_2_position_tumb(_("Left Generator Switch"), devices.ELECTRIC_SYSTEM, click_cmd.LeftAcGenerator, 11)
elements["PNT_012"] = default_2_position_tumb(_("Right Generator Switch"), devices.ELECTRIC_SYSTEM, click_cmd.RightAcGenerator, 12)
elements["PNT_013"] = default_2_position_tumb(_("Ground Power Switch"), devices.ELECTRIC_SYSTEM, click_cmd.GndPower, 13)

-- 启动器
elements["PNT_014"] = multiposition_switch(_("Starter Selector"), devices.ENGINE, click_cmd.StartorSwitch, 14,4,0.25)
elements["PNT_015"] = default_button(_('Start Engine'),devices.ENGINE,click_cmd.EngineStart_DN,click_cmd.EngineStart_UP,15)

--油门开关(OFF->Idle)
-- 启动器
elements["PNT_030"] = default_2_position_tumb(_("Left Throttle OFF/Idle"), devices.ENGINE, click_cmd.LeftThrottorIdle,30)
elements["PNT_031"] = default_2_position_tumb(_('Right Throttle OFF/Idle'),devices.ENGINE,click_cmd.RightThrottorIdle,31)

--平显头显面板
elements["PNT_070"] = default_3_position_tumb(_("HMD Power"), devices.HELMET, click_cmd.hmdPower, 70)
elements["PNT_071"] = default_axis_limited(_("HUD颜色"),devices.HUD_DCMS,click_cmd.hudColor,71,0,0.1,true,false,{0,1})
elements["PNT_072"] = default_axis_limited(_("HMD Brightness"),devices.HELMET,click_cmd.hmdBrt,72,0,0.1,true,false,{0,1})

--昼夜、惯导、亮度、防拥
elements["PNT_073"] = default_3_position_tumb(_("HUD,MFCD Day/Night Mode"), devices.MFCD, click_cmd.HudMFCD_change_dayNight, 73)
--elements["PNT_073"] = default_2_position_tumb(_("HUD,HMD,MFCD Day/Night Mode"), devices.MFCD, click_cmd.HudMFCD_change_dayNight, 73,{2,-2},{{-1,1},{-1,1}})
--elements["PNT_074"] = default_axis_limited(_("惯导"),devices.XXX,click_cmd.XXX,74,0,0.1,true,false,{0,1})
elements["PNT_075"] = default_axis_limited(_("MFCD亮度"), devices.MFCD,RightPanel_click_cmd.MFCDBrt,75,0,0.1,true,false,{0,1})
--elements["PNT_076"] = default_3_position_tumb(_("防拥"), devices.xxx, click_cmd.xxx, 76)

--键盘A-Z
for i = string.byte('A'), string.byte('Z'), 1 do
	elements[string.format('PNT_%03.0f',i+16)] = default_button(_('Keyboard')..string.char(i),devices.UFCP,Keybord_click_cmd.key_A+i-65,Keybord_click_cmd.key_A+i-65,i+16)
end
elements['PNT_107'] = default_button(_('Keyboard Space'),devices.UFCP,Keybord_click_cmd.key_SP,Keybord_click_cmd.key_SP,107)
elements['PNT_108'] = default_button(_('Keyboard +/-'),devices.UFCP,Keybord_click_cmd['key_+/-'],Keybord_click_cmd['key_+/-'],108)

--音量面板
elements['PNT_110'] = default_axis_limited(_('UHF Volume'),devices.UFCP,click_cmd.UHF_Volume,110,0,0.1,true,false,{0,1})
elements["PNT_111"] = default_2_position_tumb(_("Inner/Outer Commicat"), nil, click_cmd.VOIP, 111)
elements["PNT_112"] = default_2_position_tumb(_("Antanna Position"), nil, click_cmd.antenna, 112)
elements['PNT_114'] = default_axis_limited(_('VHF Volume'),devices.UFCP,click_cmd.VHF_Volume,114,0,0.1,true,false,{0,1})
elements['PNT_115'] = default_axis_limited(_('Tacan Volume'),nil,click_cmd.TCN_Volume,115,0,0.1,true,false,{0,1})
elements['PNT_116'] = default_axis_limited(_('RWR Volume'),devices.RWR,click_cmd.RWR_Volume,116,0,0.1,true,false,{0,1})

--机内灯光
elements['PNT_130'] = default_axis_limited(_('Flood Lights'),devices.LIGHT,click_cmd.flood_light,130,0,0.1,true,false,{0,1})
elements['PNT_132'] = default_axis_limited(_('Backgrond Lights'),devices.LIGHT,click_cmd.background_light,132,0,0.1,true,false,{0,1})

--机外灯光
elements["PNT_133"] = default_2_position_tumb(_('Navigation Lights'), devices.LIGHT, click_cmd.strobe_light, 133)
elements['PNT_134'] = default_axis_limited(_('Formation Lights'),devices.LIGHT,click_cmd.formation_light,134,0,0.1,true,false,{0,1})
elements['PNT_135'] = default_axis_limited(_('Refuel Lights'),devices.LIGHT,click_cmd.refuel_light,135,0,0.1,true,false,{0,1})
elements["PNT_136"] = default_2_position_tumb(_('Wingtip Lights'), devices.LIGHT, click_cmd.wingtip_light, 136)
elements["PNT_137"] = default_2_position_tumb(_('Anti-collision Lights'), devices.LIGHT, click_cmd.antiCollision_light, 137)

elements['PNT_140'] = default_button(_('Left Extinguishing'),devices.Engine,click_cmd.LeftExtinguishing,click_cmd.LeftExtinguishing,140)
elements['PNT_141'] = default_button(_('Right Extinguishing'),devices.Engine,click_cmd.RightExtinguishing,click_cmd.RightExtinguishing,141)
elements["PNT_144"] = default_2_position_tumb(_('Master Arm'), devices.WEAPON_SYSTEM, click_cmd.masterArm, 144)
--
--MFD点击
--elements['EADI_AUTO'] = default_button(_('EADI auto'))
elements['EADI_SETUP'] = default_button(_('Global Settings'),devices.MFCD,MFD_click_cmd.EADI_SETUP,MFD_click_cmd.EADI_SETUP)
elements['EADI_ILS'] = default_button(_('ILS Show/Hide'),devices.MFCD,MFD_click_cmd.EADI_ILS,MFD_click_cmd.EADI_ILS)

elements['FCS_OVER'] = default_button(_('FCS Over'),devices.FCS,MFD_click_cmd.FCS_OVER,MFD_click_cmd.FCS_OVER)
elements['FCS_SETUP'] = default_button(_('FCS Bit'),devices.FCS,MFD_click_cmd.FCS_BIT,MFD_click_cmd.FCS_BIT)
elements['HSI_SCALE_UP'] = default_button(_('Scale Up'),devices.HSI,MFD_click_cmd.HSI_SCALE_UP,MFD_click_cmd.HSI_SCALE_UP)
elements['HSI_SCALE_DN'] = default_button(_('Scale Down'),devices.HSI,MFD_click_cmd.HSI_SCALE_DN,MFD_click_cmd.HSI_SCALE_DN)
elements['HSI_MAP'] = default_button(_('Map'),devices.HSI,MFD_click_cmd.HSI_MAP,MFD_click_cmd.HSI_MAP)
elements['HSI_NAV'] = default_button(_('Nav'),devices.HSI,MFD_click_cmd.HSI_NAV,MFD_click_cmd.HSI_NAV)
elements['HSI_HDG_MODE'] = default_button(_('EHSI HDG Mode'),devices.HSI,MFD_click_cmd.HSI_HDG_MODE,MFD_click_cmd.HSI_HDG_MODE)
elements['HSI_MENU'] = default_button(_('EHSI Menu'),devices.HSI,MFD_click_cmd.HSI_MENU,MFD_click_cmd.HSI_MENU)
elements['HSI_WPT'] = default_button(_('EHSI WPT'),devices.HSI,MFD_click_cmd.HSI_WPT,MFD_click_cmd.HSI_WPT)
--elements['HSI_FY'] = default_button(_('EHSI FY'),devices.HSI,MFD_click_cmd.HSI_FY,MFD_click_cmd.HSI_FY)
elements['BP5_L1'] = default_button(_('L1'),devices.NAV,MFD_click_cmd.BP5_L1,MFD_click_cmd.BP5_L1)
elements['BP5_L2'] = default_button(_('L2'),devices.NAV,MFD_click_cmd.BP5_L2,MFD_click_cmd.BP5_L2)
elements['BP5_R1'] = default_button(_('R1'),devices.NAV,MFD_click_cmd.BP5_R1,MFD_click_cmd.BP5_R1)
elements['BP5_R2'] = default_button(_('R2'),devices.NAV,MFD_click_cmd.BP5_R2,MFD_click_cmd.BP5_R2)
elements['BP5_NEXT'] = default_button(_('Next'),devices.NAV,MFD_click_cmd.BP5_NEXT,MFD_click_cmd.BP5_NEXT)
elements['BP5_LAST'] = default_button(_('Last'),devices.NAV,MFD_click_cmd.BP5_LAST,MFD_click_cmd.BP5_LAST)
elements['ENG_SW'] = default_button(_('Switch Info'),devices.MFCD,MFD_click_cmd.ENG_SW,MFD_click_cmd.ENG_SW)


elements['WPN_AAMODE'] = default_button(_('Air To Air Mode'),devices.WEAPON_SYSTEM,MFD_click_cmd.WPN_AAMODE,nil)
elements['WPN_AGMODE'] = default_button(_('Air To Ground Mode'),devices.WEAPON_SYSTEM,MFD_click_cmd.WPN_AGMODE,nil)
elements['WPN_DOOR_ON'] = default_button(_('Bomb Bay Door Open'),devices.WEAPON_SYSTEM,MFD_click_cmd.WPN_DOOR_ON,nil)
elements['WPN_DOOR_AUTO'] = default_button(_('Bomb Bay Door Auto'),devices.WEAPON_SYSTEM,MFD_click_cmd.WPN_DOOR_AUTO,nil)
--UFCP
elements['PNT_150'] = default_button(_('UFCP key 0'),devices.UFCP,UFCP_click_cmd.key0_dn,UFCP_click_cmd.key0_up,150)
elements['PNT_151'] = default_button(_('UFCP key 1'),devices.UFCP,UFCP_click_cmd.key1_dn,UFCP_click_cmd.key1_up,151)
elements['PNT_152'] = default_button(_('UFCP key 2'),devices.UFCP,UFCP_click_cmd.key2_dn,UFCP_click_cmd.key2_up,152)
elements['PNT_153'] = default_button(_('UFCP key 3'),devices.UFCP,UFCP_click_cmd.key3_dn,UFCP_click_cmd.key3_up,153)
elements['PNT_154'] = default_button(_('UFCP key 4'),devices.UFCP,UFCP_click_cmd.key4_dn,UFCP_click_cmd.key4_up,154)
elements['PNT_155'] = default_button(_('UFCP key 5'),devices.UFCP,UFCP_click_cmd.key5_dn,UFCP_click_cmd.key5_up,155)
elements['PNT_156'] = default_button(_('UFCP key 6'),devices.UFCP,UFCP_click_cmd.key6_dn,UFCP_click_cmd.key6_up,156)
elements['PNT_157'] = default_button(_('UFCP key 7'),devices.UFCP,UFCP_click_cmd.key7_dn,UFCP_click_cmd.key7_up,157)
elements['PNT_158'] = default_button(_('UFCP key 8'),devices.UFCP,UFCP_click_cmd.key8_dn,UFCP_click_cmd.key8_up,158)
elements['PNT_159'] = default_button(_('UFCP key 9'),devices.UFCP,UFCP_click_cmd.key9_dn,UFCP_click_cmd.key9_up,159)
elements['PNT_160'] = default_button(_('UFCP key Enter'),devices.UFCP,UFCP_click_cmd.Enter_dn,UFCP_click_cmd.Enter_up,160)
elements['PNT_161'] = default_button(_('UFCP key Clear'),devices.UFCP,UFCP_click_cmd.Clear_dn,UFCP_click_cmd.Clear_up,161)
elements['PNT_162'] = default_button(_('UFCP L1'),devices.UFCP,UFCP_click_cmd.L1_dn,UFCP_click_cmd.L1_up,162)
elements['PNT_163'] = default_button(_('UFCP L2'),devices.UFCP,UFCP_click_cmd.L2_dn,UFCP_click_cmd.L2_up,163)
elements['PNT_164'] = default_button(_('UFCP L3'),devices.UFCP,UFCP_click_cmd.L3_dn,UFCP_click_cmd.L3_up,164)
elements['PNT_165'] = default_button(_('UFCP L4'),devices.UFCP,UFCP_click_cmd.L4_dn,UFCP_click_cmd.L4_up,165)
elements['PNT_166'] = default_button(_('UFCP R1'),devices.UFCP,UFCP_click_cmd.R1_dn,UFCP_click_cmd.R1_up,166)
elements['PNT_167'] = default_button(_('UFCP R2'),devices.UFCP,UFCP_click_cmd.R2_dn,UFCP_click_cmd.R2_up,167)
elements['PNT_168'] = default_button(_('UFCP R3'),devices.UFCP,UFCP_click_cmd.R3_dn,UFCP_click_cmd.R3_up,168)
elements['PNT_169'] = default_button(_('UFCP R4'),devices.UFCP,UFCP_click_cmd.R4_dn,UFCP_click_cmd.R4_up,169)
elements['PNT_170'] = default_button(_('UFCP Commicat'),devices.UFCP,UFCP_click_cmd.comm_dn,UFCP_click_cmd.comm_up,170)
elements['PNT_171'] = default_button(_('UFCP Nav'),devices.UFCP,UFCP_click_cmd.Nav_dn,UFCP_click_cmd.Nav_up,171)
elements['PNT_172'] = default_button(_('UFCP Combat'),devices.UFCP,UFCP_click_cmd.combat_dn,UFCP_click_cmd.combat_up,172)
elements['PNT_173'] = default_button(_('UFCP AP'),devices.UFCP,UFCP_click_cmd.AP_dn,UFCP_click_cmd.AP_up,173)
elements['PNT_174'] = default_button2(_('UFCP Page Down/Up'),devices.UFCP,UFCP_click_cmd.boat_dn,UFCP_click_cmd.boat_up,174)
elements['PNT_175'] = default_axis_limited(_('UFCP Brightness'),devices.UFCP,click_cmd.UFCPBrt,175,0,0.1,true,false,{0,1})
elements['PNT_176'] = default_axis_limited(_('HUD Brightness'),devices.HUD_DCMS,click_cmd.hudBrt,176,0,0.1,true,false,{0,1})
--centerBottom mfcd
elements['PNT_180'] = default_button(_('OSB 01'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN1,MFCD_click_cmd.BTN1,180)
elements['PNT_181'] = default_button(_('OSB 02'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN2,MFCD_click_cmd.BTN2,181)
elements['PNT_182'] = default_button(_('OSB 03'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN3,MFCD_click_cmd.BTN3,182)
elements['PNT_183'] = default_button(_('OSB 04'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN4,MFCD_click_cmd.BTN4,183)
elements['PNT_184'] = default_button(_('OSB 05'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN5,MFCD_click_cmd.BTN5,184)
elements['PNT_185'] = default_button(_('OSB 06'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN6,MFCD_click_cmd.BTN6,185)
elements['PNT_186'] = default_button(_('OSB 07'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN7,MFCD_click_cmd.BTN7,186)
elements['PNT_187'] = default_button(_('OSB 08'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN8,MFCD_click_cmd.BTN8,187)
elements['PNT_188'] = default_button(_('OSB 09'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN9,MFCD_click_cmd.BTN9,188)
elements['PNT_189'] = default_button(_('OSB 10'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN10,MFCD_click_cmd.BTN10,189)
elements['PNT_190'] = default_button(_('OSB 11'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN11,MFCD_click_cmd.BTN11,190)
elements['PNT_191'] = default_button(_('OSB 12'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN12,MFCD_click_cmd.BTN12,191)
elements['PNT_192'] = default_button(_('OSB 13'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN13,MFCD_click_cmd.BTN13,192)
elements['PNT_193'] = default_button(_('OSB 14'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN14,MFCD_click_cmd.BTN14,193)
elements['PNT_194'] = default_button(_('OSB 15'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN15,MFCD_click_cmd.BTN15,194)
elements['PNT_195'] = default_button(_('OSB 16'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN16,MFCD_click_cmd.BTN16,195)
elements['PNT_196'] = default_button(_('OSB 17'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN17,MFCD_click_cmd.BTN17,196)
elements['PNT_197'] = default_button(_('OSB 18'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN18,MFCD_click_cmd.BTN18,197)
elements['PNT_198'] = default_button(_('OSB 19'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN19,MFCD_click_cmd.BTN19,198)
elements['PNT_199'] = default_button(_('OSB 20'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN20,MFCD_click_cmd.BTN20,199)
elements['PNT_200'] = default_button(_('OSB 21'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN21,MFCD_click_cmd.BTN21,200)
elements['PNT_201'] = default_button(_('OSB 22'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN22,MFCD_click_cmd.BTN22,201)
elements['PNT_202'] = default_button(_('OSB 23'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN23,MFCD_click_cmd.BTN23,202)
elements['PNT_203'] = default_button(_('OSB 24'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN24,MFCD_click_cmd.BTN24,203)
elements['PNT_204'] = default_button(_('OSB 25'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN25,MFCD_click_cmd.BTN25,204)
elements['PNT_205'] = default_button(_('OSB 26'),devices.MFCD_BACKUP,MFCD_click_cmd.BTN26,MFCD_click_cmd.BTN26,205)
for i,o in pairs(elements) do
	if  o.class[1] == class_type.TUMB or
	   (o.class[2]  and o.class[2] == class_type.TUMB) or
	   (o.class[3]  and o.class[3] == class_type.TUMB)  then
	   o.updatable = true
	   o.use_OBB   = true
	end
end