-- 定义自定义命令的起始值
start_custom_command   = 10000
local __count_custom = start_custom_command-1
local function __custom_counter()
	__count_custom = __count_custom + 1
	return __count_custom
end
--轴命令
JoyCmd = {
	PlanePitch					= 2001, -- 俯仰
	PlaneRoll					= 2002, -- 滚转
	PlaneRudder					= 2003, -- 偏航
	ThrustCommon				= 2004, -- 推力
	PlaneThrustLeft 			= 2005,
	PlaneThrustRight 			= 2006,
	PlaneRadarHorizontal 	   	= 2025,
	PlaneRadarVertical			= 2026,
	PlaneRadarHorizontalAbs		= 2027,
	PlaneRadarVerticalAbs		= 2028,
	PlaneMFDZoom				= 2029,
	PlaneMFDZoomAbs				= 2030,
	PlaneSelecterHorizontal		= 2031,
	PlaneSelecterVertical		= 2032,
	PlaneSelecterHorizontalAbs	= 2033,
	PlaneSelecterVerticalAbs	= 2034,
	PlaneBase_Distance			= 2040,
	PlaneBase_DistanceAbs		= 2041,
	---下面开始自定义轴，从12101开始
	Flood_Light_Axis			= 12101,
	Background_Light_Axis		= 12102,
	HUD_BRT_Axis				= 12103,
	MFCD_BRT_Axis				= 12104,

}
-- 定义按键映射表，包含飞机的各种功能键
Keys =
{
	PlaneSAUAutomatic = 58,				-- 角度稳定
	PlaneSAUHBarometric = 59,			-- 绝对高度稳定
	PlaneSAUHRadio = 60,				-- 地形跟随飞行
	PlaneSAUHorizon = 61,				-- 水平稳定
	PlaneAutopilot = 62,				-- 自动驾驶仪
	PlaneAUTOnOff = 63,					-- 自动驾驶模式切换
	PlaneAUTIncrease = 64,				-- 增加设定速度
	PlaneAUTDecrease = 65,				-- 减少设定速度
	PlaneGear = 68,						-- 起落架
	PlaneHook = 69,						-- 挂钩
	PlanePackWing = 70,					-- 折叠机翼
	PlaneFonar = 71,					-- 座舱盖
	PlaneFlaps = 72,					-- 襟翼
	PlaneAirBrake = 73,					-- 空气制动器
	PlaneWheelBrakeOn = 74,				-- 车轮刹车开启
	PlaneWheelBrakeOff = 75,			-- 车轮刹车关闭
	PlaneParachute = 76,				-- 降落伞
	PlaneDropSnar = 77,					-- 投放诱饵
	PlaneWingtipSmokeOnOff = 78,		-- 翼尖烟雾开/关
	PlaneFuelOn = 79,					-- 开启燃油排放或加油
	PlaneFuelOff = 80,					-- 关闭燃油排放或加油
	PlaneSalvoOnOff = 81,				-- 齐射模式开/关
	PlaneJettisonWeapons = 82,			-- 成对投放武器
	PlaneEject = 83,					-- 弹射
	PlaneFire = 84,						-- 开火
	PlaneFireOff = 85,					-- 停止开火
	PlaneRadarOnOff = 86,				-- 雷达开/关
	PlaneEOSOnOff = 87,					-- 光电系统开/关
	PlaneRadarLeft = 88,				-- 雷达天线左转
	PlaneRadarRight = 89,				-- 雷达天线右转
	PlaneRadarUp = 90,					-- 雷达天线上转
	PlaneRadarDown = 91,				-- 雷达天线下转
	PlaneRadarCenter = 92,				-- 雷达天线居中
	PlaneTrimLeft = 93,					-- 修正向左
	PlaneTrimRight = 94,				-- 修正向右
	PlaneTrimUp = 95,					-- 修正向上
	PlaneTrimDown = 96,					-- 修正向下
	PlaneTrimCancel = 97,				-- 修正复位
	PlaneTrimLeftRudder = 98,			-- 左舵修正
	PlaneTrimRightRudder = 99,			-- 右舵修正
	PlaneChangeLock = 100,				-- 模式切换/目标锁定
	PlaneChangeWeapon = 101,			-- 模式切换/武器切换
	PlaneChangeTarget = 102,			-- 目标切换
	PlaneZoomIn = 103,					-- MFD缩放+
	PlaneZoomOut = 104,					-- MFD缩放-
	PlaneModeNAV = 105,					-- 切换到导航模式
	PlaneModeBVR = 106,					-- 切换到远程空战模式
	PlaneModeVS = 107,					-- 切换到近战模式（条形）
	PlaneModeBore = 108,				-- 切换到近战模式（圆形）
	PlaneModeHelmet = 109,				-- 切换到近战模式（头盔）
	PlaneModeFI0 = 110,					-- 切换到FI0模式
	PlaneModeGround = 111,				-- 切换到对地攻击模式
	PlaneModeGrid = 112,				-- 切换到“网格”模式
	PlaneModeCannon = 113,				-- 开启/关闭机炮
	PlaneDoAndHome = 114,				-- 执行任务并返回基地
	PlaneDoAndBack = 115,				-- 执行任务并返回我方
	PlaneFormation = 116,				-- 散开/紧密编队
	PlaneJoinUp = 117,					-- 集合
	PlaneAttackMyTarget = 118,			-- 攻击我的目标
	PlaneCoverMySix = 119,				-- 掩护我后方
	PlaneShipTakeOff = 120,				-- 航母起飞
	PlaneCobra = 121,					-- 眼镜蛇机动

	ActiveJamming = 136,
	LandDetailsIncrease = 137,			-- 调试增加细节（非模拟动作）
	LandDetailsDecrease = 138,			-- 调试减少细节（非模拟动作）
	SelecterLeft = 139,				    -- HUD目标捕获标记左移
	SelecterRight = 140,				-- HUD目标捕获标记右移
	SelecterUp  =141,					-- HUD目标捕获标记上移
	SelecterDown = 142,					-- HUD目标捕获标记下移
	RefusalTWS = 143,					-- 放弃TWS
	PlaneResetMasterWarning = 144,
	PlaneFlapsOn = 145,
	PlaneFlapsOff = 146,
	PlaneAirBrakeOn = 147,
	PlaneAirBrakeOff = 148,
	PlaneAirRefuel = 155,					-- 空中加油杆位置切换
	BrightnessILS = 156,					-- ILS亮度
	PlaneAUTIncreaseLeft = 161,
	PlaneAUTDecreaseLeft = 162,
	PlaneAUTIncreaseRight = 163,
	PlaneAUTDecreaseRight = 164,
	PlaneLightsOnOff = 175,				-- 开/关飞机灯光
	PlaneDropSnarOnce = 176,			-- 单次投放诱饵
	PlaneJettisonFuelTanks = 178,		-- 投放燃油箱
	PlaneWingmenCommand = 179,			-- 呼叫僚机指令面板
	PlaneDown = 186,					-- 自动驾驶仪高度微调
	PlaneUp = 187,
	PlaneLeft = 188,
	PlaneRight = 189,
    PlaneUpStart = 193,
    PlaneUpStop = 194,
    PlaneDownStart = 195,
    PlaneDownStop = 196,
    PlaneLeftStart = 197,
    PlaneLeftStop = 198,
    PlaneRightStart = 199,
    PlaneRightStop = 200,
    PlaneLeftRudderStart = 201,
    PlaneLeftRudderStop = 202,
    PlaneRightRudderStart = 203,
    PlaneRightRudderStop = 204,
    PlaneTrimStop = 215,
    SelecterUpRight = 226,
    SelecterDownRight = 227,
    SelecterDownLeft = 228,
    SelecterUpLeft = 229,
    SelecterStop = 230,
    PlaneRadarUpRight = 231,
    PlaneRadarDownRight = 232,
    PlaneRadarDownLeft = 233,
    PlaneRadarUpLeft = 234,
    PlaneRadarStop = 235,
	PlaneHUDFilterOnOff = 247,				-- HUD滤光片升降（Ka-50）
	PlaneMasterCaution = 252,				-- 类似“屏幕呼叫”（MiG-29），按钮灯CSO（Ka-50）
	PlaneScalesReject	= 253,				-- Scales reject / HUD显示限制（Ka-50）
	PlaneBettyRepeat = 254,					-- 重复Betty消息（Rf-50）
	ThreatMissilePadlock = 258,
	AllMissilePadlock = 259,
	DecreaseRadarScanArea = 262,
    IncreaseRadarScanArea = 263,
	AWACSHomeBearing = 267,
	AWACSTankerBearing = 268,
	AWACSBanditBearing = 269,
    AWACSDeclare = 270,
    EasyRadarOnOff = 271,
    AutoLockOnNearestAircraft = 272,
    AutoLockOnCenterAircraft = 273,
    AutoLockOnNextAircraft = 274,
    AutoLockOnPreviousAircraft = 275,
    AutoLockOnNearestSurfaceTarget = 276,
    AutoLockOnCenterSurfaceTarget = 277,
    AutoLockOnNextSurfaceTarget = 278,
    AutoLockOnPreviousSurfaceTarget = 279,
	ChangeGunRateOfFire = 280,
	ChangeRippleQuantity = 281,
	ChangeRippleInterval = 282,
	SwitchMasterArm = 283,
	ChangeReleaseMode = 284,
    PlaneRadarChangeMode = 285,
	ChangeRWRMode = 286,
	FlightClockReset = 288,
	PlaneCockpitIllumination = 300,
	ChangeRippleIntervalDown = 308,			-- A10齐射炸弹间隔反向调整
	PlaneEnginesStart = 309,				-- 发动机启动
	PlaneEnginesStop = 310,					-- 发动机关闭

	PlaneLeftEngineStart = 311,				-- 左发动机启动
	PlaneRightEngineStart = 312,			-- 右发动机启动

	PlaneLeftEngineStop = 313,				-- 左发动机关闭
	PlaneRightEngineStop = 314,				-- 右发动机关闭

	PowerOnOff = 315,						-- 电源开/关

	AltimeterPressureIncrease = 316,		-- 增加高度表压力
	AltimeterPressureDecrease = 317,		-- 减少高度表压力
	AltimeterPressureStop = 318,

	PlaneHeadLightOnOff = 328,				-- 前起落架灯开/关

	PlaneLockPadlock = 329,					-- 锁定最近目标
	PlaneUnlockPadlock = 330,				-- 解除目标锁定

	PlaneLaunchPermissionOverride = 349,	-- 武器解锁
	PlanePickleOn = 350,					-- 西方飞机导弹发射/炸弹投放
	PlanePickleOff = 351,
	PlaneDropFlareOnce = 357,				-- 单次投放红外诱饵
	PlaneDropChaffOnce = 358,				-- 单次投放箔条诱饵

	-- CMD
	PlaneCMDDispence = 364,					-- 被动电子战系统投放诱饵
	PlaneCMDDispenceOff = 365,
	PlaneCMDDispenceStop = 366,				-- 被动电子战系统停止投放诱饵
	PlaneCMDDispenceStopOff = 367,
	PlaneCMDChangeRippleQuantity = 368,		-- 被动电子战系统改变齐射数量
	PlaneCMDChangeRippleQuantityOff = 369,
	PlaneCMDChangeRippleInterval = 370,		-- 被动电子战系统改变齐射间隔
	PlaneCMDChangeRippleIntervalOff = 371,
	PlaneCMDChangeBurstAmount = 372,		-- 被动电子战系统改变齐射次数
	PlaneCMDChangeBurstAmountOff = 373,
	PlaneCMDCancelCurrentProgram = 374,		-- 被动电子战系统取消当前程序
	PlaneCMDCancelCurrentProgramOff = 375,
	PlaneCMDChangeBoard = 376,				-- 被动电子战系统选择舱板
	PlaneCMDShowAmountOrProgram = 377,		-- 被动电子战系统切换显示 - 诱饵数量或当前程序

	PlaneCancelWeaponsDelivery = 378,		-- 航电工作模式复位（Ka-50）
	PlaneMasterCautionOff = 379,
	PlaneStabTangBank = 386,				-- 俯仰和滚转稳定
	PlaneStabHbarBank = 387,				-- Hbar和滚转稳定
	PlaneStabHorizon = 388,					-- 俯仰和滚转稳定
	PlaneStabHbar = 389,					-- Hbar稳定
	PlaneStabHrad = 390,					-- Hrad稳定
	ActiveIRJamming = 391,					-- 红外干扰开/关
	PlaneLaserRangerOnOff = 392, 			-- 激光测距仪开/关
	PlaneNightTVOnOff = 393,         		-- 夜视电视系统开/关（红外或低光电视）
	PlaneChangeRadarPRF = 394,       		-- 改变雷达脉冲重复频率
	PlaneStabCancel = 408,					-- 取消所有稳定和自动驾驶模式
	PlaneThreatWarnSoundVolumeDown = 409,	-- 减小RWR声音警告音量
	PlaneThreatWarnSoundVolumeUp = 410,		-- 增大RWR声音警告音量
	ViewLaserOnOff = 411,
	PlaneIncreaseBase_Distance = 412,     	-- 增加目标基距
	PlaneDecreaseBase_Distance = 413,     	-- 减少目标基距
	PlaneStopBase_Distance = 414,
	PlaneAutopilotOverrideOn =427,
	PlaneAutopilotOverrideOff = 428,
	PlaneRouteAutopilot = 429,
	PlaneGearUp = 430,
	PlaneGearDown = 431,
	ViewNightVisionGogglesOn = 438,
	PlaneDesignate_CageOn = 439,
	PlaneDesignate_CageOff = 440,
	PlaneDesignate_CageOn_vertical = 441,
	PlaneDesignate_CageOn_horizontal = 442,

	--Data Link Panel PRTs (数据链目标指示面板)
	PlaneDLK_Target1 	= 443,
	PlaneDLK_Target2 	= 444,
	PlaneDLK_Target3 	= 445,
	PlaneDLK_RefPoint 	= 446,
	PlaneDLK_Wingman1 	= 447,
	PlaneDLK_Wingman2 	= 448,
	PlaneDLK_Wingman3 	= 449,
	PlaneDLK_Wingman4 	= 450,
	PlaneDLK_All 		= 451,
	PlaneDLK_Erase 		= 452,
	PlaneDLK_Ingress 	= 453,
	PlaneDLK_SendMemory = 454,

	-- NAV panel controls (导航面板控制 - Ka-50)
	PlaneNavChangePanelModeRight = 455,
	PlaneNavChangePanelModeLeft = 456,
	PlaneNavSetFixtakingMode 	= 457,
	PlaneNav_DLK_OnOff 			= 458,
	PlaneNav_PB1 				= 459,
	PlaneNav_PB2 				= 460,
	PlaneNav_PB3 				= 461,
	PlaneNav_PB4 				= 462,
	PlaneNav_PB5 				= 463,
	PlaneNav_PB6 				= 464,
	PlaneNav_PB7 				= 465,
	PlaneNav_PB8 				= 466,
	PlaneNav_PB9 				= 467,
	PlaneNav_PB0 				= 468,
	PlaneNav_Steerpoints 		= 469,
	PlaneNav_INU_realign 		= 470,
	PlaneNav_POS_corrMode 		= 471,
	PlaneNav_INU_precise_align 	= 472,
	PlaneNav_Airfields 			= 473,
	PlaneNav_INU_normal_align  	= 474,
	PlaneNav_Targets 			= 475,
	PlaneNav_Enter 				= 476,
	PlaneNav_Cancel 			= 477,
	PlaneNav_POS_init 			= 478,
	PlaneNav_SelfCoord 			= 479,
	PlaneNav_CourseTimeRange 	= 480,
	PlaneNav_Wind 				= 481,
	PlaneNav_THeadingTimeRangeF = 482,
	PlaneNav_BearingRangeT 		= 483,


	PlaneCockpitIlluminationPanels = 493,
	PlaneCockpitIlluminationGauges = 494,

	Plane_RouteMode 			= 506,
	Plane_DescentMode 			= 507,
	Plane_DescentModeOff 		= 508,
	Plane_LockOn_start 			= 509,
	Plane_LockOn_finish 		= 510,

	Plane_SpotLight_left  		= 511,
	Plane_SpotLight_right 		= 512,
	Plane_SpotLight_up			= 513,
	Plane_SpotLight_down 		= 514,
	Plane_SpotLight_stop 		= 515,

	PlaneRotorTipLights 		= 516,
	Plane_SpotSelect_switch 	= 517,
	PlaneAntiCollisionLights 	= 518,
	PlaneNavLights_CodeModeOn 	= 519,
	PlaneNavLights_CodeModeOff 	= 520,
	PlaneFormationLights 		= 521,

	Plane_EngageAirDefenses 	= 522,
	Plane_EngageGroundTargets 	= 523,

	Plane_AutomaticTracking_Gunsight_switch  = 524,
	Plane_AutomaticTurn 					= 526,
	Plane_GroundMovingTarget 				= 527,
	Plane_AirborneTarget 					= 528,
	Plane_HeadOnAspect 						= 529,
	Plane_ChangeDeliveryMode_right 			= 530,
	Plane_ChangeDeliveryMode_left 			= 531,

	Plane_WeaponMode_Manual_Auto 			= 532,
	Plane_WeaponMode_switch 				= 533,
	Plane_AmmoTypeSelect 					= 534,
	Plane_FireRate 							= 535,

	PlaneDropSnarOnceOff 					= 536,

	HelicopterHover 						= 537,
	AutopilotEmergOFF 						= 538,

	Plane_HOTAS_CoolieUp 					= 539,
	Plane_HOTAS_CoolieDown 					= 540,
	Plane_HOTAS_CoolieLeft 					= 541,
	Plane_HOTAS_CoolieRight 				= 542,
	Plane_HOTAS_CoolieOff 					= 543,

	Plane_HOTAS_TargetManagementSwitchUp 	= 544,
	Plane_HOTAS_TargetManagementSwitchDown 	= 545,
	Plane_HOTAS_TargetManagementSwitchLeft 	= 546,
	Plane_HOTAS_TargetManagementSwitchRight = 547,
	Plane_HOTAS_TargetManagementSwitchOff 	= 548,

	Plane_HOTAS_DataManagementSwitchUp 		= 549,
	Plane_HOTAS_DataManagementSwitchDown 	= 550,
	Plane_HOTAS_DataManagementSwitchLeft 	= 551,
	Plane_HOTAS_DataManagementSwitchRight 	= 552,
	Plane_HOTAS_DataManagementSwitchOff 	= 553,

	Plane_HOTAS_TriggerSecondStage 			= 554,
	Plane_HOTAS_TriggerFirstStage 			= 555,

	Plane_HOTAS_CMS_Up 						= 556,
	Plane_HOTAS_CMS_Down 					= 557,
	Plane_HOTAS_CMS_Left 					= 558,
	Plane_HOTAS_CMS_Right 					= 559,
	Plane_HOTAS_CMS_Off 					= 560,

	Plane_HOTAS_MasterModeControlButton 	= 561,
	Plane_HOTAS_NoseWheelSteeringButton 	= 562,
	Plane_HOTAS_NoseWheelSteeringButtonOff 	= 606,

	Plane_HOTAS_BoatSwitchForward 			= 563,
	Plane_HOTAS_BoatSwitchAft 				= 564,
	Plane_HOTAS_BoatSwitchCenter 			= 565,

	Plane_HOTAS_ChinaHatForward 			= 566,
	Plane_HOTAS_ChinaHatAft 				= 567,
	Plane_HOTAS_ChinaHatOff 				= 589,

	Plane_HOTAS_PinkySwitchForward 			= 568,
	Plane_HOTAS_PinkySwitchAft 				= 569,
	Plane_HOTAS_PinkySwitchCenter 			= 570,

	Plane_HOTAS_LeftThrottleButton 			= 571,

	Plane_HOTAS_MIC_SwitchUp 				= 572,
	Plane_HOTAS_MIC_SwitchDown  			= 573,
	Plane_HOTAS_MIC_SwitchLeft  			= 574,
	Plane_HOTAS_MIC_SwitchRight 			= 575,
	Plane_HOTAS_MIC_SwitchOff 				= 576,

	Plane_HOTAS_SpeedBrakeSwitchForward 	= 577,
	Plane_HOTAS_SpeedBrakeSwitchAft 		= 578,
	Plane_HOTAS_SpeedBrakeSwitchCenter 		= 579,

	Plane_HOTAS_MasterModeControlButtonUP 	= 633,
	Plane_HOTAS_TDC_depress_on  			= 634,
	Plane_HOTAS_TDC_depress_off 			= 635,

	Plane_HOTAS_TriggerSecondStage_Off 		= 638,
	Plane_HOTAS_TriggerFirstStage_Off  		= 639,

	Plane_HOTAS_BoatSwitchOff				= 822,
	Plane_Helmet_Brightess_Up 				= 840,
	Plane_Helmet_Brightess_Down 			= 841,

	PlaneRightMFD_OSB6_Off 					= 1012,
	Plane_HOTAS_CMS_Zaxis 					= 1041,
	Plane_HOTAS_CMS_Zaxis_Off 				= 1042,
	Plane_APU_Start 						= 1055,
	Plane_APU_Off 							= 1056,
	Plane_L_ENG_OPER_Ign 					= 1057,
	Plane_L_ENG_OPER_Norm 					= 1058,
	Plane_L_ENG_OPER_Motor 					= 1059,
	Plane_R_ENG_OPER_Ign 					= 1060,
	Plane_R_ENG_OPER_Norm 					= 1061,
	Plane_R_ENG_OPER_Motor 					= 1062,
	Plane_L_ENG_FUEL_FLOW_Norm 				= 1063,
	Plane_L_ENG_FUEL_FLOW_Override 			= 1064,
	Plane_R_ENG_FUEL_FLOW_Norm 				= 1065,
	Plane_R_ENG_FUEL_FLOW_Override 			= 1066,
	PlaneAHCPMasterArm   					= 1374,
	PlaneAHCPMasterSafe  					= 1375,
	PlaneAHCPMasterTrain 					= 1376,

	Plane_HOTAS_LeftThrottleButton_Off 		= 1557,
	--	end
	--	analog commands
    -- 自定义按键从这里开始，可以自动从10000开始增加，避免冲突 --

    --电力系统
    Battery 			= __custom_counter(),	--10000
    LeftAcGenerator 	= __custom_counter(),	--10001
    RightAcGenerator 	= __custom_counter(),	--10002
    GndPower 			= __custom_counter(),	--10003

    ThrottleAxisTest 	= __custom_counter(),	--10004油门位置
    EngStartSelector 	= __custom_counter(),	--10005
    EngStartor 			= __custom_counter(),	--10006自定义引擎启动输入
	LeftThrottorIdle 	= __custom_counter(),	--10007
	RightThrottorIdle 	= __custom_counter(),	--10008

	--	PlaneFlapsStop 		= __custom_counter(),	--目前屏蔽手动缝翼
	--	PlaneFlapsUpHotas 	= __custom_counter(),   --
	--	PlaneFlapsDownHotas = __custom_counter(),	--

    -- 武器测试用按键
    WeaponSelectNext 	= __custom_counter(),	--10009
    WeaponLaunch 		= __custom_counter(),	--10010
	PlaneRadarReset		= __custom_counter(),	--10011

	-- mp3播放器相关按键
	mp3Player_pauseOrPlay = __custom_counter(),	--10012
	mp3Player_next 		= __custom_counter(),	--10013
	mp3Player_last 		= __custom_counter(),	--10014
	mp3Player_fastForward = __custom_counter(),	--10015
	mp3Player_fastBack 	= __custom_counter(),	--10016

    Eject = __custom_counter(),					--10017
    hudBrt = __custom_counter(),				--10018
    UFCPBrt = __custom_counter(),				--10019
    UHF_PIT = __custom_counter(),				--10020
    VHF_PIT = __custom_counter(),				--10021
    DropFlare = __custom_counter(),				--10022
    DropChaff = __custom_counter(),				--10023
    DropChaffAndFlare = __custom_counter(),		--10024
    PlaneHeadingLightOnOff = __custom_counter(),		--10025
	PlaneNavLightOnOff = __custom_counter(),			--10026
	PlaneAntiCollisionLightOnOff = __custom_counter(),	--10027
	P2_to_radarPage = __custom_counter(),		--10028
	P2_to_fcsPage = __custom_counter(),			--10029
	setRadarStable = __custom_counter(),		--10030
	ShowParamList = __custom_counter(),			--10031
	NextTargetPnt = __custom_counter(),			--10032
	LastTargetPnt = __custom_counter(),			--10033
	--使用自定义舵输入命令，方便限制用户直接输入舵和转向
	LeftRudderStart = __custom_counter(),		--10034
    LeftRudderStop = __custom_counter(),		--10035
    RightRudderStart = __custom_counter(),		--10036
    RightRudderStop = __custom_counter(),		--10037
	mp3LrcViewTrigger = __custom_counter(),		--10038
	mp3PlayMode = __custom_counter(),			--10039
	A2A = __custom_counter(),					--10040
	A2G = __custom_counter(),					--10041
	specialAb = __custom_counter(),				--10042

	masterArm = __custom_counter(),				--10043
	hmdPwr = __custom_counter(),				--10044
	displayBrtMode = __custom_counter(),		--10045

    key0 = __custom_counter(),					--10046
    key1 = __custom_counter(),					--10047
    key2 = __custom_counter(),					--10048
    key3 = __custom_counter(),					--10049
    key4 = __custom_counter(),					--10050
    key5 = __custom_counter(),					--10051
    key6 = __custom_counter(),					--10052
    key7 = __custom_counter(),					--10053
    key8 = __custom_counter(),					--10054
    key9 = __custom_counter(),					--10055
    Enter = __custom_counter(),					--10056
    Clear = __custom_counter(),					--10057
    L1 = __custom_counter(),					--10058
    L2 = __custom_counter(),					--10059
    L3 = __custom_counter(),					--10060
    L4 = __custom_counter(),					--10061
    R1 = __custom_counter(),					--10062
    R2 = __custom_counter(),					--10063
    R3 = __custom_counter(),					--10064
    R4 = __custom_counter(),					--10065
    comm = __custom_counter(),					--10066
    Nav = __custom_counter(),					--10067
    combat = __custom_counter(),				--10068
    AP = __custom_counter(),					--10069
    boat = __custom_counter(),					--10070
	key_A = __custom_counter(),					--10071
	key_B = __custom_counter(),					--10072
	key_C = __custom_counter(),					--10073
	key_D = __custom_counter(),					--10074
	key_E = __custom_counter(),					--10075
	key_F = __custom_counter(),					--10076
	key_G = __custom_counter(),					--10077
	key_H = __custom_counter(),					--10078
	key_I = __custom_counter(),					--10079
	key_J = __custom_counter(),					--10080
	key_K = __custom_counter(),					--10081
	key_L = __custom_counter(),					--10082
	key_M = __custom_counter(),					--10083
	key_N = __custom_counter(),					--10084
	key_O = __custom_counter(),					--10085
	key_P = __custom_counter(),					--10086
	key_Q = __custom_counter(),					--10087
	key_R = __custom_counter(),					--10088
	key_S = __custom_counter(),					--10089
	key_T = __custom_counter(),					--10090
	key_U = __custom_counter(),					--10091
	key_V = __custom_counter(),					--10092
	key_W = __custom_counter(),					--10093
	key_X = __custom_counter(),					--10094
	key_Y = __custom_counter(),					--10095
	key_Z = __custom_counter(),					--10096
	key_SP = __custom_counter(),				--10097
	['key_+/-'] = __custom_counter(),			--10098
	back_a_car = __custom_counter(),			--10099
	P2_to_flirPage = __custom_counter(),		--10100
	STICK_SENSOR_CONTROL_FWD = __custom_counter(),		--10101
	STICK_SENSOR_CONTROL_AFT = __custom_counter(),		--10102
	STICK_SENSOR_CONTROL_LEFT = __custom_counter(),		--10103
	STICK_SENSOR_CONTROL_RIGHT = __custom_counter(),	--10104
	GunMode = __custom_counter(),				--10105
	EmergJettion = __custom_counter(),			--10106

	background_light_BRT_Increase = __custom_counter(),		--10107
	flood_light_BRT_Increase = __custom_counter(),      	--10108
	background_light_BRT_Decrease = __custom_counter(),		--10109
	flood_light_BRT_Decrease = __custom_counter(),      	--10110
	HUD_BRT_Increase = __custom_counter(),					--10111
	HUD_BRT_Decrease = __custom_counter(),					--10112
	MFCD_BRT_Increase = __custom_counter(),				--10113
	MFCD_BRT_Decrease = __custom_counter(),             --10114
}

-- 定义声音命令
SND_cmd = {
	LaserFire = __custom_counter(), 			--激光发射
}
--从3000开始递增点击指令
start_command   = 3001
local __count_click = start_command-1
local function __click_counter()
	__count_click = __count_click + 1
	return __count_click
end

-- 定义FLIR（前视红外）相关命令
flir_commands =
{
	WFOV				= __click_counter(), --3001 宽视场
	NFOV				= __click_counter(), -- 窄视场
	Menu				= __click_counter(), -- 菜单
	Hook				= __click_counter(), --
	Lock				= __click_counter(), --3005
	Freeze				= __click_counter(), --
	TrackBrk			= __click_counter(), --
    Power               = __click_counter(), --
	FocusOut			= __click_counter(), --
	FocusIn				= __click_counter(), --3010
    Cage                = __click_counter(), --
	IPHH				= __click_counter(), --
	Polarity			= __click_counter(), --
	SlewLeft			= __click_counter(), --
	SlewRight			= __click_counter(), --3015
	SlewUp				= __click_counter(), --
    SlewDown			= __click_counter(), --
	GainUp				= __click_counter(), --
	GainDown			= __click_counter(), --
	LevelDown			= __click_counter(), --3020
	LevelUp				= __click_counter(), --
	AutoGain			= __click_counter(), --
	LaserOn				= __click_counter(), --3023 -- 激光开启
}

-- 定义点击命令映射表
click_cmd =
{
    GearLevel = __click_counter(), 		  	--3024 起落架手柄
    Battery = __click_counter(), 		  	--3025 电瓶
    LeftAcGenerator = __click_counter(),  	--
    RightAcGenerator = __click_counter(), 	--
    GndPower = __click_counter(),         	--
    StartorSwitch = __click_counter(),    	--
	EngineStart_DN = __click_counter(),   	--3030
	EngineStart_UP = __click_counter(),   	--
	hudBrt = __click_counter(),           	--
	UFCPBrt = __click_counter(),          	--
	hmdPower = __click_counter(),         	--
	hudColor = __click_counter(),         	--3035
	hmdBrt = __click_counter(),           	--
	HudMFCD_change_dayNight = __click_counter(), --
	UHF_Volume = __click_counter(),				 --
	VHF_Volume = __click_counter(),              --
	VOIP = __click_counter(),                    --3040
	antenna = __click_counter(),                 --
	TCN_Volume = __click_counter(),              --
	RWR_Volume = __click_counter(),              --
	strobe_light = __click_counter(),            --
	formation_light = __click_counter(),         --3045
	refuel_light = __click_counter(),            --
	wingtip_light = __click_counter(),           --
	antiCollision_light = __click_counter(),     --
	background_light = __click_counter(), --
	flood_light = __click_counter(),      --3050
	flash_light = __click_counter(),      --
	taxi_light = __click_counter(),       --
	ext_tank_pump = __click_counter(),    --
	air_refuel = __click_counter(),       --
	drain_oil_L = __click_counter(),      --3055
	drain_oil_R = __click_counter(),      --
	masterArm = __click_counter(),        --
	LeftThrottorIdle = __click_counter(), --
	RightThrottorIdle = __click_counter(), --
	LaunchBarSw = __click_counter(),      --3060
	LeftExtinguishing = __click_counter(), --
	RightExtinguishing = __click_counter(), --3062
}

-- 定义MFD（多功能显示器）点击命令
MFD_click_cmd = {
    EADI_AUTO = __click_counter(),	--3063 自动EADI
    EADI_SETUP = __click_counter(), --3064
    EADI_IND_ON = __click_counter(), --3065
    EADI_IND_OFF = __click_counter(), --
    EADI_YAW_ON = __click_counter(),  --
    EADI_YAW_OFF = __click_counter(), --
    EADI_ILS = __click_counter(),     --
    FCS_HOLD_ON = __click_counter(),  --3070
    FCS_HOLD_OFF = __click_counter(), --
    FCS_AUTO = __click_counter(),     --
    FCS_BIT = __click_counter(),      --
    FCS_RESET = __click_counter(),    --
    FCS_AUTO2 = __click_counter(),    --3075
    FCS_OVER = __click_counter(),     --
    FCS_CAU = __click_counter(),      --
    HSI_FY = __click_counter(),       --
    HSI_MENU = __click_counter(),     --
	HSI_NAV = __click_counter(),      --3080
	HSI_HDG_MODE = __click_counter(), --
    HSI_MAP = __click_counter(),      --
    HSI_SCALE_UP = __click_counter(), --
    HSI_SCALE_DN = __click_counter(), --
	HSI_WPT = __click_counter(),      --3085
	BP5_L1 = __click_counter(),       --
	BP5_L2 = __click_counter(),       --
	BP5_R1 = __click_counter(),       --
	BP5_R2 = __click_counter(),       --
	BP5_LAST = __click_counter(),     --3090
	BP5_NEXT = __click_counter(),     --
    WPN_AAMODE = __click_counter(),   --
    WPN_AGMODE = __click_counter(),   --
    WPN_DOOR_ON = __click_counter(),  --
    WPN_DOOR_AUTO = __click_counter(),--3095
    ENG_SW = __click_counter(),       --
    MASTER_CAU = __click_counter(),   --
    FIRE_CAU = __click_counter(),     --3098
}

-- 定义MFCD（多功能彩色显示器）点击命令
MFCD_click_cmd = {
	BTN1 = __click_counter(), -- 3099按钮1 
	BTN2 = __click_counter(), -- 3100
	BTN3 = __click_counter(), -- 3101
	BTN4 = __click_counter(), -- 3102
	BTN5 = __click_counter(), -- 3103
	BTN6 = __click_counter(), -- 3104
	BTN7 = __click_counter(), -- 3105
	BTN8 = __click_counter(), -- 3106
	BTN9 = __click_counter(), -- 3107
	BTN10 = __click_counter(),-- 3108
	BTN11 = __click_counter(),-- 3109
	BTN12 = __click_counter(),-- 3110
	BTN13 = __click_counter(),-- 3111
	BTN14 = __click_counter(),-- 3112
	BTN15 = __click_counter(),-- 3113
	BTN16 = __click_counter(),-- 3114
	BTN17 = __click_counter(),-- 3115
	BTN18 = __click_counter(),-- 3116
	BTN19 = __click_counter(),-- 3117
	BTN20 = __click_counter(),-- 3118
	BTN21 = __click_counter(),-- 3119
	BTN22 = __click_counter(),-- 3120
	BTN23 = __click_counter(),-- 3121
	BTN24 = __click_counter(),-- 3122
	BTN25 = __click_counter(),-- 3123
	BTN26 = __click_counter(),-- 3124
}

-- 定义UFCP（上前控制面板）点击命令
UFCP_click_cmd = {
    key0_up = __click_counter(), -- 按键0松开-- 3125
    key0_dn = __click_counter(), -- 按键0按下-- 3126
    key1_up = __click_counter(), -- 按键1松开-- 3127
    key1_dn = __click_counter(), -- 按键1按下-- 3128
    key2_up = __click_counter(), -- 按键2松开-- 3129
    key2_dn = __click_counter(), -- 按键2按下-- 3130
    key3_up = __click_counter(), -- 按键3松开-- 3131
    key3_dn = __click_counter(), -- 按键3按下-- 3132
    key4_up = __click_counter(), -- 按键4松开-- 3133
    key4_dn = __click_counter(), -- 按键4按下-- 3134
    key5_up = __click_counter(), -- 按键5松开-- 3135
    key5_dn = __click_counter(), -- 按键5按下-- 3136
    key6_up = __click_counter(), -- 按键6松开-- 3137
    key6_dn = __click_counter(), -- 按键6按下-- 3138
    key7_up = __click_counter(), -- 按键7松开-- 3139
    key7_dn = __click_counter(), -- 按键7按下-- 3140
    key8_up = __click_counter(), -- 按键8松开-- 3141
    key8_dn = __click_counter(), -- 按键8按下-- 3142
    key9_up = __click_counter(), -- 按键9松开-- 3143
    key9_dn = __click_counter(), -- 按键9按下-- 3144
    Enter_up = __click_counter(), -- 按键Enter松开-- 3145
    Enter_dn = __click_counter(), -- 按键Enter按下-- 3146
    Clear_up = __click_counter(), -- 按键Clear松开-- 3147
    Clear_dn = __click_counter(), -- 按键Clear按下-- 3148
    L1_up = __click_counter(), -- 按键L1松开-- 3149
    L1_dn = __click_counter(), -- 按键L1按下-- 3150
    L2_up = __click_counter(), -- 按键L2松开-- 3151
    L2_dn = __click_counter(), -- 按键L2按下-- 3152
    L3_up = __click_counter(), -- 按键L3松开-- 3153
    L3_dn = __click_counter(), -- 按键L3按下-- 3154
    L4_up = __click_counter(), -- 按键L4松开-- 3155
    L4_dn = __click_counter(), -- 按键L4按下-- 3156
    R1_up = __click_counter(), -- 按键R1松开-- 3157
    R1_dn = __click_counter(), -- 按键R1按下-- 3158
    R2_up = __click_counter(), -- 按键R2松开-- 3159
    R2_dn = __click_counter(), -- 按键R2按下-- 3160
    R3_up = __click_counter(), -- 按键R3松开-- 3161
    R3_dn = __click_counter(), -- 按键R3按下-- 3162
    R4_up = __click_counter(), -- 按键R4松开-- 3163
    R4_dn = __click_counter(), -- 按键R4按下-- 3164
    comm_up = __click_counter(), -- 按键comm松开-- 3165
    comm_dn = __click_counter(), -- 按键comm按下-- 3166
    Nav_up = __click_counter(), -- 按键Nav松开-- 3167
    Nav_dn = __click_counter(), -- 按键Nav按下-- 3168
    combat_up = __click_counter(), -- 按键combat松开-- 3169
    combat_dn = __click_counter(), -- 按键combat按下-- 3170
    AP_up = __click_counter(), -- 按键AP松开-- 3171
    AP_dn = __click_counter(), -- 按键AP按下-- 3172
    boat_up = __click_counter(), -- 按键boat松开-- 3173
    boat_dn = __click_counter(), -- 按键boat按下-- 3174
}

-- 定义键盘点击命令
Keybord_click_cmd = {
	key_A = __click_counter(), -- 按键A -- 3175
	key_B = __click_counter(), -- 按键B -- 3176
	key_C = __click_counter(), -- 按键C -- 3177
	key_D = __click_counter(), -- 按键D -- 3178 
	key_E = __click_counter(), -- 按键E -- 3179
	key_F = __click_counter(), -- 按键F -- 3180
	key_G = __click_counter(), -- 按键G -- 3181
	key_H = __click_counter(), -- 按键H -- 3182
	key_I = __click_counter(), -- 按键I -- 3183
	key_J = __click_counter(), -- 按键J -- 3184
	key_K = __click_counter(), -- 按键K -- 3185
	key_L = __click_counter(), -- 按键L -- 3186
	key_M = __click_counter(), -- 按键M -- 3187
	key_N = __click_counter(), -- 按键N -- 3188
	key_O = __click_counter(), -- 按键O -- 3189
	key_P = __click_counter(), -- 按键P -- 3190
	key_Q = __click_counter(), -- 按键Q -- 3191
	key_R = __click_counter(), -- 按键R -- 3192
	key_S = __click_counter(), -- 按键S -- 3193
	key_T = __click_counter(), -- 按键T -- 3194
	key_U = __click_counter(), -- 按键U -- 3195
	key_V = __click_counter(), -- 按键V -- 3196
	key_W = __click_counter(), -- 按键W -- 3197
	key_X = __click_counter(), -- 按键X -- 3198
	key_Y = __click_counter(), -- 按键Y -- 3199
	key_Z = __click_counter(), -- 按键Z -- 3200
	key_SP = __click_counter(), -- 空格键 -- 3201
	['key_+/-'] = __click_counter(), -- +/-键 -- 3202
}

RightPanel_click_cmd={MFCDBrt = __click_counter(),}