dofile(LockOn_Options.script_path.."Displays/HUD/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')

local Level = DEFAULT_LEVEL + 3
local Noclip_Level = DEFAULT_NOCLIP_LEVEL + 3

AddBox(nil,Width,Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Width,Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)
IS_HUD = true
--这里有配合开机动画的前移显示然后逐步缩小定焦的效果，先绕YAW旋转90度，用随时间控制的增量参数控制左右移动，再绕YAW旋转-90度回正
--local N=0
local z_simple = AddSimple(nil,{0,0,-N},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.2}})
local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
local x_scale = (10-N)/10
local y_scale = (10-N)/10

local boxa=0.2*Width	--盒子边长
local boxt=0.01*Width	--线宽
--------------------------------------------------------------------------------------------------------------------------
--准星
AddCrossHair(nil,0.1*Width,0.1*Height,0.005*Width,nil,nil,'DBG_GREEN',nil,Level,base_simple,{string.format('HMD_LOCK_BVR_STATUS'),"HELMET_IN_HUD"},
	{{AnimalControllor.parameterCompareWithNumber,0,1},{AnimalControllor.parameterCompareWithNumber,1,1}}
)
--准星锁定框
AddBoxBorder(nil,0.05*Width,0.05*Height,0.005*Width,nil,nil,'DBG_GREEN',nil,Level,base_simple,{string.format('HMD_LOCK_BVR_STATUS'),"HELMET_IN_HUD"},
	{{AnimalControllor.parameterCompareWithNumber,0,1},{AnimalControllor.parameterCompareWithNumber,1,1}}
)
--主军械
AddText(nil,'SAFE','unicode_cn_red',{0*Width,-0.85*Height},Align.CC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,nil,
	{
		'MASTER_MODE',"HELMET_IN_HUD"
	},{
        { AnimalControllor.parameterCompareWithNumber, 	0,0},
		{ AnimalControllor.parameterCompareWithNumber,	1,1}
	}
)
--------------------------------------------------------------------------------------------------------------------------
--STT区
--提示文字
AddText(nil,'STT','unicode_cn_red',{0*Width,0.5*Height},Align.CC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"HELMET_IN_HUD"
	},{
        { AnimalControllor.parameterCompareWithNumber, 	1,3},
		{ AnimalControllor.parameterCompareWithNumber,	2,1},
        { AnimalControllor.parameterCompareWithNumber,	3,1}
	}
)
--STT框和圆

local stt_box=AddBoxBorder(nil,boxa,boxa,boxt,nil,nil,'DBG_RED',Level,nil,base_simple,
    {
        "TARGET_BOX_DIS_ENABLE",
        "TARGET_BOX_Y",
        "TARGET_BOX_X",
        "HELMET_IN_HUD",
		"TARGET_IN_HUD"
    },{
        {AnimalControllor.parameterInRange,0,0.01,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
        {AnimalControllor.parameterCompareWithNumber,3,1},
		{AnimalControllor.parameterCompareWithNumber,4,1}
    }
)
local stt_circle=AddCircle(nil,boxa,boxa-boxt,360,16,nil,nil,'DBG_RED',nil,Level,base_simple,
    {
		"TARGET_BOX_DIS_ENABLE",
        "TARGET_BOX_Y",
        "TARGET_BOX_X",
        "HELMET_IN_HUD"
	},
    {
		{AnimalControllor.parameterInRange,0,0.01,1.1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
        {AnimalControllor.parameterCompareWithNumber,3,1}
    }
)
--STT连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,Level,base_simple,
    {
		"TARGET_BOX_DIS_ENABLE",
		"TARGET_BOX_X",
		"TARGET_BOX_Y",
		"TARGET_BOX_X_2",
		"TARGET_BOX_Y_2",
        "HELMET_IN_HUD"
	},{
        {AnimalControllor.parameterInRange,0,0.01,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale},
        {AnimalControllor.parameterCompareWithNumber,5,1}
    }
)
--STT目标距离：公里
AddText(nil,nil,'unicode_cn_red',{0,boxa*0.5},nil,DEFAULT_FONT_SIZE[3],nil,Level,stt_circle,
    {'%.2f'},{
        "TARGET_RANGE",
        "TARGET_NCTR",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT",
        "HELMET_IN_HUD"
    },{
        {AnimalControllor.textUsingParameter,	0,0},
        --{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,0},
        {AnimalControllor.parameterCompareWithNumber,	4,1}
    }
)
AddText(nil,nil,'unicode_cn_red',{0,boxa*1.5},Align.CB,DEFAULT_FONT_SIZE[1],nil,Level,stt_box,
    {'%s'},{
        "NCTR_STATUS",
        "TARGET_NCTR",
        "TARGET_BOX_DIS_ENABLE",
        "UNIT",
        "HELMET_IN_HUD"
    },{
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.textUsingParameter,	1,0},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,0},
        {AnimalControllor.parameterCompareWithNumber,	4,1}
    }
)
--STT目标距离：公里 中央
AddText(nil,nil,'unicode_cn_red',{0*Width,0.15*Height},nil,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,
	{'%.2f'},{
		"TARGET_RANGE",
        "TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT",
        "TARGET_IN_HUD",
        "HELMET_IN_HUD"
	},{
		{AnimalControllor.textUsingParameter,	0,0},
        --{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,0},
        {AnimalControllor.parameterCompareWithNumber,	4,0},
        {AnimalControllor.parameterCompareWithNumber,	5,1}
	}
)
AddText(nil,nil,'unicode_cn_red',{0*Width,boxa*1.5},nil,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,
	{'%s'},{
		"NCTR_STATUS",
        "TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT",
        "TARGET_IN_HUD",
        "HELMET_IN_HUD"
	},{
		{AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.textUsingParameter,	1,0},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,0},
        {AnimalControllor.parameterCompareWithNumber,	4,0},
        {AnimalControllor.parameterCompareWithNumber,	5,1}
	}
)
--STT目标距离：海里 
AddText(nil,nil,'unicode_cn_red',{0,boxa*0.5},nil,DEFAULT_FONT_SIZE[3],nil,Level,stt_circle,
    {'%.1f'},{
		"TARGET_RANGE_NM",
		"TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT",
        "HELMET_IN_HUD"
	},{
        {AnimalControllor.textUsingParameter,	0,0},
		--{AnimalControllor.textUsingParameter,	1,1},        
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,1},
        {AnimalControllor.parameterCompareWithNumber,	4,1}
	}
)
AddText(nil,nil,'unicode_cn_red',{0,boxa*1.5},nil,DEFAULT_FONT_SIZE[1],nil,Level,stt_box,
    {'%s'},{
        "NCTR_STATUS",
		"TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT",
        "HELMET_IN_HUD"
	},{
        {AnimalControllor.parameterCompareWithNumber,0,1},
		{AnimalControllor.textUsingParameter,	1,0},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,1},
        {AnimalControllor.parameterCompareWithNumber,	4,1}
	}
)
--STT目标距离：海里 中央
AddText(nil,nil,'unicode_cn_red',{0*Width,0.15*Height},nil,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,
	{'%.2f'},{
		"TARGET_RANGE_NM",
        "TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT",
        "TARGET_IN_HUD",
        "HELMET_IN_HUD"
	},{
		{AnimalControllor.textUsingParameter,	0,0},
        --{AnimalControllor.textUsingParameter,	1,1},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,1},
        {AnimalControllor.parameterCompareWithNumber,	4,0},
        {AnimalControllor.parameterCompareWithNumber,	5,1},
	}
)
AddText(nil,nil,'unicode_cn_red',{0*Width,boxa*1.5},nil,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,
	{'%s'},{
		"NCTR_STATUS",
        "TARGET_NCTR",
		"TARGET_BOX_DIS_ENABLE",
		"UNIT",
        "TARGET_IN_HUD",
        "HELMET_IN_HUD"
	},{
		{AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.textUsingParameter,	1,0},
        {AnimalControllor.parameterInRange,2,0.01,1.1},
        {AnimalControllor.parameterCompareWithNumber,	3,1},
        {AnimalControllor.parameterCompareWithNumber,	4,0},
        {AnimalControllor.parameterCompareWithNumber,	5,1},
	}
)
-- 1) “点”元素：红点
local scale_stt = boxa * 0.07
local Pad_stt 	= boxt * 2
AddCircle(
    nil,                -- name
    Pad_stt,           		-- radius_outer
    0,                  -- radius_inner
    360, 16,            -- arc, sides
    nil, nil,           -- pos, rot（由 controllers 推动）
    "DBG_RED",       -- material
    h_clip_relations.COMPARE,
    Level,
    stt_box,        -- 父节点
    {
        "WS_DLZ_SHOW_X",   -- [0] 控制显示：0=点可见
        "WS_DLZ_DOT_Y",    -- [1] Y 偏移
        "WS_DLZ_DOT_X"     -- [2] X 偏移
    },
    {
        { AnimalControllor.parameterCompareWithNumber, 0, 0 },  -- WS_DLZ_SHOW_X==0 时显示
        { AnimalControllor.moveUpDownUsingParameter,    1, scale_stt },  -- 用第1个句柄做垂直位移
        { AnimalControllor.moveLeftRightUsingParameter, 2, scale_stt }   -- 用第2个句柄做水平位移
    }
)
-- 2) “叉”元素：红叉
--------------------------------------------------------------------------------
AddCrossHair(
    nil,              	-- name
    boxa, boxa, boxt,	-- width, height, thickness
    nil, {45,0},		-- pos, rot
    "DBG_RED",
    h_clip_relations.COMPARE,
    Level,
    stt_box,
    { "WS_DLZ_SHOW_X" },	-- [0] 控制显示：1=叉可见
    {
		{ AnimalControllor.parameterCompareWithNumber, 0, 1 },
		{ AnimalControllor.parameterCompareWithNumber, 1, 1 }
	}
)
--------------------------------------------------------------------------------------------------------------------------
-- 计算 DLZ 点或叉的显示
-- 先算出半宽半高

local cboxa	= 0.2*Width
local cboxt	= 0.01*Width
local scale = cboxa * 0.07
--local W 	= cboxa * 0.5
--local H 	= cboxa * 0.5
local Pad 	= cboxt * 2
local LVL	= Level

local Center_box=AddBoxBorder(nil,cboxa,cboxa,cboxt,nil,nil,'DBG_RED',LVL,nil,base_simple,
	{
		'TARGET_BOX_DIS_ENABLE',
		"HELMET_IN_HUD",
		"TARGET_IN_HUD"
	},
	{
		{AnimalControllor.parameterInRange,				0,0.01,1.1},
		{AnimalControllor.parameterCompareWithNumber,	1,1},
		{AnimalControllor.parameterCompareWithNumber,	2,0}
	}
)

--------------------------------------------------------------------------------
-- 1) “点”元素：红点
--------------------------------------------------------------------------------
AddCircle(
    nil,                -- name
    Pad,           		-- radius_outer
    0,                  -- radius_inner
    360, 16,            -- arc, sides
    nil, nil,           -- pos, rot（由 controllers 推动）
    "DBG_RED",       -- material
    h_clip_relations.COMPARE,
    LVL,
    Center_box,        -- 父节点
    {
        "WS_DLZ_SHOW_X",   -- [0] 控制显示：0=点可见
        "WS_DLZ_DOT_Y",    -- [1] Y 偏移
        "WS_DLZ_DOT_X",     -- [2] X 偏移
		"TARGET_IN_HUD"
    },
    {
        { AnimalControllor.parameterCompareWithNumber, 0, 0 },  -- WS_DLZ_SHOW_X==0 时显示
        { AnimalControllor.moveUpDownUsingParameter,    1, scale },  -- 用第1个句柄做垂直位移
        { AnimalControllor.moveLeftRightUsingParameter, 2, scale },   -- 用第2个句柄做水平位移
		{ AnimalControllor.parameterCompareWithNumber,	3,0}
    }
)

--------------------------------------------------------------------------------
-- 2) “叉”元素：红叉
--------------------------------------------------------------------------------
AddCrossHair(
    nil,              -- name
    cboxa, cboxa, cboxt,       -- width, height, thickness
    nil, {45,0},         -- pos, rot
    "DBG_RED",        -- material
    h_clip_relations.COMPARE,
    LVL,
    Center_box,      -- 父节点
    { "WS_DLZ_SHOW_X","TARGET_IN_HUD" },                              -- [0] 控制显示：1=叉可见
    { { AnimalControllor.parameterCompareWithNumber, 0, 1 },{ AnimalControllor.parameterCompareWithNumber,	1,0} }
)
--------------------------------------------------------------------------------
-- 3) 显示各阶段数据 
--------------------------------------------------------------------------------
local function CreateDLZRangeText(pos, parent,fmtStr, rangeParam, unit_value,in_hud_value)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_blue',   -- material
        pos,                -- 显示位置
        nil,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[2],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        LVL,          		-- 层级（注意 Level 大小写）
        parent,             -- 父元素
        { fmtStr },         -- 格式化输出数组（仅一项）
        { rangeParam ,'UNIT',"TARGET_IN_HUD"},           	-- 第0项：目标距离（KM 或 NM）            
        {
			{ AnimalControllor.textUsingParameter, 0,0 },
			{ AnimalControllor.parameterCompareWithNumber, 1, unit_value },
			{ AnimalControllor.parameterCompareWithNumber, 2, in_hud_value }
		}
    )
end

-- 显示DLZ数据
local function Create_DLZ_T (bu,parent_t,value)
	CreateDLZRangeText({ 1.0*bu,  1.2*bu}, parent_t, '%.0f', "WS_DLZ_MAX_KM",		    0,value) 		--右上角 武器最大射程
	CreateDLZRangeText({-1.2*bu,  1.2*bu}, parent_t, '%.0f', "WS_DLZ_MAX_DYN",		    0,value) 		--左上角 动态最大射程
	CreateDLZRangeText({   0*bu, -0.5*bu}, parent_t, '%.0f', "WS_DLZ_MARGIN_DYN",	    0,value)		--中央   动态最大拦截余量KM
	CreateDLZRangeText({-1.2*bu, -1.2*bu}, parent_t, '%.0f', "WS_DLZ_BEST_DYN",		    0,value) 		--左下角 动态最佳射程
	CreateDLZRangeText({ 1.4*bu, -1.2*bu}, parent_t, '%.0f', "WS_DLZ_MIN_DYN",		    0,value)		--右下角 动态最小射程
	CreateDLZRangeText({ 1.4*bu,  0.8*bu}, parent_t, '%.1f', "WS_DLZ_MIN_KM",		    0,value)		--右上角 武器最小射程

	CreateDLZRangeText({ 1.0*bu,  1.2*bu}, parent_t, '%.0f', "WS_DLZ_MAX_NM",			1,value) 		--右上角 武器最大射程
	CreateDLZRangeText({-1.2*bu,  1.2*bu}, parent_t, '%.0f', "WS_DLZ_MAX_DYN_NM",		1,value) 		--左上角 动态最大射程
	CreateDLZRangeText({   0*bu, -0.5*bu}, parent_t, '%.0f', "WS_DLZ_MARGIN_DYN_NM",	1,value)		--中央   动态最大拦截余量NM
	CreateDLZRangeText({-1.2*bu, -1.2*bu}, parent_t, '%.0f', "WS_DLZ_BEST_DYN_NM",		1,value) 		--左下角 动态最佳射程
	CreateDLZRangeText({ 1.4*bu, -1.2*bu}, parent_t, '%.0f', "WS_DLZ_MIN_DYN_NM",		1,value)		--右下角 动态最小射程
	CreateDLZRangeText({ 1.4*bu,  0.8*bu}, parent_t, '%.1f', "WS_DLZ_MIN_NM",			1,value)		--右上角 武器最小射程
end
Create_DLZ_T(boxa,stt_box,1) 	--为stt_box 显示DLZ数据
Create_DLZ_T(cboxa,Center_box,0) 	--为Center_box 显示DLZ数据

--------------------------------------------------------------------------------------------------------------------------
-- TOF区
-- TOF 同心表盘
do
    boxa				= 0.4 * Width
    local MAX_TOF     	= 150               -- 刻度上限（秒）
    local ANGLE_PER_S   = 300 / MAX_TOF     -- 每秒对应角度    
	local R_w			= boxa / 40			-- 表盘线径
    local LINE_WIDTH    = boxa / 80	     	-- 指针宽度
    local Y_TOF         = -1 * Height    	--  Y 中心线
	local X_TOF         =  0   				--  X 中心线
    local R_START       = 0.2 * boxa    	-- 第1 槽 X 起点（左侧）
    local R_STEP        = 0.05 * Height     -- 每槽间距
	local LINE_color	= 'SCREEN_COLOR'
	local Ring_color    = 'DBG_GREEN'    -- 表盘颜色
	local Ring_h_color	= 'DBG_RED'			-- 表盘高亮区颜色
	local Text_color	= 'hud_font_base'	-- 文字颜色
	      LVL 			= Level
    local Parent_item   = base_simple

	for i = 1, 6 do
		local R_off = R_START + (i-1) * R_STEP  -- 第1槽最内侧，依次向外排列
		-- 1. 在 Top 页创建一个定位容器容器
		local tofsim = AddSimple(nil,{X_TOF,Y_TOF},nil,Parent_item,{'HMD_MSL' .. i .. '_REMAIN'},{{ AnimalControllor.parameterInRange, 0, 0.099, MAX_TOF*1.2 }})
		-- 2. 绘制外圈和内圈（与 rpmGauge 圆环样式一致）
		AddCircle(nil,R_off, R_off-R_w, 270, 36, nil, {-30, 0},	Ring_color,		h_clip_relations.COMPARE,	LVL,	tofsim)
		AddCircle(nil,R_off, R_off-R_w,  30, 36, nil, {  0, 0},	Ring_h_color,	h_clip_relations.COMPARE,	LVL,	tofsim)

		-- 3. TOF 指针：旋转角度根据倒计时百分比改变（假设 MAX_TOF 秒对应一圈）
		AddSimpleLine(nil,LINE_WIDTH,{{0, 0}, {0, R_off}},nil, nil,LINE_color,h_clip_relations.COMPARE,LVL,tofsim,
			{'HMD_MSL'..i..'_REMAIN'},
			{{ AnimalControllor.rotateUsingParameter,0,math.rad(-ANGLE_PER_S) }}	-- 逆时针
		)

		-- 4. 数字倒计时显示（秒 ）
		local tof_text = AddText(nil, nil,Text_color,{-0* boxa, R_off},Align.RC,DEFAULT_FONT_SIZE[6],h_clip_relations.COMPARE,LVL,tofsim,
			{'%.1f'},
			{'HMD_MSL' .. i .. '_REMAIN'},
			{{ AnimalControllor.textUsingParameter, 0 }}
		)
	end
end
--------------------------------------------------------------------------------------------------------------------------
--IR弹
AddCircle(nil,0.3*Width,0.29*Width,360,72,nil,nil,'DBG_YELLOW',nil,Level,base_simple,
    {"IR_SEEK_RANGE_DIS","HELMET_IN_HUD"},{
        {AnimalControllor.parameterCompareWithNumber,	0,1},
		{AnimalControllor.parameterCompareWithNumber,	1,1}
    }
)
AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_RED',nil,Level,base_simple,
    {
        "TARGET_ROUND_DIS_ENABLE",
        "TARGET_ROUND_Y",
        "TARGET_ROUND_X",
        "HELMET_IN_HUD"
    },{
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,	2,x_scale},
		{AnimalControllor.parameterCompareWithNumber,	3,1}
    }
)
--------------------------------------------------------------------------------------------------------------------------
--机炮ccip圈
AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'SCREEN_COLOR',nil,Level,base_simple,
    {
        "GUN_CCIP_DIS_ENABLE",
        "GUN_CCIP_Y",
        "GUN_CCIP_X"
    },{
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,	2,x_scale}
    }
)
--机炮ccip连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'SCREEN_COLOR',nil,Level,base_simple,
    {
        "GUN_CCIP_DIS_ENABLE",
        "GUN_CCIP_X",
        "GUN_CCIP_Y",
        "GUN_CCIP_X_2",
        "GUN_CCIP_Y_2"
    },{
        {AnimalControllor.parameterCompareWithNumber,		0,1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale}
    }
)
--------------------------------------------------------------------------------------------------------------------------
--ccip
AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'SCREEN_COLOR',nil,Level,base_simple,
    {
        "CCIP_DIS_ENABLE",
        "CCIP_Y",
        "CCIP_X"
    },{
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,	2,x_scale}
    }
)
--ccip连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'SCREEN_COLOR',nil,Level,base_simple,
    {
        "CCIP_DIS_ENABLE",
        "CCIP_X",
        "CCIP_Y",
        "CCIP_X_2",
        "CCIP_Y_2"
    },{
        {AnimalControllor.parameterCompareWithNumber,		0,1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale}
    }
)
--------------------------------------------------------------------------------------------------------------------------
--ccrp线
AddSimpleLine(nil,0.004*Width,{{0,0},{0,-1}},nil,nil,'SCREEN_COLOR',nil,Level,base_simple,
    {
        "CCRP_DIS_ENABLE",
        "CCRP_X",
    },{
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.moveLeftRightUsingParameter,	1,x_scale}
    }
)
--CCRP命中时间
AddText(nil,nil,'hud_font_base',nil,Align.LT,DEFAULT_FONT_SIZE[5],nil,Level,base_simple,
    {'TIME:%.1f'},{
		"CCRP_DIS_ENABLE",
		"CCRP_TIME",
		'CCRP_X'
	},{
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.textUsingParameter,1},
        {AnimalControllor.moveUpDownUsingParameter,1,-0.01},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale}
    }
)
--------------------------------------------------------------------------------------------------------------------------
--武器名称显示
AddText(nil,nil,'hud_font_base',{1.0*Width , -1.05*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
    {'%s X ','%.0f'},
    {"WEAPON_NAME",'WEAPON_COUNT',"WEAPON_NAME_DIS",'ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter,			0,0},
        {AnimalControllor.textUsingParameter,			1,1},
        {AnimalControllor.parameterInRange,				2,0.5,1.1},
		{AnimalControllor.parameterInRange,				3,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,	4,0}
    }
)
--右下角CCIP/CCRP状态显示
AddText(nil,'CCIP','hud_font_base',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[5],nil,Level,base_simple,nil,
	{'CCIP_DIS_ENABLE','ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,1},
    {AnimalControllor.parameterCompareWithNumber,1,2}
})
AddText(nil,'CCRP','hud_font_base',{1.0*Width,-0.75*Height},Align.RC,DEFAULT_FONT_SIZE[5],nil,Level,base_simple,nil,
	{'CCRP_DIS_ENABLE','ATK_MODE'},{
    {AnimalControllor.parameterCompareWithNumber,0,1},
    {AnimalControllor.parameterCompareWithNumber,1,2}
})
--------------------------------------------------------------------------------------------------------------------------
--BVR 雷达区
local radarWidth 	= Width*0.65
local radarHeight 	= Width*0.6

local localSimle = AddSimple(nil,{0,-radarWidth},nil,base_simple)

--BVR 边线
AddMultiLine(nil,nil,nil,
    {
        {-radarWidth, radarHeight},
        {-radarWidth,-radarHeight},
        { radarWidth, radarHeight},
        { radarWidth,-radarHeight}
    },
    {0,1,2,3},{0,radarHeight},nil,'LIGHT_RED',nil,nil,Level,localSimle,
    {'ATK_MODE','RADAR_WORK_MODE','RADAR_MODE','GUN_MODE'},
    {
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.parameterCompareWithNumber,	1,0},
        {AnimalControllor.parameterInRange,	            2,-0.1,2.1},
        {AnimalControllor.parameterCompareWithNumber,	3,0}
    }
)
AddText(nil,'BVR','hud_font_base',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,0},
        { AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1}
	}
)
--显示雷达比例
AddText("雷达比例",nil,'radar_ui_font',{0.65*Width,0.65*Height},nil,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
    {'MAX:%.0f'},
	{'MAX_RANGE','ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter, 			0},
        {AnimalControllor.parameterCompareWithNumber,	1,1},
    	{AnimalControllor.parameterCompareWithNumber,	2,0}
	}
)

local ud_scale 		= 0.000003200*radarHeight
local lr_scale 		= 0.085*radarWidth

--友方显示圆点，敌方显示方块，未知显示为短线
for i = 1, Targetnum, 1 do
    local targetparams  = {
        string.format('HMD_CLUSTER_TARGET_%02d_ELEVATION',		i),	--0
        string.format('HMD_CLUSTER_TARGET_%02d_AZIMUTH',			i),	--1
        string.format('HMD_CLUSTER_TARGET_%02d_RANGE_SCALE',		i),	--2
        string.format('HMD_CLUSTER_TARGET_%02d_TIME',			i),	--3
        string.format('HMD_CLUSTER_TARGET_%02d_FRIENDLY',		i),	--4
        string.format('HMD_CLUSTER_TARGET_%02d_RCS',				i),	--5
        'ATK_MODE',												--6
        'RADAR_WORK_MODE',										--7
        string.format('HMD_CLUSTER_TARGET_%02d_IN_SC_LIMIT', 	i),	--8
        'GUN_MODE',												--9
    }
    AddCircle(nil,0.03*radarWidth,0,360,18,nil,nil,'SCREEN_COLOR',nil,Level,localSimle,targetparams,
    {
        {AnimalControllor.moveLeftRightUsingParameter,  1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter,     2,ud_scale},
		{AnimalControllor.parameterInRange,             1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange,             2,500,40000},
    --  {AnimalControllor.parameterInRange,             3,Life_time_low,Life_time},
        {AnimalControllor.parameterCompareWithNumber,   4,1},
    --  {AnimalControllor.opacityUsingParameter,        5},
        {AnimalControllor.parameterCompareWithNumber,   6,1},
    --  {AnimalControllor.parameterInRange,   			7,-0.9,5.1},
        {AnimalControllor.parameterCompareWithNumber,   8,1},
        {AnimalControllor.parameterCompareWithNumber,   9,0}
	})

	AddBox(nil,0.03*radarWidth,0.03*radarHeight,nil,nil,'DBG_RED',Level,nil,localSimle,targetparams,
    {
        {AnimalControllor.moveLeftRightUsingParameter,	1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter,		2,ud_scale},
		{AnimalControllor.parameterInRange,				1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange,				2,500,40000},
    --  {AnimalControllor.parameterInRange,				3,Life_time_low,Life_time},
        {AnimalControllor.parameterCompareWithNumber,	4,0},
    --  {AnimalControllor.opacityUsingParameter,		5},
        {AnimalControllor.parameterCompareWithNumber,	6,1},
    --  {AnimalControllor.parameterInRange,   			7,-0.1,5.1},
        {AnimalControllor.parameterCompareWithNumber,	8,1},
        {AnimalControllor.parameterCompareWithNumber,	9,0}
    })

	AddSimpleLine(nil,0.03*radarWidth,{{-0.055*radarWidth,0},{0.055*radarWidth,0}},nil,nil,'DBG_YELLOW',nil,Level,localSimle,targetparams,
    {
        {AnimalControllor.moveLeftRightUsingParameter,	1,lr_scale},
        {AnimalControllor.moveUpDownUsingParameter,		2,ud_scale},
        {AnimalControllor.parameterInRange,				1,-math.rad(60),math.rad(60)},
		{AnimalControllor.parameterInRange,				2,500,40000},
    --  {AnimalControllor.parameterInRange,				3,Life_time_low,Life_time},
        {AnimalControllor.parameterCompareWithNumber,	4,-1},
    --  {AnimalControllor.opacityUsingParameter,		5},
        {AnimalControllor.parameterCompareWithNumber,	6,1},
    --  {AnimalControllor.parameterInRange,   			7,-0.1,5.1},
        {AnimalControllor.parameterCompareWithNumber,	8,1},
        {AnimalControllor.parameterCompareWithNumber,	9,0}
    })
end

--TDC on HUD
local x_size = 0.032*radarWidth
local y_size = 0.03*radarHeight
AddMultiLine(nil,1.5,nil,
    {{-x_size,-y_size},{-x_size,y_size},{x_size,-y_size},{x_size,y_size}},
    {0,1,2,3},{ 0, 0 },nil,'SCREEN_COLOR',Align.CC,nil,Level,localSimle,
	{
		"RADAR_TDC_RANGE_SCALE",		--0
		"RADAR_TDC_AZIMUTH_RANGE",		--1
        "RADAR_TDC_AZIMUTH",			--2
		"RADAR_MODE",					--3
        'ATK_MODE',						--4
        'RADAR_WORK_MODE',				--5
        'GUN_MODE',						--6
	},
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0,ud_scale},
		{ AnimalControllor.moveLeftRightUsingParameter, 2,lr_scale},
		{ AnimalControllor.parameterInRange, 			3,-0.1,2.1},
        { AnimalControllor.parameterCompareWithNumber,	4,1},
        { AnimalControllor.parameterCompareWithNumber,	5,0},
        { AnimalControllor.parameterCompareWithNumber,	6,0}
	}
)
--------------------------------------------------------------------------------------------------------------------------
--广角捕获
local apertureRadius = math.rad(5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,72,nil,nil,'DBG_BLUE',nil,Level,base_simple,
    {
        'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
    },{
        { AnimalControllor.parameterCompareWithNumber,	0,1},
        { AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
        { AnimalControllor.parameterCompareWithNumber,	2,1}
    }
)
AddText(nil,'广角模式','hud_font_base',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,1},
        { AnimalControllor.parameterInRange, 			1, -0.1, 3.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1}
	}
)
--孔径
apertureRadius = math.rad(1)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'LIGHT_PURPLE',nil,Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"HELMET_IN_HUD"
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,3},
        { AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1},
        { AnimalControllor.parameterCompareWithNumber,	3,1}
	}
)
AddText(nil,'孔径','hud_font_base',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,3},
        { AnimalControllor.parameterInRange, 			1, -0.1, 3.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1}
	}
)
--长孔径
apertureRadius = math.rad(2.5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_RED',nil,Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"HELMET_IN_HUD"
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,2 },
        { AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
        { AnimalControllor.parameterCompareWithNumber,	3,1 }
	}
)
AddText(nil,'长孔径','hud_font_base',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,2 },
        { AnimalControllor.parameterInRange, 			1, -0.1, 3.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 }
	}
)
--垂扫
apertureRadius = math.rad(4)/HUD_AZ*Width
--AddMultiLine(nil,nil,nil,
--	{
--		{-apertureRadius,Height},
--		{-apertureRadius,-Height},
--		{apertureRadius,Height},
--		{apertureRadius,-Height}
--	},{0,1,2,3},nil,nil,'SCREEN_COLOR',nil,nil,Level,base_simple,
--	{
--		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"HELMET_IN_HUD"
--	},{
--		{ AnimalControllor.parameterCompareWithNumber,	0,4 },
--        { AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
--		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
--        { AnimalControllor.parameterCompareWithNumber,  3,1 }
--	}
--)
AddText(nil,'垂扫模式','hud_font_base',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,4 },
        { AnimalControllor.parameterInRange, 			1, -0.1, 3.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
	}
)
--平扫
apertureRadius = math.rad(5)/HUD_EL*Height
--AddMultiLine(nil,nil,nil,
--	{
--		{-Width,apertureRadius},
--		{Width,apertureRadius},
--		{-Width,-apertureRadius},
--		{Width,-apertureRadius}
--	},{0,1,2,3},nil,nil,'SCREEN_COLOR',nil,nil,Level,base_simple,
--	{
--		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE',"HELMET_IN_HUD"
--	},{
--		{ AnimalControllor.parameterCompareWithNumber,	0,5 },
--        { AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
--		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
--        { AnimalControllor.parameterCompareWithNumber,  3,1 }
--	}
--)
AddText(nil,'平扫模式','hud_font_base',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,5 },
        { AnimalControllor.parameterInRange, 			1, -0.1, 3.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 }
	}
)
--------------------------------------------------------------------------------------------------------------------------
--AG
if Type then
	--FLIR 激光指示
    AddText(nil, '激光', 'unicode_cn_red', { 1.0 * Width, -0.75 * Height }, Align.RC, DEFAULT_FONT_SIZE[5], nil,
        Level, base_simple, nil,
        { 'FLIR_STATUS', 'FLIR_LASER_ON', 'FLIR_LASER_FLASH', 'ATK_MODE' }, {
            { AnimalControllor.parameterCompareWithNumber, 0, 5 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.parameterInRange,           2, 0.49, 1.01 },
            { AnimalControllor.parameterCompareWithNumber, 3, 2 }
        }
	)
    --EOTS指示符
    local eotsInd = AddSimpleLine(nil, 0.003 * Width,
		{
			{ 0,            0.04 * Height },
			{ 0.02 * Width, 0 },
			{ 0,           -0.04 * Height },
			{-0.02 * Width, 0 },
			{ 0,            0.04 * Height },
		}, nil, nil, 'DBG_RED', nil, Level, base_simple,
		{ 'EOTS_HUD_X', 'EOTS_HUD_Y', 'FLIR_STATUS', 'ATK_MODE' },
        {
            { AnimalControllor.moveLeftRightUsingParameter, 0, x_scale },
            { AnimalControllor.moveUpDownUsingParameter,    1, y_scale },
            { AnimalControllor.parameterCompareWithNumber,  2, 5 },
            { AnimalControllor.parameterCompareWithNumber,  3, 2 },
        }
	)
    AddCircle(nil, 0.007 * Width, 0, 360, 18, nil, nil, 'LIGHT_ORIGIN', nil, Level, eotsInd,
        { 'FLIR_STATUS', 'ATK_MODE' }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 5 },
        { AnimalControllor.parameterCompareWithNumber, 1, 2 },
    })
    local combatMskLevel = Level + 2
    local combatMskNoClipLevel = combatMskLevel - 1
    --------------------------------------------------------------------------------------------------------------------------
    --激光炮
    AddText(nil, nil, 'hud_font_base', { 1.0 * Width, -0.95 * Height }, Align.RC, DEFAULT_FONT_SIZE[4], nil,
        Level, base_simple,
        { '%s' },
        { 'ATK_MODE', 'GUN_MODE', 'GUN_NAME' },
        {
            { AnimalControllor.parameterInRange,           0, 0.9, 2.1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.textUsingParameter,         2 },
        }
    )
    AddMultiLine(nil, nil, nil, {
        { 0, 0.1 * Height }, { 0, 0.01 * Height },
        { 0, -0.1 * Height }, { 0, -0.01 * Height },
        { -0.1 * Width, 0 }, { -0.01 * Width, 0 },
        { 0.1 * Width, 0 }, { 0.01 * Width, 0 }
    }, { 0, 1, 2, 3, 4, 5, 6, 7 }, nil, nil, 'SCREEN_COLOR', nil, nil, Level, base_simple, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    })
    local lsrGunInfoSimp = AddSimple(nil, nil, nil, base_simple)
    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, 0 }, nil, 'DBG_RED', combatMskNoClipLevel, REWRITE_LEVEL,lsrGunInfoSimp,
		{'GUN_MODE', 'GUN_TYPE'}, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    }, true)
    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, 0 }, nil, 'SCREEN_COLOR', combatMskNoClipLevel, INCREASE_IF_LEVEL, lsrGunInfoSimp,
		{'GUN_MODE', 'GUN_TYPE'}, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    }, true)
    AddBoxBorder(nil, 0.03 * Width, 0.155 * Height, 0.005 * Width, { -0.15 * Width, 0 }, nil, 'SCREEN_COLOR', Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
    })
    AddBoxBorder(nil, 0.05 * Width, 0.175 * Height, 0.005 * Width, { -0.15 * Width, 0 }, nil, 'SCREEN_COLOR', Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterCompareWithNumber, 2, 8 },
    })

    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, -0.3 * Height }, nil, 'SCREEN_COLOR', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CHARGE', 'LASER_GUN_CD1', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterInRange,           2, 0, 2.11 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 },
        { AnimalControllor.parameterCompareWithNumber, 3, 0 },
        { AnimalControllor.parameterCompareWithNumber, 4, 8 },
    })
    AddBox(nil, 0.025 * Width, 0.15 * Height, { -0.15 * Width, -0.3 * Height }, nil, 'SCREEN_COLOR', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CD1'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 * 0.215 },
        { AnimalControllor.parameterInRange,           2, 0, 10.1 }

    })
    AddText(nil, nil, 'hud_font_base', { -0.15 * Width, -0.2 * Height }, nil, DEFAULT_FONT_SIZE[5], nil, Level,
        lsrGunInfoSimp,
        { '%.0f' }, {
            'GUN_MODE', 'GUN_TYPE', 'LaserCannonAmmo_L'
        }, {
            { AnimalControllor.parameterCompareWithNumber, 0, 1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.textUsingParameter,         2 }
        })

    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, 0 }, nil, 'DBG_RED', combatMskNoClipLevel, REWRITE_LEVEL,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 }
    }, true)
    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, 0 }, nil, 'SCREEN_COLOR', combatMskNoClipLevel,
        INCREASE_IF_LEVEL, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 }
    }, true)
    AddBoxBorder(nil, 0.03 * Width, 0.155 * Height, 0.005 * Width, { 0.15 * Width, 0 }, nil, 'SCREEN_COLOR', Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 }
    })
    AddBoxBorder(nil, 0.05 * Width, 0.175 * Height, 0.005 * Width, { 0.15 * Width, 0 }, nil, 'SCREEN_COLOR', Level,
        nil, lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterCompareWithNumber, 2, 9 }
    })

    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, -0.3 * Height }, nil, 'SCREEN_COLOR', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CHARGE', 'LASER_GUN_CD2', 'CURRENT_GUN_IDX'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.parameterInRange,           2, 0, 2.11 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 },
        { AnimalControllor.parameterCompareWithNumber, 3, 0 },
        { AnimalControllor.parameterCompareWithNumber, 4, 9 }
    })
    AddBox(nil, 0.025 * Width, 0.15 * Height, { 0.15 * Width, -0.3 * Height }, nil, 'SCREEN_COLOR', combatMskLevel, nil,
        lsrGunInfoSimp, {
        'GUN_MODE', 'GUN_TYPE', 'LASER_GUN_CD2'
    }, {
        { AnimalControllor.parameterCompareWithNumber, 0, 1 },
        { AnimalControllor.parameterCompareWithNumber, 1, 1 },
        { AnimalControllor.moveUpDownUsingParameter,   2, 0.01005 * 0.215 },
        { AnimalControllor.parameterInRange,           2, 0, 10.1 }
    })
    AddText(nil, nil, 'hud_font_base', { 0.15 * Width, -0.2 * Height }, nil, DEFAULT_FONT_SIZE[5], nil, Level,
        lsrGunInfoSimp,
        { '%.0f' }, {
            'GUN_MODE', 'GUN_TYPE', 'LaserCannonAmmo_R'
        }, {
            { AnimalControllor.parameterCompareWithNumber, 0, 1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 1 },
            { AnimalControllor.textUsingParameter,         2 }
        })

    AddText(nil, nil, 'hud_font_base', { 1.0 * Width, -0.85 * Height }, Align.RC, DEFAULT_FONT_SIZE[4], nil,
        Level, base_simple,
        { '%.0f' },
        { 'GUN_MODE', 'GUN_TYPE', 'GUN_COUNT' },
        {
            { AnimalControllor.parameterCompareWithNumber, 0, 1 },
            { AnimalControllor.parameterCompareWithNumber, 1, 0 },
            { AnimalControllor.textUsingParameter,         2 }
        }
    )
end
--------------------------------------------------------------------------------------------------------------------------
-- Contact态势
--------------------------------------------------------------------------------
-- 公共辅助函数
--------------------------------------------------------------------------------
--Life_time 	  = 1
--Life_time_low   = 0
local DmaxRange = 550 --最大范围
boxa=0.1*Width
boxt=0.004*Width
-- 根据目标序号 i 返回公共参数名称数组
local function GetCommonContactParams(i)
    return {
        string.format('HMD_CONTACT_%02d_Y', i),           -- [0]
        string.format('HMD_CONTACT_%02d_X', i),           -- [1]
        string.format('HMD_CONTACT_%02d_FRIENDLY', i),    -- [2]
        string.format('HMD_CONTACT_%02d_TIME', i),      -- [3]
        "ATK_MODE",                                         -- [4]
        "RADAR_WORK_MODE",                                  -- [5]
        string.format('HMD_CONTACT_%02d_RANGE_NM', i),    -- [6]
        "HELMET_IN_HUD"                                      -- [7]    
    }
end

-- 返回 AddBoxBorder 控制映射数组，根据 compareVal 和范围参数设置
local function CommonBoxControllers(compareVal, rangeLimit)
    return {
        {AnimalControllor.moveUpDownUsingParameter,     0, y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,  1, x_scale},
        {AnimalControllor.parameterCompareWithNumber,   2, compareVal},
    --    {AnimalControllor.parameterInRange,             3, Life_time_low, Life_time},
        {AnimalControllor.parameterCompareWithNumber,   4, 1},
        {AnimalControllor.parameterInRange,             5, -0.9, 5.1},
        {AnimalControllor.parameterInRange,             6, 0.09, rangeLimit},
        {AnimalControllor.parameterCompareWithNumber,   7, 1}
    }
end

-- 封装创建目标方块（AddBoxBorder），参数 color 例如 'DBG_RED'、'DBG_YELLOW'、'SCREEN_COLOR'；
-- compareVal：敌为 0，未知为 -1，友为 1；rangeLimit：DmaxRange 或 200
local function CreateContactBox(i, color, compareVal, rangeLimit)
    return AddBoxBorder(
        nil,
        boxa,
        boxa,
        boxt,
        nil,
        nil,
        color,
        Level,
        nil,
        base_simple,
        GetCommonContactParams(i),
        CommonBoxControllers(compareVal, rangeLimit)
    )
end

-- 辅助函数：创建目标连线（AddSimpleLine）
-- 参数 factionVal 为 1（友方）、-1（未知）、0（敌方），决定最后 CompareWithNumber 控制器值
local function CreateContactLine(i, color, factionVal)
    local line_params = {
        string.format('HMD_CONTACT_%02d_X', i),           -- [0]
        string.format('HMD_CONTACT_%02d_Y', i),           -- [1]
        "HMD_TARGET_BOX_X_2",                               -- [2]
        "HMD_TARGET_BOX_Y_2",                               -- [3]
        "ATK_MODE",                                         -- [4]
        "RADAR_WORK_MODE",                                  -- [5]
        string.format('HMD_CONTACT_%02d_RANGE_NM', i),    -- [6]
        string.format('HMD_CONTACT_%02d_TIME', i),      -- [7]
        string.format('HMD_CONTACT_%02d_FRIENDLY', i),    -- [8]
        "HELMET_IN_HUD"                                      -- [9] 
    }
    local line_controllers = {
        {AnimalControllor.lineObjectSetPointUsingParameters, 0, 0, 1, x_scale, y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters, 1, 2, 3, x_scale, y_scale},
        {AnimalControllor.parameterCompareWithNumber, 4, 1},
        {AnimalControllor.parameterInRange, 5, -0.9, 5.1},
        {AnimalControllor.parameterInRange, 6, 0.09, DmaxRange},
    --    {AnimalControllor.parameterInRange, 7, Life_time_low, Life_time},
        {AnimalControllor.parameterCompareWithNumber, 8, factionVal},
        {AnimalControllor.parameterCompareWithNumber, 9, 1}
    }
    return AddSimpleLine(nil, 0.004 * Width, {{0, 0}, {1, 0}}, nil, nil, color, nil, Level, base_simple, line_params, line_controllers)
end

-- 辅助函数：创建目标说明文字（AddText），用于显示目标信息（如目标编号、距离等)
-- 参数：
--    parent      : 父对象（对应各方块，如 contact_box, unknown_box, friendly_box）
--    prefix      : 字符串前缀，如 "E "、"U "、"F "
--    color       : 显示颜色，如 'unicode_cn_red'、'unicode_cn_yellow'、'hud_font_base'
local function CreateContactText(parent, i, prefix, color)
    -- 第一个 AddText：以公里为单位
    AddText(
        nil,
        nil,
        color,
        {0,boxa+boxt},
        Align.CB,
        DEFAULT_FONT_SIZE[4],
        nil,
        Level,
        parent,
        { prefix .. "%s" },
        {
            string.format('HMD_CONTACT_%02d_NCTR', i),          --0
            "NCTR_STATUS",                                      --1
            "UNIT",                                             --2
            "ATK_MODE",                                         --3
            "HELMET_IN_HUD",                                     --4
            string.format('HMD_CONTACT_%02d_IN_LOCK',		i)  --5
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.parameterCompareWithNumber,1,1},
            {AnimalControllor.parameterCompareWithNumber, 2, 0},
            {AnimalControllor.parameterCompareWithNumber, 3, 1},
            {AnimalControllor.parameterInRange, 4, 1},
            {AnimalControllor.changeColorWhenParameterEqualToNumber,5,1,1,1,1},
        }
    )
    AddText(
        nil,
        nil,
        color,
        {0,0},
        nil,
        DEFAULT_FONT_SIZE[4],
        nil,
        Level,
        parent,
        { "%.0f" },
        {
            string.format('HMD_CONTACT_%02d_RANGE_KM', i),    --0
            "UNIT",                                           --1
            "ATK_MODE",                                       --2
            "HELMET_IN_HUD"                                   --3
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.parameterInRange, 0, 0.09, DmaxRange},
            {AnimalControllor.parameterCompareWithNumber, 1, 0},
            {AnimalControllor.parameterCompareWithNumber, 2, 1},
            {AnimalControllor.parameterInRange, 3, 1}
        }
    )
    -- 第二个 AddText：以海里为单位
    AddText(
        nil,
        nil,
        color,
        {0,boxa+boxt},
        Align.CB,
        DEFAULT_FONT_SIZE[4],
        nil,
        Level,
        parent,
        { prefix .."%s" },
        {
            string.format('HMD_CONTACT_%02d_NCTR', i),
            "NCTR_STATUS",
            "UNIT",
            "ATK_MODE",
            "HELMET_IN_HUD",
            string.format('HMD_CONTACT_%02d_IN_LOCK',		i)
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.parameterCompareWithNumber,1,1},
            {AnimalControllor.parameterCompareWithNumber, 2, 1},
            {AnimalControllor.parameterCompareWithNumber, 3, 1},
            {AnimalControllor.parameterInRange, 4, 1},
            {AnimalControllor.changeColorWhenParameterEqualToNumber,5,1,1,1,1},
        }
    )
    AddText(
        nil,
        nil,
        color,
        {0,0},
        nil,
        DEFAULT_FONT_SIZE[4],
        nil,
        Level,
        parent,
        { "%.0f" },
        {
            string.format('HMD_CONTACT_%02d_RANGE_NM', i),
            "UNIT",
            "ATK_MODE",
            "HELMET_IN_HUD"
        },
        {
            {AnimalControllor.textUsingParameter, 0, 0},
            {AnimalControllor.parameterInRange, 0, 0.09, DmaxRange},
            {AnimalControllor.parameterCompareWithNumber, 1, 1},
            {AnimalControllor.parameterCompareWithNumber, 2, 1},
            {AnimalControllor.parameterInRange, 3, 1}
        }
    )
end

--------------------------------------------------------------------------------
-- 主循环：遍历 1 至 20 的目标
--------------------------------------------------------------------------------
for i = 1, Targetnum do
    -- 创建目标方块
    local contact_box = CreateContactBox(i, 'DBG_RED', 0, DmaxRange)
    local unknown_box = CreateContactBox(i, 'DBG_YELLOW', -1, DmaxRange)
    local friendly_box = CreateContactBox(i, 'SCREEN_COLOR', 1, 200)
    if i<=5 then
    -- 创建目标连线：分别针对敌方、未知、友方
        CreateContactLine(i, 'DBG_RED', 0)
        CreateContactLine(i, 'DBG_YELLOW', -1)
        CreateContactLine(i, 'SCREEN_COLOR', 1)
    end
    local RelHeadP	=string.format('HMD_CONTACT_%02d_REL_HEAD', 	i)
    local InFocusP	=string.format('HMD_CONTACT_%02d_IN_FOCUS', 	i)
    local InLockP	=string.format('HMD_CONTACT_%02d_IN_LOCK',		i)
    local FriendlyP	=string.format('HMD_CONTACT_%02d_FRIENDLY', 	i)
    local GS		=string.format('HMD_CONTACT_%02d_GS', 			i)
    local rel_head=AddSimpleLine(nil,boxt/2,{{0,0},{0,0.75*boxa}},nil,nil,'LIGHT_BLUE',nil,Level,contact_box,
		{
			RelHeadP,
			InFocusP
    	},
    	{
    		{AnimalControllor.rotateUsingParameter,			0,math.rad(1)},
    	    --{AnimalControllor.parameterCompareWithNumber,	1,1},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,0,0},
    	}
	)
    --显示目标速度
	AddText(nil,nil,'unicode_cn_white',{0,-1.1*boxa},Align.CT,DEFAULT_FONT_SIZE[2],nil,Level,contact_box,
		{'%.0f'},{GS,FriendlyP},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,1,-1,1,1,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,1,0,1,0,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0},
		}
	)
    -- 创建目标说明文字（分别依附在各目标方块上）：
    CreateContactText(contact_box, i, "", 'unicode_cn_red')
    CreateContactText(unknown_box, i, "U ", 'unicode_cn_yellow')
    CreateContactText(friendly_box, i, "F ", 'hud_font_base')
end


--[[机炮格子
--AddTexture(nil,
--	{
--		{-0.5*Width, 0.5*Height},
--		{ 0.5*Width, 0.5*Height},
--		{ 0.5*Width,-0.5*Height},
--		{-0.5*Width,-0.5*Height}
--	},{0,1,2,2,3,0},Texure_coord_gen(0,0,1024,1024,1024,1024),MakeMaterial(GunSightMatt, {HUD_DAY_COLOR}),nil,nil,nil,Level,base_simple,
--	{
--		"GUN_CCIP_DIS_ENABLE"
--		--"GUN_GRID" -- 没有找到这个句柄在哪里定义
--	},
--	{
--		{AnimalControllor.parameterCompareWithNumber,	0,1},
--		--{AnimalControllor.parameterInRange,1,0.9,1.1}
--	}
--)]]