dofile(LockOn_Options.script_path .. "Displays/HUD/Indicator/definitions.lua")

local Level = DEFAULT_LEVEL + 2
local Noclip_level = DEFAULT_NOCLIP_LEVEL + 2

AddBox(nil,Width,Height,nil,nil,'DBG_RED',Noclip_level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Width,Height,nil,nil,'DBG_CLEAR',Noclip_level,INCREASE_IF_LEVEL)
IS_HUD = true
--local N=0
local z_simple = AddSimple(nil,{0,0,-N},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.2}})
local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
--四角飞行静态信息布局
do
    local ul_w = -0.6*Width    --左上角水平定位
    local dl_w = -1*Width       --左下角水平定位
    local ur_w =  0.65*Width    --右上角水平定位
    local dr_w =  1*Width       --右下角水平定位
    local u_l1_h = 1.0*Height   --上方第一行高度
    local u_l2_h = 0.9*Height   --上方第二行高度
    local u_l3_h = 0.8*Height   --上方第三行高度
    local d_l1_h = -0.8*Height  --下方第一行高度
    local d_l2_h = -0.9*Height  --下方第二行高度
    local d_l3_h = -1.0*Height  --下方第三行高度

    ---左上角
    --全程最大过载显示
    AddText(nil,nil,'hud_font_base',{ul_w,u_l1_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'GM:%.0f'},{'MAX_G'},{{AnimalControllor.textUsingParameter,0}})
    --过载
    AddText(nil,nil,'hud_font_base',{ul_w,u_l2_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'G:%.1f'},{'OVER_G'},{{AnimalControllor.textUsingParameter,0}})
    --攻角
    AddText(nil,nil,'hud_font_base',{ul_w,u_l3_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'攻角:%.1f','%s'},{'AOA_DEG'},{{AnimalControllor.textUsingParameter,0}})

    --- 中上
    --侧滑角
    AddText(nil,nil,'hud_font_base',{ 0,u_l1_h},nil,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'侧滑:%.1f','%s'},{'AOS_DEG'},{{'text_using_parameter',0}})

    --左下角
    --关键部件G3,F2,B,C
    AddText(nil,nil,'unicode_cn_red',{dl_w,d_l1_h},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,base_simple,
        {'%s ','%s ','%s ','%s'},
        {'HUD_GEAR','HUD_FLAP','HUD_BRAKE','HUD_CHUTE'},
        {
            {AnimalControllor.textUsingParameter,0,0},
            {AnimalControllor.textUsingParameter,1,1},
            {AnimalControllor.textUsingParameter,2,2},
            {AnimalControllor.textUsingParameter,3,3},
        }
    )
    --转数
    AddText(nil,nil,'unicode_cn_red',   {dl_w,d_l3_h},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,base_simple,{'RPM:%.0f,','%.0f'},{'L_ENG_RPM','R_ENG_RPM',"ATK_MODE"},{{AnimalControllor.textUsingParameter,0,0},{AnimalControllor.textUsingParameter,1,1},
            {AnimalControllor.parameterCompareWithNumber,2,0}})
    AddText(nil,nil,'unicode_cn_green', {dl_w,d_l3_h},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,base_simple,{'RPM:%.0f,','%.0f'},{'L_ENG_RPM','R_ENG_RPM',"ATK_MODE"},{{AnimalControllor.textUsingParameter,0,0},{AnimalControllor.textUsingParameter,1,1},
            {AnimalControllor.parameterCompareWithNumber,2,1}})
    AddText(nil,nil,'hud_font_base',    {dl_w,d_l3_h},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,base_simple,{'RPM:%.0f,','%.0f'},{'L_ENG_RPM','R_ENG_RPM',"ATK_MODE"},{{AnimalControllor.textUsingParameter,0,0},{AnimalControllor.textUsingParameter,1,1},
            {AnimalControllor.parameterCompareWithNumber,2,2}})

    ---右下角
    --右下航点显示第一行
    AddText(nil,nil,'hud_font_base',{dr_w,d_l1_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
        {'%s'},
        {"TARGET_NAME","NAV_MODE","ATK_MODE"},
        {
            {AnimalControllor.textUsingParameter,0,0},
            {AnimalControllor.parameterCompareWithNumber,1,1},
            {AnimalControllor.parameterCompareWithNumber,2,0},
            --{AnimalControllor.changeColorWhenParameterEqualToNumber,2,2,1,0,0}
        }
    )
    --右下航点显示第二行
    AddText(nil,nil,'hud_font_base',{dr_w,d_l2_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
        {'%02.0f:','%02.0f:','%02.0f+','%.0f'},
        {
            "TARGET_ETA_HH",
            "TARGET_ETA_mm",
            "TARGET_ETA_ss",
            "TARGET_ETA_dd",
            "NAV_MODE",
            "ATK_MODE"
        },
        {
            {AnimalControllor.textUsingParameter,0,0},
            {AnimalControllor.textUsingParameter,1,1},
            {AnimalControllor.textUsingParameter,2,2},
            {AnimalControllor.textUsingParameter,3,3},
            {AnimalControllor.parameterCompareWithNumber,4,1},
            {AnimalControllor.parameterCompareWithNumber,5,0},
            --{AnimalControllor.changeColorWhenParameterEqualToNumber,5,2,1,0,0}
        }
    )
    --右下航点显示第三行
    AddText(nil,nil,'hud_font_base',{dr_w,d_l3_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
        {'导航模式:%s'},
        { "NAV_TYPE", "ATK_MODE" },
        {
            {AnimalControllor.textUsingParameter,0},
            {AnimalControllor.parameterCompareWithNumber,1,0},
            --{AnimalControllor.changeColorWhenParameterEqualToNumber,1,2,1,0,0}
        }
    )
    --A/G
    --右下航点显示第一行
    AddText(nil,nil,'unicode_cn_red',{dr_w,d_l1_h},Align.RC,DEFAULT_FONT_SIZE[5],nil,Level,base_simple,
        {'%s'},
        {"TARGET_NAME","NAV_MODE","ATK_MODE"},
        {
            {AnimalControllor.textUsingParameter,0,0},
            {AnimalControllor.parameterCompareWithNumber,1,1},
            {AnimalControllor.parameterCompareWithNumber,2,2}
        }
    )
    --右下航点显示第二行
    AddText(nil,nil,'unicode_cn_red',{dr_w,d_l2_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
        {'%02.0f:','%02.0f:','%02.0f+','%.0f'},
        {
            "TARGET_ETA_HH",
            "TARGET_ETA_mm",
            "TARGET_ETA_ss",
            "TARGET_ETA_dd",
            "NAV_MODE",
            "ATK_MODE"
        },
        {
            {AnimalControllor.textUsingParameter,0,0},
            {AnimalControllor.textUsingParameter,1,1},
            {AnimalControllor.textUsingParameter,2,2},
            {AnimalControllor.textUsingParameter,3,3},
            {AnimalControllor.parameterCompareWithNumber,4,1},
            {AnimalControllor.parameterCompareWithNumber,5,02}
        }
    )
    --右下航点显示第三行
    AddText(nil,nil,'unicode_cn_red',{dr_w,d_l3_h},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
        {'导航模式:%s'},
        { "NAV_TYPE", "ATK_MODE" },
        {
            {AnimalControllor.textUsingParameter,0},
            {AnimalControllor.parameterCompareWithNumber,1,2}
        }
    )
end

--矢量符
local fd_simple = AddSimple(nil,nil,nil,base_simple,{"FD_X","FD_Y"},{{AnimalControllor.moveLeftRightUsingParameter,0,1},{AnimalControllor.moveUpDownUsingParameter,1,1}})
AddCircle(nil,0.04*Width,0.035*Width,360,36,nil,nil,'SCREEN_COLOR',nil,Level,fd_simple)
AddSimpleLine(nil,0.004*Width,{{ 0.04*Width,0},{ 0.08*Width,0}},nil,nil,'SCREEN_COLOR',nil,Level,fd_simple)
AddSimpleLine(nil,0.004*Width,{{-0.04*Width,0},{-0.08*Width,0}},nil,nil,'SCREEN_COLOR',nil,Level,fd_simple)
AddSimpleLine(nil,0.004*Width,{{0,0.04*Height},{0,0.08*Height}},nil,nil,'SCREEN_COLOR',nil,Level,fd_simple)

--警告相关
--注意文字提示
--AddText(nil,'注意','hud_font_base',{0,-0.2*Height},nil,DEFAULT_FONT_SIZE[1],nil,nil,base_simple,nil,{'WARNING_FLASH'},{{'parameter_in_range',0,0,0.9}})
--危险文字提示
--AddText(nil,'危险','hud_font_base',{0,-0.2*Height},nil,DEFAULT_FONT_SIZE[1],nil,nil,base_simple,nil,{'DANGER_FLASH'},{{'parameter_in_range',0,0,0.9}})
-- 拉起提示
AddCrossHair(nil,0.5*Width,0.5*Width,0.006*Width,nil,{45,0},'DBG_YELLOW',nil,Level,base_simple,{'PULLUP_FLASH'},{{'parameter_in_range',0,0,1.1}})

local x_scale = 1
local y_scale = 1
--------------------------------------------------------------------------------------------------------------------
--目标航路点 导航模式
local targetWpt_sim = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,1}})
local targetWpt = AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_BLUE',nil,Level,targetWpt_sim,
    { 'NAV_MODE','HUD_TARGET_WPT_EL','HUD_TARGET_WPT_AZ','ATK_MODE' },
    {
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
        {AnimalControllor.parameterCompareWithNumber,3,0}
    }
)
AddText(nil,nil,'unicode_cn_blue',{0,0},nil,DEFAULT_FONT_SIZE[5],nil,Level,targetWpt,
    {'%s\n\n','\n%s'},
    {'TARGET_NAME','TARGET_WPT_RANGE','NAV_MODE','ATK_MODE'},
    {
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.parameterInRange,2,-0.1,1.1},
        {AnimalControllor.parameterCompareWithNumber,3,0}
    }
)
--目标航路点 AG模式
local targetWpt2 = AddCircle(nil,0.07*Width,0.06*Width,360,36,nil,nil,'DBG_RED',nil,Level,targetWpt_sim,
    { 'NAV_MODE','HUD_TARGET_WPT_EL','HUD_TARGET_WPT_AZ','ATK_MODE' },
    {
        {AnimalControllor.parameterCompareWithNumber,0,1},
        {AnimalControllor.moveUpDownUsingParameter,1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,2,x_scale},
        {AnimalControllor.parameterCompareWithNumber,3,2}
    }
)
AddText(nil,nil,'unicode_cn_red',{0,0},nil,DEFAULT_FONT_SIZE[5],nil,Level,targetWpt2,
    {'%s\n\n','\n%s'},
    {'TARGET_NAME','TARGET_WPT_RANGE','NAV_MODE','ATK_MODE'},
    {
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.parameterInRange,2,-0.1,1.1},
        {AnimalControllor.parameterCompareWithNumber,3,2}
    }
)
----------------------------------------------------------------------------------------------------------------
--ILS
local ils_sim = AddSimple(nil,nil,nil,fd_simple)
AddCrossHair(nil,0.15*Width,0.15*Height,0.005*Width,nil,nil,'DBG_YELLOW',nil,Level,ils_sim,
    {'ILS_STATUS','ILS_IS_LOCALIZER_VALID','ILS_IS_GLIDESLOPE_VALID'},
    {
        {AnimalControllor.parameterInRange,0,0.9,1.1},
        {AnimalControllor.parameterInRange,1,0.9,1.1},
        {AnimalControllor.parameterInRange,2,0.9,1.1}
    }
)
AddSimpleLine(nil,0.0025*Width,{{-0.3*Width,0},{0.3*Width,0}},nil,nil,'DBG_YELLOW',nil,Level,ils_sim,
    {'ILS_GLIDESLOPE_DEVIATION','ILS_IS_OUTER_MARKER_SIGNAL','ILS_IS_MIDDLE_MARKER_SIGNAL','ILS_IS_INNER_MARKER_SIGNAL','ILS_IS_GLIDESLOPE_VALID'},
    {
        {AnimalControllor.moveUpDownUsingParameter,0,-1},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,1,0.5,0},
        {AnimalControllor.changeColorWhenParameterEqualToNumber,3,1,1,0,0},
        {AnimalControllor.parameterInRange,4,0.9,1.1}
    }
)
AddSimpleLine(nil,0.0025*Width,{{0,0.3*Height},{0,-0.3*Height}},nil,nil,'DBG_YELLOW',nil,Level,ils_sim,
    {'ILS_LOCALIZER_DEVIATION','ILS_IS_LOCALIZER_VALID'},
    {
        {AnimalControllor.moveLeftRightUsingParameter,0,1},
        {AnimalControllor.parameterInRange,1,0.9,1.1}
    }
)
--AG
AddCircle(nil,0.905*Width,0.895*Width,90,36,nil,{-135,0},'DBG_BLUE',nil,Level,base_simple,{"ATK_MODE"},{{AnimalControllor.parameterCompareWithNumber,0,2}})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{    0,0},'DBG_BLUE',nil,Level,base_simple,{"ATK_MODE"},{{AnimalControllor.parameterCompareWithNumber,0,2}})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{   45,0},'DBG_BLUE',nil,Level,base_simple,{"ATK_MODE"},{{AnimalControllor.parameterCompareWithNumber,0,2}})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{  -45,0},'DBG_BLUE',nil,Level,base_simple,{"ATK_MODE"},{{AnimalControllor.parameterCompareWithNumber,0,2}})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{ 22.5,0},'DBG_BLUE',nil,Level,base_simple,{"ATK_MODE"},{{AnimalControllor.parameterCompareWithNumber,0,2}})
AddSimpleLine(nil,0.005*Width,{{0,-0.855*Width},{0,-0.895*Width},},nil,{-22.5,0},'DBG_BLUE',nil,Level,base_simple,{"ATK_MODE"},{{AnimalControllor.parameterCompareWithNumber,0,2}})
