-------------------------------------------------------------------------------
-- Page: combat_page.lua
-- Description: 雷达目标等动态显示对象，
-------------------------------------------------------------------------------
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
--dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local Level         = DEFAULT_LEVEL + 2
local Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 2

AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)

--IS_HUD = false
local N=2
local base_simple = AddSimple(nil,{0,0,-N})
local x_scale = (10-N)/10
local y_scale = (10-N)/10

-------------------------------------------------------------------------------
local DmaxRange = 550 	--最大范围
local boxa=0.1*Width
local boxt=0.01*Width
local line_width=boxt/5
local lineRange = 80
--准星
AddCrossHair(nil,0.1*Width,0.1*Height,0.005*Width,nil,nil,'DBG_GREEN',nil,Level,base_simple)
--准星锁定框
AddBoxBorder(nil,0.05*Width,0.05*Height,0.005*Width,nil,nil,'DBG_GREEN',nil,Level,base_simple,{string.format('HMD_LOCK_BVR_STATUS'),"HELMET_IN_HUD"},
		{
			{AnimalControllor.parameterCompareWithNumber,0,1},
			{AnimalControllor.parameterCompareWithNumber,1,0}
		}
)
--雷达扫描目标
--敌方红色方块，未知黄色，友方绿色
-------------------------------------------------------------------------------
for i = 1, Targetnum do
	--定义句柄
	local elevP		=string.format('HMD_CONTACT_%02d_Y', 			i)
	local azimP		=string.format('HMD_CONTACT_%02d_X', 			i)
	local FriendlyP	=string.format('HMD_CONTACT_%02d_FRIENDLY', 	i)
	local TimeP		=string.format('HMD_CONTACT_%02d_TIME', 		i)
	local RangeNMP	=string.format('HMD_CONTACT_%02d_RANGE_NM', 	i)
	local RangeKMP	=string.format('HMD_CONTACT_%02d_RANGE_KM', 	i)
	local TimeScaleP=string.format('HMD_CONTACT_%02d_TIME_SCALE', 	i)
	local ID		=string.format('HMD_CONTACT_%02d_ID', 			i)
	local NCTR		=string.format('HMD_CONTACT_%02d_NCTR', 		i)
	local InFocusP	=string.format('HMD_CONTACT_%02d_IN_FOCUS', 	i)
	local InLockP	=string.format('HMD_CONTACT_%02d_IN_LOCK',		i)
	local RelHeadP	=string.format('HMD_CONTACT_%02d_REL_HEAD', 	i)
	local GS		=string.format('HMD_CONTACT_%02d_GS', 			i)
	local BehindP	=string.format('HMD_CONTACT_%02d_BEHIND', 		i)
	--定义动态参数
	local params 	={elevP, azimP, FriendlyP, TimeP, 'ATK_MODE', 'RADAR_WORK_MODE', RangeNMP, TimeScaleP, 'HEAD_AZ'}
	local boxparams ={FriendlyP}
	local lineparams={
			azimP,					--0
			elevP,					--1
			'HMD_TARGET_BOX_X_2',	--2
			'HMD_TARGET_BOX_Y_2',	--3
			'ATK_MODE',				--4
			'RADAR_WORK_MODE',		--5
			RangeNMP, 				--6
			TimeP,						--7
			FriendlyP,				--8
			TimeScaleP,				--9
			'HEAD_AZ',				--10
			BehindP,				--11
		}
	local txtNMparams={
			RangeNMP,
			'UNIT',
			FriendlyP
		}
	local txtKMparams={
			RangeKMP,
			'UNIT',
			FriendlyP
		}
	local NCTRparams={
			ID,
			NCTR,
			FriendlyP,
			"NCTR_STATUS",
			InLockP
		}
	-- 添加简单对象，包含雷达扫描目标的动态属性
	local contact_simple = AddSimple(nil,nil,nil,base_simple,params,
		{
			{AnimalControllor.moveUpDownUsingParameter,		0,y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,	1,x_scale},
		--	{AnimalControllor.parameterInRange,				2,-1.1,1.1},
		--	{AnimalControllor.parameterInRange,				3,Life_time_low,Life_time},
			{AnimalControllor.parameterCompareWithNumber,	4,1},
		--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
			{AnimalControllor.parameterInRange,				6,0.09,DmaxRange},
			{AnimalControllor.opacityUsingParameter,        7},
		--	{AnimalControllor.parameterInRange,				8,-60,60} -- 头向范围
		}
	)

	--敌方目标红色方块,未知目标黄色方块,友方绿色方块
	local contact_box=AddBoxBorder(nil,boxa,boxa,boxt,nil,nil,'DBG_WHITE',	Level,nil,contact_simple,boxparams,
		{
			{AnimalControllor.changeColorWhenParameterEqualToNumber,0,-1,1,1,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,0,0,1,0,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,0,1,0},
		}
	)
	local rel_head=AddSimpleLine(nil,boxt/2,{{0,0},{0,0.75*boxa}},nil,nil,'LIGHT_BLUE',nil,Level,contact_box,
		{
			RelHeadP,
			InFocusP
    	},
    	{
    		{AnimalControllor.rotateUsingParameter,			0,math.rad(1)},
    	    --{AnimalControllor.parameterCompareWithNumber,	1,1},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,1,1,1},
    	}
	)
	AddText(nil,"背面",'unicode_cn_yellow',{0,0},nil,DEFAULT_FONT_SIZE[3],nil,Level,contact_box,
		nil,{BehindP},{{AnimalControllor.parameterCompareWithNumber,0,1}})
	--if i<=Targetnum then
	if i<=5 then
	--雷达扫描目标连线，绿色友方，黄色未知，红色敌方 仅显示60NM内前5个目标
		AddSimpleLine(nil,line_width,{{0,0},{1,0}},nil,nil,'DBG_WHITE',nil,Level,base_simple,lineparams,
    		{
    		    {AnimalControllor.lineObjectSetPointUsingParameters,0,0,1,x_scale,y_scale},
    		    {AnimalControllor.lineObjectSetPointUsingParameters,1,2,3,x_scale,y_scale},
				{AnimalControllor.parameterCompareWithNumber,	4,1},
			--	{AnimalControllor.parameterInRange,   			5,-0.1,5.1},
				{AnimalControllor.parameterInRange,				6,0.09,lineRange},
				{AnimalControllor.changeColorWhenParameterEqualToNumber,8,-1,1,1,0},
    	    	{AnimalControllor.changeColorWhenParameterEqualToNumber,8,0,1,0,0},
    	    	{AnimalControllor.changeColorWhenParameterEqualToNumber,8,1,0,1,0},
			--	{AnimalControllor.opacityUsingParameter,		9},
			--	{AnimalControllor.parameterInRange,				10,-60,60}, -- 头向范围
				{AnimalControllor.parameterCompareWithNumber,	11,0},
    		}
		)
	end
	--显示距离KM
	AddText(nil,nil,'unicode_cn_white',{0,0},nil,DEFAULT_FONT_SIZE[2],nil,Level,contact_box,
		{'%.1f'},txtKMparams,
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.parameterCompareWithNumber,	1,0},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,2,-1,1,1,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,0,1,0,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,0,1,0},
		}
	)
	--显示距离NM
	AddText(nil,nil,'unicode_cn_white',{0,0},nil,DEFAULT_FONT_SIZE[2],nil,Level,contact_box,
		{'%.1f'},txtNMparams,
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.parameterCompareWithNumber,	1,1},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,2,-1,1,1,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,0,1,0,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,0,1,0},
		}
	)
	--显示文字ID和NCTR
	AddText(nil,nil,'unicode_cn_white',{0,boxt+boxa},nil,DEFAULT_FONT_SIZE[2],nil,Level,contact_box,
		{'%1.f\n','%s\n'},NCTRparams,
		{
			--{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.textUsingParameter,			1,1},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,2,-1,1,1,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,0,1,0,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,0,1,0},
			{AnimalControllor.parameterCompareWithNumber,3,1},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,4,1,1,1,1},
		}
	)
	--显示目标速度
	AddText(nil,nil,'unicode_cn_white',{0,-1.1*boxa},Align.CT,DEFAULT_FONT_SIZE[2],nil,Level,contact_box,
		{'%.0f'},{GS,FriendlyP},
		{
			{AnimalControllor.textUsingParameter,			0,0},
			{AnimalControllor.changeColorWhenParameterEqualToNumber,1,-1,1,1,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,1,0,1,0,0},
        	{AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0},
		}
	)
end
