
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
--dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local debug_switch = Render_debug_info
if debug_switch == 0 then
	return
end

local debug_Level         = DEFAULT_LEVEL + 3
local debug_Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 3
AddBox(nil,3*Width,3*Height,nil,nil,'DBG_RED',debug_Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,3*Width,3*Height,nil,nil,'DBG_CLEAR',debug_Noclip_Level,INCREASE_IF_LEVEL)

IS_HUD = false
--local z_simple = AddSimple(nil,{0,0,-6},{0,90},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.02}})
--local base_simple = AddSimple(nil,nil,{0,-90},z_simple)
local base_simple = AddSimple()

--------------------------------------------------------------------------------
IGNORE_BRT = true --使用自定义的透明度控制
--------------------------------------------------------------------------------
--【HUD 显示调试信息：本机和头盔姿态】 辅助函数：CreateHMDDebugText
-- 参数：
--   offsetY    - 水平显示元素相对于屏幕中心的垂直偏移比例（例如 0.25 表示 0.25*Height）
--   txtControllers - 控制映射数组，用于各字段的参数替换，
--                    例如第一个调用传入 { {AnimalControllor.textUsingParameter, 0, 0},
--                                              {AnimalControllor.textUsingParameter, 1, 1},
--                                              {AnimalControllor.parameterCompareWithNumber, 4, 1} }
---------------------------------------------------------------------
do
    local function CreateHMDDebugText(offsetY, txtControllers)
        AddText(
            nil,                                   -- name
            nil,                                   -- val
            'unicode_cn_yellow',                   -- material
            { -Width, offsetY * Height },               -- 位置（以屏幕高度为参考）
            Align.RC,                              -- 对齐方式
            DEFAULT_FONT_SIZE[3],                  -- 字符串尺寸
            nil,                                   -- _h_clip_relation
            debug_Level,                             -- 层级（使用 debug_Level，注意大小写）
            base_simple,                           -- 父元素
            {                                      -- 格式化输出（拆分成多个字符串，每行末尾包含 "\n"）
                "机体姿态: DEG PITCH: %.1f",       -- 第一行第1字段
                " ROLL: %.1f\n",                  -- 第一行第2字段
                "HEAD_AZ: %.1f",                  -- 第二行第1字段
                "  HEAD_EL: %.1f\n"                -- 第二行第2字段
            },
            {                                      -- 参数名称数组，依次与格式化输出对应
                "DEBUG_PITCH_DEG", "DEBUG_ROLL_DEG", "HEAD_AZ", "HEAD_EL", "DEBUG_SWITCH"
            },
            txtControllers                       -- 对应的控制映射数组
        )
    end

---------------------------------------------------------------------
-- 调用示例：
-- 第1组：显示在屏幕中间偏上（Y=0.25*Height），显示机体姿态的 PITCH/ROLL（取参数索引 0、1）
---------------------------------------------------------------------
    CreateHMDDebugText(0.25, {
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.parameterCompareWithNumber, 4, 1}
    })

---------------------------------------------------------------------
-- 第2组：显示在屏幕中间偏下（Y=-0.25*Height），显示 HEAD_AZ/HEAD_EL（取参数索引 2、3）
---------------------------------------------------------------------
    CreateHMDDebugText(-0.25, {
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.parameterCompareWithNumber, 4, 1}
    })
end
--------------------------------------------------------------------------------
--[[【HMD 显示调试信息：heading】
-- 这里根据给定案例创建一个类似于“机体姿态”显示的文本
AddText(nil, nil, 'unicode_cn_yellow', {0.5 * Width, 0.5 * Height},Align.LC, DEFAULT_FONT_SIZE[3], nil, debug_Level, base_simple,
    {
        '目标速度: vx = %.1f m/s,', ' vy = %.1f m/s',' vz = %.1f m/s\n',
		'目标航向: head = %.1fDEG',' rel_head = %.1fDEG\n',
        '预测DEG AZ = %.2f,', ' EL = %.2f\n',
        '本机速度: Vx0 = %.1f m/s,', ' Vy0 = %.1f m/s,', ' Vz0 = %.1f m/s\n',
		'本机航向: head = %.1fDEG',' HDG = %.1fDEG\n',
        '参考系: %s'
    },
    {
        'DEBUG_TARGET_VX','DEBUG_TARGET_VY', 'DEBUG_TARGET_VZ',
		'DEBUG_TARGET_HEAD', 'DEBUG_TARGET_REL_HEAD',
        'DEBUG_PRED_AZ', 'DEBUG_PRED_EL',
        'DEBUG_SELF_VX', 'DEBUG_SELF_VY', 'DEBUG_SELF_VZ',
		'DEBUG_SELF_HEAD','HDG',
        'DEBUG_REF_MODE'
    },
    {
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.textUsingParameter, 4, 4},
        {AnimalControllor.textUsingParameter, 5, 5},
        {AnimalControllor.textUsingParameter, 6, 6},
        {AnimalControllor.textUsingParameter, 7, 7},
		{AnimalControllor.textUsingParameter, 8, 8},
		{AnimalControllor.textUsingParameter, 9, 9},
		{AnimalControllor.textUsingParameter, 10, 10},
		{AnimalControllor.textUsingParameter, 11, 11},
		{AnimalControllor.textUsingParameter, 12, 12}
    }
)
]]
--------------------------------------------------------------------------------
--[[【HMD 显示调试信息：雷达模式】
-- 单独显示 Radar.mode_h 的调试数据
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {0, 0.8 * Height},                -- 位置（与其它显示略有偏移）
    Align.CC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[5],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    debug_Level,                          -- 层级（使用 debug_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出：拆分为2个字段，行末带换行符
        "雷达模式: %d   ",             -- 第1字段
        "   ACM阶段: %d\n"                          -- 换行符
    },
    {                                   -- 调试参数名称数组
        "DEBUG_RADAR_MODE","DEBUG_ACM_STATUS"
    },
    {                                   -- 控制映射
        {AnimalControllor.textUsingParameter, 0, 0},
		{AnimalControllor.textUsingParameter, 1, 1}
    }
)
]]
--------------------------------------------------------------------------------
--[[【HMD 显示调试信息: 扫描】-- 调用 AddText 将调试数据以格式化方式显示到屏幕上（显示层级使用 debug_Level）。
-- 显示格式保持原来4行输出，每行内字段按要求拆开，并在行末添加换行符 "\n"。
--------------------------------------------------------------------------------
AddText(
    nil,                                -- name
    nil,                                -- val
    'unicode_cn_yellow',                -- material
    {-0.5 * Width,0.5 * Height },                -- 位置
    Align.RC,                           -- 对齐方式
    DEFAULT_FONT_SIZE[4],               -- 字符串尺寸
    nil,                                -- _h_clip_relation
    debug_Level,                          -- 层级（使用 debug_Level）
    base_simple,                        -- 父元素
    {                                   -- 格式化输出，共6行，每行内字段拆开：
        "扫描中心: AZ=%.1fdeg", " EL=%.1fdeg\n",       -- 第1行第1、2字段
        "ACM状态: %1.f", " | 候选数: %1.f", " | 全局计时: %.1fs\n", -- 第2行第1、2、3字段
        "ID: %1.f", " | 目标距离: %.1fkm\n",					-- 第3行第1、2字段
		"雷达读数: AZ=%.1fdeg", " EL=%.1fdeg\n",           		-- 第4行第1、2字段
        "目标差值: AZ=%.1fdeg", " EL=%.1fdeg\n",        		-- 第5行第1、2字段
        "扫描范围: AZ=%.1fdeg", " EL=%.1fdeg\n"       			-- 第6行第1、2字段 
    },
    {                                   -- 调试参数名称数组，顺序与上面格式字段依次对应
        "DEBUG_ACM_CENTER_AZ", "DEBUG_ACM_CENTER_EL",
        "DEBUG_ACM_STATUS", "DEBUG_ACM_CANDIDATE_COUNT", "DEBUG_ACM_GLOBAL_TIMEOUT",
        "DEBUG_ACM_TARGET", "DEBUG_ACM_CHOICE_RANGE","DEBUG_ACM_TARGET_AZ","DEBUG_ACM_TARGET_EL",
        "DEBUG_ACM_AZ_DIFF", "DEBUG_ACM_EL_DIFF",
        "DEBUG_ACM_MAX_SCAN_AZ", "DEBUG_ACM_MAX_SCAN_EL",
        "DEBUG_SWITCH",           -- 调试开关（用于比对或控制显示）
        "HELMET_IN_HUD",
        'ATK_MODE','RADAR_WORK_MODE'
    },
    {                                   -- 控制映射，将每个调试参数与显示占位符对应
        {AnimalControllor.textUsingParameter, 0, 0},
        {AnimalControllor.textUsingParameter, 1, 1},
        {AnimalControllor.textUsingParameter, 2, 2},
        {AnimalControllor.textUsingParameter, 3, 3},
        {AnimalControllor.textUsingParameter, 4, 4},
        {AnimalControllor.textUsingParameter, 5, 5},
        {AnimalControllor.textUsingParameter, 6, 6},
        {AnimalControllor.textUsingParameter, 7, 7},
        {AnimalControllor.textUsingParameter, 8, 8},
        {AnimalControllor.textUsingParameter, 9, 9},
        {AnimalControllor.textUsingParameter, 10, 10},
		{AnimalControllor.textUsingParameter, 11, 11},
		{AnimalControllor.textUsingParameter, 12, 12},
        {AnimalControllor.parameterCompareWithNumber, 13, 1},
    --    {AnimalControllor.parameterCompareWithNumber, 14, 0},
        {AnimalControllor.parameterCompareWithNumber, 15, 1},
        {AnimalControllor.parameterInRange, 16, 0.1, 5.1}
    }
)


--5. 显示聚类调试信息：输出聚类目标数量和最新目标时间
AddText(
	nil,
	nil,
	'unicode_cn_yellow',
	{1*Width, 1*Height},
	Align.LC,
	DEFAULT_FONT_SIZE[2],
	nil,
	debug_Level,
	base_simple,
	{
		"Radar Target Count: %1.f\n", "Cluster Count: %1.f", " | Latest Time: %.1f\n"
	},
	{
		"RADAR_TARGET_COUNT","DEBUG_CLUSTER_COUNT", "DEBUG_CLUSTER_LATEST_TIME"
	},
	{
		{AnimalControllor.textUsingParameter, 0, 0},
		{AnimalControllor.textUsingParameter, 1, 1},
		{AnimalControllor.textUsingParameter, 2, 2}
	}
)

--6【新增：动态 DLZ 调试文本】
-- 当 WS_DLZ_AUTH_DYN == 1 时显示三值
AddText(
    nil, nil,
    'unicode_cn_yellow',
    {0, -0.6 * Height},          -- HMD 底部上方
    Align.CC,
    DEFAULT_FONT_SIZE[2],
    nil,
    debug_Level,
    base_simple,
    { "DLZ[D]: min=%.1f KM ","best=%.0f KM ","max=%.0f KM ","D_min=%.1f KM ","D_max=%.0f KM","\nMissionStarted:%5.1f s" },
    {
        "WS_DLZ_MIN_DYN",         -- 第0项
        "WS_DLZ_BEST_DYN",        -- 第1项
        "WS_DLZ_MAX_DYN",         -- 第2项
        "WS_DLZ_MIN_KM",          -- 第3项，用于开启/关闭
		"WS_DLZ_MAX_KM"
    },
    {
        {AnimalControllor.textUsingParameter,        0, 0},  -- min
        {AnimalControllor.textUsingParameter,        1, 1},  -- best
        {AnimalControllor.textUsingParameter,        2, 2},  -- max
		{AnimalControllor.textUsingParameter,        3, 3},	 -- D_min
		{AnimalControllor.textUsingParameter,        4, 4}	 -- D_max
    }
)
]]
--------------------------------------------------------------------------------
--[[【HMD 显示调试信息：导弹 TOF 槽位状态】（参考动态 DLZ 写法）
--------------------------------------------------------------------------------

-- 1. 定义槽位数（要和 weapon_system.lua 保持一致）
local MAX_MSL_SLOTS = 6

-- 2. 在文件开头确保能用到这些：  
--    debug_Level, base_simple, DEFAULT_FONT_SIZE, Height, Width, Align, AnimalControllor

-- 3. 逐槽生成调试文本（末尾插入到现有 AddText 调用之后即可）
for i = 1, MAX_MSL_SLOTS do
    local yPos =  -0.7 * Height - (i-1) * 0.08 * Height  -- 自行调整行间距和起始位置
    AddText(
        nil, nil,
        'unicode_cn_yellow',
        { -0.9 * Width,  yPos },             -- 左对齐从屏幕左侧向右偏移
        Align.LC,                              -- 左对齐
        DEFAULT_FONT_SIZE[4],
        nil,
        debug_Level,
        base_simple,
        {
            string.format("M%d L=", i),       -- 发射标志前缀
            " %.0f  ",                       -- LAUNCHED
            "TOF=%.1f",                  -- TOF
            "  EL=%.1f",                -- ELAPSED
			"  REMAIN=%.1f"
        },
        {
            "HMD_MSL"..i.."_LAUNCHED",       -- idx 0
            "HMD_MSL"..i.."_LAUNCHED",       -- idx 1 (复用显示0/1)
            "HMD_MSL"..i.."_TOF",            -- idx 2
            "HMD_MSL"..i.."_ELAPSED",         -- idx 3
			"HMD_MSL"..i.."_REMAIN"
        },
        {
            { AnimalControllor.textUsingParameter, 0, 0 },  -- L
            { AnimalControllor.textUsingParameter, 1, 1 },  -- L（重复，仅占位）
            { AnimalControllor.textUsingParameter, 2, 2 },  -- TOF
            { AnimalControllor.textUsingParameter, 3, 3 },   -- ELAPSED
			{ AnimalControllor.textUsingParameter, 4, 4 }
        }
    )
end
]]
--------------------------------------------------------------------------------
--【HMD 显示调试信息：IFF状态】
--------------------------------------------------------------------------------
do
    local yPos =  -0.7 * Height   -- 自行调整行间距和起始位置
    local xPos = -0.9 * Width               -- 左对齐从屏幕左侧向右偏移
    AddText(
        nil, nil,
        'unicode_cn_yellow',
        { xPos,  yPos },             -- 左对齐从屏幕左侧向右偏移
        Align.LC,                              -- 左对齐
        DEFAULT_FONT_SIZE[1],
        nil,
        debug_Level,
        base_simple,
        {
            "IFF_STATUS:%.0f\n",
            "IFF_INTERROGATOR_STATUS:%.0f"
        },
        {
            "IFF_STATUS",
            "IFF_INTERROGATOR_STATUS"
        },
        {
            { AnimalControllor.textUsingParameter, 0, 0 },  -- L
            { AnimalControllor.textUsingParameter, 1, 1 }
        }
    )
end
--------------------------------------------------------------------------------
IGNORE_BRT = false
--------------------------------------------------------------------------------