-------------------------------------------------------------------------------
-- Page: flight_info_page.lua
-- Description: 飞行信息页面,主要是显示飞行信息和武器信息、TOF等静态内容
-------------------------------------------------------------------------------
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local Level         = DEFAULT_LEVEL + 1
local Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 1

AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)

--IS_HUD = false
local N=6
local base_simple = AddSimple(nil,{0,0,-N})
local x_scale = (10-N)/10
local y_scale = (10-N)/10

local boxa=0.2*Width
--位置常驻信息类
--左上角
--全程最大过载显示
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,1.05*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'GM:%.0f'},{'MAX_G'},{{'text_using_parameter',0}})
--过载
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,0.95*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'G:%.1f'},{'OVER_G'},{{'text_using_parameter',0}})
--攻角
AddText(nil,nil,'unicode_cn_green',{-0.9*Width,0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'攻角:%.1f','%s'},{'AOA_DEG'},{{'text_using_parameter',0}})
--侧滑角
AddText(nil,nil,'unicode_cn_green',{ 0*Width,1.1*Height},nil,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,{'侧滑:%.1f','%s'},{'AOS_DEG'},{{'text_using_parameter',0}})
--左下角
--右上角
--显示最大Range
AddText(nil,nil,'unicode_cn_green',{0.8*Width,0.95*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
    {'MAX:%.0f'},
	{'MAX_RANGE','ATK_MODE','GUN_MODE'},
    {
        {AnimalControllor.textUsingParameter, 			0 },
        {AnimalControllor.parameterCompareWithNumber,	1,1 },
    	{AnimalControllor.parameterCompareWithNumber,	2,0 }
	}
)
--右下角
--右下航点显示第一行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.75*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
    {'%s'},
    {
        'TARGET_NAME',
        'NAV_MODE',
		'ATK_MODE'
    },
	{
        {AnimalControllor.textUsingParameter,			0},
        {AnimalControllor.parameterCompareWithNumber,	1,1},
		{AnimalControllor.parameterCompareWithNumber,	2,0}
    }
)
--右下航点显示第二行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.85*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
    {'%02.0f:','%02.0f:','%02.0f+','%.0f'},
    {
        'TARGET_ETA_HH',
        'TARGET_ETA_mm',
        'TARGET_ETA_ss',
        'TARGET_ETA_dd',
        'NAV_MODE',
		'ATK_MODE'
    },
	{
        {AnimalControllor.textUsingParameter,0,0},
        {AnimalControllor.textUsingParameter,1,1},
        {AnimalControllor.textUsingParameter,2,2},
        {AnimalControllor.textUsingParameter,3,3},
        {AnimalControllor.parameterCompareWithNumber,4,1},
		{AnimalControllor.parameterCompareWithNumber,5,0}
    }
)
--右下航点显示第三行
AddText(nil,nil,'unicode_cn_green',{0.65*Width,-0.95*Height},Align.LC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,
    {'导航模式:%s'},
    {
        'NAV_TYPE',
        'ATK_MODE'
    },
	{
        {AnimalControllor.textUsingParameter,0},
        {AnimalControllor.parameterCompareWithNumber,1,0}
    }
)
-----------------------------------------------------------------
--中间的Pullup 告警
AddCrossHair(nil,0.5*Width,0.5*Width,0.006*Width,nil,{45,0},'DBG_YELLOW',nil,Level,base_simple,{'PULLUP_FLASH'},{{'parameter_in_range',0,0,1.1}})
-----------------------------------------------------------------
--STT文字
AddText(nil,'STT','unicode_cn_red',{0*Width,0.15*Height},Align.CC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
        { AnimalControllor.parameterCompareWithNumber, 	1,3},
		{ AnimalControllor.parameterCompareWithNumber,	2,1}
	}
)
--武器信息类
AddText(nil,'SAFE','unicode_cn_red',{0*Width,0*Height},Align.CC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,nil,
	{
		'MASTER_MODE',"HELMET_IN_HUD"
	},{
        { AnimalControllor.parameterCompareWithNumber, 	0,0},
		{ AnimalControllor.parameterCompareWithNumber,	1,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{1.1*Width, -0.1*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,
    {'%s X ','%.0f'},
    {
		'WEAPON_NAME',
		'WEAPON_COUNT',
		'WEAPON_NAME_DIS',
		'ATK_MODE',
		'GUN_MODE'
	},
    {
        {AnimalControllor.textUsingParameter,			0,0},
        {AnimalControllor.textUsingParameter,			1,1},
        {AnimalControllor.parameterInRange,				2,0.5,1.1},
		{AnimalControllor.parameterInRange,				3,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,	4,0}
    }
)

AddText(nil,nil,'unicode_cn_green',{1.1*Width, -0.1*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,
    {'%s X ','%.0f'},
    {
		'GUN_NAME',
		'GUN_COUNT',
		'ATK_MODE',
		'GUN_MODE'
	},
    {
        {AnimalControllor.textUsingParameter,			0,0},
        {AnimalControllor.textUsingParameter,			1,1},
		{AnimalControllor.parameterInRange,				2,0.9,2.1},
        {AnimalControllor.parameterCompareWithNumber,	3,1}
    }
)
---------------------------------------------------------------------
-- TOF区
-- TOF 同心表盘
do
    local MAX_TOF     	= 150               	-- 刻度上限（秒）
    local ANGLE_PER_S   = 300 / MAX_TOF     	-- 每秒对应角度    
	local R_w			= 0.05 * Width			-- 表盘线径
    local LINE_WIDTH    = 0.005 * Width       	-- 指针宽度
    local Y_TOF         = 0.5 *Height    		--  Y 中心线
	local X_TOF         = 0.5 *Width   			--  X 中心线
    local R_START       = 1 * boxa    			-- 第1 槽 X 起点（左侧）
    local R_STEP        = 0.075 * Height     	-- 每槽间距
	local LINE_color	= 'DBG_YELLOW'			-- 指针颜色
	local Ring_color    = 'DBG_GREEN'     		-- 表盘颜色
	local Ring_h_color	= 'DBG_RED'				-- 表盘高亮区颜色
	local Text_color	= 'hud_font_base'		-- 文字颜色
	local LVL 			= Level
    local Parent_item   = base_simple
	for i = 1, 6 do
		local R_off = R_START + (i-1) * R_STEP  -- 第1槽最内侧，依次向外排列
		-- 1. 在 Top 页创建一个定位容器容器
		local tofsim = AddSimple(nil,{X_TOF,Y_TOF},nil,
			Parent_item,
			{'HMD_MSL' .. i .. '_REMAIN'},
			{{ AnimalControllor.parameterInRange, 0, 0.099, MAX_TOF*1.2 }}
		)

		-- 2. 绘制外圈和内圈（与 rpmGauge 圆环样式一致）
		AddCircle(nil,R_off, R_off-R_w, 270, 36, nil, {-30, 0},	Ring_color,	h_clip_relations.COMPARE,	LVL, tofsim)
		AddCircle(nil,R_off, R_off-R_w,  30, 36, nil, {0, 0},	Ring_h_color,h_clip_relations.COMPARE,	LVL, tofsim)

		-- 3. TOF 指针：旋转角度根据倒计时百分比改变（假设 MAX_TOF 秒对应一圈）
		AddSimpleLine(
			nil,
			LINE_WIDTH,
			{{0, 0}, {0, R_off}},
			nil, nil,
			LINE_color,
            h_clip_relations.COMPARE,
			LVL,
			tofsim,
			{'HMD_MSL'..i..'_REMAIN'},  -- 自定义的倒计时数值参数
			{
				{ AnimalControllor.rotateUsingParameter,0,math.rad(-ANGLE_PER_S) }  -- 每秒逆时针转一小段
			}
		)

		-- 4. 数字倒计时显示（秒 ）
		local tof_text = AddText(
			nil, nil,
			Text_color,
			{-0* boxa, R_off-R_w/2},
			Align.RC,
			DEFAULT_FONT_SIZE[3],
			h_clip_relations.COMPARE,
			LVL,
			tofsim,
			{'%.1f'},	--秒				
			{'HMD_MSL' .. i .. '_REMAIN'},    -- 同上参数
			{
				{ AnimalControllor.textUsingParameter, 0 }
			}
		)
	end
end
