-------------------------------------------------------------------------------
----- Page: nav_page.lua
----- Description: 导航页面,主要是显示航路点、目标航路点、
----- 以及目标航路点的距离、名称等信息
----- TARGET_WPT_TYPE:0=转向点，1=降落点，2=攻击点
----- ATK_MODE:0=NAV，1=AA，2=AG
-------------------------------------------------------------------------------
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
--dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
--dofile(LockOn_Options.script_path.."utils.lua")

local Level         = DEFAULT_LEVEL + 4
local Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 4

AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)

--IS_HUD = false
local N=2
local base_simple = AddSimple(nil,{0,0,-N})
local x_scale = (10-N)/10
local y_scale = (10-N)/10

local boxSize  = 0.08 * Width		-- RWR 框高度
local boxThk   = 0.01 * Width		-- RWR 框线厚度

--目标航路点
--------------------------------------------------------------------------------
IGNORE_BRT = true --使用自定义的透明度控制
--------------------------------------------------------------------------------
local pointparams= {'HMD_TARGET_WPT_EL','HMD_TARGET_WPT_AZ','TARGET_WPT_TYPE','ATK_MODE','NAV_MODE'}
local targetWpt_sim = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,1}})
--NAV_MODE: ATK_MODE==0
--导航点锚点
local NAV_simple = AddSimple(nil,nil,nil,targetWpt_sim,pointparams,
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0, y_scale },	--Y按HMD_TARGET_WPT_EL偏移
		{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },	--X按HMD_TARGET_WPT_AZ偏移
		{ AnimalControllor.parameterInRange, 			2, -0.1, 0.1 },	--TARGET_WPT_TYPE==0
		{ AnimalControllor.parameterCompareWithNumber,	3,0},			--ATK_MODE==0
		{ AnimalControllor.parameterCompareWithNumber,	4,1},			--NAV_MODE==1
	}
)
local NAVWpt = AddCircle(nil,boxSize,boxSize-0.01*Width,360,18,nil,nil,'DBG_BLUE',nil,Level,NAV_simple,
	{'ATK_MODE'},
	{
		{AnimalControllor.parameterCompareWithNumber,	0,0}
	}
)
AddText(nil,nil,'unicode_cn_white',{boxSize,0*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,NAVWpt,
	{'%s'},
	{'TARGET_WPT_RANGE','ATK_MODE'},
	{
		{ AnimalControllor.textUsingParameter,			0},
		{ AnimalControllor.parameterCompareWithNumber,	1,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{-boxSize,0*Height},Align.RC,DEFAULT_FONT_SIZE[3],nil,Level,NAVWpt,
	{'%s'},
	{'TARGET_NAME','ATK_MODE'},
	{
		{ AnimalControllor.textUsingParameter,			0},
		{ AnimalControllor.parameterCompareWithNumber,	1,0}
	}
)
AddText(nil,'背面','unicode_cn_yellow',{0,0},nil,DEFAULT_FONT_SIZE[3],nil,Level,NAVWpt,
	{'%s'},{'HMD_TARGET_WPT_BEHIND'},{{AnimalControllor.parameterCompareWithNumber,0,1}})
--降落点
local LAND_simple = AddSimple(nil,nil,nil,targetWpt_sim,pointparams,
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0, y_scale },	--Y按HMD_TARGET_WPT_EL偏移
		{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },	--X按HMD_TARGET_WPT_AZ偏移
		{ AnimalControllor.parameterInRange, 			2, 0.9, 1.1 },	--TARGET_WPT_TYPE==1
		{ AnimalControllor.parameterCompareWithNumber,	3,0},			--ATK_MODE==0
		{ AnimalControllor.parameterCompareWithNumber,	4,1},			--NAV_MODE==1
	}
)
local landingWpt = AddCircle(nil,boxSize,boxSize-0.01*Width,360,18,nil,nil,'DBG_WHITE',nil,Level,LAND_simple)
AddBox(nil,1.2*boxSize,boxSize/4,{0,0},nil,'DBG_WHITE',Level,nil,LAND_simple)
AddText(nil,nil,'unicode_cn_white',{1.2*boxSize,0*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,landingWpt,
	{'%s'},{'TARGET_WPT_RANGE'},{{ AnimalControllor.textUsingParameter,	0}})
AddText(nil,nil,'unicode_cn_white',{-1.2*boxSize,0*Height},Align.RC,DEFAULT_FONT_SIZE[3],nil,Level,landingWpt,
	{'%s'},	{'TARGET_NAME'},{{ AnimalControllor.textUsingParameter,	0}})
AddText(nil,'背面','unicode_cn_yellow',{0,boxSize},nil,DEFAULT_FONT_SIZE[3],nil,Level,landingWpt,
	{'%s'},{'HMD_TARGET_WPT_BEHIND'},{{AnimalControllor.parameterCompareWithNumber,0,1}})

--对地模式:ATK_MODE==2
--导航点锚点
local AG_simple = AddSimple(nil,nil,nil,targetWpt_sim,pointparams,
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0, y_scale },	--Y按HMD_TARGET_WPT_EL偏移
		{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },	--X按HMD_TARGET_WPT_AZ偏移
		{ AnimalControllor.parameterInRange, 			2, -0.1, 1.1 },	--TARGET_WPT_TYPE==0 or 1
		{ AnimalControllor.parameterCompareWithNumber,	3,2},			--ATK_MODE==2
		{ AnimalControllor.parameterCompareWithNumber,	4,1},			--NAV_MODE==1
	}
)
local targetWpt = AddCircle(nil,boxSize,boxSize-0.01*Width,360,18,nil,nil,'DBG_GREEN',nil,Level,AG_simple)
AddText(nil,nil,'unicode_cn_white',{0.08*Width,0*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,targetWpt,
	{'%s'},{'TARGET_WPT_RANGE'},{{AnimalControllor.textUsingParameter,0}})
AddText(nil,nil,'unicode_cn_green',{-0.08*Width,0*Height},Align.RC,DEFAULT_FONT_SIZE[3],nil,Level,targetWpt,
	{'%s'},{'TARGET_NAME'},{{AnimalControllor.textUsingParameter,0}})
AddText(nil,'背面','unicode_cn_yellow',{0,0},nil,DEFAULT_FONT_SIZE[3],nil,Level,targetWpt,
	{'%s'},{'HMD_TARGET_WPT_BEHIND'},{{AnimalControllor.parameterCompareWithNumber,0,1}})
-- 攻击点锚点
local Attck_simple = AddSimple(nil,nil,nil,targetWpt_sim,pointparams,
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0, y_scale },
		{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },
		{ AnimalControllor.parameterInRange, 			2, 1.1, 2.1 },	--TARGET_WPT_TYPE==2
		{ AnimalControllor.parameterCompareWithNumber,	3,2},			--ATK_MODE==2
		{ AnimalControllor.parameterCompareWithNumber,	4,1},			--NAV_MODE==1
	}
)
AddBoxBorder(nil,boxSize * math.sqrt(2)/2, boxSize * math.sqrt(2)/2, boxThk,nil, {45, 0}, "DBG_RED",Level, nil, Attck_simple)
AddText(nil,nil,'unicode_cn_red',{boxSize,0*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,Attck_simple,
	{'%s'},{'TARGET_WPT_RANGE'},{{ AnimalControllor.textUsingParameter,0}})
AddText(nil,nil,'unicode_cn_white',{-boxSize,0*Height},Align.RC,DEFAULT_FONT_SIZE[3],nil,Level,Attck_simple,
	{'%s'},{'TARGET_NAME'},{{ AnimalControllor.textUsingParameter,0}})
AddText(nil,'背面','unicode_cn_yellow',{0,0},nil,DEFAULT_FONT_SIZE[3],nil,Level,Attck_simple,
	{'%s'},{'HMD_TARGET_WPT_BEHIND'},{{AnimalControllor.parameterCompareWithNumber,0,1}})