-------------------------------------------------------------------------------
-- Page: rwr_page.lua
-- Description: RWR目标的显示
-------------------------------------------------------------------------------
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
--dofile(LockOn_Options.script_path.."cockpit_cfg.lua")
--dofile(LockOn_Options.script_path.."utils.lua")

local Level         = DEFAULT_LEVEL + 3
local Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 3

AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)

--IS_HUD = false

local N=1
local base_simple = AddSimple(nil,{0,0,-N})
local x_scale = (10-N)/10
local y_scale = (10-N)/10

--------------------------------------------------------------------------------
IGNORE_BRT = true --使用自定义的透明度控制
--------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- RWR 目标显示（三种形态）
-------------------------------------------------------------------------------
local rwrCount = 20					-- 与 Rwr.lua 中定义的最大联系人数量保持一致
local boxSize  = 0.08 * Width		-- RWR 框高度
local boxThk   = 0.01 * Width		-- RWR 框线厚度

for ia = 1, rwrCount do
    -- 参数句柄名
	local numP    = string.format("%02d",									ia)
    local elevP   = string.format("HMD_RWR_%02d_Y",							ia)
    local azimP   = string.format("HMD_RWR_%02d_X",							ia)
    local powerP  = string.format("RWR_CONTACT_%02d_POWER_SYM",				ia)
    local signalP = string.format("RWR_CONTACT_%02d_SIGNAL",				ia)
	local typeP	  = string.format("RWR_CONTACT_%02d_UNIT_TYPE",				ia)
	local behindP = string.format("HMD_RWR_%02d_BEHIND",					ia)
	local isNumP  = string.format("RWR_CONTACT_%02d_UNIT_TYPE_IS_NUMERIC",	ia)
	local colorP  = string.format("RWR_CONTACT_%02.0f_COLOR",				ia)

    -- 通用列表：0=Elev,1=Azim,2=Power,3=Signal
    local params = { elevP, azimP, powerP, signalP, colorP, typeP, isNumP }
	local rwr_simple = AddSimple(nil,nil,nil,base_simple,params,
		{
            { AnimalControllor.moveUpDownUsingParameter,    0, y_scale },
			{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },
			{ AnimalControllor.parameterInRange,            2, 0.1, 1.1 },
            { AnimalControllor.parameterInRange, 			3, 0.9, 3.1 }  -- signal==1or2or3
        }
	)
    -- 1) Search: 正方形
    local search_box = AddBoxBorder(
        nil,
        boxSize, boxSize, boxThk,
        nil, nil, "DBG_PURPLE",
        Level, nil, rwr_simple
    )

    -- 2) Lock: 红色 45° 旋转正方形
	local lock_box = AddBoxBorder(
        nil,
        boxSize * math.sqrt(2)/2, boxSize * math.sqrt(2)/2, boxThk,
        nil, {45, 0}, "DBG_RED",
        Level, nil, search_box,
        {signalP},
        {
            { AnimalControllor.parameterInRange,			0, 1.9, 3.1 }  -- signal==2or3
        }
    )

    -- 3) Launch: 外接圆
    local launch_circle = AddCircle(
        nil,
        boxSize,          -- 外接圆半径
        boxSize - boxThk, -- 内环半径留出框线厚度
        360, 32,
        nil, nil,
        "DBG_RED",
        h_clip_relations.COMPARE, Level, lock_box,
        { signalP,isNumP },
        {
            { AnimalControllor.parameterCompareWithNumber,	0, 3 }, -- signal==3
			{ AnimalControllor.parameterInRange,           1, 0.75, 1.1 }  -- isNumP > 0.75
        }
    )
	AddText(
		nil,
		nil,
		'unicode_cn_purple',			-- 使用紫色文字( unicode_cn_purple )
		{0, boxSize},				-- 文字显示的位置，相对于方块，可根据需求调整
		Align.CB,							-- 对齐
		DEFAULT_FONT_SIZE[1],			-- 字体大小
		nil,
		Level,
		rwr_simple,
		{
			"%s"
		},
		{
			typeP,signalP				-- RWR目标的 UNIT_TYPE 参数
		},
		{
			{ AnimalControllor.textUsingParameter,			0, 0 },
			{ AnimalControllor.parameterCompareWithNumber,	1, 1 }  -- signal==1
		}
	)

	AddText(
		nil,
		nil,
		'unicode_cn_red',				-- 使用红色文字（unicode_cn_red）
		{0, 0 * Height},
		nil,
		DEFAULT_FONT_SIZE[1],
		nil,
		Level,
		rwr_simple,
		{
			numP.."%s\n\n\n\n锁定"
		},
		{
			typeP,signalP
		},
		{
			{ AnimalControllor.textUsingParameter, 			0, 0 },
			{ AnimalControllor.parameterCompareWithNumber,	1, 2 }  -- signal==2
		}
	)

	AddText(
		nil,
		nil,
		'unicode_cn_red',
		{0, 0 * Height},
		nil,
		DEFAULT_FONT_SIZE[1],
		nil,
		Level,
		rwr_simple,
		{
			numP.."%s\n\n\n\n发射"
		},
		{
			typeP,signalP,isNumP
		},
		{
			{ AnimalControllor.textUsingParameter, 			0, 0 },
			{ AnimalControllor.parameterCompareWithNumber,	1, 3 },  -- signal==3
			{ AnimalControllor.parameterInRange,           2, 0.75, 1.1 }
		}
	)
	-- 后半球文字标记
	AddText(nil,"背面",'unicode_cn_yellow',{0, 0 * Height},nil,DEFAULT_FONT_SIZE[1],nil,Level,rwr_simple,nil,{behindP},{{AnimalControllor.parameterCompareWithNumber, 0, 1}})
	-- —— 新增：右侧垂直 5 段式功率条 —— 
    local barSegments = 5
    local segH       = boxSize / barSegments
    local barW       = boxThk              -- 宽度同框线厚度
    local gapX       = boxThk * 2 --1.5        -- 与主框的水平间距
    for seg = 1, barSegments do
        local lowThr = (seg - 1) / barSegments + 0.01
        AddBoxBorder(
            nil,
            barW, segH,            -- 宽度、高度
            segH,                  -- thickness = segH → 实心填充
            { boxSize/2 + gapX*2 + barW,
              -boxSize/2 + (seg-0.5)*segH },
            nil, "DBG_WHITE",
            Level, nil, rwr_simple,
            { powerP },
            { { AnimalControllor.parameterInRange, 0, lowThr, 1.1 } }
        )
    end
end

--RWR 高优先度覆盖 
--工作在放大层因此对象尺寸和位移单位需要调整
local static_simple = AddSimple(nil,{0,0,-1})
x_scale = 9/10
y_scale = 9/10
local Count = 5			--最多支持5个
for i = 1, Count do
    local elevP   = string.format("HMD_RWR_%02d_Y",				i)
    local azimP   = string.format("HMD_RWR_%02d_X",				i)
    local powerP  = string.format("RWR_CONTACT_%02d_POWER_SYM",	i)
    local signalP = string.format("RWR_CONTACT_%02d_SIGNAL",	i)
	local params = { elevP, azimP, powerP, signalP }
	local rwr_hi_simple = AddSimple(nil,nil,nil,static_simple,params,
		{
            { AnimalControllor.moveUpDownUsingParameter,    0, y_scale },
			{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },
			{ AnimalControllor.parameterInRange,            2, 0.1, 1.1 },
            { AnimalControllor.parameterInRange, 			3, 0.9, 3.1 }  -- signal==1or2or3
        }
	)
	AddBox(nil,boxSize,boxSize,{0,0},nil,'LIGHT_SCREEN_COLOR',Level,nil,rwr_hi_simple)
end
--------------------------------------------------------------------------------
IGNORE_BRT = false --使用自定义的透明度控制
--------------------------------------------------------------------------------