-------------------------------------------------------------------------------
-- Page: sigh_page.lua
-- Description:STT目标环、DLZ框等动态显示对象，以及各个ACMLOCK扫描模式框的显示
-------------------------------------------------------------------------------
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local Level         = DEFAULT_LEVEL + 2
local Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 2

AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,Noclip_num*Width,Noclip_num*Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)

--IS_HUD = false

local base_simple = AddSimple(nil,{0,0,0})
local x_scale = 1
local y_scale = 1


--武器相关
--STT
local boxa=0.2*Width
local boxt=0.01*Width
local stt_box=AddBoxBorder(nil,boxa,boxa,boxt,nil,nil,'DBG_RED',Level,nil,base_simple,
	{
		'TARGET_BOX_DIS_ENABLE',
		'HMD_TARGET_BOX_Y',
		'HMD_TARGET_BOX_X',
		'HEAD_AZ'
	},
	{
		{AnimalControllor.parameterInRange,				0,0.01,1.1},
		{AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
		{AnimalControllor.moveLeftRightUsingParameter,	2,x_scale},
		{AnimalControllor.parameterInRange,				3,-60,60} -- 头向范围
	}
)
local stt_circle=AddCircle(nil,boxa,boxa-boxt,360,16,nil,nil,'DBG_RED',nil,Level,stt_box)
--STT连线
AddSimpleLine(nil,0.004*Width,{{0,0},{1,0}},nil,nil,'DBG_RED',nil,Level,base_simple,
    {
		'TARGET_BOX_DIS_ENABLE',
		'HMD_TARGET_BOX_X',
		'HMD_TARGET_BOX_Y',
		'HMD_TARGET_BOX_X_2',
		'HMD_TARGET_BOX_Y_2',
		'HEAD_AZ'
	},
    {
        {AnimalControllor.parameterInRange,0,0.01,1.1},
        {AnimalControllor.lineObjectSetPointUsingParameters,0,1,2,x_scale,y_scale},
        {AnimalControllor.lineObjectSetPointUsingParameters,1,3,4,x_scale,y_scale},
		{AnimalControllor.parameterInRange,				5,-60,60} -- 头向范围
    }
)
---------------------------------------------------------------------
-- 辅助函数：CreateTargetRangeText
-- 用于创建显示目标距离的文本元素。
-- 参数说明：
--   pos           - 显示位置（数组形式，例如 {-boxa, 0} 或 {0.65*Width, 0}）
--   parent        - 父元素（例如 stt_box 或 base_simple ）
--   fmtStr        - 格式化字符串（例如 '%.2fKM' 或 '%.2fNM'）
--   rangeParam    - 目标距离参数名称（例如 "TARGET_RANGE" 或 "TARGET_RANGE_NM"）
--   mappingRange2 - 对应第三个参数的区间设置（数组形式，例如 {-0.1, 0.1} 对 KM，{0.9, 1.1} 对 NM）
---------------------------------------------------------------------

local function CreateTargetRangeText(pos, parent, fmtStr, rangeParam, unit_value)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_red',   -- material
        pos,                -- 显示位置
        Align.CB,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[1],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        Level,          -- 层级（注意 Level 大小写）
        parent,             -- 父元素
        { fmtStr,' %s' },         -- 格式化输出数组（仅一项）
        {
            rangeParam,            	-- 第0项：目标距离（KM 或 NM）
			'TARGET_NCTR', 			-- 第1项：目标 NCTR
            'TARGET_BOX_DIS_ENABLE',-- 第2项
            'UNIT'                  -- 第3项
        },
        {
            {AnimalControllor.textUsingParameter,  	0,0},
			--{AnimalControllor.textUsingParameter,	1,1},
            {AnimalControllor.parameterInRange, 2,0.01,1.1},
            {AnimalControllor.parameterCompareWithNumber, 3, unit_value}
        }
    )
end

---------------------------------------------------------------------
-- 父元素为 stt_box
---------------------------------------------------------------------
CreateTargetRangeText({0,0.1*boxa}, stt_box, '%.2f', "TARGET_RANGE", 0)
CreateTargetRangeText({0,0.2*boxa}, stt_box, '%.2f', "TARGET_RANGE_NM", 1)
CreateTargetRangeText({0,1.4*boxa}, stt_box, '%s', 'TARGET_NCTR',0)
CreateTargetRangeText({0,1.4*boxa}, stt_box, '%s', 'TARGET_NCTR',1)
---------------------------------------------------------------------
-- 右侧区域，父元素为 base_simple
---------------------------------------------------------------------
CreateTargetRangeText({0, -0.4*Height}, base_simple, '%.2fKM', "TARGET_RANGE", 0)
CreateTargetRangeText({0, -0.4*Height}, base_simple, '%.2fNM', "TARGET_RANGE_NM", 1)

---------------------------------------------------------------------
-- 计算 DLZ 点或叉的显示
local scale = boxa * 0.09
local Pad = boxt*2

-- 显示各阶段数据 父元素为 stt_box
local function CreateDLZRangeText(pos, parent,fmtStr, rangeParam, unit_value)
    AddText(
        nil,                -- name
        nil,                -- val
        'unicode_cn_blue',   -- material
        pos,                -- 显示位置
        nil,					--Align.CB,           -- 对齐方式：居中底部对齐
        DEFAULT_FONT_SIZE[1],  -- 字符串尺寸
        nil,                -- _h_clip_relation
        Level,          -- 层级（注意 Level 大小写）
        parent,             -- 父元素
        { fmtStr },         -- 格式化输出数组（仅一项）
        { rangeParam ,'UNIT' },           	-- 第0项：目标距离（KM 或 NM）            
        { {AnimalControllor.textUsingParameter, 0},{AnimalControllor.parameterCompareWithNumber, 1, unit_value} }
    )
end

CreateDLZRangeText({ 1.0*boxa,1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_KM",0) 		--右上角 武器最大射程KM
CreateDLZRangeText({-1.2*boxa,1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_DYN",0) 		--左上角 动态最大射程KM
CreateDLZRangeText({   0*boxa,-0.5*boxa}, stt_box, '%.0f', "WS_DLZ_MARGIN_DYN",0)	--中间 动态最大拦截余量KM
CreateDLZRangeText({-1.2*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_BEST_DYN",0) 	--左下角 动态最佳射程KM
CreateDLZRangeText({ 1.4*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MIN_DYN",0)		--右下角 动态最小射程KM
CreateDLZRangeText({ 1.4*boxa, 0.8*boxa}, stt_box, '%.1f', "WS_DLZ_MIN_KM",0)		--右上角 武器最小射程KM

CreateDLZRangeText({ 1.0*boxa,1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_NM",1) 		--右上角 武器最大射程NM
CreateDLZRangeText({-1.2*boxa,1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MAX_DYN_NM",1) 	--左上角 动态最大射程NM
CreateDLZRangeText({   0*boxa,-0.5*boxa}, stt_box, '%.0f', "WS_DLZ_MARGIN_DYN_NM",1)--中间 动态最大拦截余量NM
CreateDLZRangeText({-1.2*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_BEST_DYN_NM",1) 	--左下角 动态最佳射程NM
CreateDLZRangeText({ 1.4*boxa,-1.2*boxa}, stt_box, '%.0f', "WS_DLZ_MIN_DYN_NM",1)	--右下角 动态最小射程NM
CreateDLZRangeText({ 1.4*boxa, 0.8*boxa}, stt_box, '%.1f', "WS_DLZ_MIN_NM",1)		--右上角 武器最小射程NM
--------------------------------------------------------------------------------
-- 1) “点”元素：红点
--------------------------------------------------------------------------------
local dlz_dot = AddCircle(
    nil,                -- name
    Pad,           		-- radius_outer
    0,                  -- radius_inner
    360, 16,            -- arc, sides
    nil, nil,           -- pos, rot（由 controllers 推动）
    "DBG_RED",       -- material
    h_clip_relations.COMPARE,
    Level,
    stt_box,        -- 父节点
    {
        "WS_DLZ_SHOW_X",   -- [0] 控制显示：0=点可见
        "WS_DLZ_DOT_Y",    -- [1] Y 偏移
        "WS_DLZ_DOT_X"     -- [2] X 偏移
    },
    {
        { AnimalControllor.parameterCompareWithNumber, 0, 0 },  -- WS_DLZ_SHOW_X==0 时显示
        { AnimalControllor.moveUpDownUsingParameter,    1, scale },  -- 用第1个句柄做垂直位移
        { AnimalControllor.moveLeftRightUsingParameter, 2, scale }   -- 用第2个句柄做水平位移
    }
)

--------------------------------------------------------------------------------
-- 2) “叉”元素：红叉
--------------------------------------------------------------------------------
local dlz_cross = AddCrossHair(
    nil,              -- name
    boxa, boxa, boxt,       -- width, height, thickness
    nil, {45,0},         -- pos, rot
    "DBG_RED",        -- material
    h_clip_relations.COMPARE,
    Level,
    stt_circle,      -- 父节点
    { "WS_DLZ_SHOW_X" },                              -- [0] 控制显示：1=叉可见
    { { AnimalControllor.parameterCompareWithNumber, 0, 1 } }
)

---------------------------------------------------------------------
--IR弹
AddCircle(nil,0.3*Width,0.29*Width,360,72,nil,nil,'DBG_YELLOW',nil,Level,base_simple,
	{'IR_SEEK_RANGE_DIS'},
    {
        {AnimalControllor.parameterCompareWithNumber,	0,1}
    }
)
AddCircle(nil,0.15*Width,0.14*Width,360,36,nil,nil,'DBG_RED',nil,Level,base_simple,
    {
        'HMD_TARGET_ROUND_DIS_ENABLE',
        'HMD_TARGET_ROUND_Y',
        'HMD_TARGET_ROUND_X'
    },
    {
    	{AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.moveUpDownUsingParameter,		1,y_scale},
        {AnimalControllor.moveLeftRightUsingParameter,	2,x_scale}
    }
)
AddCrossHair(nil,0.35*Width,0.35*Height,0.01*Width,nil,{45,0},'DBG_YELLOW',nil,Level,base_simple,
    {'IR_SEEK_RANGE_DIS','IR_SEEK_LIMIT'},
    {
        {AnimalControllor.parameterCompareWithNumber,	0,1},
        {AnimalControllor.parameterCompareWithNumber,	1,1}
    }
)

---------------------------------------------------------------------
--孔径
local apertureRadius = math.rad(1)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_GREEN',nil,Level,base_simple,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange, 			0,  2.9, 3.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
AddText(nil,'孔径','unicode_cn_green',{0.08*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,nil,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,	2.9,3.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
--长孔径
apertureRadius = math.rad(2.5)/HUD_EL*Width
AddCircle(nil,apertureRadius,apertureRadius-0.01*Width,360,36,nil,nil,'DBG_RED',nil,Level,base_simple,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,  1.9, 2.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,	1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,	1 }
	}
)
AddText(nil,'长孔径','unicode_cn_green',{0.08*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[1],nil,Level,base_simple,nil,
	{'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HELMET_IN_RADAR_SCAN'},
	{
		{ AnimalControllor.parameterInRange,			0,  1.9, 2.1 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,  1 },
		{ AnimalControllor.parameterCompareWithNumber,	3,  1 }
	}
)
--垂扫
IGNORE_BRT = true
apertureRadius = math.rad(4)/HUD_AZ*Width
local line_height = math.rad(45)/HUD_EL*Width
AddMultiLine(nil,nil,nil,
	{
		{-apertureRadius, line_height},
		{-apertureRadius,-line_height},
		{ apertureRadius, line_height},
		{ apertureRadius,-line_height},
		{-apertureRadius, line_height},
		{ apertureRadius, line_height},
		{-apertureRadius,-line_height},
		{ apertureRadius,-line_height}
	},{0,1,2,3,4,5,6,7},nil,nil,'DBG_GREEN',nil,nil,Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HEAD_AZ','HEAD_EL'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,4 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
		{ AnimalControllor.moveLeftRightUsingParameter,	3,math.rad(x_scale) },
		{ AnimalControllor.moveUpDownUsingParameter,	4,-math.rad(y_scale) }
	}
)
IGNORE_BRT = false
AddText(nil,'垂扫模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,4 },
		{ AnimalControllor.parameterInRange, 			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
	}
)
--平扫
IGNORE_BRT = true
apertureRadius = math.rad(5)/HUD_EL*Height
local line_width = math.rad(60)/HUD_AZ*Width
AddMultiLine(nil,nil,nil,
	{
		{-line_width, apertureRadius},
		{ line_width, apertureRadius},
		{-line_width,-apertureRadius},
		{ line_width,-apertureRadius},
		{-line_width, apertureRadius},
		{-line_width,-apertureRadius},
		{ line_width, apertureRadius},
		{ line_width,-apertureRadius}
	},{0,1,2,3,4,5,6,7},nil,nil,'DBG_GREEN',nil,nil,Level,base_simple,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE','HEAD_AZ','HEAD_EL'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,5 },
		{ AnimalControllor.parameterInRange,			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
		{ AnimalControllor.moveLeftRightUsingParameter,	3,math.rad(x_scale) },
		{ AnimalControllor.moveUpDownUsingParameter,	4,-math.rad(y_scale) }
	}
)
IGNORE_BRT = false
AddText(nil,'平扫模式','unicode_cn_green',{1.0*Width,-0.85*Height},Align.RC,DEFAULT_FONT_SIZE[4],nil,Level,base_simple,nil,
	{
		'RADAR_WORK_MODE','RADAR_MODE','ATK_MODE'
	},{
		{ AnimalControllor.parameterCompareWithNumber,	0,5 },
		{ AnimalControllor.parameterInRange,			1, -0.1, 2.1 },
		{ AnimalControllor.parameterCompareWithNumber,	2,1 },
	}
)

