--------------------------------------------------------------------------------
-- ROT:{roll,yaw,pitch} roll逆时针为正，yaw顺时针为正，pitch俯冲为正




--------------------------------------------------------------------------------
local test_switch = 0 --Render_debug_info
if test_switch == 0 then
	return
end
--------------------------------------------------------------------------------
dofile(LockOn_Options.script_path.."Displays/Helmet/Indicator/definitions.lua")
--dofile(LockOn_Options.script_path..'cockpit_cfg.lua')
dofile(LockOn_Options.script_path.."utils.lua")

local Level         = DEFAULT_LEVEL + 4
local Noclip_Level  = DEFAULT_NOCLIP_LEVEL + 4
AddBox(nil,20*Width,10*Height,nil,nil,'DBG_RED',Noclip_Level,REWRITE_LEVEL,nil,nil,nil,true)
AddBox(nil,20*Width,10*Height,nil,nil,'DBG_CLEAR',Noclip_Level,INCREASE_IF_LEVEL)

IS_HUD = false
--local z_simple = AddSimple(nil,{0,0,-6},{0,0},nil,{'HUD_Z'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.02}})
local n=0 --n越大，z轴越小，离眼睛越近，显示越大，偏移量就越小
local base_simple = AddSimple(nil,{0,0,-n}) --带有z轴偏移的全局锚层
local x_scale = (10-n)/10
local y_scale = (10-n)/10
local yaw_scale=math.rad(x_scale)
local pitch_scale=math.rad(y_scale)
local HEAD_AZ_sim = AddSimple(nil,nil,nil,base_simple,{'HEAD_AZ'},{{AnimalControllor.moveLeftRightUsingParameter,0,yaw_scale}})
local HEAD_EL_sim = AddSimple(nil,nil,nil,HEAD_AZ_sim,{'HEAD_EL'},{{AnimalControllor.moveUpDownUsingParameter,0,-pitch_scale}})
local ROLL_sim = AddSimple(nil,nil,nil,HEAD_EL_sim,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0}})
local PITCH_sim = AddSimple(nil,nil,nil,ROLL_sim,{'EADI_PITCH'},{{AnimalControllor.moveUpDownUsingParameter,0,-y_scale}})
local YAW_sim = AddSimple(nil,nil,nil,PITCH_sim,{'YAW'},{{AnimalControllor.moveLeftRightUsingParameter,0,-yaw_scale}})
base_simple=AddSimple(nil,nil,nil,YAW_sim)
--------------------------------------------------------------------------------
IGNORE_BRT = true --使用自定义的透明度控制
--------------------------------------------------------------------------------
--local demobox=AddBox(nil,3*Width,3*Height,{0,-5,20},{0,0,80},'TEST_MATERIAL',Level,nil,base_simple )
local demobox=AddBox(nil,0.3*Width,0.3*Height,{0,0,0},{0,0,0},'LIGHT_BLUE',Level,nil,base_simple )
AddText(nil,nil,'unicode_cn_red',{0,0*Height},nil,DEFAULT_FONT_SIZE[1],nil,Level,demobox,{'%.0f'},{'HEAD_HDG'},{{'text_using_parameter',0}})
--===============================
--[[ 雷达聚类目标显示模块（蓝色显示）
--===============================
-- 此处循环建立显示对象。循环次数可以使用 Targetnum 或者聚类目标数量（例如 clusterTargetCount）
--------------------------------------------------------------------------------
IGNORE_BRT = true --使用自定义的透明度控制
--------------------------------------------------------------------------------

for i = 1, Targetnum do
	-- 1. 用蓝色方块标识聚类目标位置
	local cluster_box = AddBoxBorder(
		nil,                                -- name
		0.075 * Width,                       -- 方块宽度
		0.075 * Width,                       -- 方块高度
		0.004 * Width,                      -- 边框厚度
		nil, nil,
		'DBG_WHITE',                         -- 材质使用蓝色（DBG_BLUE）
		Level,                          	-- 层级
		nil,
		HEAD_EL_sim,                        -- 父元素
		{
			string.format('RADAR_CONTACT_%02d_ELEVATION', i),          --0 用于获取Y坐标的参数名称
			string.format('RADAR_CONTACT_%02d_AZIMUTH', i),          --1 用于获取X坐标的参数名称
			string.format('RADAR_CONTACT_%02d_FRIENDLY', i),   --2 获取IFF属性
			string.format('RADAR_CONTACT_%02d_TIME', i),       --3 时间参数（同扫描目标类似）
			'ATK_MODE',                                             --4 攻击模式参数（直接传字符串即可）
		},
		{
			{AnimalControllor.moveUpDownUsingParameter,         0, y_scale},
			{AnimalControllor.moveLeftRightUsingParameter,      1, x_scale},
			{AnimalControllor.parameterCompareWithNumber,       2, 0},
			{AnimalControllor.parameterInRange,                 3, Life_time_low, Life_time},
			{AnimalControllor.parameterCompareWithNumber,       4, 1},
		}
	)
	-- 2. 在蓝色方块上附着文字信息，显示聚类目标的 id、range（单位 km）和 NCTR
	AddText(
		nil,
		nil,
		'unicode_cn_white',                  -- 使用蓝色文字（unicode_cn_blue）
		{0, 0 * Height},                 -- 文字显示的位置，相对于方块，可根据需求调整
		nil,                           -- 中间对齐
		DEFAULT_FONT_SIZE[4],               -- 字体大小
		nil,
		Level,
		cluster_box,                        -- 将文字依附于 blue 方块
		{
			i.."\n%1.f"
		},
		{
			string.format("RADAR_CONTACT_%02d_ID", i),       -- 聚类目标的 ID 参数
			--string.format("RADAR_CONTACT_%02d_RANGE_KM", i),   -- 聚类目标的距离，单位 km
			--string.format("RADAR_CONTACT_%02d_NCTR", i)        -- 聚类目标的 NCTR 参数
		},
		{
			{AnimalControllor.textUsingParameter, 0, 0},
			--{AnimalControllor.textUsingParameter, 1, 1},
			--{AnimalControllor.textUsingParameter, 2, 2}
		}
	)
end]]
--[[local boxSize  = 0.08 * Width		-- RWR 框高度
local boxThk   = 0.01 * Width		-- RWR 框线厚度

--目标航路点
--------------------------------------------------------------------------------
IGNORE_BRT = true --使用自定义的透明度控制
--------------------------------------------------------------------------------
local pointparams= {'HMD_TARGET_WPT_EL','HMD_TARGET_WPT_AZ','TARGET_WPT_TYPE','ATK_MODE','NAV_MODE'}
local targetWpt_sim = AddSimple(nil,nil,nil,base_simple,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0,1}})
--NAV_MODE: ATK_MODE==0
--导航点锚点
local NAV_simple = AddSimple(nil,nil,nil,targetWpt_sim,pointparams,
	{
		{ AnimalControllor.moveUpDownUsingParameter, 	0, y_scale },	--Y按HMD_TARGET_WPT_EL偏移
		{ AnimalControllor.moveLeftRightUsingParameter, 1, x_scale },	--X按HMD_TARGET_WPT_AZ偏移
		{ AnimalControllor.parameterInRange, 			2, -0.1, 0.1 },	--TARGET_WPT_TYPE==0
		{ AnimalControllor.parameterCompareWithNumber,	3,0},			--ATK_MODE==0
		{ AnimalControllor.parameterCompareWithNumber,	4,1},			--NAV_MODE==1
	}
)
local NAVWpt = AddCircle(nil,boxSize,boxSize-0.01*Width,360,18,nil,nil,'DBG_BLUE',nil,Level,NAV_simple,
	{'ATK_MODE'},
	{
		{AnimalControllor.parameterCompareWithNumber,	0,0}
	}
)
AddText(nil,nil,'unicode_cn_white',{boxSize,0*Height},Align.LC,DEFAULT_FONT_SIZE[3],nil,Level,NAVWpt,
	{'%s'},
	{'TARGET_WPT_RANGE','ATK_MODE'},
	{
		{ AnimalControllor.textUsingParameter,			0},
		{ AnimalControllor.parameterCompareWithNumber,	1,0}
	}
)
AddText(nil,nil,'unicode_cn_green',{-boxSize,0*Height},Align.RC,DEFAULT_FONT_SIZE[3],nil,Level,NAVWpt,
	{'%s'},
	{'TARGET_NAME','ATK_MODE'},
	{
		{ AnimalControllor.textUsingParameter,			0},
		{ AnimalControllor.parameterCompareWithNumber,	1,0}
	}
)
AddText(nil,'背面','unicode_cn_yellow',{0,0},nil,DEFAULT_FONT_SIZE[3],nil,Level,NAVWpt,
	{'%s'},{'HMD_TARGET_WPT_BEHIND'},{{AnimalControllor.parameterCompareWithNumber,0,1}})
]]