dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")
--dofile(LockOn_Options.script_path.."Systems/DLZCalculator.lua")

local HELMET 	    = GetSelf()

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)
-- 注册用于驱动显示的三个句柄
local h_show   = get_param_handle("WS_DLZ_SHOW_X")   -- 0=圆点，1=叉
local h_dot_x  = get_param_handle("WS_DLZ_DOT_X")    -- 圆点 X 偏移（HMD 坐标）
local h_dot_y  = get_param_handle("WS_DLZ_DOT_Y")    -- 圆点 Y 偏移
-- DLZ 数据句柄
local h_tgt_R	= get_param_handle("TARGET_RANGE")   -- km
local h_min_dyn	= get_param_handle("WS_DLZ_MIN_DYN") -- km
local h_best	= get_param_handle("WS_DLZ_BEST_DYN") -- km
local h_max		= get_param_handle("WS_DLZ_MAX_DYN") -- km
local h_min		= get_param_handle("WS_DLZ_MIN")	 -- m
local h_far		= get_param_handle("WS_DLZ_MAX")	 -- m

-- DLZ 句柄
local D_MIN_KM  = get_param_handle("WS_DLZ_MIN_KM")		--KM
local D_MAX_KM  = get_param_handle("WS_DLZ_MAX_KM")		--KM
local D_MIN_NM  = get_param_handle("WS_DLZ_MIN_NM")		--KM
local D_MAX_NM  = get_param_handle("WS_DLZ_MAX_NM")		--KM
local params_h = {
    HMD_TYPE = {get_param_handle('HMD_TYPE'),0},--HMD类型,0:HMS,1:NVG
}
-- 辅助函数
local function clamp(x, lo, hi)
    if x < lo then return lo elseif x > hi then return hi else return x end
end
local function lerp(a, b, t)
    return a + (b - a) * t
end

function post_initialize()
    HELMET:listen_event(CptEvntNames.setupNVG)
    HELMET:listen_event(CptEvntNames.setupHMS)
	HELMET:listen_command(Keys.hmdPwr)

    local birth = LockOn_Options.init_conditions.birth_place
    local birth_time_hours = LockOn_Options.time.hours	--获取初始化时间（小时）
	if birth=="GROUND_HOT" or birth=="AIR_HOT" then
        HELMET:performClickableAction(click_cmd.hmdPower,1)
        if birth_time_hours>=18 or birth_time_hours<=6 then
            HELMET:performClickableAction(click_cmd.hmdBrt,0.035)
        else
            HELMET:performClickableAction(click_cmd.hmdBrt,0.8)
        end
    elseif birth=="GROUND_COLD" then
		HELMET:performClickableAction(click_cmd.hmdPower,0)
        HELMET:performClickableAction(click_cmd.hmdBrt,0)
    end
end

function SetCommand(command,value)
    --DebugPrint('头盔：'..Get_command_name(command)..'..........'..value)

end

function update()

    -- 1. 读句柄缓存
    local R     = h_tgt_R:get()			-- 目标距离    
    local Rdyn  = h_min_dyn:get()      	-- 动态最小射程
    local Rbest = h_best:get()			-- 动态最佳射程
    local Rmax  = h_max:get()			-- 动态最大射程
    --转换为公里
	local Rmin  = h_min:get()/1000    	-- D_min 武器最小射程（公里）
	local Rfar 	= h_far:get()/1000     	-- D_max 武器最远射程（公里）
	--转换为海里
	local Rmin_NM = h_min:get()*Meter_TO_NM    	-- 武器最小射程（海里）
	local Rfar_NM = h_far:get()*Meter_TO_NM     -- 武器最远射程（海里）
	--回写句柄值
	D_MIN_KM:set(Rmin)
	D_MAX_KM:set(Rfar)
	D_MIN_NM:set(Rmin_NM)
	D_MAX_NM:set(Rfar_NM)
    -- 2. 常量几何——直接用数字
    local half = 1       -- 等价于 0.5*boxa
    local pad  = 0.2     -- 等价于 0.1*boxa

    -- 3. 计算显示状态与偏移
    --    state =  0 点, 1 叉
    local state, dx, dy = 0, 0, 0

	if Rmax > 0 then
        if     R <= Rmin then
            -- 区间 0：距离在静态最小以内 → 显示叉
            state = 1

        elseif R < Rdyn then
		--	Log_and_print(string.format("区间1"))
            -- 区间 1：Rmin < R < 动态最小 → 右侧外
            state = 0
            local t = clamp((R - Rmin) / (Rdyn - Rmin), 0, 1)
            dx =  half + pad
            dy =  lerp(half, -half, t)

        elseif R < Rbest then
		--	Log_and_print(string.format("区间2"))
            -- 区间 2：动态最小 ≤ R < 最佳 → 底部外
            state = 0
            local t = clamp((R - Rdyn) / (Rbest - Rdyn), 0, 1)
            dx =  lerp(half, -half, t)
            dy = -half - pad

        elseif R < Rmax then
		--	Log_and_print(string.format("区间3"))
            -- 区间 3：最佳 ≤ R < 最大 → 左侧外
            state = 0
            local t = clamp((Rmax - R) / (Rmax - Rbest), 0, 1)
            dx = -half - pad
            dy =  lerp(half, -half, t)

        elseif R < Rfar then
		--	Log_and_print(string.format("区间4"))
            -- 区间 4：最大 ≤ R < Rfar → 顶部外
            state = 0
            local t = clamp((R - Rmax) / (Rfar - Rmax), 0, 1)
            dx =  lerp(-half, half, t)
            dy =  half + pad
        end
    end

    -- 4. 写回显示驱动句柄
    h_show :set(state)    -- -1 隐藏，0 点，1 叉
    h_dot_x:set(dx)       -- “点”的 X 偏移
    h_dot_y:set(dy)       -- “点”的 Y 偏移

end



function CockpitEvent(event, val)
    if event == CptEvntNames.setupHMS then
        params_h.HMD_TYPE[2] = 0
    elseif event == CptEvntNames.setupNVG then
        params_h.HMD_TYPE[2] = 1
    end
end

need_to_be_closed = false