local contact_scale = 0.02
local pct_display_fill = 0.90*width

local RWR_Simp = AddSimple(nil,nil,nil,B_Page2_sim)

AddCrossHair(nil,0.05*width,0.05*width,0.005*width,nil,nil,'LIGHT_BLUE',nil,nil,B_Page2_sim)

AddCircle(nil,(pct_display_fill*0.2) + 0.005*width, (pct_display_fill*0.2) - 0.005*width, 360, 72,nil,nil,'DBG_WHITE',nil,nil,RWR_Simp)
AddCircle(nil,(pct_display_fill*0.6) + 0.005*width, (pct_display_fill*0.6) - 0.005*width, 360, 72,nil,nil,'DBG_WHITE',nil,nil,RWR_Simp)

-- CONTACT SYMBOLOGY

for ia = 1, 20 do
    local rwr_contact = AddSimple(nil,nil, nil, RWR_Simp,
        {
            string.format("RWR_CONTACT_%02.0f_AZIMUTH",ia),
            string.format("RWR_CONTACT_%02.0f_POWER_SYM",ia),
            string.format("RWR_CONTACT_%02.0f_SCAN_SYM",ia),
        },
        {
            { "rotate_using_parameter",       0, 1 },
            { "parameter_in_range",           1, 0.1,          1.09 },
            { "move_up_down_using_parameter", 2, contact_scale },
        })
    AddText(nil, nil, 'unicode_cn_white', nil, nil, DEFAULT_FONT_SIZE[6], nil, nil, rwr_contact, { '%s' },
        {
            string.format("RWR_CONTACT_%02.0f_UNIT_TYPE_SYM",ia),
            string.format("RWR_CONTACT_%02.0f_AZIMUTH",ia),
            string.format("RWR_CONTACT_%02.0f_UNIT_TYPE_IS_NUMERIC",ia),
            "RWR_PLACEHODER",
            "RWR_PLACEHODER",
            string.format("RWR_CONTACT_%02.0f_COLOR",ia),
        }, {
            { "text_using_parameter", 0, 0 },
            { "rotate_using_parameter",  1, -1 },
            { "parameter_in_range",      2, 0.1, 0.8 },
            --{"parameter_in_range", 4, 0.9, 1.1},
            YELLOW_CONTACT, RED_CONTACT, GREEN_CONTACT
        })
    AddText(nil, nil, 'unicode_cn_white', nil, nil, DEFAULT_FONT_SIZE[6], nil, nil, rwr_contact, { '%.f' },
        {
            string.format("RWR_CONTACT_%02.0f_UNIT_TYPE_SYM",ia),
            string.format("RWR_CONTACT_%02.0f_AZIMUTH",ia),
            string.format("RWR_CONTACT_%02.0f_UNIT_TYPE_IS_NUMERIC",ia),
            "RWR_PLACEHODER",
            "RWR_PLACEHODER",
            string.format("RWR_CONTACT_%02.0f_COLOR",ia),
        },
        {
            { "text_using_parameter",  0, 0 },
            { "rotate_using_parameter",  1, -1 },
            { "parameter_in_range",      2, 0.8, 1.09 },
            --{"parameter_in_range", 4, 0.9, 1.1},
            YELLOW_CONTACT, RED_CONTACT, GREEN_CONTACT
        })
end

AddText(nil,'RWR','unicode_cn_green',{-0.5*width,-0.85*height},nil,DEFAULT_FONT_SIZE[5],nil,nil,B_Page2_sim)

local txt=AddText(nil,'航\n向','unicode_cn_green',{0.9*width,0.7*height},nil,DEFAULT_FONT_SIZE[5],nil,nil,B_Page2_sim,nil,{'RWR_SHOW_HSI'},
{
    {AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,1,1,1},
}
)
AddBoxBorder(nil,0.1*width,0.2*height,0.010*width,nil,nil,FrameEdgeMaterial,nil,nil,txt,{'RWR_SHOW_HSI'},
{
    {AnimalControllor.parameterInRange,0,0.9,1.1}
})
-----------------------------------------
AddMeshPoly(nil,{{0.766356*width,-0.768747*height},{0.601763*width,-0.970537*height},{0.934214*width,-0.970537*height}},{0,1,2},nil,nil,'DBG_WHITE',nil,nil,B_Page2_sim)
AddMeshPoly(nil,{{0.766356*width,-0.783899*height},{0.637029*width,-0.946215*height},{0.901052*width,-0.946215*height}},{0,1,2},nil,nil,'LIGHT_BLUE',nil,nil,B_Page2_sim)