local eadiMaskLevel = DEFAULT_MASK_LEVEL
local eadi_sim = AddSimple(nil,{0.005*width,-0.11*height},nil,Page1_sim)

local eadi_w = width*0.495
local eadi_h = height*0.7
AddBox(nil,eadi_w,eadi_h,nil,nil,'DBG_RED',eadiMaskLevel,REWRITE_LEVEL,eadi_sim,nil,nil,true)

local eadiUpMaterial = MakeMaterial(nil, {5,154,172,255})
local eadiDnMaterial = MakeMaterial(nil, {171,142,16,255})

local eadiRot_sim = AddSimple(nil,nil,nil,eadi_sim,{'EADI_ROLL'},{{AnimalControllor.rotateUsingParameter,0}})
local eadiMove_sim = AddSimple(nil,nil,nil,eadiRot_sim,{'EADI_PITCH'},{{AnimalControllor.moveUpDownUsingParameter,0,-0.1345}})
AddBox(nil,eadi_w*4,eadi_h*10,{0,eadi_h*10},nil,eadiUpMaterial,eadiMaskLevel,nil,eadiMove_sim)
AddBox(nil,eadi_w*4,eadi_h*10,{0,-eadi_h*10},nil,eadiDnMaterial,eadiMaskLevel,nil,eadiMove_sim)
AddSimpleLine(nil,0.004*width,{{-0.5*width,0},{0.5*width,0}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,eadi_sim)

for i = 1, 18, 1 do
    local pos_y = 0.3*eadi_h*i
    AddSimpleLine(nil,0.01*eadi_w,{{-0.95*eadi_w,-0.07*eadi_h},{-0.95*eadi_w,0},{-0.1*eadi_w,0}},{0,pos_y},nil,'DBG_WHITE',nil,eadiMaskLevel,eadiMove_sim)
    AddSimpleLine(nil,0.01*eadi_w,{{0.95*eadi_w,-0.07*eadi_h},{0.95*eadi_w,0},{0.1*eadi_w,0}},{0,pos_y},nil,'DBG_WHITE',nil,eadiMaskLevel,eadiMove_sim)
    AddText(nil,tostring(i*5),'unicode_cn_white',{-0.85*eadi_w,pos_y-0.1*eadi_h},nil,DEFAULT_FONT_SIZE[5],nil,eadiMaskLevel,eadiMove_sim)
    AddText(nil,tostring(i*5),'unicode_cn_white',{0.85*eadi_w,pos_y-0.1*eadi_h},nil,DEFAULT_FONT_SIZE[5],nil,eadiMaskLevel,eadiMove_sim)

    for j = 1, 6, 1 do
        local startPntX = (-0.95+(j-1)*(0.08+0.04))*eadi_w
        local endPntX = startPntX + 0.08*eadi_w
        AddSimpleLine(nil,0.01*eadi_w,
            {
                {startPntX,0},
                {endPntX,0}
            },{0,-pos_y},nil,'DBG_WHITE',nil,eadiMaskLevel,eadiMove_sim
        )
        AddSimpleLine(nil,0.01*eadi_w,
            {
                {-startPntX,0},
                {-endPntX,0}
            },{0,-pos_y},nil,'DBG_WHITE',nil,eadiMaskLevel,eadiMove_sim
        )
    end
    AddSimpleLine(nil,0.01*eadi_w,
            {
                {(-0.95+6*(0.08+0.04))*eadi_w,0},
                {-0.1*eadi_w,0},{-0.1*eadi_w,0.07*eadi_h},
            },{0,-pos_y},nil,'DBG_WHITE',nil,eadiMaskLevel,eadiMove_sim
        )
    AddSimpleLine(nil,0.01*eadi_w,
        {
            {(0.95-6*(0.08+0.04))*eadi_w,0},
            {0.1*eadi_w,0},{0.1*eadi_w,0.07*eadi_h},
        },{0,-pos_y},nil,'DBG_WHITE',nil,eadiMaskLevel,eadiMove_sim
    )
    AddText(nil,tostring(i*5),'unicode_cn_white',{-0.85*eadi_w,-pos_y+0.1*eadi_h},nil,DEFAULT_FONT_SIZE[5],nil,eadiMaskLevel,eadiMove_sim)
    AddText(nil,tostring(i*5),'unicode_cn_white',{0.85*eadi_w,-pos_y+0.1*eadi_h},nil,DEFAULT_FONT_SIZE[5],nil,eadiMaskLevel,eadiMove_sim)
end
--------------
--速度
local spdSim=AddSimple('spdSim',{-eadi_w-0.1*width,0},nil,eadi_sim)
local frameW = 0.1*width
local frameH = eadi_h
AddBox('spdcutbase',frameW,frameH,nil,nil,'DBG_RED',eadiMaskLevel,REWRITE_LEVEL,spdSim,nil,nil,true)

local spdBarMoveSim = AddSimple('spdBarMoveSim',{0.375*frameW,0},nil,spdSim,{'AS'},{{AnimalControllor.moveUpDownUsingParameter,0,-0.0008689}})
AddSimpleLine('spdbar',0.005*width,{{0,0},{0,72*frameH}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,spdBarMoveSim)
local tickInterval = frameH/9
for i = 6, 600, 1 do --会生成大量的对象，导致VR静默崩溃，限制文字显示
    local scaleLength = 0.4*frameW
    local posY = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        AddText(nil,tostring(i*0.5),'unicode_cn_white',{-0.4*frameW,posY},Align.RC,DEFAULT_FONT_SIZE[6],nil,eadiMaskLevel,spdBarMoveSim,nil,{'VR_MODE'},{{AnimalControllor.parameterCompareWithNumber,0,0}})
        --AddText(nil,tostring(i*0.5),'unicode_cn_white',{-0.4*frameW,posY},Align.RC,DEFAULT_FONT_SIZE[6],nil,eadiMaskLevel,spdBarMoveSim)
    end
    AddSimpleLine(nil,0.005*width,{{0,posY},{-scaleLength,posY}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,spdBarMoveSim)
    --AddSimpleLine(nil,0.005*width,{{0,posY},{-scaleLength,posY}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,spdBarMoveSim,{'VR_MODE'},{{AnimalControllor.parameterCompareWithNumber,0,0}})
end

local spdFrameSim = AddSimple('spdFrameSim',{-0.1*width,0},nil,spdSim)

local frameBGCMaterial = MakeMaterial(nil,{0,32,0,255})
local frameEdgeMaterial = MakeMaterial(nil,{0,255,0,255})

local frameMaskLevel = eadiMaskLevel+1

AddMeshPoly('spdbarcutlayer',{
        {-0.11*width,0.04*height},{0.065*width,0.04*height},{0.065*width,-0.04*height},{-0.11*width,-0.04*height},
        {0.11*width,0}
    },{
        0,1,2,2,3,0,
        1,4,2
    },nil,nil,frameBGCMaterial,REWRITE_LEVEL,frameMaskLevel,spdFrameSim,nil,nil,true
)
AddMeshPoly('spdbarbase',{
        {-0.11*width,0.04*height},{0.065*width,0.04*height},{0.065*width,-0.04*height},{-0.11*width,-0.04*height},
        {0.11*width,0}
    },{
        0,1,2,2,3,0,
        1,4,2
    },nil,nil,frameBGCMaterial,nil,frameMaskLevel,spdFrameSim
)
AddSimpleLine('spdframeside',0.005*width,{{-0.11*width,0.04*height},{0.065*width,0.04*height},{0.11*width,0},{0.065*width,-0.04*height},{-0.11*width,-0.04*height},{-0.11*width,0.04*height}},nil,nil,frameEdgeMaterial,nil,frameMaskLevel,spdFrameSim)
AddText('spd','0000','unicode_cn_white',{-0.02*width,0},nil,DEFAULT_FONT_SIZE[6],nil,frameMaskLevel,spdFrameSim,{'%.0f'},
    {'AS'},{{AnimalControllor.textUsingParameter,0}}
)
------------------
--高度
local altSim=AddSimple('altSim',{eadi_w+0.1*width,0},nil,eadi_sim)
AddBox('altcutbase',frameW,frameH,nil,nil,'DBG_RED',eadiMaskLevel,REWRITE_LEVEL,altSim,nil,nil,true)

local altBarMoveSim = AddSimple('altBarMoveSim',{-0.375*frameW,0},nil,altSim,{'ALT'},{{AnimalControllor.moveUpDownUsingParameter,0,-0.00008689}})
AddSimpleLine('altBar',0.005*width,{{0,0},{0,40*frameH}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,altBarMoveSim)
for i = 0, 560, 1 do
    local scaleLength = 0.4*frameW
    local posY = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        AddText(nil,tostring(i*0.5),'unicode_cn_white',{0.4*frameW,posY},Align.LC,DEFAULT_FONT_SIZE[6],nil,eadiMaskLevel,altBarMoveSim,nil,{'VR_MODE'},{{AnimalControllor.parameterCompareWithNumber,0,0}})
    end
    AddSimpleLine(nil,0.005*width,{{0,posY},{scaleLength,posY}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,altBarMoveSim)
end

local altFrameSim = AddSimple('altFrameSim',{0.1*width,0},nil,altSim)

AddMeshPoly('altFrameCut',{
        {0.11*width,0.04*height},{-0.065*width,0.04*height},{-0.065*width,-0.04*height},{0.11*width,-0.04*height},
        {-0.11*width,0}
    },{
        0,1,2,2,3,0,
        1,4,2
    },nil,nil,frameBGCMaterial,REWRITE_LEVEL,frameMaskLevel,altFrameSim,nil,nil,true
)
AddMeshPoly('altFrameBG',{
        {0.11*width,0.04*height},{-0.065*width,0.04*height},{-0.065*width,-0.04*height},{0.11*width,-0.04*height},
        {-0.11*width,0}
    },{
        0,1,2,2,3,0,
        1,4,2
    },nil,nil,frameBGCMaterial,nil,frameMaskLevel,altFrameSim
)
AddSimpleLine('altFrameside',0.005*width,{{0.11*width,0.04*height},{-0.065*width,0.04*height},{-0.11*width,0},{-0.065*width,-0.04*height},{0.11*width,-0.04*height},{0.11*width,0.04*height}},nil,nil,frameEdgeMaterial,nil,frameMaskLevel,altFrameSim)
AddText('alt','00000','unicode_cn_white',{0.02*width,0},nil,DEFAULT_FONT_SIZE[6],nil,frameMaskLevel,altFrameSim,{'%.0f'},
    {'ALT'},{{AnimalControllor.textUsingParameter,0}}
)
------------
--航向
frameH = frameW
frameW = eadi_w
local hdgSim = AddSimple('hdgSim',{0,0.1*height+eadi_h},nil,eadi_sim)
AddBox('hdgBarcutbase',frameW,frameH,nil,nil,'DBG_RED',eadiMaskLevel,REWRITE_LEVEL,hdgSim,nil,nil,true)

local hdgBarMoveSim = AddSimple('hdgBarMoveSim',{0,-0.525*frameH},nil,hdgSim,{'HDG'},{{AnimalControllor.moveLeftRightUsingParameter,0,-0.000869}})
AddSimpleLine('hdgBar',0.005*width,{{-4*frameW,0},{12*frameW,0}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,hdgBarMoveSim)
--航向刻度条
for i = -24, 96, 1 do
    local scaleLength = 0.4*frameH
    local posX = i*tickInterval
    if math.fmod(i,2)~=0 then
        scaleLength = scaleLength*0.5
    else
        local hdg = i*0.5
        local v
        if hdg<0 then
            hdg = 36+hdg
        end
        if hdg == 0 or hdg == 36 then
            v = 'N'
        elseif hdg == 9 or hdg == 45 then
            v = 'E'
        elseif hdg == 18 or hdg == 54 then
            v = 'S'
        elseif hdg == 27 or hdg == 63 then
            v = 'W'
        elseif hdg > 36 then
            v = tostring(36-hdg)
        else
            v = tostring(hdg)
        end
        AddText(nil,v,'unicode_cn_white',{posX,0.4*frameH},Align.CB,DEFAULT_FONT_SIZE[6],nil,eadiMaskLevel,hdgBarMoveSim)
    end
    AddSimpleLine(nil,0.005*width,{{posX,0},{posX,scaleLength}},nil,nil,'DBG_WHITE',nil,eadiMaskLevel,hdgBarMoveSim)
end

local hdgFrameSim = AddSimple('hdgFrameSim',{0,0.065*height},nil,hdgSim)

AddMeshPoly('hdgFrameCut',{
        {-0.07*width,0.04*height},{0.07*width,0.04*height},{0.07*width,-0.04*height},{-0.07*width,-0.04*height},
        {-0.035*width,-0.04*height},{0.035*width,-0.04*height},{0,-0.08*height}
    },{
        0,1,2,2,3,0,
        4,5,6
    },nil,nil,frameBGCMaterial,REWRITE_LEVEL,frameMaskLevel,hdgFrameSim,nil,nil,true
)
AddMeshPoly('hdgFrameBG',{
        {-0.07*width,0.04*height},{0.07*width,0.04*height},{0.07*width,-0.04*height},{-0.07*width,-0.04*height},
        {-0.035*width,-0.04*height},{0.035*width,-0.04*height},{0,-0.08*height}
    },{
        0,1,2,2,3,0,
        4,5,6
    },nil,nil,frameBGCMaterial,nil,frameMaskLevel,hdgFrameSim
)
AddSimpleLine('hdgFrameSide',0.005*width,{{-0.07*width,0.04*height},{0.07*width,0.04*height},{0.07*width,-0.04*height},{0.035*width,-0.04*height},{0,-0.08*height},{-0.035*width,-0.04*height},{-0.07*width,-0.04*height},{-0.07*width,0.04*height}},
    nil,nil,frameEdgeMaterial,nil,frameMaskLevel,hdgFrameSim
)
AddText('hdg','000','unicode_cn_white',nil,nil,DEFAULT_FONT_SIZE[6],nil,frameMaskLevel,hdgFrameSim,{'%.0f'},
    {'HDG'},{{AnimalControllor.textUsingParameter,0}}
)
AddSimpleLine(nil,0.007*width,{{-eadi_w,0},{eadi_w,0}},nil,nil,'DBG_GREEN',nil,frameMaskLevel,eadi_sim,
{'ILS_GLIDESLOPE_DEVIATION','ILS_IS_OUTER_MARKER_SIGNAL','ILS_IS_MIDDLE_MARKER_SIGNAL','ILS_IS_INNER_MARKER_SIGNAL','ILS_IS_GLIDESLOPE_VALID','EADI_ILS'},
{
    {AnimalControllor.moveUpDownUsingParameter,0,-1},
    {AnimalControllor.changeColorWhenParameterEqualToNumber,1,1,0,1,0},
    {AnimalControllor.changeColorWhenParameterEqualToNumber,2,1,1,0.5,0},
    {AnimalControllor.changeColorWhenParameterEqualToNumber,3,1,1,0,0},
    {AnimalControllor.parameterCompareWithNumber,4,1},
    {AnimalControllor.parameterCompareWithNumber,5,1},
})
AddSimpleLine(nil,0.007*width,{{0,eadi_h},{0,-eadi_h}},nil,nil,'DBG_GREEN',nil,frameMaskLevel,eadi_sim,
{'ILS_LOCALIZER_DEVIATION','ILS_IS_LOCALIZER_VALID'},
{
    {AnimalControllor.moveLeftRightUsingParameter,0,1},
    {AnimalControllor.parameterInRange,1,0.9,1.1}
})
-----------------
local meterTxt = AddText(nil,'仪表','unicode_cn_white',{-0.411*width,0.925*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)
AddBoxBorder(nil,0.072*width,0.04*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,meterTxt)

local ilsTxt = AddText(nil,'ILS','unicode_cn_white',{0.411*width,0.925*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim,nil,
{'EADI_ILS'},{
    {AnimalControllor.changeColorWhenParameterEqualToNumber,0,0,0,1,0},
    {AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,1,1,1},
})
AddBoxBorder(nil,0.072*width,0.04*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,ilsTxt,
{'EADI_ILS'},{
    {AnimalControllor.parameterCompareWithNumber,0,1}
})

local autoTxt = AddText(nil,'自\n动','unicode_cn_white',{-0.93*width,0.56*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)
AddBoxBorder(nil,0.045*width,0.08*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,autoTxt)

local on = AddText(nil,'开','unicode_cn_white',{-0.9325*width,-0.227*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)
AddBoxBorder(nil,0.04*width,0.04*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,on)

AddText(nil,'指\n示','unicode_cn_white',{-0.9325*width,-0.397*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)

local off = AddText(nil,'关','unicode_cn_white',{-0.9325*width,-0.547*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)
AddBoxBorder(nil,0.04*width,0.04*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,off)

on = AddText(nil,'开','unicode_cn_white',{0.9325*width,-0.227*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)
AddBoxBorder(nil,0.04*width,0.04*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,on)

AddText(nil,'偏\n航','unicode_cn_white',{0.9325*width,-0.397*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)

off = AddText(nil,'关','unicode_cn_white',{0.9325*width,-0.547*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim)
AddBoxBorder(nil,0.04*width,0.04*height,0.007*width,nil,nil,frameEdgeMaterial,nil,nil,off)

AddText(nil,'设\n置','unicode_cn_green',{0.95*width,0.56*height},nil,DEFAULT_FONT_SIZE[6],nil,nil,Page1_sim,nil,{'EADI_SETTING_CLICK'},{
    {AnimalControllor.changeColorWhenParameterEqualToNumber,0,1,1,1,1}
})

AddMeshPoly(nil,{{-0.078*width,0},{0.078*width,0},{0,0.09*height}},{0,1,2},{-0.882*width,0.894*height},nil,'DBG_WHITE',nil,nil,Page1_sim)
AddMeshPoly(nil,{{-0.06*width,0},{0.06*width,0},{0,0.07*height}},{0,1,2},{-0.882*width,0.904*height},nil,'LIGHT_BLUE',nil,nil,Page1_sim)

AddMeshPoly(nil,{{-0.078*width,0.09*height},{0.078*width,0.09*height},{0,0}},{0,1,2},{0.882*width,0.894*height},nil,'DBG_WHITE',nil,nil,Page1_sim)
AddMeshPoly(nil,{{-0.06*width,0.07*height},{0.06*width,0.07*height},{0,0}},{0,1,2},{0.882*width,0.904*height},nil,'LIGHT_BLUE',nil,nil,Page1_sim)