dofile(LockOn_Options.script_path.."cockpit_cfg.lua")
dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."displays/MFD/indicator/pages.lua")

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)
local dayNight = 0 --0白天 1夜晚
local MFCD_BRT_value = 1

local MFCD = GetSelf()
local params_h = {
    MFCD_BRT = {get_param_handle('MFCD_BRT'),0,0,0.01},
    EADI_SETTING_CLICK = {get_param_handle('EADI_SETTING_CLICK'),0},
    EADI_ILS = {get_param_handle('EADI_ILS'),0},
    MFCD_Page = {get_param_handle('MFCD_PAGE'),Pages.BASE},
    P1_SUB_PAGE = {get_param_handle('P1_SUB_PAGE'),Pages[Pages.P1].BASE},
    B3_SUB_PAGE = {get_param_handle('B3_SUB_PAGE'),Pages[Pages.B3].BASE},
    B4_SUB_PAGE = {get_param_handle('B4_SUB_PAGE'),Pages[Pages.B4].BASE},
    eng_sw_click = {get_param_handle('ENG_SW_CLICK'),0},
    P2_SUB_PAGE = {get_param_handle('P2_SUB_PAGE'),Pages[Pages.P2].BASE},
    P4_SUB_PAGE = {get_param_handle('P4_SUB_PAGE'),Pages[Pages.P4].BASE},
    ST_TIME = {get_param_handle('ST_TIME'),0},
    ST = {get_param_handle('ST'),100},
    ST_ROT = {get_param_handle('ST_ROT'),0},
    ST_BIOS_TXT = {get_param_handle('BIOS_TXT'),''},
    MFCD_MASK = {get_param_handle('MFCD_MASK'),0},
    DAY_NIGHT = {get_param_handle('DAY_NIGHT'),0},
}
local step = 0

local elements = {
    EADI_AUTO = {'EADI_AUTO',false},
    EADI_SETUP = {'EADI_SETUP',false},
    EADI_IND_ON = {'EADI_IND_ON',false},
    EADI_IND_OFF ={'EADI_IND_OFF',false},
    EADI_YAW_ON = {'EADI_YAW_ON',false},
    EADI_YAW_OFF = {'EADI_YAW_OFF',false},
    EADI_ILS={'EADI_ILS',false},
    FCS_HOLD_ON= {'FCS_HOLD_ON',false},
    FCS_HOLD_OFF ={'FCS_HOLD_OFF',false},
    FCS_AUTO= {'FCS_AUTO',false},
    FCS_SETUP ={'FCS_SETUP',false},
    FCS_RESET ={'FCS_RESET',false},
    FCS_AUTO2= {'FCS_AUTO2',false},
    FCS_OVER ={'FCS_OVER',false},
    FCS_CAU= {'FCS_CAU',false},
    HSI_FY= {'HSI_FY',false},
    HSI_MENU ={'HSI_MENU',false},
    HSI_MAP= {'HSI_MAP',false},
    HSI_SCALE_UP= {'HSI_SCALE_UP',false},
    HSI_SCALE_DN= {'HSI_SCALE_DN',false},
    WPN_AAMODE= {'WPN_AAMODE',false},
    WPN_AGMODE= {'WPN_AGMODE',false},
    WPN_DOOR_ON= {'WPN_DOOR_ON',false},
    WPN_DOOR_AUTO={'WPN_DOOR_AUTO',false},
    ENG_SW= {'ENG_SW',false},
    MASTER_CAU= {'MASTER_CAU',false},
    FIRE_CAU= {'FIRE_CAU',false},
}

function post_initialize()
    MFCD:listen_command(Keys.P2_to_fcsPage)
    MFCD:listen_command(Keys.P2_to_radarPage)
    MFCD:listen_command(Keys.P2_to_flirPage)
    MFCD:listen_command(click_cmd.HudMFCD_change_dayNight)
	MFCD:listen_command(RightPanel_click_cmd.MFCDBrt)
	MFCD:listen_command(Keys.MFCD_BRT_Increase)
	MFCD:listen_command(Keys.MFCD_BRT_Decrease)
	MFCD:listen_command(JoyCmd.MFCD_BRT_Axis)

	--MFCD:performClickableAction(click_cmd.HudMFCD_change_dayNight,1,false)
	local birth_time_hours = LockOn_Options.time.hours	--获取初始化时间（小时）
    local birth = LockOn_Options.init_conditions.birth_place
    if birth=="GROUND_HOT" then
		MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,1,true)
        params_h.MFCD_BRT[2] = 1
        params_h.MFCD_BRT[3] = 0.98
        params_h.MFCD_Page[2] = Pages.INDICATION
        params_h.ST_TIME[2] = 36
        params_h.MFCD_MASK[2] = 0
    elseif birth=="AIR_HOT" then
		MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,1,true)
        params_h.MFCD_BRT[2] = 1
        params_h.MFCD_BRT[3] = 0.98
        params_h.MFCD_Page[2] = Pages.INDICATION
        params_h.ST_TIME[2] = 36
        params_h.MFCD_MASK[2] = 1
    elseif birth=="GROUND_COLD" then
        params_h.MFCD_BRT[2] = -1
        params_h.MFCD_BRT[3] = 0.0
        params_h.MFCD_Page[2] = Pages.BASE
        params_h.ST_TIME[2] = 0
        params_h.MFCD_MASK[2] = 0
    end
	if (birth=="GROUND_HOT" or birth=="AIR_HOT") then
		if birth_time_hours>=18 or birth_time_hours<=6 then
			MFCD:performClickableAction(click_cmd.HudMFCD_change_dayNight,-1,false)
            MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,0.25,true)
		else
			MFCD:performClickableAction(click_cmd.HudMFCD_change_dayNight,1,false)
		end
	end
end

function SetCommand(command,value)
    --DebugPrint('主显示：'..Get_command_name(command)..'..........'..value)
    if command == MFD_click_cmd.EADI_SETUP then
        if value == 1 then
            if params_h.P1_SUB_PAGE[2] == Pages[Pages.P1].BASE then
                params_h.P1_SUB_PAGE[2] = Pages[Pages.P1].SETTING
            elseif params_h.P1_SUB_PAGE[2] == Pages[Pages.P1].SETTING then
                params_h.P1_SUB_PAGE[2] = Pages[Pages.P1].BASE
            end
        end
        params_h.EADI_SETTING_CLICK[2] = value
    elseif command == MFD_click_cmd.ENG_SW then
        if value == 1 then
            if params_h.B3_SUB_PAGE[2] == Pages[Pages.B3].BASE then
                params_h.B3_SUB_PAGE[2] = Pages[Pages.B3].APU
            elseif params_h.B3_SUB_PAGE[2] == Pages[Pages.B3].APU then
                params_h.B3_SUB_PAGE[2] = Pages[Pages.B3].BASE
            end
        end
        params_h.eng_sw_click[2] = value
    elseif command == Keys.P2_to_radarPage then
        params_h.P2_SUB_PAGE[2] = Pages[Pages.P2].RADAR
        params_h.B3_SUB_PAGE[2] = Pages[Pages.B3].RADAR_L
        params_h.B4_SUB_PAGE[2] = Pages[Pages.B4].RADAR_R
    elseif command == Keys.P2_to_fcsPage then
        params_h.P2_SUB_PAGE[2] = Pages[Pages.P2].BASE
        params_h.B3_SUB_PAGE[2] = Pages[Pages.B3].BASE
        params_h.B4_SUB_PAGE[2] = Pages[Pages.B4].BASE
    elseif command == Keys.P2_to_flirPage and USE_EXT_DLL and Type then
        params_h.P2_SUB_PAGE[2] = Pages[Pages.P2].FLIR
        params_h.B3_SUB_PAGE[2] = Pages[Pages.B3].BASE
        params_h.B4_SUB_PAGE[2] = Pages[Pages.B4].BASE
    elseif command == click_cmd.HudMFCD_change_dayNight then
        if value == 1 then
            dayNight = 0
        elseif value == -1 then
            dayNight = 1
        end
    elseif command == MFD_click_cmd.EADI_ILS and value == 1 then
        params_h.EADI_ILS[2] = 1 - params_h.EADI_ILS[2]

	elseif command == JoyCmd.MFCD_BRT_Axis then
		value = Limit(value,0,1)
        MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,value,true)
	elseif command == Keys.MFCD_BRT_Increase then
        if MFCD_BRT_value~=params_h.MFCD_BRT[2] then
            MFCD_BRT_value = params_h.MFCD_BRT[2]
        end
		MFCD_BRT_value = MFCD_BRT_value + 0.1
		MFCD_BRT_value = Limit(MFCD_BRT_value,0,1)
		MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,MFCD_BRT_value,true)
	elseif command == Keys.MFCD_BRT_Decrease then
        if MFCD_BRT_value~=params_h.MFCD_BRT[2] then
            MFCD_BRT_value = params_h.MFCD_BRT[2]
        end
		MFCD_BRT_value = MFCD_BRT_value - 0.1
		MFCD_BRT_value = Limit(MFCD_BRT_value,0,1)
		MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,MFCD_BRT_value,true)
	elseif command == RightPanel_click_cmd.MFCDBrt then
        value = Limit(value,0,1)
		params_h.MFCD_BRT[2] = value
    end
end
local tmp = 0
local function playSt()
    local timer = params_h.ST_TIME[2]
    if timer > 3 and timer< 30 then
        params_h.MFCD_Page[2] = Pages.ST
    elseif timer > 3 and timer< 30 then
        params_h.MFCD_Page[2] = Pages.INDICATION
    end
    if params_h.MFCD_Page[2] == Pages.ST then
        if timer < 10 then
			MFCD:performClickableAction(RightPanel_click_cmd.MFCDBrt,1,true)
            --bios
            if math.fmod(timer*100,10)==0 then
                tmp = tmp + 1
            end
            if  tmp > 4 then
                tmp = 1
            end
            local txt = ''
            for i = 0, (timer-3), 1 do
                txt=txt..'.'
            end
            if tmp == 1 then
                txt = txt..'\\';
            elseif tmp == 2 then
                txt = txt..'|'
            elseif tmp == 3 then
                txt = txt..'/'
            elseif tmp == 4 then
                txt = txt..'--'
            end
            params_h.ST_BIOS_TXT[2] = txt
        elseif timer > 12 and timer <33.36 then
            if step == 0 then
                if params_h.ST[2] > 0 then
                    params_h.ST[2] = params_h.ST[2] - update_time_step*10
                    params_h.ST_ROT[2] = LoopPlayAnimal(params_h.ST_ROT[2],3.6,0,360)
                else
                    step = 1
                end
            elseif step == 1 then
                if params_h.ST[2]<1 then
                    params_h.ST[2] = params_h.ST[2] + update_time_step
                else
                    step = 2
                end
            elseif step == 2 then
                if params_h.ST[2]>0 then
                    params_h.ST[2] = params_h.ST[2] - update_time_step*0.5
                else
                    step = 3
                end
            elseif step == 3 then
                if params_h.ST_ROT[2]<360 then
                    params_h.ST_ROT[2] = params_h.ST_ROT[2] + 7.2
                else
                    step = 1
                    params_h.ST_ROT[2] = 0
                end
            end
        elseif timer > 33.36 and timer < 36 then
            if params_h.MFCD_Page[2] == Pages.ST  then
                params_h.MFCD_Page[2] = Pages.INDICATION
            end
        end
    elseif params_h.MFCD_Page[2] == Pages.INDICATION then
        if timer > 33.36 and timer < 36 then
            params_h.MFCD_MASK[2] = Limit(params_h.MFCD_MASK[2] + update_time_step,0,1)
        end
    end
end

function update()
    params_h.DAY_NIGHT[2]= dayNight
    if (get_elec_primary_dc_ok() or get_elec_primary_ac_ok()) then
        if params_h.MFCD_BRT[2] < 0 then
            params_h.MFCD_BRT[2] = 1
        end
        if params_h.ST_TIME[2] < 36 then
            params_h.ST_TIME[2] = tonumber(string.format('%.2f',params_h.ST_TIME[2]+update_time_step))
        end
    elseif (not get_elec_primary_dc_ok() and not get_elec_primary_ac_ok()) and params_h.MFCD_BRT[2] > 0 then
        params_h.MFCD_BRT[2] = 0
        params_h.MFCD_BRT[3] = 0.0
        if params_h.ST_TIME[2] <35 then
            params_h.ST_TIME[2] = 0
            params_h.MFCD_MASK[2] = 0
        end
    end
    playSt()
    if (get_elec_primary_dc_ok() or get_elec_primary_ac_ok()) and params_h.MFCD_Page[2] == Pages.INDICATION then
        for k, v in pairs(elements) do
            v[2] = false
        end
    else
        for k, v in pairs(elements) do
            v[2] = true
        end
    end
    if params_h.P4_SUB_PAGE[2]~=Pages[Pages.P4].BASE then
        elements.WPN_AAMODE[2] = true
        elements.WPN_AGMODE[2] = true
        elements.WPN_DOOR_AUTO[2] = true
        elements.WPN_DOOR_ON[2] = true
    end
    for k, v in pairs(elements) do
        local element = get_clickable_element_reference(v[1])
        if type(element)~="nil" then
            element:hide(v[2])
        end
    end
	for k, v in pairs(params_h) do
        if type(v[3])~="nil" then
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],0,1)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],0,1)
            end
            if k == 'MFCD_BRT' then
                v[1]:set(v[3]*(1-0.8*dayNight))
            else
                v[1]:set(v[3])
            end
        else
            v[1]:set(v[2])
        end
    end
end

need_to_be_closed = false
