-- 初始化座舱模型
shape_name   	   = "Cockpit_J-20A_V8" -- 定义座舱模型的名称
is_EDM			   = true -- 指定是否使用EDM格式
new_model_format   = true -- 是否启用新模型格式

-- 环境光设置
ambient_light    			 = {255,255,255} 	-- 环境光的RGB值
ambient_color_day_texture    = {72, 100, 160} 	-- 白天纹理的环境光颜色
ambient_color_night_texture  = {40, 60 ,150} 	-- 夜晚纹理的环境光颜色
ambient_color_from_devices   = {50, 50, 40} 	-- 来自设备的环境光颜色
ambient_color_from_panels	 = {35, 25, 25} 	-- 来自面板的环境光颜色

-- 黄昏边界值
dusk_border					 = 0.4 	 			-- 定义黄昏的亮度边界
draw_pilot					 = false			-- 是否绘制飞行员模型

-- 外部模型座舱盖参数
external_model_canopy_arg	 = 38				-- 定义外部模型座舱盖的参数编号

-- 是否启用外部视图
use_external_views 			 = false			-- 禁用外部视图

-- 纹理亮度设置
day_texture_set_value   	 = 0.0				-- 白天纹理亮度值
night_texture_set_value 	 = 0.1				-- 夜晚纹理亮度值

-- 初始化座舱动画
local controllers 			 = LoRegisterPanelControls() -- 注册面板控制器

-- 定义右油门杆的仪表
RightThrottor    					= CreateGauge("parameter")
RightThrottor.arg_number		    = 33	 	-- 参数编号
RightThrottor.input				    = {0, 1} 	-- 输入范围
RightThrottor.output			    = {0, 1} 	-- 输出范围
RightThrottor.parameter_name		= "RightThrottor" -- 参数名称

-- 定义左油门杆的仪表
LeftThrottor    					= CreateGauge("parameter")
LeftThrottor.arg_number		        = 32	 	-- 参数编号
LeftThrottor.input				    = {0, 1} 	-- 输入范围
LeftThrottor.output			        = {0, 1} 	-- 输出范围
LeftThrottor.parameter_name	        = "LeftThrottor" -- 参数名称

-- 定义座舱内部视角的仪表
CanopyInside					    = CreateGauge("parameter")
CanopyInside.arg_number		        = 38	 	-- 参数编号
CanopyInside.input				    = {0, 1} 	-- 输入范围
CanopyInside.output			        = {0, 1} 	-- 输出范围
CanopyInside.parameter_name	        = "CanopyInsideView" -- 参数名称

-- 定义座舱背景灯的仪表
CptBackgroundLight					= CreateGauge("parameter")
CptBackgroundLight.arg_number		= 208	 	-- 参数编号
CptBackgroundLight.input			= {0, 1} 	-- 输入范围
CptBackgroundLight.output			= {0, 1} 	-- 输出范围
CptBackgroundLight.parameter_name	= "cockpitBackgroundLight" -- 参数名称

-- 定义座舱泛光灯的仪表
CptFloodLight						= CreateGauge("parameter")
CptFloodLight.arg_number			= 209 		-- 参数编号
CptFloodLight.input					= {0, 1}	-- 输入范围
CptFloodLight.output				= {0, 1}	-- 输出范围
CptFloodLight.parameter_name		= "cockpitFloodLight" -- 参数名称

-- 指定是否需要关闭脚本
need_to_be_closed 					= false 	-- 不需要关闭脚本

--[[
这个 mainpanel_init.lua 文件是为 DCS 模组（J-20A）定义座舱主面板的初始化脚本。
它主要负责设置座舱模型、环境光、动画控制器以及仪表的参数。
以下是文件的详细分析：

---

### 1. **座舱模型初始化**
```lua
shape_name   	   = "Cockpit_J-20A_V8" -- 定义座舱模型的名称
is_EDM			   = true -- 指定是否使用EDM格式
new_model_format   = true -- 是否启用新模型格式
```
- **`shape_name`**：定义座舱的 3D 模型名称，这里使用的是 `Cockpit_J-20A_V8`。
- **`is_EDM`**：指定是否使用 EDM（Eagle Dynamics Model）格式的模型。
- **`new_model_format`**：启用新模型格式，可能与 DCS 的渲染引擎兼容性有关。

---

### 2. **环境光设置**
```lua
ambient_light    = {255,255,255} -- 环境光的RGB值
ambient_color_day_texture    = {72, 100, 160} -- 白天纹理的环境光颜色
ambient_color_night_texture  = {40, 60 ,150} -- 夜晚纹理的环境光颜色
ambient_color_from_devices   = {50, 50, 40} -- 来自设备的环境光颜色
ambient_color_from_panels	 = {35, 25, 25} -- 来自面板的环境光颜色
```
- **`ambient_light`**：
定义座舱的环境光颜色，使用 RGB 值表示。
- **`ambient_color_day_texture`** 和 **`ambient_color_night_texture`**：
分别定义白天和夜晚纹理的环境光颜色。
- **`ambient_color_from_devices`** 和 **`ambient_color_from_panels`**：
分别定义来自设备和面板的环境光颜色。

这些设置影响座舱的整体光照效果，确保在不同时间和条件下有合适的视觉表现。

---

### 3. **黄昏边界与飞行员模型**
```lua
dusk_border					 = 0.4 -- 定义黄昏的亮度边界
draw_pilot					 = false -- 是否绘制飞行员模型
```
- **`dusk_border`**：定义黄昏的亮度边界值，用于调整光照过渡。
- **`draw_pilot`**：是否在座舱中绘制飞行员模型，这里设置为 `false`，表示不绘制。

---

### 4. **外部模型设置**
```lua
external_model_canopy_arg	 = 38 -- 定义外部模型座舱盖的参数编号
use_external_views = false -- 禁用外部视图
```
- **`external_model_canopy_arg`**：定义外部模型中座舱盖的动画参数编号（38）。
- **`use_external_views`**：是否启用外部视图，这里设置为 `false`，表示禁用。

---

### 5. **纹理亮度设置**
```lua
day_texture_set_value   = 0.0 -- 白天纹理亮度值
night_texture_set_value = 0.1 -- 夜晚纹理亮度值
```
- **`day_texture_set_value`** 和 **`night_texture_set_value`**：分别定义白天和夜晚纹理的亮度值，用于调整纹理的视觉效果。

---

### 6. **座舱动画控制器**
```lua
local controllers = LoRegisterPanelControls() -- 注册面板控制器
```
- **`LoRegisterPanelControls`**：注册座舱的面板控制器，用于管理座舱内的交互和动画。

---

### 7. **仪表定义**
文件中定义了多个仪表（`Gauge`），每个仪表都有以下属性：
- **`arg_number`**：参数编号，用于与 DCS 的动画系统绑定。
- **input** 和 **`output`**：定义输入和输出范围。
- **`parameter_name`**：参数名称，用于脚本中引用。

#### 示例 1：右油门杆
```lua
RightThrottor    					= CreateGauge("parameter")
RightThrottor.arg_number		    = 33 -- 参数编号
RightThrottor.input				    = {0, 1} -- 输入范围
RightThrottor.output			    = {0, 1} -- 输出范围
RightThrottor.parameter_name		= "RightThrottor" -- 参数名称
```
- 定义了右油门杆的仪表。
- 参数编号为 `33`，输入和输出范围均为 `{0, 1}`。
- 参数名称为 `RightThrottor`。

#### 示例 2：座舱背景灯
```lua
CptBackgroundLight					    = CreateGauge("parameter")
CptBackgroundLight.arg_number		    = 208 -- 参数编号
CptBackgroundLight.input				= {0, 1} -- 输入范围
CptBackgroundLight.output			    = {0, 1} -- 输出范围
CptBackgroundLight.parameter_name	    = "cockpitBackgroundLight" -- 参数名称
```
- 定义了座舱背景灯的仪表。
- 参数编号为 `208`，输入和输出范围均为 `{0, 1}`。
- 参数名称为 `cockpitBackgroundLight`。

#### 其他仪表：
- **左油门杆**：`LeftThrottor`，参数编号 `32`。
- **座舱内部视角**：`CanopyInside`，参数编号 `38`。
- **座舱泛光灯**：`CptFloodLight`，参数编号 `209`。

---

### 8. **脚本关闭设置**
```lua
need_to_be_closed = false -- 不需要关闭脚本
```
- **`need_to_be_closed`**：指定是否需要关闭脚本，这里设置为 `false`，表示脚本会一直运行。

---

### 总结
这个脚本的主要功能是：
1. 初始化座舱模型和光照环境。
2. 定义座舱内的动画控制器和仪表参数。
3. 设置座舱的纹理亮度和外部模型参数。
4. 提供对座舱灯光、油门杆等设备的控制。

]]