local beaconsFile = get_terrain_related_data('beaconsFile')
if beaconsFile then 
    local f = loadfile(beaconsFile)
    if f then
        f()
    end
end

BEACON_TYPE_VOR = 1
BEACON_TYPE_TACAN = 4
BEACON_TYPE_ILS_LOCALIZER = 16640

ILS_beacons = {}
TCN_beacons = {}
VOR_beacons = {}

ILS_idx = 0
TCN_idx = 0
VOR_idx = 0

function Init_beacons()
    for k, v in pairs(beacons) do
        if v.type == BEACON_TYPE_VOR then
            VOR_beacons[#VOR_beacons+1] = {
                type = v.type,
                beaconId = v.beaconId,
                posGeo = v.positionGeo,
                display_name = v.display_name,
                channel = v.channel,
                pos = v.position,
                direction = v.direction,
                callsign = v.callsign,
                freq = v.frequency
            }
        elseif v.type == BEACON_TYPE_ILS_LOCALIZER then
            ILS_beacons[#ILS_beacons+1] = {
                type = v.type,
                beaconId = v.beaconId,
                posGeo = v.positionGeo,
                display_name = v.display_name,
                pos = v.position,
                direction = v.direction,
                callsign = v.callsign,
                freq = v.frequency
            }
        elseif v.type == BEACON_TYPE_TACAN then
            TCN_beacons[#TCN_beacons+1] = {
                type = v.type,
                beaconId = v.beaconId,
                posGeo = v.positionGeo,
                display_name = v.display_name,
                channel = v.channel,
                pos = v.position,
                direction = v.direction,
                callsign = v.callsign,
                freq = v.frequency
            }
        end
    end
end
local tcnStatus_h = get_param_handle('TCN_STATUS')
local tcnChannel_h = get_param_handle('TCN_CHANNEL')
function UpdateTCN()
    if tcnStatus_h:get()>0.5 then
        local tcnChannel = tcnChannel_h:get()
        local tcnData = nil
        for k, v in pairs(TCN_beacons) do
            if v.channel==tcnChannel then
                tcnData=v
                break
            end
        end
        if tcnData~=nil then
            Nav_params_h.TCN_WORKING[2] = 1
            local myLatM = GPS_LAT_M:get()
            local myLonM = GPS_LON_M:get()
            local lat_sub = tcnData.pos[1]-myLatM
            local lon_sub = tcnData.pos[3]-myLonM
            local angle = math.atan2(lon_sub,lat_sub)
            local distance = math.sqrt(lat_sub^2+lon_sub^2)--计算距离
            local el = math.atan((tcnData.pos[2] - BASE_SENSOR.BAROALT:get())/distance)
            Nav_params_h.TCN_DISTANCE[2] = distance
            Nav_params_h.TCN_NAME[2] = tcnData.callsign
            Nav_params_h.TCN_AZ[2]=math.deg(angle)-MagVar_h:get()
            local scale = 40/MaxRange_h:get()
            Nav_params_h.TCN_LAT_M[2] = tcnData.pos[1]*scale
            Nav_params_h.TCN_LON_M[2] = tcnData.pos[3]*scale
            local runwayName = AIRPORT_INFO[tcnData.display_name].RUNWAY[1]
            if type(runwayName)=="string" then
                Nav_params_h.RUNWAY_AZ[2] = tonumber(runwayName)*10
            else
                Nav_params_h.RUNWAY_AZ[2] = 0
            end
            return el,angle,distance,0,tcnData.callsign,tcnData.display_name
        else
            Nav_params_h.TCN_AZ[2] = Nav_params_h.TCN_AZ[2]+1
            Nav_params_h.TCN_WORKING[2] = 0
        end
    else
        Nav_params_h.TCN_WORKING[2] = 0
    end
end
local ilsStatus_h = get_param_handle('ILS_STATUS')
local ilsFreq_h = get_param_handle('ILS_FREQ')
local ilsIsLocalizerValid = get_param_handle('ILS_IS_LOCALIZER_VALID')
local ilsData = nil
function GetILS()
    if ilsStatus_h:get()>0.5 then
        if ilsData~=nil then
            local myLatM = GPS_LAT_M:get()
            local myLonM = GPS_LON_M:get()
            local lat_sub = ilsData.pos[1]-myLatM
            local lon_sub = ilsData.pos[3]-myLonM
            local angle = math.atan2(lon_sub,lat_sub)
            local distance = math.sqrt(lat_sub^2+lon_sub^2)--根据三角函数计算距离
            local el = math.atan((ilsData.pos[2] - BASE_SENSOR.BAROALT:get())/distance)
            local runwayName = AIRPORT_INFO[ilsData.display_name].RUNWAY[1]
            if type(runwayName)=="string" then
                Nav_params_h.RUNWAY_AZ[2] = runwayName*10
            --  Nav_params_h.RUNWAY_AZ[2] = tonumber(runwayName)*10
            else
                Nav_params_h.RUNWAY_AZ[2] = 0
            end
            return el,angle,distance,0,ilsData.callsign
        else
            Nav_params_h.RUNWAY_AZ[2] = Nav_params_h.RUNWAY_AZ[2]+1
            Nav_params_h.TCN_WORKING[2] = 0
        end
    else
        Nav_params_h.TCN_WORKING[2] = 0
    end
end
function UpdateILS()
    if ilsStatus_h:get()>0.5 then
        local ilsFreq = ilsFreq_h:get()*1e6
        ilsData = nil
        local ilsName = nil
        for k, v in pairs(ILS_beacons) do
            if v.freq==ilsFreq then
                ilsData=v
                ilsName = v.display_name
                break
            end
        end
        if ilsIsLocalizerValid:get()>0.5 then
            return ilsData~=nil,ilsName
        else
            return nil,nil
        end
    else
        ilsData = nil
    end
    return false,nil
end