
dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/electric_system_api.lua")
dofile(LockOn_Options.script_path.."Systems/device_header.lua")
dofile(LockOn_Options.script_path.."cockpit_cfg.lua")

Terrain = require('terrain')
dofile(LockOn_Options.script_path.."nav/airports.lua")
dofile(LockOn_Options.script_path.."nav/waypoint.lua")
dofile(LockOn_Options.script_path.."nav/beacons.lua")
dofile(LockOn_Options.script_path.."nav/towns.lua")

local NAV 	    = GetSelf()

GPS_LAT_M = get_param_handle('GPS_LAT_M')
GPS_LON_M = get_param_handle('GPS_LON_M')

local update_time_step = 0.02  --每秒50次刷新
make_default_activity(update_time_step)
MaxRange_h = get_param_handle('MAX_RANGE')
local navType = 6 --0:未设置,1:塔康,2:ILS,3:VOR,4:机场,5:城镇,6:航路点,12:塔康+ILS
Nav_params_h = {
    TARGET_NAME={get_param_handle('TARGET_NAME'),0},
    HUD_TARGET_WPT_EL={get_param_handle('HUD_TARGET_WPT_EL'),0},
    HUD_TARGET_WPT_AZ={get_param_handle('HUD_TARGET_WPT_AZ'),0},
    HMD_TARGET_WPT_EL={get_param_handle('HMD_TARGET_WPT_EL'),0},
    HMD_TARGET_WPT_AZ={get_param_handle('HMD_TARGET_WPT_AZ'),0},

    TARGET_WPT_RANGE={get_param_handle('TARGET_WPT_RANGE'),'0KM'},
    TARGET_ETA_HH = {get_param_handle('TARGET_ETA_HH'),0},
    TARGET_ETA_mm = {get_param_handle('TARGET_ETA_mm'),0},
    TARGET_ETA_ss = {get_param_handle('TARGET_ETA_ss'),0},
    TARGET_ETA_dd = {get_param_handle('TARGET_ETA_dd'),0},
    NAV_TYPE = {get_param_handle('NAV_TYPE'),'NOTSET'},
    NAV_MODE = {get_param_handle('NAV_MODE'),1},

    TCN_AZ = {get_param_handle('TCN_AZ'),0},
    TCN_WORKING = {get_param_handle('TCN_WORKING'),0},
    TCN_DISTANCE = {get_param_handle('TCN_DISTANCE'),0},
    TCN_NAME = {get_param_handle('TCN_NAME'),0},
    TCN_LAT_M = {get_param_handle('TCN_LAT_M'),0},
    TCN_LON_M = {get_param_handle('TCN_LON_M'),0},
    RUNWAY_AZ = {get_param_handle('RUNWAY_AZ'),0}
}
MagVar_h = get_param_handle('MAG_VAR')

Nav_sensor_data = get_base_data()

function post_initialize()
    Init_waypoint()
    Init_airport_pos()
    Init_beacons()
    Init_towns()
end

function SetCommand(command,value)
    if command == Keys.NextTargetPnt then
        if navType == 4 then
            SetAirportWptIdx(1)
        elseif navType == 6 then
            SetWptIdx(1)
        end
    elseif command== Keys.LastTargetPnt then
        if navType == 4 then
            SetAirportWptIdx(-1)
        elseif navType == 6 then
            SetWptIdx(-1)
        end
    end
end
local hdg_h = get_param_handle('HDG')
local unit_h = get_param_handle('UNIT')
local head_el_h = get_param_handle('HEAD_EL')
local head_hdg_h = get_param_handle('HEAD_HDG')
local hdgType = get_param_handle('HDG_TYPE')
--local dbg = get_param_handle('DBG')

function updateTargetPos()
    local el,az,range,offset,name
    if navType == 0 then
        Nav_params_h.NAV_TYPE[2]='NOTSET'
        return
    elseif navType == 1 then
        el,az,range,offset,name = UpdateTCN()
        if el==nil then
            return
        end
        Nav_params_h.NAV_TYPE[2]='TCN'
    elseif navType == 2 then
        Nav_params_h.NAV_TYPE[2]='ILS'
        el,az,range,offset,name = GetILS()
    elseif navType == 12 then
        local tcnName
        el,az,range,offset,tcnName = UpdateTCN()
        el,az,range,offset,name = GetILS()
        name = name..'+'..tcnName
        Nav_params_h.NAV_TYPE[2]='ILS+TCN'
    elseif navType == 3 then
        name = 'VOR'
        Nav_params_h.NAV_TYPE[2]='VOR'
    elseif navType == 4 then
        name = '机场'
        Nav_params_h.NAV_TYPE[2]='机场'
    elseif navType == 5 then
        Nav_params_h.NAV_TYPE[2]='城镇'
    elseif navType == 6 then
        el,az,range,offset,name = GetTargetWpt()
        Nav_params_h.NAV_TYPE[2]='航路点'
        if type(el)=="nil" then
            Nav_params_h.NAV_MODE[2] = 0
            return
        end
    end
    if hdgType:get() == 0 then
        az = az - math.rad(MagVar_h:get())
    end
    --dbg:set(math.deg(az))
    local hmd_az = az + offset - math.rad(head_hdg_h:get())
    hmd_az = Normalize_angle(hmd_az)

    -- 判断是否在前半球
    if math.abs(hmd_az) <= math.pi/2 then
        get_param_handle('HMD_TARGET_WPT_BEHIND'):set(0)
    else
        -- 后半球标志
        get_param_handle('HMD_TARGET_WPT_BEHIND'):set(1)
    end

    local hmd_el = el - BASE_SENSOR.PITCH:get() - math.rad(head_el_h:get())

    local hmd_x = math.tan(hmd_az)*1
    local hmd_y = math.tan(hmd_el)*1

    local hud_az = az + offset - math.rad(hdg_h:get())
    local hud_el = el - BASE_SENSOR.PITCH:get()
    hud_az = Normalize_angle(hud_az) -- 对HUD方位归一化
    local limit_az = Limit(hud_az, -HUD_AZ, HUD_AZ)
    local limit_el = Limit(hud_el, -HUD_EL, HUD_EL)
    local hud_x = math.tan(limit_az)*HUD_distance
    local hud_y = math.tan(limit_el)*HUD_distance

    if unit_h:get()==0 then
        Nav_params_h.TARGET_WPT_RANGE[2] = string.format('%.2fKM',range*0.001)
    else
        Nav_params_h.TARGET_WPT_RANGE[2] = string.format('%.2fNM',range*Meter_TO_NM)
    end
    Nav_params_h.HUD_TARGET_WPT_EL[2] = hud_y
    Nav_params_h.HUD_TARGET_WPT_AZ[2] = hud_x
    Nav_params_h.HMD_TARGET_WPT_EL[2] = hmd_y
    Nav_params_h.HMD_TARGET_WPT_AZ[2] = hmd_x
    Nav_params_h.TARGET_NAME[2] = name
    local gs = GetGroundSpeed()
    if gs > 0 then
        local eta_day,etaH,eta_m,eta_s = SecondsTo_ddHHmmss(range/gs)
        Nav_params_h.TARGET_ETA_dd[2]=eta_day
        Nav_params_h.TARGET_ETA_HH[2]=etaH
        Nav_params_h.TARGET_ETA_mm[2]=eta_m
        Nav_params_h.TARGET_ETA_ss[2]=eta_s
    end
end

function update()
    UpdateWaypoint()
    UpdateAirPortPos()
    updateTargetPos()
    local el,az,distance,offsets,name,name2=UpdateTCN()
    local ilsValid,ilsDisplayName = UpdateILS()
    if
		ilsValid and Nav_params_h.TCN_WORKING[2]>0.5 and name2 == ilsDisplayName
	then
        navType = 12
    elseif ilsValid then
        navType = 2
    elseif Nav_params_h.TCN_WORKING[2]>0.5 then
        navType = 1
    else
        navType = 6
    end
    for k, v in pairs(Nav_params_h) do
        if type(v[3])~="nil" then
            if v[2] > v[3] then
                v[3] = Limit(v[3]+v[4],0,1)
            elseif v[2]< v[3] then
                v[3] = Limit(v[3]-v[4],0,1)
            end
            v[1]:set(v[3])
        else
            v[1]:set(v[2])
        end
    end
end
need_to_be_closed = false