local slugft2_to_kgm2 = 1.355817962;
local main_wheel_brake_moment_max = 270000.0; -- 11000.0 (Good for rolling, but need higher static)
local main_amortizer_length = 1.454-1.225
local nose_amortizer_length = 0.97-0.748
local mainGear = {
	wheel_radius					= 0.4325, 
	anti_skid_installed = true,
	crossover_locked_wheel_protection = true, 
	crossover_locked_wheel_protection_speed_min = 18, -- 15 knots
	anti_skid_improved	= true,
	anti_skid_gain = 800.0,

	amortizer_min_length                 = 0.0,
    amortizer_max_length                 = main_amortizer_length,
	amortizer_basic_length               = main_amortizer_length+0.01,
	amortizer_reduce_length		            = main_amortizer_length, 
	allowable_hard_contact_length   		= main_amortizer_length,

	amortizer_spring_force_factor        = 10000000,
    amortizer_spring_force_factor_rate   = 2.0,
    amortizer_static_force               = 6500.0,
	amortizer_direct_damper_force_factor = 64000.0,
    amortizer_back_damper_force_factor   = 27200.0,
	
	
	-- Measured Main diameter 0.88825
	wheel_static_friction_factor  = 0.7 ,
    wheel_side_friction_factor    = 0.65 ,
    wheel_roll_friction_factor    = 0.04 ,
    wheel_glide_friction_factor   = 0.35 ,

	wheel_damage_force_factor		= 450.0,
	wheel_brake_moment_max			= main_wheel_brake_moment_max,
	wheel_kz_factor					= 0.52,
	noise_k							= 0.4,
	-- probability of damage is 1 when the wheel speed is >= wheel_damage_speedX + wheel_damage_delta_speedX
	wheel_damage_speedX				= 116.779, -- 227 knots
	wheel_damage_delta_speedX		= 15.4333, -- 30 knots
}

J20A = {
	-- center of mass position relative to object 3d model center for empty aircraft (m)
	-- in DCS World coordinates, desire a 25.65% CG Reference
    center_of_mass      =   {  -2.5, 0.0, 0.0},  
	-- moment of inertia of empty aircraft (kg-m^2)
	-- (Ix, Iz, Iy, Ixy) in typical body coordinates (not DCS World coordinates)
    -- F-15E FQR Empty Loading w/ CFTs
    -- Aero Ixx =  25170 slug-ft2 (Roll)
    -- Aero Iyy = 181150 slug-ft2 (Pitch)
    -- Aero Izz = 200270 slug-ft2 (Yaw)
    -- Aero Ixz =  -1400 slug-ft2 (Product)
    -- moment of inertia of empty aircraft
    moment_of_inertia   = {   25170.0 * slugft2_to_kgm2, 
                             200270.0 * slugft2_to_kgm2,
                             181150.0 * slugft2_to_kgm2,
                              -1400.0 * slugft2_to_kgm2},    
	suspension 			= {
		{ -- NOSE WHEEL
			damage_element					= 83,
            wheel_axle_offset               = 0,
			self_attitude					= true,
            yaw_limit                       = math.rad(75.0),
			moment_limit                    = 750.0,
			moment_of_inertia 				= {10.0,0.5,10.0},
			damper_coeff			        = 300.0,
			filter_yaw                      = false,
			
			amortizer_min_length                 = 0.0,
            amortizer_max_length                 = nose_amortizer_length,
            amortizer_basic_length               = nose_amortizer_length+0.01,
			amortizer_reduce_length		            = nose_amortizer_length,
			allowable_hard_contact_length   = nose_amortizer_length,

			amortizer_spring_force_factor        = 1700000.0,
            amortizer_spring_force_factor_rate   = 2.0,
            amortizer_static_force               = 30000.0,
			amortizer_direct_damper_force_factor = 40000.0,
            amortizer_back_damper_force_factor   = 20000.0,
			
			anti_skid_installed = false,

            -- Measured Nose diameter 0.56278
			wheel_radius			        = 0.441, 
			wheel_moment_of_inertia			= 0.6,
			wheel_static_friction_factor = 0.75,
            wheel_side_friction_factor   = 0.35 ,
            wheel_roll_friction_factor   = 0.12 ,
            wheel_glide_friction_factor  = 0.35 ,
			wheel_damage_force_factor		= 450.0,
            wheel_kz_factor					= 0.3,
            noise_k							= 1.0,
            wheel_damage_speedX				= 116.779, -- 227 knots
            wheel_damage_delta_speedX		= 15.4333, -- 30 knots
            
			-- probability of damage is 1 when the wheel speed is >= wheel_damage_speedX + wheel_damage_delta_speedX

			arg_post			= 0,
			arg_amortizer		= 1,
			arg_wheel_rotation	= 101,
			arg_wheel_damage	= 134,
			collision_shell_name  = "FRONT_WHEEL",
		},
		{ -- LEFT WHEEL
			damage_element					= 84,
			wheel_radius					= mainGear.wheel_radius,
			anti_skid_installed = mainGear.anti_skid_installed,
			crossover_locked_wheel_protection			= mainGear.crossover_locked_wheel_protection,
			crossover_locked_wheel_protection_wheel		= 2,
			crossover_locked_wheel_protection_speed_min	= mainGear.crossover_locked_wheel_protection_speed_min,
			anti_skid_improved							= mainGear.anti_skid_improved;
			anti_skid_gain								= mainGear.anti_skid_gain,
			--wheel_axle_offset						= mainGear.wheel_axle_offset,
			
			amortizer_min_length					= mainGear.amortizer_min_length,
			amortizer_max_length					= mainGear.amortizer_max_length,
			amortizer_basic_length					= mainGear.amortizer_basic_length,
			amortizer_reduce_length					= mainGear.amortizer_reduce_length,
			allowable_hard_contact_length			= mainGear.allowable_hard_contact_length,

			amortizer_spring_force_factor			= mainGear.amortizer_spring_force_factor, -- force = spring_force_factor * pow(reduce_length, amortizer_spring_force_factor_rate
			amortizer_spring_force_factor_rate		= mainGear.amortizer_spring_force_factor_rate,
			amortizer_static_force					= mainGear.amortizer_static_force,
			amortizer_direct_damper_force_factor	= mainGear.amortizer_direct_damper_force_factor, 
			amortizer_back_damper_force_factor		= mainGear.amortizer_back_damper_force_factor, 



			wheel_static_friction_factor	= mainGear.wheel_static_friction_factor,
			wheel_side_friction_factor		= mainGear.wheel_side_friction_factor,
			wheel_roll_friction_factor		= mainGear.wheel_roll_friction_factor,
			wheel_glide_friction_factor		= mainGear.wheel_glide_friction_factor,
			
			wheel_damage_force_factor		= mainGear.wheel_damage_force_factor,
			wheel_brake_moment_max			= mainGear.wheel_brake_moment_max,
			wheel_kz_factor					= mainGear.wheel_kz_factor,
			noise_k							= mainGear.noise_k,
			wheel_damage_speedX				= mainGear.wheel_damage_speedX,
			wheel_damage_delta_speedX		= mainGear.wheel_damage_delta_speedX,

			arg_post			= 5,
			arg_amortizer		= 6,
			arg_wheel_rotation	= 102,
			arg_wheel_damage	= 136,
			collision_shell_name  = "LEFT_WHEEL",
		},
		{ -- RIGHT WHEEL			
			damage_element					= 85,
			wheel_radius					= mainGear.wheel_radius,
			anti_skid_installed = mainGear.anti_skid_installed,
			crossover_locked_wheel_protection			= mainGear.crossover_locked_wheel_protection,
			crossover_locked_wheel_protection_wheel		= 1,
			crossover_locked_wheel_protection_speed_min	= mainGear.crossover_locked_wheel_protection_speed_min,
			anti_skid_improved							= mainGear.anti_skid_improved;
			anti_skid_gain								= mainGear.anti_skid_gain,
			--wheel_axle_offset						= mainGear.wheel_axle_offset,
			
			amortizer_min_length					= mainGear.amortizer_min_length,
			amortizer_max_length					= mainGear.amortizer_max_length,
			amortizer_basic_length					= mainGear.amortizer_basic_length,
			amortizer_reduce_length					= mainGear.amortizer_reduce_length,
			allowable_hard_contact_length			= mainGear.allowable_hard_contact_length,

			amortizer_spring_force_factor			= mainGear.amortizer_spring_force_factor, -- force = spring_force_factor * pow(reduce_length, amortizer_spring_force_factor_rate
			amortizer_spring_force_factor_rate		= mainGear.amortizer_spring_force_factor_rate,
			amortizer_static_force					= mainGear.amortizer_static_force,
			amortizer_direct_damper_force_factor	= mainGear.amortizer_direct_damper_force_factor, 
			amortizer_back_damper_force_factor		= mainGear.amortizer_back_damper_force_factor, 



			wheel_static_friction_factor	= mainGear.wheel_static_friction_factor,
			wheel_side_friction_factor		= mainGear.wheel_side_friction_factor,
			wheel_roll_friction_factor		= mainGear.wheel_roll_friction_factor,
			wheel_glide_friction_factor		= mainGear.wheel_glide_friction_factor,

			wheel_damage_force_factor		= mainGear.wheel_damage_force_factor,
			wheel_brake_moment_max			= mainGear.wheel_brake_moment_max,
			wheel_kz_factor					= mainGear.wheel_kz_factor,
			noise_k							= mainGear.noise_k,
			wheel_damage_speedX				= mainGear.wheel_damage_speedX,
			wheel_damage_delta_speedX		= mainGear.wheel_damage_delta_speedX,

			arg_post			= 3,
			arg_amortizer		= 4,
			arg_wheel_rotation	= 103,
			arg_wheel_damage	= 135,
			collision_shell_name  = "RIGHT_WHEEL",
		},
	}, -- gears	
	
	disable_built_in_oxygen_system	= true,
--[[ ------------------------------------------------------------- ]]--
-- END -- this part of the file is not intended for an end-user editing

	-- FFB force multiplier
	ffbPitchK	= 0.65,
	ffbRollK	= 0.65,

	-- view shake amplitude
	minor_shake_ampl = 0.07,
	major_shake_ampl = 0.25,


-- view shake amplitude
cs_shakeAoA0 				=   10, -- shake0 start at AoA 17° NEW//NEW 13° // NEW 10
cs_shakeAoA1 				= 	14, -- shake1 start at AoA 19° NEW// NEW 16° // NEW 14
cs_shakeNy0 				= 	5.5, -- shake0 start bei 6,5 Gs NEW//NEW 5,5 Gs
cs_shakeNy1 				= 	6.5, -- shake1 start at 7,5 Gs NEW//NEW 6,5 Gs
cs_shakeAmpl 				=   0.7, -- shake amplitude NEW // NEW 0.7
cs_shakeFreq 				= 	3,--5, -- shake frequency NEW // NEW 5

-- debug
debugLine = "{M}:%1.3f {IAS}:%4.1f {AoA}:%2.1f {ny}:%2.1f {nx}:%1.2f {AoS}:%2.1f {mass}:%2.1f {Fy}:%2.1f {Fx}:%2.1f {wx}:%.1f {wy}:%.1f {wz}:%.1f {Vy}:%2.1f {dPsi}:%2.1f",
record_enabled = false,

}