local cscripts = folder.."../../../Cockpit/Scripts/"
dofile(cscripts.."devices.lua")
dofile(cscripts.."command_defs.lua")
--[[
local kneeboard_id = 100
if devices and devices.KNEEBOARD then
   kneeboard_id = devices.KNEEBOARD
end
]]--

return {
keyCommands = {
	-- MP3Playser
	--	{combos = {{key = 'Space', reformers = {'LCtrl'}}}, 		down = Keys.mp3Player_pauseOrPlay, 	name = _('pause/play'), 	category = _('Mp3')},
	--	{combos = {{key = 'Right', reformers = {'LCtrl'}}}, 		down = Keys.mp3Player_next, 		name = _('next'), 			category = _('Mp3')},
	--	{combos = {{key = 'Left', reformers = {'LCtrl'}}}, 			down = Keys.mp3Player_last, 		name = _('last'), 			category = _('Mp3')},
	--	{combos = {{key = 'Left', reformers = {'LCtrl', 'LAlt'}}}, 	down = Keys.mp3Player_fastBack, 	name = _('fastBack'), 		category = _('Mp3')},
	--	{combos = {{key = 'Right', reformers = {'LCtrl', 'LAlt'}}}, down = Keys.mp3Player_fastForward, 	name = _('fastForward'), 	category = _('Mp3')},
	--	{															down = Keys.mp3PlayMode,			name = _('Play Mode'),		category = _('Mp3')},
	--	{															down = Keys.mp3LrcViewTrigger,		name = _('Display Lyrics'),	category = _('Mp3')},

    --{combos = {{key = 'Y', reformers = {'LCtrl', 'LShift'}}}, down = iCommandChatShowHide, name = _('Chat show/hide'), category = _('General')},

    {combos = {{key = 'S', reformers = {'LAlt','LShift','LCtrl'}}},	down = Keys.ToggleStick, name = _('Hide/Show Control Stick'), category = _('General')},

	-----Debug-----
    {combos = {{key = '`', reformers = {'LAlt'}}},	 				down = ICommandToggleConsole,	name = _('Toggle Console'),	category = _('Debug')},
    {combos = {{key = 'D', reformers = {'LAlt','LShift','LCtrl'}}},	down = Keys.ShowParamList,		name = _('DEBUG RECORD'),	category = _('Debug')},

	-----Gameplay-----
    {combos = {{key = 'S',	 reformers = {'LShift'}}},			down = iCommandCockpitShowPilotOnOff,			name = _('Show Pilot Body'),						category = _('General')},
    {combos = {{key = 'Y',	 reformers = {'LCtrl'}}},			down = iCommandInfoOnOff,						name = _('Info bar view toggle'),					category = _('General')},
    {combos = {{key = 'Tab', reformers = {'RCtrl', 'RShift'}}},	down = iCommandRecoverHuman,					name = _('Get new plane - respawn'),				category = _('General')},
    {combos = {{key = 'J',	 reformers = {'RAlt'}}},			down = iCommandPlaneJump,						name = _('Jump into selected aircraft'),			category = _('General')},
    {combos = {{key = 'Y',	 reformers = {'LAlt'}}},			down = iCommandViewCoordinatesInLinearUnits,	name = _('Info bar coordinate units toggle'),		category = _('General')},
    {combos = {{key = 'C',	 reformers = {'LAlt'}}},			down = iCommandCockpitClickModeOnOff,			name = _('Clickable mouse cockpit mode On/Off'),	category = _('General')},
    {combos = {{key = 'S',	 reformers = {'LCtrl'}}},			down = iCommandSoundOnOff,						name = _('Sound On/Off'),							category = _('General')},
    {combos = {{key = '\'',	 reformers = {'LAlt'}}},			down = iCommandMissionResourcesManagement,		name = _('Rearming and Refueling Window'),			category = _('General')},
    {combos = {{key = 'B',	 reformers = {'LAlt'}}},			down = iCommandViewBriefing,					name = _('View briefing on/off'),					category = _('General')},
    {combos = {{key = 'Enter', reformers = {'RCtrl'}}},			down = iCommandPlane_ShowControls,				name = _('Show controls indicator') ,				category = _('General')},

	-----Communications
    {combos = {{key = 'E', reformers = {'LWin'}}},		down = iCommandPlaneDoAndHome,				name = _('Flight - Complete mission and RTB'),		category = _('Communications')},
    {combos = {{key = 'R', reformers = {'LWin'}}},		down = iCommandPlaneDoAndBack,				name = _('Flight - Complete mission and rejoin'),	category = _('Communications')},
    {combos = {{key = 'T', reformers = {'LWin'}}},		down = iCommandPlaneFormation,				name = _('Toggle Formation'),						category = _('Communications')},
    {combos = {{key = 'Y', reformers = {'LWin'}}},		down = iCommandPlaneJoinUp,					name = _('Join Up Formation'),						category = _('Communications')},
    {combos = {{key = 'Q', reformers = {'LWin'}}},		down = iCommandPlaneAttackMyTarget,			name = _('Attack My Target'),						category = _('Communications')},
    {combos = {{key = 'W', reformers = {'LWin'}}},		down = iCommandPlaneCoverMySix,				name = _('Cover Me'),								category = _('Communications')},
    {combos = {{key = 'U', reformers = {'LWin'}}},		down = iCommandAWACSHomeBearing,			name = _('Request AWACS Home Airbase'),				category = _('Communications')},
    {combos = {{key = 'G', reformers = {'LWin'}}},		down = iCommandPlane_EngageGroundTargets,	name = _('Flight - Attack ground targets'),			category = _('Communications')},
    {combos = {{key = 'D', reformers = {'LWin'}}},		down = iCommandPlane_EngageAirDefenses,		name = _('Flight - Attack air defenses'),			category = _('Communications')},
    {combos = {{key = '\\'}},							down = iCommandToggleCommandMenu,			name = _('Communication menu'),						category = _('Communications')},
    {combos = {{key = '\\', reformers = {'LShift'}}},	down = ICommandSwitchDialog,				name = _('Switch dialog'),							category = _('Communications')},
    {combos = {{key = '\\', reformers = {'LCtrl'}}},	down = ICommandSwitchToCommonDialog,		name = _('Switch to main menu'),					category = _('Communications')},
    {combos = {{key = '\\', reformers = {'RAlt'}}},		down = Keys.UHF_PIT,						name = _('UHF Pit'),				  				category = _('Communications')},
    {combos = {{key = '\\', reformers = {'RCtrl'}}},	down = Keys.VHF_PIT,						name = _('VHF Pit'),				  				category = _('Communications')},
	--	{combos = {{key = '\\', reformers = {'RCtrl','RShift'}}},  down = Keys.HF_PIT,					name = _('HF Pit'),									category = _('Communications')},

	-----View
    {combos = {{key = 'Num4'}}, pressed = iCommandViewLeftSlow,		 up = iCommandViewStopSlow, name = _('View Left slow'),		  category = _('View')},
    {combos = {{key = 'Num6'}}, pressed = iCommandViewRightSlow,	 up = iCommandViewStopSlow, name = _('View Right slow'),	  category = _('View')},
    {combos = {{key = 'Num8'}}, pressed = iCommandViewUpSlow,		 up = iCommandViewStopSlow, name = _('View Up slow'),		  category = _('View')},
    {combos = {{key = 'Num2'}}, pressed = iCommandViewDownSlow,		 up = iCommandViewStopSlow, name = _('View Down slow'),		  category = _('View')},
    {combos = {{key = 'Num9'}}, pressed = iCommandViewUpRightSlow,	 up = iCommandViewStopSlow, name = _('View Up Right slow'),	  category = _('View')},
    {combos = {{key = 'Num3'}}, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = _('View Down Right slow'), category = _('View')},
    {combos = {{key = 'Num1'}}, pressed = iCommandViewDownLeftSlow,	 up = iCommandViewStopSlow, name = _('View Down Left slow'),  category = _('View')},
    {combos = {{key = 'Num7'}}, pressed = iCommandViewUpLeftSlow,	 up = iCommandViewStopSlow, name = _('View Up Left slow'),	  category = _('View')},
    {combos = {{key = 'Num5'}}, pressed = iCommandViewCenter,		 							name = _('View Center'),		  category = _('View')},

    {combos = {{key = 'Num*'}}, pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = _('Zoom in slow'), category = _('View')},
    {combos = {{key = 'Num/'}}, pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = _('Zoom out slow'), category = _('View')},
    {combos = {{key = 'Num*', reformers = {'RCtrl'}}}, pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = _('Zoom external in'), category = _('View')},
    {combos = {{key = 'Num/', reformers = {'RCtrl'}}}, pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = _('Zoom external out'), category = _('View')},
    {combos = {{key = 'NumEnter'}}, down = iCommandViewAngleDefault, name = _('Zoom normal'), category = _('View')},
    {combos = {{key = 'NumEnter', reformers = {'RCtrl'}}}, down = iCommandViewExternalZoomDefault, name = _('Zoom external normal'), category = _('View')},
    {combos = {{key = 'Num*', reformers = {'LAlt'}}}, down = iCommandViewSpeedUp, name = _('F11 Camera moving forward'), category = _('View')},
    {combos = {{key = 'Num/', reformers = {'LAlt'}}}, down = iCommandViewSlowDown, name = _('F11 Camera moving backward'), category = _('View')},

    {combos = {{key = 'F1'}}, 							down = iCommandViewCockpit, 			name = _('F1 Cockpit view'), 							category = _('View')},
    {combos = {{key = 'F1', reformers = {'LCtrl'}}}, 	down = iCommandNaturalViewCockpitIn, 	name = _('F1 Natural head movement view'), 				category = _('View')},
    {combos = {{key = 'F1', reformers = {'LAlt'}}}, 	down = iCommandViewHUDOnlyOnOff, 		name = _('F1 HUD only view switch'), 					category = _('View')},
    {combos = {{key = 'F2'}}, 							down = iCommandViewAir, 				name = _('F2 Aircraft view'), 							category = _('View')},
    {combos = {{key = 'F2', reformers = {'LCtrl'}}}, 	down = iCommandViewMe, 					name = _('F2 View own aircraft'), 						category = _('View')},
    {combos = {{key = 'F2', reformers = {'RAlt'}}}, 	down = iCommandViewFromTo, 				name = _('F2 Toggle camera position'), 					category = _('View')},
    {combos = {{key = 'F2', reformers = {'LAlt'}}}, 	down = iCommandViewLocal, 				name = _('F2 Toggle local camera control'), 			category = _('View')},
    {combos = {{key = 'F3'}}, 							down = iCommandViewTower, 				name = _('F3 Fly-By view'), 							category = _('View')},
    {combos = {{key = 'F3', reformers = {'LCtrl'}}}, 	down = iCommandViewTowerJump, 			name = _('F3 Fly-By jump view'), 						category = _('View')},
    {combos = {{key = 'F4'}}, 							down = iCommandViewRear, 				name = _('F4 Look back view'), 							category = _('View')},
    {combos = {{key = 'F4', reformers = {'LCtrl'}}}, 	down = iCommandViewChase, 				name = _('F4 Chase view'), 								category = _('View')},
    {combos = {{key = 'F4', reformers = {'LShift'}}},	down = iCommandViewChaseArcade, 		name = _('F4 Arcade Chase view'), 						category = _('View')},
    {combos = {{key = 'F5'}}, 							down = iCommandViewFight, 				name = _('F5 nearest AC view'), 						category = _('View')},
    {combos = {{key = 'F5', reformers = {'LCtrl'}}}, 	down = iCommandViewFightGround, 		name = _('F5 Ground hostile view'), 					category = _('View')},
    {combos = {{key = 'F6'}}, 							down = iCommandViewWeapons, 			name = _('F6 Released weapon view'), 					category = _('View')},
    {combos = {{key = 'F6', reformers = {'LCtrl'}}}, 	down = iCommandViewWeaponAndTarget, 	name = _('F6 Weapon to target view'), 					category = _('View')},
    {combos = {{key = 'F7'}}, 							down = iCommandViewGround, 				name = _('F7 Ground unit view'), 						category = _('View')},
    {combos = {{key = 'F8'}}, 							down = iCommandViewTargets, 			name = _('F8 Target view'), 							category = _('View')},
    {combos = {{key = 'F8', reformers = {'RCtrl'}}}, 	down = iCommandViewTargetType, 			name = _('F8 Player targets/All targets filter'), 		category = _('View')},
    {combos = {{key = 'F9'}}, 							down = iCommandViewNavy, 				name = _('F9 Ship view'), 								category = _('View')},
    {combos = {{key = 'F9', reformers = {'LAlt'}}}, 	down = iCommandViewLndgOfficer, 		name = _('F9 Landing signal officer view'), 			category = _('View')},
    {combos = {{key = 'F10'}}, 							down = iCommandViewAWACS, 				name = _('F10 Theater map view'), 						category = _('View')},
    {combos = {{key = 'F10', reformers = {'LCtrl'}}}, 	down = iCommandViewAWACSJump, 			name = _('F10 Jump to theater map view over current point'), category = _('View')},
    {combos = {{key = 'F11'}}, 							down = iCommandViewFree, 				name = _('F11 Airport free camera'), 					category = _('View')},
    {combos = {{key = 'F11', reformers = {'LCtrl'}}}, 	down = iCommandViewFreeJump, 			name = _('F11 Jump to free camera'), 					category = _('View')},
    {combos = {{key = 'F12'}}, 							down = iCommandViewStatic, 				name = _('F12 Static object view'), 					category = _('View')},
    {combos = {{key = 'F12', reformers = {'LCtrl'}}}, 	down = iCommandViewMirage, 				name = _('F12 Civil traffic view'), 					category = _('View')},
    {combos = {{key = 'F12', reformers = {'LShift'}}},	down = iCommandViewLocomotivesToggle, 	name = _('F12 Trains/cars toggle'), 					category = _('View')},
    {combos = {{key = 'F1', reformers = {'LWin'}}} , 	down = iCommandViewPitHeadOnOff, 		name = _('F1 Head shift movement on / off'), 			category = _('View')},

    {combos = {{key = ']', reformers = {'LShift'}}}, 	down = iCommandViewFastKeyboard, 	name = _('Keyboard Rate Fast'), 	category = _('View')},
    {combos = {{key = ']', reformers = {'LCtrl'}}}, 	down = iCommandViewSlowKeyboard, 	name = _('Keyboard Rate Slow'), 	category = _('View')},
    {combos = {{key = ']', reformers = {'LAlt'}}}, 		down = iCommandViewNormalKeyboard, 	name = _('Keyboard Rate Normal'), 	category = _('View')},
	{combos = {{key = '[', reformers = {'LShift'}}}, 	down = iCommandViewFastMouse, 		name = _('Mouse Rate Fast'), 		category = _('View')},
    {combos = {{key = '[', reformers = {'LCtrl'}}}, 	down = iCommandViewSlowMouse, 		name = _('Mouse Rate Slow'), 		category = _('View')},
    {combos = {{key = '[', reformers = {'LAlt'}}}, 		down = iCommandViewNormalMouse, 	name = _('Mouse Rate Normal'), 		category = _('View')},

    -- Cockpit view
    {combos = {{key = 'L', reformers = {'LAlt'}}}, down = 3256, cockpit_device_id = 0, value_down = 1.0, name = _('Flashlight'), category = _('View Cockpit')},

    {combos = {{key = 'Num0'}}, down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = _('Cockpit panel view in'), category = _('View Cockpit')},
    {combos = {{key = 'Num0', reformers = {'RCtrl'}}}, down = iCommandViewTempCockpitToggle, name = _('Cockpit panel view toggle'), category = _('View Cockpit')},
    --// Save current cockpit camera angles for fast numpad jumps  
    {combos = {{key = 'Num0', reformers = {'RAlt'}}}, down = iCommandViewSaveAngles, name = _('Save Cockpit Angles'), category = _('View Cockpit')},
    {combos = {{key = 'Num8', reformers = {'RShift'}}}, pressed = iCommandViewUp, up = iCommandViewStop, name = _('View up'), category = _('View Cockpit')},
    {combos = {{key = 'Num2', reformers = {'RShift'}}}, pressed = iCommandViewDown, up = iCommandViewStop, name = _('View down'), category = _('View Cockpit')},
    {combos = {{key = 'Num4', reformers = {'RShift'}}}, pressed = iCommandViewLeft, up = iCommandViewStop, name = _('View left'), category = _('View Cockpit')},
    {combos = {{key = 'Num6', reformers = {'RShift'}}}, pressed = iCommandViewRight, up = iCommandViewStop, name = _('View right'), category = _('View Cockpit')},
    {combos = {{key = 'Num9', reformers = {'RShift'}}}, pressed = iCommandViewUpRight, up = iCommandViewStop, name = _('View up right'), category = _('View Cockpit')},
    {combos = {{key = 'Num3', reformers = {'RShift'}}}, pressed = iCommandViewDownRight, up = iCommandViewStop, name = _('View down right'), category = _('View Cockpit')},
    {combos = {{key = 'Num1', reformers = {'RShift'}}}, pressed = iCommandViewDownLeft, up = iCommandViewStop, name = _('View down left'), category = _('View Cockpit')},
    {combos = {{key = 'Num7', reformers = {'RShift'}}}, pressed = iCommandViewUpLeft, up = iCommandViewStop, name = _('View up left'), category = _('View Cockpit')},

    -- Cockpit Camera Motion
    {combos = {{key = 'Num8', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveUp, up = iCommandViewPitCameraMoveStop, name = _('Cockpit Camera Move Up'), category = _('View Cockpit')},
    {combos = {{key = 'Num2', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveDown, up = iCommandViewPitCameraMoveStop, name = _('Cockpit Camera Move Down'), category = _('View Cockpit')},
    {combos = {{key = 'Num4', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveLeft, up = iCommandViewPitCameraMoveStop, name = _('Cockpit Camera Move Left'), category = _('View Cockpit')},
    {combos = {{key = 'Num6', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveRight, up = iCommandViewPitCameraMoveStop, name = _('Cockpit Camera Move Right'), category = _('View Cockpit')},
    {combos = {{key = 'Num*', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveForward, up = iCommandViewPitCameraMoveStop, name = _('Cockpit Camera Move Forward'), category = _('View Cockpit')},
    {combos = {{key = 'Num-', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveBack, up = iCommandViewPitCameraMoveStop, name = _('Cockpit Camera Move Back'), category = _('View Cockpit')},
    {combos = {{key = 'Num5', reformers = {'RCtrl','RShift'}}}, down = iCommandViewPitCameraMoveCenter, name = _('Cockpit Camera Move Center'), category = _('View Cockpit')},

    {combos = {{key = 'Num8', reformers = {'RCtrl'}}}, down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = _('Glance up'), category = _('View Cockpit')},
    {combos = {{key = 'Num2', reformers = {'RCtrl'}}}, down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = _('Glance down'), category = _('View Cockpit')},
    {combos = {{key = 'Num4', reformers = {'RCtrl'}}}, down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = _('Glance left'), category = _('View Cockpit')},
    {combos = {{key = 'Num6', reformers = {'RCtrl'}}}, down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = _('Glance right'), category = _('View Cockpit')},
    {combos = {{key = 'Num7', reformers = {'RCtrl'}}}, down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = _('Glance up-left'), category = _('View Cockpit')},
    {combos = {{key = 'Num1', reformers = {'RCtrl'}}}, down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = _('Glance down-left'), category = _('View Cockpit')},
    {combos = {{key = 'Num9', reformers = {'RCtrl'}}}, down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = _('Glance up-right'), category = _('View Cockpit')},
    {combos = {{key = 'Num3', reformers = {'RCtrl'}}}, down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = _('Glance down-right'), category = _('View Cockpit')},
    {combos = {{key = 'Z', reformers = {'LAlt','LShift'}}}, down = iCommandViewPanToggle, name = _('Camera pan mode toggle'), category = _('View Cockpit')},

    {combos = {{key = 'Num8', reformers = {'RAlt'}}}, down = iCommandViewCameraUpSlow, name = _('Camera snap view up'), category = _('View Cockpit')},
    {combos = {{key = 'Num2', reformers = {'RAlt'}}}, down = iCommandViewCameraDownSlow, name = _('Camera snap view down'), category = _('View Cockpit')},
    {combos = {{key = 'Num4', reformers = {'RAlt'}}}, down = iCommandViewCameraLeftSlow, name = _('Camera snap view left'), category = _('View Cockpit')},
    {combos = {{key = 'Num6', reformers = {'RAlt'}}}, down = iCommandViewCameraRightSlow, name = _('Camera snap view right'), category = _('View Cockpit')},
    {combos = {{key = 'Num7', reformers = {'RAlt'}}}, down = iCommandViewCameraUpLeftSlow, name = _('Camera snap view up-left'), category = _('View Cockpit')},
    {combos = {{key = 'Num1', reformers = {'RAlt'}}}, down = iCommandViewCameraDownLeftSlow, name = _('Camera snap view down-left'), category = _('View Cockpit')},
    {combos = {{key = 'Num9', reformers = {'RAlt'}}}, down = iCommandViewCameraUpRightSlow, name = _('Camera snap view up-right'), category = _('View Cockpit')},
    {combos = {{key = 'Num3', reformers = {'RAlt'}}}, down = iCommandViewCameraDownRightSlow, name = _('Camera snap view down-right'), category = _('View Cockpit')},
    {combos = {{key = 'Num5', reformers = {'RShift'}}}, down = iCommandViewCameraCenter, name = _('Center Camera View'), category = _('View Cockpit')},
    {combos = {{key = 'Num5', reformers = {'RCtrl'}}}, down = iCommandViewCameraReturn, name = _('Return Camera'), category = _('View Cockpit')},
    {combos = {{key = 'Num5', reformers = {'RAlt'}}}, down = iCommandViewCameraBaseReturn, name = _('Return Camera Base'), category = _('View Cockpit')},

    {combos = {{key = 'Num0', reformers = {'LWin'}}}, down = iCommandViewSnapView0,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  0'), category = _('View Cockpit')},
    {combos = {{key = 'Num1', reformers = {'LWin'}}}, down = iCommandViewSnapView1,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  1'), category = _('View Cockpit')},
    {combos = {{key = 'Num2', reformers = {'LWin'}}}, down = iCommandViewSnapView2,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  2'), category = _('View Cockpit')},
    {combos = {{key = 'Num3', reformers = {'LWin'}}}, down = iCommandViewSnapView3,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  3'), category = _('View Cockpit')},
    {combos = {{key = 'Num4', reformers = {'LWin'}}}, down = iCommandViewSnapView4,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  4'), category = _('View Cockpit')},
    {combos = {{key = 'Num5', reformers = {'LWin'}}}, down = iCommandViewSnapView5,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  5'), category = _('View Cockpit')},
    {combos = {{key = 'Num6', reformers = {'LWin'}}}, down = iCommandViewSnapView6,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  6'), category = _('View Cockpit')},
    {combos = {{key = 'Num7', reformers = {'LWin'}}}, down = iCommandViewSnapView7,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  7'), category = _('View Cockpit')},
    {combos = {{key = 'Num8', reformers = {'LWin'}}}, down = iCommandViewSnapView8,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  8'), category = _('View Cockpit')},
    {combos = {{key = 'Num9', reformers = {'LWin'}}}, down = iCommandViewSnapView9,	up = iCommandViewSnapViewStop, name = _('Custom Snap View  9'), category = _('View Cockpit')},

    {combos = {{key = 'Num*', reformers = {'RShift'}}}, pressed = iCommandViewForward, 	up = iCommandViewForwardStop, 	name = _('Zoom in'), 	category = _('View Cockpit')},
    {combos = {{key = 'Num/', reformers = {'RShift'}}}, pressed = iCommandViewBack, 	up = iCommandViewBackStop, 		name = _('Zoom out'), 	category = _('View Cockpit')},

    -- Extended view
    {combos = {{key = 'J', reformers = {'LShift'}}}, 			down = iCommandViewCameraJiggle, 	name = _('Camera jiggle toggle'), 					category = _('View Extended')},
    {combos = {{key = 'K', reformers = {'LAlt'}}}, 				down = iCommandViewKeepTerrain, 	name = _('Keep terrain camera altitude'), 			category = _('View Extended')},
    {combos = {{key = 'Home', reformers = {'RCtrl','RShift'}}}, down = iCommandViewFriends, 		name = _('View friends mode'), 						category = _('View Extended')},
    {combos = {{key = 'End', reformers = {'RCtrl' ,'RShift'}}}, down = iCommandViewEnemies, 		name = _('View enemies mode'), 						category = _('View Extended')},
    {combos = {{key = 'Delete', reformers = {'RCtrl'}}}, 		down = iCommandViewAll, 			name = _('View all mode'), 							category = _('View Extended')},
    {combos = {{key = 'Num+', reformers = {'RCtrl'}}}, 			down = iCommandViewPlus, 			name = _('Toggle tracking launched weapon'), 		category = _('View Extended')},
    {combos = {{key = 'PageDown', reformers = {'LCtrl'}}}, 		down = iCommandViewSwitchForward, 	name = _('Objects switching direction forward '), 	category = _('View Extended')},
    {combos = {{key = 'PageUp', reformers = {'LCtrl'}}}, 		down = iCommandViewSwitchReverse, 	name = _('Objects switching direction reverse '), 	category = _('View Extended')},
    {combos = {{key = 'Delete', reformers = {'LAlt'}}}, 		down = iCommandViewObjectIgnore, 	name = _('Object exclude '), 						category = _('View Extended')},
    {combos = {{key = 'Insert', reformers = {'LAlt'}}}, 		down = iCommandViewObjectsAll, 		name = _('Objects all excluded - include'), 		category = _('View Extended')},

    -- Padlock
    {combos = {{key = 'Num.'}}, 						down = iCommandViewLock,				name = _('Lock View (cycle padlock)'),	category = _('View Padlock')},
    {combos = {{key = 'NumLock'}},						down = iCommandViewUnlock,				name = _('Unlock view (stop padlock)'), category = _('View Padlock')},
    {combos = {{key = 'Num.', reformers = {'RShift'}}}, down = iCommandAllMissilePadlock,		name = _('All missiles padlock'),		category = _('View Padlock')},
    {combos = {{key = 'Num.', reformers = {'RAlt'}}},	down = iCommandThreatMissilePadlock,	name = _('Threat missile padlock'),		category = _('View Padlock')},
    {combos = {{key = 'Num.', reformers = {'RCtrl'}}},	down = iCommandViewTerrainLock,			name = _('Lock terrain view'),			category = _('View Padlock')},

    -- Labels
    {combos = {{key = 'F10', reformers = {'LShift'}}},	down = iCommandMarkerState,				name = _('All Labels'),					category = _('Labels')},
    {combos = {{key = 'F2', reformers = {'LShift'}}},	down = iCommandMarkerStatePlane,		name = _('Aircraft Labels'),			category = _('Labels')},
    {combos = {{key = 'F6', reformers = {'LShift'}}},	down = iCommandMarkerStateRocket,		name = _('Missile Labels'),				category = _('Labels')},
    {combos = {{key = 'F9', reformers = {'LShift'}}},	down = iCommandMarkerStateShip,			name = _('Vehicle & Ship Labels'),		category = _('Labels')},

	--[[--Kneeboard未见定义
    {combos = {{key = 'K', reformers = {'RShift'}}}, 			down = iCommandPlaneShowKneeboard	, name = _('Kneeboard ON/OFF'), category = _('Kneeboard')},
    {combos = {{key = 'K'}}						   , 			down = iCommandPlaneShowKneeboard	, up = iCommandPlaneShowKneeboard ,value_down = 1.0,value_up = -1.0, name = _('Kneeboard glance view')  , category = _('Kneeboard')},
    {combos = {{key = ']'}}						   , 			down = 3001		, cockpit_device_id  = kneeboard_id, value_down = 1.0, name = _('Kneeboard Next Page')  , category = _('Kneeboard')},
    {combos = {{key = '['}}						   , 			down = 3002		, cockpit_device_id  = kneeboard_id, value_down = 1.0, name = _('Kneeboard Previous Page'), category = _('Kneeboard')},
    {combos = {{key = 'K', reformers = {'RCtrl'}}} , 			down = 3003		, cockpit_device_id  = kneeboard_id,value_down = 1.0, name = _('Kneeboard current position mark point')  , category = _('Kneeboard')},
    --shortcuts navigation 未见定义
    {down = 3004		, cockpit_device_id  = kneeboard_id,value_down =  1.0, name = _('Kneeboard Make Shortcut'), category = _('Kneeboard')},
    {down = 3005		, cockpit_device_id  = kneeboard_id,value_down =  1.0, name = _('Kneeboard Next Shortcut'), category = _('Kneeboard')},
    {down = 3005		, cockpit_device_id  = kneeboard_id,value_down = -1.0, name = _('Kneeboard Previous Shortcut')  , category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 0   , name = _('Kneeboard Jump To Shortcut  1'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 1   , name = _('Kneeboard Jump To Shortcut  2'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 2   , name = _('Kneeboard Jump To Shortcut  3'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 3   , name = _('Kneeboard Jump To Shortcut  4'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 4   , name = _('Kneeboard Jump To Shortcut  5'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 5   , name = _('Kneeboard Jump To Shortcut  6'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 6   , name = _('Kneeboard Jump To Shortcut  7'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 7   , name = _('Kneeboard Jump To Shortcut  8'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 8   , name = _('Kneeboard Jump To Shortcut  9'), category = _('Kneeboard')},
    {down = 3006		, cockpit_device_id  = kneeboard_id,value_down = 9   , name = _('Kneeboard Jump To Shortcut 10'), category = _('Kneeboard')},
	]]

    -- Flight Control
    {combos = {{key = 'J'}},		down = Keys.PlaneAUTOnOff, 											name = _('Autothrust'), 			category = _('Autopilot')},
    {combos = {{key = 'Up'}}, 		down = Keys.PlaneUpStart, 			up = Keys.PlaneUpStop, 			name = _('Aircraft Pitch Down'), 	category = _('Flight Control')},
    {combos = {{key = 'Down'}}, 	down = Keys.PlaneDownStart, 		up = Keys.PlaneDownStop, 		name = _('Aircraft Pitch Up'), 		category = _('Flight Control')},
    {combos = {{key = 'Left'}}, 	down = Keys.PlaneLeftStart, 		up = Keys.PlaneLeftStop, 		name = _('Aircraft Bank Left'), 	category = _('Flight Control')},
    {combos = {{key = 'Right'}},	down = Keys.PlaneRightStart,		up = Keys.PlaneRightStop, 		name = _('Aircraft Bank Right'), 	category = _('Flight Control')},
    {combos = {{key = 'Z'}},		down = Keys.PlaneLeftRudderStart,	up = Keys.PlaneLeftRudderStop, 	name = _('Aircraft Rudder Left'), 	category = _('Flight Control')},
    {combos = {{key = 'X'}},		down = Keys.PlaneRightRudderStart,	up = Keys.PlaneRightRudderStop, name = _('Aircraft Rudder Right'), 	category = _('Flight Control')},

	--[[--没有Trim
	--	{combos = {{key = '.', reformers = {'RCtrl'}}}, pressed = Keys.PlaneTrimUp,         	up = Keys.PlaneTrimStop, 	name = _('Trim: Nose Up'),        	category = _('Flight Control')},
	--	{combos = {{key = ';', reformers = {'RCtrl'}}}, pressed = Keys.PlaneTrimDown,       	up = Keys.PlaneTrimStop, 	name = _('Trim: Nose Down'),      	category = _('Flight Control')},
	--	{combos = {{key = ',', reformers = {'RCtrl'}}}, pressed = Keys.PlaneTrimLeft,       	up = Keys.PlaneTrimStop, 	name = _('Trim: Left Wing Down'), 	category = _('Flight Control')},
	--	{combos = {{key = '/', reformers = {'RCtrl'}}}, pressed = Keys.PlaneTrimRight,      	up = Keys.PlaneTrimStop, 	name = _('Trim: Right Wing Down'),	category = _('Flight Control')},
	--	{combos = {{key = 'Z', reformers = {'RCtrl'}}}, pressed = Keys.PlaneTrimLeftRudder, 	up = Keys.PlaneTrimStop, 	name = _('Trim: Rudder Left'),    	category = _('Flight Control')},
	--	{combos = {{key = 'X', reformers = {'RCtrl'}}}, pressed = Keys.PlaneTrimRightRudder,	up = Keys.PlaneTrimStop, 	name = _('Trim: Rudder Right'),   	category = _('Flight Control')},
	]]

    {combos = {{key = 'Num+'}},
		pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  name = _('Throttle Up'), category = _('Flight Control')},
    {combos = {{key = 'Num-'}},
		pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  name = _('Throttle Down'), category = _('Flight Control')},
    {combos = {{key = 'Num+', reformers = {'RAlt'}}},
		pressed = iCommandThrottle1Increase,up = iCommandThrottle1Stop, name = _('Throttle Left Up'), category = _('Flight Control')},
    {combos = {{key = 'Num-', reformers = {'RAlt'}}},
		pressed = iCommandThrottle1Decrease,up = iCommandThrottle1Stop, name = _('Throttle Left Down'), category = _('Flight Control')},
    {combos = {{key = 'Num+', reformers = {'RShift'}}},
		pressed = iCommandThrottle2Increase,up = iCommandThrottle2Stop, name = _('Throttle Right Up'), category = _('Flight Control')},
    {combos = {{key = 'Num-', reformers = {'RShift'}}},
		pressed = iCommandThrottle2Decrease,up = iCommandThrottle2Stop, name = _('Throttle Right Down'), category = _('Flight Control')},
    {combos = {{key = 'PageUp', reformers = {'RAlt'}}},
		down = iCommandPlaneAUTIncreaseRegimeLeft, name = _('Throttle Step Up Left'), category = _('Flight Control')},
    {combos = {{key = 'PageDown', reformers = {'RAlt'}}},
		down = iCommandPlaneAUTDecreaseRegimeLeft, name = _('Throttle Step Down Left'), category = _('Flight Control')},
    {combos = {{key = 'PageUp', reformers = {'RShift'}}},
		down = iCommandPlaneAUTIncreaseRegimeRight, name = _('Throttle Step Up Right'), category = _('Flight Control')},
    {combos = {{key = 'PageDown', reformers = {'RShift'}}},
		down = iCommandPlaneAUTDecreaseRegimeRight, name = _('Throttle Step Down Right'), category = _('Flight Control')},
    {combos = {{key = 'E', reformers = {'LShift'}}},
		down = iCommandPlane_P_51_WarEmergencyPower,up = iCommandPlane_P_51_WarEmergencyPower, value_down = 1,value_up = 0, name = _('Special Afterburner Mode'), category = _('Flight Control')},--1601

	--{combos = {{key = 'PageUp'}}, down = iCommandPlaneAUTIncreaseRegime, name = _('Throttle Step Up'), category = _('Flight Control')},
    --{combos = {{key = 'PageDown'}}, down = iCommandPlaneAUTDecreaseRegime, name = _('Throttle Step Down'), category = _('Flight Control')},

    -- Systems
    {combos = {{key = '1'}},down = Keys.A2A, name = _('A2A'), category = _('Systems')},
    {combos = {{key = '2'}},down = Keys.A2G, name = _('A2G'), category = _('Systems')},
	--{down = iCommandPlaneFonar, 				name = _('Canopy Open/Close'), 		category = _('Systems')},
    {combos = {{key = 'B'}}, down = Keys.PlaneAirBrake, name = _('Airbrake'), category = _('Systems')},
    {combos = {{key = 'B', reformers = {'LShift'}}}, down = Keys.PlaneAirBrakeOn, name = _('Airbrake On'), category = _('Systems')},
    {combos = {{key = 'B', reformers = {'LCtrl'}}}, down = Keys.PlaneAirBrakeOff, name = _('Airbrake Off'), category = _('Systems')},

    {combos = {{key = 'P'}}, down = Keys.PlaneParachute, name = _('Drag Chute DEPLOY'), category = _('Systems')},

    {combos = {{key = 'T'}}, down = iCommandPlaneWingtipSmokeOnOff, name = _('Smoke'), category = _('Systems')},
    {combos = {{key = 'L'}}, down = iCommandPlaneCockpitIllumination, name = _('Illumination Cockpit'), category = _('Systems')},

    {combos = {{key = 'F'}}, down = Keys.PlaneFlaps, name = _('Flaps Up/Down'), category = _('Systems')},
    {combos = {{key = 'F', reformers = {'LCtrl'}}}, down = Keys.PlaneFlapsOn, name = _('Flaps Down'), category = _('Systems')},
    {combos = {{key = 'F', reformers = {'LShift'}}}, down = Keys.PlaneFlapsOff, name = _('Flaps Up'), category = _('Systems')},
    --{combos = {{key = 'F', reformers = {'LAlt'}}}, down = Keys.PlaneFlapsStop, name = _('Flaps Stop'), category = _('Systems')},

    {combos = {{key = 'G'}}, down = Keys.PlaneGear, name = _('Landing Gear Up/Down'), category = _('Systems')},
    {combos = {{key = 'G', reformers = {'LCtrl'}}}, down = Keys.PlaneGearUp, name = _('Landing Gear Up'), category = _('Systems')},
    {combos = {{key = 'G', reformers = {'LShift'}}}, down = Keys.PlaneGearDown, name = _('Landing Gear Down'), category = _('Systems')},

    {combos = {{key = 'W'}}, down = Keys.PlaneWheelBrakeOn, up = Keys.PlaneWheelBrakeOff, name = _('Wheel Brake On'), category = _('Systems')},
    {combos = {{key = 'C', reformers = {'LCtrl'}}}, down = Keys.PlaneFonar, name = _('Canopy Open/Close'), category = _('Systems')},
    {combos = {{key = 'R'}}, down = Keys.PlaneFuelOn, up = Keys.PlaneFuelOff, name = _('Fuel Dump'), category = _('Systems')},
    {combos = {{key = 'E', reformers = {'LCtrl'}}}, down = Keys.Eject,					name = _('Eject (3 times)'),						category = _('Systems')},
    {combos = {{key = 'S'}}, down = Keys.Plane_HOTAS_NoseWheelSteeringButton, up = Keys.Plane_HOTAS_NoseWheelSteeringButton,value_down=1,value_up=0, name = _('Nose Gear Maneuvering Range'), category = _('Systems')},
    {combos = {{key = 'Q', reformers = {'LAlt'}}}, down = Keys.Plane_HOTAS_NoseWheelSteeringButtonOff, name = _('Nose Wheel Steering'), category = _('Systems')},

    -- Communications
    {combos = {{key = 'I', reformers = {'LWin'}}}, down = iCommandAWACSTankerBearing, name = _('Request AWACS Available Tanker'), category = _('Communications')},
    {combos = {{key = '\\', reformers = {'RShift'}}, {key = 'M', reformers = {'RShift'}}}, down = iCommandToggleReceiveMode, name = _('Receive Mode'), category = _('Communications')},

    -- Weapon
    {combos = {{key = 'Space'}},
		down = Keys.WeaponLaunch, up = Keys.WeaponLaunch, value_down = 1, value_up = 0, name = _('Weapon Launch'), category = _('Weapons')},
    {combos = {{key = 'W', reformers = {'LAlt'}}},
		down = Keys.EmergJettion, value_down = 1, name = _('Emergency Jettison'), category = _('Weapons')},
	{combos = {{key = 'M'}},
		down = Keys.masterArm, name = _('Master Arm Switch'), category = _('Weapons')},
	{	down = Keys.PlaneAHCPMasterArm, name = _('Master Arm On'), category = _('Weapons')},
    {	down = Keys.PlaneAHCPMasterSafe, name = _('Master Arm Safe'), category = _('Weapons')},

	-- Countermeasures
    {combos = {{key = 'Delete'}},
		down = Keys.DropFlare, name = _('Countermeasures Flares Dispense'), category = _('Countermeasures')},
    {combos = {{key = 'Insert'}},
		down = Keys.DropChaff, name = _('Countermeasures Chaff Dispense'), category = _('Countermeasures')},
    {combos = {{key = 'Q'}},
		down = Keys.DropChaffAndFlare, name = _('Countermeasures Release'), category = _('Countermeasures')},
    {combos = {{key = 'E'}},
		down = Keys.ActiveJamming, name = _('ECM'), category = _('Countermeasures')},
	-- HOTAS
    {combos = {{key = 'X',reformers = {'LShift'}}},
		down = Keys.GunMode, name = _('Gun Mode Button'), cockpit_device_id = devices.WEAPON_SYSTEM, category={_('Weapons'),_('Stick'),_('HOTAS')}},
    {	down = Keys.GunMode, up = Keys.GunMode, value_down = 1.0, value_up = 0.0, name=_('Gun Mode Switch'), cockpit_device_id = devices.WEAPON_SYSTEM, category={_('Weapons'),_('Stick'),_('HOTAS')}},
	{	down = Keys.GunMode, value_down = 1.0, name=_('Gun Mode On'), cockpit_device_id = devices.WEAPON_SYSTEM, category = {_('Weapons'),_('Stick'),_('HOTAS')}},
	{	down = Keys.GunMode, value_down = 0.0, name=_('Gun Mode Off'), cockpit_device_id = devices.WEAPON_SYSTEM, category = {_('Weapons'),_('Stick'),_('HOTAS')}},
	{combos = {{key = ';',reformers = {'RAlt'}}},
		down = Keys.STICK_SENSOR_CONTROL_FWD, up = Keys.STICK_SENSOR_CONTROL_FWD, value_down =  1.0, value_up = 0.0, name = _('Sensor Control Switch - Fwd'), category = {_('Stick'), _('HOTAS')}},
    {combos = {{key = '.',reformers = {'RAlt'}}},
		down = Keys.STICK_SENSOR_CONTROL_AFT, up = Keys.STICK_SENSOR_CONTROL_AFT, value_down =  1.0, value_up = 0.0, name = _('Sensor Control Switch - Aft'), category = {_('Stick'), _('HOTAS')}},
    {combos = {{key = ',',reformers = {'RAlt'}}},
		down = Keys.STICK_SENSOR_CONTROL_LEFT, up = Keys.STICK_SENSOR_CONTROL_LEFT, value_down =  1.0, value_up = 0.0, name = _('Sensor Control Switch - Left'), category = {_('Stick'), _('HOTAS')}},
    {combos = {{key = '/',reformers = {'RAlt'}}},
		down = Keys.STICK_SENSOR_CONTROL_RIGHT, up = Keys.STICK_SENSOR_CONTROL_RIGHT, value_down =  1.0, value_up = 0.0, name = _('Sensor Control Switch - Right'), category = {_('Stick'), _('HOTAS')}},
    {combos = {{key = 'D'}},
		down = Keys.WeaponSelectNext, name = _('Weapon Select Next'), category = {_('Weapons'),_('Stick'), _('HOTAS')}},
    {down = Keys.Plane_HOTAS_TargetManagementSwitchUp,		up = Keys.Plane_HOTAS_TargetManagementSwitchOff,	name = _('Target Management Switch - Up'),		category = {_('Stick'), _('HOTAS')}},
    {down = Keys.Plane_HOTAS_TargetManagementSwitchDown,	up = Keys.Plane_HOTAS_TargetManagementSwitchOff,	name = _('Target Management Switch - Down'),	category = {_('Stick'), _('HOTAS')}},
    {down = Keys.Plane_HOTAS_TargetManagementSwitchLeft,	up = Keys.Plane_HOTAS_TargetManagementSwitchOff,	name = _('Target Management Switch - Left'),	category = {_('Stick'), _('HOTAS')}},
    {down = Keys.Plane_HOTAS_TargetManagementSwitchRight,	up = Keys.Plane_HOTAS_TargetManagementSwitchOff,	name = _('Target Management Switch - Right'),	category = {_('Stick'), _('HOTAS')}},

	--Sensors
    {combos = {{key = 'Enter'}},
		down = iCommandPlane_LockOn_start, up = iCommandPlane_LockOn_finish, name = _('Target Lock'), category = _('Sensors')},
    {combos = {{key = ';'}},
		pressed = Keys.PlaneRadarUp, up = Keys.PlaneRadarStop, name = _('Target Designator Up'), category = _('Sensors')},
    {combos = {{key = '.'}},
		pressed = Keys.PlaneRadarDown, up = Keys.PlaneRadarStop, name = _('Target Designator Down'), category = _('Sensors')},
    {combos = {{key = ','}},
		pressed = Keys.PlaneRadarLeft, up = Keys.PlaneRadarStop, name = _('Target Designator Left'), category = _('Sensors')},
    {combos = {{key = '/'}},
		pressed = Keys.PlaneRadarRight, up = Keys.PlaneRadarStop, name = _('Target Designator Right'), category = _('Sensors')},
    {combos = {{key = ';', reformers = { 'RShift' } } },
		pressed = Keys.SelecterUp, up = Keys.SelecterStop,name = _('Scan Zone Up'),category = _('Sensors') },
    {combos = {{key = '.', reformers = { 'RShift' } } },
		pressed = Keys.SelecterDown,up = Keys.SelecterStop,name = _('Scan Zone Down'),category = _('Sensors') },
    {combos = {{key = ',', reformers = { 'RShift' } } },
		pressed = Keys.SelecterLeft,up = Keys.SelecterStop,name = _('Scan Zone Left'),category = _('Sensors') },
    {combos = {{key = '/', reformers = { 'RShift' } } },
		pressed = Keys.SelecterRight,up = Keys.SelecterStop,name = _('Scan Zone Right'),category = _('Sensors') },
    {combos = {{key = '='}},
		down = Keys.PlaneZoomIn, name = _('Display Zoom In'), category = _('Sensors')},
    {combos = {{key = '-'}},
		down = Keys.PlaneZoomOut, name = _('Display Zoom Out'), category = _('Sensors')},
    {down = Keys.PlaneRadarReset,	name = _('Radar Reset'), 		category = _('Sensors')},
	{combos = {{key = 'N'}},
		down = Keys.ViewNightVisionGogglesOn, name = _('Night Vision Goggles'), category = _('Sensors')},
    {combos = {{key = 'N', reformers = {'RCtrl'}}},
		pressed = Keys.Plane_Helmet_Brightess_Up, name = _('Night Vision Goggles Gain Up'), category = _('Sensors')},
    {combos = {{key = 'N', reformers = {'RCtrl','RShift'}}},
		pressed = Keys.Plane_Helmet_Brightess_Down, name = _('Night Vision Goggles Gain Down'), category = _('Sensors')},

	{down = Keys.PlaneZoomIn, 											name = _('Display Zoom In'), 				category = _('Sensors')},
    {down = Keys.PlaneZoomOut, 											name = _('Display Zoom Out'), 				category = _('Sensors')},
    {down = Keys.ViewNightVisionGogglesOn, 								name = _('Night Vision Goggles'), 			category = _('Sensors')},

    --Electric Systems
    {down = Keys.PlaneAirRefuel, 	name = _('Refueling Boom'), 	category = 'Fuel Systems'},
    {down = Keys.Battery, 			name = _('Battery Power'), 		category = _('Electric Systems')},
    {down = Keys.LeftAcGenerator, 	name = _('Left Generator'), 	category = _('Electric Systems')},
    {down = Keys.RightAcGenerator, 	name = _('Right Generator'), 	category = _('Electric Systems')},
    {down = Keys.GndPower, 			name = _('Ground Power'), 		category = _('Electric Systems')},

	--Engine Systems
    {down = Keys.EngStartSelector, name = _('Engine Start Selector'), category = _('Engine Systems')},
    {down = Keys.EngStartor, up = Keys.EngStartor,value_down = 1,value_up = 0, name = _('Engine Startor'), category = _('Engine Systems')},
    {down = Keys.LeftThrottorIdle, name = _('Left Throttle Idle/Off'), category = _('Engine Systems')},
    {down = Keys.RightThrottorIdle, name = _('Right Throttle Idle/Off'), category = _('Engine Systems')},
	--Lights Systems
    {combos = {{key = 'L', reformers = {'RCtrl'}}}, down = Keys.PlaneNavLightOnOff, name = _('Navigation Lights Bright/Off'), category = _('Lights Systems')},
    {combos = {{key = 'L', reformers = {'RCtrl','RAlt'}}}, down = Keys.PlaneAntiCollisionLightOnOff, name = _('Anti Collision Lights On/Off'), category = _('Lights Systems')},
    {combos = {{key = 'L', reformers = {'RAlt'}}}, down = Keys.PlaneHeadingLightOnOff, name = _('Taxi Lights On/Off'), category = _('Lights Systems')},
    {down = iCommandPlaneLightsOnOff, name = _('Plane lights'), category = _('Lights Systems')},
    {down = iCommandPlaneHeadLightOnOff, name = _('Gear Light Near/Far/Off'), category = _('Lights Systems')},

	{down = click_cmd.flood_light, 				cockpit_device_id = devices.LIGHT, value_down = 1.0, name = _('Flood Light On'), 			category = _('Lights Systems')},
	{down = click_cmd.flood_light, 				cockpit_device_id = devices.LIGHT, value_down = 0.0, name = _('Flood Light Off'), 			category = _('Lights Systems')},
	{down = Keys.flood_light_BRT_Increase, 		cockpit_device_id = devices.LIGHT, name = _('Flood Light BRT +'), 		category = _('Lights Systems')},
	{down = Keys.flood_light_BRT_Decrease, 		cockpit_device_id = devices.LIGHT, name = _('Flood Light BRT -'), 		category = _('Lights Systems')},

	{down = click_cmd.background_light, 		cockpit_device_id = devices.LIGHT, value_down = 1.0, name = _('Background Light On'), 		category = _('Lights Systems')},
	{down = click_cmd.background_light, 		cockpit_device_id = devices.LIGHT, value_down = 0.0, name = _('Background Light Off'), 		category = _('Lights Systems')},
	{down = Keys.background_light_BRT_Increase, cockpit_device_id = devices.LIGHT, name = _('Background Light BRT +'), 	category = _('Lights Systems')},
	{down = Keys.background_light_BRT_Decrease, cockpit_device_id = devices.LIGHT, name = _('Background Light BRT -'), 	category = _('Lights Systems')},
	--Fuel Systems
	{combos = {{key = 'R', reformers = {'LCtrl'}}}, down = Keys.PlaneAirRefuel, name = _('Refueling Boom'), category = _('Fuel Systems')},
    --HMD
	{down = click_cmd.hmdPower, cockpit_device_id = devices.HELMET, value_down =  1.0, name = _('HMD Power On'),  category = _('HMD')},
	{down = click_cmd.hmdPower, cockpit_device_id = devices.HELMET, value_down = -1.0, name = _('HMD Power Off'), category = _('HMD')},
    {down = click_cmd.hmdBrt, 		cockpit_device_id = devices.HELMET, value_down = 1.0, name = _('HMD BRT On'), 		category = _('HMD')},
	{down = click_cmd.hmdBrt, 		cockpit_device_id = devices.HELMET, value_down = 0.0, name = _('HMD BRT Off'), 		category = _('HMD')},

	--HUD
	{down = click_cmd.hudBrt, 		cockpit_device_id = devices.HUD_DCMS, value_down = 1.0, name = _('HUD On'), 		category = _('HUD')},
	{down = click_cmd.hudBrt, 		cockpit_device_id = devices.HUD_DCMS, value_down = 0.0, name = _('HUD Off'), 		category = _('HUD')},
	{down = Keys.HUD_BRT_Increase, cockpit_device_id = devices.HUD_DCMS, name = _('HUD BRT +'), 	category = _('HUD')},
	{down = Keys.HUD_BRT_Decrease, cockpit_device_id = devices.HUD_DCMS, name = _('HUD BRT -'), 	category = _('HUD')},
	--UFCP
	{down = click_cmd.UFCPBrt, 		cockpit_device_id = devices.UFCP, value_down = 1.0, name = _('UFCP On'), 		category = _('UFCP System')},
	{down = click_cmd.UFCPBrt, 		cockpit_device_id = devices.UFCP, value_down = 0.0, name = _('UFCP Off'), 		category = _('UFCP System')},
	--UFCP
	{down = UFCP_click_cmd.key0_dn, up = UFCP_click_cmd.key0_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 0'), category = _('UFCP')},
    {down = UFCP_click_cmd.key1_dn, up = UFCP_click_cmd.key1_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 1'), category = _('UFCP')},
    {down = UFCP_click_cmd.key2_dn, up = UFCP_click_cmd.key2_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 2'), category = _('UFCP')},
    {down = UFCP_click_cmd.key3_dn, up = UFCP_click_cmd.key3_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 3'), category = _('UFCP')},
    {down = UFCP_click_cmd.key4_dn, up = UFCP_click_cmd.key4_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 4'), category = _('UFCP')},
    {down = UFCP_click_cmd.key5_dn, up = UFCP_click_cmd.key5_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 5'), category = _('UFCP')},
    {down = UFCP_click_cmd.key6_dn, up = UFCP_click_cmd.key6_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 6'), category = _('UFCP')},
    {down = UFCP_click_cmd.key7_dn, up = UFCP_click_cmd.key7_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 7'), category = _('UFCP')},
    {down = UFCP_click_cmd.key8_dn, up = UFCP_click_cmd.key8_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 8'), category = _('UFCP')},
    {down = UFCP_click_cmd.key9_dn, up = UFCP_click_cmd.key9_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Key 9'), category = _('UFCP')},
    {down = UFCP_click_cmd.Enter_dn, up = UFCP_click_cmd.Enter_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Enter'), category = _('UFCP')},
    {down = UFCP_click_cmd.Clear_dn, up = UFCP_click_cmd.Clear_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Clear'), category = _('UFCP')},
    {down = UFCP_click_cmd.L1_dn, up = UFCP_click_cmd.L1_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP L1'), category = _('UFCP')},
    {down = UFCP_click_cmd.L2_dn, up = UFCP_click_cmd.L2_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP L2'), category = _('UFCP')},
    {down = UFCP_click_cmd.L3_dn, up = UFCP_click_cmd.L3_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP L3'), category = _('UFCP')},
    {down = UFCP_click_cmd.L4_dn, up = UFCP_click_cmd.L4_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP L4'), category = _('UFCP')},
    {down = UFCP_click_cmd.R1_dn, up = UFCP_click_cmd.R1_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP R1'), category = _('UFCP')},
    {down = UFCP_click_cmd.R2_dn, up = UFCP_click_cmd.R2_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP R2'), category = _('UFCP')},
    {down = UFCP_click_cmd.R3_dn, up = UFCP_click_cmd.R3_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP R3'), category = _('UFCP')},
    {down = UFCP_click_cmd.R4_dn, up = UFCP_click_cmd.R4_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP R4'), category = _('UFCP')},
    {down = UFCP_click_cmd.comm_dn, up = UFCP_click_cmd.comm_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Commicat'), category = _('UFCP')},
    {down = UFCP_click_cmd.Nav_dn, up = UFCP_click_cmd.Nav_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Nav'), category = _('UFCP')},
    {down = UFCP_click_cmd.combat_dn, up = UFCP_click_cmd.combat_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Combat'), category = _('UFCP')},
    {down = UFCP_click_cmd.AP_dn, up = UFCP_click_cmd.AP_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Autopilot'), category = _('UFCP')},
    {down = UFCP_click_cmd.boat_dn, up = UFCP_click_cmd.boat_up, cockpit_device_id = devices.UFCP, value_down = 1.0, value_up = 0.0, name = _('UFCP Boat Key'), category = _('UFCP')},
    --{down = Keys.key0, name = _('UFCP 0'), category = _('UFCP')},
    --{down = Keys.key1, name = _('UFCP 1'), category = _('UFCP')},
    --{down = Keys.key2, name = _('UFCP 2'), category = _('UFCP')},
    --{down = Keys.key3, name = _('UFCP 3'), category = _('UFCP')},
    --{down = Keys.key4, name = _('UFCP 4'), category = _('UFCP')},
    --{down = Keys.key5, name = _('UFCP 5'), category = _('UFCP')},
    --{down = Keys.key6, name = _('UFCP 6'), category = _('UFCP')},
    --{down = Keys.key7, name = _('UFCP 7'), category = _('UFCP')},
    --{down = Keys.key8, name = _('UFCP 8'), category = _('UFCP')},
    --{down = Keys.key9, name = _('UFCP 9'), category = _('UFCP')},
    --{down = Keys.Enter, name = _('UFCP Enter'), category = _('UFCP')},
    --{down = Keys.Clear, name = _('UFCP Clear'), category = _('UFCP')},
    --{down = Keys.L1, name = _('UFCP L1'), category = _('UFCP')},
    --{down = Keys.L2, name = _('UFCP L2'), category = _('UFCP')},
    --{down = Keys.L3, name = _('UFCP L3'), category = _('UFCP')},
    --{down = Keys.L4, name = _('UFCP L4'), category = _('UFCP')},
    --{down = Keys.R1, name = _('UFCP R1'), category = _('UFCP')},
    --{down = Keys.R2, name = _('UFCP R2'), category = _('UFCP')},
    --{down = Keys.R3, name = _('UFCP R3'), category = _('UFCP')},
    --{down = Keys.R4, name = _('UFCP R4'), category = _('UFCP')},
    --{down = Keys.comm, name = _('UFCP Commicat'), category = _('UFCP')},
    --{down = Keys.Nav, name = _('UFCP Nav'), category = _('UFCP')},
    --{down = Keys.combat, name = _('UFCP Combat'), category = _('UFCP')},
    --{down = Keys.AP, name = _('UFCP Autopilot'), category = _('UFCP')},
    --{down = Keys.boat, name = _('UFCP Boat Key'), category = _('UFCP')},


	--Right Panel
    --{down = Keys.displayBrtMode, name = _('MFCD HUD Brightness Mode Dark/Normal'), category = _('Right Panel')},
    --昼夜、惯导、MFCD 亮度、防拥面板
	{down = click_cmd.HudMFCD_change_dayNight, up = click_cmd.HudMFCD_change_dayNight, cockpit_device_id = devices.MFCD, value_down = 1.0, value_up = -1.0, name = _('Day/Night Mode Switch'), category = _('Right Panel')},
	{down = click_cmd.HudMFCD_change_dayNight, cockpit_device_id = devices.MFCD, value_down = 1.0, value_up = 0.0, name = _('Day/Night Mode Day'), category = _('Right Panel')},
	{down = click_cmd.HudMFCD_change_dayNight, cockpit_device_id = devices.MFCD, value_down = -1.0, value_up = 0.0, name = _('Day/Night Mode Night'), category = _('Right Panel')},
    {down = Keys.MFCD_BRT_Increase, 		cockpit_device_id = devices.MFCD, name = _('MFCD BRT +'), 		category = _('Right Panel')},
	{down = Keys.MFCD_BRT_Decrease, 		cockpit_device_id = devices.MFCD, name = _('MFCD BRT -'), 		category = _('Right Panel')},

	--Keyboard
	{down = Keys.key_A, name = _('Keyboard A'), category = _('Keyboard')},
    {down = Keys.key_B, name = _('Keyboard B'), category = _('Keyboard')},
    {down = Keys.key_C, name = _('Keyboard C'), category = _('Keyboard')},
    {down = Keys.key_D, name = _('Keyboard D'), category = _('Keyboard')},
    {down = Keys.key_E, name = _('Keyboard E'), category = _('Keyboard')},
    {down = Keys.key_F, name = _('Keyboard F'), category = _('Keyboard')},
    {down = Keys.key_G, name = _('Keyboard G'), category = _('Keyboard')},
    {down = Keys.key_H, name = _('Keyboard H'), category = _('Keyboard')},
    {down = Keys.key_I, name = _('Keyboard I'), category = _('Keyboard')},
    {down = Keys.key_J, name = _('Keyboard J'), category = _('Keyboard')},
    {down = Keys.key_K, name = _('Keyboard K'), category = _('Keyboard')},
    {down = Keys.key_L, name = _('Keyboard L'), category = _('Keyboard')},
    {down = Keys.key_M, name = _('Keyboard M'), category = _('Keyboard')},
    {down = Keys.key_N, name = _('Keyboard N'), category = _('Keyboard')},
    {down = Keys.key_O, name = _('Keyboard O'), category = _('Keyboard')},
    {down = Keys.key_P, name = _('Keyboard P'), category = _('Keyboard')},
    {down = Keys.key_Q, name = _('Keyboard Q'), category = _('Keyboard')},
    {down = Keys.key_R, name = _('Keyboard R'), category = _('Keyboard')},
    {down = Keys.key_S, name = _('Keyboard S'), category = _('Keyboard')},
    {down = Keys.key_T, name = _('Keyboard T'), category = _('Keyboard')},
    {down = Keys.key_U, name = _('Keyboard U'), category = _('Keyboard')},
    {down = Keys.key_V, name = _('Keyboard V'), category = _('Keyboard')},
    {down = Keys.key_W, name = _('Keyboard W'), category = _('Keyboard')},
    {down = Keys.key_X, name = _('Keyboard X'), category = _('Keyboard')},
    {down = Keys.key_Y, name = _('Keyboard Y'), category = _('Keyboard')},
    {down = Keys.key_Z, name = _('Keyboard Z'), category = _('Keyboard')},
    {down = Keys.key_SP, name = _('Keyboard Space'), category = _('Keyboard')},
    {down = Keys['key_+/-'], name = _('Keyboard ±'), category = _('Keyboard')},
    {combos = {{key = 'S', reformers = {'LShift'}}},down = Keys.back_a_car, name = _('Back A Car'), category = _('Taxi')},
    --Carrier Operations
    {combos = {{key = 'U', reformers = {'LCtrl'}}}, down = Keys.PlaneRightMFD_OSB6_Off, name = _('Launch Bar Toggle'), category = _('Carrier Operations')}, -- command Nr.1012
    {combos = {{key = 'U'}}, down = iCommandPlaneShipTakeOff, name = _('Catapult Hook-Up'),	category = _('Carrier Operations')}, -- command Nr. 120
    --FLIR		
	{	down = flir_commands.WFOV,			up = flir_commands.WFOV,		name = _('FLIR WFOV'),			category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.NFOV,			up = flir_commands.NFOV,		name = _('FLIR NFOV'),			category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.Menu,			up = flir_commands.Menu,    	name = _('FLIR Menu'),         	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.Hook,			up = flir_commands.Hook,    	name = _('FLIR Hook'),         	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.Lock,			up = flir_commands.Lock,    	name = _('FLIR Lock'),         	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.Freeze,		up = flir_commands.Freeze,  	name = _('FLIR Freeze'),       	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.TrackBrk,		up = flir_commands.TrackBrk,	name = _('FLIR Track / Break'),	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{combos = {{key = 'O'}},
		down = flir_commands.Power, 		up = flir_commands.Power,		name = _('FLIR Power'),    		category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.FocusOut,		up = flir_commands.FocusOut,	name = _('FLIR Focus Out'),		category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.FocusIn, 		up = flir_commands.FocusIn, 	name = _('FLIR Focus In'), 		category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{combos = {{key = 'C'}},
		down = flir_commands.Cage,			up = flir_commands.Cage,		name = _('FLIR Cage'),      	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.IPHH,     		up = flir_commands.IPHH,     	name = _('FLIR IPHH'),      	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.Polarity, 		up = flir_commands.Polarity, 	name = _('FLIR Polarity'),  	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.SlewLeft,      up = flir_commands.SlewLeft,    name = _('FLIR Slew Left'),     category = {_('FLIR')}, value_down =  1.0,	value_up = 0.0, cockpit_device_id = devices.FLIR},
	{	down = flir_commands.SlewRight,     up = flir_commands.SlewRight,   name = _('FLIR Slew Right'),    category = {_('FLIR')}, value_down =  1.0,	value_up = 0.0, cockpit_device_id = devices.FLIR},
	{	down = flir_commands.SlewUp,        up = flir_commands.SlewUp,      name = _('FLIR Slew Up'),       category = {_('FLIR')}, value_down =  1.0,	value_up = 0.0, cockpit_device_id = devices.FLIR},
	{	down = flir_commands.SlewDown,      up = flir_commands.SlewDown,    name = _('FLIR Slew Down'),     category = {_('FLIR')}, value_down =  1.0,	value_up = 0.0, cockpit_device_id = devices.FLIR},
	{	down = flir_commands.GainUp,   		up = flir_commands.GainUp,   	name = _('FLIR Gain Up'),   	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.GainDown, 		up = flir_commands.GainDown, 	name = _('FLIR Gain Down'), 	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.LevelUp,  		up = flir_commands.LevelUp,  	name = _('FLIR Level Up'),  	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.LevelDown,		up = flir_commands.LevelDown,	name = _('FLIR Level Down'),	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{	down = flir_commands.AutoGain, 		up = flir_commands.AutoGain, 	name = _('FLIR Auto Gain'), 	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
	{combos = {{key = 'Space',reformers = {'RAlt'}}},
		down = flir_commands.LaserOn,		up = flir_commands.LaserOn,		name = _('FLIR Laser On/Off'),	category = {_('FLIR')},	value_down =  1.0,	value_up = 0.0,	cockpit_device_id = devices.FLIR},
    -- VTOL
	{down = 660, name = _('Engine Nozzle Toggle DOWN'), category = _('VTOL Operations')},
    {down = 661, name = _('Engine Nozzle Toggle UP'), category = _('VTOL Operations')},
  },
}
