dofile(current_mod_path .. "/sensors.lua")
dofile("Scripts/Database/Weapons/warheads.lua")
dofile(current_mod_path .. "/pylon_weapon_init.lua")
dofile(current_mod_path .. "/J20A_CM102A.lua")

local mech_anime = make_default_mech_animation()
mech_anime["ServiceHatches"] = {
	{ Transition = { "Close", "Open" }, Sequence = { { C = { { "PosType", 3 }, { "Sleep", "for", 30.0 } } }, { C = { { "Arg", 24, "set", 1.0 } } } } },
	{ Transition = { "Open", "Close" }, Sequence = { { C = { { "PosType", 6 }, { "Sleep", "for", 5.0 } } }, { C = { { "Arg", 24, "set", 0.0 } } } } },
} --进气道塞子
mech_anime["CrewLadder"] = {
	{
		Transition = { "Dismantle", "Erect" },
		Sequence = {
			{ C = { { "PosType", 6 }, { "Sleep", "for", 10.0 } } },
			{ C = { { "Arg", 91, "set", 1.0 } } },
			{ C = { { "PosType", 6 }, { "Sleep", "for", 10.0 } } },
		}
	},
	{
		Transition = { "Erect", "Dismantle" },
		Sequence = {
			{ C = { { "PosType", 6 }, { "Sleep", "for", 10.0 } } },
			{ C = { { "Arg", 91, "set", 0.0 } } },
			{ C = { { "PosType", 6 }, { "Sleep", "for", 10.0 } } },
		}
	},
} --登机梯

mech_anime["Door0"] = {
	{ Transition = { "Close", "Open" }, Sequence = { { C = { { "Arg", 38, "to", 0.9, "in", 9.0 }, }, }, },                                                                                                                                    Flags = { "Reversible" }, },
	{ Transition = { "Open", "Close" }, Sequence = { { C = { { "Arg", 38, "to", 0.0, "in", 6.0 }, }, }, },                                                                                                                                    Flags = { "Reversible", "StepsBackwards" }, },
	--{Transition = {"Open", "Taxi"},   Sequence = {{C = {{"Sleep", "for", 0.0},},},},},
	--{Transition = {"Taxi", "Open"},   Sequence = {{C = {{"Sleep", "for", 0.0},},},},},
	{ Transition = { "Open", "Bailout" }, Sequence = { { C = { { "TearCanopy", 0 }, { "Arg", 993, "set", 1.0 }, }, }, }, },
	{ Transition = { "Taxi", "Bailout" }, Sequence = { { C = { { "TearCanopy", 0 }, { "Arg", 993, "set", 1.0 }, }, }, }, },
	{ Transition = { "Any", "Bailout" }, Sequence = { { C = { { "Origin", "x", 3.458, "y", 0.703, "z", 0.0 }, { "Impulse", 1, "tertiary", 1.0 }, { "Impulse", 2, "tertiary", 10.5 }, { "Sleep", "for", 0.005 }, }, }, { C = { { "Arg", 993, "set", 1.0 }, }, }, }, },
} --砸窗救人

mech_anime["Door0"] = {
	{ Transition = { "Close", "Open" }, Sequence = { { C = { { "Arg", 38, "to", 0.9, "in", 9.0 }, }, }, },                                                                                                                                    Flags = { "Reversible" }, },
	{ Transition = { "Open", "Close" }, Sequence = { { C = { { "Arg", 38, "to", 0.0, "in", 6.0 }, }, }, },                                                                                                                                    Flags = { "Reversible", "StepsBackwards" }, },
	--{Transition = {"Open", "Taxi"},   Sequence = {{C = {{"Sleep", "for", 0.0},},},},},
	--{Transition = {"Taxi", "Open"},   Sequence = {{C = {{"Sleep", "for", 0.0},},},},},
	{ Transition = { "Open", "Bailout" }, Sequence = { { C = { { "TearCanopy", 0 }, { "Arg", 993, "set", 1.0 }, }, }, }, },
	{ Transition = { "Taxi", "Bailout" }, Sequence = { { C = { { "TearCanopy", 0 }, { "Arg", 993, "set", 1.0 }, }, }, }, },
	{ Transition = { "Any", "Bailout" }, Sequence = { { C = { { "Origin", "x", 3.458, "y", 0.703, "z", 0.0 }, { "Impulse", 1, "tertiary", 1.0 }, { "Impulse", 2, "tertiary", 10.5 }, { "Sleep", "for", 0.005 }, }, }, { C = { { "Arg", 993, "set", 1.0 }, }, }, }, },
}
J_20A = {
	Name                        = "J-20A",
	username                    = "J-20A",
	DisplayName                 = _("J-20A"),
	ViewSettings                = ViewSettings,
	-- 为所有国家启用J-20
	Countries                   = { "China" },
	-- HumanCockpit        = true,
	-- HumanCockpitPath    = current_mod_path..'/Cockpit/Scripts/',

	Picture                     = "J-20A.png",
	Rate                        = 50,
	Shape                       = "J-20A",
	WorldID                     = WSTYPE_PLACEHOLDER,
	shape_table_data            = {
		{
			file        = "J-20A",
			life        = 18,
			vis         = 3,
			desrt       = "J-20A-oblomok",
			fire        = { 300, 2 },
			username    = "J-20A",
			index       = WSTYPE_PLACEHOLDER,
			classname   = "lLandPlane",
			positioning = "BYNORMAL",
		},
		{
			-- using outer destory model
			name = "J-20A-oblomok",
			file = "J-20A-oblomok",
			fire = { 240, 2 },
		}

	},
	----外部动画,多人游戏网络同步动画
	net_animation = {
		--0, --前轮
		--1, --前轮悬挂
		--2, --前轮转向
		--3, --右轮
		--4, --右轮悬挂
		--5, --左轮
		--6, --左轮悬挂
		9, --右襟翼
		10, --左襟翼
		--11, --右副翼
		--12, --左副翼
		13, --右前缘襟翼
		14, --左前缘襟翼
		--15, --右鸭翼
		--16, --左鸭翼
		17, --右垂尾
		18, --左垂尾
		21, --扰流板
		22, --加油探杆
		--23, --轮档
		26, --弹舱盖
		28, --右加力
		29, --左加力
		35, --减速伞
		36, --减速伞摆动y
		37, --减速伞摆动x
		38, --座舱盖
		39, --驾驶员左右观察
		--50, --驾驶员离开-弹射		
		88, --编队灯
		89, --右喷口
		90, --左喷口
		--101, --前轮滚动
		--102, --左轮滚动
		--103, --右轮滚动
		--114, --座舱区域消失		
		--134, --前轮爆胎
		--135, --右轮爆胎
		--136, --左轮爆胎
		181, --鸭翼减速
		190, --右航行灯
		191, --左航行灯
		192, --尾灯
		193, --防撞灯
		208, --滑行灯
		209, --着陆灯
	--	290, --VTOL前风扇盖（J-20C）
	--	291，--VTOL尾喷下盖（J-20C）
	--	292，--VTOL尾喷下转（J-20C）
		515, --右矢喷-ud
		516, --左矢喷-ud
		517, --右矢喷--lr
		518, --左矢喷--lr
		525, --弹仓武器隐藏
		526, --主弹舱打开
		527, --右弹舱打开
		528, --左弹舱打开
	},

	mapclasskey                 = "P0091000024",
	attribute                   = { wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Fighters", "Refuelable", "Datalink", "Link16",
	--"All", "NonAndLightArmoredUnits", "NonArmoredUnits", "Air", "Planes", "Battle airplanes" 
	},
	Categories                  = { "{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor", },

	M_empty                     = 17330, --14500, --空重
	M_nominal                   = 30000, --23000,
	M_max                       = 37000, --最大重量
	M_fuel_max                  = 11600, --9400, --最大燃油重量
	H_max                       = 18500, --最大高度
	-------------------------
	length                      = 20,   --长度（m)
	height                      = 5.932, --高度（m）
	wing_area                   = 62,   --机翼面积
	wing_span                   = 14.7, --机翼跨度
	wing_tip_pos                = { -6.3, -0.09, 6.400 }, --机翼坐标（前后 上下 左右）
	wing_type                   = 0,    --机翼类型
	flaps_maneuver              = 1,    --起飞时最大襟翼(0.5为一级，1.0为两级)(仅AI使用此参数)
	has_speedbrake              = true, --有空气刹车

	RCS                         = 0.01, --正面雷达反射面积（m2）F16的标准截面积为4.0
	IR_emission_coeff           = 0.7,  --红外发射系数（无加力）
	IR_emission_coeff_ab        = 3,    --红外发射系数（加力）

	stores_number               = 11,   --挂架数量

	CAS_min                     = 58,  --最小CAS速度（m/s）仅AI使用此参数
	V_opt                       = 220, --170 巡航速度（m/s）仅AI使用此参数
	V_take_off                  = 75, --67, --离地速度（m/s)仅AI使用此参数
	V_land                      = 65, --63, --着陆速度AI（m/s)仅AI使用此参数
	V_max_sea_level             = 403, --最大海平面速度AI（m/s)
	V_max_h                     = 694.44, --最大高度速度AI（m/s)
	Vy_max                      = 325,
	Mach_max                    = 2.05, --最大马赫数AI
	Ny_min                      = -3, --最小过载AI
	Ny_max                      = 9, --最大过载AI
	Ny_max_e                    = 9,
	AOA_take_off                = 0.15, --起飞攻角 仅AI使用此参数
	bank_angle_max              = 60, --最大回转角 仅AI使用此参数
	range                       = 3940, --航程（KM）AI

	thrust_sum_max              = 30400, --推力最大值（军推）//注意：此处单位被标记为kg
	has_afteburner              = true,
	has_differential_stabilizer = false,
	thrust_sum_ab               = 50000, --推力最大值（加力）//注意：此处单位被标记为kg
	average_fuel_consumption    = 0.112, --0.208,
	is_tanker                   = false,
	tanker_type                 = 2,
	--F14=2/S33=4/M29=0/S27=0/F15=1/F16=1/To=0/F18=2/A10A=1/M29K=4/M2000=2/F4=0/F5=0/
	air_refuel_receptacle_pos   = { 8.456, 0.612, -0.93 },

	nose_gear_pos               = { 7.611, -2.09, -0.100 }, --前起落架坐标（前后 上下 左右）
	main_gear_pos               = { -1.35, -2.05, 1.700 }, --主起落架坐标（前后 上下 左右）
	tand_gear_max               = math.tan(math.rad(45)), --前轮最大旋转角度的tan值
	-- nose_gear_amortizer_direct_stroke = 0.0458,--0.229
	-- nose_gear_amortizer_reversal_stroke = -0.1832,
	-- main_gear_amortizer_direct_stroke = 0.0444,--0.222
	-- main_gear_amortizer_reversal_stroke = -0.1776,
	-- nose_gear_amortizer_normal_weight_stroke = -0.1,
	-- main_gear_amortizer_normal_weight_stroke = -0.1,

	nose_gear_wheel_diameter    = 0.754, --前机轮直径（m)
	main_gear_wheel_diameter    = 0.972, --主机轮直径（m）
	brakeshute_name             = 4,


	engines_count = 2, --发动机数量
	engines_nozzles = {
		[1] =
		{
			pos                 = { -8.0, -0.00, 0.80 }, --右发坐标
			elevation           = 0,
			diameter            = 0.97, --马赫环直径
			exhaust_length_ab   = 0.0,
			exhaust_length_ab_K = 0.629,
			smokiness_level     = 0.1, --烟			
		},
		[2] =
		{
			pos                 = { -8.0, -0.00, -0.80 }, --左发坐标
			elevation           = 0,
			diameter            = 0.97, --马赫环直径
			exhaust_length_ab   = 0.0,
			exhaust_length_ab_K = 0.629,
			smokiness_level     = 0.1, --烟			
		},
	},

	crew_size = 1,
	crew_members = {
		[1] =
		{
			ejection_seat_name = "J-20_ejectionseat",
			drop_canopy_name   = "J-20-fragment-canopy-glass",
			pos                = { 3.035, 0.169, 0.005 },
			canopy_pos         = { 2.677, 2.677, 0 },
		}, -- end of [1]
	}, -- end of crew_members


	fires_pos = {
		[1] = { -0, 1.004, 0 },--机身中心
		[2] = { -4.315, 0.2655, 2.561 }, --WING_R
		[3] = { -4.315, 0.2655, -2.561 }, --WING_L
		[4] = { -2.91, 0.256, 3.504 },--WING_R_PART_CENTER
		[5] = { -2.91, 0.256, -3.504 },--WING_L_PART_CENTER
		[6] = { -5.133, 0.1505, 4.328 },--WING_R_PART_OUT
		[7] = { -5.133, 0.1505, -4.328 },--WING_L_PART_OUT
		[8] = { -8.213, 0.017, 0.766 },--ENGINE_R_IN
		[9] = { -8.213, 0.017, -0.766 },--ENGINE_L_IN
		[10] = { -4.258, 0.845, 1.033 },--右机身
		[11] = { -4.258, 0.845, -1.033 },--左机身
	},

	-- EmptyWeight = "17500",
	-- MaxTakeOffWeight = "33000",
	-- MaxFuelWeight = "9400",
	-- MaxHeight = "18500",
	-- MaxSpeed = "2500",
	sounderName = "Aircraft/Planes/J-20A",

	Failures  = {
		{ id = 'ILS_FAILURE_TOTAL',          label = _('ILS AN/ARN-118'),                    enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ILS_FAILURE_ANT_LOCALIZER',  label = _('ILS AN/ARN-118 localizer antenna'),  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ILS_FAILURE_ANT_GLIDESLOPE', label = _('ILS AN/ARN-118 glideslope antenna'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ILS_FAILURE_ANT_MARKER',     label = _('ILS AN/ARN-118 marker antenna'),     enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'UHF_RADIO_FAILURE_TOTAL',    label = _('UHF radio'),                         enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_AM_RADIO_FAILURE_TOTAL', label = _('VHF AM radio'),                      enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_FM_RADIO_FAILURE_TOTAL', label = _('VHF FM radio'),                      enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	},
	ColdStartDefaultControls = {
		[9] = 1, --右襟翼
		[10] = 1, --左襟翼
		[11] = -1, --右副翼
		[12] = -1, --左副翼
		[15] = 0, --右平尾
		[16] = 0, --左平尾
		[17] = 0, --右垂尾
		[18] = 0, --左垂尾
		[23] = 1, --轮挡
		[26] = 1, --弹舱盖
		[89] = 1, --右喷口
		[90] = 1, --左喷口
		--[181] = 1,--鸭翼
	},
	-- Aircraft Additional Properties
	AddPropAircraft          = {
		{
			id = "MP3Player",
			control = "checkbox",
			label = _("Enable MP3Player"),
			defValue = false,
			--weightWhenOn = -80
		},
	},
	mechanimations           = mech_anime,

	passivCounterm           = {
		CMDS_Edit = true,
		SingleChargeTotal = 192,
		chaff = { default = 112, increment = 3, chargeSz = 1 },
		flare = { default = 80, increment = 3, chargeSz = 1 },
	},
	chaff_flare_dispenser    = {
		{ dir = { 0, 1, 0 }, pos = { -6.227, -0.535, -1.60 }, }, -- Chaff L
		{ dir = { 0, 1, 0 }, pos = { -6.227, -0.535, 1.60 }, }, -- Chaff R
		{ dir = { 0, 1, 0 }, pos = { -7.062, -0.373, -1.60 }, }, -- Flares L
		{ dir = { 0, 1, 0 }, pos = { -7.062, -0.373, 1.60 }, }, -- Flares R
	},
	Countermeasures 		 = {
		ECM = "AN/ALQ-135"
	},
	--
	detection_range_max      = 550,
	radar_can_see_ground     = true,
	--CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
	CanopyGeometry           = {
		azimuth   = { -160.0, 160.0 }, -- pilot view horizontal (AI)
		elevation = { -50.0, 90.0 }  -- pilot view vertical (AI)
	},
	Sensors = {
		RWR = "Abstract RWR",
		RADAR = "RD20", -- Radar type
		OPTIC = { "TADS DTV", "TADS DVO", "TADS FLIR", "GD-20" },
		IRST = "HW-20"
	},

	TACAN_AA                 = true,
	HumanRadio               = {
		frequency      = 127.5, -- /N/ onboard radio, default DCSW frequency, chnl 0
		editable       = true,
		minFrequency   = 30.000,
		maxFrequency   = 399.975,
		rangeFrequency = {
			{ min = 30.0,  max = 87.995,  modulation = MODULATION_FM },
			{ min = 118.0, max = 135.995, modulation = MODULATION_AM },
			{ min = 136.0, max = 155.995, modulation = MODULATION_AM_AND_FM, modulationDef = MODULATION_FM },
			{ min = 156.0, max = 173.995, modulation = MODULATION_FM },
			{ min = 225.0, max = 399.975, modulation = MODULATION_AM_AND_FM, modulationDef = MODULATION_AM }
		},
		modulation     = MODULATION_AM
	},
	panelRadio = {
		[1] = {
			name = _("UHF Radio AN/ARC-164"),
			-- range = {min = 80.0, max = 399.9},
			range = { min = 225.0, max = 390.0 },
			channels = {
				[1] = { name = _("radiochannel00"), default = 250.0, modulation = _("AM"), connect = true },
				[2] = { name = _("radiochannel01"), default = 260.0, modulation = _("AM") },
				[3] = { name = _("radiochannel02"), default = 270.0, modulation = _("AM") },
				[4] = { name = _("radiochannel03"), default = 255.0, modulation = _("AM") },
				[5] = { name = _("radiochannel04"), default = 259.0, modulation = _("AM") },
				[6] = { name = _("radiochannel05"), default = 262.0, modulation = _("AM") },
				[7] = { name = _("radiochannel06"), default = 251.0, modulation = _("AM") },
				[8] = { name = _("radiochannel07"), default = 257.0, modulation = _("AM") },
				[9] = { name = _("radiochannel08"), default = 253.0, modulation = _("AM") },
				[10] = { name = _("radiochannel09"), default = 263.0, modulation = _("AM") },
				[11] = { name = _("radiochannel10"), default = 267.0, modulation = _("AM") },
				[12] = { name = _("radiochannel11"), default = 254.0, modulation = _("AM") },
				[13] = { name = _("radiochannel12"), default = 264.0, modulation = _("AM") },
				[14] = { name = _("radiochannel13"), default = 266.0, modulation = _("AM") },
				[15] = { name = _("radiochannel14"), default = 265.0, modulation = _("AM") },
				[16] = { name = _("radiochannel15"), default = 252.0, modulation = _("AM") },
				[17] = { name = _("radiochannel16"), default = 261.0, modulation = _("AM") },
				[18] = { name = _("radiochannel17"), default = 256.0, modulation = _("AM") },
				[19] = { name = _("radiochannel18"), default = 258.0, modulation = _("AM") },
				[20] = { name = _("radiochannel19"), default = 268.0, modulation = _("AM") },
			},
		},
		[2] = {
			name = _("VHF AM Radio AN/ARC-186"),
			range = { min = 116.0, max = 151.95 },
			channels = {
				[1] = { name = _("radiochannel00"), default = 121.0, modulation = _("AM"), connect = true },
				[2] = { name = _("radiochannel01"), default = 131.0, modulation = _("AM") },
				[3] = { name = _("radiochannel02"), default = 141.0, modulation = _("AM") },
				[4] = { name = _("radiochannel03"), default = 126.0, modulation = _("AM") },
				[5] = { name = _("radiochannel04"), default = 130.0, modulation = _("AM") },
				[6] = { name = _("radiochannel05"), default = 133.0, modulation = _("AM") },
				[7] = { name = _("radiochannel06"), default = 122.0, modulation = _("AM") },
				[8] = { name = _("radiochannel07"), default = 128.0, modulation = _("AM") },
				[9] = { name = _("radiochannel08"), default = 124.0, modulation = _("AM") },
				[10] = { name = _("radiochannel09"), default = 134.0, modulation = _("AM") },
				[11] = { name = _("radiochannel10"), default = 138.0, modulation = _("AM") },
				[12] = { name = _("radiochannel11"), default = 125.0, modulation = _("AM") },
				[13] = { name = _("radiochannel12"), default = 135.0, modulation = _("AM") },
				[14] = { name = _("radiochannel13"), default = 137.0, modulation = _("AM") },
				[15] = { name = _("radiochannel14"), default = 136.0, modulation = _("AM") },
				[16] = { name = _("radiochannel15"), default = 123.0, modulation = _("AM") },
				[17] = { name = _("radiochannel16"), default = 132.0, modulation = _("AM") },
				[18] = { name = _("radiochannel17"), default = 127.0, modulation = _("AM") },
				[19] = { name = _("radiochannel18"), default = 129.0, modulation = _("AM") },
				[20] = { name = _("radiochannel19"), default = 139.0, modulation = _("AM") },
			},
		},
		[3] = {
			name = _("VHF FM Radio AN/ARC-186"),
			range = { min = 30.0, max = 108.0 },
			channels = {
				[1] = { name = _("radiochannel00"), default = 38.4, modulation = _("FM"), connect = true },
				[2] = { name = _("radiochannel01"), default = 40.4, modulation = _("FM") },
				[3] = { name = _("radiochannel02"), default = 42.4, modulation = _("FM") },
				[4] = { name = _("radiochannel03"), default = 39.4, modulation = _("FM") },
				[5] = { name = _("radiochannel04"), default = 40.2, modulation = _("FM") },
				[6] = { name = _("radiochannel05"), default = 40.8, modulation = _("FM") },
				[7] = { name = _("radiochannel06"), default = 38.6, modulation = _("FM") },
				[8] = { name = _("radiochannel07"), default = 39.8, modulation = _("FM") },
				[9] = { name = _("radiochannel08"), default = 39.0, modulation = _("FM") },
				[10] = { name = _("radiochannel09"), default = 41.0, modulation = _("FM") },
				[11] = { name = _("radiochannel10"), default = 41.8, modulation = _("FM") },
				[12] = { name = _("radiochannel11"), default = 39.2, modulation = _("FM") },
				[13] = { name = _("radiochannel12"), default = 41.2, modulation = _("FM") },
				[14] = { name = _("radiochannel13"), default = 41.6, modulation = _("FM") },
				[15] = { name = _("radiochannel14"), default = 41.4, modulation = _("FM") },
				[16] = { name = _("radiochannel15"), default = 38.8, modulation = _("FM") },
				[17] = { name = _("radiochannel16"), default = 40.6, modulation = _("FM") },
				[18] = { name = _("radiochannel17"), default = 39.6, modulation = _("FM") },
				[19] = { name = _("radiochannel18"), default = 40.0, modulation = _("FM") },
				[20] = { name = _("radiochannel19"), default = 42.0, modulation = _("FM") },
			},
		},
	},

	--mech_timing = {{0, 0.074, 0.11, 0.14}, {0, 0.18, 0.89, 0.074}},
	--pylons_enumeration = {10, 1, 9, 2, 3, 8, 4, 7, 6, 5},
	--pylons_enumeration = {2, 1,3},

	Pylons = {
					--Back/Forward    	Up/Down  		-Left/Right
		pylon(1, 0, 1.597, -0.87, -1.679,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_001",
			},
			{
				{ CLSID = "{PLAAF_PL-10E}", 			required = { { station = 2, loadout = { '{PLAAF_PL-10E}' } } } },
				{ CLSID = "{BayArm_PLAAF_PL-10E_x4}", 	required = { { station = 2, loadout = { '{BayArm_PLAAF_PL-10E_x4}' } } } },
			}
		),
		pylon(2, 0, 1.597, -0.87, 1.679,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_002",
			},
			{
				{ CLSID = "{PLAAF_PL-10E}", 			required = { { station = 1, loadout = { '{PLAAF_PL-10E}' } } } },
				{ CLSID = "{BayArm_PLAAF_PL-10E_x4}", 	required = { { station = 1, loadout = { '{BayArm_PLAAF_PL-10E_x4}' } } } },
			}
		),
		pylon(3, 1, 0.5, -0.533, -0.915,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_003",
			},
			{
				{ CLSID = "DIS_PL-12",   required = { { station = 4, loadout = { 'DIS_PL-12' } } } },
				{ CLSID = "DIS_LD-10",   required = { { station = 4, loadout = { 'DIS_LD-10' } } } },
				{ CLSID = "{J20A_CM102A}",   required = { { station = 4, loadout = { '{J20A_CM102A}' } } } },
				{ CLSID = "{J20A_PL15}", required = { { station = 4, loadout = { '{J20A_PL15}' } } } },
				{ CLSID = "{J20A_PL17}", required = { { station = 4, loadout = { '{J20A_PL17}' } } } },
				{ CLSID = "BayArm_J20_PL-15_DUAL", required = { { station = 4, loadout = { 'BayArm_J20_PL-15_DUAL' } } } },
				{ CLSID = "{BayArm_J20_PL-17_x4}", required = { { station = 4, loadout = { '{BayArm_J20_PL-17_x4}' } } } },
			}
		),
		pylon(4, 1, 0.5, -0.533, 0.915,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_004",
			},
			{
				{ CLSID = "DIS_PL-12",   required = { { station = 3, loadout = { 'DIS_PL-12' } } } },
				{ CLSID = "DIS_LD-10",   required = { { station = 3, loadout = { 'DIS_LD-10' } } } },
				{ CLSID = "{J20A_CM102A}",   required = { { station = 3, loadout = { '{J20A_CM102A}' } } } },
				{ CLSID = "{J20A_PL15}", required = { { station = 3, loadout = { '{J20A_PL15}' } } } },
				{ CLSID = "{J20A_PL17}", required = { { station = 3, loadout = { '{J20A_PL17}' } } } },
				{ CLSID = "BayArm_J20_PL-15_DUAL", required = { { station = 3, loadout = { 'BayArm_J20_PL-15_DUAL' } } } },
				{ CLSID = "{BayArm_J20_PL-17_x4}", required = { { station = 3, loadout = { '{BayArm_J20_PL-17_x4}' } } } },
			}
		),
		pylon(5, 1, 0.613, -0.533, -0.609,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_005",
			},
			{
				{ CLSID = "DIS_PL-12",   required = { { station = 6, loadout = { 'DIS_PL-12' } } } },
				{ CLSID = "DIS_LD-10",   required = { { station = 6, loadout = { 'DIS_LD-10' } } } },
				{ CLSID = "{J20A_CM102A}",   required = { { station = 6, loadout = { '{J20A_CM102A}' } } } },
				{ CLSID = "{J20A_PL15}", required = { { station = 6, loadout = { '{J20A_PL15}' } } } },
				{ CLSID = "{J20A_PL17}", required = { { station = 6, loadout = { '{J20A_PL17}' } } } },
				{ CLSID = "BayArm_J20_PL-15_DUAL", required = { { station = 6, loadout = { 'BayArm_J20_PL-15_DUAL' } } } },
				{ CLSID = "{BayArm_J20_PL-17_x4}", required = { { station = 6, loadout = { '{BayArm_J20_PL-17_x4}' } } } },
			}
		),
		pylon(6, 1, 0.613, -0.533, 0.609,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_006",
			},
			{
				{ CLSID = "DIS_PL-12",   required = { { station = 5, loadout = { 'DIS_PL-12' } } } },
				{ CLSID = "DIS_LD-10",   required = { { station = 5, loadout = { 'DIS_LD-10' } } } },
				{ CLSID = "{J20A_CM102A}",   required = { { station = 5, loadout = { '{J20A_CM102A}' } } } },
				{ CLSID = "{J20A_PL15}", required = { { station = 5, loadout = { '{J20A_PL15}' } } } },
				{ CLSID = "{J20A_PL17}", required = { { station = 5, loadout = { '{J20A_PL17}' } } } },
				{ CLSID = "BayArm_J20_PL-15_DUAL", required = { { station = 5, loadout = { 'BayArm_J20_PL-15_DUAL' } } } },
				{ CLSID = "{BayArm_J20_PL-17_x4}", required = { { station = 5, loadout = { '{BayArm_J20_PL-17_x4}' } } } },
			}
		),
		pylon(7, 1, 0.5, -0.533, -0.279,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_007",
			},
			{
				{ CLSID = "DIS_PL-12",   required = { { station = 8, loadout = { 'DIS_PL-12' } } } },
				{ CLSID = "DIS_LD-10",   required = { { station = 8, loadout = { 'DIS_LD-10' } } } },
				{ CLSID = "{J20A_CM102A}",   required = { { station = 8, loadout = { '{J20A_CM102A}' } } } },
				{ CLSID = "{J20A_PL15}", required = { { station = 8, loadout = { '{J20A_PL15}' } } } },
				{ CLSID = "{J20A_PL17}", required = { { station = 8, loadout = { '{J20A_PL17}' } } } },
				{ CLSID = "BayArm_J20_PL-15_DUAL", required = { { station = 8, loadout = { 'BayArm_J20_PL-15_DUAL' } } } },
				{ CLSID = "{BayArm_J20_PL-17_x4}", required = { { station = 8, loadout = { '{BayArm_J20_PL-17_x4}' } } } },
			}
		),
		pylon(8, 1, 0.5, -0.533, 0.279,
			{
				arg = 26 ,arg_value = 1,use_full_connector_position = true, connector = "Pylon_008",
			},
			{
				{ CLSID = "DIS_PL-12",   required = { { station = 7, loadout = { 'DIS_PL-12' } } } },
				{ CLSID = "DIS_LD-10",   required = { { station = 7, loadout = { 'DIS_LD-10' } } } },
				{ CLSID = "{J20A_CM102A}",   required = { { station = 7, loadout = { '{J20A_CM102A}' } } } },
				{ CLSID = "{J20A_PL15}", required = { { station = 7, loadout = { '{J20A_PL15}' } } } },
				{ CLSID = "{J20A_PL17}", required = { { station = 7, loadout = { '{J20A_PL17}' } } } },
				{ CLSID = "BayArm_J20_PL-15_DUAL", required = { { station = 7, loadout = { 'BayArm_J20_PL-15_DUAL' } } } },
				{ CLSID = "{BayArm_J20_PL-17_x4}", required = { { station = 7, loadout = { '{BayArm_J20_PL-17_x4}' } } } },
			}
		),
		pylon(9, 0, 8.533, -0.692, 0.0,
			{
				connector = 'FLIR',
				use_full_connector_position = false,
			},
			{
				{ CLSID = "J_20A-EOTS" },
				{ CLSID = "<CLEAN>",   arg_value = 1 }, -- CLEAN --
			}
		),
		pylon(10, 2, -6.046, 0.028, -6.441,
			{
				connector = 'FLOW_001',
				use_full_connector_position = false,
			},
			{
				{ CLSID = 'DIS_SMOKE_GENERATOR_R' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_G' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_B' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_W' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_Y' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_O' },
			}
		),
		pylon(11, 2, -6.046, 0.028, 6.441,
			{
				connector = 'FLOW_002',
				use_full_connector_position = false,
			},
			{
				{ CLSID = 'DIS_SMOKE_GENERATOR_R' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_G' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_B' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_W' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_Y' },
				{ CLSID = 'DIS_SMOKE_GENERATOR_O' },
			}
		),
	},

	-------------------------------------------------------------------------------------------
	Tasks = {
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(Escort),
		aircraft_task(FighterSweep),
		aircraft_task(CAS),
		aircraft_task(SEAD),
		aircraft_task(GroundAttack),
		aircraft_task(AntishipStrike),
		aircraft_task(PinpointStrike)
	},
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
		aerodynamics =
		{
			Cy0 = 0, --零迎角升力系数
			Mzalfa = 16.355, -- 俯仰敏捷度系数
			Mzalfadt = 2.4, -- 俯仰敏捷度系数
			kjx = 2.7, --2.75,滚转加速率，单位为rad/sec
			kjz = 0.00125, -- 升降舵或stab控制功率系数/俯仰阻尼系数
			Czbe = -0.016, --偏航稳定性系数沿Z轴（垂直）影响偏航，负值表示FC坐标系中的力方向
			cx_gear = 0.0268, --机轮阻力系数
			cx_flap = 0.053, --0.05,系数、阻力、全襟翼 --前 10 度为 0.006
			cy_flap = 0.42, --0.35,襟翼垂直升力系数
			cx_brk = 0.088, --0.09,系数，阻力减速板（减速板为 0.04，额外的 0.08 来模拟扰流板（参见spoilers.lua 和airbrakes.lua））
			table_data =
			{

				--M	     Cx0		Cya		 	B			B4	    	Omxmax		Aldop		Cymax
				{0.0,	0.02,		0.050,		0.09,		0.022,		3.65,		30.0,		1.60	},
				{0.1,	0.02,		0.050,		0.09,		0.022,		2.65,		30.0,		1.60	},
				{0.2,	0.02,		0.050,		0.09,		0.022,		3.95,		30.0,		1.60	},
				{0.3,	0.02,		0.049,		0.09,		0.022,		3.95,		30.0,		1.60	},
				{0.4,	0.02,		0.048,		0.09,	   	0.022,		3.25,		30.0,		1.60	},
				{0.5,	0.02,		0.048,		0.07,	   	0.025,		3.25,		30.0,		1.60	},
				{0.6,	0.02,		0.048,		0.06,		0.028,		4.55,		30.0,		1.60	},
				{0.7,	0.02,		0.048,		0.06,		0.028,		4.55,		30.0,		1.60	},
				{0.8,	0.021,		0.048,		0.06,		0.028,		4.55,		30.0,		1.60	},
				{0.9,	0.0215,		0.052,		0.08,		0.023,		4.55,		30.0,		1.60	},
				{1.0,	0.0310,		0.058,		0.14,		0.020,		4.55,		30.0,		1.50	},
				{1.1,	0.0422,		0.062,	   	0.17,		0.070,		4.10,		28.0,		1.60	},
				{1.2,	0.0440,		0.062,	   	0.25,		0.060,		3.19,		26.0,		1.00	},
				{1.3,	0.0432,		0.060,	   	0.26,		0.100,		2.28,		24.0,		0.92	},
				{1.4,	0.0432,		0.056,	   	0.28,		0.120,		2.28,		22.0,		0.80	},
				{1.5,	0.0423,		0.054,	   	0.30,		0.150,		1.95,		20.0,		0.75	},
				{1.6,	0.0423,		0.052,	   	0.32,		0.180,		1.95,		18.0,		0.70	},
				{1.7,	0.0423,		0.047,	   	0.32,		1.500,		1.95,		16.0,		0.60	},
				{1.8,	0.0416,		0.042,	   	0.33,		2.100,		1.17,		16.0,		0.55	},
				{1.9,	0.0416,		0.040,	   	0.33,		2.100,		1.17,		16.0,		0.50	},
				{2.0,	0.0416,		0.039,	   	0.33,		2.100,		1.04,		14.0,		0.45	},
				{2.1,	0.0416,		0.038,	   	0.33,		2.100,		1.04,		14.0,		0.40	},
				{2.2,	0.0416,		0.037,	   	0.45,		3.300,		0.91,		14.0,		0.37	},
				{2.3,	0.0416,		0.036,	   	0.45,		3.300,		0.91,		12.0,		0.34	},
				{2.4,	0.0412,		0.035,	   	0.45,		3.300,		0.91,		12.0,		0.30	},
				{2.5,	0.0410,		0.033,		0.58,		4.500,		0.91,		12.0,		0.30	},
				-- Sean: 上面的table 参考自F-22A, 下面的是深海的参考自F-35 
			--[[
			--	  M		Cx0		Cya		B		B4		Omxmax	Aldop	Cymax
				{ 0.0, 	0.0215, 0.077, 	0.1,   	0.032, 	0.65, 	25.0, 	1.8 	},
				{ 0.2, 	0.0215, 0.085, 	0.1,   	0.032, 	1.95, 	25.0, 	1.8 	},
				{ 0.4, 	0.0215, 0.085, 	0.1,   	0.032, 	3.25, 	25.0, 	1.8 	},
				{ 0.6, 	0.0215, 0.087, 	0.094, 	0.043, 	4.55, 	24.0, 	1.8 	},
				{ 0.7, 	0.0220, 0.087, 	0.094, 	0.045, 	4.55, 	23.0, 	1.6 	},
				{ 0.8, 	0.0223, 0.087, 	0.094, 	0.048, 	4.55, 	21.0, 	1.6 	},
				{ 0.9, 	0.0235, 0.091, 	0.11,  	0.050, 	4.55, 	20.0, 	1.4 	},
				{ 1.0, 	0.0434, 0.094, 	0.15,  	0.1,   	4.55, 	18.0, 	1.3 	},
				{ 1.1, 	0.0432, 0.094, 	0.15,  	0.1,   	4.10, 	16.0, 	1.1 	},
				{ 1.2, 	0.0435, 0.091, 	0.14,  	0.1,   	3.19, 	17.0, 	1.0 	},
				{ 1.3, 	0.0437, 0.085, 	0.17,  	0.096, 	2.28, 	15.0, 	0.95	},
				{ 1.5, 	0.0433, 0.078, 	0.23,  	0.09,  	1.95, 	13.0, 	0.9 	},
				{ 1.8, 	0.0477, 0.071, 	0.23,  	0.38,  	1.17, 	12.0, 	0.7 	},
				{ 2.0, 	0.0578, 0.063, 	0.08,  	2.5,   	1.04, 	10.5, 	0.55	},
				{ 2.2, 	0.0593, 0.037, 	0.16,  	3.2,   	0.91, 	9.0,  	0.4 	},
				{ 2.5, 	0.0592, 0.036, 	0.25,  	4.5,   	0.91, 	9.0,  	0.4 	},
				{ 3.9, 	0.0595, 0.033, 	0.35,  	6.0,   	0.8,  	9.0,  	0.4 	},
			]]
				--M 	- 马赫数
				--Cx0 	-飞机的系数、阻力、剖面
				--Cya 	-飞机机翼和机身在飞行方向法线方向上的法向力系数。与任何马赫值下的可用 G 载荷成反比。 （Cya 值越低，可用 G 越高）每 1 度 AOA
				--B 	-极地二阶功率系数
				--B4 	-极地四次方系数
				--Omxmax -滚转速率，rad/s
				--Aldop -当前 M 处的 Alfadop 最大迎角 -出发阈值
				--Cymax -系数、升力、最大可能值（如果当前 Cy > Cymax，则忽略其他计算）

				--现在校正寄生阻力（阻力指数） --在顶端大约 1.5 倍，以模拟空时 ~40 的阻力指数
				--删除了 10 度板条线，导致 SFM 插值错误
				--Cya max M0.15 为 0.95 导致接近 noflap=137-140，fullflap=120-123 目标：143/126 @ 14,000#
				--测试：M0.0和M0.15更改Cya 0.96 -> 0.92，M0.30保留Cya 0.71，在14000测试#
				--结果：138-141 noflap，121-123 襟翼
				--测试：Cya 0.92 -> 0.84，M<=0.15，0.71->0.66 M0.3，14K#
				--结果：145-147 襟翼，126-127 襟翼
				--测试：Cya归一化0.60@M0.40、0.61@0.30、14K#
				--结果：145-147 襟翼，126-127 襟翼
				--测试：Cya 0.84->0.85 M<=0.15, 14K#
				--结果：144-147 无襟翼，125-126 襟翼关闭！
				--测试：Cya 0.85->0.86、Cyflap 0.22->0.21、14000#
				--结果：143-146 襟翼，126-127 襟翼关闭 14K#
				--测试：Cya 0.86->0.87 M<=0.15
				--结果：142-145 次无襟翼，125-126 次襟翼完成 14K#（目标）
				--测试：权重12K#，目标：135/116.5
				--结果：131-133 个无襟翼，115-116 个襟翼完成 12K#（约 2% 的升力太少，没有襟翼）
				--测试：权重16K#，目标：153/134
				--结果：152-156 次无襟翼，134-135 次襟翼完成 16K#（达到目标）

				--缝翼在 200 KCAS 以下自动伸展，线性至 100 KCAS
				--缝翼的效果可能是更高的迎角、更高的阻力、更高的升力
				--对于 20 度板条延伸，M0.6 处的板条 Cd 约为 0.016，具有线性映射
				--M0.6 处的板条 Cl 对于 20 度板条延伸约为 0.06/度，2/3 来自前 10 度
			}, -- end of table_data
		}, -- end of aerodynamics
		engine =
		{
			Nmg     = 67.5, -- 怠速转速
			MinRUD  = 0, 	-- 油门最小状态
			MaxRUD  = 1, 	-- 油门最大状态
			MaksRUD = 0.85, -- 军用油门状态
			ForsRUD = 0.91, -- 油门加力状态
			typeng  = 1,
			--[[
            --    涡喷 = 0
            --    涡喷-带加力燃烧室 = 1
            --    活塞发动机 = 2
            --    涡桨发动机 = 3
            --    涡扇发动机 = 4
            --    涡轴发动机 = 5
            --]]
			hMaxEng = 20.5, --19,发动机安全运行的最大海拔高度（以公里为单位）
			dcx_eng = 0.0085, --Sean:Refer to F-22A --0.0144, --发动机阻力系数
			--影响发动机停机时的阻力
			--cemax/cefor 影响低速时升降舵/惯性的海绵度
			--明显影响可用的重力
			cemax = 1.24,                  --不用于燃油计算，仅用于AI例程检查飞行时间（内置燃油计算算法）
			cefor = 2.56,                  --不用于燃油计算，仅用于AI例程检查飞行时间（内置燃油计算算法）
			dpdh_m = 8000,                 --最大推力高度系数
			dpdh_f = 17000,                --加力状态推力的高度系数
			sound_name = "Aircrafts/J-20A/Silence", --shut up!fucking the default engine sound
			--Name = 'WS15',                 --invalid attribute
			table_data = {
			--   M		Pmax		Pfor			-- Sean: More clear
			--  Mach	Military	Afterburner	
				{0.0, 	298000,		490000}, 		--100%	100%
				{0.2, 	184009,		438184}, 		--62% 	89%
				{0.4, 	186448,		449138}, 		--63% 	92%
				{0.6, 	188276,		453522}, 		--63% 	93%
				{0.7, 	192794,		460093}, 		--65% 	94%
				{0.8, 	192794,		482003}, 		--65% 	98%
				{0.9, 	192794,		514866}, 		--65% 	105%
				{1.0, 	269633,		547730}, 		--90% 	112%
				{1.1, 	246043,		565257}, 		--83% 	115%
				{1.2, 	246043,		565257}, 		--83% 	115%
				{1.3, 	257279,		477998}, 		--86% 	98%
				{1.4, 	284887,		542254}, 		--96% 	111%
				{1.6, 	314200,		574790}, 		--105%	117%
				{1.8, 	327293,		609131}, 		--110%	124%
				{2.2, 	342092,		668779}, 		--115%	136%
				{2.5, 	359735,		704929}, 		--121%	144%
				{3.9, 	140023,		560329}, 		--47% 	114%
			-- Sean: above from F-22A, original keep in below(should from F-35)
			--[[
			--	{ 0.0, 189000, 242354 },
			--	{ 0.2, 189000, 260354 },
			--	{ 0.4, 189000, 272850 },
			--	{ 0.6, 189000, 289368 },
			--	{ 0.7, 186000, 297190 },
			--	{ 0.8, 186000, 305082 },
			--	{ 0.9, 183000, 250210 },
			--	{ 1.0, 175500, 327775 },
			--	{ 1.1, 169500, 347674 },
			--	{ 1.2, 165000, 367193 },
			--	{ 1.3, 153000, 391559 },
			--	{ 1.5, 127500, 427060 },
			--	{ 1.8, 45000,  458503 },
			--	{ 2.0, 19000,  445600 },
			--	{ 2.2, 17000,  324080 },
			--	{ 2.5, 12000,  235600 },
			--	{ 3.9, 10000,  175946 },]]
			}
		}, -- end of engine
	},

	Damage = {
		[0]   = { critical_damage = 3, args = { 148 } },                                               --NOSE_CENTER
		[1]   = { critical_damage = 8, args = { 149 } },                                               --NOSE_LEFT_SIDE
		[2]   = { critical_damage = 8, args = { 150 } },                                               --NOSE_RIGHT_SIDE
		[3]   = { critical_damage = 2, args = { 65, 66 } },                                            --3,COCKPIT、CABINA		
		[4]   = { critical_damage = 8, args = { 298 } },                                               --CABIN_LEFT_SIDE
		[5]   = { critical_damage = 8, args = { 299 } },                                               --CABIN_RIGHT_SIDE
		[6]   = { critical_damage = 8, args = { 297 } },                                               --CABIN_BOTTOM
		[7]   = { critical_damage = 1 },                                                               --GUN
		[8]   = { critical_damage = 10, args = { 265 }, deps_cells = { 83 } },                         --FRONT_GEAR_BOX、GEAR_REAR、GEAR_C、GEAR_F、STOIKA_F、GEAR_FRONT
		[9]   = { critical_damage = 10, args = { 153 }, construction = { durability = 7.69, skin = "Aluminum" }, }, --FUSELAGE_LEFT_SIDE
		[10]  = { critical_damage = 10, args = { 154 }, construction = { durability = 7.69, skin = "Aluminum" }, }, --MAIN,FUSELAGE_RIGHT_SIDE
		[11]  = { critical_damage = 5, args = { 161 }, construction = { durability = 2.22, skin = "Aluminum" }, }, --ENGINE_L,ENGINE_L_IN
		[12]  = { critical_damage = 5, args = { 160 }, construction = { durability = 2.22, skin = "Aluminum" }, }, --ENGINE_R,ENGINE_R_IN
		[15]  = { critical_damage = 8, args = { 266 }, deps_cells = { 84 } },                          --LEFT_GEAR_BOX,GEAR_L,STOIKA_L
		[16]  = { critical_damage = 8, args = { 267 }, deps_cells = { 85 } },                          --RIGHT_GEAR_BOX,GEAR_R,STOIKA_R
		[17]  = { critical_damage = 5, args = { 168 } },                                               --ENGINE_L_VNESHN
		[18]  = { critical_damage = 5, args = { 169 } },                                               --ENGINE_R_VNESHN
		[21]  = { critical_damage = 3, args = { 222 } },                                               --WING_L_PART_OUT
		[22]  = { critical_damage = 3, args = { 232 } },                                               --WING_R_PART_OUT
		[23]  = { critical_damage = 3, args = { 223 }, deps_cells = { 25, 21 } },                      --WING_L_OUT
		[24]  = { critical_damage = 3, args = { 233 }, deps_cells = { 26, 22 } },                      --WING_R_OUT
		[25]  = { critical_damage = 5, args = { 225 } },                                               --AILERON_L
		[26]  = { critical_damage = 5, args = { 235 } },                                               --AILERON_R
		[27]  = { critical_damage = 6, args = { 221 } },                                               --WING_L_PART_CENTER
		[28]  = { critical_damage = 6, args = { 231 } },                                               --WING_R_PART_CENTER
		[35]  = { critical_damage = 10, args = { 224 }, deps_cells = { 27, 37, 23 } },                 --WING_L
		[36]  = { critical_damage = 10, args = { 234 }, deps_cells = { 28, 38, 24 } },                 --"WING_R"
		[37]  = { critical_damage = 5, args = { 226 } },                                               --FLAP_L
		[38]  = { critical_damage = 5, args = { 236 } },                                               --FLAP_R
		[43]  = { critical_damage = 4, args = { 61 }, deps_cells = { 53 }, droppable = false },        --KEEL
		[47]  = { critical_damage = 5, args = { 63, 67 } },                                            --STABILIZATOR_L01,STABILIZATOR_L
		[48]  = { critical_damage = 5, args = { 64, 68 } },                                            --STABILIZATOR_R01,STABILIZATOR_R
		[53]  = { critical_damage = 5, args = { 247 } },                                               --RN_L,RUDDER_L
		[54]  = { critical_damage = 5, args = { 248 } },                                               --RN_R,RUDDER_R
		[55]  = { critical_damage = 20, args = { 156 }, droppable = false },                           --TAIL
		[56]  = { critical_damage = 10, args = { 157 } },                                              --TAIL_LEFT_SIDE
		[57]  = { critical_damage = 10, args = { 158 } },                                              --TAIL_RIGHT_SIDE
		[58]  = { critical_damage = 10, args = { 159 } },                                              --TAIL_BOTTOM
		[60]  = { critical_damage = 3, droppable = false },                                            --PWD
		[61]  = { critical_damage = 4, args = { 146 } },                                               --FUEL_TANK_F,FUEL_TANK_LEFT_SIDE
		[62]  = { critical_damage = 10, args = { 147 } },                                              --FUEL_TANK_RIGHT_SIDE
		[82]  = { critical_damage = 4, args = { 152 } },                                               --FUSELAGE_BOTTOM
		[83]  = { critical_damage = 2, args = { 134 } },                                               --WHEEL_F
		[84]  = { critical_damage = 2, args = { 136 } },                                               --WHEEL_L
		[85]  = { critical_damage = 2, args = { 135 } },                                               --WHEEL_R
		[86]  = { critical_damage = 3, args = { 162 }, construction = { durability = 1.00, skin = "Aluminum" }, }, --PYLONL
		[87]  = { critical_damage = 3, args = { 163 }, construction = { durability = 1.00, skin = "Aluminum" }, }, --PYLONL
		[88]  = { critical_damage = 3, args = { 164 }, construction = { durability = 1.00, skin = "Aluminum" }, }, --PYLON3
		[89]  = { critical_damage = 3, args = { 165 }, construction = { durability = 1.00, skin = "Aluminum" }, }, --PYLON4
		[100] = { critical_damage = 5, args = { 166 }, construction = { durability = 1.00, skin = "Aluminum" }, }, --TAIL_TOP
	},

	DamageParts =
	{
		"J-20A_oblomok_wing_R",
		"J-20A_oblomok_wing_L",
		"J-20A_oblomok_rudder_R",
		"J-20A_oblomok_rudder_L",
		"J-20A_oblomok_canard_R",
		"J-20A_oblomok_canard_L",
		"J-20A_oblomok_caudal_fin_R",
		"J-20A_oblomok_caudal_fin_L",
	},

	effects_presets = {
		{ effect = "APU_STARTUP_BLAST", preset = "F18", ttl = 3.0 },
		{ effect = "OVERWING_VAPOR",    file = current_mod_path .. "/Effects/J-20_overwingVapor.lua" },
		{ effect = 'LERX_VORTEX',       file = current_mod_path .. '/Effects/J-20_LERXVortex.lua' }
	},

	lights_data = {
		typename = "collection",
		lights = {
			[1] = {
				typename = "collection", --频闪灯
				lights = {
					[1] = {
						typename = "argumentlight", argument = 193, controller = "Strobe", period = 1.5,
					},
				}
			},
			[2] = {
				typename = "collection",          -- 着陆灯
				lights = {
					{ typename = "argumentlight", argument = 209 }, -- form front
					{ typename = "argumentlight", argument = 209 }, -- form aft
					{ typename = "argumentlight", argument = 209 }, -- form aft
				},
			},
			[3] = {
				typename = "collection",          -- 航行灯
				lights = {
					{ typename = "argumentlight", argument = 190 }, -- left nav light red
					{ typename = "argumentlight", argument = 191 }, -- tail nav light white
					{ typename = "argumentlight", argument = 192 }, -- right nav light green
				},
			},
			[4] = {
				typename = "collection",         -- 编队灯
				lights = {
					{ typename = "argumentlight", argument = 88 }, -- FORMATION LIGHTS
				},
			},
			[5] = {
				typename = "collection", -- 翼尖灯（直升机的）
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
			[6] = {
				typename = "Collection", --滑行灯
				lights = {
					{
						typename = "argumentlight", argument = 208,
					},
				},
			},
			[7] = {
				typename = "collection", --信标灯
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
			[8] = {
				typename = "collection", --舱内照明灯
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
			[9] = {
				typename = "collection", --舱内仪表照明
				lights = {
					[1] = {
						typename = "Collection",
						lights = {
							{
								typename = "Omni",
								connector = "pilots_vis",
								color = { 0.0, 0.5, 0.0, 0.2 },
								range = 5.0,
							},
						},
					},
				},
			},
			[10] = {
				typename = "collection", --加油探照灯（向前照明的）
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
			[11] = {
				typename = "collection", --探照灯（向下，直升机用）
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
			[12] = {
				typename = "collection", --示宽灯(红色的)
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
			[13] = {
				typename = "collection", --未知，压根未使用
				lights = {
					{ typename = "argumentlight", argument = -1 },
				}
			},
		}
	}, -- end lights_data
	connectDatalinks = {
		"Link16",
	},
}
J_20C = {}

CopyTable(J_20C, J_20A)
J_20C.Pylons[1].Launchers[#J_20C.Pylons[1].Launchers + 1] = { CLSID = "J_20A_AGM-65E", required = { { station = 2, loadout = { 'J_20A_AGM-65E' } } } }
J_20C.Pylons[2].Launchers[#J_20C.Pylons[2].Launchers + 1] = { CLSID = "J_20A_AGM-65E", required = { { station = 2, loadout = { 'J_20A_AGM-65E' } } } }

J_20C.Pylons[5].Launchers[#J_20C.Pylons[5].Launchers + 1] = { CLSID = "DIS_MK_20", required = { { station = 6, loadout = { 'DIS_MK_20' } } } }
J_20C.Pylons[5].Launchers[#J_20C.Pylons[5].Launchers + 1] = { CLSID = "DIS_GBU_12", required = { { station = 6, loadout = { 'DIS_GBU_12' } } } }

J_20C.Pylons[6].Launchers[#J_20C.Pylons[6].Launchers + 1] = { CLSID = "DIS_MK_20", required = { { station = 5, loadout = { 'DIS_MK_20' } } } }
J_20C.Pylons[6].Launchers[#J_20C.Pylons[6].Launchers + 1] = { CLSID = "DIS_GBU_12", required = { { station = 5, loadout = { 'DIS_GBU_12' } } } }
J_20C.ammo_type = { _("GSH23_23_HE"), _("GSH23_23_AP"), _('GSH23_23_HE_T') }
J_20C.Guns = {
	J_20_GunMount({
		effects = GunTemplate.GSH_23_2.effects,
		effective_fire_distance = 2000,
		drop_cartridge = 203,
	}, GunTemplate.GSH_23_2)
}
J_20A.Guns = {
	J_20_GunMount({
		effects = GunTemplate.GSH_23_2.effects,
		effective_fire_distance = 2000,
		drop_cartridge = 203,
	}, GunTemplate.GSH_23_2)
}
J_20C.Shape = 'J-20C'
J_20C.picture = 'J-20C.png'
J_20C.Name = 'J-20C'
J_20C.username = 'J-20C'
J_20C.DisplayName = _('J-20C')
J_20C.shape_table_data[1].file = 'J-20C'
J_20C.shape_table_data[1].username = 'J-20C'
J_20C.launch_bar_connected_arg_value = 0.87
J_20C.mechanimations['LaunchBar'] = {
	{ Transition = { "Retract", "Extend" }, Sequence = { { C = { { "ChangeDriveTo", "HydraulicGravityAssisted" }, { "VelType", 3 }, { "Arg", 85, "to", 0.881, "in", 4.4 } } } } },
	{ Transition = { "Retract", "Stage" }, Sequence = { { C = { { "ChangeDriveTo", "HydraulicGravityAssisted" }, { "VelType", 3 }, { "Arg", 85, "to", 0.815, "in", 4.4 } } } } },
	{ Transition = { "Any", "Retract" },  Sequence = { { C = { { "ChangeDriveTo", "Hydraulic" }, { "VelType", 2 }, { "Arg", 85, "to", 0.000, "in", 4.5 } } } } },
	{
		Transition = { "Extend", "Stage" },
		Sequence = {
			{ C = { { "ChangeDriveTo", "Mechanical" }, { "Sleep", "for", 0.000 } } },
			{ C = { { "Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600 } } },
			{ C = { { "Arg", 85, "from", 0.766, "to", 0.753, "in", 0.200 } } },
			{ C = { { "Sleep", "for", 0.15 } } },
			{ C = { { "Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2 } } },
			{ C = { { "Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0 } } },
		},
	},
	{
		Transition = { "Stage", "Pull" },
		Sequence = {
			{ C = { { "ChangeDriveTo", "Mechanical" }, { "VelType", 2 }, { "Arg", 85, "from", 0.881, "to", J_20C.launch_bar_connected_arg_value, "in", 0.27 } } },
		}
	},
	{ Transition = { "Stage", "Extend" }, Sequence = { { C = { { "ChangeDriveTo", "HydraulicGravityAssisted" }, { "VelType", 3 }, { "Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2 } } } } },
}
J_20C.Pylons[9] = pylon(9, 0, 0.00000, -0.0000, 0.00000, {
	use_full_connector_position = true,
	connector = "Pylon_009",
}, {
	{ CLSID = "J20_PL-15_DUAL",			arg_value = 1.0, required = { { station = 10, loadout = { "J20_PL-15_DUAL" } } } },
	{ CLSID = "DIS_PL-12_DUAL_L",		arg_value = 1.0, required = { { station = 10, loadout = { "DIS_PL-12_DUAL_L" } } } },
	{ CLSID = "DIS_LD-10_DUAL_L",		arg_value = 1.0, required = { { station = 10, loadout = { "DIS_LD-10_DUAL_L" } } } },
	{ CLSID = "J20_CM102A_DUAL",		arg_value = 1.0, required = { { station = 10, loadout = { 'J20_CM102A_DUAL' } } } },
	{ CLSID = "{J20A_PL15}",			arg_value = 1.0, required = { { station = 10, loadout = { "{J20A_PL15}" } } } },
	{ CLSID = "{J20A_PL17}",			arg_value = 1.0, required = { { station = 10, loadout = { "{J20A_PL17}" } } } },
	{ CLSID = "DIS_PL-12",				arg_value = 1.0, required = { { station = 10, loadout = { "DIS_PL-12" } } } },
	{ CLSID = "DIS_LD-10",				arg_value = 1.0, required = { { station = 10, loadout = { "DIS_LD-10" } } } },
	{ CLSID = "{J20A_CM102A}",			arg_value = 1.0, required = { { station = 10, loadout = { '{J20A_CM102A}' } } } },

	{ CLSID = "J_20A_AGM-65E",			arg_value = 1.0, required = { { station = 10, loadout = { "J_20A_AGM-65E" } } } },
	{ CLSID = "DIS_DF4B_YJ12",			arg_value = 1.0, Type = 0, required = { { station = 10, loadout = { "DIS_DF4B_YJ12" } } } },
	{ CLSID = "DIS_GDJ_YJ83K",			arg_value = 1.0, Type = 1, required = { { station = 10, loadout = { "DIS_GDJ_YJ83K" } } } },
	{ CLSID = "J20C_Laser_Cannon_POD",	arg_value = 1.0, required = { { station = 10, loadout = { "J20C_Laser_Cannon_POD" } } } },
	{ CLSID = "J20C_EML_POD",			arg_value = 1.0, required = { { station = 10, loadout = { "J20C_EML_POD" } } } },

	{ CLSID = "DIS_TANK1100",			arg_value = 1.0, required = { { station = 10, loadout = { "DIS_TANK1100" } } } },
	{ CLSID = "DIS_TANK1100_EMPTY",		arg_value = 1.0, required = { { station = 10, loadout = { "DIS_TANK1100_EMPTY" } } } },

	{ CLSID = "<CLEAN>",				arg_value = 0.0, required = { { station = 10, loadout = { "<CLEAN>" } } } },
})
J_20C.Pylons[10] = pylon(10, 0, 0.00000, -0.0000, 0.00000, {
	use_full_connector_position = true,
	connector = "Pylon_010",
}, {
	{ CLSID = "J20_PL-15_DUAL",			 required = { { station = 9, loadout = { "J20_PL-15_DUAL" } } } },
	{ CLSID = "DIS_PL-12_DUAL_L",		 required = { { station = 9, loadout = { "DIS_PL-12_DUAL_L" } } } },
	{ CLSID = "DIS_LD-10_DUAL_L",		 required = { { station = 9, loadout = { "DIS_LD-10_DUAL_L" } } } },
	{ CLSID = "J20_CM102A_DUAL",		 required = { { station = 9, loadout = { 'J20_CM102A_DUAL' } } } },
	{ CLSID = "{J20A_CM102A}",			 required = { { station = 9, loadout = { '{J20A_CM102A}' } } } },
	{ CLSID = "{J20A_PL15}",			 required = { { station = 9, loadout = { "{J20A_PL15}" } } } },
	{ CLSID = "{J20A_PL17}",			 required = { { station = 9, loadout = { "{J20A_PL17}" } } } },
	{ CLSID = "DIS_PL-12",				 required = { { station = 9, loadout = { "DIS_PL-12" } } } },
	{ CLSID = "DIS_LD-10",				 required = { { station = 9, loadout = { "DIS_LD-10" } } } },

	{ CLSID = "J_20A_AGM-65E",			 required = { { station = 9, loadout = { "J_20A_AGM-65E" } } } },
	{ CLSID = "DIS_DF4B_YJ12",			 Type = 0, required = { { station = 9, loadout = { "DIS_DF4B_YJ12" } } } },
	{ CLSID = "DIS_GDJ_YJ83K",			 Type = 1, required = { { station = 9, loadout = { "DIS_GDJ_YJ83K" } } } },
	{ CLSID = "J20C_Laser_Cannon_POD",	 required = { { station = 9, loadout = { "J20C_Laser_Cannon_POD" } } } },
	{ CLSID = "J20C_EML_POD",			 required = { { station = 9, loadout = { "J20C_EML_POD" } } } },

	{ CLSID = "DIS_TANK1100",			 required = { { station = 9, loadout = { "DIS_TANK1100" } } } },
	{ CLSID = "DIS_TANK1100_EMPTY",		 required = { { station = 9, loadout = { "DIS_TANK1100_EMPTY" } } } },
	{ CLSID = "<CLEAN>",				 required = { { station = 9, loadout = { "<CLEAN>" } } } },
})
J_20C.Pylons[11] = pylon(11, 0, 0.00000, -0.0000, 0.00000, {
	use_full_connector_position = true,
	connector = "Pylon_011",
}, {
	{ CLSID = "J20_PL-15_DUAL",      required = { { station = 12, loadout = { "J20_PL-15_DUAL" } } } },
	{ CLSID = "DIS_PL-12_DUAL_L",    required = { { station = 12, loadout = { "DIS_PL-12_DUAL_L" } } } },
	{ CLSID = "DIS_LD-10_DUAL_L",    required = { { station = 12, loadout = { "DIS_LD-10_DUAL_L" } } } },
	{ CLSID = "J20_CM102A_DUAL",	 required = { { station = 12, loadout = { 'J20_CM102A_DUAL' } } } },
	{ CLSID = "{J20A_PL15}",         required = { { station = 12, loadout = { "{J20A_PL15}" } } } },
	{ CLSID = "{J20A_PL17}",         required = { { station = 12, loadout = { "{J20A_PL17}" } } } },
	{ CLSID = "DIS_PL-12",           required = { { station = 12, loadout = { "DIS_PL-12" } } } },
	{ CLSID = "DIS_LD-10",           required = { { station = 12, loadout = { "DIS_LD-10" } } } },
	{ CLSID = "{J20A_CM102A}",		 required = { { station = 12, loadout = { '{J20A_CM102A}' } } } },

	{ CLSID = "J_20A_AGM-65E",       required = { { station = 12, loadout = { "J_20A_AGM-65E" } } } },
	{ CLSID = "DIS_DF4B_YJ12",       Type = 0, required = { { station = 12, loadout = { "DIS_DF4B_YJ12" } } } },
	{ CLSID = "DIS_GDJ_YJ83K",       Type = 1, required = { { station = 12, loadout = { "DIS_GDJ_YJ83K" } } } },

	{ CLSID = "DIS_TANK1100",        required = { { station = 12, loadout = { "DIS_TANK1100" } } } },
	{ CLSID = "DIS_TANK1100_EMPTY",  required = { { station = 12, loadout = { "DIS_TANK1100_EMPTY" } } } },
	{ CLSID = "<CLEAN>",             required = { { station = 12, loadout = { "<CLEAN>" } } } },
})
J_20C.Pylons[12] = pylon(12, 0, 0.00000, -0.0000, 0.00000, {
	use_full_connector_position = true,
	connector = "Pylon_012",
}, {
	{ CLSID = "J20_PL-15_DUAL",      required = { { station = 11, loadout = { "J20_PL-15_DUAL" } } } },
	{ CLSID = "DIS_PL-12_DUAL_L",    required = { { station = 11, loadout = { "DIS_PL-12_DUAL_L" } } } },
	{ CLSID = "DIS_LD-10_DUAL_L",    required = { { station = 11, loadout = { "DIS_LD-10_DUAL_L" } } } },
	{ CLSID = "J20_CM102A_DUAL",	 required = { { station = 11, loadout = { 'J20_CM102A_DUAL' } } } },
	{ CLSID = "{J20A_PL15}",         required = { { station = 11, loadout = { "{J20A_PL15}" } } } },
	{ CLSID = "{J20A_PL17}",         required = { { station = 11, loadout = { "{J20A_PL17}" } } } },
	{ CLSID = "DIS_PL-12",           required = { { station = 11, loadout = { "DIS_PL-12" } } } },
	{ CLSID = "DIS_LD-10",           required = { { station = 11, loadout = { "DIS_LD-10" } } } },
	{ CLSID = "{J20A_CM102A}",		 required = { { station = 11, loadout = { '{J20A_CM102A}' } } } },

	{ CLSID = "J_20A_AGM-65E",       required = { { station = 11, loadout = { "J_20A_AGM-65E" } } } },
	{ CLSID = "DIS_DF4B_YJ12",       Type = 0, required = { { station = 11, loadout = { "DIS_DF4B_YJ12" } } } },
	{ CLSID = "DIS_GDJ_YJ83K",       Type = 1, required = { { station = 11, loadout = { "DIS_GDJ_YJ83K" } } } },

	{ CLSID = "DIS_TANK1100",        required = { { station = 11, loadout = { "DIS_TANK1100" } } } },
	{ CLSID = "DIS_TANK1100_EMPTY",  required = { { station = 11, loadout = { "DIS_TANK1100_EMPTY" } } } },
	{ CLSID = "<CLEAN>",             required = { { station = 11, loadout = { "<CLEAN>" } } } },
})

J_20C.Pylons[13] = {}
J_20C.Pylons[14] = {}
J_20C.Pylons[15] = {}
CopyTable(J_20C.Pylons[13], J_20A.Pylons[9])
CopyTable(J_20C.Pylons[14], J_20A.Pylons[10])
CopyTable(J_20C.Pylons[15], J_20A.Pylons[11])
J_20C.Pylons[13].Number = 13
J_20C.Pylons[13].Order = 13
J_20C.Pylons[14].Number = 14
J_20C.Pylons[14].Order = 14
J_20C.Pylons[15].Number = 15
J_20C.Pylons[15].Order = 15
add_aircraft(J_20A)
add_aircraft(J_20C)
