#ifndef _NVD_COMMON_
#define _NVD_COMMON_

#include "common/context.hlsl"

/* =========================
   ASILTURQ NVG CORE TUNING
   ========================= */

float NVG_SIZE = 0.90;        // NVG mask size (kk = daha geni gr)
float NVG_VERT_POS = -0.20;   // NVG dikey pozisyon

#define MASK_SIZE ((1.0 / 0.8) * NVG_SIZE)

/* =========================
   MASK FUNCTIONS
   ========================= */

float getMask(float2 c, float mul)
{
    return saturate(mul * (1.0 - sqrt(dot(c, c))));
}

float2 calcMaskCoord(float2 projPos)
{
    return float2(
        (projPos.x - gNVDpos.x) * gNVDaspect,
        projPos.y - (gNVDpos.y + NVG_VERT_POS)
    ) * MASK_SIZE;
}

float getNVDMask(float2 projPos)
{
    float2 uvm = calcMaskCoord(projPos);
    return getMask(uvm, 8.0);
}

/* =========================
   TECH 2 (OPTICAL) MASK
   ========================= */

float getMask2(float d, float mul)
{
    return 1.0 - saturate(mul * (1.0 - d));
}

float2 calcMaskCoord2(float2 projPos)
{
    float4 vp = mul(float4(projPos, 1, 1), gProjInv);
    float3 vp3 = normalize(vp.xyz / vp.w);
    return float2(
        dot(gNVDdir, vp3) * gNVDmul,
        sqrt(1.0 - 1.0 / (gNVDmul * gNVDmul))
    );
}

float getNVDMask2(float2 projPos)
{
    float2 d = calcMaskCoord2(projPos);
    return getMask(d.x, 10.0 * d.x / d.y);
}

#endif
