collimated = false

stroke_thickness = 120   --200
stroke_fuzziness = 120  --200

function roundDI(value)
	if value > 0 then
		return math.floor(value + 0.5)
	else
		return math.ceil(value - 0.5)
	end
end

MeterToIn					= 39.3701
InToMeter					= 1 / MeterToIn

PixelsPerSide			= 960
HalfPixelsPerSide		= PixelsPerSide / 2

local ScreenSizeInch		= 4		-- inches

-- Currently this values are used
local PXtoIn_		= ScreenSizeInch / PixelsPerSide
local InToPX_		= 1.0 / PXtoIn_

local DegToRad_		= math.rad(1)
local RadToDeg_		= 1.0 / DegToRad_

local DegToMil_		= math.rad(1) * 1000
local MilToDeg_		= 1.0 / DegToMil_

local RadToMil_		= 1000
local MilToRad_		= 1.0 / RadToMil_

-- PX is a pixel in MFD indicators.
function PXtoIn(param) return (param or 1) * PXtoIn_ end						-- PX to inches
function InToPX(param) return (param or 1) * InToPX_ end						-- inches to PX

function DegToRad(param) return (param or 1) * DegToRad_ end
function RadToDeg(param) return (param or 1) * RadToDeg_ end

function DegToMil(param) return (param or 1) * DegToMil_ end
function MilToDeg(param) return (param or 1) * MilToDeg_ end

function RadToMil(param) return (param or 1) * RadToMil_ end
function MilToRad(param) return (param or 1) * MilToRad_ end

local bgSize = 10.5
displayBorderVerts = {
	{ bgSize,  bgSize},
	{ bgSize, -bgSize},
	{-bgSize, -bgSize},
	{-bgSize,  bgSize}
}

-- Tools for indicator border mesh handling

-- Add the second half of the convex poly mirrored about Y axis
local function addVertsMirroredAboutY(verts)
	--if #verts == 0 then do return end end
	
	local vertsSz = #verts
	for i = 0, vertsSz - 1 do
		local idx = vertsSz - i
		verts[#verts + 1] = {-(verts[idx][1]), (verts[idx][2])}
	end
end

-- Rescale verts
local function rescaleVerts(verts, scale)
	for i = 1, #verts do
		verts[i] = {verts[i][1] * scale, verts[i][2] * scale}
	end
end

-- Build indices for a convex poly.
-- Mesh should be described point-to-point either clockwise or counterclockwise
-- (both will work, as the poly is usually rendered as a two sided).
local function buildMeshPolyIndices(verts)
	--if #verts < 3 then do return end end
	
	local inds = {}
	for i = 1, #verts - 2 do
		inds[3 * (i-1) + 1] = 0
		inds[3 * (i-1) + 2] = i
		inds[3 * (i-1) + 3] = i + 1 
	end 
	
	return inds
end

function prepareBorderVerts(verts, scale)
	-- Add the second half of the border (mirrored about Y axis)
	addVertsMirroredAboutY(verts)
	-- Rescale vertices to indicator units
	rescaleVerts(verts, scale)
	-- Build indices and return them as a table
	return buildMeshPolyIndices(verts)
end