dofile(LockOn_Options.common_script_path.."devices_defs.lua")
dofile(LockOn_Options.script_path.."materials.lua")

indicator_type	= indicator_types.COMMON
purposes		= {render_purpose.BAKE}

opacity_sensitive_materials =
{
	"HUD_STROKE"
}

color_sensitive_materials =
{
	"HUD",
	"HUD_STROKE",
	"HUD_NIGHT",
}

function get_color(tbl_in)
	tbl_out = {}
	
	local ind = 0
	for k, v in pairs(tbl_in) do
		ind = ind + 1
		if (ind < 4) then
			tbl_out[k] = v
		end
	end
	
	return tbl_out
end

indication_color	= get_color(materials["HUD"])
ring_color 			= get_color(materials["HUD_STROKE"])
grid_color			= get_color(materials["HUD_GRID"])
night_color     	= get_color(materials["HUD_NIGHT"])

shaderLineParamsUpdatable  = true
shaderLineDefaultThickness = 0.55  --0,8
shaderLineDefaultFuzziness = 0.08  --0,5
shaderLineDrawAsWire 	   = false
shaderLineUseSpecularPass  = false

dynamically_update_geometry = false

dofile(LockOn_Options.script_path.."Displays/HUD/indicator/HUD_Pages_init.lua")

-- optical center is 5.2 degrees below the FRL
collimator_default_distance_factor = {auto_collimator_default_distance_factor[1], auto_collimator_default_distance_factor[1] * math.rad(-5.2), 0}
