-- Place this file in C:\Users\<username>\Saved Games\DCS_F4E\jester\mods\
local Class = require('base.Class')
local Behavior = require('base.Behavior')
local Interactions = require('base.Interactions')

local default_interval = s(5)

local LightingPresets = Class(Behavior)

local isFirstTick = true

function LightingDay()
    -- contrast and brightness knobs around the radar screen
    ClickRaw(Interactions.devices.HUD_AN_ASG_26, Interactions.device_commands.HUD_AdjustIntensity_AXIS, -1) -- HUD brightness       - Full bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_SCALE_AXIS, -1)            -- Scale brightness     - Full bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, -1)       -- Screen brightness    - Full bright

    -- RWR Display Brightness
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_RWR_KNOB_AXIS, -1)     -- RWR display brightness    - Full bright
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_APR_DIM_KNOB_AXIS, -1) -- RWR button brightness     - Full bright

    -- Light settings interior
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 0)  -- Instrument flood switch   - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 0) -- Red Flood switch          - Dim
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, 1)              -- White flood switch        - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, 1)              -- Console light knob        - Minimum
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, 1)     -- Instrument light knob     - Minimum
end

function LightingMid()
    -- contrast and brightness knobs around the radar screen
    ClickRaw(Interactions.devices.HUD_AN_ASG_26, Interactions.device_commands.HUD_AdjustIntensity_AXIS, -0.6) -- HUD brightness     - Mostly bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_SCALE_AXIS, -0.6)            -- Scale brightness   - Mostly bright
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, -0.6)       -- Screen brightness  - Mostly bright

    -- RWR Display Brightness
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_RWR_KNOB_AXIS, -0.6)     -- RWR display brightness    - Mostly bright
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_APR_DIM_KNOB_AXIS, -0.6) -- RWR button brightness     - Mostly bright

    -- Light settings interior
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 1)  -- Instrument flood switch   - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, 1) -- Red Flood switch          - Dim //
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, 1)              -- White flood switch        - Off
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, 0)              -- Console light knob        - Half
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, 0)     -- Instrument light knob     - Half
end

function LightingNight()
    -- contrast and brightness knobs around the radar screen
    ClickRaw(Interactions.devices.HUD_AN_ASG_26, Interactions.device_commands.HUD_AdjustIntensity_AXIS, 0.5) -- HUD brightness  - Mostly dim
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_SCALE_AXIS, 0.5)    -- Scale brightness        - Mostly dim
    ClickRaw(Interactions.devices.RADAR, Interactions.device_commands.PILOT_DSCG_BRIGHTNESS_AXIS, 0.5) -- Screen brightness     - Mostly dim

    -- RWR Display Brightness
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_RWR_KNOB_AXIS, 0.5)     -- RWR display brightness   - Dim
    ClickRaw(Interactions.devices.RWR_INTERFACE, Interactions.device_commands.PILOT_APR_DIM_KNOB_AXIS, 0.5) -- RWR button brightness    - Dim

    -- Light settings interior
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_RIGHT_WALL_INSTRUMENT_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, -1)  -- Instrument flood switch   - On
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_FLOODLIGHT_BRIGHTNESS_SWITCH_AXIS, -1)  -- Red Flood switch          - Bright //
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_WHITE_FLOODLIGHT_SWITCH_AXIS, 0)               -- White flood switch        - On
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_CONSOLE_BRIGHTNESS_KNOB_AXIS, -1)              -- Console light knob        - Full bright
    ClickRaw(Interactions.devices.INTERIOR_LIGHTS, Interactions.device_commands.PILOT_COCKPIT_LIGHTS_INSTRUMENT_PANEL_BRIGHTNESS_KNOB_AXIS, -1)     -- Instrument light knob     - Full bright
end

function SetupMenus()
    local menu_page = Wheel.Item.new({
        name = "Lighting",
        menu = Wheel.Menu.new({
            name = "Presets",
            items = {
                Wheel.Item.new({ 
                    name = "Day",           
                    action = "day_btn"
                }),
                Wheel.Item.new({ 
                    name = "Dusk/Dawn",           
                    action = "mid_btn"
                }),
                Wheel.Item.new({ 
                    name = "Night",           
                    action = "night_btn"
                })
            }
        })
    })

    Wheel.AddItem(menu_page, {})    --Add the menu page to the wheel root
end

function LightingPresets:Constructor()
	Behavior.Constructor(self)
end

function LightingPresets:Tick()
	if isFirstTick then
		isFirstTick = false

        SetupMenus()

        -- Create the ListenTo() functions for the actions.
        ListenTo("day_btn", "day_lighting_preset", function() 
            Log("Day lighting preset selected")
            LightingDay()
        end)

        ListenTo("mid_btn", "mid_lighting_preset", function() 
            Log("Mid lighting preset selected")
            LightingMid()
        end)

        ListenTo("night_btn", "night_lighting_preset", function() 
            Log("Night lighting preset selected")
            LightingNight()
        end)


    end-- End first tick
end -- End tick

LightingPresets:Seal()
return LightingPresets