# Flaming Cliffs: Clickable Cockpits Continued
#### A mod for DCS by TicTac, original CLICKABLE-FC3 mod by RedK0d
#### Licensed under GNU-GPL-3.0

<br>


## About
This mod aims to add basic clickable functionality to all Flaming Cliffs aircraft in DCS, including FC24, with a later goal being to enhance some of it where possible. Basic support means you can trigger most keybinds by clicking an appropriate part of the cockpit, but with no added features.  PDFs showing clickable points for each aircraft are in the **FC-Clickable-Cockpits-Continued\Doc** folder, and try to be as accurate to the real aircraft as possible.  All aircraft and their level of support are listed below:

- **A-10A:**  Basic
- **F-5E:**  Basic
- **F-15C:**  Basic
- **F-86:**  Basic
- **MiG-15bis:**  Basic
- **MiG-29:**  Basic
- **SU-25A:**  Basic
- **SU-25T:**  Basic
- **SU-27 / J-11A:**  Basic
- **SU-33:**  Basic

Due to the lack of licensing on the original mod, and to my lack of experience with DCS modding, I'm rebuilding it from scratch.
**This mod, *Clickable Cockpits Continued* is licensed under GNU-GPL-3.0,** meaning that it is open source and will always be open source.  Anyone is free to copy this and work on it as long as they keep it open, and I hope that the work I've done here can help others learn how to write plugins and mods for DCS -- I'm trying to document the code as thoroughly as I can so that this project might centralize some of the knowledge floating around in the community.

## Installation
- Download the latest **[Release](https://github.com/TicTac-93/FC-Clickable-Cockpits-Continued/releases)** version
- Copy the **FC-Clickable-Cockpits-Continued** folder to your **%UserProfile%/Saved Games/DCS/Mods/tech/** directory, NOT to your DCS installation directory
- Check for an **FC Clickable Cockpits** menu under **Options** > **Special**
  - If installed correctly, you should see that menu with options to enable or disable the mod for each aircraft

## Troubleshooting
- If you're in a supported aircraft and can't click anything:
  - Try pressing your bind for "Force cursor to show" (default LALT+C)
  - Check that it's enabled in the **FC Clickable Cockpits** Options menu
  - Check the PDF for your aircraft in **FC-Clickable-Cockpits-Continued\Doc** to see what points are clickable.  Some functions are split between LMB and RMB, eg Left Click will RAISE landing gear, while Right Click will lower it.

## Original CLICKABLE-FC3 mod

RedK0d's original mod was a big help in getting me into DCS and combat flight sims, it bridged a very important gap between the FC aircraft and the much more expensive, and difficult to learn, full-fidelity aircraft that the game is known for. Simply being able to interact with each jet in a more natural way made the game so much more enjoyable to me, and so much easier to get accustomed to. Unfortunately, RedK0d hasn't been active on discord, youtube, or github in a while, and even before the release of FC24 there were some compatibility issues with the mod as ED updates older cockpit models in the game. Because of that, I wanted to take over maintaining the mod.

If you're looking for RedK0d's original mod, you can find the **[github repo here](https://github.com/RedK0d/CLICKABLE-FC3)**, and their **[Gumroad page here](https://redk0d.gumroad.com/l/fvkodo)**.
