--
-- file prepared:  2025 14:38:53.303, using fd653a
--
--SFM_characteristics.lua (file 2 for assembly)

hawkersiddeley_nimrod = {

	Name = 'hawkersiddeley_nimrod',

	DisplayName = _('hawkersiddeley_nimrod'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "hawkersiddeley_nimrod.png",
	Rate = 50,
	Shape = "hawkersiddeley_nimrod",

	shape_table_data =
	{
		{
			file = 'hawkersiddeley_nimrod';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'hawkersiddeley_nimrod';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------
	length = 38.63,
	height = 9.4,
	wing_area = 197.05,
	wing_span = 35,
	wing_tip_pos = { -2, -1.9, 17},
	RCS = 21,											-- (estimated from height, length and wing surface area)
	air_refuel_receptacle_pos = { 0, 0, 0},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 39009,
	M_nominal = 64000,
	M_max = 87090,
	M_fuel_max = 17500,
	H_max = 13411,										-- (calculated from service_ceiling)
	CAS_min = 77,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 204,
	V_take_off = 80,
	V_land = 80,
	V_max_sea_level = 127,
	V_max_h = 183,
	Vy_max = 30,
	Mach_max = 0.85,
	Ny_min = -3,										-- default
	Ny_max = 8,											-- default
	Ny_max_e = 8,										-- default
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 15.75, -4.4, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { 1.32, -4.55, 4.33},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 22078,
	thrust_sum_ab = 22078,
	engines_count = 4,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {15.75, -3.45, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {15.75, -4.4, 0},
		}, --end of[1]
		--[2] =
		--{
			--ejection_seat_name = 9,
			--drop_canopy_name = "aircraft_canopy_2",
			--canopy_pos = {15.75, -3.45, 0},
			--canopy_ejection_dir = {0.0, 0.5, 0.5},
			--pos = {15.75, -4.4, 0},
			--canopy_arg = 421,
		--}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-4, -2.5, 2.8},
			elevation = -2.5,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.375,
		}, -- end of [1]
		[2] =
		{
			pos = {-4, -2.5, -2.8},
			elevation = -2.5,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.375,
		}, -- end of [2]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------




	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
			} 
		),
		pylon(4, 0, 4, -2.5, 0, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{8B7CADF9-4954-46B3-8CFB-93F2F5B90B03}" }, --AGM-84A 
				{ CLSID = "{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}" }, --AGM-84E 
			} 
		),
		pylon(5, 0, -1, -2.5, 0, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{8B7CADF9-4954-46B3-8CFB-93F2F5B90B03}" }, --AGM-84A 
				{ CLSID = "{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}" }, --AGM-84E 
			} 
		),
		pylon(6, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

---------------------------------------------------------------------------------------------------------------------------------------------

		 -- calibrate_countermeasures 

---------------------------------------------------------------------------------------------------------------------------------------------



	fires_pos =
	{
		[1] = { -1, -1.9, 0.0},
		[2] = { -0.4, -1.9, 0.2},
		[3] = { -0.6, -1.9, -0.2},
		[4] = { -1, -1.9, 4.25},
		[5] = { -1, -1.9, -4.25},
		[6] = { -1, -1.9, 13.6},
		[7] = { -1, -1.9, -13.6},
		[8] = { -4, -2.5, 0.2},
		[9] = { -4, -2.5, -0.2},
		[10] = { -2, -1.9, 0.2},
		[11] = { -2, -1.9, -0.2},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.036,	0.162,	0.0932,	1.38,	11.7,	0.422,		},
				{0.1,	0.015,	0.0326,	0.162,	0.0932,	3.75,	13,	0.422,		},
				{0.2,	0.015,	0.0295,	0.162,	0.0932,	3.75,	14.3,	0.422,		},
				{0.3,	0.015,	0.0509,	0.162,	0.0932,	3.75,	15.8,	0.622,		},
				{0.4,	0.015,	0.0724,	0.162,	0.0932,	3.75,	17.5,	1.29,		},
				{0.5,	0.015,	0.0562,	0.16,	0.153,	3.75,	17.5,	1,		},
				{0.6,	0.015,	0.0457,	0.153,	0.221,	3.75,	17.5,	1,		},
				{0.7,	0.015,	0.0381,	0.143,	0.298,	3.75,	17.5,	1,		},
				{0.8,	0.0213,	0.03,	0.106,	0.368,	1.38,	17.5,	1,		},
				{0.9,	0.035,	0.03,	0.00145,	0.00019,	1.21,	17.5,	1,		},
				{1,		0.0575,	0.03,	0.0015,	0.0002,	1.06,	16.6,	0.951,		},
				{1.1,	0.0675,	0.03,	0.00155,	0.00021,	0.925,	15.8,	0.905,		},
				{1.2,	0.0775,	0.03,	0.0016,	0.00022,	0.809,	15.1,	0.861,		},
			}, --end of table_data
		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,
			MaxRUD = 1,
			MaksRUD  = 0.85,
			ForsRUD  = 0.91,
			typeng  = 1,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,
			dpdh_f = 2000,

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	94542,	94542,		},
				{0.2,	141813,	141813,		},
				{0.4,	189085,	189085,		},
				{0.6,	189085,	189085,		},
				{0.8,	189085,	189085,		},
				{1,	189085,	189085,		},
				{1.2,	189085,	189085,		},
				{1.4,	189085,	189085,		},
				{1.6,	189085,	189085,		},
				{1.8,	189085,	189085,		},
				{2,	141813,	141813,		},
				{2.2,	94542,	94542,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				32 k ft		0.m		adj:+/-
				34 k ft		0.m		adj:+/-
				38 k ft		0.m		adj:+/-
				42 k ft		0.m		adj:+/-
				46 k ft		0.m		adj:+/-
				48 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9905, 10401, 11622, 13075, 14237, 14891 }, 
					thrust = {
						{ 108224, 162336, 216448, 216448, 216448, 216448, 216448, 216448, 216448, 216448, 216448, 216448 }, 
						{ 94566,  141849, 189132, 189132, 189132, 189132, 189132, 189132, 189132, 189132, 189132, 189132 }, 
						{ 64025,  96037,  128050, 128050, 128050, 128050, 128050, 128050, 128050, 128050, 128050, 128050 }, 
						{ 52705,  79057,  105410, 105410, 105410, 105410, 105410, 105410, 105410, 105410, 105410, 105410 }, 
						{ 43029,  64544,  86059,  86059,  86059,  86059,  86059,  86059,  86059,  86059,  86059,  86059  }, 
						{ 40584,  60876,  81168,  81168,  81168,  81168,  81168,  81168,  81168,  81168,  81168,  81168  }, 
						{ 35735,  53603,  71471,  71471,  71471,  71471,  71471,  71471,  71471,  71471,  71471,  71471  }, 
						{ 4328,   6493,   8657,   8657,   8657,   8657,   8657,   8657,   8657,   8657,   8657,   8657   }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9905, 10401, 11622, 13075, 14237, 14891 }, 
					thrust = {
						{ 108224, 162336, 216448, 216448, 216448, 216448, 216448, 216448, 216448, 216448, 216448, 216448 }, 
						{ 94566,  141849, 189132, 189132, 189132, 189132, 189132, 189132, 189132, 189132, 189132, 189132 }, 
						{ 64025,  96037,  128050, 128050, 128050, 128050, 128050, 128050, 128050, 128050, 128050, 128050 }, 
						{ 52705,  79057,  105410, 105410, 105410, 105410, 105410, 105410, 105410, 105410, 105410, 105410 }, 
						{ 43029,  64544,  86059,  86059,  86059,  86059,  86059,  86059,  86059,  86059,  86059,  86059  }, 
						{ 40584,  60876,  81168,  81168,  81168,  81168,  81168,  81168,  81168,  81168,  81168,  81168  }, 
						{ 35735,  53603,  71471,  71471,  71471,  71471,  71471,  71471,  71471,  71471,  71471,  71471  }, 
						{ 4328,   6493,   8657,   8657,   8657,   8657,   8657,   8657,   8657,   8657,   8657,   8657   }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		}, --end of engine

	},

	DamageParts =
	{
		[1] = "hawkersiddeley_nimrod-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(hawkersiddeley_nimrod)


