env.info('*** MOOSE GITHUB Commit Hash ID: 2025-05-03T17:03:30+02:00-e9d812f3157235f28b713f68ad1051a3fafb85df ***')
if not MOOSE_DEVELOPMENT_FOLDER then
MOOSE_DEVELOPMENT_FOLDER='Scripts'
end
ModuleLoader=MOOSE_DEVELOPMENT_FOLDER..'/Moose/Modules.lua'
if io then
local f=io.open(ModuleLoader,"r")
if f~=nil then
io.close(f)
env.info('*** MOOSE DYNAMIC INCLUDE START *** ')
local base=_G
__Moose={}
__Moose.Include=function(IncludeFile)
if not __Moose.Includes[IncludeFile]then
__Moose.Includes[IncludeFile]=IncludeFile
local f=assert(base.loadfile(IncludeFile))
if f==nil then
error("Moose: Could not load Moose file "..IncludeFile)
else
env.info("Moose: "..IncludeFile.." dynamically loaded.")
return f()
end
end
end
__Moose.Includes={}
__Moose.Include(MOOSE_DEVELOPMENT_FOLDER..'/Moose/Modules.lua')
BASE:TraceOnOff(true)
env.info('*** MOOSE INCLUDE END *** ')
do return end
end
else
env.info('*** MOOSE DYNAMIC INCLUDE NOT POSSIBLE (Desanitize io to use it) *** ')
end
env.info('*** MOOSE STATIC INCLUDE START *** ')
ENUMS={}
env.setErrorMessageBoxEnabled(false)
ENUMS.ROE={
WeaponFree=0,
OpenFireWeaponFree=1,
OpenFire=2,
ReturnFire=3,
WeaponHold=4,
}
ENUMS.ROT={
NoReaction=0,
PassiveDefense=1,
EvadeFire=2,
BypassAndEscape=3,
AllowAbortMission=4,
}
ENUMS.AlarmState={
Auto=0,
Green=1,
Red=2,
}
ENUMS.WeaponFlag={
LGB=2,
TvGB=4,
SNSGB=8,
HEBomb=16,
Penetrator=32,
NapalmBomb=64,
FAEBomb=128,
ClusterBomb=256,
Dispencer=512,
CandleBomb=1024,
ParachuteBomb=2147483648,
LightRocket=2048,
MarkerRocket=4096,
CandleRocket=8192,
HeavyRocket=16384,
AntiRadarMissile=32768,
AntiShipMissile=65536,
AntiTankMissile=131072,
FireAndForgetASM=262144,
LaserASM=524288,
TeleASM=1048576,
CruiseMissile=2097152,
AntiRadarMissile2=1073741824,
SRAM=4194304,
MRAAM=8388608,
LRAAM=16777216,
IR_AAM=33554432,
SAR_AAM=67108864,
AR_AAM=134217728,
GunPod=268435456,
BuiltInCannon=536870912,
GuidedBomb=14,
AnyUnguidedBomb=2147485680,
AnyBomb=2147485694,
AnyRocket=30720,
GuidedASM=1572864,
TacticalASM=1835008,
AnyASM=4161536,
AnyASM2=1077903360,
AnyAAM=264241152,
AnyAutonomousMissile=36012032,
AnyMissile=268402688,
Cannons=805306368,
Torpedo=4294967296,
Auto=3221225470,
AutoDCS=1073741822,
AnyAG=2956984318,
AnyAA=264241152,
AnyUnguided=2952822768,
AnyGuided=268402702,
}
ENUMS.WeaponType={}
ENUMS.WeaponType.Bomb={
LGB=2,
TvGB=4,
SNSGB=8,
HEBomb=16,
Penetrator=32,
NapalmBomb=64,
FAEBomb=128,
ClusterBomb=256,
Dispencer=512,
CandleBomb=1024,
ParachuteBomb=2147483648,
GuidedBomb=14,
AnyUnguidedBomb=2147485680,
AnyBomb=2147485694,
}
ENUMS.WeaponType.Rocket={
LightRocket=2048,
MarkerRocket=4096,
CandleRocket=8192,
HeavyRocket=16384,
AnyRocket=30720,
}
ENUMS.WeaponType.Gun={
GunPod=268435456,
BuiltInCannon=536870912,
Cannons=805306368,
}
ENUMS.WeaponType.Missile={
AntiRadarMissile=32768,
AntiShipMissile=65536,
AntiTankMissile=131072,
FireAndForgetASM=262144,
LaserASM=524288,
TeleASM=1048576,
CruiseMissile=2097152,
AntiRadarMissile2=1073741824,
GuidedASM=1572864,
TacticalASM=1835008,
AnyASM=4161536,
AnyASM2=1077903360,
AnyAutonomousMissile=36012032,
AnyMissile=268402688,
}
ENUMS.WeaponType.AAM={
SRAM=4194304,
MRAAM=8388608,
LRAAM=16777216,
IR_AAM=33554432,
SAR_AAM=67108864,
AR_AAM=134217728,
AnyAAM=264241152,
}
ENUMS.WeaponType.Torpedo={
Torpedo=4294967296,
}
ENUMS.WeaponType.Any={
Weapon=3221225470,
AG=2956984318,
AA=264241152,
Unguided=2952822768,
Guided=268402702,
}
ENUMS.MissionTask={
NOTHING="Nothing",
AFAC="AFAC",
ANTISHIPSTRIKE="Antiship Strike",
AWACS="AWACS",
CAP="CAP",
CAS="CAS",
ESCORT="Escort",
GROUNDESCORT="Ground escort",
FIGHTERSWEEP="Fighter Sweep",
GROUNDATTACK="Ground Attack",
INTERCEPT="Intercept",
PINPOINTSTRIKE="Pinpoint Strike",
RECONNAISSANCE="Reconnaissance",
REFUELING="Refueling",
RUNWAYATTACK="Runway Attack",
SEAD="SEAD",
TRANSPORT="Transport",
}
ENUMS.Formation={}
ENUMS.Formation.FixedWing={}
ENUMS.Formation.FixedWing.LineAbreast={}
ENUMS.Formation.FixedWing.LineAbreast.Close=65537
ENUMS.Formation.FixedWing.LineAbreast.Open=65538
ENUMS.Formation.FixedWing.LineAbreast.Group=65539
ENUMS.Formation.FixedWing.Trail={}
ENUMS.Formation.FixedWing.Trail.Close=131073
ENUMS.Formation.FixedWing.Trail.Open=131074
ENUMS.Formation.FixedWing.Trail.Group=131075
ENUMS.Formation.FixedWing.Wedge={}
ENUMS.Formation.FixedWing.Wedge.Close=196609
ENUMS.Formation.FixedWing.Wedge.Open=196610
ENUMS.Formation.FixedWing.Wedge.Group=196611
ENUMS.Formation.FixedWing.EchelonRight={}
ENUMS.Formation.FixedWing.EchelonRight.Close=262145
ENUMS.Formation.FixedWing.EchelonRight.Open=262146
ENUMS.Formation.FixedWing.EchelonRight.Group=262147
ENUMS.Formation.FixedWing.EchelonLeft={}
ENUMS.Formation.FixedWing.EchelonLeft.Close=327681
ENUMS.Formation.FixedWing.EchelonLeft.Open=327682
ENUMS.Formation.FixedWing.EchelonLeft.Group=327683
ENUMS.Formation.FixedWing.FingerFour={}
ENUMS.Formation.FixedWing.FingerFour.Close=393217
ENUMS.Formation.FixedWing.FingerFour.Open=393218
ENUMS.Formation.FixedWing.FingerFour.Group=393219
ENUMS.Formation.FixedWing.Spread={}
ENUMS.Formation.FixedWing.Spread.Close=458753
ENUMS.Formation.FixedWing.Spread.Open=458754
ENUMS.Formation.FixedWing.Spread.Group=458755
ENUMS.Formation.FixedWing.BomberElement={}
ENUMS.Formation.FixedWing.BomberElement.Close=786433
ENUMS.Formation.FixedWing.BomberElement.Open=786434
ENUMS.Formation.FixedWing.BomberElement.Group=786435
ENUMS.Formation.FixedWing.BomberElementHeight={}
ENUMS.Formation.FixedWing.BomberElementHeight.Close=851968
ENUMS.Formation.FixedWing.FighterVic={}
ENUMS.Formation.FixedWing.FighterVic.Close=917505
ENUMS.Formation.FixedWing.FighterVic.Open=917506
ENUMS.Formation.RotaryWing={}
ENUMS.Formation.RotaryWing.Column={}
ENUMS.Formation.RotaryWing.Column.D70=720896
ENUMS.Formation.RotaryWing.Wedge={}
ENUMS.Formation.RotaryWing.Wedge.D70=8
ENUMS.Formation.RotaryWing.FrontRight={}
ENUMS.Formation.RotaryWing.FrontRight.D300=655361
ENUMS.Formation.RotaryWing.FrontRight.D600=655362
ENUMS.Formation.RotaryWing.FrontLeft={}
ENUMS.Formation.RotaryWing.FrontLeft.D300=655617
ENUMS.Formation.RotaryWing.FrontLeft.D600=655618
ENUMS.Formation.RotaryWing.EchelonRight={}
ENUMS.Formation.RotaryWing.EchelonRight.D70=589825
ENUMS.Formation.RotaryWing.EchelonRight.D300=589826
ENUMS.Formation.RotaryWing.EchelonRight.D600=589827
ENUMS.Formation.RotaryWing.EchelonLeft={}
ENUMS.Formation.RotaryWing.EchelonLeft.D70=590081
ENUMS.Formation.RotaryWing.EchelonLeft.D300=590082
ENUMS.Formation.RotaryWing.EchelonLeft.D600=590083
ENUMS.Formation.Vehicle={}
ENUMS.Formation.Vehicle.Vee="Vee"
ENUMS.Formation.Vehicle.EchelonRight="EchelonR"
ENUMS.Formation.Vehicle.OffRoad="Off Road"
ENUMS.Formation.Vehicle.Rank="Rank"
ENUMS.Formation.Vehicle.EchelonLeft="EchelonL"
ENUMS.Formation.Vehicle.OnRoad="On Road"
ENUMS.Formation.Vehicle.Cone="Cone"
ENUMS.Formation.Vehicle.Diamond="Diamond"
ENUMS.FormationOld={}
ENUMS.FormationOld.FixedWing={}
ENUMS.FormationOld.FixedWing.LineAbreast=1
ENUMS.FormationOld.FixedWing.Trail=2
ENUMS.FormationOld.FixedWing.Wedge=3
ENUMS.FormationOld.FixedWing.EchelonRight=4
ENUMS.FormationOld.FixedWing.EchelonLeft=5
ENUMS.FormationOld.FixedWing.FingerFour=6
ENUMS.FormationOld.FixedWing.SpreadFour=7
ENUMS.FormationOld.FixedWing.BomberElement=12
ENUMS.FormationOld.FixedWing.BomberElementHeight=13
ENUMS.FormationOld.FixedWing.FighterVic=14
ENUMS.FormationOld.RotaryWing={}
ENUMS.FormationOld.RotaryWing.Wedge=8
ENUMS.FormationOld.RotaryWing.Echelon=9
ENUMS.FormationOld.RotaryWing.Front=10
ENUMS.FormationOld.RotaryWing.Column=11
ENUMS.Morse={}
ENUMS.Morse.A="* -"
ENUMS.Morse.B="- * * *"
ENUMS.Morse.C="- * - *"
ENUMS.Morse.D="- * *"
ENUMS.Morse.E="*"
ENUMS.Morse.F="* * - *"
ENUMS.Morse.G="- - *"
ENUMS.Morse.H="* * * *"
ENUMS.Morse.I="* *"
ENUMS.Morse.J="* - - -"
ENUMS.Morse.K="- * -"
ENUMS.Morse.L="* - * *"
ENUMS.Morse.M="- -"
ENUMS.Morse.N="- *"
ENUMS.Morse.O="- - -"
ENUMS.Morse.P="* - - *"
ENUMS.Morse.Q="- - * -"
ENUMS.Morse.R="* - *"
ENUMS.Morse.S="* * *"
ENUMS.Morse.T="-"
ENUMS.Morse.U="* * -"
ENUMS.Morse.V="* * * -"
ENUMS.Morse.W="* - -"
ENUMS.Morse.X="- * * -"
ENUMS.Morse.Y="- * - -"
ENUMS.Morse.Z="- - * *"
ENUMS.Morse.N1="* - - - -"
ENUMS.Morse.N2="* * - - -"
ENUMS.Morse.N3="* * * - -"
ENUMS.Morse.N4="* * * * -"
ENUMS.Morse.N5="* * * * *"
ENUMS.Morse.N6="- * * * *"
ENUMS.Morse.N7="- - * * *"
ENUMS.Morse.N8="- - - * *"
ENUMS.Morse.N9="- - - - *"
ENUMS.Morse.N0="- - - - -"
ENUMS.Morse[" "]=" "
ENUMS.ISOLang=
{
Arabic='AR',
Chinese='ZH',
English='EN',
French='FR',
German='DE',
Russian='RU',
Spanish='ES',
Japanese='JA',
Italian='IT',
}
ENUMS.Phonetic=
{
A='Alpha',
B='Bravo',
C='Charlie',
D='Delta',
E='Echo',
F='Foxtrot',
G='Golf',
H='Hotel',
I='India',
J='Juliett',
K='Kilo',
L='Lima',
M='Mike',
N='November',
O='Oscar',
P='Papa',
Q='Quebec',
R='Romeo',
S='Sierra',
T='Tango',
U='Uniform',
V='Victor',
W='Whiskey',
X='Xray',
Y='Yankee',
Z='Zulu',
}
ENUMS.ReportingName=
{
NATO={
Dragon="JF-17",
Fagot="MiG-15",
Farmer="MiG-19",
Felon="Su-57",
Fencer="Su-24",
Fishbed="MiG-21",
Fitter="Su-17",
Flogger="MiG-23",
Flogger_D="MiG-27",
Flagon="Su-15",
Foxbat="MiG-25",
Fulcrum="MiG-29",
Foxhound="MiG-31",
Flanker="Su-27",
Flanker_C="Su-30",
Flanker_E="Su-35",
Flanker_F="Su-37",
Flanker_L="J-11A",
Firebird="J-10",
Sea_Flanker="Su-33",
Fullback="Su-34",
Frogfoot="Su-25",
Tomcat="F-14",
Mirage="Mirage",
Codling="Yak-40",
Maya="L-39",
Warthog="A-10",
Skyhawk="A-4E",
Viggen="AJS37",
Harrier_B="AV8BNA",
Harrier="AV-8B",
Spirit="B-2",
Aviojet="C-101",
Nighthawk="F-117A",
Eagle="F-15C",
Mudhen="F-15E",
Viper="F-16",
Phantom="F-4E",
Tiger="F-5",
Sabre="F-86",
Hornet="A-18",
Hawk="Hawk",
Albatros="L-39",
Goshawk="T-45",
Starfighter="F-104",
Tornado="Tornado",
Atlas="A400",
Lancer="B1-B",
Stratofortress="B-52H",
Hercules="C-130",
Super_Hercules="Hercules",
Globemaster="C-17",
Greyhound="C-2A",
Galaxy="C-5",
Hawkeye="E-2D",
Sentry="E-3A",
Stratotanker="KC-135",
Gasstation="KC-135MPRS",
Extender="KC-10",
Orion="P-3C",
Viking="S-3B",
Osprey="V-22",
Badger="H6-J",
Bear_J="Tu-142",
Bear="Tu-95",
Blinder="Tu-22",
Blackjack="Tu-160",
Clank="An-30",
Curl="An-26",
Candid="IL-76",
Midas="IL-78",
Mainstay="A-50",
Mainring="KJ-2000",
Yak="Yak-52",
Helix="Ka-27",
Shark="Ka-50",
Hind="Mi-24",
Halo="Mi-26",
Hip="Mi-8",
Havoc="Mi-28",
Gazelle="SA342",
Huey="UH-1H",
Cobra="AH-1",
Apache="AH-64",
Chinook="CH-47",
Sea_Stallion="CH-53",
Kiowa="OH-58",
Seahawk="SH-60",
Blackhawk="UH-60",
Sea_King="S-61",
UCAV="WingLoong",
Reaper="MQ-9",
Predator="MQ-1A",
}
}
ENUMS.Link16Power={
none=0,
low=1,
medium=2,
high=3,
}
ENUMS.Storage={
weapons={
missiles={},
bombs={},
nurs={},
containers={},
droptanks={},
adapters={},
torpedoes={},
Gazelle={},
CH47={},
OH58={},
UH1H={},
AH64D={},
}
}
ENUMS.Storage.weapons.nurs.SNEB_TYPE253_F1B="weapons.nurs.SNEB_TYPE253_F1B"
ENUMS.Storage.weapons.missiles.P_24T="weapons.missiles.P_24T"
ENUMS.Storage.weapons.bombs.BLU_3B_OLD="weapons.bombs.BLU-3B_OLD"
ENUMS.Storage.weapons.missiles.AGM_154="weapons.missiles.AGM_154"
ENUMS.Storage.weapons.nurs.HYDRA_70_M151_M433="weapons.nurs.HYDRA_70_M151_M433"
ENUMS.Storage.weapons.bombs.SAM_Avenger_M1097_Skid_7090lb="weapons.bombs.SAM Avenger M1097 Skid [7090lb]"
ENUMS.Storage.weapons.bombs.British_GP_250LB_Bomb_Mk5="weapons.bombs.British_GP_250LB_Bomb_Mk5"
ENUMS.Storage.weapons.containers.OV10_SMOKE="weapons.containers.{OV10_SMOKE}"
ENUMS.Storage.weapons.bombs.BLU_4B_OLD="weapons.bombs.BLU-4B_OLD"
ENUMS.Storage.weapons.bombs.FAB_500M54="weapons.bombs.FAB-500M54"
ENUMS.Storage.weapons.bombs.GBU_38="weapons.bombs.GBU_38"
ENUMS.Storage.weapons.containers.F_15E_AXQ_14_DATALINK="weapons.containers.F-15E_AXQ-14_DATALINK"
ENUMS.Storage.weapons.bombs.BEER_BOMB="weapons.bombs.BEER_BOMB"
ENUMS.Storage.weapons.bombs.P_50T="weapons.bombs.P-50T"
ENUMS.Storage.weapons.nurs.C_8CM_GN="weapons.nurs.C_8CM_GN"
ENUMS.Storage.weapons.bombs.FAB_500SL="weapons.bombs.FAB-500SL"
ENUMS.Storage.weapons.bombs.KAB_1500Kr="weapons.bombs.KAB_1500Kr"
ENUMS.Storage.weapons.bombs.two50_2="weapons.bombs.250-2"
ENUMS.Storage.weapons.droptanks.Spitfire_tank_1="weapons.droptanks.Spitfire_tank_1"
ENUMS.Storage.weapons.missiles.AGM_65G="weapons.missiles.AGM_65G"
ENUMS.Storage.weapons.missiles.AGM_65A="weapons.missiles.AGM_65A"
ENUMS.Storage.weapons.containers.Hercules_JATO="weapons.containers.Hercules_JATO"
ENUMS.Storage.weapons.nurs.HYDRA_70_M259="weapons.nurs.HYDRA_70_M259"
ENUMS.Storage.weapons.missiles.AGM_84E="weapons.missiles.AGM_84E"
ENUMS.Storage.weapons.bombs.AN_M30A1="weapons.bombs.AN_M30A1"
ENUMS.Storage.weapons.nurs.C_25="weapons.nurs.C_25"
ENUMS.Storage.weapons.containers.AV8BNA_ALQ164="weapons.containers.AV8BNA_ALQ164"
ENUMS.Storage.weapons.containers.lav_25="weapons.containers.lav-25"
ENUMS.Storage.weapons.missiles.P_60="weapons.missiles.P_60"
ENUMS.Storage.weapons.bombs.FAB_1500="weapons.bombs.FAB_1500"
ENUMS.Storage.weapons.droptanks.FuelTank_350L="weapons.droptanks.FuelTank_350L"
ENUMS.Storage.weapons.bombs.AAA_Vulcan_M163_Skid_21577lb="weapons.bombs.AAA Vulcan M163 Skid [21577lb]"
ENUMS.Storage.weapons.missiles.Kormoran="weapons.missiles.Kormoran"
ENUMS.Storage.weapons.droptanks.HB_F14_EXT_DROPTANK_EMPTY="weapons.droptanks.HB_F14_EXT_DROPTANK_EMPTY"
ENUMS.Storage.weapons.droptanks.FuelTank_150L="weapons.droptanks.FuelTank_150L"
ENUMS.Storage.weapons.missiles.Rb_15F_for_A_I="weapons.missiles.Rb 15F (for A.I.)"
ENUMS.Storage.weapons.missiles.RB75T="weapons.missiles.RB75T"
ENUMS.Storage.weapons.missiles.Vikhr_M="weapons.missiles.Vikhr_M"
ENUMS.Storage.weapons.nurs.FFAR_M156_WP="weapons.nurs.FFAR M156 WP"
ENUMS.Storage.weapons.nurs.British_HE_60LBSAPNo2_3INCHNo1="weapons.nurs.British_HE_60LBSAPNo2_3INCHNo1"
ENUMS.Storage.weapons.missiles.DWS39_MJ2="weapons.missiles.DWS39_MJ2"
ENUMS.Storage.weapons.bombs.HEBOMBD="weapons.bombs.HEBOMBD"
ENUMS.Storage.weapons.missiles.CATM_9M="weapons.missiles.CATM_9M"
ENUMS.Storage.weapons.bombs.Mk_81="weapons.bombs.Mk_81"
ENUMS.Storage.weapons.droptanks.Drop_Tank_300_Liter="weapons.droptanks.Drop_Tank_300_Liter"
ENUMS.Storage.weapons.containers.HMMWV_M1025="weapons.containers.HMMWV_M1025"
ENUMS.Storage.weapons.bombs.SAM_CHAPARRAL_Air_21624lb="weapons.bombs.SAM CHAPARRAL Air [21624lb]"
ENUMS.Storage.weapons.missiles.AGM_154A="weapons.missiles.AGM_154A"
ENUMS.Storage.weapons.bombs.Mk_84AIR_TP="weapons.bombs.Mk_84AIR_TP"
ENUMS.Storage.weapons.bombs.GBU_31_V_3B="weapons.bombs.GBU_31_V_3B"
ENUMS.Storage.weapons.nurs.C_8CM_WH="weapons.nurs.C_8CM_WH"
ENUMS.Storage.weapons.missiles.Matra_Super_530D="weapons.missiles.Matra Super 530D"
ENUMS.Storage.weapons.nurs.ARF8M3TPSM="weapons.nurs.ARF8M3TPSM"
ENUMS.Storage.weapons.missiles.TGM_65H="weapons.missiles.TGM_65H"
ENUMS.Storage.weapons.nurs.M8rocket="weapons.nurs.M8rocket"
ENUMS.Storage.weapons.bombs.GBU_27="weapons.bombs.GBU_27"
ENUMS.Storage.weapons.missiles.AGR_20A="weapons.missiles.AGR_20A"
ENUMS.Storage.weapons.missiles.LS_6_250="weapons.missiles.LS-6-250"
ENUMS.Storage.weapons.droptanks.M2KC_RPL_522_EMPTY="weapons.droptanks.M2KC_RPL_522_EMPTY"
ENUMS.Storage.weapons.droptanks.M2KC_02_RPL541="weapons.droptanks.M2KC_02_RPL541"
ENUMS.Storage.weapons.missiles.AGM_45="weapons.missiles.AGM_45"
ENUMS.Storage.weapons.missiles.AGM_84A="weapons.missiles.AGM_84A"
ENUMS.Storage.weapons.bombs.APC_BTR_80_Air_23936lb="weapons.bombs.APC BTR-80 Air [23936lb]"
ENUMS.Storage.weapons.missiles.P_33E="weapons.missiles.P_33E"
ENUMS.Storage.weapons.missiles.Ataka_9M120="weapons.missiles.Ataka_9M120"
ENUMS.Storage.weapons.bombs.MK76="weapons.bombs.MK76"
ENUMS.Storage.weapons.bombs.AB_250_2_SD_2="weapons.bombs.AB_250_2_SD_2"
ENUMS.Storage.weapons.missiles.Rb_05A="weapons.missiles.Rb 05A"
ENUMS.Storage.weapons.bombs.ART_GVOZDIKA_34720lb="weapons.bombs.ART GVOZDIKA [34720lb]"
ENUMS.Storage.weapons.bombs.Generic_Crate_20000lb="weapons.bombs.Generic Crate [20000lb]"
ENUMS.Storage.weapons.bombs.FAB_100SV="weapons.bombs.FAB_100SV"
ENUMS.Storage.weapons.bombs.BetAB_500="weapons.bombs.BetAB_500"
ENUMS.Storage.weapons.droptanks.M2KC_02_RPL541_EMPTY="weapons.droptanks.M2KC_02_RPL541_EMPTY"
ENUMS.Storage.weapons.droptanks.PTB600_MIG15="weapons.droptanks.PTB600_MIG15"
ENUMS.Storage.weapons.missiles.Rb_24J="weapons.missiles.Rb 24J"
ENUMS.Storage.weapons.nurs.C_8CM_BU="weapons.nurs.C_8CM_BU"
ENUMS.Storage.weapons.nurs.SNEB_TYPE259E_F1B="weapons.nurs.SNEB_TYPE259E_F1B"
ENUMS.Storage.weapons.nurs.WGr21="weapons.nurs.WGr21"
ENUMS.Storage.weapons.bombs.SAMP250HD="weapons.bombs.SAMP250HD"
ENUMS.Storage.weapons.containers.alq_184long="weapons.containers.alq-184long"
ENUMS.Storage.weapons.nurs.SNEB_TYPE259E_H1="weapons.nurs.SNEB_TYPE259E_H1"
ENUMS.Storage.weapons.bombs.British_SAP_250LB_Bomb_Mk5="weapons.bombs.British_SAP_250LB_Bomb_Mk5"
ENUMS.Storage.weapons.bombs.Transport_UAZ_469_Air_3747lb="weapons.bombs.Transport UAZ-469 Air [3747lb]"
ENUMS.Storage.weapons.bombs.Mk_83CT="weapons.bombs.Mk_83CT"
ENUMS.Storage.weapons.missiles.AIM_7P="weapons.missiles.AIM-7P"
ENUMS.Storage.weapons.missiles.AT_6="weapons.missiles.AT_6"
ENUMS.Storage.weapons.nurs.SNEB_TYPE254_H1_GREEN="weapons.nurs.SNEB_TYPE254_H1_GREEN"
ENUMS.Storage.weapons.nurs.SNEB_TYPE250_F1B="weapons.nurs.SNEB_TYPE250_F1B"
ENUMS.Storage.weapons.containers.U22A="weapons.containers.U22A"
ENUMS.Storage.weapons.bombs.British_GP_250LB_Bomb_Mk1="weapons.bombs.British_GP_250LB_Bomb_Mk1"
ENUMS.Storage.weapons.bombs.CBU_105="weapons.bombs.CBU_105"
ENUMS.Storage.weapons.droptanks.FW_190_Fuel_Tank="weapons.droptanks.FW-190_Fuel-Tank"
ENUMS.Storage.weapons.missiles.X_58="weapons.missiles.X_58"
ENUMS.Storage.weapons.missiles.BK90_MJ1_MJ2="weapons.missiles.BK90_MJ1_MJ2"
ENUMS.Storage.weapons.missiles.TGM_65D="weapons.missiles.TGM_65D"
ENUMS.Storage.weapons.containers.BRD_4_250="weapons.containers.BRD-4-250"
ENUMS.Storage.weapons.missiles.P_73="weapons.missiles.P_73"
ENUMS.Storage.weapons.bombs.AN_M66="weapons.bombs.AN_M66"
ENUMS.Storage.weapons.bombs.APC_LAV_25_Air_22520lb="weapons.bombs.APC LAV-25 Air [22520lb]"
ENUMS.Storage.weapons.missiles.AIM_7MH="weapons.missiles.AIM-7MH"
ENUMS.Storage.weapons.containers.MB339_TravelPod="weapons.containers.MB339_TravelPod"
ENUMS.Storage.weapons.bombs.GBU_12="weapons.bombs.GBU_12"
ENUMS.Storage.weapons.bombs.SC_250_T3_J="weapons.bombs.SC_250_T3_J"
ENUMS.Storage.weapons.missiles.KD_20="weapons.missiles.KD-20"
ENUMS.Storage.weapons.missiles.AGM_86C="weapons.missiles.AGM_86C"
ENUMS.Storage.weapons.missiles.X_35="weapons.missiles.X_35"
ENUMS.Storage.weapons.bombs.MK106="weapons.bombs.MK106"
ENUMS.Storage.weapons.bombs.BETAB_500S="weapons.bombs.BETAB-500S"
ENUMS.Storage.weapons.nurs.C_5="weapons.nurs.C_5"
ENUMS.Storage.weapons.nurs.S_24B="weapons.nurs.S-24B"
ENUMS.Storage.weapons.bombs.British_MC_500LB_Bomb_Mk2="weapons.bombs.British_MC_500LB_Bomb_Mk2"
ENUMS.Storage.weapons.containers.ANAWW_13="weapons.containers.ANAWW_13"
ENUMS.Storage.weapons.droptanks.droptank_108_gal="weapons.droptanks.droptank_108_gal"
ENUMS.Storage.weapons.droptanks.DFT_300_GAL_A4E_LR="weapons.droptanks.DFT_300_GAL_A4E_LR"
ENUMS.Storage.weapons.bombs.CBU_87="weapons.bombs.CBU_87"
ENUMS.Storage.weapons.missiles.GAR_8="weapons.missiles.GAR-8"
ENUMS.Storage.weapons.bombs.BELOUGA="weapons.bombs.BELOUGA"
ENUMS.Storage.weapons.containers.EclairM_33="weapons.containers.{EclairM_33}"
ENUMS.Storage.weapons.bombs.ART_2S9_NONA_Air_19140lb="weapons.bombs.ART 2S9 NONA Air [19140lb]"
ENUMS.Storage.weapons.bombs.BR_250="weapons.bombs.BR_250"
ENUMS.Storage.weapons.bombs.IAB_500="weapons.bombs.IAB-500"
ENUMS.Storage.weapons.containers.AN_ASQ_228="weapons.containers.AN_ASQ_228"
ENUMS.Storage.weapons.missiles.P_27P="weapons.missiles.P_27P"
ENUMS.Storage.weapons.bombs.SD_250_Stg="weapons.bombs.SD_250_Stg"
ENUMS.Storage.weapons.missiles.R_530F_IR="weapons.missiles.R_530F_IR"
ENUMS.Storage.weapons.bombs.British_SAP_500LB_Bomb_Mk5="weapons.bombs.British_SAP_500LB_Bomb_Mk5"
ENUMS.Storage.weapons.bombs.FAB_250M54="weapons.bombs.FAB-250M54"
ENUMS.Storage.weapons.containers.M2KC_AAF="weapons.containers.{M2KC_AAF}"
ENUMS.Storage.weapons.missiles.CM_802AKG_AI="weapons.missiles.CM-802AKG_AI"
ENUMS.Storage.weapons.bombs.CBU_103="weapons.bombs.CBU_103"
ENUMS.Storage.weapons.containers.US_M10_SMOKE_TANK_RED="weapons.containers.{US_M10_SMOKE_TANK_RED}"
ENUMS.Storage.weapons.missiles.X_29T="weapons.missiles.X_29T"
ENUMS.Storage.weapons.bombs.HEMTT_TFFT_34400lb="weapons.bombs.HEMTT TFFT [34400lb]"
ENUMS.Storage.weapons.missiles.C_701IR="weapons.missiles.C-701IR"
ENUMS.Storage.weapons.containers.fullCargoSeats="weapons.containers.fullCargoSeats"
ENUMS.Storage.weapons.bombs.GBU_15_V_31_B="weapons.bombs.GBU_15_V_31_B"
ENUMS.Storage.weapons.bombs.APC_M1043_HMMWV_Armament_Air_7023lb="weapons.bombs.APC M1043 HMMWV Armament Air [7023lb]"
ENUMS.Storage.weapons.missiles.PL_5EII="weapons.missiles.PL-5EII"
ENUMS.Storage.weapons.bombs.SC_250_T1_L2="weapons.bombs.SC_250_T1_L2"
ENUMS.Storage.weapons.torpedoes.mk46torp_name="weapons.torpedoes.mk46torp_name"
ENUMS.Storage.weapons.containers.F_15E_AAQ_33_XR_ATP_SE="weapons.containers.F-15E_AAQ-33_XR_ATP-SE"
ENUMS.Storage.weapons.missiles.AIM_7="weapons.missiles.AIM_7"
ENUMS.Storage.weapons.missiles.AGM_122="weapons.missiles.AGM_122"
ENUMS.Storage.weapons.bombs.HEBOMB="weapons.bombs.HEBOMB"
ENUMS.Storage.weapons.bombs.CBU_97="weapons.bombs.CBU_97"
ENUMS.Storage.weapons.bombs.MK_81SE="weapons.bombs.MK-81SE"
ENUMS.Storage.weapons.nurs.Zuni_127="weapons.nurs.Zuni_127"
ENUMS.Storage.weapons.containers.M2KC_AGF="weapons.containers.{M2KC_AGF}"
ENUMS.Storage.weapons.droptanks.Hercules_ExtFuelTank="weapons.droptanks.Hercules_ExtFuelTank"
ENUMS.Storage.weapons.containers.SMOKE_WHITE="weapons.containers.{SMOKE_WHITE}"
ENUMS.Storage.weapons.droptanks.droptank_150_gal="weapons.droptanks.droptank_150_gal"
ENUMS.Storage.weapons.nurs.HYDRA_70_WTU1B="weapons.nurs.HYDRA_70_WTU1B"
ENUMS.Storage.weapons.missiles.GB_6_SFW="weapons.missiles.GB-6-SFW"
ENUMS.Storage.weapons.missiles.KD_63="weapons.missiles.KD-63"
ENUMS.Storage.weapons.bombs.GBU_28="weapons.bombs.GBU_28"
ENUMS.Storage.weapons.nurs.C_8CM_YE="weapons.nurs.C_8CM_YE"
ENUMS.Storage.weapons.droptanks.HB_F14_EXT_DROPTANK="weapons.droptanks.HB_F14_EXT_DROPTANK"
ENUMS.Storage.weapons.missiles.Super_530F="weapons.missiles.Super_530F"
ENUMS.Storage.weapons.missiles.Ataka_9M220="weapons.missiles.Ataka_9M220"
ENUMS.Storage.weapons.bombs.BDU_33="weapons.bombs.BDU_33"
ENUMS.Storage.weapons.bombs.British_GP_250LB_Bomb_Mk4="weapons.bombs.British_GP_250LB_Bomb_Mk4"
ENUMS.Storage.weapons.missiles.TOW="weapons.missiles.TOW"
ENUMS.Storage.weapons.bombs.ATGM_M1045_HMMWV_TOW_Air_7183lb="weapons.bombs.ATGM M1045 HMMWV TOW Air [7183lb]"
ENUMS.Storage.weapons.missiles.X_25MR="weapons.missiles.X_25MR"
ENUMS.Storage.weapons.droptanks.fueltank230="weapons.droptanks.fueltank230"
ENUMS.Storage.weapons.droptanks.PTB_490C_MIG21="weapons.droptanks.PTB-490C-MIG21"
ENUMS.Storage.weapons.bombs.M1025_HMMWV_Air_6160lb="weapons.bombs.M1025 HMMWV Air [6160lb]"
ENUMS.Storage.weapons.nurs.SNEB_TYPE254_F1B_GREEN="weapons.nurs.SNEB_TYPE254_F1B_GREEN"
ENUMS.Storage.weapons.missiles.R_550="weapons.missiles.R_550"
ENUMS.Storage.weapons.bombs.KAB_1500LG="weapons.bombs.KAB_1500LG"
ENUMS.Storage.weapons.missiles.AGM_84D="weapons.missiles.AGM_84D"
ENUMS.Storage.weapons.missiles.YJ_83K="weapons.missiles.YJ-83K"
ENUMS.Storage.weapons.missiles.AIM_54C_Mk47="weapons.missiles.AIM_54C_Mk47"
ENUMS.Storage.weapons.missiles.BRM_1_90MM="weapons.missiles.BRM-1_90MM"
ENUMS.Storage.weapons.missiles.Ataka_9M120F="weapons.missiles.Ataka_9M120F"
ENUMS.Storage.weapons.droptanks.Eleven00L_Tank="weapons.droptanks.1100L Tank"
ENUMS.Storage.weapons.bombs.BAP_100="weapons.bombs.BAP_100"
ENUMS.Storage.weapons.adapters.lau_88="weapons.adapters.lau-88"
ENUMS.Storage.weapons.missiles.P_40T="weapons.missiles.P_40T"
ENUMS.Storage.weapons.missiles.GB_6="weapons.missiles.GB-6"
ENUMS.Storage.weapons.bombs.FAB_250M54TU="weapons.bombs.FAB-250M54TU"
ENUMS.Storage.weapons.missiles.DWS39_MJ1="weapons.missiles.DWS39_MJ1"
ENUMS.Storage.weapons.missiles.CM_802AKG="weapons.missiles.CM-802AKG"
ENUMS.Storage.weapons.bombs.FAB_250="weapons.bombs.FAB_250"
ENUMS.Storage.weapons.missiles.C_802AK="weapons.missiles.C_802AK"
ENUMS.Storage.weapons.bombs.SD_500_A="weapons.bombs.SD_500_A"
ENUMS.Storage.weapons.bombs.GBU_32_V_2B="weapons.bombs.GBU_32_V_2B"
ENUMS.Storage.weapons.containers.marder="weapons.containers.marder"
ENUMS.Storage.weapons.missiles.ADM_141B="weapons.missiles.ADM_141B"
ENUMS.Storage.weapons.bombs.ROCKEYE="weapons.bombs.ROCKEYE"
ENUMS.Storage.weapons.missiles.BK90_MJ1="weapons.missiles.BK90_MJ1"
ENUMS.Storage.weapons.containers.BTR_80="weapons.containers.BTR-80"
ENUMS.Storage.weapons.bombs.SAM_ROLAND_ADS_34720lb="weapons.bombs.SAM ROLAND ADS [34720lb]"
ENUMS.Storage.weapons.containers.wmd7="weapons.containers.wmd7"
ENUMS.Storage.weapons.missiles.C_701T="weapons.missiles.C-701T"
ENUMS.Storage.weapons.missiles.AIM_7E_2="weapons.missiles.AIM-7E-2"
ENUMS.Storage.weapons.nurs.HVAR="weapons.nurs.HVAR"
ENUMS.Storage.weapons.containers.HMMWV_M1043="weapons.containers.HMMWV_M1043"
ENUMS.Storage.weapons.droptanks.PTB_800_MIG21="weapons.droptanks.PTB-800-MIG21"
ENUMS.Storage.weapons.missiles.AGM_114="weapons.missiles.AGM_114"
ENUMS.Storage.weapons.bombs.APC_M1126_Stryker_ICV_29542lb="weapons.bombs.APC M1126 Stryker ICV [29542lb]"
ENUMS.Storage.weapons.bombs.APC_M113_Air_21624lb="weapons.bombs.APC M113 Air [21624lb]"
ENUMS.Storage.weapons.bombs.M_117="weapons.bombs.M_117"
ENUMS.Storage.weapons.missiles.AGM_65D="weapons.missiles.AGM_65D"
ENUMS.Storage.weapons.droptanks.MB339_TT320_L="weapons.droptanks.MB339_TT320_L"
ENUMS.Storage.weapons.missiles.AGM_86="weapons.missiles.AGM_86"
ENUMS.Storage.weapons.bombs.BDU_45LGB="weapons.bombs.BDU_45LGB"
ENUMS.Storage.weapons.missiles.AGM_65H="weapons.missiles.AGM_65H"
ENUMS.Storage.weapons.nurs.RS_82="weapons.nurs.RS-82"
ENUMS.Storage.weapons.nurs.SNEB_TYPE252_F1B="weapons.nurs.SNEB_TYPE252_F1B"
ENUMS.Storage.weapons.bombs.BL_755="weapons.bombs.BL_755"
ENUMS.Storage.weapons.containers.F_15E_AAQ_28_LITENING="weapons.containers.F-15E_AAQ-28_LITENING"
ENUMS.Storage.weapons.nurs.SNEB_TYPE256_F1B="weapons.nurs.SNEB_TYPE256_F1B"
ENUMS.Storage.weapons.missiles.AGM_84H="weapons.missiles.AGM_84H"
ENUMS.Storage.weapons.missiles.AIM_54="weapons.missiles.AIM_54"
ENUMS.Storage.weapons.missiles.X_31A="weapons.missiles.X_31A"
ENUMS.Storage.weapons.bombs.KAB_500Kr="weapons.bombs.KAB_500Kr"
ENUMS.Storage.weapons.containers.SPS_141_100="weapons.containers.SPS-141-100"
ENUMS.Storage.weapons.missiles.BK90_MJ2="weapons.missiles.BK90_MJ2"
ENUMS.Storage.weapons.missiles.Super_530D="weapons.missiles.Super_530D"
ENUMS.Storage.weapons.bombs.CBU_52B="weapons.bombs.CBU_52B"
ENUMS.Storage.weapons.droptanks.PTB_450="weapons.droptanks.PTB-450"
ENUMS.Storage.weapons.bombs.IFV_MCV_80_34720lb="weapons.bombs.IFV MCV-80 [34720lb]"
ENUMS.Storage.weapons.containers.Two_c9="weapons.containers.2-c9"
ENUMS.Storage.weapons.missiles.AIM_9JULI="weapons.missiles.AIM-9JULI"
ENUMS.Storage.weapons.droptanks.MB339_TT500_R="weapons.droptanks.MB339_TT500_R"
ENUMS.Storage.weapons.nurs.C_8CM="weapons.nurs.C_8CM"
ENUMS.Storage.weapons.containers.BARAX="weapons.containers.BARAX"
ENUMS.Storage.weapons.missiles.P_40R="weapons.missiles.P_40R"
ENUMS.Storage.weapons.missiles.YJ_12="weapons.missiles.YJ-12"
ENUMS.Storage.weapons.missiles.CM_802AKG="weapons.missiles.CM_802AKG"
ENUMS.Storage.weapons.nurs.SNEB_TYPE254_H1_YELLOW="weapons.nurs.SNEB_TYPE254_H1_YELLOW"
ENUMS.Storage.weapons.bombs.Durandal="weapons.bombs.Durandal"
ENUMS.Storage.weapons.droptanks.i16_eft="weapons.droptanks.i16_eft"
ENUMS.Storage.weapons.droptanks.AV8BNA_AERO1D_EMPTY="weapons.droptanks.AV8BNA_AERO1D_EMPTY"
ENUMS.Storage.weapons.containers.Hercules_Battle_Station_TGP="weapons.containers.Hercules_Battle_Station_TGP"
ENUMS.Storage.weapons.nurs.C_8CM_VT="weapons.nurs.C_8CM_VT"
ENUMS.Storage.weapons.missiles.PL_12="weapons.missiles.PL-12"
ENUMS.Storage.weapons.missiles.R_3R="weapons.missiles.R-3R"
ENUMS.Storage.weapons.bombs.GBU_54_V_1B="weapons.bombs.GBU_54_V_1B"
ENUMS.Storage.weapons.droptanks.MB339_TT320_R="weapons.droptanks.MB339_TT320_R"
ENUMS.Storage.weapons.bombs.RN_24="weapons.bombs.RN-24"
ENUMS.Storage.weapons.containers.Twoc6m="weapons.containers.2c6m"
ENUMS.Storage.weapons.bombs.ARV_BRDM_2_Air_12320lb="weapons.bombs.ARV BRDM-2 Air [12320lb]"
ENUMS.Storage.weapons.bombs.ARV_BRDM_2_Skid_12210lb="weapons.bombs.ARV BRDM-2 Skid [12210lb]"
ENUMS.Storage.weapons.nurs.SNEB_TYPE251_F1B="weapons.nurs.SNEB_TYPE251_F1B"
ENUMS.Storage.weapons.missiles.X_41="weapons.missiles.X_41"
ENUMS.Storage.weapons.containers.MIG21_SMOKE_WHITE="weapons.containers.{MIG21_SMOKE_WHITE}"
ENUMS.Storage.weapons.bombs.MK_82AIR="weapons.bombs.MK_82AIR"
ENUMS.Storage.weapons.missiles.R_530F_EM="weapons.missiles.R_530F_EM"
ENUMS.Storage.weapons.bombs.SAMP400LD="weapons.bombs.SAMP400LD"
ENUMS.Storage.weapons.bombs.FAB_50="weapons.bombs.FAB_50"
ENUMS.Storage.weapons.bombs.AB_250_2_SD_10A="weapons.bombs.AB_250_2_SD_10A"
ENUMS.Storage.weapons.missiles.ADM_141A="weapons.missiles.ADM_141A"
ENUMS.Storage.weapons.containers.KBpod="weapons.containers.KBpod"
ENUMS.Storage.weapons.bombs.British_GP_500LB_Bomb_Mk4="weapons.bombs.British_GP_500LB_Bomb_Mk4"
ENUMS.Storage.weapons.missiles.AGM_65E="weapons.missiles.AGM_65E"
ENUMS.Storage.weapons.containers.sa342_dipole_antenna="weapons.containers.sa342_dipole_antenna"
ENUMS.Storage.weapons.bombs.OFAB_100_Jupiter="weapons.bombs.OFAB-100 Jupiter"
ENUMS.Storage.weapons.nurs.SNEB_TYPE257_F1B="weapons.nurs.SNEB_TYPE257_F1B"
ENUMS.Storage.weapons.missiles.Rb_04E_for_A_I="weapons.missiles.Rb 04E (for A.I.)"
ENUMS.Storage.weapons.bombs.AN_M66A2="weapons.bombs.AN-M66A2"
ENUMS.Storage.weapons.missiles.P_27T="weapons.missiles.P_27T"
ENUMS.Storage.weapons.droptanks.LNS_VIG_XTANK="weapons.droptanks.LNS_VIG_XTANK"
ENUMS.Storage.weapons.missiles.R_55="weapons.missiles.R-55"
ENUMS.Storage.weapons.torpedoes.YU_6="weapons.torpedoes.YU-6"
ENUMS.Storage.weapons.bombs.British_MC_250LB_Bomb_Mk2="weapons.bombs.British_MC_250LB_Bomb_Mk2"
ENUMS.Storage.weapons.droptanks.PTB_120_F86F35="weapons.droptanks.PTB_120_F86F35"
ENUMS.Storage.weapons.missiles.PL_8B="weapons.missiles.PL-8B"
ENUMS.Storage.weapons.droptanks.F_15E_Drop_Tank_Empty="weapons.droptanks.F-15E_Drop_Tank_Empty"
ENUMS.Storage.weapons.nurs.British_HE_60LBFNo1_3INCHNo1="weapons.nurs.British_HE_60LBFNo1_3INCHNo1"
ENUMS.Storage.weapons.missiles.P_77="weapons.missiles.P_77"
ENUMS.Storage.weapons.torpedoes.LTF_5B="weapons.torpedoes.LTF_5B"
ENUMS.Storage.weapons.missiles.R_3S="weapons.missiles.R-3S"
ENUMS.Storage.weapons.nurs.SNEB_TYPE253_H1="weapons.nurs.SNEB_TYPE253_H1"
ENUMS.Storage.weapons.missiles.PL_8A="weapons.missiles.PL-8A"
ENUMS.Storage.weapons.bombs.APC_BTR_82A_Skid_24888lb="weapons.bombs.APC BTR-82A Skid [24888lb]"
ENUMS.Storage.weapons.containers.Sborka="weapons.containers.Sborka"
ENUMS.Storage.weapons.missiles.AGM_65L="weapons.missiles.AGM_65L"
ENUMS.Storage.weapons.missiles.X_28="weapons.missiles.X_28"
ENUMS.Storage.weapons.missiles.TGM_65G="weapons.missiles.TGM_65G"
ENUMS.Storage.weapons.nurs.SNEB_TYPE257_H1="weapons.nurs.SNEB_TYPE257_H1"
ENUMS.Storage.weapons.missiles.RB75B="weapons.missiles.RB75B"
ENUMS.Storage.weapons.missiles.X_25ML="weapons.missiles.X_25ML"
ENUMS.Storage.weapons.droptanks.FPU_8A="weapons.droptanks.FPU_8A"
ENUMS.Storage.weapons.bombs.BLG66="weapons.bombs.BLG66"
ENUMS.Storage.weapons.nurs.C_8CM_RD="weapons.nurs.C_8CM_RD"
ENUMS.Storage.weapons.containers.EclairM_06="weapons.containers.{EclairM_06}"
ENUMS.Storage.weapons.bombs.RBK_500AO="weapons.bombs.RBK_500AO"
ENUMS.Storage.weapons.missiles.AIM_9P="weapons.missiles.AIM-9P"
ENUMS.Storage.weapons.bombs.British_GP_500LB_Bomb_Mk4_Short="weapons.bombs.British_GP_500LB_Bomb_Mk4_Short"
ENUMS.Storage.weapons.containers.MB339_Vinten="weapons.containers.MB339_Vinten"
ENUMS.Storage.weapons.missiles.Rb_15F="weapons.missiles.Rb 15F"
ENUMS.Storage.weapons.nurs.ARAKM70BHE="weapons.nurs.ARAKM70BHE"
ENUMS.Storage.weapons.bombs.AAA_Vulcan_M163_Air_21666lb="weapons.bombs.AAA Vulcan M163 Air [21666lb]"
ENUMS.Storage.weapons.missiles.X_29L="weapons.missiles.X_29L"
ENUMS.Storage.weapons.containers.F14_LANTIRN_TP="weapons.containers.{F14-LANTIRN-TP}"
ENUMS.Storage.weapons.bombs.FAB_250_M62="weapons.bombs.FAB-250-M62"
ENUMS.Storage.weapons.missiles.AIM_120C="weapons.missiles.AIM_120C"
ENUMS.Storage.weapons.bombs.EWR_SBORKA_Air_21624lb="weapons.bombs.EWR SBORKA Air [21624lb]"
ENUMS.Storage.weapons.bombs.SAMP250LD="weapons.bombs.SAMP250LD"
ENUMS.Storage.weapons.droptanks.Spitfire_slipper_tank="weapons.droptanks.Spitfire_slipper_tank"
ENUMS.Storage.weapons.missiles.LS_6_500="weapons.missiles.LS-6-500"
ENUMS.Storage.weapons.bombs.GBU_31_V_4B="weapons.bombs.GBU_31_V_4B"
ENUMS.Storage.weapons.droptanks.PTB400_MIG15="weapons.droptanks.PTB400_MIG15"
ENUMS.Storage.weapons.containers.m_113="weapons.containers.m-113"
ENUMS.Storage.weapons.bombs.SPG_M1128_Stryker_MGS_33036lb="weapons.bombs.SPG M1128 Stryker MGS [33036lb]"
ENUMS.Storage.weapons.missiles.AIM_9L="weapons.missiles.AIM-9L"
ENUMS.Storage.weapons.missiles.AIM_9X="weapons.missiles.AIM_9X"
ENUMS.Storage.weapons.nurs.C_8="weapons.nurs.C_8"
ENUMS.Storage.weapons.bombs.SAM_CHAPARRAL_Skid_21516lb="weapons.bombs.SAM CHAPARRAL Skid [21516lb]"
ENUMS.Storage.weapons.missiles.P_27TE="weapons.missiles.P_27TE"
ENUMS.Storage.weapons.bombs.ODAB_500PM="weapons.bombs.ODAB-500PM"
ENUMS.Storage.weapons.bombs.MK77mod1_WPN="weapons.bombs.MK77mod1-WPN"
ENUMS.Storage.weapons.droptanks.PTB400_MIG19="weapons.droptanks.PTB400_MIG19"
ENUMS.Storage.weapons.torpedoes.Mark_46="weapons.torpedoes.Mark_46"
ENUMS.Storage.weapons.containers.rightSeat="weapons.containers.rightSeat"
ENUMS.Storage.weapons.containers.US_M10_SMOKE_TANK_ORANGE="weapons.containers.{US_M10_SMOKE_TANK_ORANGE}"
ENUMS.Storage.weapons.bombs.SAB_100MN="weapons.bombs.SAB_100MN"
ENUMS.Storage.weapons.nurs.FFAR_Mk5_HEAT="weapons.nurs.FFAR Mk5 HEAT"
ENUMS.Storage.weapons.bombs.IFV_TPZ_FUCH_33440lb="weapons.bombs.IFV TPZ FUCH [33440lb]"
ENUMS.Storage.weapons.bombs.IFV_M2A2_Bradley_34720lb="weapons.bombs.IFV M2A2 Bradley [34720lb]"
ENUMS.Storage.weapons.bombs.MK77mod0_WPN="weapons.bombs.MK77mod0-WPN"
ENUMS.Storage.weapons.containers.ASO_2="weapons.containers.ASO-2"
ENUMS.Storage.weapons.bombs.Mk_84AIR_GP="weapons.bombs.Mk_84AIR_GP"
ENUMS.Storage.weapons.nurs.S_24A="weapons.nurs.S-24A"
ENUMS.Storage.weapons.bombs.RBK_250_275_AO_1SCH="weapons.bombs.RBK_250_275_AO_1SCH"
ENUMS.Storage.weapons.bombs.Transport_Tigr_Skid_15730lb="weapons.bombs.Transport Tigr Skid [15730lb]"
ENUMS.Storage.weapons.missiles.AIM_7F="weapons.missiles.AIM-7F"
ENUMS.Storage.weapons.bombs.CBU_99="weapons.bombs.CBU_99"
ENUMS.Storage.weapons.bombs.LUU_2B="weapons.bombs.LUU_2B"
ENUMS.Storage.weapons.bombs.FAB_500TA="weapons.bombs.FAB-500TA"
ENUMS.Storage.weapons.missiles.AGR_20_M282="weapons.missiles.AGR_20_M282"
ENUMS.Storage.weapons.droptanks.MB339_FT330="weapons.droptanks.MB339_FT330"
ENUMS.Storage.weapons.bombs.SAMP125LD="weapons.bombs.SAMP125LD"
ENUMS.Storage.weapons.missiles.X_25MP="weapons.missiles.X_25MP"
ENUMS.Storage.weapons.nurs.SNEB_TYPE252_H1="weapons.nurs.SNEB_TYPE252_H1"
ENUMS.Storage.weapons.missiles.AGM_65F="weapons.missiles.AGM_65F"
ENUMS.Storage.weapons.missiles.AIM_9P5="weapons.missiles.AIM-9P5"
ENUMS.Storage.weapons.bombs.Transport_Tigr_Air_15900lb="weapons.bombs.Transport Tigr Air [15900lb]"
ENUMS.Storage.weapons.nurs.SNEB_TYPE254_H1_RED="weapons.nurs.SNEB_TYPE254_H1_RED"
ENUMS.Storage.weapons.nurs.FFAR_Mk1_HE="weapons.nurs.FFAR Mk1 HE"
ENUMS.Storage.weapons.nurs.SPRD_99="weapons.nurs.SPRD-99"
ENUMS.Storage.weapons.bombs.BIN_200="weapons.bombs.BIN_200"
ENUMS.Storage.weapons.bombs.BLU_4B_GROUP="weapons.bombs.BLU_4B_GROUP"
ENUMS.Storage.weapons.bombs.GBU_24="weapons.bombs.GBU_24"
ENUMS.Storage.weapons.missiles.Rb_04E="weapons.missiles.Rb 04E"
ENUMS.Storage.weapons.missiles.Rb_74="weapons.missiles.Rb 74"
ENUMS.Storage.weapons.containers.leftSeat="weapons.containers.leftSeat"
ENUMS.Storage.weapons.bombs.LS_6_100="weapons.bombs.LS-6-100"
ENUMS.Storage.weapons.bombs.Transport_URAL_375_14815lb="weapons.bombs.Transport URAL-375 [14815lb]"
ENUMS.Storage.weapons.containers.US_M10_SMOKE_TANK_GREEN="weapons.containers.{US_M10_SMOKE_TANK_GREEN}"
ENUMS.Storage.weapons.missiles.X_22="weapons.missiles.X_22"
ENUMS.Storage.weapons.containers.FAS="weapons.containers.FAS"
ENUMS.Storage.weapons.nurs.S_25_O="weapons.nurs.S-25-O"
ENUMS.Storage.weapons.droptanks.para="weapons.droptanks.para"
ENUMS.Storage.weapons.droptanks.F_15E_Drop_Tank="weapons.droptanks.F-15E_Drop_Tank"
ENUMS.Storage.weapons.droptanks.M2KC_08_RPL541_EMPTY="weapons.droptanks.M2KC_08_RPL541_EMPTY"
ENUMS.Storage.weapons.missiles.X_31P="weapons.missiles.X_31P"
ENUMS.Storage.weapons.bombs.RBK_500U="weapons.bombs.RBK_500U"
ENUMS.Storage.weapons.missiles.AIM_54A_Mk47="weapons.missiles.AIM_54A_Mk47"
ENUMS.Storage.weapons.droptanks.oiltank="weapons.droptanks.oiltank"
ENUMS.Storage.weapons.missiles.AGM_154B="weapons.missiles.AGM_154B"
ENUMS.Storage.weapons.containers.MB339_SMOKE_POD="weapons.containers.MB339_SMOKE-POD"
ENUMS.Storage.weapons.containers.ECM_POD_L_175V="weapons.containers.{ECM_POD_L_175V}"
ENUMS.Storage.weapons.droptanks.PTB_580G_F1="weapons.droptanks.PTB_580G_F1"
ENUMS.Storage.weapons.containers.EclairM_15="weapons.containers.{EclairM_15}"
ENUMS.Storage.weapons.containers.F_15E_AAQ_13_LANTIRN="weapons.containers.F-15E_AAQ-13_LANTIRN"
ENUMS.Storage.weapons.droptanks.Eight00L_Tank_Empty="weapons.droptanks.800L Tank Empty"
ENUMS.Storage.weapons.containers.One6c_hts_pod="weapons.containers.16c_hts_pod"
ENUMS.Storage.weapons.bombs.AN_M81="weapons.bombs.AN-M81"
ENUMS.Storage.weapons.droptanks.Mosquito_Drop_Tank_100gal="weapons.droptanks.Mosquito_Drop_Tank_100gal"
ENUMS.Storage.weapons.droptanks.Mosquito_Drop_Tank_50gal="weapons.droptanks.Mosquito_Drop_Tank_50gal"
ENUMS.Storage.weapons.droptanks.DFT_150_GAL_A4E="weapons.droptanks.DFT_150_GAL_A4E"
ENUMS.Storage.weapons.missiles.AIM_9="weapons.missiles.AIM_9"
ENUMS.Storage.weapons.bombs.IFV_BTR_D_Air_18040lb="weapons.bombs.IFV BTR-D Air [18040lb]"
ENUMS.Storage.weapons.containers.EclairM_42="weapons.containers.{EclairM_42}"
ENUMS.Storage.weapons.bombs.KAB_1500T="weapons.bombs.KAB_1500T"
ENUMS.Storage.weapons.droptanks.PTB_490_MIG21="weapons.droptanks.PTB-490-MIG21"
ENUMS.Storage.weapons.droptanks.PTB_200_F86F35="weapons.droptanks.PTB_200_F86F35"
ENUMS.Storage.weapons.droptanks.PTB760_MIG19="weapons.droptanks.PTB760_MIG19"
ENUMS.Storage.weapons.bombs.GBU_43_B_MOAB="weapons.bombs.GBU-43/B(MOAB)"
ENUMS.Storage.weapons.torpedoes.G7A_T1="weapons.torpedoes.G7A_T1"
ENUMS.Storage.weapons.bombs.IFV_BMD_1_Air_18040lb="weapons.bombs.IFV BMD-1 Air [18040lb]"
ENUMS.Storage.weapons.bombs.SAM_LINEBACKER_34720lb="weapons.bombs.SAM LINEBACKER [34720lb]"
ENUMS.Storage.weapons.containers.ais_pod_t50_r="weapons.containers.ais-pod-t50_r"
ENUMS.Storage.weapons.containers.CE2_SMOKE_WHITE="weapons.containers.{CE2_SMOKE_WHITE}"
ENUMS.Storage.weapons.droptanks.fuel_tank_230="weapons.droptanks.fuel_tank_230"
ENUMS.Storage.weapons.droptanks.M2KC_RPL_522="weapons.droptanks.M2KC_RPL_522"
ENUMS.Storage.weapons.missiles.AGM_130="weapons.missiles.AGM_130"
ENUMS.Storage.weapons.droptanks.Eight00L_Tank="weapons.droptanks.800L Tank"
ENUMS.Storage.weapons.bombs.IFV_BTR_D_Skid_17930lb="weapons.bombs.IFV BTR-D Skid [17930lb]"
ENUMS.Storage.weapons.containers.bmp_1="weapons.containers.bmp-1"
ENUMS.Storage.weapons.bombs.GBU_31="weapons.bombs.GBU_31"
ENUMS.Storage.weapons.containers.aaq_28LEFT_litening="weapons.containers.aaq-28LEFT litening"
ENUMS.Storage.weapons.missiles.Kh_66_Grom="weapons.missiles.Kh-66_Grom"
ENUMS.Storage.weapons.containers.MIG21_SMOKE_RED="weapons.containers.{MIG21_SMOKE_RED}"
ENUMS.Storage.weapons.containers.U22="weapons.containers.U22"
ENUMS.Storage.weapons.bombs.IFV_BMD_1_Skid_17930lb="weapons.bombs.IFV BMD-1 Skid [17930lb]"
ENUMS.Storage.weapons.droptanks.Bidon="weapons.droptanks.Bidon"
ENUMS.Storage.weapons.bombs.GBU_31_V_2B="weapons.bombs.GBU_31_V_2B"
ENUMS.Storage.weapons.bombs.Mk_82Y="weapons.bombs.Mk_82Y"
ENUMS.Storage.weapons.containers.pl5eii="weapons.containers.pl5eii"
ENUMS.Storage.weapons.bombs.RBK_500U_OAB_2_5RT="weapons.bombs.RBK_500U_OAB_2_5RT"
ENUMS.Storage.weapons.bombs.British_GP_500LB_Bomb_Mk5="weapons.bombs.British_GP_500LB_Bomb_Mk5"
ENUMS.Storage.weapons.containers.Eclair="weapons.containers.{Eclair}"
ENUMS.Storage.weapons.nurs.S5MO_HEFRAG_FFAR="weapons.nurs.S5MO_HEFRAG_FFAR"
ENUMS.Storage.weapons.bombs.BETAB_500M="weapons.bombs.BETAB-500M"
ENUMS.Storage.weapons.bombs.Transport_M818_16000lb="weapons.bombs.Transport M818 [16000lb]"
ENUMS.Storage.weapons.bombs.British_MC_250LB_Bomb_Mk1="weapons.bombs.British_MC_250LB_Bomb_Mk1"
ENUMS.Storage.weapons.nurs.SNEB_TYPE251_H1="weapons.nurs.SNEB_TYPE251_H1"
ENUMS.Storage.weapons.bombs.TYPE_200A="weapons.bombs.TYPE-200A"
ENUMS.Storage.weapons.nurs.HYDRA_70_M151="weapons.nurs.HYDRA_70_M151"
ENUMS.Storage.weapons.bombs.IFV_BMP_3_32912lb="weapons.bombs.IFV BMP-3 [32912lb]"
ENUMS.Storage.weapons.bombs.APC_MTLB_Air_26400lb="weapons.bombs.APC MTLB Air [26400lb]"
ENUMS.Storage.weapons.nurs.HYDRA_70_M229="weapons.nurs.HYDRA_70_M229"
ENUMS.Storage.weapons.bombs.BDU_45="weapons.bombs.BDU_45"
ENUMS.Storage.weapons.bombs.OFAB_100_120TU="weapons.bombs.OFAB-100-120TU"
ENUMS.Storage.weapons.missiles.AIM_9J="weapons.missiles.AIM-9J"
ENUMS.Storage.weapons.nurs.ARF8M3API="weapons.nurs.ARF8M3API"
ENUMS.Storage.weapons.bombs.BetAB_500ShP="weapons.bombs.BetAB_500ShP"
ENUMS.Storage.weapons.nurs.C_8OFP2="weapons.nurs.C_8OFP2"
ENUMS.Storage.weapons.bombs.GBU_10="weapons.bombs.GBU_10"
ENUMS.Storage.weapons.bombs.APC_MTLB_Skid_26290lb="weapons.bombs.APC MTLB Skid [26290lb]"
ENUMS.Storage.weapons.nurs.SNEB_TYPE254_F1B_RED="weapons.nurs.SNEB_TYPE254_F1B_RED"
ENUMS.Storage.weapons.missiles.X_65="weapons.missiles.X_65"
ENUMS.Storage.weapons.missiles.R_550_M1="weapons.missiles.R_550_M1"
ENUMS.Storage.weapons.missiles.AGM_65K="weapons.missiles.AGM_65K"
ENUMS.Storage.weapons.nurs.SNEB_TYPE254_F1B_YELLOW="weapons.nurs.SNEB_TYPE254_F1B_YELLOW"
ENUMS.Storage.weapons.missiles.AGM_88="weapons.missiles.AGM_88"
ENUMS.Storage.weapons.nurs.C_8OM="weapons.nurs.C_8OM"
ENUMS.Storage.weapons.bombs.SAM_ROLAND_LN_34720b="weapons.bombs.SAM ROLAND LN [34720b]"
ENUMS.Storage.weapons.missiles.AIM_120="weapons.missiles.AIM_120"
ENUMS.Storage.weapons.missiles.HOT3_MBDA="weapons.missiles.HOT3_MBDA"
ENUMS.Storage.weapons.missiles.R_13M="weapons.missiles.R-13M"
ENUMS.Storage.weapons.missiles.AIM_54C_Mk60="weapons.missiles.AIM_54C_Mk60"
ENUMS.Storage.weapons.bombs.AAA_GEPARD_34720lb="weapons.bombs.AAA GEPARD [34720lb]"
ENUMS.Storage.weapons.missiles.R_13M1="weapons.missiles.R-13M1"
ENUMS.Storage.weapons.bombs.APC_Cobra_Air_10912lb="weapons.bombs.APC Cobra Air [10912lb]"
ENUMS.Storage.weapons.bombs.RBK_250="weapons.bombs.RBK_250"
ENUMS.Storage.weapons.bombs.SC_500_J="weapons.bombs.SC_500_J"
ENUMS.Storage.weapons.missiles.AGM_114K="weapons.missiles.AGM_114K"
ENUMS.Storage.weapons.missiles.ALARM="weapons.missiles.ALARM"
ENUMS.Storage.weapons.bombs.Mk_83="weapons.bombs.Mk_83"
ENUMS.Storage.weapons.missiles.AGM_65B="weapons.missiles.AGM_65B"
ENUMS.Storage.weapons.bombs.MK_82SNAKEYE="weapons.bombs.MK_82SNAKEYE"
ENUMS.Storage.weapons.nurs.HYDRA_70_MK1="weapons.nurs.HYDRA_70_MK1"
ENUMS.Storage.weapons.bombs.BLG66_BELOUGA="weapons.bombs.BLG66_BELOUGA"
ENUMS.Storage.weapons.containers.EclairM_51="weapons.containers.{EclairM_51}"
ENUMS.Storage.weapons.missiles.AIM_54A_Mk60="weapons.missiles.AIM_54A_Mk60"
ENUMS.Storage.weapons.droptanks.DFT_300_GAL_A4E="weapons.droptanks.DFT_300_GAL_A4E"
ENUMS.Storage.weapons.bombs.ATGM_M1134_Stryker_30337lb="weapons.bombs.ATGM M1134 Stryker [30337lb]"
ENUMS.Storage.weapons.bombs.BAT_120="weapons.bombs.BAT-120"
ENUMS.Storage.weapons.missiles.DWS39_MJ1_MJ2="weapons.missiles.DWS39_MJ1_MJ2"
ENUMS.Storage.weapons.containers.SPRD="weapons.containers.SPRD"
ENUMS.Storage.weapons.bombs.BR_500="weapons.bombs.BR_500"
ENUMS.Storage.weapons.bombs.British_GP_500LB_Bomb_Mk1="weapons.bombs.British_GP_500LB_Bomb_Mk1"
ENUMS.Storage.weapons.bombs.BDU_50HD="weapons.bombs.BDU_50HD"
ENUMS.Storage.weapons.missiles.RS2US="weapons.missiles.RS2US"
ENUMS.Storage.weapons.bombs.IFV_BMP_2_25168lb="weapons.bombs.IFV BMP-2 [25168lb]"
ENUMS.Storage.weapons.bombs.SAMP400HD="weapons.bombs.SAMP400HD"
ENUMS.Storage.weapons.containers.Hercules_Battle_Station="weapons.containers.Hercules_Battle_Station"
ENUMS.Storage.weapons.bombs.AN_M64="weapons.bombs.AN_M64"
ENUMS.Storage.weapons.containers.rearCargoSeats="weapons.containers.rearCargoSeats"
ENUMS.Storage.weapons.bombs.Mk_82="weapons.bombs.Mk_82"
ENUMS.Storage.weapons.missiles.AKD_10="weapons.missiles.AKD-10"
ENUMS.Storage.weapons.bombs.BDU_50LGB="weapons.bombs.BDU_50LGB"
ENUMS.Storage.weapons.missiles.SD_10="weapons.missiles.SD-10"
ENUMS.Storage.weapons.containers.IRDeflector="weapons.containers.IRDeflector"
ENUMS.Storage.weapons.bombs.FAB_500="weapons.bombs.FAB_500"
ENUMS.Storage.weapons.bombs.KAB_500="weapons.bombs.KAB_500"
ENUMS.Storage.weapons.nurs.S_5M="weapons.nurs.S-5M"
ENUMS.Storage.weapons.missiles.MICA_R="weapons.missiles.MICA_R"
ENUMS.Storage.weapons.missiles.X_59M="weapons.missiles.X_59M"
ENUMS.Storage.weapons.nurs.UG_90MM="weapons.nurs.UG_90MM"
ENUMS.Storage.weapons.bombs.LYSBOMB="weapons.bombs.LYSBOMB"
ENUMS.Storage.weapons.nurs.R4M="weapons.nurs.R4M"
ENUMS.Storage.weapons.containers.dlpod_akg="weapons.containers.dlpod_akg"
ENUMS.Storage.weapons.missiles.LD_10="weapons.missiles.LD-10"
ENUMS.Storage.weapons.bombs.SC_50="weapons.bombs.SC_50"
ENUMS.Storage.weapons.nurs.HYDRA_70_MK5="weapons.nurs.HYDRA_70_MK5"
ENUMS.Storage.weapons.bombs.FAB_100M="weapons.bombs.FAB_100M"
ENUMS.Storage.weapons.missiles.Rb_24="weapons.missiles.Rb 24"
ENUMS.Storage.weapons.bombs.BDU_45B="weapons.bombs.BDU_45B"
ENUMS.Storage.weapons.missiles.GB_6_HE="weapons.missiles.GB-6-HE"
ENUMS.Storage.weapons.missiles.KD_63B="weapons.missiles.KD-63B"
ENUMS.Storage.weapons.missiles.P_27PE="weapons.missiles.P_27PE"
ENUMS.Storage.weapons.droptanks.PTB300_MIG15="weapons.droptanks.PTB300_MIG15"
ENUMS.Storage.weapons.bombs.Two50_3="weapons.bombs.250-3"
ENUMS.Storage.weapons.bombs.SC_500_L2="weapons.bombs.SC_500_L2"
ENUMS.Storage.weapons.containers.HMMWV_M1045="weapons.containers.HMMWV_M1045"
ENUMS.Storage.weapons.bombs.FAB_500M54TU="weapons.bombs.FAB-500M54TU"
ENUMS.Storage.weapons.containers.US_M10_SMOKE_TANK_YELLOW="weapons.containers.{US_M10_SMOKE_TANK_YELLOW}"
ENUMS.Storage.weapons.containers.EclairM_60="weapons.containers.{EclairM_60}"
ENUMS.Storage.weapons.bombs.SAB_250_200="weapons.bombs.SAB_250_200"
ENUMS.Storage.weapons.bombs.FAB_100="weapons.bombs.FAB_100"
ENUMS.Storage.weapons.bombs.KAB_500S="weapons.bombs.KAB_500S"
ENUMS.Storage.weapons.missiles.AGM_45A="weapons.missiles.AGM_45A"
ENUMS.Storage.weapons.missiles.Kh25MP_PRGS1VP="weapons.missiles.Kh25MP_PRGS1VP"
ENUMS.Storage.weapons.nurs.S5M1_HEFRAG_FFAR="weapons.nurs.S5M1_HEFRAG_FFAR"
ENUMS.Storage.weapons.containers.kg600="weapons.containers.kg600"
ENUMS.Storage.weapons.bombs.AN_M65="weapons.bombs.AN_M65"
ENUMS.Storage.weapons.bombs.AN_M57="weapons.bombs.AN_M57"
ENUMS.Storage.weapons.bombs.BLU_3B_GROUP="weapons.bombs.BLU_3B_GROUP"
ENUMS.Storage.weapons.bombs.BAP_100="weapons.bombs.BAP-100"
ENUMS.Storage.weapons.containers.HEMTT="weapons.containers.HEMTT"
ENUMS.Storage.weapons.bombs.British_MC_500LB_Bomb_Mk1_Short="weapons.bombs.British_MC_500LB_Bomb_Mk1_Short"
ENUMS.Storage.weapons.nurs.ARAKM70BAP="weapons.nurs.ARAKM70BAP"
ENUMS.Storage.weapons.missiles.AGM_119="weapons.missiles.AGM_119"
ENUMS.Storage.weapons.missiles.MMagicII="weapons.missiles.MMagicII"
ENUMS.Storage.weapons.bombs.AB_500_1_SD_10A="weapons.bombs.AB_500_1_SD_10A"
ENUMS.Storage.weapons.nurs.HYDRA_70_M282="weapons.nurs.HYDRA_70_M282"
ENUMS.Storage.weapons.droptanks.DFT_400_GAL_A4E="weapons.droptanks.DFT_400_GAL_A4E"
ENUMS.Storage.weapons.nurs.HYDRA_70_M257="weapons.nurs.HYDRA_70_M257"
ENUMS.Storage.weapons.droptanks.AV8BNA_AERO1D="weapons.droptanks.AV8BNA_AERO1D"
ENUMS.Storage.weapons.containers.US_M10_SMOKE_TANK_BLUE="weapons.containers.{US_M10_SMOKE_TANK_BLUE}"
ENUMS.Storage.weapons.nurs.ARF8M3HEI="weapons.nurs.ARF8M3HEI"
ENUMS.Storage.weapons.bombs.RN_28="weapons.bombs.RN-28"
ENUMS.Storage.weapons.bombs.Squad_30_x_Soldier_7950lb="weapons.bombs.Squad 30 x Soldier [7950lb]"
ENUMS.Storage.weapons.containers.uaz_469="weapons.containers.uaz-469"
ENUMS.Storage.weapons.containers.Otokar_Cobra="weapons.containers.Otokar_Cobra"
ENUMS.Storage.weapons.bombs.APC_BTR_82A_Air_24998lb="weapons.bombs.APC BTR-82A Air [24998lb]"
ENUMS.Storage.weapons.nurs.HYDRA_70_M274="weapons.nurs.HYDRA_70_M274"
ENUMS.Storage.weapons.missiles.P_24R="weapons.missiles.P_24R"
ENUMS.Storage.weapons.nurs.HYDRA_70_MK61="weapons.nurs.HYDRA_70_MK61"
ENUMS.Storage.weapons.missiles.Igla_1E="weapons.missiles.Igla_1E"
ENUMS.Storage.weapons.missiles.C_802AK="weapons.missiles.C-802AK"
ENUMS.Storage.weapons.nurs.C_24="weapons.nurs.C_24"
ENUMS.Storage.weapons.droptanks.M2KC_08_RPL541="weapons.droptanks.M2KC_08_RPL541"
ENUMS.Storage.weapons.nurs.C_13="weapons.nurs.C_13"
ENUMS.Storage.weapons.droptanks.droptank_110_gal="weapons.droptanks.droptank_110_gal"
ENUMS.Storage.weapons.bombs.Mk_84="weapons.bombs.Mk_84"
ENUMS.Storage.weapons.missiles.Sea_Eagle="weapons.missiles.Sea_Eagle"
ENUMS.Storage.weapons.droptanks.PTB_1200_F1="weapons.droptanks.PTB_1200_F1"
ENUMS.Storage.weapons.nurs.SNEB_TYPE256_H1="weapons.nurs.SNEB_TYPE256_H1"
ENUMS.Storage.weapons.containers.MATRA_PHIMAT="weapons.containers.MATRA-PHIMAT"
ENUMS.Storage.weapons.containers.smoke_pod="weapons.containers.smoke_pod"
ENUMS.Storage.weapons.containers.F_15E_AAQ_14_LANTIRN="weapons.containers.F-15E_AAQ-14_LANTIRN"
ENUMS.Storage.weapons.containers.EclairM_24="weapons.containers.{EclairM_24}"
ENUMS.Storage.weapons.bombs.GBU_16="weapons.bombs.GBU_16"
ENUMS.Storage.weapons.nurs.HYDRA_70_M156="weapons.nurs.HYDRA_70_M156"
ENUMS.Storage.weapons.missiles.R_60="weapons.missiles.R-60"
ENUMS.Storage.weapons.containers.zsu_23_4="weapons.containers.zsu-23-4"
ENUMS.Storage.weapons.missiles.RB75="weapons.missiles.RB75"
ENUMS.Storage.weapons.missiles.Mistral="weapons.missiles.Mistral"
ENUMS.Storage.weapons.droptanks.MB339_TT500_L="weapons.droptanks.MB339_TT500_L"
ENUMS.Storage.weapons.bombs.SAM_SA_13_STRELA_21624lb="weapons.bombs.SAM SA-13 STRELA [21624lb]"
ENUMS.Storage.weapons.bombs.SAM_Avenger_M1097_Air_7200lb="weapons.bombs.SAM Avenger M1097 Air [7200lb]"
ENUMS.Storage.weapons.droptanks.Eleven00L_Tank_Empty="weapons.droptanks.1100L Tank Empty"
ENUMS.Storage.weapons.bombs.AN_M88="weapons.bombs.AN-M88"
ENUMS.Storage.weapons.missiles.S_25L="weapons.missiles.S_25L"
ENUMS.Storage.weapons.nurs.British_AP_25LBNo1_3INCHNo1="weapons.nurs.British_AP_25LBNo1_3INCHNo1"
ENUMS.Storage.weapons.bombs.BDU_50LD="weapons.bombs.BDU_50LD"
ENUMS.Storage.weapons.bombs.AGM_62="weapons.bombs.AGM_62"
ENUMS.Storage.weapons.containers.US_M10_SMOKE_TANK_WHITE="weapons.containers.{US_M10_SMOKE_TANK_WHITE}"
ENUMS.Storage.weapons.missiles.MICA_T="weapons.missiles.MICA_T"
ENUMS.Storage.weapons.containers.HVAR_rocket="weapons.containers.HVAR_rocket"
ENUMS.Storage.weapons.containers.LANTIRN="weapons.containers.LANTIRN"
ENUMS.Storage.weapons.missiles.AGM_78B="weapons.missiles.AGM_78B"
ENUMS.Storage.weapons.containers.uh_60l_pilot="weapons.containers.uh-60l_pilot"
ENUMS.Storage.weapons.missiles.AIM_92E="weapons.missiles.AIM-92E"
ENUMS.Storage.weapons.missiles.KD_63B="weapons.missiles.KD_63B"
ENUMS.Storage.weapons.bombs.Type_200A="weapons.bombs.Type_200A"
ENUMS.Storage.weapons.missiles.HB_AIM_7E_2="weapons.missiles.HB-AIM-7E-2"
ENUMS.Storage.weapons.containers.Spear="weapons.containers.Spear"
ENUMS.Storage.weapons.missiles.LS_6="weapons.missiles.LS_6"
ENUMS.Storage.weapons.containers.HB_ALE_40_0_120="weapons.containers.HB_ALE_40_0_120"
ENUMS.Storage.weapons.containers.Fantasm="weapons.containers.Fantasm"
ENUMS.Storage.weapons.nurs.FFAR_Mk61="weapons.nurs.FFAR_Mk61"
ENUMS.Storage.weapons.bombs.HB_F4E_GBU15V1="weapons.bombs.HB_F4E_GBU15V1"
ENUMS.Storage.weapons.containers.HB_F14_EXT_AN_APQ_167="weapons.containers.HB_F14_EXT_AN_APQ-167"
ENUMS.Storage.weapons.nurs.LWL_RP="weapons.nurs.LWL_RP"
ENUMS.Storage.weapons.bombs.AGM_62_I="weapons.bombs.AGM_62_I"
ENUMS.Storage.weapons.containers.ETHER="weapons.containers.ETHER"
ENUMS.Storage.weapons.containers.TANGAZH="weapons.containers.TANGAZH"
ENUMS.Storage.weapons.bombs.LYSBOMB_11086="weapons.bombs.LYSBOMB 11086"
ENUMS.Storage.weapons.containers.Stub_Wing="weapons.containers.Stub_Wing"
ENUMS.Storage.weapons.missiles.AIM_9E="weapons.missiles.AIM-9E"
ENUMS.Storage.weapons.missiles.C_701T="weapons.missiles.C_701T"
ENUMS.Storage.weapons.bombs.BAP_100="weapons.bombs.BAP_100"
ENUMS.Storage.weapons.missiles.CM_802AKG="weapons.missiles.CM-802AKG"
ENUMS.Storage.weapons.missiles.CM_400AKG="weapons.missiles.CM-400AKG"
ENUMS.Storage.weapons.missiles.C_802AK="weapons.missiles.C_802AK"
ENUMS.Storage.weapons.missiles.KD_63="weapons.missiles.KD_63"
ENUMS.Storage.weapons.containers.HB_ORD_Pave_Spike_Fast="weapons.containers.HB_ORD_Pave_Spike_Fast"
ENUMS.Storage.weapons.missiles.SPIKE_ER2="weapons.missiles.SPIKE_ER2"
ENUMS.Storage.weapons.containers.KINGAL="weapons.containers.KINGAL"
ENUMS.Storage.weapons.containers.LANTIRN_F14_TARGET="weapons.containers.LANTIRN-F14-TARGET"
ENUMS.Storage.weapons.containers.SPS_141="weapons.containers.SPS-141"
ENUMS.Storage.weapons.bombs.BLU_3B_GROUP="weapons.bombs.BLU-3B_GROUP"
ENUMS.Storage.weapons.containers.HB_ALE_40_30_0="weapons.containers.HB_ALE_40_30_0"
ENUMS.Storage.weapons.droptanks.HB_HIGH_PERFORMANCE_CENTERLINE_600_GAL="weapons.droptanks.HB_HIGH_PERFORMANCE_CENTERLINE_600_GAL"
ENUMS.Storage.weapons.containers.ALQ_184="weapons.containers.ALQ-184"
ENUMS.Storage.weapons.missiles.AGM_45B="weapons.missiles.AGM_45B"
ENUMS.Storage.weapons.bombs.BLU_3_GROUP="weapons.bombs.BLU-3_GROUP"
ENUMS.Storage.weapons.missiles.SPIKE_ER="weapons.missiles.SPIKE_ER"
ENUMS.Storage.weapons.nurs.ARAKM70BAPPX="weapons.nurs.ARAKM70BAPPX"
ENUMS.Storage.weapons.bombs.LYSBOMB_11088="weapons.bombs.LYSBOMB 11088"
ENUMS.Storage.weapons.bombs.LYSBOMB_11087="weapons.bombs.LYSBOMB 11087"
ENUMS.Storage.weapons.missiles.KD_20="weapons.missiles.KD_20"
ENUMS.Storage.weapons.droptanks.HB_F_4E_EXT_WingTank="weapons.droptanks.HB_F-4E_EXT_WingTank"
ENUMS.Storage.weapons.missiles.Rb_04="weapons.missiles.Rb_04"
ENUMS.Storage.weapons.containers.AAQ_33="weapons.containers.AAQ-33"
ENUMS.Storage.weapons.droptanks.HB_F_4E_EXT_Center_Fuel_Tank_EMPTY="weapons.droptanks.HB_F-4E_EXT_Center_Fuel_Tank_EMPTY"
ENUMS.Storage.weapons.droptanks.HB_F_4E_EXT_WingTank_R_EMPTY="weapons.droptanks.HB_F-4E_EXT_WingTank_R_EMPTY"
ENUMS.Storage.weapons.droptanks.HB_F_4E_EXT_WingTank_EMPTY="weapons.droptanks.HB_F-4E_EXT_WingTank_EMPTY"
ENUMS.Storage.weapons.containers.uh_60l_copilot="weapons.containers.uh-60l_copilot"
ENUMS.Storage.weapons.droptanks.JAYHAWK_80gal_Fuel_Tankv2="weapons.droptanks.JAYHAWK_80gal_Fuel_Tankv2"
ENUMS.Storage.weapons.containers.supply_m134="weapons.containers.supply_m134"
ENUMS.Storage.weapons.containers.Seahawk_Pylon="weapons.containers.Seahawk_Pylon"
ENUMS.Storage.weapons.nurs.LWL_MPP="weapons.nurs.LWL_MPP"
ENUMS.Storage.weapons.nurs.S_5KP="weapons.nurs.S_5KP"
ENUMS.Storage.weapons.missiles.AIM_92J="weapons.missiles.AIM-92J"
ENUMS.Storage.weapons.missiles.HB_AIM_7E="weapons.missiles.HB-AIM-7E"
ENUMS.Storage.weapons.containers.ALQ_131="weapons.containers.ALQ-131"
ENUMS.Storage.weapons.containers.HB_F14_EXT_TARPS="weapons.containers.HB_F14_EXT_TARPS"
ENUMS.Storage.weapons.containers.MH60_SOAR="weapons.containers.MH60_SOAR"
ENUMS.Storage.weapons.missiles.YJ_83="weapons.missiles.YJ-83"
ENUMS.Storage.weapons.bombs.GBU_8_B="weapons.bombs.GBU_8_B"
ENUMS.Storage.weapons.containers.HB_F14_EXT_ECA="weapons.containers.HB_F14_EXT_ECA"
ENUMS.Storage.weapons.bombs.BAP_100="weapons.bombs.BAP-100"
ENUMS.Storage.weapons.nurs.M261_MPSM_Rocket="weapons.nurs.M261_MPSM_Rocket"
ENUMS.Storage.weapons.droptanks.SEAHAWK_120_Fuel_Tank="weapons.droptanks.SEAHAWK_120_Fuel_Tank"
ENUMS.Storage.weapons.containers.SHPIL="weapons.containers.SHPIL"
ENUMS.Storage.weapons.bombs.GBU_39="weapons.bombs.GBU_39"
ENUMS.Storage.weapons.nurs.S_5M="weapons.nurs.S_5M"
ENUMS.Storage.weapons.containers.HB_ALE_40_15_90="weapons.containers.HB_ALE_40_15_90"
ENUMS.Storage.weapons.missiles.AIM_7E="weapons.missiles.AIM-7E"
ENUMS.Storage.weapons.missiles.AIM_9P3="weapons.missiles.AIM-9P3"
ENUMS.Storage.weapons.missiles.AGM_12B="weapons.missiles.AGM_12B"
ENUMS.Storage.weapons.missiles.CM_802AKG="weapons.missiles.CM_802AKG"
ENUMS.Storage.weapons.droptanks.JAYHAWK_120_Fuel_Dual_Tank="weapons.droptanks.JAYHAWK_120_Fuel_Dual_Tank"
ENUMS.Storage.weapons.droptanks.HB_F_4E_EXT_Center_Fuel_Tank="weapons.droptanks.HB_F-4E_EXT_Center_Fuel_Tank"
ENUMS.Storage.weapons.containers.PAVETACK="weapons.containers.PAVETACK"
ENUMS.Storage.weapons.missiles.LS_6_500="weapons.missiles.LS_6_500"
ENUMS.Storage.weapons.bombs.LYSBOMB_11089="weapons.bombs.LYSBOMB 11089"
ENUMS.Storage.weapons.bombs.BLU_4B_GROUP="weapons.bombs.BLU-4B_GROUP"
ENUMS.Storage.weapons.containers.ah_64d_radar="weapons.containers.ah-64d_radar"
ENUMS.Storage.weapons.containers.F_18_LDT_POD="weapons.containers.F-18-LDT-POD"
ENUMS.Storage.weapons.containers.HB_ALE_40_30_60="weapons.containers.HB_ALE_40_30_60"
ENUMS.Storage.weapons.bombs.LS_6_100="weapons.bombs.LS_6_100"
ENUMS.Storage.weapons.droptanks.HB_F_4E_EXT_WingTank_R="weapons.droptanks.HB_F-4E_EXT_WingTank_R"
ENUMS.Storage.weapons.containers.SORBCIJA_R="weapons.containers.SORBCIJA_R"
ENUMS.Storage.weapons.missiles.CATM_65K="weapons.missiles.CATM_65K"
ENUMS.Storage.weapons.containers.HB_ORD_Pave_Spike="weapons.containers.HB_ORD_Pave_Spike"
ENUMS.Storage.weapons.containers.RobbieTank1="weapons.containers.RobbieTank1"
ENUMS.Storage.weapons.containers.SKY_SHADOW="weapons.containers.SKY_SHADOW"
ENUMS.Storage.weapons.containers.SORBCIJA_L="weapons.containers.SORBCIJA_L"
ENUMS.Storage.weapons.containers.Pavehawk="weapons.containers.Pavehawk"
ENUMS.Storage.weapons.bombs.BLG66_EG="weapons.bombs.BLG66_EG"
ENUMS.Storage.weapons.missiles.AGM_12C_ED="weapons.missiles.AGM_12C_ED"
ENUMS.Storage.weapons.missiles.AIM_92C="weapons.missiles.AIM-92C"
ENUMS.Storage.weapons.containers.MPS_410="weapons.containers.MPS-410"
ENUMS.Storage.weapons.missiles.HJ_12="weapons.missiles.HJ-12"
ENUMS.Storage.weapons.containers.AAQ_28_LITENING="weapons.containers.AAQ-28_LITENING"
ENUMS.Storage.weapons.containers.F_18_FLIR_POD="weapons.containers.F-18-FLIR-POD"
ENUMS.Storage.weapons.bombs.BLU_3B_GROUP="weapons.bombs.BLU_3B_GROUP"
ENUMS.Storage.weapons.containers.UH60L_Jayhawk="weapons.containers.UH60L_Jayhawk"
ENUMS.Storage.weapons.containers.BOZ_100="weapons.containers.BOZ-100"
ENUMS.Storage.weapons.missiles.AGM_78A="weapons.missiles.AGM_78A"
ENUMS.Storage.weapons.missiles.LAU_61_APKWS_M282="weapons.missiles.LAU_61_APKWS_M282"
ENUMS.Storage.weapons.bombs.BAP_100="weapons.bombs.BAP-100"
ENUMS.Storage.weapons.missiles.CM_802AKG="weapons.missiles.CM-802AKG"
ENUMS.Storage.weapons.bombs.BLU_3B_GROUP="weapons.bombs.BLU_3B_GROUP"
ENUMS.Storage.weapons.bombs.BLU_4B_GROUP="weapons.bombs.BLU-4B_GROUP"
ENUMS.Storage.weapons.nurs.S_5M="weapons.nurs.S_5M"
ENUMS.Storage.weapons.missiles.AGM_12A="weapons.missiles.AGM_12A"
ENUMS.Storage.weapons.droptanks.JAYHAWK_120_Fuel_Tank="weapons.droptanks.JAYHAWK_120_Fuel_Tank"
ENUMS.Storage.weapons.bombs.GBU_15_V_1_B="weapons.bombs.GBU_15_V_1_B"
ENUMS.Storage.weapons.missiles.HYDRA_70_M151_APKWS={4,4,8,292}
ENUMS.Storage.weapons.missiles.HYDRA_70_M282_APKWS={4,4,8,293}
ENUMS.Storage.weapons.bombs.BAP100="weapons.bombs.BAP_100"
ENUMS.Storage.weapons.bombs.BLU3B_GROUP="weapons.bombs.BLU-3B_GROUP"
ENUMS.Storage.weapons.missiles.CM_802AKG="weapons.missiles.CM_802AKG"
ENUMS.Storage.weapons.bombs.BLU_4B_GROUP="weapons.bombs.BLU_4B_GROUP"
ENUMS.Storage.weapons.nurs.S5M="weapons.nurs.S-5M"
ENUMS.Storage.weapons.Gazelle.HMP400_100RDS={4,15,46,1771}
ENUMS.Storage.weapons.Gazelle.HMP400_200RDS={4,15,46,1770}
ENUMS.Storage.weapons.Gazelle.HMP400_400RDS={4,15,46,1769}
ENUMS.Storage.weapons.Gazelle.GIAT_M261_AP={4,15,46,1768}
ENUMS.Storage.weapons.Gazelle.GIAT_M261_SAPHEI={4,15,46,1767}
ENUMS.Storage.weapons.Gazelle.GIAT_M261_HE={4,15,46,1766}
ENUMS.Storage.weapons.Gazelle.GIAT_M261_HEAP={4,15,46,1765}
ENUMS.Storage.weapons.Gazelle.GIAT_M261_APHE={4,15,46,1764}
ENUMS.Storage.weapons.Gazelle.GAZELLE_IR_DEFLECTOR={4,15,47,680}
ENUMS.Storage.weapons.Gazelle.GAZELLE_FAS_SANDFILTER={4,15,47,679}
ENUMS.Storage.weapons.CH47.CH47_PORT_M60D={4,15,46,2489}
ENUMS.Storage.weapons.CH47.CH47_STBD_M60D={4,15,46,2488}
ENUMS.Storage.weapons.CH47.CH47_AFT_M60D={4,15,46,2490}
ENUMS.Storage.weapons.CH47.CH47_PORT_M134D={4,15,46,2494}
ENUMS.Storage.weapons.CH47.CH47_STBD_M134D={4,15,46,2495}
ENUMS.Storage.weapons.CH47.CH47_AFT_M3M={4,15,46,2496}
ENUMS.Storage.weapons.CH47.CH47_PORT_M240H={4,15,46,2492}
ENUMS.Storage.weapons.CH47.CH47_STBD_M240H={4,15,46,2491}
ENUMS.Storage.weapons.CH47.CH47_AFT_M240H={4,15,46,2493}
ENUMS.Storage.weapons.UH1H.M134_MiniGun_Right={4,15,46,161}
ENUMS.Storage.weapons.UH1H.M134_MiniGun_Left={4,15,46,160}
ENUMS.Storage.weapons.UH1H.M134_MiniGun_Right_Door={4,15,46,175}
ENUMS.Storage.weapons.UH1H.M60_MG_Right_Door={4,15,46,177}
ENUMS.Storage.weapons.UH1H.M134_MiniGun_Left_Door={4,15,46,174}
ENUMS.Storage.weapons.UH1H.M60_MG_Left_Door={4,15,46,176}
ENUMS.Storage.weapons.OH58.FIM92={4,4,7,449}
ENUMS.Storage.weapons.OH58.MG_M3P100={4,15,46,2611}
ENUMS.Storage.weapons.OH58.MG_M3P200={4,15,46,2610}
ENUMS.Storage.weapons.OH58.MG_M3P300={4,15,46,2609}
ENUMS.Storage.weapons.OH58.MG_M3P400={4,15,46,2608}
ENUMS.Storage.weapons.OH58.MG_M3P500={4,15,46,2607}
ENUMS.Storage.weapons.OH58.Smk_Grenade_Blue={4,5,9,488}
ENUMS.Storage.weapons.OH58.Smk_Grenade_Green={4,5,9,489}
ENUMS.Storage.weapons.OH58.Smk_Grenade_Red={4,5,9,487}
ENUMS.Storage.weapons.OH58.Smk_Grenade_Violet={4,5,9,490}
ENUMS.Storage.weapons.OH58.Smk_Grenade_White={4,5,9,492}
ENUMS.Storage.weapons.OH58.Smk_Grenade_Yellow={4,5,9,491}
ENUMS.Storage.weapons.AH64D.AN_APG78={4,15,44,2114}
ENUMS.Storage.weapons.AH64D.Internal_Aux_FuelTank={1,3,43,1700}
ENUMS.Storage.weapons.droptanks.FuelTank_610gal={1,3,43,10}
ENUMS.Storage.weapons.droptanks.FuelTank_370gal={1,3,43,11}
ENUMS.Storage.weapons.containers.AV8BNA_GAU_12_AP_M79={4,15,46,824}
ENUMS.Storage.weapons.containers.AV8BNA_GAU_12_HE_M792={4,15,46,825}
ENUMS.Storage.weapons.containers.AV8BNA_GAU_12_SAPHEI_T={4,15,46,300}
ENUMS.FARPType={
FARP="FARP",
INVISIBLE="INVISIBLE",
HELIPADSINGLE="HELIPADSINGLE",
PADSINGLE="PADSINGLE",
}
ENUMS.FARPObjectTypeNamesAndShape={
[ENUMS.FARPType.FARP]={TypeName="FARP",ShapeName="FARPS"},
[ENUMS.FARPType.INVISIBLE]={TypeName="Invisible FARP",ShapeName="invisiblefarp"},
[ENUMS.FARPType.HELIPADSINGLE]={TypeName="SINGLE_HELIPAD",ShapeName="FARP"},
[ENUMS.FARPType.PADSINGLE]={TypeName="FARP_SINGLE_01",ShapeName="FARP_SINGLE_01"},
}
SMOKECOLOR=trigger.smokeColor
FLARECOLOR=trigger.flareColor
BIGSMOKEPRESET={
SmallSmokeAndFire=1,
MediumSmokeAndFire=2,
LargeSmokeAndFire=3,
HugeSmokeAndFire=4,
SmallSmoke=5,
MediumSmoke=6,
LargeSmoke=7,
HugeSmoke=8,
}
DCSMAP={
Caucasus="Caucasus",
NTTR="Nevada",
Normandy="Normandy",
PersianGulf="PersianGulf",
TheChannel="TheChannel",
Syria="Syria",
MarianaIslands="MarianaIslands",
Falklands="Falklands",
Sinai="SinaiMap",
Kola="Kola",
Afghanistan="Afghanistan",
Iraq="Iraq",
GermanyCW="GermanyCW",
}
CALLSIGN={
Aircraft={
Enfield=1,
Springfield=2,
Uzi=3,
Colt=4,
Dodge=5,
Ford=6,
Chevy=7,
Pontiac=8,
Hawg=9,
Boar=10,
Pig=11,
Tusk=12,
},
AWACS={
Overlord=1,
Magic=2,
Wizard=3,
Focus=4,
Darkstar=5,
},
Tanker={
Texaco=1,
Arco=2,
Shell=3,
Navy_One=4,
Mauler=5,
Bloodhound=6,
},
JTAC={
Axeman=1,
Darknight=2,
Warrior=3,
Pointer=4,
Eyeball=5,
Moonbeam=6,
Whiplash=7,
Finger=8,
Pinpoint=9,
Ferret=10,
Shaba=11,
Playboy=12,
Hammer=13,
Jaguar=14,
Deathstar=15,
Anvil=16,
Firefly=17,
Mantis=18,
Badger=19,
},
FARP={
London=1,
Dallas=2,
Paris=3,
Moscow=4,
Berlin=5,
Rome=6,
Madrid=7,
Warsaw=8,
Dublin=9,
Perth=10,
},
F16={
Viper=9,
Venom=10,
Lobo=11,
Cowboy=12,
Python=13,
Rattler=14,
Panther=15,
Wolf=16,
Weasel=17,
Wild=18,
Ninja=19,
Jedi=20,
},
F18={
Hornet=9,
Squid=10,
Ragin=11,
Roman=12,
Sting=13,
Jury=14,
Jokey=15,
Ram=16,
Hawk=17,
Devil=18,
Check=19,
Snake=20,
},
F15E={
Dude=9,
Thud=10,
Gunny=11,
Trek=12,
Sniper=13,
Sled=14,
Best=15,
Jazz=16,
Rage=17,
Tahoe=18,
},
B1B={
Bone=9,
Dark=10,
Vader=11
},
B52={
Buff=9,
Dump=10,
Kenworth=11,
},
TransportAircraft={
Heavy=9,
Trash=10,
Cargo=11,
Ascot=12,
},
AH64={
Army_Air=9,
Apache=10,
Crow=11,
Sioux=12,
Gatling=13,
Gunslinger=14,
Hammerhead=15,
Bootleg=16,
Palehorse=17,
Carnivor=18,
Saber=19,
},
Kiowa={
Anvil=1,
Azrael=2,
BamBam=3,
Blackjack=4,
Bootleg=5,
BurninStogie=6,
Chaos=7,
CrazyHorse=8,
Crusader=9,
Darkhorse=10,
Eagle=11,
Lighthorse=12,
Mustang=13,
Outcast=14,
Palehorse=15,
Pegasus=16,
Pistol=17,
Roughneck=18,
Saber=19,
Shamus=20,
Spur=21,
Stetson=22,
Wrath=23,
},
}
UTILS={
_MarkID=1
}
UTILS.IsInstanceOf=function(object,className)
if type(className)~='string'then
if type(className)=='table'and className.IsInstanceOf~=nil then
className=className.ClassName
else
local err_str='className parameter should be a string; parameter received: '..type(className)
return false
end
end
if type(object)=='table'and object.IsInstanceOf~=nil then
return object:IsInstanceOf(className)
else
local basicDataTypes={'string','number','function','boolean','nil','table'}
for _,basicDataType in ipairs(basicDataTypes)do
if className==basicDataType then
return type(object)==basicDataType
end
end
end
return false
end
UTILS.DeepCopy=function(object)
local lookup_table={}
local function _copy(object)
if type(object)~="table"then
return object
elseif lookup_table[object]then
return lookup_table[object]
end
local new_table={}
lookup_table[object]=new_table
for index,value in pairs(object)do
new_table[_copy(index)]=_copy(value)
end
return setmetatable(new_table,getmetatable(object))
end
local objectreturn=_copy(object)
return objectreturn
end
UTILS.OneLineSerialize=function(tbl)
local lookup_table={}
local function _Serialize(tbl)
if type(tbl)=='table'then
if lookup_table[tbl]then
return lookup_table[object]
end
local tbl_str={}
lookup_table[tbl]=tbl_str
tbl_str[#tbl_str+1]='{'
for ind,val in pairs(tbl)do
local ind_str={}
if type(ind)=="number"then
ind_str[#ind_str+1]='['
ind_str[#ind_str+1]=tostring(ind)
ind_str[#ind_str+1]=']='
else
ind_str[#ind_str+1]='['
ind_str[#ind_str+1]=UTILS.BasicSerialize(ind)
ind_str[#ind_str+1]=']='
end
local val_str={}
if((type(val)=='number')or(type(val)=='boolean'))then
val_str[#val_str+1]=tostring(val)
val_str[#val_str+1]=','
tbl_str[#tbl_str+1]=table.concat(ind_str)
tbl_str[#tbl_str+1]=table.concat(val_str)
elseif type(val)=='string'then
val_str[#val_str+1]=UTILS.BasicSerialize(val)
val_str[#val_str+1]=','
tbl_str[#tbl_str+1]=table.concat(ind_str)
tbl_str[#tbl_str+1]=table.concat(val_str)
elseif type(val)=='nil'then
val_str[#val_str+1]='nil,'
tbl_str[#tbl_str+1]=table.concat(ind_str)
tbl_str[#tbl_str+1]=table.concat(val_str)
elseif type(val)=='table'then
if ind=="__index"then
else
val_str[#val_str+1]=_Serialize(val)
val_str[#val_str+1]=','
tbl_str[#tbl_str+1]=table.concat(ind_str)
tbl_str[#tbl_str+1]=table.concat(val_str)
end
elseif type(val)=='function'then
tbl_str[#tbl_str+1]="f() "..tostring(ind)
tbl_str[#tbl_str+1]=','
else
env.info('unable to serialize value type '..UTILS.BasicSerialize(type(val))..' at index '..tostring(ind))
env.info(debug.traceback())
end
end
tbl_str[#tbl_str+1]='}'
return table.concat(tbl_str)
else
return tostring(tbl)
end
end
local objectreturn=_Serialize(tbl)
return objectreturn
end
function UTILS._OneLineSerialize(tbl)
if type(tbl)=='table'then
local tbl_str={}
tbl_str[#tbl_str+1]='{ '
for ind,val in pairs(tbl)do
if type(ind)=="number"then
tbl_str[#tbl_str+1]='['
tbl_str[#tbl_str+1]=tostring(ind)
tbl_str[#tbl_str+1]='] = '
else
tbl_str[#tbl_str+1]='['
tbl_str[#tbl_str+1]=UTILS.BasicSerialize(ind)
tbl_str[#tbl_str+1]='] = '
end
if((type(val)=='number')or(type(val)=='boolean'))then
tbl_str[#tbl_str+1]=tostring(val)
tbl_str[#tbl_str+1]=', '
elseif type(val)=='string'then
tbl_str[#tbl_str+1]=UTILS.BasicSerialize(val)
tbl_str[#tbl_str+1]=', '
elseif type(val)=='nil'then
tbl_str[#tbl_str+1]='nil, '
elseif type(val)=='table'then
else
end
end
tbl_str[#tbl_str+1]='}'
return table.concat(tbl_str)
else
return UTILS.BasicSerialize(tbl)
end
end
UTILS.BasicSerialize=function(s)
if s==nil then
return"\"\""
else
if((type(s)=='number')or(type(s)=='boolean')or(type(s)=='function')or(type(s)=='userdata'))then
return tostring(s)
elseif type(s)=="table"then
return UTILS._OneLineSerialize(s)
elseif type(s)=='string'then
s=string.format('(%s)',s)
return s
end
end
end
function UTILS.TableLength(T)
local count=0
for _ in pairs(T or{})do count=count+1 end
return count
end
function UTILS.PrintTableToLog(table,indent,noprint)
local text="\n"
if not table or type(table)~="table"then
env.warning("No table passed!")
return nil
end
if not indent then indent=0 end
for k,v in pairs(table)do
if string.find(k," ")then k='"'..k..'"'end
if type(v)=="table"and UTILS.TableLength(v)>0 then
if not noprint then
env.info(string.rep("  ",indent)..tostring(k).." = {")
end
text=text..string.rep("  ",indent)..tostring(k).." = {\n"
text=text..tostring(UTILS.PrintTableToLog(v,indent+1),noprint).."\n"
if not noprint then
env.info(string.rep("  ",indent).."},")
end
text=text..string.rep("  ",indent).."},\n"
elseif type(v)=="function"then
else
local value
if tostring(v)=="true"or tostring(v)=="false"or tonumber(v)~=nil then
value=v
else
value='"'..tostring(v)..'"'
end
if not noprint then
env.info(string.rep("  ",indent)..tostring(k).." = "..tostring(value)..",\n")
end
text=text..string.rep("  ",indent)..tostring(k).." = "..tostring(value)..",\n"
end
end
return text
end
function UTILS.TableShow(tbl,loc,indent,tableshow_tbls)
tableshow_tbls=tableshow_tbls or{}
loc=loc or""
indent=indent or""
if type(tbl)=='table'then
tableshow_tbls[tbl]=loc
local tbl_str={}
tbl_str[#tbl_str+1]=indent..'{\n'
for ind,val in pairs(tbl)do
if type(ind)=="number"then
tbl_str[#tbl_str+1]=indent
tbl_str[#tbl_str+1]=loc..'['
tbl_str[#tbl_str+1]=tostring(ind)
tbl_str[#tbl_str+1]='] = '
else
tbl_str[#tbl_str+1]=indent
tbl_str[#tbl_str+1]=loc..'['
tbl_str[#tbl_str+1]=UTILS.BasicSerialize(ind)
tbl_str[#tbl_str+1]='] = '
end
if((type(val)=='number')or(type(val)=='boolean'))then
tbl_str[#tbl_str+1]=tostring(val)
tbl_str[#tbl_str+1]=',\n'
elseif type(val)=='string'then
tbl_str[#tbl_str+1]=UTILS.BasicSerialize(val)
tbl_str[#tbl_str+1]=',\n'
elseif type(val)=='nil'then
tbl_str[#tbl_str+1]='nil,\n'
elseif type(val)=='table'then
if tableshow_tbls[val]then
tbl_str[#tbl_str+1]=tostring(val)..' already defined: '..tableshow_tbls[val]..',\n'
else
tableshow_tbls[val]=loc..'['..UTILS.BasicSerialize(ind)..']'
tbl_str[#tbl_str+1]=tostring(val)..' '
tbl_str[#tbl_str+1]=UTILS.TableShow(val,loc..'['..UTILS.BasicSerialize(ind)..']',indent..'    ',tableshow_tbls)
tbl_str[#tbl_str+1]=',\n'
end
elseif type(val)=='function'then
if debug and debug.getinfo then
local fcnname=tostring(val)
local info=debug.getinfo(val,"S")
if info.what=="C"then
tbl_str[#tbl_str+1]=string.format('%q',fcnname..', C function')..',\n'
else
if(string.sub(info.source,1,2)==[[./]])then
tbl_str[#tbl_str+1]=string.format('%q',fcnname..', defined in ('..info.linedefined..'-'..info.lastlinedefined..')'..info.source)..',\n'
else
tbl_str[#tbl_str+1]=string.format('%q',fcnname..', defined in ('..info.linedefined..'-'..info.lastlinedefined..')')..',\n'
end
end
else
tbl_str[#tbl_str+1]='a function,\n'
end
else
tbl_str[#tbl_str+1]='unable to serialize value type '..UTILS.BasicSerialize(type(val))..' at index '..tostring(ind)
end
end
tbl_str[#tbl_str+1]=indent..'}'
return table.concat(tbl_str)
end
end
function UTILS.Gdump(fname)
if lfs and io then
local fdir=lfs.writedir()..[[Logs\]]..fname
local f=io.open(fdir,'w')
f:write(UTILS.TableShow(_G))
f:close()
env.info(string.format('Wrote debug data to $1',fdir))
else
env.error("WARNING: lfs and/or io not de-sanitized - cannot dump _G!")
end
end
function UTILS.DoString(s)
local f,err=loadstring(s)
if f then
return true,f()
else
return false,err
end
end
UTILS.ToDegree=function(angle)
return angle*180/math.pi
end
UTILS.ToRadian=function(angle)
return angle*math.pi/180
end
UTILS.MetersToNM=function(meters)
return meters/1852
end
UTILS.KiloMetersToNM=function(kilometers)
return kilometers/1852*1000
end
UTILS.MetersToSM=function(meters)
return meters/1609.34
end
UTILS.KiloMetersToSM=function(kilometers)
return kilometers/1609.34*1000
end
UTILS.MetersToFeet=function(meters)
return meters/0.3048
end
UTILS.KiloMetersToFeet=function(kilometers)
return kilometers/0.3048*1000
end
UTILS.NMToMeters=function(NM)
return NM*1852
end
UTILS.NMToKiloMeters=function(NM)
return NM*1852/1000
end
UTILS.FeetToMeters=function(feet)
return feet*0.3048
end
UTILS.KnotsToKmph=function(knots)
return knots*1.852
end
UTILS.KmphToKnots=function(knots)
return knots/1.852
end
UTILS.KmphToMps=function(kmph)
return kmph/3.6
end
UTILS.MpsToKmph=function(mps)
return mps*3.6
end
UTILS.MiphToMps=function(miph)
return miph*0.44704
end
UTILS.MpsToMiph=function(mps)
return mps/0.44704
end
UTILS.MpsToKnots=function(mps)
return mps*1.94384
end
UTILS.KnotsToMps=function(knots)
if type(knots)=="number"then
return knots/1.94384
else
return 0
end
end
UTILS.CelsiusToFahrenheit=function(Celcius)
return Celcius*9/5+32
end
UTILS.hPa2inHg=function(hPa)
return hPa*0.0295299830714
end
UTILS.IasToTas=function(ias,altitude,oatcorr)
oatcorr=oatcorr or 0.017
local tas=ias+(ias*oatcorr*UTILS.MetersToFeet(altitude)/1000)
return tas
end
UTILS.TasToIas=function(tas,altitude,oatcorr)
oatcorr=oatcorr or 0.017
local ias=tas/(1+oatcorr*UTILS.MetersToFeet(altitude)/1000)
return ias
end
UTILS.KnotsToAltKIAS=function(knots,altitude)
return(knots*0.018*(altitude/1000))+knots
end
UTILS.hPa2mmHg=function(hPa)
return hPa*0.7500615613030
end
UTILS.kg2lbs=function(kg)
return kg*2.20462
end
UTILS.tostringLL=function(lat,lon,acc,DMS)
local latHemi,lonHemi
if lat>0 then
latHemi='N'
else
latHemi='S'
end
if lon>0 then
lonHemi='E'
else
lonHemi='W'
end
lat=math.abs(lat)
lon=math.abs(lon)
local latDeg=math.floor(lat)
local latMin=(lat-latDeg)*60
local lonDeg=math.floor(lon)
local lonMin=(lon-lonDeg)*60
if DMS then
local oldLatMin=latMin
latMin=math.floor(latMin)
local latSec=UTILS.Round((oldLatMin-latMin)*60,acc)
local oldLonMin=lonMin
lonMin=math.floor(lonMin)
local lonSec=UTILS.Round((oldLonMin-lonMin)*60,acc)
if latSec==60 then
latSec=0
latMin=latMin+1
end
if lonSec==60 then
lonSec=0
lonMin=lonMin+1
end
local secFrmtStr
secFrmtStr='%02d'
if acc<=0 then
secFrmtStr='%02d'
else
local width=3+acc
secFrmtStr='%0'..width..'.'..acc..'f'
end
return string.format('%03d°',latDeg)..string.format('%02d',latMin)..'\''..string.format(secFrmtStr,latSec)..'"'..latHemi..' '
..string.format('%03d°',lonDeg)..string.format('%02d',lonMin)..'\''..string.format(secFrmtStr,lonSec)..'"'..lonHemi
else
latMin=UTILS.Round(latMin,acc)
lonMin=UTILS.Round(lonMin,acc)
if latMin==60 then
latMin=0
latDeg=latDeg+1
end
if lonMin==60 then
lonMin=0
lonDeg=lonDeg+1
end
local minFrmtStr
if acc<=0 then
minFrmtStr='%02d'
else
local width=3+acc
minFrmtStr='%0'..width..'.'..acc..'f'
end
return string.format('%03d°',latDeg)..' '..string.format(minFrmtStr,latMin)..'\''..latHemi..'   '
..string.format('%03d°',lonDeg)..' '..string.format(minFrmtStr,lonMin)..'\''..lonHemi
end
end
UTILS.tostringLLM2KData=function(lat,lon,acc)
local latHemi,lonHemi
if lat>0 then
latHemi='N'
else
latHemi='S'
end
if lon>0 then
lonHemi='E'
else
lonHemi='W'
end
lat=math.abs(lat)
lon=math.abs(lon)
local latDeg=math.floor(lat)
local latMin=(lat-latDeg)*60
local lonDeg=math.floor(lon)
local lonMin=(lon-lonDeg)*60
latMin=UTILS.Round(latMin,acc)
lonMin=UTILS.Round(lonMin,acc)
if latMin==60 then
latMin=0
latDeg=latDeg+1
end
if lonMin==60 then
lonMin=0
lonDeg=lonDeg+1
end
local minFrmtStr
if acc<=0 then
minFrmtStr='%02d'
else
local width=3+acc
minFrmtStr='%0'..width..'.'..acc..'f'
end
return latHemi..string.format('%02d:',latDeg)..string.format(minFrmtStr,latMin),lonHemi..string.format('%02d:',lonDeg)..string.format(minFrmtStr,lonMin)
end
UTILS.tostringMGRS=function(MGRS,acc)
if acc<=0 then
return MGRS.UTMZone..' '..MGRS.MGRSDigraph
else
if acc>5 then acc=5 end
local Easting=tostring(MGRS.Easting)
local Northing=tostring(MGRS.Northing)
local nE=5-string.len(Easting)
local nN=5-string.len(Northing)
for i=1,nE do Easting="0"..Easting end
for i=1,nN do Northing="0"..Northing end
return string.format("%s %s %s %s",MGRS.UTMZone,MGRS.MGRSDigraph,string.sub(Easting,1,acc),string.sub(Northing,1,acc))
end
end
function UTILS.Round(num,idp)
local mult=10^(idp or 0)
return math.floor(num*mult+0.5)/mult
end
function UTILS.DoString(s)
local f,err=loadstring(s)
if f then
return true,f()
else
return false,err
end
end
function UTILS.spairs(t,order)
local keys={}
for k in pairs(t)do keys[#keys+1]=k end
if order then
table.sort(keys,function(a,b)return order(t,a,b)end)
else
table.sort(keys)
end
local i=0
return function()
i=i+1
if keys[i]then
return keys[i],t[keys[i]]
end
end
end
function UTILS.kpairs(t,getkey,order)
local keys={}
local keyso={}
for k,o in pairs(t)do keys[#keys+1]=k keyso[#keyso+1]=getkey(o)end
if order then
table.sort(keys,function(a,b)return order(t,a,b)end)
else
table.sort(keys)
end
local i=0
return function()
i=i+1
if keys[i]then
return keyso[i],t[keys[i]]
end
end
end
function UTILS.rpairs(t)
local keys={}
for k in pairs(t)do keys[#keys+1]=k end
local random={}
local j=#keys
for i=1,j do
local k=math.random(1,#keys)
random[i]=keys[k]
table.remove(keys,k)
end
local i=0
return function()
i=i+1
if random[i]then
return random[i],t[random[i]]
end
end
end
function UTILS.GetMarkID()
UTILS._MarkID=UTILS._MarkID+1
return UTILS._MarkID
end
function UTILS.RemoveMark(MarkID,Delay)
if Delay and Delay>0 then
TIMER:New(UTILS.RemoveMark,MarkID):Start(Delay)
else
if MarkID then
trigger.action.removeMark(MarkID)
end
end
end
function UTILS.IsInRadius(InVec2,Vec2,Radius)
local InRadius=((InVec2.x-Vec2.x)^2+(InVec2.y-Vec2.y)^2)^0.5<=Radius
return InRadius
end
function UTILS.IsInSphere(InVec3,Vec3,Radius)
local InSphere=((InVec3.x-Vec3.x)^2+(InVec3.y-Vec3.y)^2+(InVec3.z-Vec3.z)^2)^0.5<=Radius
return InSphere
end
function UTILS.BeaufortScale(speed)
local bn=nil
local bd=nil
if speed<0.51 then
bn=0
bd="Calm"
elseif speed<2.06 then
bn=1
bd="Light Air"
elseif speed<3.60 then
bn=2
bd="Light Breeze"
elseif speed<5.66 then
bn=3
bd="Gentle Breeze"
elseif speed<8.23 then
bn=4
bd="Moderate Breeze"
elseif speed<11.32 then
bn=5
bd="Fresh Breeze"
elseif speed<14.40 then
bn=6
bd="Strong Breeze"
elseif speed<17.49 then
bn=7
bd="Moderate Gale"
elseif speed<21.09 then
bn=8
bd="Fresh Gale"
elseif speed<24.69 then
bn=9
bd="Strong Gale"
elseif speed<28.81 then
bn=10
bd="Storm"
elseif speed<32.92 then
bn=11
bd="Violent Storm"
else
bn=12
bd="Hurricane"
end
return bn,bd
end
function UTILS.Split(str,sep)
local result={}
local regex=("([^%s]+)"):format(sep)
for each in str:gmatch(regex)do
table.insert(result,each)
end
return result
end
function UTILS.GetCharacters(str)
local chars={}
for i=1,#str do
local c=str:sub(i,i)
table.insert(chars,c)
end
return chars
end
function UTILS.SecondsToClock(seconds,short)
if seconds==nil then
return nil
end
local seconds=tonumber(seconds)or 0
local _seconds=seconds%(60*60*24)
if seconds<0 then
return nil
else
local hours=string.format("%02.f",math.floor(_seconds/3600))
local mins=string.format("%02.f",math.floor(_seconds/60-(hours*60)))
local secs=string.format("%02.f",math.floor(_seconds-hours*3600-mins*60))
local days=string.format("%d",seconds/(60*60*24))
local clock=hours..":"..mins..":"..secs.."+"..days
if short then
if hours=="00"then
clock=hours..":"..mins..":"..secs
else
clock=hours..":"..mins..":"..secs
end
end
return clock
end
end
function UTILS.SecondsOfToday()
local time=timer.getAbsTime()
local clock=UTILS.SecondsToClock(time,true)
return UTILS.ClockToSeconds(clock)
end
function UTILS.SecondsToMidnight()
return 24*60*60-UTILS.SecondsOfToday()
end
function UTILS.ClockToSeconds(clock)
if clock==nil then
return nil
end
local seconds=0
local dsplit=UTILS.Split(clock,"+")
if#dsplit>1 then
seconds=seconds+tonumber(dsplit[2])*60*60*24
end
local tsplit=UTILS.Split(dsplit[1],":")
local i=1
for _,time in ipairs(tsplit)do
if i==1 then
seconds=seconds+tonumber(time)*60*60
elseif i==2 then
seconds=seconds+tonumber(time)*60
elseif i==3 then
seconds=seconds+tonumber(time)
end
i=i+1
end
return seconds
end
function UTILS.DisplayMissionTime(duration)
duration=duration or 5
local Tnow=timer.getAbsTime()
local mission_time=Tnow-timer.getTime0()
local mission_time_minutes=mission_time/60
local mission_time_seconds=mission_time%60
local local_time=UTILS.SecondsToClock(Tnow)
local text=string.format("Time: %s - %02d:%02d",local_time,mission_time_minutes,mission_time_seconds)
MESSAGE:New(text,duration):ToAll()
end
function UTILS.ReplaceIllegalCharacters(Text,ReplaceBy)
ReplaceBy=ReplaceBy or"_"
local text=Text:gsub("[<>|/?*:\\]",ReplaceBy)
return text
end
function UTILS.RandomGaussian(x0,sigma,xmin,xmax,imax)
sigma=sigma or 10
imax=imax or 100
local r
local gotit=false
local i=0
while not gotit do
local x1=math.random()
local x2=math.random()
r=math.sqrt(-2*sigma*sigma*math.log(x1))*math.cos(2*math.pi*x2)+x0
i=i+1
if(r>=xmin and r<=xmax)or i>imax then
gotit=true
end
end
return r
end
function UTILS.Randomize(value,fac,lower,upper)
local min
if lower then
min=math.max(value-value*fac,lower)
else
min=value-value*fac
end
local max
if upper then
max=math.min(value+value*fac,upper)
else
max=value+value*fac
end
local r=math.random(min,max)
return r
end
function UTILS.VecDot(a,b)
return a.x*b.x+a.y*b.y+a.z*b.z
end
function UTILS.Vec2Dot(a,b)
return a.x*b.x+a.y*b.y
end
function UTILS.VecNorm(a)
return math.sqrt(UTILS.VecDot(a,a))
end
function UTILS.Vec2Norm(a)
return math.sqrt(UTILS.Vec2Dot(a,a))
end
function UTILS.VecDist2D(a,b)
local d=math.huge
if(not a)or(not b)then return d end
local c={x=b.x-a.x,y=b.y-a.y}
d=math.sqrt(c.x*c.x+c.y*c.y)
return d
end
function UTILS.VecDist3D(a,b)
local d=math.huge
if(not a)or(not b)then return d end
local c={x=b.x-a.x,y=b.y-a.y,z=b.z-a.z}
d=math.sqrt(UTILS.VecDot(c,c))
return d
end
function UTILS.VecCross(a,b)
return{x=a.y*b.z-a.z*b.y,y=a.z*b.x-a.x*b.z,z=a.x*b.y-a.y*b.x}
end
function UTILS.VecSubstract(a,b)
return{x=a.x-b.x,y=a.y-b.y,z=a.z-b.z}
end
function UTILS.VecSubtract(a,b)
return UTILS.VecSubstract(a,b)
end
function UTILS.Vec2Substract(a,b)
return{x=a.x-b.x,y=a.y-b.y}
end
function UTILS.Vec2Subtract(a,b)
return UTILS.Vec2Substract(a,b)
end
function UTILS.VecAdd(a,b)
return{x=a.x+b.x,y=a.y+b.y,z=a.z+b.z}
end
function UTILS.Vec2Add(a,b)
return{x=a.x+b.x,y=a.y+b.y}
end
function UTILS.VecAngle(a,b)
local cosalpha=UTILS.VecDot(a,b)/(UTILS.VecNorm(a)*UTILS.VecNorm(b))
local alpha=0
if cosalpha>=0.9999999999 then
alpha=0
elseif cosalpha<=-0.999999999 then
alpha=math.pi
else
alpha=math.acos(cosalpha)
end
return math.deg(alpha)
end
function UTILS.VecHdg(a)
local h=math.deg(math.atan2(a.z,a.x))
if h<0 then
h=h+360
end
return h
end
function UTILS.Vec2Hdg(a)
local h=math.deg(math.atan2(a.y,a.x))
if h<0 then
h=h+360
end
return h
end
function UTILS.HdgDiff(h1,h2)
local alpha=math.rad(tonumber(h1))
local beta=math.rad(tonumber(h2))
local v1={x=math.cos(alpha),y=0,z=math.sin(alpha)}
local v2={x=math.cos(beta),y=0,z=math.sin(beta)}
local delta=UTILS.VecAngle(v1,v2)
return math.abs(delta)
end
function UTILS.HdgTo(a,b)
local dz=b.z-a.z
local dx=b.x-a.x
local heading=math.deg(math.atan2(dz,dx))
if heading<0 then
heading=360+heading
end
return heading
end
function UTILS.VecTranslate(a,distance,angle)
local SX=a.x
local SY=a.z
local Radians=math.rad(angle or 0)
local TX=distance*math.cos(Radians)+SX
local TY=distance*math.sin(Radians)+SY
return{x=TX,y=a.y,z=TY}
end
function UTILS.Vec2Translate(a,distance,angle)
local SX=a.x
local SY=a.y
local Radians=math.rad(angle or 0)
local TX=distance*math.cos(Radians)+SX
local TY=distance*math.sin(Radians)+SY
return{x=TX,y=TY}
end
function UTILS.Rotate2D(a,angle)
local phi=math.rad(angle)
local x=a.z
local y=a.x
local Z=x*math.cos(phi)-y*math.sin(phi)
local X=x*math.sin(phi)+y*math.cos(phi)
local Y=a.y
local A={x=X,y=Y,z=Z}
return A
end
function UTILS.Vec2Rotate2D(a,angle)
local phi=math.rad(angle)
local x=a.x
local y=a.y
local X=x*math.cos(phi)-y*math.sin(phi)
local Y=x*math.sin(phi)+y*math.cos(phi)
local A={x=X,y=Y}
return A
end
function UTILS.TACANToFrequency(TACANChannel,TACANMode)
if type(TACANChannel)~="number"then
return nil
end
if TACANMode~="X"and TACANMode~="Y"then
return nil
end
local A=1151
local B=64
if TACANChannel<64 then
B=1
end
if TACANMode=='Y'then
A=1025
if TACANChannel<64 then
A=1088
end
else
if TACANChannel<64 then
A=962
end
end
return(A+TACANChannel-B)*1000000
end
function UTILS.GetDCSMap()
return env.mission.theatre
end
function UTILS.GetDCSMissionDate()
local year=tostring(env.mission.date.Year)
local month=tostring(env.mission.date.Month)
local day=tostring(env.mission.date.Day)
return string.format("%s/%s/%s",year,month,day),tonumber(year),tonumber(month),tonumber(day)
end
function UTILS.GetMissionDay(Time)
Time=Time or timer.getAbsTime()
local clock=UTILS.SecondsToClock(Time,false)
local x=tonumber(UTILS.Split(clock,"+")[2])
return x
end
function UTILS.GetMissionDayOfYear(Time)
local Date,Year,Month,Day=UTILS.GetDCSMissionDate()
local d=UTILS.GetMissionDay(Time)
return UTILS.GetDayOfYear(Year,Month,Day)+d
end
function UTILS.GetMagneticDeclination(map)
map=map or UTILS.GetDCSMap()
local declination=0
if map==DCSMAP.Caucasus then
declination=6
elseif map==DCSMAP.NTTR then
declination=12
elseif map==DCSMAP.Normandy then
declination=-10
elseif map==DCSMAP.PersianGulf then
declination=2
elseif map==DCSMAP.TheChannel then
declination=-10
elseif map==DCSMAP.Syria then
declination=5
elseif map==DCSMAP.MarianaIslands then
declination=2
elseif map==DCSMAP.Falklands then
declination=12
elseif map==DCSMAP.Sinai then
declination=4.8
elseif map==DCSMAP.Kola then
declination=15
elseif map==DCSMAP.Afghanistan then
declination=3
elseif map==DCSMAP.Iraq then
declination=4.4
elseif map==DCSMAP.GermanyCW then
declination=0.1
else
declination=0
end
return declination
end
function UTILS.FileExists(file)
if io then
local f=io.open(file,"r")
if f~=nil then
io.close(f)
return true
else
return false
end
else
return nil
end
end
function UTILS.CheckMemory(output)
local time=timer.getTime()
local clock=UTILS.SecondsToClock(time)
local mem=collectgarbage("count")
if output then
env.info(string.format("T=%s  Memory usage %d kByte = %.2f MByte",clock,mem,mem/1024))
end
return mem
end
function UTILS.GetCoalitionName(Coalition)
if Coalition then
if Coalition==coalition.side.BLUE then
return"Blue"
elseif Coalition==coalition.side.RED then
return"Red"
elseif Coalition==coalition.side.NEUTRAL then
return"Neutral"
else
return"Unknown"
end
else
return"Unknown"
end
end
function UTILS.GetCoalitionEnemy(Coalition,Neutral)
local Coalitions={}
if Coalition then
if Coalition==coalition.side.RED then
Coalitions={coalition.side.BLUE}
elseif Coalition==coalition.side.BLUE then
Coalitions={coalition.side.RED}
elseif Coalition==coalition.side.NEUTRAL then
Coalitions={coalition.side.RED,coalition.side.BLUE}
end
end
if Neutral then
table.insert(Coalitions,coalition.side.NEUTRAL)
end
return Coalitions
end
function UTILS.GetModulationName(Modulation)
if Modulation then
if Modulation==0 then
return"AM"
elseif Modulation==1 then
return"FM"
else
return"Unknown"
end
else
return"Unknown"
end
end
function UTILS.GetReportingName(Typename)
local typename=string.lower(Typename)
for name,value in pairs(ENUMS.ReportingName.NATO)do
local svalue=string.lower(value)
if string.find(typename,svalue,1,true)then
return name
end
end
return"Bogey"
end
function UTILS.GetCallsignName(Callsign)
for name,value in pairs(CALLSIGN.Aircraft)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.AWACS)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.JTAC)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.Tanker)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.B1B)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.B52)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.F15E)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.F16)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.F18)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.FARP)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.TransportAircraft)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.AH64)do
if value==Callsign then
return name
end
end
for name,value in pairs(CALLSIGN.Kiowa)do
if value==Callsign then
return name
end
end
return"Ghostrider"
end
function UTILS.GMTToLocalTimeDifference()
local theatre=UTILS.GetDCSMap()
if theatre==DCSMAP.Caucasus then
return 4
elseif theatre==DCSMAP.PersianGulf then
return 4
elseif theatre==DCSMAP.NTTR then
return-8
elseif theatre==DCSMAP.Normandy then
return 0
elseif theatre==DCSMAP.TheChannel then
return 2
elseif theatre==DCSMAP.Syria then
return 3
elseif theatre==DCSMAP.MarianaIslands then
return 10
elseif theatre==DCSMAP.Falklands then
return-3
elseif theatre==DCSMAP.Sinai then
return 2
elseif theatre==DCSMAP.Kola then
return 3
elseif theatre==DCSMAP.Afghanistan then
return 4.5
elseif theatre==DCSMAP.Iraq then
return 3.0
elseif theatre==DCSMAP.GermanyCW then
return 1.0
else
BASE:E(string.format("ERROR: Unknown Map %s in UTILS.GMTToLocal function. Returning 0",tostring(theatre)))
return 0
end
end
function UTILS.GetDayOfYear(Year,Month,Day)
local floor=math.floor
local n1=floor(275*Month/9)
local n2=floor((Month+9)/12)
local n3=(1+floor((Year-4*floor(Year/4)+2)/3))
return n1-(n2*n3)+Day-30
end
function UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,Rising,Tlocal)
local zenith=90.83
local latitude=Latitude
local longitude=Longitude
local rising=Rising
local n=DayOfYear
Tlocal=Tlocal or 0
local rad=math.rad
local deg=math.deg
local floor=math.floor
local frac=function(n)return n-floor(n)end
local cos=function(d)return math.cos(rad(d))end
local acos=function(d)return deg(math.acos(d))end
local sin=function(d)return math.sin(rad(d))end
local asin=function(d)return deg(math.asin(d))end
local tan=function(d)return math.tan(rad(d))end
local atan=function(d)return deg(math.atan(d))end
local function fit_into_range(val,min,max)
local range=max-min
local count
if val<min then
count=floor((min-val)/range)+1
return val+count*range
elseif val>=max then
count=floor((val-max)/range)+1
return val-count*range
else
return val
end
end
local lng_hour=longitude/15
local t
if rising then
t=n+((6-lng_hour)/24)
else
t=n+((18-lng_hour)/24)
end
local M=(0.9856*t)-3.289
local L=fit_into_range(M+(1.916*sin(M))+(0.020*sin(2*M))+282.634,0,360)
local RA=fit_into_range(atan(0.91764*tan(L)),0,360)
local Lquadrant=floor(L/90)*90
local RAquadrant=floor(RA/90)*90
RA=RA+Lquadrant-RAquadrant
RA=RA/15
local sinDec=0.39782*sin(L)
local cosDec=cos(asin(sinDec))
local cosH=(cos(zenith)-(sinDec*sin(latitude)))/(cosDec*cos(latitude))
if rising and cosH>1 then
return"N/S"
elseif cosH<-1 then
return"N/R"
end
local H
if rising then
H=360-acos(cosH)
else
H=acos(cosH)
end
H=H/15
local T=H+RA-(0.06571*t)-6.622
local UT=fit_into_range(T-lng_hour+Tlocal,0,24)
return floor(UT)*60*60+frac(UT)*60*60
end
function UTILS.GetSunrise(Day,Month,Year,Latitude,Longitude,Tlocal)
local DayOfYear=UTILS.GetDayOfYear(Year,Month,Day)
return UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,true,Tlocal)
end
function UTILS.GetSunset(Day,Month,Year,Latitude,Longitude,Tlocal)
local DayOfYear=UTILS.GetDayOfYear(Year,Month,Day)
return UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,false,Tlocal)
end
function UTILS.GetOSTime()
if os then
local ts=0
local t=os.date("*t")
local s=t.sec
local m=t.min*60
local h=t.hour*3600
ts=s+m+h
return ts
else
return nil
end
end
function UTILS.ShuffleTable(t)
if t==nil or type(t)~="table"then
BASE:I("Error in ShuffleTable: Missing or wrong type of Argument")
return
end
math.random()
math.random()
math.random()
local TempTable={}
for i=1,#t do
local r=math.random(1,#t)
TempTable[i]=t[r]
table.remove(t,r)
end
return TempTable
end
function UTILS.GetRandomTableElement(t,replace)
if t==nil or type(t)~="table"then
BASE:I("Error in ShuffleTable: Missing or wrong type of Argument")
return
end
math.random()
math.random()
math.random()
local r=math.random(#t)
local element=t[r]
if not replace then
table.remove(t,r)
end
return element
end
function UTILS.IsLoadingDoorOpen(unit_name)
local unit=Unit.getByName(unit_name)
if unit~=nil then
local type_name=unit:getTypeName()
BASE:T("TypeName = "..type_name)
if type_name=="Mi-8MT"and(unit:getDrawArgumentValue(38)==1 or unit:getDrawArgumentValue(86)==1 or unit:getDrawArgumentValue(250)<0)then
BASE:T(unit_name.." Cargo doors are open or cargo door not present")
return true
end
if type_name=="Mi-24P"and(unit:getDrawArgumentValue(38)==1 or unit:getDrawArgumentValue(86)==1)then
BASE:T(unit_name.." a side door is open")
return true
end
if type_name=="UH-1H"and(unit:getDrawArgumentValue(43)==1 or unit:getDrawArgumentValue(44)==1)then
BASE:T(unit_name.." a side door is open ")
return true
end
if string.find(type_name,"SA342")and(unit:getDrawArgumentValue(34)==1)then
BASE:T(unit_name.." front door(s) are open or doors removed")
return true
end
if string.find(type_name,"Hercules")and(unit:getDrawArgumentValue(1215)==1 and unit:getDrawArgumentValue(1216)==1)then
BASE:T(unit_name.." rear doors are open")
return true
end
if string.find(type_name,"Hercules")and(unit:getDrawArgumentValue(1220)==1 or unit:getDrawArgumentValue(1221)==1)then
BASE:T(unit_name.." para doors are open")
return true
end
if string.find(type_name,"Hercules")and(unit:getDrawArgumentValue(1217)==1)then
BASE:T(unit_name.." side door is open")
return true
end
if type_name=="Bell-47"then
BASE:T(unit_name.." door is open")
return true
end
if type_name=="UH-60L"and(unit:getDrawArgumentValue(401)==1 or unit:getDrawArgumentValue(402)==1)then
BASE:T(unit_name.." cargo door is open")
return true
end
if type_name=="UH-60L"and(unit:getDrawArgumentValue(38)>0 or unit:getDrawArgumentValue(400)==1)then
BASE:T(unit_name.." front door(s) are open")
return true
end
if type_name=="AH-64D_BLK_II"then
BASE:T(unit_name.." front door(s) are open")
return true
end
if type_name=="Bronco-OV-10A"then
BASE:T(unit_name.." front door(s) are open")
return true
end
if type_name=="MH-60R"and(unit:getDrawArgumentValue(403)>0 or unit:getDrawArgumentValue(403)==-1)then
BASE:T(unit_name.." cargo door is open")
return true
end
if type_name=="OH58D"then
BASE:T(unit_name.." front door(s) are open")
return true
end
if type_name=="CH-47Fbl1"and(unit:getDrawArgumentValue(86)>0.5)then
BASE:T(unit_name.." rear cargo door is open")
return true
end
local UnitDescriptor=unit:getDesc()
local IsGroundResult=(UnitDescriptor.category==Unit.Category.GROUND_UNIT)
return IsGroundResult
end
return nil
end
function UTILS.GenerateFMFrequencies()
local FreeFMFrequencies={}
for _first=3,7 do
for _second=0,5 do
for _third=0,9 do
local _frequency=((100*_first)+(10*_second)+_third)*100000
table.insert(FreeFMFrequencies,_frequency)
end
end
end
return FreeFMFrequencies
end
function UTILS.GenerateVHFrequencies()
local _skipFrequencies={
214,243,264,273,274,288,291.5,295,297.5,
300.5,304,305,307,309.5,310,311,312,312.5,316,317,
320,323,324,325,326,328,329,330,332,335,336,337,
340,342,343,346,348,351,352,353,358,
360,363,364,365,368,372.5,373,374,
380,381,384,385,387,389,391,395,396,399,
403,404,410,412,414,418,420,423,
430,432,435,440,445,
450,455,462,470,485,490,
507,515,520,525,528,540,550,560,563,570,577,580,595,
602,625,641,662,670,680,682,690,
705,720,722,730,735,740,745,750,770,795,
822,830,862,866,
905,907,920,935,942,950,995,
1000,1025,1030,1050,1065,1116,1175,1182,1210,1215
}
local FreeVHFFrequencies={}
local _start=200000
while _start<400000 do
local _found=false
for _,value in pairs(_skipFrequencies)do
if value*1000==_start then
_found=true
break
end
end
if _found==false then
table.insert(FreeVHFFrequencies,_start)
end
_start=_start+10000
end
_start=400000
while _start<850000 do
local _found=false
for _,value in pairs(_skipFrequencies)do
if value*1000==_start then
_found=true
break
end
end
if _found==false then
table.insert(FreeVHFFrequencies,_start)
end
_start=_start+10000
end
_start=850000
while _start<=999000 do
local _found=false
for _,value in pairs(_skipFrequencies)do
if value*1000==_start then
_found=true
break
end
end
if _found==false then
table.insert(FreeVHFFrequencies,_start)
end
_start=_start+50000
end
return FreeVHFFrequencies
end
function UTILS.GenerateUHFrequencies(Start,End)
local FreeUHFFrequencies={}
local _start=220000000
if not Start then
while _start<399000000 do
if _start~=243000000 then
table.insert(FreeUHFFrequencies,_start)
end
_start=_start+500000
end
else
local myend=End*1000000 or 399000000
local mystart=Start*1000000 or 220000000
while _start<399000000 do
if _start~=243000000 and(_start<mystart or _start>myend)then
print(_start)
table.insert(FreeUHFFrequencies,_start)
end
_start=_start+500000
end
end
return FreeUHFFrequencies
end
function UTILS.GenerateLaserCodes()
local jtacGeneratedLaserCodes={}
local function ContainsDigit(_number,_numberToFind)
local _thisNumber=_number
local _thisDigit=0
while _thisNumber~=0 do
_thisDigit=_thisNumber%10
_thisNumber=math.floor(_thisNumber/10)
if _thisDigit==_numberToFind then
return true
end
end
return false
end
local _code=1111
local _count=1
while _code<1777 and _count<30 do
while true do
_code=_code+1
if not ContainsDigit(_code,8)
and not ContainsDigit(_code,9)
and not ContainsDigit(_code,0)then
table.insert(jtacGeneratedLaserCodes,_code)
break
end
end
_count=_count+1
end
return jtacGeneratedLaserCodes
end
function UTILS.EnsureTable(Object,ReturnNil)
if Object then
if type(Object)~="table"then
Object={Object}
end
else
if ReturnNil then
return nil
else
Object={}
end
end
return Object
end
function UTILS.SaveToFile(Path,Filename,Data)
if not io then
BASE:E("ERROR: io not desanitized. Can't save current file.")
return false
end
if Path==nil and not lfs then
BASE:E("WARNING: lfs not desanitized. File will be saved in DCS installation root directory rather than your \"Saved Games\\DCS\" folder.")
end
local path=nil
if lfs then
path=Path or lfs.writedir()
end
local filename=Filename
if path~=nil then
filename=path.."\\"..filename
end
local f=assert(io.open(filename,"wb"))
f:write(Data)
f:close()
return true
end
function UTILS.LoadFromFile(Path,Filename)
if not io then
BASE:E("ERROR: io not desanitized. Can't save current state.")
return false
end
if Path==nil and not lfs then
BASE:E("WARNING: lfs not desanitized. Loading will look into your DCS installation root directory rather than your \"Saved Games\\DCS\" folder.")
end
local path=nil
if lfs then
path=Path or lfs.writedir()
end
local filename=Filename
if path~=nil then
filename=path.."\\"..filename
end
local exists=UTILS.CheckFileExists(Path,Filename)
if not exists then
BASE:I(string.format("ERROR: File %s does not exist!",filename))
return false
end
local file=assert(io.open(filename,"rb"))
local loadeddata={}
for line in file:lines()do
loadeddata[#loadeddata+1]=line
end
file:close()
return true,loadeddata
end
function UTILS.CheckFileExists(Path,Filename)
local function _fileexists(name)
local f=io.open(name,"r")
if f~=nil then
io.close(f)
return true
else
return false
end
end
if not io then
BASE:E("ERROR: io not desanitized.")
return false
end
if Path==nil and not lfs then
BASE:E("WARNING: lfs not desanitized. Loading will look into your DCS installation root directory rather than your \"Saved Games\\DCS\" folder.")
end
local path=nil
if lfs then
path=Path or lfs.writedir()
end
local filename=Filename
if path~=nil then
filename=path.."\\"..filename
end
local exists=_fileexists(filename)
if not exists then
BASE:E(string.format("ERROR: File %s does not exist!",filename))
return false
else
return true
end
end
function UTILS.GetCountPerTypeName(Group)
local units=Group:GetUnits()
local TypeNameTable={}
for _,_unt in pairs(units)do
local unit=_unt
local typen=unit:GetTypeName()
if not TypeNameTable[typen]then
TypeNameTable[typen]=1
else
TypeNameTable[typen]=TypeNameTable[typen]+1
end
end
return TypeNameTable
end
function UTILS.SaveStationaryListOfGroups(List,Path,Filename,Structured)
local filename=Filename or"StateListofGroups"
local data="--Save Stationary List of Groups: "..Filename.."\n"
for _,_group in pairs(List)do
local group=GROUP:FindByName(_group)
if group and group:IsAlive()then
local units=group:CountAliveUnits()
local position=group:GetVec3()
if Structured then
local structure=UTILS.GetCountPerTypeName(group)
local strucdata=""
for typen,anzahl in pairs(structure)do
strucdata=strucdata..typen.."=="..anzahl..";"
end
data=string.format("%s%s,%d,%d,%d,%d,%s\n",data,_group,units,position.x,position.y,position.z,strucdata)
else
data=string.format("%s%s,%d,%d,%d,%d\n",data,_group,units,position.x,position.y,position.z)
end
else
data=string.format("%s%s,0,0,0,0\n",data,_group)
end
end
local outcome=UTILS.SaveToFile(Path,Filename,data)
return outcome
end
function UTILS.SaveSetOfGroups(Set,Path,Filename,Structured)
local filename=Filename or"SetOfGroups"
local data="--Save SET of groups: "..Filename.."\n"
local List=Set:GetSetObjects()
for _,_group in pairs(List)do
local group=_group
if group and group:IsAlive()then
local name=group:GetName()
local template=string.gsub(name,"-(.+)$","")
if string.find(name,"AID")then
template=string.gsub(name,"(.AID.%d+$","")
end
if string.find(template,"#")then
template=string.gsub(name,"#(%d+)$","")
end
local units=group:CountAliveUnits()
local position=group:GetVec3()
if Structured then
local structure=UTILS.GetCountPerTypeName(group)
local strucdata=""
for typen,anzahl in pairs(structure)do
strucdata=strucdata..typen.."=="..anzahl..";"
end
data=string.format("%s%s,%s,%d,%d,%d,%d,%s\n",data,name,template,units,position.x,position.y,position.z,strucdata)
else
data=string.format("%s%s,%s,%d,%d,%d,%d\n",data,name,template,units,position.x,position.y,position.z)
end
end
end
local outcome=UTILS.SaveToFile(Path,Filename,data)
return outcome
end
function UTILS.SaveSetOfStatics(Set,Path,Filename)
local filename=Filename or"SetOfStatics"
local data="--Save SET of statics: "..Filename.."\n"
local List=Set:GetSetObjects()
for _,_group in pairs(List)do
local group=_group
if group and group:IsAlive()then
local name=group:GetName()
local position=group:GetVec3()
data=string.format("%s%s,%d,%d,%d\n",data,name,position.x,position.y,position.z)
end
end
local outcome=UTILS.SaveToFile(Path,Filename,data)
return outcome
end
function UTILS.SaveStationaryListOfStatics(List,Path,Filename)
local filename=Filename or"StateListofStatics"
local data="--Save Stationary List of Statics: "..Filename.."\n"
for _,_group in pairs(List)do
local group=STATIC:FindByName(_group,false)
if group and group:IsAlive()then
local position=group:GetVec3()
data=string.format("%s%s,1,%d,%d,%d\n",data,_group,position.x,position.y,position.z)
else
data=string.format("%s%s,0,0,0,0\n",data,_group)
end
end
local outcome=UTILS.SaveToFile(Path,Filename,data)
return outcome
end
function UTILS.LoadStationaryListOfGroups(Path,Filename,Reduce,Structured,Cinematic,Effect,Density)
local fires={}
local function Smokers(name,coord,effect,density)
local eff=math.random(8)
if type(effect)=="number"then eff=effect end
coord:BigSmokeAndFire(eff,density,name)
table.insert(fires,name)
end
local function Cruncher(group,typename,anzahl)
local units=group:GetUnits()
local reduced=0
for _,_unit in pairs(units)do
local typo=_unit:GetTypeName()
if typename==typo then
if Cinematic then
local coordinate=_unit:GetCoordinate()
local name=_unit:GetName()
Smokers(name,coordinate,Effect,Density)
end
_unit:Destroy(false)
reduced=reduced+1
if reduced==anzahl then break end
end
end
end
local reduce=true
if Reduce==false then reduce=false end
local filename=Filename or"StateListofGroups"
local datatable={}
if UTILS.CheckFileExists(Path,filename)then
local outcome,loadeddata=UTILS.LoadFromFile(Path,Filename)
table.remove(loadeddata,1)
for _id,_entry in pairs(loadeddata)do
local dataset=UTILS.Split(_entry,",")
local groupname=dataset[1]
local size=tonumber(dataset[2])
local posx=tonumber(dataset[3])
local posy=tonumber(dataset[4])
local posz=tonumber(dataset[5])
local structure=dataset[6]
local coordinate=COORDINATE:NewFromVec3({x=posx,y=posy,z=posz})
local data={groupname=groupname,size=size,coordinate=coordinate,group=GROUP:FindByName(groupname)}
if reduce then
local actualgroup=GROUP:FindByName(groupname)
if actualgroup and actualgroup:IsAlive()and actualgroup:CountAliveUnits()>size then
if Structured and structure then
local loadedstructure={}
local strcset=UTILS.Split(structure,";")
for _,_data in pairs(strcset)do
local datasplit=UTILS.Split(_data,"==")
loadedstructure[datasplit[1]]=tonumber(datasplit[2])
end
local originalstructure=UTILS.GetCountPerTypeName(actualgroup)
for _name,_number in pairs(originalstructure)do
local loadednumber=0
if loadedstructure[_name]then
loadednumber=loadedstructure[_name]
end
local reduce=false
if loadednumber<_number then reduce=true end
if reduce then
Cruncher(actualgroup,_name,_number-loadednumber)
end
end
else
local reduction=actualgroup:CountAliveUnits()-size
local units=actualgroup:GetUnits()
local units2=UTILS.ShuffleTable(units)
for i=1,reduction do
units2[i]:Destroy(false)
end
end
end
end
table.insert(datatable,data)
end
else
return nil
end
return datatable,fires
end
function UTILS.LoadSetOfGroups(Path,Filename,Spawn,Structured,Cinematic,Effect,Density)
local fires={}
local usedtemplates={}
local spawn=true
if Spawn==false then spawn=false end
local filename=Filename or"SetOfGroups"
local setdata=SET_GROUP:New()
local datatable={}
local function Smokers(name,coord,effect,density)
local eff=math.random(8)
if type(effect)=="number"then eff=effect end
coord:BigSmokeAndFire(eff,density,name)
table.insert(fires,name)
end
local function Cruncher(group,typename,anzahl)
local units=group:GetUnits()
local reduced=0
for _,_unit in pairs(units)do
local typo=_unit:GetTypeName()
if typename==typo then
if Cinematic then
local coordinate=_unit:GetCoordinate()
local name=_unit:GetName()
Smokers(name,coordinate,Effect,Density)
end
_unit:Destroy(false)
reduced=reduced+1
if reduced==anzahl then break end
end
end
end
local function PostSpawn(args)
local spwndgrp=args[1]
local size=args[2]
local structure=args[3]
setdata:AddObject(spwndgrp)
local actualsize=spwndgrp:CountAliveUnits()
if actualsize>size then
if Structured and structure then
local loadedstructure={}
local strcset=UTILS.Split(structure,";")
for _,_data in pairs(strcset)do
local datasplit=UTILS.Split(_data,"==")
loadedstructure[datasplit[1]]=tonumber(datasplit[2])
end
local originalstructure=UTILS.GetCountPerTypeName(spwndgrp)
for _name,_number in pairs(originalstructure)do
local loadednumber=0
if loadedstructure[_name]then
loadednumber=loadedstructure[_name]
end
local reduce=false
if loadednumber<_number then reduce=true end
if reduce then
Cruncher(spwndgrp,_name,_number-loadednumber)
end
end
else
local reduction=actualsize-size
local units=spwndgrp:GetUnits()
local units2=UTILS.ShuffleTable(units)
for i=1,reduction do
units2[i]:Destroy(false)
end
end
end
end
local function MultiUse(Data)
local template=Data.template
if template and usedtemplates[template]and usedtemplates[template].used and usedtemplates[template].used>1 then
if not usedtemplates[template].done then
local spwnd=0
local spawngrp=SPAWN:New(template)
spawngrp:InitLimit(0,usedtemplates[template].used)
for _,_entry in pairs(usedtemplates[template].data)do
spwnd=spwnd+1
local sgrp=spawngrp:SpawnFromCoordinate(_entry.coordinate,spwnd)
BASE:ScheduleOnce(0.5,PostSpawn,{sgrp,_entry.size,_entry.structure})
end
usedtemplates[template].done=true
end
return true
else
return false
end
end
if UTILS.CheckFileExists(Path,filename)then
local outcome,loadeddata=UTILS.LoadFromFile(Path,Filename)
table.remove(loadeddata,1)
for _id,_entry in pairs(loadeddata)do
local dataset=UTILS.Split(_entry,",")
local groupname=dataset[1]
local template=dataset[2]
local size=tonumber(dataset[3])
local posx=tonumber(dataset[4])
local posy=tonumber(dataset[5])
local posz=tonumber(dataset[6])
local structure=dataset[7]
local coordinate=COORDINATE:NewFromVec3({x=posx,y=posy,z=posz})
local group=nil
if size>0 then
local data={groupname=groupname,size=size,coordinate=coordinate,template=template,structure=structure}
table.insert(datatable,data)
if usedtemplates[template]then
usedtemplates[template].used=usedtemplates[template].used+1
table.insert(usedtemplates[template].data,data)
else
usedtemplates[template]={
data={},
used=1,
done=false,
}
table.insert(usedtemplates[template].data,data)
end
end
end
for _id,_entry in pairs(datatable)do
if spawn and not MultiUse(_entry)and _entry.size>0 then
local group=SPAWN:New(_entry.template)
local sgrp=group:SpawnFromCoordinate(_entry.coordinate)
BASE:ScheduleOnce(0.5,PostSpawn,{sgrp,_entry.size,_entry.structure})
end
end
else
return nil
end
if spawn then
return setdata,fires
else
return datatable
end
end
function UTILS.LoadSetOfStatics(Path,Filename)
local filename=Filename or"SetOfStatics"
local datatable=SET_STATIC:New()
if UTILS.CheckFileExists(Path,filename)then
local outcome,loadeddata=UTILS.LoadFromFile(Path,Filename)
table.remove(loadeddata,1)
for _id,_entry in pairs(loadeddata)do
local dataset=UTILS.Split(_entry,",")
local staticname=dataset[1]
local StaticObject=STATIC:FindByName(staticname,false)
if StaticObject then
datatable:AddObject(StaticObject)
end
end
else
return nil
end
return datatable
end
function UTILS.LoadStationaryListOfStatics(Path,Filename,Reduce,Dead,Cinematic,Effect,Density)
local fires={}
local reduce=true
if Reduce==false then reduce=false end
local filename=Filename or"StateListofStatics"
local datatable={}
if UTILS.CheckFileExists(Path,filename)then
local outcome,loadeddata=UTILS.LoadFromFile(Path,Filename)
table.remove(loadeddata,1)
for _id,_entry in pairs(loadeddata)do
local dataset=UTILS.Split(_entry,",")
local staticname=dataset[1]
local size=tonumber(dataset[2])
local posx=tonumber(dataset[3])
local posy=tonumber(dataset[4])
local posz=tonumber(dataset[5])
local coordinate=COORDINATE:NewFromVec3({x=posx,y=posy,z=posz})
local data={staticname=staticname,size=size,coordinate=coordinate,static=STATIC:FindByName(staticname,false)}
table.insert(datatable,data)
if size==0 and reduce then
local static=STATIC:FindByName(staticname,false)
if static then
if Dead then
local deadobject=SPAWNSTATIC:NewFromStatic(staticname,static:GetCountry())
deadobject:InitDead(true)
local heading=static:GetHeading()
local coord=static:GetCoordinate()
static:Destroy(false)
deadobject:SpawnFromCoordinate(coord,heading,staticname)
if Cinematic then
local effect=math.random(8)
if type(Effect)=="number"then
effect=Effect
end
coord:BigSmokeAndFire(effect,Density,staticname)
table.insert(fires,staticname)
end
else
static:Destroy(false)
end
end
end
end
else
return nil
end
return datatable,fires
end
function UTILS.BearingToCardinal(Heading)
if Heading>=0 and Heading<=22 then return"North"
elseif Heading>=23 and Heading<=66 then return"North-East"
elseif Heading>=67 and Heading<=101 then return"East"
elseif Heading>=102 and Heading<=146 then return"South-East"
elseif Heading>=147 and Heading<=201 then return"South"
elseif Heading>=202 and Heading<=246 then return"South-West"
elseif Heading>=247 and Heading<=291 then return"West"
elseif Heading>=292 and Heading<=338 then return"North-West"
elseif Heading>=339 then return"North"
end
end
function UTILS.ToStringBRAANATO(FromGrp,ToGrp)
local BRAANATO="Merged."
local GroupNumber=ToGrp:GetSize()
local GroupWords="Singleton"
if GroupNumber==2 then GroupWords="Two-Ship"
elseif GroupNumber>=3 then GroupWords="Heavy"
end
local grpLeadUnit=ToGrp:GetUnit(1)
local tgtCoord=grpLeadUnit:GetCoordinate()
local currentCoord=FromGrp:GetCoordinate()
local hdg=UTILS.Round(ToGrp:GetHeading()/100,1)*100
local bearing=UTILS.Round(currentCoord:HeadingTo(tgtCoord),0)
local rangeMetres=tgtCoord:Get2DDistance(currentCoord)
local rangeNM=UTILS.Round(UTILS.MetersToNM(rangeMetres),0)
local aspect=tgtCoord:ToStringAspect(currentCoord)
local alt=UTILS.Round(UTILS.MetersToFeet(grpLeadUnit:GetAltitude())/1000,0)
local track=UTILS.BearingToCardinal(hdg)
if rangeNM>3 then
if aspect==""then
BRAANATO=string.format("%s, BRA, %03d, %d miles, Angels %d, Track %s",GroupWords,bearing,rangeNM,alt,track)
else
BRAANATO=string.format("%s, BRAA, %03d, %d miles, Angels %d, %s, Track %s",GroupWords,bearing,rangeNM,alt,aspect,track)
end
end
return BRAANATO
end
function UTILS.IsInTable(Table,Object,Key)
for key,object in pairs(Table)do
if Key then
if Object[Key]==object[Key]then
return true
end
else
if object==Object then
return true
end
end
end
return false
end
function UTILS.IsAnyInTable(Table,Objects,Key)
for _,Object in pairs(UTILS.EnsureTable(Objects))do
for key,object in pairs(Table)do
if Key then
if Object[Key]==object[Key]then
return true
end
else
if object==Object then
return true
end
end
end
end
return false
end
function UTILS.PlotRacetrack(Coordinate,Altitude,Speed,Heading,Leg,Coalition,Color,Alpha,LineType,ReadOnly)
local fix_coordinate=Coordinate
local altitude=Altitude
local speed=Speed or 350
local heading=Heading or 270
local leg_distance=Leg or 10
local coalition=Coalition or-1
local color=Color or{1,0,0}
local alpha=Alpha or 1
local lineType=LineType or 1
speed=UTILS.IasToTas(speed,UTILS.FeetToMeters(altitude),oatcorr)
local turn_radius=0.0211*speed-3.01
local point_two=fix_coordinate:Translate(UTILS.NMToMeters(leg_distance),heading,true,false)
local point_three=point_two:Translate(UTILS.NMToMeters(turn_radius)*2,heading-90,true,false)
local point_four=fix_coordinate:Translate(UTILS.NMToMeters(turn_radius)*2,heading-90,true,false)
local circle_center_fix_four=point_two:Translate(UTILS.NMToMeters(turn_radius),heading-90,true,false)
local circle_center_two_three=fix_coordinate:Translate(UTILS.NMToMeters(turn_radius),heading-90,true,false)
fix_coordinate:LineToAll(point_two,coalition,color,alpha,lineType)
point_four:LineToAll(point_three,coalition,color,alpha,lineType)
circle_center_fix_four:CircleToAll(UTILS.NMToMeters(turn_radius),coalition,color,alpha,nil,0,lineType)
circle_center_two_three:CircleToAll(UTILS.NMToMeters(turn_radius),coalition,color,alpha,nil,0,lineType)
end
function UTILS.TimeNow()
return UTILS.SecondsToClock(timer.getAbsTime(),false,false)
end
function UTILS.TimeDifferenceInSeconds(start_time,end_time)
return UTILS.ClockToSeconds(end_time)-UTILS.ClockToSeconds(start_time)
end
function UTILS.TimeLaterThan(time_string)
if timer.getAbsTime()>UTILS.ClockToSeconds(time_string)then
return true
end
return false
end
function UTILS.TimeBefore(time_string)
if timer.getAbsTime()<UTILS.ClockToSeconds(time_string)then
return true
end
return false
end
function UTILS.CombineTimeStrings(time_string_01,time_string_02)
local hours1,minutes1,seconds1=time_string_01:match("(%d+):(%d+):(%d+)")
local hours2,minutes2,seconds2=time_string_02:match("(%d+):(%d+):(%d+)")
local total_seconds=tonumber(seconds1)+tonumber(seconds2)+tonumber(minutes1)*60+tonumber(minutes2)*60+tonumber(hours1)*3600+tonumber(hours2)*3600
total_seconds=total_seconds%(24*3600)
if total_seconds<0 then
total_seconds=total_seconds+24*3600
end
local hours=math.floor(total_seconds/3600)
total_seconds=total_seconds-hours*3600
local minutes=math.floor(total_seconds/60)
local seconds=total_seconds%60
return string.format("%02d:%02d:%02d",hours,minutes,seconds)
end
function UTILS.SubtractTimeStrings(time_string_01,time_string_02)
local hours1,minutes1,seconds1=time_string_01:match("(%d+):(%d+):(%d+)")
local hours2,minutes2,seconds2=time_string_02:match("(%d+):(%d+):(%d+)")
local total_seconds=tonumber(seconds1)-tonumber(seconds2)+tonumber(minutes1)*60-tonumber(minutes2)*60+tonumber(hours1)*3600-tonumber(hours2)*3600
total_seconds=total_seconds%(24*3600)
if total_seconds<0 then
total_seconds=total_seconds+24*3600
end
local hours=math.floor(total_seconds/3600)
total_seconds=total_seconds-hours*3600
local minutes=math.floor(total_seconds/60)
local seconds=total_seconds%60
return string.format("%02d:%02d:%02d",hours,minutes,seconds)
end
function UTILS.TimeBetween(start_time,end_time)
return UTILS.TimeLaterThan(start_time)and UTILS.TimeBefore(end_time)
end
function UTILS.PercentageChance(chance)
chance=chance or math.random(0,100)
chance=UTILS.Clamp(chance,0,100)
local percentage=math.random(0,100)
if percentage<chance then
return true
end
return false
end
function UTILS.Clamp(value,min,max)
if value<min then value=min end
if value>max then value=max end
return value
end
function UTILS.ClampAngle(value)
if value>360 then return value-360 end
if value<0 then return value+360 end
return value
end
function UTILS.RemapValue(value,old_min,old_max,new_min,new_max)
new_min=new_min or 0
new_max=new_max or 100
local old_range=old_max-old_min
local new_range=new_max-new_min
local percentage=(value-old_min)/old_range
return(new_range*percentage)+new_min
end
function UTILS.RandomPointInTriangle(pt1,pt2,pt3)
local pt={math.random(),math.random()}
table.sort(pt)
local s=pt[1]
local t=pt[2]-pt[1]
local u=1-pt[2]
return{x=s*pt1.x+t*pt2.x+u*pt3.x,
y=s*pt1.y+t*pt2.y+u*pt3.y}
end
function UTILS.AngleBetween(angle,min,max)
angle=(360+(angle%360))%360
min=(360+min%360)%360
max=(360+max%360)%360
if min<max then return min<=angle and angle<=max end
return min<=angle or angle<=max
end
function UTILS.WriteJSON(data,file_path)
package.path=package.path..";.\\Scripts\\?.lua"
local JSON=require("json")
local pretty_json_text=JSON:encode_pretty(data)
local write_file=io.open(file_path,"w")
write_file:write(pretty_json_text)
write_file:close()
end
function UTILS.ReadJSON(file_path)
package.path=package.path..";.\\Scripts\\?.lua"
local JSON=require("json")
local read_file=io.open(file_path,"r")
local contents=read_file:read("*a")
io.close(read_file)
return JSON:decode(contents)
end
function UTILS.GetZoneProperties(zone_name)
local return_table={}
for _,zone in pairs(env.mission.triggers.zones)do
if zone["name"]==zone_name then
if table.length(zone["properties"])>0 then
for _,property in pairs(zone["properties"])do
return_table[property["key"]]=property["value"]
end
return return_table
else
BASE:I(string.format("%s doesn't have any properties",zone_name))
return{}
end
end
end
end
function UTILS.RotatePointAroundPivot(point,pivot,angle)
local radians=math.rad(angle)
local x=point.x-pivot.x
local y=point.y-pivot.y
local rotated_x=x*math.cos(radians)-y*math.sin(radians)
local rotatex_y=x*math.sin(radians)+y*math.cos(radians)
local original_x=rotated_x+pivot.x
local original_y=rotatex_y+pivot.y
return{x=original_x,y=original_y}
end
function UTILS.UniqueName(base)
base=base or""
local ran=tostring(math.random(0,1000000))
if base==""then
return ran
end
return base.."_"..ran
end
function string.startswith(str,value)
return string.sub(str,1,string.len(value))==value
end
function string.endswith(str,value)
return value==""or str:sub(-#value)==value
end
function string.split(input,separator)
local parts={}
for part in input:gmatch("[^"..separator.."]+")do
table.insert(parts,part)
end
return parts
end
function string.contains(str,value)
return string.match(str,value)
end
function table.move_object(obj,from_table,to_table)
local index
for i,v in pairs(from_table)do
if v==obj then
index=i
end
end
if index then
local moved=table.remove(from_table,index)
table.insert_unique(to_table,moved)
end
end
function table.contains(tbl,element)
if element==nil or tbl==nil then return false end
local index=1
while tbl[index]do
if tbl[index]==element then
return true
end
index=index+1
end
return false
end
function table.contains_key(tbl,key)
if tbl[key]~=nil then return true else return false end
end
function table.insert_unique(tbl,element)
if element==nil or tbl==nil then return end
if not table.contains(tbl,element)then
table.insert(tbl,element)
end
end
function table.remove_by_value(tbl,element)
local indices_to_remove={}
local index=1
for _,value in pairs(tbl)do
if value==element then
table.insert(indices_to_remove,index)
end
index=index+1
end
for _,idx in pairs(indices_to_remove)do
table.remove(tbl,idx)
end
end
function table.remove_key(table,key)
local element=table[key]
table[key]=nil
return element
end
function table.index_of(table,element)
for i,v in ipairs(table)do
if v==element then
return i
end
end
return nil
end
function table.length(T)
local count=0
for _ in pairs(T)do count=count+1 end
return count
end
function table.slice(tbl,first,last)
local sliced={}
local start=first or 1
local stop=last or table.length(tbl)
local count=1
for key,value in pairs(tbl)do
if count>=start and count<=stop then
sliced[key]=value
end
count=count+1
end
return sliced
end
function table.count_value(tbl,value)
local count=0
for _,item in pairs(tbl)do
if item==value then count=count+1 end
end
return count
end
function table.combine(t1,t2)
if t1==nil and t2==nil then
BASE:E("Both tables were empty!")
end
if t1==nil then return t2 end
if t2==nil then return t1 end
for i=1,#t2 do
t1[#t1+1]=t2[i]
end
return t1
end
function table.merge(t1,t2)
for k,v in pairs(t2)do
if(type(v)=="table")and(type(t1[k]or false)=="table")then
table.merge(t1[k],t2[k])
else
t1[k]=v
end
end
return t1
end
function table.add(tbl,item)
tbl[#tbl+1]=item
end
function table.shuffle(tbl)
local new_table={}
for _,value in ipairs(tbl)do
local pos=math.random(1,#new_table+1)
table.insert(new_table,pos,value)
end
return new_table
end
function table.find_key_value_pair(tbl,key,value)
for k,v in pairs(tbl)do
if type(v)=="table"then
local result=table.find_key_value_pair(v,key,value)
if result~=nil then
return result
end
elseif k==key and v==value then
return tbl
end
end
return nil
end
function UTILS.DecimalToOctal(Number)
if Number<8 then return Number end
local number=tonumber(Number)
local octal=""
local n=1
while number>7 do
local number1=number%8
octal=string.format("%d",number1)..octal
local number2=math.abs(number/8)
if number2<8 then
octal=string.format("%d",number2)..octal
end
number=number2
n=n+1
end
return tonumber(octal)
end
function UTILS.OctalToDecimal(Number)
return tonumber(Number,8)
end
function UTILS.HexToRGBA(hex_string)
local hexNumber=tonumber(string.sub(hex_string,3),16)
local alpha=hexNumber%256
hexNumber=(hexNumber-alpha)/256
local blue=hexNumber%256
hexNumber=(hexNumber-blue)/256
local green=hexNumber%256
hexNumber=(hexNumber-green)/256
local red=hexNumber%256
return{R=red,G=green,B=blue,A=alpha}
end
function UTILS.SaveSetOfOpsGroups(Set,Path,Filename,Structured)
local filename=Filename or"SetOfGroups"
local data="--Save SET of groups: (name,legion,template,alttemplate,units,position.x,position.y,position.z,strucdata) "..Filename.."\n"
local List=Set:GetSetObjects()
for _,_group in pairs(List)do
local group=_group:GetGroup()
if group and group:IsAlive()then
local name=group:GetName()
local template=string.gsub(name,"(.AID.%d+$","")
if string.find(template,"#")then
template=string.gsub(name,"#(%d+)$","")
end
local alttemplate=_group.templatename or"none"
local legiono=_group.legion
local legion="none"
if legiono and type(legiono)=="table"and legiono.ClassName then
legion=legiono:GetName()
local asset=legiono:GetAssetByName(name)
alttemplate=asset.templatename
end
local units=group:CountAliveUnits()
local position=group:GetVec3()
if Structured then
local structure=UTILS.GetCountPerTypeName(group)
local strucdata=""
for typen,anzahl in pairs(structure)do
strucdata=strucdata..typen.."=="..anzahl..";"
end
data=string.format("%s%s,%s,%s,%s,%d,%d,%d,%d,%s\n",data,name,legion,template,alttemplate,units,position.x,position.y,position.z,strucdata)
else
data=string.format("%s%s,%s,%s,%s,%d,%d,%d,%d\n",data,name,legion,template,alttemplate,units,position.x,position.y,position.z)
end
end
end
local outcome=UTILS.SaveToFile(Path,Filename,data)
return outcome
end
function UTILS.LoadSetOfOpsGroups(Path,Filename)
local filename=Filename or"SetOfGroups"
local datatable={}
if UTILS.CheckFileExists(Path,filename)then
local outcome,loadeddata=UTILS.LoadFromFile(Path,Filename)
table.remove(loadeddata,1)
for _id,_entry in pairs(loadeddata)do
local dataset=UTILS.Split(_entry,",")
local groupname=dataset[1]
local legion=dataset[2]
local template=dataset[3]
local alttemplate=dataset[4]
local size=tonumber(dataset[5])
local posx=tonumber(dataset[6])
local posy=tonumber(dataset[7])
local posz=tonumber(dataset[8])
local structure=dataset[9]
local coordinate=COORDINATE:NewFromVec3({x=posx,y=posy,z=posz})
if size>0 then
local data={groupname=groupname,size=size,coordinate=coordinate,template=template,structure=structure,legion=legion,alttemplate=alttemplate}
table.insert(datatable,data)
end
end
else
return nil
end
return datatable
end
function UTILS.ClockHeadingString(refHdg,tgtHdg)
local relativeAngle=tgtHdg-refHdg
if relativeAngle<0 then
relativeAngle=relativeAngle+360
end
local clockPos=math.ceil((relativeAngle%360)/30)
return clockPos.." o'clock"
end
function UTILS.MGRSStringToSRSFriendly(Text,Slow)
local Text=string.gsub(Text,"MGRS ","")
Text=string.gsub(Text,"%s+","")
Text=string.gsub(Text,"([%a%d])","%1;")
Text=string.gsub(Text,"A","Alpha")
Text=string.gsub(Text,"B","Bravo")
Text=string.gsub(Text,"C","Charlie")
Text=string.gsub(Text,"D","Delta")
Text=string.gsub(Text,"E","Echo")
Text=string.gsub(Text,"F","Foxtrot")
Text=string.gsub(Text,"G","Golf")
Text=string.gsub(Text,"H","Hotel")
Text=string.gsub(Text,"I","India")
Text=string.gsub(Text,"J","Juliett")
Text=string.gsub(Text,"K","Kilo")
Text=string.gsub(Text,"L","Lima")
Text=string.gsub(Text,"M","Mike")
Text=string.gsub(Text,"N","November")
Text=string.gsub(Text,"O","Oscar")
Text=string.gsub(Text,"P","Papa")
Text=string.gsub(Text,"Q","Quebec")
Text=string.gsub(Text,"R","Romeo")
Text=string.gsub(Text,"S","Sierra")
Text=string.gsub(Text,"T","Tango")
Text=string.gsub(Text,"U","Uniform")
Text=string.gsub(Text,"V","Victor")
Text=string.gsub(Text,"W","Whiskey")
Text=string.gsub(Text,"X","Xray")
Text=string.gsub(Text,"Y","Yankee")
Text=string.gsub(Text,"Z","Zulu")
Text=string.gsub(Text,"0","zero")
Text=string.gsub(Text,"9","niner")
if Slow then
Text='<prosody rate="slow">'..Text..'</prosody>'
end
Text="MGRS;"..Text
return Text
end
function UTILS.ReadCSV(filename)
if not UTILS.FileExists(filename)then
env.error("File does not exist")
return nil
end
local function _loadfile(filename)
local f=io.open(filename,"rb")
if f then
local data=f:read("*all")
f:close()
return data
else
BASE:E(string.format("WARNING: Could read data from file %s!",tostring(filename)))
return nil
end
end
local data=_loadfile(filename)
local lines=UTILS.Split(data,"\n")
for _,line in pairs(lines)do
line=string.gsub(line,"[\n\r]","")
end
local sep=";"
local columns=UTILS.Split(lines[1],sep)
table.remove(lines,1)
local csvdata={}
for i,line in pairs(lines)do
line=string.gsub(line,"[\n\r]","")
local row={}
for j,value in pairs(UTILS.Split(line,sep))do
local key=string.gsub(columns[j],"[\n\r]","")
row[key]=value
end
table.insert(csvdata,row)
end
return csvdata
end
function UTILS.LCGRandomSeed(seed)
UTILS.lcg={
seed=seed or math.random(1,2^32-1),
a=1664525,
c=1013904223,
m=2^32
}
end
function UTILS.LCGRandom()
if UTILS.lcg==nil then
UTILS.LCGRandomSeed()
end
UTILS.lcg.seed=(UTILS.lcg.a*UTILS.lcg.seed+UTILS.lcg.c)%UTILS.lcg.m
return UTILS.lcg.seed/UTILS.lcg.m
end
function UTILS.SpawnFARPAndFunctionalStatics(Name,Coordinate,FARPType,Coalition,Country,CallSign,Frequency,Modulation,ADF,SpawnRadius,VehicleTemplate,Liquids,Equipment)
local farplocation=Coordinate
local farptype=FARPType or ENUMS.FARPType.FARP
local Coalition=Coalition or coalition.side.BLUE
local callsign=CallSign or CALLSIGN.FARP.Berlin
local freq=Frequency or 127.5
local mod=Modulation or radio.modulation.AM
local radius=SpawnRadius or 100
if radius<0 or radius>150 then radius=100 end
local liquids=Liquids or 10
liquids=liquids*1000
local equip=Equipment or 10
local statictypes=ENUMS.FARPObjectTypeNamesAndShape[farptype]or{TypeName="FARP",ShapeName="FARPS"}
local STypeName=statictypes.TypeName
local SShapeName=statictypes.ShapeName
local Country=Country or(Coalition==coalition.side.BLUE and country.id.USA or country.id.RUSSIA)
local ReturnObjects={}
local newfarp=SPAWNSTATIC:NewFromType(STypeName,"Heliports",Country)
newfarp:InitShape(SShapeName)
newfarp:InitFARP(callsign,freq,mod)
local spawnedfarp=newfarp:SpawnFromCoordinate(farplocation,0,Name)
table.insert(ReturnObjects,spawnedfarp)
local FARPStaticObjectsNato={
["FUEL"]={TypeName="FARP Fuel Depot",ShapeName="GSM Rus",Category="Fortifications"},
["AMMO"]={TypeName="FARP Ammo Dump Coating",ShapeName="SetkaKP",Category="Fortifications"},
["TENT"]={TypeName="FARP Tent",ShapeName="PalatkaB",Category="Fortifications"},
["WINDSOCK"]={TypeName="Windsock",ShapeName="H-Windsock_RW",Category="Fortifications"},
}
local farpobcount=0
for _name,_object in pairs(FARPStaticObjectsNato)do
local objloc=farplocation:Translate(radius,farpobcount*30)
local heading=objloc:HeadingTo(farplocation)
local newobject=SPAWNSTATIC:NewFromType(_object.TypeName,_object.Category,Country)
newobject:InitShape(_object.ShapeName)
newobject:InitHeading(heading)
newobject:SpawnFromCoordinate(objloc,farpobcount*30,_name.." - "..Name)
table.insert(ReturnObjects,newobject)
farpobcount=farpobcount+1
end
if VehicleTemplate and type(VehicleTemplate)=="string"then
local vcoordinate=farplocation:Translate(radius,farpobcount*30)
local heading=vcoordinate:HeadingTo(farplocation)
local vehicles=SPAWN:NewWithAlias(VehicleTemplate,"FARP Vehicles - "..Name)
vehicles:InitGroupHeading(heading)
vehicles:InitCountry(Country)
vehicles:InitCoalition(Coalition)
vehicles:InitDelayOff()
local spawnedvehicle=vehicles:SpawnFromCoordinate(vcoordinate)
table.insert(ReturnObjects,spawnedvehicle)
end
local newWH=STORAGE:New(Name)
if liquids and liquids>0 then
newWH:SetLiquid(STORAGE.Liquid.DIESEL,liquids)
newWH:SetLiquid(STORAGE.Liquid.GASOLINE,liquids)
newWH:SetLiquid(STORAGE.Liquid.JETFUEL,liquids)
newWH:SetLiquid(STORAGE.Liquid.MW50,liquids)
end
if equip and equip>0 then
for cat,nitem in pairs(ENUMS.Storage.weapons)do
for name,item in pairs(nitem)do
newWH:SetItem(item,equip)
end
end
end
local ADFName
if ADF and type(ADF)=="number"then
local ADFFreq=ADF*1000
local Sound="l10n/DEFAULT/beacon.ogg"
local vec3=farplocation:GetVec3()
ADFName=Name.." ADF "..tostring(ADF).."KHz"
trigger.action.radioTransmission(Sound,vec3,0,true,ADFFreq,250,ADFName)
end
return ReturnObjects,ADFName
end
function UTILS.Vec2toVec3(vec,y)
if not vec.z then
if vec.alt and not y then
y=vec.alt
elseif not y then
y=0
end
return{x=vec.x,y=y,z=vec.y}
else
return{x=vec.x,y=vec.y,z=vec.z}
end
end
function UTILS.GetNorthCorrection(gPoint)
local point=UTILS.DeepCopy(gPoint)
if not point.z then
point.z=point.y
point.y=0
end
local lat,lon=coord.LOtoLL(point)
local north_posit=coord.LLtoLO(lat+1,lon)
return math.atan2(north_posit.z-point.z,north_posit.x-point.x)
end
function UTILS.GetDHMS(timeInSec)
if timeInSec and type(timeInSec)=='number'then
local tbl={d=0,h=0,m=0,s=0}
if timeInSec>86400 then
while timeInSec>86400 do
tbl.d=tbl.d+1
timeInSec=timeInSec-86400
end
end
if timeInSec>3600 then
while timeInSec>3600 do
tbl.h=tbl.h+1
timeInSec=timeInSec-3600
end
end
if timeInSec>60 then
while timeInSec>60 do
tbl.m=tbl.m+1
timeInSec=timeInSec-60
end
end
tbl.s=timeInSec
return tbl
else
BASE:E("No number handed!")
return
end
end
function UTILS.GetDirectionRadians(vec,point)
local dir=math.atan2(vec.z,vec.x)
if point then
dir=dir+UTILS.GetNorthCorrection(point)
end
if dir<0 then
dir=dir+2*math.pi
end
return dir
end
function UTILS.IsPointInPolygon(point,poly,maxalt)
point=UTILS.Vec2toVec3(point)
local px=point.x
local pz=point.z
local cn=0
local newpoly=UTILS.DeepCopy(poly)
if not maxalt or(point.y<=maxalt)then
local polysize=#newpoly
newpoly[#newpoly+1]=newpoly[1]
newpoly[1]=UTILS.Vec2toVec3(newpoly[1])
for k=1,polysize do
newpoly[k+1]=UTILS.Vec2toVec3(newpoly[k+1])
if((newpoly[k].z<=pz)and(newpoly[k+1].z>pz))or((newpoly[k].z>pz)and(newpoly[k+1].z<=pz))then
local vt=(pz-newpoly[k].z)/(newpoly[k+1].z-newpoly[k].z)
if(px<newpoly[k].x+vt*(newpoly[k+1].x-newpoly[k].x))then
cn=cn+1
end
end
end
return cn%2==1
else
return false
end
end
function UTILS.ScalarMult(vec,mult)
return{x=vec.x*mult,y=vec.y*mult,z=vec.z*mult}
end
UTILS.Weather={}
function UTILS.Weather.GetFogThickness()
return world.weather.getFogThickness()
end
function UTILS.Weather.SetFogThickness(Thickness)
local value=Thickness
if value<100 then value=100
elseif value>5000 then value=5000 end
return world.weather.setFogThickness(value)
end
function UTILS.Weather.RemoveFog()
return world.weather.setFogThickness(0)
end
function UTILS.Weather.GetFogVisibilityDistanceMax()
return world.weather.getFogVisibilityDistance()
end
function UTILS.Weather.SetFogVisibilityDistance(Thickness)
local value=Thickness
if value<100 then value=100
elseif value>100000 then value=100000 end
return world.weather.setFogVisibilityDistance(value)
end
function UTILS.Weather.SetFogAnimation(AnimationKeys)
return world.weather.setFogAnimation(AnimationKeys)
end
function UTILS.Weather.StopFogAnimation()
return world.weather.setFogAnimation({})
end
PROFILER={
ClassName="PROFILER",
Counters={},
dInfo={},
fTime={},
fTimeTotal={},
eventHandler={},
logUnknown=false,
ThreshCPS=0.0,
ThreshTtot=0.005,
fileNamePrefix="MooseProfiler",
fileNameSuffix="txt"
}
function PROFILER.Start(Delay,Duration)
local go=true
if not os then
env.error("ERROR: Profiler needs os to be de-sanitized!")
go=false
end
if not io then
env.error("ERROR: Profiler needs io to be desanitized!")
go=false
end
if not lfs then
env.error("ERROR: Profiler needs lfs to be desanitized!")
go=false
end
if not go then
return
end
if Delay and Delay>0 then
BASE:ScheduleOnce(Delay,PROFILER.Start,0,Duration)
else
PROFILER.TstartGame=timer.getTime()
PROFILER.TstartOS=os.clock()
world.addEventHandler(PROFILER.eventHandler)
env.info('############################   Profiler Started   ############################')
if Duration then
env.info(string.format("- Will be running for %d seconds",Duration))
else
env.info(string.format("- Will be stopped when mission ends"))
end
env.info(string.format("- Calls per second threshold %.3f/sec",PROFILER.ThreshCPS))
env.info(string.format("- Total function time threshold %.3f sec",PROFILER.ThreshTtot))
env.info(string.format("- Output file \"%s\" in your DCS log file folder",PROFILER.getfilename(PROFILER.fileNameSuffix)))
env.info(string.format("- Output file \"%s\" in CSV format",PROFILER.getfilename("csv")))
env.info('###############################################################################')
local duration=Duration or 600
trigger.action.outText("### Profiler running ###",duration)
debug.sethook(PROFILER.hook,"cr")
if Duration then
PROFILER.Stop(Duration)
end
end
end
function PROFILER.Stop(Delay)
if Delay and Delay>0 then
BASE:ScheduleOnce(Delay,PROFILER.Stop)
end
end
function PROFILER.Stop(Delay)
if Delay and Delay>0 then
BASE:ScheduleOnce(Delay,PROFILER.Stop)
else
debug.sethook()
local runTimeGame=timer.getTime()-PROFILER.TstartGame
local runTimeOS=os.clock()-PROFILER.TstartOS
PROFILER.showInfo(runTimeGame,runTimeOS)
end
end
function PROFILER.eventHandler:onEvent(event)
if event.id==world.event.S_EVENT_MISSION_END then
PROFILER.Stop()
end
end
function PROFILER.hook(event)
local f=debug.getinfo(2,"f").func
if event=='call'then
if PROFILER.Counters[f]==nil then
PROFILER.Counters[f]=1
PROFILER.dInfo[f]=debug.getinfo(2,"Sn")
if PROFILER.fTimeTotal[f]==nil then
PROFILER.fTimeTotal[f]=0
end
else
PROFILER.Counters[f]=PROFILER.Counters[f]+1
end
if PROFILER.fTime[f]==nil then
PROFILER.fTime[f]=os.clock()
end
elseif(event=='return')then
if PROFILER.fTime[f]~=nil then
PROFILER.fTimeTotal[f]=PROFILER.fTimeTotal[f]+(os.clock()-PROFILER.fTime[f])
PROFILER.fTime[f]=nil
end
end
end
function PROFILER.getData(func)
local n=PROFILER.dInfo[func]
if n.what=="C"then
return n.name,"?","?",PROFILER.fTimeTotal[func]
end
return n.name,n.short_src,n.linedefined,PROFILER.fTimeTotal[func]
end
function PROFILER._flog(f,txt)
f:write(txt.."\r\n")
end
function PROFILER.showTable(data,f,runTimeGame)
for i=1,#data do
local t=data[i]
local cps=t.count/runTimeGame
local threshCPS=cps>=PROFILER.ThreshCPS
local threshTot=t.tm>=PROFILER.ThreshTtot
if threshCPS and threshTot then
local text=string.format("%30s: %8d calls %8.1f/sec - Time Total %8.3f sec (%.3f %%) %5.3f sec/call  %s line %s",t.func,t.count,cps,t.tm,t.tm/runTimeGame*100,t.tm/t.count,tostring(t.src),tostring(t.line))
PROFILER._flog(f,text)
end
end
end
function PROFILER.printCSV(data,runTimeGame)
local file=PROFILER.getfilename("csv")
local g=io.open(file,'w')
local text="Function,Total Calls,Calls per Sec,Total Time,Total in %,Sec per Call,Source File;Line Number,"
g:write(text.."\r\n")
for i=1,#data do
local t=data[i]
local cps=t.count/runTimeGame
local txt=string.format("%s,%d,%.1f,%.3f,%.3f,%.3f,%s,%s,",t.func,t.count,cps,t.tm,t.tm/runTimeGame*100,t.tm/t.count,tostring(t.src),tostring(t.line))
g:write(txt.."\r\n")
end
g:close()
end
function PROFILER.getfilename(ext)
local dir=lfs.writedir()..[[Logs\]]
ext=ext or PROFILER.fileNameSuffix
local file=dir..PROFILER.fileNamePrefix.."."..ext
if not UTILS.FileExists(file)then
return file
end
for i=1,999 do
local file=string.format("%s%s-%03d.%s",dir,PROFILER.fileNamePrefix,i,ext)
if not UTILS.FileExists(file)then
return file
end
end
end
function PROFILER.showInfo(runTimeGame,runTimeOS)
local file=PROFILER.getfilename(PROFILER.fileNameSuffix)
local f=io.open(file,'w')
local Ttot=0
local Calls=0
local t={}
local tcopy=nil
local tserialize=nil
local tforgen=nil
local tpairs=nil
for func,count in pairs(PROFILER.Counters)do
local s,src,line,tm=PROFILER.getData(func)
if PROFILER.logUnknown==true then
if s==nil then s="<Unknown>"end
end
if s~=nil then
local T=
{func=s,
src=src,
line=line,
count=count,
tm=tm,
}
if s=="_copy"then
if tcopy==nil then
tcopy=T
else
tcopy.count=tcopy.count+T.count
tcopy.tm=tcopy.tm+T.tm
end
elseif s=="_Serialize"then
if tserialize==nil then
tserialize=T
else
tserialize.count=tserialize.count+T.count
tserialize.tm=tserialize.tm+T.tm
end
elseif s=="(for generator)"then
if tforgen==nil then
tforgen=T
else
tforgen.count=tforgen.count+T.count
tforgen.tm=tforgen.tm+T.tm
end
elseif s=="pairs"then
if tpairs==nil then
tpairs=T
else
tpairs.count=tpairs.count+T.count
tpairs.tm=tpairs.tm+T.tm
end
else
table.insert(t,T)
end
Ttot=Ttot+tm
Calls=Calls+count
end
end
if tcopy then
table.insert(t,tcopy)
end
if tserialize then
table.insert(t,tserialize)
end
if tforgen then
table.insert(t,tforgen)
end
if tpairs then
table.insert(t,tpairs)
end
env.info('############################   Profiler Stopped   ############################')
env.info(string.format("* Runtime Game     : %s = %d sec",UTILS.SecondsToClock(runTimeGame,true),runTimeGame))
env.info(string.format("* Runtime Real     : %s = %d sec",UTILS.SecondsToClock(runTimeOS,true),runTimeOS))
env.info(string.format("* Function time    : %s = %.1f sec (%.1f percent of runtime game)",UTILS.SecondsToClock(Ttot,true),Ttot,Ttot/runTimeGame*100))
env.info(string.format("* Total functions  : %d",#t))
env.info(string.format("* Total func calls : %d",Calls))
env.info(string.format("* Writing to file  : \"%s\"",file))
env.info(string.format("* Writing to file  : \"%s\"",PROFILER.getfilename("csv")))
env.info("##############################################################################")
table.sort(t,function(a,b)return a.tm>b.tm end)
PROFILER._flog(f,"")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"")
PROFILER._flog(f,"-------------------------")
PROFILER._flog(f,"---- Profiler Report ----")
PROFILER._flog(f,"-------------------------")
PROFILER._flog(f,"")
PROFILER._flog(f,string.format("* Runtime Game     : %s = %.1f sec",UTILS.SecondsToClock(runTimeGame,true),runTimeGame))
PROFILER._flog(f,string.format("* Runtime Real     : %s = %.1f sec",UTILS.SecondsToClock(runTimeOS,true),runTimeOS))
PROFILER._flog(f,string.format("* Function time    : %s = %.1f sec (%.1f %% of runtime game)",UTILS.SecondsToClock(Ttot,true),Ttot,Ttot/runTimeGame*100))
PROFILER._flog(f,"")
PROFILER._flog(f,string.format("* Total functions  = %d",#t))
PROFILER._flog(f,string.format("* Total func calls = %d",Calls))
PROFILER._flog(f,"")
PROFILER._flog(f,string.format("* Calls per second threshold = %.3f/sec",PROFILER.ThreshCPS))
PROFILER._flog(f,string.format("* Total func time threshold  = %.3f sec",PROFILER.ThreshTtot))
PROFILER._flog(f,"")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"")
PROFILER.showTable(t,f,runTimeGame)
table.sort(t,function(a,b)return a.tm/a.count>b.tm/b.count end)
PROFILER._flog(f,"")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"")
PROFILER._flog(f,"--------------------------------------")
PROFILER._flog(f,"---- Data Sorted by Time per Call ----")
PROFILER._flog(f,"--------------------------------------")
PROFILER._flog(f,"")
PROFILER.showTable(t,f,runTimeGame)
table.sort(t,function(a,b)return a.count>b.count end)
PROFILER._flog(f,"")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"")
PROFILER._flog(f,"------------------------------------")
PROFILER._flog(f,"---- Data Sorted by Total Calls ----")
PROFILER._flog(f,"------------------------------------")
PROFILER._flog(f,"")
PROFILER.showTable(t,f,runTimeGame)
PROFILER._flog(f,"")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"************************************************************************************************************************")
PROFILER._flog(f,"************************************************************************************************************************")
f:close()
PROFILER.printCSV(t,runTimeGame)
end
do
FIFO={
ClassName="FIFO",
lid="",
version="0.0.5",
counter=0,
pointer=0,
stackbypointer={},
stackbyid={}
}
function FIFO:New()
local self=BASE:Inherit(self,BASE:New())
self.pointer=0
self.counter=0
self.stackbypointer={}
self.stackbyid={}
self.uniquecounter=0
self.lid=string.format("%s (%s) | ","FiFo",self.version)
self:T(self.lid.."Created.")
return self
end
function FIFO:Clear()
self:T(self.lid.."Clear")
self.pointer=0
self.counter=0
self.stackbypointer=nil
self.stackbyid=nil
self.stackbypointer={}
self.stackbyid={}
self.uniquecounter=0
return self
end
function FIFO:Push(Object,UniqueID)
self:T(self.lid.."Push")
self:T({Object,UniqueID})
self.pointer=self.pointer+1
self.counter=self.counter+1
local uniID=UniqueID
if not UniqueID then
self.uniquecounter=self.uniquecounter+1
uniID=self.uniquecounter
end
self.stackbyid[uniID]={pointer=self.pointer,data=Object,uniqueID=uniID}
self.stackbypointer[self.pointer]={pointer=self.pointer,data=Object,uniqueID=uniID}
return self
end
function FIFO:Pull()
self:T(self.lid.."Pull")
if self.counter==0 then return nil end
local object=self.stackbypointer[1].data
self.stackbypointer[1]=nil
self.counter=self.counter-1
self:Flatten()
return object
end
function FIFO:PullByPointer(Pointer)
self:T(self.lid.."PullByPointer "..tostring(Pointer))
if self.counter==0 then return nil end
local object=self.stackbypointer[Pointer]
self.stackbypointer[Pointer]=nil
if object then self.stackbyid[object.uniqueID]=nil end
self.counter=self.counter-1
self:Flatten()
if object then
return object.data
else
return nil
end
end
function FIFO:ReadByPointer(Pointer)
self:T(self.lid.."ReadByPointer "..tostring(Pointer))
if self.counter==0 or not Pointer or not self.stackbypointer[Pointer]then return nil end
local object=self.stackbypointer[Pointer]
if object then
return object.data
else
return nil
end
end
function FIFO:ReadByID(UniqueID)
self:T(self.lid.."ReadByID "..tostring(UniqueID))
if self.counter==0 or not UniqueID or not self.stackbyid[UniqueID]then return nil end
local object=self.stackbyid[UniqueID]
if object then
return object.data
else
return nil
end
end
function FIFO:PullByID(UniqueID)
self:T(self.lid.."PullByID "..tostring(UniqueID))
if self.counter==0 then return nil end
local object=self.stackbyid[UniqueID]
if object then
return self:PullByPointer(object.pointer)
else
return nil
end
end
function FIFO:Flatten()
self:T(self.lid.."Flatten")
local pointerstack={}
local idstack={}
local counter=0
for _ID,_entry in pairs(self.stackbypointer)do
counter=counter+1
pointerstack[counter]={pointer=counter,data=_entry.data,uniqueID=_entry.uniqueID}
end
for _ID,_entry in pairs(pointerstack)do
idstack[_entry.uniqueID]={pointer=_entry.pointer,data=_entry.data,uniqueID=_entry.uniqueID}
end
self.stackbypointer=nil
self.stackbypointer=pointerstack
self.stackbyid=nil
self.stackbyid=idstack
self.counter=counter
self.pointer=counter
return self
end
function FIFO:IsEmpty()
self:T(self.lid.."IsEmpty")
return self.counter==0 and true or false
end
function FIFO:GetSize()
self:T(self.lid.."GetSize")
return self.counter
end
function FIFO:Count()
self:T(self.lid.."Count")
return self.counter
end
function FIFO:IsNotEmpty()
self:T(self.lid.."IsNotEmpty")
return not self:IsEmpty()
end
function FIFO:GetPointerStack()
self:T(self.lid.."GetPointerStack")
return self.stackbypointer
end
function FIFO:HasUniqueID(UniqueID)
self:T(self.lid.."HasUniqueID")
if self.stackbyid[UniqueID]~=nil then
return true
else
return false
end
end
function FIFO:GetIDStack()
self:T(self.lid.."GetIDStack")
return self.stackbyid
end
function FIFO:GetIDStackSorted()
self:T(self.lid.."GetIDStackSorted")
local stack=self:GetIDStack()
local idstack={}
for _id,_entry in pairs(stack)do
idstack[#idstack+1]=_id
self:T({"pre",_id})
end
local function sortID(a,b)
return a<b
end
table.sort(idstack)
return idstack
end
function FIFO:GetDataTable()
self:T(self.lid.."GetDataTable")
local datatable={}
for _,_entry in pairs(self.stackbypointer)do
datatable[#datatable+1]=_entry.data
end
return datatable
end
function FIFO:GetSortedDataTable()
self:T(self.lid.."GetSortedDataTable")
local datatable={}
local idtablesorted=self:GetIDStackSorted()
for _,_entry in pairs(idtablesorted)do
datatable[#datatable+1]=self:ReadByID(_entry)
end
return datatable
end
function FIFO:ForEach(IteratorFunction,Arg,Function,FunctionArguments)
self:T(self.lid.."ForEach")
local Set=self:GetPointerStack()or{}
Arg=Arg or{}
local function CoRoutine()
local Count=0
for ObjectID,ObjectData in pairs(Set)do
local Object=ObjectData.data
self:T({Object})
if Function then
if Function(unpack(FunctionArguments or{}),Object)==true then
IteratorFunction(Object,unpack(Arg))
end
else
IteratorFunction(Object,unpack(Arg))
end
Count=Count+1
end
return true
end
local co=CoRoutine
local function Schedule()
local status,res=co()
self:T({status,res})
if status==false then
error(res)
end
if res==false then
return true
end
return false
end
Schedule()
return self
end
function FIFO:Flush()
self:T(self.lid.."FiFo Flush")
self:I("FIFO Flushing Stack by Pointer")
for _id,_data in pairs(self.stackbypointer)do
local data=_data
self:I(string.format("Pointer: %s | Entry: Number = %s Data = %s UniqueID = %s",tostring(_id),tostring(data.pointer),tostring(data.data),tostring(data.uniqueID)))
end
self:I("FIFO Flushing Stack by ID")
for _id,_data in pairs(self.stackbyid)do
local data=_data
self:I(string.format("ID: %s | Entry: Number = %s Data = %s UniqueID = %s",tostring(_id),tostring(data.pointer),tostring(data.data),tostring(data.uniqueID)))
end
self:I("Counter = "..self.counter)
self:I("Pointer = "..self.pointer)
return self
end
end
do
LIFO={
ClassName="LIFO",
lid="",
version="0.0.5",
counter=0,
pointer=0,
stackbypointer={},
stackbyid={}
}
function LIFO:New()
local self=BASE:Inherit(self,BASE:New())
self.pointer=0
self.counter=0
self.uniquecounter=0
self.stackbypointer={}
self.stackbyid={}
self.lid=string.format("%s (%s) | ","LiFo",self.version)
self:T(self.lid.."Created.")
return self
end
function LIFO:Clear()
self:T(self.lid.."Clear")
self.pointer=0
self.counter=0
self.stackbypointer=nil
self.stackbyid=nil
self.stackbypointer={}
self.stackbyid={}
self.uniquecounter=0
return self
end
function LIFO:Push(Object,UniqueID)
self:T(self.lid.."Push")
self:T({Object,UniqueID})
self.pointer=self.pointer+1
self.counter=self.counter+1
local uniID=UniqueID
if not UniqueID then
self.uniquecounter=self.uniquecounter+1
uniID=self.uniquecounter
end
self.stackbyid[uniID]={pointer=self.pointer,data=Object,uniqueID=uniID}
self.stackbypointer[self.pointer]={pointer=self.pointer,data=Object,uniqueID=uniID}
return self
end
function LIFO:Pull()
self:T(self.lid.."Pull")
if self.counter==0 then return nil end
local object=self.stackbypointer[self.pointer].data
self.stackbypointer[self.pointer]=nil
self.counter=self.counter-1
self.pointer=self.pointer-1
self:Flatten()
return object
end
function LIFO:PullByPointer(Pointer)
self:T(self.lid.."PullByPointer "..tostring(Pointer))
if self.counter==0 then return nil end
local object=self.stackbypointer[Pointer]
self.stackbypointer[Pointer]=nil
if object then self.stackbyid[object.uniqueID]=nil end
self.counter=self.counter-1
self:Flatten()
if object then
return object.data
else
return nil
end
end
function LIFO:ReadByPointer(Pointer)
self:T(self.lid.."ReadByPointer "..tostring(Pointer))
if self.counter==0 or not Pointer or not self.stackbypointer[Pointer]then return nil end
local object=self.stackbypointer[Pointer]
if object then
return object.data
else
return nil
end
end
function LIFO:ReadByID(UniqueID)
self:T(self.lid.."ReadByID "..tostring(UniqueID))
if self.counter==0 or not UniqueID or not self.stackbyid[UniqueID]then return nil end
local object=self.stackbyid[UniqueID]
if object then
return object.data
else
return nil
end
end
function LIFO:PullByID(UniqueID)
self:T(self.lid.."PullByID "..tostring(UniqueID))
if self.counter==0 then return nil end
local object=self.stackbyid[UniqueID]
if object then
return self:PullByPointer(object.pointer)
else
return nil
end
end
function LIFO:Flatten()
self:T(self.lid.."Flatten")
local pointerstack={}
local idstack={}
local counter=0
for _ID,_entry in pairs(self.stackbypointer)do
counter=counter+1
pointerstack[counter]={pointer=counter,data=_entry.data,uniqueID=_entry.uniqueID}
end
for _ID,_entry in pairs(pointerstack)do
idstack[_entry.uniqueID]={pointer=_entry.pointer,data=_entry.data,uniqueID=_entry.uniqueID}
end
self.stackbypointer=nil
self.stackbypointer=pointerstack
self.stackbyid=nil
self.stackbyid=idstack
self.counter=counter
self.pointer=counter
return self
end
function LIFO:IsEmpty()
self:T(self.lid.."IsEmpty")
return self.counter==0 and true or false
end
function LIFO:GetSize()
self:T(self.lid.."GetSize")
return self.counter
end
function LIFO:Count()
self:T(self.lid.."Count")
return self.counter
end
function LIFO:IsNotEmpty()
self:T(self.lid.."IsNotEmpty")
return not self:IsEmpty()
end
function LIFO:GetPointerStack()
self:T(self.lid.."GetPointerStack")
return self.stackbypointer
end
function LIFO:GetIDStack()
self:T(self.lid.."GetIDStack")
return self.stackbyid
end
function LIFO:GetIDStackSorted()
self:T(self.lid.."GetIDStackSorted")
local stack=self:GetIDStack()
local idstack={}
for _id,_entry in pairs(stack)do
idstack[#idstack+1]=_id
self:T({"pre",_id})
end
local function sortID(a,b)
return a<b
end
table.sort(idstack)
return idstack
end
function LIFO:HasUniqueID(UniqueID)
self:T(self.lid.."HasUniqueID")
return self.stackbyid[UniqueID]and true or false
end
function LIFO:Flush()
self:T(self.lid.."FiFo Flush")
self:I("LIFO Flushing Stack by Pointer")
for _id,_data in pairs(self.stackbypointer)do
local data=_data
self:I(string.format("Pointer: %s | Entry: Number = %s Data = %s UniqueID = %s",tostring(_id),tostring(data.pointer),tostring(data.data),tostring(data.uniqueID)))
end
self:I("LIFO Flushing Stack by ID")
for _id,_data in pairs(self.stackbyid)do
local data=_data
self:I(string.format("ID: %s | Entry: Number = %s Data = %s UniqueID = %s",tostring(_id),tostring(data.pointer),tostring(data.data),tostring(data.uniqueID)))
end
self:I("Counter = "..self.counter)
self:I("Pointer = "..self.pointer)
return self
end
function LIFO:GetDataTable()
self:T(self.lid.."GetDataTable")
local datatable={}
for _,_entry in pairs(self.stackbypointer)do
datatable[#datatable+1]=_entry.data
end
return datatable
end
function LIFO:GetSortedDataTable()
self:T(self.lid.."GetSortedDataTable")
local datatable={}
local idtablesorted=self:GetIDStackSorted()
for _,_entry in pairs(idtablesorted)do
datatable[#datatable+1]=self:ReadByID(_entry)
end
return datatable
end
function LIFO:ForEach(IteratorFunction,Arg,Function,FunctionArguments)
self:T(self.lid.."ForEach")
local Set=self:GetPointerStack()or{}
Arg=Arg or{}
local function CoRoutine()
local Count=0
for ObjectID,ObjectData in pairs(Set)do
local Object=ObjectData.data
self:T({Object})
if Function then
if Function(unpack(FunctionArguments or{}),Object)==true then
IteratorFunction(Object,unpack(Arg))
end
else
IteratorFunction(Object,unpack(Arg))
end
Count=Count+1
end
return true
end
local co=CoRoutine
local function Schedule()
local status,res=co()
self:T({status,res})
if status==false then
error(res)
end
if res==false then
return true
end
return false
end
Schedule()
return self
end
end
SOCKET={
ClassName="SOCKET",
verbose=0,
lid=nil,
}
SOCKET.DataType={
TEXT="moose_text",
BOMBRESULT="moose_bomb_result",
STRAFERESULT="moose_strafe_result",
LSOGRADE="moose_lso_grade",
TTS="moose_text2speech"
}
SOCKET.version="0.3.0"
function SOCKET:New(Port,Host)
local self=BASE:Inherit(self,FSM:New())
package.path=package.path..";.\\LuaSocket\\?.lua;"
package.cpath=package.cpath..";.\\LuaSocket\\?.dll;"
self.socket=require("socket")
self.port=Port or 10042
self.host=Host or"127.0.0.1"
self.json=loadfile("Scripts\\JSON.lua")()
self.UDPSendSocket=self.socket.udp()
self.UDPSendSocket:settimeout(0)
return self
end
function SOCKET:SetPort(Port)
self.port=Port or 10042
end
function SOCKET:SetHost(Host)
self.host=Host or"127.0.0.1"
end
function SOCKET:SendTable(Table)
Table.server_name=BASE.ServerName or"Unknown"
local json=self.json:encode(Table)
self:T("Json table:")
self:T(json)
self.socket.try(self.UDPSendSocket:sendto(json,self.host,self.port))
return self
end
function SOCKET:SendText(Text)
local message={}
message.command=SOCKET.DataType.TEXT
message.text=Text
self:SendTable(message)
return self
end
function SOCKET:SendTextToSpeech(Text,Provider,Voice,Culture,Gender,Volume)
Text=Text or"Hello World!"
local message={}
message.command=SOCKET.DataType.TTS
message.text=Text
message.provider=Provider
message.voice=Voice
message.culture=Culture
message.gender=Gender
message.volume=Volume
self:SendTable(message)
return self
end
local _TraceOnOff=false
local _TraceLevel=1
local _TraceAll=false
local _TraceClass={}
local _TraceClassMethod={}
local _ClassID=0
BASE={
ClassName="BASE",
ClassID=0,
Events={},
States={},
Debug=debug,
Scheduler=nil,
Properties={},
}
BASE.__={}
BASE._={
Schedules={},
}
function BASE:New()
local self=UTILS.DeepCopy(self)
_ClassID=_ClassID+1
self.ClassID=_ClassID
return self
end
function BASE:Inherit(Child,Parent)
local Child=UTILS.DeepCopy(Child)
if Child~=nil then
if rawget(Child,"__")then
setmetatable(Child,{__index=Child.__})
setmetatable(Child.__,{__index=Parent})
else
setmetatable(Child,{__index=Parent})
end
end
return Child
end
local function getParent(Child)
local Parent=nil
if Child.ClassName=='BASE'then
Parent=nil
else
if rawget(Child,"__")then
Parent=getmetatable(Child.__).__index
else
Parent=getmetatable(Child).__index
end
end
return Parent
end
function BASE:GetParent(Child,FromClass)
local Parent
if Child.ClassName=='BASE'then
Parent=nil
else
if FromClass then
while(Child.ClassName~="BASE"and Child.ClassName~=FromClass.ClassName)do
Child=getParent(Child)
end
end
if Child.ClassName=='BASE'then
Parent=nil
else
Parent=getParent(Child)
end
end
return Parent
end
function BASE:IsInstanceOf(ClassName)
if type(ClassName)~='string'then
if type(ClassName)=='table'and ClassName.ClassName~=nil then
ClassName=ClassName.ClassName
else
local err_str='className parameter should be a string; parameter received: '..type(ClassName)
self:E(err_str)
return false
end
end
ClassName=string.upper(ClassName)
if string.upper(self.ClassName)==ClassName then
return true
end
local Parent=getParent(self)
while Parent do
if string.upper(Parent.ClassName)==ClassName then
return true
end
Parent=getParent(Parent)
end
return false
end
function BASE:GetClassNameAndID()
return string.format('%s#%09d',self.ClassName,self.ClassID)
end
function BASE:GetClassName()
return self.ClassName
end
function BASE:GetClassID()
return self.ClassID
end
do
function BASE:EventDispatcher()
return _EVENTDISPATCHER
end
function BASE:GetEventPriority()
return self._.EventPriority or 5
end
function BASE:SetEventPriority(EventPriority)
self._.EventPriority=EventPriority
end
function BASE:EventRemoveAll()
self:EventDispatcher():RemoveAll(self)
return self
end
function BASE:HandleEvent(EventID,EventFunction)
self:EventDispatcher():OnEventGeneric(EventFunction,self,EventID)
return self
end
function BASE:UnHandleEvent(EventID)
self:EventDispatcher():RemoveEvent(self,EventID)
return self
end
end
function BASE:CreateEventBirth(EventTime,Initiator,IniUnitName,place,subplace)
self:F({EventTime,Initiator,IniUnitName,place,subplace})
local Event={
id=world.event.S_EVENT_BIRTH,
time=EventTime,
initiator=Initiator,
IniUnitName=IniUnitName,
place=place,
subplace=subplace,
}
world.onEvent(Event)
end
function BASE:CreateEventCrash(EventTime,Initiator,IniObjectCategory)
self:F({EventTime,Initiator})
local Event={
id=world.event.S_EVENT_CRASH,
time=EventTime,
initiator=Initiator,
IniObjectCategory=IniObjectCategory,
}
world.onEvent(Event)
end
function BASE:CreateEventUnitLost(EventTime,Initiator)
self:F({EventTime,Initiator})
local Event={
id=world.event.S_EVENT_UNIT_LOST,
time=EventTime,
initiator=Initiator,
}
world.onEvent(Event)
end
function BASE:CreateEventDead(EventTime,Initiator,IniObjectCategory)
self:F({EventTime,Initiator,IniObjectCategory})
local Event={
id=world.event.S_EVENT_DEAD,
time=EventTime,
initiator=Initiator,
IniObjectCategory=IniObjectCategory,
}
world.onEvent(Event)
end
function BASE:CreateEventRemoveUnit(EventTime,Initiator)
self:F({EventTime,Initiator})
local Event={
id=EVENTS.RemoveUnit,
time=EventTime,
initiator=Initiator,
}
world.onEvent(Event)
end
function BASE:CreateEventTakeoff(EventTime,Initiator)
self:F({EventTime,Initiator})
local Event={
id=world.event.S_EVENT_TAKEOFF,
time=EventTime,
initiator=Initiator,
}
world.onEvent(Event)
end
function BASE:CreateEventPlayerEnterAircraft(PlayerUnit)
self:F({PlayerUnit})
local Event={
id=EVENTS.PlayerEnterAircraft,
time=timer.getTime(),
initiator=PlayerUnit:GetDCSObject()
}
world.onEvent(Event)
end
function BASE:CreateEventNewDynamicCargo(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.NewDynamicCargo,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function BASE:CreateEventDynamicCargoLoaded(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.DynamicCargoLoaded,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function BASE:CreateEventDynamicCargoUnloaded(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.DynamicCargoUnloaded,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function BASE:CreateEventDynamicCargoRemoved(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.DynamicCargoRemoved,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function BASE:onEvent(event)
if self then
for EventID,EventObject in pairs(self.Events)do
if EventObject.EventEnabled then
if event.id==EventObject.Event then
if self==EventObject.Self then
if event.initiator and event.initiator:isExist()then
event.IniUnitName=event.initiator:getName()
end
if event.target and event.target:isExist()then
event.TgtUnitName=event.target:getName()
end
end
end
end
end
end
end
do
function BASE:ScheduleOnce(Start,SchedulerFunction,...)
local ObjectName="-"
ObjectName=self.ClassName..self.ClassID
self:F3({"ScheduleOnce: ",ObjectName,Start})
if not self.Scheduler then
self.Scheduler=SCHEDULER:New(self)
end
local ScheduleID=self.Scheduler:Schedule(nil,SchedulerFunction,{...},Start)
self._.Schedules[#self._.Schedules+1]=ScheduleID
return self._.Schedules[#self._.Schedules]
end
function BASE:ScheduleRepeat(Start,Repeat,RandomizeFactor,Stop,SchedulerFunction,...)
self:F2({Start})
self:T3({...})
local ObjectName="-"
ObjectName=self.ClassName..self.ClassID
self:F3({"ScheduleRepeat: ",ObjectName,Start,Repeat,RandomizeFactor,Stop})
if not self.Scheduler then
self.Scheduler=SCHEDULER:New(self)
end
local ScheduleID=self.Scheduler:Schedule(
nil,
SchedulerFunction,
{...},
Start,
Repeat,
RandomizeFactor,
Stop,
4
)
self._.Schedules[#self._.Schedules+1]=ScheduleID
return self._.Schedules[#self._.Schedules]
end
function BASE:ScheduleStop(SchedulerID)
self:F3({"ScheduleStop:"})
if self.Scheduler then
_SCHEDULEDISPATCHER:Stop(self.Scheduler,SchedulerID)
end
end
end
function BASE:SetState(Object,Key,Value)
local ClassNameAndID=Object:GetClassNameAndID()
self.States[ClassNameAndID]=self.States[ClassNameAndID]or{}
self.States[ClassNameAndID][Key]=Value
return self.States[ClassNameAndID][Key]
end
function BASE:GetState(Object,Key)
local ClassNameAndID=Object:GetClassNameAndID()
if self.States[ClassNameAndID]then
local Value=self.States[ClassNameAndID][Key]or false
return Value
end
return nil
end
function BASE:ClearState(Object,StateName)
local ClassNameAndID=Object:GetClassNameAndID()
if self.States[ClassNameAndID]then
self.States[ClassNameAndID][StateName]=nil
end
end
function BASE:SetProperty(Key,Value)
self.Properties=self.Properties or{}
self.Properties[Key]=Value
end
function BASE:GetProperty(Key)
self.Properties=self.Properties or{}
return self.Properties[Key]
end
function BASE:GetProperties()
return self.Properties
end
function BASE:TraceOn()
self:TraceOnOff(true)
end
function BASE:TraceOff()
self:TraceOnOff(false)
end
function BASE:TraceOnOff(TraceOnOff)
if TraceOnOff==false then
self:I("Tracing in MOOSE is OFF")
_TraceOnOff=false
else
self:I("Tracing in MOOSE is ON")
_TraceOnOff=true
end
end
function BASE:IsTrace()
if BASE.Debug and(_TraceAll==true)or(_TraceClass[self.ClassName]or _TraceClassMethod[self.ClassName])then
return true
else
return false
end
end
function BASE:TraceLevel(Level)
_TraceLevel=Level or 1
self:I("Tracing level ".._TraceLevel)
end
function BASE:TraceAll(TraceAll)
if TraceAll==false then
_TraceAll=false
else
_TraceAll=true
end
if _TraceAll then
self:I("Tracing all methods in MOOSE ")
else
self:I("Switched off tracing all methods in MOOSE")
end
end
function BASE:TraceClass(Class)
_TraceClass[Class]=true
_TraceClassMethod[Class]={}
self:I("Tracing class "..Class)
end
function BASE:TraceClassMethod(Class,Method)
if not _TraceClassMethod[Class]then
_TraceClassMethod[Class]={}
_TraceClassMethod[Class].Method={}
end
_TraceClassMethod[Class].Method[Method]=true
self:I("Tracing method "..Method.." of class "..Class)
end
function BASE:_Serialize(Arguments)
local text=UTILS.PrintTableToLog({Arguments},0,true)
text=string.gsub(text,"(\n+)","")
text=string.gsub(text,"%(%(","%(")
text=string.gsub(text,"%)%)","%)")
text=string.gsub(text,"(%s+)"," ")
return text
end
function BASE:_F(Arguments,DebugInfoCurrentParam,DebugInfoFromParam)
if BASE.Debug and(_TraceAll==true)or(_TraceClass[self.ClassName]or _TraceClassMethod[self.ClassName])then
local DebugInfoCurrent=DebugInfoCurrentParam and DebugInfoCurrentParam or BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=DebugInfoFromParam and DebugInfoFromParam or BASE.Debug.getinfo(3,"l")
local Function="function"
if DebugInfoCurrent.name then
Function=DebugInfoCurrent.name
end
if _TraceAll==true or _TraceClass[self.ClassName]or _TraceClassMethod[self.ClassName].Method[Function]then
local LineCurrent=0
if DebugInfoCurrent.currentline then
LineCurrent=DebugInfoCurrent.currentline
end
local LineFrom=0
if DebugInfoFrom then
LineFrom=DebugInfoFrom.currentline
end
env.info(string.format("%6d(%6d)/%1s:%30s%05d.%s(%s)",LineCurrent,LineFrom,"F",self.ClassName,self.ClassID,Function,BASE:_Serialize(Arguments)))
end
end
end
function BASE:F(Arguments)
if BASE.Debug and _TraceOnOff==true then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
if _TraceLevel>=1 then
self:_F(Arguments,DebugInfoCurrent,DebugInfoFrom)
end
end
end
function BASE:F2(Arguments)
if BASE.Debug and _TraceOnOff==true and _TraceLevel>=2 then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
if _TraceLevel>=2 then
self:_F(Arguments,DebugInfoCurrent,DebugInfoFrom)
end
end
end
function BASE:F3(Arguments)
if BASE.Debug and _TraceOnOff==true and _TraceLevel>=3 then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
if _TraceLevel>=3 then
self:_F(Arguments,DebugInfoCurrent,DebugInfoFrom)
end
end
end
function BASE:_T(Arguments,DebugInfoCurrentParam,DebugInfoFromParam)
if BASE.Debug and(_TraceAll==true)or(_TraceClass[self.ClassName]or _TraceClassMethod[self.ClassName])then
local DebugInfoCurrent=DebugInfoCurrentParam and DebugInfoCurrentParam or BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=DebugInfoFromParam and DebugInfoFromParam or BASE.Debug.getinfo(3,"l")
local Function="function"
if DebugInfoCurrent.name then
Function=DebugInfoCurrent.name
end
if _TraceAll==true or _TraceClass[self.ClassName]or _TraceClassMethod[self.ClassName].Method[Function]then
local LineCurrent=0
if DebugInfoCurrent.currentline then
LineCurrent=DebugInfoCurrent.currentline
end
local LineFrom=0
if DebugInfoFrom then
LineFrom=DebugInfoFrom.currentline
end
env.info(string.format("%6d(%6d)/%1s:%30s%05d.%s",LineCurrent,LineFrom,"T",self.ClassName,self.ClassID,BASE:_Serialize(Arguments)))
end
end
end
function BASE:T(Arguments)
if BASE.Debug and _TraceOnOff==true then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
if _TraceLevel>=1 then
self:_T(Arguments,DebugInfoCurrent,DebugInfoFrom)
end
end
end
function BASE:T2(Arguments)
if BASE.Debug and _TraceOnOff==true and _TraceLevel>=2 then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
if _TraceLevel>=2 then
self:_T(Arguments,DebugInfoCurrent,DebugInfoFrom)
end
end
end
function BASE:T3(Arguments)
if BASE.Debug and _TraceOnOff==true and _TraceLevel>=3 then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
if _TraceLevel>=3 then
self:_T(Arguments,DebugInfoCurrent,DebugInfoFrom)
end
end
end
function BASE:E(Arguments)
if BASE.Debug then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
local Function="function"
if DebugInfoCurrent.name then
Function=DebugInfoCurrent.name
end
local LineCurrent=DebugInfoCurrent.currentline
local LineFrom=-1
if DebugInfoFrom then
LineFrom=DebugInfoFrom.currentline
end
env.info(string.format("%6d(%6d)/%1s:%30s%05d.%s(%s)",LineCurrent,LineFrom,"E",self.ClassName,self.ClassID,Function,UTILS.BasicSerialize(Arguments)))
else
env.info(string.format("%1s:%30s%05d(%s)","E",self.ClassName,self.ClassID,UTILS.BasicSerialize(Arguments)))
end
end
function BASE:I(Arguments)
if BASE.Debug then
local DebugInfoCurrent=BASE.Debug.getinfo(2,"nl")
local DebugInfoFrom=BASE.Debug.getinfo(3,"l")
local Function="function"
if DebugInfoCurrent.name then
Function=DebugInfoCurrent.name
end
local LineCurrent=DebugInfoCurrent.currentline
local LineFrom=-1
if DebugInfoFrom then
LineFrom=DebugInfoFrom.currentline
end
env.info(string.format("%6d(%6d)/%1s:%30s%05d.%s(%s)",LineCurrent,LineFrom,"I",self.ClassName,self.ClassID,Function,UTILS.BasicSerialize(Arguments)))
else
env.info(string.format("%1s:%30s%05d(%s)","I",self.ClassName,self.ClassID,UTILS.BasicSerialize(Arguments)))
end
end
ASTAR={
ClassName="ASTAR",
Debug=nil,
lid=nil,
nodes={},
counter=1,
Nnodes=0,
ncost=0,
ncostcache=0,
nvalid=0,
nvalidcache=0,
}
ASTAR.INF=1/0
ASTAR.version="0.4.0"
function ASTAR:New()
local self=BASE:Inherit(self,BASE:New())
self.lid="ASTAR | "
return self
end
function ASTAR:SetStartCoordinate(Coordinate)
self.startCoord=Coordinate
return self
end
function ASTAR:SetEndCoordinate(Coordinate)
self.endCoord=Coordinate
return self
end
function ASTAR:GetNodeFromCoordinate(Coordinate)
local node={}
node.coordinate=Coordinate
node.surfacetype=Coordinate:GetSurfaceType()
node.id=self.counter
node.valid={}
node.cost={}
self.counter=self.counter+1
return node
end
function ASTAR:AddNode(Node)
self.nodes[Node.id]=Node
self.Nnodes=self.Nnodes+1
return self
end
function ASTAR:AddNodeFromCoordinate(Coordinate)
local node=self:GetNodeFromCoordinate(Coordinate)
self:AddNode(node)
return node
end
function ASTAR:CheckValidSurfaceType(Node,SurfaceTypes)
if SurfaceTypes then
if type(SurfaceTypes)~="table"then
SurfaceTypes={SurfaceTypes}
end
for _,surface in pairs(SurfaceTypes)do
if surface==Node.surfacetype then
return true
end
end
return false
else
return true
end
end
function ASTAR:SetValidNeighbourFunction(NeighbourFunction,...)
self.ValidNeighbourFunc=NeighbourFunction
self.ValidNeighbourArg={}
if arg then
self.ValidNeighbourArg=arg
end
return self
end
function ASTAR:SetValidNeighbourLoS(CorridorWidth)
self:SetValidNeighbourFunction(ASTAR.LoS,CorridorWidth)
return self
end
function ASTAR:SetValidNeighbourDistance(MaxDistance)
self:SetValidNeighbourFunction(ASTAR.DistMax,MaxDistance)
return self
end
function ASTAR:SetValidNeighbourRoad(MaxDistance)
self:SetValidNeighbourFunction(ASTAR.Road,MaxDistance)
return self
end
function ASTAR:SetCostFunction(CostFunction,...)
self.CostFunc=CostFunction
self.CostArg={}
if arg then
self.CostArg=arg
end
return self
end
function ASTAR:SetCostDist2D()
self:SetCostFunction(ASTAR.Dist2D)
return self
end
function ASTAR:SetCostDist3D()
self:SetCostFunction(ASTAR.Dist3D)
return self
end
function ASTAR:SetCostRoad()
self:SetCostFunction(ASTAR)
return self
end
function ASTAR:CreateGrid(ValidSurfaceTypes,BoxHY,SpaceX,deltaX,deltaY,MarkGrid)
local Dz=SpaceX or 10000
local Dx=BoxHY and BoxHY/2 or 20000
local dz=deltaX or 2000
local dx=deltaY or dz
local angle=self.startCoord:HeadingTo(self.endCoord)
local dist=self.startCoord:Get2DDistance(self.endCoord)+2*Dz
local co=COORDINATE:New(0,0,0)
local do1=co:Get2DDistance(self.startCoord)
local ho1=co:HeadingTo(self.startCoord)
local xmin=-Dx
local zmin=-Dz
local nz=dist/dz+1
local nx=2*Dx/dx+1
local text=string.format("Building grid with nx=%d ny=%d => total=%d nodes",nx,nz,nx*nz)
self:T(self.lid..text)
for i=1,nx do
local x=xmin+dx*(i-1)
for j=1,nz do
local z=zmin+dz*(j-1)
local vec3=UTILS.Rotate2D({x=x,y=0,z=z},angle)
local c=COORDINATE:New(vec3.z,vec3.y,vec3.x):Translate(do1,ho1,true)
local node=self:GetNodeFromCoordinate(c)
if self:CheckValidSurfaceType(node,ValidSurfaceTypes)then
if MarkGrid then
c:MarkToAll(string.format("i=%d, j=%d surface=%d",i,j,node.surfacetype))
end
self:AddNode(node)
end
end
end
local text=string.format("Done building grid!")
self:T2(self.lid..text)
return self
end
function ASTAR.LoS(nodeA,nodeB,corridor)
local offset=1
local dx=corridor and corridor/2 or nil
local dy=dx
local cA=nodeA.coordinate:GetVec3()
local cB=nodeB.coordinate:GetVec3()
cA.y=offset
cB.y=offset
local los=land.isVisible(cA,cB)
if los and corridor then
local heading=nodeA.coordinate:HeadingTo(nodeB.coordinate)
local Ap=UTILS.VecTranslate(cA,dx,heading+90)
local Bp=UTILS.VecTranslate(cB,dx,heading+90)
los=land.isVisible(Ap,Bp)
if los then
local Am=UTILS.VecTranslate(cA,dx,heading-90)
local Bm=UTILS.VecTranslate(cB,dx,heading-90)
los=land.isVisible(Am,Bm)
end
end
return los
end
function ASTAR.Road(nodeA,nodeB)
local path=land.findPathOnRoads("roads",nodeA.coordinate.x,nodeA.coordinate.z,nodeB.coordinate.x,nodeB.coordinate.z)
if path then
return true
else
return false
end
end
function ASTAR.DistMax(nodeA,nodeB,distmax)
distmax=distmax or 2000
local dist=nodeA.coordinate:Get2DDistance(nodeB.coordinate)
return dist<=distmax
end
function ASTAR.Dist2D(nodeA,nodeB)
local dist=nodeA.coordinate:Get2DDistance(nodeB)
return dist
end
function ASTAR.Dist3D(nodeA,nodeB)
local dist=nodeA.coordinate:Get3DDistance(nodeB.coordinate)
return dist
end
function ASTAR.DistRoad(nodeA,nodeB)
local path=land.findPathOnRoads("roads",nodeA.coordinate.x,nodeA.coordinate.z,nodeB.coordinate.x,nodeB.coordinate.z)
if path then
local dist=0
for i=2,#path do
local b=path[i]
local a=path[i-1]
dist=dist+UTILS.VecDist2D(a,b)
end
return dist
end
return math.huge
end
function ASTAR:FindClosestNode(Coordinate)
local distMin=math.huge
local closeNode=nil
for _,_node in pairs(self.nodes)do
local node=_node
local dist=node.coordinate:Get2DDistance(Coordinate)
if dist<distMin then
distMin=dist
closeNode=node
end
end
return closeNode,distMin
end
function ASTAR:FindStartNode()
local node,dist=self:FindClosestNode(self.startCoord)
self.startNode=node
if dist>1000 then
self:T(self.lid.."Adding start node to node grid!")
self:AddNode(node)
end
return self
end
function ASTAR:FindEndNode()
local node,dist=self:FindClosestNode(self.endCoord)
self.endNode=node
if dist>1000 then
self:T(self.lid.."Adding end node to node grid!")
self:AddNode(node)
end
return self
end
function ASTAR:GetPath(ExcludeStartNode,ExcludeEndNode)
self:FindStartNode()
self:FindEndNode()
local nodes=self.nodes
local start=self.startNode
local goal=self.endNode
local openset={}
local closedset={}
local came_from={}
local g_score={}
local f_score={}
openset[start.id]=true
local Nopen=1
g_score[start.id]=0
f_score[start.id]=g_score[start.id]+self:_HeuristicCost(start,goal)
local T0=timer.getAbsTime()
local text=string.format("Starting A* pathfinding with %d Nodes",self.Nnodes)
self:T(self.lid..text)
local Tstart=UTILS.GetOSTime()
while Nopen>0 do
local current=self:_LowestFscore(openset,f_score)
if current.id==goal.id then
local path=self:_UnwindPath({},came_from,goal)
if not ExcludeEndNode then
table.insert(path,goal)
end
if ExcludeStartNode then
table.remove(path,1)
end
local Tstop=UTILS.GetOSTime()
local dT=nil
if Tstart and Tstop then
dT=Tstop-Tstart
end
local text=string.format("Found path with %d nodes (%d total)",#path,self.Nnodes)
if dT then
text=text..string.format(", OS Time %.6f sec",dT)
end
text=text..string.format(", Nvalid=%d [%d cached]",self.nvalid,self.nvalidcache)
text=text..string.format(", Ncost=%d [%d cached]",self.ncost,self.ncostcache)
self:T(self.lid..text)
return path
end
openset[current.id]=nil
Nopen=Nopen-1
closedset[current.id]=true
local neighbors=self:_NeighbourNodes(current,nodes)
for _,neighbor in pairs(neighbors)do
if self:_NotIn(closedset,neighbor.id)then
local tentative_g_score=g_score[current.id]+self:_DistNodes(current,neighbor)
if self:_NotIn(openset,neighbor.id)or tentative_g_score<g_score[neighbor.id]then
came_from[neighbor]=current
g_score[neighbor.id]=tentative_g_score
f_score[neighbor.id]=g_score[neighbor.id]+self:_HeuristicCost(neighbor,goal)
if self:_NotIn(openset,neighbor.id)then
openset[neighbor.id]=true
Nopen=Nopen+1
end
end
end
end
end
local text=string.format("WARNING: Could NOT find valid path!")
self:E(self.lid..text)
MESSAGE:New(text,60,"ASTAR"):ToAllIf(self.Debug)
return nil
end
function ASTAR:_HeuristicCost(nodeA,nodeB)
self.ncost=self.ncost+1
local cost=nodeA.cost[nodeB.id]
if cost~=nil then
self.ncostcache=self.ncostcache+1
return cost
end
local cost=nil
if self.CostFunc then
cost=self.CostFunc(nodeA,nodeB,unpack(self.CostArg))
else
cost=self:_DistNodes(nodeA,nodeB)
end
nodeA.cost[nodeB.id]=cost
nodeB.cost[nodeA.id]=cost
return cost
end
function ASTAR:_IsValidNeighbour(node,neighbor)
self.nvalid=self.nvalid+1
local valid=node.valid[neighbor.id]
if valid~=nil then
self.nvalidcache=self.nvalidcache+1
return valid
end
local valid=nil
if self.ValidNeighbourFunc then
valid=self.ValidNeighbourFunc(node,neighbor,unpack(self.ValidNeighbourArg))
else
valid=true
end
node.valid[neighbor.id]=valid
neighbor.valid[node.id]=valid
return valid
end
function ASTAR:_DistNodes(nodeA,nodeB)
return nodeA.coordinate:Get2DDistance(nodeB.coordinate)
end
function ASTAR:_LowestFscore(set,f_score)
local lowest,bestNode=ASTAR.INF,nil
for nid,node in pairs(set)do
local score=f_score[nid]
if score<lowest then
lowest,bestNode=score,nid
end
end
return self.nodes[bestNode]
end
function ASTAR:_NeighbourNodes(theNode,nodes)
local neighbors={}
for _,node in pairs(nodes)do
if theNode.id~=node.id then
local isvalid=self:_IsValidNeighbour(theNode,node)
if isvalid then
table.insert(neighbors,node)
end
end
end
return neighbors
end
function ASTAR:_NotIn(set,theNode)
return set[theNode]==nil
end
function ASTAR:_UnwindPath(flat_path,map,current_node)
if map[current_node]then
table.insert(flat_path,1,map[current_node])
return self:_UnwindPath(flat_path,map,map[current_node])
else
return flat_path
end
end
BEACON={
ClassName="BEACON",
Positionable=nil,
name=nil,
UniqueName=0,
}
BEACON.Type={
NULL=0,
VOR=1,
DME=2,
VOR_DME=3,
TACAN=4,
VORTAC=5,
RSBN=128,
BROADCAST_STATION=1024,
HOMER=8,
AIRPORT_HOMER=4104,
AIRPORT_HOMER_WITH_MARKER=4136,
ILS_FAR_HOMER=16408,
ILS_NEAR_HOMER=16424,
ILS_LOCALIZER=16640,
ILS_GLIDESLOPE=16896,
PRMG_LOCALIZER=33024,
PRMG_GLIDESLOPE=33280,
ICLS=131584,
ICLS_LOCALIZER=131328,
ICLS_GLIDESLOPE=131584,
NAUTICAL_HOMER=65536,
}
BEACON.System={
PAR_10=1,
RSBN_5=2,
TACAN=3,
TACAN_TANKER_X=4,
TACAN_TANKER_Y=5,
VOR=6,
ILS_LOCALIZER=7,
ILS_GLIDESLOPE=8,
PRMG_LOCALIZER=9,
PRMG_GLIDESLOPE=10,
BROADCAST_STATION=11,
VORTAC=12,
TACAN_AA_MODE_X=13,
TACAN_AA_MODE_Y=14,
VORDME=15,
ICLS_LOCALIZER=16,
ICLS_GLIDESLOPE=17,
}
function BEACON:New(Positionable)
local self=BASE:Inherit(self,BASE:New())
self:F(Positionable)
if Positionable:GetPointVec2()then
self.Positionable=Positionable
self.name=Positionable:GetName()
self:I(string.format("New BEACON %s",tostring(self.name)))
return self
end
self:E({"The passed positionable is invalid, no BEACON created",Positionable})
return nil
end
function BEACON:ActivateTACAN(Channel,Mode,Message,Bearing,Duration)
self:T({channel=Channel,mode=Mode,callsign=Message,bearing=Bearing,duration=Duration})
Mode=Mode or"Y"
local Frequency=UTILS.TACANToFrequency(Channel,Mode)
if not Frequency then
self:E({"The passed TACAN channel is invalid, the BEACON is not emitting"})
return self
end
local Type=BEACON.Type.TACAN
local System=BEACON.System.TACAN
local AA=self.Positionable:IsAir()
if AA then
System=5
if Mode=="X"then
System=BEACON.System.TACAN_TANKER_X
else
System=BEACON.System.TACAN_TANKER_Y
end
end
local UnitID=self.Positionable:GetID()
self:I({string.format("BEACON Activating TACAN %s: Channel=%d%s, Morse=%s, Bearing=%s, Duration=%s!",tostring(self.name),Channel,Mode,Message,tostring(Bearing),tostring(Duration))})
self.Positionable:CommandActivateBeacon(Type,System,Frequency,UnitID,Channel,Mode,AA,Message,Bearing)
if Duration then
self.Positionable:DeactivateBeacon(Duration)
end
return self
end
function BEACON:ActivateICLS(Channel,Callsign,Duration)
self:F({Channel=Channel,Callsign=Callsign,Duration=Duration})
local UnitID=self.Positionable:GetID()
self:T2({"ICLS BEACON started!"})
self.Positionable:CommandActivateICLS(Channel,UnitID,Callsign)
if Duration then
self.Positionable:DeactivateBeacon(Duration)
end
return self
end
function BEACON:ActivateLink4(Frequency,Morse,Duration)
self:F({Frequency=Frequency,Morse=Morse,Duration=Duration})
local UnitID=self.Positionable:GetID()
self:T2({"LINK4 BEACON started!"})
self.Positionable:CommandActivateLink4(Frequency,UnitID,Morse)
if Duration then
self.Positionable:CommandDeactivateLink4(Duration)
end
return self
end
function BEACON:AATACAN(TACANChannel,Message,Bearing,BeaconDuration)
self:F({TACANChannel,Message,Bearing,BeaconDuration})
self:E("This method is DEPRECATED! Please use ActivateTACAN() instead.")
local IsValid=true
if not self.Positionable:IsAir()then
self:E({"The POSITIONABLE you want to attach the AA Tacan Beacon is not an aircraft ! The BEACON is not emitting",self.Positionable})
IsValid=false
end
local Frequency=self:_TACANToFrequency(TACANChannel,"Y")
if not Frequency then
self:E({"The passed TACAN channel is invalid, the BEACON is not emitting"})
IsValid=false
end
local System
if Bearing then
System=BEACON.System.TACAN_TANKER_Y
else
System=BEACON.System.TACAN_AA_MODE_Y
end
if IsValid then
self:T2({"AA TACAN BEACON started !"})
self.Positionable:SetCommand({
id="ActivateBeacon",
params={
type=BEACON.Type.TACAN,
system=System,
callsign=Message,
AA=true,
frequency=Frequency,
bearing=Bearing,
modeChannel="Y",
}
})
if BeaconDuration then
SCHEDULER:New(nil,
function()
self:StopAATACAN()
end,{},BeaconDuration)
end
end
return self
end
function BEACON:StopAATACAN()
self:F()
if not self.Positionable then
self:E({"Start the beacon first before stoping it !"})
else
self.Positionable:SetCommand({
id='DeactivateBeacon',
params={
}
})
end
end
function BEACON:RadioBeacon(FileName,Frequency,Modulation,Power,BeaconDuration)
self:F({FileName,Frequency,Modulation,Power,BeaconDuration})
local IsValid=false
Modulation=Modulation or radio.modulation.AM
if type(FileName)=="string"then
if FileName:find(".ogg")or FileName:find(".wav")then
if not FileName:find("l10n/DEFAULT/")then
FileName="l10n/DEFAULT/"..FileName
end
IsValid=true
end
end
if not IsValid then
self:E({"File name invalid. Maybe something wrong with the extension? ",FileName})
end
if type(Frequency)~="number"and IsValid then
self:E({"Frequency invalid. ",Frequency})
IsValid=false
end
Frequency=Frequency*1000000
if Modulation~=radio.modulation.AM and Modulation~=radio.modulation.FM and IsValid then
self:E({"Modulation is invalid. Use DCS's enum radio.modulation.",Modulation})
IsValid=false
end
if type(Power)~="number"and IsValid then
self:E({"Power is invalid. ",Power})
IsValid=false
end
Power=math.floor(math.abs(Power))
if IsValid then
self:T2({"Activating Beacon on ",Frequency,Modulation})
BEACON.UniqueName=BEACON.UniqueName+1
self.BeaconName="MooseBeacon"..tostring(BEACON.UniqueName)
trigger.action.radioTransmission(FileName,self.Positionable:GetPositionVec3(),Modulation,true,Frequency,Power,self.BeaconName)
if BeaconDuration then
SCHEDULER:New(nil,
function()
self:StopRadioBeacon()
end,{},BeaconDuration)
end
end
return self
end
function BEACON:StopRadioBeacon()
self:F()
trigger.action.stopRadioTransmission(self.BeaconName)
return self
end
function BEACON:_TACANToFrequency(TACANChannel,TACANMode)
self:F3({TACANChannel,TACANMode})
if type(TACANChannel)~="number"then
if TACANMode~="X"and TACANMode~="Y"then
return nil
end
end
local A=1151
local B=64
if TACANChannel<64 then
B=1
end
if TACANMode=='Y'then
A=1025
if TACANChannel<64 then
A=1088
end
else
if TACANChannel<64 then
A=962
end
end
return(A+TACANChannel-B)*1000000
end
CONDITION={
ClassName="CONDITION",
lid=nil,
functionsGen={},
functionsAny={},
functionsAll={},
functionCounter=0,
defaultPersist=false,
}
CONDITION.version="0.3.0"
function CONDITION:New(Name)
local self=BASE:Inherit(self,BASE:New())
self.name=Name or"Condition X"
self:SetNoneResult(false)
self.lid=string.format("%s | ",self.name)
return self
end
function CONDITION:SetAny(Any)
self.isAny=Any
return self
end
function CONDITION:SetNegateResult(Negate)
self.negateResult=Negate
return self
end
function CONDITION:SetNoneResult(ReturnValue)
if not ReturnValue then
self.noneResult=false
else
self.noneResult=true
end
return self
end
function CONDITION:SetDefaultPersistence(IsPersistent)
self.defaultPersist=IsPersistent
return self
end
function CONDITION:AddFunction(Function,...)
local condition=self:_CreateCondition(0,Function,...)
table.insert(self.functionsGen,condition)
return condition
end
function CONDITION:AddFunctionAny(Function,...)
local condition=self:_CreateCondition(1,Function,...)
table.insert(self.functionsAny,condition)
return condition
end
function CONDITION:AddFunctionAll(Function,...)
local condition=self:_CreateCondition(2,Function,...)
table.insert(self.functionsAll,condition)
return condition
end
function CONDITION:RemoveFunction(ConditionFunction)
if ConditionFunction then
local data=nil
if ConditionFunction.type==0 then
data=self.functionsGen
elseif ConditionFunction.type==1 then
data=self.functionsAny
elseif ConditionFunction.type==2 then
data=self.functionsAll
end
if data then
for i=#data,1,-1 do
local cf=data[i]
if cf.uid==ConditionFunction.uid then
self:T(self.lid..string.format("Removed ConditionFunction UID=%d",cf.uid))
table.remove(data,i)
return self
end
end
end
end
return self
end
function CONDITION:RemoveNonPersistant()
for i=#self.functionsGen,1,-1 do
local cf=self.functionsGen[i]
if not cf.persistence then
table.remove(self.functionsGen,i)
end
end
for i=#self.functionsAll,1,-1 do
local cf=self.functionsAll[i]
if not cf.persistence then
table.remove(self.functionsAll,i)
end
end
for i=#self.functionsAny,1,-1 do
local cf=self.functionsAny[i]
if not cf.persistence then
table.remove(self.functionsAny,i)
end
end
return self
end
function CONDITION:Evaluate(AnyTrue)
if#self.functionsAll+#self.functionsAny+#self.functionsAll==0 then
return self.noneResult
end
local evalAny=self.isAny
if AnyTrue~=nil then
evalAny=AnyTrue
end
local isGen=nil
if evalAny then
isGen=self:_EvalConditionsAny(self.functionsGen)
else
isGen=self:_EvalConditionsAll(self.functionsGen)
end
local isAny=self:_EvalConditionsAny(self.functionsAny)
local isAll=self:_EvalConditionsAll(self.functionsAll)
local result=isGen and isAny and isAll
if self.negateResult then
result=not result
end
self:T(self.lid..string.format("Evaluate: isGen=%s, isAny=%s, isAll=%s (negate=%s) ==> result=%s",tostring(isGen),tostring(isAny),tostring(isAll),tostring(self.negateResult),tostring(result)))
return result
end
function CONDITION:_EvalConditionsAll(functions)
local gotone=false
for _,_condition in pairs(functions or{})do
local condition=_condition
gotone=true
local istrue=condition.func(unpack(condition.arg))
if not istrue then
return false
end
end
return true
end
function CONDITION:_EvalConditionsAny(functions)
local gotone=false
for _,_condition in pairs(functions or{})do
local condition=_condition
gotone=true
local istrue=condition.func(unpack(condition.arg))
if istrue then
return true
end
end
if gotone then
return false
else
return true
end
end
function CONDITION:_CreateCondition(Ftype,Function,...)
self.functionCounter=self.functionCounter+1
local condition={}
condition.uid=self.functionCounter
condition.type=Ftype or 0
condition.persistence=self.defaultPersist
condition.func=Function
condition.arg={}
if arg then
condition.arg=arg
end
return condition
end
function CONDITION.IsTimeGreater(Time,Absolute)
local Tnow=nil
if Absolute then
Tnow=timer.getAbsTime()
else
Tnow=timer.getTime()
end
if Tnow>Time then
return true
else
return false
end
return nil
end
function CONDITION.IsRandomSuccess(Probability)
Probability=Probability or 50
math.random()
math.random()
math.random()
local N=math.random()*100
if N<Probability then
return true
else
return false
end
end
function CONDITION.ReturnTrue()
return true
end
function CONDITION.ReturnFalse()
return false
end
do
USERFLAG={
ClassName="USERFLAG",
UserFlagName=nil,
}
function USERFLAG:New(UserFlagName)
local self=BASE:Inherit(self,BASE:New())
self.UserFlagName=UserFlagName
return self
end
function USERFLAG:GetName()
return self.UserFlagName
end
function USERFLAG:Set(Number,Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,USERFLAG.Set,self,Number)
else
trigger.action.setUserFlag(self.UserFlagName,Number)
end
return self
end
function USERFLAG:Get()
return trigger.misc.getUserFlag(self.UserFlagName)
end
function USERFLAG:Is(Number)
return trigger.misc.getUserFlag(self.UserFlagName)==Number
end
end
REPORT={
ClassName="REPORT",
Title="",
}
function REPORT:New(Title)
local self=BASE:Inherit(self,BASE:New())
self.Report={}
self:SetTitle(Title or"")
self:SetIndent(3)
return self
end
function REPORT:HasText()
return#self.Report>0
end
function REPORT:SetIndent(Indent)
self.Indent=Indent
return self
end
function REPORT:Add(Text)
self.Report[#self.Report+1]=Text
return self
end
function REPORT:AddIndent(Text,Separator)
self.Report[#self.Report+1]=((Separator and Separator..string.rep(" ",self.Indent-1))or string.rep(" ",self.Indent))..Text:gsub("\n","\n"..string.rep(" ",self.Indent))
return self
end
function REPORT:Text(Delimiter)
Delimiter=Delimiter or"\n"
local ReportText=(self.Title~=""and self.Title..Delimiter or self.Title)..table.concat(self.Report,Delimiter)or""
return ReportText
end
function REPORT:SetTitle(Title)
self.Title=Title
return self
end
function REPORT:GetCount()
return#self.Report
end
SCHEDULER={
ClassName="SCHEDULER",
Schedules={},
MasterObject=nil,
ShowTrace=nil,
}
function SCHEDULER:New(MasterObject,SchedulerFunction,SchedulerArguments,Start,Repeat,RandomizeFactor,Stop)
local self=BASE:Inherit(self,BASE:New())
self:F2({Start,Repeat,RandomizeFactor,Stop})
local ScheduleID=nil
self.MasterObject=MasterObject
self.ShowTrace=false
if SchedulerFunction then
ScheduleID=self:Schedule(MasterObject,SchedulerFunction,SchedulerArguments,Start,Repeat,RandomizeFactor,Stop,3)
end
return self,ScheduleID
end
function SCHEDULER:Schedule(MasterObject,SchedulerFunction,SchedulerArguments,Start,Repeat,RandomizeFactor,Stop,TraceLevel,Fsm)
self:F2({Start,Repeat,RandomizeFactor,Stop})
self:T3({SchedulerArguments})
local ObjectName="-"
if MasterObject and MasterObject.ClassName and MasterObject.ClassID then
ObjectName=MasterObject.ClassName..MasterObject.ClassID
end
self:F3({"Schedule :",ObjectName,tostring(MasterObject),Start,Repeat,RandomizeFactor,Stop})
self.MasterObject=MasterObject
local ScheduleID=_SCHEDULEDISPATCHER:AddSchedule(self,
SchedulerFunction,
SchedulerArguments,
Start,
Repeat,
RandomizeFactor,
Stop,
TraceLevel or 3,
Fsm
)
self.Schedules[#self.Schedules+1]=ScheduleID
return ScheduleID
end
function SCHEDULER:Start(ScheduleID)
self:F3({ScheduleID})
self:T(string.format("Starting scheduler ID=%s",tostring(ScheduleID)))
_SCHEDULEDISPATCHER:Start(self,ScheduleID)
end
function SCHEDULER:Stop(ScheduleID)
self:F3({ScheduleID})
self:T(string.format("Stopping scheduler ID=%s",tostring(ScheduleID)))
_SCHEDULEDISPATCHER:Stop(self,ScheduleID)
end
function SCHEDULER:Remove(ScheduleID)
self:F3({ScheduleID})
self:T(string.format("Removing scheduler ID=%s",tostring(ScheduleID)))
_SCHEDULEDISPATCHER:RemoveSchedule(self,ScheduleID)
end
function SCHEDULER:Clear()
self:F3()
self:T(string.format("Clearing scheduler"))
_SCHEDULEDISPATCHER:Clear(self)
end
function SCHEDULER:ShowTrace()
_SCHEDULEDISPATCHER:ShowTrace(self)
end
function SCHEDULER:NoTrace()
_SCHEDULEDISPATCHER:NoTrace(self)
end
SCHEDULEDISPATCHER={
ClassName="SCHEDULEDISPATCHER",
CallID=0,
PersistentSchedulers={},
ObjectSchedulers={},
Schedule=nil,
}
function SCHEDULEDISPATCHER:New()
local self=BASE:Inherit(self,BASE:New())
self:F3()
return self
end
function SCHEDULEDISPATCHER:AddSchedule(Scheduler,ScheduleFunction,ScheduleArguments,Start,Repeat,Randomize,Stop,TraceLevel,Fsm)
self:F2({Scheduler,ScheduleFunction,ScheduleArguments,Start,Repeat,Randomize,Stop,TraceLevel,Fsm})
self.CallID=self.CallID+1
local CallID=self.CallID.."#"..(Scheduler.MasterObject and Scheduler.MasterObject.GetClassNameAndID and Scheduler.MasterObject:GetClassNameAndID()or"")or""
self:T2(string.format("Adding schedule #%d CallID=%s",self.CallID,CallID))
self.PersistentSchedulers=self.PersistentSchedulers or{}
self.ObjectSchedulers=self.ObjectSchedulers or setmetatable({},{__mode="v"})
if Scheduler.MasterObject then
self.ObjectSchedulers[CallID]=Scheduler
self:F3({CallID=CallID,ObjectScheduler=tostring(self.ObjectSchedulers[CallID]),MasterObject=tostring(Scheduler.MasterObject)})
else
self.PersistentSchedulers[CallID]=Scheduler
self:F3({CallID=CallID,PersistentScheduler=self.PersistentSchedulers[CallID]})
end
self.Schedule=self.Schedule or setmetatable({},{__mode="k"})
self.Schedule[Scheduler]=self.Schedule[Scheduler]or{}
self.Schedule[Scheduler][CallID]={}
self.Schedule[Scheduler][CallID].Function=ScheduleFunction
self.Schedule[Scheduler][CallID].Arguments=ScheduleArguments
self.Schedule[Scheduler][CallID].StartTime=timer.getTime()+(Start or 0)
self.Schedule[Scheduler][CallID].Start=Start+0.001
self.Schedule[Scheduler][CallID].Repeat=Repeat or 0
self.Schedule[Scheduler][CallID].Randomize=Randomize or 0
self.Schedule[Scheduler][CallID].Stop=Stop
local Info={}
if debug then
TraceLevel=TraceLevel or 2
Info=debug.getinfo(TraceLevel,"nlS")
local name_fsm=debug.getinfo(TraceLevel-1,"n").name
if name_fsm then
Info.name=name_fsm
end
end
self:T3(self.Schedule[Scheduler][CallID])
self.Schedule[Scheduler][CallID].CallHandler=function(Params)
local CallID=Params.CallID
local Info=Params.Info or{}
local Source=Info.source or"?"
local Line=Info.currentline or"?"
local Name=Info.name or"?"
local ErrorHandler=function(errmsg)
env.info("Error in timer function: "..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
local Scheduler=self.ObjectSchedulers[CallID]
if not Scheduler then
Scheduler=self.PersistentSchedulers[CallID]
end
if Scheduler then
local MasterObject=tostring(Scheduler.MasterObject)
local Schedule=self.Schedule[Scheduler][CallID]
local SchedulerObject=Scheduler.MasterObject
local ShowTrace=Scheduler.ShowTrace
local ScheduleFunction=Schedule.Function
local ScheduleArguments=Schedule.Arguments or{}
local Start=Schedule.Start
local Repeat=Schedule.Repeat or 0
local Randomize=Schedule.Randomize or 0
local Stop=Schedule.Stop or 0
local ScheduleID=Schedule.ScheduleID
local Prefix=(Repeat==0)and"--->"or"+++>"
local Status,Result
if SchedulerObject then
local function Timer()
if ShowTrace then
SchedulerObject:T(Prefix..Name..":"..Line.." ("..Source..")")
end
return ScheduleFunction(SchedulerObject,unpack(ScheduleArguments))
end
Status,Result=xpcall(Timer,ErrorHandler)
else
local function Timer()
if ShowTrace then
self:T(Prefix..Name..":"..Line.." ("..Source..")")
end
return ScheduleFunction(unpack(ScheduleArguments))
end
Status,Result=xpcall(Timer,ErrorHandler)
end
local CurrentTime=timer.getTime()
local StartTime=Schedule.StartTime
self:F3({CallID=CallID,ScheduleID=ScheduleID,Master=MasterObject,CurrentTime=CurrentTime,StartTime=StartTime,Start=Start,Repeat=Repeat,Randomize=Randomize,Stop=Stop})
if Status and((Result==nil)or(Result and Result~=false))then
if Repeat~=0 and((Stop==0)or(Stop~=0 and CurrentTime<=StartTime+Stop))then
local ScheduleTime=CurrentTime+Repeat+math.random(-(Randomize*Repeat/2),(Randomize*Repeat/2))+0.0001
return ScheduleTime
else
self:Stop(Scheduler,CallID)
end
else
self:Stop(Scheduler,CallID)
end
else
self:I("<<<>"..Name..":"..Line.." ("..Source..")")
end
return nil
end
self:Start(Scheduler,CallID,Info)
return CallID
end
function SCHEDULEDISPATCHER:RemoveSchedule(Scheduler,CallID)
self:F2({Remove=CallID,Scheduler=Scheduler})
if CallID then
self:Stop(Scheduler,CallID)
self.Schedule[Scheduler][CallID]=nil
end
end
function SCHEDULEDISPATCHER:Start(Scheduler,CallID,Info)
self:F2({Start=CallID,Scheduler=Scheduler})
if CallID then
local Schedule=self.Schedule[Scheduler][CallID]
if not Schedule.ScheduleID then
local Tnow=timer.getTime()
Schedule.StartTime=Tnow
Schedule.ScheduleID=timer.scheduleFunction(Schedule.CallHandler,{CallID=CallID,Info=Info},Tnow+Schedule.Start)
self:T(string.format("Starting SCHEDULEDISPATCHER Call ID=%s ==> Schedule ID=%s",tostring(CallID),tostring(Schedule.ScheduleID)))
end
else
for CallID,Schedule in pairs(self.Schedule[Scheduler]or{})do
self:Start(Scheduler,CallID,Info)
end
end
end
function SCHEDULEDISPATCHER:Stop(Scheduler,CallID)
self:F2({Stop=CallID,Scheduler=Scheduler})
if CallID then
local Schedule=self.Schedule[Scheduler][CallID]
if Schedule.ScheduleID then
self:T(string.format("SCHEDULEDISPATCHER stopping scheduler CallID=%s, ScheduleID=%s",tostring(CallID),tostring(Schedule.ScheduleID)))
timer.removeFunction(Schedule.ScheduleID)
Schedule.ScheduleID=nil
else
self:T(string.format("Error no ScheduleID for CallID=%s",tostring(CallID)))
end
else
for CallID,Schedule in pairs(self.Schedule[Scheduler]or{})do
self:Stop(Scheduler,CallID)
end
end
end
function SCHEDULEDISPATCHER:Clear(Scheduler)
self:F2({Scheduler=Scheduler})
for CallID,Schedule in pairs(self.Schedule[Scheduler]or{})do
self:Stop(Scheduler,CallID)
end
end
function SCHEDULEDISPATCHER:ShowTrace(Scheduler)
self:F2({Scheduler=Scheduler})
Scheduler.ShowTrace=true
end
function SCHEDULEDISPATCHER:NoTrace(Scheduler)
self:F2({Scheduler=Scheduler})
Scheduler.ShowTrace=false
end
EVENT={
ClassName="EVENT",
ClassID=0,
MissionEnd=false,
}
world.event.S_EVENT_NEW_CARGO=world.event.S_EVENT_MAX+1000
world.event.S_EVENT_DELETE_CARGO=world.event.S_EVENT_MAX+1001
world.event.S_EVENT_NEW_ZONE=world.event.S_EVENT_MAX+1002
world.event.S_EVENT_DELETE_ZONE=world.event.S_EVENT_MAX+1003
world.event.S_EVENT_NEW_ZONE_GOAL=world.event.S_EVENT_MAX+1004
world.event.S_EVENT_DELETE_ZONE_GOAL=world.event.S_EVENT_MAX+1005
world.event.S_EVENT_REMOVE_UNIT=world.event.S_EVENT_MAX+1006
world.event.S_EVENT_PLAYER_ENTER_AIRCRAFT=world.event.S_EVENT_MAX+1007
world.event.S_EVENT_NEW_DYNAMIC_CARGO=world.event.S_EVENT_MAX+1008
world.event.S_EVENT_DYNAMIC_CARGO_LOADED=world.event.S_EVENT_MAX+1009
world.event.S_EVENT_DYNAMIC_CARGO_UNLOADED=world.event.S_EVENT_MAX+1010
world.event.S_EVENT_DYNAMIC_CARGO_REMOVED=world.event.S_EVENT_MAX+1011
EVENTS={
Shot=world.event.S_EVENT_SHOT,
Hit=world.event.S_EVENT_HIT,
Takeoff=world.event.S_EVENT_TAKEOFF,
Land=world.event.S_EVENT_LAND,
Crash=world.event.S_EVENT_CRASH,
Ejection=world.event.S_EVENT_EJECTION,
Refueling=world.event.S_EVENT_REFUELING,
Dead=world.event.S_EVENT_DEAD,
PilotDead=world.event.S_EVENT_PILOT_DEAD,
BaseCaptured=world.event.S_EVENT_BASE_CAPTURED,
MissionStart=world.event.S_EVENT_MISSION_START,
MissionEnd=world.event.S_EVENT_MISSION_END,
TookControl=world.event.S_EVENT_TOOK_CONTROL,
RefuelingStop=world.event.S_EVENT_REFUELING_STOP,
Birth=world.event.S_EVENT_BIRTH,
HumanFailure=world.event.S_EVENT_HUMAN_FAILURE,
EngineStartup=world.event.S_EVENT_ENGINE_STARTUP,
EngineShutdown=world.event.S_EVENT_ENGINE_SHUTDOWN,
PlayerEnterUnit=world.event.S_EVENT_PLAYER_ENTER_UNIT,
PlayerLeaveUnit=world.event.S_EVENT_PLAYER_LEAVE_UNIT,
PlayerComment=world.event.S_EVENT_PLAYER_COMMENT,
ShootingStart=world.event.S_EVENT_SHOOTING_START,
ShootingEnd=world.event.S_EVENT_SHOOTING_END,
MarkAdded=world.event.S_EVENT_MARK_ADDED,
MarkChange=world.event.S_EVENT_MARK_CHANGE,
MarkRemoved=world.event.S_EVENT_MARK_REMOVED,
NewCargo=world.event.S_EVENT_NEW_CARGO,
DeleteCargo=world.event.S_EVENT_DELETE_CARGO,
NewZone=world.event.S_EVENT_NEW_ZONE,
DeleteZone=world.event.S_EVENT_DELETE_ZONE,
NewZoneGoal=world.event.S_EVENT_NEW_ZONE_GOAL,
DeleteZoneGoal=world.event.S_EVENT_DELETE_ZONE_GOAL,
RemoveUnit=world.event.S_EVENT_REMOVE_UNIT,
PlayerEnterAircraft=world.event.S_EVENT_PLAYER_ENTER_AIRCRAFT,
DetailedFailure=world.event.S_EVENT_DETAILED_FAILURE or-1,
Kill=world.event.S_EVENT_KILL or-1,
Score=world.event.S_EVENT_SCORE or-1,
UnitLost=world.event.S_EVENT_UNIT_LOST or-1,
LandingAfterEjection=world.event.S_EVENT_LANDING_AFTER_EJECTION or-1,
ParatrooperLanding=world.event.S_EVENT_PARATROOPER_LENDING or-1,
DiscardChairAfterEjection=world.event.S_EVENT_DISCARD_CHAIR_AFTER_EJECTION or-1,
WeaponAdd=world.event.S_EVENT_WEAPON_ADD or-1,
TriggerZone=world.event.S_EVENT_TRIGGER_ZONE or-1,
LandingQualityMark=world.event.S_EVENT_LANDING_QUALITY_MARK or-1,
BDA=world.event.S_EVENT_BDA or-1,
AIAbortMission=world.event.S_EVENT_AI_ABORT_MISSION or-1,
DayNight=world.event.S_EVENT_DAYNIGHT or-1,
FlightTime=world.event.S_EVENT_FLIGHT_TIME or-1,
SelfKillPilot=world.event.S_EVENT_PLAYER_SELF_KILL_PILOT or-1,
PlayerCaptureAirfield=world.event.S_EVENT_PLAYER_CAPTURE_AIRFIELD or-1,
EmergencyLanding=world.event.S_EVENT_EMERGENCY_LANDING or-1,
UnitCreateTask=world.event.S_EVENT_UNIT_CREATE_TASK or-1,
UnitDeleteTask=world.event.S_EVENT_UNIT_DELETE_TASK or-1,
SimulationStart=world.event.S_EVENT_SIMULATION_START or-1,
WeaponRearm=world.event.S_EVENT_WEAPON_REARM or-1,
WeaponDrop=world.event.S_EVENT_WEAPON_DROP or-1,
UnitTaskComplete=world.event.S_EVENT_UNIT_TASK_COMPLETE or-1,
UnitTaskStage=world.event.S_EVENT_UNIT_TASK_STAGE or-1,
MacExtraScore=world.event.S_EVENT_MAC_EXTRA_SCORE or-1,
MissionRestart=world.event.S_EVENT_MISSION_RESTART or-1,
MissionWinner=world.event.S_EVENT_MISSION_WINNER or-1,
RunwayTakeoff=world.event.S_EVENT_RUNWAY_TAKEOFF or-1,
RunwayTouch=world.event.S_EVENT_RUNWAY_TOUCH or-1,
MacLMSRestart=world.event.S_EVENT_MAC_LMS_RESTART or-1,
SimulationFreeze=world.event.S_EVENT_SIMULATION_FREEZE or-1,
SimulationUnfreeze=world.event.S_EVENT_SIMULATION_UNFREEZE or-1,
HumanAircraftRepairStart=world.event.S_EVENT_HUMAN_AIRCRAFT_REPAIR_START or-1,
HumanAircraftRepairFinish=world.event.S_EVENT_HUMAN_AIRCRAFT_REPAIR_FINISH or-1,
NewDynamicCargo=world.event.S_EVENT_NEW_DYNAMIC_CARGO or-1,
DynamicCargoLoaded=world.event.S_EVENT_DYNAMIC_CARGO_LOADED or-1,
DynamicCargoUnloaded=world.event.S_EVENT_DYNAMIC_CARGO_UNLOADED or-1,
DynamicCargoRemoved=world.event.S_EVENT_DYNAMIC_CARGO_REMOVED or-1,
}
local _EVENTMETA={
[world.event.S_EVENT_SHOT]={
Order=1,
Side="I",
Event="OnEventShot",
Text="S_EVENT_SHOT"
},
[world.event.S_EVENT_HIT]={
Order=1,
Side="T",
Event="OnEventHit",
Text="S_EVENT_HIT"
},
[world.event.S_EVENT_TAKEOFF]={
Order=1,
Side="I",
Event="OnEventTakeoff",
Text="S_EVENT_TAKEOFF"
},
[world.event.S_EVENT_LAND]={
Order=1,
Side="I",
Event="OnEventLand",
Text="S_EVENT_LAND"
},
[world.event.S_EVENT_CRASH]={
Order=-1,
Side="I",
Event="OnEventCrash",
Text="S_EVENT_CRASH"
},
[world.event.S_EVENT_EJECTION]={
Order=1,
Side="I",
Event="OnEventEjection",
Text="S_EVENT_EJECTION"
},
[world.event.S_EVENT_REFUELING]={
Order=1,
Side="I",
Event="OnEventRefueling",
Text="S_EVENT_REFUELING"
},
[world.event.S_EVENT_DEAD]={
Order=-1,
Side="I",
Event="OnEventDead",
Text="S_EVENT_DEAD"
},
[world.event.S_EVENT_PILOT_DEAD]={
Order=1,
Side="I",
Event="OnEventPilotDead",
Text="S_EVENT_PILOT_DEAD"
},
[world.event.S_EVENT_BASE_CAPTURED]={
Order=1,
Side="I",
Event="OnEventBaseCaptured",
Text="S_EVENT_BASE_CAPTURED"
},
[world.event.S_EVENT_MISSION_START]={
Order=1,
Side="N",
Event="OnEventMissionStart",
Text="S_EVENT_MISSION_START"
},
[world.event.S_EVENT_MISSION_END]={
Order=1,
Side="N",
Event="OnEventMissionEnd",
Text="S_EVENT_MISSION_END"
},
[world.event.S_EVENT_TOOK_CONTROL]={
Order=1,
Side="N",
Event="OnEventTookControl",
Text="S_EVENT_TOOK_CONTROL"
},
[world.event.S_EVENT_REFUELING_STOP]={
Order=1,
Side="I",
Event="OnEventRefuelingStop",
Text="S_EVENT_REFUELING_STOP"
},
[world.event.S_EVENT_BIRTH]={
Order=1,
Side="I",
Event="OnEventBirth",
Text="S_EVENT_BIRTH"
},
[world.event.S_EVENT_HUMAN_FAILURE]={
Order=1,
Side="I",
Event="OnEventHumanFailure",
Text="S_EVENT_HUMAN_FAILURE"
},
[world.event.S_EVENT_ENGINE_STARTUP]={
Order=1,
Side="I",
Event="OnEventEngineStartup",
Text="S_EVENT_ENGINE_STARTUP"
},
[world.event.S_EVENT_ENGINE_SHUTDOWN]={
Order=1,
Side="I",
Event="OnEventEngineShutdown",
Text="S_EVENT_ENGINE_SHUTDOWN"
},
[world.event.S_EVENT_PLAYER_ENTER_UNIT]={
Order=1,
Side="I",
Event="OnEventPlayerEnterUnit",
Text="S_EVENT_PLAYER_ENTER_UNIT"
},
[world.event.S_EVENT_PLAYER_LEAVE_UNIT]={
Order=-1,
Side="I",
Event="OnEventPlayerLeaveUnit",
Text="S_EVENT_PLAYER_LEAVE_UNIT"
},
[world.event.S_EVENT_PLAYER_COMMENT]={
Order=1,
Side="I",
Event="OnEventPlayerComment",
Text="S_EVENT_PLAYER_COMMENT"
},
[world.event.S_EVENT_SHOOTING_START]={
Order=1,
Side="I",
Event="OnEventShootingStart",
Text="S_EVENT_SHOOTING_START"
},
[world.event.S_EVENT_SHOOTING_END]={
Order=1,
Side="I",
Event="OnEventShootingEnd",
Text="S_EVENT_SHOOTING_END"
},
[world.event.S_EVENT_MARK_ADDED]={
Order=1,
Side="I",
Event="OnEventMarkAdded",
Text="S_EVENT_MARK_ADDED"
},
[world.event.S_EVENT_MARK_CHANGE]={
Order=1,
Side="I",
Event="OnEventMarkChange",
Text="S_EVENT_MARK_CHANGE"
},
[world.event.S_EVENT_MARK_REMOVED]={
Order=1,
Side="I",
Event="OnEventMarkRemoved",
Text="S_EVENT_MARK_REMOVED"
},
[EVENTS.NewCargo]={
Order=1,
Event="OnEventNewCargo",
Text="S_EVENT_NEW_CARGO"
},
[EVENTS.DeleteCargo]={
Order=1,
Event="OnEventDeleteCargo",
Text="S_EVENT_DELETE_CARGO"
},
[EVENTS.NewZone]={
Order=1,
Event="OnEventNewZone",
Text="S_EVENT_NEW_ZONE"
},
[EVENTS.DeleteZone]={
Order=1,
Event="OnEventDeleteZone",
Text="S_EVENT_DELETE_ZONE"
},
[EVENTS.NewZoneGoal]={
Order=1,
Event="OnEventNewZoneGoal",
Text="S_EVENT_NEW_ZONE_GOAL"
},
[EVENTS.DeleteZoneGoal]={
Order=1,
Event="OnEventDeleteZoneGoal",
Text="S_EVENT_DELETE_ZONE_GOAL"
},
[EVENTS.RemoveUnit]={
Order=-1,
Event="OnEventRemoveUnit",
Text="S_EVENT_REMOVE_UNIT"
},
[EVENTS.PlayerEnterAircraft]={
Order=1,
Event="OnEventPlayerEnterAircraft",
Text="S_EVENT_PLAYER_ENTER_AIRCRAFT"
},
[EVENTS.DetailedFailure]={
Order=1,
Event="OnEventDetailedFailure",
Text="S_EVENT_DETAILED_FAILURE"
},
[EVENTS.Kill]={
Order=1,
Event="OnEventKill",
Text="S_EVENT_KILL"
},
[EVENTS.Score]={
Order=1,
Event="OnEventScore",
Text="S_EVENT_SCORE"
},
[EVENTS.UnitLost]={
Order=1,
Event="OnEventUnitLost",
Text="S_EVENT_UNIT_LOST"
},
[EVENTS.LandingAfterEjection]={
Order=1,
Event="OnEventLandingAfterEjection",
Text="S_EVENT_LANDING_AFTER_EJECTION"
},
[EVENTS.ParatrooperLanding]={
Order=1,
Event="OnEventParatrooperLanding",
Text="S_EVENT_PARATROOPER_LENDING"
},
[EVENTS.DiscardChairAfterEjection]={
Order=1,
Event="OnEventDiscardChairAfterEjection",
Text="S_EVENT_DISCARD_CHAIR_AFTER_EJECTION"
},
[EVENTS.WeaponAdd]={
Order=1,
Event="OnEventWeaponAdd",
Text="S_EVENT_WEAPON_ADD"
},
[EVENTS.TriggerZone]={
Order=1,
Event="OnEventTriggerZone",
Text="S_EVENT_TRIGGER_ZONE"
},
[EVENTS.LandingQualityMark]={
Order=1,
Event="OnEventLandingQualityMark",
Text="S_EVENT_LANDING_QUALITYMARK"
},
[EVENTS.BDA]={
Order=1,
Event="OnEventBDA",
Text="S_EVENT_BDA"
},
[EVENTS.AIAbortMission]={
Order=1,
Side="I",
Event="OnEventAIAbortMission",
Text="S_EVENT_AI_ABORT_MISSION"
},
[EVENTS.DayNight]={
Order=1,
Event="OnEventDayNight",
Text="S_EVENT_DAYNIGHT"
},
[EVENTS.FlightTime]={
Order=1,
Event="OnEventFlightTime",
Text="S_EVENT_FLIGHT_TIME"
},
[EVENTS.SelfKillPilot]={
Order=1,
Side="I",
Event="OnEventSelfKillPilot",
Text="S_EVENT_PLAYER_SELF_KILL_PILOT"
},
[EVENTS.PlayerCaptureAirfield]={
Order=1,
Event="OnEventPlayerCaptureAirfield",
Text="S_EVENT_PLAYER_CAPTURE_AIRFIELD"
},
[EVENTS.EmergencyLanding]={
Order=1,
Side="I",
Event="OnEventEmergencyLanding",
Text="S_EVENT_EMERGENCY_LANDING"
},
[EVENTS.UnitCreateTask]={
Order=1,
Event="OnEventUnitCreateTask",
Text="S_EVENT_UNIT_CREATE_TASK"
},
[EVENTS.UnitDeleteTask]={
Order=1,
Event="OnEventUnitDeleteTask",
Text="S_EVENT_UNIT_DELETE_TASK"
},
[EVENTS.SimulationStart]={
Order=1,
Event="OnEventSimulationStart",
Text="S_EVENT_SIMULATION_START"
},
[EVENTS.WeaponRearm]={
Order=1,
Side="I",
Event="OnEventWeaponRearm",
Text="S_EVENT_WEAPON_REARM"
},
[EVENTS.WeaponDrop]={
Order=1,
Side="I",
Event="OnEventWeaponDrop",
Text="S_EVENT_WEAPON_DROP"
},
[EVENTS.UnitTaskStage]={
Order=1,
Side="I",
Event="OnEventUnitTaskStage",
Text="S_EVENT_UNIT_TASK_STAGE "
},
[EVENTS.MacExtraScore]={
Order=1,
Side="I",
Event="OnEventMacExtraScore",
Text="S_EVENT_MAC_EXTRA_SCOREP"
},
[EVENTS.MissionRestart]={
Order=1,
Side="I",
Event="OnEventMissionRestart",
Text="S_EVENT_MISSION_RESTART"
},
[EVENTS.MissionWinner]={
Order=1,
Side="I",
Event="OnEventMissionWinner",
Text="S_EVENT_MISSION_WINNER"
},
[EVENTS.RunwayTakeoff]={
Order=1,
Side="I",
Event="OnEventRunwayTakeoff",
Text="S_EVENT_RUNWAY_TAKEOFF"
},
[EVENTS.RunwayTouch]={
Order=1,
Side="I",
Event="OnEventRunwayTouch",
Text="S_EVENT_RUNWAY_TOUCH"
},
[EVENTS.MacLMSRestart]={
Order=1,
Side="I",
Event="OnEventMacLMSRestart",
Text="S_EVENT_MAC_LMS_RESTART"
},
[EVENTS.SimulationFreeze]={
Order=1,
Side="I",
Event="OnEventSimulationFreeze",
Text="S_EVENT_SIMULATION_FREEZE"
},
[EVENTS.SimulationUnfreeze]={
Order=1,
Side="I",
Event="OnEventSimulationUnfreeze",
Text="S_EVENT_SIMULATION_UNFREEZE"
},
[EVENTS.HumanAircraftRepairStart]={
Order=1,
Side="I",
Event="OnEventHumanAircraftRepairStart",
Text="S_EVENT_HUMAN_AIRCRAFT_REPAIR_START"
},
[EVENTS.HumanAircraftRepairFinish]={
Order=1,
Side="I",
Event="OnEventHumanAircraftRepairFinish",
Text="S_EVENT_HUMAN_AIRCRAFT_REPAIR_FINISH"
},
[EVENTS.NewDynamicCargo]={
Order=1,
Side="I",
Event="OnEventNewDynamicCargo",
Text="S_EVENT_NEW_DYNAMIC_CARGO"
},
[EVENTS.DynamicCargoLoaded]={
Order=1,
Side="I",
Event="OnEventDynamicCargoLoaded",
Text="S_EVENT_DYNAMIC_CARGO_LOADED"
},
[EVENTS.DynamicCargoUnloaded]={
Order=1,
Side="I",
Event="OnEventDynamicCargoUnloaded",
Text="S_EVENT_DYNAMIC_CARGO_UNLOADED"
},
[EVENTS.DynamicCargoRemoved]={
Order=1,
Side="I",
Event="OnEventDynamicCargoRemoved",
Text="S_EVENT_DYNAMIC_CARGO_REMOVED"
},
}
function EVENT:New()
local self=BASE:Inherit(self,BASE:New())
self.EventHandler=world.addEventHandler(self)
return self
end
function EVENT:Init(EventID,EventClass)
self:F3({_EVENTMETA[EventID].Text,EventClass})
if not self.Events[EventID]then
self.Events[EventID]={}
end
local EventPriority=EventClass:GetEventPriority()
if not self.Events[EventID][EventPriority]then
self.Events[EventID][EventPriority]=setmetatable({},{__mode="k"})
end
if not self.Events[EventID][EventPriority][EventClass]then
self.Events[EventID][EventPriority][EventClass]={}
end
return self.Events[EventID][EventPriority][EventClass]
end
function EVENT:RemoveEvent(EventClass,EventID)
self:F2({"Removing subscription for class: ",EventClass:GetClassNameAndID()})
local EventPriority=EventClass:GetEventPriority()
self.Events=self.Events or{}
self.Events[EventID]=self.Events[EventID]or{}
self.Events[EventID][EventPriority]=self.Events[EventID][EventPriority]or{}
self.Events[EventID][EventPriority][EventClass]=nil
return self
end
function EVENT:Reset(EventObject)
self:F({"Resetting subscriptions for class: ",EventObject:GetClassNameAndID()})
local EventPriority=EventObject:GetEventPriority()
for EventID,EventData in pairs(self.Events)do
if self.EventsDead then
if self.EventsDead[EventID]then
if self.EventsDead[EventID][EventPriority]then
if self.EventsDead[EventID][EventPriority][EventObject]then
self.Events[EventID][EventPriority][EventObject]=self.EventsDead[EventID][EventPriority][EventObject]
end
end
end
end
end
end
function EVENT:RemoveAll(EventClass)
local EventClassName=EventClass:GetClassNameAndID()
local EventPriority=EventClass:GetEventPriority()
for EventID,EventData in pairs(self.Events)do
self.Events[EventID][EventPriority][EventClass]=nil
end
return self
end
function EVENT:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EventID)
self:F2(EventTemplate.name)
for EventUnitID,EventUnit in pairs(EventTemplate.units)do
self:OnEventForUnit(EventUnit.name,EventFunction,EventClass,EventID)
end
return self
end
function EVENT:OnEventGeneric(EventFunction,EventClass,EventID)
self:F2({EventID,EventClass,EventFunction})
local EventData=self:Init(EventID,EventClass)
EventData.EventFunction=EventFunction
return self
end
function EVENT:OnEventForUnit(UnitName,EventFunction,EventClass,EventID)
self:F2(UnitName)
local EventData=self:Init(EventID,EventClass)
EventData.EventUnit=true
EventData.EventFunction=EventFunction
return self
end
function EVENT:OnEventForGroup(GroupName,EventFunction,EventClass,EventID,...)
local Event=self:Init(EventID,EventClass)
Event.EventGroup=true
Event.EventFunction=EventFunction
Event.Params=arg
return self
end
do
function EVENT:OnBirthForTemplate(EventTemplate,EventFunction,EventClass)
self:F2(EventTemplate.name)
self:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EVENTS.Birth)
return self
end
end
do
function EVENT:OnCrashForTemplate(EventTemplate,EventFunction,EventClass)
self:F2(EventTemplate.name)
self:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EVENTS.Crash)
return self
end
end
do
function EVENT:OnDeadForTemplate(EventTemplate,EventFunction,EventClass)
self:F2(EventTemplate.name)
self:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EVENTS.Dead)
return self
end
end
do
function EVENT:OnLandForTemplate(EventTemplate,EventFunction,EventClass)
self:F2(EventTemplate.name)
self:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EVENTS.Land)
return self
end
end
do
function EVENT:OnTakeOffForTemplate(EventTemplate,EventFunction,EventClass)
self:F2(EventTemplate.name)
self:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EVENTS.Takeoff)
return self
end
end
do
function EVENT:OnEngineShutDownForTemplate(EventTemplate,EventFunction,EventClass)
self:F2(EventTemplate.name)
self:OnEventForTemplate(EventTemplate,EventFunction,EventClass,EVENTS.EngineShutdown)
return self
end
end
do
function EVENT:CreateEventNewCargo(Cargo)
self:F({Cargo})
local Event={
id=EVENTS.NewCargo,
time=timer.getTime(),
cargo=Cargo,
}
world.onEvent(Event)
end
function EVENT:CreateEventDeleteCargo(Cargo)
self:F({Cargo})
local Event={
id=EVENTS.DeleteCargo,
time=timer.getTime(),
cargo=Cargo,
}
world.onEvent(Event)
end
function EVENT:CreateEventNewZone(Zone)
self:F({Zone})
local Event={
id=EVENTS.NewZone,
time=timer.getTime(),
zone=Zone,
}
world.onEvent(Event)
end
function EVENT:CreateEventDeleteZone(Zone)
self:F({Zone})
local Event={
id=EVENTS.DeleteZone,
time=timer.getTime(),
zone=Zone,
}
world.onEvent(Event)
end
function EVENT:CreateEventNewZoneGoal(ZoneGoal)
self:F({ZoneGoal})
local Event={
id=EVENTS.NewZoneGoal,
time=timer.getTime(),
ZoneGoal=ZoneGoal,
}
world.onEvent(Event)
end
function EVENT:CreateEventDeleteZoneGoal(ZoneGoal)
self:F({ZoneGoal})
local Event={
id=EVENTS.DeleteZoneGoal,
time=timer.getTime(),
ZoneGoal=ZoneGoal,
}
world.onEvent(Event)
end
function EVENT:CreateEventPlayerEnterUnit(PlayerUnit)
self:F({PlayerUnit})
local Event={
id=EVENTS.PlayerEnterUnit,
time=timer.getTime(),
initiator=PlayerUnit:GetDCSObject()
}
world.onEvent(Event)
end
function EVENT:CreateEventPlayerEnterAircraft(PlayerUnit)
self:F({PlayerUnit})
local Event={
id=EVENTS.PlayerEnterAircraft,
time=timer.getTime(),
initiator=PlayerUnit:GetDCSObject()
}
world.onEvent(Event)
end
function EVENT:CreateEventNewDynamicCargo(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.NewDynamicCargo,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function EVENT:CreateEventDynamicCargoLoaded(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.DynamicCargoLoaded,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function EVENT:CreateEventDynamicCargoUnloaded(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.DynamicCargoUnloaded,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
function EVENT:CreateEventDynamicCargoRemoved(DynamicCargo)
self:F({DynamicCargo})
local Event={
id=EVENTS.DynamicCargoRemoved,
time=timer.getTime(),
dynamiccargo=DynamicCargo,
initiator=DynamicCargo:GetDCSObject(),
}
world.onEvent(Event)
end
end
function EVENT:onEvent(Event)
local ErrorHandler=function(errmsg)
env.info("Error in SCHEDULER function:"..errmsg)
if BASE.Debug~=nil then
env.info(debug.traceback())
end
return errmsg
end
local EventMeta=_EVENTMETA[Event.id]
if EventMeta then
if self and self.Events and self.Events[Event.id]and self.MissionEnd==false and(Event.initiator~=nil or(Event.initiator==nil and Event.id~=EVENTS.PlayerLeaveUnit))then
if Event.id and Event.id==EVENTS.MissionEnd then
self.MissionEnd=true
end
if Event.initiator then
Event.IniObjectCategory=Object.getCategory(Event.initiator)
if Event.IniObjectCategory==Object.Category.STATIC then
if Event.id==31 then
Event.IniDCSUnit=Event.initiator
local ID=Event.initiator.id_
Event.IniDCSUnitName=string.format("Ejected Pilot ID %s",tostring(ID))
Event.IniUnitName=Event.IniDCSUnitName
Event.IniCoalition=0
Event.IniCategory=0
Event.IniTypeName="Ejected Pilot"
elseif Event.id==33 then
Event.IniDCSUnit=Event.initiator
local ID=Event.initiator.id_
Event.IniDCSUnitName=string.format("Ejection Seat ID %s",tostring(ID))
Event.IniUnitName=Event.IniDCSUnitName
Event.IniCoalition=0
Event.IniCategory=0
Event.IniTypeName="Ejection Seat"
else
Event.IniDCSUnit=Event.initiator
Event.IniDCSUnitName=Event.IniDCSUnit:getName()
Event.IniUnitName=Event.IniDCSUnitName
Event.IniUnit=STATIC:FindByName(Event.IniDCSUnitName,false)
Event.IniCoalition=Event.IniDCSUnit:getCoalition()
Event.IniCategory=Event.IniDCSUnit:getDesc().category
Event.IniTypeName=Event.IniDCSUnit:getTypeName()
end
local Unit=UNIT:FindByName(Event.IniDCSUnitName)
if Unit then
Event.IniObjectCategory=Object.Category.UNIT
end
elseif Event.IniObjectCategory==Object.Category.UNIT then
Event.IniDCSUnit=Event.initiator
Event.IniDCSUnitName=Event.IniDCSUnit:getName()
Event.IniUnitName=Event.IniDCSUnitName
Event.IniDCSGroup=Event.IniDCSUnit:getGroup()
Event.IniUnit=UNIT:FindByName(Event.IniDCSUnitName)
if not Event.IniUnit then
Event.IniUnit=CLIENT:FindByName(Event.IniDCSUnitName,'',true)
end
Event.IniDCSGroupName=Event.IniUnit and Event.IniUnit.GroupName or""
Event.IniGroupName=Event.IniDCSGroupName
if Event.IniDCSGroup and Event.IniDCSGroup:isExist()then
Event.IniDCSGroupName=Event.IniDCSGroup:getName()
Event.IniGroup=GROUP:FindByName(Event.IniDCSGroupName)
Event.IniGroupName=Event.IniDCSGroupName
end
Event.IniPlayerName=Event.IniDCSUnit:getPlayerName()
if Event.IniPlayerName then
local PID=NET.GetPlayerIDByName(nil,Event.IniPlayerName)
if PID then
Event.IniPlayerUCID=net.get_player_info(tonumber(PID),'ucid')
end
end
Event.IniCoalition=Event.IniDCSUnit:getCoalition()
Event.IniTypeName=Event.IniDCSUnit:getTypeName()
Event.IniCategory=Event.IniDCSUnit:getDesc().category
elseif Event.IniObjectCategory==Object.Category.CARGO then
Event.IniDCSUnit=Event.initiator
Event.IniDCSUnitName=Event.IniDCSUnit:getName()
Event.IniUnitName=Event.IniDCSUnitName
if string.match(Event.IniUnitName,".+|%d%d:%d%d|PKG%d+")then
Event.IniDynamicCargo=DYNAMICCARGO:FindByName(Event.IniUnitName)
Event.IniDynamicCargoName=Event.IniUnitName
Event.IniPlayerName=string.match(Event.IniUnitName,"^(.+)|%d%d:%d%d|PKG%d+")
else
Event.IniUnit=STATIC:FindByName(Event.IniDCSUnitName,false)
end
Event.IniCoalition=Event.IniDCSUnit:getCoalition()
Event.IniCategory=Event.IniDCSUnit:getDesc().category
Event.IniTypeName=Event.IniDCSUnit:getTypeName()
elseif Event.IniObjectCategory==Object.Category.SCENERY then
Event.IniDCSUnit=Event.initiator
Event.IniDCSUnitName=(Event.IniDCSUnit and Event.IniDCSUnit.getName)and Event.IniDCSUnit:getName()or"Scenery no name "..math.random(1,20000)
Event.IniUnitName=Event.IniDCSUnitName
Event.IniUnit=SCENERY:Register(Event.IniDCSUnitName,Event.initiator)
Event.IniCategory=(Event.IniDCSUnit and Event.IniDCSUnit.getDesc)and Event.IniDCSUnit:getDesc().category
Event.IniTypeName=(Event.initiator and Event.initiator.isExist
and Event.initiator:isExist()and Event.IniDCSUnit and Event.IniDCSUnit.getTypeName)and Event.IniDCSUnit:getTypeName()or"SCENERY"
elseif Event.IniObjectCategory==Object.Category.BASE then
Event.IniDCSUnit=Event.initiator
Event.IniDCSUnitName=Event.IniDCSUnit:getName()
Event.IniUnitName=Event.IniDCSUnitName
Event.IniUnit=AIRBASE:FindByName(Event.IniDCSUnitName)
Event.IniCoalition=Event.IniDCSUnit:getCoalition()
Event.IniCategory=Event.IniDCSUnit:getDesc().category
Event.IniTypeName=Event.IniDCSUnit:getTypeName()
if not Event.IniUnit then
_DATABASE:_RegisterAirbase(Event.initiator)
Event.IniUnit=AIRBASE:FindByName(Event.IniDCSUnitName)
end
end
end
if Event.target then
Event.TgtObjectCategory=Object.getCategory(Event.target)
if Event.TgtObjectCategory==Object.Category.UNIT then
Event.TgtDCSUnit=Event.target
Event.TgtDCSGroup=Event.TgtDCSUnit:getGroup()
Event.TgtDCSUnitName=Event.TgtDCSUnit:getName()
Event.TgtUnitName=Event.TgtDCSUnitName
Event.TgtUnit=UNIT:FindByName(Event.TgtDCSUnitName)
Event.TgtDCSGroupName=""
if Event.TgtDCSGroup and Event.TgtDCSGroup:isExist()then
Event.TgtDCSGroupName=Event.TgtDCSGroup:getName()
Event.TgtGroup=GROUP:FindByName(Event.TgtDCSGroupName)
Event.TgtGroupName=Event.TgtDCSGroupName
end
Event.TgtPlayerName=Event.TgtDCSUnit:getPlayerName()
if Event.TgtPlayerName then
local PID=NET.GetPlayerIDByName(nil,Event.TgtPlayerName)
if PID then
Event.TgtPlayerUCID=net.get_player_info(tonumber(PID),'ucid')
end
end
Event.TgtCoalition=Event.TgtDCSUnit:getCoalition()
Event.TgtCategory=Event.TgtDCSUnit:getDesc().category
Event.TgtTypeName=Event.TgtDCSUnit:getTypeName()
elseif Event.TgtObjectCategory==Object.Category.STATIC then
Event.TgtDCSUnit=Event.target
if Event.target.isExist and Event.target:isExist()and Event.id~=33 then
Event.TgtDCSUnitName=Event.TgtDCSUnit:getName()
if Event.TgtDCSUnitName and Event.TgtDCSUnitName~=""then
Event.TgtUnitName=Event.TgtDCSUnitName
Event.TgtUnit=STATIC:FindByName(Event.TgtDCSUnitName,false)
Event.TgtCoalition=Event.TgtDCSUnit:getCoalition()
Event.TgtCategory=Event.TgtDCSUnit:getDesc().category
Event.TgtTypeName=Event.TgtDCSUnit:getTypeName()
end
else
Event.TgtDCSUnitName=string.format("No target object for Event ID %s",tostring(Event.id))
Event.TgtUnitName=Event.TgtDCSUnitName
Event.TgtUnit=nil
Event.TgtCoalition=0
Event.TgtCategory=0
if Event.id==6 then
Event.TgtTypeName="Ejected Pilot"
Event.TgtDCSUnitName=string.format("Ejected Pilot ID %s",tostring(Event.IniDCSUnitName))
Event.TgtUnitName=Event.TgtDCSUnitName
elseif Event.id==33 then
Event.TgtTypeName="Ejection Seat"
Event.TgtDCSUnitName=string.format("Ejection Seat ID %s",tostring(Event.IniDCSUnitName))
Event.TgtUnitName=Event.TgtDCSUnitName
else
Event.TgtTypeName="Static"
end
end
elseif Event.TgtObjectCategory==Object.Category.SCENERY then
Event.TgtDCSUnit=Event.target
Event.TgtDCSUnitName=Event.TgtDCSUnit.getName and Event.TgtDCSUnit.getName()or nil
if Event.TgtDCSUnitName~=nil then
Event.TgtUnitName=Event.TgtDCSUnitName
Event.TgtUnit=SCENERY:Register(Event.TgtDCSUnitName,Event.target)
Event.TgtCategory=Event.TgtDCSUnit:getDesc().category
Event.TgtTypeName=Event.TgtDCSUnit:getTypeName()
end
end
end
if Event.weapon and type(Event.weapon)=="table"and Event.weapon.isExist and Event.weapon:isExist()then
Event.Weapon=Event.weapon
Event.WeaponName=Event.weapon:isExist()and Event.weapon:getTypeName()or"Unknown Weapon"
Event.WeaponUNIT=CLIENT:Find(Event.Weapon,'',true)
Event.WeaponPlayerName=Event.WeaponUNIT and Event.Weapon.getPlayerName and Event.Weapon:getPlayerName()
Event.WeaponCoalition=Event.WeaponUNIT and Event.Weapon.getCoalition and Event.Weapon:getCoalition()
Event.WeaponCategory=Event.WeaponUNIT and Event.Weapon.getDesc and Event.Weapon:getDesc().category
Event.WeaponTypeName=Event.WeaponUNIT and Event.Weapon.getTypeName and Event.Weapon:getTypeName()
end
if Event.place then
if Event.id==EVENTS.LandingAfterEjection then
else
if Event.place:isExist()and Object.getCategory(Event.place)~=Object.Category.SCENERY then
Event.Place=AIRBASE:Find(Event.place)
Event.PlaceName=Event.Place:GetName()
end
end
end
if Event.idx then
Event.MarkID=Event.idx
Event.MarkVec3=Event.pos
Event.MarkCoordinate=COORDINATE:NewFromVec3(Event.pos)
Event.MarkText=Event.text
Event.MarkCoalition=Event.coalition
Event.IniCoalition=Event.coalition
Event.MarkGroupID=Event.groupID
end
if Event.cargo then
Event.Cargo=Event.cargo
Event.CargoName=Event.cargo.Name
end
if Event.dynamiccargo then
Event.IniDynamicCargo=Event.dynamiccargo
Event.IniDynamicCargoName=Event.IniDynamicCargo.StaticName
if Event.IniDynamicCargo.Owner or Event.IniUnitName then
Event.IniPlayerName=Event.IniDynamicCargo.Owner or string.match(Event.IniUnitName or"None|00:00|PKG00","^(.+)|%d%d:%d%d|PKG%d+")
end
end
if Event.zone then
Event.Zone=Event.zone
Event.ZoneName=Event.zone.ZoneName
end
local PriorityOrder=EventMeta.Order
local PriorityBegin=PriorityOrder==-1 and 5 or 1
local PriorityEnd=PriorityOrder==-1 and 1 or 5
for EventPriority=PriorityBegin,PriorityEnd,PriorityOrder do
if self.Events[Event.id][EventPriority]then
for EventClass,EventData in pairs(self.Events[Event.id][EventPriority])do
Event.IniGroup=Event.IniGroup or GROUP:FindByName(Event.IniDCSGroupName)
Event.TgtGroup=Event.TgtGroup or GROUP:FindByName(Event.TgtDCSGroupName)
if EventData.EventUnit then
if EventClass:IsAlive()or
Event.id==EVENTS.PlayerEnterUnit or
Event.id==EVENTS.Crash or
Event.id==EVENTS.Dead or
Event.id==EVENTS.RemoveUnit or
Event.id==EVENTS.UnitLost then
local UnitName=EventClass:GetName()
if(EventMeta.Side=="I"and UnitName==Event.IniDCSUnitName)or
(EventMeta.Side=="T"and UnitName==Event.TgtDCSUnitName)then
if EventData.EventFunction then
local Result,Value=xpcall(
function()
return EventData.EventFunction(EventClass,Event)
end,ErrorHandler)
else
local EventFunction=EventClass[EventMeta.Event]
if EventFunction and type(EventFunction)=="function"then
local Result,Value=xpcall(
function()
return EventFunction(EventClass,Event)
end,ErrorHandler)
end
end
end
else
self:RemoveEvent(EventClass,Event.id)
end
else
if EventData.EventGroup then
if EventClass:IsAlive()or
Event.id==EVENTS.PlayerEnterUnit or
Event.id==EVENTS.Crash or
Event.id==EVENTS.Dead or
Event.id==EVENTS.RemoveUnit or
Event.id==EVENTS.UnitLost then
local GroupName=EventClass:GetName()
if(EventMeta.Side=="I"and GroupName==Event.IniDCSGroupName)or
(EventMeta.Side=="T"and GroupName==Event.TgtDCSGroupName)then
if EventData.EventFunction then
local Result,Value=xpcall(
function()
return EventData.EventFunction(EventClass,Event,unpack(EventData.Params))
end,ErrorHandler)
else
local EventFunction=EventClass[EventMeta.Event]
if EventFunction and type(EventFunction)=="function"then
local Result,Value=xpcall(
function()
return EventFunction(EventClass,Event,unpack(EventData.Params))
end,ErrorHandler)
end
end
end
else
end
else
if not EventData.EventUnit then
if EventData.EventFunction then
local Result,Value=xpcall(
function()
return EventData.EventFunction(EventClass,Event)
end,ErrorHandler)
else
local EventFunction=EventClass[EventMeta.Event]
if EventFunction and type(EventFunction)=="function"then
local Result,Value=xpcall(
function()
local Result,Value=EventFunction(EventClass,Event)
return Result,Value
end,ErrorHandler)
end
end
end
end
end
end
end
end
if Event.id==EVENTS.DeleteCargo then
Event.Cargo.NoDestroy=nil
end
else
self:T({EventMeta.Text,Event})
end
else
self:E(string.format("WARNING: Could not get EVENTMETA data for event ID=%d! Is this an unknown/new DCS event?",tostring(Event.id)))
end
Event=nil
end
EVENTHANDLER={
ClassName="EVENTHANDLER",
ClassID=0,
}
function EVENTHANDLER:New()
self=BASE:Inherit(self,BASE:New())
return self
end
SETTINGS={
ClassName="SETTINGS",
ShowPlayerMenu=true,
MenuShort=false,
MenuStatic=false,
}
SETTINGS.__Enum={}
SETTINGS.__Enum.Era={
WWII=1,
Korea=2,
Cold=3,
Modern=4,
}
do
function SETTINGS:Set(PlayerName)
if PlayerName==nil then
local self=BASE:Inherit(self,BASE:New())
self:SetMetric()
self:SetA2G_BR()
self:SetA2A_BRAA()
self:SetLL_Accuracy(3)
self:SetMGRS_Accuracy(5)
self:SetMessageTime(MESSAGE.Type.Briefing,180)
self:SetMessageTime(MESSAGE.Type.Detailed,60)
self:SetMessageTime(MESSAGE.Type.Information,30)
self:SetMessageTime(MESSAGE.Type.Overview,60)
self:SetMessageTime(MESSAGE.Type.Update,15)
self:SetEraModern()
self:SetLocale("en")
return self
else
local Settings=_DATABASE:GetPlayerSettings(PlayerName)
if not Settings then
Settings=BASE:Inherit(self,BASE:New())
_DATABASE:SetPlayerSettings(PlayerName,Settings)
end
return Settings
end
end
function SETTINGS:SetMenutextShort(onoff)
_SETTINGS.MenuShort=onoff
end
function SETTINGS:SetMenuStatic(onoff)
_SETTINGS.MenuStatic=onoff
end
function SETTINGS:SetMetric()
self.Metric=true
end
function SETTINGS:SetLocale(Locale)
self.Locale=Locale or"en"
end
function SETTINGS:GetLocale()
return self.Locale or _SETTINGS:GetLocale()
end
function SETTINGS:IsMetric()
return(self.Metric~=nil and self.Metric==true)or(self.Metric==nil and _SETTINGS:IsMetric())
end
function SETTINGS:SetImperial()
self.Metric=false
end
function SETTINGS:IsImperial()
return(self.Metric~=nil and self.Metric==false)or(self.Metric==nil and _SETTINGS:IsImperial())
end
function SETTINGS:SetLL_Accuracy(LL_Accuracy)
self.LL_Accuracy=LL_Accuracy
end
function SETTINGS:GetLL_DDM_Accuracy()
return self.LL_DDM_Accuracy or _SETTINGS:GetLL_DDM_Accuracy()
end
function SETTINGS:SetMGRS_Accuracy(MGRS_Accuracy)
self.MGRS_Accuracy=MGRS_Accuracy
end
function SETTINGS:GetMGRS_Accuracy()
return self.MGRS_Accuracy or _SETTINGS:GetMGRS_Accuracy()
end
function SETTINGS:SetMessageTime(MessageType,MessageTime)
self.MessageTypeTimings=self.MessageTypeTimings or{}
self.MessageTypeTimings[MessageType]=MessageTime
end
function SETTINGS:GetMessageTime(MessageType)
return(self.MessageTypeTimings and self.MessageTypeTimings[MessageType])or _SETTINGS:GetMessageTime(MessageType)
end
function SETTINGS:SetA2G_LL_DMS()
self.A2GSystem="LL DMS"
end
function SETTINGS:SetA2G_LL_DDM()
self.A2GSystem="LL DDM"
end
function SETTINGS:IsA2G_LL_DMS()
return(self.A2GSystem and self.A2GSystem=="LL DMS")or(not self.A2GSystem and _SETTINGS:IsA2G_LL_DMS())
end
function SETTINGS:IsA2G_LL_DDM()
return(self.A2GSystem and self.A2GSystem=="LL DDM")or(not self.A2GSystem and _SETTINGS:IsA2G_LL_DDM())
end
function SETTINGS:SetA2G_MGRS()
self.A2GSystem="MGRS"
end
function SETTINGS:IsA2G_MGRS()
return(self.A2GSystem and self.A2GSystem=="MGRS")or(not self.A2GSystem and _SETTINGS:IsA2G_MGRS())
end
function SETTINGS:SetA2G_BR()
self.A2GSystem="BR"
end
function SETTINGS:IsA2G_BR()
return(self.A2GSystem and self.A2GSystem=="BR")or(not self.A2GSystem and _SETTINGS:IsA2G_BR())
end
function SETTINGS:SetA2A_BRAA()
self.A2ASystem="BRAA"
end
function SETTINGS:IsA2A_BRAA()
return(self.A2ASystem and self.A2ASystem=="BRAA")or(not self.A2ASystem and _SETTINGS:IsA2A_BRAA())
end
function SETTINGS:SetA2A_BULLS()
self.A2ASystem="BULLS"
end
function SETTINGS:IsA2A_BULLS()
return(self.A2ASystem and self.A2ASystem=="BULLS")or(not self.A2ASystem and _SETTINGS:IsA2A_BULLS())
end
function SETTINGS:SetA2A_LL_DMS()
self.A2ASystem="LL DMS"
end
function SETTINGS:SetA2A_LL_DDM()
self.A2ASystem="LL DDM"
end
function SETTINGS:IsA2A_LL_DMS()
return(self.A2ASystem and self.A2ASystem=="LL DMS")or(not self.A2ASystem and _SETTINGS:IsA2A_LL_DMS())
end
function SETTINGS:IsA2A_LL_DDM()
return(self.A2ASystem and self.A2ASystem=="LL DDM")or(not self.A2ASystem and _SETTINGS:IsA2A_LL_DDM())
end
function SETTINGS:SetA2A_MGRS()
self.A2ASystem="MGRS"
end
function SETTINGS:IsA2A_MGRS()
return(self.A2ASystem and self.A2ASystem=="MGRS")or(not self.A2ASystem and _SETTINGS:IsA2A_MGRS())
end
function SETTINGS:SetSystemMenu(MenuGroup,RootMenu)
local MenuText="System Settings"
local MenuTime=timer.getTime()
local SettingsMenu=MENU_GROUP:New(MenuGroup,MenuText,RootMenu):SetTime(MenuTime)
local text="A2G Coordinate System"
if _SETTINGS.MenuShort then
text="A2G Coordinates"
end
local A2GCoordinateMenu=MENU_GROUP:New(MenuGroup,text,SettingsMenu):SetTime(MenuTime)
if not self:IsA2G_LL_DMS()then
local text="Lat/Lon Degree Min Sec (LL DMS)"
if _SETTINGS.MenuShort then
text="LL DMS"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2GCoordinateMenu,self.A2GMenuSystem,self,MenuGroup,RootMenu,"LL DMS"):SetTime(MenuTime)
end
if not self:IsA2G_LL_DDM()then
local text="Lat/Lon Degree Dec Min (LL DDM)"
if _SETTINGS.MenuShort then
text="LL DDM"
end
MENU_GROUP_COMMAND:New(MenuGroup,"Lat/Lon Degree Dec Min (LL DDM)",A2GCoordinateMenu,self.A2GMenuSystem,self,MenuGroup,RootMenu,"LL DDM"):SetTime(MenuTime)
end
if self:IsA2G_LL_DDM()then
local text1="LL DDM Accuracy 1"
local text2="LL DDM Accuracy 2"
local text3="LL DDM Accuracy 3"
if _SETTINGS.MenuShort then
text1="LL DDM"
end
MENU_GROUP_COMMAND:New(MenuGroup,"LL DDM Accuracy 1",A2GCoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,1):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"LL DDM Accuracy 2",A2GCoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,2):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"LL DDM Accuracy 3",A2GCoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,3):SetTime(MenuTime)
end
if not self:IsA2G_BR()then
local text="Bearing, Range (BR)"
if _SETTINGS.MenuShort then
text="BR"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2GCoordinateMenu,self.A2GMenuSystem,self,MenuGroup,RootMenu,"BR"):SetTime(MenuTime)
end
if not self:IsA2G_MGRS()then
local text="Military Grid (MGRS)"
if _SETTINGS.MenuShort then
text="MGRS"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2GCoordinateMenu,self.A2GMenuSystem,self,MenuGroup,RootMenu,"MGRS"):SetTime(MenuTime)
end
if self:IsA2G_MGRS()then
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 1",A2GCoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,1):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 2",A2GCoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,2):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 3",A2GCoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,3):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 4",A2GCoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,4):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 5",A2GCoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,5):SetTime(MenuTime)
end
local text="A2A Coordinate System"
if _SETTINGS.MenuShort then
text="A2A Coordinates"
end
local A2ACoordinateMenu=MENU_GROUP:New(MenuGroup,text,SettingsMenu):SetTime(MenuTime)
if not self:IsA2A_LL_DMS()then
local text="Lat/Lon Degree Min Sec (LL DMS)"
if _SETTINGS.MenuShort then
text="LL DMS"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2ACoordinateMenu,self.A2AMenuSystem,self,MenuGroup,RootMenu,"LL DMS"):SetTime(MenuTime)
end
if not self:IsA2A_LL_DDM()then
local text="Lat/Lon Degree Dec Min (LL DDM)"
if _SETTINGS.MenuShort then
text="LL DDM"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2ACoordinateMenu,self.A2AMenuSystem,self,MenuGroup,RootMenu,"LL DDM"):SetTime(MenuTime)
end
if self:IsA2A_LL_DDM()or self:IsA2A_LL_DMS()then
MENU_GROUP_COMMAND:New(MenuGroup,"LL Accuracy 0",A2ACoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,0):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"LL Accuracy 1",A2ACoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,1):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"LL Accuracy 2",A2ACoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,2):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"LL Accuracy 3",A2ACoordinateMenu,self.MenuLL_DDM_Accuracy,self,MenuGroup,RootMenu,3):SetTime(MenuTime)
end
if not self:IsA2A_BULLS()then
local text="Bullseye (BULLS)"
if _SETTINGS.MenuShort then
text="Bulls"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2ACoordinateMenu,self.A2AMenuSystem,self,MenuGroup,RootMenu,"BULLS"):SetTime(MenuTime)
end
if not self:IsA2A_BRAA()then
local text="Bearing Range Altitude Aspect (BRAA)"
if _SETTINGS.MenuShort then
text="BRAA"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2ACoordinateMenu,self.A2AMenuSystem,self,MenuGroup,RootMenu,"BRAA"):SetTime(MenuTime)
end
if not self:IsA2A_MGRS()then
local text="Military Grid (MGRS)"
if _SETTINGS.MenuShort then
text="MGRS"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,A2ACoordinateMenu,self.A2AMenuSystem,self,MenuGroup,RootMenu,"MGRS"):SetTime(MenuTime)
end
if self:IsA2A_MGRS()then
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 1",A2ACoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,1):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 2",A2ACoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,2):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 3",A2ACoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,3):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 4",A2ACoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,4):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"MGRS Accuracy 5",A2ACoordinateMenu,self.MenuMGRS_Accuracy,self,MenuGroup,RootMenu,5):SetTime(MenuTime)
end
local text="Measures and Weights System"
if _SETTINGS.MenuShort then
text="Unit System"
end
local MetricsMenu=MENU_GROUP:New(MenuGroup,text,SettingsMenu):SetTime(MenuTime)
if self:IsMetric()then
local text="Imperial (Miles,Feet)"
if _SETTINGS.MenuShort then
text="Imperial"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,MetricsMenu,self.MenuMWSystem,self,MenuGroup,RootMenu,false):SetTime(MenuTime)
end
if self:IsImperial()then
local text="Metric (Kilometers,Meters)"
if _SETTINGS.MenuShort then
text="Metric"
end
MENU_GROUP_COMMAND:New(MenuGroup,text,MetricsMenu,self.MenuMWSystem,self,MenuGroup,RootMenu,true):SetTime(MenuTime)
end
local text="Messages and Reports"
if _SETTINGS.MenuShort then
text="Messages & Reports"
end
local MessagesMenu=MENU_GROUP:New(MenuGroup,text,SettingsMenu):SetTime(MenuTime)
local UpdateMessagesMenu=MENU_GROUP:New(MenuGroup,"Update Messages",MessagesMenu):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"Off",UpdateMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Update,0):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"5 seconds",UpdateMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Update,5):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"10 seconds",UpdateMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Update,10):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"15 seconds",UpdateMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Update,15):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"30 seconds",UpdateMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Update,30):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"1 minute",UpdateMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Update,60):SetTime(MenuTime)
local InformationMessagesMenu=MENU_GROUP:New(MenuGroup,"Information Messages",MessagesMenu):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"5 seconds",InformationMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Information,5):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"10 seconds",InformationMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Information,10):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"15 seconds",InformationMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Information,15):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"30 seconds",InformationMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Information,30):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"1 minute",InformationMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Information,60):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"2 minutes",InformationMessagesMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Information,120):SetTime(MenuTime)
local BriefingReportsMenu=MENU_GROUP:New(MenuGroup,"Briefing Reports",MessagesMenu):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"15 seconds",BriefingReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Briefing,15):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"30 seconds",BriefingReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Briefing,30):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"1 minute",BriefingReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Briefing,60):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"2 minutes",BriefingReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Briefing,120):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"3 minutes",BriefingReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Briefing,180):SetTime(MenuTime)
local OverviewReportsMenu=MENU_GROUP:New(MenuGroup,"Overview Reports",MessagesMenu):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"15 seconds",OverviewReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Overview,15):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"30 seconds",OverviewReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Overview,30):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"1 minute",OverviewReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Overview,60):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"2 minutes",OverviewReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Overview,120):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"3 minutes",OverviewReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.Overview,180):SetTime(MenuTime)
local DetailedReportsMenu=MENU_GROUP:New(MenuGroup,"Detailed Reports",MessagesMenu):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"15 seconds",DetailedReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.DetailedReportsMenu,15):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"30 seconds",DetailedReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.DetailedReportsMenu,30):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"1 minute",DetailedReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.DetailedReportsMenu,60):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"2 minutes",DetailedReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.DetailedReportsMenu,120):SetTime(MenuTime)
MENU_GROUP_COMMAND:New(MenuGroup,"3 minutes",DetailedReportsMenu,self.MenuMessageTimingsSystem,self,MenuGroup,RootMenu,MESSAGE.Type.DetailedReportsMenu,180):SetTime(MenuTime)
SettingsMenu:Remove(MenuTime)
return self
end
function SETTINGS:SetPlayerMenuOn()
self.ShowPlayerMenu=true
end
function SETTINGS:SetPlayerMenuOff()
self.ShowPlayerMenu=false
end
function SETTINGS:SetPlayerMenu(PlayerUnit)
if _SETTINGS.ShowPlayerMenu==true then
local PlayerGroup=PlayerUnit:GetGroup()
local PlayerName=PlayerUnit:GetPlayerName()or"None"
local PlayerMenu=MENU_GROUP:New(PlayerGroup,'Settings "'..PlayerName..'"')
self.PlayerMenu=PlayerMenu
self:T(string.format("Setting menu for player %s",tostring(PlayerName)))
local submenu=MENU_GROUP:New(PlayerGroup,"LL Accuracy",PlayerMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"LL 0 Decimals",submenu,self.MenuGroupLL_DDM_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,0)
MENU_GROUP_COMMAND:New(PlayerGroup,"LL 1 Decimal",submenu,self.MenuGroupLL_DDM_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,1)
MENU_GROUP_COMMAND:New(PlayerGroup,"LL 2 Decimals",submenu,self.MenuGroupLL_DDM_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,2)
MENU_GROUP_COMMAND:New(PlayerGroup,"LL 3 Decimals",submenu,self.MenuGroupLL_DDM_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,3)
MENU_GROUP_COMMAND:New(PlayerGroup,"LL 4 Decimals",submenu,self.MenuGroupLL_DDM_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,4)
local submenu=MENU_GROUP:New(PlayerGroup,"MGRS Accuracy",PlayerMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"MRGS Accuracy 0",submenu,self.MenuGroupMGRS_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,0)
MENU_GROUP_COMMAND:New(PlayerGroup,"MRGS Accuracy 1",submenu,self.MenuGroupMGRS_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,1)
MENU_GROUP_COMMAND:New(PlayerGroup,"MRGS Accuracy 2",submenu,self.MenuGroupMGRS_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,2)
MENU_GROUP_COMMAND:New(PlayerGroup,"MRGS Accuracy 3",submenu,self.MenuGroupMGRS_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,3)
MENU_GROUP_COMMAND:New(PlayerGroup,"MRGS Accuracy 4",submenu,self.MenuGroupMGRS_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,4)
MENU_GROUP_COMMAND:New(PlayerGroup,"MRGS Accuracy 5",submenu,self.MenuGroupMGRS_AccuracySystem,self,PlayerUnit,PlayerGroup,PlayerName,5)
local text="A2G Coordinate System"
if _SETTINGS.MenuShort then
text="A2G Coordinates"
end
local A2GCoordinateMenu=MENU_GROUP:New(PlayerGroup,text,PlayerMenu)
if not self:IsA2G_LL_DMS()or _SETTINGS.MenuStatic then
local text="Lat/Lon Degree Min Sec (LL DMS)"
if _SETTINGS.MenuShort then
text="A2G LL DMS"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2GCoordinateMenu,self.MenuGroupA2GSystem,self,PlayerUnit,PlayerGroup,PlayerName,"LL DMS")
end
if not self:IsA2G_LL_DDM()or _SETTINGS.MenuStatic then
local text="Lat/Lon Degree Dec Min (LL DDM)"
if _SETTINGS.MenuShort then
text="A2G LL DDM"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2GCoordinateMenu,self.MenuGroupA2GSystem,self,PlayerUnit,PlayerGroup,PlayerName,"LL DDM")
end
if not self:IsA2G_BR()or _SETTINGS.MenuStatic then
local text="Bearing, Range (BR)"
if _SETTINGS.MenuShort then
text="A2G BR"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2GCoordinateMenu,self.MenuGroupA2GSystem,self,PlayerUnit,PlayerGroup,PlayerName,"BR")
end
if not self:IsA2G_MGRS()or _SETTINGS.MenuStatic then
local text="Military Grid (MGRS)"
if _SETTINGS.MenuShort then
text="A2G MGRS"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2GCoordinateMenu,self.MenuGroupA2GSystem,self,PlayerUnit,PlayerGroup,PlayerName,"MGRS")
end
local text="A2A Coordinate System"
if _SETTINGS.MenuShort then
text="A2A Coordinates"
end
local A2ACoordinateMenu=MENU_GROUP:New(PlayerGroup,text,PlayerMenu)
if not self:IsA2A_LL_DMS()or _SETTINGS.MenuStatic then
local text="Lat/Lon Degree Min Sec (LL DMS)"
if _SETTINGS.MenuShort then
text="A2A LL DMS"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2ACoordinateMenu,self.MenuGroupA2GSystem,self,PlayerUnit,PlayerGroup,PlayerName,"LL DMS")
end
if not self:IsA2A_LL_DDM()or _SETTINGS.MenuStatic then
local text="Lat/Lon Degree Dec Min (LL DDM)"
if _SETTINGS.MenuShort then
text="A2A LL DDM"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2ACoordinateMenu,self.MenuGroupA2ASystem,self,PlayerUnit,PlayerGroup,PlayerName,"LL DDM")
end
if not self:IsA2A_BULLS()or _SETTINGS.MenuStatic then
local text="Bullseye (BULLS)"
if _SETTINGS.MenuShort then
text="A2A BULLS"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2ACoordinateMenu,self.MenuGroupA2ASystem,self,PlayerUnit,PlayerGroup,PlayerName,"BULLS")
end
if not self:IsA2A_BRAA()or _SETTINGS.MenuStatic then
local text="Bearing Range Altitude Aspect (BRAA)"
if _SETTINGS.MenuShort then
text="A2A BRAA"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2ACoordinateMenu,self.MenuGroupA2ASystem,self,PlayerUnit,PlayerGroup,PlayerName,"BRAA")
end
if not self:IsA2A_MGRS()or _SETTINGS.MenuStatic then
local text="Military Grid (MGRS)"
if _SETTINGS.MenuShort then
text="A2A MGRS"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,A2ACoordinateMenu,self.MenuGroupA2ASystem,self,PlayerUnit,PlayerGroup,PlayerName,"MGRS")
end
local text="Measures and Weights System"
if _SETTINGS.MenuShort then
text="Unit System"
end
local MetricsMenu=MENU_GROUP:New(PlayerGroup,text,PlayerMenu)
if self:IsMetric()or _SETTINGS.MenuStatic then
local text="Imperial (Miles,Feet)"
if _SETTINGS.MenuShort then
text="Imperial"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,MetricsMenu,self.MenuGroupMWSystem,self,PlayerUnit,PlayerGroup,PlayerName,false)
end
if self:IsImperial()or _SETTINGS.MenuStatic then
local text="Metric (Kilometers,Meters)"
if _SETTINGS.MenuShort then
text="Metric"
end
MENU_GROUP_COMMAND:New(PlayerGroup,text,MetricsMenu,self.MenuGroupMWSystem,self,PlayerUnit,PlayerGroup,PlayerName,true)
end
local text="Messages and Reports"
if _SETTINGS.MenuShort then
text="Messages & Reports"
end
local MessagesMenu=MENU_GROUP:New(PlayerGroup,text,PlayerMenu)
local UpdateMessagesMenu=MENU_GROUP:New(PlayerGroup,"Update Messages",MessagesMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"Updates Off",UpdateMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Update,0)
MENU_GROUP_COMMAND:New(PlayerGroup,"Updates 5 sec",UpdateMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Update,5)
MENU_GROUP_COMMAND:New(PlayerGroup,"Updates 10 sec",UpdateMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Update,10)
MENU_GROUP_COMMAND:New(PlayerGroup,"Updates 15 sec",UpdateMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Update,15)
MENU_GROUP_COMMAND:New(PlayerGroup,"Updates 30 sec",UpdateMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Update,30)
MENU_GROUP_COMMAND:New(PlayerGroup,"Updates 1 min",UpdateMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Update,60)
local InformationMessagesMenu=MENU_GROUP:New(PlayerGroup,"Info Messages",MessagesMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"Info 5 sec",InformationMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Information,5)
MENU_GROUP_COMMAND:New(PlayerGroup,"Info 10 sec",InformationMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Information,10)
MENU_GROUP_COMMAND:New(PlayerGroup,"Info 15 sec",InformationMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Information,15)
MENU_GROUP_COMMAND:New(PlayerGroup,"Info 30 sec",InformationMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Information,30)
MENU_GROUP_COMMAND:New(PlayerGroup,"Info 1 min",InformationMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Information,60)
MENU_GROUP_COMMAND:New(PlayerGroup,"Info 2 min",InformationMessagesMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Information,120)
local BriefingReportsMenu=MENU_GROUP:New(PlayerGroup,"Briefing Reports",MessagesMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"Brief 15 sec",BriefingReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Briefing,15)
MENU_GROUP_COMMAND:New(PlayerGroup,"Brief 30 sec",BriefingReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Briefing,30)
MENU_GROUP_COMMAND:New(PlayerGroup,"Brief 1 min",BriefingReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Briefing,60)
MENU_GROUP_COMMAND:New(PlayerGroup,"Brief 2 min",BriefingReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Briefing,120)
MENU_GROUP_COMMAND:New(PlayerGroup,"Brief 3 min",BriefingReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Briefing,180)
local OverviewReportsMenu=MENU_GROUP:New(PlayerGroup,"Overview Reports",MessagesMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"Overview 15 sec",OverviewReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Overview,15)
MENU_GROUP_COMMAND:New(PlayerGroup,"Overview 30 sec",OverviewReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Overview,30)
MENU_GROUP_COMMAND:New(PlayerGroup,"Overview 1 min",OverviewReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Overview,60)
MENU_GROUP_COMMAND:New(PlayerGroup,"Overview 2 min",OverviewReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Overview,120)
MENU_GROUP_COMMAND:New(PlayerGroup,"Overview 3 min",OverviewReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.Overview,180)
local DetailedReportsMenu=MENU_GROUP:New(PlayerGroup,"Detailed Reports",MessagesMenu)
MENU_GROUP_COMMAND:New(PlayerGroup,"Detailed 15 sec",DetailedReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.DetailedReportsMenu,15)
MENU_GROUP_COMMAND:New(PlayerGroup,"Detailed 30 sec",DetailedReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.DetailedReportsMenu,30)
MENU_GROUP_COMMAND:New(PlayerGroup,"Detailed 1 min",DetailedReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.DetailedReportsMenu,60)
MENU_GROUP_COMMAND:New(PlayerGroup,"Detailed 2 min",DetailedReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.DetailedReportsMenu,120)
MENU_GROUP_COMMAND:New(PlayerGroup,"Detailed 3 min",DetailedReportsMenu,self.MenuGroupMessageTimingsSystem,self,PlayerUnit,PlayerGroup,PlayerName,MESSAGE.Type.DetailedReportsMenu,180)
end
return self
end
function SETTINGS:RemovePlayerMenu(PlayerUnit)
if self.PlayerMenu then
self.PlayerMenu:Remove()
self.PlayerMenu=nil
end
return self
end
function SETTINGS:A2GMenuSystem(MenuGroup,RootMenu,A2GSystem)
self.A2GSystem=A2GSystem
MESSAGE:New(string.format("Settings: Default A2G coordinate system set to %s for all players!",A2GSystem),5):ToAll()
self:SetSystemMenu(MenuGroup,RootMenu)
end
function SETTINGS:A2AMenuSystem(MenuGroup,RootMenu,A2ASystem)
self.A2ASystem=A2ASystem
MESSAGE:New(string.format("Settings: Default A2A coordinate system set to %s for all players!",A2ASystem),5):ToAll()
self:SetSystemMenu(MenuGroup,RootMenu)
end
function SETTINGS:MenuLL_DDM_Accuracy(MenuGroup,RootMenu,LL_Accuracy)
self.LL_Accuracy=LL_Accuracy
MESSAGE:New(string.format("Settings: Default LL accuracy set to %s for all players!",LL_Accuracy),5):ToAll()
self:SetSystemMenu(MenuGroup,RootMenu)
end
function SETTINGS:MenuMGRS_Accuracy(MenuGroup,RootMenu,MGRS_Accuracy)
self.MGRS_Accuracy=MGRS_Accuracy
MESSAGE:New(string.format("Settings: Default MGRS accuracy set to %s for all players!",MGRS_Accuracy),5):ToAll()
self:SetSystemMenu(MenuGroup,RootMenu)
end
function SETTINGS:MenuMWSystem(MenuGroup,RootMenu,MW)
self.Metric=MW
MESSAGE:New(string.format("Settings: Default measurement format set to %s for all players!",MW and"Metric"or"Imperial"),5):ToAll()
self:SetSystemMenu(MenuGroup,RootMenu)
end
function SETTINGS:MenuMessageTimingsSystem(MenuGroup,RootMenu,MessageType,MessageTime)
self:SetMessageTime(MessageType,MessageTime)
MESSAGE:New(string.format("Settings: Default message time set for %s to %d.",MessageType,MessageTime),5):ToAll()
end
do
function SETTINGS:MenuGroupA2GSystem(PlayerUnit,PlayerGroup,PlayerName,A2GSystem)
self.A2GSystem=A2GSystem
MESSAGE:New(string.format("Settings: A2G format set to %s for player %s.",A2GSystem,PlayerName),5):ToGroup(PlayerGroup)
if _SETTINGS.MenuStatic==false then
self:RemovePlayerMenu(PlayerUnit)
self:SetPlayerMenu(PlayerUnit)
end
end
function SETTINGS:MenuGroupA2ASystem(PlayerUnit,PlayerGroup,PlayerName,A2ASystem)
self.A2ASystem=A2ASystem
MESSAGE:New(string.format("Settings: A2A format set to %s for player %s.",A2ASystem,PlayerName),5):ToGroup(PlayerGroup)
if _SETTINGS.MenuStatic==false then
self:RemovePlayerMenu(PlayerUnit)
self:SetPlayerMenu(PlayerUnit)
end
end
function SETTINGS:MenuGroupLL_DDM_AccuracySystem(PlayerUnit,PlayerGroup,PlayerName,LL_Accuracy)
self.LL_Accuracy=LL_Accuracy
MESSAGE:New(string.format("Settings: LL format accuracy set to %d decimal places for player %s.",LL_Accuracy,PlayerName),5):ToGroup(PlayerGroup)
if _SETTINGS.MenuStatic==false then
self:RemovePlayerMenu(PlayerUnit)
self:SetPlayerMenu(PlayerUnit)
end
end
function SETTINGS:MenuGroupMGRS_AccuracySystem(PlayerUnit,PlayerGroup,PlayerName,MGRS_Accuracy)
self.MGRS_Accuracy=MGRS_Accuracy
MESSAGE:New(string.format("Settings: MGRS format accuracy set to %d for player %s.",MGRS_Accuracy,PlayerName),5):ToGroup(PlayerGroup)
if _SETTINGS.MenuStatic==false then
self:RemovePlayerMenu(PlayerUnit)
self:SetPlayerMenu(PlayerUnit)
end
end
function SETTINGS:MenuGroupMWSystem(PlayerUnit,PlayerGroup,PlayerName,MW)
self.Metric=MW
MESSAGE:New(string.format("Settings: Measurement format set to %s for player %s.",MW and"Metric"or"Imperial",PlayerName),5):ToGroup(PlayerGroup)
if _SETTINGS.MenuStatic==false then
self:RemovePlayerMenu(PlayerUnit)
self:SetPlayerMenu(PlayerUnit)
end
end
function SETTINGS:MenuGroupMessageTimingsSystem(PlayerUnit,PlayerGroup,PlayerName,MessageType,MessageTime)
self:SetMessageTime(MessageType,MessageTime)
MESSAGE:New(string.format("Settings: Default message time set for %s to %d.",MessageType,MessageTime),5):ToGroup(PlayerGroup)
end
end
function SETTINGS:SetEraWWII()
self.Era=SETTINGS.__Enum.Era.WWII
end
function SETTINGS:SetEraKorea()
self.Era=SETTINGS.__Enum.Era.Korea
end
function SETTINGS:SetEraCold()
self.Era=SETTINGS.__Enum.Era.Cold
end
function SETTINGS:SetEraModern()
self.Era=SETTINGS.__Enum.Era.Modern
end
end
MENU_INDEX={}
MENU_INDEX.MenuMission={}
MENU_INDEX.MenuMission.Menus={}
MENU_INDEX.Coalition={}
MENU_INDEX.Coalition[coalition.side.BLUE]={}
MENU_INDEX.Coalition[coalition.side.BLUE].Menus={}
MENU_INDEX.Coalition[coalition.side.RED]={}
MENU_INDEX.Coalition[coalition.side.RED].Menus={}
MENU_INDEX.Group={}
function MENU_INDEX:ParentPath(ParentMenu,MenuText)
local Path=ParentMenu and"@"..table.concat(ParentMenu.MenuPath or{},"@")or""
if ParentMenu then
if ParentMenu:IsInstanceOf("MENU_GROUP")or ParentMenu:IsInstanceOf("MENU_GROUP_COMMAND")then
local GroupName=ParentMenu.Group:GetName()
if not self.Group[GroupName].Menus[Path]then
BASE:E({Path=Path,GroupName=GroupName})
error("Parent path not found in menu index for group menu")
return nil
end
elseif ParentMenu:IsInstanceOf("MENU_COALITION")or ParentMenu:IsInstanceOf("MENU_COALITION_COMMAND")then
local Coalition=ParentMenu.Coalition
if not self.Coalition[Coalition].Menus[Path]then
BASE:E({Path=Path,Coalition=Coalition})
error("Parent path not found in menu index for coalition menu")
return nil
end
elseif ParentMenu:IsInstanceOf("MENU_MISSION")or ParentMenu:IsInstanceOf("MENU_MISSION_COMMAND")then
if not self.MenuMission.Menus[Path]then
BASE:E({Path=Path})
error("Parent path not found in menu index for mission menu")
return nil
end
end
end
Path=Path.."@"..MenuText
return Path
end
function MENU_INDEX:PrepareMission()
self.MenuMission.Menus=self.MenuMission.Menus or{}
end
function MENU_INDEX:PrepareCoalition(CoalitionSide)
self.Coalition[CoalitionSide]=self.Coalition[CoalitionSide]or{}
self.Coalition[CoalitionSide].Menus=self.Coalition[CoalitionSide].Menus or{}
end
function MENU_INDEX:PrepareGroup(Group)
if Group and Group:IsAlive()~=nil then
local GroupName=Group:GetName()
self.Group[GroupName]=self.Group[GroupName]or{}
self.Group[GroupName].Menus=self.Group[GroupName].Menus or{}
end
end
function MENU_INDEX:HasMissionMenu(Path)
return self.MenuMission.Menus[Path]
end
function MENU_INDEX:SetMissionMenu(Path,Menu)
self.MenuMission.Menus[Path]=Menu
end
function MENU_INDEX:ClearMissionMenu(Path)
self.MenuMission.Menus[Path]=nil
end
function MENU_INDEX:HasCoalitionMenu(Coalition,Path)
return self.Coalition[Coalition].Menus[Path]
end
function MENU_INDEX:SetCoalitionMenu(Coalition,Path,Menu)
self.Coalition[Coalition].Menus[Path]=Menu
end
function MENU_INDEX:ClearCoalitionMenu(Coalition,Path)
self.Coalition[Coalition].Menus[Path]=nil
end
function MENU_INDEX:HasGroupMenu(Group,Path)
if Group and Group:IsAlive()then
local MenuGroupName=Group:GetName()
if self.Group[MenuGroupName]and self.Group[MenuGroupName].Menus and self.Group[MenuGroupName].Menus[Path]then
return self.Group[MenuGroupName].Menus[Path]
end
end
return nil
end
function MENU_INDEX:SetGroupMenu(Group,Path,Menu)
local MenuGroupName=Group:GetName()
self.Group[MenuGroupName].Menus[Path]=Menu
end
function MENU_INDEX:ClearGroupMenu(Group,Path)
local MenuGroupName=Group:GetName()
self.Group[MenuGroupName].Menus[Path]=nil
end
function MENU_INDEX:Refresh(Group)
for MenuID,Menu in pairs(self.MenuMission.Menus)do
Menu:Refresh()
end
for MenuID,Menu in pairs(self.Coalition[coalition.side.BLUE].Menus)do
Menu:Refresh()
end
for MenuID,Menu in pairs(self.Coalition[coalition.side.RED].Menus)do
Menu:Refresh()
end
local GroupName=Group:GetName()
for MenuID,Menu in pairs(self.Group[GroupName].Menus)do
Menu:Refresh()
end
return self
end
do
MENU_BASE={
ClassName="MENU_BASE",
MenuPath=nil,
MenuText="",
MenuParentPath=nil,
}
function MENU_BASE:New(MenuText,ParentMenu)
local MenuParentPath={}
if ParentMenu~=nil then
MenuParentPath=ParentMenu.MenuPath
end
local self=BASE:Inherit(self,BASE:New())
self.MenuPath=nil
self.MenuText=MenuText
self.ParentMenu=ParentMenu
self.MenuParentPath=MenuParentPath
self.Path=(self.ParentMenu and"@"..table.concat(self.MenuParentPath or{},"@")or"").."@"..self.MenuText
self.Menus={}
self.MenuCount=0
self.MenuStamp=timer.getTime()
self.MenuRemoveParent=false
if self.ParentMenu then
self.ParentMenu.Menus=self.ParentMenu.Menus or{}
self.ParentMenu.Menus[MenuText]=self
end
return self
end
function MENU_BASE:SetParentMenu(MenuText,Menu)
if self.ParentMenu then
self.ParentMenu.Menus=self.ParentMenu.Menus or{}
self.ParentMenu.Menus[MenuText]=Menu
self.ParentMenu.MenuCount=self.ParentMenu.MenuCount+1
end
end
function MENU_BASE:ClearParentMenu(MenuText)
if self.ParentMenu and self.ParentMenu.Menus[MenuText]then
self.ParentMenu.Menus[MenuText]=nil
self.ParentMenu.MenuCount=self.ParentMenu.MenuCount-1
if self.ParentMenu.MenuCount==0 then
end
end
end
function MENU_BASE:SetRemoveParent(RemoveParent)
self.MenuRemoveParent=RemoveParent
return self
end
function MENU_BASE:GetMenu(MenuText)
return self.Menus[MenuText]
end
function MENU_BASE:SetStamp(MenuStamp)
self.MenuStamp=MenuStamp
return self
end
function MENU_BASE:GetStamp()
return timer.getTime()
end
function MENU_BASE:SetTime(MenuStamp)
self.MenuStamp=MenuStamp
return self
end
function MENU_BASE:SetTag(MenuTag)
self.MenuTag=MenuTag
return self
end
end
do
MENU_COMMAND_BASE={
ClassName="MENU_COMMAND_BASE",
CommandMenuFunction=nil,
CommandMenuArgument=nil,
MenuCallHandler=nil,
}
function MENU_COMMAND_BASE:New(MenuText,ParentMenu,CommandMenuFunction,CommandMenuArguments)
local self=BASE:Inherit(self,MENU_BASE:New(MenuText,ParentMenu))
local ErrorHandler=function(errmsg)
env.info("MOOSE error in MENU COMMAND function: "..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
self:SetCommandMenuFunction(CommandMenuFunction)
self:SetCommandMenuArguments(CommandMenuArguments)
self.MenuCallHandler=function()
local function MenuFunction()
return self.CommandMenuFunction(unpack(self.CommandMenuArguments))
end
local Status,Result=xpcall(MenuFunction,ErrorHandler)
end
return self
end
function MENU_COMMAND_BASE:SetCommandMenuFunction(CommandMenuFunction)
self.CommandMenuFunction=CommandMenuFunction
return self
end
function MENU_COMMAND_BASE:SetCommandMenuArguments(CommandMenuArguments)
self.CommandMenuArguments=CommandMenuArguments
return self
end
end
do
MENU_MISSION={
ClassName="MENU_MISSION",
}
function MENU_MISSION:New(MenuText,ParentMenu)
MENU_INDEX:PrepareMission()
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local MissionMenu=MENU_INDEX:HasMissionMenu(Path)
if MissionMenu then
return MissionMenu
else
local self=BASE:Inherit(self,MENU_BASE:New(MenuText,ParentMenu))
MENU_INDEX:SetMissionMenu(Path,self)
self.MenuPath=missionCommands.addSubMenu(self.MenuText,self.MenuParentPath)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_MISSION:Refresh()
do
missionCommands.removeItem(self.MenuPath)
self.MenuPath=missionCommands.addSubMenu(self.MenuText,self.MenuParentPath)
end
return self
end
function MENU_MISSION:RemoveSubMenus()
for MenuID,Menu in pairs(self.Menus or{})do
Menu:Remove()
end
self.Menus=nil
end
function MENU_MISSION:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareMission()
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local MissionMenu=MENU_INDEX:HasMissionMenu(Path)
if MissionMenu==self then
self:RemoveSubMenus()
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
self:F({Text=self.MenuText,Path=self.MenuPath})
if self.MenuPath~=nil then
missionCommands.removeItem(self.MenuPath)
end
MENU_INDEX:ClearMissionMenu(self.Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_MISSION",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText})
end
return self
end
end
do
MENU_MISSION_COMMAND={
ClassName="MENU_MISSION_COMMAND",
}
function MENU_MISSION_COMMAND:New(MenuText,ParentMenu,CommandMenuFunction,...)
MENU_INDEX:PrepareMission()
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local MissionMenu=MENU_INDEX:HasMissionMenu(Path)
if MissionMenu then
MissionMenu:SetCommandMenuFunction(CommandMenuFunction)
MissionMenu:SetCommandMenuArguments(arg)
return MissionMenu
else
local self=BASE:Inherit(self,MENU_COMMAND_BASE:New(MenuText,ParentMenu,CommandMenuFunction,arg))
MENU_INDEX:SetMissionMenu(Path,self)
self.MenuPath=missionCommands.addCommand(MenuText,self.MenuParentPath,self.MenuCallHandler)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_MISSION_COMMAND:Refresh()
do
missionCommands.removeItem(self.MenuPath)
missionCommands.addCommand(self.MenuText,self.MenuParentPath,self.MenuCallHandler)
end
return self
end
function MENU_MISSION_COMMAND:Remove()
MENU_INDEX:PrepareMission()
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local MissionMenu=MENU_INDEX:HasMissionMenu(Path)
if MissionMenu==self then
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
self:F({Text=self.MenuText,Path=self.MenuPath})
if self.MenuPath~=nil then
missionCommands.removeItem(self.MenuPath)
end
MENU_INDEX:ClearMissionMenu(self.Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_MISSION_COMMAND",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText})
end
return self
end
end
do
MENU_COALITION={
ClassName="MENU_COALITION"
}
function MENU_COALITION:New(Coalition,MenuText,ParentMenu)
MENU_INDEX:PrepareCoalition(Coalition)
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local CoalitionMenu=MENU_INDEX:HasCoalitionMenu(Coalition,Path)
if CoalitionMenu then
return CoalitionMenu
else
local self=BASE:Inherit(self,MENU_BASE:New(MenuText,ParentMenu))
MENU_INDEX:SetCoalitionMenu(Coalition,Path,self)
self.Coalition=Coalition
self.MenuPath=missionCommands.addSubMenuForCoalition(Coalition,MenuText,self.MenuParentPath)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_COALITION:Refresh()
do
missionCommands.removeItemForCoalition(self.Coalition,self.MenuPath)
missionCommands.addSubMenuForCoalition(self.Coalition,self.MenuText,self.MenuParentPath)
end
return self
end
function MENU_COALITION:RemoveSubMenus()
for MenuID,Menu in pairs(self.Menus or{})do
Menu:Remove()
end
self.Menus=nil
end
function MENU_COALITION:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareCoalition(self.Coalition)
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local CoalitionMenu=MENU_INDEX:HasCoalitionMenu(self.Coalition,Path)
if CoalitionMenu==self then
self:RemoveSubMenus()
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
self:F({Coalition=self.Coalition,Text=self.MenuText,Path=self.MenuPath})
if self.MenuPath~=nil then
missionCommands.removeItemForCoalition(self.Coalition,self.MenuPath)
end
MENU_INDEX:ClearCoalitionMenu(self.Coalition,Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_COALITION",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText,Coalition=self.Coalition})
end
return self
end
end
do
MENU_COALITION_COMMAND={
ClassName="MENU_COALITION_COMMAND"
}
function MENU_COALITION_COMMAND:New(Coalition,MenuText,ParentMenu,CommandMenuFunction,...)
MENU_INDEX:PrepareCoalition(Coalition)
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local CoalitionMenu=MENU_INDEX:HasCoalitionMenu(Coalition,Path)
if CoalitionMenu then
CoalitionMenu:SetCommandMenuFunction(CommandMenuFunction)
CoalitionMenu:SetCommandMenuArguments(arg)
return CoalitionMenu
else
local self=BASE:Inherit(self,MENU_COMMAND_BASE:New(MenuText,ParentMenu,CommandMenuFunction,arg))
MENU_INDEX:SetCoalitionMenu(Coalition,Path,self)
self.Coalition=Coalition
self.MenuPath=missionCommands.addCommandForCoalition(self.Coalition,MenuText,self.MenuParentPath,self.MenuCallHandler)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_COALITION_COMMAND:Refresh()
do
missionCommands.removeItemForCoalition(self.Coalition,self.MenuPath)
missionCommands.addCommandForCoalition(self.Coalition,self.MenuText,self.MenuParentPath,self.MenuCallHandler)
end
return self
end
function MENU_COALITION_COMMAND:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareCoalition(self.Coalition)
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local CoalitionMenu=MENU_INDEX:HasCoalitionMenu(self.Coalition,Path)
if CoalitionMenu==self then
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
self:F({Coalition=self.Coalition,Text=self.MenuText,Path=self.MenuPath})
if self.MenuPath~=nil then
missionCommands.removeItemForCoalition(self.Coalition,self.MenuPath)
end
MENU_INDEX:ClearCoalitionMenu(self.Coalition,Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_COALITION_COMMAND",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText,Coalition=self.Coalition})
end
return self
end
end
do
local _MENUGROUPS={}
MENU_GROUP={
ClassName="MENU_GROUP"
}
function MENU_GROUP:New(Group,MenuText,ParentMenu)
MENU_INDEX:PrepareGroup(Group)
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(Group,Path)
if GroupMenu then
return GroupMenu
else
self=BASE:Inherit(self,MENU_BASE:New(MenuText,ParentMenu))
MENU_INDEX:SetGroupMenu(Group,Path,self)
self.Group=Group
self.GroupID=Group:GetID()
self.MenuPath=missionCommands.addSubMenuForGroup(self.GroupID,MenuText,self.MenuParentPath)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_GROUP:Refresh()
do
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
missionCommands.addSubMenuForGroup(self.GroupID,self.MenuText,self.MenuParentPath)
for MenuText,Menu in pairs(self.Menus or{})do
Menu:Refresh()
end
end
return self
end
function MENU_GROUP:RefreshAndOrderByTag()
do
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
missionCommands.addSubMenuForGroup(self.GroupID,self.MenuText,self.MenuParentPath)
local MenuTable={}
for MenuText,Menu in pairs(self.Menus or{})do
local tag=Menu.MenuTag or math.random(1,10000)
MenuTable[#MenuTable+1]={Tag=tag,Enty=Menu}
end
table.sort(MenuTable,function(k1,k2)return k1.tag<k2.tag end)
for _,Menu in pairs(MenuTable)do
Menu.Entry:Refresh()
end
end
return self
end
function MENU_GROUP:RemoveSubMenus(MenuStamp,MenuTag)
for MenuText,Menu in pairs(self.Menus or{})do
Menu:Remove(MenuStamp,MenuTag)
end
self.Menus=nil
end
function MENU_GROUP:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareGroup(self.Group)
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(self.Group,Path)
if GroupMenu==self then
self:RemoveSubMenus(MenuStamp,MenuTag)
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
if self.MenuPath~=nil then
self:F({Group=self.GroupID,Text=self.MenuText,Path=self.MenuPath})
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
end
MENU_INDEX:ClearGroupMenu(self.Group,Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_GROUP",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText,Group=self.Group})
return nil
end
return self
end
MENU_GROUP_COMMAND={
ClassName="MENU_GROUP_COMMAND"
}
function MENU_GROUP_COMMAND:New(Group,MenuText,ParentMenu,CommandMenuFunction,...)
MENU_INDEX:PrepareGroup(Group)
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(Group,Path)
if GroupMenu then
GroupMenu:SetCommandMenuFunction(CommandMenuFunction)
GroupMenu:SetCommandMenuArguments(arg)
return GroupMenu
else
self=BASE:Inherit(self,MENU_COMMAND_BASE:New(MenuText,ParentMenu,CommandMenuFunction,arg))
MENU_INDEX:SetGroupMenu(Group,Path,self)
self.Group=Group
self.GroupID=Group:GetID()
self.MenuPath=missionCommands.addCommandForGroup(self.GroupID,MenuText,self.MenuParentPath,self.MenuCallHandler)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_GROUP_COMMAND:Refresh()
do
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
missionCommands.addCommandForGroup(self.GroupID,self.MenuText,self.MenuParentPath,self.MenuCallHandler)
end
return self
end
function MENU_GROUP_COMMAND:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareGroup(self.Group)
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(self.Group,Path)
if GroupMenu==self then
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
if self.MenuPath~=nil then
self:F({Group=self.GroupID,Text=self.MenuText,Path=self.MenuPath})
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
end
MENU_INDEX:ClearGroupMenu(self.Group,Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_GROUP_COMMAND",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText,Group=self.Group})
end
return self
end
end
do
MENU_GROUP_DELAYED={
ClassName="MENU_GROUP_DELAYED"
}
function MENU_GROUP_DELAYED:New(Group,MenuText,ParentMenu)
MENU_INDEX:PrepareGroup(Group)
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(Group,Path)
if GroupMenu then
return GroupMenu
else
self=BASE:Inherit(self,MENU_BASE:New(MenuText,ParentMenu))
MENU_INDEX:SetGroupMenu(Group,Path,self)
self.Group=Group
self.GroupID=Group:GetID()
if self.MenuParentPath then
self.MenuPath=UTILS.DeepCopy(self.MenuParentPath)
else
self.MenuPath={}
end
table.insert(self.MenuPath,self.MenuText)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_GROUP_DELAYED:Set()
if not self.GroupID then return end
do
if not self.MenuSet then
missionCommands.addSubMenuForGroup(self.GroupID,self.MenuText,self.MenuParentPath)
self.MenuSet=true
end
for MenuText,Menu in pairs(self.Menus or{})do
Menu:Set()
end
end
end
function MENU_GROUP_DELAYED:Refresh()
do
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
missionCommands.addSubMenuForGroup(self.GroupID,self.MenuText,self.MenuParentPath)
for MenuText,Menu in pairs(self.Menus or{})do
Menu:Refresh()
end
end
return self
end
function MENU_GROUP_DELAYED:RemoveSubMenus(MenuStamp,MenuTag)
for MenuText,Menu in pairs(self.Menus or{})do
Menu:Remove(MenuStamp,MenuTag)
end
self.Menus=nil
end
function MENU_GROUP_DELAYED:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareGroup(self.Group)
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(self.Group,Path)
if GroupMenu==self then
self:RemoveSubMenus(MenuStamp,MenuTag)
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
if self.MenuPath~=nil then
self:F({Group=self.GroupID,Text=self.MenuText,Path=self.MenuPath})
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
end
MENU_INDEX:ClearGroupMenu(self.Group,Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_GROUP_DELAYED",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText,Group=self.Group})
return nil
end
return self
end
MENU_GROUP_COMMAND_DELAYED={
ClassName="MENU_GROUP_COMMAND_DELAYED"
}
function MENU_GROUP_COMMAND_DELAYED:New(Group,MenuText,ParentMenu,CommandMenuFunction,...)
MENU_INDEX:PrepareGroup(Group)
local Path=MENU_INDEX:ParentPath(ParentMenu,MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(Group,Path)
if GroupMenu then
GroupMenu:SetCommandMenuFunction(CommandMenuFunction)
GroupMenu:SetCommandMenuArguments(arg)
return GroupMenu
else
self=BASE:Inherit(self,MENU_COMMAND_BASE:New(MenuText,ParentMenu,CommandMenuFunction,arg))
MENU_INDEX:SetGroupMenu(Group,Path,self)
self.Group=Group
self.GroupID=Group:GetID()
if self.MenuParentPath then
self.MenuPath=UTILS.DeepCopy(self.MenuParentPath)
else
self.MenuPath={}
end
table.insert(self.MenuPath,self.MenuText)
self:SetParentMenu(self.MenuText,self)
return self
end
end
function MENU_GROUP_COMMAND_DELAYED:Set()
do
if not self.MenuSet then
self.MenuPath=missionCommands.addCommandForGroup(self.GroupID,self.MenuText,self.MenuParentPath,self.MenuCallHandler)
self.MenuSet=true
end
end
end
function MENU_GROUP_COMMAND_DELAYED:Refresh()
do
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
missionCommands.addCommandForGroup(self.GroupID,self.MenuText,self.MenuParentPath,self.MenuCallHandler)
end
return self
end
function MENU_GROUP_COMMAND_DELAYED:Remove(MenuStamp,MenuTag)
MENU_INDEX:PrepareGroup(self.Group)
local Path=MENU_INDEX:ParentPath(self.ParentMenu,self.MenuText)
local GroupMenu=MENU_INDEX:HasGroupMenu(self.Group,Path)
if GroupMenu==self then
if not MenuStamp or self.MenuStamp~=MenuStamp then
if(not MenuTag)or(MenuTag and self.MenuTag and MenuTag==self.MenuTag)then
if self.MenuPath~=nil then
self:F({Group=self.GroupID,Text=self.MenuText,Path=self.MenuPath})
missionCommands.removeItemForGroup(self.GroupID,self.MenuPath)
end
MENU_INDEX:ClearGroupMenu(self.Group,Path)
self:ClearParentMenu(self.MenuText)
return nil
end
end
else
BASE:E({"Cannot Remove MENU_GROUP_COMMAND_DELAYED",Path=Path,ParentMenu=self.ParentMenu,MenuText=self.MenuText,Group=self.Group})
end
return self
end
end
ZONE_BASE={
ClassName="ZONE_BASE",
ZoneName="",
ZoneProbability=1,
DrawID=nil,
Color={},
ZoneID=nil,
Properties={},
Surface=nil,
Checktime=5,
}
function ZONE_BASE:New(ZoneName)
local self=BASE:Inherit(self,FSM:New())
self.ZoneName=ZoneName
return self
end
function ZONE_BASE:GetName()
return self.ZoneName
end
function ZONE_BASE:SetName(ZoneName)
self.ZoneName=ZoneName
end
function ZONE_BASE:IsVec2InZone(Vec2)
return false
end
function ZONE_BASE:IsVec3InZone(Vec3)
if not Vec3 then return false end
local InZone=self:IsVec2InZone({x=Vec3.x,y=Vec3.z})
return InZone
end
function ZONE_BASE:IsCoordinateInZone(Coordinate)
if not Coordinate then return false end
local InZone=self:IsVec2InZone(Coordinate:GetVec2())
return InZone
end
function ZONE_BASE:IsPointVec2InZone(Coordinate)
local InZone=self:IsVec2InZone(Coordinate:GetVec2())
return InZone
end
function ZONE_BASE:IsPointVec3InZone(PointVec3)
local InZone=self:IsPointVec2InZone(PointVec3)
return InZone
end
function ZONE_BASE:GetVec2()
return nil
end
function ZONE_BASE:GetPointVec2()
local Vec2=self:GetVec2()
local PointVec2=COORDINATE:NewFromVec2(Vec2)
return PointVec2
end
function ZONE_BASE:GetVec3(Height)
Height=Height or 0
local Vec2=self:GetVec2()
local Vec3={x=Vec2.x,y=Height and Height or land.getHeight(self:GetVec2()),z=Vec2.y}
return Vec3
end
function ZONE_BASE:GetPointVec3(Height)
local Vec3=self:GetVec3(Height)
local PointVec3=COORDINATE:NewFromVec3(Vec3)
return PointVec3
end
function ZONE_BASE:GetCoordinate(Height)
local Vec3=self:GetVec3(Height)
if self.Coordinate then
self.Coordinate.x=Vec3.x
self.Coordinate.y=Vec3.y
self.Coordinate.z=Vec3.z
else
self.Coordinate=COORDINATE:NewFromVec3(Vec3)
end
return self.Coordinate
end
function ZONE_BASE:Get2DDistance(Coordinate)
local a=self:GetVec2()
local b={}
if Coordinate.z then
b.x=Coordinate.x
b.y=Coordinate.z
else
b.x=Coordinate.x
b.y=Coordinate.y
end
local dist=UTILS.VecDist2D(a,b)
return dist
end
function ZONE_BASE:GetRandomVec2()
return nil
end
function ZONE_BASE:GetRandomPointVec2()
return nil
end
function ZONE_BASE:GetRandomPointVec3()
return nil
end
function ZONE_BASE:GetBoundingSquare()
return nil
end
function ZONE_BASE:GetSurfaceType()
local coord=self:GetCoordinate()
local surface=coord:GetSurfaceType()
return surface
end
function ZONE_BASE:BoundZone()
end
function ZONE_BASE:SetDrawCoalition(Coalition)
self.drawCoalition=Coalition or-1
return self
end
function ZONE_BASE:GetDrawCoalition()
return self.drawCoalition or-1
end
function ZONE_BASE:SetColor(RGBcolor,Alpha)
RGBcolor=RGBcolor or{1,0,0}
Alpha=Alpha or 0.15
self.Color={}
self.Color[1]=RGBcolor[1]
self.Color[2]=RGBcolor[2]
self.Color[3]=RGBcolor[3]
self.Color[4]=Alpha
return self
end
function ZONE_BASE:GetColor()
return self.Color or{1,0,0,0.15}
end
function ZONE_BASE:GetColorRGB()
local rgb={}
local Color=self:GetColor()
rgb[1]=Color[1]
rgb[2]=Color[2]
rgb[3]=Color[3]
return rgb
end
function ZONE_BASE:GetColorAlpha()
local Color=self:GetColor()
local alpha=Color[4]
return alpha
end
function ZONE_BASE:SetFillColor(RGBcolor,Alpha)
RGBcolor=RGBcolor or{1,0,0}
Alpha=Alpha or 0.15
self.FillColor={}
self.FillColor[1]=RGBcolor[1]
self.FillColor[2]=RGBcolor[2]
self.FillColor[3]=RGBcolor[3]
self.FillColor[4]=Alpha
return self
end
function ZONE_BASE:GetFillColor()
return self.FillColor or{1,0,0,0.15}
end
function ZONE_BASE:GetFillColorRGB()
local rgb={}
local FillColor=self:GetFillColor()
rgb[1]=FillColor[1]
rgb[2]=FillColor[2]
rgb[3]=FillColor[3]
return rgb
end
function ZONE_BASE:GetFillColorAlpha()
local FillColor=self:GetFillColor()
local alpha=FillColor[4]
return alpha
end
function ZONE_BASE:UndrawZone(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,ZONE_BASE.UndrawZone,self)
else
if self.DrawID then
if type(self.DrawID)~="table"then
UTILS.RemoveMark(self.DrawID)
else
for _,mark_id in pairs(self.DrawID)do
UTILS.RemoveMark(mark_id)
end
end
end
end
return self
end
function ZONE_BASE:GetDrawID()
return self.DrawID
end
function ZONE_BASE:SmokeZone(SmokeColor)
end
function ZONE_BASE:SetZoneProbability(ZoneProbability)
self.ZoneProbability=ZoneProbability or 1
return self
end
function ZONE_BASE:GetZoneProbability()
return self.ZoneProbability
end
function ZONE_BASE:GetZoneMaybe()
local Randomization=math.random()
if Randomization<=self.ZoneProbability then
return self
else
return nil
end
end
function ZONE_BASE:SetCheckTime(seconds)
self.Checktime=seconds or 5
return self
end
function ZONE_BASE:Trigger(Objects)
self:SetStartState("TriggerStopped")
self:AddTransition("TriggerStopped","TriggerStart","TriggerRunning")
self:AddTransition("*","EnteredZone","*")
self:AddTransition("*","LeftZone","*")
self:AddTransition("*","ZoneEmpty","*")
self:AddTransition("*","ObjectDead","*")
self:AddTransition("*","TriggerRunCheck","*")
self:AddTransition("*","TriggerStop","TriggerStopped")
self:TriggerStart()
self.checkobjects=Objects
self.ObjectsInZone=false
if UTILS.IsInstanceOf(Objects,"SET_BASE")then
self.objectset=Objects.Set
else
self.objectset={Objects}
end
self:_TriggerCheck(true)
self:__TriggerRunCheck(self.Checktime)
return self
end
function ZONE_BASE:_TriggerCheck(fromstart)
local objectset=self.objectset or{}
if fromstart then
for _,_object in pairs(objectset)do
local obj=_object
if not obj.TriggerInZone then
obj.TriggerInZone={}
obj.TriggerZoneDeadNotification=false
end
if obj and obj:IsAlive()and self:IsCoordinateInZone(obj:GetCoordinate())then
obj.TriggerInZone[self.ZoneName]=true
self.ObjectsInZone=true
else
obj.TriggerInZone[self.ZoneName]=false
end
end
else
local objcount=0
for _,_object in pairs(objectset)do
local obj=_object
if obj and obj:IsAlive()then
if not obj.TriggerInZone then
obj.TriggerInZone={}
end
if not obj.TriggerInZone[self.ZoneName]then
obj.TriggerInZone[self.ZoneName]=false
end
local inzone=self:IsCoordinateInZone(obj:GetCoordinate())
if inzone and obj.TriggerInZone[self.ZoneName]then
objcount=objcount+1
self.ObjectsInZone=true
obj.TriggerZoneDeadNotification=false
end
if inzone and not obj.TriggerInZone[self.ZoneName]then
self:__EnteredZone(0.5,obj)
obj.TriggerInZone[self.ZoneName]=true
objcount=objcount+1
self.ObjectsInZone=true
obj.TriggerZoneDeadNotification=false
elseif(not inzone)and obj.TriggerInZone[self.ZoneName]then
self:__LeftZone(0.5,obj)
obj.TriggerInZone[self.ZoneName]=false
else
end
else
if not obj.TriggerZoneDeadNotification==true then
obj.TriggerInZone=nil
self:__ObjectDead(0.5,obj)
obj.TriggerZoneDeadNotification=true
end
end
end
if objcount==0 and self.ObjectsInZone==true then
self.ObjectsInZone=false
self:__ZoneEmpty(0.5)
end
end
return self
end
function ZONE_BASE:onafterTriggerRunCheck(From,Event,To)
if self:GetState()~="TriggerStopped"then
self:_TriggerCheck()
self:__TriggerRunCheck(self.Checktime)
end
return self
end
function ZONE_BASE:GetProperty(PropertyName)
return self.Properties[PropertyName]
end
function ZONE_BASE:GetAllProperties()
return self.Properties
end
ZONE_RADIUS={
ClassName="ZONE_RADIUS",
}
function ZONE_RADIUS:New(ZoneName,Vec2,Radius,DoNotRegisterZone)
local self=BASE:Inherit(self,ZONE_BASE:New(ZoneName))
self.Radius=Radius
self.Vec2=Vec2
if not DoNotRegisterZone then
_EVENTDISPATCHER:CreateEventNewZone(self)
end
return self
end
function ZONE_RADIUS:UpdateFromVec2(Vec2,Radius)
self.Vec2=Vec2
if Radius then
self.Radius=Radius
end
return self
end
function ZONE_RADIUS:UpdateFromVec3(Vec3,Radius)
self.Vec2.x=Vec3.x
self.Vec2.y=Vec3.z
if Radius then
self.Radius=Radius
end
return self
end
function ZONE_RADIUS:MarkZone(Points)
local Point={}
local Vec2=self:GetVec2()
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,(360/Points)do
local Radial=Angle*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
COORDINATE:NewFromVec2(Point):MarkToAll(self:GetName())
end
end
function ZONE_RADIUS:DrawZone(Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly)
local coordinate=self:GetCoordinate()
local Radius=self:GetRadius()
Color=Color or self:GetColorRGB()
Alpha=Alpha or 1
FillColor=FillColor or UTILS.DeepCopy(Color)
FillAlpha=FillAlpha or self:GetColorAlpha()
self.DrawID=coordinate:CircleToAll(Radius,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly)
return self
end
function ZONE_RADIUS:BoundZone(Points,CountryID,UnBound)
local Point={}
local Vec2=self:GetVec2()
local countryID=CountryID or country.id.USA
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,(360/Points)do
local Radial=Angle*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
local CountryName=_DATABASE.COUNTRY_NAME[countryID]
local Tire={
["country"]=CountryName,
["category"]="Fortifications",
["canCargo"]=false,
["shape_name"]="H-tyre_B_WF",
["type"]="Black_Tyre_WF",
["y"]=Point.y,
["x"]=Point.x,
["name"]=string.format("%s-Tire #%0d",self:GetName(),Angle),
["heading"]=0,
}
local Group=coalition.addStaticObject(countryID,Tire)
if UnBound and UnBound==true then
Group:destroy()
end
end
return self
end
function ZONE_RADIUS:SmokeZone(SmokeColor,Points,AddHeight,AngleOffset)
local Point={}
local Vec2=self:GetVec2()
AddHeight=AddHeight or 0
AngleOffset=AngleOffset or 0
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,360/Points do
local Radial=(Angle+AngleOffset)*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
COORDINATE:New(Point.x,AddHeight,Point.y):Smoke(SmokeColor)
end
return self
end
function ZONE_RADIUS:FlareZone(FlareColor,Points,Azimuth,AddHeight)
local Point={}
local Vec2=self:GetVec2()
AddHeight=AddHeight or 0
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,360/Points do
local Radial=Angle*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
COORDINATE:New(Point.x,AddHeight,Point.y):Flare(FlareColor,Azimuth)
end
return self
end
function ZONE_RADIUS:GetRadius()
return self.Radius
end
function ZONE_RADIUS:SetRadius(Radius)
self.Radius=Radius
return self.Radius
end
function ZONE_RADIUS:GetVec2()
return self.Vec2
end
function ZONE_RADIUS:SetVec2(Vec2)
self.Vec2=Vec2
return self.Vec2
end
function ZONE_RADIUS:GetVec3(Height)
Height=Height or 0
local Vec2=self:GetVec2()
local Vec3={x=Vec2.x,y=land.getHeight(self:GetVec2())+Height,z=Vec2.y}
return Vec3
end
function ZONE_RADIUS:Scan(ObjectCategories,UnitCategories)
self.ScanData={}
self.ScanData.Coalitions={}
self.ScanData.Scenery={}
self.ScanData.SceneryTable={}
self.ScanData.Units={}
local ZoneCoord=self:GetCoordinate()
local ZoneRadius=self:GetRadius()
local SphereSearch={
id=world.VolumeType.SPHERE,
params={
point=ZoneCoord:GetVec3(),
radius=ZoneRadius,
}
}
local function EvaluateZone(ZoneObject)
if ZoneObject then
local ObjectCategory=Object.getCategory(ZoneObject)
if(ObjectCategory==Object.Category.UNIT and ZoneObject:isExist()and ZoneObject:isActive())or(ObjectCategory==Object.Category.STATIC and ZoneObject:isExist())then
local CoalitionDCSUnit=ZoneObject:getCoalition()
local Include=false
if not UnitCategories then
Include=true
else
local CategoryDCSUnit=ZoneObject:getDesc().category
for UnitCategoryID,UnitCategory in pairs(UnitCategories)do
if UnitCategory==CategoryDCSUnit then
Include=true
break
end
end
end
if Include then
local CoalitionDCSUnit=ZoneObject:getCoalition()
self.ScanData.Coalitions[CoalitionDCSUnit]=true
self.ScanData.Units[ZoneObject]=ZoneObject
end
end
if ObjectCategory==Object.Category.SCENERY then
local SceneryType=ZoneObject:getTypeName()
local SceneryName=ZoneObject:getName()
self.ScanData.Scenery[SceneryType]=self.ScanData.Scenery[SceneryType]or{}
self.ScanData.Scenery[SceneryType][SceneryName]=SCENERY:Register(tostring(SceneryName),ZoneObject)
table.insert(self.ScanData.SceneryTable,self.ScanData.Scenery[SceneryType][SceneryName])
end
end
return true
end
world.searchObjects(ObjectCategories,SphereSearch,EvaluateZone)
end
function ZONE_RADIUS:RemoveJunk()
local radius=self.Radius
local vec3=self:GetVec3()
local volS={
id=world.VolumeType.SPHERE,
params={point=vec3,radius=radius}
}
local n=world.removeJunk(volS)
return n
end
function ZONE_RADIUS:GetScannedUnits()
return self.ScanData.Units
end
function ZONE_RADIUS:GetScannedSetUnit()
local SetUnit=SET_UNIT:New()
if self.ScanData then
for ObjectID,UnitObject in pairs(self.ScanData.Units)do
local UnitObject=UnitObject
if UnitObject:isExist()then
local FoundUnit=UNIT:FindByName(UnitObject:getName())
if FoundUnit then
SetUnit:AddUnit(FoundUnit)
else
local FoundStatic=STATIC:FindByName(UnitObject:getName(),false)
if FoundStatic then
SetUnit:AddUnit(FoundStatic)
end
end
end
end
end
return SetUnit
end
function ZONE_RADIUS:GetScannedSetGroup()
self.ScanSetGroup=self.ScanSetGroup or SET_GROUP:New()
self.ScanSetGroup.Set={}
if self.ScanData then
for ObjectID,UnitObject in pairs(self.ScanData.Units)do
local UnitObject=UnitObject
if UnitObject:isExist()then
local FoundUnit=UNIT:FindByName(UnitObject:getName())
if FoundUnit then
local group=FoundUnit:GetGroup()
self.ScanSetGroup:AddGroup(group)
end
end
end
end
return self.ScanSetGroup
end
function ZONE_RADIUS:CountScannedCoalitions()
local Count=0
for CoalitionID,Coalition in pairs(self.ScanData.Coalitions)do
Count=Count+1
end
return Count
end
function ZONE_RADIUS:CheckScannedCoalition(Coalition)
if Coalition then
return self.ScanData.Coalitions[Coalition]
end
return nil
end
function ZONE_RADIUS:GetScannedCoalition(Coalition)
if Coalition then
return self.ScanData.Coalitions[Coalition]
else
local Count=0
local ReturnCoalition=nil
for CoalitionID,Coalition in pairs(self.ScanData.Coalitions)do
Count=Count+1
ReturnCoalition=CoalitionID
end
if Count~=1 then
ReturnCoalition=nil
end
return ReturnCoalition
end
end
function ZONE_RADIUS:GetScannedSceneryType(SceneryType)
return self.ScanData.Scenery[SceneryType]
end
function ZONE_RADIUS:GetScannedScenery()
return self.ScanData.Scenery
end
function ZONE_RADIUS:GetScannedSceneryObjects()
return self.ScanData.SceneryTable
end
function ZONE_RADIUS:GetScannedSetScenery()
local scenery=SET_SCENERY:New()
local objects=self:GetScannedSceneryObjects()
for _,_obj in pairs(objects)do
scenery:AddScenery(_obj)
end
return scenery
end
function ZONE_RADIUS:IsAllInZoneOfCoalition(Coalition)
return self:CountScannedCoalitions()==1 and self:GetScannedCoalition(Coalition)==true
end
function ZONE_RADIUS:IsAllInZoneOfOtherCoalition(Coalition)
return self:CountScannedCoalitions()==1 and self:GetScannedCoalition(Coalition)==nil
end
function ZONE_RADIUS:IsSomeInZoneOfCoalition(Coalition)
return self:CountScannedCoalitions()>1 and self:GetScannedCoalition(Coalition)==true
end
function ZONE_RADIUS:IsNoneInZoneOfCoalition(Coalition)
return self:GetScannedCoalition(Coalition)==nil
end
function ZONE_RADIUS:IsNoneInZone()
return self:CountScannedCoalitions()==0
end
function ZONE_RADIUS:SearchZone(EvaluateFunction,ObjectCategories)
local SearchZoneResult=true
local ZoneCoord=self:GetCoordinate()
local ZoneRadius=self:GetRadius()
local SphereSearch={
id=world.VolumeType.SPHERE,
params={
point=ZoneCoord:GetVec3(),
radius=ZoneRadius,
}
}
local function EvaluateZone(ZoneDCSUnit)
local ZoneUnit=UNIT:Find(ZoneDCSUnit)
return EvaluateFunction(ZoneUnit)
end
world.searchObjects(Object.Category.UNIT,SphereSearch,EvaluateZone)
end
function ZONE_RADIUS:IsVec2InZone(Vec2)
if not Vec2 then return false end
local ZoneVec2=self:GetVec2()
if ZoneVec2 then
if((Vec2.x-ZoneVec2.x)^2+(Vec2.y-ZoneVec2.y)^2)^0.5<=self:GetRadius()then
return true
end
end
return false
end
function ZONE_RADIUS:IsVec3InZone(Vec3)
if not Vec3 then return false end
local InZone=self:IsVec2InZone({x=Vec3.x,y=Vec3.z})
return InZone
end
function ZONE_RADIUS:GetRandomVec2(inner,outer,surfacetypes)
local Vec2=self:GetVec2()
local _inner=inner or 0
local _outer=outer or self:GetRadius()
if surfacetypes and type(surfacetypes)~="table"then
surfacetypes={surfacetypes}
end
local function _getpoint()
local point={}
local angle=math.random()*math.pi*2
point.x=Vec2.x+math.cos(angle)*math.random(_inner,_outer)
point.y=Vec2.y+math.sin(angle)*math.random(_inner,_outer)
return point
end
local function _checkSurface(point)
local stype=land.getSurfaceType(point)
for _,sf in pairs(surfacetypes)do
if sf==stype then
return true
end
end
return false
end
local point=_getpoint()
if surfacetypes then
local N=1;local Nmax=100;local gotit=false
while gotit==false and N<=Nmax do
gotit=_checkSurface(point)
if gotit then
else
point=_getpoint()
N=N+1
end
end
end
return point
end
function ZONE_RADIUS:GetRandomPointVec2(inner,outer)
local PointVec2=COORDINATE:NewFromVec2(self:GetRandomVec2(inner,outer))
return PointVec2
end
function ZONE_RADIUS:GetRandomVec3(inner,outer)
local Vec2=self:GetRandomVec2(inner,outer)
return{x=Vec2.x,y=self.y,z=Vec2.y}
end
function ZONE_RADIUS:GetRandomPointVec3(inner,outer)
local PointVec3=COORDINATE:NewFromVec2(self:GetRandomVec2(inner,outer))
return PointVec3
end
function ZONE_RADIUS:GetRandomCoordinate(inner,outer,surfacetypes)
local vec2=self:GetRandomVec2(inner,outer,surfacetypes)
local Coordinate=COORDINATE:NewFromVec2(vec2)
return Coordinate
end
function ZONE_RADIUS:GetRandomCoordinateWithoutBuildings(inner,outer,distance,markbuildings,markfinal)
local dist=distance or 100
local objects={}
if self.ScanData and self.ScanData.Scenery then
objects=self:GetScannedScenery()
else
self:Scan({Object.Category.SCENERY})
objects=self:GetScannedScenery()
end
local T0=timer.getTime()
local T1=timer.getTime()
local buildings={}
local buildingzones={}
if self.ScanData and self.ScanData.BuildingCoordinates then
buildings=self.ScanData.BuildingCoordinates
buildingzones=self.ScanData.BuildingZones
else
for _,_object in pairs(objects)do
for _,_scen in pairs(_object)do
local scenery=_scen
local description=scenery:GetDesc()
if description and description.attributes and description.attributes.Buildings then
if markbuildings then
MARKER:New(scenery:GetCoordinate(),"Building"):ToAll()
end
buildings[#buildings+1]=scenery:GetCoordinate()
local bradius=scenery:GetBoundingRadius()or dist
local bzone=ZONE_RADIUS:New("Building-"..math.random(1,100000),scenery:GetVec2(),bradius,false)
buildingzones[#buildingzones+1]=bzone
end
end
end
self.ScanData.BuildingCoordinates=buildings
self.ScanData.BuildingZones=buildingzones
end
local rcoord=nil
local found=true
local iterations=0
for i=1,1000 do
iterations=iterations+1
rcoord=self:GetRandomCoordinate(inner,outer)
found=true
for _,_coord in pairs(buildingzones)do
local zone=_coord
if zone:IsPointVec2InZone(rcoord)then
found=false
break
end
end
if found then
if markfinal then
MARKER:New(rcoord,"FREE"):ToAll()
end
break
end
end
if not found then
local rcoord=nil
local found=true
local iterations=0
for i=1,1000 do
iterations=iterations+1
rcoord=self:GetRandomCoordinate(inner,outer)
found=true
for _,_coord in pairs(buildings)do
local coord=_coord
if coord:Get3DDistance(rcoord)<dist then
found=false
end
end
if found then
if markfinal then
MARKER:New(rcoord,"FREE"):ToAll()
end
break
end
end
end
T1=timer.getTime()
if found then return rcoord else return nil end
end
ZONE={
ClassName="ZONE",
}
function ZONE:New(ZoneName)
local zone=_DATABASE:FindZone(ZoneName)
if zone then
return zone
end
local Zone=trigger.misc.getZone(ZoneName)
if not Zone then
env.error("ERROR: Zone "..ZoneName.." does not exist!")
return nil
end
local self=BASE:Inherit(self,ZONE_RADIUS:New(ZoneName,{x=Zone.point.x,y=Zone.point.z},Zone.radius,true))
self.Color={1,0,0,0.15}
self.Zone=Zone
return self
end
function ZONE:FindByName(ZoneName)
local ZoneFound=_DATABASE:FindZone(ZoneName)
return ZoneFound
end
ZONE_UNIT={
ClassName="ZONE_UNIT",
}
function ZONE_UNIT:New(ZoneName,ZoneUNIT,Radius,Offset)
if Offset then
if(Offset.dx or Offset.dy)and(Offset.rho or Offset.theta)then
error("Cannot use (dx, dy) with (rho, theta)")
end
end
local self=BASE:Inherit(self,ZONE_RADIUS:New(ZoneName,ZoneUNIT:GetVec2(),Radius,true))
if Offset then
self.dy=Offset.dy or 0.0
self.dx=Offset.dx or 0.0
self.rho=Offset.rho or 0.0
self.theta=(Offset.theta or 0.0)*math.pi/180.0
self.relative_to_unit=Offset.relative_to_unit or false
end
self.ZoneUNIT=ZoneUNIT
self.LastVec2=ZoneUNIT:GetVec2()
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_UNIT:GetVec2()
local ZoneVec2=self.ZoneUNIT:GetVec2()
if ZoneVec2 then
local heading
if self.relative_to_unit then
heading=(self.ZoneUNIT:GetHeading()or 0.0)*math.pi/180.0
else
heading=0.0
end
if(self.dx or self.dy)then
ZoneVec2.x=ZoneVec2.x+self.dx*math.cos(-heading)+self.dy*math.sin(-heading)
ZoneVec2.y=ZoneVec2.y-self.dx*math.sin(-heading)+self.dy*math.cos(-heading)
end
if(self.rho or self.theta)then
ZoneVec2.x=ZoneVec2.x+self.rho*math.cos(self.theta+heading)
ZoneVec2.y=ZoneVec2.y+self.rho*math.sin(self.theta+heading)
end
self.LastVec2=ZoneVec2
return ZoneVec2
else
return self.LastVec2
end
return nil
end
function ZONE_UNIT:GetRandomVec2()
local RandomVec2={}
local Vec2=self:GetVec2()
if not Vec2 then
Vec2=self.LastVec2
end
local angle=math.random()*math.pi*2;
RandomVec2.x=Vec2.x+math.cos(angle)*math.random()*self:GetRadius();
RandomVec2.y=Vec2.y+math.sin(angle)*math.random()*self:GetRadius();
return RandomVec2
end
function ZONE_UNIT:GetVec3(Height)
Height=Height or 0
local Vec2=self:GetVec2()
local Vec3={x=Vec2.x,y=land.getHeight(self:GetVec2())+Height,z=Vec2.y}
return Vec3
end
ZONE_GROUP={
ClassName="ZONE_GROUP",
}
function ZONE_GROUP:New(ZoneName,ZoneGROUP,Radius)
local self=BASE:Inherit(self,ZONE_RADIUS:New(ZoneName,ZoneGROUP:GetVec2(),Radius,true))
self._.ZoneGROUP=ZoneGROUP
self._.ZoneVec2Cache=self._.ZoneGROUP:GetVec2()
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_GROUP:GetVec2()
local ZoneVec2=nil
if self._.ZoneGROUP:IsAlive()then
ZoneVec2=self._.ZoneGROUP:GetVec2()
self._.ZoneVec2Cache=ZoneVec2
else
ZoneVec2=self._.ZoneVec2Cache
end
return ZoneVec2
end
function ZONE_GROUP:GetRandomVec2()
local Point={}
local Vec2=self._.ZoneGROUP:GetVec2()
local angle=math.random()*math.pi*2;
Point.x=Vec2.x+math.cos(angle)*math.random()*self:GetRadius();
Point.y=Vec2.y+math.sin(angle)*math.random()*self:GetRadius();
return Point
end
function ZONE_GROUP:GetRandomPointVec2(inner,outer)
local PointVec2=COORDINATE:NewFromVec2(self:GetRandomVec2())
return PointVec2
end
_ZONE_TRIANGLE={
ClassName="ZONE_TRIANGLE",
Points={},
Coords={},
CenterVec2={x=0,y=0},
SurfaceArea=0,
DrawID={}
}
function _ZONE_TRIANGLE:New(p1,p2,p3)
local self=BASE:Inherit(self,ZONE_BASE:New())
self.Points={p1,p2,p3}
local center_x=(p1.x+p2.x+p3.x)/3
local center_y=(p1.y+p2.y+p3.y)/3
self.CenterVec2={x=center_x,y=center_y}
for _,pt in pairs({p1,p2,p3})do
table.add(self.Coords,COORDINATE:NewFromVec2(pt))
end
self.SurfaceArea=math.abs((p2.x-p1.x)*(p3.y-p1.y)-(p3.x-p1.x)*(p2.y-p1.y))*0.5
return self
end
function _ZONE_TRIANGLE:ContainsPoint(pt,points)
points=points or self.Points
local function sign(p1,p2,p3)
return(p1.x-p3.x)*(p2.y-p3.y)-(p2.x-p3.x)*(p1.y-p3.y)
end
local d1=sign(pt,self.Points[1],self.Points[2])
local d2=sign(pt,self.Points[2],self.Points[3])
local d3=sign(pt,self.Points[3],self.Points[1])
local has_neg=(d1<0)or(d2<0)or(d3<0)
local has_pos=(d1>0)or(d2>0)or(d3>0)
return not(has_neg and has_pos)
end
function _ZONE_TRIANGLE:GetRandomVec2(points)
points=points or self.Points
local pt={math.random(),math.random()}
table.sort(pt)
local s=pt[1]
local t=pt[2]-pt[1]
local u=1-pt[2]
return{x=s*points[1].x+t*points[2].x+u*points[3].x,
y=s*points[1].y+t*points[2].y+u*points[3].y}
end
function _ZONE_TRIANGLE:Draw(Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly)
Coalition=Coalition or-1
Color=Color or{1,0,0}
Alpha=Alpha or 1
FillColor=FillColor or Color
if not FillColor then UTILS.DeepCopy(Color)end
FillAlpha=FillAlpha or Alpha
if not FillAlpha then FillAlpha=1 end
for i=1,#self.Coords do
local c1=self.Coords[i]
local c2=self.Coords[i%#self.Coords+1]
local id=c1:LineToAll(c2,Coalition,Color,Alpha,LineType,ReadOnly)
self.DrawID[#self.DrawID+1]=id
end
local newID=self.Coords[1]:MarkupToAllFreeForm({self.Coords[2],self.Coords[3]},Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly)
self.DrawID[#self.DrawID+1]=newID
return self.DrawID
end
function _ZONE_TRIANGLE:Fill(Coalition,FillColor,FillAlpha,ReadOnly)
Coalition=Coalition or-1
FillColor=FillColor
FillAlpha=FillAlpha
local newID=self.Coords[1]:MarkupToAllFreeForm({self.Coords[2],self.Coords[3]},Coalition,nil,nil,FillColor,FillAlpha,0,nil)
self.DrawID[#self.DrawID+1]=newID
return self.DrawID
end
ZONE_POLYGON_BASE={
ClassName="ZONE_POLYGON_BASE",
_Triangles={},
SurfaceArea=0,
DrawID={},
FillTriangles={},
Borderlines={},
}
function ZONE_POLYGON_BASE:New(ZoneName,PointsArray)
local self=BASE:Inherit(self,ZONE_BASE:New(ZoneName))
if PointsArray then
self._.Polygon={}
for i=1,#PointsArray do
self._.Polygon[i]={}
self._.Polygon[i].x=PointsArray[i].x
self._.Polygon[i].y=PointsArray[i].y
end
self._Triangles=self:_Triangulate()
self.SurfaceArea=self:_CalculateSurfaceArea()
end
return self
end
function ZONE_POLYGON_BASE:_Triangulate()
local points=self._.Polygon
local triangles={}
local function get_orientation(shape_points)
local sum=0
for i=1,#shape_points do
local j=i%#shape_points+1
sum=sum+(shape_points[j].x-shape_points[i].x)*(shape_points[j].y+shape_points[i].y)
end
return sum>=0 and"clockwise"or"counter-clockwise"
end
local function ensure_clockwise(shape_points)
local orientation=get_orientation(shape_points)
if orientation=="counter-clockwise"then
local reversed={}
for i=#shape_points,1,-1 do
table.insert(reversed,shape_points[i])
end
return reversed
end
return shape_points
end
local function is_clockwise(p1,p2,p3)
local cross_product=(p2.x-p1.x)*(p3.y-p1.y)-(p2.y-p1.y)*(p3.x-p1.x)
return cross_product<0
end
local function divide_recursively(shape_points)
if#shape_points==3 then
table.insert(triangles,_ZONE_TRIANGLE:New(shape_points[1],shape_points[2],shape_points[3]))
elseif#shape_points>3 then
for i,p1 in ipairs(shape_points)do
local p2=shape_points[(i%#shape_points)+1]
local p3=shape_points[(i+1)%#shape_points+1]
local triangle=_ZONE_TRIANGLE:New(p1,p2,p3)
local is_ear=true
if not is_clockwise(p1,p2,p3)then
is_ear=false
else
for _,point in ipairs(shape_points)do
if point~=p1 and point~=p2 and point~=p3 and triangle:ContainsPoint(point)then
is_ear=false
break
end
end
end
if is_ear then
local is_valid_triangle=true
for _,point in ipairs(points)do
if point~=p1 and point~=p2 and point~=p3 and triangle:ContainsPoint(point)then
is_valid_triangle=false
break
end
end
if is_valid_triangle then
table.insert(triangles,triangle)
local remaining_points={}
for j,point in ipairs(shape_points)do
if point~=p2 then
table.insert(remaining_points,point)
end
end
divide_recursively(remaining_points)
break
end
else
end
end
end
end
points=ensure_clockwise(points)
divide_recursively(points)
return triangles
end
function ZONE_POLYGON_BASE:UpdateFromVec2(Vec2Array)
self._.Polygon={}
for i=1,#Vec2Array do
self._.Polygon[i]={}
self._.Polygon[i].x=Vec2Array[i].x
self._.Polygon[i].y=Vec2Array[i].y
end
self._Triangles=self:_Triangulate()
self.SurfaceArea=self:_CalculateSurfaceArea()
return self
end
function ZONE_POLYGON_BASE:UpdateFromVec3(Vec3Array)
self._.Polygon={}
for i=1,#Vec3Array do
self._.Polygon[i]={}
self._.Polygon[i].x=Vec3Array[i].x
self._.Polygon[i].y=Vec3Array[i].z
end
self._Triangles=self:_Triangulate()
self.SurfaceArea=self:_CalculateSurfaceArea()
return self
end
function ZONE_POLYGON_BASE:_CalculateSurfaceArea()
local area=0
for _,triangle in pairs(self._Triangles)do
area=area+triangle.SurfaceArea
end
return area
end
function ZONE_POLYGON_BASE:GetVec2()
local Bounds=self:GetBoundingSquare()
return{x=(Bounds.x2+Bounds.x1)/2,y=(Bounds.y2+Bounds.y1)/2}
end
function ZONE_POLYGON_BASE:GetVertexVec2(Index)
return self._.Polygon[Index or 1]
end
function ZONE_POLYGON_BASE:GetVertexVec3(Index)
local vec2=self:GetVertexVec2(Index)
if vec2 then
local vec3={x=vec2.x,y=land.getHeight(vec2),z=vec2.y}
return vec3
end
return nil
end
function ZONE_POLYGON_BASE:GetVertexCoordinate(Index)
local vec2=self:GetVertexVec2(Index)
if vec2 then
local coord=COORDINATE:NewFromVec2(vec2)
return coord
end
return nil
end
function ZONE_POLYGON_BASE:GetVerticiesVec2()
return self._.Polygon
end
function ZONE_POLYGON_BASE:GetVerticiesVec3()
local coords={}
for i,vec2 in ipairs(self._.Polygon)do
local vec3={x=vec2.x,y=land.getHeight(vec2),z=vec2.y}
table.insert(coords,vec3)
end
return coords
end
function ZONE_POLYGON_BASE:GetVerticiesCoordinates()
local coords={}
for i,vec2 in ipairs(self._.Polygon)do
local coord=COORDINATE:NewFromVec2(vec2)
table.insert(coords,coord)
end
return coords
end
function ZONE_POLYGON_BASE:Flush()
return self
end
function ZONE_POLYGON_BASE:BoundZone(UnBound)
local i
local j
local Segments=10
i=1
j=#self._.Polygon
while i<=#self._.Polygon do
local DeltaX=self._.Polygon[j].x-self._.Polygon[i].x
local DeltaY=self._.Polygon[j].y-self._.Polygon[i].y
for Segment=0,Segments do
local PointX=self._.Polygon[i].x+(Segment*DeltaX/Segments)
local PointY=self._.Polygon[i].y+(Segment*DeltaY/Segments)
local Tire={
["country"]="USA",
["category"]="Fortifications",
["canCargo"]=false,
["shape_name"]="H-tyre_B_WF",
["type"]="Black_Tyre_WF",
["y"]=PointY,
["x"]=PointX,
["name"]=string.format("%s-Tire #%0d",self:GetName(),((i-1)*Segments)+Segment),
["heading"]=0,
}
local Group=coalition.addStaticObject(country.id.USA,Tire)
if UnBound and UnBound==true then
Group:destroy()
end
end
j=i
i=i+1
end
return self
end
function ZONE_POLYGON_BASE:DrawZone(Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,IncludeTriangles)
if self._.Polygon and#self._.Polygon>=3 then
Coalition=Coalition or self:GetDrawCoalition()
self:SetDrawCoalition(Coalition)
Color=Color or self:GetColorRGB()
Alpha=Alpha or self:GetColorAlpha()
FillColor=FillColor or self:GetFillColorRGB()
FillAlpha=FillAlpha or self:GetFillColorAlpha()
if FillColor then
self:ReFill(FillColor,FillAlpha)
end
if Color then
self:ReDrawBorderline(Color,Alpha,LineType)
end
end
if false then
local coords=self:GetVerticiesCoordinates()
local coord=coords[1]
table.remove(coords,1)
coord:MarkupToAllFreeForm(coords,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,"Drew Polygon")
if true then
return
end
end
return self
end
function ZONE_POLYGON_BASE:ReFill(Color,Alpha)
local color=Color or self:GetFillColorRGB()or{1,0,0}
local alpha=Alpha or self:GetFillColorAlpha()or 1
local coalition=self:GetDrawCoalition()or-1
if#self.FillTriangles>0 then
for _,triangle in pairs(self._Triangles)do
triangle:UndrawZone()
end
for _,_value in pairs(self.FillTriangles)do
table.remove_by_value(self.DrawID,_value)
end
self.FillTriangles=nil
self.FillTriangles={}
end
for _,triangle in pairs(self._Triangles)do
local draw_ids=triangle:Fill(coalition,color,alpha,nil)
self.FillTriangles=draw_ids
table.combine(self.DrawID,draw_ids)
end
return self
end
function ZONE_POLYGON_BASE:ReDrawBorderline(Color,Alpha,LineType)
local color=Color or self:GetFillColorRGB()or{1,0,0}
local alpha=Alpha or self:GetFillColorAlpha()or 1
local coalition=self:GetDrawCoalition()or-1
local linetype=LineType or 1
if#self.Borderlines>0 then
for _,MarkID in pairs(self.Borderlines)do
trigger.action.removeMark(MarkID)
end
for _,_value in pairs(self.Borderlines)do
table.remove_by_value(self.DrawID,_value)
end
self.Borderlines=nil
self.Borderlines={}
end
local coords=self:GetVerticiesCoordinates()
for i=1,#coords do
local c1=coords[i]
local c2=coords[i%#coords+1]
local newID=c1:LineToAll(c2,coalition,color,alpha,linetype,nil)
self.DrawID[#self.DrawID+1]=newID
self.Borderlines[#self.Borderlines+1]=newID
end
return self
end
function ZONE_POLYGON_BASE:GetSurfaceArea()
return self.SurfaceArea
end
function ZONE_POLYGON_BASE:GetRadius()
local center=self:GetVec2()
local radius=0
for _,_vec2 in pairs(self._.Polygon)do
local vec2=_vec2
local r=UTILS.VecDist2D(center,vec2)
if r>radius then
radius=r
end
end
return radius
end
function ZONE_POLYGON_BASE:GetZoneRadius(ZoneName,DoNotRegisterZone)
local center=self:GetVec2()
local radius=self:GetRadius()
local zone=ZONE_RADIUS:New(ZoneName or self.ZoneName,center,radius,DoNotRegisterZone)
return zone
end
function ZONE_POLYGON_BASE:GetZoneQuad(ZoneName,DoNotRegisterZone)
local vec1,vec3=self:GetBoundingVec2()
local vec2={x=vec1.x,y=vec3.y}
local vec4={x=vec3.x,y=vec1.y}
local zone=ZONE_POLYGON_BASE:New(ZoneName or self.ZoneName,{vec1,vec2,vec3,vec4})
return zone
end
function ZONE_POLYGON_BASE:RemoveJunk(Height)
Height=Height or 1000
local vec2SW,vec2NE=self:GetBoundingVec2()
local vec3SW={x=vec2SW.x,y=-Height,z=vec2SW.y}
local vec3NE={x=vec2NE.x,y=Height,z=vec2NE.y}
local volume={
id=world.VolumeType.BOX,
params={
min=vec3SW,
max=vec3SW
}
}
local n=world.removeJunk(volume)
return n
end
function ZONE_POLYGON_BASE:SmokeZone(SmokeColor,Segments)
Segments=Segments or 10
local i=1
local j=#self._.Polygon
while i<=#self._.Polygon do
local DeltaX=self._.Polygon[j].x-self._.Polygon[i].x
local DeltaY=self._.Polygon[j].y-self._.Polygon[i].y
for Segment=0,Segments do
local PointX=self._.Polygon[i].x+(Segment*DeltaX/Segments)
local PointY=self._.Polygon[i].y+(Segment*DeltaY/Segments)
COORDINATE:New(PointX,0,PointY):Smoke(SmokeColor)
end
j=i
i=i+1
end
return self
end
function ZONE_POLYGON_BASE:FlareZone(FlareColor,Segments,Azimuth,AddHeight)
Segments=Segments or 10
AddHeight=AddHeight or 0
local i=1
local j=#self._.Polygon
while i<=#self._.Polygon do
local DeltaX=self._.Polygon[j].x-self._.Polygon[i].x
local DeltaY=self._.Polygon[j].y-self._.Polygon[i].y
for Segment=0,Segments do
local PointX=self._.Polygon[i].x+(Segment*DeltaX/Segments)
local PointY=self._.Polygon[i].y+(Segment*DeltaY/Segments)
COORDINATE:New(PointX,AddHeight,PointY):Flare(FlareColor,Azimuth)
end
j=i
i=i+1
end
return self
end
function ZONE_POLYGON_BASE:IsVec2InZone(Vec2)
if not Vec2 then return false end
local Next
local Prev
local InPolygon=false
Next=1
Prev=#self._.Polygon
while Next<=#self._.Polygon do
if(((self._.Polygon[Next].y>Vec2.y)~=(self._.Polygon[Prev].y>Vec2.y))and
(Vec2.x<(self._.Polygon[Prev].x-self._.Polygon[Next].x)*(Vec2.y-self._.Polygon[Next].y)/(self._.Polygon[Prev].y-self._.Polygon[Next].y)+self._.Polygon[Next].x)
)then
InPolygon=not InPolygon
end
Prev=Next
Next=Next+1
end
return InPolygon
end
function ZONE_POLYGON_BASE:IsVec3InZone(Vec3)
if not Vec3 then return false end
local InZone=self:IsVec2InZone({x=Vec3.x,y=Vec3.z})
return InZone
end
function ZONE_POLYGON_BASE:GetRandomVec2()
local weights={}
for _,triangle in pairs(self._Triangles)do
weights[triangle]=triangle.SurfaceArea/self.SurfaceArea
end
local random_weight=math.random()
local accumulated_weight=0
for triangle,weight in pairs(weights)do
accumulated_weight=accumulated_weight+weight
if accumulated_weight>=random_weight then
return triangle:GetRandomVec2()
end
end
end
function ZONE_POLYGON_BASE:GetRandomPointVec2()
local PointVec2=COORDINATE:NewFromVec2(self:GetRandomVec2())
return PointVec2
end
function ZONE_POLYGON_BASE:GetRandomPointVec3()
local PointVec3=COORDINATE:NewFromVec2(self:GetRandomVec2())
return PointVec3
end
function ZONE_POLYGON_BASE:GetRandomCoordinate()
local Coordinate=COORDINATE:NewFromVec2(self:GetRandomVec2())
return Coordinate
end
function ZONE_POLYGON_BASE:GetBoundingSquare()
local x1=self._.Polygon[1].x
local y1=self._.Polygon[1].y
local x2=self._.Polygon[1].x
local y2=self._.Polygon[1].y
for i=2,#self._.Polygon do
x1=(x1>self._.Polygon[i].x)and self._.Polygon[i].x or x1
x2=(x2<self._.Polygon[i].x)and self._.Polygon[i].x or x2
y1=(y1>self._.Polygon[i].y)and self._.Polygon[i].y or y1
y2=(y2<self._.Polygon[i].y)and self._.Polygon[i].y or y2
end
return{x1=x1,y1=y1,x2=x2,y2=y2}
end
function ZONE_POLYGON_BASE:GetBoundingVec2()
local x1=self._.Polygon[1].x
local y1=self._.Polygon[1].y
local x2=self._.Polygon[1].x
local y2=self._.Polygon[1].y
for i=2,#self._.Polygon do
x1=(x1>self._.Polygon[i].x)and self._.Polygon[i].x or x1
x2=(x2<self._.Polygon[i].x)and self._.Polygon[i].x or x2
y1=(y1>self._.Polygon[i].y)and self._.Polygon[i].y or y1
y2=(y2<self._.Polygon[i].y)and self._.Polygon[i].y or y2
end
local vec1={x=x1,y=y1}
local vec2={x=x2,y=y2}
return vec1,vec2
end
function ZONE_POLYGON_BASE:Boundary(Coalition,Color,Radius,Alpha,Segments,Closed)
Coalition=Coalition or-1
Color=Color or{1,1,1}
Radius=Radius or 1000
Alpha=Alpha or 1
Segments=Segments or 10
Closed=Closed or false
local Limit
local i=1
local j=#self._.Polygon
if(Closed)then
Limit=#self._.Polygon+1
else
Limit=#self._.Polygon
end
while i<=#self._.Polygon do
if j~=Limit then
local DeltaX=self._.Polygon[j].x-self._.Polygon[i].x
local DeltaY=self._.Polygon[j].y-self._.Polygon[i].y
for Segment=0,Segments do
local PointX=self._.Polygon[i].x+(Segment*DeltaX/Segments)
local PointY=self._.Polygon[i].y+(Segment*DeltaY/Segments)
end
end
j=i
i=i+1
end
return self
end
do
ZONE_POLYGON={
ClassName="ZONE_POLYGON",
}
function ZONE_POLYGON:New(ZoneName,ZoneGroup)
local GroupPoints=ZoneGroup:GetTaskRoute()
local self=BASE:Inherit(self,ZONE_POLYGON_BASE:New(ZoneName,GroupPoints))
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_POLYGON:NewFromPointsArray(ZoneName,PointsArray)
local self=BASE:Inherit(self,ZONE_POLYGON_BASE:New(ZoneName,PointsArray))
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_POLYGON:NewFromGroupName(GroupName)
local ZoneGroup=GROUP:FindByName(GroupName)
local GroupPoints=ZoneGroup:GetTaskRoute()
local self=BASE:Inherit(self,ZONE_POLYGON_BASE:New(GroupName,GroupPoints))
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_POLYGON:NewFromDrawing(DrawingName)
local points={}
for _,layer in pairs(env.mission.drawings.layers)do
for _,object in pairs(layer["objects"])do
if object["name"]==DrawingName then
if(object["primitiveType"]=="Line"and object["closed"]==true)or(object["polygonMode"]=="free")then
for _,point in UTILS.spairs(object["points"])do
local skip=false
local p={x=object["mapX"]+point["x"],
y=object["mapY"]+point["y"]}
for _,pt in pairs(points)do
if pt.x==p.x and pt.y==p.y then
skip=true
end
end
if not skip then
table.add(points,p)
end
end
elseif object["polygonMode"]=="rect"then
local angle=object["angle"]
local half_width=object["width"]/2
local half_height=object["height"]/2
local center={x=object["mapX"],y=object["mapY"]}
local p1=UTILS.RotatePointAroundPivot({x=center.x-half_height,y=center.y+half_width},center,angle)
local p2=UTILS.RotatePointAroundPivot({x=center.x+half_height,y=center.y+half_width},center,angle)
local p3=UTILS.RotatePointAroundPivot({x=center.x+half_height,y=center.y-half_width},center,angle)
local p4=UTILS.RotatePointAroundPivot({x=center.x-half_height,y=center.y-half_width},center,angle)
points={p1,p2,p3,p4}
else
end
end
end
end
local self=BASE:Inherit(self,ZONE_POLYGON_BASE:New(DrawingName,points))
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_POLYGON:FindByName(ZoneName)
local ZoneFound=_DATABASE:FindZone(ZoneName)
return ZoneFound
end
function ZONE_POLYGON:Scan(ObjectCategories,UnitCategories)
self.ScanData={}
self.ScanData.Coalitions={}
self.ScanData.Scenery={}
self.ScanData.SceneryTable={}
self.ScanData.Units={}
local vectors=self:GetBoundingSquare()
local minVec3={x=vectors.x1,y=0,z=vectors.y1}
local maxVec3={x=vectors.x2,y=0,z=vectors.y2}
local minmarkcoord=COORDINATE:NewFromVec3(minVec3)
local maxmarkcoord=COORDINATE:NewFromVec3(maxVec3)
local ZoneRadius=minmarkcoord:Get2DDistance(maxmarkcoord)/2
local CenterVec3=self:GetCoordinate():GetVec3()
local SphereSearch={
id=world.VolumeType.SPHERE,
params={
point=CenterVec3,
radius=ZoneRadius,
}
}
local function EvaluateZone(ZoneObject)
if ZoneObject then
local ObjectCategory=Object.getCategory(ZoneObject)
if(ObjectCategory==Object.Category.UNIT and ZoneObject:isExist()and ZoneObject:isActive())or(ObjectCategory==Object.Category.STATIC and ZoneObject:isExist())then
local CoalitionDCSUnit=ZoneObject:getCoalition()
local Include=false
if not UnitCategories then
Include=true
else
local CategoryDCSUnit=ZoneObject:getDesc().category
for UnitCategoryID,UnitCategory in pairs(UnitCategories)do
if UnitCategory==CategoryDCSUnit then
Include=true
break
end
end
end
if Include then
local CoalitionDCSUnit=ZoneObject:getCoalition()
self.ScanData.Coalitions[CoalitionDCSUnit]=true
self.ScanData.Units[ZoneObject]=ZoneObject
end
end
if ObjectCategory==Object.Category.SCENERY and self:IsVec3InZone(ZoneObject:getPoint())then
local SceneryType=ZoneObject:getTypeName()
local SceneryName=ZoneObject:getName()
self.ScanData.Scenery[SceneryType]=self.ScanData.Scenery[SceneryType]or{}
self.ScanData.Scenery[SceneryType][SceneryName]=SCENERY:Register(SceneryName,ZoneObject)
table.insert(self.ScanData.SceneryTable,self.ScanData.Scenery[SceneryType][SceneryName])
end
end
return true
end
local inzoneunits=SET_UNIT:New():FilterZones({self}):FilterOnce()
local inzonestatics=SET_STATIC:New():FilterZones({self}):FilterOnce()
inzoneunits:ForEach(
function(unit)
local Unit=unit
local DCS=Unit:GetDCSObject()
EvaluateZone(DCS)
end
)
inzonestatics:ForEach(
function(static)
local Static=static
local DCS=Static:GetDCSObject()
EvaluateZone(DCS)
end
)
local searchscenery=false
for _,_type in pairs(ObjectCategories)do
if _type==Object.Category.SCENERY then
searchscenery=true
end
end
if searchscenery then
world.searchObjects({Object.Category.SCENERY},SphereSearch,EvaluateZone)
end
end
function ZONE_POLYGON:GetScannedUnits()
return self.ScanData.Units
end
function ZONE_POLYGON:GetScannedSetUnit()
local SetUnit=SET_UNIT:New()
if self.ScanData then
for ObjectID,UnitObject in pairs(self.ScanData.Units)do
local UnitObject=UnitObject
if UnitObject:isExist()then
local FoundUnit=UNIT:FindByName(UnitObject:getName())
if FoundUnit then
SetUnit:AddUnit(FoundUnit)
else
local FoundStatic=STATIC:FindByName(UnitObject:getName())
if FoundStatic then
SetUnit:AddUnit(FoundStatic)
end
end
end
end
end
return SetUnit
end
function ZONE_POLYGON:GetScannedSetGroup()
self.ScanSetGroup=self.ScanSetGroup or SET_GROUP:New()
self.ScanSetGroup.Set={}
if self.ScanData then
for ObjectID,UnitObject in pairs(self.ScanData.Units)do
local UnitObject=UnitObject
if UnitObject:isExist()then
local FoundUnit=UNIT:FindByName(UnitObject:getName())
if FoundUnit then
local group=FoundUnit:GetGroup()
self.ScanSetGroup:AddGroup(group)
end
end
end
end
return self.ScanSetGroup
end
function ZONE_POLYGON:CountScannedCoalitions()
local Count=0
for CoalitionID,Coalition in pairs(self.ScanData.Coalitions)do
Count=Count+1
end
return Count
end
function ZONE_POLYGON:CheckScannedCoalition(Coalition)
if Coalition then
return self.ScanData.Coalitions[Coalition]
end
return nil
end
function ZONE_POLYGON:GetScannedCoalition(Coalition)
if Coalition then
return self.ScanData.Coalitions[Coalition]
else
local Count=0
local ReturnCoalition=nil
for CoalitionID,Coalition in pairs(self.ScanData.Coalitions)do
Count=Count+1
ReturnCoalition=CoalitionID
end
if Count~=1 then
ReturnCoalition=nil
end
return ReturnCoalition
end
end
function ZONE_POLYGON:GetScannedSceneryType(SceneryType)
return self.ScanData.Scenery[SceneryType]
end
function ZONE_POLYGON:GetScannedSceneryObjects()
return self.ScanData.SceneryTable
end
function ZONE_POLYGON:GetScannedScenery()
return self.ScanData.Scenery
end
function ZONE_POLYGON:GetScannedSetScenery()
local scenery=SET_SCENERY:New()
local objects=self:GetScannedSceneryObjects()
for _,_obj in pairs(objects)do
scenery:AddScenery(_obj)
end
return scenery
end
function ZONE_POLYGON:IsAllInZoneOfCoalition(Coalition)
return self:CountScannedCoalitions()==1 and self:GetScannedCoalition(Coalition)==true
end
function ZONE_POLYGON:IsAllInZoneOfOtherCoalition(Coalition)
return self:CountScannedCoalitions()==1 and self:GetScannedCoalition(Coalition)==nil
end
function ZONE_POLYGON:IsSomeInZoneOfCoalition(Coalition)
return self:CountScannedCoalitions()>1 and self:GetScannedCoalition(Coalition)==true
end
function ZONE_POLYGON:IsNoneInZoneOfCoalition(Coalition)
return self:GetScannedCoalition(Coalition)==nil
end
function ZONE_POLYGON:IsNoneInZone()
return self:CountScannedCoalitions()==0
end
end
do
ZONE_ELASTIC={
ClassName="ZONE_ELASTIC",
points={},
setGroups={}
}
function ZONE_ELASTIC:New(ZoneName,Points)
local self=BASE:Inherit(self,ZONE_POLYGON_BASE:New(ZoneName,Points))
_EVENTDISPATCHER:CreateEventNewZone(self)
if Points then
self.points=Points
end
return self
end
function ZONE_ELASTIC:AddVertex2D(Vec2)
table.insert(self.points,Vec2)
return self
end
function ZONE_ELASTIC:RemoveVertex2D(Vec2)
local found=false
local findex=0
for _id,_vec2 in pairs(self.points)do
if _vec2.x==Vec2.x and _vec2.y==Vec2.y then
found=true
findex=_id
break
end
end
if found==true and findex>0 then
table.remove(self.points,findex)
end
return self
end
function ZONE_ELASTIC:RemoveVertex3D(Vec3)
return self:RemoveVertex2D({x=Vec3.x,y=Vec3.z})
end
function ZONE_ELASTIC:AddVertex3D(Vec3)
table.insert(self.points,{x=Vec3.x,y=Vec3.z})
return self
end
function ZONE_ELASTIC:AddSetGroup(GroupSet)
table.insert(self.setGroups,GroupSet)
return self
end
function ZONE_ELASTIC:Update(Delay,Draw)
local points=UTILS.DeepCopy(self.points or{})
if self.setGroups then
for _,_setGroup in pairs(self.setGroups)do
local setGroup=_setGroup
for _,_group in pairs(setGroup.Set)do
local group=_group
if group and group:IsAlive()then
table.insert(points,group:GetVec2())
end
end
end
end
self._.Polygon=self:_ConvexHull(points)
self._Triangles=self:_Triangulate()
self.SurfaceArea=self:_CalculateSurfaceArea()
if Draw~=false then
if self.DrawID or Draw==true then
self:UndrawZone()
self:DrawZone()
end
end
return self
end
function ZONE_ELASTIC:StartUpdate(Tstart,dT,Tstop,Draw)
self.updateID=self:ScheduleRepeat(Tstart,dT,0,Tstop,ZONE_ELASTIC.Update,self,0,Draw)
return self
end
function ZONE_ELASTIC:StopUpdate(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,ZONE_ELASTIC.StopUpdate,self)
else
if self.updateID then
self:ScheduleStop(self.updateID)
self.updateID=nil
end
end
return self
end
function ZONE_ELASTIC:_ConvexHull(pl)
if#pl==0 then
return{}
end
table.sort(pl,function(left,right)
return left.x<right.x
end)
local h={}
local function ccw(a,b,c)
return(b.x-a.x)*(c.y-a.y)>(b.y-a.y)*(c.x-a.x)
end
for i,pt in pairs(pl)do
while#h>=2 and not ccw(h[#h-1],h[#h],pt)do
table.remove(h,#h)
end
table.insert(h,pt)
end
local t=#h+1
for i=#pl,1,-1 do
local pt=pl[i]
while#h>=t and not ccw(h[#h-1],h[#h],pt)do
table.remove(h,#h)
end
table.insert(h,pt)
end
table.remove(h,#h)
return h
end
end
ZONE_OVAL={
ClassName="OVAL",
ZoneName="",
MajorAxis=nil,
MinorAxis=nil,
Angle=0,
DrawPoly=nil
}
function ZONE_OVAL:New(name,vec2,major_axis,minor_axis,angle)
self=BASE:Inherit(self,ZONE_BASE:New())
self.ZoneName=name
self.CenterVec2=vec2
self.MajorAxis=major_axis
self.MinorAxis=minor_axis
self.Angle=angle or 0
_DATABASE:AddZone(name,self)
return self
end
function ZONE_OVAL:NewFromDrawing(DrawingName)
self=BASE:Inherit(self,ZONE_BASE:New(DrawingName))
for _,layer in pairs(env.mission.drawings.layers)do
for _,object in pairs(layer["objects"])do
if string.find(object["name"],DrawingName,1,true)then
if object["polygonMode"]=="oval"then
self.CenterVec2={x=object["mapX"],y=object["mapY"]}
self.MajorAxis=object["r1"]
self.MinorAxis=object["r2"]
self.Angle=object["angle"]
end
end
end
end
_DATABASE:AddZone(DrawingName,self)
return self
end
function ZONE_OVAL:GetMajorAxis()
return self.MajorAxis
end
function ZONE_OVAL:GetMinorAxis()
return self.MinorAxis
end
function ZONE_OVAL:GetAngle()
return self.Angle
end
function ZONE_OVAL:GetVec2()
return self.CenterVec2
end
function ZONE_OVAL:IsVec2InZone(vec2)
local cos,sin=math.cos,math.sin
local dx=vec2.x-self.CenterVec2.x
local dy=vec2.y-self.CenterVec2.y
local rx=dx*cos(self.Angle)+dy*sin(self.Angle)
local ry=-dx*sin(self.Angle)+dy*cos(self.Angle)
return rx*rx/(self.MajorAxis*self.MajorAxis)+ry*ry/(self.MinorAxis*self.MinorAxis)<=1
end
function ZONE_OVAL:GetBoundingSquare()
local min_x=self.CenterVec2.x-self.MajorAxis
local min_y=self.CenterVec2.y-self.MinorAxis
local max_x=self.CenterVec2.x+self.MajorAxis
local max_y=self.CenterVec2.y+self.MinorAxis
return{
{x=min_x,y=min_x},{x=max_x,y=min_y},{x=max_x,y=max_y},{x=min_x,y=max_y}
}
end
function ZONE_OVAL:PointsOnEdge(num_points)
num_points=num_points or 40
local points={}
local dtheta=2*math.pi/num_points
for i=0,num_points-1 do
local theta=i*dtheta
local x=self.CenterVec2.x+self.MajorAxis*math.cos(theta)*math.cos(self.Angle)-self.MinorAxis*math.sin(theta)*math.sin(self.Angle)
local y=self.CenterVec2.y+self.MajorAxis*math.cos(theta)*math.sin(self.Angle)+self.MinorAxis*math.sin(theta)*math.cos(self.Angle)
table.insert(points,{x=x,y=y})
end
return points
end
function ZONE_OVAL:GetRandomVec2()
local theta=math.rad(self.Angle)
local random_point=math.sqrt(math.random())
local phi=math.random()*2*math.pi
local x_c=random_point*math.cos(phi)
local y_c=random_point*math.sin(phi)
local x_e=x_c*self.MajorAxis
local y_e=y_c*self.MinorAxis
local rx=(x_e*math.cos(theta)-y_e*math.sin(theta))+self.CenterVec2.x
local ry=(x_e*math.sin(theta)+y_e*math.cos(theta))+self.CenterVec2.y
return{x=rx,y=ry}
end
function ZONE_OVAL:GetRandomPointVec2()
return COORDINATE:NewFromVec2(self:GetRandomVec2())
end
function ZONE_OVAL:GetRandomPointVec3()
return COORDINATE:NewFromVec3(self:GetRandomVec2())
end
function ZONE_OVAL:DrawZone(Coalition,Color,Alpha,FillColor,FillAlpha,LineType)
Coalition=Coalition or self:GetDrawCoalition()
self:SetDrawCoalition(Coalition)
Color=Color or self:GetColorRGB()
Alpha=Alpha or 1
self:SetColor(Color,Alpha)
FillColor=FillColor or self:GetFillColorRGB()
if not FillColor then
UTILS.DeepCopy(Color)
end
FillAlpha=FillAlpha or self:GetFillColorAlpha()
if not FillAlpha then
FillAlpha=0.15
end
LineType=LineType or 1
self:SetFillColor(FillColor,FillAlpha)
self.DrawPoly=ZONE_POLYGON:NewFromPointsArray(self.ZoneName,self:PointsOnEdge(80))
self.DrawPoly:DrawZone(Coalition,Color,Alpha,FillColor,FillAlpha,LineType)
end
function ZONE_OVAL:UndrawZone()
if self.DrawPoly then
self.DrawPoly:UndrawZone()
end
end
do
ZONE_AIRBASE={
ClassName="ZONE_AIRBASE",
}
function ZONE_AIRBASE:New(AirbaseName,Radius)
Radius=Radius or 4000
local Airbase=AIRBASE:FindByName(AirbaseName)
local self=BASE:Inherit(self,ZONE_RADIUS:New(AirbaseName,Airbase:GetVec2(),Radius,true))
self._.ZoneAirbase=Airbase
self._.ZoneVec2Cache=self._.ZoneAirbase:GetVec2()
if Airbase:IsShip()then
self.isShip=true
self.isHelipad=false
self.isAirdrome=false
elseif Airbase:IsHelipad()then
self.isShip=false
self.isHelipad=true
self.isAirdrome=false
elseif Airbase:IsAirdrome()then
self.isShip=false
self.isHelipad=false
self.isAirdrome=true
end
_EVENTDISPATCHER:CreateEventNewZone(self)
return self
end
function ZONE_AIRBASE:GetAirbase()
return self._.ZoneAirbase
end
function ZONE_AIRBASE:GetVec2()
local ZoneVec2=nil
if self._.ZoneAirbase:IsAlive()then
ZoneVec2=self._.ZoneAirbase:GetVec2()
self._.ZoneVec2Cache=ZoneVec2
else
ZoneVec2=self._.ZoneVec2Cache
end
return ZoneVec2
end
function ZONE_AIRBASE:GetRandomPointVec2(inner,outer)
local PointVec2=COORDINATE:NewFromVec2(self:GetRandomVec2())
return PointVec2
end
end
ZONE_DETECTION={
ClassName="ZONE_DETECTION",
}
function ZONE_DETECTION:New(ZoneName,Detection,Radius)
local self=BASE:Inherit(self,ZONE_BASE:New(ZoneName))
self:F({ZoneName,Detection,Radius})
self.Detection=Detection
self.Radius=Radius
return self
end
function ZONE_DETECTION:BoundZone(Points,CountryID,UnBound)
local Point={}
local Vec2=self:GetVec2()
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,(360/Points)do
local Radial=Angle*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
local CountryName=_DATABASE.COUNTRY_NAME[CountryID]
local Tire={
["country"]=CountryName,
["category"]="Fortifications",
["canCargo"]=false,
["shape_name"]="H-tyre_B_WF",
["type"]="Black_Tyre_WF",
["y"]=Point.y,
["x"]=Point.x,
["name"]=string.format("%s-Tire #%0d",self:GetName(),Angle),
["heading"]=0,
}
local Group=coalition.addStaticObject(CountryID,Tire)
if UnBound and UnBound==true then
Group:destroy()
end
end
return self
end
function ZONE_DETECTION:SmokeZone(SmokeColor,Points,AddHeight,AngleOffset)
self:F2(SmokeColor)
local Point={}
local Vec2=self:GetVec2()
AddHeight=AddHeight or 0
AngleOffset=AngleOffset or 0
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,360/Points do
local Radial=(Angle+AngleOffset)*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
COORDINATE:New(Point.x,AddHeight,Point.y):Smoke(SmokeColor)
end
return self
end
function ZONE_DETECTION:FlareZone(FlareColor,Points,Azimuth,AddHeight)
self:F2({FlareColor,Azimuth})
local Point={}
local Vec2=self:GetVec2()
AddHeight=AddHeight or 0
Points=Points and Points or 360
local Angle
local RadialBase=math.pi*2
for Angle=0,360,360/Points do
local Radial=Angle*RadialBase/360
Point.x=Vec2.x+math.cos(Radial)*self:GetRadius()
Point.y=Vec2.y+math.sin(Radial)*self:GetRadius()
COORDINATE:New(Point.x,AddHeight,Point.y):Flare(FlareColor,Azimuth)
end
return self
end
function ZONE_DETECTION:GetRadius()
self:F2(self.ZoneName)
self:T2({self.Radius})
return self.Radius
end
function ZONE_DETECTION:SetRadius(Radius)
self:F2(self.ZoneName)
self.Radius=Radius
self:T2({self.Radius})
return self.Radius
end
function ZONE_DETECTION:IsVec2InZone(Vec2)
self:F2(Vec2)
local Coordinates=self.Detection:GetDetectedItemCoordinates()
for CoordinateID,Coordinate in pairs(Coordinates)do
local ZoneVec2=Coordinate:GetVec2()
if ZoneVec2 then
if((Vec2.x-ZoneVec2.x)^2+(Vec2.y-ZoneVec2.y)^2)^0.5<=self:GetRadius()then
return true
end
end
end
return false
end
function ZONE_DETECTION:IsVec3InZone(Vec3)
self:F2(Vec3)
local InZone=self:IsVec2InZone({x=Vec3.x,y=Vec3.z})
return InZone
end
DATABASE={
ClassName="DATABASE",
Templates={
Units={},
Groups={},
Statics={},
ClientsByName={},
ClientsByID={},
},
UNITS={},
UNITS_Index={},
STATICS={},
GROUPS={},
PLAYERS={},
PLAYERSJOINED={},
PLAYERUNITS={},
CLIENTS={},
CARGOS={},
AIRBASES={},
COUNTRY_ID={},
COUNTRY_NAME={},
NavPoints={},
PLAYERSETTINGS={},
ZONENAMES={},
HITS={},
DESTROYS={},
ZONES={},
ZONES_GOAL={},
WAREHOUSES={},
FLIGHTGROUPS={},
FLIGHTCONTROLS={},
OPSZONES={},
PATHLINES={},
STORAGES={},
STNS={},
SADL={},
DYNAMICCARGO={},
}
local _DATABASECoalition=
{
[1]="Red",
[2]="Blue",
[3]="Neutral",
}
local _DATABASECategory=
{
["plane"]=Unit.Category.AIRPLANE,
["helicopter"]=Unit.Category.HELICOPTER,
["vehicle"]=Unit.Category.GROUND_UNIT,
["ship"]=Unit.Category.SHIP,
["static"]=Unit.Category.STRUCTURE,
}
function DATABASE:New()
local self=BASE:Inherit(self,BASE:New())
self:SetEventPriority(1)
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.PlayerEnterUnit,self._EventOnPlayerEnterUnit)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.RemoveUnit,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Hit,self.AccountHits)
self:HandleEvent(EVENTS.NewCargo)
self:HandleEvent(EVENTS.DeleteCargo)
self:HandleEvent(EVENTS.NewZone)
self:HandleEvent(EVENTS.DeleteZone)
self:HandleEvent(EVENTS.PlayerLeaveUnit,self._EventOnPlayerLeaveUnit)
self:HandleEvent(EVENTS.DynamicCargoRemoved,self._EventOnDynamicCargoRemoved)
self:_RegisterTemplates()
self:_RegisterGroupsAndUnits()
self:_RegisterClients()
self:_RegisterStatics()
self.UNITS_Position=0
return self
end
function DATABASE:FindUnit(UnitName)
local UnitFound=self.UNITS[UnitName]
return UnitFound
end
function DATABASE:AddUnit(DCSUnitName,force)
local DCSunitName=DCSUnitName
if type(DCSunitName)=="number"then DCSunitName=string.format("%d",DCSUnitName)end
if not self.UNITS[DCSunitName]or force==true then
self:T({"Add UNIT:",DCSunitName})
self.UNITS[DCSunitName]=UNIT:Register(DCSunitName)
end
return self.UNITS[DCSunitName]
end
function DATABASE:DeleteUnit(DCSUnitName)
self:T("DeleteUnit "..tostring(DCSUnitName))
self.UNITS[DCSUnitName]=nil
end
function DATABASE:AddStatic(DCSStaticName)
if not self.STATICS[DCSStaticName]then
self.STATICS[DCSStaticName]=STATIC:Register(DCSStaticName)
end
return self.STATICS[DCSStaticName]
end
function DATABASE:DeleteStatic(DCSStaticName)
self.STATICS[DCSStaticName]=nil
end
function DATABASE:FindStatic(StaticName)
local StaticFound=self.STATICS[StaticName]
return StaticFound
end
function DATABASE:AddDynamicCargo(Name)
if not self.DYNAMICCARGO[Name]then
self.DYNAMICCARGO[Name]=DYNAMICCARGO:Register(Name)
end
return self.DYNAMICCARGO[Name]
end
function DATABASE:FindDynamicCargo(DynamicCargoName)
local StaticFound=self.DYNAMICCARGO[DynamicCargoName]
return StaticFound
end
function DATABASE:DeleteDynamicCargo(DynamicCargoName)
self.DYNAMICCARGO[DynamicCargoName]=nil
return self
end
function DATABASE:AddAirbase(AirbaseName)
if not self.AIRBASES[AirbaseName]then
self.AIRBASES[AirbaseName]=AIRBASE:Register(AirbaseName)
end
return self.AIRBASES[AirbaseName]
end
function DATABASE:DeleteAirbase(AirbaseName)
self.AIRBASES[AirbaseName]=nil
end
function DATABASE:FindAirbase(AirbaseName)
local AirbaseFound=self.AIRBASES[AirbaseName]
return AirbaseFound
end
function DATABASE:AddStorage(AirbaseName)
if not self.STORAGES[AirbaseName]then
self.STORAGES[AirbaseName]=STORAGE:New(AirbaseName)
end
return self.STORAGES[AirbaseName]
end
function DATABASE:DeleteStorage(AirbaseName)
self.STORAGES[AirbaseName]=nil
end
function DATABASE:FindStorage(AirbaseName)
local storage=self.STORAGES[AirbaseName]
return storage
end
do
function DATABASE:FindZone(ZoneName)
local ZoneFound=self.ZONES[ZoneName]
return ZoneFound
end
function DATABASE:AddZone(ZoneName,Zone)
if not self.ZONES[ZoneName]then
self.ZONES[ZoneName]=Zone
end
end
function DATABASE:DeleteZone(ZoneName)
self.ZONES[ZoneName]=nil
end
function DATABASE:AddPathline(PathlineName,Pathline)
if not self.PATHLINES[PathlineName]then
self.PATHLINES[PathlineName]=Pathline
end
end
function DATABASE:FindPathline(PathlineName)
local pathline=self.PATHLINES[PathlineName]
return pathline
end
function DATABASE:DeletePathline(PathlineName)
self.PATHLINES[PathlineName]=nil
return self
end
function DATABASE:_RegisterZones()
for ZoneID,ZoneData in pairs(env.mission.triggers.zones)do
local ZoneName=ZoneData.name
local color=ZoneData.color or{1,0,0,0.15}
local Zone=nil
if ZoneData.type==0 then
self:I(string.format("Register ZONE: %s (Circular)",ZoneName))
Zone=ZONE:New(ZoneName)
else
self:I(string.format("Register ZONE: %s (Polygon, Quad)",ZoneName))
Zone=ZONE_POLYGON:NewFromPointsArray(ZoneName,ZoneData.verticies)
end
if Zone then
Zone.Color=color
Zone.ZoneID=ZoneData.zoneId
local ZoneProperties=ZoneData.properties or nil
Zone.Properties={}
if ZoneName and ZoneProperties then
for _,ZoneProp in ipairs(ZoneProperties)do
if ZoneProp.key then
Zone.Properties[ZoneProp.key]=ZoneProp.value
end
end
end
self.ZONENAMES[ZoneName]=ZoneName
self:AddZone(ZoneName,Zone)
end
end
for ZoneGroupName,ZoneGroup in pairs(self.GROUPS)do
if ZoneGroupName:match("#ZONE_POLYGON")then
local ZoneName1=ZoneGroupName:match("(.*)#ZONE_POLYGON")
local ZoneName2=ZoneGroupName:match(".*#ZONE_POLYGON(.*)")
local ZoneName=ZoneName1..(ZoneName2 or"")
self:I(string.format("Register ZONE: %s (Polygon)",ZoneName))
local Zone_Polygon=ZONE_POLYGON:New(ZoneName,ZoneGroup)
Zone_Polygon:SetColor({1,0,0},0.15)
self.ZONENAMES[ZoneName]=ZoneName
self:AddZone(ZoneName,Zone_Polygon)
end
end
if env.mission.drawings and env.mission.drawings.layers then
for layerID,layerData in pairs(env.mission.drawings.layers or{})do
for objectID,objectData in pairs(layerData.objects or{})do
if objectData.polygonMode and(objectData.polygonMode=="free")and objectData.points and#objectData.points>=4 then
local ZoneName=objectData.name or"Unknown free Polygon Drawing"
local vec2={x=objectData.mapX,y=objectData.mapY}
local points=UTILS.DeepCopy(objectData.points)
for i,_point in pairs(points)do
local point=_point
points[i]=UTILS.Vec2Add(point,vec2)
end
table.remove(points,#points)
self:I(string.format("Register ZONE: %s (Polygon (free) drawing with %d vertices)",ZoneName,#points))
local Zone=ZONE_POLYGON:NewFromPointsArray(ZoneName,points)
Zone:SetColor({1,0,0},0.15)
Zone:SetFillColor({1,0,0},0.15)
if objectData.colorString then
local color=string.gsub(objectData.colorString,"^0x","")
local r=tonumber(string.sub(color,1,2),16)/255
local g=tonumber(string.sub(color,3,4),16)/255
local b=tonumber(string.sub(color,5,6),16)/255
local a=tonumber(string.sub(color,7,8),16)/255
Zone:SetColor({r,g,b},a)
end
if objectData.fillColorString then
local color=string.gsub(objectData.colorString,"^0x","")
local r=tonumber(string.sub(color,1,2),16)/255
local g=tonumber(string.sub(color,3,4),16)/255
local b=tonumber(string.sub(color,5,6),16)/255
local a=tonumber(string.sub(color,7,8),16)/255
Zone:SetFillColor({r,g,b},a)
end
self.ZONENAMES[ZoneName]=ZoneName
self:AddZone(ZoneName,Zone)
elseif objectData.polygonMode and objectData.polygonMode=="rect"then
local ZoneName=objectData.name or"Unknown rect Polygon Drawing"
local vec2={x=objectData.mapX,y=objectData.mapY}
local w=objectData.width
local h=objectData.height
local points={}
points[1]={x=vec2.x-h/2,y=vec2.y+w/2}
points[2]={x=vec2.x+h/2,y=vec2.y+w/2}
points[3]={x=vec2.x+h/2,y=vec2.y-w/2}
points[4]={x=vec2.x-h/2,y=vec2.y-w/2}
self:I(string.format("Register ZONE: %s (Polygon (rect) drawing with %d vertices)",ZoneName,#points))
local Zone=ZONE_POLYGON:NewFromPointsArray(ZoneName,points)
Zone:SetColor({1,0,0},0.15)
if objectData.colorString then
local color=string.gsub(objectData.colorString,"^0x","")
local r=tonumber(string.sub(color,1,2),16)/255
local g=tonumber(string.sub(color,3,4),16)/255
local b=tonumber(string.sub(color,5,6),16)/255
local a=tonumber(string.sub(color,7,8),16)/255
Zone:SetColor({r,g,b},a)
end
if objectData.fillColorString then
local color=string.gsub(objectData.colorString,"^0x","")
local r=tonumber(string.sub(color,1,2),16)/255
local g=tonumber(string.sub(color,3,4),16)/255
local b=tonumber(string.sub(color,5,6),16)/255
local a=tonumber(string.sub(color,7,8),16)/255
Zone:SetFillColor({r,g,b},a)
end
self.ZONENAMES[ZoneName]=ZoneName
self:AddZone(ZoneName,Zone)
elseif objectData.lineMode and(objectData.lineMode=="segments"or objectData.lineMode=="segment"or objectData.lineMode=="free")and objectData.points and#objectData.points>=2 then
local Name=objectData.name or"Unknown Line Drawing"
local vec2={x=objectData.mapX,y=objectData.mapY}
local points=UTILS.DeepCopy(objectData.points)
for i,_point in pairs(points)do
local point=_point
points[i]=UTILS.Vec2Add(point,vec2)
end
self:I(string.format("Register PATHLINE: %s (Line drawing with %d points)",Name,#points))
local Pathline=PATHLINE:NewFromVec2Array(Name,points)
self:AddPathline(Name,Pathline)
end
end
end
end
end
end
do
function DATABASE:FindZoneGoal(ZoneName)
local ZoneFound=self.ZONES_GOAL[ZoneName]
return ZoneFound
end
function DATABASE:AddZoneGoal(ZoneName,Zone)
if not self.ZONES_GOAL[ZoneName]then
self.ZONES_GOAL[ZoneName]=Zone
end
end
function DATABASE:DeleteZoneGoal(ZoneName)
self.ZONES_GOAL[ZoneName]=nil
end
end
do
function DATABASE:FindOpsZone(ZoneName)
local ZoneFound=self.OPSZONES[ZoneName]
return ZoneFound
end
function DATABASE:AddOpsZone(OpsZone)
if OpsZone then
local ZoneName=OpsZone:GetName()
if not self.OPSZONES[ZoneName]then
self.OPSZONES[ZoneName]=OpsZone
end
end
end
function DATABASE:DeleteOpsZone(ZoneName)
self.OPSZONES[ZoneName]=nil
end
end
do
function DATABASE:AddCargo(Cargo)
if not self.CARGOS[Cargo.Name]then
self.CARGOS[Cargo.Name]=Cargo
end
end
function DATABASE:DeleteCargo(CargoName)
self.CARGOS[CargoName]=nil
end
function DATABASE:FindCargo(CargoName)
local CargoFound=self.CARGOS[CargoName]
return CargoFound
end
function DATABASE:IsCargo(TemplateName)
TemplateName=env.getValueDictByKey(TemplateName)
local Cargo=TemplateName:match("#(CARGO)")
return Cargo and Cargo=="CARGO"
end
function DATABASE:_RegisterCargos()
local Groups=UTILS.DeepCopy(self.GROUPS)
for CargoGroupName,CargoGroup in pairs(Groups)do
if self:IsCargo(CargoGroupName)then
local CargoInfo=CargoGroupName:match("#CARGO(.*)")
local CargoParam=CargoInfo and CargoInfo:match("%((.*)%)")
local CargoName1=CargoGroupName:match("(.*)#CARGO%(.*%)")
local CargoName2=CargoGroupName:match(".*#CARGO%(.*%)(.*)")
local CargoName=CargoName1..(CargoName2 or"")
local Type=CargoParam and CargoParam:match("T=([%a%d ]+),?")
local Name=CargoParam and CargoParam:match("N=([%a%d]+),?")or CargoName
local LoadRadius=CargoParam and tonumber(CargoParam:match("RR=([%a%d]+),?"))
local NearRadius=CargoParam and tonumber(CargoParam:match("NR=([%a%d]+),?"))
self:I({"Register CargoGroup:",Type=Type,Name=Name,LoadRadius=LoadRadius,NearRadius=NearRadius})
CARGO_GROUP:New(CargoGroup,Type,Name,LoadRadius,NearRadius)
end
end
for CargoStaticName,CargoStatic in pairs(self.STATICS)do
if self:IsCargo(CargoStaticName)then
local CargoInfo=CargoStaticName:match("#CARGO(.*)")
local CargoParam=CargoInfo and CargoInfo:match("%((.*)%)")
local CargoName=CargoStaticName:match("(.*)#CARGO")
local Type=CargoParam and CargoParam:match("T=([%a%d ]+),?")
local Category=CargoParam and CargoParam:match("C=([%a%d ]+),?")
local Name=CargoParam and CargoParam:match("N=([%a%d]+),?")or CargoName
local LoadRadius=CargoParam and tonumber(CargoParam:match("RR=([%a%d]+),?"))
local NearRadius=CargoParam and tonumber(CargoParam:match("NR=([%a%d]+),?"))
if Category=="SLING"then
self:I({"Register CargoSlingload:",Type=Type,Name=Name,LoadRadius=LoadRadius,NearRadius=NearRadius})
CARGO_SLINGLOAD:New(CargoStatic,Type,Name,LoadRadius,NearRadius)
else
if Category=="CRATE"then
self:I({"Register CargoCrate:",Type=Type,Name=Name,LoadRadius=LoadRadius,NearRadius=NearRadius})
CARGO_CRATE:New(CargoStatic,Type,Name,LoadRadius,NearRadius)
end
end
end
end
end
end
function DATABASE:FindClient(ClientName)
local ClientFound=self.CLIENTS[ClientName]
return ClientFound
end
function DATABASE:AddClient(ClientName,Force)
local DCSUnitName=ClientName
if type(DCSUnitName)=="number"then DCSUnitName=string.format("%d",ClientName)end
if not self.CLIENTS[DCSUnitName]or Force==true then
self.CLIENTS[DCSUnitName]=CLIENT:Register(DCSUnitName)
end
return self.CLIENTS[DCSUnitName]
end
function DATABASE:FindGroup(GroupName)
local GroupFound=self.GROUPS[GroupName]
if GroupFound==nil and GroupName~=nil and self.Templates.Groups[GroupName]==nil then
self:_RegisterDynamicGroup(GroupName)
return self.GROUPS[GroupName]
end
return GroupFound
end
function DATABASE:AddGroup(GroupName,force)
if not self.GROUPS[GroupName]or force==true then
self:T({"Add GROUP:",GroupName})
self.GROUPS[GroupName]=GROUP:Register(GroupName)
end
return self.GROUPS[GroupName]
end
function DATABASE:AddPlayer(UnitName,PlayerName)
if type(UnitName)=="number"then UnitName=string.format("%d",UnitName)end
if PlayerName then
self:I({"Add player for unit:",UnitName,PlayerName})
self.PLAYERS[PlayerName]=UnitName
self.PLAYERUNITS[PlayerName]=self:FindUnit(UnitName)
self.PLAYERSJOINED[PlayerName]=PlayerName
end
end
function DATABASE:_FindPlayerNameByUnitName(UnitName)
if UnitName then
for playername,unitname in pairs(self.PLAYERS)do
if unitname==UnitName and self.PLAYERUNITS[playername]and self.PLAYERUNITS[playername]:IsAlive()then
return playername,self.PLAYERUNITS[playername]
end
end
end
return nil
end
function DATABASE:DeletePlayer(UnitName,PlayerName)
if PlayerName then
self:T({"Clean player:",PlayerName})
self.PLAYERS[PlayerName]=nil
self.PLAYERUNITS[PlayerName]=nil
end
end
function DATABASE:GetPlayers()
return self.PLAYERS
end
function DATABASE:GetPlayerUnits()
return self.PLAYERUNITS
end
function DATABASE:GetPlayersJoined()
return self.PLAYERSJOINED
end
function DATABASE:Spawn(SpawnTemplate)
self:F(SpawnTemplate.name)
self:T({SpawnTemplate.SpawnCountryID,SpawnTemplate.SpawnCategoryID})
local SpawnCoalitionID=SpawnTemplate.CoalitionID
local SpawnCountryID=SpawnTemplate.CountryID
local SpawnCategoryID=SpawnTemplate.CategoryID
SpawnTemplate.CoalitionID=nil
SpawnTemplate.CountryID=nil
SpawnTemplate.CategoryID=nil
self:_RegisterGroupTemplate(SpawnTemplate,SpawnCoalitionID,SpawnCategoryID,SpawnCountryID,SpawnTemplate.name)
self:T3(SpawnTemplate)
coalition.addGroup(SpawnCountryID,SpawnCategoryID,SpawnTemplate)
SpawnTemplate.CoalitionID=SpawnCoalitionID
SpawnTemplate.CountryID=SpawnCountryID
SpawnTemplate.CategoryID=SpawnCategoryID
local SpawnGroup=self:AddGroup(SpawnTemplate.name)
for UnitID,UnitData in pairs(SpawnTemplate.units)do
self:AddUnit(UnitData.name)
end
return SpawnGroup
end
function DATABASE:SetStatusGroup(GroupName,Status)
self:F2(Status)
self.Templates.Groups[GroupName].Status=Status
end
function DATABASE:GetStatusGroup(GroupName)
self:F2(GroupName)
if self.Templates.Groups[GroupName]then
return self.Templates.Groups[GroupName].Status
else
return""
end
end
function DATABASE:_RegisterGroupTemplate(GroupTemplate,CoalitionSide,CategoryID,CountryID,GroupName)
local GroupTemplateName=GroupName or env.getValueDictByKey(GroupTemplate.name)
if not self.Templates.Groups[GroupTemplateName]then
self.Templates.Groups[GroupTemplateName]={}
self.Templates.Groups[GroupTemplateName].Status=nil
end
if GroupTemplate.route and GroupTemplate.route.spans then
GroupTemplate.route.spans=nil
end
GroupTemplate.CategoryID=CategoryID
GroupTemplate.CoalitionID=CoalitionSide
GroupTemplate.CountryID=CountryID
self.Templates.Groups[GroupTemplateName].GroupName=GroupTemplateName
self.Templates.Groups[GroupTemplateName].Template=GroupTemplate
self.Templates.Groups[GroupTemplateName].groupId=GroupTemplate.groupId
self.Templates.Groups[GroupTemplateName].UnitCount=#GroupTemplate.units
self.Templates.Groups[GroupTemplateName].Units=GroupTemplate.units
self.Templates.Groups[GroupTemplateName].CategoryID=CategoryID
self.Templates.Groups[GroupTemplateName].CoalitionID=CoalitionSide
self.Templates.Groups[GroupTemplateName].CountryID=CountryID
local UnitNames={}
for unit_num,UnitTemplate in pairs(GroupTemplate.units)do
UnitTemplate.name=env.getValueDictByKey(UnitTemplate.name)
self.Templates.Units[UnitTemplate.name]={}
self.Templates.Units[UnitTemplate.name].UnitName=UnitTemplate.name
self.Templates.Units[UnitTemplate.name].Template=UnitTemplate
self.Templates.Units[UnitTemplate.name].GroupName=GroupTemplateName
self.Templates.Units[UnitTemplate.name].GroupTemplate=GroupTemplate
self.Templates.Units[UnitTemplate.name].GroupId=GroupTemplate.groupId
self.Templates.Units[UnitTemplate.name].CategoryID=CategoryID
self.Templates.Units[UnitTemplate.name].CoalitionID=CoalitionSide
self.Templates.Units[UnitTemplate.name].CountryID=CountryID
if UnitTemplate.skill and(UnitTemplate.skill=="Client"or UnitTemplate.skill=="Player")then
self.Templates.ClientsByName[UnitTemplate.name]=UnitTemplate
self.Templates.ClientsByName[UnitTemplate.name].CategoryID=CategoryID
self.Templates.ClientsByName[UnitTemplate.name].CoalitionID=CoalitionSide
self.Templates.ClientsByName[UnitTemplate.name].CountryID=CountryID
self.Templates.ClientsByID[UnitTemplate.unitId]=UnitTemplate
end
if UnitTemplate.AddPropAircraft then
if UnitTemplate.AddPropAircraft.STN_L16 then
local stn=UTILS.OctalToDecimal(UnitTemplate.AddPropAircraft.STN_L16)
if stn==nil or stn<1 then
self:E("WARNING: Invalid STN "..tostring(UnitTemplate.AddPropAircraft.STN_L16).." for "..UnitTemplate.name)
else
self.STNS[stn]=UnitTemplate.name
self:I("Register STN "..tostring(UnitTemplate.AddPropAircraft.STN_L16).." for "..UnitTemplate.name)
end
end
if UnitTemplate.AddPropAircraft.SADL_TN then
local sadl=UTILS.OctalToDecimal(UnitTemplate.AddPropAircraft.SADL_TN)
if sadl==nil or sadl<1 then
self:E("WARNING: Invalid SADL "..tostring(UnitTemplate.AddPropAircraft.SADL_TN).." for "..UnitTemplate.name)
else
self.SADL[sadl]=UnitTemplate.name
self:I("Register SADL "..tostring(UnitTemplate.AddPropAircraft.SADL_TN).." for "..UnitTemplate.name)
end
end
end
UnitNames[#UnitNames+1]=self.Templates.Units[UnitTemplate.name].UnitName
end
self:T({Group=self.Templates.Groups[GroupTemplateName].GroupName,
Coalition=self.Templates.Groups[GroupTemplateName].CoalitionID,
Category=self.Templates.Groups[GroupTemplateName].CategoryID,
Country=self.Templates.Groups[GroupTemplateName].CountryID,
Units=UnitNames
}
)
end
function DATABASE:GetNextSTN(octal,unitname)
local first=UTILS.OctalToDecimal(octal)or 0
if self.STNS[first]==unitname then return octal end
local nextoctal=77777
local found=false
if 32767-first<10 then
first=0
end
for i=first+1,32767 do
if self.STNS[i]==nil then
found=true
nextoctal=UTILS.DecimalToOctal(i)
self.STNS[i]=unitname
self:T("Register STN "..tostring(nextoctal).." for "..unitname)
break
end
end
if not found then
self:E(string.format("WARNING: No next free STN past %05d found!",octal))
local NewSTNS={}
for _id,_name in pairs(self.STNS)do
if self.UNITS[_name]~=nil then
NewSTNS[_id]=_name
end
end
self.STNS=nil
self.STNS=NewSTNS
end
return nextoctal
end
function DATABASE:GetNextSADL(octal,unitname)
local first=UTILS.OctalToDecimal(octal)or 0
if self.SADL[first]==unitname then return octal end
local nextoctal=7777
local found=false
if 4095-first<10 then
first=0
end
for i=first+1,4095 do
if self.STNS[i]==nil then
found=true
nextoctal=UTILS.DecimalToOctal(i)
self.SADL[i]=unitname
self:T("Register SADL "..tostring(nextoctal).." for "..unitname)
break
end
end
if not found then
self:E(string.format("WARNING: No next free SADL past %04d found!",octal))
local NewSTNS={}
for _id,_name in pairs(self.SADL)do
if self.UNITS[_name]~=nil then
NewSTNS[_id]=_name
end
end
self.SADL=nil
self.SADL=NewSTNS
end
return nextoctal
end
function DATABASE:GetGroupTemplate(GroupName)
local GroupTemplate=nil
if self.Templates.Groups[GroupName]then
GroupTemplate=self.Templates.Groups[GroupName].Template
GroupTemplate.SpawnCoalitionID=self.Templates.Groups[GroupName].CoalitionID
GroupTemplate.SpawnCategoryID=self.Templates.Groups[GroupName].CategoryID
GroupTemplate.SpawnCountryID=self.Templates.Groups[GroupName].CountryID
end
return GroupTemplate
end
function DATABASE:_RegisterStaticTemplate(StaticTemplate,CoalitionID,CategoryID,CountryID)
local StaticTemplate=UTILS.DeepCopy(StaticTemplate)
local StaticTemplateGroupName=env.getValueDictByKey(StaticTemplate.name)
local StaticTemplateName=StaticTemplate.units[1].name
self.Templates.Statics[StaticTemplateName]=self.Templates.Statics[StaticTemplateName]or{}
StaticTemplate.CategoryID=CategoryID
StaticTemplate.CoalitionID=CoalitionID
StaticTemplate.CountryID=CountryID
self.Templates.Statics[StaticTemplateName].StaticName=StaticTemplateGroupName
self.Templates.Statics[StaticTemplateName].GroupTemplate=StaticTemplate
self.Templates.Statics[StaticTemplateName].UnitTemplate=StaticTemplate.units[1]
self.Templates.Statics[StaticTemplateName].CategoryID=CategoryID
self.Templates.Statics[StaticTemplateName].CoalitionID=CoalitionID
self.Templates.Statics[StaticTemplateName].CountryID=CountryID
self:T({Static=self.Templates.Statics[StaticTemplateName].StaticName,
Coalition=self.Templates.Statics[StaticTemplateName].CoalitionID,
Category=self.Templates.Statics[StaticTemplateName].CategoryID,
Country=self.Templates.Statics[StaticTemplateName].CountryID
}
)
self:AddStatic(StaticTemplateName)
return self
end
function DATABASE:_GetGenericStaticCargoGroupTemplate(Name,Typename,Mass,Coalition,Country)
local StaticTemplate={}
StaticTemplate.name=Name or"None"
StaticTemplate.units={[1]={
name=Name,
resourcePayload={
["weapons"]={},
["aircrafts"]={},
["gasoline"]=0,
["diesel"]=0,
["methanol_mixture"]=0,
["jet_fuel"]=0,
},
["mass"]=Mass or 0,
["category"]="Cargos",
["canCargo"]=true,
["type"]=Typename or"container_cargo",
["rate"]=100,
["y"]=0,
["x"]=0,
["heading"]=0,
}}
StaticTemplate.CategoryID="static"
StaticTemplate.CoalitionID=Coalition or coalition.side.BLUE
StaticTemplate.CountryID=Country or country.id.GERMANY
return StaticTemplate
end
function DATABASE:GetStaticGroupTemplate(StaticName)
if self.Templates.Statics[StaticName]then
local StaticTemplate=self.Templates.Statics[StaticName].GroupTemplate
return StaticTemplate,self.Templates.Statics[StaticName].CoalitionID,self.Templates.Statics[StaticName].CategoryID,self.Templates.Statics[StaticName].CountryID
else
self:E("ERROR: Static group template does NOT exist for static "..tostring(StaticName))
return nil
end
end
function DATABASE:GetStaticUnitTemplate(StaticName)
if self.Templates.Statics[StaticName]then
local UnitTemplate=self.Templates.Statics[StaticName].UnitTemplate
return UnitTemplate,self.Templates.Statics[StaticName].CoalitionID,self.Templates.Statics[StaticName].CategoryID,self.Templates.Statics[StaticName].CountryID
else
self:E("ERROR: Static unit template does NOT exist for static "..tostring(StaticName))
return nil
end
end
function DATABASE:GetGroupNameFromUnitName(UnitName)
if self.Templates.Units[UnitName]then
return self.Templates.Units[UnitName].GroupName
else
self:E("ERROR: Unit template does not exist for unit "..tostring(UnitName))
return nil
end
end
function DATABASE:GetGroupTemplateFromUnitName(UnitName)
if self.Templates.Units[UnitName]then
return self.Templates.Units[UnitName].GroupTemplate
else
self:E("ERROR: Unit template does not exist for unit "..tostring(UnitName))
return nil
end
end
function DATABASE:GetUnitTemplateFromUnitName(UnitName)
if self.Templates.Units[UnitName]then
return self.Templates.Units[UnitName]
else
self:E("ERROR: Unit template does not exist for unit "..tostring(UnitName))
return nil
end
end
function DATABASE:GetCoalitionFromClientTemplate(ClientName)
if self.Templates.ClientsByName[ClientName]then
return self.Templates.ClientsByName[ClientName].CoalitionID
end
self:E("WARNING: Template does not exist for client "..tostring(ClientName))
return nil
end
function DATABASE:GetCategoryFromClientTemplate(ClientName)
if self.Templates.ClientsByName[ClientName]then
return self.Templates.ClientsByName[ClientName].CategoryID
end
self:E("WARNING: Template does not exist for client "..tostring(ClientName))
return nil
end
function DATABASE:GetCountryFromClientTemplate(ClientName)
if self.Templates.ClientsByName[ClientName]then
return self.Templates.ClientsByName[ClientName].CountryID
end
self:E("WARNING: Template does not exist for client "..tostring(ClientName))
return nil
end
function DATABASE:GetCoalitionFromAirbase(AirbaseName)
return self.AIRBASES[AirbaseName]:GetCoalition()
end
function DATABASE:GetCategoryFromAirbase(AirbaseName)
return self.AIRBASES[AirbaseName]:GetAirbaseCategory()
end
function DATABASE:_RegisterPlayers()
local CoalitionsData={AlivePlayersRed=coalition.getPlayers(coalition.side.RED),AlivePlayersBlue=coalition.getPlayers(coalition.side.BLUE),AlivePlayersNeutral=coalition.getPlayers(coalition.side.NEUTRAL)}
for CoalitionId,CoalitionData in pairs(CoalitionsData)do
for UnitId,UnitData in pairs(CoalitionData)do
self:T3({"UnitData:",UnitData})
if UnitData and UnitData:isExist()then
local UnitName=UnitData:getName()
local PlayerName=UnitData:getPlayerName()
if not self.PLAYERS[PlayerName]then
self:I({"Add player for unit:",UnitName,PlayerName})
self:AddPlayer(UnitName,PlayerName)
end
end
end
end
return self
end
function DATABASE:_RegisterDynamicGroup(Groupname)
local DCSGroup=Group.getByName(Groupname)
if DCSGroup and DCSGroup:isExist()then
local DCSGroupName=DCSGroup:getName()
self:I(string.format("Register Group: %s",tostring(DCSGroupName)))
self:AddGroup(DCSGroupName,true)
for DCSUnitId,DCSUnit in pairs(DCSGroup:getUnits())do
local DCSUnitName=DCSUnit:getName()
self:I(string.format("Register Unit: %s",tostring(DCSUnitName)))
self:AddUnit(tostring(DCSUnitName),true)
end
else
self:E({"Group does not exist: ",DCSGroup})
end
return self
end
function DATABASE:_RegisterGroupsAndUnits()
local CoalitionsData={GroupsRed=coalition.getGroups(coalition.side.RED),GroupsBlue=coalition.getGroups(coalition.side.BLUE),GroupsNeutral=coalition.getGroups(coalition.side.NEUTRAL)}
for CoalitionId,CoalitionData in pairs(CoalitionsData)do
for DCSGroupId,DCSGroup in pairs(CoalitionData)do
if DCSGroup:isExist()then
local DCSGroupName=DCSGroup:getName()
self:I(string.format("Register Group: %s",tostring(DCSGroupName)))
self:AddGroup(DCSGroupName)
for DCSUnitId,DCSUnit in pairs(DCSGroup:getUnits())do
local DCSUnitName=DCSUnit:getName()
self:I(string.format("Register Unit: %s",tostring(DCSUnitName)))
self:AddUnit(DCSUnitName)
end
else
self:E({"Group does not exist: ",DCSGroup})
end
end
end
return self
end
function DATABASE:_RegisterClients()
for ClientName,ClientTemplate in pairs(self.Templates.ClientsByName)do
self:I(string.format("Register Client: %s",tostring(ClientName)))
local client=self:AddClient(ClientName)
client.SpawnCoord=COORDINATE:New(ClientTemplate.x,ClientTemplate.alt,ClientTemplate.y)
end
return self
end
function DATABASE:_RegisterStatics()
local CoalitionsData={GroupsRed=coalition.getStaticObjects(coalition.side.RED),GroupsBlue=coalition.getStaticObjects(coalition.side.BLUE),GroupsNeutral=coalition.getStaticObjects(coalition.side.NEUTRAL)}
for CoalitionId,CoalitionData in pairs(CoalitionsData)do
for DCSStaticId,DCSStatic in pairs(CoalitionData)do
if DCSStatic:isExist()then
local DCSStaticName=DCSStatic:getName()
self:I(string.format("Register Static: %s",tostring(DCSStaticName)))
self:AddStatic(DCSStaticName)
else
self:E({"Static does not exist: ",DCSStatic})
end
end
end
return self
end
function DATABASE:_RegisterAirbases()
for DCSAirbaseId,DCSAirbase in pairs(world.getAirbases())do
self:_RegisterAirbase(DCSAirbase)
end
return self
end
function DATABASE:_RegisterAirbase(airbase)
local IsSyria=UTILS.GetDCSMap()=="Syria"and true or false
local countHSyria=0
if airbase then
local DCSAirbaseName=airbase:getName()
if IsSyria and DCSAirbaseName=="H"and countHSyria>0 then
return self
elseif IsSyria and DCSAirbaseName=="H"and countHSyria==0 then
countHSyria=countHSyria+1
end
local airbaseID=airbase:getID()
local airbase=self:AddAirbase(DCSAirbaseName)
local airbaseUID=airbase:GetID(true)
local typename=airbase:GetTypeName()
local category=airbase.category
if category==Airbase.Category.SHIP and typename=="FARP_SINGLE_01"then
category=Airbase.Category.HELIPAD
end
local text=string.format("Register %s: %s (UID=%d), Runways=%d, Parking=%d [",AIRBASE.CategoryName[category],tostring(DCSAirbaseName),airbaseUID,#airbase.runways,airbase.NparkingTotal)
for _,terminalType in pairs(AIRBASE.TerminalType)do
if airbase.NparkingTerminal and airbase.NparkingTerminal[terminalType]then
text=text..string.format("%d=%d ",terminalType,airbase.NparkingTerminal[terminalType])
end
end
text=text.."]"
self:I(text)
end
return self
end
function DATABASE:_EventOnBirth(Event)
self:T({Event})
if Event.IniDCSUnit then
if Event.IniObjectCategory==Object.Category.STATIC then
self:AddStatic(Event.IniDCSUnitName)
elseif Event.IniObjectCategory==Object.Category.CARGO and string.match(Event.IniUnitName,".+|%d%d:%d%d|PKG%d+")then
local cargo=self:AddDynamicCargo(Event.IniDCSUnitName)
self:I(string.format("Adding dynamic cargo %s",tostring(Event.IniDCSUnitName)))
self:CreateEventNewDynamicCargo(cargo)
else
if Event.IniObjectCategory==Object.Category.UNIT then
self:AddUnit(Event.IniDCSUnitName)
self:AddGroup(Event.IniDCSGroupName)
local DCSAirbase=Airbase.getByName(Event.IniDCSUnitName)
if DCSAirbase then
self:I(string.format("Adding airbase %s",tostring(Event.IniDCSUnitName)))
self:AddAirbase(Event.IniDCSUnitName)
end
end
end
if Event.IniObjectCategory==Object.Category.UNIT then
Event.IniGroup=self:FindGroup(Event.IniDCSGroupName)
Event.IniUnit=self:FindUnit(Event.IniDCSUnitName)
local client=self.CLIENTS[Event.IniDCSUnitName]
if client then
end
local PlayerName=Event.IniUnit:GetPlayerName()
if PlayerName then
self:I(string.format("Player '%s' joined unit '%s' of group '%s'",tostring(PlayerName),tostring(Event.IniDCSUnitName),tostring(Event.IniDCSGroupName)))
if client==nil or(client and client:CountPlayers()==0)then
client=self:AddClient(Event.IniDCSUnitName,true)
end
client:AddPlayer(PlayerName)
if not self.PLAYERS[PlayerName]then
self:AddPlayer(Event.IniUnitName,PlayerName)
end
local function SetPlayerSettings(self,PlayerName,IniUnit)
local Settings=SETTINGS:Set(PlayerName)
Settings:SetPlayerMenu(IniUnit)
self:CreateEventPlayerEnterAircraft(IniUnit)
end
self:ScheduleOnce(1,SetPlayerSettings,self,PlayerName,Event.IniUnit)
end
end
end
end
function DATABASE:_EventOnDeadOrCrash(Event)
if Event.IniDCSUnit then
local name=Event.IniDCSUnitName
if Event.IniObjectCategory==3 then
if self.STATICS[Event.IniDCSUnitName]then
self:DeleteStatic(Event.IniDCSUnitName)
end
if self.UNITS[Event.IniDCSUnitName]then
self:T("STATIC Event for UNIT "..tostring(Event.IniDCSUnitName))
local DCSUnit=_DATABASE:FindUnit(Event.IniDCSUnitName)
self:T({DCSUnit})
if DCSUnit then
return
end
end
else
if Event.IniObjectCategory==1 then
if self.UNITS[Event.IniDCSUnitName]then
self:ScheduleOnce(1,self.DeleteUnit,self,Event.IniDCSUnitName)
end
local client=self.CLIENTS[name]
if client then
client:RemovePlayers()
end
end
end
local airbase=self.AIRBASES[Event.IniDCSUnitName]
if airbase and(airbase:IsHelipad()or airbase:IsShip())then
self:DeleteAirbase(Event.IniDCSUnitName)
end
end
self:AccountDestroys(Event)
end
function DATABASE:_EventOnPlayerEnterUnit(Event)
self:F2({Event})
if Event.IniDCSUnit then
if Event.IniObjectCategory==1 and Event.IniGroup and Event.IniGroup:IsGround()then
local IsPlayer=Event.IniDCSUnit:getPlayerName()
if IsPlayer then
self:I(string.format("Player '%s' joined GROUND unit '%s' of group '%s'",tostring(Event.IniPlayerName),tostring(Event.IniDCSUnitName),tostring(Event.IniDCSGroupName)))
local client=self.CLIENTS[Event.IniDCSUnitName]
if not client then
client=self:AddClient(Event.IniDCSUnitName)
end
client:AddPlayer(Event.IniPlayerName)
if not self.PLAYERS[Event.IniPlayerName]then
self:AddPlayer(Event.IniUnitName,Event.IniPlayerName)
end
local Settings=SETTINGS:Set(Event.IniPlayerName)
Settings:SetPlayerMenu(Event.IniUnit)
end
end
end
end
function DATABASE:_EventOnDynamicCargoRemoved(Event)
self:T({Event})
if Event.IniDynamicCargoName then
self:DeleteDynamicCargo(Event.IniDynamicCargoName)
end
end
function DATABASE:_EventOnPlayerLeaveUnit(Event)
self:F2({Event})
local function FindPlayerName(UnitName)
local playername=nil
for _name,_unitname in pairs(self.PLAYERS)do
if _unitname==UnitName then
playername=_name
break
end
end
return playername
end
if Event.IniUnit then
if Event.IniObjectCategory==1 then
local PlayerName=Event.IniPlayerName or Event.IniUnit:GetPlayerName()or FindPlayerName(Event.IniUnitName)
if PlayerName then
self:I(string.format("Player '%s' left unit %s",tostring(PlayerName),tostring(Event.IniUnitName)))
local Settings=SETTINGS:Set(PlayerName)
Settings:RemovePlayerMenu(Event.IniUnit)
self:DeletePlayer(Event.IniUnit,PlayerName)
local client=self.CLIENTS[Event.IniDCSUnitName]
if client then
client:RemovePlayer(PlayerName)
end
end
end
end
end
function DATABASE:ForEach(IteratorFunction,FinalizeFunction,arg,Set)
self:F2(arg)
local function CoRoutine()
local Count=0
for ObjectID,Object in pairs(Set)do
self:T2(Object)
IteratorFunction(Object,unpack(arg))
Count=Count+1
end
return true
end
local co=CoRoutine
local function Schedule()
local status,res=co()
self:T3({status,res})
if status==false then
error(res)
end
if res==false then
return true
end
if FinalizeFunction then
FinalizeFunction(unpack(arg))
end
return false
end
Schedule()
return self
end
function DATABASE:ForEachStatic(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.STATICS)
return self
end
function DATABASE:ForEachUnit(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.UNITS)
return self
end
function DATABASE:ForEachGroup(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.GROUPS)
return self
end
function DATABASE:ForEachPlayer(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.PLAYERS)
return self
end
function DATABASE:ForEachPlayerJoined(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.PLAYERSJOINED)
return self
end
function DATABASE:ForEachPlayerUnit(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.PLAYERUNITS)
return self
end
function DATABASE:ForEachClient(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.CLIENTS)
return self
end
function DATABASE:ForEachCargo(IteratorFunction,FinalizeFunction,...)
self:F2(arg)
self:ForEach(IteratorFunction,FinalizeFunction,arg,self.CARGOS)
return self
end
function DATABASE:OnEventNewCargo(EventData)
self:F2({EventData})
if EventData.Cargo then
self:AddCargo(EventData.Cargo)
end
end
function DATABASE:OnEventDeleteCargo(EventData)
self:F2({EventData})
if EventData.Cargo then
self:DeleteCargo(EventData.Cargo.Name)
end
end
function DATABASE:OnEventNewZone(EventData)
self:F2({EventData})
if EventData.Zone then
self:AddZone(EventData.Zone.ZoneName,EventData.Zone)
end
end
function DATABASE:OnEventDeleteZone(EventData)
self:F2({EventData})
if EventData.Zone then
self:DeleteZone(EventData.Zone.ZoneName)
end
end
function DATABASE:GetPlayerSettings(PlayerName)
self:F2({PlayerName})
return self.PLAYERSETTINGS[PlayerName]
end
function DATABASE:SetPlayerSettings(PlayerName,Settings)
self:F2({PlayerName,Settings})
self.PLAYERSETTINGS[PlayerName]=Settings
end
function DATABASE:AddOpsGroup(opsgroup)
self.FLIGHTGROUPS[opsgroup.groupname]=opsgroup
end
function DATABASE:GetOpsGroup(groupname)
if type(groupname)=="string"then
else
groupname=groupname:GetName()
end
return self.FLIGHTGROUPS[groupname]
end
function DATABASE:FindOpsGroup(groupname)
if type(groupname)=="string"then
else
groupname=groupname:GetName()
end
return self.FLIGHTGROUPS[groupname]
end
function DATABASE:FindOpsGroupFromUnit(unitname)
local unit=nil
local groupname
if type(unitname)=="string"then
unit=UNIT:FindByName(unitname)
else
unit=unitname
end
if unit then
groupname=unit:GetGroup():GetName()
end
if groupname then
return self.FLIGHTGROUPS[groupname]
else
return nil
end
end
function DATABASE:AddFlightControl(flightcontrol)
self:F2({flightcontrol})
self.FLIGHTCONTROLS[flightcontrol.airbasename]=flightcontrol
end
function DATABASE:GetFlightControl(airbasename)
return self.FLIGHTCONTROLS[airbasename]
end
function DATABASE:_RegisterTemplates()
self:F2()
self.Navpoints={}
self.UNITS={}
for CoalitionName,coa_data in pairs(env.mission.coalition)do
self:T({CoalitionName=CoalitionName})
if(CoalitionName=='red'or CoalitionName=='blue'or CoalitionName=='neutrals')and type(coa_data)=='table'then
local CoalitionSide=coalition.side[string.upper(CoalitionName)]
if CoalitionName=="red"then
CoalitionSide=coalition.side.RED
elseif CoalitionName=="blue"then
CoalitionSide=coalition.side.BLUE
else
CoalitionSide=coalition.side.NEUTRAL
end
self.Navpoints[CoalitionName]={}
if coa_data.nav_points then
for nav_ind,nav_data in pairs(coa_data.nav_points)do
if type(nav_data)=='table'then
self.Navpoints[CoalitionName][nav_ind]=UTILS.DeepCopy(nav_data)
self.Navpoints[CoalitionName][nav_ind]['name']=nav_data.callsignStr
self.Navpoints[CoalitionName][nav_ind]['point']={}
self.Navpoints[CoalitionName][nav_ind]['point']['x']=nav_data.x
self.Navpoints[CoalitionName][nav_ind]['point']['y']=0
self.Navpoints[CoalitionName][nav_ind]['point']['z']=nav_data.y
end
end
end
if coa_data.country then
for cntry_id,cntry_data in pairs(coa_data.country)do
local CountryName=string.upper(cntry_data.name)
local CountryID=cntry_data.id
self.COUNTRY_ID[CountryName]=CountryID
self.COUNTRY_NAME[CountryID]=CountryName
if type(cntry_data)=='table'then
for obj_type_name,obj_type_data in pairs(cntry_data)do
if obj_type_name=="helicopter"or obj_type_name=="ship"or obj_type_name=="plane"or obj_type_name=="vehicle"or obj_type_name=="static"then
local CategoryName=obj_type_name
if((type(obj_type_data)=='table')and obj_type_data.group and(type(obj_type_data.group)=='table')and(#obj_type_data.group>0))then
for group_num,Template in pairs(obj_type_data.group)do
if obj_type_name~="static"and Template and Template.units and type(Template.units)=='table'then
self:_RegisterGroupTemplate(Template,CoalitionSide,_DATABASECategory[string.lower(CategoryName)],CountryID)
else
self:_RegisterStaticTemplate(Template,CoalitionSide,_DATABASECategory[string.lower(CategoryName)],CountryID)
end
end
end
end
end
end
end
end
end
end
return self
end
function DATABASE:AccountHits(Event)
self:F({Event})
if Event.IniPlayerName~=nil then
self:T("Hitting Something")
if Event.TgtCategory then
self.HITS[Event.TgtUnitName]=self.HITS[Event.TgtUnitName]or{}
local Hit=self.HITS[Event.TgtUnitName]
Hit.Players=Hit.Players or{}
Hit.Players[Event.IniPlayerName]=true
end
end
if Event.WeaponPlayerName~=nil then
self:T("Hitting Scenery")
if Event.TgtCategory then
if Event.WeaponCoalition then
self.HITS[Event.TgtUnitName]=self.HITS[Event.TgtUnitName]or{}
local Hit=self.HITS[Event.TgtUnitName]
Hit.Players=Hit.Players or{}
Hit.Players[Event.WeaponPlayerName]=true
else
end
end
end
end
function DATABASE:AccountDestroys(Event)
self:F({Event})
local TargetUnit=nil
local TargetGroup=nil
local TargetUnitName=""
local TargetGroupName=""
local TargetPlayerName=""
local TargetCoalition=nil
local TargetCategory=nil
local TargetType=nil
local TargetUnitCoalition=nil
local TargetUnitCategory=nil
local TargetUnitType=nil
if Event.IniDCSUnit then
TargetUnit=Event.IniUnit
TargetUnitName=Event.IniDCSUnitName
TargetGroup=Event.IniDCSGroup
TargetGroupName=Event.IniDCSGroupName
TargetPlayerName=Event.IniPlayerName
TargetCoalition=Event.IniCoalition
TargetCategory=Event.IniCategory
TargetType=Event.IniTypeName
TargetUnitType=TargetType
self:T({TargetUnitName,TargetGroupName,TargetPlayerName,TargetCoalition,TargetCategory,TargetType})
end
local Destroyed=false
if self.HITS[Event.IniUnitName]then
self.DESTROYS[Event.IniUnitName]=self.DESTROYS[Event.IniUnitName]or{}
self.DESTROYS[Event.IniUnitName]=true
end
end
do
SET_BASE={
ClassName="SET_BASE",
Filter={},
Set={},
List={},
Index={},
Database=nil,
CallScheduler=nil,
}
function SET_BASE:New(Database)
local self=BASE:Inherit(self,FSM:New())
self.Database=Database
self:SetStartState("Started")
self:AddTransition("*","Added","*")
self:AddTransition("*","Removed","*")
self.YieldInterval=10
self.TimeInterval=0.001
self.Set={}
self.Index={}
self.CallScheduler=SCHEDULER:New(self)
self:SetEventPriority(2)
return self
end
function SET_BASE:FilterFunction(ConditionFunction,...)
local condition={}
condition.func=ConditionFunction
condition.arg={}
if arg then
condition.arg=arg
end
if not self.Filter.Functions then self.Filter.Functions={}end
table.insert(self.Filter.Functions,condition)
return self
end
function SET_BASE:_EvalFilterFunctions(Object)
for _,_condition in pairs(self.Filter.Functions or{})do
local condition=_condition
if condition.func(Object,unpack(condition.arg))==false then
return false
end
end
return true
end
function SET_BASE:Clear(TriggerEvent)
for Name,Object in pairs(self.Set)do
self:Remove(Name,not TriggerEvent)
end
return self
end
function SET_BASE:_Find(ObjectName)
local ObjectFound=self.Set[ObjectName]
return ObjectFound
end
function SET_BASE:GetSet()
return self.Set or{}
end
function SET_BASE:GetSetNames()
local Names={}
for Name,Object in pairs(self.Set)do
table.insert(Names,Name)
end
return Names
end
function SET_BASE:GetSetObjects()
local Objects={}
for Name,Object in pairs(self.Set)do
table.insert(Objects,Object)
end
return Objects
end
function SET_BASE:Remove(ObjectName,NoTriggerEvent)
local TriggerEvent=true
if NoTriggerEvent then
TriggerEvent=false
else
TriggerEvent=true
end
local Object=self.Set[ObjectName]
if Object then
for Index,Key in ipairs(self.Index)do
if Key==ObjectName then
table.remove(self.Index,Index)
self.Set[ObjectName]=nil
break
end
end
if TriggerEvent then
self:Removed(ObjectName,Object)
end
end
end
function SET_BASE:Add(ObjectName,Object)
if not ObjectName or ObjectName==""then
self:E("SET_BASE:Add - Invalid ObjectName handed")
self:E({ObjectName=ObjectName,Object=Object})
return self
end
if self.Set[ObjectName]then
self:Remove(ObjectName,true)
end
self.Set[ObjectName]=Object
table.insert(self.Index,ObjectName)
self:Added(ObjectName,Object)
return self
end
function SET_BASE:AddObject(Object)
self:Add(Object.ObjectName,Object)
end
function SET_BASE:SortByName()
local function sort(a,b)
return a<b
end
table.sort(self.Index)
end
function SET_BASE:AddSet(SetToAdd)
if not SetToAdd then return self end
for _,ObjectB in pairs(SetToAdd.Set)do
self:AddObject(ObjectB)
end
return self
end
function SET_BASE:GetSetUnion(SetB)
local union=SET_BASE:New()
for _,ObjectA in pairs(self.Set)do
union:AddObject(ObjectA)
end
for _,ObjectB in pairs(SetB.Set)do
union:AddObject(ObjectB)
end
return union
end
function SET_BASE:GetSetIntersection(SetB)
local intersection=SET_BASE:New()
local union=self:GetSetUnion(SetB)
for _,Object in pairs(union.Set)do
if self:IsIncludeObject(Object)and SetB:IsIncludeObject(Object)then
intersection:AddObject(Object)
end
end
return intersection
end
function SET_BASE:GetSetComplement(SetB)
local complement=self:GetSetUnion(SetB)
local intersection=self:GetSetIntersection(SetB)
for _,Object in pairs(intersection.Set)do
complement:Remove(Object.ObjectName,true)
end
return complement
end
function SET_BASE:CompareSets(SetA,SetB)
for _,ObjectB in pairs(SetB.Set)do
if SetA:IsIncludeObject(ObjectB)then
SetA:Add(ObjectB)
end
end
return SetA
end
function SET_BASE:Get(ObjectName)
local Object=self.Set[ObjectName]
return Object
end
function SET_BASE:GetFirst()
local ObjectName=self.Index[1]
local FirstObject=self.Set[ObjectName]
return FirstObject
end
function SET_BASE:GetLast()
local tablemax=table.maxn(self.Index)
local ObjectName=self.Index[tablemax]
local LastObject=self.Set[ObjectName]
return LastObject
end
function SET_BASE:GetRandom()
local tablemax=0
for _,_ind in pairs(self.Index)do
tablemax=tablemax+1
end
local RandomItem=self.Set[self.Index[math.random(1,tablemax)]]
return RandomItem
end
function SET_BASE:GetRandomSurely()
local tablemax=0
local sorted={}
for _,_obj in pairs(self.Set)do
tablemax=tablemax+1
sorted[tablemax]=_obj
end
local RandomItem=sorted[math.random(1,tablemax)]
return RandomItem
end
function SET_BASE:Count()
return self.Index and table.maxn(self.Index)or 0
end
function SET_BASE:SetDatabase(BaseSet)
local OtherFilter=UTILS.DeepCopy(BaseSet.Filter)
self.Filter=OtherFilter
self.Database=BaseSet:GetSet()
return self
end
function SET_BASE:SetSomeIteratorLimit(Limit)
self.SomeIteratorLimit=Limit or 1
return self
end
function SET_BASE:GetSomeIteratorLimit()
return self.SomeIteratorLimit or self:Count()
end
function SET_BASE:GetThreatLevelMax()
local ThreatMax=0
for _,_unit in pairs(self.Set or{})do
local unit=_unit
local threat=unit.GetThreatLevel and unit:GetThreatLevel()or 0
if threat>ThreatMax then
ThreatMax=threat
end
end
return ThreatMax
end
function SET_BASE:FilterOnce()
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:Remove(ObjectName,true)
end
end
return self
end
function SET_BASE:FilterClear()
for key,value in pairs(self.Filter)do
self.Filter[key]={}
end
return self
end
function SET_BASE:_FilterStart()
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
end
end
return self
end
function SET_BASE:FilterDeads()
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
return self
end
function SET_BASE:FilterCrashes()
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
return self
end
function SET_BASE:FilterStop()
self:UnHandleEvent(EVENTS.Birth)
self:UnHandleEvent(EVENTS.Dead)
self:UnHandleEvent(EVENTS.Crash)
return self
end
function SET_BASE:FindNearestObjectFromPointVec2(Coordinate)
local NearestObject=nil
local ClosestDistance=nil
for ObjectID,ObjectData in pairs(self.Set)do
if NearestObject==nil then
NearestObject=ObjectData
ClosestDistance=Coordinate:DistanceFromPointVec2(ObjectData:GetCoordinate())
else
local Distance=Coordinate:DistanceFromPointVec2(ObjectData:GetCoordinate())
if Distance<ClosestDistance then
NearestObject=ObjectData
ClosestDistance=Distance
end
end
end
return NearestObject
end
function SET_BASE:_EventOnBirth(Event)
if Event.IniDCSUnit then
local ObjectName,Object=self:AddInDatabase(Event)
if Object and self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
end
end
end
function SET_BASE:_EventOnDeadOrCrash(Event)
if Event.IniDCSUnit then
local ObjectName,Object=self:FindInDatabase(Event)
if ObjectName then
self:Remove(ObjectName)
end
end
end
function SET_BASE:ForEach(IteratorFunction,arg,Set,Function,FunctionArguments)
Set=Set or self:GetSet()
arg=arg or{}
local function CoRoutine()
local Count=0
for ObjectID,ObjectData in pairs(Set)do
local Object=ObjectData
if Function then
if Function(unpack(FunctionArguments or{}),Object)==true then
IteratorFunction(Object,unpack(arg))
end
else
IteratorFunction(Object,unpack(arg))
end
Count=Count+1
end
return true
end
local co=CoRoutine
local function Schedule()
local status,res=co()
if status==false then
error(res)
end
if res==false then
return true
end
return false
end
Schedule()
return self
end
function SET_BASE:ForSome(IteratorFunction,arg,Set,Function,FunctionArguments)
Set=Set or self:GetSet()
arg=arg or{}
local Limit=self:GetSomeIteratorLimit()
local function CoRoutine()
local Count=0
for ObjectID,ObjectData in pairs(Set)do
local Object=ObjectData
if Function then
if Function(unpack(FunctionArguments),Object)==true then
IteratorFunction(Object,unpack(arg))
end
else
IteratorFunction(Object,unpack(arg))
end
Count=Count+1
if Count>=Limit then
break
end
end
return true
end
local co=CoRoutine
local function Schedule()
local status,res=co()
if status==false then
error(res)
end
if res==false then
return true
end
return false
end
Schedule()
return self
end
function SET_BASE:IsIncludeObject(Object)
return true
end
function SET_BASE:IsInSet(Object)
local outcome=false
local name=Object:GetName()
self:ForEach(
function(object)
if object:GetName()==name then
outcome=true
end
end
)
return outcome
end
function SET_BASE:IsNotInSet(Object)
return not self:IsInSet(Object)
end
function SET_BASE:GetObjectNames()
local ObjectNames=""
for ObjectName,Object in pairs(self.Set)do
ObjectNames=ObjectNames..ObjectName..", "
end
return ObjectNames
end
function SET_BASE:Flush(MasterObject)
local ObjectNames=""
for ObjectName,Object in pairs(self.Set)do
ObjectNames=ObjectNames..ObjectName..", "
end
return ObjectNames
end
end
do
SET_GROUP={
ClassName="SET_GROUP",
Filter={
Coalitions=nil,
Categories=nil,
Countries=nil,
GroupPrefixes=nil,
Zones=nil,
Functions=nil,
Alive=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
plane=Group.Category.AIRPLANE,
helicopter=Group.Category.HELICOPTER,
ground=Group.Category.GROUND,
ship=Group.Category.SHIP,
structure=Group.Category.STRUCTURE,
},
},
}
function SET_GROUP:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.GROUPS))
self:FilterActive(false)
return self
end
function SET_GROUP:GetAliveSet()
local AliveSet=SET_GROUP:New()
for GroupName,GroupObject in pairs(self.Set)do
local GroupObject=GroupObject
if GroupObject then
if GroupObject:IsAlive()then
AliveSet:Add(GroupName,GroupObject)
end
end
end
return AliveSet.Set or{}
end
function SET_GROUP:GetUnitTypeNames()
local MT={}
local UnitTypes={}
local ReportUnitTypes=REPORT:New()
for GroupID,GroupData in pairs(self:GetSet())do
local Units=GroupData:GetUnits()
for UnitID,UnitData in pairs(Units)do
if UnitData:IsAlive()then
local UnitType=UnitData:GetTypeName()
if not UnitTypes[UnitType]then
UnitTypes[UnitType]=1
else
UnitTypes[UnitType]=UnitTypes[UnitType]+1
end
end
end
end
for UnitTypeID,UnitType in pairs(UnitTypes)do
ReportUnitTypes:Add(UnitType.." of "..UnitTypeID)
end
return ReportUnitTypes
end
function SET_GROUP:AddGroup(group,DontSetCargoBayLimit)
self:Add(group:GetName(),group)
if not DontSetCargoBayLimit then
for UnitID,UnitData in pairs(group:GetUnits()or{})do
if UnitData and UnitData:IsAlive()then
UnitData:SetCargoBayWeightLimit()
end
end
end
return self
end
function SET_GROUP:AddGroupsByName(AddGroupNames)
local AddGroupNamesArray=(type(AddGroupNames)=="table")and AddGroupNames or{AddGroupNames}
for AddGroupID,AddGroupName in pairs(AddGroupNamesArray)do
self:Add(AddGroupName,GROUP:FindByName(AddGroupName))
end
return self
end
function SET_GROUP:RemoveGroupsByName(RemoveGroupNames)
local RemoveGroupNamesArray=(type(RemoveGroupNames)=="table")and RemoveGroupNames or{RemoveGroupNames}
for RemoveGroupID,RemoveGroupName in pairs(RemoveGroupNamesArray)do
self:Remove(RemoveGroupName)
end
return self
end
function SET_GROUP:FindGroup(GroupName)
local GroupFound=self.Set[GroupName]
return GroupFound
end
function SET_GROUP:FindNearestGroupFromPointVec2(Coordinate)
local NearestGroup=nil
local ClosestDistance=nil
local Set=self:GetAliveSet()
for ObjectID,ObjectData in pairs(Set)do
if NearestGroup==nil then
NearestGroup=ObjectData
ClosestDistance=Coordinate:DistanceFromPointVec2(ObjectData:GetCoordinate())
else
local Distance=Coordinate:DistanceFromPointVec2(ObjectData:GetCoordinate())
if Distance<ClosestDistance then
NearestGroup=ObjectData
ClosestDistance=Distance
end
end
end
return NearestGroup
end
function SET_GROUP:FilterZones(Zones,Clear)
if Clear or not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_GROUP:FilterCoalitions(Coalitions,Clear)
if Clear or(not self.Filter.Coalitions)then
self.Filter.Coalitions={}
end
Coalitions=UTILS.EnsureTable(Coalitions,false)
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_GROUP:FilterCategories(Categories,Clear)
if Clear or not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_GROUP:FilterCategoryGround()
self:FilterCategories("ground")
return self
end
function SET_GROUP:FilterCategoryAirplane()
self:FilterCategories("plane")
return self
end
function SET_GROUP:FilterCategoryHelicopter()
self:FilterCategories("helicopter")
return self
end
function SET_GROUP:FilterCategoryShip()
self:FilterCategories("ship")
return self
end
function SET_GROUP:FilterCategoryStructure()
self:FilterCategories("structure")
return self
end
function SET_GROUP:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_GROUP:FilterPrefixes(Prefixes)
if not self.Filter.GroupPrefixes then
self.Filter.GroupPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.GroupPrefixes[Prefix]=Prefix
end
return self
end
function SET_GROUP:_ContinousZoneFilter()
local Database=_DATABASE.GROUPS
for ObjectName,Object in pairs(Database)do
if self:IsIncludeObject(Object)and self:IsNotInSet(Object)then
self:Add(ObjectName,Object)
elseif(not self:IsIncludeObject(Object))and self:IsInSet(Object)then
self:Remove(ObjectName)
end
end
return self
end
function SET_GROUP:FilterActive(Active)
Active=Active or not(Active==false)
self.Filter.Active=Active
return self
end
function SET_GROUP:FilterAlive()
self.Filter.Alive=true
return self
end
function SET_GROUP:FilterStart()
if _DATABASE then
self:_FilterStart()
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.RemoveUnit,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.PlayerLeaveUnit,self._EventOnDeadOrCrash)
if self.Filter.Zones then
self.ZoneTimer=TIMER:New(self._ContinousZoneFilter,self)
local timing=self.ZoneTimerInterval or 30
self.ZoneTimer:Start(timing,timing)
end
end
return self
end
function SET_GROUP:FilterZoneTimer(Seconds)
self.ZoneTimerInterval=Seconds or 30
return self
end
function SET_GROUP:FilterStop()
if _DATABASE then
self:UnHandleEvent(EVENTS.Birth)
self:UnHandleEvent(EVENTS.Dead)
self:UnHandleEvent(EVENTS.Crash)
self:UnHandleEvent(EVENTS.RemoveUnit)
self:UnHandleEvent(EVENTS.UnitLost)
if self.Filter.Zones and self.ZoneTimer and self.ZoneTimer:IsRunning()then
self.ZoneTimer:Stop()
end
end
return self
end
function SET_GROUP:_EventOnDeadOrCrash(Event)
if Event.IniDCSUnit then
local ObjectName,Object=self:FindInDatabase(Event)
if ObjectName then
local size=1
if Event.IniDCSGroup then
size=Event.IniDCSGroup:getSize()
elseif Event.IniDCSGroupName then
local grp=Group.getByName(Event.IniDCSGroupName)
if grp then
size=grp:getSize()
end
elseif Object:IsAlive()then
size=Object:CountAliveUnits()
end
if size==1 then
self:Remove(ObjectName)
end
end
end
end
function SET_GROUP:AddInDatabase(Event)
if Event.IniObjectCategory==Object.Category.UNIT then
if not self.Database[Event.IniDCSGroupName]then
self.Database[Event.IniDCSGroupName]=GROUP:Register(Event.IniDCSGroupName)
end
end
return Event.IniDCSGroupName,self.Database[Event.IniDCSGroupName]
end
function SET_GROUP:FindInDatabase(Event)
return Event.IniDCSGroupName,self.Database[Event.IniDCSGroupName]
end
function SET_GROUP:ForEachGroup(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_GROUP:ForSomeGroup(IteratorFunction,...)
self:ForSome(IteratorFunction,arg,self:GetSet())
return self
end
function SET_GROUP:ForEachGroupAlive(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetAliveSet())
return self
end
function SET_GROUP:ForSomeGroupAlive(IteratorFunction,...)
self:ForSome(IteratorFunction,arg,self:GetAliveSet())
return self
end
function SET_GROUP:Activate(Delay)
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
local group=GroupData
if group and group:IsAlive()==false then
group:Activate(Delay)
end
end
return self
end
function SET_GROUP:ForEachGroupCompletelyInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,GroupObject)
if GroupObject:IsCompletelyInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_GROUP:ForEachGroupPartlyInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,GroupObject)
if GroupObject:IsPartlyInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_GROUP:ForEachGroupNotInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,GroupObject)
if GroupObject:IsNotInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_GROUP:AllCompletelyInZone(Zone)
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if not GroupData:IsCompletelyInZone(Zone)then
return false
end
end
return true
end
function SET_GROUP:ForEachGroupAnyInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,GroupObject)
if GroupObject:IsAnyInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_GROUP:AnyCompletelyInZone(Zone)
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if GroupData:IsCompletelyInZone(Zone)then
return true
end
end
return false
end
function SET_GROUP:AnyInZone(Zone)
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if GroupData:IsPartlyInZone(Zone)or GroupData:IsCompletelyInZone(Zone)then
return true
end
end
return false
end
function SET_GROUP:AnyPartlyInZone(Zone)
local IsPartlyInZone=false
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if GroupData:IsCompletelyInZone(Zone)then
return false
elseif GroupData:IsPartlyInZone(Zone)then
IsPartlyInZone=true
end
end
if IsPartlyInZone then
return true
else
return false
end
end
function SET_GROUP:NoneInZone(Zone)
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if not GroupData:IsNotInZone(Zone)then
return false
end
end
return true
end
function SET_GROUP:CountInZone(Zone)
local Count=0
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if GroupData:IsCompletelyInZone(Zone)then
Count=Count+1
end
end
return Count
end
function SET_GROUP:CountUnitInZone(Zone)
local Count=0
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
Count=Count+GroupData:CountInZone(Zone)
end
return Count
end
function SET_GROUP:CountAlive()
local CountG=0
local CountU=0
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
if GroupData and GroupData:IsAlive()then
CountG=CountG+1
for _,_unit in pairs(GroupData:GetUnits())do
local unit=_unit
if unit and unit:IsAlive()then
CountU=CountU+1
end
end
end
end
return CountG,CountU
end
function SET_GROUP:IsIncludeObject(MGroup)
local MGroupInclude=true
if self.Filter.Alive==true then
local MGroupAlive=false
if MGroup and MGroup:IsAlive()then
MGroupAlive=true
end
MGroupInclude=MGroupInclude and MGroupAlive
end
if self.Filter.Active~=nil then
local MGroupActive=false
if self.Filter.Active==false or(self.Filter.Active==true and MGroup:IsActive()==true)then
MGroupActive=true
end
MGroupInclude=MGroupInclude and MGroupActive
end
if self.Filter.Coalitions and MGroupInclude then
local MGroupCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==MGroup:GetCoalition()then
MGroupCoalition=true
end
end
MGroupInclude=MGroupInclude and MGroupCoalition
end
if self.Filter.Categories and MGroupInclude then
local MGroupCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
if self.FilterMeta.Categories[CategoryName]and self.FilterMeta.Categories[CategoryName]==MGroup:GetCategory()then
MGroupCategory=true
end
end
MGroupInclude=MGroupInclude and MGroupCategory
end
if self.Filter.Countries and MGroupInclude then
local MGroupCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
if country.id[CountryName]==MGroup:GetCountry()then
MGroupCountry=true
end
end
MGroupInclude=MGroupInclude and MGroupCountry
end
if self.Filter.GroupPrefixes and MGroupInclude then
local MGroupPrefix=false
for GroupPrefixId,GroupPrefix in pairs(self.Filter.GroupPrefixes)do
if string.find(MGroup:GetName(),string.gsub(GroupPrefix,"-","%%-"),1)then
MGroupPrefix=true
end
end
MGroupInclude=MGroupInclude and MGroupPrefix
end
if self.Filter.Zones and MGroupInclude then
local MGroupZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
if MGroup:IsInZone(Zone)then
MGroupZone=true
end
end
MGroupInclude=MGroupInclude and MGroupZone
end
if self.Filter.Functions and MGroupInclude then
local MGroupFunc=false
MGroupFunc=self:_EvalFilterFunctions(MGroup)
MGroupInclude=MGroupInclude and MGroupFunc
end
return MGroupInclude
end
function SET_GROUP:GetClosestGroup(Coordinate,Coalitions)
local Set=self:GetSet()
local dmin=math.huge
local gmin=nil
for GroupID,GroupData in pairs(Set)do
local group=GroupData
if group and group:IsAlive()and(Coalitions==nil or UTILS.IsAnyInTable(Coalitions,group:GetCoalition()))then
local coord=group:GetCoordinate()
local d
if coord~=nil then
d=UTILS.VecDist3D(Coordinate,coord)
if d<dmin then
dmin=d
gmin=group
end
end
end
end
return gmin,dmin
end
function SET_GROUP:SetCargoBayWeightLimit()
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
for UnitName,UnitData in pairs(GroupData:GetUnits())do
UnitData:SetCargoBayWeightLimit()
end
end
end
end
do
SET_UNIT={
ClassName="SET_UNIT",
Units={},
Filter={
Coalitions=nil,
Categories=nil,
Types=nil,
Countries=nil,
UnitPrefixes=nil,
Zones=nil,
Functions=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
plane=Unit.Category.AIRPLANE,
helicopter=Unit.Category.HELICOPTER,
ground=Unit.Category.GROUND_UNIT,
ship=Unit.Category.SHIP,
structure=Unit.Category.STRUCTURE,
},
},
}
function SET_UNIT:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.UNITS))
self:FilterActive(false)
return self
end
function SET_UNIT:AddUnit(Unit)
self:Add(Unit:GetName(),Unit)
if Unit:IsInstanceOf("UNIT")then
Unit:SetCargoBayWeightLimit()
end
return self
end
function SET_UNIT:AddUnitsByName(AddUnitNames)
local AddUnitNamesArray=(type(AddUnitNames)=="table")and AddUnitNames or{AddUnitNames}
for AddUnitID,AddUnitName in pairs(AddUnitNamesArray)do
self:Add(AddUnitName,UNIT:FindByName(AddUnitName))
end
return self
end
function SET_UNIT:RemoveUnitsByName(RemoveUnitNames)
local RemoveUnitNamesArray=(type(RemoveUnitNames)=="table")and RemoveUnitNames or{RemoveUnitNames}
for RemoveUnitID,RemoveUnitName in pairs(RemoveUnitNamesArray)do
self:Remove(RemoveUnitName)
end
return self
end
function SET_UNIT:FindUnit(UnitName)
local UnitFound=self.Set[UnitName]
return UnitFound
end
function SET_UNIT:FilterCoalitions(Coalitions)
self.Filter.Coalitions={}
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_UNIT:FilterCategories(Categories)
if not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_UNIT:FilterTypes(Types)
if not self.Filter.Types then
self.Filter.Types={}
end
if type(Types)~="table"then
Types={Types}
end
for TypeID,Type in pairs(Types)do
self.Filter.Types[Type]=Type
end
return self
end
function SET_UNIT:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_UNIT:FilterPrefixes(Prefixes)
if not self.Filter.UnitPrefixes then
self.Filter.UnitPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.UnitPrefixes[Prefix]=Prefix
end
return self
end
function SET_UNIT:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_UNIT:FilterActive(Active)
Active=Active or not(Active==false)
self.Filter.Active=Active
return self
end
function SET_UNIT:FilterAlive()
self:FilterFunction(
function(unit)
if unit and unit:IsExist()and unit:IsAlive()then
return true
else
return false
end
end
)
return self
end
function SET_UNIT:FilterGroupPrefixes(Prefixes)
if type(Prefixes)=="string"then
Prefixes={Prefixes}
end
self:FilterFunction(
function(unit,prefixes)
local outcome=false
if unit then
local grp=unit:GetGroup()
local gname=grp~=nil and grp:GetName()or"none"
for _,_fix in pairs(prefixes or{})do
if string.find(gname,_fix)then
outcome=true
break
end
end
else
return false
end
return outcome
end,Prefixes
)
return self
end
function SET_UNIT:FilterHasRadar(RadarTypes)
self.Filter.RadarTypes=self.Filter.RadarTypes or{}
if type(RadarTypes)~="table"then
RadarTypes={RadarTypes}
end
for RadarTypeID,RadarType in pairs(RadarTypes)do
self.Filter.RadarTypes[RadarType]=RadarType
end
return self
end
function SET_UNIT:FilterHasSEAD()
self.Filter.SEAD=true
return self
end
function SET_UNIT:CountAlive()
local Set=self:GetSet()
local CountU=0
for UnitID,UnitData in pairs(Set)do
if UnitData and UnitData:IsAlive()then
CountU=CountU+1
end
end
return CountU
end
function SET_UNIT:GetAliveSet()
local AliveSet=SET_UNIT:New()
for GroupName,GroupObject in pairs(self.Set)do
local GroupObject=GroupObject
if GroupObject and GroupObject:IsAlive()then
AliveSet:Add(GroupName,GroupObject)
end
end
return AliveSet.Set or{},AliveSet
end
function SET_UNIT:_ContinousZoneFilter()
local Database=_DATABASE.UNITS
for ObjectName,Object in pairs(Database)do
if self:IsIncludeObject(Object)and self:IsNotInSet(Object)then
self:Add(ObjectName,Object)
elseif(not self:IsIncludeObject(Object))and self:IsInSet(Object)then
self:Remove(ObjectName)
end
end
return self
end
function SET_UNIT:FilterZoneTimer(Seconds)
self.ZoneTimerInterval=Seconds or 30
return self
end
function SET_UNIT:FilterStop()
if _DATABASE then
self:UnHandleEvent(EVENTS.Birth)
self:UnHandleEvent(EVENTS.Dead)
self:UnHandleEvent(EVENTS.Crash)
self:UnHandleEvent(EVENTS.RemoveUnit)
if self.Filter.Zones and self.ZoneTimer and self.ZoneTimer:IsRunning()then
self.ZoneTimer:Stop()
end
end
return self
end
function SET_UNIT:FilterStart()
if _DATABASE then
self:_FilterStart()
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.RemoveUnit,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._EventOnDeadOrCrash)
if self.Filter.Zones then
self.ZoneTimer=TIMER:New(self._ContinousZoneFilter,self)
local timing=self.ZoneTimerInterval or 30
self.ZoneTimer:Start(timing,timing)
end
end
return self
end
function SET_UNIT:AddInDatabase(Event)
if Event.IniObjectCategory==Object.Category.UNIT then
if not self.Database[Event.IniDCSUnitName]then
self.Database[Event.IniDCSUnitName]=UNIT:Register(Event.IniDCSUnitName)
end
end
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_UNIT:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Set[Event.IniDCSUnitName]
end
do
function SET_UNIT:IsPartiallyInZone(ZoneTest)
local IsPartiallyInZone=false
local function EvaluateZone(ZoneUnit)
local ZoneUnitName=ZoneUnit:GetName()
if self:FindUnit(ZoneUnitName)then
IsPartiallyInZone=true
return false
end
return true
end
ZoneTest:SearchZone(EvaluateZone)
return IsPartiallyInZone
end
function SET_UNIT:IsNotInZone(Zone)
local IsNotInZone=true
local function EvaluateZone(ZoneUnit)
local ZoneUnitName=ZoneUnit:GetName()
if self:FindUnit(ZoneUnitName)then
IsNotInZone=false
return false
end
return true
end
Zone:SearchZone(EvaluateZone)
return IsNotInZone
end
end
function SET_UNIT:ForEachUnit(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_UNIT:GetSetPerThreatLevel(FromThreatLevel,ToThreatLevel)
local ThreatLevelSet={}
if self:Count()~=0 then
for UnitName,UnitObject in pairs(self.Set)do
local Unit=UnitObject
local ThreatLevel=Unit:GetThreatLevel()
ThreatLevelSet[ThreatLevel]=ThreatLevelSet[ThreatLevel]or{}
ThreatLevelSet[ThreatLevel].Set=ThreatLevelSet[ThreatLevel].Set or{}
ThreatLevelSet[ThreatLevel].Set[UnitName]=UnitObject
end
local OrderedPerThreatLevelSet={}
local ThreatLevelIncrement=FromThreatLevel<=ToThreatLevel and 1 or-1
for ThreatLevel=FromThreatLevel,ToThreatLevel,ThreatLevelIncrement do
local ThreatLevelItem=ThreatLevelSet[ThreatLevel]
if ThreatLevelItem then
for UnitName,UnitObject in pairs(ThreatLevelItem.Set)do
table.insert(OrderedPerThreatLevelSet,UnitObject)
end
end
end
return OrderedPerThreatLevelSet
end
end
function SET_UNIT:ForEachUnitPerThreatLevel(FromThreatLevel,ToThreatLevel,IteratorFunction,...)
local ThreatLevelSet={}
if self:Count()~=0 then
for UnitName,UnitObject in pairs(self.Set)do
local Unit=UnitObject
local ThreatLevel=Unit:GetThreatLevel()
ThreatLevelSet[ThreatLevel]=ThreatLevelSet[ThreatLevel]or{}
ThreatLevelSet[ThreatLevel].Set=ThreatLevelSet[ThreatLevel].Set or{}
ThreatLevelSet[ThreatLevel].Set[UnitName]=UnitObject
end
local ThreatLevelIncrement=FromThreatLevel<=ToThreatLevel and 1 or-1
for ThreatLevel=FromThreatLevel,ToThreatLevel,ThreatLevelIncrement do
local ThreatLevelItem=ThreatLevelSet[ThreatLevel]
if ThreatLevelItem then
self:ForEach(IteratorFunction,arg,ThreatLevelItem.Set)
end
end
end
return self
end
function SET_UNIT:ForEachUnitCompletelyInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,UnitObject)
if UnitObject:IsInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_UNIT:ForEachUnitNotInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,UnitObject)
if UnitObject:IsNotInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_UNIT:GetUnitTypes()
local MT={}
local UnitTypes={}
for UnitID,UnitData in pairs(self:GetSet())do
local TextUnit=UnitData
if TextUnit:IsAlive()then
local UnitType=TextUnit:GetTypeName()
if not UnitTypes[UnitType]then
UnitTypes[UnitType]=1
else
UnitTypes[UnitType]=UnitTypes[UnitType]+1
end
end
end
for UnitTypeID,UnitType in pairs(UnitTypes)do
MT[#MT+1]=UnitType.." of "..UnitTypeID
end
return UnitTypes
end
function SET_UNIT:GetUnitTypesText()
local MT={}
local UnitTypes=self:GetUnitTypes()
for UnitTypeID,UnitType in pairs(UnitTypes)do
MT[#MT+1]=UnitType.." of "..UnitTypeID
end
return table.concat(MT,", ")
end
function SET_UNIT:GetUnitThreatLevels()
local UnitThreatLevels={}
for UnitID,UnitData in pairs(self:GetSet())do
local ThreatUnit=UnitData
if ThreatUnit:IsAlive()then
local UnitThreatLevel,UnitThreatLevelText=ThreatUnit:GetThreatLevel()
local ThreatUnitName=ThreatUnit:GetName()
UnitThreatLevels[UnitThreatLevel]=UnitThreatLevels[UnitThreatLevel]or{}
UnitThreatLevels[UnitThreatLevel].UnitThreatLevelText=UnitThreatLevelText
UnitThreatLevels[UnitThreatLevel].Units=UnitThreatLevels[UnitThreatLevel].Units or{}
UnitThreatLevels[UnitThreatLevel].Units[ThreatUnitName]=ThreatUnit
end
end
return UnitThreatLevels
end
function SET_UNIT:CalculateThreatLevelA2G()
local MaxThreatLevelA2G=0
local MaxThreatText=""
for UnitName,UnitData in pairs(self:GetSet())do
local ThreatUnit=UnitData
local ThreatLevelA2G,ThreatText=ThreatUnit:GetThreatLevel()
if ThreatLevelA2G>MaxThreatLevelA2G then
MaxThreatLevelA2G=ThreatLevelA2G
MaxThreatText=ThreatText
end
end
return MaxThreatLevelA2G,MaxThreatText
end
function SET_UNIT:GetCoordinate()
local function GetSetVec3(units)
local x=0
local y=0
local z=0
local n=0
for _,unit in pairs(units)do
local vec3=nil
if unit and unit:IsAlive()then
vec3=unit:GetVec3()
end
if vec3 then
x=x+vec3.x
y=y+vec3.y
z=z+vec3.z
n=n+1
end
end
if n>0 then
local Vec3={x=x/n,y=y/n,z=z/n}
return Vec3
end
return nil
end
local Coordinate=nil
local Vec3=GetSetVec3(self.Set)
if Vec3 then
Coordinate=COORDINATE:NewFromVec3(Vec3)
end
if Coordinate then
local heading=self:GetHeading()or 0
local velocity=self:GetVelocity()or 0
Coordinate:SetHeading(heading)
Coordinate:SetVelocity(velocity)
end
return Coordinate
end
function SET_UNIT:GetVelocity()
local Coordinate=self:GetFirst():GetCoordinate()
local MaxVelocity=0
for UnitName,UnitData in pairs(self:GetSet())do
local Unit=UnitData
local Coordinate=Unit:GetCoordinate()
local Velocity=Coordinate:GetVelocity()
if Velocity~=0 then
MaxVelocity=(MaxVelocity<Velocity)and Velocity or MaxVelocity
end
end
return MaxVelocity
end
function SET_UNIT:GetHeading()
local HeadingSet=nil
local MovingCount=0
for UnitName,UnitData in pairs(self:GetSet())do
local Unit=UnitData
local Coordinate=Unit:GetCoordinate()
local Velocity=Coordinate:GetVelocity()
if Velocity~=0 then
local Heading=Coordinate:GetHeading()
if HeadingSet==nil then
HeadingSet=Heading
else
local HeadingDiff=(HeadingSet-Heading+180+360)%360-180
HeadingDiff=math.abs(HeadingDiff)
if HeadingDiff>5 then
HeadingSet=nil
break
end
end
end
end
return HeadingSet
end
function SET_UNIT:HasRadar(RadarType)
local RadarCount=0
for UnitID,UnitData in pairs(self:GetSet())do
local UnitSensorTest=UnitData
local HasSensors
if RadarType then
HasSensors=UnitSensorTest:HasSensors(Unit.SensorType.RADAR,RadarType)
else
HasSensors=UnitSensorTest:HasSensors(Unit.SensorType.RADAR)
end
if HasSensors then
RadarCount=RadarCount+1
end
end
return RadarCount
end
function SET_UNIT:HasSEAD()
local SEADCount=0
for UnitID,UnitData in pairs(self:GetSet())do
local UnitSEAD=UnitData
if UnitSEAD:IsAlive()then
local UnitSEADAttributes=UnitSEAD:GetDesc().attributes
local HasSEAD=UnitSEAD:HasSEAD()
if HasSEAD then
SEADCount=SEADCount+1
end
end
end
return SEADCount
end
function SET_UNIT:HasGroundUnits()
local GroundUnitCount=0
for UnitID,UnitData in pairs(self:GetSet())do
local UnitTest=UnitData
if UnitTest:IsGround()then
GroundUnitCount=GroundUnitCount+1
end
end
return GroundUnitCount
end
function SET_UNIT:HasAirUnits()
local AirUnitCount=0
for UnitID,UnitData in pairs(self:GetSet())do
local UnitTest=UnitData
if UnitTest:IsAir()then
AirUnitCount=AirUnitCount+1
end
end
return AirUnitCount
end
function SET_UNIT:HasFriendlyUnits(FriendlyCoalition)
local FriendlyUnitCount=0
for UnitID,UnitData in pairs(self:GetSet())do
local UnitTest=UnitData
if UnitTest:IsFriendly(FriendlyCoalition)then
FriendlyUnitCount=FriendlyUnitCount+1
end
end
return FriendlyUnitCount
end
function SET_UNIT:IsIncludeObject(MUnit)
local MUnitInclude=false
if MUnit:IsAlive()~=nil then
MUnitInclude=true
if self.Filter.Active~=nil then
local MUnitActive=false
if self.Filter.Active==false or(self.Filter.Active==true and MUnit:IsActive()==true)then
MUnitActive=true
end
MUnitInclude=MUnitInclude and MUnitActive
end
if self.Filter.Coalitions and MUnitInclude then
local MUnitCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==MUnit:GetCoalition()then
MUnitCoalition=true
end
end
MUnitInclude=MUnitInclude and MUnitCoalition
end
if self.Filter.Categories and MUnitInclude then
local MUnitCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
if self.FilterMeta.Categories[CategoryName]and self.FilterMeta.Categories[CategoryName]==MUnit:GetDesc().category then
MUnitCategory=true
end
end
MUnitInclude=MUnitInclude and MUnitCategory
end
if self.Filter.Types and MUnitInclude then
local MUnitType=false
for TypeID,TypeName in pairs(self.Filter.Types)do
if TypeName==MUnit:GetTypeName()then
MUnitType=true
end
end
MUnitInclude=MUnitInclude and MUnitType
end
if self.Filter.Countries and MUnitInclude then
local MUnitCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
if country.id[CountryName]==MUnit:GetCountry()then
MUnitCountry=true
end
end
MUnitInclude=MUnitInclude and MUnitCountry
end
if self.Filter.UnitPrefixes and MUnitInclude then
local MUnitPrefix=false
for UnitPrefixId,UnitPrefix in pairs(self.Filter.UnitPrefixes)do
if string.find(MUnit:GetName(),UnitPrefix,1)then
MUnitPrefix=true
end
end
MUnitInclude=MUnitInclude and MUnitPrefix
end
if self.Filter.RadarTypes and MUnitInclude then
local MUnitRadar=false
for RadarTypeID,RadarType in pairs(self.Filter.RadarTypes)do
if MUnit:HasSensors(Unit.SensorType.RADAR,RadarType)==true then
if MUnit:GetRadar()==true then
end
MUnitRadar=true
end
end
MUnitInclude=MUnitInclude and MUnitRadar
end
if self.Filter.SEAD and MUnitInclude then
local MUnitSEAD=false
if MUnit:HasSEAD()==true then
MUnitSEAD=true
end
MUnitInclude=MUnitInclude and MUnitSEAD
end
end
if self.Filter.Zones and MUnitInclude then
local MGroupZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
if MUnit:IsInZone(Zone)then
MGroupZone=true
end
end
MUnitInclude=MUnitInclude and MGroupZone
end
if self.Filter.Functions and MUnitInclude then
local MUnitFunc=self:_EvalFilterFunctions(MUnit)
MUnitInclude=MUnitInclude and MUnitFunc
end
return MUnitInclude
end
function SET_UNIT:GetTypeNames(Delimiter)
Delimiter=Delimiter or", "
local TypeReport=REPORT:New()
local Types={}
for UnitName,UnitData in pairs(self:GetSet())do
local Unit=UnitData
local UnitTypeName=Unit:GetTypeName()
if not Types[UnitTypeName]then
Types[UnitTypeName]=UnitTypeName
TypeReport:Add(UnitTypeName)
end
end
return TypeReport:Text(Delimiter)
end
function SET_UNIT:SetCargoBayWeightLimit()
local Set=self:GetSet()
for UnitID,UnitData in pairs(Set)do
UnitData:SetCargoBayWeightLimit()
end
end
end
do
SET_STATIC={
ClassName="SET_STATIC",
Statics={},
Filter={
Coalitions=nil,
Categories=nil,
Types=nil,
Countries=nil,
StaticPrefixes=nil,
Zones=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
plane=Unit.Category.AIRPLANE,
helicopter=Unit.Category.HELICOPTER,
ground=Unit.Category.GROUND_STATIC,
ship=Unit.Category.SHIP,
structure=Unit.Category.STRUCTURE,
},
},
}
function SET_STATIC:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.STATICS))
return self
end
function SET_STATIC:AddStatic(AddStatic)
self:Add(AddStatic:GetName(),AddStatic)
return self
end
function SET_STATIC:AddStaticsByName(AddStaticNames)
local AddStaticNamesArray=(type(AddStaticNames)=="table")and AddStaticNames or{AddStaticNames}
for AddStaticID,AddStaticName in pairs(AddStaticNamesArray)do
self:Add(AddStaticName,STATIC:FindByName(AddStaticName))
end
return self
end
function SET_STATIC:RemoveStaticsByName(RemoveStaticNames)
local RemoveStaticNamesArray=(type(RemoveStaticNames)=="table")and RemoveStaticNames or{RemoveStaticNames}
for RemoveStaticID,RemoveStaticName in pairs(RemoveStaticNamesArray)do
self:Remove(RemoveStaticName)
end
return self
end
function SET_STATIC:FindStatic(StaticName)
local StaticFound=self.Set[StaticName]
return StaticFound
end
function SET_STATIC:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_STATIC:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_STATIC:FilterCategories(Categories)
if not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_STATIC:FilterTypes(Types)
if not self.Filter.Types then
self.Filter.Types={}
end
if type(Types)~="table"then
Types={Types}
end
for TypeID,Type in pairs(Types)do
self.Filter.Types[Type]=Type
end
return self
end
function SET_STATIC:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_STATIC:FilterPrefixes(Prefixes)
if not self.Filter.StaticPrefixes then
self.Filter.StaticPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.StaticPrefixes[Prefix]=Prefix
end
return self
end
function SET_STATIC:FilterStart()
if _DATABASE then
self:_FilterStart()
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._EventOnDeadOrCrash)
end
return self
end
function SET_STATIC:CountAlive()
local Set=self:GetSet()
local CountU=0
for UnitID,UnitData in pairs(Set)do
if UnitData and UnitData:IsAlive()then
CountU=CountU+1
end
end
return CountU
end
function SET_STATIC:AddInDatabase(Event)
if Event.IniObjectCategory==Object.Category.STATIC then
if not self.Database[Event.IniDCSUnitName]then
self.Database[Event.IniDCSUnitName]=STATIC:Register(Event.IniDCSUnitName)
end
end
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_STATIC:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Set[Event.IniDCSUnitName]
end
do
function SET_STATIC:IsPartiallyInZone(Zone)
local IsPartiallyInZone=false
local function EvaluateZone(ZoneStatic)
local ZoneStaticName=ZoneStatic:GetName()
if self:FindStatic(ZoneStaticName)then
IsPartiallyInZone=true
return false
end
return true
end
return IsPartiallyInZone
end
function SET_STATIC:IsNotInZone(Zone)
local IsNotInZone=true
local function EvaluateZone(ZoneStatic)
local ZoneStaticName=ZoneStatic:GetName()
if self:FindStatic(ZoneStaticName)then
IsNotInZone=false
return false
end
return true
end
Zone:Search(EvaluateZone)
return IsNotInZone
end
function SET_STATIC:ForEachStaticInZone(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
end
function SET_STATIC:ForEachStatic(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_STATIC:ForEachStaticCompletelyInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,StaticObject)
if StaticObject:IsInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_STATIC:ForEachStaticNotInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,StaticObject)
if StaticObject:IsNotInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_STATIC:GetStaticTypes()
local MT={}
local StaticTypes={}
for StaticID,StaticData in pairs(self:GetSet())do
local TextStatic=StaticData
if TextStatic:IsAlive()then
local StaticType=TextStatic:GetTypeName()
if not StaticTypes[StaticType]then
StaticTypes[StaticType]=1
else
StaticTypes[StaticType]=StaticTypes[StaticType]+1
end
end
end
for StaticTypeID,StaticType in pairs(StaticTypes)do
MT[#MT+1]=StaticType.." of "..StaticTypeID
end
return StaticTypes
end
function SET_STATIC:GetStaticTypesText()
local MT={}
local StaticTypes=self:GetStaticTypes()
for StaticTypeID,StaticType in pairs(StaticTypes)do
MT[#MT+1]=StaticType.." of "..StaticTypeID
end
return table.concat(MT,", ")
end
function SET_STATIC:GetCoordinate()
local Coordinate=self:GetFirst():GetCoordinate()
local x1=Coordinate.x
local x2=Coordinate.x
local y1=Coordinate.y
local y2=Coordinate.y
local z1=Coordinate.z
local z2=Coordinate.z
local MaxVelocity=0
local AvgHeading=nil
local MovingCount=0
for StaticName,StaticData in pairs(self:GetSet())do
local Static=StaticData
local Coordinate=Static:GetCoordinate()
x1=(Coordinate.x<x1)and Coordinate.x or x1
x2=(Coordinate.x>x2)and Coordinate.x or x2
y1=(Coordinate.y<y1)and Coordinate.y or y1
y2=(Coordinate.y>y2)and Coordinate.y or y2
z1=(Coordinate.y<z1)and Coordinate.z or z1
z2=(Coordinate.y>z2)and Coordinate.z or z2
local Velocity=Coordinate:GetVelocity()
if Velocity~=0 then
MaxVelocity=(MaxVelocity<Velocity)and Velocity or MaxVelocity
local Heading=Coordinate:GetHeading()
AvgHeading=AvgHeading and(AvgHeading+Heading)or Heading
MovingCount=MovingCount+1
end
end
AvgHeading=AvgHeading and(AvgHeading/MovingCount)
Coordinate.x=(x2-x1)/2+x1
Coordinate.y=(y2-y1)/2+y1
Coordinate.z=(z2-z1)/2+z1
Coordinate:SetHeading(AvgHeading)
Coordinate:SetVelocity(MaxVelocity)
return Coordinate
end
function SET_STATIC:GetVelocity()
return 0
end
function SET_STATIC:GetHeading()
local HeadingSet=nil
local MovingCount=0
for StaticName,StaticData in pairs(self:GetSet())do
local Static=StaticData
local Coordinate=Static:GetCoordinate()
local Velocity=Coordinate:GetVelocity()
if Velocity~=0 then
local Heading=Coordinate:GetHeading()
if HeadingSet==nil then
HeadingSet=Heading
else
local HeadingDiff=(HeadingSet-Heading+180+360)%360-180
HeadingDiff=math.abs(HeadingDiff)
if HeadingDiff>5 then
HeadingSet=nil
break
end
end
end
end
return HeadingSet
end
function SET_STATIC:CalculateThreatLevelA2G()
local MaxThreatLevelA2G=0
local MaxThreatText=""
for StaticName,StaticData in pairs(self:GetSet())do
local ThreatStatic=StaticData
local ThreatLevelA2G,ThreatText=ThreatStatic:GetThreatLevel()
if ThreatLevelA2G>MaxThreatLevelA2G then
MaxThreatLevelA2G=ThreatLevelA2G
MaxThreatText=ThreatText
end
end
return MaxThreatLevelA2G,MaxThreatText
end
function SET_STATIC:IsIncludeObject(MStatic)
local MStaticInclude=true
if self.Filter.Coalitions then
local MStaticCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==MStatic:GetCoalition()then
MStaticCoalition=true
end
end
MStaticInclude=MStaticInclude and MStaticCoalition
end
if self.Filter.Categories then
local MStaticCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
if self.FilterMeta.Categories[CategoryName]and self.FilterMeta.Categories[CategoryName]==MStatic:GetDesc().category then
MStaticCategory=true
end
end
MStaticInclude=MStaticInclude and MStaticCategory
end
if self.Filter.Types then
local MStaticType=false
for TypeID,TypeName in pairs(self.Filter.Types)do
if TypeName==MStatic:GetTypeName()then
MStaticType=true
end
end
MStaticInclude=MStaticInclude and MStaticType
end
if self.Filter.Countries then
local MStaticCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
if country.id[CountryName]==MStatic:GetCountry()then
MStaticCountry=true
end
end
MStaticInclude=MStaticInclude and MStaticCountry
end
if self.Filter.StaticPrefixes then
local MStaticPrefix=false
for StaticPrefixId,StaticPrefix in pairs(self.Filter.StaticPrefixes)do
if string.find(MStatic:GetName(),StaticPrefix,1)then
MStaticPrefix=true
end
end
MStaticInclude=MStaticInclude and MStaticPrefix
end
if self.Filter.Zones then
local MStaticZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
if MStatic and MStatic:IsInZone(Zone)then
MStaticZone=true
end
end
MStaticInclude=MStaticInclude and MStaticZone
end
if self.Filter.Functions and MStaticInclude then
local MClientFunc=self:_EvalFilterFunctions(MStatic)
MStaticInclude=MStaticInclude and MClientFunc
end
return MStaticInclude
end
function SET_STATIC:GetTypeNames(Delimiter)
Delimiter=Delimiter or", "
local TypeReport=REPORT:New()
local Types={}
for StaticName,StaticData in pairs(self:GetSet())do
local Static=StaticData
local StaticTypeName=Static:GetTypeName()
if not Types[StaticTypeName]then
Types[StaticTypeName]=StaticTypeName
TypeReport:Add(StaticTypeName)
end
end
return TypeReport:Text(Delimiter)
end
function SET_STATIC:GetClosestStatic(Coordinate,Coalitions)
local Set=self:GetSet()
local dmin=math.huge
local gmin=nil
for GroupID,GroupData in pairs(Set)do
local group=GroupData
if group and group:IsAlive()and(Coalitions==nil or UTILS.IsAnyInTable(Coalitions,group:GetCoalition()))then
local coord=group:GetCoord()
local d=UTILS.VecDist3D(Coordinate,coord)
if d<dmin then
dmin=d
gmin=group
end
end
end
return gmin,dmin
end
end
do
SET_CLIENT={
ClassName="SET_CLIENT",
Clients={},
Filter={
Coalitions=nil,
Categories=nil,
Types=nil,
Countries=nil,
ClientPrefixes=nil,
Zones=nil,
Playernames=nil,
Callsigns=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
plane=Unit.Category.AIRPLANE,
helicopter=Unit.Category.HELICOPTER,
ground=Unit.Category.GROUND_UNIT,
ship=Unit.Category.SHIP,
structure=Unit.Category.STRUCTURE,
},
},
}
function SET_CLIENT:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.CLIENTS))
self:FilterActive(false)
return self
end
function SET_CLIENT:AddClientsByName(AddClientNames)
local AddClientNamesArray=(type(AddClientNames)=="table")and AddClientNames or{AddClientNames}
for AddClientID,AddClientName in pairs(AddClientNamesArray)do
self:Add(AddClientName,CLIENT:FindByName(AddClientName))
end
return self
end
function SET_CLIENT:RemoveClientsByName(RemoveClientNames)
local RemoveClientNamesArray=(type(RemoveClientNames)=="table")and RemoveClientNames or{RemoveClientNames}
for RemoveClientID,RemoveClientName in pairs(RemoveClientNamesArray)do
self:Remove(RemoveClientName.ClientName)
end
return self
end
function SET_CLIENT:FindClient(ClientName)
local ClientFound=self.Set[ClientName]
return ClientFound
end
function SET_CLIENT:FilterCallsigns(Callsigns)
if not self.Filter.Callsigns then
self.Filter.Callsigns={}
end
if type(Callsigns)~="table"then
Callsigns={Callsigns}
end
for callsignID,callsign in pairs(Callsigns)do
self.Filter.Callsigns[callsign]=callsign
end
return self
end
function SET_CLIENT:FilterPlayernames(Playernames)
if not self.Filter.Playernames then
self.Filter.Playernames={}
end
if type(Playernames)~="table"then
Playernames={Playernames}
end
for PlayernameID,playername in pairs(Playernames)do
self.Filter.Playernames[playername]=playername
end
return self
end
function SET_CLIENT:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_CLIENT:FilterCategories(Categories)
if not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_CLIENT:FilterTypes(Types)
if not self.Filter.Types then
self.Filter.Types={}
end
if type(Types)~="table"then
Types={Types}
end
for TypeID,Type in pairs(Types)do
self.Filter.Types[Type]=Type
end
return self
end
function SET_CLIENT:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_CLIENT:FilterPrefixes(Prefixes)
if not self.Filter.ClientPrefixes then
self.Filter.ClientPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.ClientPrefixes[Prefix]=Prefix
end
return self
end
function SET_CLIENT:FilterGroupPrefixes(Prefixes)
if type(Prefixes)=="string"then
Prefixes={Prefixes}
end
self:FilterFunction(
function(unit,prefixes)
local outcome=false
if unit then
local grp=unit:GetGroup()
local gname=grp~=nil and grp:GetName()or"none"
for _,_fix in pairs(prefixes or{})do
if string.find(gname,_fix)then
outcome=true
break
end
end
else
return false
end
return outcome
end,Prefixes
)
return self
end
function SET_CLIENT:FilterActive(Active)
Active=Active or not(Active==false)
self.Filter.Active=Active
return self
end
function SET_CLIENT:FilterAlive()
self:FilterFunction(
function(unit)
if unit and unit:IsExist()and unit:IsAlive()then
return true
else
return false
end
end
)
return self
end
function SET_CLIENT:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_CLIENT:_ContinousZoneFilter()
local Database=_DATABASE.CLIENTS
for ObjectName,Object in pairs(Database)do
if self:IsIncludeObject(Object)and self:IsNotInSet(Object)then
self:Add(ObjectName,Object)
elseif(not self:IsIncludeObject(Object))and self:IsInSet(Object)then
self:Remove(ObjectName)
end
end
return self
end
function SET_CLIENT:FilterZoneTimer(Seconds)
self.ZoneTimerInterval=Seconds or 30
return self
end
function SET_CLIENT:FilterStop()
if _DATABASE then
self:UnHandleEvent(EVENTS.Birth)
self:UnHandleEvent(EVENTS.Dead)
self:UnHandleEvent(EVENTS.Crash)
self:UnHandleEvent(EVENTS.PlayerLeaveUnit)
if self.Filter.Zones and self.ZoneTimer and self.ZoneTimer:IsRunning()then
self.ZoneTimer:Stop()
end
end
return self
end
function SET_CLIENT:FilterStart()
if _DATABASE then
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.PlayerLeaveUnit,self._EventPlayerLeaveUnit)
if self.Filter.Zones then
self.ZoneTimer=TIMER:New(self._ContinousZoneFilter,self)
local timing=self.ZoneTimerInterval or 30
self.ZoneTimer:Start(timing,timing)
end
self:_FilterStart()
end
return self
end
function SET_CLIENT:_EventPlayerEnterUnit(Event)
if Event.IniDCSUnit then
if Event.IniObjectCategory==Object.Category.UNIT and Event.IniGroup and Event.IniGroup:IsGround()then
local ObjectName,Object=self:AddInDatabase(Event)
if Object and self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
end
end
end
return self
end
function SET_CLIENT:_EventPlayerLeaveUnit(Event)
if Event.IniDCSUnit then
if Event.IniObjectCategory==Object.Category.UNIT and Event.IniGroup then
local ObjectName,Object=self:FindInDatabase(Event)
if ObjectName then
self:Remove(ObjectName)
end
end
end
return self
end
function SET_CLIENT:HandleCASlots()
self:HandleEvent(EVENTS.PlayerEnterUnit,SET_CLIENT._EventPlayerEnterUnit)
self:HandleEvent(EVENTS.PlayerLeaveUnit,SET_CLIENT._EventPlayerLeaveUnit)
self:FilterFunction(function(client)if client and client:IsAlive()and client:IsGround()then return true else return false end end)
return self
end
function SET_CLIENT:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_CLIENT:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_CLIENT:ForEachClient(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_CLIENT:ForEachClientInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,ClientObject)
if ClientObject:IsInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_CLIENT:ForEachClientNotInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,ClientObject)
if ClientObject:IsNotInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_CLIENT:CountAlive()
local Set=self:GetSet()
local CountU=0
for UnitID,UnitData in pairs(Set)do
if UnitData and UnitData:IsAlive()then
CountU=CountU+1
end
end
return CountU
end
function SET_CLIENT:GetAliveSet()
local AliveSet=SET_CLIENT:New()
for GroupName,GroupObject in pairs(self.Set)do
local GroupObject=GroupObject
if GroupObject and GroupObject:IsAlive()then
AliveSet:Add(GroupName,GroupObject)
end
end
return AliveSet.Set or{}
end
function SET_CLIENT:IsIncludeObject(MClient)
local MClientInclude=true
if MClient then
local MClientName=MClient.UnitName
if self.Filter.Active~=nil then
local MClientActive=false
if self.Filter.Active==false or(self.Filter.Active==true and MClient:IsActive()==true and MClient:IsAlive()==true)then
MClientActive=true
end
MClientInclude=MClientInclude and MClientActive
end
if self.Filter.Coalitions and MClientInclude then
local MClientCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
local ClientCoalitionID=_DATABASE:GetCoalitionFromClientTemplate(MClientName)
if ClientCoalitionID==nil and MClient:IsAlive()~=nil then
ClientCoalitionID=MClient:GetCoalition()
end
if self.FilterMeta.Coalitions[CoalitionName]and ClientCoalitionID and self.FilterMeta.Coalitions[CoalitionName]==ClientCoalitionID then
MClientCoalition=true
end
end
MClientInclude=MClientInclude and MClientCoalition
end
if self.Filter.Categories and MClientInclude then
local MClientCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
local ClientCategoryID=_DATABASE:GetCategoryFromClientTemplate(MClientName)
local UnitCategory=0
if ClientCategoryID==nil and MClient:IsExist()then
ClientCategoryID,UnitCategory=MClient:GetCategory()
if self.FilterMeta.Categories[CategoryName]and UnitCategory and self.FilterMeta.Categories[CategoryName]==UnitCategory then
MClientCategory=true
end
else
if self.FilterMeta.Categories[CategoryName]and ClientCategoryID and self.FilterMeta.Categories[CategoryName]==ClientCategoryID then
MClientCategory=true
end
end
end
MClientInclude=MClientInclude and MClientCategory
end
if self.Filter.Types and MClientInclude then
local MClientType=false
for TypeID,TypeName in pairs(self.Filter.Types)do
if TypeName==MClient:GetTypeName()then
MClientType=true
end
end
MClientInclude=MClientInclude and MClientType
end
if self.Filter.Countries and MClientInclude then
local MClientCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
local ClientCountryID=_DATABASE:GetCountryFromClientTemplate(MClientName)
if ClientCountryID==nil and MClient:IsAlive()~=nil then
ClientCountryID=MClient:GetCountry()
end
if country.id[CountryName]and ClientCountryID and country.id[CountryName]==ClientCountryID then
MClientCountry=true
end
end
MClientInclude=MClientInclude and MClientCountry
end
if self.Filter.ClientPrefixes and MClientInclude then
local MClientPrefix=false
for ClientPrefixId,ClientPrefix in pairs(self.Filter.ClientPrefixes)do
if string.find(MClient.UnitName,ClientPrefix,1)then
MClientPrefix=true
end
end
MClientInclude=MClientInclude and MClientPrefix
end
if self.Filter.Zones and MClientInclude then
local MClientZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
local unit=MClient:GetClientGroupUnit()
if unit and unit:IsInZone(Zone)then
MClientZone=true
end
end
MClientInclude=MClientInclude and MClientZone
end
if self.Filter.Playernames and MClientInclude then
local MClientPlayername=false
local playername=MClient:GetPlayerName()or"Unknown"
for _,_Playername in pairs(self.Filter.Playernames)do
if playername and string.find(playername,_Playername)then
MClientPlayername=true
end
end
MClientInclude=MClientInclude and MClientPlayername
end
if self.Filter.Callsigns and MClientInclude then
local MClientCallsigns=false
local callsign=MClient:GetCallsign()
for _,_Callsign in pairs(self.Filter.Callsigns)do
if callsign and string.find(callsign,_Callsign,1,true)then
MClientCallsigns=true
end
end
MClientInclude=MClientInclude and MClientCallsigns
end
if self.Filter.Functions and MClientInclude then
local MClientFunc=self:_EvalFilterFunctions(MClient)
MClientInclude=MClientInclude and MClientFunc
end
end
return MClientInclude
end
end
do
SET_PLAYER={
ClassName="SET_PLAYER",
Clients={},
Filter={
Coalitions=nil,
Categories=nil,
Types=nil,
Countries=nil,
ClientPrefixes=nil,
Zones=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
plane=Unit.Category.AIRPLANE,
helicopter=Unit.Category.HELICOPTER,
ground=Unit.Category.GROUND_UNIT,
ship=Unit.Category.SHIP,
structure=Unit.Category.STRUCTURE,
},
},
}
function SET_PLAYER:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.PLAYERS))
return self
end
function SET_PLAYER:AddClientsByName(AddClientNames)
local AddClientNamesArray=(type(AddClientNames)=="table")and AddClientNames or{AddClientNames}
for AddClientID,AddClientName in pairs(AddClientNamesArray)do
self:Add(AddClientName,CLIENT:FindByName(AddClientName))
end
return self
end
function SET_PLAYER:RemoveClientsByName(RemoveClientNames)
local RemoveClientNamesArray=(type(RemoveClientNames)=="table")and RemoveClientNames or{RemoveClientNames}
for RemoveClientID,RemoveClientName in pairs(RemoveClientNamesArray)do
self:Remove(RemoveClientName.ClientName)
end
return self
end
function SET_PLAYER:FindClient(PlayerName)
local ClientFound=self.Set[PlayerName]
return ClientFound
end
function SET_PLAYER:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_PLAYER:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_PLAYER:FilterCategories(Categories)
if not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_PLAYER:FilterTypes(Types)
if not self.Filter.Types then
self.Filter.Types={}
end
if type(Types)~="table"then
Types={Types}
end
for TypeID,Type in pairs(Types)do
self.Filter.Types[Type]=Type
end
return self
end
function SET_PLAYER:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_PLAYER:FilterPrefixes(Prefixes)
if not self.Filter.ClientPrefixes then
self.Filter.ClientPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.ClientPrefixes[Prefix]=Prefix
end
return self
end
function SET_PLAYER:FilterStart()
if _DATABASE then
self:_FilterStart()
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.PlayerLeaveUnit,self._EventOnDeadOrCrash)
end
return self
end
function SET_PLAYER:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_PLAYER:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_PLAYER:ForEachPlayer(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_PLAYER:ForEachPlayerInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,ClientObject)
if ClientObject:IsInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_PLAYER:ForEachPlayerNotInZone(ZoneObject,IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet(),
function(ZoneObject,ClientObject)
if ClientObject:IsNotInZone(ZoneObject)then
return true
else
return false
end
end,{ZoneObject})
return self
end
function SET_PLAYER:IsIncludeObject(MClient)
local MClientInclude=true
if MClient then
local MClientName=MClient.UnitName
if self.Filter.Coalitions and MClientInclude then
local MClientCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
local ClientCoalitionID=_DATABASE:GetCoalitionFromClientTemplate(MClientName)
if ClientCoalitionID==nil and MClient:IsAlive()~=nil then
ClientCoalitionID=MClient:GetCoalition()
end
if self.FilterMeta.Coalitions[CoalitionName]and ClientCoalitionID and self.FilterMeta.Coalitions[CoalitionName]==ClientCoalitionID then
MClientCoalition=true
end
end
MClientInclude=MClientInclude and MClientCoalition
end
if self.Filter.Categories and MClientInclude then
local MClientCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
local ClientCategoryID=_DATABASE:GetCategoryFromClientTemplate(MClientName)
local UnitCategory=0
if ClientCategoryID==nil and MClient:IsExist()then
ClientCategoryID,UnitCategory=MClient:GetCategory()
if self.FilterMeta.Categories[CategoryName]and UnitCategory and self.FilterMeta.Categories[CategoryName]==UnitCategory then
MClientCategory=true
end
else
if self.FilterMeta.Categories[CategoryName]and ClientCategoryID and self.FilterMeta.Categories[CategoryName]==ClientCategoryID then
MClientCategory=true
end
end
end
MClientInclude=MClientInclude and MClientCategory
end
if self.Filter.Types then
local MClientType=false
for TypeID,TypeName in pairs(self.Filter.Types)do
if TypeName==MClient:GetTypeName()then
MClientType=true
end
end
MClientInclude=MClientInclude and MClientType
end
if self.Filter.Countries then
local MClientCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
local ClientCountryID=_DATABASE:GetCountryFromClientTemplate(MClientName)
if country.id[CountryName]and country.id[CountryName]==ClientCountryID then
MClientCountry=true
end
end
MClientInclude=MClientInclude and MClientCountry
end
if self.Filter.ClientPrefixes then
local MClientPrefix=false
for ClientPrefixId,ClientPrefix in pairs(self.Filter.ClientPrefixes)do
if string.find(MClient.UnitName,ClientPrefix,1)then
MClientPrefix=true
end
end
MClientInclude=MClientInclude and MClientPrefix
end
end
if self.Filter.Zones then
local MClientZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
local unit=MClient:GetClientGroupUnit()
if unit and unit:IsInZone(Zone)then
MClientZone=true
end
end
MClientInclude=MClientInclude and MClientZone
end
if self.Filter.Functions and MClientInclude then
local MClientFunc=self:_EvalFilterFunctions(MClient)
MClientInclude=MClientInclude and MClientFunc
end
return MClientInclude
end
end
do
SET_AIRBASE={
ClassName="SET_AIRBASE",
Airbases={},
Filter={
Coalitions=nil,
Zones=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
airdrome=Airbase.Category.AIRDROME,
helipad=Airbase.Category.HELIPAD,
ship=Airbase.Category.SHIP,
},
},
}
function SET_AIRBASE:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.AIRBASES))
return self
end
function SET_AIRBASE:AddAirbase(airbase)
self:Add(airbase:GetName(),airbase)
return self
end
function SET_AIRBASE:AddAirbasesByName(AddAirbaseNames)
local AddAirbaseNamesArray=(type(AddAirbaseNames)=="table")and AddAirbaseNames or{AddAirbaseNames}
for AddAirbaseID,AddAirbaseName in pairs(AddAirbaseNamesArray)do
self:Add(AddAirbaseName,AIRBASE:FindByName(AddAirbaseName))
end
return self
end
function SET_AIRBASE:RemoveAirbasesByName(RemoveAirbaseNames)
local RemoveAirbaseNamesArray=(type(RemoveAirbaseNames)=="table")and RemoveAirbaseNames or{RemoveAirbaseNames}
for RemoveAirbaseID,RemoveAirbaseName in pairs(RemoveAirbaseNamesArray)do
self:Remove(RemoveAirbaseName)
end
return self
end
function SET_AIRBASE:FindAirbase(AirbaseName)
local AirbaseFound=self.Set[AirbaseName]
return AirbaseFound
end
function SET_AIRBASE:FindAirbaseInRange(Coordinate,Range)
local AirbaseFound=nil
for AirbaseName,AirbaseObject in pairs(self.Set)do
local AirbaseCoordinate=AirbaseObject:GetCoordinate()
local Distance=Coordinate:Get2DDistance(AirbaseCoordinate)
if Distance<=Range then
AirbaseFound=AirbaseObject
break
end
end
return AirbaseFound
end
function SET_AIRBASE:GetRandomAirbase()
local RandomAirbase=self:GetRandom()
return RandomAirbase
end
function SET_AIRBASE:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_AIRBASE:FilterCategories(Categories)
if not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_AIRBASE:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_AIRBASE:FilterStart()
if _DATABASE then
self:HandleEvent(EVENTS.BaseCaptured)
self:HandleEvent(EVENTS.Dead)
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:RemoveAirbasesByName(ObjectName)
end
end
end
return self
end
function SET_AIRBASE:OnEventBaseCaptured(EventData)
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:RemoveAirbasesByName(ObjectName)
end
end
end
function SET_AIRBASE:OnEventDead(EventData)
local airbaseName,airbase=self:FindInDatabase(EventData)
if airbase and(airbase:IsShip()or airbase:IsHelipad())then
self:RemoveAirbasesByName(airbaseName)
end
end
function SET_AIRBASE:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_AIRBASE:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_AIRBASE:ForEachAirbase(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_AIRBASE:FindNearestAirbaseFromPointVec2(Coordinate)
local NearestAirbase=self:FindNearestObjectFromPointVec2(Coordinate)
return NearestAirbase
end
function SET_AIRBASE:IsIncludeObject(MAirbase)
local MAirbaseInclude=true
if MAirbase then
local MAirbaseName=MAirbase:GetName()
if self.Filter.Coalitions then
local MAirbaseCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
local AirbaseCoalitionID=_DATABASE:GetCoalitionFromAirbase(MAirbaseName)
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==AirbaseCoalitionID then
MAirbaseCoalition=true
end
end
MAirbaseInclude=MAirbaseInclude and MAirbaseCoalition
end
if self.Filter.Categories and MAirbaseInclude then
local MAirbaseCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
local AirbaseCategoryID=_DATABASE:GetCategoryFromAirbase(MAirbaseName)
if self.FilterMeta.Categories[CategoryName]and self.FilterMeta.Categories[CategoryName]==AirbaseCategoryID then
MAirbaseCategory=true
end
end
MAirbaseInclude=MAirbaseInclude and MAirbaseCategory
end
if self.Filter.Zones and MAirbaseInclude then
local MAirbaseZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
local coord=MAirbase:GetCoordinate()
if coord and Zone:IsCoordinateInZone(coord)then
MAirbaseZone=true
end
end
MAirbaseInclude=MAirbaseInclude and MAirbaseZone
end
end
if self.Filter.Functions and MAirbaseInclude then
local MClientFunc=self:_EvalFilterFunctions(MAirbase)
MAirbaseInclude=MAirbaseInclude and MClientFunc
end
return MAirbaseInclude
end
end
do
SET_CARGO={
ClassName="SET_CARGO",
Cargos={},
Filter={
Coalitions=nil,
Types=nil,
Countries=nil,
ClientPrefixes=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
},
}
function SET_CARGO:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.CARGOS))
return self
end
function SET_CARGO:AddCargo(Cargo)
self:Add(Cargo:GetName(),Cargo)
return self
end
function SET_CARGO:AddCargosByName(AddCargoNames)
local AddCargoNamesArray=(type(AddCargoNames)=="table")and AddCargoNames or{AddCargoNames}
for AddCargoID,AddCargoName in pairs(AddCargoNamesArray)do
self:Add(AddCargoName,CARGO:FindByName(AddCargoName))
end
return self
end
function SET_CARGO:RemoveCargosByName(RemoveCargoNames)
local RemoveCargoNamesArray=(type(RemoveCargoNames)=="table")and RemoveCargoNames or{RemoveCargoNames}
for RemoveCargoID,RemoveCargoName in pairs(RemoveCargoNamesArray)do
self:Remove(RemoveCargoName.CargoName)
end
return self
end
function SET_CARGO:FindCargo(CargoName)
local CargoFound=self.Set[CargoName]
return CargoFound
end
function SET_CARGO:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_CARGO:FilterTypes(Types)
if not self.Filter.Types then
self.Filter.Types={}
end
if type(Types)~="table"then
Types={Types}
end
for TypeID,Type in pairs(Types)do
self.Filter.Types[Type]=Type
end
return self
end
function SET_CARGO:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_CARGO:FilterPrefixes(Prefixes)
if not self.Filter.CargoPrefixes then
self.Filter.CargoPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.CargoPrefixes[Prefix]=Prefix
end
return self
end
function SET_CARGO:FilterStart()
if _DATABASE then
self:_FilterStart()
self:HandleEvent(EVENTS.NewCargo)
self:HandleEvent(EVENTS.DeleteCargo)
end
return self
end
function SET_CARGO:FilterStop()
self:UnHandleEvent(EVENTS.NewCargo)
self:UnHandleEvent(EVENTS.DeleteCargo)
return self
end
function SET_CARGO:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_CARGO:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_CARGO:ForEachCargo(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_CARGO:FindNearestCargoFromPointVec2(Coordinate)
local NearestCargo=self:FindNearestObjectFromPointVec2(Coordinate)
return NearestCargo
end
function SET_CARGO:FirstCargoWithState(State)
local FirstCargo=nil
for CargoName,Cargo in pairs(self.Set)do
if Cargo:Is(State)then
FirstCargo=Cargo
break
end
end
return FirstCargo
end
function SET_CARGO:FirstCargoWithStateAndNotDeployed(State)
local FirstCargo=nil
for CargoName,Cargo in pairs(self.Set)do
if Cargo:Is(State)and not Cargo:IsDeployed()then
FirstCargo=Cargo
break
end
end
return FirstCargo
end
function SET_CARGO:FirstCargoUnLoaded()
local FirstCargo=self:FirstCargoWithState("UnLoaded")
return FirstCargo
end
function SET_CARGO:FirstCargoUnLoadedAndNotDeployed()
local FirstCargo=self:FirstCargoWithStateAndNotDeployed("UnLoaded")
return FirstCargo
end
function SET_CARGO:FirstCargoLoaded()
local FirstCargo=self:FirstCargoWithState("Loaded")
return FirstCargo
end
function SET_CARGO:FirstCargoDeployed()
local FirstCargo=self:FirstCargoWithState("Deployed")
return FirstCargo
end
function SET_CARGO:IsIncludeObject(MCargo)
local MCargoInclude=true
if MCargo then
local MCargoName=MCargo:GetName()
if self.Filter.Coalitions then
local MCargoCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
local CargoCoalitionID=MCargo:GetCoalition()
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==CargoCoalitionID then
MCargoCoalition=true
end
end
MCargoInclude=MCargoInclude and MCargoCoalition
end
if self.Filter.Types then
local MCargoType=false
for TypeID,TypeName in pairs(self.Filter.Types)do
if TypeName==MCargo:GetType()then
MCargoType=true
end
end
MCargoInclude=MCargoInclude and MCargoType
end
if self.Filter.CargoPrefixes then
local MCargoPrefix=false
for CargoPrefixId,CargoPrefix in pairs(self.Filter.CargoPrefixes)do
if string.find(MCargo.Name,CargoPrefix,1)then
MCargoPrefix=true
end
end
MCargoInclude=MCargoInclude and MCargoPrefix
end
end
if self.Filter.Functions and MCargoInclude then
local MClientFunc=self:_EvalFilterFunctions(MCargo)
MCargoInclude=MCargoInclude and MClientFunc
end
return MCargoInclude
end
function SET_CARGO:OnEventNewCargo(EventData)
if EventData.Cargo then
if EventData.Cargo and self:IsIncludeObject(EventData.Cargo)then
self:Add(EventData.Cargo.Name,EventData.Cargo)
end
end
end
function SET_CARGO:OnEventDeleteCargo(EventData)
if EventData.Cargo then
local Cargo=_DATABASE:FindCargo(EventData.Cargo.Name)
if Cargo and Cargo.Name then
if Cargo.NoDestroy then
else
self:Remove(Cargo.Name)
end
end
end
end
end
do
SET_ZONE={
ClassName="SET_ZONE",
Zones={},
Filter={
Prefixes=nil,
},
FilterMeta={
},
Checktime=5,
}
function SET_ZONE:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.ZONES))
return self
end
function SET_ZONE:AddZonesByName(AddZoneNames)
local AddZoneNamesArray=(type(AddZoneNames)=="table")and AddZoneNames or{AddZoneNames}
for AddAirbaseID,AddZoneName in pairs(AddZoneNamesArray)do
self:Add(AddZoneName,ZONE:FindByName(AddZoneName))
end
return self
end
function SET_ZONE:AddZone(Zone)
self:Add(Zone:GetName(),Zone)
return self
end
function SET_ZONE:RemoveZonesByName(RemoveZoneNames)
local RemoveZoneNamesArray=(type(RemoveZoneNames)=="table")and RemoveZoneNames or{RemoveZoneNames}
for RemoveZoneID,RemoveZoneName in pairs(RemoveZoneNamesArray)do
self:Remove(RemoveZoneName)
end
return self
end
function SET_ZONE:FindZone(ZoneName)
local ZoneFound=self.Set[ZoneName]
return ZoneFound
end
function SET_ZONE:GetRandomZone(margin)
local margin=margin or 100
if self:Count()~=0 then
local Index=self.Index
local ZoneFound=nil
local counter=0
while(not ZoneFound)or(counter<margin)do
local ZoneRandom=math.random(1,#Index)
ZoneFound=self.Set[Index[ZoneRandom]]:GetZoneMaybe()
counter=counter+1
end
return ZoneFound
end
return nil
end
function SET_ZONE:SetZoneProbability(ZoneName,ZoneProbability)
local Zone=self:FindZone(ZoneName)
Zone:SetZoneProbability(ZoneProbability)
end
function SET_ZONE:FilterPrefixes(Prefixes)
if not self.Filter.Prefixes then
self.Filter.Prefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.Prefixes[Prefix]=Prefix
end
return self
end
function SET_ZONE:FilterStart()
if _DATABASE then
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:RemoveZonesByName(ObjectName)
end
end
end
self:HandleEvent(EVENTS.NewZone)
self:HandleEvent(EVENTS.DeleteZone)
return self
end
function SET_ZONE:FilterStop()
self:UnHandleEvent(EVENTS.NewZone)
self:UnHandleEvent(EVENTS.DeleteZone)
return self
end
function SET_ZONE:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_ZONE:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_ZONE:ForEachZone(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_ZONE:DrawZone(Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly)
for _,_zone in pairs(self.Set)do
local zone=_zone
zone:DrawZone(Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly)
end
return self
end
function SET_ZONE:GetAverageCoordinate()
local x,y,z=0,0,0
local count=0
for _,_zone in pairs(self.Set)do
local zone=_zone
local vec3=zone:GetVec3()
x=x+vec3.x
y=y+vec3.y
z=z+vec3.z
count=count+1
end
if count>1 then
x=x/count
y=y/count
z=z/count
end
local coord=COORDINATE:New(x,y,z)
return coord
end
function SET_ZONE:IsIncludeObject(MZone)
local MZoneInclude=true
if MZone then
local MZoneName=MZone:GetName()
if self.Filter.Prefixes then
local MZonePrefix=false
for ZonePrefixId,ZonePrefix in pairs(self.Filter.Prefixes)do
if string.find(MZoneName,ZonePrefix,1)then
MZonePrefix=true
end
end
MZoneInclude=MZoneInclude and MZonePrefix
end
end
if self.Filter.Functions and MZoneInclude then
local MClientFunc=self:_EvalFilterFunctions(MZone)
MZoneInclude=MZoneInclude and MClientFunc
end
return MZoneInclude
end
function SET_ZONE:OnEventNewZone(EventData)
if EventData.Zone then
if EventData.Zone and self:IsIncludeObject(EventData.Zone)then
self:Add(EventData.Zone.ZoneName,EventData.Zone)
end
end
end
function SET_ZONE:OnEventDeleteZone(EventData)
if EventData.Zone then
local Zone=_DATABASE:FindZone(EventData.Zone.ZoneName)
if Zone and Zone.ZoneName then
if Zone.NoDestroy then
else
self:Remove(Zone.ZoneName)
end
end
end
end
function SET_ZONE:IsCoordinateInZone(Coordinate)
for _,Zone in pairs(self:GetSet())do
local Zone=Zone
if Zone:IsCoordinateInZone(Coordinate)then
return Zone
end
end
return nil
end
function SET_ZONE:GetClosestZone(Coordinate)
local dmin=math.huge
local zmin=nil
for _,Zone in pairs(self:GetSet())do
local Zone=Zone
local d=Zone:Get2DDistance(Coordinate)
if d<dmin then
dmin=d
zmin=Zone
end
end
return zmin,dmin
end
function SET_ZONE:SetCheckTime(seconds)
self.Checktime=seconds or 5
return self
end
function SET_ZONE:Trigger(Objects)
self:AddTransition("*","TriggerStart","TriggerRunning")
self:AddTransition("*","EnteredZone","*")
self:AddTransition("*","LeftZone","*")
self:AddTransition("*","TriggerRunCheck","*")
self:AddTransition("*","TriggerStop","TriggerStopped")
self:TriggerStart()
self.checkobjects=Objects
if UTILS.IsInstanceOf(Objects,"SET_BASE")then
self.objectset=Objects.Set
else
self.objectset={Objects}
end
self:_TriggerCheck(true)
self:__TriggerRunCheck(self.Checktime)
return self
end
function SET_ZONE:_TriggerCheck(fromstart)
if fromstart then
for _,_object in pairs(self.objectset)do
local obj=_object
if obj and obj:IsAlive()then
for _,_zone in pairs(self.Set)do
if not obj.TriggerInZone then obj.TriggerInZone={}end
if _zone:IsCoordinateInZone(obj:GetCoordinate())then
obj.TriggerInZone[_zone.ZoneName]=true
else
obj.TriggerInZone[_zone.ZoneName]=false
end
end
end
end
else
for _,_object in pairs(self.objectset)do
local obj=_object
if obj and obj:IsAlive()then
for _,_zone in pairs(self.Set)do
if not obj.TriggerInZone then
obj.TriggerInZone={}
end
if not obj.TriggerInZone[_zone.ZoneName]then
obj.TriggerInZone[_zone.ZoneName]=false
end
local inzone=_zone:IsCoordinateInZone(obj:GetCoordinate())
if inzone and not obj.TriggerInZone[_zone.ZoneName]then
self:__EnteredZone(0.5,obj,_zone)
obj.TriggerInZone[_zone.ZoneName]=true
elseif(not inzone)and obj.TriggerInZone[_zone.ZoneName]then
self:__LeftZone(0.5,obj,_zone)
obj.TriggerInZone[_zone.ZoneName]=false
else
end
end
end
end
end
return self
end
function SET_ZONE:onafterTriggerRunCheck(From,Event,To)
if self:GetState()~="TriggerStopped"then
self:_TriggerCheck()
self:__TriggerRunCheck(self.Checktime)
end
return self
end
end
do
SET_ZONE_GOAL={
ClassName="SET_ZONE_GOAL",
Zones={},
Filter={
Prefixes=nil,
},
FilterMeta={
},
}
function SET_ZONE_GOAL:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.ZONES_GOAL))
return self
end
function SET_ZONE_GOAL:AddZone(Zone)
self:Add(Zone:GetName(),Zone)
return self
end
function SET_ZONE_GOAL:RemoveZonesByName(RemoveZoneNames)
local RemoveZoneNamesArray=(type(RemoveZoneNames)=="table")and RemoveZoneNames or{RemoveZoneNames}
for RemoveZoneID,RemoveZoneName in pairs(RemoveZoneNamesArray)do
self:Remove(RemoveZoneName)
end
return self
end
function SET_ZONE_GOAL:FindZone(ZoneName)
local ZoneFound=self.Set[ZoneName]
return ZoneFound
end
function SET_ZONE_GOAL:GetRandomZone()
if self:Count()~=0 then
local Index=self.Index
local ZoneFound=nil
while not ZoneFound do
local ZoneRandom=math.random(1,#Index)
ZoneFound=self.Set[Index[ZoneRandom]]:GetZoneMaybe()
end
return ZoneFound
end
return nil
end
function SET_ZONE_GOAL:SetZoneProbability(ZoneName,ZoneProbability)
local Zone=self:FindZone(ZoneName)
Zone:SetZoneProbability(ZoneProbability)
end
function SET_ZONE_GOAL:FilterPrefixes(Prefixes)
if not self.Filter.Prefixes then
self.Filter.Prefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.Prefixes[Prefix]=Prefix
end
return self
end
function SET_ZONE_GOAL:FilterStart()
if _DATABASE then
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:RemoveZonesByName(ObjectName)
end
end
end
self:HandleEvent(EVENTS.NewZoneGoal)
self:HandleEvent(EVENTS.DeleteZoneGoal)
return self
end
function SET_ZONE_GOAL:FilterStop()
self:UnHandleEvent(EVENTS.NewZoneGoal)
self:UnHandleEvent(EVENTS.DeleteZoneGoal)
return self
end
function SET_ZONE_GOAL:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_ZONE_GOAL:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_ZONE_GOAL:ForEachZone(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_ZONE_GOAL:IsIncludeObject(MZone)
local MZoneInclude=true
if MZone then
local MZoneName=MZone:GetName()
if self.Filter.Prefixes then
local MZonePrefix=false
for ZonePrefixId,ZonePrefix in pairs(self.Filter.Prefixes)do
if string.find(MZoneName,ZonePrefix,1)then
MZonePrefix=true
end
end
MZoneInclude=MZoneInclude and MZonePrefix
end
end
if self.Filter.Functions and MZoneInclude then
local MClientFunc=self:_EvalFilterFunctions(MZone)
MZoneInclude=MZoneInclude and MClientFunc
end
return MZoneInclude
end
function SET_ZONE_GOAL:OnEventNewZoneGoal(EventData)
if EventData.ZoneGoal then
if EventData.ZoneGoal and self:IsIncludeObject(EventData.ZoneGoal)then
self:Add(EventData.ZoneGoal.ZoneName,EventData.ZoneGoal)
end
end
end
function SET_ZONE_GOAL:OnEventDeleteZoneGoal(EventData)
if EventData.ZoneGoal then
local Zone=_DATABASE:FindZone(EventData.ZoneGoal.ZoneName)
if Zone and Zone.ZoneName then
if Zone.NoDestroy then
else
self:Remove(Zone.ZoneName)
end
end
end
end
function SET_ZONE_GOAL:IsCoordinateInZone(Coordinate)
for _,Zone in pairs(self:GetSet())do
local Zone=Zone
if Zone:IsCoordinateInZone(Coordinate)then
return Zone
end
end
return nil
end
end
do
SET_OPSZONE={
ClassName="SET_OPSZONE",
Zones={},
Filter={
Prefixes=nil,
Coalitions=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
},
}
function SET_OPSZONE:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.OPSZONES))
return self
end
function SET_OPSZONE:AddZone(Zone)
self:Add(Zone:GetName(),Zone)
return self
end
function SET_OPSZONE:RemoveZonesByName(RemoveZoneNames)
local RemoveZoneNamesArray=(type(RemoveZoneNames)=="table")and RemoveZoneNames or{RemoveZoneNames}
for RemoveZoneID,RemoveZoneName in pairs(RemoveZoneNamesArray)do
self:Remove(RemoveZoneName)
end
return self
end
function SET_OPSZONE:FindZone(ZoneName)
local ZoneFound=self.Set[ZoneName]
return ZoneFound
end
function SET_OPSZONE:GetRandomZone()
if self:Count()~=0 then
local Index=self.Index
local ZoneFound=nil
while not ZoneFound do
local ZoneRandom=math.random(1,#Index)
ZoneFound=self.Set[Index[ZoneRandom]]:GetZoneMaybe()
end
return ZoneFound
end
return nil
end
function SET_OPSZONE:SetZoneProbability(ZoneName,Probability)
local Zone=self:FindZone(ZoneName)
Zone:SetZoneProbability(Probability)
return self
end
function SET_OPSZONE:FilterPrefixes(Prefixes)
if not self.Filter.Prefixes then
self.Filter.Prefixes={}
end
Prefixes=UTILS.EnsureTable(Prefixes,false)
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.Prefixes[Prefix]=Prefix
end
return self
end
function SET_OPSZONE:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
Coalitions=UTILS.EnsureTable(Coalitions,false)
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_OPSZONE:FilterOnce()
for ObjectName,Object in pairs(self.Database)do
self:Remove(ObjectName,true)
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
end
end
return self
end
function SET_OPSZONE:FilterClear()
local parent=self:GetParent(self,SET_OPSZONE)
parent:FilterClear()
return self
end
function SET_OPSZONE:FilterStart()
if _DATABASE then
for ObjectName,Object in pairs(self.Database)do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:RemoveZonesByName(ObjectName)
end
end
end
self:HandleEvent(EVENTS.NewZoneGoal)
self:HandleEvent(EVENTS.DeleteZoneGoal)
return self
end
function SET_OPSZONE:FilterStop()
self:UnHandleEvent(EVENTS.NewZoneGoal)
self:UnHandleEvent(EVENTS.DeleteZoneGoal)
return self
end
function SET_OPSZONE:AddInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_OPSZONE:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Database[Event.IniDCSUnitName]
end
function SET_OPSZONE:ForEachZone(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_OPSZONE:IsIncludeObject(MZone)
local MZoneInclude=true
if MZone then
local MZoneName=MZone:GetName()
if self.Filter.Prefixes then
local MZonePrefix=false
for ZonePrefixId,ZonePrefix in pairs(self.Filter.Prefixes)do
if string.find(MZoneName,ZonePrefix,1)then
MZonePrefix=true
break
end
end
MZoneInclude=MZoneInclude and MZonePrefix
end
if self.Filter.Coalitions then
local MGroupCoalition=false
local coalition=MZone:GetOwner()
for _,CoalitionName in pairs(self.Filter.Coalitions)do
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==coalition then
MGroupCoalition=true
break
end
end
MZoneInclude=MZoneInclude and MGroupCoalition
end
end
if self.Filter.Functions and MZoneInclude then
local MClientFunc=self:_EvalFilterFunctions(MZone)
MZoneInclude=MZoneInclude and MClientFunc
end
return MZoneInclude
end
function SET_OPSZONE:OnEventNewZoneGoal(EventData)
if EventData.ZoneGoal then
if EventData.ZoneGoal and self:IsIncludeObject(EventData.ZoneGoal)then
self:Add(EventData.ZoneGoal.ZoneName,EventData.ZoneGoal)
end
end
end
function SET_OPSZONE:OnEventDeleteZoneGoal(EventData)
if EventData.ZoneGoal then
local Zone=_DATABASE:FindZone(EventData.ZoneGoal.ZoneName)
if Zone and Zone.ZoneName then
if Zone.NoDestroy then
else
self:Remove(Zone.ZoneName)
end
end
end
end
function SET_OPSZONE:Start()
for _,_Zone in pairs(self:GetSet())do
local Zone=_Zone
if Zone:IsStopped()then
Zone:Start()
end
end
return self
end
function SET_OPSZONE:IsCoordinateInZone(Coordinate)
for _,_Zone in pairs(self:GetSet())do
local Zone=_Zone
if Zone:GetZone():IsCoordinateInZone(Coordinate)then
return Zone
end
end
return nil
end
function SET_OPSZONE:GetClosestZone(Coordinate,Coalitions)
Coalitions=UTILS.EnsureTable(Coalitions,true)
local dmin=math.huge
local zmin=nil
for _,_opszone in pairs(self:GetSet())do
local opszone=_opszone
local coal=opszone:GetOwner()
if opszone:IsStarted()and(Coalitions==nil or(Coalitions and UTILS.IsInTable(Coalitions,coal)))then
local d=opszone:GetZone():Get2DDistance(Coordinate)
if d<dmin then
dmin=d
zmin=opszone
end
end
end
return zmin,dmin
end
end
do
SET_OPSGROUP={
ClassName="SET_OPSGROUP",
Filter={
Coalitions=nil,
Categories=nil,
Countries=nil,
GroupPrefixes=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
},
Categories={
plane=Group.Category.AIRPLANE,
helicopter=Group.Category.HELICOPTER,
ground=Group.Category.GROUND,
ship=Group.Category.SHIP,
},
},
}
function SET_OPSGROUP:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.GROUPS))
self:FilterActive(false)
return self
end
function SET_OPSGROUP:GetAliveSet()
local AliveSet=SET_OPSGROUP:New()
for GroupName,GroupObject in pairs(self.Set)do
local GroupObject=GroupObject
if GroupObject and GroupObject:IsAlive()then
AliveSet:Add(GroupName,GroupObject)
end
end
return AliveSet.Set or{}
end
function SET_OPSGROUP:Add(ObjectName,Object)
if self.Set[ObjectName]then
self:Remove(ObjectName,true)
end
local object=nil
if Object:IsInstanceOf("GROUP")then
object=_DATABASE:FindOpsGroup(ObjectName)
if not object then
if Object:IsShip()then
object=NAVYGROUP:New(Object)
elseif Object:IsGround()then
object=ARMYGROUP:New(Object)
elseif Object:IsAir()then
object=FLIGHTGROUP:New(Object)
else
env.error("ERROR: Unknown category of group object!")
end
end
elseif Object:IsInstanceOf("OPSGROUP")then
object=Object
else
env.error("ERROR: Object must be a GROUP or OPSGROUP!")
end
self.Set[ObjectName]=object
table.insert(self.Index,ObjectName)
self:Added(ObjectName,object)
end
function SET_OPSGROUP:AddObject(Object)
self:Add(Object.groupname,Object)
end
function SET_OPSGROUP:AddGroup(group)
local groupname=group:GetName()
self:Add(groupname,group)
return self
end
function SET_OPSGROUP:AddGroupsByName(AddGroupNames)
local AddGroupNamesArray=(type(AddGroupNames)=="table")and AddGroupNames or{AddGroupNames}
for AddGroupID,AddGroupName in pairs(AddGroupNamesArray)do
self:Add(AddGroupName,GROUP:FindByName(AddGroupName))
end
return self
end
function SET_OPSGROUP:RemoveGroupsByName(RemoveGroupNames)
local RemoveGroupNamesArray=(type(RemoveGroupNames)=="table")and RemoveGroupNames or{RemoveGroupNames}
for RemoveGroupID,RemoveGroupName in pairs(RemoveGroupNamesArray)do
self:Remove(RemoveGroupName)
end
return self
end
function SET_OPSGROUP:FindGroup(GroupName)
local GroupFound=self.Set[GroupName]
return GroupFound
end
function SET_OPSGROUP:FindFlightGroup(GroupName)
local GroupFound=self:FindGroup(GroupName)
return GroupFound
end
function SET_OPSGROUP:FindArmyGroup(GroupName)
local GroupFound=self:FindGroup(GroupName)
return GroupFound
end
function SET_OPSGROUP:FindNavyGroup(GroupName)
local GroupFound=self:FindGroup(GroupName)
return GroupFound
end
function SET_OPSGROUP:FilterCoalitions(Coalitions,Clear)
if Clear or not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_OPSGROUP:FilterCategories(Categories,Clear)
if Clear or not self.Filter.Categories then
self.Filter.Categories={}
end
if type(Categories)~="table"then
Categories={Categories}
end
for CategoryID,Category in pairs(Categories)do
self.Filter.Categories[Category]=Category
end
return self
end
function SET_OPSGROUP:FilterCategoryGround()
self:FilterCategories("ground")
return self
end
function SET_OPSGROUP:FilterCategoryAirplane()
self:FilterCategories("plane")
return self
end
function SET_OPSGROUP:FilterCategoryAircraft()
self:FilterCategories({"plane","helicopter"})
return self
end
function SET_OPSGROUP:FilterCategoryHelicopter()
self:FilterCategories("helicopter")
return self
end
function SET_OPSGROUP:FilterCategoryShip()
self:FilterCategories("ship")
return self
end
function SET_OPSGROUP:FilterCountries(Countries,Clear)
if Clear or not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_OPSGROUP:FilterPrefixes(Prefixes,Clear)
if Clear or not self.Filter.GroupPrefixes then
self.Filter.GroupPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.GroupPrefixes[Prefix]=Prefix
end
return self
end
function SET_OPSGROUP:FilterActive(Active)
Active=Active or not(Active==false)
self.Filter.Active=Active
return self
end
function SET_OPSGROUP:FilterStart()
if _DATABASE then
self:_FilterStart()
self:HandleEvent(EVENTS.Birth,self._EventOnBirth)
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.RemoveUnit,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._EventOnDeadOrCrash)
end
return self
end
function SET_OPSGROUP:Activate(Delay)
local Set=self:GetSet()
for GroupID,GroupData in pairs(Set)do
local group=GroupData
if group and group:IsAlive()==false then
group:Activate(Delay)
end
end
return self
end
function SET_OPSGROUP:_EventOnBirth(Event)
if Event.IniDCSUnit and Event.IniDCSGroup then
local DCSgroup=Event.IniDCSGroup
local CountAliveActive=0
for index,data in pairs(DCSgroup:getUnits())do
if data:isExist()and data:isActive()then
CountAliveActive=CountAliveActive+1
end
end
if DCSgroup:getInitialSize()==DCSgroup:getSize()then
local groupname,group=self:AddInDatabase(Event)
if group and CountAliveActive==DCSgroup:getInitialSize()then
if group and self:IsIncludeObject(group)then
self:Add(groupname,group)
end
end
end
end
end
function SET_OPSGROUP:_EventOnDeadOrCrash(Event)
if Event.IniDCSGroup then
local ObjectName,Object=self:FindInDatabase(Event)
if ObjectName then
if Event.IniDCSGroup:getSize()==1 then
self:Remove(ObjectName)
end
end
end
end
function SET_OPSGROUP:AddInDatabase(Event)
if Event.IniObjectCategory==Object.Category.UNIT then
if not self.Database[Event.IniDCSGroupName]then
self.Database[Event.IniDCSGroupName]=GROUP:Register(Event.IniDCSGroupName)
end
end
return Event.IniDCSGroupName,self.Database[Event.IniDCSGroupName]
end
function SET_OPSGROUP:FindInDatabase(Event)
return Event.IniDCSGroupName,self.Database[Event.IniDCSGroupName]
end
function SET_OPSGROUP:ForEachGroup(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_OPSGROUP:IsIncludeObject(MGroup)
local MGroupInclude=true
if self.Filter.Active~=nil then
local MGroupActive=false
if self.Filter.Active==false or(self.Filter.Active==true and MGroup:IsActive()==true)then
MGroupActive=true
end
MGroupInclude=MGroupInclude and MGroupActive
end
if self.Filter.Coalitions and MGroupInclude then
local MGroupCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==MGroup:GetCoalition()then
MGroupCoalition=true
end
end
MGroupInclude=MGroupInclude and MGroupCoalition
end
if self.Filter.Categories and MGroupInclude then
local MGroupCategory=false
for CategoryID,CategoryName in pairs(self.Filter.Categories)do
if self.FilterMeta.Categories[CategoryName]and self.FilterMeta.Categories[CategoryName]==MGroup:GetCategory()then
MGroupCategory=true
end
end
MGroupInclude=MGroupInclude and MGroupCategory
end
if self.Filter.Countries and MGroupInclude then
local MGroupCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
if country.id[CountryName]==MGroup:GetCountry()then
MGroupCountry=true
end
end
MGroupInclude=MGroupInclude and MGroupCountry
end
if self.Filter.GroupPrefixes and MGroupInclude then
local MGroupPrefix=false
for GroupPrefixId,GroupPrefix in pairs(self.Filter.GroupPrefixes)do
if string.find(MGroup:GetName(),GroupPrefix:gsub("-","%%-"),1)then
MGroupPrefix=true
end
end
MGroupInclude=MGroupInclude and MGroupPrefix
end
if self.Filter.Functions and MGroupInclude then
local MClientFunc=self:_EvalFilterFunctions(MGroup)
MGroupInclude=MGroupInclude and MClientFunc
end
return MGroupInclude
end
end
do
SET_SCENERY={
ClassName="SET_SCENERY",
Scenerys={},
Filter={
SceneryPrefixes=nil,
SceneryRoles=nil,
Zones=nil,
},
}
function SET_SCENERY:New(ZoneSet)
local zoneset={}
local self=BASE:Inherit(self,SET_BASE:New(zoneset))
local zonenames={}
if ZoneSet then
for _,_zone in pairs(ZoneSet.Set)do
table.insert(zonenames,_zone:GetName())
end
self:AddSceneryByName(zonenames)
end
return self
end
function SET_SCENERY:NewFromZone(Zone)
local zone=Zone
if type(Zone)=="string"then
zone=ZONE:FindByName(Zone)
end
zone:Scan({Object.Category.SCENERY})
return zone:GetScannedSetScenery()
end
function SET_SCENERY:AddScenery(AddScenery)
self:Add(AddScenery:GetName(),AddScenery)
return self
end
function SET_SCENERY:AddSceneryByName(AddSceneryNames)
local AddSceneryNamesArray=(type(AddSceneryNames)=="table")and AddSceneryNames or{AddSceneryNames}
for AddSceneryID,AddSceneryName in pairs(AddSceneryNamesArray)do
self:Add(AddSceneryName,SCENERY:FindByZoneName(AddSceneryName))
end
return self
end
function SET_SCENERY:RemoveSceneryByName(RemoveSceneryNames)
local RemoveSceneryNamesArray=(type(RemoveSceneryNames)=="table")and RemoveSceneryNames or{RemoveSceneryNames}
for RemoveSceneryID,RemoveSceneryName in pairs(RemoveSceneryNamesArray)do
self:Remove(RemoveSceneryName)
end
return self
end
function SET_SCENERY:FindScenery(SceneryName)
local SceneryFound=self.Set[SceneryName]
return SceneryFound
end
function SET_SCENERY:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_SCENERY:FilterPrefixes(Prefixes)
if not self.Filter.SceneryPrefixes then
self.Filter.SceneryPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.SceneryPrefixes[Prefix]=Prefix
end
return self
end
function SET_SCENERY:FilterRoles(Role)
if not self.Filter.SceneryRoles then
self.Filter.SceneryRoles={}
end
if type(Role)~="table"then
Role={Role}
end
for PrefixID,Prefix in pairs(Role)do
self.Filter.SceneryRoles[Prefix]=Prefix
end
return self
end
function SET_SCENERY:CountAlive()
local Set=self:GetSet()
local CountU=0
for UnitID,UnitData in pairs(Set)do
if UnitData and UnitData:IsAlive()then
CountU=CountU+1
end
end
return CountU
end
function SET_SCENERY:GetAliveSet()
local AliveSet=SET_SCENERY:New()
for GroupName,GroupObject in pairs(self.Set)do
local GroupObject=GroupObject
if GroupObject then
if GroupObject:IsAlive()then
AliveSet:Add(GroupName,GroupObject)
end
end
end
return AliveSet.Set or{},AliveSet
end
function SET_SCENERY:ForEachScenery(IteratorFunction,...)
self:ForEach(IteratorFunction,arg,self:GetSet())
return self
end
function SET_SCENERY:GetCoordinate()
local Coordinate=self:GetFirst():GetCoordinate()
local x1=Coordinate.x
local x2=Coordinate.x
local y1=Coordinate.y
local y2=Coordinate.y
local z1=Coordinate.z
local z2=Coordinate.z
for SceneryName,SceneryData in pairs(self:GetSet())do
local Scenery=SceneryData
local Coordinate=Scenery:GetCoordinate()
x1=(Coordinate.x<x1)and Coordinate.x or x1
x2=(Coordinate.x>x2)and Coordinate.x or x2
y1=(Coordinate.y<y1)and Coordinate.y or y1
y2=(Coordinate.y>y2)and Coordinate.y or y2
z1=(Coordinate.y<z1)and Coordinate.z or z1
z2=(Coordinate.y>z2)and Coordinate.z or z2
end
Coordinate.x=(x2-x1)/2+x1
Coordinate.y=(y2-y1)/2+y1
Coordinate.z=(z2-z1)/2+z1
return Coordinate
end
function SET_SCENERY:IsIncludeObject(MScenery)
local MSceneryInclude=true
if MScenery then
local MSceneryName=MScenery:GetName()
if self.Filter.Prefixes then
local MSceneryPrefix=false
for ZonePrefixId,ZonePrefix in pairs(self.Filter.Prefixes)do
if string.find(MSceneryName,ZonePrefix,1)then
MSceneryPrefix=true
end
end
MSceneryInclude=MSceneryInclude and MSceneryPrefix
end
if self.Filter.Zones then
local MSceneryZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
local coord=MScenery:GetCoordinate()
if coord and Zone:IsCoordinateInZone(coord)then
MSceneryZone=true
end
end
MSceneryInclude=MSceneryInclude and MSceneryZone
end
if self.Filter.SceneryRoles then
local MSceneryRole=false
local Role=MScenery:GetProperty("ROLE")or"none"
for ZoneRoleId,ZoneRole in pairs(self.Filter.SceneryRoles)do
if ZoneRole==Role then
MSceneryRole=true
end
end
MSceneryInclude=MSceneryInclude and MSceneryRole
end
end
if self.Filter.Functions and MSceneryInclude then
local MClientFunc=self:_EvalFilterFunctions(MScenery)
MSceneryInclude=MSceneryInclude and MClientFunc
end
return MSceneryInclude
end
function SET_SCENERY:FilterOnce()
for ObjectName,Object in pairs(self:GetSet())do
if self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
else
self:Remove(ObjectName,true)
end
end
return self
end
function SET_SCENERY:GetLife0()
local life0=0
self:ForEachScenery(
function(obj)
local Obj=obj
life0=life0+Obj:GetLife0()
end
)
return life0
end
function SET_SCENERY:GetLife()
local life=0
self:ForEachScenery(
function(obj)
local Obj=obj
life=life+Obj:GetLife()
end
)
return life
end
function SET_SCENERY:GetRelativeLife()
local life=self:GetLife()
local life0=self:GetLife0()
local rlife=math.floor((life/life0)*100)
return rlife
end
end
do
SET_DYNAMICCARGO={
ClassName="SET_DYNAMICCARGO",
Set={},
List={},
Index={},
Database=nil,
CallScheduler=nil,
Filter={
Coalitions=nil,
Types=nil,
Countries=nil,
StaticPrefixes=nil,
Zones=nil,
},
FilterMeta={
Coalitions={
red=coalition.side.RED,
blue=coalition.side.BLUE,
neutral=coalition.side.NEUTRAL,
}
},
ZoneTimerInterval=20,
ZoneTimer=nil,
}
function SET_DYNAMICCARGO:New()
local self=BASE:Inherit(self,SET_BASE:New(_DATABASE.DYNAMICCARGO))
return self
end
function SET_DYNAMICCARGO:IsIncludeObject(DCargo)
local DCargoInclude=true
if self.Filter.Coalitions then
local DCargoCoalition=false
for CoalitionID,CoalitionName in pairs(self.Filter.Coalitions)do
if self.FilterMeta.Coalitions[CoalitionName]and self.FilterMeta.Coalitions[CoalitionName]==DCargo:GetCoalition()then
DCargoCoalition=true
end
end
DCargoInclude=DCargoInclude and DCargoCoalition
end
if self.Filter.Types then
local DCargoType=false
for TypeID,TypeName in pairs(self.Filter.Types)do
if TypeName==DCargo:GetTypeName()then
DCargoType=true
end
end
DCargoInclude=DCargoInclude and DCargoType
end
if self.Filter.Countries then
local DCargoCountry=false
for CountryID,CountryName in pairs(self.Filter.Countries)do
if country.id[CountryName]==DCargo:GetCountry()then
DCargoCountry=true
end
end
DCargoInclude=DCargoInclude and DCargoCountry
end
if self.Filter.StaticPrefixes then
local DCargoPrefix=false
for StaticPrefixId,StaticPrefix in pairs(self.Filter.StaticPrefixes)do
if string.find(DCargo:GetName(),StaticPrefix,1)then
DCargoPrefix=true
end
end
DCargoInclude=DCargoInclude and DCargoPrefix
end
if self.Filter.Zones then
local DCargoZone=false
for ZoneName,Zone in pairs(self.Filter.Zones)do
if DCargo and DCargo:IsInZone(Zone)then
DCargoZone=true
end
end
DCargoInclude=DCargoInclude and DCargoZone
end
if self.Filter.Functions and DCargoInclude then
local MClientFunc=self:_EvalFilterFunctions(DCargo)
DCargoInclude=DCargoInclude and MClientFunc
end
return DCargoInclude
end
function SET_DYNAMICCARGO:FilterCoalitions(Coalitions)
if not self.Filter.Coalitions then
self.Filter.Coalitions={}
end
if type(Coalitions)~="table"then
Coalitions={Coalitions}
end
for CoalitionID,Coalition in pairs(Coalitions)do
self.Filter.Coalitions[Coalition]=Coalition
end
return self
end
function SET_DYNAMICCARGO:FilterTypes(Types)
if not self.Filter.Types then
self.Filter.Types={}
end
if type(Types)~="table"then
Types={Types}
end
for TypeID,Type in pairs(Types)do
self.Filter.Types[Type]=Type
end
return self
end
function SET_DYNAMICCARGO:FilterCountries(Countries)
if not self.Filter.Countries then
self.Filter.Countries={}
end
if type(Countries)~="table"then
Countries={Countries}
end
for CountryID,Country in pairs(Countries)do
self.Filter.Countries[Country]=Country
end
return self
end
function SET_DYNAMICCARGO:FilterPrefixes(Prefixes)
if not self.Filter.StaticPrefixes then
self.Filter.StaticPrefixes={}
end
if type(Prefixes)~="table"then
Prefixes={Prefixes}
end
for PrefixID,Prefix in pairs(Prefixes)do
self.Filter.StaticPrefixes[Prefix]=Prefix
end
return self
end
function SET_DYNAMICCARGO:FilterNamePattern(Patterns)
return self:FilterPrefixes(Patterns)
end
function SET_DYNAMICCARGO:FilterIsLoaded()
self:FilterFunction(
function(cargo)
if cargo and cargo.CargoState and cargo.CargoState==DYNAMICCARGO.State.LOADED then
return true
else
return false
end
end
)
return self
end
function SET_DYNAMICCARGO:FilterIsUnloaded()
self:FilterFunction(
function(cargo)
if cargo and cargo.CargoState and cargo.CargoState==DYNAMICCARGO.State.UNLOADED then
return true
else
return false
end
end
)
return self
end
function SET_DYNAMICCARGO:FilterIsNew()
self:FilterFunction(
function(cargo)
if cargo and cargo.CargoState and cargo.CargoState==DYNAMICCARGO.State.NEW then
return true
else
return false
end
end
)
return self
end
function SET_DYNAMICCARGO:FilterCurrentOwner(PlayerName)
self:FilterFunction(
function(cargo)
if cargo and cargo.Owner and string.find(cargo.Owner,PlayerName,1,true)then
return true
else
return false
end
end
)
return self
end
function SET_DYNAMICCARGO:FilterZones(Zones)
if not self.Filter.Zones then
self.Filter.Zones={}
end
local zones={}
if Zones.ClassName and Zones.ClassName=="SET_ZONE"then
zones=Zones.Set
elseif type(Zones)~="table"or(type(Zones)=="table"and Zones.ClassName)then
self:E("***** FilterZones needs either a table of ZONE Objects or a SET_ZONE as parameter!")
return self
else
zones=Zones
end
for _,Zone in pairs(zones)do
local zonename=Zone:GetName()
self.Filter.Zones[zonename]=Zone
end
return self
end
function SET_DYNAMICCARGO:FilterStart()
if _DATABASE then
self:HandleEvent(EVENTS.NewDynamicCargo,self._EventHandlerDCAdd)
self:HandleEvent(EVENTS.DynamicCargoRemoved,self._EventHandlerDCRemove)
if self.Filter.Zones then
self.ZoneTimer=TIMER:New(self._ContinousZoneFilter,self)
local timing=self.ZoneTimerInterval or 30
self.ZoneTimer:Start(timing,timing)
end
self:_FilterStart()
end
return self
end
function SET_DYNAMICCARGO:FilterStop()
if _DATABASE then
self:UnHandleEvent(EVENTS.NewDynamicCargo)
self:UnHandleEvent(EVENTS.DynamicCargoRemoved)
if self.ZoneTimer and self.ZoneTimer:IsRunning()then
self.ZoneTimer:Stop()
end
end
return self
end
function SET_DYNAMICCARGO:_ContinousZoneFilter()
local Database=_DATABASE.DYNAMICCARGO
for ObjectName,Object in pairs(Database)do
if self:IsIncludeObject(Object)and self:IsNotInSet(Object)then
self:Add(ObjectName,Object)
elseif(not self:IsIncludeObject(Object))and self:IsInSet(Object)then
self:Remove(ObjectName)
end
end
return self
end
function SET_DYNAMICCARGO:_EventHandlerDCAdd(Event)
if Event.IniDynamicCargo and Event.IniDynamicCargoName then
if not _DATABASE.DYNAMICCARGO[Event.IniDynamicCargoName]then
_DATABASE:AddDynamicCargo(Event.IniDynamicCargoName)
end
local ObjectName,Object=self:FindInDatabase(Event)
if Object and self:IsIncludeObject(Object)then
self:Add(ObjectName,Object)
end
end
return self
end
function SET_DYNAMICCARGO:_EventHandlerDCRemove(Event)
if Event.IniDCSUnitName then
local ObjectName,Object=self:FindInDatabase(Event)
if ObjectName then
self:Remove(ObjectName)
end
end
return self
end
function SET_DYNAMICCARGO:FindInDatabase(Event)
return Event.IniDCSUnitName,self.Set[Event.IniDCSUnitName]
end
function SET_DYNAMICCARGO:FilterZoneTimer(Seconds)
self.ZoneTimerInterval=Seconds or 30
return self
end
function SET_DYNAMICCARGO:FilterDeads()
return self
end
function SET_DYNAMICCARGO:FilterCrashes()
return self
end
function SET_DYNAMICCARGO:GetOwnerNames()
local owners={}
self:ForEach(
function(cargo)
if cargo and cargo.Owner then
table.insert(owners,cargo.Owner,cargo.Owner)
end
end
)
return owners
end
function SET_DYNAMICCARGO:GetStorageObjects()
local owners={}
self:ForEach(
function(cargo)
if cargo and cargo.warehouse then
table.insert(owners,cargo.StaticName,cargo.warehouse)
end
end
)
return owners
end
function SET_DYNAMICCARGO:GetOwnerClientObjects()
local owners={}
self:ForEach(
function(cargo)
if cargo and cargo.Owner then
local client=CLIENT:FindByPlayerName(cargo.Owner)
if client then
table.insert(owners,cargo.Owner,client)
end
end
end
)
return owners
end
end
do
COORDINATE={
ClassName="COORDINATE",
}
COORDINATE.WaypointAltType={
BARO="BARO",
RADIO="RADIO",
}
COORDINATE.WaypointAction={
TurningPoint="Turning Point",
FlyoverPoint="Fly Over Point",
FromParkingArea="From Parking Area",
FromParkingAreaHot="From Parking Area Hot",
FromGroundAreaHot="From Ground Area Hot",
FromGroundArea="From Ground Area",
FromRunway="From Runway",
Landing="Landing",
LandingReFuAr="LandingReFuAr",
}
COORDINATE.WaypointType={
TakeOffParking="TakeOffParking",
TakeOffParkingHot="TakeOffParkingHot",
TakeOff="TakeOffParkingHot",
TakeOffGroundHot="TakeOffGroundHot",
TakeOffGround="TakeOffGround",
TurningPoint="Turning Point",
Land="Land",
LandingReFuAr="LandingReFuAr",
}
function COORDINATE:New(x,y,z)
local self=BASE:Inherit(self,BASE:New())
self.x=x
self.y=y
self.z=z
return self
end
function COORDINATE:NewFromCoordinate(Coordinate)
local self=BASE:Inherit(self,BASE:New())
self.x=Coordinate.x
self.y=Coordinate.y
self.z=Coordinate.z
return self
end
function COORDINATE:NewFromVec2(Vec2,LandHeightAdd)
local LandHeight=land.getHeight(Vec2)
LandHeightAdd=LandHeightAdd or 0
LandHeight=LandHeight+LandHeightAdd
local self=self:New(Vec2.x,LandHeight,Vec2.y)
return self
end
function COORDINATE:NewFromVec3(Vec3)
local self=self:New(Vec3.x,Vec3.y,Vec3.z)
self:F2(self)
return self
end
function COORDINATE:NewFromWaypoint(Waypoint)
local self=self:New(Waypoint.x,Waypoint.alt,Waypoint.y)
return self
end
function COORDINATE:GetCoordinate()
return self
end
function COORDINATE:GetVec3()
return{x=self.x,y=self.y,z=self.z}
end
function COORDINATE:GetVec2()
return{x=self.x,y=self.z}
end
function COORDINATE:UpdateFromVec3(Vec3)
self.x=Vec3.x
self.y=Vec3.y
self.z=Vec3.z
return self
end
function COORDINATE:UpdateFromCoordinate(Coordinate)
self.x=Coordinate.x
self.y=Coordinate.y
self.z=Coordinate.z
return self
end
function COORDINATE:UpdateFromVec2(Vec2)
self.x=Vec2.x
self.z=Vec2.y
return self
end
function COORDINATE:GetMagneticDeclination(Month,Year)
local decl=UTILS.GetMagneticDeclination()
if require then
local magvar=require('magvar')
if magvar then
local date,year,month,day=UTILS.GetDCSMissionDate()
magvar.init(Month or month,Year or year)
local lat,lon=self:GetLLDDM()
decl=magvar.get_mag_decl(lat,lon)
if decl then
decl=math.deg(decl)
end
end
else
self:T("The require package is not available. Using constant value for magnetic declination")
end
return decl
end
function COORDINATE:NewFromLLDD(latitude,longitude,altitude)
local vec3=coord.LLtoLO(latitude,longitude)
local _coord=self:NewFromVec3(vec3)
if altitude==nil then
_coord.y=self:GetLandHeight()
else
_coord.y=altitude
end
return _coord
end
function COORDINATE:IsAtCoordinate2D(Coordinate,Precision)
self:F({Coordinate=Coordinate:GetVec2()})
self:F({self=self:GetVec2()})
local x=Coordinate.x
local z=Coordinate.z
return x-Precision<=self.x and x+Precision>=self.x and z-Precision<=self.z and z+Precision>=self.z
end
function COORDINATE:ScanObjects(radius,scanunits,scanstatics,scanscenery)
self:F(string.format("Scanning in radius %.1f m.",radius or 100))
local SphereSearch={
id=world.VolumeType.SPHERE,
params={
point=self:GetVec3(),
radius=radius,
}
}
radius=radius or 100
if scanunits==nil then
scanunits=true
end
if scanstatics==nil then
scanstatics=true
end
if scanscenery==nil then
scanscenery=false
end
local scanobjects={}
if scanunits then
table.insert(scanobjects,Object.Category.UNIT)
end
if scanstatics then
table.insert(scanobjects,Object.Category.STATIC)
end
if scanscenery then
table.insert(scanobjects,Object.Category.SCENERY)
end
local Units={}
local Statics={}
local Scenery={}
local gotstatics=false
local gotunits=false
local gotscenery=false
local function EvaluateZone(ZoneObject)
if ZoneObject then
local ObjectCategory=Object.getCategory(ZoneObject)
if ObjectCategory==Object.Category.UNIT and ZoneObject:isExist()then
table.insert(Units,UNIT:Find(ZoneObject))
gotunits=true
elseif ObjectCategory==Object.Category.STATIC and ZoneObject:isExist()then
table.insert(Statics,ZoneObject)
gotstatics=true
elseif ObjectCategory==Object.Category.SCENERY then
table.insert(Scenery,ZoneObject)
gotscenery=true
end
end
return true
end
world.searchObjects(scanobjects,SphereSearch,EvaluateZone)
for _,unit in pairs(Units)do
self:T(string.format("Scan found unit %s",unit:GetName()))
end
for _,static in pairs(Statics)do
self:T(string.format("Scan found static %s",static:getName()))
_DATABASE:AddStatic(static:getName())
end
for _,scenery in pairs(Scenery)do
self:T(string.format("Scan found scenery %s typename=%s",scenery:getName(),scenery:getTypeName()))
end
return gotunits,gotstatics,gotscenery,Units,Statics,Scenery
end
function COORDINATE:ScanUnits(radius)
local _,_,_,units=self:ScanObjects(radius,true,false,false)
local set=SET_UNIT:New()
for _,unit in pairs(units)do
set:AddUnit(unit)
end
return set
end
function COORDINATE:ScanStatics(radius)
local _,_,_,_,statics=self:ScanObjects(radius,false,true,false)
local set=SET_STATIC:New()
for _,stat in pairs(statics)do
set:AddStatic(STATIC:Find(stat))
end
return set
end
function COORDINATE:FindClosestStatic(radius)
local units=self:ScanStatics(radius)
local umin=nil
local dmin=math.huge
for _,_unit in pairs(units.Set)do
local unit=_unit
local coordinate=unit:GetCoordinate()
local d=self:Get2DDistance(coordinate)
if d<dmin then
dmin=d
umin=unit
end
end
return umin
end
function COORDINATE:FindClosestUnit(radius)
local units=self:ScanUnits(radius)
local umin=nil
local dmin=math.huge
for _,_unit in pairs(units.Set)do
local unit=_unit
local coordinate=unit:GetCoordinate()
local d=self:Get2DDistance(coordinate)
if d<dmin then
dmin=d
umin=unit
end
end
return umin
end
function COORDINATE:ScanScenery(radius)
local _,_,_,_,_,scenerys=self:ScanObjects(radius,false,false,true)
local set={}
for _,_scenery in pairs(scenerys)do
local scenery=_scenery
local name=scenery:getName()
local s=SCENERY:Register(name,scenery)
table.insert(set,s)
end
return set
end
function COORDINATE:FindClosestScenery(radius)
local sceneries=self:ScanScenery(radius)
local umin=nil
local dmin=math.huge
for _,_scenery in pairs(sceneries)do
local scenery=_scenery
local coordinate=scenery:GetCoordinate()
local d=self:Get2DDistance(coordinate)
if d<dmin then
dmin=d
umin=scenery
end
end
return umin
end
function COORDINATE:DistanceFromPointVec2(PointVec2Reference)
self:F2(PointVec2Reference)
if not PointVec2Reference then return math.huge end
local Distance=((PointVec2Reference.x-self.x)^2+(PointVec2Reference.z-self.z)^2)^0.5
self:T2(Distance)
return Distance
end
function COORDINATE:Translate(Distance,Angle,Keepalt,Overwrite)
local alpha=math.rad((Angle or 0))
local x=Distance*math.cos(alpha)+self.x
local z=Distance*math.sin(alpha)+self.z
local y=Keepalt and self.y or land.getHeight({x=x,y=z})
if Overwrite then
self.x=x
self.y=y
self.z=z
return self
else
local coord=COORDINATE:New(x,y,z)
return coord
end
end
function COORDINATE:Rotate2D(Angle)
if not Angle then
return self
end
local phi=math.rad(Angle)
local X=self.z
local Y=self.x
local x=X*math.cos(phi)-Y*math.sin(phi)
local y=X*math.sin(phi)+Y*math.cos(phi)
local coord=COORDINATE:NewFromVec3({x=y,y=self.y,z=x})
return coord
end
function COORDINATE:GetRandomVec2InRadius(OuterRadius,InnerRadius)
self:F2({OuterRadius,InnerRadius})
local Theta=2*math.pi*math.random()
local Radials=math.random()+math.random()
if Radials>1 then
Radials=2-Radials
end
local RadialMultiplier
if InnerRadius and InnerRadius<=OuterRadius then
RadialMultiplier=(OuterRadius-InnerRadius)*Radials+InnerRadius
else
RadialMultiplier=OuterRadius*Radials
end
local RandomVec2
if OuterRadius>0 then
RandomVec2={x=math.cos(Theta)*RadialMultiplier+self.x,y=math.sin(Theta)*RadialMultiplier+self.z}
else
RandomVec2={x=self.x,y=self.z}
end
return RandomVec2
end
function COORDINATE:GetRandomCoordinateInRadius(OuterRadius,InnerRadius)
self:F2({OuterRadius,InnerRadius})
local coord=COORDINATE:NewFromVec2(self:GetRandomVec2InRadius(OuterRadius,InnerRadius))
return coord
end
function COORDINATE:GetRandomVec3InRadius(OuterRadius,InnerRadius)
local RandomVec2=self:GetRandomVec2InRadius(OuterRadius,InnerRadius)
local y=self.y+math.random(InnerRadius,OuterRadius)
local RandomVec3={x=RandomVec2.x,y=y,z=RandomVec2.y}
return RandomVec3
end
function COORDINATE:GetLandHeight()
local Vec2={x=self.x,y=self.z}
return land.getHeight(Vec2)
end
function COORDINATE:SetHeading(Heading)
self.Heading=Heading
end
function COORDINATE:GetHeading()
return self.Heading
end
function COORDINATE:SetVelocity(Velocity)
self.Velocity=Velocity
end
function COORDINATE:GetVelocity()
local Velocity=self.Velocity
return Velocity or 0
end
function COORDINATE:GetName()
local name=self:ToStringMGRS()
return name
end
function COORDINATE:GetMovingText(Settings)
return self:GetVelocityText(Settings)..", "..self:GetHeadingText(Settings)
end
function COORDINATE:GetDirectionVec3(TargetCoordinate)
if TargetCoordinate then
return{x=TargetCoordinate.x-self.x,y=TargetCoordinate.y-self.y,z=TargetCoordinate.z-self.z}
else
return{x=0,y=0,z=0}
end
end
function COORDINATE:GetNorthCorrectionRadians()
local TargetVec3=self:GetVec3()
local lat,lon=coord.LOtoLL(TargetVec3)
local north_posit=coord.LLtoLO(lat+1,lon)
return math.atan2(north_posit.z-TargetVec3.z,north_posit.x-TargetVec3.x)
end
function COORDINATE:GetAngleRadians(DirectionVec3)
local DirectionRadians=math.atan2(DirectionVec3.z,DirectionVec3.x)
if DirectionRadians<0 then
DirectionRadians=DirectionRadians+2*math.pi
end
return DirectionRadians
end
function COORDINATE:GetAngleDegrees(DirectionVec3)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Angle=UTILS.ToDegree(AngleRadians)
return Angle
end
function COORDINATE:GetIntermediateCoordinate(ToCoordinate,Fraction)
local f=Fraction or 0.5
local vec=UTILS.VecSubstract(ToCoordinate,self)
if f>1 then
local norm=UTILS.VecNorm(vec)
f=Fraction/norm
end
vec.x=f*vec.x
vec.y=f*vec.y
vec.z=f*vec.z
vec=UTILS.VecAdd(self,vec)
local coord=COORDINATE:New(vec.x,vec.y,vec.z)
return coord
end
function COORDINATE:Get2DDistance(TargetCoordinate)
if not TargetCoordinate then return 1000000 end
local a=self:GetVec2()
if not TargetCoordinate.ClassName then
TargetCoordinate=COORDINATE:NewFromVec3(TargetCoordinate)
end
local b=TargetCoordinate:GetVec2()
local norm=UTILS.VecDist2D(a,b)
return norm
end
function COORDINATE:GetTemperature(height)
self:F2(height)
local y=height or self.y
local point={x=self.x,y=height or self.y,z=self.z}
local T,P=atmosphere.getTemperatureAndPressure(point)
return T-273.15
end
function COORDINATE:GetTemperatureText(height,Settings)
local DegreesCelcius=self:GetTemperature(height)
local Settings=Settings or _SETTINGS
if DegreesCelcius then
if Settings:IsMetric()then
return string.format(" %-2.2f °C",DegreesCelcius)
else
return string.format(" %-2.2f °F",UTILS.CelsiusToFahrenheit(DegreesCelcius))
end
else
return" no temperature"
end
return nil
end
function COORDINATE:GetPressure(height)
local point={x=self.x,y=height or self.y,z=self.z}
local T,P=atmosphere.getTemperatureAndPressure(point)
return P/100
end
function COORDINATE:GetPressureText(height,Settings)
local Pressure_hPa=self:GetPressure(height)
local Pressure_mmHg=Pressure_hPa*0.7500615613030
local Pressure_inHg=Pressure_hPa*0.0295299830714
local Settings=Settings or _SETTINGS
if Pressure_hPa then
if Settings:IsMetric()then
return string.format(" %4.1f hPa (%3.1f mmHg)",Pressure_hPa,Pressure_mmHg)
else
return string.format(" %4.1f hPa (%3.2f inHg)",Pressure_hPa,Pressure_inHg)
end
else
return" no pressure"
end
return nil
end
function COORDINATE:HeadingTo(ToCoordinate)
local dz=ToCoordinate.z-self.z
local dx=ToCoordinate.x-self.x
local heading=math.deg(math.atan2(dz,dx))
if heading<0 then
heading=360+heading
end
return heading
end
function COORDINATE:GetWindVec3(height,turbulence)
local landheight=self:GetLandHeight()+0.1
local point={x=self.x,y=math.max(height or self.y,landheight),z=self.z}
local wind=nil
if turbulence then
wind=atmosphere.getWindWithTurbulence(point)
else
wind=atmosphere.getWind(point)
end
return wind
end
function COORDINATE:GetWind(height,turbulence)
local wind=self:GetWindVec3(height,turbulence)
local direction=UTILS.VecHdg(wind)
if direction>180 then
direction=direction-180
else
direction=direction+180
end
local strength=UTILS.VecNorm(wind)
return direction,strength
end
function COORDINATE:GetWindWithTurbulenceVec3(height)
local landheight=self:GetLandHeight()+0.1
local point={x=self.x,y=math.max(height or self.y,landheight),z=self.z}
local vec3=atmosphere.getWindWithTurbulence(point)
return vec3
end
function COORDINATE:GetX()
return self.x
end
function COORDINATE:GetY()
if self:IsInstanceOf("POINT_VEC2")then
return self.z
end
return self.y
end
function COORDINATE:GetZ()
return self.z
end
function COORDINATE:SetX(x)
self.x=x
return self
end
function COORDINATE:SetY(y)
if self:IsInstanceOf("POINT_VEC2")then
self.z=y
else
self.y=y
end
return self
end
function COORDINATE:SetZ(z)
self.z=z
return self
end
function COORDINATE:AddX(x)
self.x=self.x+x
return self
end
function COORDINATE:GetLat()
return self.x
end
function COORDINATE:SetLat(x)
self.x=x
return self
end
function COORDINATE:GetLon()
return self.z
end
function COORDINATE:SetLon(z)
self.z=z
return self
end
function COORDINATE:GetAlt()
return self.y~=0 or land.getHeight({x=self.x,y=self.z})
end
function COORDINATE:SetAlt(Altitude)
self.y=Altitude or land.getHeight({x=self.x,y=self.z})
return self
end
function COORDINATE:AddAlt(Altitude)
self.y=land.getHeight({x=self.x,y=self.z})+Altitude or 0
return self
end
function COORDINATE:GetRandomPointVec2InRadius(OuterRadius,InnerRadius)
self:F2({OuterRadius,InnerRadius})
return COORDINATE:NewFromVec2(self:GetRandomVec2InRadius(OuterRadius,InnerRadius))
end
function COORDINATE:AddY(y)
if self:IsInstanceOf("POINT_VEC2")then
return self:AddZ(y)
else
self.y=self.y+y
end
return self
end
function COORDINATE:AddZ(z)
self.z=self.z+z
return self
end
function COORDINATE:GetWindText(height,Settings)
local Direction,Strength=self:GetWind(height)
local Settings=Settings or _SETTINGS
if Direction and Strength then
if Settings:IsMetric()then
return string.format(" %d ° at %3.2f mps",Direction,UTILS.MpsToKmph(Strength))
else
return string.format(" %d ° at %3.2f kps",Direction,UTILS.MpsToKnots(Strength))
end
else
return" no wind"
end
return nil
end
function COORDINATE:Get3DDistance(TargetCoordinate)
local TargetVec3={x=TargetCoordinate.x,y=TargetCoordinate.y,z=TargetCoordinate.z}
local SourceVec3=self:GetVec3()
local dist=UTILS.VecDist3D(TargetVec3,SourceVec3)
return dist
end
function COORDINATE:GetBearingText(AngleRadians,Precision,Settings,MagVar)
local Settings=Settings or _SETTINGS
local AngleDegrees=UTILS.Round(UTILS.ToDegree(AngleRadians),Precision)
local s=string.format('%03d°',AngleDegrees)
if MagVar then
local variation=self:GetMagneticDeclination()or 0
local AngleMagnetic=AngleDegrees-variation
if AngleMagnetic<0 then AngleMagnetic=360-AngleMagnetic end
s=string.format('%03d°M|%03d°',AngleMagnetic,AngleDegrees)
end
return s
end
function COORDINATE:GetDistanceText(Distance,Settings,Language,Precision)
local Settings=Settings or _SETTINGS
local Language=Language or Settings.Locale or _SETTINGS.Locale or"EN"
Language=string.lower(Language)
local Precision=Precision or 0
local DistanceText
if Settings:IsMetric()then
if Language=="en"then
DistanceText=" for "..UTILS.Round(Distance/1000,Precision).." km"
elseif Language=="ru"then
DistanceText=" за "..UTILS.Round(Distance/1000,Precision).." километров"
end
else
if Language=="en"then
DistanceText=" for "..UTILS.Round(UTILS.MetersToNM(Distance),Precision).." miles"
elseif Language=="ru"then
DistanceText=" за "..UTILS.Round(UTILS.MetersToNM(Distance),Precision).." миль"
end
end
return DistanceText
end
function COORDINATE:GetAltitudeText(Settings,Language)
local Altitude=self.y
local Settings=Settings or _SETTINGS
local Language=Language or Settings.Locale or _SETTINGS.Locale or"EN"
Language=string.lower(Language)
if Altitude~=0 then
if Settings:IsMetric()then
if Language=="en"then
return" at "..UTILS.Round(self.y,-3).." meters"
elseif Language=="ru"then
return" в "..UTILS.Round(self.y,-3).." метры"
end
else
if Language=="en"then
return" at "..UTILS.Round(UTILS.MetersToFeet(self.y),-3).." feet"
elseif Language=="ru"then
return" в "..UTILS.Round(self.y,-3).." ноги"
end
end
else
return""
end
end
function COORDINATE:GetVelocityText(Settings)
local Velocity=self:GetVelocity()
local Settings=Settings or _SETTINGS
if Velocity then
if Settings:IsMetric()then
return string.format(" moving at %d km/h",UTILS.MpsToKmph(Velocity))
else
return string.format(" moving at %d mi/h",UTILS.MpsToKmph(Velocity)/1.852)
end
else
return" stationary"
end
end
function COORDINATE:GetHeadingText(Settings)
local Heading=self:GetHeading()
if Heading then
return string.format(" bearing %3d°",Heading)
else
return" bearing unknown"
end
end
function COORDINATE:GetBRText(AngleRadians,Distance,Settings,Language,MagVar,Precision)
local Settings=Settings or _SETTINGS
Precision=Precision or 0
local BearingText=self:GetBearingText(AngleRadians,0,Settings,MagVar)
local DistanceText=self:GetDistanceText(Distance,Settings,Language,Precision)
local BRText=BearingText..DistanceText
return BRText
end
function COORDINATE:GetBRAText(AngleRadians,Distance,Settings,Language,MagVar)
local Settings=Settings or _SETTINGS
local BearingText=self:GetBearingText(AngleRadians,0,Settings,MagVar)
local DistanceText=self:GetDistanceText(Distance,Settings,Language,0)
local AltitudeText=self:GetAltitudeText(Settings,Language)
local BRAText=BearingText..DistanceText..AltitudeText
return BRAText
end
function COORDINATE:SetAltitude(altitude,asl)
local alt=altitude
if asl then
alt=altitude
else
alt=self:GetLandHeight()+altitude
end
self.y=alt
return self
end
function COORDINATE:SetAtLandheight()
local alt=self:GetLandHeight()
self.y=alt
return self
end
function COORDINATE:WaypointAir(AltType,Type,Action,Speed,SpeedLocked,airbase,DCSTasks,description,timeReFuAr)
self:F2({AltType,Type,Action,Speed,SpeedLocked})
AltType=AltType or"RADIO"
if SpeedLocked==nil then
SpeedLocked=true
end
Speed=Speed or 500
local RoutePoint={}
RoutePoint.x=self.x
RoutePoint.y=self.z
RoutePoint.alt=self.y
RoutePoint.alt_type=AltType
RoutePoint.type=Type or nil
RoutePoint.action=Action or nil
RoutePoint.speed=Speed/3.6
RoutePoint.speed_locked=SpeedLocked
RoutePoint.ETA=0
RoutePoint.ETA_locked=false
RoutePoint.name=description
if airbase then
local AirbaseID=airbase:GetID()
local AirbaseCategory=airbase:GetAirbaseCategory()
if AirbaseCategory==Airbase.Category.SHIP or AirbaseCategory==Airbase.Category.HELIPAD then
RoutePoint.linkUnit=AirbaseID
RoutePoint.helipadId=AirbaseID
elseif AirbaseCategory==Airbase.Category.AIRDROME then
RoutePoint.airdromeId=AirbaseID
else
self:E("ERROR: Unknown airbase category in COORDINATE:WaypointAir()!")
end
end
if Type==COORDINATE.WaypointType.LandingReFuAr then
RoutePoint.timeReFuAr=timeReFuAr or 10
end
RoutePoint.task={}
RoutePoint.task.id="ComboTask"
RoutePoint.task.params={}
RoutePoint.task.params.tasks=DCSTasks or{}
self:T({RoutePoint=RoutePoint})
return RoutePoint
end
function COORDINATE:WaypointAirTurningPoint(AltType,Speed,DCSTasks,description)
return self:WaypointAir(AltType,COORDINATE.WaypointType.TurningPoint,COORDINATE.WaypointAction.TurningPoint,Speed,true,nil,DCSTasks,description)
end
function COORDINATE:WaypointAirFlyOverPoint(AltType,Speed)
return self:WaypointAir(AltType,COORDINATE.WaypointType.TurningPoint,COORDINATE.WaypointAction.FlyoverPoint,Speed)
end
function COORDINATE:WaypointAirTakeOffParkingHot(AltType,Speed)
return self:WaypointAir(AltType,COORDINATE.WaypointType.TakeOffParkingHot,COORDINATE.WaypointAction.FromParkingAreaHot,Speed)
end
function COORDINATE:WaypointAirTakeOffParking(AltType,Speed)
return self:WaypointAir(AltType,COORDINATE.WaypointType.TakeOffParking,COORDINATE.WaypointAction.FromParkingArea,Speed)
end
function COORDINATE:WaypointAirTakeOffRunway(AltType,Speed)
return self:WaypointAir(AltType,COORDINATE.WaypointType.TakeOff,COORDINATE.WaypointAction.FromRunway,Speed)
end
function COORDINATE:WaypointAirLanding(Speed,airbase,DCSTasks,description)
return self:WaypointAir(nil,COORDINATE.WaypointType.Land,COORDINATE.WaypointAction.Landing,Speed,false,airbase,DCSTasks,description)
end
function COORDINATE:WaypointAirLandingReFu(Speed,airbase,timeReFuAr,DCSTasks,description)
return self:WaypointAir(nil,COORDINATE.WaypointType.LandingReFuAr,COORDINATE.WaypointAction.LandingReFuAr,Speed,false,airbase,DCSTasks,description,timeReFuAr or 10)
end
function COORDINATE:WaypointGround(Speed,Formation,DCSTasks)
self:F2({Speed,Formation,DCSTasks})
local RoutePoint={}
RoutePoint.x=self.x
RoutePoint.y=self.z
RoutePoint.alt=self:GetLandHeight()+1
RoutePoint.alt_type=COORDINATE.WaypointAltType.BARO
RoutePoint.type="Turning Point"
RoutePoint.action=Formation or"Off Road"
RoutePoint.formation_template=""
RoutePoint.ETA=0
RoutePoint.ETA_locked=false
RoutePoint.speed=(Speed or 20)/3.6
RoutePoint.speed_locked=true
RoutePoint.task={}
RoutePoint.task.id="ComboTask"
RoutePoint.task.params={}
RoutePoint.task.params.tasks=DCSTasks or{}
return RoutePoint
end
function COORDINATE:WaypointNaval(Speed,Depth,DCSTasks)
self:F2({Speed,Depth,DCSTasks})
local RoutePoint={}
RoutePoint.x=self.x
RoutePoint.y=self.z
RoutePoint.alt=Depth or self.y
RoutePoint.alt_type="BARO"
RoutePoint.type="Turning Point"
RoutePoint.action="Turning Point"
RoutePoint.formation_template=""
RoutePoint.ETA=0
RoutePoint.ETA_locked=false
RoutePoint.speed=(Speed or 20)/3.6
RoutePoint.speed_locked=true
RoutePoint.task={}
RoutePoint.task.id="ComboTask"
RoutePoint.task.params={}
RoutePoint.task.params.tasks=DCSTasks or{}
return RoutePoint
end
function COORDINATE:GetClosestAirbase(Category,Coalition)
local airbases=AIRBASE.GetAllAirbases(Coalition)
local closest=nil
local distmin=nil
for _,_airbase in pairs(airbases)do
local airbase=_airbase
if airbase then
local category=airbase:GetAirbaseCategory()
if Category and Category==category or Category==nil then
local dist=self:Get2DDistance(airbase:GetCoordinate())
if closest==nil then
distmin=dist
closest=airbase
else
if dist<distmin then
distmin=dist
closest=airbase
end
end
end
end
end
return closest,distmin
end
function COORDINATE:GetClosestAirbase2(Category,Coalition)
local closest,distmin=self:GetClosestAirbase(Category,Coalition)
return closest,distmin
end
function COORDINATE:GetClosestParkingSpot(airbase,terminaltype,free)
local airbases={}
if airbase then
table.insert(airbases,airbase)
else
airbases=AIRBASE.GetAllAirbases()
end
local _closest=nil
local _termID=nil
local _distmin=nil
local spot=nil
for _,_airbase in pairs(airbases)do
local mybase=_airbase
local parkingdata=mybase:GetParkingSpotsTable(terminaltype)
for _,_spot in pairs(parkingdata)do
if(free==true and _spot.Free==true)or(free==false and _spot.Free==false)or free==nil then
local _coord=_spot.Coordinate
local _dist=self:Get2DDistance(_coord)
if _distmin==nil then
_closest=_coord
_distmin=_dist
_termID=_spot.TerminalID
spot=_spot
else
if _dist<_distmin then
_distmin=_dist
_closest=_coord
_termID=_spot.TerminalID
spot=_spot
end
end
end
end
end
return _closest,_termID,_distmin,spot
end
function COORDINATE:GetClosestFreeParkingSpot(airbase,terminaltype)
return self:GetClosestParkingSpot(airbase,terminaltype,true)
end
function COORDINATE:GetClosestOccupiedParkingSpot(airbase,terminaltype)
return self:GetClosestParkingSpot(airbase,terminaltype,false)
end
function COORDINATE:GetClosestPointToRoad(Railroad)
local roadtype="roads"
if Railroad==true then
roadtype="railroads"
end
local x,y=land.getClosestPointOnRoads(roadtype,self.x,self.z)
local coord=nil
if x and y then
local vec2={x=x,y=y}
coord=COORDINATE:NewFromVec2(vec2)
end
return coord
end
function COORDINATE:GetPathOnRoad(ToCoord,IncludeEndpoints,Railroad,MarkPath,SmokePath)
local RoadType="roads"
if Railroad==true then
RoadType="railroads"
end
local path=land.findPathOnRoads(RoadType,self.x,self.z,ToCoord.x,ToCoord.z)
local Path={}
local Way=0
if IncludeEndpoints then
Path[1]=self
end
local GotPath=true
if path then
for _i,_vec2 in ipairs(path)do
local coord=COORDINATE:NewFromVec2(_vec2)
Path[#Path+1]=coord
end
else
self:E("Path is nil. No valid path on road could be found.")
GotPath=false
end
if IncludeEndpoints then
Path[#Path+1]=ToCoord
end
if MarkPath or SmokePath then
for i,c in pairs(Path)do
local coord=c
if MarkPath then
coord:MarkToAll(string.format("Path segment %d",i))
end
if SmokePath then
if i==1 or i==#Path then
coord:SmokeBlue()
else
coord:SmokeGreen()
end
end
end
end
if#Path>=2 then
for i=1,#Path-1 do
Way=Way+Path[i+1]:Get2DDistance(Path[i])
end
else
return nil,nil,false
end
return Path,Way,GotPath
end
function COORDINATE:GetSurfaceType()
local vec2=self:GetVec2()
local surface=land.getSurfaceType(vec2)
return surface
end
function COORDINATE:IsSurfaceTypeLand()
return self:GetSurfaceType()==land.SurfaceType.LAND
end
function COORDINATE:IsSurfaceTypeLand()
return self:GetSurfaceType()==land.SurfaceType.LAND
end
function COORDINATE:IsSurfaceTypeRoad()
return self:GetSurfaceType()==land.SurfaceType.ROAD
end
function COORDINATE:IsSurfaceTypeRunway()
return self:GetSurfaceType()==land.SurfaceType.RUNWAY
end
function COORDINATE:IsSurfaceTypeShallowWater()
return self:GetSurfaceType()==land.SurfaceType.SHALLOW_WATER
end
function COORDINATE:IsSurfaceTypeWater()
return self:GetSurfaceType()==land.SurfaceType.WATER
end
function COORDINATE:Explosion(ExplosionIntensity,Delay)
ExplosionIntensity=ExplosionIntensity or 100
if Delay and Delay>0 then
self:ScheduleOnce(Delay,self.Explosion,self,ExplosionIntensity)
else
trigger.action.explosion(self:GetVec3(),ExplosionIntensity)
end
return self
end
function COORDINATE:IlluminationBomb(Power,Delay)
Power=Power or 1000
if Delay and Delay>0 then
self:ScheduleOnce(Delay,self.IlluminationBomb,self,Power)
else
trigger.action.illuminationBomb(self:GetVec3(),Power)
end
return self
end
function COORDINATE:Smoke(SmokeColor,Duration,Delay,Name)
self:F2({SmokeColor,Name,Duration,Delay})
SmokeColor=SmokeColor or SMOKECOLOR.Green
if Delay and Delay>0 then
self:ScheduleOnce(Delay,COORDINATE.Smoke,self,SmokeColor,Duration,0,Name)
else
self.firename=Name or"Smoke-"..math.random(1,100000)
trigger.action.smoke(self:GetVec3(),SmokeColor,self.firename)
if Duration and Duration>0 then
self:ScheduleOnce(Duration,COORDINATE.StopSmoke,self,self.firename)
end
end
return self
end
function COORDINATE:StopSmoke(name)
self:StopBigSmokeAndFire(name)
end
function COORDINATE:SmokeGreen(Duration,Delay)
self:Smoke(SMOKECOLOR.Green,Duration,Delay)
return self
end
function COORDINATE:SmokeRed(Duration,Delay)
self:Smoke(SMOKECOLOR.Red,Duration,Delay)
return self
end
function COORDINATE:SmokeWhite(Duration,Delay)
self:Smoke(SMOKECOLOR.White,Duration,Delay)
return self
end
function COORDINATE:SmokeOrange(Duration,Delay)
self:Smoke(SMOKECOLOR.Orange,Duration,Delay)
return self
end
function COORDINATE:SmokeBlue(Duration,Delay)
self:Smoke(SMOKECOLOR.Blue,Duration,Delay)
return self
end
function COORDINATE:BigSmokeAndFire(Preset,Density,Duration,Delay,Name)
self:F2({preset=Preset,density=Density})
Preset=Preset or BIGSMOKEPRESET.SmallSmokeAndFire
Density=Density or 0.5
if Delay and Delay>0 then
self:ScheduleOnce(Delay,COORDINATE.BigSmokeAndFire,self,Preset,Density,Duration,0,Name)
else
self.firename=Name or"Fire-"..math.random(1,10000)
trigger.action.effectSmokeBig(self:GetVec3(),Preset,Density,self.firename)
if Duration and Duration>0 then
self:ScheduleOnce(Duration,COORDINATE.StopBigSmokeAndFire,self,self.firename)
end
end
return self
end
function COORDINATE:StopBigSmokeAndFire(name)
name=name or self.firename
trigger.action.effectSmokeStop(name)
end
function COORDINATE:BigSmokeAndFireSmall(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.SmallSmokeAndFire,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeAndFireMedium(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.MediumSmokeAndFire,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeAndFireLarge(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.LargeSmokeAndFire,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeAndFireHuge(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.HugeSmokeAndFire,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeSmall(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.SmallSmoke,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeMedium(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.MediumSmoke,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeLarge(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.LargeSmoke,Density,Duration,Delay,Name)
return self
end
function COORDINATE:BigSmokeHuge(Density,Duration,Delay,Name)
self:BigSmokeAndFire(BIGSMOKEPRESET.HugeSmoke,Density,Duration,Delay,Name)
return self
end
function COORDINATE:Flare(FlareColor,Azimuth)
self:F2({FlareColor})
trigger.action.signalFlare(self:GetVec3(),FlareColor,Azimuth and Azimuth or 0)
end
function COORDINATE:FlareWhite(Azimuth)
self:F2(Azimuth)
self:Flare(FLARECOLOR.White,Azimuth)
end
function COORDINATE:FlareYellow(Azimuth)
self:F2(Azimuth)
self:Flare(FLARECOLOR.Yellow,Azimuth)
end
function COORDINATE:FlareGreen(Azimuth)
self:F2(Azimuth)
self:Flare(FLARECOLOR.Green,Azimuth)
end
function COORDINATE:FlareRed(Azimuth)
self:F2(Azimuth)
self:Flare(FLARECOLOR.Red,Azimuth)
end
do
function COORDINATE:MarkToAll(MarkText,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local text=Text or""
trigger.action.markToAll(MarkID,MarkText,self:GetVec3(),ReadOnly,text)
return MarkID
end
function COORDINATE:MarkToCoalition(MarkText,Coalition,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local text=Text or""
trigger.action.markToCoalition(MarkID,MarkText,self:GetVec3(),Coalition,ReadOnly,text)
return MarkID
end
function COORDINATE:MarkToCoalitionRed(MarkText,ReadOnly,Text)
return self:MarkToCoalition(MarkText,coalition.side.RED,ReadOnly,Text)
end
function COORDINATE:MarkToCoalitionBlue(MarkText,ReadOnly,Text)
return self:MarkToCoalition(MarkText,coalition.side.BLUE,ReadOnly,Text)
end
function COORDINATE:MarkToGroup(MarkText,MarkGroup,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local text=Text or""
trigger.action.markToGroup(MarkID,MarkText,self:GetVec3(),MarkGroup:GetID(),ReadOnly,text)
return MarkID
end
function COORDINATE:RemoveMark(MarkID)
trigger.action.removeMark(MarkID)
end
function COORDINATE:LineToAll(Endpoint,Coalition,Color,Alpha,LineType,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local vec3=Endpoint:GetVec3()
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
LineType=LineType or 1
trigger.action.lineToAll(Coalition,MarkID,self:GetVec3(),vec3,Color,LineType,ReadOnly,Text or"")
return MarkID
end
function COORDINATE:CircleToAll(Radius,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local vec3=self:GetVec3()
Radius=Radius or 1000
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
LineType=LineType or 1
FillColor=FillColor or UTILS.DeepCopy(Color)
FillColor[4]=FillAlpha or 0.15
trigger.action.circleToAll(Coalition,MarkID,vec3,Radius,Color,FillColor,LineType,ReadOnly,Text or"")
return MarkID
end
end
function COORDINATE:RectToAll(Endpoint,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local vec3=Endpoint:GetVec3()
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
LineType=LineType or 1
FillColor=FillColor or UTILS.DeepCopy(Color)
FillColor[4]=FillAlpha or 0.15
trigger.action.rectToAll(Coalition,MarkID,self:GetVec3(),vec3,Color,FillColor,LineType,ReadOnly,Text or"")
return MarkID
end
function COORDINATE:QuadToAll(Coord2,Coord3,Coord4,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local point1=self:GetVec3()
local point2=Coord2:GetVec3()
local point3=Coord3:GetVec3()
local point4=Coord4:GetVec3()
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
LineType=LineType or 1
FillColor=FillColor or UTILS.DeepCopy(Color)
FillColor[4]=FillAlpha or 0.15
trigger.action.quadToAll(Coalition,MarkID,point1,point2,point3,point4,Color,FillColor,LineType,ReadOnly,Text or"")
return MarkID
end
function COORDINATE:MarkupToAllFreeForm(Coordinates,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
LineType=LineType or 1
FillColor=FillColor or UTILS.DeepCopy(Color)
FillColor[4]=FillAlpha or 0.15
local vecs={}
vecs[1]=self:GetVec3()
for i,coord in ipairs(Coordinates)do
vecs[i+1]=coord:GetVec3()
end
if#vecs<3 then
self:E("ERROR: A free form polygon needs at least three points!")
elseif#vecs==3 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==4 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==5 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==6 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==7 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==8 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==9 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==10 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],vecs[10],Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==11 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],vecs[10],
vecs[11],
Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==12 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],vecs[10],
vecs[11],vecs[12],
Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==13 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],vecs[10],
vecs[11],vecs[12],vecs[13],
Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==14 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],vecs[10],
vecs[11],vecs[12],vecs[13],vecs[14],
Color,FillColor,LineType,ReadOnly,Text or"")
elseif#vecs==15 then
trigger.action.markupToAll(7,Coalition,MarkID,vecs[1],vecs[2],vecs[3],vecs[4],vecs[5],vecs[6],vecs[7],vecs[8],vecs[9],vecs[10],
vecs[11],vecs[12],vecs[13],vecs[14],vecs[15],
Color,FillColor,LineType,ReadOnly,Text or"")
else
local s=string.format("trigger.action.markupToAll(7, %d, %d,",Coalition,MarkID)
for _,vec in pairs(vecs)do
s=s..string.format("{x=%.1f, y=%.1f, z=%.1f},",vec.x,vec.y,vec.z)
end
s=s..string.format("{%.3f, %.3f, %.3f, %.3f},",Color[1],Color[2],Color[3],Color[4])
s=s..string.format("{%.3f, %.3f, %.3f, %.3f},",FillColor[1],FillColor[2],FillColor[3],FillColor[4])
s=s..string.format("%d,",LineType or 1)
s=s..string.format("%s",tostring(ReadOnly))
if Text and type(Text)=="string"and string.len(Text)>0 then
s=s..string.format(", \"%s\"",tostring(Text))
end
s=s..")"
local success=UTILS.DoString(s)
if not success then
self:E("ERROR: Could not draw polygon")
env.info(s)
end
end
return MarkID
end
function COORDINATE:TextToAll(Text,Coalition,Color,Alpha,FillColor,FillAlpha,FontSize,ReadOnly)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
FillColor=FillColor or UTILS.DeepCopy(Color)
FillColor[4]=FillAlpha or 0.3
FontSize=FontSize or 14
trigger.action.textToAll(Coalition,MarkID,self:GetVec3(),Color,FillColor,FontSize,ReadOnly,Text or"Hello World")
return MarkID
end
function COORDINATE:ArrowToAll(Endpoint,Coalition,Color,Alpha,FillColor,FillAlpha,LineType,ReadOnly,Text)
local MarkID=UTILS.GetMarkID()
if ReadOnly==nil then
ReadOnly=false
end
local vec3=Endpoint:GetVec3()
Coalition=Coalition or-1
Color=Color or{1,0,0}
Color[4]=Alpha or 1.0
LineType=LineType or 1
FillColor=FillColor or UTILS.DeepCopy(Color)
FillColor[4]=FillAlpha or 0.15
trigger.action.arrowToAll(Coalition,MarkID,vec3,self:GetVec3(),Color,FillColor,LineType,ReadOnly,Text or"")
return MarkID
end
function COORDINATE:IsLOS(ToCoordinate,Offset)
Offset=Offset or 2
local FromVec3=self:GetVec3()
FromVec3.y=FromVec3.y+Offset
local ToVec3=ToCoordinate:GetVec3()
ToVec3.y=ToVec3.y+Offset
local IsLOS=land.isVisible(FromVec3,ToVec3)
return IsLOS
end
function COORDINATE:IsInRadius(Coordinate,Radius)
local InVec2=self:GetVec2()
local Vec2=Coordinate:GetVec2()
local InRadius=UTILS.IsInRadius(InVec2,Vec2,Radius)
return InRadius
end
function COORDINATE:IsInSphere(Coordinate,Radius)
local InVec3=self:GetVec3()
local Vec3=Coordinate:GetVec3()
local InSphere=UTILS.IsInSphere(InVec3,Vec3,Radius)
return InSphere
end
function COORDINATE:GetSunriseAtDate(Day,Month,Year,InSeconds)
local DayOfYear=UTILS.GetDayOfYear(Year,Month,Day)
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
local sunrise=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,true,Tdiff)
if InSeconds then
return sunrise
else
return UTILS.SecondsToClock(sunrise,true)
end
end
function COORDINATE:GetSunriseAtDayOfYear(DayOfYear,InSeconds)
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
local sunrise=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,true,Tdiff)
if InSeconds then
return sunrise
else
return UTILS.SecondsToClock(sunrise,true)
end
end
function COORDINATE:GetSunrise(InSeconds)
local DayOfYear=UTILS.GetMissionDayOfYear()
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
local sunrise=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,true,Tdiff)
local date=UTILS.GetDCSMissionDate()
if InSeconds or type(sunrise)=="string"then
return sunrise
else
return UTILS.SecondsToClock(sunrise,true)
end
end
function COORDINATE:GetMinutesToSunrise(OnlyToday)
local time=UTILS.SecondsOfToday()
local sunrise=nil
local delta=nil
if OnlyToday then
sunrise=self:GetSunrise(true)
delta=sunrise-time
else
local DayOfYear=UTILS.GetMissionDayOfYear()+1
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
sunrise=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,true,Tdiff)
delta=sunrise+UTILS.SecondsToMidnight()
end
return delta/60
end
function COORDINATE:IsDay(Clock)
if Clock then
local Time=UTILS.ClockToSeconds(Clock)
local clock=UTILS.Split(Clock,"+")[1]
local DayOfYear=UTILS.GetMissionDayOfYear(Time)
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
local sunrise=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,true,Tdiff)
local sunset=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,false,Tdiff)
if sunrise=="N/R"then return false end
if sunrise=="N/S"then return true end
local time=UTILS.ClockToSeconds(clock)
if time>sunrise and time<=sunset then
return true
else
return false
end
else
local sunrise=self:GetSunrise(true)
local sunset=self:GetSunset(true)
local time=UTILS.SecondsOfToday()
if time>sunrise and time<=sunset then
return true
else
return false
end
end
end
function COORDINATE:IsNight(Clock)
return not self:IsDay(Clock)
end
function COORDINATE:GetSunsetAtDate(Day,Month,Year,InSeconds)
local DayOfYear=UTILS.GetDayOfYear(Year,Month,Day)
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
local sunset=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,false,Tdiff)
if InSeconds then
return sunset
else
return UTILS.SecondsToClock(sunset,true)
end
end
function COORDINATE:GetSunset(InSeconds)
local DayOfYear=UTILS.GetMissionDayOfYear()
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
local sunrise=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,false,Tdiff)
local date=UTILS.GetDCSMissionDate()
if InSeconds or type(sunrise)=="string"then
return sunrise
else
return UTILS.SecondsToClock(sunrise,true)
end
end
function COORDINATE:GetMinutesToSunset(OnlyToday)
local time=UTILS.SecondsOfToday()
local sunset=nil
local delta=nil
if OnlyToday then
sunset=self:GetSunset(true)
delta=sunset-time
else
local DayOfYear=UTILS.GetMissionDayOfYear()+1
local Latitude,Longitude=self:GetLLDDM()
local Tdiff=UTILS.GMTToLocalTimeDifference()
sunset=UTILS.GetSunRiseAndSet(DayOfYear,Latitude,Longitude,false,Tdiff)
delta=sunset+UTILS.SecondsToMidnight()
end
return delta/60
end
function COORDINATE:ToStringBR(FromCoordinate,Settings,MagVar,Precision)
local DirectionVec3=FromCoordinate:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=self:Get2DDistance(FromCoordinate)
return"BR, "..self:GetBRText(AngleRadians,Distance,Settings,nil,MagVar,Precision)
end
function COORDINATE:ToStringBRA(FromCoordinate,Settings,MagVar)
local DirectionVec3=FromCoordinate:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=FromCoordinate:Get2DDistance(self)
local Altitude=self:GetAltitudeText()
return"BRA, "..self:GetBRAText(AngleRadians,Distance,Settings,nil,MagVar)
end
function COORDINATE:ToStringBRAANATO(FromCoordinate,Bogey,Spades,SSML,Angels,Zeros)
local BRAANATO="Merged."
local currentCoord=FromCoordinate
local DirectionVec3=FromCoordinate:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local bearing=UTILS.Round(UTILS.ToDegree(AngleRadians),0)
local magnetic=self:GetMagneticDeclination()or 0
bearing=bearing-magnetic
local rangeMetres=self:Get2DDistance(currentCoord)
local rangeNM=UTILS.Round(UTILS.MetersToNM(rangeMetres),0)
local aspect=self:ToStringAspect(currentCoord)
local alt=UTILS.Round(UTILS.MetersToFeet(self.y)/1000,0)
local alttext=string.format("%d thousand",alt)
if Angels then
alttext=string.format("Angels %d",alt)
end
if alt<1 then
alttext="very low"
end
local track="Maneuver"
if self.Heading then
track=UTILS.BearingToCardinal(self.Heading)or"North"
end
if rangeNM>3 then
if SSML then
if Zeros then
bearing=string.format("%03d",bearing)
local AngleDegText=string.gsub(bearing,"%d","%1 ")
AngleDegText=string.gsub(AngleDegText," $","")
AngleDegText=string.gsub(AngleDegText,"0","zero")
if aspect==""then
BRAANATO=string.format("brah %s, %d miles, %s, Track %s",AngleDegText,rangeNM,alttext,track)
else
BRAANATO=string.format("brah %s, %d miles, %s, %s, Track %s",AngleDegText,rangeNM,alttext,aspect,track)
end
else
if aspect==""then
BRAANATO=string.format("brah <say-as interpret-as='characters'>%03d</say-as>, %d miles, %s, Track %s",bearing,rangeNM,alttext,track)
else
BRAANATO=string.format("brah <say-as interpret-as='characters'>%03d</say-as>, %d miles, %s, %s, Track %s",bearing,rangeNM,alttext,aspect,track)
end
end
if Bogey and Spades then
BRAANATO=BRAANATO..", Bogey, Spades."
elseif Bogey then
BRAANATO=BRAANATO..", Bogey."
elseif Spades then
BRAANATO=BRAANATO..", Spades."
else
BRAANATO=BRAANATO.."."
end
else
if aspect==""then
BRAANATO=string.format("BRA %03d, %d miles, %s, Track %s",bearing,rangeNM,alttext,track)
else
BRAANATO=string.format("BRAA %03d, %d miles, %s, %s, Track %s",bearing,rangeNM,alttext,aspect,track)
end
if Bogey and Spades then
BRAANATO=BRAANATO..", Bogey, Spades."
elseif Bogey then
BRAANATO=BRAANATO..", Bogey."
elseif Spades then
BRAANATO=BRAANATO..", Spades."
else
BRAANATO=BRAANATO.."."
end
end
end
return BRAANATO
end
function COORDINATE.GetBullseyeCoordinate(Coalition)
return COORDINATE:NewFromVec3(coalition.getMainRefPoint(Coalition))
end
function COORDINATE:ToStringBULLS(Coalition,Settings,MagVar)
local BullsCoordinate=COORDINATE:NewFromVec3(coalition.getMainRefPoint(Coalition))
local DirectionVec3=BullsCoordinate:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=self:Get2DDistance(BullsCoordinate)
local Altitude=self:GetAltitudeText()
return"BULLS, "..self:GetBRText(AngleRadians,Distance,Settings,nil,MagVar)
end
function COORDINATE:ToStringAspect(TargetCoordinate)
local Heading=self.Heading
local DirectionVec3=self:GetDirectionVec3(TargetCoordinate)
local Angle=self:GetAngleDegrees(DirectionVec3)
if Heading then
local Aspect=Angle-Heading
if Aspect>-135 and Aspect<=-45 then
return"Flanking"
end
if Aspect>-45 and Aspect<=45 then
return"Hot"
end
if Aspect>45 and Aspect<=135 then
return"Flanking"
end
if Aspect>135 or Aspect<=-135 then
return"Cold"
end
end
return""
end
function COORDINATE:GetLLDDM()
return coord.LOtoLL(self:GetVec3())
end
function COORDINATE:ToStringLL(Settings)
local LL_Accuracy=Settings and Settings.LL_Accuracy or _SETTINGS.LL_Accuracy
local lat,lon=coord.LOtoLL(self:GetVec3())
return string.format('%f',lat)..' '..string.format('%f',lon)
end
function COORDINATE:ToStringLLDMS(Settings)
local LL_Accuracy=Settings and Settings.LL_Accuracy or _SETTINGS.LL_Accuracy
local lat,lon=coord.LOtoLL(self:GetVec3())
return"LL DMS "..UTILS.tostringLL(lat,lon,LL_Accuracy,true)
end
function COORDINATE:ToStringLLDDM(Settings)
local LL_Accuracy=Settings and Settings.LL_Accuracy or _SETTINGS.LL_Accuracy
local lat,lon=coord.LOtoLL(self:GetVec3())
return"LL DDM "..UTILS.tostringLL(lat,lon,LL_Accuracy,false)
end
function COORDINATE:ToStringMGRS(Settings)
local MGRS_Accuracy=Settings and Settings.MGRS_Accuracy or _SETTINGS.MGRS_Accuracy
local lat,lon=coord.LOtoLL(self:GetVec3())
local MGRS=coord.LLtoMGRS(lat,lon)
return"MGRS "..UTILS.tostringMGRS(MGRS,MGRS_Accuracy)
end
function COORDINATE:NewFromMGRSString(MGRSString)
local myparts=UTILS.Split(MGRSString," ")
local northing=tostring(myparts[5])or""
local easting=tostring(myparts[4])or""
if string.len(easting)<5 then easting=easting..string.rep("0",5-string.len(easting))end
if string.len(northing)<5 then northing=northing..string.rep("0",5-string.len(northing))end
local MGRS={
UTMZone=myparts[2],
MGRSDigraph=myparts[3],
Easting=easting,
Northing=northing,
}
local lat,lon=coord.MGRStoLL(MGRS)
local point=coord.LLtoLO(lat,lon,0)
local coord=COORDINATE:NewFromVec2({x=point.x,y=point.z})
return coord
end
function COORDINATE:NewFromMGRS(UTMZone,MGRSDigraph,Easting,Northing)
if string.len(Easting)<5 then Easting=tostring(Easting..string.rep("0",5-string.len(Easting)))end
if string.len(Northing)<5 then Northing=tostring(Northing..string.rep("0",5-string.len(Northing)))end
local MGRS={
UTMZone=UTMZone,
MGRSDigraph=MGRSDigraph,
Easting=tostring(Easting),
Northing=tostring(Northing),
}
local lat,lon=coord.MGRStoLL(MGRS)
local point=coord.LLtoLO(lat,lon,0)
local coord=COORDINATE:NewFromVec2({x=point.x,y=point.z})
return coord
end
function COORDINATE:ToStringFromRP(ReferenceCoord,ReferenceName,Controllable,Settings,MagVar)
self:F2({ReferenceCoord=ReferenceCoord,ReferenceName=ReferenceName})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
local IsAir=Controllable and Controllable:IsAirPlane()or false
if IsAir then
local DirectionVec3=ReferenceCoord:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=self:Get2DDistance(ReferenceCoord)
return"Targets are the last seen "..self:GetBRText(AngleRadians,Distance,Settings,nil,MagVar).." from "..ReferenceName
else
local DirectionVec3=ReferenceCoord:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=self:Get2DDistance(ReferenceCoord)
return"Target are located "..self:GetBRText(AngleRadians,Distance,Settings,nil,MagVar).." from "..ReferenceName
end
return nil
end
function COORDINATE:ToStringFromRPShort(ReferenceCoord,ReferenceName,Controllable,Settings,MagVar)
self:F2({ReferenceCoord=ReferenceCoord,ReferenceName=ReferenceName})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
local IsAir=Controllable and Controllable:IsAirPlane()or false
if IsAir then
local DirectionVec3=ReferenceCoord:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=self:Get2DDistance(ReferenceCoord)
return self:GetBRText(AngleRadians,Distance,Settings,nil,MagVar).." from "..ReferenceName
else
local DirectionVec3=ReferenceCoord:GetDirectionVec3(self)
local AngleRadians=self:GetAngleRadians(DirectionVec3)
local Distance=self:Get2DDistance(ReferenceCoord)
return self:GetBRText(AngleRadians,Distance,Settings,nil,MagVar).." from "..ReferenceName
end
return nil
end
function COORDINATE:ToStringA2G(Controllable,Settings,MagVar)
self:F2({Controllable=Controllable and Controllable:GetName()})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
if Settings:IsA2G_BR()then
if Controllable then
local Coordinate=Controllable:GetCoordinate()
return Controllable and self:ToStringBR(Coordinate,Settings,MagVar)or self:ToStringMGRS(Settings)
else
return self:ToStringMGRS(Settings)
end
end
if Settings:IsA2G_LL_DMS()then
return self:ToStringLLDMS(Settings)
end
if Settings:IsA2G_LL_DDM()then
return self:ToStringLLDDM(Settings)
end
if Settings:IsA2G_MGRS()then
return self:ToStringMGRS(Settings)
end
return nil
end
function COORDINATE:ToStringA2A(Controllable,Settings,MagVar)
self:F2({Controllable=Controllable and Controllable:GetName()})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
if Settings:IsA2A_BRAA()then
if Controllable then
local Coordinate=Controllable:GetCoordinate()
return self:ToStringBRA(Coordinate,Settings,MagVar)
else
return self:ToStringMGRS(Settings)
end
end
if Settings:IsA2A_BULLS()then
local Coalition=Controllable:GetCoalition()
return self:ToStringBULLS(Coalition,Settings,MagVar)
end
if Settings:IsA2A_LL_DMS()then
return self:ToStringLLDMS(Settings)
end
if Settings:IsA2A_LL_DDM()then
return self:ToStringLLDDM(Settings)
end
if Settings:IsA2A_MGRS()then
return self:ToStringMGRS(Settings)
end
return nil
end
function COORDINATE:ToString(Controllable,Settings)
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
local ModeA2A=nil
if ModeA2A==nil then
local IsAir=Controllable and(Controllable:IsAirPlane()or Controllable:IsHelicopter())or false
if IsAir then
ModeA2A=true
else
ModeA2A=false
end
end
if ModeA2A==true then
return self:ToStringA2A(Controllable,Settings)
else
return self:ToStringA2G(Controllable,Settings)
end
return nil
end
function COORDINATE:ToStringPressure(Controllable,Settings)
self:F2({Controllable=Controllable and Controllable:GetName()})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
return self:GetPressureText(nil,Settings)
end
function COORDINATE:ToStringWind(Controllable,Settings)
self:F2({Controllable=Controllable and Controllable:GetName()})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
return self:GetWindText(nil,Settings)
end
function COORDINATE:ToStringTemperature(Controllable,Settings)
self:F2({Controllable=Controllable and Controllable:GetName()})
local Settings=Settings or(Controllable and _DATABASE:GetPlayerSettings(Controllable:GetPlayerName()))or _SETTINGS
return self:GetTemperatureText(nil,Settings)
end
function COORDINATE:IsInSteepArea(Radius,Minelevation)
local steep=false
local elev=Minelevation or 8
local bdelta=0
local h0=self:GetLandHeight()
local radius=Radius or 50
local diam=radius*2
for i=0,150,30 do
local polar=math.fmod(i+180,360)
local c1=self:Translate(radius,i,false,false)
local c2=self:Translate(radius,polar,false,false)
local h1=c1:GetLandHeight()
local h2=c2:GetLandHeight()
local d1=math.abs(h1-h2)
local d2=math.abs(h0-h1)
local d3=math.abs(h0-h2)
local dm=d1>d2 and d1 or d2
local dm1=dm>d3 and dm or d3
bdelta=dm1>bdelta and dm1 or bdelta
self:T(string.format("d1=%d, d2=%d, d3=%d, max delta=%d",d1,d2,d3,bdelta))
end
local steepness=bdelta/(radius/100)
if steepness>=elev then steep=true end
return steep,math.floor(steepness)
end
function COORDINATE:IsInFlatArea(Radius,Minelevation)
local steep,elev=self:IsInSteepArea(Radius,Minelevation)
local flat=not steep
return flat,elev
end
function COORDINATE:GetRandomPointVec3InRadius(OuterRadius,InnerRadius)
return COORDINATE:NewFromVec3(self:GetRandomVec3InRadius(OuterRadius,InnerRadius))
end
end
do
POINT_VEC3={
ClassName="POINT_VEC3",
Metric=true,
RoutePointAltType={
BARO="BARO",
},
RoutePointType={
TakeOffParking="TakeOffParking",
TurningPoint="Turning Point",
},
RoutePointAction={
FromParkingArea="From Parking Area",
TurningPoint="Turning Point",
},
}
function POINT_VEC3:New(x,y,z)
local self=BASE:Inherit(self,COORDINATE:New(x,y,z))
self:F2(self)
return self
end
end
do
POINT_VEC2={
ClassName="POINT_VEC2",
}
function POINT_VEC2:New(x,y,LandHeightAdd)
local LandHeight=land.getHeight({["x"]=x,["y"]=y})
LandHeightAdd=LandHeightAdd or 0
LandHeight=LandHeight+LandHeightAdd
local self=BASE:Inherit(self,COORDINATE:New(x,LandHeight,y))
self:F2(self)
return self
end
end
do
VELOCITY={
ClassName="VELOCITY",
}
function VELOCITY:New(VelocityMps)
local self=BASE:Inherit(self,BASE:New())
self:F({})
self.Velocity=VelocityMps
return self
end
function VELOCITY:Set(VelocityMps)
self.Velocity=VelocityMps
return self
end
function VELOCITY:Get()
return self.Velocity
end
function VELOCITY:SetKmph(VelocityKmph)
self.Velocity=UTILS.KmphToMps(VelocityKmph)
return self
end
function VELOCITY:GetKmph()
return UTILS.MpsToKmph(self.Velocity)
end
function VELOCITY:SetMiph(VelocityMiph)
self.Velocity=UTILS.MiphToMps(VelocityMiph)
return self
end
function VELOCITY:GetMiph()
return UTILS.MpsToMiph(self.Velocity)
end
function VELOCITY:GetText(Settings)
local Settings=Settings or _SETTINGS
if self.Velocity~=0 then
if Settings:IsMetric()then
return string.format("%d km/h",UTILS.MpsToKmph(self.Velocity))
else
return string.format("%d mi/h",UTILS.MpsToMiph(self.Velocity))
end
else
return"stationary"
end
end
function VELOCITY:ToString(VelocityGroup,Settings)
self:F({Group=VelocityGroup and VelocityGroup:GetName()})
local Settings=Settings or(VelocityGroup and _DATABASE:GetPlayerSettings(VelocityGroup:GetPlayerName()))or _SETTINGS
return self:GetText(Settings)
end
end
do
VELOCITY_POSITIONABLE={
ClassName="VELOCITY_POSITIONABLE",
}
function VELOCITY_POSITIONABLE:New(Positionable)
local self=BASE:Inherit(self,VELOCITY:New())
self:F({})
self.Positionable=Positionable
return self
end
function VELOCITY_POSITIONABLE:Get()
return self.Positionable:GetVelocityMPS()or 0
end
function VELOCITY_POSITIONABLE:GetKmph()
return UTILS.MpsToKmph(self.Positionable:GetVelocityMPS()or 0)
end
function VELOCITY_POSITIONABLE:GetMiph()
return UTILS.MpsToMiph(self.Positionable:GetVelocityMPS()or 0)
end
function VELOCITY_POSITIONABLE:ToString()
self:F({Group=self.Positionable and self.Positionable:GetName()})
local Settings=Settings or(self.Positionable and _DATABASE:GetPlayerSettings(self.Positionable:GetPlayerName()))or _SETTINGS
self.Velocity=self.Positionable:GetVelocityMPS()
return self:GetText(Settings)
end
end
MESSAGE={
ClassName="MESSAGE",
MessageCategory=0,
MessageID=0,
}
MESSAGE.Type={
Update="Update",
Information="Information",
Briefing="Briefing Report",
Overview="Overview Report",
Detailed="Detailed Report",
}
function MESSAGE:New(Text,Duration,Category,ClearScreen)
local self=BASE:Inherit(self,BASE:New())
self:F({Text,Duration,Category})
self.MessageType=nil
if Category and Category~=""then
if Category:sub(-1)~="\n"then
self.MessageCategory=Category..": "
else
self.MessageCategory=Category:sub(1,-2)..":\n"
end
else
self.MessageCategory=""
end
self.ClearScreen=false
if ClearScreen~=nil then
self.ClearScreen=ClearScreen
end
self.MessageDuration=Duration or 5
self.MessageTime=timer.getTime()
self.MessageText=Text:gsub("^\n","",1):gsub("\n$","",1)
self.MessageSent=false
self.MessageGroup=false
self.MessageCoalition=false
return self
end
function MESSAGE:NewType(MessageText,MessageType,ClearScreen)
local self=BASE:Inherit(self,BASE:New())
self:F({MessageText})
self.MessageType=MessageType
self.ClearScreen=false
if ClearScreen~=nil then
self.ClearScreen=ClearScreen
end
self.MessageTime=timer.getTime()
self.MessageText=MessageText:gsub("^\n","",1):gsub("\n$","",1)
return self
end
function MESSAGE:Clear()
self:F()
self.ClearScreen=true
return self
end
function MESSAGE:ToClient(Client,Settings)
self:F(Client)
self:ToUnit(Client,Settings)
return self
end
function MESSAGE:ToGroup(Group,Settings)
self:F(Group.GroupName)
if Group and Group:IsAlive()then
if self.MessageType then
local Settings=Settings or(Group and _DATABASE:GetPlayerSettings(Group:GetPlayerName()))or _SETTINGS
self.MessageDuration=Settings:GetMessageTime(self.MessageType)
self.MessageCategory=""
end
if self.MessageDuration~=0 then
self:T(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$","").." / "..self.MessageDuration)
trigger.action.outTextForGroup(Group:GetID(),self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""),self.MessageDuration,self.ClearScreen)
end
end
return self
end
function MESSAGE:ToUnit(Unit,Settings)
self:F(Unit.IdentifiableName)
if Unit and Unit:IsAlive()then
if self.MessageType then
local Settings=Settings or(Unit and _DATABASE:GetPlayerSettings(Unit:GetPlayerName()))or _SETTINGS
self.MessageDuration=Settings:GetMessageTime(self.MessageType)
self.MessageCategory=""
end
if self.MessageDuration~=0 then
self:T(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$","").." / "..self.MessageDuration)
local ID=Unit:GetID()
trigger.action.outTextForUnit(Unit:GetID(),self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""),self.MessageDuration,self.ClearScreen)
end
end
return self
end
function MESSAGE:ToCountry(Country,Settings)
self:F(Country)
if Country then
if self.MessageType then
local Settings=Settings or _SETTINGS
self.MessageDuration=Settings:GetMessageTime(self.MessageType)
self.MessageCategory=""
end
if self.MessageDuration~=0 then
self:T(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$","").." / "..self.MessageDuration)
trigger.action.outTextForCountry(Country,self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""),self.MessageDuration,self.ClearScreen)
end
end
return self
end
function MESSAGE:ToCountryIf(Country,Condition,Settings)
self:F(Country)
if Country and Condition==true then
self:ToCountry(Country,Settings)
end
return self
end
function MESSAGE:ToBlue()
self:F()
self:ToCoalition(coalition.side.BLUE)
return self
end
function MESSAGE:ToRed()
self:F()
self:ToCoalition(coalition.side.RED)
return self
end
function MESSAGE:ToCoalition(CoalitionSide,Settings)
self:F(CoalitionSide)
if self.MessageType then
local Settings=Settings or _SETTINGS
self.MessageDuration=Settings:GetMessageTime(self.MessageType)
self.MessageCategory=""
end
if CoalitionSide then
if self.MessageDuration~=0 then
self:T(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$","").." / "..self.MessageDuration)
trigger.action.outTextForCoalition(CoalitionSide,self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""),self.MessageDuration,self.ClearScreen)
end
end
self.CoalitionSide=CoalitionSide
return self
end
function MESSAGE:ToCoalitionIf(CoalitionSide,Condition)
self:F(CoalitionSide)
if Condition and Condition==true then
self:ToCoalition(CoalitionSide)
end
return self
end
function MESSAGE:ToAll(Settings,Delay)
self:F()
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MESSAGE.ToAll,self,Settings,0)
else
if self.MessageType then
local Settings=Settings or _SETTINGS
self.MessageDuration=Settings:GetMessageTime(self.MessageType)
self.MessageCategory=""
end
if self.MessageDuration~=0 then
self:T(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$","").." / "..self.MessageDuration)
trigger.action.outText(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""),self.MessageDuration,self.ClearScreen)
end
end
return self
end
function MESSAGE:ToAllIf(Condition)
if Condition and Condition==true then
self:ToAll()
end
return self
end
function MESSAGE:ToLog()
env.info(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""))
return self
end
function MESSAGE:ToLogIf(Condition)
if Condition and Condition==true then
env.info(self.MessageCategory..self.MessageText:gsub("\n$",""):gsub("\n$",""))
end
return self
end
_MESSAGESRS={}
function MESSAGE.SetMSRS(PathToSRS,Port,PathToCredentials,Frequency,Modulation,Gender,Culture,Voice,Coalition,Volume,Label,Coordinate,Backend)
_MESSAGESRS.PathToSRS=PathToSRS or MSRS.path or"C:\\Program Files\\DCS-SimpleRadio-Standalone"
_MESSAGESRS.frequency=Frequency or MSRS.frequencies or 243
_MESSAGESRS.modulation=Modulation or MSRS.modulations or radio.modulation.AM
_MESSAGESRS.MSRS=MSRS:New(_MESSAGESRS.PathToSRS,_MESSAGESRS.frequency,_MESSAGESRS.modulation)
_MESSAGESRS.coalition=Coalition or MSRS.coalition or coalition.side.NEUTRAL
_MESSAGESRS.MSRS:SetCoalition(_MESSAGESRS.coalition)
_MESSAGESRS.coordinate=Coordinate
if Coordinate then
_MESSAGESRS.MSRS:SetCoordinate(Coordinate)
end
if Backend then
_MESSAGESRS.MSRS:SetBackend(Backend)
end
_MESSAGESRS.Culture=Culture or MSRS.culture or"en-GB"
_MESSAGESRS.MSRS:SetCulture(Culture)
_MESSAGESRS.Gender=Gender or MSRS.gender or"female"
_MESSAGESRS.MSRS:SetGender(Gender)
if PathToCredentials then
_MESSAGESRS.MSRS:SetProviderOptionsGoogle(PathToCredentials)
_MESSAGESRS.MSRS:SetProvider(MSRS.Provider.GOOGLE)
end
_MESSAGESRS.label=Label or MSRS.Label or"MESSAGE"
_MESSAGESRS.MSRS:SetLabel(_MESSAGESRS.label)
_MESSAGESRS.port=Port or MSRS.port or 5002
_MESSAGESRS.MSRS:SetPort(_MESSAGESRS.port)
_MESSAGESRS.volume=Volume or MSRS.volume or 1
_MESSAGESRS.MSRS:SetVolume(_MESSAGESRS.volume)
if Voice then _MESSAGESRS.MSRS:SetVoice(Voice)end
_MESSAGESRS.voice=Voice or MSRS.voice
_MESSAGESRS.SRSQ=MSRSQUEUE:New(_MESSAGESRS.label)
end
function MESSAGE:ToSRS(frequency,modulation,gender,culture,voice,coalition,volume,coordinate)
local tgender=gender or _MESSAGESRS.Gender
if _MESSAGESRS.SRSQ then
if voice then
_MESSAGESRS.MSRS:SetVoice(voice or _MESSAGESRS.voice)
end
if coordinate then
_MESSAGESRS.MSRS:SetCoordinate(coordinate)
end
local category=string.gsub(self.MessageCategory,":","")
_MESSAGESRS.SRSQ:NewTransmission(self.MessageText,nil,_MESSAGESRS.MSRS,0.5,1,nil,nil,nil,frequency or _MESSAGESRS.frequency,modulation or _MESSAGESRS.modulation,gender or _MESSAGESRS.Gender,culture or _MESSAGESRS.Culture,nil,volume or _MESSAGESRS.volume,category,coordinate or _MESSAGESRS.coordinate)
end
return self
end
function MESSAGE:ToSRSBlue(frequency,modulation,gender,culture,voice,volume,coordinate)
self:ToSRS(frequency,modulation,gender,culture,voice,coalition.side.BLUE,volume,coordinate)
return self
end
function MESSAGE:ToSRSRed(frequency,modulation,gender,culture,voice,volume,coordinate)
self:ToSRS(frequency,modulation,gender,culture,voice,coalition.side.RED,volume,coordinate)
return self
end
function MESSAGE:ToSRSAll(frequency,modulation,gender,culture,voice,volume,coordinate)
self:ToSRS(frequency,modulation,gender,culture,voice,coalition.side.NEUTRAL,volume,coordinate)
return self
end
do
FSM={
ClassName="FSM",
}
function FSM:New()
self=BASE:Inherit(self,BASE:New())
self.options=options or{}
self.options.subs=self.options.subs or{}
self.current=self.options.initial or'none'
self.Events={}
self.subs={}
self.endstates={}
self.Scores={}
self._StartState="none"
self._Transitions={}
self._Processes={}
self._EndStates={}
self._Scores={}
self._EventSchedules={}
self.CallScheduler=SCHEDULER:New(self)
return self
end
function FSM:SetStartState(State)
self._StartState=State
self.current=State
end
function FSM:GetStartState()
return self._StartState or{}
end
function FSM:AddTransition(From,Event,To)
local Transition={}
Transition.From=From
Transition.Event=Event
Transition.To=To
self._Transitions[Transition]=Transition
self:_eventmap(self.Events,Transition)
end
function FSM:GetTransitions()
return self._Transitions or{}
end
function FSM:AddProcess(From,Event,Process,ReturnEvents)
local Sub={}
Sub.From=From
Sub.Event=Event
Sub.fsm=Process
Sub.StartEvent="Start"
Sub.ReturnEvents=ReturnEvents
self._Processes[Sub]=Sub
self:_submap(self.subs,Sub,nil)
self:AddTransition(From,Event,From)
return Process
end
function FSM:GetProcesses()
self:F({Processes=self._Processes})
return self._Processes or{}
end
function FSM:GetProcess(From,Event)
for ProcessID,Process in pairs(self:GetProcesses())do
if Process.From==From and Process.Event==Event then
return Process.fsm
end
end
error("Sub-Process from state "..From.." with event "..Event.." not found!")
end
function FSM:SetProcess(From,Event,Fsm)
for ProcessID,Process in pairs(self:GetProcesses())do
if Process.From==From and Process.Event==Event then
Process.fsm=Fsm
return true
end
end
error("Sub-Process from state "..From.." with event "..Event.." not found!")
end
function FSM:AddEndState(State)
self._EndStates[State]=State
self.endstates[State]=State
end
function FSM:GetEndStates()
return self._EndStates or{}
end
function FSM:AddScore(State,ScoreText,Score)
self:F({State,ScoreText,Score})
self._Scores[State]=self._Scores[State]or{}
self._Scores[State].ScoreText=ScoreText
self._Scores[State].Score=Score
return self
end
function FSM:AddScoreProcess(From,Event,State,ScoreText,Score)
self:F({From,Event,State,ScoreText,Score})
local Process=self:GetProcess(From,Event)
Process._Scores[State]=Process._Scores[State]or{}
Process._Scores[State].ScoreText=ScoreText
Process._Scores[State].Score=Score
return Process
end
function FSM:GetScores()
return self._Scores or{}
end
function FSM:GetSubs()
return self.options.subs
end
function FSM:LoadCallBacks(CallBackTable)
for name,callback in pairs(CallBackTable or{})do
self[name]=callback
end
end
function FSM:_eventmap(Events,EventStructure)
local Event=EventStructure.Event
local __Event="__"..EventStructure.Event
self[Event]=self[Event]or self:_create_transition(Event)
self[__Event]=self[__Event]or self:_delayed_transition(Event)
Events[Event]=self.Events[Event]or{map={}}
self:_add_to_map(Events[Event].map,EventStructure)
end
function FSM:_submap(subs,sub,name)
subs[sub.From]=subs[sub.From]or{}
subs[sub.From][sub.Event]=subs[sub.From][sub.Event]or{}
subs[sub.From][sub.Event][sub]={}
subs[sub.From][sub.Event][sub].fsm=sub.fsm
subs[sub.From][sub.Event][sub].StartEvent=sub.StartEvent
subs[sub.From][sub.Event][sub].ReturnEvents=sub.ReturnEvents or{}
subs[sub.From][sub.Event][sub].name=name
subs[sub.From][sub.Event][sub].fsmparent=self
end
function FSM:_call_handler(step,trigger,params,EventName)
local handler=step..trigger
if self[handler]then
self._EventSchedules[EventName]=nil
local ErrorHandler=function(errmsg)
env.info("Error in SCHEDULER function:"..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
local Result,Value=xpcall(function()
return self[handler](self,unpack(params))
end,ErrorHandler)
return Value
end
end
function FSM._handler(self,EventName,...)
local Can,To=self:can(EventName)
if To=="*"then
To=self.current
end
if Can then
local From=self.current
local Params={From,EventName,To,...}
if self["onleave"..From]or
self["OnLeave"..From]or
self["onbefore"..EventName]or
self["OnBefore"..EventName]or
self["onafter"..EventName]or
self["OnAfter"..EventName]or
self["onenter"..To]or
self["OnEnter"..To]then
if self:_call_handler("onbefore",EventName,Params,EventName)==false then
self:T("*** FSM ***    Cancel".." *** "..self.current.." --> "..EventName.." --> "..To.." *** onbefore"..EventName)
return false
else
if self:_call_handler("OnBefore",EventName,Params,EventName)==false then
self:T("*** FSM ***    Cancel".." *** "..self.current.." --> "..EventName.." --> "..To.." *** OnBefore"..EventName)
return false
else
if self:_call_handler("onleave",From,Params,EventName)==false then
self:T("*** FSM ***    Cancel".." *** "..self.current.." --> "..EventName.." --> "..To.." *** onleave"..From)
return false
else
if self:_call_handler("OnLeave",From,Params,EventName)==false then
self:T("*** FSM ***    Cancel".." *** "..self.current.." --> "..EventName.." --> "..To.." *** OnLeave"..From)
return false
end
end
end
end
else
local ClassName=self:GetClassName()
if ClassName=="FSM"then
self:T("*** FSM ***    Transit *** "..self.current.." --> "..EventName.." --> "..To)
end
if ClassName=="FSM_TASK"then
self:T("*** FSM ***    Transit *** "..self.current.." --> "..EventName.." --> "..To.." *** Task: "..self.TaskName)
end
if ClassName=="FSM_CONTROLLABLE"then
self:T("*** FSM ***    Transit *** "..self.current.." --> "..EventName.." --> "..To.." *** TaskUnit: "..self.Controllable.ControllableName.." *** ")
end
if ClassName=="FSM_PROCESS"then
self:T("*** FSM ***    Transit *** "..self.current.." --> "..EventName.." --> "..To.." *** Task: "..self.Task:GetName()..", TaskUnit: "..self.Controllable.ControllableName.." *** ")
end
end
self.current=To
local execute=true
local subtable=self:_gosub(From,EventName)
for _,sub in pairs(subtable)do
self:T("*** FSM ***    Sub *** "..sub.StartEvent)
sub.fsm.fsmparent=self
sub.fsm.ReturnEvents=sub.ReturnEvents
sub.fsm[sub.StartEvent](sub.fsm)
execute=false
end
local fsmparent,Event=self:_isendstate(To)
if fsmparent and Event then
self:T("*** FSM ***    End *** "..Event)
self:_call_handler("onenter",To,Params,EventName)
self:_call_handler("OnEnter",To,Params,EventName)
self:_call_handler("onafter",EventName,Params,EventName)
self:_call_handler("OnAfter",EventName,Params,EventName)
self:_call_handler("onstate","change",Params,EventName)
fsmparent[Event](fsmparent)
execute=false
end
if execute then
self:_call_handler("onafter",EventName,Params,EventName)
self:_call_handler("OnAfter",EventName,Params,EventName)
self:_call_handler("onenter",To,Params,EventName)
self:_call_handler("OnEnter",To,Params,EventName)
self:_call_handler("onstate","change",Params,EventName)
end
else
self:T("*** FSM *** NO Transition *** "..self.current.." --> "..EventName.." -->  ? ")
end
return nil
end
function FSM:_delayed_transition(EventName)
return function(self,DelaySeconds,...)
self:T3("Delayed Event: "..EventName)
local CallID=0
if DelaySeconds~=nil then
if DelaySeconds<0 then
DelaySeconds=math.abs(DelaySeconds)
if not self._EventSchedules[EventName]then
CallID=self.CallScheduler:Schedule(self,self._handler,{EventName,...},DelaySeconds or 1,nil,nil,nil,4,true)
self._EventSchedules[EventName]=CallID
self:T2(string.format("NEGATIVE Event %s delayed by %.3f sec SCHEDULED with CallID=%s",EventName,DelaySeconds,tostring(CallID)))
else
self:T2(string.format("NEGATIVE Event %s delayed by %.3f sec CANCELLED as we already have such an event in the queue.",EventName,DelaySeconds))
end
else
CallID=self.CallScheduler:Schedule(self,self._handler,{EventName,...},DelaySeconds or 1,nil,nil,nil,4,true)
self:T2(string.format("Event %s delayed by %.3f sec SCHEDULED with CallID=%s",EventName,DelaySeconds,tostring(CallID)))
end
else
error("FSM: An asynchronous event trigger requires a DelaySeconds parameter!!! This can be positive or negative! Sorry, but will not process this.")
end
end
end
function FSM:_create_transition(EventName)
return function(self,...)
return self._handler(self,EventName,...)
end
end
function FSM:_gosub(ParentFrom,ParentEvent)
local fsmtable={}
if self.subs[ParentFrom]and self.subs[ParentFrom][ParentEvent]then
return self.subs[ParentFrom][ParentEvent]
else
return{}
end
end
function FSM:_isendstate(Current)
local FSMParent=self.fsmparent
if FSMParent and self.endstates[Current]then
FSMParent.current=Current
local ParentFrom=FSMParent.current
local Event=self.ReturnEvents[Current]
if Event then
return FSMParent,Event
else
end
end
return nil
end
function FSM:_add_to_map(Map,Event)
self:F3({Map,Event})
if type(Event.From)=='string'then
Map[Event.From]=Event.To
else
for _,From in ipairs(Event.From)do
Map[From]=Event.To
end
end
end
function FSM:GetState()
return self.current
end
function FSM:GetCurrentState()
return self.current
end
function FSM:Is(State)
return self.current==State
end
function FSM:is(state)
return self.current==state
end
function FSM:can(e)
local Event=self.Events[e]
local To=Event and Event.map[self.current]or Event.map['*']
return To~=nil,To
end
function FSM:cannot(e)
return not self:can(e)
end
end
do
FSM_CONTROLLABLE={
ClassName="FSM_CONTROLLABLE",
}
function FSM_CONTROLLABLE:New(Controllable)
local self=BASE:Inherit(self,FSM:New())
if Controllable then
self:SetControllable(Controllable)
end
self:AddTransition("*","Stop","Stopped")
return self
end
function FSM_CONTROLLABLE:OnAfterStop(Controllable,From,Event,To)
self.CallScheduler:Clear()
end
function FSM_CONTROLLABLE:SetControllable(FSMControllable)
self.Controllable=FSMControllable
end
function FSM_CONTROLLABLE:GetControllable()
return self.Controllable
end
function FSM_CONTROLLABLE:_call_handler(step,trigger,params,EventName)
local handler=step..trigger
local ErrorHandler=function(errmsg)
env.info("Error in SCHEDULER function:"..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
if self[handler]then
self:T("*** FSM ***    "..step.." *** "..params[1].." --> "..params[2].." --> "..params[3].." *** TaskUnit: "..self.Controllable:GetName())
self._EventSchedules[EventName]=nil
local Result,Value=xpcall(function()
return self[handler](self,self.Controllable,unpack(params))
end,ErrorHandler)
return Value
end
end
end
do
FSM_PROCESS={ClassName="FSM_PROCESS"}
function FSM_PROCESS:New(Controllable,Task)
local self=BASE:Inherit(self,FSM_CONTROLLABLE:New())
self:Assign(Controllable,Task)
return self
end
function FSM_PROCESS:Init(FsmProcess)
self:T("No Initialisation")
end
function FSM_PROCESS:_call_handler(step,trigger,params,EventName)
local handler=step..trigger
local ErrorHandler=function(errmsg)
env.info("Error in FSM_PROCESS call handler:"..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
if self[handler]then
if handler~="onstatechange"then
self:T("*** FSM ***    "..step.." *** "..params[1].." --> "..params[2].." --> "..params[3].." *** Task: "..self.Task:GetName()..", TaskUnit: "..self.Controllable:GetName())
end
self._EventSchedules[EventName]=nil
local Result,Value
if self.Controllable and self.Controllable:IsAlive()==true then
Result,Value=xpcall(function()
return self[handler](self,self.Controllable,self.Task,unpack(params))
end,ErrorHandler)
end
return Value
end
end
function FSM_PROCESS:Copy(Controllable,Task)
local NewFsm=self:New(Controllable,Task)
NewFsm:Assign(Controllable,Task)
NewFsm:Init(self)
NewFsm:SetStartState(self:GetStartState())
for TransitionID,Transition in pairs(self:GetTransitions())do
NewFsm:AddTransition(Transition.From,Transition.Event,Transition.To)
end
for ProcessID,Process in pairs(self:GetProcesses())do
local FsmProcess=NewFsm:AddProcess(Process.From,Process.Event,Process.fsm:Copy(Controllable,Task),Process.ReturnEvents)
end
for EndStateID,EndState in pairs(self:GetEndStates())do
NewFsm:AddEndState(EndState)
end
for ScoreID,Score in pairs(self:GetScores())do
NewFsm:AddScore(ScoreID,Score.ScoreText,Score.Score)
end
return NewFsm
end
function FSM_PROCESS:Remove()
self:F({self:GetClassNameAndID()})
self:F("Clearing Schedules")
self.CallScheduler:Clear()
for ProcessID,Process in pairs(self:GetProcesses())do
if Process.fsm then
Process.fsm:Remove()
Process.fsm=nil
end
end
return self
end
function FSM_PROCESS:SetTask(Task)
self.Task=Task
return self
end
function FSM_PROCESS:GetTask()
return self.Task
end
function FSM_PROCESS:GetMission()
return self.Task.Mission
end
function FSM_PROCESS:GetCommandCenter()
return self:GetTask():GetMission():GetCommandCenter()
end
function FSM_PROCESS:Message(Message)
self:F({Message=Message})
local CC=self:GetCommandCenter()
local TaskGroup=self.Controllable:GetGroup()
local PlayerName=self.Controllable:GetPlayerName()
PlayerName=PlayerName and" ("..PlayerName..")"or""
local Callsign=self.Controllable:GetCallsign()
local Prefix=Callsign and" @ "..Callsign..PlayerName or""
Message=Prefix..": "..Message
CC:MessageToGroup(Message,TaskGroup)
end
function FSM_PROCESS:Assign(ProcessUnit,Task)
self:SetControllable(ProcessUnit)
self:SetTask(Task)
return self
end
function FSM_PROCESS:onenterFailed(ProcessUnit,Task,From,Event,To)
self:T("*** FSM ***    Failed *** "..Task:GetName().."/"..ProcessUnit:GetName().." *** "..From.." --> "..Event.." --> "..To)
self.Task:Fail()
end
function FSM_PROCESS:onstatechange(ProcessUnit,Task,From,Event,To)
if From~=To then
self:T("*** FSM ***    Change *** "..Task:GetName().."/"..ProcessUnit:GetName().." *** "..From.." --> "..Event.." --> "..To)
end
if self._Scores[To]then
local Task=self.Task
local Scoring=Task:GetScoring()
if Scoring then
Scoring:_AddMissionTaskScore(Task.Mission,ProcessUnit,self._Scores[To].ScoreText,self._Scores[To].Score)
end
end
end
end
do
FSM_TASK={
ClassName="FSM_TASK",
}
function FSM_TASK:New(TaskName)
local self=BASE:Inherit(self,FSM_CONTROLLABLE:New())
self["onstatechange"]=self.OnStateChange
self.TaskName=TaskName
return self
end
function FSM_TASK:_call_handler(step,trigger,params,EventName)
local handler=step..trigger
local ErrorHandler=function(errmsg)
env.info("Error in SCHEDULER function:"..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
if self[handler]then
self:T("*** FSM ***    "..step.." *** "..params[1].." --> "..params[2].." --> "..params[3].." *** Task: "..self.TaskName)
self._EventSchedules[EventName]=nil
local Result,Value=xpcall(function()
return self[handler](self,unpack(params))
end,ErrorHandler)
return Value
end
end
end
do
FSM_SET={
ClassName="FSM_SET",
}
function FSM_SET:New(FSMSet)
self=BASE:Inherit(self,FSM:New())
if FSMSet then
self:Set(FSMSet)
end
return self
end
function FSM_SET:Set(FSMSet)
self:F(FSMSet)
self.Set=FSMSet
end
function FSM_SET:Get()
return self.Set
end
function FSM_SET:_call_handler(step,trigger,params,EventName)
local handler=step..trigger
if self[handler]then
self:T("*** FSM ***    "..step.." *** "..params[1].." --> "..params[2].." --> "..params[3])
self._EventSchedules[EventName]=nil
return self[handler](self,self.Set,unpack(params))
end
end
end
SPAWN={
ClassName="SPAWN",
SpawnTemplatePrefix=nil,
SpawnAliasPrefix=nil,
}
SPAWN.Takeoff={
Air=1,
Runway=2,
Hot=3,
Cold=4,
}
function SPAWN:New(SpawnTemplatePrefix)
local self=BASE:Inherit(self,BASE:New())
local TemplateGroup=GROUP:FindByName(SpawnTemplatePrefix)
if TemplateGroup then
self.SpawnTemplatePrefix=SpawnTemplatePrefix
self.SpawnIndex=0
self.SpawnCount=0
self.AliveUnits=0
self.SpawnIsScheduled=false
self.SpawnTemplate=self._GetTemplate(self,SpawnTemplatePrefix)
self.Repeat=false
self.UnControlled=false
self.SpawnInitLimit=false
self.SpawnMaxUnitsAlive=0
self.SpawnMaxGroups=0
self.SpawnRandomize=false
self.SpawnVisible=false
self.AIOnOff=true
self.SpawnUnControlled=false
self.SpawnInitKeepUnitNames=false
self.DelayOnOff=false
self.SpawnGrouping=nil
self.SpawnInitLivery=nil
self.SpawnInitSkill=nil
self.SpawnInitFreq=nil
self.SpawnInitModu=nil
self.SpawnInitRadio=nil
self.SpawnInitModex=nil
self.SpawnInitModexPrefix=nil
self.SpawnInitModexPostfix=nil
self.SpawnInitAirbase=nil
self.TweakedTemplate=false
self.SpawnRandomCallsign=false
self.SpawnGroups={}
else
error("SPAWN:New: There is no group declared in the mission editor with SpawnTemplatePrefix = '"..SpawnTemplatePrefix.."'")
end
self:SetEventPriority(5)
self.SpawnHookScheduler=SCHEDULER:New(nil)
return self
end
function SPAWN:NewWithAlias(SpawnTemplatePrefix,SpawnAliasPrefix)
local self=BASE:Inherit(self,BASE:New())
local TemplateGroup=GROUP:FindByName(SpawnTemplatePrefix)
if TemplateGroup then
self.SpawnTemplatePrefix=SpawnTemplatePrefix
self.SpawnAliasPrefix=SpawnAliasPrefix
self.SpawnIndex=0
self.SpawnCount=0
self.AliveUnits=0
self.SpawnIsScheduled=false
self.SpawnTemplate=self._GetTemplate(self,SpawnTemplatePrefix)
self.Repeat=false
self.UnControlled=false
self.SpawnInitLimit=false
self.SpawnMaxUnitsAlive=0
self.SpawnMaxGroups=0
self.SpawnRandomize=false
self.SpawnVisible=false
self.AIOnOff=true
self.SpawnUnControlled=false
self.SpawnInitKeepUnitNames=false
self.DelayOnOff=false
self.SpawnGrouping=nil
self.SpawnInitLivery=nil
self.SpawnInitSkill=nil
self.SpawnInitFreq=nil
self.SpawnInitModu=nil
self.SpawnInitRadio=nil
self.SpawnInitModex=nil
self.SpawnInitModexPrefix=nil
self.SpawnInitModexPostfix=nil
self.SpawnInitAirbase=nil
self.TweakedTemplate=false
self.SpawnGroups={}
else
error("SPAWN:New: There is no group declared in the mission editor with SpawnTemplatePrefix = '"..SpawnTemplatePrefix.."'")
end
self:SetEventPriority(5)
self.SpawnHookScheduler=SCHEDULER:New(nil)
return self
end
function SPAWN:NewFromTemplate(SpawnTemplate,SpawnTemplatePrefix,SpawnAliasPrefix,NoMooseNamingPostfix)
local self=BASE:Inherit(self,BASE:New())
if SpawnTemplatePrefix==nil or SpawnTemplatePrefix==""then
BASE:I("ERROR: in function NewFromTemplate, required parameter SpawnTemplatePrefix is not set")
return nil
end
if SpawnTemplate then
self.SpawnTemplate=UTILS.DeepCopy(SpawnTemplate)
self.SpawnTemplatePrefix=SpawnTemplatePrefix
self.SpawnAliasPrefix=SpawnAliasPrefix or SpawnTemplatePrefix
self.SpawnTemplate.name=SpawnTemplatePrefix
self.SpawnIndex=0
self.SpawnCount=0
self.AliveUnits=0
self.SpawnIsScheduled=false
self.Repeat=false
self.UnControlled=false
self.SpawnInitLimit=false
self.SpawnMaxUnitsAlive=0
self.SpawnMaxGroups=0
self.SpawnRandomize=false
self.SpawnVisible=false
self.AIOnOff=true
self.SpawnUnControlled=false
self.SpawnInitKeepUnitNames=false
self.DelayOnOff=false
self.Grouping=nil
self.SpawnInitLivery=nil
self.SpawnInitSkill=nil
self.SpawnInitFreq=nil
self.SpawnInitModu=nil
self.SpawnInitRadio=nil
self.SpawnInitModex=nil
self.SpawnInitModexPrefix=nil
self.SpawnInitModexPostfix=nil
self.SpawnInitAirbase=nil
self.TweakedTemplate=true
self.MooseNameing=true
if NoMooseNamingPostfix==true then
self.MooseNameing=false
end
self.SpawnGroups={}
else
error("There is no template provided for SpawnTemplatePrefix = '"..SpawnTemplatePrefix.."'")
end
self:SetEventPriority(5)
self.SpawnHookScheduler=SCHEDULER:New(nil)
return self
end
function SPAWN:InitLimit(SpawnMaxUnitsAlive,SpawnMaxGroups)
self.SpawnInitLimit=true
self.SpawnMaxUnitsAlive=SpawnMaxUnitsAlive
self.SpawnMaxGroups=SpawnMaxGroups
for SpawnGroupID=1,self.SpawnMaxGroups do
self:_InitializeSpawnGroups(SpawnGroupID)
end
return self
end
function SPAWN:InitKeepUnitNames(KeepUnitNames)
self.SpawnInitKeepUnitNames=false
if KeepUnitNames==true then self.SpawnInitKeepUnitNames=true end
return self
end
function SPAWN:InitLateActivated(LateActivated)
self.LateActivated=LateActivated or true
return self
end
function SPAWN:InitAirbase(AirbaseName,Takeoff,TerminalType)
self.SpawnInitAirbase=AIRBASE:FindByName(AirbaseName)
self.SpawnInitTakeoff=Takeoff or SPAWN.Takeoff.Hot
self.SpawnInitTerminalType=TerminalType
return self
end
function SPAWN:InitHeading(HeadingMin,HeadingMax)
self.SpawnInitHeadingMin=HeadingMin
self.SpawnInitHeadingMax=HeadingMax
return self
end
function SPAWN:InitGroupHeading(HeadingMin,HeadingMax,unitVar)
self:F({HeadingMin=HeadingMin,HeadingMax=HeadingMax,unitVar=unitVar})
self.SpawnInitGroupHeadingMin=HeadingMin
self.SpawnInitGroupHeadingMax=HeadingMax
self.SpawnInitGroupUnitVar=unitVar
return self
end
function SPAWN:InitCoalition(Coalition)
self:F({coalition=Coalition})
self.SpawnInitCoalition=Coalition
return self
end
function SPAWN:InitCountry(Country)
self.SpawnInitCountry=Country
return self
end
function SPAWN:InitCategory(Category)
self.SpawnInitCategory=Category
return self
end
function SPAWN:InitLivery(Livery)
self.SpawnInitLivery=Livery
return self
end
function SPAWN:InitSkill(Skill)
if Skill:lower()=="average"then
self.SpawnInitSkill="Average"
elseif Skill:lower()=="good"then
self.SpawnInitSkill="Good"
elseif Skill:lower()=="excellent"then
self.SpawnInitSkill="Excellent"
elseif Skill:lower()=="random"then
self.SpawnInitSkill="Random"
else
self.SpawnInitSkill="High"
end
return self
end
function SPAWN:InitSTN(Octal)
self.SpawnInitSTN=Octal or 77777
local num=UTILS.OctalToDecimal(Octal)
if num==nil or num<1 then
self:E("WARNING - STN "..tostring(Octal).." is not valid!")
return self
end
if _DATABASE.STNS[num]~=nil then
self:E("WARNING - STN already assigned: "..tostring(Octal).." is used for ".._DATABASE.STNS[Octal])
end
return self
end
function SPAWN:InitSADL(Octal)
self.SpawnInitSADL=Octal or 7777
local num=UTILS.OctalToDecimal(Octal)
if num==nil or num<1 then
self:E("WARNING - SADL "..tostring(Octal).." is not valid!")
return self
end
if _DATABASE.SADL[num]~=nil then
self:E("WARNING - SADL already assigned: "..tostring(Octal).." is used for ".._DATABASE.SADL[Octal])
end
return self
end
function SPAWN:InitSpeedMps(MPS)
if MPS==nil or tonumber(MPS)<0 then
MPS=125
end
self.InitSpeed=MPS
return self
end
function SPAWN:InitSpeedKnots(Knots)
if Knots==nil or tonumber(Knots)<0 then
Knots=300
end
self.InitSpeed=UTILS.KnotsToMps(Knots)
return self
end
function SPAWN:InitSpeedKph(KPH)
if KPH==nil or tonumber(KPH)<0 then
KPH=UTILS.KnotsToKmph(300)
end
self.InitSpeed=UTILS.KmphToMps(KPH)
return self
end
function SPAWN:InitRadioCommsOnOff(switch)
self.SpawnInitRadio=switch or true
return self
end
function SPAWN:InitRadioFrequency(frequency)
self.SpawnInitFreq=frequency
return self
end
function SPAWN:InitRadioModulation(modulation)
if modulation and modulation:lower()=="fm"then
self.SpawnInitModu=radio.modulation.FM
else
self.SpawnInitModu=radio.modulation.AM
end
return self
end
function SPAWN:InitModex(modex,prefix,postfix)
if modex then
self.SpawnInitModex=tonumber(modex)
end
self.SpawnInitModexPrefix=prefix
self.SpawnInitModexPostfix=postfix
return self
end
function SPAWN:InitRandomizeRoute(SpawnStartPoint,SpawnEndPoint,SpawnRadius,SpawnHeight)
self.SpawnRandomizeRoute=true
self.SpawnRandomizeRouteStartPoint=SpawnStartPoint
self.SpawnRandomizeRouteEndPoint=SpawnEndPoint
self.SpawnRandomizeRouteRadius=SpawnRadius
self.SpawnRandomizeRouteHeight=SpawnHeight
for GroupID=1,self.SpawnMaxGroups do
self:_RandomizeRoute(GroupID)
end
return self
end
function SPAWN:InitRandomizePosition(RandomizePosition,OuterRadius,InnerRadius)
self.SpawnRandomizePosition=RandomizePosition or false
self.SpawnRandomizePositionOuterRadius=OuterRadius or 0
self.SpawnRandomizePositionInnerRadius=InnerRadius or 0
for GroupID=1,self.SpawnMaxGroups do
self:_RandomizeRoute(GroupID)
end
return self
end
function SPAWN:InitRandomizeUnits(RandomizeUnits,OuterRadius,InnerRadius)
self.SpawnRandomizeUnits=RandomizeUnits or false
self.SpawnOuterRadius=OuterRadius or 0
self.SpawnInnerRadius=InnerRadius or 0
for GroupID=1,self.SpawnMaxGroups do
self:_RandomizeRoute(GroupID)
end
return self
end
function SPAWN:InitSetUnitRelativePositions(Positions)
self.SpawnUnitsWithRelativePositions=true
self.UnitsRelativePositions=Positions
return self
end
function SPAWN:InitSetUnitAbsolutePositions(Positions)
self.SpawnUnitsWithAbsolutePositions=true
self.UnitsAbsolutePositions=Positions
return self
end
function SPAWN:InitRandomizeTemplate(SpawnTemplatePrefixTable)
local temptable={}
for _,_temp in pairs(SpawnTemplatePrefixTable)do
temptable[#temptable+1]=_temp
end
self.SpawnTemplatePrefixTable=UTILS.ShuffleTable(temptable)
self.SpawnRandomizeTemplate=true
for SpawnGroupID=1,self.SpawnMaxGroups do
self:_RandomizeTemplate(SpawnGroupID,RandomizePositionInZone)
end
return self
end
function SPAWN:InitRandomizeTemplateSet(SpawnTemplateSet,RandomizePositionInZone)
local setnames=SpawnTemplateSet:GetSetNames()
self:InitRandomizeTemplate(setnames,RandomizePositionInZone)
return self
end
function SPAWN:InitRandomizeTemplatePrefixes(SpawnTemplatePrefixes,RandomizePositionInZone)
local SpawnTemplateSet=SET_GROUP:New():FilterPrefixes(SpawnTemplatePrefixes):FilterOnce()
self:InitRandomizeTemplateSet(SpawnTemplateSet,RandomizePositionInZone)
return self
end
function SPAWN:InitGrouping(Grouping)
self.SpawnGrouping=Grouping
return self
end
function SPAWN:InitRandomizeZones(SpawnZoneTable,RandomizePositionInZone)
local temptable={}
for _,_temp in pairs(SpawnZoneTable)do
temptable[#temptable+1]=_temp
end
self.SpawnZoneTable=UTILS.ShuffleTable(temptable)
self.SpawnRandomizeZones=true
for SpawnGroupID=1,self.SpawnMaxGroups do
self:_RandomizeZones(SpawnGroupID,RandomizePositionInZone)
end
return self
end
function SPAWN:InitRandomizeCallsign()
self.SpawnRandomCallsign=true
return self
end
function SPAWN:InitCallSign(ID,Name,Minor,Major)
local Name=Name or"Enfield"
self.SpawnInitCallSign=true
self.SpawnInitCallSignID=ID or 1
self.SpawnInitCallSignMinor=Minor or 1
self.SpawnInitCallSignMajor=Major or 1
self.SpawnInitCallSignName=string.lower(Name):gsub("^%l",string.upper)
return self
end
function SPAWN:InitPositionCoordinate(Coordinate)
self:InitPositionVec2(Coordinate:GetVec2())
return self
end
function SPAWN:InitPositionVec2(Vec2)
self.SpawnInitPosition=Vec2
self.SpawnFromNewPosition=true
for SpawnGroupID=1,self.SpawnMaxGroups do
self:_SetInitialPosition(SpawnGroupID)
end
return self
end
function SPAWN:InitRepeat()
self.Repeat=true
self.RepeatOnEngineShutDown=false
self.RepeatOnLanding=true
return self
end
function SPAWN:InitRepeatOnLanding(WaitingTime)
self:InitRepeat()
self.RepeatOnEngineShutDown=false
self.RepeatOnLanding=true
self.RepeatOnLandingTime=(WaitingTime and WaitingTime>3)and WaitingTime or 3
return self
end
function SPAWN:InitRepeatOnEngineShutDown()
self:InitRepeat()
self.RepeatOnEngineShutDown=true
self.RepeatOnLanding=false
return self
end
function SPAWN:InitCleanUp(SpawnCleanUpInterval)
self.SpawnCleanUpInterval=SpawnCleanUpInterval
self.SpawnCleanUpTimeStamps={}
local SpawnGroup,SpawnCursor=self:GetFirstAliveGroup()
self.CleanUpScheduler=SCHEDULER:New(self,self._SpawnCleanUpScheduler,{},1,SpawnCleanUpInterval,0.2)
return self
end
function SPAWN:InitArray(SpawnAngle,SpawnWidth,SpawnDeltaX,SpawnDeltaY)
self.SpawnVisible=true
local SpawnX=0
local SpawnY=0
local SpawnXIndex=0
local SpawnYIndex=0
for SpawnGroupID=1,self.SpawnMaxGroups do
self.SpawnGroups[SpawnGroupID].Visible=true
self.SpawnGroups[SpawnGroupID].Spawned=false
SpawnXIndex=SpawnXIndex+1
if SpawnWidth and SpawnWidth~=0 then
if SpawnXIndex>=SpawnWidth then
SpawnXIndex=0
SpawnYIndex=SpawnYIndex+1
end
end
local SpawnRootX=self.SpawnGroups[SpawnGroupID].SpawnTemplate.x
local SpawnRootY=self.SpawnGroups[SpawnGroupID].SpawnTemplate.y
self:_TranslateRotate(SpawnGroupID,SpawnRootX,SpawnRootY,SpawnX,SpawnY,SpawnAngle)
self.SpawnGroups[SpawnGroupID].SpawnTemplate.lateActivation=true
self.SpawnGroups[SpawnGroupID].SpawnTemplate.visible=true
self.SpawnGroups[SpawnGroupID].Visible=true
self:HandleEvent(EVENTS.Birth,self._OnBirth)
self:HandleEvent(EVENTS.Dead,self._OnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._OnDeadOrCrash)
self:HandleEvent(EVENTS.RemoveUnit,self._OnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._OnDeadOrCrash)
if self.Repeat then
self:HandleEvent(EVENTS.Takeoff,self._OnTakeOff)
self:HandleEvent(EVENTS.Land,self._OnLand)
end
if self.RepeatOnEngineShutDown then
self:HandleEvent(EVENTS.EngineShutdown,self._OnEngineShutDown)
end
self.SpawnGroups[SpawnGroupID].Group=_DATABASE:Spawn(self.SpawnGroups[SpawnGroupID].SpawnTemplate)
SpawnX=SpawnXIndex*SpawnDeltaX
SpawnY=SpawnYIndex*SpawnDeltaY
end
return self
end
function SPAWN:StopRepeat()
if self.Repeat then
self:UnHandleEvent(EVENTS.Takeoff)
self:UnHandleEvent(EVENTS.Land)
end
if self.RepeatOnEngineShutDown then
self:UnHandleEvent(EVENTS.EngineShutdown)
end
self.Repeat=false
self.RepeatOnEngineShutDown=false
self.RepeatOnLanding=false
return self
end
do
function SPAWN:InitAIOnOff(AIOnOff)
self.AIOnOff=AIOnOff
return self
end
function SPAWN:InitAIOn()
return self:InitAIOnOff(true)
end
function SPAWN:InitAIOff()
return self:InitAIOnOff(false)
end
end
do
function SPAWN:InitDelayOnOff(DelayOnOff)
self.DelayOnOff=DelayOnOff
return self
end
function SPAWN:InitDelayOn()
return self:InitDelayOnOff(true)
end
function SPAWN:InitDelayOff()
return self:InitDelayOnOff(false)
end
end
function SPAWN:InitHiddenOnMap(OnOff)
self.SpawnHiddenOnMap=OnOff==false and false or true
return self
end
function SPAWN:InitHiddenOnMFD()
self.SpawnHiddenOnMFD=true
return self
end
function SPAWN:InitHiddenOnPlanner()
self.SpawnHiddenOnPlanner=true
return self
end
function SPAWN:Spawn()
if self.SpawnInitAirbase then
return self:SpawnAtAirbase(self.SpawnInitAirbase,self.SpawnInitTakeoff,nil,self.SpawnInitTerminalType)
else
return self:SpawnWithIndex(self.SpawnIndex+1)
end
end
function SPAWN:ReSpawn(SpawnIndex)
if not SpawnIndex then
SpawnIndex=1
end
local SpawnGroup=self:GetGroupFromIndex(SpawnIndex)
local WayPoints=SpawnGroup and SpawnGroup.WayPoints or nil
if SpawnGroup then
local SpawnDCSGroup=SpawnGroup:GetDCSObject()
if SpawnDCSGroup then
SpawnGroup:Destroy()
end
end
local SpawnGroup=self:SpawnWithIndex(SpawnIndex)
if SpawnGroup and WayPoints then
SpawnGroup:WayPointInitialize(WayPoints)
SpawnGroup:WayPointExecute(1,5)
end
if SpawnGroup and SpawnGroup.ReSpawnFunction then
SpawnGroup:ReSpawnFunction()
end
if SpawnGroup then SpawnGroup:ResetEvents()end
return SpawnGroup
end
function SPAWN:SetSpawnIndex(SpawnIndex)
self.SpawnIndex=SpawnIndex or 0
end
function SPAWN:SpawnWithIndex(SpawnIndex,NoBirth)
if self:_GetSpawnIndex(SpawnIndex)then
if self.SpawnFromNewPosition then
self:_SetInitialPosition(SpawnIndex)
end
if self.SpawnGroups[self.SpawnIndex].Visible then
self.SpawnGroups[self.SpawnIndex].Group:Activate()
else
local SpawnTemplate=self.SpawnGroups[self.SpawnIndex].SpawnTemplate
local SpawnZone=self.SpawnGroups[self.SpawnIndex].SpawnZone
if SpawnTemplate then
local PointVec3=COORDINATE:New(SpawnTemplate.route.points[1].x,SpawnTemplate.route.points[1].alt,SpawnTemplate.route.points[1].y)
if self.SpawnRandomizePosition then
local RandomVec2=PointVec3:GetRandomVec2InRadius(self.SpawnRandomizePositionOuterRadius,self.SpawnRandomizePositionInnerRadius)
local CurrentX=SpawnTemplate.units[1].x
local CurrentY=SpawnTemplate.units[1].y
SpawnTemplate.x=RandomVec2.x
SpawnTemplate.y=RandomVec2.y
for UnitID=1,#SpawnTemplate.units do
SpawnTemplate.units[UnitID].x=SpawnTemplate.units[UnitID].x+(RandomVec2.x-CurrentX)
SpawnTemplate.units[UnitID].y=SpawnTemplate.units[UnitID].y+(RandomVec2.y-CurrentY)
end
end
if self.SpawnRandomizeUnits then
for UnitID=1,#SpawnTemplate.units do
local RandomVec2=PointVec3:GetRandomVec2InRadius(self.SpawnOuterRadius,self.SpawnInnerRadius)
if(SpawnZone)then
local inZone=SpawnZone:IsVec2InZone(RandomVec2)
local numTries=1
while(not inZone)and(numTries<20)do
if not inZone then
RandomVec2=PointVec3:GetRandomVec2InRadius(self.SpawnOuterRadius,self.SpawnInnerRadius)
numTries=numTries+1
inZone=SpawnZone:IsVec2InZone(RandomVec2)
end
end
if(not inZone)then
RandomVec2=SpawnZone:GetRandomVec2()
end
end
SpawnTemplate.units[UnitID].x=RandomVec2.x
SpawnTemplate.units[UnitID].y=RandomVec2.y
end
end
local function _Heading(courseDeg)
local h
if courseDeg<=180 then
h=math.rad(courseDeg)
else
h=-math.rad(360-courseDeg)
end
return h
end
local Rad180=math.rad(180)
local function _HeadingRad(courseRad)
if courseRad<=Rad180 then
return courseRad
else
return-((2*Rad180)-courseRad)
end
end
local function _RandomInRange(min,max)
if min and max then
return min+(math.random()*(max-min))
else
return min
end
end
if self.SpawnInitGroupHeadingMin and#SpawnTemplate.units>0 then
local pivotX=SpawnTemplate.units[1].x
local pivotY=SpawnTemplate.units[1].y
local headingRad=math.rad(_RandomInRange(self.SpawnInitGroupHeadingMin or 0,self.SpawnInitGroupHeadingMax))
local cosHeading=math.cos(headingRad)
local sinHeading=math.sin(headingRad)
local unitVarRad=math.rad(self.SpawnInitGroupUnitVar or 0)
for UnitID=1,#SpawnTemplate.units do
if not self.SpawnRandomizeUnits then
if UnitID>1 then
local unitXOff=SpawnTemplate.units[UnitID].x-pivotX
local unitYOff=SpawnTemplate.units[UnitID].y-pivotY
SpawnTemplate.units[UnitID].x=pivotX+(unitXOff*cosHeading)-(unitYOff*sinHeading)
SpawnTemplate.units[UnitID].y=pivotY+(unitYOff*cosHeading)+(unitXOff*sinHeading)
end
end
local unitHeading=SpawnTemplate.units[UnitID].heading+headingRad
SpawnTemplate.units[UnitID].heading=_HeadingRad(_RandomInRange(unitHeading-unitVarRad,unitHeading+unitVarRad))
SpawnTemplate.units[UnitID].psi=-SpawnTemplate.units[UnitID].heading
end
end
if self.SpawnInitHeadingMin then
for UnitID=1,#SpawnTemplate.units do
SpawnTemplate.units[UnitID].heading=_Heading(_RandomInRange(self.SpawnInitHeadingMin,self.SpawnInitHeadingMax))
SpawnTemplate.units[UnitID].psi=-SpawnTemplate.units[UnitID].heading
end
end
if self.SpawnUnitsWithRelativePositions and self.UnitsRelativePositions then
local BaseX=SpawnTemplate.units[1].x or 0
local BaseY=SpawnTemplate.units[1].y or 0
local BaseZ=SpawnTemplate.units[1].z or 0
for UnitID=1,#SpawnTemplate.units do
if self.UnitsRelativePositions[UnitID].heading then
SpawnTemplate.units[UnitID].heading=math.rad(self.UnitsRelativePositions[UnitID].heading or 0)
end
SpawnTemplate.units[UnitID].x=BaseX+(self.UnitsRelativePositions[UnitID].x or 0)
SpawnTemplate.units[UnitID].y=BaseY+(self.UnitsRelativePositions[UnitID].y or 0)
if self.UnitsRelativePositions[UnitID].z then
SpawnTemplate.units[UnitID].z=BaseZ+(self.UnitsRelativePositions[UnitID].z or 0)
end
end
end
if self.SpawnUnitsWithAbsolutePositions and self.UnitsAbsolutePositions then
for UnitID=1,#SpawnTemplate.units do
if self.UnitsAbsolutePositions[UnitID].heading then
SpawnTemplate.units[UnitID].heading=math.rad(self.UnitsAbsolutePositions[UnitID].heading or 0)
end
SpawnTemplate.units[UnitID].x=self.UnitsAbsolutePositions[UnitID].x or 0
SpawnTemplate.units[UnitID].y=self.UnitsAbsolutePositions[UnitID].y or 0
if self.UnitsAbsolutePositions[UnitID].z then
SpawnTemplate.units[UnitID].z=self.UnitsAbsolutePositions[UnitID].z or 0
end
end
end
if self.SpawnInitLivery then
for UnitID=1,#SpawnTemplate.units do
SpawnTemplate.units[UnitID].livery_id=self.SpawnInitLivery
end
end
if self.SpawnInitSkill then
for UnitID=1,#SpawnTemplate.units do
SpawnTemplate.units[UnitID].skill=self.SpawnInitSkill
end
end
if self.SpawnInitModex then
for UnitID=1,#SpawnTemplate.units do
local modexnumber=string.format("%03d",self.SpawnInitModex+(UnitID-1))
if self.SpawnInitModexPrefix then modexnumber=self.SpawnInitModexPrefix..modexnumber end
if self.SpawnInitModexPostfix then modexnumber=modexnumber..self.SpawnInitModexPostfix end
SpawnTemplate.units[UnitID].onboard_num=modexnumber
end
end
if self.SpawnInitRadio then
SpawnTemplate.communication=self.SpawnInitRadio
end
if self.SpawnInitFreq then
SpawnTemplate.frequency=self.SpawnInitFreq
end
if self.SpawnInitModu then
SpawnTemplate.modulation=self.SpawnInitModu
end
if self.SpawnHiddenOnPlanner then
SpawnTemplate.hiddenOnPlanner=true
end
if self.SpawnHiddenOnMFD then
SpawnTemplate.hiddenOnMFD=true
end
if self.SpawnHiddenOnMap then
SpawnTemplate.hidden=self.SpawnHiddenOnMap
end
SpawnTemplate.CategoryID=self.SpawnInitCategory or SpawnTemplate.CategoryID
SpawnTemplate.CountryID=self.SpawnInitCountry or SpawnTemplate.CountryID
SpawnTemplate.CoalitionID=self.SpawnInitCoalition or SpawnTemplate.CoalitionID
end
if not NoBirth then
self:HandleEvent(EVENTS.Birth,self._OnBirth)
end
self:HandleEvent(EVENTS.Crash,self._OnDeadOrCrash)
self:HandleEvent(EVENTS.UnitLost,self._OnDeadOrCrash)
self:HandleEvent(EVENTS.RemoveUnit,self._OnDeadOrCrash)
if self.Repeat then
self:HandleEvent(EVENTS.Takeoff,self._OnTakeOff)
self:HandleEvent(EVENTS.Land,self._OnLand)
end
if self.RepeatOnEngineShutDown then
self:HandleEvent(EVENTS.EngineShutdown,self._OnEngineShutDown)
end
self.SpawnGroups[self.SpawnIndex].Group=_DATABASE:Spawn(SpawnTemplate)
local SpawnGroup=self.SpawnGroups[self.SpawnIndex].Group
if SpawnGroup then
SpawnGroup:SetAIOnOff(self.AIOnOff)
end
self:T3(SpawnTemplate.name)
if self.SpawnFunctionHook then
self.SpawnHookScheduler:Schedule(nil,self.SpawnFunctionHook,{self.SpawnGroups[self.SpawnIndex].Group,unpack(self.SpawnFunctionArguments)},0.3)
end
end
self.SpawnGroups[self.SpawnIndex].Spawned=true
self.SpawnGroups[self.SpawnIndex].Group.TemplateDonor=self.SpawnTemplatePrefix
return self.SpawnGroups[self.SpawnIndex].Group
else
end
return nil
end
function SPAWN:SpawnScheduled(SpawnTime,SpawnTimeVariation,WithDelay)
local SpawnTime=SpawnTime or 60
local SpawnTimeVariation=SpawnTimeVariation or 0.5
if SpawnTime<15 then
self:E("****SPAWN SCHEDULED****\nWARNING - Setting a very low SpawnTime heavily impacts your mission performance and CPU time, it is NOT useful to check the alive state of an object every "..tostring(SpawnTime).." seconds.\nSetting to 15 second intervals.\n*****")
SpawnTime=15
end
if SpawnTimeVariation>1 or SpawnTimeVariation<0 then SpawnTimeVariation=0.5 end
if SpawnTime~=nil and SpawnTimeVariation~=nil then
local InitialDelay=0
if WithDelay or self.DelayOnOff==true then
InitialDelay=math.random(SpawnTime-SpawnTime*SpawnTimeVariation,SpawnTime+SpawnTime*SpawnTimeVariation)
end
self.SpawnScheduler=SCHEDULER:New(self,self._Scheduler,{},InitialDelay,SpawnTime,SpawnTimeVariation)
end
return self
end
function SPAWN:SpawnScheduleStart()
self.SpawnScheduler:Start()
return self
end
function SPAWN:SpawnScheduleStop()
self.SpawnScheduler:Stop()
return self
end
function SPAWN:OnSpawnGroup(SpawnCallBackFunction,...)
self.SpawnFunctionHook=SpawnCallBackFunction
self.SpawnFunctionArguments={}
if arg then
self.SpawnFunctionArguments=arg
end
return self
end
function SPAWN:SpawnAtAirbase(SpawnAirbase,Takeoff,TakeoffAltitude,TerminalType,EmergencyAirSpawn,Parkingdata)
local PointVec3=SpawnAirbase:GetCoordinate()
Takeoff=Takeoff or SPAWN.Takeoff.Hot
if EmergencyAirSpawn==nil then
EmergencyAirSpawn=true
end
if self:_GetSpawnIndex(self.SpawnIndex+1)then
local SpawnTemplate=self.SpawnGroups[self.SpawnIndex].SpawnTemplate
if SpawnTemplate then
local group=GROUP:FindByName(self.SpawnTemplatePrefix)
local unit=group:GetUnit(1)
local istransport=group:HasAttribute("Transports")and group:HasAttribute("Planes")
local isawacs=group:HasAttribute("AWACS")
local isfighter=group:HasAttribute("Fighters")or group:HasAttribute("Interceptors")or group:HasAttribute("Multirole fighters")or(group:HasAttribute("Bombers")and not group:HasAttribute("Strategic bombers"))
local isbomber=group:HasAttribute("Strategic bombers")
local istanker=group:HasAttribute("Tankers")
local ishelo=unit:HasAttribute("Helicopters")
local nunits=#SpawnTemplate.units
local SpawnPoint=SpawnTemplate.route.points[1]
SpawnPoint.linkUnit=nil
SpawnPoint.helipadId=nil
SpawnPoint.airdromeId=nil
local AirbaseID=SpawnAirbase:GetID()
local AirbaseCategory=SpawnAirbase:GetAirbaseCategory()
if AirbaseCategory==Airbase.Category.SHIP then
SpawnPoint.linkUnit=AirbaseID
SpawnPoint.helipadId=AirbaseID
elseif AirbaseCategory==Airbase.Category.HELIPAD then
SpawnPoint.linkUnit=AirbaseID
SpawnPoint.helipadId=AirbaseID
else
SpawnPoint.airdromeId=AirbaseID
end
SpawnPoint.alt=0
SpawnPoint.type=GROUPTEMPLATE.Takeoff[Takeoff][1]
SpawnPoint.action=GROUPTEMPLATE.Takeoff[Takeoff][2]
local spawnonground=not(Takeoff==SPAWN.Takeoff.Air)
local autoparking=false
if SpawnAirbase.isAirdrome then
autoparking=false
else
autoparking=true
end
local parkingspots={}
local parkingindex={}
local spots
if spawnonground and not SpawnTemplate.parked then
local nfree=0
local termtype=TerminalType
if Takeoff==SPAWN.Takeoff.Runway then
if SpawnAirbase.isShip then
if ishelo then
termtype=AIRBASE.TerminalType.HelicopterUsable
else
termtype=AIRBASE.TerminalType.OpenMedOrBig
end
else
termtype=AIRBASE.TerminalType.Runway
end
end
local scanradius=50
local scanunits=true
local scanstatics=true
local scanscenery=false
local verysafe=false
if autoparking then
nfree=SpawnAirbase:GetFreeParkingSpotsNumber(termtype,true)
spots=SpawnAirbase:GetFreeParkingSpotsTable(termtype,true)
elseif Parkingdata~=nil then
nfree=#Parkingdata
spots=Parkingdata
else
if ishelo then
if termtype==nil then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,AIRBASE.TerminalType.HelicopterOnly,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
if nfree<nunits then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,AIRBASE.TerminalType.HelicopterUsable,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,termtype,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
if termtype==nil then
if isbomber or istransport or istanker or isawacs then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,AIRBASE.TerminalType.OpenBig,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
if nfree<nunits then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,AIRBASE.TerminalType.OpenMedOrBig,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,AIRBASE.TerminalType.FighterAircraft,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(group,termtype,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
end
end
local _notenough=false
if autoparking then
if nfree>=1 then
for i=1,nunits do
table.insert(parkingspots,spots[1].Coordinate)
table.insert(parkingindex,spots[1].TerminalID)
end
PointVec3=spots[1].Coordinate
else
_notenough=true
end
else
if nfree>=nunits then
for i=1,nunits do
table.insert(parkingspots,spots[i].Coordinate)
table.insert(parkingindex,spots[i].TerminalID)
end
else
_notenough=true
end
end
if _notenough then
if EmergencyAirSpawn and not self.SpawnUnControlled then
self:E(string.format("WARNING: Group %s has no parking spots at %s ==> air start!",self.SpawnTemplatePrefix,SpawnAirbase:GetName()))
autoparking=false
SpawnPoint.type=GROUPTEMPLATE.Takeoff[GROUP.Takeoff.Air][1]
SpawnPoint.action=GROUPTEMPLATE.Takeoff[GROUP.Takeoff.Air][2]
PointVec3.x=PointVec3.x+math.random(-500,500)
PointVec3.z=PointVec3.z+math.random(-500,500)
if ishelo then
PointVec3.y=PointVec3:GetLandHeight()+math.random(100,1000)
else
PointVec3.y=PointVec3:GetLandHeight()+math.random(500,2500)
end
Takeoff=GROUP.Takeoff.Air
else
self:E(string.format("WARNING: Group %s has no parking spots at %s ==> No emergency air start or uncontrolled spawning ==> No spawn!",self.SpawnTemplatePrefix,SpawnAirbase:GetName()))
return nil
end
end
else
if TakeoffAltitude then
PointVec3.y=TakeoffAltitude
else
if ishelo then
PointVec3.y=PointVec3:GetLandHeight()+math.random(100,1000)
else
PointVec3.y=PointVec3:GetLandHeight()+math.random(500,2500)
end
end
end
if not SpawnTemplate.parked then
SpawnTemplate.parked=true
for UnitID=1,nunits do
local UnitTemplate=SpawnTemplate.units[UnitID]
local SX=UnitTemplate.x
local SY=UnitTemplate.y
local BX=SpawnTemplate.route.points[1].x
local BY=SpawnTemplate.route.points[1].y
local TX=PointVec3.x+(SX-BX)
local TY=PointVec3.z+(SY-BY)
if spawnonground then
if autoparking then
SpawnTemplate.units[UnitID].x=PointVec3.x
SpawnTemplate.units[UnitID].y=PointVec3.z
SpawnTemplate.units[UnitID].alt=PointVec3.y
else
SpawnTemplate.units[UnitID].x=parkingspots[UnitID].x
SpawnTemplate.units[UnitID].y=parkingspots[UnitID].z
SpawnTemplate.units[UnitID].alt=parkingspots[UnitID].y
end
else
SpawnTemplate.units[UnitID].x=TX
SpawnTemplate.units[UnitID].y=TY
SpawnTemplate.units[UnitID].alt=PointVec3.y
end
UnitTemplate.parking=nil
UnitTemplate.parking_id=nil
if parkingindex[UnitID]then
UnitTemplate.parking=parkingindex[UnitID]
end
end
end
SpawnPoint.x=PointVec3.x
SpawnPoint.y=PointVec3.z
SpawnPoint.alt=PointVec3.y
SpawnTemplate.x=PointVec3.x
SpawnTemplate.y=PointVec3.z
SpawnTemplate.uncontrolled=self.SpawnUnControlled
local GroupSpawned=self:SpawnWithIndex(self.SpawnIndex)
if Takeoff==GROUP.Takeoff.Air then
for UnitID,UnitSpawned in pairs(GroupSpawned:GetUnits())do
self:ScheduleOnce(5,BASE.CreateEventTakeoff,{GroupSpawned,timer.getTime(),UnitSpawned:GetDCSObject()})
end
end
return GroupSpawned
end
end
return nil
end
function SPAWN:SpawnAtParkingSpot(Airbase,Spots,Takeoff)
if type(Spots)~="table"then
Spots={Spots}
end
if type(Airbase)=="string"then
Airbase=AIRBASE:FindByName(Airbase)
end
local group=GROUP:FindByName(self.SpawnTemplatePrefix)
local nunits=self.SpawnGrouping or#group:GetUnits()
if nunits then
if#Spots<nunits then
self:E("ERROR: Number of provided parking spots is less than number of units in group!")
return nil
end
local Parkingdata={}
for _,TerminalID in pairs(Spots)do
local spot=Airbase:GetParkingSpotData(TerminalID)
if spot and spot.Free then
table.insert(Parkingdata,spot)
end
end
if#Parkingdata>=nunits then
return self:SpawnAtAirbase(Airbase,Takeoff,nil,nil,nil,Parkingdata)
else
self:E("ERROR: Could not find enough free parking spots!")
end
else
self:E("ERROR: Could not get number of units in group!")
end
return nil
end
function SPAWN:ParkAircraft(SpawnAirbase,TerminalType,Parkingdata,SpawnIndex)
local PointVec3=SpawnAirbase:GetCoordinate()
local Takeoff=SPAWN.Takeoff.Cold
local SpawnTemplate=self.SpawnGroups[SpawnIndex].SpawnTemplate
if SpawnTemplate then
local GroupAlive=self:GetGroupFromIndex(SpawnIndex)
local TemplateGroup=GROUP:FindByName(self.SpawnTemplatePrefix)
local TemplateUnit=TemplateGroup:GetUnit(1)
local ishelo=TemplateUnit:HasAttribute("Helicopters")
local isbomber=TemplateUnit:HasAttribute("Bombers")
local istransport=TemplateUnit:HasAttribute("Transports")
local isfighter=TemplateUnit:HasAttribute("Battleplanes")
local nunits=#SpawnTemplate.units
local SpawnPoint=SpawnTemplate.route.points[1]
SpawnPoint.linkUnit=nil
SpawnPoint.helipadId=nil
SpawnPoint.airdromeId=nil
local AirbaseID=SpawnAirbase:GetID()
local AirbaseCategory=SpawnAirbase:GetAirbaseCategory()
if AirbaseCategory==Airbase.Category.SHIP then
SpawnPoint.linkUnit=AirbaseID
SpawnPoint.helipadId=AirbaseID
elseif AirbaseCategory==Airbase.Category.HELIPAD then
SpawnPoint.linkUnit=AirbaseID
SpawnPoint.helipadId=AirbaseID
elseif AirbaseCategory==Airbase.Category.AIRDROME then
SpawnPoint.airdromeId=AirbaseID
end
SpawnPoint.alt=0
SpawnPoint.type=GROUPTEMPLATE.Takeoff[Takeoff][1]
SpawnPoint.action=GROUPTEMPLATE.Takeoff[Takeoff][2]
local spawnonground=not(Takeoff==SPAWN.Takeoff.Air)
local spawnonship=false
local spawnonfarp=false
local spawnonrunway=false
local spawnonairport=false
if spawnonground then
if AirbaseCategory==Airbase.Category.SHIP then
spawnonship=true
elseif AirbaseCategory==Airbase.Category.HELIPAD then
spawnonfarp=true
elseif AirbaseCategory==Airbase.Category.AIRDROME then
spawnonairport=true
end
spawnonrunway=Takeoff==SPAWN.Takeoff.Runway
end
local parkingspots={}
local parkingindex={}
local spots
if spawnonground and not SpawnTemplate.parked then
local nfree=0
local termtype=TerminalType
local scanradius=50
local scanunits=true
local scanstatics=true
local scanscenery=false
local verysafe=false
if spawnonship or spawnonfarp or spawnonrunway then
nfree=SpawnAirbase:GetFreeParkingSpotsNumber(termtype,true)
spots=SpawnAirbase:GetFreeParkingSpotsTable(termtype,true)
else
if ishelo then
if termtype==nil then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,AIRBASE.TerminalType.HelicopterOnly,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
if nfree<nunits then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,AIRBASE.TerminalType.HelicopterUsable,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,termtype,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
if termtype==nil then
if isbomber or istransport then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,AIRBASE.TerminalType.OpenBig,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
if nfree<nunits then
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,AIRBASE.TerminalType.OpenMedOrBig,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,AIRBASE.TerminalType.FighterAircraft,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
else
spots=SpawnAirbase:FindFreeParkingSpotForAircraft(TemplateGroup,termtype,scanradius,scanunits,scanstatics,scanscenery,verysafe,nunits,Parkingdata)
nfree=#spots
end
end
end
local _notenough=false
if spawnonship or spawnonfarp or spawnonrunway then
if nfree>=1 then
for i=1,nunits do
table.insert(parkingspots,spots[1].Coordinate)
table.insert(parkingindex,spots[1].TerminalID)
end
PointVec3=spots[1].Coordinate
else
_notenough=true
end
elseif spawnonairport then
if nfree>=nunits then
for i=1,nunits do
table.insert(parkingspots,spots[i].Coordinate)
table.insert(parkingindex,spots[i].TerminalID)
end
else
_notenough=true
end
end
if _notenough then
if not self.SpawnUnControlled then
else
self:E(string.format("WARNING: Group %s has no parking spots at %s ==> No emergency air start or uncontrolled spawning ==> No spawn!",self.SpawnTemplatePrefix,SpawnAirbase:GetName()))
return nil
end
end
else
end
if not SpawnTemplate.parked then
SpawnTemplate.parked=true
for UnitID=1,nunits do
local UnitTemplate=SpawnTemplate.units[UnitID]
local SX=UnitTemplate.x
local SY=UnitTemplate.y
local BX=SpawnTemplate.route.points[1].x
local BY=SpawnTemplate.route.points[1].y
local TX=PointVec3.x+(SX-BX)
local TY=PointVec3.z+(SY-BY)
if spawnonground then
if spawnonship or spawnonfarp or spawnonrunway then
SpawnTemplate.units[UnitID].x=PointVec3.x
SpawnTemplate.units[UnitID].y=PointVec3.z
SpawnTemplate.units[UnitID].alt=PointVec3.y
else
SpawnTemplate.units[UnitID].x=parkingspots[UnitID].x
SpawnTemplate.units[UnitID].y=parkingspots[UnitID].z
SpawnTemplate.units[UnitID].alt=parkingspots[UnitID].y
end
else
SpawnTemplate.units[UnitID].x=TX
SpawnTemplate.units[UnitID].y=TY
SpawnTemplate.units[UnitID].alt=PointVec3.y
end
UnitTemplate.parking=nil
UnitTemplate.parking_id=nil
if parkingindex[UnitID]then
UnitTemplate.parking=parkingindex[UnitID]
end
end
end
SpawnPoint.x=PointVec3.x
SpawnPoint.y=PointVec3.z
SpawnPoint.alt=PointVec3.y
SpawnTemplate.x=PointVec3.x
SpawnTemplate.y=PointVec3.z
SpawnTemplate.uncontrolled=true
local GroupSpawned=self:SpawnWithIndex(SpawnIndex,true)
if Takeoff==GROUP.Takeoff.Air then
for UnitID,UnitSpawned in pairs(GroupSpawned:GetUnits())do
SCHEDULER:New(nil,BASE.CreateEventTakeoff,{GroupSpawned,timer.getTime(),UnitSpawned:GetDCSObject()},5)
end
end
if Takeoff~=SPAWN.Takeoff.Runway and Takeoff~=SPAWN.Takeoff.Air and spawnonairport then
SCHEDULER:New(nil,AIRBASE.CheckOnRunWay,{SpawnAirbase,GroupSpawned,75,true},1.0)
end
end
end
function SPAWN:ParkAtAirbase(SpawnAirbase,TerminalType,Parkingdata)
self:ParkAircraft(SpawnAirbase,TerminalType,Parkingdata,1)
for SpawnIndex=2,self.SpawnMaxGroups do
self:ParkAircraft(SpawnAirbase,TerminalType,Parkingdata,SpawnIndex)
end
self:SetSpawnIndex(0)
return nil
end
function SPAWN:SpawnFromVec3(Vec3,SpawnIndex)
local PointVec3=COORDINATE:NewFromVec3(Vec3)
if SpawnIndex then
else
SpawnIndex=self.SpawnIndex+1
end
if self:_GetSpawnIndex(SpawnIndex)then
local SpawnTemplate=self.SpawnGroups[self.SpawnIndex].SpawnTemplate
if SpawnTemplate then
local TemplateHeight=SpawnTemplate.route and SpawnTemplate.route.points[1].alt or nil
SpawnTemplate.route=SpawnTemplate.route or{}
SpawnTemplate.route.points=SpawnTemplate.route.points or{}
SpawnTemplate.route.points[1]=SpawnTemplate.route.points[1]or{}
SpawnTemplate.route.points[1].x=SpawnTemplate.route.points[1].x or 0
SpawnTemplate.route.points[1].y=SpawnTemplate.route.points[1].y or 0
for UnitID=1,#SpawnTemplate.units do
local UnitTemplate=SpawnTemplate.units[UnitID]
local SX=UnitTemplate.x or 0
local SY=UnitTemplate.y or 0
local BX=SpawnTemplate.route.points[1].x
local BY=SpawnTemplate.route.points[1].y
local TX=Vec3.x+(SX-BX)
local TY=Vec3.z+(SY-BY)
SpawnTemplate.units[UnitID].x=TX
SpawnTemplate.units[UnitID].y=TY
if SpawnTemplate.CategoryID~=Group.Category.SHIP then
SpawnTemplate.units[UnitID].alt=Vec3.y or TemplateHeight
end
end
SpawnTemplate.route.points[1].x=Vec3.x
SpawnTemplate.route.points[1].y=Vec3.z
if SpawnTemplate.CategoryID~=Group.Category.SHIP then
SpawnTemplate.route.points[1].alt=Vec3.y or TemplateHeight
end
SpawnTemplate.x=Vec3.x
SpawnTemplate.y=Vec3.z
SpawnTemplate.alt=Vec3.y or TemplateHeight
return self:SpawnWithIndex(self.SpawnIndex)
end
end
return nil
end
function SPAWN:SpawnFromCoordinate(Coordinate,SpawnIndex)
return self:SpawnFromVec3(Coordinate:GetVec3(),SpawnIndex)
end
function SPAWN:SpawnFromPointVec3(PointVec3,SpawnIndex)
return self:SpawnFromVec3(PointVec3:GetVec3(),SpawnIndex)
end
function SPAWN:SpawnFromVec2(Vec2,MinHeight,MaxHeight,SpawnIndex)
local Height=nil
if MinHeight and MaxHeight then
Height=math.random(MinHeight,MaxHeight)
end
return self:SpawnFromVec3({x=Vec2.x,y=Height,z=Vec2.y},SpawnIndex)
end
function SPAWN:SpawnFromPointVec2(PointVec2,MinHeight,MaxHeight,SpawnIndex)
return self:SpawnFromVec2(PointVec2:GetVec2(),MinHeight,MaxHeight,SpawnIndex)
end
function SPAWN:SpawnFromUnit(HostUnit,MinHeight,MaxHeight,SpawnIndex)
if HostUnit and HostUnit:IsAlive()~=nil then
return self:SpawnFromVec2(HostUnit:GetVec2(),MinHeight,MaxHeight,SpawnIndex)
end
return nil
end
function SPAWN:SpawnFromStatic(HostStatic,MinHeight,MaxHeight,SpawnIndex)
if HostStatic and HostStatic:IsAlive()then
return self:SpawnFromVec2(HostStatic:GetVec2(),MinHeight,MaxHeight,SpawnIndex)
end
return nil
end
function SPAWN:SpawnInZone(Zone,RandomizeGroup,MinHeight,MaxHeight,SpawnIndex)
if Zone then
if RandomizeGroup then
return self:SpawnFromVec2(Zone:GetRandomVec2(),MinHeight,MaxHeight,SpawnIndex)
else
return self:SpawnFromVec2(Zone:GetVec2(),MinHeight,MaxHeight,SpawnIndex)
end
end
return nil
end
function SPAWN:InitUnControlled(UnControlled)
self:F2({self.SpawnTemplatePrefix,UnControlled})
self.SpawnUnControlled=(UnControlled==true)and true or nil
for SpawnGroupID=1,self.SpawnMaxGroups do
self.SpawnGroups[SpawnGroupID].UnControlled=self.SpawnUnControlled
end
return self
end
function SPAWN:GetCoordinate()
local LateGroup=GROUP:FindByName(self.SpawnTemplatePrefix)
if LateGroup then
return LateGroup:GetCoordinate()
end
return nil
end
function SPAWN:SpawnGroupName(SpawnIndex)
local SpawnPrefix=self.SpawnTemplatePrefix
if self.SpawnAliasPrefix then
SpawnPrefix=self.SpawnAliasPrefix
end
if SpawnIndex then
local SpawnName=string.format('%s#%03d',SpawnPrefix,SpawnIndex)
return SpawnName
else
return SpawnPrefix
end
end
function SPAWN:GetFirstAliveGroup()
for SpawnIndex=1,self.SpawnCount do
local SpawnGroup=self:GetGroupFromIndex(SpawnIndex)
if SpawnGroup and SpawnGroup:IsAlive()then
return SpawnGroup,SpawnIndex
end
end
return nil,nil
end
function SPAWN:GetNextAliveGroup(SpawnIndexStart)
SpawnIndexStart=SpawnIndexStart+1
for SpawnIndex=SpawnIndexStart,self.SpawnCount do
local SpawnGroup=self:GetGroupFromIndex(SpawnIndex)
if SpawnGroup and SpawnGroup:IsAlive()then
return SpawnGroup,SpawnIndex
end
end
return nil,nil
end
function SPAWN:GetLastAliveGroup()
for SpawnIndex=self.SpawnCount,1,-1 do
local SpawnGroup=self:GetGroupFromIndex(SpawnIndex)
if SpawnGroup and SpawnGroup:IsAlive()then
self.SpawnIndex=SpawnIndex
return SpawnGroup
end
end
self.SpawnIndex=nil
return nil
end
function SPAWN:GetGroupFromIndex(SpawnIndex)
if not SpawnIndex then
SpawnIndex=1
end
if self.SpawnGroups and self.SpawnGroups[SpawnIndex]then
local SpawnGroup=self.SpawnGroups[SpawnIndex].Group
return SpawnGroup
else
return nil
end
end
function SPAWN:_GetPrefixFromGroup(SpawnGroup)
local GroupName=SpawnGroup:GetName()
if GroupName then
local SpawnPrefix=self:_GetPrefixFromGroupName(GroupName)
return SpawnPrefix
end
return nil
end
function SPAWN:_GetPrefixFromGroupName(SpawnGroupName)
if SpawnGroupName then
local SpawnPrefix=string.match(SpawnGroupName,".*#")
if SpawnPrefix then
SpawnPrefix=SpawnPrefix:sub(1,-2)
end
return SpawnPrefix
end
return nil
end
function SPAWN:GetSpawnIndexFromGroup(SpawnGroup)
local IndexString=string.match(SpawnGroup:GetName(),"#(%d*)$"):sub(2)
local Index=tonumber(IndexString)
self:T3(IndexString,Index)
return Index
end
function SPAWN:_GetLastIndex()
return self.SpawnMaxGroups
end
function SPAWN:_InitializeSpawnGroups(SpawnIndex)
if not self.SpawnGroups[SpawnIndex]then
self.SpawnGroups[SpawnIndex]={}
self.SpawnGroups[SpawnIndex].Visible=false
self.SpawnGroups[SpawnIndex].Spawned=false
self.SpawnGroups[SpawnIndex].UnControlled=false
self.SpawnGroups[SpawnIndex].SpawnTime=0
self.SpawnGroups[SpawnIndex].SpawnTemplatePrefix=self.SpawnTemplatePrefix
self.SpawnGroups[SpawnIndex].SpawnTemplate=self:_Prepare(self.SpawnGroups[SpawnIndex].SpawnTemplatePrefix,SpawnIndex)
end
self:_RandomizeTemplate(SpawnIndex)
self:_RandomizeRoute(SpawnIndex)
return self.SpawnGroups[SpawnIndex]
end
function SPAWN:_GetGroupCategoryID(SpawnPrefix)
local TemplateGroup=Group.getByName(SpawnPrefix)
if TemplateGroup then
return TemplateGroup:getCategory()
else
return nil
end
end
function SPAWN:_GetGroupCoalitionID(SpawnPrefix)
local TemplateGroup=Group.getByName(SpawnPrefix)
if TemplateGroup then
return TemplateGroup:getCoalition()
else
return nil
end
end
function SPAWN:_GetGroupCountryID(SpawnPrefix)
local TemplateGroup=Group.getByName(SpawnPrefix)
if TemplateGroup then
local TemplateUnits=TemplateGroup:getUnits()
return TemplateUnits[1]:getCountry()
else
return nil
end
end
function SPAWN:_GetTemplate(SpawnTemplatePrefix)
local SpawnTemplate=nil
if _DATABASE.Templates.Groups[SpawnTemplatePrefix]==nil then
error('No Template exists for SpawnTemplatePrefix = '..SpawnTemplatePrefix)
end
local Template=_DATABASE.Templates.Groups[SpawnTemplatePrefix].Template
SpawnTemplate=UTILS.DeepCopy(_DATABASE.Templates.Groups[SpawnTemplatePrefix].Template)
if SpawnTemplate==nil then
error('No Template returned for SpawnTemplatePrefix = '..SpawnTemplatePrefix)
end
self:T3({SpawnTemplate})
return SpawnTemplate
end
function SPAWN:_Prepare(SpawnTemplatePrefix,SpawnIndex)
local SpawnTemplate
if self.TweakedTemplate~=nil and self.TweakedTemplate==true then
BASE:I("WARNING: You are using a tweaked template.")
SpawnTemplate=self.SpawnTemplate
if self.MooseNameing==true then
SpawnTemplate.name=self:SpawnGroupName(SpawnIndex)
else
SpawnTemplate.name=self:SpawnGroupName()
end
else
SpawnTemplate=self:_GetTemplate(SpawnTemplatePrefix)
SpawnTemplate.name=self:SpawnGroupName(SpawnIndex)
end
SpawnTemplate.groupId=nil
SpawnTemplate.lateActivation=self.LateActivated or false
if SpawnTemplate.CategoryID==Group.Category.GROUND then
self:T3("For ground units, visible needs to be false...")
SpawnTemplate.visible=false
end
if self.SpawnGrouping then
local UnitAmount=#SpawnTemplate.units
if UnitAmount>self.SpawnGrouping then
for UnitID=self.SpawnGrouping+1,UnitAmount do
SpawnTemplate.units[UnitID]=nil
end
else
if UnitAmount<self.SpawnGrouping then
for UnitID=UnitAmount+1,self.SpawnGrouping do
SpawnTemplate.units[UnitID]=UTILS.DeepCopy(SpawnTemplate.units[1])
SpawnTemplate.units[UnitID].unitId=nil
end
end
end
end
if self.SpawnInitKeepUnitNames==false then
for UnitID=1,#SpawnTemplate.units do
if not string.find(SpawnTemplate.units[UnitID].name,"#IFF_",1,true)then
SpawnTemplate.units[UnitID].name=string.format(SpawnTemplate.name..'-%02d',UnitID)
end
SpawnTemplate.units[UnitID].unitId=nil
end
else
for UnitID=1,#SpawnTemplate.units do
local SpawnInitKeepUnitIFF=false
if string.find(SpawnTemplate.units[UnitID].name,"#IFF_",1,true)then
SpawnInitKeepUnitIFF=true
end
local UnitPrefix,Rest
if SpawnInitKeepUnitIFF==false then
UnitPrefix,Rest=string.match(SpawnTemplate.units[UnitID].name,"^([^#]+)#?"):gsub("^%s*(.-)%s*$","%1")
SpawnTemplate.units[UnitID].name=string.format('%s#%03d-%02d',UnitPrefix,SpawnIndex,UnitID)
end
SpawnTemplate.units[UnitID].unitId=nil
end
end
if self.SpawnRandomCallsign and SpawnTemplate.units[1].callsign then
if type(SpawnTemplate.units[1].callsign)~="number"then
local min=1
local max=8
local ctable=CALLSIGN.Aircraft
if string.find(SpawnTemplate.units[1].type,"A-10",1,true)then
max=12
end
if string.find(SpawnTemplate.units[1].type,"18",1,true)then
min=9
max=20
ctable=CALLSIGN.F18
end
if string.find(SpawnTemplate.units[1].type,"16",1,true)then
min=9
max=20
ctable=CALLSIGN.F16
end
if SpawnTemplate.units[1].type=="F-15E"then
min=9
max=18
ctable=CALLSIGN.F15E
end
local callsignnr=math.random(min,max)
local callsignname="Enfield"
for name,value in pairs(ctable)do
if value==callsignnr then
callsignname=name
end
end
for UnitID=1,#SpawnTemplate.units do
SpawnTemplate.units[UnitID].callsign[1]=callsignnr
SpawnTemplate.units[UnitID].callsign[2]=UnitID
SpawnTemplate.units[UnitID].callsign[3]="1"
SpawnTemplate.units[UnitID].callsign["name"]=tostring(callsignname)..tostring(UnitID).."1"
end
else
for UnitID=1,#SpawnTemplate.units do
SpawnTemplate.units[UnitID].callsign=math.random(1,999)
end
end
end
if self.SpawnInitCallSign then
for UnitID=1,#SpawnTemplate.units do
local Callsign=SpawnTemplate.units[UnitID].callsign
if Callsign and type(Callsign)~="number"then
SpawnTemplate.units[UnitID].callsign[1]=self.SpawnInitCallSignID
SpawnTemplate.units[UnitID].callsign[2]=self.SpawnInitCallSignMinor
SpawnTemplate.units[UnitID].callsign[3]=self.SpawnInitCallSignMajor
SpawnTemplate.units[UnitID].callsign["name"]=string.format("%s%d%d",self.SpawnInitCallSignName,self.SpawnInitCallSignMinor,self.SpawnInitCallSignMajor)
end
end
end
for UnitID=1,#SpawnTemplate.units do
local Callsign=SpawnTemplate.units[UnitID].callsign
if Callsign then
if type(Callsign)~="number"and not self.SpawnInitCallSign then
Callsign[2]=((SpawnIndex-1)%10)+1
local CallsignName=SpawnTemplate.units[UnitID].callsign["name"]
CallsignName=string.match(CallsignName,"^(%a+)")
local CallsignLen=CallsignName:len()
SpawnTemplate.units[UnitID].callsign[2]=UnitID
SpawnTemplate.units[UnitID].callsign["name"]=CallsignName:sub(1,CallsignLen)..SpawnTemplate.units[UnitID].callsign[2]..SpawnTemplate.units[UnitID].callsign[3]
elseif type(Callsign)=="number"then
SpawnTemplate.units[UnitID].callsign=Callsign+SpawnIndex
end
end
if self.InitSpeed then
SpawnTemplate.units[UnitID].speed=self.InitSpeed
end
local AddProps=SpawnTemplate.units[UnitID].AddPropAircraft
if AddProps then
if SpawnTemplate.units[UnitID].AddPropAircraft.STN_L16 then
if self.SpawnInitSTN then
local octal=self.SpawnInitSTN
if UnitID>1 then
octal=_DATABASE:GetNextSTN(self.SpawnInitSTN,SpawnTemplate.units[UnitID].name)
end
SpawnTemplate.units[UnitID].AddPropAircraft.STN_L16=string.format("%05d",octal)
else
if tonumber(SpawnTemplate.units[UnitID].AddPropAircraft.STN_L16)~=nil then
local octal=SpawnTemplate.units[UnitID].AddPropAircraft.STN_L16
local num=UTILS.OctalToDecimal(octal)
if _DATABASE.STNS[num]~=nil or UnitID>1 then
octal=_DATABASE:GetNextSTN(octal,SpawnTemplate.units[UnitID].name)
end
SpawnTemplate.units[UnitID].AddPropAircraft.STN_L16=string.format("%05d",octal)
else
local OSTN=_DATABASE:GetNextSTN(1,SpawnTemplate.units[UnitID].name)
SpawnTemplate.units[UnitID].AddPropAircraft.STN_L16=string.format("%05d",OSTN)
end
end
end
if SpawnTemplate.units[UnitID].AddPropAircraft.SADL_TN then
if self.SpawnInitSADL then
local octal=self.SpawnInitSADL
if UnitID>1 then
octal=_DATABASE:GetNextSADL(self.SpawnInitSADL,SpawnTemplate.units[UnitID].name)
end
SpawnTemplate.units[UnitID].AddPropAircraft.SADL_TN=string.format("%04d",octal)
else
if tonumber(SpawnTemplate.units[UnitID].AddPropAircraft.SADL_TN)~=nil then
local octal=SpawnTemplate.units[UnitID].AddPropAircraft.SADL_TN
local num=UTILS.OctalToDecimal(octal)
self.SpawnInitSADL=num
if _DATABASE.SADL[num]~=nil or UnitID>1 then
octal=_DATABASE:GetNextSADL(self.SpawnInitSADL,SpawnTemplate.units[UnitID].name)
end
SpawnTemplate.units[UnitID].AddPropAircraft.SADL_TN=string.format("%04d",octal)
else
local OSTN=_DATABASE:GetNextSADL(1,SpawnTemplate.units[UnitID].name)
SpawnTemplate.units[UnitID].AddPropAircraft.SADL_TN=string.format("%04d",OSTN)
end
end
end
if SpawnTemplate.units[UnitID].AddPropAircraft.VoiceCallsignNumber and type(Callsign)~="number"then
SpawnTemplate.units[UnitID].AddPropAircraft.VoiceCallsignNumber=SpawnTemplate.units[UnitID].callsign[2]..SpawnTemplate.units[UnitID].callsign[3]
end
if SpawnTemplate.units[UnitID].AddPropAircraft.VoiceCallsignLabel and type(Callsign)~="number"then
local CallsignName=SpawnTemplate.units[UnitID].callsign["name"]
CallsignName=string.match(CallsignName,"^(%a+)")
local label="NY"
if not string.find(CallsignName," ")then
label=string.upper(string.match(CallsignName,"^%a")..string.match(CallsignName,"%a$"))
end
SpawnTemplate.units[UnitID].AddPropAircraft.VoiceCallsignLabel=label
end
if SpawnTemplate.units[UnitID].datalinks and SpawnTemplate.units[UnitID].datalinks.Link16 and SpawnTemplate.units[UnitID].datalinks.Link16.settings then
SpawnTemplate.units[UnitID].datalinks.Link16.settings.flightLead=UnitID==1 and true or false
end
if SpawnTemplate.units[UnitID].datalinks and SpawnTemplate.units[UnitID].datalinks.SADL and SpawnTemplate.units[UnitID].datalinks.SADL.settings then
SpawnTemplate.units[UnitID].datalinks.SADL.settings.flightLead=UnitID==1 and true or false
end
end
end
for UnitID=1,#SpawnTemplate.units do
if SpawnTemplate.units[UnitID].datalinks and SpawnTemplate.units[UnitID].datalinks.Link16 and SpawnTemplate.units[UnitID].datalinks.Link16.network then
local team={}
local isF16=string.find(SpawnTemplate.units[UnitID].type,"F-16",1,true)and true or false
for ID=1,#SpawnTemplate.units do
local member={}
member.missionUnitId=ID
if isF16 then
member.TDOA=true
end
table.insert(team,member)
end
SpawnTemplate.units[UnitID].datalinks.Link16.network.teamMembers=team
end
end
self:T3({"Template:",SpawnTemplate})
return SpawnTemplate
end
function SPAWN:_RandomizeRoute(SpawnIndex)
if self.SpawnRandomizeRoute then
local SpawnTemplate=self.SpawnGroups[SpawnIndex].SpawnTemplate
local RouteCount=#SpawnTemplate.route.points
for t=self.SpawnRandomizeRouteStartPoint+1,(RouteCount-self.SpawnRandomizeRouteEndPoint)do
SpawnTemplate.route.points[t].x=SpawnTemplate.route.points[t].x+math.random(self.SpawnRandomizeRouteRadius*-1,self.SpawnRandomizeRouteRadius)
SpawnTemplate.route.points[t].y=SpawnTemplate.route.points[t].y+math.random(self.SpawnRandomizeRouteRadius*-1,self.SpawnRandomizeRouteRadius)
if SpawnTemplate.CategoryID==Group.Category.AIRPLANE or SpawnTemplate.CategoryID==Group.Category.HELICOPTER then
if SpawnTemplate.route.points[t].alt and self.SpawnRandomizeRouteHeight then
SpawnTemplate.route.points[t].alt=SpawnTemplate.route.points[t].alt+math.random(1,self.SpawnRandomizeRouteHeight)
end
else
SpawnTemplate.route.points[t].alt=nil
end
end
end
self:_RandomizeZones(SpawnIndex)
return self
end
function SPAWN:_RandomizeTemplate(SpawnIndex)
if self.SpawnRandomizeTemplate then
self.SpawnGroups[SpawnIndex].SpawnTemplatePrefix=self.SpawnTemplatePrefixTable[math.random(1,#self.SpawnTemplatePrefixTable)]
self.SpawnGroups[SpawnIndex].SpawnTemplate=self:_Prepare(self.SpawnGroups[SpawnIndex].SpawnTemplatePrefix,SpawnIndex)
self.SpawnGroups[SpawnIndex].SpawnTemplate.route=UTILS.DeepCopy(self.SpawnTemplate.route)
self.SpawnGroups[SpawnIndex].SpawnTemplate.x=self.SpawnTemplate.x
self.SpawnGroups[SpawnIndex].SpawnTemplate.y=self.SpawnTemplate.y
self.SpawnGroups[SpawnIndex].SpawnTemplate.start_time=self.SpawnTemplate.start_time
local OldX=self.SpawnGroups[SpawnIndex].SpawnTemplate.units[1].x
local OldY=self.SpawnGroups[SpawnIndex].SpawnTemplate.units[1].y
for UnitID=1,#self.SpawnGroups[SpawnIndex].SpawnTemplate.units do
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[UnitID].heading=self.SpawnTemplate.units[1].heading
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[UnitID].x=self.SpawnTemplate.units[1].x+(self.SpawnGroups[SpawnIndex].SpawnTemplate.units[UnitID].x-OldX)
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[UnitID].y=self.SpawnTemplate.units[1].y+(self.SpawnGroups[SpawnIndex].SpawnTemplate.units[UnitID].y-OldY)
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[UnitID].alt=self.SpawnTemplate.units[1].alt
end
end
self:_RandomizeRoute(SpawnIndex)
return self
end
function SPAWN:_SetInitialPosition(SpawnIndex)
if self.SpawnFromNewPosition then
local SpawnVec2=self.SpawnInitPosition
local SpawnTemplate=self.SpawnGroups[SpawnIndex].SpawnTemplate
SpawnTemplate.route=SpawnTemplate.route or{}
SpawnTemplate.route.points=SpawnTemplate.route.points or{}
SpawnTemplate.route.points[1]=SpawnTemplate.route.points[1]or{}
SpawnTemplate.route.points[1].x=SpawnTemplate.route.points[1].x or 0
SpawnTemplate.route.points[1].y=SpawnTemplate.route.points[1].y or 0
for UnitID=1,#SpawnTemplate.units do
local UnitTemplate=SpawnTemplate.units[UnitID]
local SX=UnitTemplate.x
local SY=UnitTemplate.y
local BX=SpawnTemplate.route.points[1].x
local BY=SpawnTemplate.route.points[1].y
local TX=SpawnVec2.x+(SX-BX)
local TY=SpawnVec2.y+(SY-BY)
UnitTemplate.x=TX
UnitTemplate.y=TY
end
SpawnTemplate.route.points[1].x=SpawnVec2.x
SpawnTemplate.route.points[1].y=SpawnVec2.y
SpawnTemplate.x=SpawnVec2.x
SpawnTemplate.y=SpawnVec2.y
end
return self
end
function SPAWN:_RandomizeZones(SpawnIndex,RandomizePositionInZone)
if self.SpawnRandomizeZones then
local SpawnZone=nil
while not SpawnZone do
local ZoneID=math.random(#self.SpawnZoneTable)
SpawnZone=self.SpawnZoneTable[ZoneID]:GetZoneMaybe()
end
local SpawnVec2=SpawnZone:GetVec2()
if RandomizePositionInZone~=false then
SpawnVec2=SpawnZone:GetRandomVec2()
end
local SpawnTemplate=self.SpawnGroups[SpawnIndex].SpawnTemplate
self.SpawnGroups[SpawnIndex].SpawnZone=SpawnZone
for UnitID=1,#SpawnTemplate.units do
local UnitTemplate=SpawnTemplate.units[UnitID]
local SX=UnitTemplate.x
local SY=UnitTemplate.y
local BX=SpawnTemplate.route.points[1].x
local BY=SpawnTemplate.route.points[1].y
local TX=SpawnVec2.x+(SX-BX)
local TY=SpawnVec2.y+(SY-BY)
UnitTemplate.x=TX
UnitTemplate.y=TY
end
SpawnTemplate.x=SpawnVec2.x
SpawnTemplate.y=SpawnVec2.y
SpawnTemplate.route.points[1].x=SpawnVec2.x
SpawnTemplate.route.points[1].y=SpawnVec2.y
end
return self
end
function SPAWN:_TranslateRotate(SpawnIndex,SpawnRootX,SpawnRootY,SpawnX,SpawnY,SpawnAngle)
local TranslatedX=SpawnX
local TranslatedY=SpawnY
local RotatedX=-TranslatedX*math.cos(math.rad(SpawnAngle))+TranslatedY*math.sin(math.rad(SpawnAngle))
local RotatedY=TranslatedX*math.sin(math.rad(SpawnAngle))+TranslatedY*math.cos(math.rad(SpawnAngle))
self.SpawnGroups[SpawnIndex].SpawnTemplate.x=SpawnRootX-RotatedX
self.SpawnGroups[SpawnIndex].SpawnTemplate.y=SpawnRootY+RotatedY
local SpawnUnitCount=table.getn(self.SpawnGroups[SpawnIndex].SpawnTemplate.units)
for u=1,SpawnUnitCount do
local TranslatedX=SpawnX
local TranslatedY=SpawnY-10*(u-1)
local RotatedX=-TranslatedX*math.cos(math.rad(SpawnAngle))+TranslatedY*math.sin(math.rad(SpawnAngle))
local RotatedY=TranslatedX*math.sin(math.rad(SpawnAngle))+TranslatedY*math.cos(math.rad(SpawnAngle))
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[u].x=SpawnRootX-RotatedX
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[u].y=SpawnRootY+RotatedY
self.SpawnGroups[SpawnIndex].SpawnTemplate.units[u].heading=self.SpawnGroups[SpawnIndex].SpawnTemplate.units[u].heading+math.rad(SpawnAngle)
end
return self
end
function SPAWN:_GetSpawnIndex(SpawnIndex)
if(self.SpawnMaxGroups==0)or(SpawnIndex<=self.SpawnMaxGroups)then
if(self.SpawnMaxUnitsAlive==0)or(self.AliveUnits+#self.SpawnTemplate.units<=self.SpawnMaxUnitsAlive)or self.UnControlled==true then
if SpawnIndex and SpawnIndex>=self.SpawnCount+1 then
self.SpawnCount=self.SpawnCount+1
SpawnIndex=self.SpawnCount
end
self.SpawnIndex=SpawnIndex
if not self.SpawnGroups[self.SpawnIndex]then
self:_InitializeSpawnGroups(self.SpawnIndex)
end
else
return nil
end
else
return nil
end
return self.SpawnIndex
end
function SPAWN:_OnBirth(EventData)
local SpawnGroup=EventData.IniGroup
if SpawnGroup then
local EventPrefix=self:_GetPrefixFromGroup(SpawnGroup)
if EventPrefix then
if EventPrefix==self.SpawnTemplatePrefix or(self.SpawnAliasPrefix and EventPrefix==self.SpawnAliasPrefix)then
self.AliveUnits=self.AliveUnits+1
end
end
end
end
function SPAWN:_CountAliveUnits()
local count=0
if self.SpawnAliasPrefix then
if not self.SpawnAliasPrefixEscaped then self.SpawnAliasPrefixEscaped=string.gsub(self.SpawnAliasPrefix,"[%p%s]",".")end
local SpawnAliasPrefix=self.SpawnAliasPrefixEscaped
local agroups=GROUP:FindAllByMatching(SpawnAliasPrefix)
for _,_grp in pairs(agroups)do
local game=self:_GetPrefixFromGroupName(_grp.GroupName)
if game and game==self.SpawnAliasPrefix then
count=count+_grp:CountAliveUnits()
end
end
else
if not self.SpawnTemplatePrefixEscaped then self.SpawnTemplatePrefixEscaped=string.gsub(self.SpawnTemplatePrefix,"[%p%s]",".")end
local SpawnTemplatePrefix=self.SpawnTemplatePrefixEscaped
local groups=GROUP:FindAllByMatching(SpawnTemplatePrefix)
for _,_grp in pairs(groups)do
local game=self:_GetPrefixFromGroupName(_grp.GroupName)
if game and game==self.SpawnTemplatePrefix then
count=count+_grp:CountAliveUnits()
end
end
end
self.AliveUnits=count
return self
end
function SPAWN:_OnDeadOrCrash(EventData)
local unit=UNIT:FindByName(EventData.IniUnitName)
if unit then
local EventPrefix=self:_GetPrefixFromGroupName(unit.GroupName)
if EventPrefix then
if EventPrefix==self.SpawnTemplatePrefix or(self.SpawnAliasPrefix and EventPrefix==self.SpawnAliasPrefix)and self.AliveUnits>0 then
self:ScheduleOnce(1,self._CountAliveUnits,self)
end
end
end
end
function SPAWN:_OnTakeOff(EventData)
local SpawnGroup=EventData.IniGroup
if SpawnGroup then
local EventPrefix=self:_GetPrefixFromGroup(SpawnGroup)
if EventPrefix then
if EventPrefix==self.SpawnTemplatePrefix or(self.SpawnAliasPrefix and EventPrefix==self.SpawnAliasPrefix)then
SpawnGroup:SetState(SpawnGroup,"Spawn_Landed",false)
end
end
end
end
function SPAWN:_OnLand(EventData)
local SpawnGroup=EventData.IniGroup
if SpawnGroup then
local EventPrefix=self:_GetPrefixFromGroup(SpawnGroup)
if EventPrefix then
if EventPrefix==self.SpawnTemplatePrefix or(self.SpawnAliasPrefix and EventPrefix==self.SpawnAliasPrefix)then
SpawnGroup:SetState(SpawnGroup,"Spawn_Landed",true)
if self.RepeatOnLanding then
local SpawnGroupIndex=self:GetSpawnIndexFromGroup(SpawnGroup)
SCHEDULER:New(nil,self.ReSpawn,{self,SpawnGroupIndex},self.RepeatOnLandingTime or 3)
end
end
end
end
end
function SPAWN:_OnEngineShutDown(EventData)
local SpawnGroup=EventData.IniGroup
if SpawnGroup then
local EventPrefix=self:_GetPrefixFromGroup(SpawnGroup)
if EventPrefix then
if EventPrefix==self.SpawnTemplatePrefix or(self.SpawnAliasPrefix and EventPrefix==self.SpawnAliasPrefix)then
local Landed=SpawnGroup:GetState(SpawnGroup,"Spawn_Landed")
if Landed and self.RepeatOnEngineShutDown then
local SpawnGroupIndex=self:GetSpawnIndexFromGroup(SpawnGroup)
SCHEDULER:New(nil,self.ReSpawn,{self,SpawnGroupIndex},3)
end
end
end
end
end
function SPAWN:_Scheduler()
self:F2({"_Scheduler",self.SpawnTemplatePrefix,self.SpawnAliasPrefix,self.SpawnIndex,self.SpawnMaxGroups,self.SpawnMaxUnitsAlive})
self:Spawn()
return true
end
function SPAWN:_SpawnCleanUpScheduler()
local SpawnGroup,SpawnCursor=self:GetFirstAliveGroup()
local IsHelo=false
while SpawnGroup do
IsHelo=SpawnGroup:IsHelicopter()
local SpawnUnits=SpawnGroup:GetUnits()
for UnitID,UnitData in pairs(SpawnUnits)do
local SpawnUnit=UnitData
local SpawnUnitName=SpawnUnit:GetName()
self.SpawnCleanUpTimeStamps[SpawnUnitName]=self.SpawnCleanUpTimeStamps[SpawnUnitName]or{}
local Stamp=self.SpawnCleanUpTimeStamps[SpawnUnitName]
if Stamp.Vec2 then
if(SpawnUnit:InAir()==false and SpawnUnit:GetVelocityKMH()<1)or IsHelo then
local NewVec2=SpawnUnit:GetVec2()or{x=0,y=0}
if(Stamp.Vec2.x==NewVec2.x and Stamp.Vec2.y==NewVec2.y)or(SpawnUnit:GetLife()<=1)then
if Stamp.Time+self.SpawnCleanUpInterval<timer.getTime()then
SCHEDULER:New(nil,self.ReSpawn,{self,SpawnCursor},3)
Stamp.Vec2=nil
Stamp.Time=nil
end
else
Stamp.Time=timer.getTime()
Stamp.Vec2=SpawnUnit:GetVec2()
end
else
Stamp.Vec2=nil
Stamp.Time=nil
end
else
if SpawnUnit:InAir()==false or(IsHelo and SpawnUnit:GetLife()<=1)then
Stamp.Vec2=SpawnUnit:GetVec2()or{x=0,y=0}
if(SpawnUnit:GetVelocityKMH()<1)then
Stamp.Time=timer.getTime()
end
else
Stamp.Time=nil
Stamp.Vec2=nil
end
end
end
SpawnGroup,SpawnCursor=self:GetNextAliveGroup(SpawnCursor)
end
return true
end
SPAWNSTATIC={
ClassName="SPAWNSTATIC",
SpawnIndex=0,
}
function SPAWNSTATIC:NewFromStatic(SpawnTemplateName,SpawnCountryID)
local self=BASE:Inherit(self,BASE:New())
local TemplateStatic,CoalitionID,CategoryID,CountryID=_DATABASE:GetStaticGroupTemplate(SpawnTemplateName)
if TemplateStatic then
self.SpawnTemplatePrefix=SpawnTemplateName
self.TemplateStaticUnit=UTILS.DeepCopy(TemplateStatic.units[1])
self.CountryID=SpawnCountryID or CountryID
self.CategoryID=CategoryID
self.CoalitionID=CoalitionID
self.SpawnIndex=0
else
error("SPAWNSTATIC:New: There is no static declared in the mission editor with SpawnTemplatePrefix = '"..tostring(SpawnTemplateName).."'")
end
self:SetEventPriority(5)
return self
end
function SPAWNSTATIC:NewFromTemplate(SpawnTemplate,CountryID)
local self=BASE:Inherit(self,BASE:New())
self.TemplateStaticUnit=UTILS.DeepCopy(SpawnTemplate)
self.SpawnTemplatePrefix=SpawnTemplate.name
self.CountryID=CountryID or country.id.USA
return self
end
function SPAWNSTATIC:NewFromType(StaticType,StaticCategory,CountryID)
local self=BASE:Inherit(self,BASE:New())
self.InitStaticType=StaticType
self.InitStaticCategory=StaticCategory
self.CountryID=CountryID or country.id.USA
self.SpawnTemplatePrefix=self.InitStaticType
self.TemplateStaticUnit={}
self.InitStaticCoordinate=COORDINATE:New(0,0,0)
self.InitStaticHeading=0
return self
end
function SPAWNSTATIC:_InitResourceTable(CombinedWeight)
if not self.TemplateStaticUnit.resourcePayload then
self.TemplateStaticUnit.resourcePayload={
["weapons"]={},
["aircrafts"]={},
["gasoline"]=0,
["diesel"]=0,
["methanol_mixture"]=0,
["jet_fuel"]=0,
}
end
self:InitCargo(true)
self:InitCargoMass(CombinedWeight or 1)
return self
end
function SPAWNSTATIC:AddCargoResource(Type,Name,Amount,CombinedWeight)
if not self.TemplateStaticUnit.resourcePayload then
self:_InitResourceTable(CombinedWeight)
end
if Type==STORAGE.Type.LIQUIDS and type(Name)=="string"then
self.TemplateStaticUnit.resourcePayload[Name]=Amount
else
self.TemplateStaticUnit.resourcePayload[Type]={
[Name]={
["amount"]=Amount,
}
}
end
UTILS.PrintTableToLog(self.TemplateStaticUnit)
return self
end
function SPAWNSTATIC:ResetCargoResources()
self.TemplateStaticUnit.resourcePayload=nil
self:_InitResourceTable()
return self
end
function SPAWNSTATIC:InitCoordinate(Coordinate)
self.InitStaticCoordinate=Coordinate
return self
end
function SPAWNSTATIC:InitHeading(Heading)
self.InitStaticHeading=Heading
return self
end
function SPAWNSTATIC:InitLivery(LiveryName)
self.InitStaticLivery=LiveryName
return self
end
function SPAWNSTATIC:InitType(StaticType)
self.InitStaticType=StaticType
return self
end
function SPAWNSTATIC:InitShape(StaticShape)
self.InitStaticShape=StaticShape
return self
end
function SPAWNSTATIC:InitFARP(CallsignID,Frequency,Modulation)
self.InitFarp=true
self.InitFarpCallsignID=CallsignID or 1
self.InitFarpFreq=Frequency or 127.5
self.InitFarpModu=Modulation or 0
return self
end
function SPAWNSTATIC:InitCargoMass(Mass)
self.InitStaticCargoMass=Mass
return self
end
function SPAWNSTATIC:InitCargo(IsCargo)
self.InitStaticCargo=IsCargo
return self
end
function SPAWNSTATIC:InitDead(IsDead)
self.InitStaticDead=IsDead
return self
end
function SPAWNSTATIC:InitCountry(CountryID)
self.CountryID=CountryID
return self
end
function SPAWNSTATIC:InitNamePrefix(NamePrefix)
self.SpawnTemplatePrefix=NamePrefix
return self
end
function SPAWNSTATIC:InitLinkToUnit(Unit,OffsetX,OffsetY,OffsetAngle)
self.InitLinkUnit=Unit
self.InitOffsetX=OffsetX or 0
self.InitOffsetY=OffsetY or 0
self.InitOffsetAngle=OffsetAngle or 0
return self
end
function SPAWNSTATIC:OnSpawnStatic(SpawnCallBackFunction,...)
self:F("OnSpawnStatic")
self.SpawnFunctionHook=SpawnCallBackFunction
self.SpawnFunctionArguments={}
if arg then
self.SpawnFunctionArguments=arg
end
return self
end
function SPAWNSTATIC:Spawn(Heading,NewName)
if Heading then
self.InitStaticHeading=Heading
end
if NewName then
self.InitStaticName=NewName
end
return self:_SpawnStatic(self.TemplateStaticUnit,self.CountryID)
end
function SPAWNSTATIC:SpawnFromPointVec2(PointVec2,Heading,NewName)
local vec2={x=PointVec2:GetX(),y=PointVec2:GetY()}
local Coordinate=COORDINATE:NewFromVec2(vec2)
return self:SpawnFromCoordinate(Coordinate,Heading,NewName)
end
function SPAWNSTATIC:SpawnFromCoordinate(Coordinate,Heading,NewName)
self.InitStaticCoordinate=Coordinate
if Heading then
self.InitStaticHeading=Heading
end
if NewName then
self.InitStaticName=NewName
end
return self:_SpawnStatic(self.TemplateStaticUnit,self.CountryID)
end
function SPAWNSTATIC:SpawnFromZone(Zone,Heading,NewName)
local Static=self:SpawnFromPointVec2(Zone:GetPointVec2(),Heading,NewName)
return Static
end
function SPAWNSTATIC:_SpawnStatic(Template,CountryID)
Template=Template or{}
local CountryID=CountryID or self.CountryID
if self.InitStaticType then
Template.type=self.InitStaticType
end
if self.InitStaticCategory then
Template.category=self.InitStaticCategory
end
if self.InitStaticCoordinate then
Template.x=self.InitStaticCoordinate.x
Template.y=self.InitStaticCoordinate.z
Template.alt=self.InitStaticCoordinate.y
end
if self.InitStaticHeading then
Template.heading=math.rad(self.InitStaticHeading)
end
if self.InitStaticShape then
Template.shape_name=self.InitStaticShape
end
if self.InitStaticLivery then
Template.livery_id=self.InitStaticLivery
end
if self.InitStaticDead~=nil then
Template.dead=self.InitStaticDead
end
if self.InitStaticCargo~=nil then
Template.canCargo=self.InitStaticCargo
end
if self.InitStaticCargoMass~=nil then
Template.mass=self.InitStaticCargoMass
end
if self.InitLinkUnit then
Template.linkUnit=self.InitLinkUnit:GetID()
Template.linkOffset=true
Template.offsets={}
Template.offsets.y=self.InitOffsetY
Template.offsets.x=self.InitOffsetX
Template.offsets.angle=self.InitOffsetAngle and math.rad(self.InitOffsetAngle)or 0
end
if self.InitFarp then
Template.heliport_callsign_id=self.InitFarpCallsignID
Template.heliport_frequency=self.InitFarpFreq
Template.heliport_modulation=self.InitFarpModu
Template.unitId=nil
end
self.SpawnIndex=self.SpawnIndex+1
Template.name=self.InitStaticName or string.format("%s#%05d",self.SpawnTemplatePrefix,self.SpawnIndex)
local Static=nil
if self.InitFarp then
local TemplateGroup={}
TemplateGroup.units={}
TemplateGroup.units[1]=Template
TemplateGroup.visible=true
TemplateGroup.hidden=false
TemplateGroup.x=Template.x
TemplateGroup.y=Template.y
TemplateGroup.name=Template.name
self:T("Spawning FARP")
self:T({Template=Template})
self:T({TemplateGroup=TemplateGroup})
Static=coalition.addGroup(CountryID,-1,TemplateGroup)
local Event={
id=EVENTS.Birth,
time=timer.getTime(),
initiator=Static
}
world.onEvent(Event)
else
self:T("Spawning Static")
self:T2({Template=Template})
Static=coalition.addStaticObject(CountryID,Template)
if Static then
self:T(string.format("Succesfully spawned static object \"%s\" ID=%d",Static:getName(),Static:getID()))
else
self:E(string.format("ERROR: DCS static object \"%s\" is nil!",tostring(Template.name)))
end
end
local mystatic=_DATABASE:AddStatic(Template.name)
if self.SpawnFunctionHook then
self:ScheduleOnce(0.3,self.SpawnFunctionHook,mystatic,unpack(self.SpawnFunctionArguments))
end
return mystatic
end
TIMER={
ClassName="TIMER",
lid=nil,
}
_TIMERID=0
TIMER.version="0.2.0"
function TIMER:New(Function,...)
local self=BASE:Inherit(self,BASE:New())
self.func=Function
self.para=arg or{}
self.ncalls=0
self.isrunning=false
_TIMERID=_TIMERID+1
self.uid=_TIMERID
self.lid=string.format("TIMER UID=%d | ",self.uid)
return self
end
function TIMER:Start(Tstart,dT,Duration)
local Tnow=timer.getTime()
self.Tstart=Tstart and Tnow+math.max(Tstart,0.001)or Tnow+0.001
self.dT=dT
if Duration then
self.Tstop=self.Tstart+Duration
end
self.tid=timer.scheduleFunction(self._Function,self,self.Tstart)
self.lid=string.format("TIMER UID=%d/%d | ",self.uid,self.tid)
self.isrunning=true
self:T(self.lid..string.format("Starting Timer in %.3f sec, dT=%s, Tstop=%s",self.Tstart-Tnow,tostring(self.dT),tostring(self.Tstop)))
return self
end
function TIMER:StartIf(Condition,Tstart,dT,Duration)
if Condition then
self:Start(Tstart,dT,Duration)
end
return self
end
function TIMER:Stop(Delay)
if Delay and Delay>0 then
self.Tstop=timer.getTime()+Delay
else
if self.tid then
self:T(self.lid..string.format("Stopping timer by removing timer function after %d calls!",self.ncalls))
local status=pcall(
function()
timer.removeFunction(self.tid)
end
)
if status then
self:T2(self.lid..string.format("Stopped timer!"))
else
self:E(self.lid..string.format("WARNING: Could not remove timer function! isrunning=%s",tostring(self.isrunning)))
end
self.isrunning=false
end
end
return self
end
function TIMER:SetMaxFunctionCalls(Nmax)
self.ncallsMax=Nmax
return self
end
function TIMER:SetTimeInterval(dT)
self.dT=dT
return self
end
function TIMER:IsRunning()
return self.isrunning
end
function TIMER:_Function(time)
self.func(unpack(self.para))
self.ncalls=self.ncalls+1
local Tnext=self.dT and time+self.dT or nil
local stopme=false
if Tnext==nil then
self:T(self.lid..string.format("No next time as dT=nil ==> Stopping timer after %d function calls",self.ncalls))
stopme=true
elseif self.Tstop and Tnext>self.Tstop then
self:T(self.lid..string.format("Stop time passed %.3f > %.3f ==> Stopping timer after %d function calls",Tnext,self.Tstop,self.ncalls))
stopme=true
elseif self.ncallsMax and self.ncalls>=self.ncallsMax then
self:T(self.lid..string.format("Max function calls Nmax=%d reached ==> Stopping timer after %d function calls",self.ncallsMax,self.ncalls))
stopme=true
end
if stopme then
self:Stop()
return nil
else
return Tnext
end
end
do
GOAL={
ClassName="GOAL",
}
GOAL.Players={}
GOAL.TotalContributions=0
function GOAL:New()
local self=BASE:Inherit(self,FSM:New())
self:F({})
self:SetStartState("Pending")
self:AddTransition("*","Achieved","Achieved")
self:SetEventPriority(5)
return self
end
function GOAL:AddPlayerContribution(PlayerName)
self:F({PlayerName})
self.Players[PlayerName]=self.Players[PlayerName]or 0
self.Players[PlayerName]=self.Players[PlayerName]+1
self.TotalContributions=self.TotalContributions+1
end
function GOAL:GetPlayerContribution(PlayerName)
return self.Players[PlayerName]or 0
end
function GOAL:GetPlayerContributions()
return self.Players or{}
end
function GOAL:GetTotalContributions()
return self.TotalContributions or 0
end
function GOAL:IsAchieved()
return self:Is("Achieved")
end
end
do
SPOT={
ClassName="SPOT",
}
function SPOT:New(Recce)
local self=BASE:Inherit(self,FSM:New())
self:F({})
self:SetStartState("Off")
self:AddTransition("Off","LaseOn","On")
self:AddTransition("Off","LaseOnCoordinate","On")
self:AddTransition("On","Lasing","On")
self:AddTransition({"On","Destroyed"},"LaseOff","Off")
self:AddTransition("*","Destroyed","Destroyed")
self.Recce=Recce
self.RecceName=self.Recce:GetName()
self.LaseScheduler=SCHEDULER:New(self)
self:SetEventPriority(5)
self.Lasing=false
return self
end
function SPOT:onafterLaseOn(From,Event,To,Target,LaserCode,Duration)
self:T({From,Event,To})
self:T2({"LaseOn",Target,LaserCode,Duration})
local function StopLase(self)
self:LaseOff()
end
self.Target=Target
self.TargetName=Target:GetName()
self.LaserCode=LaserCode
self.Lasing=true
local RecceDcsUnit=self.Recce:GetDCSObject()
local relativespot=self.relstartpos or{x=0,y=2,z=0}
self.SpotIR=Spot.createInfraRed(RecceDcsUnit,relativespot,Target:GetPointVec3():AddY(1):GetVec3())
self.SpotLaser=Spot.createLaser(RecceDcsUnit,relativespot,Target:GetPointVec3():AddY(1):GetVec3(),LaserCode)
if Duration then
self.ScheduleID=self.LaseScheduler:Schedule(self,StopLase,{self},Duration)
end
self:HandleEvent(EVENTS.Dead)
self:__Lasing(-1)
return self
end
function SPOT:onafterLaseOnCoordinate(From,Event,To,Coordinate,LaserCode,Duration)
self:T2({"LaseOnCoordinate",Coordinate,LaserCode,Duration})
local function StopLase(self)
self:LaseOff()
end
self.Target=nil
self.TargetCoord=Coordinate
self.LaserCode=LaserCode
self.Lasing=true
local RecceDcsUnit=self.Recce:GetDCSObject()
self.SpotIR=Spot.createInfraRed(RecceDcsUnit,{x=0,y=1,z=0},Coordinate:GetVec3())
self.SpotLaser=Spot.createLaser(RecceDcsUnit,{x=0,y=1,z=0},Coordinate:GetVec3(),LaserCode)
if Duration then
self.ScheduleID=self.LaseScheduler:Schedule(self,StopLase,{self},Duration)
end
self:__Lasing(-1)
return self
end
function SPOT:OnEventDead(EventData)
self:T2({Dead=EventData.IniDCSUnitName,Target=self.Target})
if self.Target then
if EventData.IniDCSUnitName==self.TargetName then
self:F({"Target dead ",self.TargetName})
self:Destroyed()
self:LaseOff()
end
end
if self.Recce then
if EventData.IniDCSUnitName==self.RecceName then
self:F({"Recce dead ",self.RecceName})
self:LaseOff()
end
end
return self
end
function SPOT:onafterLasing(From,Event,To)
self:T({From,Event,To})
if self.Lasing then
if self.Target and self.Target:IsAlive()then
self.SpotIR:setPoint(self.Target:GetPointVec3():AddY(1):AddY(math.random(-100,100)/200):AddX(math.random(-100,100)/200):GetVec3())
self.SpotLaser:setPoint(self.Target:GetPointVec3():AddY(1):GetVec3())
self:__Lasing(0.2)
elseif self.TargetCoord then
local irvec3={x=self.TargetCoord.x+math.random(-100,100)/200,y=self.TargetCoord.y+math.random(-100,100)/200,z=self.TargetCoord.z}
local lsvec3={x=self.TargetCoord.x,y=self.TargetCoord.y,z=self.TargetCoord.z}
self.SpotIR:setPoint(irvec3)
self.SpotLaser:setPoint(lsvec3)
self:__Lasing(0.2)
else
self:F({"Target is not alive",self.Target:IsAlive()})
end
end
return self
end
function SPOT:onafterLaseOff(From,Event,To)
self:T({From,Event,To})
self:T2({"Stopped lasing for ",self.Target and self.Target:GetName()or"coord",SpotIR=self.SportIR,SpotLaser=self.SpotLaser})
self.Lasing=false
self.SpotIR:destroy()
self.SpotLaser:destroy()
self.SpotIR=nil
self.SpotLaser=nil
if self.ScheduleID then
self.LaseScheduler:Stop(self.ScheduleID)
end
self.ScheduleID=nil
self.Target=nil
return self
end
function SPOT:IsLasing()
return self.Lasing
end
function SPOT:SetRelativeStartPosition(position)
self.relstartpos=position or{x=0,y=2,z=0}
return self
end
end
MARKEROPS_BASE={
ClassName="MARKEROPS",
Tag="mytag",
Keywords={},
version="0.1.3",
debug=false,
Casesensitive=true,
}
function MARKEROPS_BASE:New(Tagname,Keywords,Casesensitive)
local self=BASE:Inherit(self,FSM:New())
self.lid=string.format("MARKEROPS_BASE %s | ",tostring(self.version))
self.Tag=Tagname or"mytag"
self.Keywords=Keywords or{}
self.debug=false
self.Casesensitive=true
if Casesensitive and Casesensitive==false then
self.Casesensitive=false
end
self:SetStartState("Stopped")
self:AddTransition("Stopped","Start","Running")
self:AddTransition("*","MarkAdded","*")
self:AddTransition("*","MarkChanged","*")
self:AddTransition("*","MarkDeleted","*")
self:AddTransition("Running","Stop","Stopped")
self:HandleEvent(EVENTS.MarkAdded,self.OnEventMark)
self:HandleEvent(EVENTS.MarkChange,self.OnEventMark)
self:HandleEvent(EVENTS.MarkRemoved,self.OnEventMark)
self:I(self.lid..string.format("started for %s",self.Tag))
self:__Start(1)
return self
end
function MARKEROPS_BASE:OnEventMark(Event)
self:T({Event})
if Event==nil or Event.idx==nil then
self:E("Skipping onEvent. Event or Event.idx unknown.")
return true
end
local vec3={y=Event.pos.y,x=Event.pos.x,z=Event.pos.z}
local coord=COORDINATE:NewFromVec3(vec3)
if self.debug then
local coordtext=coord:ToStringLLDDM()
local text=tostring(Event.text)
local m=MESSAGE:New(string.format("Mark added at %s with text: %s",coordtext,text),10,"Info",false):ToAll()
end
local coalition=Event.MarkCoalition
if Event.id==world.event.S_EVENT_MARK_ADDED then
self:T({event="S_EVENT_MARK_ADDED",carrier=Event.IniGroupName,vec3=Event.pos})
local Eventtext=tostring(Event.text)
if Eventtext~=nil then
if self:_MatchTag(Eventtext)then
local matchtable=self:_MatchKeywords(Eventtext)
self:MarkAdded(Eventtext,matchtable,coord,Event.idx,coalition,Event.PlayerName,Event)
end
end
elseif Event.id==world.event.S_EVENT_MARK_CHANGE then
self:T({event="S_EVENT_MARK_CHANGE",carrier=Event.IniGroupName,vec3=Event.pos})
local Eventtext=tostring(Event.text)
if Eventtext~=nil then
if self:_MatchTag(Eventtext)then
local matchtable=self:_MatchKeywords(Eventtext)
self:MarkChanged(Eventtext,matchtable,coord,Event.idx,coalition,Event.PlayerName,Event)
end
end
elseif Event.id==world.event.S_EVENT_MARK_REMOVED then
self:T({event="S_EVENT_MARK_REMOVED",carrier=Event.IniGroupName,vec3=Event.pos})
local Eventtext=tostring(Event.text)
if Eventtext~=nil then
if self:_MatchTag(Eventtext)then
self:MarkDeleted()
end
end
end
end
function MARKEROPS_BASE:_MatchTag(Eventtext)
local matches=false
if not self.Casesensitive then
local type=string.lower(self.Tag)
if string.find(string.lower(Eventtext),type)then
matches=true
end
else
local type=self.Tag
if string.find(Eventtext,type)then
matches=true
end
end
return matches
end
function MARKEROPS_BASE:_MatchKeywords(Eventtext)
local matchtable={}
local keytable=self.Keywords
for _index,_word in pairs(keytable)do
if string.find(string.lower(Eventtext),string.lower(_word))then
table.insert(matchtable,_word)
end
end
return matchtable
end
function MARKEROPS_BASE:onbeforeMarkAdded(From,Event,To,Text,Keywords,Coord,MarkerID,CoalitionNumber)
self:T({self.lid,From,Event,To,Text,Keywords,Coord:ToStringLLDDM()})
end
function MARKEROPS_BASE:onbeforeMarkChanged(From,Event,To,Text,Keywords,Coord,MarkerID,CoalitionNumber)
self:T({self.lid,From,Event,To,Text,Keywords,Coord:ToStringLLDDM()})
end
function MARKEROPS_BASE:onbeforeMarkDeleted(From,Event,To)
self:T({self.lid,From,Event,To})
end
function MARKEROPS_BASE:onenterStopped(From,Event,To)
self:T({self.lid,From,Event,To})
self:UnHandleEvent(EVENTS.MarkAdded)
self:UnHandleEvent(EVENTS.MarkChange)
self:UnHandleEvent(EVENTS.MarkRemoved)
end
TEXTANDSOUND={
ClassName="TEXTANDSOUND",
version="0.0.1",
lid="",
locale="en",
entries={},
textclass="",
}
function TEXTANDSOUND:New(ClassName,Defaultlocale)
local self=BASE:Inherit(self,BASE:New())
self.lid=string.format("%s (%s) | ",self.ClassName,self.version)
self.locale=Defaultlocale or(_SETTINGS:GetLocale()or"en")
self.textclass=ClassName or"none"
self.entries={}
local initentry={}
initentry.Classname=ClassName
initentry.Data={}
initentry.Locale=self.locale
self.entries[self.locale]=initentry
self:I(self.lid.."Instantiated.")
self:T({self.entries[self.locale]})
return self
end
function TEXTANDSOUND:AddEntry(Locale,ID,Text,Soundfile,Soundlength,Subtitle)
self:T(self.lid.."AddEntry")
local locale=Locale or self.locale
local dataentry={}
dataentry.ID=ID or"1"
dataentry.Text=Text or"none"
dataentry.Soundfile=Soundfile
dataentry.Soundlength=Soundlength or 0
dataentry.Subtitle=Subtitle
if not self.entries[locale]then
local initentry={}
initentry.Classname=self.textclass
initentry.Data={}
initentry.Locale=locale
self.entries[locale]=initentry
end
self.entries[locale].Data[ID]=dataentry
self:T({self.entries[locale].Data})
return self
end
function TEXTANDSOUND:GetEntry(ID,Locale)
self:T(self.lid.."GetEntry")
local locale=Locale or self.locale
if not self.entries[locale]then
locale=self.locale
end
local Text,Soundfile,Soundlength,Subtitle=nil,nil,0,nil
if self.entries[locale]then
if self.entries[locale].Data then
local data=self.entries[locale].Data[ID]
if data then
Text=data.Text
Soundfile=data.Soundfile
Soundlength=data.Soundlength
Subtitle=data.Subtitle
elseif self.entries[self.locale].Data[ID]then
local data=self.entries[self.locale].Data[ID]
Text=data.Text
Soundfile=data.Soundfile
Soundlength=data.Soundlength
Subtitle=data.Subtitle
end
end
else
return nil,nil,0,nil
end
return Text,Soundfile,Soundlength,Subtitle
end
function TEXTANDSOUND:GetDefaultLocale()
self:T(self.lid.."GetDefaultLocale")
return self.locale
end
function TEXTANDSOUND:SetDefaultLocale(locale)
self:T(self.lid.."SetDefaultLocale")
self.locale=locale or"en"
return self
end
function TEXTANDSOUND:HasLocale(Locale)
self:T(self.lid.."HasLocale")
return self.entries[Locale]and true or false
end
function TEXTANDSOUND:FlushToLog()
self:I(self.lid.."Flushing entries:")
local text=string.format("Textclass: %s | Default Locale: %s",self.textclass,self.locale)
for _,_entry in pairs(self.entries)do
local entry=_entry
local text=string.format("Textclassname: %s | Locale: %s",entry.Classname,entry.Locale)
self:I(text)
for _ID,_data in pairs(entry.Data)do
local data=_data
local text=string.format("ID: %s\nText: %s\nSoundfile: %s With length: %d\nSubtitle: %s",tostring(_ID),data.Text or"none",data.Soundfile or"none",data.Soundlength or 0,data.Subtitle or"none")
self:I(text)
end
end
return self
end
PATHLINE={
ClassName="PATHLINE",
lid=nil,
points={},
}
PATHLINE.version="0.1.1"
function PATHLINE:New(Name)
local self=BASE:Inherit(self,BASE:New())
self.name=Name or"Unknown Path"
self.lid=string.format("PATHLINE %s | ",Name)
return self
end
function PATHLINE:NewFromVec2Array(Name,Vec2Array)
local self=PATHLINE:New(Name)
for i=1,#Vec2Array do
self:AddPointFromVec2(Vec2Array[i])
end
return self
end
function PATHLINE:NewFromVec3Array(Name,Vec3Array)
local self=PATHLINE:New(Name)
for i=1,#Vec3Array do
self:AddPointFromVec3(Vec3Array[i])
end
return self
end
function PATHLINE:FindByName(Name)
local pathline=_DATABASE:FindPathline(Name)
return pathline
end
function PATHLINE:AddPointFromVec2(Vec2)
if Vec2 then
local point=self:_CreatePoint(Vec2)
table.insert(self.points,point)
end
return self
end
function PATHLINE:AddPointFromVec3(Vec3)
if Vec3 then
local point=self:_CreatePoint(Vec3)
table.insert(self.points,point)
end
return self
end
function PATHLINE:GetName()
return self.name
end
function PATHLINE:GetNumberOfPoints()
local N=#self.points
return N
end
function PATHLINE:GetPoints()
return self.points
end
function PATHLINE:GetPoints3D()
local vecs={}
for _,_point in pairs(self.points)do
local point=_point
table.insert(vecs,point.vec3)
end
return vecs
end
function PATHLINE:GetPoints2D()
local vecs={}
for _,_point in pairs(self.points)do
local point=_point
table.insert(vecs,point.vec2)
end
return vecs
end
function PATHLINE:GetCoordinates()
local vecs={}
for _,_point in pairs(self.points)do
local point=_point
local coord=COORDINATE:NewFromVec3(point.vec3)
table.insert(vecs,coord)
end
return vecs
end
function PATHLINE:GetPointFromIndex(n)
local N=self:GetNumberOfPoints()
n=n or 1
local point=nil
if n>=1 and n<=N then
point=self.points[n]
else
self:E(self.lid..string.format("ERROR: No point in pathline for N=%s",tostring(n)))
end
return point
end
function PATHLINE:GetPoint3DFromIndex(n)
local point=self:GetPointFromIndex(n)
if point then
return point.vec3
end
return nil
end
function PATHLINE:GetPoint2DFromIndex(n)
local point=self:GetPointFromIndex(n)
if point then
return point.vec2
end
return nil
end
function PATHLINE:MarkPoints(Switch)
for i,_point in pairs(self.points)do
local point=_point
if Switch==false then
if point.markerID then
UTILS.RemoveMark(point.markerID,Delay)
end
else
if point.markerID then
UTILS.RemoveMark(point.markerID)
end
point.markerID=UTILS.GetMarkID()
local text=string.format("Pathline %s: Point #%d\nSurface Type=%d\nHeight=%.1f m\nDepth=%.1f m",self.name,i,point.surfaceType,point.landHeight,point.depth)
trigger.action.markToAll(point.markerID,text,point.vec3,"")
end
end
end
function PATHLINE:_CreatePoint(Vec)
local point={}
if Vec.z then
point.vec3=UTILS.DeepCopy(Vec)
point.vec2={x=Vec.x,y=Vec.z}
else
point.vec2=UTILS.DeepCopy(Vec)
point.vec3={x=Vec.x,y=land.getHeight(Vec),z=Vec.y}
end
point.surfaceType=land.getSurfaceType(point.vec2)
point.landHeight,point.depth=land.getSurfaceHeightWithSeabed(point.vec2)
point.markerID=nil
return point
end
CLIENTMENU={
ClassName="CLIENTMENU",
lid="",
version="0.1.3",
name=nil,
path=nil,
group=nil,
client=nil,
GroupID=nil,
Children={},
Once=false,
Generic=false,
debug=false,
Controller=nil,
groupname=nil,
active=false,
}
CLIENTMENU_ID=0
function CLIENTMENU:NewEntry(Client,Text,Parent,Function,...)
local self=BASE:Inherit(self,BASE:New())
CLIENTMENU_ID=CLIENTMENU_ID+1
self.ID=CLIENTMENU_ID
if Client then
self.group=Client:GetGroup()
self.client=Client
self.GroupID=self.group:GetID()
self.groupname=self.group:GetName()or"Unknown Groupname"
else
self.Generic=true
end
self.name=Text or"unknown entry"
if Parent then
if Parent:IsInstanceOf("MENU_BASE")then
self.parentpath=Parent.MenuPath
else
self.parentpath=Parent:GetPath()
Parent:AddChild(self)
end
end
self.Parent=Parent
self.Function=Function
self.Functionargs=arg or{}
table.insert(self.Functionargs,self.group)
table.insert(self.Functionargs,self.client)
if self.Functionargs and self.debug then
self:T({"Functionargs",self.Functionargs})
end
if not self.Generic and self.active==false then
if Function~=nil then
local ErrorHandler=function(errmsg)
env.info("MOOSE Error in CLIENTMENU COMMAND function: "..errmsg)
if BASE.Debug~=nil then
env.info(BASE.Debug.traceback())
end
return errmsg
end
self.CallHandler=function()
local function MenuFunction()
return self.Function(unpack(self.Functionargs))
end
local Status,Result=xpcall(MenuFunction,ErrorHandler)
if self.Once==true then
self:Clear()
end
end
self.path=missionCommands.addCommandForGroup(self.GroupID,Text,self.parentpath,self.CallHandler)
self.active=true
else
self.path=missionCommands.addSubMenuForGroup(self.GroupID,Text,self.parentpath)
self.active=true
end
else
if self.parentpath then
self.path=UTILS.DeepCopy(self.parentpath)
else
self.path={}
end
self.path[#self.path+1]=Text
end
self.UUID=table.concat(self.path,";")
self:T({self.UUID})
self.Once=false
self.lid=string.format("CLIENTMENU %s | %s | ",self.ID,self.name)
self:T(self.lid.."Created")
return self
end
function CLIENTMENU:CreateUUID(Parent,Text)
local path={}
if Parent and Parent.path then
path=Parent.path
end
path[#path+1]=Text
local UUID=table.concat(path,";")
return UUID
end
function CLIENTMENU:SetController(Controller)
self.Controller=Controller
return self
end
function CLIENTMENU:SetOnce()
self:T(self.lid.."SetOnce")
self.Once=true
return self
end
function CLIENTMENU:RemoveF10()
self:T(self.lid.."RemoveF10")
if self.GroupID then
local function RemoveFunction()
return missionCommands.removeItemForGroup(self.GroupID,self.path)
end
local status,err=pcall(RemoveFunction)
if not status then
self:I(string.format("**** Error Removing Menu Entry %s for %s!",tostring(self.name),self.groupname))
end
self.active=false
end
return self
end
function CLIENTMENU:GetPath()
self:T(self.lid.."GetPath")
return self.path
end
function CLIENTMENU:GetUUID()
self:T(self.lid.."GetUUID")
return self.UUID
end
function CLIENTMENU:AddChild(Child)
self:T(self.lid.."AddChild "..Child.ID)
table.insert(self.Children,Child.ID,Child)
return self
end
function CLIENTMENU:RemoveChild(Child)
self:T(self.lid.."RemoveChild "..Child.ID)
table.remove(self.Children,Child.ID)
return self
end
function CLIENTMENU:RemoveSubEntries()
self:T(self.lid.."RemoveSubEntries")
self:T({self.Children})
for _id,_entry in pairs(self.Children)do
self:T("Removing ".._id)
if _entry then
_entry:RemoveSubEntries()
_entry:RemoveF10()
if _entry.Parent then
_entry.Parent:RemoveChild(self)
end
end
end
return self
end
function CLIENTMENU:Clear()
self:T(self.lid.."Clear")
for _id,_entry in pairs(self.Children)do
if _entry then
_entry:RemoveSubEntries()
_entry=nil
end
end
self:RemoveF10()
if self.Parent then
self.Parent:RemoveChild(self)
end
return self
end
CLIENTMENUMANAGER={
ClassName="CLIENTMENUMANAGER",
lid="",
version="0.1.6",
name=nil,
clientset=nil,
menutree={},
flattree={},
playertree={},
entrycount=0,
rootentries={},
debug=true,
PlayerMenu={},
Coalition=nil,
}
function CLIENTMENUMANAGER:New(ClientSet,Alias,Coalition)
local self=BASE:Inherit(self,BASE:New())
self.clientset=ClientSet
self.PlayerMenu={}
self.name=Alias or"Nightshift"
self.Coalition=Coalition or coalition.side.BLUE
self.lid=string.format("CLIENTMENUMANAGER %s | %s | ",self.version,self.name)
if self.debug then
self:I(self.lid.."Created")
end
return self
end
function CLIENTMENUMANAGER:_EventHandler(EventData,Retry)
self:T(self.lid.."_EventHandler: "..EventData.id)
if EventData.id==EVENTS.PlayerLeaveUnit or EventData.id==EVENTS.Ejection or EventData.id==EVENTS.Crash or EventData.id==EVENTS.PilotDead then
self:T(self.lid.."Leave event for player: "..tostring(EventData.IniPlayerName))
local Client=_DATABASE:FindClient(EventData.IniUnitName)
if Client then
self:ResetMenu(Client)
end
elseif(EventData.id==EVENTS.PlayerEnterAircraft)and EventData.IniCoalition==self.Coalition then
if EventData.IniPlayerName and EventData.IniGroup then
if(not self.clientset:IsIncludeObject(_DATABASE:FindClient(EventData.IniUnitName)))then
self:T(self.lid.."Client not in SET: "..EventData.IniPlayerName)
if not Retry then
self:ScheduleOnce(2,CLIENTMENUMANAGER._EventHandler,self,EventData,true)
end
return self
end
local player=_DATABASE:FindClient(EventData.IniUnitName)
self:Propagate(player)
end
elseif EventData.id==EVENTS.PlayerEnterUnit then
local grp=GROUP:FindByName(EventData.IniGroupName)
if grp:IsGround()then
self:T(string.format("Player %s entered GROUND unit %s!",EventData.IniPlayerName,EventData.IniUnitName))
local IsPlayer=EventData.IniDCSUnit:getPlayerName()
if IsPlayer then
local client=_DATABASE.CLIENTS[EventData.IniDCSUnitName]
if not client then
self:I(string.format("Player '%s' joined ground unit '%s' of group '%s'",tostring(EventData.IniPlayerName),tostring(EventData.IniDCSUnitName),tostring(EventData.IniDCSGroupName)))
client=_DATABASE:AddClient(EventData.IniDCSUnitName)
client:AddPlayer(EventData.IniPlayerName)
if not _DATABASE.PLAYERS[EventData.IniPlayerName]then
_DATABASE:AddPlayer(EventData.IniUnitName,EventData.IniPlayerName)
end
local Settings=SETTINGS:Set(EventData.IniPlayerName)
Settings:SetPlayerMenu(EventData.IniUnit)
end
self:Propagate(client)
end
end
end
return self
end
function CLIENTMENUMANAGER:InitAutoPropagation()
self:HandleEvent(EVENTS.PlayerLeaveUnit,self._EventHandler)
self:HandleEvent(EVENTS.Ejection,self._EventHandler)
self:HandleEvent(EVENTS.Crash,self._EventHandler)
self:HandleEvent(EVENTS.PilotDead,self._EventHandler)
self:HandleEvent(EVENTS.PlayerEnterAircraft,self._EventHandler)
self:HandleEvent(EVENTS.PlayerEnterUnit,self._EventHandler)
self:SetEventPriority(6)
return self
end
function CLIENTMENUMANAGER:NewEntry(Text,Parent,Function,...)
self:T(self.lid.."NewEntry "..Text or"None")
self.entrycount=self.entrycount+1
local entry=CLIENTMENU:NewEntry(nil,Text,Parent,Function,unpack(arg))
if not Parent then
self.rootentries[self.entrycount]=entry
end
local depth=#entry.path
if not self.menutree[depth]then self.menutree[depth]={}end
table.insert(self.menutree[depth],entry.UUID)
self.flattree[entry.UUID]=entry
return entry
end
function CLIENTMENUMANAGER:EntryUUIDExists(UUID)
local exists=self.flattree[UUID]and true or false
return exists
end
function CLIENTMENUMANAGER:FindEntryByUUID(UUID)
self:T(self.lid.."FindEntryByUUID "..UUID or"None")
local entry=nil
for _gid,_entry in pairs(self.flattree)do
local Entry=_entry
if Entry and Entry.UUID==UUID then
entry=Entry
end
end
return entry
end
function CLIENTMENUMANAGER:FindUUIDsByText(Text,Parent)
self:T(self.lid.."FindUUIDsByText "..Text or"None")
local matches={}
local entries={}
local n=0
for _uuid,_entry in pairs(self.flattree)do
local Entry=_entry
if Parent then
if Entry and string.find(Entry.name,Text,1,true)and string.find(Entry.UUID,Parent.UUID,1,true)then
table.insert(matches,_uuid)
table.insert(entries,Entry)
n=n+1
end
else
if Entry and string.find(Entry.name,Text,1,true)then
table.insert(matches,_uuid)
table.insert(entries,Entry)
n=n+1
end
end
end
return matches,entries,n
end
function CLIENTMENUMANAGER:FindEntriesByText(Text,Parent)
self:T(self.lid.."FindEntriesByText "..Text or"None")
local matches,objects,number=self:FindUUIDsByText(Text,Parent)
return objects,number
end
function CLIENTMENUMANAGER:FindUUIDsByParent(Parent)
self:T(self.lid.."FindUUIDsByParent")
local matches={}
local entries={}
local n=0
for _uuid,_entry in pairs(self.flattree)do
local Entry=_entry
if Parent then
if Entry and string.find(Entry.UUID,Parent.UUID,1,true)then
table.insert(matches,_uuid)
table.insert(entries,Entry)
n=n+1
end
end
end
return matches,entries,n
end
function CLIENTMENUMANAGER:FindEntriesByParent(Parent)
self:T(self.lid.."FindEntriesByParent")
local matches,objects,number=self:FindUUIDsByParent(Parent)
return objects,number
end
function CLIENTMENUMANAGER:ChangeEntryText(Entry,Text,Client)
self:T(self.lid.."ChangeEntryText "..Text or"None")
local newentry=CLIENTMENU:NewEntry(nil,Text,Entry.Parent,Entry.Function,unpack(Entry.Functionargs))
self:DeleteF10Entry(Entry,Client)
self:DeleteGenericEntry(Entry)
if not Entry.Parent then
self.rootentries[self.entrycount]=newentry
end
local depth=#newentry.path
if not self.menutree[depth]then self.menutree[depth]={}end
table.insert(self.menutree[depth],newentry.UUID)
self.flattree[newentry.UUID]=newentry
self:AddEntry(newentry,Client)
return self
end
function CLIENTMENUMANAGER:Propagate(Client)
self:T(self.lid.."Propagate")
local knownunits={}
local Set=self.clientset.Set
if Client then
Set={Client}
end
self:ResetMenu(Client)
for _,_client in pairs(Set)do
local client=_client
if client and client:IsAlive()then
local playerunit=client:GetName()
local playername=client:GetPlayerName()or"none"
if not knownunits[playerunit]then
knownunits[playerunit]=true
else
self:I("Player in multi seat unit: "..playername)
break
end
if not self.playertree[playername]then
self.playertree[playername]={}
end
for level,branch in pairs(self.menutree)do
self:T("Building branch:"..level)
for _,leaf in pairs(branch)do
self:T("Building leaf:"..leaf)
local entry=self:FindEntryByUUID(leaf)
if entry then
self:T("Found generic entry:"..entry.UUID)
local parent=nil
if entry.Parent and entry.Parent.UUID then
parent=self.playertree[playername][entry.Parent.UUID]or self:FindEntryByUUID(entry.Parent.UUID)
end
self.playertree[playername][entry.UUID]=CLIENTMENU:NewEntry(client,entry.name,parent,entry.Function,unpack(entry.Functionargs))
self.playertree[playername][entry.UUID].Once=entry.Once
else
self:T("NO generic entry for:"..leaf)
end
end
end
end
end
return self
end
function CLIENTMENUMANAGER:AddEntry(Entry,Client)
self:T(self.lid.."AddEntry")
local Set=self.clientset.Set
local knownunits={}
if Client then
Set={Client}
end
for _,_client in pairs(Set)do
local client=_client
if client and client:IsAlive()then
local playername=client:GetPlayerName()or"None"
local unitname=client:GetName()
if not knownunits[unitname]then
knownunits[unitname]=true
else
self:I("Player in multi seat unit: "..playername)
break
end
if Entry then
self:T("Adding generic entry:"..Entry.UUID)
local parent=nil
if not self.playertree[playername]then
self.playertree[playername]={}
end
if Entry.Parent and Entry.Parent.UUID then
parent=self.playertree[playername][Entry.Parent.UUID]or self:FindEntryByUUID(Entry.Parent.UUID)
end
self.playertree[playername][Entry.UUID]=CLIENTMENU:NewEntry(client,Entry.name,parent,Entry.Function,unpack(Entry.Functionargs))
self.playertree[playername][Entry.UUID].Once=Entry.Once
else
self:T("NO generic entry given")
end
end
end
return self
end
function CLIENTMENUMANAGER:ResetMenu(Client)
self:T(self.lid.."ResetMenu")
for _,_entry in pairs(self.rootentries)do
if _entry then
self:DeleteF10Entry(_entry,Client)
end
end
return self
end
function CLIENTMENUMANAGER:ResetMenuComplete()
self:T(self.lid.."ResetMenuComplete")
for _,_entry in pairs(self.rootentries)do
if _entry then
self:DeleteF10Entry(_entry)
end
end
self.playertree=nil
self.playertree={}
self.rootentries=nil
self.rootentries={}
self.menutree=nil
self.menutree={}
return self
end
function CLIENTMENUMANAGER:DeleteF10Entry(Entry,Client)
self:T(self.lid.."DeleteF10Entry")
local Set=self.clientset.Set
if Client then
Set={Client}
end
for _,_client in pairs(Set)do
if _client and _client:IsAlive()then
local playername=_client:GetPlayerName()
if self.playertree[playername]then
local centry=self.playertree[playername][Entry.UUID]
if centry then
centry:Clear()
end
end
end
end
return self
end
function CLIENTMENUMANAGER:DeleteGenericEntry(Entry)
self:T(self.lid.."DeleteGenericEntry")
if Entry.Children and#Entry.Children>0 then
self:RemoveGenericSubEntries(Entry)
end
local depth=#Entry.path
local uuid=Entry.UUID
local tbl=UTILS.DeepCopy(self.menutree)
if tbl[depth]then
for i=depth,#tbl do
for _id,_uuid in pairs(tbl[i])do
self:T(_uuid)
if string.find(_uuid,uuid,1,true)or _uuid==uuid then
self.menutree[i][_id]=nil
self.flattree[_uuid]=nil
end
end
end
end
return self
end
function CLIENTMENUMANAGER:RemoveGenericSubEntries(Entry)
self:T(self.lid.."RemoveGenericSubEntries")
local depth=#Entry.path+1
local uuid=Entry.UUID
local tbl=UTILS.DeepCopy(self.menutree)
if tbl[depth]then
for i=depth,#tbl do
self:T("Level = "..i)
for _id,_uuid in pairs(tbl[i])do
self:T(_uuid)
if string.find(_uuid,uuid,1,true)then
self:T("Match for ".._uuid)
self.menutree[i][_id]=nil
self.flattree[_uuid]=nil
end
end
end
end
return self
end
function CLIENTMENUMANAGER:RemoveF10SubEntries(Entry,Client)
self:T(self.lid.."RemoveSubEntries")
local Set=self.clientset.Set
if Client then
Set={Client}
end
for _,_client in pairs(Set)do
if _client and _client:IsAlive()then
local playername=_client:GetPlayerName()
if self.playertree[playername]then
local centry=self.playertree[playername][Entry.UUID]
centry:RemoveSubEntries()
end
end
end
return self
end
OBJECT={
ClassName="OBJECT",
ObjectName="",
}
function OBJECT:New(ObjectName)
local self=BASE:Inherit(self,BASE:New())
self:F2(ObjectName)
self.ObjectName=ObjectName
return self
end
function OBJECT:GetID()
local DCSObject=self:GetDCSObject()
if DCSObject then
local ObjectID=DCSObject:getID()
return ObjectID
end
self:E({"Cannot GetID",Name=self.ObjectName,Class=self:GetClassName()})
return nil
end
function OBJECT:Destroy()
local DCSObject=self:GetDCSObject()
if DCSObject then
DCSObject:destroy(false)
return true
end
self:E({"Cannot Destroy",Name=self.ObjectName,Class=self:GetClassName()})
return nil
end
IDENTIFIABLE={
ClassName="IDENTIFIABLE",
IdentifiableName="",
}
local _CategoryName={
[Unit.Category.AIRPLANE]="Airplane",
[Unit.Category.HELICOPTER]="Helicopter",
[Unit.Category.GROUND_UNIT]="Ground Identifiable",
[Unit.Category.SHIP]="Ship",
[Unit.Category.STRUCTURE]="Structure",
}
function IDENTIFIABLE:New(IdentifiableName)
local self=BASE:Inherit(self,OBJECT:New(IdentifiableName))
self:F2(IdentifiableName)
self.IdentifiableName=IdentifiableName
return self
end
function IDENTIFIABLE:IsAlive()
self:F3(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableIsAlive=DCSIdentifiable:isExist()
return IdentifiableIsAlive
end
return false
end
function IDENTIFIABLE:GetName()
local IdentifiableName=self.IdentifiableName
return IdentifiableName
end
function IDENTIFIABLE:GetTypeName()
self:F2(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableTypeName=DCSIdentifiable:getTypeName()
self:T3(IdentifiableTypeName)
return IdentifiableTypeName
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:GetCategory()
self:F2(self.ObjectName)
local DCSObject=self:GetDCSObject()
if DCSObject then
local ObjectCategory,UnitCategory=DCSObject:getCategory()
self:T3(ObjectCategory)
return ObjectCategory,UnitCategory
end
return nil,nil
end
function IDENTIFIABLE:GetCategoryName()
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableCategoryName=_CategoryName[self:GetDesc().category]
return IdentifiableCategoryName
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:GetCoalition()
self:F2(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableCoalition=DCSIdentifiable:getCoalition()
self:T3(IdentifiableCoalition)
return IdentifiableCoalition
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:GetCoalitionName()
self:F2(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableCoalition=DCSIdentifiable:getCoalition()
self:T3(IdentifiableCoalition)
return UTILS.GetCoalitionName(IdentifiableCoalition)
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:GetCountry()
self:F2(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableCountry=DCSIdentifiable:getCountry()
self:T3(IdentifiableCountry)
return IdentifiableCountry
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:GetCountryName()
self:F2(self.IdentifiableName)
local countryid=self:GetCountry()
for name,id in pairs(country.id)do
if countryid==id then
return name
end
end
end
function IDENTIFIABLE:GetDesc()
self:F2(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableDesc=DCSIdentifiable:getDesc()
self:T2(IdentifiableDesc)
return IdentifiableDesc
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:HasAttribute(AttributeName)
self:F2(self.IdentifiableName)
local DCSIdentifiable=self:GetDCSObject()
if DCSIdentifiable then
local IdentifiableHasAttribute=DCSIdentifiable:hasAttribute(AttributeName)
self:T2(IdentifiableHasAttribute)
return IdentifiableHasAttribute
end
self:F(self.ClassName.." "..self.IdentifiableName.." not found!")
return nil
end
function IDENTIFIABLE:GetCallsign()
return''
end
function IDENTIFIABLE:GetThreatLevel()
return 0,"Scenery"
end
POSITIONABLE={
ClassName="POSITIONABLE",
PositionableName="",
coordinate=nil,
pointvec3=nil,
}
POSITIONABLE.__={}
POSITIONABLE.__.Cargo={}
function POSITIONABLE:New(PositionableName)
local self=BASE:Inherit(self,IDENTIFIABLE:New(PositionableName))
self.PositionableName=PositionableName
return self
end
function POSITIONABLE:Destroy(GenerateEvent)
self:F2(self.ObjectName)
local DCSObject=self:GetDCSObject()
if DCSObject then
local UnitGroup=self:GetGroup()
local UnitGroupName=UnitGroup:GetName()
self:F({UnitGroupName=UnitGroupName})
if GenerateEvent and GenerateEvent==true then
if self:IsAir()then
self:CreateEventCrash(timer.getTime(),DCSObject)
else
self:CreateEventDead(timer.getTime(),DCSObject)
end
elseif GenerateEvent==false then
else
self:CreateEventRemoveUnit(timer.getTime(),DCSObject)
end
USERFLAG:New(UnitGroupName):Set(100)
DCSObject:destroy()
end
return nil
end
function POSITIONABLE:GetDCSObject()
return nil
end
function POSITIONABLE:GetPosition()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if self:IsInstanceOf("GROUP")then
DCSPositionable=self:GetFirstUnitAlive():GetDCSObject()
end
if DCSPositionable then
local PositionablePosition=DCSPositionable:getPosition()
self:T3(PositionablePosition)
return PositionablePosition
end
BASE:E({"Cannot GetPosition",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetOrientation()
local position=self:GetPosition()
if position then
return position.x,position.y,position.z
else
BASE:E({"Cannot GetOrientation",Positionable=self,Alive=self:IsAlive()})
return nil,nil,nil
end
end
function POSITIONABLE:GetOrientationX()
local position=self:GetPosition()
if position then
return position.x
else
BASE:E({"Cannot GetOrientationX",Positionable=self,Alive=self:IsAlive()})
return nil
end
end
function POSITIONABLE:GetOrientationY()
local position=self:GetPosition()
if position then
return position.y
else
BASE:E({"Cannot GetOrientationY",Positionable=self,Alive=self:IsAlive()})
return nil
end
end
function POSITIONABLE:GetOrientationZ()
local position=self:GetPosition()
if position then
return position.z
else
BASE:E({"Cannot GetOrientationZ",Positionable=self,Alive=self:IsAlive()})
return nil
end
end
function POSITIONABLE:GetPositionVec3()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionablePosition=DCSPositionable:getPosition().p
self:T3(PositionablePosition)
return PositionablePosition
end
BASE:E({"Cannot GetPositionVec3",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetVec3()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local vec3=DCSPositionable:getPoint()
return vec3
end
self:E({"Cannot get the Positionable DCS Object for GetVec3",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetVec2()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local Vec3=DCSPositionable:getPoint()
return{x=Vec3.x,y=Vec3.z}
end
self:E({"Cannot GetVec2",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetPointVec2()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionableVec3=DCSPositionable:getPosition().p
local PositionablePointVec2=COORDINATE:NewFromVec3(PositionableVec3)
return PositionablePointVec2
end
self:E({"Cannot Coordinate",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetPointVec3()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionableVec3=self:GetPositionVec3()
if false and self.pointvec3 then
self.pointvec3.x=PositionableVec3.x
self.pointvec3.y=PositionableVec3.y
self.pointvec3.z=PositionableVec3.z
else
self.pointvec3=COORDINATE:NewFromVec3(PositionableVec3)
end
return self.pointvec3
end
BASE:E({"Cannot GetPointVec3",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetCoord()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionableVec3=self:GetVec3()
if self.coordinate then
self.coordinate:UpdateFromVec3(PositionableVec3)
else
self.coordinate=COORDINATE:NewFromVec3(PositionableVec3)
end
return self.coordinate
end
BASE:E({"Cannot GetCoordinate",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetCoordinate()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionableVec3=self:GetVec3()
local coord=COORDINATE:NewFromVec3(PositionableVec3)
local heading=self:GetHeading()
coord.Heading=heading
return coord
end
self:E({"Cannot GetCoordinate",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:Explode(power,delay)
power=power or 100
if delay and delay>0 then
self:ScheduleOnce(delay,POSITIONABLE.Explode,self,power,0)
else
local coord=self:GetCoord()
if coord then
coord:Explosion(power)
end
end
return self
end
function POSITIONABLE:GetOffsetCoordinate(x,y,z)
x=x or 0
y=y or 0
z=z or 0
local X=self:GetOrientationX()
local Y=self:GetOrientationY()
local Z=self:GetOrientationZ()
local A={x=x,y=y,z=z}
local x={x=X.x*A.x,y=X.y*A.x,z=X.z*A.x}
local y={x=Y.x*A.y,y=Y.y*A.y,z=Y.z*A.y}
local z={x=Z.x*A.z,y=Z.y*A.z,z=Z.z*A.z}
local a={x=x.x+y.x+z.x,y=x.y+y.y+z.y,z=x.z+y.z+z.z}
local u=self:GetVec3()
local v={x=a.x+u.x,y=a.y+u.y,z=a.z+u.z}
local coord=COORDINATE:NewFromVec3(v)
return coord
end
function POSITIONABLE:GetRelativeCoordinate(x,y,z)
x=x or 0
y=y or 0
z=z or 0
local selfPos=self:GetVec3()
local X=self:GetOrientationX()
local Y=self:GetOrientationY()
local Z=self:GetOrientationZ()
local off={
x=x-selfPos.x,
y=y-selfPos.y,
z=z-selfPos.z
}
local res={x=0,y=0,z=0}
local mat={
{X.x,Y.x,Z.x,off.x},
{X.y,Y.y,Z.y,off.y},
{X.z,Y.z,Z.z,off.z}
}
local m=3
local n=4
local h=1
local k=1
while h<=m and k<=n do
local v_max=math.abs(mat[h][k])
local i_max=h
for i=h,m,1 do
local value=math.abs(mat[i][k])
if value>v_max then
i_max=i
v_max=value
end
end
if mat[i_max][k]==0 then
k=k+1
else
local tmp=mat[h]
mat[h]=mat[i_max]
mat[i_max]=tmp
for i=h+1,m,1 do
local f=mat[i][k]/mat[h][k]
mat[i][k]=0
for j=k+1,n,1 do
mat[i][j]=mat[i][j]-f*mat[h][j]
end
end
h=h+1
k=k+1
end
end
res.z=mat[3][4]/mat[3][3]
res.y=(mat[2][4]-res.z*mat[2][3])/mat[2][2]
res.x=(mat[1][4]-res.y*mat[1][2]-res.z*mat[1][3])/mat[1][1]
local coord=COORDINATE:NewFromVec3(res)
return coord
end
function POSITIONABLE:GetRandomVec3(Radius)
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionablePointVec3=DCSPositionable:getPosition().p
if Radius then
local PositionableRandomVec3={}
local angle=math.random()*math.pi*2
PositionableRandomVec3.x=PositionablePointVec3.x+math.cos(angle)*math.random()*Radius
PositionableRandomVec3.y=PositionablePointVec3.y
PositionableRandomVec3.z=PositionablePointVec3.z+math.sin(angle)*math.random()*Radius
self:T3(PositionableRandomVec3)
return PositionableRandomVec3
else
self:F("Radius is nil, returning the PointVec3 of the POSITIONABLE",PositionablePointVec3)
return PositionablePointVec3
end
end
BASE:E({"Cannot GetRandomVec3",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetBoundingBox()
self:F2()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionableDesc=DCSPositionable:getDesc()
if PositionableDesc then
local PositionableBox=PositionableDesc.box
return PositionableBox
end
end
BASE:E({"Cannot GetBoundingBox",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetObjectSize()
local box=self:GetBoundingBox()
if box then
local x=box.max.x+math.abs(box.min.x)
local y=box.max.y+math.abs(box.min.y)
local z=box.max.z+math.abs(box.min.z)
return math.max(x,z),x,y,z
end
return 0,0,0,0
end
function POSITIONABLE:GetBoundingRadius(MinDist)
self:F2()
local Box=self:GetBoundingBox()
local boxmin=MinDist or 0
if Box then
local X=Box.max.x-Box.min.x
local Z=Box.max.z-Box.min.z
local CX=X/2
local CZ=Z/2
return math.max(math.max(CX,CZ),boxmin)
end
BASE:T({"Cannot GetBoundingRadius",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetAltitude()
self:F2()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionablePointVec3=DCSPositionable:getPoint()
return PositionablePointVec3.y
end
BASE:E({"Cannot GetAltitude",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:IsAboveRunway()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local Vec2=self:GetVec2()
local SurfaceType=land.getSurfaceType(Vec2)
local IsAboveRunway=SurfaceType==land.SurfaceType.RUNWAY
self:T2(IsAboveRunway)
return IsAboveRunway
end
BASE:E({"Cannot IsAboveRunway",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetSize()
local DCSObject=self:GetDCSObject()
if DCSObject then
return 1
else
return 0
end
end
function POSITIONABLE:GetHeading()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local PositionablePosition=DCSPositionable:getPosition()
if PositionablePosition then
local PositionableHeading=math.atan2(PositionablePosition.x.z,PositionablePosition.x.x)
if PositionableHeading<0 then
PositionableHeading=PositionableHeading+2*math.pi
end
PositionableHeading=PositionableHeading*180/math.pi
return PositionableHeading
end
end
self:E({"Cannot GetHeading",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:IsAir()
self:F2()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitDescriptor=DCSUnit:getDesc()
self:T3({UnitDescriptor.category,Unit.Category.AIRPLANE,Unit.Category.HELICOPTER})
local IsAirResult=(UnitDescriptor.category==Unit.Category.AIRPLANE)or(UnitDescriptor.category==Unit.Category.HELICOPTER)
self:T3(IsAirResult)
return IsAirResult
end
self:E({"Cannot check IsAir",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:IsGround()
self:F2()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitDescriptor=DCSUnit:getDesc()
self:T3({UnitDescriptor.category,Unit.Category.GROUND_UNIT})
local IsGroundResult=(UnitDescriptor.category==Unit.Category.GROUND_UNIT)
self:T3(IsGroundResult)
return IsGroundResult
end
self:E({"Cannot check IsGround",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:IsShip()
self:F2()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitDescriptor=DCSUnit:getDesc()
self:T3({UnitDescriptor.category,Unit.Category.SHIP})
local IsShipResult=(UnitDescriptor.category==Unit.Category.SHIP)
self:T3(IsShipResult)
return IsShipResult
end
self:E({"Cannot check IsShip",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:IsSubmarine()
self:F2()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitDescriptor=DCSUnit:getDesc()
if UnitDescriptor.attributes["Submarines"]==true then
return true
else
return false
end
end
self:E({"Cannot check IsSubmarine",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:InAir()
self:F2(self.PositionableName)
return nil
end
function POSITIONABLE:GetVelocity()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local Velocity=VELOCITY:New(self)
return Velocity
end
BASE:E({"Cannot GetVelocity",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetVelocityVec3()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable and DCSPositionable:isExist()then
local PositionableVelocityVec3=DCSPositionable:getVelocity()
self:T3(PositionableVelocityVec3)
return PositionableVelocityVec3
end
BASE:E({"Cannot GetVelocityVec3",Positionable=self,Alive=self:IsAlive()})
return nil
end
function POSITIONABLE:GetRelativeVelocity(Positionable)
self:F2(self.PositionableName)
local v1=self:GetVelocityVec3()
local v2=Positionable:GetVelocityVec3()
local vtot=UTILS.VecAdd(v1,v2)
return UTILS.VecNorm(vtot)
end
function POSITIONABLE:GetHeight()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable and DCSPositionable:isExist()then
local PositionablePosition=DCSPositionable:getPosition()
if PositionablePosition then
local PositionableHeight=PositionablePosition.p.y
self:T2(PositionableHeight)
return PositionableHeight
end
end
return nil
end
function POSITIONABLE:GetVelocityKMH()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable and DCSPositionable:isExist()then
local VelocityVec3=self:GetVelocityVec3()
local Velocity=(VelocityVec3.x^2+VelocityVec3.y^2+VelocityVec3.z^2)^0.5
local Velocity=Velocity*3.6
self:T3(Velocity)
return Velocity
end
return 0
end
function POSITIONABLE:GetVelocityMPS()
self:F2(self.PositionableName)
local DCSPositionable=self:GetDCSObject()
if DCSPositionable and DCSPositionable:isExist()then
local VelocityVec3=self:GetVelocityVec3()
local Velocity=(VelocityVec3.x^2+VelocityVec3.y^2+VelocityVec3.z^2)^0.5
self:T3(Velocity)
return Velocity
end
return 0
end
function POSITIONABLE:GetVelocityKNOTS()
self:F2(self.PositionableName)
return UTILS.MpsToKnots(self:GetVelocityMPS())
end
function POSITIONABLE:GetAirspeedTrue()
local tas=0
local coord=self:GetCoord()
if coord then
local alt=coord.y
local wvec3=coord:GetWindVec3(alt,false)
local vvec3=self:GetVelocityVec3()
local tasvec3=UTILS.VecSubstract(vvec3,wvec3)
tas=UTILS.VecNorm(tasvec3)
end
return tas
end
function POSITIONABLE:GetAirspeedIndicated(oatcorr)
local tas=self:GetAirspeedTrue()
local altitude=self:GetAltitude()
local ias=UTILS.TasToIas(tas,altitude,oatcorr)
return ias
end
function POSITIONABLE:GetGroundSpeed()
local gs=0
local vel=self:GetVelocityVec3()
if vel then
local vec2={x=vel.x,y=vel.z}
gs=UTILS.Vec2Norm(vel)
end
return gs
end
function POSITIONABLE:GetAoA()
local unitpos=self:GetPosition()
if unitpos then
local unitvel=self:GetVelocityVec3()
if unitvel and UTILS.VecNorm(unitvel)~=0 then
local wind=self:GetCoordinate():GetWindWithTurbulenceVec3()
unitvel.x=unitvel.x-wind.x
unitvel.y=unitvel.y-wind.y
unitvel.z=unitvel.z-wind.z
local AxialVel={}
AxialVel.x=UTILS.VecDot(unitpos.x,unitvel)
AxialVel.y=UTILS.VecDot(unitpos.y,unitvel)
AxialVel.z=UTILS.VecDot(unitpos.z,unitvel)
local AoA=math.acos(UTILS.VecDot({x=1,y=0,z=0},{x=AxialVel.x,y=AxialVel.y,z=0})/UTILS.VecNorm({x=AxialVel.x,y=AxialVel.y,z=0}))
if AxialVel.y>0 then
AoA=-AoA
end
return math.deg(AoA)
end
end
return nil
end
function POSITIONABLE:GetClimbAngle()
local unitpos=self:GetPosition()
if unitpos then
local unitvel=self:GetVelocityVec3()
if unitvel and UTILS.VecNorm(unitvel)~=0 then
local angle=math.asin(unitvel.y/UTILS.VecNorm(unitvel))
return math.deg(angle)
else
return 0
end
end
return nil
end
function POSITIONABLE:GetPitch()
local unitpos=self:GetPosition()
if unitpos then
return math.deg(math.asin(unitpos.x.y))
end
return nil
end
function POSITIONABLE:GetRoll()
local unitpos=self:GetPosition()
if unitpos then
local cp=UTILS.VecCross(unitpos.x,{x=0,y=1,z=0})
local dp=UTILS.VecDot(cp,unitpos.z)
local Roll=math.acos(dp/(UTILS.VecNorm(cp)*UTILS.VecNorm(unitpos.z)))
if unitpos.z.y>0 then
Roll=-Roll
end
return math.deg(Roll)
end
return nil
end
function POSITIONABLE:GetYaw()
local unitpos=self:GetPosition()
if unitpos then
local unitvel=self:GetVelocityVec3()
if unitvel and UTILS.VecNorm(unitvel)~=0 then
local AxialVel={}
AxialVel.x=UTILS.VecDot(unitpos.x,unitvel)
AxialVel.y=UTILS.VecDot(unitpos.y,unitvel)
AxialVel.z=UTILS.VecDot(unitpos.z,unitvel)
local Yaw=math.acos(UTILS.VecDot({x=1,y=0,z=0},{x=AxialVel.x,y=0,z=AxialVel.z})/UTILS.VecNorm({x=AxialVel.x,y=0,z=AxialVel.z}))
if AxialVel.z>0 then
Yaw=-Yaw
end
return Yaw
end
end
return nil
end
function POSITIONABLE:GetMessageText(Message,Name)
local DCSObject=self:GetDCSObject()
if DCSObject then
local Callsign=string.format("%s",((Name~=""and Name)or self:GetCallsign()~=""and self:GetCallsign())or self:GetName())
local MessageText=string.format("%s - %s",Callsign,Message)
return MessageText
end
return nil
end
function POSITIONABLE:GetMessage(Message,Duration,Name)
local DCSObject=self:GetDCSObject()
if DCSObject then
local MessageText=self:GetMessageText(Message,Name)
return MESSAGE:New(MessageText,Duration)
end
return nil
end
function POSITIONABLE:GetMessageType(Message,MessageType,Name)
local DCSObject=self:GetDCSObject()
if DCSObject then
local MessageText=self:GetMessageText(Message,Name)
return MESSAGE:NewType(MessageText,MessageType)
end
return nil
end
function POSITIONABLE:MessageToAll(Message,Duration,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessage(Message,Duration,Name):ToAll()
end
return nil
end
function POSITIONABLE:MessageToCoalition(Message,Duration,MessageCoalition,Name)
self:F2({Message,Duration})
local Name=Name or""
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessage(Message,Duration,Name):ToCoalition(MessageCoalition)
end
return nil
end
function POSITIONABLE:MessageTypeToCoalition(Message,MessageType,MessageCoalition,Name)
self:F2({Message,MessageType})
local Name=Name or""
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessageType(Message,MessageType,Name):ToCoalition(MessageCoalition)
end
return nil
end
function POSITIONABLE:MessageToRed(Message,Duration,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessage(Message,Duration,Name):ToRed()
end
return nil
end
function POSITIONABLE:MessageToBlue(Message,Duration,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessage(Message,Duration,Name):ToBlue()
end
return nil
end
function POSITIONABLE:MessageToClient(Message,Duration,Client,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessage(Message,Duration,Name):ToClient(Client)
end
return nil
end
function POSITIONABLE:MessageToUnit(Message,Duration,MessageUnit,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
if MessageUnit:IsAlive()then
self:GetMessage(Message,Duration,Name):ToUnit(MessageUnit)
else
BASE:E({"Message not sent to Unit; Unit is not alive...",Message=Message,MessageUnit=MessageUnit})
end
else
BASE:E({"Message not sent to Unit; Positionable is not alive ...",Message=Message,Positionable=self,MessageUnit=MessageUnit})
end
end
end
function POSITIONABLE:MessageToGroup(Message,Duration,MessageGroup,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
if MessageGroup:IsAlive()then
self:GetMessage(Message,Duration,Name):ToGroup(MessageGroup)
else
BASE:E({"Message not sent to Group; Group is not alive...",Message=Message,MessageGroup=MessageGroup})
end
else
BASE:E({
"Message not sent to Group; Positionable is not alive ...",
Message=Message,
Positionable=self,
MessageGroup=MessageGroup
})
end
end
return nil
end
function POSITIONABLE:MessageToUnit(Message,Duration,MessageUnit,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
if MessageUnit:IsAlive()then
self:GetMessage(Message,Duration,Name):ToUnit(MessageUnit)
else
BASE:E({"Message not sent to Unit; Unit is not alive...",Message=Message,MessageUnit=MessageUnit})
end
else
BASE:E({"Message not sent to Unit; Positionable is not alive ...",Message=Message,Positionable=self,MessageUnit=MessageUnit})
end
end
return nil
end
function POSITIONABLE:MessageTypeToGroup(Message,MessageType,MessageGroup,Name)
self:F2({Message,MessageType})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
self:GetMessageType(Message,MessageType,Name):ToGroup(MessageGroup)
end
end
return nil
end
function POSITIONABLE:MessageToSetGroup(Message,Duration,MessageSetGroup,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
MessageSetGroup:ForEachGroupAlive(function(MessageGroup)
self:GetMessage(Message,Duration,Name):ToGroup(MessageGroup)
end)
end
end
return nil
end
function POSITIONABLE:MessageToSetUnit(Message,Duration,MessageSetUnit,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
MessageSetUnit:ForEachUnit(
function(MessageGroup)
self:GetMessage(Message,Duration,Name):ToUnit(MessageGroup)
end
)
end
end
return nil
end
function POSITIONABLE:MessageToSetUnit(Message,Duration,MessageSetUnit,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:isExist()then
MessageSetUnit:ForEachUnit(
function(MessageGroup)
self:GetMessage(Message,Duration,Name):ToUnit(MessageGroup)
end
)
end
end
return nil
end
function POSITIONABLE:Message(Message,Duration,Name)
self:F2({Message,Duration})
local DCSObject=self:GetDCSObject()
if DCSObject then
self:GetMessage(Message,Duration,Name):ToGroup(self)
end
return nil
end
function POSITIONABLE:GetRadio()
self:F2(self)
return RADIO:New(self)
end
function POSITIONABLE:GetBeacon()
self:F2(self)
return BEACON:New(self)
end
function POSITIONABLE:LaseUnit(Target,LaserCode,Duration)
self:F2()
LaserCode=LaserCode or math.random(1000,9999)
local RecceDcsUnit=self:GetDCSObject()
local TargetVec3=Target:GetVec3()
self:F("building spot")
self.Spot=SPOT:New(self)
self.Spot:LaseOn(Target,LaserCode,Duration)
self.LaserCode=LaserCode
return self.Spot
end
function POSITIONABLE:LaseCoordinate(Coordinate,LaserCode,Duration)
self:F2()
LaserCode=LaserCode or math.random(1000,9999)
self.Spot=SPOT:New(self)
self.Spot:LaseOnCoordinate(Coordinate,LaserCode,Duration)
self.LaserCode=LaserCode
return self.Spot
end
function POSITIONABLE:LaseOff()
self:F2()
if self.Spot then
self.Spot:LaseOff()
self.Spot=nil
end
return self
end
function POSITIONABLE:IsLasing()
self:F2()
local Lasing=false
if self.Spot then
Lasing=self.Spot:IsLasing()
end
return Lasing
end
function POSITIONABLE:GetSpot()
return self.Spot
end
function POSITIONABLE:GetLaserCode()
return self.LaserCode
end
do
function POSITIONABLE:AddCargo(Cargo)
self.__.Cargo[Cargo]=Cargo
return self
end
function POSITIONABLE:GetCargo()
return self.__.Cargo
end
function POSITIONABLE:RemoveCargo(Cargo)
self.__.Cargo[Cargo]=nil
return self
end
function POSITIONABLE:HasCargo(Cargo)
return self.__.Cargo[Cargo]
end
function POSITIONABLE:ClearCargo()
self.__.Cargo={}
end
function POSITIONABLE:IsCargoEmpty()
local IsEmpty=true
for _,Cargo in pairs(self.__.Cargo)do
IsEmpty=false
break
end
return IsEmpty
end
function POSITIONABLE:CargoItemCount()
local ItemCount=0
for CargoName,Cargo in pairs(self.__.Cargo)do
ItemCount=ItemCount+Cargo:GetCount()
end
return ItemCount
end
function POSITIONABLE:GetTroopCapacity()
local DCSunit=self:GetDCSObject()
local capacity=DCSunit:getDescentCapacity()
return capacity
end
function POSITIONABLE:GetCargoBayFreeWeight()
if not self.__.CargoBayWeightLimit then
self:SetCargoBayWeightLimit()
end
local CargoWeight=0
for CargoName,Cargo in pairs(self.__.Cargo)do
CargoWeight=CargoWeight+Cargo:GetWeight()
end
return self.__.CargoBayWeightLimit-CargoWeight
end
POSITIONABLE.DefaultInfantryWeight=95
POSITIONABLE.CargoBayCapacityValues={
["Air"]={
["C_130"]=70000,
},
["Naval"]={
["Type_071"]=245000,
["LHA_Tarawa"]=500000,
["Ropucha_class"]=150000,
["Dry_cargo_ship_1"]=70000,
["Dry_cargo_ship_2"]=70000,
["Higgins_boat"]=3700,
["USS_Samuel_Chase"]=25000,
["LST_Mk2"]=2100000,
["speedboat"]=500,
["Seawise_Giant"]=261000000,
},
["Ground"]={
["AAV7"]=25*POSITIONABLE.DefaultInfantryWeight,
["Bedford_MWD"]=8*POSITIONABLE.DefaultInfantryWeight,
["Blitz_36_6700A"]=10*POSITIONABLE.DefaultInfantryWeight,
["BMD_1"]=9*POSITIONABLE.DefaultInfantryWeight,
["BMP_1"]=8*POSITIONABLE.DefaultInfantryWeight,
["BMP_2"]=7*POSITIONABLE.DefaultInfantryWeight,
["BMP_3"]=8*POSITIONABLE.DefaultInfantryWeight,
["Boman"]=25*POSITIONABLE.DefaultInfantryWeight,
["BTR_80"]=9*POSITIONABLE.DefaultInfantryWeight,
["BTR_82A"]=9*POSITIONABLE.DefaultInfantryWeight,
["BTR_D"]=12*POSITIONABLE.DefaultInfantryWeight,
["Cobra"]=8*POSITIONABLE.DefaultInfantryWeight,
["Land_Rover_101_FC"]=11*POSITIONABLE.DefaultInfantryWeight,
["Land_Rover_109_S3"]=7*POSITIONABLE.DefaultInfantryWeight,
["LAV_25"]=6*POSITIONABLE.DefaultInfantryWeight,
["M_2_Bradley"]=6*POSITIONABLE.DefaultInfantryWeight,
["M1043_HMMWV_Armament"]=4*POSITIONABLE.DefaultInfantryWeight,
["M1045_HMMWV_TOW"]=4*POSITIONABLE.DefaultInfantryWeight,
["M1126_Stryker_ICV"]=9*POSITIONABLE.DefaultInfantryWeight,
["M1134_Stryker_ATGM"]=9*POSITIONABLE.DefaultInfantryWeight,
["M2A1_halftrack"]=9*POSITIONABLE.DefaultInfantryWeight,
["M_113"]=9*POSITIONABLE.DefaultInfantryWeight,
["Marder"]=6*POSITIONABLE.DefaultInfantryWeight,
["MCV_80"]=9*POSITIONABLE.DefaultInfantryWeight,
["MLRS_FDDM"]=4*POSITIONABLE.DefaultInfantryWeight,
["MTLB"]=25*POSITIONABLE.DefaultInfantryWeight,
["GAZ_66"]=8*POSITIONABLE.DefaultInfantryWeight,
["GAZ_3307"]=12*POSITIONABLE.DefaultInfantryWeight,
["GAZ_3308"]=14*POSITIONABLE.DefaultInfantryWeight,
["Grad_FDDM"]=6*POSITIONABLE.DefaultInfantryWeight,
["KAMAZ_Truck"]=12*POSITIONABLE.DefaultInfantryWeight,
["KrAZ6322"]=12*POSITIONABLE.DefaultInfantryWeight,
["M_818"]=12*POSITIONABLE.DefaultInfantryWeight,
["Tigr_233036"]=6*POSITIONABLE.DefaultInfantryWeight,
["TPZ"]=10*POSITIONABLE.DefaultInfantryWeight,
["UAZ_469"]=4*POSITIONABLE.DefaultInfantryWeight,
["Ural_375"]=12*POSITIONABLE.DefaultInfantryWeight,
["Ural_4320_31"]=14*POSITIONABLE.DefaultInfantryWeight,
["Ural_4320_APA_5D"]=10*POSITIONABLE.DefaultInfantryWeight,
["Ural_4320T"]=14*POSITIONABLE.DefaultInfantryWeight,
["ZBD04A"]=7*POSITIONABLE.DefaultInfantryWeight,
["VAB_Mephisto"]=8*POSITIONABLE.DefaultInfantryWeight,
["tt_KORD"]=6*POSITIONABLE.DefaultInfantryWeight,
["tt_DSHK"]=6*POSITIONABLE.DefaultInfantryWeight,
["HL_KORD"]=6*POSITIONABLE.DefaultInfantryWeight,
["HL_DSHK"]=6*POSITIONABLE.DefaultInfantryWeight,
["CCKW_353"]=16*POSITIONABLE.DefaultInfantryWeight,
["MaxxPro_MRAP"]=7*POSITIONABLE.DefaultInfantryWeight,
}
}
function POSITIONABLE:SetCargoBayWeightLimit(WeightLimit)
if WeightLimit then
self.__.CargoBayWeightLimit=WeightLimit
elseif self.__.CargoBayWeightLimit~=nil then
else
local Desc=self:GetDesc()
self:F({Desc=Desc})
local TypeName=Desc.typeName or"Unknown Type"
TypeName=string.gsub(TypeName,"[%p%s]","_")
if self:IsAir()then
local Weights=POSITIONABLE.CargoBayCapacityValues.Air
local massMax=Desc.massMax or 0
local maxTakeoff=Weights[TypeName]
if maxTakeoff then
massMax=maxTakeoff
end
local massEmpty=Desc.massEmpty or 0
local massFuelMax=Desc.fuelMassMax or 0
local relFuel=math.min(self:GetFuel()or 1.0,1.0)
local massFuel=massFuelMax*relFuel
local CargoWeight=massMax-(massEmpty+massFuel)
self:T(string.format("Setting Cargo bay weight limit [%s]=%d kg (Mass max=%d, empty=%d, fuelMax=%d kg (rel=%.3f), fuel=%d kg",TypeName,CargoWeight,massMax,massEmpty,massFuelMax,relFuel,massFuel))
self.__.CargoBayWeightLimit=CargoWeight
elseif self:IsShip()then
local Weights=POSITIONABLE.CargoBayCapacityValues.Naval
self.__.CargoBayWeightLimit=(Weights[TypeName]or 50000)
else
local Weights=POSITIONABLE.CargoBayCapacityValues.Ground
local CargoBayWeightLimit=(Weights[TypeName]or 0)
self.__.CargoBayWeightLimit=CargoBayWeightLimit
end
end
self:F({CargoBayWeightLimit=self.__.CargoBayWeightLimit})
end
function POSITIONABLE:GetCargoBayWeightLimit()
if self.__.CargoBayWeightLimit==nil then
self:SetCargoBayWeightLimit()
end
return self.__.CargoBayWeightLimit
end
end
function POSITIONABLE:Flare(FlareColor)
self:F2()
trigger.action.signalFlare(self:GetVec3(),FlareColor,0)
end
function POSITIONABLE:FlareWhite()
self:F2()
trigger.action.signalFlare(self:GetVec3(),trigger.flareColor.White,0)
end
function POSITIONABLE:FlareYellow()
self:F2()
trigger.action.signalFlare(self:GetVec3(),trigger.flareColor.Yellow,0)
end
function POSITIONABLE:FlareGreen()
self:F2()
trigger.action.signalFlare(self:GetVec3(),trigger.flareColor.Green,0)
end
function POSITIONABLE:FlareRed()
self:F2()
local Vec3=self:GetVec3()
if Vec3 then
trigger.action.signalFlare(Vec3,trigger.flareColor.Red,0)
end
end
function POSITIONABLE:Smoke(SmokeColor,Range,AddHeight)
self:F2()
if Range then
local Vec3=self:GetRandomVec3(Range)
Vec3.y=Vec3.y+AddHeight or 0
trigger.action.smoke(Vec3,SmokeColor)
else
local Vec3=self:GetVec3()
Vec3.y=Vec3.y+AddHeight or 0
trigger.action.smoke(self:GetVec3(),SmokeColor)
end
end
function POSITIONABLE:SmokeGreen()
self:F2()
trigger.action.smoke(self:GetVec3(),trigger.smokeColor.Green)
end
function POSITIONABLE:SmokeRed()
self:F2()
trigger.action.smoke(self:GetVec3(),trigger.smokeColor.Red)
end
function POSITIONABLE:SmokeWhite()
self:F2()
trigger.action.smoke(self:GetVec3(),trigger.smokeColor.White)
end
function POSITIONABLE:SmokeOrange()
self:F2()
trigger.action.smoke(self:GetVec3(),trigger.smokeColor.Orange)
end
function POSITIONABLE:SmokeBlue()
self:F2()
trigger.action.smoke(self:GetVec3(),trigger.smokeColor.Blue)
end
function POSITIONABLE:IsInZone(Zone)
self:F2({self.PositionableName,Zone})
if self:IsAlive()then
local IsInZone=Zone:IsVec3InZone(self:GetVec3())
return IsInZone
end
return false
end
function POSITIONABLE:IsNotInZone(Zone)
self:F2({self.PositionableName,Zone})
if self:IsAlive()then
local IsNotInZone=not Zone:IsVec3InZone(self:GetVec3())
return IsNotInZone
else
return false
end
end
CONTROLLABLE={
ClassName="CONTROLLABLE",
ControllableName="",
WayPointFunctions={},
}
function CONTROLLABLE:New(ControllableName)
local self=BASE:Inherit(self,POSITIONABLE:New(ControllableName))
self.ControllableName=ControllableName
self.TaskScheduler=SCHEDULER:New(self)
return self
end
function CONTROLLABLE:_GetController()
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local ControllableController=DCSControllable:getController()
return ControllableController
end
return nil
end
function CONTROLLABLE:GetLife()
self:F2(self.ControllableName)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local UnitLife=0
local Units=self:GetUnits()
if#Units==1 then
local Unit=Units[1]
UnitLife=Unit:GetLife()
else
local UnitLifeTotal=0
for UnitID,Unit in pairs(Units)do
local Unit=Unit
UnitLifeTotal=UnitLifeTotal+Unit:GetLife()
end
UnitLife=UnitLifeTotal/#Units
end
return UnitLife
end
return nil
end
function CONTROLLABLE:GetLife0()
self:F2(self.ControllableName)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local UnitLife=0
local Units=self:GetUnits()
if#Units==1 then
local Unit=Units[1]
UnitLife=Unit:GetLife0()
else
local UnitLifeTotal=0
for UnitID,Unit in pairs(Units)do
local Unit=Unit
UnitLifeTotal=UnitLifeTotal+Unit:GetLife0()
end
UnitLife=UnitLifeTotal/#Units
end
return UnitLife
end
return nil
end
function CONTROLLABLE:GetFuelMin()
self:F(self.ControllableName)
return nil
end
function CONTROLLABLE:GetFuelAve()
self:F(self.ControllableName)
return nil
end
function CONTROLLABLE:GetFuel()
self:F(self.ControllableName)
return nil
end
function CONTROLLABLE:ClearTasks()
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
Controller:resetTask()
return self
end
return nil
end
function CONTROLLABLE:PopCurrentTask()
self:F2()
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
Controller:popTask()
return self
end
return nil
end
function CONTROLLABLE:PushTask(DCSTask,WaitTime)
self:F2()
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local DCSControllableName=self:GetName()
local function PushTask(Controller,DCSTask)
if self and self:IsAlive()then
local Controller=self:_GetController()
Controller:pushTask(DCSTask)
else
BASE:E({DCSControllableName.." is not alive anymore.",DCSTask=DCSTask})
end
end
if not WaitTime or WaitTime==0 then
PushTask(self,DCSTask)
else
self.TaskScheduler:Schedule(self,PushTask,{DCSTask},WaitTime)
end
return self
end
return nil
end
function CONTROLLABLE:SetTask(DCSTask,WaitTime)
self:F({"SetTask",WaitTime,DCSTask=DCSTask})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local DCSControllableName=self:GetName()
self:T2("Controllable Name = "..DCSControllableName)
local function SetTask(Controller,DCSTask)
if self and self:IsAlive()then
local Controller=self:_GetController()
Controller:setTask(DCSTask)
self:T({ControllableName=self:GetName(),DCSTask=DCSTask})
else
BASE:E({DCSControllableName.." is not alive anymore.",DCSTask=DCSTask})
end
end
if not WaitTime or WaitTime==0 then
SetTask(self,DCSTask)
self:T({ControllableName=self:GetName(),DCSTask=DCSTask})
else
self.TaskScheduler:Schedule(self,SetTask,{DCSTask},WaitTime)
end
return self
end
return nil
end
function CONTROLLABLE:HasTask()
local HasTaskResult=false
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
HasTaskResult=Controller:hasTask()
end
return HasTaskResult
end
function CONTROLLABLE:TaskCondition(time,userFlag,userFlagValue,condition,duration,lastWayPoint)
local DCSStopCondition={}
DCSStopCondition.time=time
DCSStopCondition.userFlag=userFlag
DCSStopCondition.userFlagValue=userFlagValue
DCSStopCondition.condition=condition
DCSStopCondition.duration=duration
DCSStopCondition.lastWayPoint=lastWayPoint
return DCSStopCondition
end
function CONTROLLABLE:TaskControlled(DCSTask,DCSStopCondition)
local DCSTaskControlled={
id='ControlledTask',
params={
task=DCSTask,
stopCondition=DCSStopCondition,
},
}
return DCSTaskControlled
end
function CONTROLLABLE:TaskCombo(DCSTasks)
local DCSTaskCombo={
id='ComboTask',
params={
tasks=DCSTasks,
},
}
return DCSTaskCombo
end
function CONTROLLABLE:TaskWrappedAction(DCSCommand,Index)
local DCSTaskWrappedAction={
id="WrappedAction",
enabled=true,
number=Index or 1,
auto=false,
params={
action=DCSCommand,
},
}
return DCSTaskWrappedAction
end
function CONTROLLABLE:TaskEmptyTask()
local DCSTaskWrappedAction={
["id"]="WrappedAction",
["params"]={
["action"]={
["id"]="Script",
["params"]={
["command"]="",
},
},
},
}
return DCSTaskWrappedAction
end
function CONTROLLABLE:SetTaskWaypoint(Waypoint,Task)
Waypoint.task=self:TaskCombo({Task})
self:F({Waypoint.task})
return Waypoint.task
end
function CONTROLLABLE:SetCommand(DCSCommand)
self:F2(DCSCommand)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
Controller:setCommand(DCSCommand)
return self
end
return nil
end
function CONTROLLABLE:CommandSwitchWayPoint(FromWayPoint,ToWayPoint)
self:F2({FromWayPoint,ToWayPoint})
local CommandSwitchWayPoint={
id='SwitchWaypoint',
params={
fromWaypointIndex=FromWayPoint,
goToWaypointIndex=ToWayPoint,
},
}
self:T3({CommandSwitchWayPoint})
return CommandSwitchWayPoint
end
function CONTROLLABLE:CommandStopRoute(StopRoute)
self:F2({StopRoute})
local CommandStopRoute={
id='StopRoute',
params={
value=StopRoute,
},
}
self:T3({CommandStopRoute})
return CommandStopRoute
end
function CONTROLLABLE:StartUncontrolled(delay)
if delay and delay>0 then
SCHEDULER:New(nil,CONTROLLABLE.StartUncontrolled,{self},delay)
else
self:SetCommand({id='Start',params={}})
end
return self
end
function CONTROLLABLE:CommandActivateBeacon(Type,System,Frequency,UnitID,Channel,ModeChannel,AA,Callsign,Bearing,Delay)
AA=AA or self:IsAir()
UnitID=UnitID or self:GetID()
local CommandActivateBeacon={
id="ActivateBeacon",
params={
["type"]=Type,
["system"]=System,
["frequency"]=Frequency,
["unitId"]=UnitID,
["channel"]=Channel,
["modeChannel"]=ModeChannel,
["AA"]=AA,
["callsign"]=Callsign,
["bearing"]=Bearing,
},
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandActivateBeacon,{self,Type,System,Frequency,UnitID,Channel,ModeChannel,AA,Callsign,Bearing},Delay)
else
self:SetCommand(CommandActivateBeacon)
end
return self
end
function CONTROLLABLE:CommandActivateACLS(UnitID,Name,Delay)
local CommandActivateACLS={
id='ActivateACLS',
params={
unitId=UnitID or self:GetID(),
name=Name or"ACL",
}
}
self:T({CommandActivateACLS})
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandActivateACLS,{self,UnitID,Name},Delay)
else
local controller=self:_GetController()
controller:setCommand(CommandActivateACLS)
end
return self
end
function CONTROLLABLE:CommandDeactivateACLS(Delay)
local CommandDeactivateACLS={
id='DeactivateACLS',
params={}
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandDeactivateACLS,{self},Delay)
else
local controller=self:_GetController()
controller:setCommand(CommandDeactivateACLS)
end
return self
end
function CONTROLLABLE:CommandActivateICLS(Channel,UnitID,Callsign,Delay)
local CommandActivateICLS={
id="ActivateICLS",
params={
["type"]=BEACON.Type.ICLS,
["channel"]=Channel,
["unitId"]=UnitID or self:GetID(),
["callsign"]=Callsign,
},
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandActivateICLS,{self,Channel,UnitID,Callsign},Delay)
else
self:SetCommand(CommandActivateICLS)
end
return self
end
function CONTROLLABLE:CommandActivateLink4(Frequency,UnitID,Callsign,Delay)
local freq=Frequency or 336
local CommandActivateLink4={
id="ActivateLink4",
params={
["frequency"]=freq*1000000,
["unitId"]=UnitID or self:GetID(),
["name"]=Callsign or"LNK",
}
}
self:T({CommandActivateLink4})
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandActivateLink4,{self,Frequency,UnitID,Callsign},Delay)
else
local controller=self:_GetController()
controller:setCommand(CommandActivateLink4)
end
return self
end
function CONTROLLABLE:CommandDeactivateBeacon(Delay)
local CommandDeactivateBeacon={id='DeactivateBeacon',params={}}
local CommandDeactivateBeacon={id='DeactivateBeacon',params={}}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandDeactivateBeacon,{self},Delay)
else
self:SetCommand(CommandDeactivateBeacon)
end
return self
end
function CONTROLLABLE:CommandDeactivateLink4(Delay)
local CommandDeactivateLink4={id='DeactivateLink4',params={}}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandDeactivateLink4,{self},Delay)
else
local controller=self:_GetController()
controller:setCommand(CommandDeactivateLink4)
end
return self
end
function CONTROLLABLE:CommandDeactivateICLS(Delay)
local CommandDeactivateICLS={id='DeactivateICLS',params={}}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandDeactivateICLS,{self},Delay)
else
self:SetCommand(CommandDeactivateICLS)
end
return self
end
function CONTROLLABLE:CommandSetCallsign(CallName,CallNumber,Delay)
local CommandSetCallsign={id='SetCallsign',params={callname=CallName,number=CallNumber or 1}}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSetCallsign,{self,CallName,CallNumber},Delay)
else
self:SetCommand(CommandSetCallsign)
end
return self
end
function CONTROLLABLE:CommandEPLRS(SwitchOnOff,Delay)
if SwitchOnOff==nil then
SwitchOnOff=true
end
local CommandEPLRS={
id='EPLRS',
params={
value=SwitchOnOff,
groupId=self:GetID(),
},
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandEPLRS,{self,SwitchOnOff},Delay)
else
self:T(string.format("EPLRS=%s for controllable %s (id=%s)",tostring(SwitchOnOff),tostring(self:GetName()),tostring(self:GetID())))
self:SetCommand(CommandEPLRS)
end
return self
end
function CONTROLLABLE:CommandSetUnlimitedFuel(OnOff,Delay)
local CommandSetFuel={
id='SetUnlimitedFuel',
params={
value=OnOff
}
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSetUnlimitedFuel,{self,OnOff},Delay)
else
self:SetCommand(CommandSetFuel)
end
return self
end
function CONTROLLABLE:CommandSetFrequency(Frequency,Modulation,Power,Delay)
local CommandSetFrequency={
id='SetFrequency',
params={
frequency=Frequency*1000000,
modulation=Modulation or radio.modulation.AM,
power=Power or 10,
},
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSetFrequency,{self,Frequency,Modulation,Power},Delay)
else
self:SetCommand(CommandSetFrequency)
end
return self
end
function CONTROLLABLE:CommandSetFrequencyForUnit(Frequency,Modulation,Power,UnitID,Delay)
local CommandSetFrequencyForUnit={
id='SetFrequencyForUnit',
params={
frequency=Frequency*1000000,
modulation=Modulation or radio.modulation.AM,
unitId=UnitID or self:GetID(),
power=Power or 10,
},
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSetFrequencyForUnit,{self,Frequency,Modulation,Power,UnitID},Delay)
else
self:SetCommand(CommandSetFrequencyForUnit)
end
return self
end
function CONTROLLABLE:CommandSmokeOnOff(OnOff,Delay)
local switch=(OnOff==nil)and true or OnOff
local command={
id='SMOKE_ON_OFF',
params={
value=switch
}
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSmokeOnOff,{self,switch},Delay)
else
self:SetCommand(command)
end
return self
end
function CONTROLLABLE:CommandSmokeON(Delay)
local command={
id='SMOKE_ON_OFF',
params={
value=true
}
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSmokeON,{self},Delay)
else
self:SetCommand(command)
end
return self
end
function CONTROLLABLE:CommandSmokeOFF(Delay)
local command={
id='SMOKE_ON_OFF',
params={
value=false
}
}
if Delay and Delay>0 then
SCHEDULER:New(nil,self.CommandSmokeOFF,{self},Delay)
else
self:SetCommand(command)
end
return self
end
function CONTROLLABLE:TaskEPLRS(SwitchOnOff,idx)
if SwitchOnOff==nil then
SwitchOnOff=true
end
local CommandEPLRS={
id='EPLRS',
params={
value=SwitchOnOff,
groupId=self:GetID(),
},
}
return self:TaskWrappedAction(CommandEPLRS,idx or 1)
end
function CONTROLLABLE:TaskAttackGroup(AttackGroup,WeaponType,WeaponExpend,AttackQty,Direction,Altitude,AttackQtyLimit,GroupAttack)
local DCSTask={id='AttackGroup',
params={
groupId=AttackGroup:GetID(),
weaponType=WeaponType or 1073741822,
expend=WeaponExpend or"Auto",
attackQtyLimit=AttackQty and true or false,
attackQty=AttackQty or 1,
directionEnabled=Direction and true or false,
direction=Direction and math.rad(Direction)or 0,
altitudeEnabled=Altitude and true or false,
altitude=Altitude,
groupAttack=GroupAttack and true or false,
},
}
return DCSTask
end
function CONTROLLABLE:TaskAttackUnit(AttackUnit,GroupAttack,WeaponExpend,AttackQty,Direction,Altitude,WeaponType)
local DCSTask={
id='AttackUnit',
params={
unitId=AttackUnit:GetID(),
groupAttack=GroupAttack and GroupAttack or false,
expend=WeaponExpend or"Auto",
directionEnabled=Direction and true or false,
direction=Direction and math.rad(Direction)or 0,
altitudeEnabled=Altitude and true or false,
altitude=Altitude,
attackQtyLimit=AttackQty and true or false,
attackQty=AttackQty,
weaponType=WeaponType or 1073741822,
},
}
return DCSTask
end
function CONTROLLABLE:TaskBombing(Vec2,GroupAttack,WeaponExpend,AttackQty,Direction,Altitude,WeaponType,Divebomb)
local DCSTask={
id='Bombing',
params={
point=Vec2,
x=Vec2.x,
y=Vec2.y,
groupAttack=GroupAttack and GroupAttack or false,
expend=WeaponExpend or"Auto",
attackQtyLimit=AttackQty and true or false,
attackQty=AttackQty or 1,
directionEnabled=Direction and true or false,
direction=Direction and math.rad(Direction)or 0,
altitudeEnabled=Altitude and true or false,
altitude=Altitude or 2000,
weaponType=WeaponType or 1073741822,
attackType=Divebomb and"Dive"or nil,
},
}
return DCSTask
end
function CONTROLLABLE:TaskStrafing(Vec2,AttackQty,Length,WeaponType,WeaponExpend,Direction,GroupAttack)
local DCSTask={
id='Strafing',
params={
point=Vec2,
weaponType=WeaponType or 805337088,
expend=WeaponExpend or"Auto",
attackQty=AttackQty or 1,
attackQtyLimit=AttackQty~=nil and true or false,
direction=Direction and math.rad(Direction)or 0,
directionEnabled=Direction and true or false,
groupAttack=GroupAttack or false,
length=Length,
}
}
return DCSTask
end
function CONTROLLABLE:TaskAttackMapObject(Vec2,GroupAttack,WeaponExpend,AttackQty,Direction,Altitude,WeaponType)
local DCSTask={
id='AttackMapObject',
params={
point=Vec2,
x=Vec2.x,
y=Vec2.y,
groupAttack=GroupAttack or false,
expend=WeaponExpend or"Auto",
attackQtyLimit=AttackQty and true or false,
directionEnabled=Direction and true or false,
direction=Direction and math.rad(Direction)or 0,
altitudeEnabled=Altitude and true or false,
altitude=Altitude,
weaponType=WeaponType or 1073741822,
},
}
return DCSTask
end
function CONTROLLABLE:TaskCarpetBombing(Vec2,GroupAttack,WeaponExpend,AttackQty,Direction,Altitude,WeaponType,CarpetLength)
local DCSTask={
id='CarpetBombing',
params={
attackType="Carpet",
x=Vec2.x,
y=Vec2.y,
groupAttack=GroupAttack and GroupAttack or false,
carpetLength=CarpetLength or 500,
weaponType=WeaponType or ENUMS.WeaponFlag.AnyBomb,
expend=WeaponExpend or"All",
attackQtyLimit=AttackQty and true or false,
attackQty=AttackQty or 1,
directionEnabled=Direction and true or false,
direction=Direction and math.rad(Direction)or 0,
altitudeEnabled=Altitude and true or false,
altitude=Altitude,
},
}
return DCSTask
end
function CONTROLLABLE:TaskFollowBigFormation(FollowControllable,Vec3,LastWaypointIndex)
local DCSTask={
id='FollowBigFormation',
params={
groupId=FollowControllable:GetID(),
pos=Vec3,
lastWptIndexFlag=LastWaypointIndex and true or false,
lastWptIndex=LastWaypointIndex,
},
}
return DCSTask
end
function CONTROLLABLE:TaskEmbarking(Coordinate,GroupSetForEmbarking,Duration,Distribution)
local g4e={}
if GroupSetForEmbarking then
for _,_group in pairs(GroupSetForEmbarking:GetSet())do
local group=_group
table.insert(g4e,group:GetID())
end
else
self:E("ERROR: No groups for embarking specified!")
return nil
end
local groupID=self and self:GetID()
local DCSTask={
id='Embarking',
params={
selectedTransport=groupID,
x=Coordinate.x,
y=Coordinate.z,
groupsForEmbarking=g4e,
durationFlag=Duration and true or false,
duration=Duration,
distributionFlag=Distribution and true or false,
distribution=Distribution,
},
}
return DCSTask
end
function CONTROLLABLE:TaskEmbarkToTransport(Coordinate,Radius,UnitType)
local EmbarkToTransport={
id="EmbarkToTransport",
params={
x=Coordinate.x,
y=Coordinate.z,
zoneRadius=Radius or 200,
selectedType=UnitType,
},
}
return EmbarkToTransport
end
function CONTROLLABLE:TaskDisembarking(Coordinate,GroupSetToDisembark)
local g4e={}
if GroupSetToDisembark then
for _,_group in pairs(GroupSetToDisembark:GetSet())do
local group=_group
table.insert(g4e,group:GetID())
end
else
self:E("ERROR: No groups for disembarking specified!")
return nil
end
local Disembarking={
id="Disembarking",
params={
x=Coordinate.x,
y=Coordinate.z,
groupsForEmbarking=g4e,
},
}
return Disembarking
end
function CONTROLLABLE:TaskOrbitCircleAtVec2(Point,Altitude,Speed)
self:F2({self.ControllableName,Point,Altitude,Speed})
local DCSTask={
id='Orbit',
params={
pattern=AI.Task.OrbitPattern.CIRCLE,
point=Point,
speed=Speed,
altitude=Altitude+land.getHeight(Point),
},
}
return DCSTask
end
function CONTROLLABLE:TaskOrbit(Coord,Altitude,Speed,CoordRaceTrack)
local Pattern=AI.Task.OrbitPattern.CIRCLE
local P1={x=Coord.x,y=Coord.z or Coord.y}
local P2=nil
if CoordRaceTrack then
Pattern=AI.Task.OrbitPattern.RACE_TRACK
P2={x=CoordRaceTrack.x,y=CoordRaceTrack.z or CoordRaceTrack.y}
end
local Task={
id='Orbit',
params={
pattern=Pattern,
point=P1,
point2=P2,
speed=Speed or UTILS.KnotsToMps(250),
altitude=Altitude or Coord.y,
},
}
return Task
end
function CONTROLLABLE:TaskOrbitCircle(Altitude,Speed,Coordinate)
self:F2({self.ControllableName,Altitude,Speed})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local OrbitVec2=Coordinate and Coordinate:GetVec2()or self:GetVec2()
return self:TaskOrbitCircleAtVec2(OrbitVec2,Altitude,Speed)
end
return nil
end
function CONTROLLABLE:TaskHoldPosition()
self:F2({self.ControllableName})
return self:TaskOrbitCircle(30,10)
end
function CONTROLLABLE:TaskBombingRunway(Airbase,WeaponType,WeaponExpend,AttackQty,Direction,GroupAttack)
local DCSTask={
id='BombingRunway',
params={
runwayId=Airbase:GetID(),
weaponType=WeaponType or ENUMS.WeaponFlag.AnyBomb,
expend=WeaponExpend or AI.Task.WeaponExpend.ALL,
attackQty=AttackQty or 1,
direction=Direction and math.rad(Direction)or 0,
groupAttack=GroupAttack and true or false,
},
}
return DCSTask
end
function CONTROLLABLE:TaskRefueling()
local DCSTask={
id='Refueling',
params={},
}
return DCSTask
end
function CONTROLLABLE:TaskRecoveryTanker(CarrierGroup,Speed,Altitude,LastWptNumber)
local LastWptFlag=type(LastWptNumber)=="number"and true or false
local DCSTask={
id="RecoveryTanker",
params={
groupId=CarrierGroup:GetID(),
speed=Speed,
altitude=Altitude,
lastWptIndexFlag=LastWptFlag,
lastWptIndex=LastWptNumber
}
}
return DCSTask
end
function CONTROLLABLE:TaskLandAtVec2(Vec2,Duration,CombatLanding,DirectionAfterLand)
local DCSTask={
id='Land',
params={
point=Vec2,
durationFlag=Duration and true or false,
duration=Duration,
combatLandingFlag=CombatLanding==true and true or false,
},
}
if DirectionAfterLand~=nil and type(DirectionAfterLand)=="number"then
DCSTask.params.directionEnabled=true
DCSTask.params.direction=math.rad(DirectionAfterLand)
end
return DCSTask
end
function CONTROLLABLE:TaskLandAtZone(Zone,Duration,RandomPoint,CombatLanding,DirectionAfterLand)
local Point=RandomPoint and Zone:GetRandomVec2()or Zone:GetVec2()
local DCSTask=CONTROLLABLE.TaskLandAtVec2(self,Point,Duration,CombatLanding,DirectionAfterLand)
return DCSTask
end
function CONTROLLABLE:TaskFollow(FollowControllable,Vec3,LastWaypointIndex)
self:F2({self.ControllableName,FollowControllable,Vec3,LastWaypointIndex})
local LastWaypointIndexFlag=false
local lastWptIndexFlagChangedManually=false
if LastWaypointIndex then
LastWaypointIndexFlag=true
lastWptIndexFlagChangedManually=true
end
local DCSTask={
id='Follow',
params={
groupId=FollowControllable:GetID(),
pos=Vec3,
lastWptIndexFlag=LastWaypointIndexFlag,
lastWptIndex=LastWaypointIndex,
lastWptIndexFlagChangedManually=lastWptIndexFlagChangedManually,
},
}
self:T3({DCSTask})
return DCSTask
end
function CONTROLLABLE:TaskGroundEscort(FollowControllable,LastWaypointIndex,OrbitDistance,TargetTypes)
local DCSTask={
id='GroundEscort',
params={
groupId=FollowControllable and FollowControllable:GetID()or nil,
engagementDistMax=OrbitDistance or 2000,
lastWptIndexFlag=LastWaypointIndex and true or false,
lastWptIndex=LastWaypointIndex,
targetTypes=TargetTypes or{"Ground vehicles"},
lastWptIndexFlagChangedManually=true,
},
}
return DCSTask
end
function CONTROLLABLE:TaskEscort(FollowControllable,Vec3,LastWaypointIndex,EngagementDistance,TargetTypes)
local DCSTask={
id='Escort',
params={
groupId=FollowControllable and FollowControllable:GetID()or nil,
pos=Vec3,
lastWptIndexFlag=LastWaypointIndex and true or false,
lastWptIndex=LastWaypointIndex,
engagementDistMax=EngagementDistance,
targetTypes=TargetTypes or{"Air"},
},
}
return DCSTask
end
function CONTROLLABLE:TaskFireAtPoint(Vec2,Radius,AmmoCount,WeaponType,Altitude,ASL)
local DCSTask={
id='FireAtPoint',
params={
point=Vec2,
x=Vec2.x,
y=Vec2.y,
zoneRadius=Radius,
radius=Radius,
expendQty=1,
expendQtyEnabled=false,
alt_type=ASL and 0 or 1,
},
}
if AmmoCount then
DCSTask.params.expendQty=AmmoCount
DCSTask.params.expendQtyEnabled=true
end
if Altitude then
DCSTask.params.altitude=Altitude
end
if WeaponType then
DCSTask.params.weaponType=WeaponType
end
return DCSTask
end
function CONTROLLABLE:TaskHold()
local DCSTask={id='Hold',params={}}
return DCSTask
end
function CONTROLLABLE:TaskFAC_AttackGroup(AttackGroup,WeaponType,Designation,Datalink,Frequency,Modulation,CallsignName,CallsignNumber)
local DCSTask={
id='FAC_AttackGroup',
params={
groupId=AttackGroup:GetID(),
weaponType=WeaponType or ENUMS.WeaponFlag.AutoDCS,
designation=Designation or"Auto",
datalink=Datalink and Datalink or true,
frequency=(Frequency or 133)*1000000,
modulation=Modulation or radio.modulation.AM,
callname=CallsignName,
number=CallsignNumber,
},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskEngageTargets(Distance,TargetTypes,Priority)
local DCSTask={
id='EngageTargets',
params={
maxDistEnabled=Distance and true or false,
maxDist=Distance,
targetTypes=TargetTypes or{"Air"},
priority=Priority or 0,
},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskEngageTargetsInZone(Vec2,Radius,TargetTypes,Priority)
local DCSTask={
id='EngageTargetsInZone',
params={
point=Vec2,
zoneRadius=Radius,
targetTypes=TargetTypes or{"Air"},
priority=Priority or 0
},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskAntiShip(TargetTypes,Priority)
local DCSTask={
id='EngageTargets',
key="AntiShip",
params={
targetTypes=TargetTypes or{"Ships"},
priority=Priority or 0
}
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskSEAD(TargetTypes,Priority)
local DCSTask={
id='EngageTargets',
key="SEAD",
params={
targetTypes=TargetTypes or{"Air Defence"},
priority=Priority or 0
}
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskCAP(TargetTypes,Priority)
local DCSTask={
id='EngageTargets',
key="CAP",
enabled=true,
params={
targetTypes=TargetTypes or{"Air"},
priority=Priority or 0
}
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskEngageGroup(AttackGroup,Priority,WeaponType,WeaponExpend,AttackQty,Direction,Altitude,AttackQtyLimit)
local DCSTask={
id='EngageGroup',
params={
groupId=AttackGroup:GetID(),
weaponType=WeaponType,
expend=WeaponExpend or"Auto",
directionEnabled=Direction and true or false,
direction=Direction,
altitudeEnabled=Altitude and true or false,
altitude=Altitude,
attackQtyLimit=AttackQty and true or false,
attackQty=AttackQty,
priority=Priority or 1,
},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskEngageUnit(EngageUnit,Priority,GroupAttack,WeaponExpend,AttackQty,Direction,Altitude,Visible,ControllableAttack)
local DCSTask={
id='EngageUnit',
params={
unitId=EngageUnit:GetID(),
priority=Priority or 1,
groupAttack=GroupAttack and GroupAttack or false,
visible=Visible and Visible or false,
expend=WeaponExpend or"Auto",
directionEnabled=Direction and true or false,
direction=Direction and math.rad(Direction)or nil,
altitudeEnabled=Altitude and true or false,
altitude=Altitude,
attackQtyLimit=AttackQty and true or false,
attackQty=AttackQty,
controllableAttack=ControllableAttack,
},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskAWACS()
local DCSTask={
id='AWACS',
params={},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskTanker()
local DCSTask={
id='Tanker',
params={},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskEWR()
local DCSTask={
id='EWR',
params={},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskFAC_EngageGroup(AttackGroup,Priority,WeaponType,Designation,Datalink,Frequency,Modulation,CallsignID,CallsignNumber)
local DCSTask={
id='FAC_EngageGroup',
params={
groupId=AttackGroup:GetID(),
weaponType=WeaponType or"Auto",
designation=Designation,
datalink=Datalink and Datalink or false,
frequency=(Frequency or 133)*1000000,
modulation=Modulation or radio.modulation.AM,
callname=CallsignID,
number=CallsignNumber,
priority=Priority or 0,
},
}
return DCSTask
end
function CONTROLLABLE:EnRouteTaskFAC(Frequency,Modulation,CallsignID,CallsignNumber,Priority)
local DCSTask={
id='FAC',
params={
frequency=(Frequency or 133)*1000000,
modulation=Modulation or radio.modulation.AM,
callname=CallsignID,
number=CallsignNumber,
priority=Priority or 0
}
}
return DCSTask
end
function CONTROLLABLE:TaskFunction(FunctionString,...)
local DCSScript={}
DCSScript[#DCSScript+1]="local MissionControllable = GROUP:Find( ... ) "
if arg and arg.n>0 then
local ArgumentKey='_'..tostring(arg):match("table: (.*)")
self:SetState(self,ArgumentKey,arg)
DCSScript[#DCSScript+1]="local Arguments = MissionControllable:GetState( MissionControllable, '"..ArgumentKey.."' ) "
DCSScript[#DCSScript+1]=FunctionString.."( MissionControllable, unpack( Arguments ) )"
else
DCSScript[#DCSScript+1]=FunctionString.."( MissionControllable )"
end
local DCSTask=self:TaskWrappedAction(self:CommandDoScript(table.concat(DCSScript)))
return DCSTask
end
function CONTROLLABLE:TaskMission(TaskMission)
local DCSTask={
id='Mission',
params={
TaskMission,
},
}
return DCSTask
end
do
function CONTROLLABLE:PatrolRoute()
local PatrolGroup=self
if not self:IsInstanceOf("GROUP")then
PatrolGroup=self:GetGroup()
end
self:F({PatrolGroup=PatrolGroup:GetName()})
if PatrolGroup:IsGround()or PatrolGroup:IsShip()then
local Waypoints=PatrolGroup:GetTemplateRoutePoints()
local FromCoord=PatrolGroup:GetCoordinate()
local depth=0
local IsSub=false
if PatrolGroup:IsShip()then
local navalvec3=FromCoord:GetVec3()
if navalvec3.y<0 then
depth=navalvec3.y
IsSub=true
end
end
local Waypoint=Waypoints[1]
local Speed=Waypoint.speed or(20/3.6)
local From=FromCoord:WaypointGround(Speed)
if IsSub then
From=FromCoord:WaypointNaval(Speed,Waypoint.alt)
end
table.insert(Waypoints,1,From)
local TaskRoute=PatrolGroup:TaskFunction("CONTROLLABLE.PatrolRoute")
self:F({Waypoints=Waypoints})
local Waypoint=Waypoints[#Waypoints]
PatrolGroup:SetTaskWaypoint(Waypoint,TaskRoute)
PatrolGroup:Route(Waypoints,2)
end
end
function CONTROLLABLE:PatrolRouteRandom(Speed,Formation,ToWaypoint)
local PatrolGroup=self
if not self:IsInstanceOf("GROUP")then
PatrolGroup=self:GetGroup()
end
self:F({PatrolGroup=PatrolGroup:GetName()})
if PatrolGroup:IsGround()or PatrolGroup:IsShip()then
local Waypoints=PatrolGroup:GetTemplateRoutePoints()
local FromCoord=PatrolGroup:GetCoordinate()
local FromWaypoint=1
if ToWaypoint then
FromWaypoint=ToWaypoint
end
local depth=0
local IsSub=false
if PatrolGroup:IsShip()then
local navalvec3=FromCoord:GetVec3()
if navalvec3.y<0 then
depth=navalvec3.y
IsSub=true
end
end
local ToWaypoint
repeat
ToWaypoint=math.random(1,#Waypoints)
until(ToWaypoint~=FromWaypoint)
self:F({FromWaypoint=FromWaypoint,ToWaypoint=ToWaypoint})
local Waypoint=Waypoints[ToWaypoint]
local ToCoord=COORDINATE:NewFromVec2({x=Waypoint.x,y=Waypoint.y})
local Route={}
if IsSub then
Route[#Route+1]=FromCoord:WaypointNaval(Speed,depth)
Route[#Route+1]=ToCoord:WaypointNaval(Speed,Waypoint.alt)
else
Route[#Route+1]=FromCoord:WaypointGround(Speed,Formation)
Route[#Route+1]=ToCoord:WaypointGround(Speed,Formation)
end
local TaskRouteToZone=PatrolGroup:TaskFunction("CONTROLLABLE.PatrolRouteRandom",Speed,Formation,ToWaypoint)
PatrolGroup:SetTaskWaypoint(Route[#Route],TaskRouteToZone)
PatrolGroup:Route(Route,1)
end
end
function CONTROLLABLE:PatrolZones(ZoneList,Speed,Formation,DelayMin,DelayMax)
if type(ZoneList)~="table"then
ZoneList={ZoneList}
end
local PatrolGroup=self
if not self:IsInstanceOf("GROUP")then
PatrolGroup=self:GetGroup()
end
DelayMin=DelayMin or 1
if not DelayMax or DelayMax<DelayMin then
DelayMax=DelayMin
end
local Delay=math.random(DelayMin,DelayMax)
self:F({PatrolGroup=PatrolGroup:GetName()})
if PatrolGroup:IsGround()or PatrolGroup:IsShip()then
local FromCoord=PatrolGroup:GetCoordinate()
local depth=0
local IsSub=false
if PatrolGroup:IsShip()then
local navalvec3=FromCoord:GetVec3()
if navalvec3.y<0 then
depth=navalvec3.y
IsSub=true
end
end
local RandomZone=ZoneList[math.random(1,#ZoneList)]
local ToCoord=RandomZone:GetRandomCoordinate(10)
local Route={}
if IsSub then
Route[#Route+1]=FromCoord:WaypointNaval(Speed,depth)
Route[#Route+1]=ToCoord:WaypointNaval(Speed,depth)
else
Route[#Route+1]=FromCoord:WaypointGround(Speed,Formation)
Route[#Route+1]=ToCoord:WaypointGround(Speed,Formation)
end
local TaskRouteToZone=PatrolGroup:TaskFunction("CONTROLLABLE.PatrolZones",ZoneList,Speed,Formation,DelayMin,DelayMax)
PatrolGroup:SetTaskWaypoint(Route[#Route],TaskRouteToZone)
PatrolGroup:Route(Route,Delay)
end
end
end
function CONTROLLABLE:TaskRoute(Points)
local DCSTask={
id='Mission',
params={
airborne=self:IsAir(),
route={points=Points},
},
}
return DCSTask
end
do
function CONTROLLABLE:RouteToVec2(Point,Speed)
self:F2({Point,Speed})
local ControllablePoint=self:GetUnit(1):GetVec2()
local PointFrom={}
PointFrom.x=ControllablePoint.x
PointFrom.y=ControllablePoint.y
PointFrom.type="Turning Point"
PointFrom.action="Turning Point"
PointFrom.speed=Speed
PointFrom.speed_locked=true
PointFrom.properties={
["vnav"]=1,
["scale"]=0,
["angle"]=0,
["vangle"]=0,
["steer"]=2,
}
local PointTo={}
PointTo.x=Point.x
PointTo.y=Point.y
PointTo.type="Turning Point"
PointTo.action="Fly Over Point"
PointTo.speed=Speed
PointTo.speed_locked=true
PointTo.properties={
["vnav"]=1,
["scale"]=0,
["angle"]=0,
["vangle"]=0,
["steer"]=2,
}
local Points={PointFrom,PointTo}
self:T3(Points)
self:Route(Points)
return self
end
function CONTROLLABLE:RouteToVec3(Point,Speed)
self:F2({Point,Speed})
local ControllableVec3=self:GetUnit(1):GetVec3()
local PointFrom={}
PointFrom.x=ControllableVec3.x
PointFrom.y=ControllableVec3.z
PointFrom.alt=ControllableVec3.y
PointFrom.alt_type="BARO"
PointFrom.type="Turning Point"
PointFrom.action="Turning Point"
PointFrom.speed=Speed
PointFrom.speed_locked=true
PointFrom.properties={
["vnav"]=1,
["scale"]=0,
["angle"]=0,
["vangle"]=0,
["steer"]=2,
}
local PointTo={}
PointTo.x=Point.x
PointTo.y=Point.z
PointTo.alt=Point.y
PointTo.alt_type="BARO"
PointTo.type="Turning Point"
PointTo.action="Fly Over Point"
PointTo.speed=Speed
PointTo.speed_locked=true
PointTo.properties={
["vnav"]=1,
["scale"]=0,
["angle"]=0,
["vangle"]=0,
["steer"]=2,
}
local Points={PointFrom,PointTo}
self:T3(Points)
self:Route(Points)
return self
end
function CONTROLLABLE:Route(Route,DelaySeconds)
self:F2(Route)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local RouteTask=self:TaskRoute(Route)
self:SetTask(RouteTask,DelaySeconds or 1)
return self
end
return nil
end
function CONTROLLABLE:RoutePush(Route,DelaySeconds)
self:F2(Route)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local RouteTask=self:TaskRoute(Route)
self:PushTask(RouteTask,DelaySeconds or 1)
return self
end
return nil
end
function CONTROLLABLE:RouteStop()
self:F(self:GetName().." RouteStop")
local CommandStop=self:CommandStopRoute(true)
self:SetCommand(CommandStop)
end
function CONTROLLABLE:RouteResume()
self:F(self:GetName().." RouteResume")
local CommandResume=self:CommandStopRoute(false)
self:SetCommand(CommandResume)
end
function CONTROLLABLE:RouteGroundTo(ToCoordinate,Speed,Formation,DelaySeconds,WaypointFunction,WaypointFunctionArguments)
local FromCoordinate=self:GetCoordinate()
local FromWP=FromCoordinate:WaypointGround(Speed,Formation)
local ToWP=ToCoordinate:WaypointGround(Speed,Formation)
local route={FromWP,ToWP}
if WaypointFunction then
local N=#route
for n,waypoint in pairs(route)do
waypoint.task={}
waypoint.task.id="ComboTask"
waypoint.task.params={}
waypoint.task.params.tasks={self:TaskFunction("CONTROLLABLE.___PassingWaypoint",n,N,WaypointFunction,unpack(WaypointFunctionArguments or{}))}
end
end
self:Route(route,DelaySeconds)
return self
end
function CONTROLLABLE:RouteGroundOnRoad(ToCoordinate,Speed,DelaySeconds,OffRoadFormation,WaypointFunction,WaypointFunctionArguments)
Speed=Speed or 20
DelaySeconds=DelaySeconds or 1
OffRoadFormation=OffRoadFormation or"Off Road"
local route=self:TaskGroundOnRoad(ToCoordinate,Speed,OffRoadFormation,nil,nil,WaypointFunction,WaypointFunctionArguments)
self:Route(route,DelaySeconds)
return self
end
function CONTROLLABLE:RouteGroundOnRailRoads(ToCoordinate,Speed,DelaySeconds,WaypointFunction,WaypointFunctionArguments)
Speed=Speed or 20
DelaySeconds=DelaySeconds or 1
local route=self:TaskGroundOnRailRoads(ToCoordinate,Speed,WaypointFunction,WaypointFunctionArguments)
self:Route(route,DelaySeconds)
return self
end
function CONTROLLABLE:TaskGroundOnRoad(ToCoordinate,Speed,OffRoadFormation,Shortcut,FromCoordinate,WaypointFunction,WaypointFunctionArguments)
self:T({ToCoordinate=ToCoordinate,Speed=Speed,OffRoadFormation=OffRoadFormation,WaypointFunction=WaypointFunction,Args=WaypointFunctionArguments})
Speed=Speed or 20
OffRoadFormation=OffRoadFormation or"Off Road"
FromCoordinate=FromCoordinate or self:GetCoordinate()
local PathOnRoad,LengthOnRoad,GotPath=FromCoordinate:GetPathOnRoad(ToCoordinate,true)
local _,LengthRoad=FromCoordinate:GetPathOnRoad(ToCoordinate,false)
local LengthOffRoad
local LongRoad
local LengthDirect=FromCoordinate:Get2DDistance(ToCoordinate)
if GotPath and LengthRoad then
LengthOffRoad=LengthOnRoad-LengthRoad
LongRoad=LengthOnRoad and((LengthOnRoad>LengthDirect*10)or(LengthRoad/LengthOnRoad*100<5))
self:T(string.format("Length on road   = %.3f km",LengthOnRoad/1000))
self:T(string.format("Length directly  = %.3f km",LengthDirect/1000))
self:T(string.format("Length fraction  = %.3f km",LengthOnRoad/LengthDirect))
self:T(string.format("Length only road = %.3f km",LengthRoad/1000))
self:T(string.format("Length off road  = %.3f km",LengthOffRoad/1000))
self:T(string.format("Percent on road  = %.1f",LengthRoad/LengthOnRoad*100))
end
local route={}
local canroad=false
if GotPath and LengthRoad and LengthDirect>2000 then
if LongRoad and Shortcut then
table.insert(route,FromCoordinate:WaypointGround(Speed,OffRoadFormation))
table.insert(route,ToCoordinate:WaypointGround(Speed,OffRoadFormation))
else
table.insert(route,FromCoordinate:WaypointGround(Speed,OffRoadFormation))
table.insert(route,PathOnRoad[2]:WaypointGround(Speed,"On Road"))
table.insert(route,PathOnRoad[#PathOnRoad-1]:WaypointGround(Speed,"On Road"))
local dist=ToCoordinate:Get2DDistance(PathOnRoad[#PathOnRoad-1])
if dist>10 then
table.insert(route,ToCoordinate:WaypointGround(Speed,OffRoadFormation))
table.insert(route,ToCoordinate:GetRandomCoordinateInRadius(10,5):WaypointGround(5,OffRoadFormation))
table.insert(route,ToCoordinate:GetRandomCoordinateInRadius(10,5):WaypointGround(5,OffRoadFormation))
end
end
canroad=true
else
table.insert(route,FromCoordinate:WaypointGround(Speed,OffRoadFormation))
table.insert(route,ToCoordinate:WaypointGround(Speed,OffRoadFormation))
end
if WaypointFunction then
local N=#route
for n,waypoint in pairs(route)do
waypoint.task={}
waypoint.task.id="ComboTask"
waypoint.task.params={}
waypoint.task.params.tasks={self:TaskFunction("CONTROLLABLE.___PassingWaypoint",n,N,WaypointFunction,unpack(WaypointFunctionArguments or{}))}
end
end
return route,canroad
end
function CONTROLLABLE:TaskGroundOnRailRoads(ToCoordinate,Speed,WaypointFunction,WaypointFunctionArguments)
self:F2({ToCoordinate=ToCoordinate,Speed=Speed})
Speed=Speed or 20
local FromCoordinate=self:GetCoordinate()
local PathOnRail,LengthOnRail=FromCoordinate:GetPathOnRoad(ToCoordinate,false,true)
self:T(string.format("Length on railroad = %.3f km",LengthOnRail/1000))
local route={}
if PathOnRail then
table.insert(route,PathOnRail[1]:WaypointGround(Speed,"On Railroad"))
table.insert(route,PathOnRail[2]:WaypointGround(Speed,"On Railroad"))
end
if WaypointFunction then
local N=#route
for n,waypoint in pairs(route)do
waypoint.task={}
waypoint.task.id="ComboTask"
waypoint.task.params={}
waypoint.task.params.tasks={self:TaskFunction("CONTROLLABLE.___PassingWaypoint",n,N,WaypointFunction,unpack(WaypointFunctionArguments or{}))}
end
end
return route
end
function CONTROLLABLE.___PassingWaypoint(controllable,n,N,waypointfunction,...)
waypointfunction(controllable,n,N,...)
end
function CONTROLLABLE:RouteAirTo(ToCoordinate,AltType,Type,Action,Speed,DelaySeconds)
local FromCoordinate=self:GetCoordinate()
local FromWP=FromCoordinate:WaypointAir()
local ToWP=ToCoordinate:WaypointAir(AltType,Type,Action,Speed)
self:Route({FromWP,ToWP},DelaySeconds)
return self
end
function CONTROLLABLE:TaskRouteToZone(Zone,Randomize,Speed,Formation)
self:F2(Zone)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local ControllablePoint=self:GetVec2()
local PointFrom={}
PointFrom.x=ControllablePoint.x
PointFrom.y=ControllablePoint.y
PointFrom.type="Turning Point"
PointFrom.action=Formation or"Cone"
PointFrom.speed=20/3.6
local PointTo={}
local ZonePoint
if Randomize then
ZonePoint=Zone:GetRandomVec2()
else
ZonePoint=Zone:GetVec2()
end
PointTo.x=ZonePoint.x
PointTo.y=ZonePoint.y
PointTo.type="Turning Point"
if Formation then
PointTo.action=Formation
else
PointTo.action="Cone"
end
if Speed then
PointTo.speed=Speed
else
PointTo.speed=20/3.6
end
local Points={PointFrom,PointTo}
self:T3(Points)
self:Route(Points)
return self
end
return nil
end
function CONTROLLABLE:TaskRouteToVec2(Vec2,Speed,Formation)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local ControllablePoint=self:GetVec2()
local PointFrom={}
PointFrom.x=ControllablePoint.x
PointFrom.y=ControllablePoint.y
PointFrom.type="Turning Point"
PointFrom.action=Formation or"Cone"
PointFrom.speed=20/3.6
local PointTo={}
PointTo.x=Vec2.x
PointTo.y=Vec2.y
PointTo.type="Turning Point"
if Formation then
PointTo.action=Formation
else
PointTo.action="Cone"
end
if Speed then
PointTo.speed=Speed
else
PointTo.speed=20/3.6
end
local Points={PointFrom,PointTo}
self:T3(Points)
self:Route(Points)
return self
end
return nil
end
end
function CONTROLLABLE:CommandDoScript(DoScript)
local DCSDoScript={
id="Script",
params={
command=DoScript,
},
}
self:T3(DCSDoScript)
return DCSDoScript
end
function CONTROLLABLE:GetTaskMission()
self:F2(self.ControllableName)
return UTILS.DeepCopy(_DATABASE.Templates.Controllables[self.ControllableName].Template)
end
function CONTROLLABLE:GetTaskRoute()
self:F2(self.ControllableName)
return UTILS.DeepCopy(_DATABASE.Templates.Controllables[self.ControllableName].Template.route.points)
end
function CONTROLLABLE:CopyRoute(Begin,End,Randomize,Radius)
self:F2({Begin,End})
local Points={}
local ControllableName=string.match(self:GetName(),".*#")
if ControllableName then
ControllableName=ControllableName:sub(1,-2)
else
ControllableName=self:GetName()
end
self:T3({ControllableName})
local Template=_DATABASE.Templates.Controllables[ControllableName].Template
if Template then
if not Begin then
Begin=0
end
if not End then
End=0
end
for TPointID=Begin+1,#Template.route.points-End do
if Template.route.points[TPointID]then
Points[#Points+1]=UTILS.DeepCopy(Template.route.points[TPointID])
if Randomize then
if not Radius then
Radius=500
end
Points[#Points].x=Points[#Points].x+math.random(Radius*-1,Radius)
Points[#Points].y=Points[#Points].y+math.random(Radius*-1,Radius)
end
end
end
return Points
else
error("Template not found for Controllable : "..ControllableName)
end
return nil
end
function CONTROLLABLE:GetDetectedTargets(DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
self:F2(self.ControllableName)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local DetectionVisual=(DetectVisual and DetectVisual==true)and Controller.Detection.VISUAL or nil
local DetectionOptical=(DetectOptical and DetectOptical==true)and Controller.Detection.OPTIC or nil
local DetectionRadar=(DetectRadar and DetectRadar==true)and Controller.Detection.RADAR or nil
local DetectionIRST=(DetectIRST and DetectIRST==true)and Controller.Detection.IRST or nil
local DetectionRWR=(DetectRWR and DetectRWR==true)and Controller.Detection.RWR or nil
local DetectionDLINK=(DetectDLINK and DetectDLINK==true)and Controller.Detection.DLINK or nil
local Params={}
if DetectionVisual then
Params[#Params+1]=DetectionVisual
end
if DetectionOptical then
Params[#Params+1]=DetectionOptical
end
if DetectionRadar then
Params[#Params+1]=DetectionRadar
end
if DetectionIRST then
Params[#Params+1]=DetectionIRST
end
if DetectionRWR then
Params[#Params+1]=DetectionRWR
end
if DetectionDLINK then
Params[#Params+1]=DetectionDLINK
end
self:T2({DetectionVisual,DetectionOptical,DetectionRadar,DetectionIRST,DetectionRWR,DetectionDLINK})
return self:_GetController():getDetectedTargets(Params[1],Params[2],Params[3],Params[4],Params[5],Params[6])
end
return nil
end
function CONTROLLABLE:IsTargetDetected(DCSObject,DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
self:F2(self.ControllableName)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local DetectionVisual=(DetectVisual and DetectVisual==true)and Controller.Detection.VISUAL or nil
local DetectionOptical=(DetectOptical and DetectOptical==true)and Controller.Detection.OPTIC or nil
local DetectionRadar=(DetectRadar and DetectRadar==true)and Controller.Detection.RADAR or nil
local DetectionIRST=(DetectIRST and DetectIRST==true)and Controller.Detection.IRST or nil
local DetectionRWR=(DetectRWR and DetectRWR==true)and Controller.Detection.RWR or nil
local DetectionDLINK=(DetectDLINK and DetectDLINK==true)and Controller.Detection.DLINK or nil
local Controller=self:_GetController()
local TargetIsDetected,TargetIsVisible,TargetKnowType,TargetKnowDistance,TargetLastTime,TargetLastPos,TargetLastVelocity
=Controller:isTargetDetected(DCSObject,DetectionVisual,DetectionOptical,DetectionRadar,DetectionIRST,DetectionRWR,DetectionDLINK)
return TargetIsDetected,TargetIsVisible,TargetKnowType,TargetKnowDistance,TargetLastTime,TargetLastPos,TargetLastVelocity
end
return nil
end
function CONTROLLABLE:IsUnitDetected(Unit,DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
self:F2(self.ControllableName)
if Unit and Unit:IsAlive()then
return self:IsTargetDetected(Unit:GetDCSObject(),DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
end
return nil
end
function CONTROLLABLE:IsGroupDetected(Group,DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
self:F2(self.ControllableName)
if Group and Group:IsAlive()then
for _,_unit in pairs(Group:GetUnits())do
local unit=_unit
if unit and unit:IsAlive()then
local isdetected=self:IsUnitDetected(unit,DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
if isdetected then
return true
end
end
end
return false
end
return nil
end
function CONTROLLABLE:GetDetectedUnitSet(DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
local detectedtargets=self:GetDetectedTargets(DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
local unitset=SET_UNIT:New()
for DetectionObjectID,Detection in pairs(detectedtargets or{})do
local DetectedObject=Detection.object
if DetectedObject and DetectedObject:isExist()and DetectedObject.id_<50000000 then
local unit=UNIT:Find(DetectedObject)
if unit and unit:IsAlive()then
if not unitset:FindUnit(unit:GetName())then
unitset:AddUnit(unit)
end
end
end
end
return unitset
end
function CONTROLLABLE:GetDetectedGroupSet(DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
local detectedtargets=self:GetDetectedTargets(DetectVisual,DetectOptical,DetectRadar,DetectIRST,DetectRWR,DetectDLINK)
local groupset=SET_GROUP:New()
for DetectionObjectID,Detection in pairs(detectedtargets or{})do
local DetectedObject=Detection.object
if DetectedObject and DetectedObject:isExist()and DetectedObject.id_<50000000 then
local unit=UNIT:Find(DetectedObject)
if unit and unit:IsAlive()then
local group=unit:GetGroup()
if group and not groupset:FindGroup(group:GetName())then
groupset:AddGroup(group)
end
end
end
end
return groupset
end
function CONTROLLABLE:SetOption(OptionID,OptionValue)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
Controller:setOption(OptionID,OptionValue)
return self
end
return nil
end
function CONTROLLABLE:OptionROE(ROEvalue)
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ROE,ROEvalue)
elseif self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ROE,ROEvalue)
elseif self:IsShip()then
Controller:setOption(AI.Option.Naval.id.ROE,ROEvalue)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROEHoldFirePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()or self:IsGround()or self:IsShip()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROEHoldFire()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ROE,AI.Option.Air.val.ROE.WEAPON_HOLD)
elseif self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ROE,AI.Option.Ground.val.ROE.WEAPON_HOLD)
elseif self:IsShip()then
Controller:setOption(AI.Option.Naval.id.ROE,AI.Option.Naval.val.ROE.WEAPON_HOLD)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROEReturnFirePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()or self:IsGround()or self:IsShip()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROEReturnFire()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ROE,AI.Option.Air.val.ROE.RETURN_FIRE)
elseif self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ROE,AI.Option.Ground.val.ROE.RETURN_FIRE)
elseif self:IsShip()then
Controller:setOption(AI.Option.Naval.id.ROE,AI.Option.Naval.val.ROE.RETURN_FIRE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROEOpenFirePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()or self:IsGround()or self:IsShip()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROEOpenFire()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ROE,AI.Option.Air.val.ROE.OPEN_FIRE)
elseif self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ROE,AI.Option.Ground.val.ROE.OPEN_FIRE)
elseif self:IsShip()then
Controller:setOption(AI.Option.Naval.id.ROE,AI.Option.Naval.val.ROE.OPEN_FIRE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROEOpenFireWeaponFreePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROEOpenFireWeaponFree()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ROE,AI.Option.Air.val.ROE.OPEN_FIRE_WEAPON_FREE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROEWeaponFreePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROEWeaponFree()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ROE,AI.Option.Air.val.ROE.WEAPON_FREE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROTNoReactionPossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROTNoReaction()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.REACTION_ON_THREAT,AI.Option.Air.val.REACTION_ON_THREAT.NO_REACTION)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROT(ROTvalue)
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.REACTION_ON_THREAT,ROTvalue)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROTPassiveDefensePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROTPassiveDefense()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.REACTION_ON_THREAT,AI.Option.Air.val.REACTION_ON_THREAT.PASSIVE_DEFENCE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROTEvadeFirePossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROTEvadeFire()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.REACTION_ON_THREAT,AI.Option.Air.val.REACTION_ON_THREAT.EVADE_FIRE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionROTVerticalPossible()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
if self:IsAir()then
return true
end
return false
end
return nil
end
function CONTROLLABLE:OptionROTVertical()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.REACTION_ON_THREAT,AI.Option.Air.val.REACTION_ON_THREAT.BYPASS_AND_ESCAPE)
end
return self
end
return nil
end
function CONTROLLABLE:OptionAlarmStateAuto()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ALARM_STATE,AI.Option.Ground.val.ALARM_STATE.AUTO)
elseif self:IsShip()then
Controller:setOption(9,0)
end
return self
end
return nil
end
function CONTROLLABLE:OptionAlarmStateGreen()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ALARM_STATE,AI.Option.Ground.val.ALARM_STATE.GREEN)
elseif self:IsShip()then
Controller:setOption(9,1)
end
return self
end
return nil
end
function CONTROLLABLE:OptionAlarmStateRed()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsGround()then
Controller:setOption(AI.Option.Ground.id.ALARM_STATE,AI.Option.Ground.val.ALARM_STATE.RED)
elseif self:IsShip()then
Controller:setOption(9,2)
end
return self
end
return nil
end
function CONTROLLABLE:OptionRTBBingoFuel(RTB)
self:F2({self.ControllableName})
if RTB==nil then
RTB=true
end
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.RTB_ON_BINGO,RTB)
end
return self
end
return nil
end
function CONTROLLABLE:OptionRTBAmmo(WeaponsFlag)
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.RTB_ON_OUT_OF_AMMO,WeaponsFlag)
end
return self
end
return nil
end
function CONTROLLABLE:OptionAllowJettisonWeaponsOnThreat()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.PROHIBIT_JETT,false)
end
return self
end
return nil
end
function CONTROLLABLE:OptionKeepWeaponsOnThreat()
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.PROHIBIT_JETT,true)
end
return self
end
return nil
end
function CONTROLLABLE:OptionProhibitAfterburner(Prohibit)
self:F2({self.ControllableName})
if Prohibit==nil then
Prohibit=true
end
if self:IsAir()then
self:SetOption(AI.Option.Air.id.PROHIBIT_AB,Prohibit)
end
return self
end
function CONTROLLABLE:OptionEvasionOfARM(Seconds)
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsGround()then
if Seconds==nil then Seconds=false end
Controller:setOption(AI.Option.Ground.id.EVASION_OF_ARM,Seconds)
end
end
return self
end
function CONTROLLABLE:OptionFormationInterval(meters)
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsGround()then
if meters==nil or meters>100 or meters<0 then meters=50 end
Controller:setOption(30,meters)
end
end
return self
end
function CONTROLLABLE:OptionECM(ECMvalue)
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if self:IsAir()then
Controller:setOption(AI.Option.Air.id.ECM_USING,ECMvalue or 1)
end
end
return self
end
function CONTROLLABLE:OptionECM_Never()
self:F2({self.ControllableName})
self:OptionECM(0)
return self
end
function CONTROLLABLE:OptionECM_OnlyLockByRadar()
self:F2({self.ControllableName})
self:OptionECM(1)
return self
end
function CONTROLLABLE:OptionECM_DetectedLockByRadar()
self:F2({self.ControllableName})
self:OptionECM(2)
return self
end
function CONTROLLABLE:OptionECM_AlwaysOn()
self:F2({self.ControllableName})
self:OptionECM(3)
return self
end
function CONTROLLABLE:WayPointInitialize(WayPoints)
self:F({WayPoints})
if WayPoints then
self.WayPoints=WayPoints
else
self.WayPoints=self:GetTaskRoute()
end
return self
end
function CONTROLLABLE:GetWayPoints()
self:F()
if self.WayPoints then
return self.WayPoints
end
return nil
end
function CONTROLLABLE:WayPointFunction(WayPoint,WayPointIndex,WayPointFunction,...)
self:F2({WayPoint,WayPointIndex,WayPointFunction})
if not self.WayPoints then
self:WayPointInitialize()
end
table.insert(self.WayPoints[WayPoint].task.params.tasks,WayPointIndex)
self.WayPoints[WayPoint].task.params.tasks[WayPointIndex]=self:TaskFunction(WayPointFunction,arg)
return self
end
function CONTROLLABLE:WayPointExecute(WayPoint,WaitTime)
self:F({WayPoint,WaitTime})
if not WayPoint then
WayPoint=1
end
for TaskPointID=1,WayPoint-1 do
table.remove(self.WayPoints,1)
end
self:T3(self.WayPoints)
self:SetTask(self:TaskRoute(self.WayPoints),WaitTime)
return self
end
function CONTROLLABLE:IsAirPlane()
self:F2()
local DCSObject=self:GetDCSObject()
if DCSObject then
local Category=DCSObject:getDesc().category
return Category==Unit.Category.AIRPLANE
end
return nil
end
function CONTROLLABLE:IsHelicopter()
self:F2()
local DCSObject=self:GetDCSObject()
if DCSObject then
local Category=DCSObject:getDesc().category
return Category==Unit.Category.HELICOPTER
end
return nil
end
function CONTROLLABLE:OptionRestrictBurner(RestrictBurner)
self:F2({self.ControllableName})
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if Controller then
if RestrictBurner==true then
if self:IsAir()then
Controller:setOption(16,true)
end
else
if self:IsAir()then
Controller:setOption(16,false)
end
end
end
end
end
function CONTROLLABLE:OptionAAAttackRange(range)
self:F2({self.ControllableName})
local range=range or 3
if range<0 or range>4 then
range=3
end
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if Controller then
if self:IsAir()then
self:SetOption(AI.Option.Air.id.MISSILE_ATTACK,range)
end
end
return self
end
return nil
end
function CONTROLLABLE:OptionEngageRange(EngageRange)
self:F2({self.ControllableName})
EngageRange=EngageRange or 100
if EngageRange<0 or EngageRange>100 then
EngageRange=100
end
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if Controller then
if self:IsGround()then
self:SetOption(AI.Option.Ground.id.AC_ENGAGEMENT_RANGE_RESTRICTION,EngageRange)
end
end
return self
end
return nil
end
function CONTROLLABLE:SetOptionRadarUsing(Option)
self:F2({self.ControllableName})
if self:IsAir()then
self:SetOption(AI.Option.Air.id.RADAR_USING,Option)
end
return self
end
function CONTROLLABLE:SetOptionRadarUsingNever()
self:F2({self.ControllableName})
if self:IsAir()then
self:SetOption(AI.Option.Air.id.RADAR_USING,0)
end
return self
end
function CONTROLLABLE:SetOptionRadarUsingForAttackOnly()
self:F2({self.ControllableName})
if self:IsAir()then
self:SetOption(AI.Option.Air.id.RADAR_USING,1)
end
return self
end
function CONTROLLABLE:SetOptionRadarUsingForSearchIfRequired()
self:F2({self.ControllableName})
if self:IsAir()then
self:SetOption(AI.Option.Air.id.RADAR_USING,2)
end
return self
end
function CONTROLLABLE:SetOptionRadarUsingForContinousSearch()
self:F2({self.ControllableName})
if self:IsAir()then
self:SetOption(AI.Option.Air.id.RADAR_USING,3)
end
return self
end
function CONTROLLABLE:SetOptionWaypointPassReport(OnOff)
self:F2({self.ControllableName})
local onoff=(OnOff==nil or OnOff==true)and false or true
if self:IsAir()then
self:SetOption(AI.Option.Air.id.PROHIBIT_WP_PASS_REPORT,onoff)
end
return self
end
function CONTROLLABLE:SetOptionRadioSilence(OnOff)
local onoff=(OnOff==true or OnOff==nil)and true or false
self:F2({self.ControllableName})
if self:IsAir()then
self:SetOption(AI.Option.Air.id.SILENCE,onoff)
end
return self
end
function CONTROLLABLE:SetOptionRadioContact(Objects)
self:F2({self.ControllableName})
if not Objects then Objects={"Air"}end
if type(Objects)~="table"then Objects={Objects}end
if self:IsAir()then
self:SetOption(AI.Option.Air.id.OPTION_RADIO_USAGE_CONTACT,Objects)
end
return self
end
function CONTROLLABLE:SetOptionRadioEngage(Objects)
self:F2({self.ControllableName})
if not Objects then Objects={"Air"}end
if type(Objects)~="table"then Objects={Objects}end
if self:IsAir()then
self:SetOption(AI.Option.Air.id.OPTION_RADIO_USAGE_ENGAGE,Objects)
end
return self
end
function CONTROLLABLE:SetOptionRadioKill(Objects)
self:F2({self.ControllableName})
if not Objects then Objects={"Air"}end
if type(Objects)~="table"then Objects={Objects}end
if self:IsAir()then
self:SetOption(AI.Option.Air.id.OPTION_RADIO_USAGE_KILL,Objects)
end
return self
end
function CONTROLLABLE:RelocateGroundRandomInRadius(speed,radius,onroad,shortcut,formation,onland)
self:F2({self.ControllableName})
local _coord=self:GetCoordinate()
if not _coord then
return self
end
local _radius=radius or 500
local _speed=speed or 20
local _tocoord=_coord:GetRandomCoordinateInRadius(_radius,100)
if onland then
for i=1,50 do
local island=_tocoord:GetSurfaceType()==land.SurfaceType.LAND and true or false
if island then break end
_tocoord=_coord:GetRandomCoordinateInRadius(_radius,100)
end
end
local _onroad=onroad or true
local _grptsk={}
local _candoroad=false
local _shortcut=shortcut or false
local _formation=formation or"Off Road"
if onroad then
_grptsk,_candoroad=self:TaskGroundOnRoad(_tocoord,_speed,_formation,_shortcut)
self:Route(_grptsk,5)
else
self:TaskRouteToVec2(_tocoord:GetVec2(),_speed,_formation)
end
return self
end
function CONTROLLABLE:OptionDisperseOnAttack(Seconds)
self:F2({self.ControllableName})
local seconds=Seconds or 0
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if Controller then
if self:IsGround()then
self:SetOption(AI.Option.Ground.id.DISPERSE_ON_ATTACK,seconds)
end
end
return self
end
return nil
end
function CONTROLLABLE:IsSubmarine()
self:F2()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitDescriptor=DCSUnit:getDesc()
if UnitDescriptor.attributes["Submarines"]==true then
return true
else
return false
end
end
return nil
end
function CONTROLLABLE:SetSpeed(Speed,Keep)
self:F2({self.ControllableName})
local speed=Speed or 5
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if Controller then
Controller:setSpeed(speed,Keep)
end
end
return self
end
function CONTROLLABLE:SetAltitude(Altitude,Keep,AltType)
self:F2({self.ControllableName})
local altitude=Altitude or 1000
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=self:_GetController()
if Controller then
if self:IsAir()then
Controller:setAltitude(altitude,Keep,AltType)
end
end
end
return self
end
function CONTROLLABLE:TaskAerobatics()
local DCSTaskAerobatics={
id="Aerobatics",
params={
["maneuversSequency"]={},
},
["enabled"]=true,
["auto"]=false,
}
return DCSTaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsCandle(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local CandleTask={
["name"]="CANDLE",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
}
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],CandleTask)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsEdgeFlight(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,FlightTime,Side)
local maxrepeats=10
local maxflight=200
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local flighttime=FlightTime or 10
if flighttime>200 then maxflight=flighttime end
local EdgeTask={
["name"]="EDGE_FLIGHT",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["FlightTime"]={
["max_v"]=maxflight,
["min_v"]=1,
["order"]=6,
["step"]=0.1,
["value"]=flighttime or 10,
},
["SIDE"]={
["order"]=7,
["value"]=Side or 0,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],EdgeTask)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsWingoverFlight(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,FlightTime)
local maxrepeats=10
local maxflight=200
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local flighttime=FlightTime or 10
if flighttime>200 then maxflight=flighttime end
local WingoverTask={
["name"]="WINGOVER_FLIGHT",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["FlightTime"]={
["max_v"]=maxflight,
["min_v"]=1,
["order"]=6,
["step"]=0.1,
["value"]=flighttime or 10,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],WingoverTask)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsLoop(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local LoopTask={
["name"]="LOOP",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
}
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],LoopTask)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsHorizontalEight(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Side,RollDeg)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local LoopTask={
["name"]="HORIZONTAL_EIGHT",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["SIDE"]={
["order"]=6,
["value"]=Side or 0,
},
["ROLL1"]={
["order"]=7,
["value"]=RollDeg or 60,
},
["ROLL2"]={
["order"]=8,
["value"]=RollDeg or 60,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],LoopTask)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsHammerhead(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Side)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="HUMMERHEAD",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["SIDE"]={
["order"]=6,
["value"]=Side or 0,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsSkewedLoop(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Side,RollDeg)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="SKEWED_LOOP",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["ROLL"]={
["order"]=6,
["value"]=RollDeg or 60,
},
["SIDE"]={
["order"]=7,
["value"]=Side or 0,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsTurn(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Side,RollDeg,Pull,Angle)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="TURN",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["Ny_req"]={
["order"]=6,
["value"]=Pull or 2,
},
["ROLL"]={
["order"]=7,
["value"]=RollDeg or 60,
},
["SECTOR"]={
["order"]=8,
["value"]=Angle or 180,
},
["SIDE"]={
["order"]=9,
["value"]=Side or 0,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsDive(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Angle,FinalAltitude)
local maxrepeats=10
local angle=Angle
if angle<15 then angle=15 elseif angle>90 then angle=90 end
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="DIVE",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 5000,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["Angle"]={
["max_v"]=90,
["min_v"]=15,
["order"]=6,
["step"]=5,
["value"]=angle or 45,
},
["FinalAltitude"]={
["order"]=7,
["value"]=FinalAltitude or 1000,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsMilitaryTurn(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="MILITARY_TURN",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
}
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsImmelmann(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="IMMELMAN",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
}
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsStraightFlight(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,FlightTime)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local maxflight=200
if Repeats>maxrepeats then maxrepeats=Repeats end
local flighttime=FlightTime or 10
if flighttime>200 then maxflight=flighttime end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="STRAIGHT_FLIGHT",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["FlightTime"]={
["max_v"]=maxflight,
["min_v"]=1,
["order"]=6,
["step"]=0.1,
["value"]=flighttime or 10,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsClimb(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Angle,FinalAltitude)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="CLIMB",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["Angle"]={
["max_v"]=90,
["min_v"]=15,
["order"]=6,
["step"]=5,
["value"]=Angle or 45,
},
["FinalAltitude"]={
["order"]=7,
["value"]=FinalAltitude or 5000,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsSpiral(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,TurnAngle,Roll,Side,UpDown,Angle)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local updown=UpDown and 1 or 0
local side=Side and 1 or 0
local Task={
["name"]="SPIRAL",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["SECTOR"]={
["order"]=6,
["value"]=TurnAngle or 360,
},
["ROLL"]={
["order"]=7,
["value"]=Roll or 60,
},
["SIDE"]={
["order"]=8,
["value"]=side or 0,
},
["UPDOWN"]={
["order"]=9,
["value"]=updown or 0,
},
["Angle"]={
["max_v"]=90,
["min_v"]=15,
["order"]=10,
["step"]=5,
["value"]=Angle or 45,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsSplitS(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,FinalSpeed)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local maxflight=200
if Repeats>maxrepeats then maxrepeats=Repeats end
local finalspeed=FinalSpeed or 500
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="SPLIT_S",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["FinalSpeed"]={
["order"]=6,
["value"]=finalspeed,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsAileronRoll(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Side,RollRate,TurnAngle,FixAngle)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local maxflight=200
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="AILERON_ROLL",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["SIDE"]={
["order"]=6,
["value"]=Side or 0,
},
["RollRate"]={
["max_v"]=450,
["min_v"]=15,
["order"]=7,
["step"]=5,
["value"]=RollRate or 90,
},
["SECTOR"]={
["order"]=8,
["value"]=TurnAngle or 360,
},
["FIXSECTOR"]={
["max_v"]=180,
["min_v"]=0,
["order"]=9,
["step"]=5,
["value"]=FixAngle or 0,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsForcedTurn(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,TurnAngle,Side,FlightTime,MinSpeed)
local maxrepeats=10
local flighttime=FlightTime or 30
local maxtime=200
if flighttime>200 then maxtime=flighttime end
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="FORCED_TURN",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["SECTOR"]={
["order"]=6,
["value"]=TurnAngle or 360,
},
["SIDE"]={
["order"]=7,
["value"]=Side or 0,
},
["FlightTime"]={
["max_v"]=maxtime or 200,
["min_v"]=0,
["order"]=8,
["step"]=0.1,
["value"]=flighttime or 30,
},
["MinSpeed"]={
["max_v"]=3000,
["min_v"]=30,
["order"]=9,
["step"]=10,
["value"]=MinSpeed or 250,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:TaskAerobaticsBarrelRoll(TaskAerobatics,Repeats,InitAltitude,InitSpeed,UseSmoke,StartImmediately,Side,RollRate,TurnAngle)
local maxrepeats=10
if Repeats>maxrepeats then maxrepeats=Repeats end
local usesmoke=UseSmoke and 1 or 0
local startimmediately=StartImmediately and 1 or 0
local Task={
["name"]="BARREL_ROLL",
["params"]={
["RepeatQty"]={
["max_v"]=maxrepeats,
["min_v"]=1,
["order"]=1,
["value"]=Repeats or 1,
},
["InitAltitude"]={
["order"]=2,
["value"]=InitAltitude or 0,
},
["InitSpeed"]={
["order"]=3,
["value"]=InitSpeed or 0,
},
["UseSmoke"]={
["order"]=4,
["value"]=usesmoke,
},
["StartImmediatly"]={
["order"]=5,
["value"]=startimmediately,
},
["SIDE"]={
["order"]=6,
["value"]=Side or 0,
},
["RollRate"]={
["max_v"]=450,
["min_v"]=15,
["order"]=7,
["step"]=5,
["value"]=RollRate or 90,
},
["SECTOR"]={
["order"]=8,
["value"]=TurnAngle or 360,
},
}
}
table.insert(TaskAerobatics.params["maneuversSequency"],Task)
return TaskAerobatics
end
function CONTROLLABLE:PatrolRaceTrack(Point1,Point2,Altitude,Speed,Formation,AGL,Delay)
local PatrolGroup=self
if not self:IsInstanceOf("GROUP")then
PatrolGroup=self:GetGroup()
end
local delay=Delay or 1
self:F({PatrolGroup=PatrolGroup:GetName()})
if PatrolGroup:IsAir()then
if Formation then
PatrolGroup:SetOption(AI.Option.Air.id.FORMATION,Formation)
end
local FromCoord=PatrolGroup:GetCoordinate()
local ToCoord=Point1:GetCoordinate()
if Altitude then
local asl=true
if AGL then asl=false end
FromCoord:SetAltitude(Altitude,asl)
ToCoord:SetAltitude(Altitude,asl)
end
local Route={}
Route[#Route+1]=FromCoord:WaypointAir(AltType,COORDINATE.WaypointType.TurningPoint,COORDINATE.WaypointAction.TurningPoint,Speed,true,nil,DCSTasks,description,timeReFuAr)
Route[#Route+1]=ToCoord:WaypointAir(AltType,COORDINATE.WaypointType.TurningPoint,COORDINATE.WaypointAction.TurningPoint,Speed,true,nil,DCSTasks,description,timeReFuAr)
local TaskRouteToZone=PatrolGroup:TaskFunction("CONTROLLABLE.PatrolRaceTrack",Point2,Point1,Altitude,Speed,Formation,Delay)
PatrolGroup:SetTaskWaypoint(Route[#Route],TaskRouteToZone)
PatrolGroup:Route(Route,Delay)
end
return self
end
function CONTROLLABLE:NewIRMarker(EnableImmediately,Runtime)
self:T2("NewIRMarker")
if self:IsInstanceOf("GROUP")then
if self.IRMarkerGroup==true then return end
self.IRMarkerGroup=true
self.IRMarkerUnit=false
elseif self:IsInstanceOf("UNIT")then
if self.IRMarkerUnit==true then return end
self.IRMarkerGroup=false
self.IRMarkerUnit=true
end
self.Runtime=Runtime or 60
if EnableImmediately and EnableImmediately==true then
self:EnableIRMarker(Runtime)
end
return self
end
function CONTROLLABLE:EnableIRMarker(Runtime)
self:T2("EnableIRMarker")
if self.IRMarkerGroup==nil then
self:NewIRMarker(true,Runtime)
return
end
if self:IsInstanceOf("GROUP")then
self:EnableIRMarkerForGroup(Runtime)
return
end
if self.timer and self.timer:IsRunning()then return self end
local Runtime=Runtime or self.Runtime
self.timer=TIMER:New(CONTROLLABLE._MarkerBlink,self)
self.timer:Start(nil,1-math.random(1,5)/10/2,Runtime)
self.IRMarkerUnit=true
return self
end
function CONTROLLABLE:DisableIRMarker()
self:T2("DisableIRMarker")
if self:IsInstanceOf("GROUP")then
self:DisableIRMarkerForGroup()
return
end
if self.spot then
self.spot=nil
end
if self.timer and self.timer:IsRunning()then
self.timer:Stop()
self.timer=nil
end
if self:IsInstanceOf("GROUP")then
self.IRMarkerGroup=nil
elseif self:IsInstanceOf("UNIT")then
self.IRMarkerUnit=nil
end
return self
end
function CONTROLLABLE:EnableIRMarkerForGroup(Runtime)
self:T2("EnableIRMarkerForGroup")
if self:IsInstanceOf("GROUP")
then
local units=self:GetUnits()or{}
for _,_unit in pairs(units)do
_unit:EnableIRMarker(Runtime)
end
self.IRMarkerGroup=true
end
return self
end
function CONTROLLABLE:DisableIRMarkerForGroup()
self:T2("DisableIRMarkerForGroup")
if self:IsInstanceOf("GROUP")then
local units=self:GetUnits()or{}
for _,_unit in pairs(units)do
_unit:DisableIRMarker()
end
self.IRMarkerGroup=nil
end
return self
end
function CONTROLLABLE:HasIRMarker()
self:T2("HasIRMarker")
if self:IsInstanceOf("GROUP")then
local units=self:GetUnits()or{}
for _,_unit in pairs(units)do
if _unit.timer and _unit.timer:IsRunning()then return true end
end
elseif self.timer and self.timer:IsRunning()then return true end
return false
end
function CONTROLLABLE._StopSpot(spot)
if spot then
spot:destroy()
end
end
function CONTROLLABLE:_MarkerBlink()
self:T2("_MarkerBlink")
if self:IsAlive()~=true then
self:DisableIRMarker()
return
end
self.timer.dT=1-(math.random(1,2)/10/2)
local _,_,unitBBHeight,_=self:GetObjectSize()
local unitPos=self:GetPositionVec3()
if self.timer:IsRunning()then
self:T2("Create Spot")
local spot=Spot.createInfraRed(
self.DCSUnit,
{x=0,y=(unitBBHeight+1),z=0},
{x=unitPos.x,y=(unitPos.y+unitBBHeight),z=unitPos.z}
)
self.spot=spot
local offTimer=nil
local offTimer=TIMER:New(CONTROLLABLE._StopSpot,spot)
offTimer:Start(0.5)
end
return self
end
GROUP={
ClassName="GROUP",
}
GROUP.Takeoff={
Air=1,
Runway=2,
Hot=3,
Cold=4,
}
GROUPTEMPLATE={}
GROUPTEMPLATE.Takeoff={
[GROUP.Takeoff.Air]={"Turning Point","Turning Point"},
[GROUP.Takeoff.Runway]={"TakeOff","From Runway"},
[GROUP.Takeoff.Hot]={"TakeOffParkingHot","From Parking Area Hot"},
[GROUP.Takeoff.Cold]={"TakeOffParking","From Parking Area"}
}
GROUP.Attribute={
AIR_TRANSPORTPLANE="Air_TransportPlane",
AIR_AWACS="Air_AWACS",
AIR_FIGHTER="Air_Fighter",
AIR_BOMBER="Air_Bomber",
AIR_TANKER="Air_Tanker",
AIR_TRANSPORTHELO="Air_TransportHelo",
AIR_ATTACKHELO="Air_AttackHelo",
AIR_UAV="Air_UAV",
AIR_OTHER="Air_OtherAir",
GROUND_APC="Ground_APC",
GROUND_TRUCK="Ground_Truck",
GROUND_INFANTRY="Ground_Infantry",
GROUND_IFV="Ground_IFV",
GROUND_ARTILLERY="Ground_Artillery",
GROUND_TANK="Ground_Tank",
GROUND_TRAIN="Ground_Train",
GROUND_EWR="Ground_EWR",
GROUND_AAA="Ground_AAA",
GROUND_SAM="Ground_SAM",
GROUND_OTHER="Ground_OtherGround",
NAVAL_AIRCRAFTCARRIER="Naval_AircraftCarrier",
NAVAL_WARSHIP="Naval_WarShip",
NAVAL_ARMEDSHIP="Naval_ArmedShip",
NAVAL_UNARMEDSHIP="Naval_UnarmedShip",
NAVAL_OTHER="Naval_OtherNaval",
OTHER_UNKNOWN="Other_Unknown",
}
function GROUP:NewTemplate(GroupTemplate,CoalitionSide,CategoryID,CountryID)
local GroupName=GroupTemplate.name
_DATABASE:_RegisterGroupTemplate(GroupTemplate,CoalitionSide,CategoryID,CountryID,GroupName)
local self=BASE:Inherit(self,CONTROLLABLE:New(GroupName))
self.GroupName=GroupName
if not _DATABASE.GROUPS[GroupName]then
_DATABASE.GROUPS[GroupName]=self
end
self:SetEventPriority(4)
return self
end
function GROUP:Register(GroupName)
local self=BASE:Inherit(self,CONTROLLABLE:New(GroupName))
self.GroupName=GroupName
self:SetEventPriority(4)
return self
end
function GROUP:Find(DCSGroup)
local GroupName=DCSGroup:getName()
local GroupFound=_DATABASE:FindGroup(GroupName)
return GroupFound
end
function GROUP:FindByName(GroupName)
local GroupFound=_DATABASE:FindGroup(GroupName)
return GroupFound
end
function GROUP:FindByMatching(Pattern)
local GroupFound=nil
for name,group in pairs(_DATABASE.GROUPS)do
if string.match(name,Pattern)then
GroupFound=group
break
end
end
return GroupFound
end
function GROUP:FindAllByMatching(Pattern)
local GroupsFound={}
for name,group in pairs(_DATABASE.GROUPS)do
if string.match(name,Pattern)then
GroupsFound[#GroupsFound+1]=group
end
end
return GroupsFound
end
function GROUP:GetDCSObject()
local DCSGroup=Group.getByName(self.GroupName)
if DCSGroup then
self.LastCallDCSObject=timer.getTime()
self.DCSObject=DCSGroup
return DCSGroup
end
return nil
end
function GROUP:GetPositionVec3()
local DCSPositionable=self:GetDCSObject()
if DCSPositionable then
local unit=DCSPositionable:getUnits()[1]
if unit then
local PositionablePosition=unit:getPosition().p
return PositionablePosition
end
end
return nil
end
function GROUP:IsAlive()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
if DCSGroup:isExist()then
local DCSUnit=DCSGroup:getUnit(1)
if DCSUnit then
local GroupIsAlive=DCSUnit:isActive()
return GroupIsAlive
end
end
end
return nil
end
function GROUP:IsActive()
local DCSGroup=self:GetDCSObject()
if DCSGroup and DCSGroup:isExist()then
local unit=DCSGroup:getUnit(1)
if unit then
local GroupIsActive=unit:isActive()
return GroupIsActive
end
end
return nil
end
function GROUP:Destroy(GenerateEvent,delay)
if delay and delay>0 then
self:ScheduleOnce(delay,GROUP.Destroy,self,GenerateEvent)
else
local DCSGroup=Group.getByName(self.GroupName)
if DCSGroup then
for Index,UnitData in pairs(DCSGroup:getUnits())do
if GenerateEvent and GenerateEvent==true then
if self:IsAir()then
self:CreateEventCrash(timer.getTime(),UnitData)
else
self:CreateEventDead(timer.getTime(),UnitData)
end
elseif GenerateEvent==false then
else
self:CreateEventRemoveUnit(timer.getTime(),UnitData)
end
end
USERFLAG:New(self:GetName()):Set(100)
DCSGroup:destroy()
DCSGroup=nil
end
end
return nil
end
function GROUP:GetCategory()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCategory=DCSGroup:getCategory()
return GroupCategory
end
return nil
end
function GROUP:GetCategoryName()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local CategoryNames={
[Group.Category.AIRPLANE]="Airplane",
[Group.Category.HELICOPTER]="Helicopter",
[Group.Category.GROUND]="Ground Unit",
[Group.Category.SHIP]="Ship",
[Group.Category.TRAIN]="Train",
}
local GroupCategory=DCSGroup:getCategory()
return CategoryNames[GroupCategory]
end
return nil
end
function GROUP:GetCoalition()
if self.GroupCoalition~=nil then
return self.GroupCoalition
else
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCoalition=DCSGroup:getCoalition()
self.GroupCoalition=GroupCoalition
return GroupCoalition
end
end
return nil
end
function GROUP:GetCountry()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCountry=DCSGroup:getUnit(1):getCountry()
return GroupCountry
end
return nil
end
function GROUP:HasAttribute(attribute,all)
local _units=self:GetUnits()
if _units then
local _allhave=true
local _onehas=false
for _,_unit in pairs(_units)do
local _unit=_unit
if _unit then
local _hastit=_unit:HasAttribute(attribute)
if _hastit==true then
_onehas=true
else
_allhave=false
end
end
end
if all==true then
return _allhave
else
return _onehas
end
end
return nil
end
function GROUP:GetSpeedMax()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local Units=self:GetUnits()
local speedmax=nil
for _,unit in pairs(Units)do
local unit=unit
local speed=unit:GetSpeedMax()
if speedmax==nil or speed<speedmax then
speedmax=speed
end
end
return speedmax
end
return nil
end
function GROUP:GetRange()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local Units=self:GetUnits()
local Rangemin=nil
for _,unit in pairs(Units)do
local unit=unit
local range=unit:GetRange()
if range then
if Rangemin==nil then
Rangemin=range
elseif range<Rangemin then
Rangemin=range
end
end
end
return Rangemin
end
return nil
end
function GROUP:GetUnits()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local DCSUnits=DCSGroup:getUnits()or{}
local Units={}
for Index,UnitData in pairs(DCSUnits)do
local unit=UNIT:Find(UnitData)
if unit then
Units[#Units+1]=UNIT:Find(UnitData)
else
local UnitName=UnitData:getName()
unit=_DATABASE:AddUnit(UnitName)
Units[#Units+1]=unit
end
end
return Units
end
return nil
end
function GROUP:GetPlayerUnits()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local DCSUnits=DCSGroup:getUnits()
local Units={}
for Index,UnitData in pairs(DCSUnits)do
local PlayerUnit=UNIT:Find(UnitData)
if PlayerUnit:GetPlayerName()then
Units[#Units+1]=PlayerUnit
end
end
return Units
end
return nil
end
function GROUP:IsPlayer()
local unit=self:GetUnit(1)
if unit then
return unit:IsPlayer()
end
return false
end
function GROUP:GetUnit(UnitNumber)
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local UnitFound=nil
local units=DCSGroup:getUnits()or{}
if units[UnitNumber]then
local UnitFound=UNIT:Find(units[UnitNumber])
if UnitFound then
return UnitFound
end
else
for _,_unit in pairs(units)do
local UnitFound=UNIT:Find(_unit)
if UnitFound then
return UnitFound
end
end
end
end
return nil
end
function GROUP:GetDCSUnit(UnitNumber)
local DCSGroup=self:GetDCSObject()
if DCSGroup then
if DCSGroup.getUnit and DCSGroup:getUnit(UnitNumber)then
return DCSGroup:getUnit(UnitNumber)
else
local units=DCSGroup:getUnits()or{}
for _,_unit in pairs(units)do
if _unit and _unit:isExist()then
return _unit
end
end
end
end
return nil
end
function GROUP:GetSize()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupSize=DCSGroup:getSize()
if GroupSize then
return GroupSize
else
return 0
end
end
return nil
end
function GROUP:CountAliveUnits()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local units=self:GetUnits()
local n=0
for _,_unit in pairs(units)do
local unit=_unit
if unit and unit:IsAlive()then
n=n+1
end
end
return n
end
return 0
end
function GROUP:GetFirstUnitAlive()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local units=self:GetUnits()
for _,_unit in pairs(units)do
local unit=_unit
if unit and unit:IsAlive()then
return unit
end
end
end
return nil
end
function GROUP:GetFirstUnit()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local units=self:GetUnits()
return units[1]
end
return nil
end
function GROUP:GetVelocityVec3()
local DCSGroup=self:GetDCSObject()
if DCSGroup and DCSGroup:isExist()then
local GroupUnits=DCSGroup:getUnits()
local GroupCount=#GroupUnits
local VelocityVec3={x=0,y=0,z=0}
for _,DCSUnit in pairs(GroupUnits)do
local UnitVelocityVec3=DCSUnit:getVelocity()
VelocityVec3.x=VelocityVec3.x+UnitVelocityVec3.x
VelocityVec3.y=VelocityVec3.y+UnitVelocityVec3.y
VelocityVec3.z=VelocityVec3.z+UnitVelocityVec3.z
end
VelocityVec3.x=VelocityVec3.x/GroupCount
VelocityVec3.y=VelocityVec3.y/GroupCount
VelocityVec3.z=VelocityVec3.z/GroupCount
return VelocityVec3
end
BASE:E({"Cannot GetVelocityVec3",Group=self,Alive=self:IsAlive()})
return nil
end
function GROUP:GetAltitude(FromGround)
return self:GetHeight(FromGround)
end
function GROUP:GetHeight(FromGround)
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupUnits=DCSGroup:getUnits()
local GroupCount=#GroupUnits
local GroupHeight=0
for _,DCSUnit in pairs(GroupUnits)do
local GroupPosition=DCSUnit:getPosition()
if FromGround==true then
local LandHeight=land.getHeight({x=GroupPosition.p.x,y=GroupPosition.p.z})
GroupHeight=GroupHeight+(GroupPosition.p.y-LandHeight)
else
GroupHeight=GroupHeight+GroupPosition.p.y
end
end
return GroupHeight/GroupCount
end
return nil
end
function GROUP:GetInitialSize()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupInitialSize=DCSGroup:getInitialSize()
return GroupInitialSize
end
return nil
end
function GROUP:GetDCSUnits()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local DCSUnits=DCSGroup:getUnits()
return DCSUnits
end
return nil
end
function GROUP:Activate(delay)
if delay and delay>0 then
self:ScheduleOnce(delay,GROUP.Activate,self)
else
trigger.action.activateGroup(self:GetDCSObject())
end
return self
end
function GROUP:Deactivate(delay)
if delay and delay>0 then
self:ScheduleOnce(delay,GROUP.Deactivate,self)
else
trigger.action.deactivateGroup(self:GetDCSObject())
end
return self
end
function GROUP:GetTypeName()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupTypeName=DCSGroup:getUnit(1):getTypeName()
return(GroupTypeName)
end
return nil
end
function GROUP:GetNatoReportingName()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupTypeName=DCSGroup:getUnit(1):getTypeName()
return UTILS.GetReportingName(GroupTypeName)
end
return"Bogey"
end
function GROUP:GetPlayerName()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local PlayerName=DCSGroup:getUnit(1):getPlayerName()
return(PlayerName)
end
return nil
end
function GROUP:GetCallsign()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCallSign=DCSGroup:getUnit(1):getCallsign()
return GroupCallSign
end
BASE:E({"Cannot GetCallsign",Positionable=self,Alive=self:IsAlive()})
return nil
end
function GROUP:GetVec2()
local Unit=self:GetUnit(1)
if Unit then
local vec2=Unit:GetVec2()
return vec2
end
end
function GROUP:GetVec3()
local unit=self:GetUnit(1)
if unit then
local vec3=unit:GetVec3()
return vec3
end
self:E("ERROR: Cannot get Vec3 of group "..tostring(self.GroupName))
return nil
end
function GROUP:GetAverageVec3()
local units=self:GetUnits()or{}
local x=0;local y=0;local z=0;local n=0
for _,unit in pairs(units)do
local vec3=nil
if unit and unit:IsAlive()then
vec3=unit:GetVec3()
end
if vec3 then
x=x+vec3.x
y=y+vec3.y
z=z+vec3.z
n=n+1
end
end
if n>0 then
local Vec3={x=x/n,y=y/n,z=z/n}
return Vec3
else
return self:GetVec3()
end
end
function GROUP:GetPointVec2()
local FirstUnit=self:GetUnit(1)
if FirstUnit then
local FirstUnitPointVec2=FirstUnit:GetPointVec2()
return FirstUnitPointVec2
end
BASE:E({"Cannot get COORDINATE",Group=self,Alive=self:IsAlive()})
return nil
end
function GROUP:GetAverageCoordinate()
local vec3=self:GetAverageVec3()
if vec3 then
local coord=COORDINATE:NewFromVec3(vec3)
local Heading=self:GetHeading()
coord.Heading=Heading
return coord
else
local coord=self:GetCoordinate()
if coord then
return coord
else
BASE:E({"Cannot GetAverageCoordinate",Group=self,Alive=self:IsAlive()})
return nil
end
end
end
function GROUP:GetCoordinate()
local vec3=self:GetVec3()
local coord
if vec3 then
coord=COORDINATE:NewFromVec3(vec3)
coord.Heading=self:GetHeading()or 0
return coord
end
local Units=self:GetUnits()or{}
for _,_unit in pairs(Units)do
local FirstUnit=_unit
if FirstUnit and FirstUnit:IsAlive()then
local FirstUnitCoordinate=FirstUnit:GetCoordinate()
if FirstUnitCoordinate then
local Heading=self:GetHeading()or 0
FirstUnitCoordinate.Heading=Heading
return FirstUnitCoordinate
end
end
end
local DCSGroup=Group.getByName(self.GroupName)
if DCSGroup then
local DCSUnits=DCSGroup:getUnits()or{}
for _,_unit in pairs(DCSUnits)do
if Object.isExist(_unit)then
local position=_unit:getPosition()
local point=position.p~=nil and position.p or _unit:GetPoint()
if point then
local coord=COORDINATE:NewFromVec3(point)
coord.Heading=0
local munit=UNIT:Find(_unit)
if munit then
coord.Heading=munit:GetHeading()or 0
end
return coord
end
end
end
end
BASE:E({"Cannot GetCoordinate",Group=self,Alive=self:IsAlive()})
end
function GROUP:GetRandomVec3(Radius)
local FirstUnit=self:GetUnit(1)
if FirstUnit then
local FirstUnitRandomPointVec3=FirstUnit:GetRandomVec3(Radius)
return FirstUnitRandomPointVec3
end
BASE:E({"Cannot GetRandomVec3",Group=self,Alive=self:IsAlive()})
return nil
end
function GROUP:GetHeading()
local GroupSize=self:GetSize()
local HeadingAccumulator=0
local n=0
local Units=self:GetUnits()
if GroupSize then
for _,unit in pairs(Units)do
if unit and unit:IsAlive()then
HeadingAccumulator=HeadingAccumulator+unit:GetHeading()
n=n+1
end
end
return math.floor(HeadingAccumulator/n)
end
BASE:E({"Cannot GetHeading",Group=self,Alive=self:IsAlive()})
return nil
end
function GROUP:GetFuelMin()
if not self:GetDCSObject()then
BASE:E({"Cannot GetFuel",Group=self,Alive=self:IsAlive()})
return 0
end
local min=65535
local unit=nil
local tmp=nil
for UnitID,UnitData in pairs(self:GetUnits())do
if UnitData and UnitData:IsAlive()then
tmp=UnitData:GetFuel()
if tmp<min then
min=tmp
unit=UnitData
end
end
end
return min,unit
end
function GROUP:GetFuelAvg()
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local GroupSize=self:GetSize()
local TotalFuel=0
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
local UnitFuel=Unit:GetFuel()or 0
TotalFuel=TotalFuel+UnitFuel
end
local GroupFuel=TotalFuel/GroupSize
return GroupFuel
end
BASE:E({"Cannot GetFuel",Group=self,Alive=self:IsAlive()})
return 0
end
function GROUP:GetFuel()
return self:GetFuelAvg()
end
function GROUP:GetAmmunition()
local DCSControllable=self:GetDCSObject()
local Ntot=0
local Nshells=0
local Nrockets=0
local Nmissiles=0
local Nbombs=0
local Narti=0
if DCSControllable then
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
local ntot,nshells,nrockets,nbombs,nmissiles,narti=Unit:GetAmmunition()
Ntot=Ntot+ntot
Nshells=Nshells+nshells
Nrockets=Nrockets+nrockets
Nmissiles=Nmissiles+nmissiles
Nbombs=Nbombs+nbombs
Narti=Narti+narti
end
end
return Ntot,Nshells,Nrockets,Nbombs,Nmissiles,Narti
end
do
function GROUP:IsInZone(Zone)
if self:IsAlive()then
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
local vec2=nil
if Unit then
vec2=Unit:GetVec2()
end
if vec2 and Zone:IsVec2InZone(vec2)then
return true
end
end
return false
end
return nil
end
function GROUP:IsCompletelyInZone(Zone)
if not self:IsAlive()then return false end
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
if Zone:IsVec3InZone(Unit:GetVec3())then
else
return false
end
end
return true
end
function GROUP:IsPartlyInZone(Zone)
local IsOneUnitInZone=false
local IsOneUnitOutsideZone=false
if not self:IsAlive()then return false end
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
if Zone:IsVec3InZone(Unit:GetVec3())then
IsOneUnitInZone=true
else
IsOneUnitOutsideZone=true
end
end
if IsOneUnitInZone and IsOneUnitOutsideZone then
return true
else
return false
end
end
function GROUP:IsPartlyOrCompletelyInZone(Zone)
return self:IsPartlyInZone(Zone)or self:IsCompletelyInZone(Zone)
end
function GROUP:IsNotInZone(Zone)
if not self:IsAlive()then return true end
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
if Zone:IsVec3InZone(Unit:GetVec3())then
return false
end
end
return true
end
function GROUP:IsAnyInZone(Zone)
if not self:IsAlive()then return false end
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
if Zone:IsVec3InZone(Unit:GetVec3())then
return true
end
end
return false
end
function GROUP:CountInZone(Zone)
local Count=0
if not self:IsAlive()then return Count end
for UnitID,UnitData in pairs(self:GetUnits())do
local Unit=UnitData
if Zone:IsVec3InZone(Unit:GetVec3())then
Count=Count+1
end
end
return Count
end
function GROUP:IsAir()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local IsAirResult=DCSGroup:getCategory()==Group.Category.AIRPLANE or DCSGroup:getCategory()==Group.Category.HELICOPTER
return IsAirResult
end
return nil
end
function GROUP:IsHelicopter()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCategory=DCSGroup:getCategory()
return GroupCategory==Group.Category.HELICOPTER
end
return nil
end
function GROUP:IsAirPlane()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCategory=DCSGroup:getCategory()
return GroupCategory==Group.Category.AIRPLANE
end
return nil
end
function GROUP:IsGround()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCategory=DCSGroup:getCategory()
return GroupCategory==Group.Category.GROUND
end
return nil
end
function GROUP:IsShip()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupCategory=DCSGroup:getCategory()
return GroupCategory==Group.Category.SHIP
end
return nil
end
function GROUP:AllOnGround()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local AllOnGroundResult=true
for Index,UnitData in pairs(DCSGroup:getUnits())do
if UnitData:inAir()then
AllOnGroundResult=false
end
end
return AllOnGroundResult
end
return nil
end
end
do
function GROUP:SetAIOnOff(AIOnOff)
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local DCSController=DCSGroup:getController()
if DCSController then
DCSController:setOnOff(AIOnOff)
return self
end
end
return nil
end
function GROUP:SetAIOn()
return self:SetAIOnOff(true)
end
function GROUP:SetAIOff()
return self:SetAIOnOff(false)
end
end
function GROUP:GetMaxVelocity()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupVelocityMax=0
for Index,UnitData in pairs(DCSGroup:getUnits())do
local UnitVelocityVec3=UnitData:getVelocity()
local UnitVelocity=math.abs(UnitVelocityVec3.x)+math.abs(UnitVelocityVec3.y)+math.abs(UnitVelocityVec3.z)
if UnitVelocity>GroupVelocityMax then
GroupVelocityMax=UnitVelocity
end
end
return GroupVelocityMax
end
return nil
end
function GROUP:GetMinHeight()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupHeightMin=999999999
for Index,UnitData in pairs(DCSGroup:getUnits())do
local UnitData=UnitData
local UnitHeight=UnitData:getPoint()
if UnitHeight<GroupHeightMin then
GroupHeightMin=UnitHeight
end
end
return GroupHeightMin
end
return nil
end
function GROUP:GetMaxHeight()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local GroupHeightMax=-999999999
for Index,UnitData in pairs(DCSGroup:getUnits())do
local UnitData=UnitData
local UnitHeight=UnitData:getPoint().p.y
if UnitHeight>GroupHeightMax then
GroupHeightMax=UnitHeight
end
end
return GroupHeightMax
end
return nil
end
function GROUP:GetTemplate()
local GroupName=self:GetName()
local template=_DATABASE:GetGroupTemplate(GroupName)
if template then
return UTILS.DeepCopy(template)
end
return nil
end
function GROUP:GetTemplateRoutePoints()
local GroupName=self:GetName()
local template=_DATABASE:GetGroupTemplate(GroupName)
if template and template.route and template.route.points then
return UTILS.DeepCopy(template.route.points)
end
end
function GROUP:SetTemplateControlled(Template,Controlled)
Template.uncontrolled=not Controlled
return Template
end
function GROUP:SetTemplateCountry(Template,CountryID)
Template.CountryID=CountryID
return Template
end
function GROUP:SetTemplateCoalition(Template,CoalitionID)
Template.CoalitionID=CoalitionID
return Template
end
function GROUP:InitHeading(Heading)
self.InitRespawnHeading=Heading
return self
end
function GROUP:InitHeight(Height)
self.InitRespawnHeight=Height
return self
end
function GROUP:InitZone(Zone)
self.InitRespawnZone=Zone
return self
end
function GROUP:InitRandomizePositionZone(PositionZone)
self.InitRespawnRandomizePositionZone=PositionZone
self.InitRespawnRandomizePositionInner=nil
self.InitRespawnRandomizePositionOuter=nil
return self
end
function GROUP:InitRandomizePositionRadius(OuterRadius,InnerRadius)
self.InitRespawnRandomizePositionZone=nil
self.InitRespawnRandomizePositionOuter=OuterRadius
self.InitRespawnRandomizePositionInner=InnerRadius
return self
end
function GROUP:InitCoordinate(coordinate)
self.InitCoord=coordinate
return self
end
function GROUP:InitRadioCommsOnOff(switch)
if switch==true or switch==nil then
self.InitRespawnRadio=true
else
self.InitRespawnRadio=false
end
return self
end
function GROUP:InitRadioFrequency(frequency)
self.InitRespawnFreq=frequency
return self
end
function GROUP:InitRadioModulation(modulation)
if modulation and modulation:lower()=="fm"then
self.InitRespawnModu=radio.modulation.FM
else
self.InitRespawnModu=radio.modulation.AM
end
return self
end
function GROUP:InitModex(modex)
if modex then
self.InitRespawnModex=tonumber(modex)
end
return self
end
function GROUP:Respawn(Template,Reset)
Template=Template or self:GetTemplate()
local function _Heading(course)
local h
if course<=180 then
h=math.rad(course)
else
h=-math.rad(360-course)
end
return h
end
local function TransFormRoute(Template,OldPos,NewPos)
if Template.route and Template.route.points then
for _,_point in ipairs(Template.route.points)do
_point.x=_point.x-OldPos.x+NewPos.x
_point.y=_point.y-OldPos.y+NewPos.y
end
end
return Template
end
if self:IsAlive()then
local OldPos=self:GetVec2()
local Zone=self.InitRespawnZone
local Vec3=Zone and Zone:GetVec3()or self:GetVec3()
local From={x=Template.x,y=Template.y}
Template.x=Vec3.x
Template.y=Vec3.z
local NewPos={x=Vec3.x,y=Vec3.z}
if Reset==true then
for UnitID,UnitData in pairs(self:GetUnits())do
local GroupUnit=UnitData
if GroupUnit:IsAlive()then
local GroupUnitVec3=GroupUnit:GetVec3()
if Zone then
if self.InitRespawnRandomizePositionZone then
GroupUnitVec3=Zone:GetRandomVec3()
else
if self.InitRespawnRandomizePositionInner and self.InitRespawnRandomizePositionOuter then
GroupUnitVec3=COORDINATE:NewFromVec3(From):GetRandomVec3InRadius(self.InitRespawnRandomizePositionsOuter,self.InitRespawnRandomizePositionsInner)
else
GroupUnitVec3=Zone:GetVec3()
end
end
end
if self.InitCoord then
GroupUnitVec3=self.InitCoord:GetVec3()
end
Template.units[UnitID].alt=self.InitRespawnHeight and self.InitRespawnHeight or GroupUnitVec3.y
if Zone then
Template.units[UnitID].x=(Template.units[UnitID].x-From.x)+GroupUnitVec3.x
Template.units[UnitID].y=(Template.units[UnitID].y-From.y)+GroupUnitVec3.z
else
Template.units[UnitID].x=GroupUnitVec3.x
Template.units[UnitID].y=GroupUnitVec3.z
end
Template.units[UnitID].heading=_Heading(self.InitRespawnHeading and self.InitRespawnHeading or GroupUnit:GetHeading())
Template.units[UnitID].psi=-Template.units[UnitID].heading
end
end
Template=TransFormRoute(Template,OldPos,NewPos)
elseif Reset==false then
for UnitID,TemplateUnitData in pairs(Template.units)do
local GroupUnitVec3={x=TemplateUnitData.x,y=TemplateUnitData.alt,z=TemplateUnitData.y}
if Zone then
if self.InitRespawnRandomizePositionZone then
GroupUnitVec3=Zone:GetRandomVec3()
else
if self.InitRespawnRandomizePositionInner and self.InitRespawnRandomizePositionOuter then
GroupUnitVec3=COORDINATE:NewFromVec2(From):GetRandomPointVec3InRadius(self.InitRespawnRandomizePositionsOuter,self.InitRespawnRandomizePositionsInner)
else
GroupUnitVec3=Zone:GetVec3()
end
end
end
if self.InitCoord then
GroupUnitVec3=self.InitCoord:GetVec3()
end
Template.units[UnitID].alt=self.InitRespawnHeight and self.InitRespawnHeight or GroupUnitVec3.y
Template.units[UnitID].x=(Template.units[UnitID].x-From.x)+GroupUnitVec3.x
Template.units[UnitID].y=(Template.units[UnitID].y-From.y)+GroupUnitVec3.z
Template.units[UnitID].heading=self.InitRespawnHeading and self.InitRespawnHeading or TemplateUnitData.heading
end
Template=TransFormRoute(Template,OldPos,NewPos)
else
local units=self:GetUnits()
for UnitID,Unit in pairs(Template.units)do
for _,_unit in pairs(units)do
local unit=_unit
if unit:GetName()==Unit.name then
local coord=unit:GetCoordinate()
local heading=unit:GetHeading()
Unit.x=coord.x
Unit.y=coord.z
Unit.alt=coord.y
Unit.heading=math.rad(heading)
Unit.psi=-Unit.heading
end
end
end
end
end
if self.InitRespawnModex then
for UnitID=1,#Template.units do
Template.units[UnitID].onboard_num=string.format("%03d",self.InitRespawnModex+(UnitID-1))
end
end
if self.InitRespawnRadio then
Template.communication=self.InitRespawnRadio
end
if self.InitRespawnFreq then
Template.frequency=self.InitRespawnFreq
end
if self.InitRespawnModu then
Template.modulation=self.InitRespawnModu
end
self:Destroy(false)
self:ScheduleOnce(0.1,_DATABASE.Spawn,_DATABASE,Template)
self:ResetEvents()
return self
end
function GROUP:Teleport(Coordinate)
self:InitZone(Coordinate)
return self:Respawn(nil,false)
end
function GROUP:RespawnAtCurrentAirbase(SpawnTemplate,Takeoff,Uncontrolled)
if self and self:IsAlive()then
local airbase=self:GetCoordinate():GetClosestAirbase()
if airbase then
else
self:E("ERROR: could not find closest airbase!")
return nil
end
Takeoff=Takeoff or SPAWN.Takeoff.Hot
local AirbaseCoord=airbase:GetCoordinate()
SpawnTemplate=SpawnTemplate or self:GetTemplate()
if SpawnTemplate then
local SpawnPoint=SpawnTemplate.route.points[1]
SpawnPoint.linkUnit=nil
SpawnPoint.helipadId=nil
SpawnPoint.airdromeId=nil
local AirbaseID=airbase:GetID()
local AirbaseCategory=airbase:GetAirbaseCategory()
if AirbaseCategory==Airbase.Category.SHIP or AirbaseCategory==Airbase.Category.HELIPAD then
SpawnPoint.linkUnit=AirbaseID
SpawnPoint.helipadId=AirbaseID
elseif AirbaseCategory==Airbase.Category.AIRDROME then
SpawnPoint.airdromeId=AirbaseID
end
SpawnPoint.type=GROUPTEMPLATE.Takeoff[Takeoff][1]
SpawnPoint.action=GROUPTEMPLATE.Takeoff[Takeoff][2]
local units=self:GetUnits()
local x
local y
for UnitID=1,#units do
local unit=units[UnitID]
local Parkingspot,TermialID,Distance=unit:GetCoordinate():GetClosestParkingSpot(airbase)
local uc=unit:GetCoordinate()
SpawnTemplate.units[UnitID].x=uc.x
SpawnTemplate.units[UnitID].y=uc.z
SpawnTemplate.units[UnitID].alt=uc.y
SpawnTemplate.units[UnitID].parking=TermialID
SpawnTemplate.units[UnitID].parking_id=nil
end
SpawnPoint.x=SpawnTemplate.units[1].x
SpawnPoint.y=SpawnTemplate.units[1].y
SpawnPoint.alt=SpawnTemplate.units[1].alt
SpawnTemplate.x=SpawnTemplate.units[1].x
SpawnTemplate.y=SpawnTemplate.units[1].y
SpawnTemplate.uncontrolled=Uncontrolled
if self.InitRespawnRadio then
SpawnTemplate.communication=self.InitRespawnRadio
end
if self.InitRespawnFreq then
SpawnTemplate.frequency=self.InitRespawnFreq
end
if self.InitRespawnModu then
SpawnTemplate.modulation=self.InitRespawnModu
end
self:Destroy(false)
_DATABASE:Spawn(SpawnTemplate)
self:ResetEvents()
return self
end
else
self:E("WARNING: GROUP is not alive!")
end
return nil
end
function GROUP:GetTaskMission()
return UTILS.DeepCopy(_DATABASE.Templates.Groups[self.GroupName].Template)
end
function GROUP:GetTaskRoute()
if _DATABASE.Templates.Groups[self.GroupName].Template and _DATABASE.Templates.Groups[self.GroupName].Template.route and _DATABASE.Templates.Groups[self.GroupName].Template.route.points then
return UTILS.DeepCopy(_DATABASE.Templates.Groups[self.GroupName].Template.route.points)
else
return{}
end
end
function GROUP:CopyRoute(Begin,End,Randomize,Radius)
local Points={}
local GroupName=string.match(self:GetName(),".*#")
if GroupName then
GroupName=GroupName:sub(1,-2)
else
GroupName=self:GetName()
end
local Template=_DATABASE.Templates.Groups[GroupName].Template
if Template then
if not Begin then
Begin=0
end
if not End then
End=0
end
for TPointID=Begin+1,#Template.route.points-End do
if Template.route.points[TPointID]then
Points[#Points+1]=UTILS.DeepCopy(Template.route.points[TPointID])
if Randomize then
if not Radius then
Radius=500
end
Points[#Points].x=Points[#Points].x+math.random(Radius*-1,Radius)
Points[#Points].y=Points[#Points].y+math.random(Radius*-1,Radius)
end
end
end
return Points
else
error("Template not found for Group : "..GroupName)
end
return nil
end
function GROUP:CalculateThreatLevelA2G()
local MaxThreatLevelA2G=0
for UnitName,UnitData in pairs(self:GetUnits())do
local ThreatUnit=UnitData
local ThreatLevelA2G=ThreatUnit:GetThreatLevel()
if ThreatLevelA2G>MaxThreatLevelA2G then
MaxThreatLevelA2G=ThreatLevelA2G
end
end
return MaxThreatLevelA2G
end
function GROUP:GetThreatLevel()
local threatlevelMax=0
for UnitName,UnitData in pairs(self:GetUnits())do
local ThreatUnit=UnitData
local threatlevel=ThreatUnit:GetThreatLevel()
if threatlevel>threatlevelMax then
threatlevelMax=threatlevel
end
end
return threatlevelMax
end
function GROUP:InAir()
local DCSGroup=self:GetDCSObject()
if DCSGroup then
local DCSUnit=DCSGroup:getUnit(1)
if DCSUnit then
local GroupInAir=DCSGroup:getUnit(1):inAir()
return GroupInAir
end
end
return nil
end
function GROUP:IsAirborne(AllUnits)
local units=self:GetUnits()
if units then
if AllUnits then
for _,_unit in pairs(units)do
local unit=_unit
if unit then
local inair=unit:InAir()
if not inair then
return false
end
end
end
return true
else
for _,_unit in pairs(units)do
local unit=_unit
if unit then
local inair=unit:InAir()
if inair then
return true
end
end
return false
end
end
end
return nil
end
function GROUP:GetDCSDesc(n)
n=n or 1
local unit=self:GetUnit(n)
if unit and unit:IsAlive()~=nil then
local desc=unit:GetDesc()
return desc
end
return nil
end
function GROUP:GetAttribute()
local attribute=GROUP.Attribute.OTHER_UNKNOWN
if self then
local transportplane=self:HasAttribute("Transports")and self:HasAttribute("Planes")
local awacs=self:HasAttribute("AWACS")
local fighter=self:HasAttribute("Fighters")or self:HasAttribute("Interceptors")or self:HasAttribute("Multirole fighters")or(self:HasAttribute("Bombers")and not self:HasAttribute("Strategic bombers"))
local bomber=self:HasAttribute("Strategic bombers")
local tanker=self:HasAttribute("Tankers")
local uav=self:HasAttribute("UAVs")
local transporthelo=self:HasAttribute("Transport helicopters")
local attackhelicopter=self:HasAttribute("Attack helicopters")
local apc=self:HasAttribute("APC")
local truck=self:HasAttribute("Trucks")and self:GetCategory()==Group.Category.GROUND
local infantry=self:HasAttribute("Infantry")
local artillery=self:HasAttribute("Artillery")
local tank=self:HasAttribute("Old Tanks")or self:HasAttribute("Modern Tanks")or self:HasAttribute("Tanks")
local aaa=self:HasAttribute("AAA")and(not self:HasAttribute("SAM elements"))
local ewr=self:HasAttribute("EWR")
local ifv=self:HasAttribute("IFV")
local sam=self:HasAttribute("SAM elements")or self:HasAttribute("Optical Tracker")
local train=self:GetCategory()==Group.Category.TRAIN
local aircraftcarrier=self:HasAttribute("Aircraft Carriers")
local warship=self:HasAttribute("Heavy armed ships")
local armedship=self:HasAttribute("Armed ships")
local unarmedship=self:HasAttribute("Unarmed ships")
if fighter then
attribute=GROUP.Attribute.AIR_FIGHTER
elseif bomber then
attribute=GROUP.Attribute.AIR_BOMBER
elseif awacs then
attribute=GROUP.Attribute.AIR_AWACS
elseif transportplane then
attribute=GROUP.Attribute.AIR_TRANSPORTPLANE
elseif tanker then
attribute=GROUP.Attribute.AIR_TANKER
elseif attackhelicopter then
attribute=GROUP.Attribute.AIR_ATTACKHELO
elseif transporthelo then
attribute=GROUP.Attribute.AIR_TRANSPORTHELO
elseif uav then
attribute=GROUP.Attribute.AIR_UAV
elseif ewr then
attribute=GROUP.Attribute.GROUND_EWR
elseif sam then
attribute=GROUP.Attribute.GROUND_SAM
elseif aaa then
attribute=GROUP.Attribute.GROUND_AAA
elseif artillery then
attribute=GROUP.Attribute.GROUND_ARTILLERY
elseif tank then
attribute=GROUP.Attribute.GROUND_TANK
elseif ifv then
attribute=GROUP.Attribute.GROUND_IFV
elseif apc then
attribute=GROUP.Attribute.GROUND_APC
elseif infantry then
attribute=GROUP.Attribute.GROUND_INFANTRY
elseif truck then
attribute=GROUP.Attribute.GROUND_TRUCK
elseif train then
attribute=GROUP.Attribute.GROUND_TRAIN
elseif aircraftcarrier then
attribute=GROUP.Attribute.NAVAL_AIRCRAFTCARRIER
elseif warship then
attribute=GROUP.Attribute.NAVAL_WARSHIP
elseif armedship then
attribute=GROUP.Attribute.NAVAL_ARMEDSHIP
elseif unarmedship then
attribute=GROUP.Attribute.NAVAL_UNARMEDSHIP
else
if self:IsGround()then
attribute=GROUP.Attribute.GROUND_OTHER
elseif self:IsShip()then
attribute=GROUP.Attribute.NAVAL_OTHER
elseif self:IsAir()then
attribute=GROUP.Attribute.AIR_OTHER
else
attribute=GROUP.Attribute.OTHER_UNKNOWN
end
end
end
return attribute
end
do
function GROUP:RouteRTB(RTBAirbase,Speed)
local DCSGroup=self:GetDCSObject()
if DCSGroup then
if RTBAirbase then
local Speed=Speed or self:GetSpeedMax()*0.8
local coord=self:GetCoordinate()
local PointFrom=coord:WaypointAirTurningPoint(nil,Speed)
local PointLanding=RTBAirbase:GetCoordinate():WaypointAirLanding(Speed,RTBAirbase)
local Points={PointFrom,PointLanding}
local Template=self:GetTemplate()
Template.route.points=Points
self:Respawn(Template,true)
self:Route(Points)
else
self:ClearTasks()
end
end
return self
end
end
function GROUP:OnReSpawn(ReSpawnFunction)
self.ReSpawnFunction=ReSpawnFunction
end
do
function GROUP:HandleEvent(Event,EventFunction,...)
self:EventDispatcher():OnEventForGroup(self:GetName(),EventFunction,self,Event,...)
return self
end
function GROUP:UnHandleEvent(Event)
self:EventDispatcher():RemoveEvent(self,Event)
return self
end
function GROUP:ResetEvents()
self:EventDispatcher():Reset(self)
for UnitID,UnitData in pairs(self:GetUnits()or{})do
UnitData:ResetEvents()
end
return self
end
end
do
function GROUP:GetPlayerNames()
local HasPlayers=false
local PlayerNames={}
local Units=self:GetUnits()
for UnitID,UnitData in pairs(Units or{})do
local Unit=UnitData
local PlayerName=Unit:GetPlayerName()
if PlayerName and PlayerName~=""then
PlayerNames=PlayerNames or{}
table.insert(PlayerNames,PlayerName)
HasPlayers=true
end
end
if HasPlayers==true then
return PlayerNames
end
return nil
end
function GROUP:GetPlayerCount()
local PlayerCount=0
local Units=self:GetUnits()
for UnitID,UnitData in pairs(Units or{})do
local Unit=UnitData
local PlayerName=Unit:GetPlayerName()
if PlayerName and PlayerName~=""then
PlayerCount=PlayerCount+1
end
end
return PlayerCount
end
end
function GROUP:EnableEmission(switch)
local switch=switch or false
local DCSUnit=self:GetDCSObject()
if DCSUnit then
DCSUnit:enableEmission(switch)
end
return self
end
function GROUP:SetCommandInvisible(switch)
return self:CommandSetInvisible(switch)
end
function GROUP:CommandSetInvisible(switch)
if switch==nil then
switch=false
end
local SetInvisible={id='SetInvisible',params={value=switch}}
self:SetCommand(SetInvisible)
return self
end
function GROUP:SetCommandImmortal(switch)
return self:CommandSetImmortal(switch)
end
function GROUP:CommandSetImmortal(switch)
if switch==nil then
switch=false
end
local SetImmortal={id='SetImmortal',params={value=switch}}
self:SetCommand(SetImmortal)
return self
end
function GROUP:GetSkill()
local unit=self:GetUnit(1)
local name=unit:GetName()
local skill=_DATABASE.Templates.Units[name].Template.skill or"Random"
return skill
end
function GROUP:GetHighestThreat()
local units=self:GetUnits()
if units then
local threat=nil;local maxtl=0
for _,_unit in pairs(units or{})do
local unit=_unit
if unit and unit:IsAlive()then
local tl=unit:GetThreatLevel()
if tl>maxtl then
maxtl=tl
threat=unit
end
end
end
return threat,maxtl
end
return nil,nil
end
function GROUP:GetCustomCallSign(ShortCallsign,Keepnumber,CallsignTranslations,CustomFunction,...)
self:T("GetCustomCallSign")
local callsign="Ghost 1"
if self:IsAlive()then
local IsPlayer=self:IsPlayer()
local shortcallsign=self:GetCallsign()or"unknown91"
local callsignroot=string.match(shortcallsign,'(%a+)')or"Ghost"
local groupname=self:GetName()
local callnumber=string.match(shortcallsign,"(%d+)$")or"91"
local callnumbermajor=string.char(string.byte(callnumber,1))
local callnumberminor=string.char(string.byte(callnumber,2))
local personalized=false
local playername=shortcallsign
if IsPlayer then playername=self:GetPlayerName()end
self:T2("GetCustomCallSign outcome = "..playername)
if CustomFunction and IsPlayer then
local arguments=arg or{}
local callsign=CustomFunction(groupname,playername,unpack(arguments))
return callsign
end
if CallsignTranslations and CallsignTranslations[callsignroot]then
callsignroot=CallsignTranslations[callsignroot]
elseif IsPlayer and string.find(groupname,"#")then
if Keepnumber then
shortcallsign=string.match(groupname,"#(.+)")or"Ghost 111"
else
shortcallsign=string.match(groupname,"#%s*([%a]+)")or"Ghost"
end
personalized=true
elseif IsPlayer and string.find(playername,"|")then
shortcallsign=string.match(playername,"|%s*([%a]+)")or string.match(self:GetPlayerName(),"|%s*([%d]+)")or"Ghost"
personalized=true
end
if personalized then
shortcallsign=string.gsub(shortcallsign,"^%s*","")
shortcallsign=string.gsub(shortcallsign,"%s*$","")
if Keepnumber then
return shortcallsign
elseif ShortCallsign then
callsign=shortcallsign.." "..callnumbermajor
else
callsign=shortcallsign.." "..callnumbermajor.." "..callnumberminor
end
return callsign
end
if ShortCallsign then
callsign=callsignroot.." "..callnumbermajor
else
callsign=callsignroot.." "..callnumbermajor.." "..callnumberminor
end
end
return callsign
end
function GROUP:SetAsRecoveryTanker(CarrierGroup,Speed,ToKIAS,Altitude,Delay,LastWaypoint)
local speed=ToKIAS==true and UTILS.KnotsToAltKIAS(Speed,Altitude)or Speed
speed=UTILS.KnotsToMps(speed)
local alt=UTILS.FeetToMeters(Altitude)
local delay=Delay or 1
local task=self:TaskRecoveryTanker(CarrierGroup,speed,alt,LastWaypoint)
self:SetTask(task,delay)
local tankertask=self:EnRouteTaskTanker()
self:PushTask(tankertask,delay+2)
return self
end
function GROUP:GetGroupSTN()
local tSTN={}
local units=self:GetUnits()
local gname=self:GetName()
gname=string.gsub(gname,"(#%d+)$","")
local report=REPORT:New()
report:Add("Link16 S/TN Report")
report:Add("Group: "..gname)
report:Add("==================")
for _,_unit in pairs(units)do
local unit=_unit
if unit and unit:IsAlive()then
local STN,VCL,VCN,Lead=unit:GetSTN()
local name=unit:GetName()
tSTN[name]={
STN=STN,
VCL=VCL,
VCN=VCN,
Lead=Lead,
}
local lead=Lead==true and"(*)"or""
report:Add(string.format("| %s%s %s %s",tostring(VCL),tostring(VCN),tostring(STN),lead))
end
end
report:Add("==================")
local text=report:Text()
return tSTN,text
end
function GROUP:IsSAM()
local issam=false
local units=self:GetUnits()
for _,_unit in pairs(units or{})do
local unit=_unit
if unit:IsSAM()then
issam=true
break
end
end
return issam
end
function GROUP:IsAAA()
local isAAA=false
local units=self:GetUnits()
for _,_unit in pairs(units or{})do
local unit=_unit
if unit:IsAAA()then
isAAA=true
break
end
end
return isAAA
end
UNIT={
ClassName="UNIT",
UnitName=nil,
GroupName=nil,
DCSUnit=nil,
}
function UNIT:Register(UnitName)
local self=BASE:Inherit(self,CONTROLLABLE:New(UnitName))
self.UnitName=UnitName
local unit=Unit.getByName(self.UnitName)
if unit then
local group=unit:getGroup()
if group then
self.GroupName=group:getName()
self.groupId=group:getID()
end
self.DCSUnit=unit
end
self:SetEventPriority(3)
return self
end
function UNIT:Find(DCSUnit)
if DCSUnit then
local UnitName=DCSUnit:getName()
local UnitFound=_DATABASE:FindUnit(UnitName)
return UnitFound
end
return nil
end
function UNIT:FindByName(UnitName)
local UnitFound=_DATABASE:FindUnit(UnitName)
return UnitFound
end
function UNIT:FindByMatching(Pattern)
local GroupFound=nil
for name,group in pairs(_DATABASE.UNITS)do
if string.match(name,Pattern)then
GroupFound=group
break
end
end
return GroupFound
end
function UNIT:FindAllByMatching(Pattern)
local GroupsFound={}
for name,group in pairs(_DATABASE.UNITS)do
if string.match(name,Pattern)then
GroupsFound[#GroupsFound+1]=group
end
end
return GroupsFound
end
function UNIT:Name()
return self.UnitName
end
function UNIT:GetDCSObject()
if(not self.LastCallDCSObject)or(self.LastCallDCSObject and timer.getTime()-self.LastCallDCSObject>1)or(self.DCSObject==nil)or(self.DCSObject:isExist()==false)then
local DCSUnit=Unit.getByName(self.UnitName)
if DCSUnit then
self.LastCallDCSObject=timer.getTime()
self.DCSObject=DCSUnit
return DCSUnit
else
self.DCSObject=nil
self.LastCallDCSObject=nil
end
else
return self.DCSObject
end
return nil
end
function UNIT:GetAltitude(FromGround)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local altitude=0
local point=DCSUnit:getPoint()
altitude=point.y
if FromGround then
local land=land.getHeight({x=point.x,y=point.z})or 0
altitude=altitude-land
end
return altitude
end
return nil
end
function UNIT:ReSpawnAt(Coordinate,Heading)
local SpawnGroupTemplate=UTILS.DeepCopy(_DATABASE:GetGroupTemplateFromUnitName(self:Name()))
local SpawnGroup=self:GetGroup()
if SpawnGroup then
local Vec3=SpawnGroup:GetVec3()
SpawnGroupTemplate.x=Coordinate.x
SpawnGroupTemplate.y=Coordinate.z
for UnitID,UnitData in pairs(SpawnGroup:GetUnits()or{})do
local GroupUnit=UnitData
if GroupUnit:IsAlive()then
local GroupUnitVec3=GroupUnit:GetVec3()
local GroupUnitHeading=GroupUnit:GetHeading()
SpawnGroupTemplate.units[UnitID].alt=GroupUnitVec3.y
SpawnGroupTemplate.units[UnitID].x=GroupUnitVec3.x
SpawnGroupTemplate.units[UnitID].y=GroupUnitVec3.z
SpawnGroupTemplate.units[UnitID].heading=GroupUnitHeading
end
end
end
for UnitTemplateID,UnitTemplateData in pairs(SpawnGroupTemplate.units)do
SpawnGroupTemplate.units[UnitTemplateID].unitId=nil
if UnitTemplateData.name==self:Name()then
SpawnGroupTemplate.units[UnitTemplateID].alt=Coordinate.y
SpawnGroupTemplate.units[UnitTemplateID].x=Coordinate.x
SpawnGroupTemplate.units[UnitTemplateID].y=Coordinate.z
SpawnGroupTemplate.units[UnitTemplateID].heading=Heading
else
local GroupUnit=UNIT:FindByName(SpawnGroupTemplate.units[UnitTemplateID].name)
if GroupUnit and GroupUnit:IsAlive()then
local GroupUnitVec3=GroupUnit:GetVec3()
local GroupUnitHeading=GroupUnit:GetHeading()
UnitTemplateData.alt=GroupUnitVec3.y
UnitTemplateData.x=GroupUnitVec3.x
UnitTemplateData.y=GroupUnitVec3.z
UnitTemplateData.heading=GroupUnitHeading
else
if SpawnGroupTemplate.units[UnitTemplateID].name~=self:Name()then
SpawnGroupTemplate.units[UnitTemplateID].delete=true
end
end
end
end
local i=1
while i<=#SpawnGroupTemplate.units do
local UnitTemplateData=SpawnGroupTemplate.units[i]
if UnitTemplateData.delete then
table.remove(SpawnGroupTemplate.units,i)
else
i=i+1
end
end
SpawnGroupTemplate.groupId=nil
_DATABASE:Spawn(SpawnGroupTemplate)
end
function UNIT:IsActive()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitIsActive=DCSUnit:isActive()
return UnitIsActive
end
return nil
end
function UNIT:IsExist()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local exists=DCSUnit:isExist()
return exists
end
return nil
end
function UNIT:IsAlive()
local DCSUnit=self:GetDCSObject()
if DCSUnit and DCSUnit:isExist()then
local UnitIsAlive=DCSUnit:isActive()
return UnitIsAlive
end
return nil
end
function UNIT:IsDead()
return not self:IsAlive()
end
function UNIT:GetCallsign()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitCallSign=DCSUnit:getCallsign()
if UnitCallSign==""then
UnitCallSign=DCSUnit:getName()
end
return UnitCallSign
end
return nil
end
function UNIT:IsPlayer()
local group=self:GetGroup()
if not group then
return false
end
local template=group:GetTemplate()
if(template==nil)or(template.units==nil)then
local DCSObject=self:GetDCSObject()
if DCSObject then
if DCSObject:getPlayerName()~=nil then
return true
else
return false
end
else
return false
end
end
local units=template.units
for _,unit in pairs(units)do
if unit.name==self:GetName()and(unit.skill=="Client"or unit.skill=="Player")then
return true
end
end
return false
end
function UNIT:GetPlayerName()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local PlayerName=DCSUnit:getPlayerName()
return PlayerName
end
return nil
end
function UNIT:IsClient()
if _DATABASE.CLIENTS[self.UnitName]then
return true
end
return false
end
function UNIT:GetClient()
local client=_DATABASE.CLIENTS[self.UnitName]
if client then
return client
end
return nil
end
function UNIT:GetNatoReportingName()
local typename=self:GetTypeName()
return UTILS.GetReportingName(typename)
end
function UNIT:GetNumber()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitNumber=DCSUnit:getNumber()
return UnitNumber
end
return nil
end
function UNIT:GetSpeedMax()
local Desc=self:GetDesc()
if Desc then
local SpeedMax=Desc.speedMax or 0
return SpeedMax*3.6
end
return 0
end
function UNIT:GetRange()
local Desc=self:GetDesc()
if Desc then
local Range=Desc.range
if Range then
Range=Range*1000
else
Range=10000000
end
return Range
end
return nil
end
function UNIT:IsRefuelable()
local refuelable=self:HasAttribute("Refuelable")
local system=nil
local Desc=self:GetDesc()
if Desc and Desc.tankerType then
system=Desc.tankerType
end
return refuelable,system
end
function UNIT:IsTanker()
local tanker=self:HasAttribute("Tankers")
local system=nil
if tanker then
local Desc=self:GetDesc()
if Desc and Desc.tankerType then
system=Desc.tankerType
end
local typename=self:GetTypeName()
if typename=="IL-78M"then
system=1
elseif typename=="KC130"or typename=="KC130J"then
system=1
elseif typename=="KC135BDA"then
system=1
elseif typename=="KC135MPRS"then
system=1
elseif typename=="S-3B Tanker"then
system=1
elseif typename=="KC_10_Extender"then
system=1
elseif typename=="KC_10_Extender_D"then
system=0
end
end
return tanker,system
end
function UNIT:IsAmmoSupply()
local typename=self:GetTypeName()
if typename=="M 818"then
return true
elseif typename=="Ural-375"then
return true
elseif typename=="ZIL-135"then
return true
end
return false
end
function UNIT:IsFuelSupply()
local typename=self:GetTypeName()
if typename=="M978 HEMTT Tanker"then
return true
elseif typename=="ATMZ-5"then
return true
elseif typename=="ATMZ-10"then
return true
elseif typename=="ATZ-5"then
return true
end
return false
end
function UNIT:GetGroup()
local UnitGroup=GROUP:FindByName(self.GroupName)
if UnitGroup then
return UnitGroup
else
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local grp=DCSUnit:getGroup()
if grp then
local UnitGroup=GROUP:FindByName(grp:getName())
return UnitGroup
end
end
end
return nil
end
function UNIT:GetPrefix()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitPrefix=string.match(self.UnitName,".*#"):sub(1,-2)
return UnitPrefix
end
return nil
end
function UNIT:GetAmmo()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitAmmo=DCSUnit:getAmmo()
return UnitAmmo
end
return nil
end
function UNIT:SetUnitInternalCargo(mass)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
trigger.action.setUnitInternalCargo(DCSUnit:getName(),mass)
end
return self
end
function UNIT:GetAmmunition()
local nammo=0
local nshells=0
local nrockets=0
local nmissiles=0
local nbombs=0
local narti=0
local nAPshells=0
local nHEshells=0
local unit=self
local ammotable=unit:GetAmmo()
if ammotable then
local weapons=#ammotable
for w=1,weapons do
local Nammo=ammotable[w]["count"]
local Tammo=ammotable[w]["desc"]["typeName"]
local Category=ammotable[w].desc.category
local MissileCategory=nil
if Category==Weapon.Category.MISSILE then
MissileCategory=ammotable[w].desc.missileCategory
end
if Category==Weapon.Category.SHELL then
nshells=nshells+Nammo
if ammotable[w].desc.warhead and ammotable[w].desc.warhead.explosiveMass and ammotable[w].desc.warhead.explosiveMass>0 then
narti=narti+Nammo
end
if ammotable[w].desc.typeName and string.find(ammotable[w].desc.typeName,"_AP",1,true)then
nAPshells=nAPshells+Nammo
end
if ammotable[w].desc.typeName and(string.find(ammotable[w].desc.typeName,"_HE",1,true)or string.find(ammotable[w].desc.typeName,"HESH",1,true))then
nHEshells=nHEshells+Nammo
end
elseif Category==Weapon.Category.ROCKET then
nrockets=nrockets+Nammo
elseif Category==Weapon.Category.BOMB then
nbombs=nbombs+Nammo
elseif Category==Weapon.Category.MISSILE then
if MissileCategory==Weapon.MissileCategory.AAM then
nmissiles=nmissiles+Nammo
elseif MissileCategory==Weapon.MissileCategory.ANTI_SHIP then
nmissiles=nmissiles+Nammo
elseif MissileCategory==Weapon.MissileCategory.BM then
nmissiles=nmissiles+Nammo
elseif MissileCategory==Weapon.MissileCategory.OTHER then
nmissiles=nmissiles+Nammo
elseif MissileCategory==Weapon.MissileCategory.SAM then
nmissiles=nmissiles+Nammo
elseif MissileCategory==Weapon.MissileCategory.CRUISE then
nmissiles=nmissiles+Nammo
end
end
end
end
nammo=nshells+nrockets+nmissiles+nbombs
return nammo,nshells,nrockets,nbombs,nmissiles,narti,nAPshells,nHEshells
end
function UNIT:HasAPShells()
local _,_,_,_,_,_,shells=self:GetAmmunition()
if shells>0 then
return true
else
return false
end
end
function UNIT:GetAPShells()
local _,_,_,_,_,_,shells=self:GetAmmunition()
return shells or 0
end
function UNIT:GetHEShells()
local _,_,_,_,_,_,_,shells=self:GetAmmunition()
return shells or 0
end
function UNIT:HasHEShells()
local _,_,_,_,_,_,_,shells=self:GetAmmunition()
if shells>0 then
return true
else
return false
end
end
function UNIT:HasArtiShells()
local _,_,_,_,_,shells=self:GetAmmunition()
if shells>0 then
return true
else
return false
end
end
function UNIT:GetArtiShells()
local _,_,_,_,_,shells=self:GetAmmunition()
return shells or 0
end
function UNIT:GetSensors()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitSensors=DCSUnit:getSensors()
return UnitSensors
end
return nil
end
function UNIT:HasSensors(...)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local HasSensors=DCSUnit:hasSensors(unpack(arg))
return HasSensors
end
return nil
end
function UNIT:HasSEAD()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitSEADAttributes=DCSUnit:getDesc().attributes
local HasSEAD=false
if UnitSEADAttributes["RADAR_BAND1_FOR_ARM"]and UnitSEADAttributes["RADAR_BAND1_FOR_ARM"]==true or
UnitSEADAttributes["RADAR_BAND2_FOR_ARM"]and UnitSEADAttributes["RADAR_BAND2_FOR_ARM"]==true or
UnitSEADAttributes["Optical Tracker"]and UnitSEADAttributes["Optical Tracker"]==true
then
HasSEAD=true
end
return HasSEAD
end
return nil
end
function UNIT:GetRadar()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitRadarOn,UnitRadarObject=DCSUnit:getRadar()
return UnitRadarOn,UnitRadarObject
end
return nil,nil
end
function UNIT:GetFuel()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitFuel=DCSUnit:getFuel()
return UnitFuel
end
return nil
end
function UNIT:GetUnits()
local DCSUnit=self:GetDCSObject()
local Units={}
if DCSUnit then
Units[1]=UNIT:Find(DCSUnit)
return Units
end
return nil
end
function UNIT:GetLife()
local DCSUnit=self:GetDCSObject()
if DCSUnit and DCSUnit:isExist()then
local UnitLife=DCSUnit:getLife()
return UnitLife
end
return-1
end
function UNIT:GetLife0()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitLife0=DCSUnit:getLife0()
return UnitLife0
end
return 0
end
function UNIT:GetLifeRelative()
if self and self:IsAlive()then
local life0=self:GetLife0()
local lifeN=self:GetLife()
return lifeN/life0
end
return-1
end
function UNIT:GetDamageRelative()
if self and self:IsAlive()then
return 1-self:GetLifeRelative()
end
return 1
end
function UNIT:GetDrawArgumentValue(AnimationArgument)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local value=DCSUnit:getDrawArgumentValue(AnimationArgument or 0)
return value
end
return 0
end
function UNIT:GetUnitCategory()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
return DCSUnit:getDesc().category
end
return nil
end
function UNIT:GetCategoryName()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local CategoryNames={
[Unit.Category.AIRPLANE]="Airplane",
[Unit.Category.HELICOPTER]="Helicopter",
[Unit.Category.GROUND_UNIT]="Ground Unit",
[Unit.Category.SHIP]="Ship",
[Unit.Category.STRUCTURE]="Structure",
}
local UnitCategory=DCSUnit:getDesc().category
return CategoryNames[UnitCategory]
end
return nil
end
function UNIT:GetThreatLevel()
local ThreatLevel=0
local ThreatText=""
local Descriptor=self:GetDesc()
if Descriptor then
local Attributes=Descriptor.attributes
if self:IsGround()then
local ThreatLevels={
[1]="Unarmed",
[2]="Infantry",
[3]="Old Tanks & APCs",
[4]="Tanks & IFVs without ATGM",
[5]="Tanks & IFV with ATGM",
[6]="Modern Tanks",
[7]="AAA",
[8]="IR Guided SAMs",
[9]="SR SAMs",
[10]="MR SAMs",
[11]="LR SAMs"
}
if Attributes["LR SAM"]then
ThreatLevel=10
elseif Attributes["MR SAM"]then
ThreatLevel=9
elseif Attributes["SR SAM"]and
not Attributes["IR Guided SAM"]then
ThreatLevel=8
elseif(Attributes["SR SAM"]or Attributes["MANPADS"])and
Attributes["IR Guided SAM"]then
ThreatLevel=7
elseif Attributes["AAA"]then
ThreatLevel=6
elseif Attributes["Modern Tanks"]then
ThreatLevel=5
elseif(Attributes["Tanks"]or Attributes["IFV"])and
Attributes["ATGM"]then
ThreatLevel=4
elseif(Attributes["Tanks"]or Attributes["IFV"])and
not Attributes["ATGM"]then
ThreatLevel=3
elseif Attributes["Old Tanks"]or Attributes["APC"]or Attributes["Artillery"]then
ThreatLevel=2
elseif Attributes["Infantry"]or Attributes["EWR"]then
ThreatLevel=1
end
ThreatText=ThreatLevels[ThreatLevel+1]
end
if self:IsAir()then
local ThreatLevels={
[1]="Unarmed",
[2]="Tanker",
[3]="AWACS",
[4]="Transport Helicopter",
[5]="UAV",
[6]="Bomber",
[7]="Strategic Bomber",
[8]="Attack Helicopter",
[9]="Battleplane",
[10]="Multirole Fighter",
[11]="Fighter"
}
if Attributes["Fighters"]then
ThreatLevel=10
elseif Attributes["Multirole fighters"]then
ThreatLevel=9
elseif Attributes["Interceptors"]then
ThreatLevel=9
elseif Attributes["Battleplanes"]then
ThreatLevel=8
elseif Attributes["Battle airplanes"]then
ThreatLevel=8
elseif Attributes["Attack helicopters"]then
ThreatLevel=7
elseif Attributes["Strategic bombers"]then
ThreatLevel=6
elseif Attributes["Bombers"]then
ThreatLevel=5
elseif Attributes["UAVs"]then
ThreatLevel=4
elseif Attributes["Transport helicopters"]then
ThreatLevel=3
elseif Attributes["AWACS"]then
ThreatLevel=2
elseif Attributes["Tankers"]then
ThreatLevel=1
end
ThreatText=ThreatLevels[ThreatLevel+1]
end
if self:IsShip()then
local ThreatLevels={
[1]="Unarmed ship",
[2]="Light armed ships",
[3]="Corvettes",
[4]="",
[5]="Frigates",
[6]="",
[7]="Cruiser",
[8]="",
[9]="Destroyer",
[10]="",
[11]="Aircraft Carrier"
}
if Attributes["Aircraft Carriers"]then
ThreatLevel=10
elseif Attributes["Destroyers"]then
ThreatLevel=8
elseif Attributes["Cruisers"]then
ThreatLevel=6
elseif Attributes["Frigates"]then
ThreatLevel=4
elseif Attributes["Corvettes"]then
ThreatLevel=2
elseif Attributes["Light armed ships"]then
ThreatLevel=1
end
ThreatText=ThreatLevels[ThreatLevel+1]
end
end
return ThreatLevel,ThreatText
end
function UNIT:Explode(power,delay)
power=power or 100
local DCSUnit=self:GetDCSObject()
if DCSUnit then
if delay and delay>0 then
SCHEDULER:New(nil,self.Explode,{self,power},delay)
else
self:GetCoordinate():Explosion(power)
end
return self
end
return nil
end
function UNIT:OtherUnitInRadius(AwaitUnit,Radius)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitVec3=self:GetVec3()
local AwaitUnitVec3=AwaitUnit:GetVec3()
if(((UnitVec3.x-AwaitUnitVec3.x)^2+(UnitVec3.z-AwaitUnitVec3.z)^2)^0.5<=Radius)then
return true
else
return false
end
end
return nil
end
function UNIT:IsFriendly(FriendlyCoalition)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitCoalition=DCSUnit:getCoalition()
local IsFriendlyResult=(UnitCoalition==FriendlyCoalition)
return IsFriendlyResult
end
return nil
end
function UNIT:IsShip()
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitDescriptor=DCSUnit:getDesc()
local IsShipResult=(UnitDescriptor.category==Unit.Category.SHIP)
return IsShipResult
end
return nil
end
function UNIT:InAir(NoHeloCheck)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local UnitInAir=DCSUnit:inAir()
local UnitCategory=DCSUnit:getDesc().category
if UnitInAir==true and UnitCategory==Unit.Category.HELICOPTER and(not NoHeloCheck)then
local VelocityVec3=DCSUnit:getVelocity()
local Velocity=UTILS.VecNorm(VelocityVec3)
local Coordinate=DCSUnit:getPoint()
local LandHeight=land.getHeight({x=Coordinate.x,y=Coordinate.z})
local Height=Coordinate.y-LandHeight
if Velocity<1 and Height<=60 then
UnitInAir=false
end
end
return UnitInAir
end
return nil
end
do
function UNIT:HandleEvent(EventID,EventFunction)
self:EventDispatcher():OnEventForUnit(self:GetName(),EventFunction,self,EventID)
return self
end
function UNIT:UnHandleEvent(EventID)
self:EventDispatcher():RemoveEvent(self,EventID)
return self
end
function UNIT:ResetEvents()
self:EventDispatcher():Reset(self)
return self
end
end
do
function UNIT:IsDetected(TargetUnit)
local TargetIsDetected,TargetIsVisible,TargetLastTime,TargetKnowType,TargetKnowDistance,TargetLastPos,TargetLastVelocity=self:IsTargetDetected(TargetUnit:GetDCSObject())
return TargetIsDetected
end
function UNIT:IsLOS(TargetUnit)
local IsLOS=self:GetPointVec3():IsLOS(TargetUnit:GetPointVec3())
return IsLOS
end
function UNIT:KnowUnit(TargetUnit,TypeKnown,DistanceKnown)
if TypeKnown~=false then
TypeKnown=true
end
if DistanceKnown~=false then
DistanceKnown=true
end
local DCSControllable=self:GetDCSObject()
if DCSControllable then
local Controller=DCSControllable:getController()
if Controller then
local object=TargetUnit:GetDCSObject()
if object then
self:I(string.format("Unit %s now knows target unit %s. Type known=%s, distance known=%s",self:GetName(),TargetUnit:GetName(),tostring(TypeKnown),tostring(DistanceKnown)))
Controller:knowTarget(object,TypeKnown,DistanceKnown)
end
end
end
end
end
function UNIT:GetTemplate()
local group=self:GetGroup()
local name=self:GetName()
if group then
local template=group:GetTemplate()
if template then
for _,unit in pairs(template.units)do
if unit.name==name then
return UTILS.DeepCopy(unit)
end
end
end
end
return nil
end
function UNIT:GetTemplatePayload()
local unit=self:GetTemplate()
if unit then
return unit.payload
end
return nil
end
function UNIT:GetTemplatePylons()
local payload=self:GetTemplatePayload()
if payload then
return payload.pylons
end
return nil
end
function UNIT:GetTemplateFuel()
local payload=self:GetTemplatePayload()
if payload then
return payload.fuel
end
return nil
end
function UNIT:EnableEmission(switch)
local switch=switch or false
local DCSUnit=self:GetDCSObject()
if DCSUnit then
DCSUnit:enableEmission(switch)
end
return self
end
function UNIT:GetSkill()
local name=self.UnitName
local skill="Random"
if _DATABASE.Templates.Units[name]and _DATABASE.Templates.Units[name].Template and _DATABASE.Templates.Units[name].Template.skill then
skill=_DATABASE.Templates.Units[name].Template.skill or"Random"
end
return skill
end
function UNIT:GetSTN()
local STN=nil
local VCL=nil
local VCN=nil
local FGL=false
local template=self:GetTemplate()
if template then
if template.AddPropAircraft then
if template.AddPropAircraft.STN_L16 then
STN=template.AddPropAircraft.STN_L16
elseif template.AddPropAircraft.SADL_TN then
STN=template.AddPropAircraft.SADL_TN
end
VCN=template.AddPropAircraft.VoiceCallsignNumber
VCL=template.AddPropAircraft.VoiceCallsignLabel
end
if template.datalinks and template.datalinks.Link16 and template.datalinks.Link16.settings then
FGL=template.datalinks.Link16.settings.flightLead
end
if template.datalinks and template.datalinks.SADL and template.datalinks.SADL.settings then
FGL=template.datalinks.SADL.settings.flightLead
end
end
return STN,VCL,VCN,FGL
end
do
function UNIT:SetAIOnOff(AIOnOff)
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local DCSController=DCSUnit:getController()
if DCSController then
DCSController:setOnOff(AIOnOff)
return self
end
end
return nil
end
function UNIT:SetAIOn()
return self:SetAIOnOff(true)
end
function UNIT:SetAIOff()
return self:SetAIOnOff(false)
end
end
function UNIT:IsSAM()
if self:HasSEAD()and self:IsGround()and(not self:HasAttribute("Mobile AAA"))then
return true
end
return false
end
function UNIT:IsEWR()
if self:IsGround()then
local DCSUnit=self:GetDCSObject()
if DCSUnit then
local attrs=DCSUnit:getDesc().attributes
return attrs["EWR"]==true
end
end
return false
end
function UNIT:IsAAA()
local unit=self
local desc=unit:GetDesc()or{}
local attr=desc.attributes or{}
if unit:HasSEAD()then
return false
end
if attr["AAA"]or attr["SAM related"]then
return true
end
return false
end
CLIENT={
ClassName="CLIENT",
ClientName=nil,
ClientAlive=false,
ClientTransport=false,
ClientBriefingShown=false,
_Menus={},
_Tasks={},
Messages={},
Players={},
}
function CLIENT:Find(DCSUnit,Error)
local ClientName=DCSUnit:getName()
local ClientFound=_DATABASE:FindClient(ClientName)
if ClientFound then
ClientFound:F(ClientName)
return ClientFound
end
if not Error then
error("CLIENT not found for: "..ClientName)
end
end
function CLIENT:FindByPlayerName(Name)
local foundclient=nil
_DATABASE:ForEachClient(
function(client)
if client:GetPlayerName()==Name then
foundclient=client
end
end
)
return foundclient
end
function CLIENT:FindByName(ClientName,ClientBriefing,Error)
local ClientFound=_DATABASE:FindClient(ClientName)
if ClientFound then
ClientFound:F({ClientName,ClientBriefing})
ClientFound:AddBriefing(ClientBriefing)
ClientFound.MessageSwitch=true
return ClientFound
end
if not Error then
error("CLIENT not found for: "..ClientName)
end
end
function CLIENT:Register(ClientName)
local self=BASE:Inherit(self,UNIT:Register(ClientName))
self.ClientName=ClientName
self.MessageSwitch=true
self.ClientAlive2=false
return self
end
function CLIENT:Transport()
self.ClientTransport=true
return self
end
function CLIENT:AddBriefing(ClientBriefing)
self.ClientBriefing=ClientBriefing
self.ClientBriefingShown=false
return self
end
function CLIENT:AddPlayer(PlayerName)
table.insert(self.Players,PlayerName)
return self
end
function CLIENT:CountPlayers()
return#self.Players or 0
end
function CLIENT:GetPlayers()
return self.Players
end
function CLIENT:GetPlayer()
if#self.Players>0 then
return self.Players[1]
end
return nil
end
function CLIENT:RemovePlayer(PlayerName)
for i,playername in pairs(self.Players)do
if PlayerName==playername then
table.remove(self.Players,i)
break
end
end
return self
end
function CLIENT:RemovePlayers()
self.Players={}
return self
end
function CLIENT:ShowBriefing()
if not self.ClientBriefingShown then
self.ClientBriefingShown=true
local Briefing=""
if self.ClientBriefing and self.ClientBriefing~=""then
Briefing=Briefing..self.ClientBriefing
self:Message(Briefing,60,"Briefing")
end
end
return self
end
function CLIENT:ShowMissionBriefing(MissionBriefing)
self:F({self.ClientName})
if MissionBriefing then
self:Message(MissionBriefing,60,"Mission Briefing")
end
return self
end
function CLIENT:Reset(ClientName)
self:F()
self._Menus={}
end
function CLIENT:IsMultiSeated()
self:F(self.ClientName)
local ClientMultiSeatedTypes={
["Mi-8MT"]="Mi-8MT",
["UH-1H"]="UH-1H",
["P-51B"]="P-51B"
}
if self:IsAlive()then
local ClientTypeName=self:GetClientGroupUnit():GetTypeName()
if ClientMultiSeatedTypes[ClientTypeName]then
return true
end
end
return false
end
function CLIENT:Alive(CallBackFunction,...)
self:F()
self.ClientCallBack=CallBackFunction
self.ClientParameters=arg
self.AliveCheckScheduler=SCHEDULER:New(self,self._AliveCheckScheduler,{"Client Alive "..self.ClientName},0.1,5,0.5)
self.AliveCheckScheduler:NoTrace()
return self
end
function CLIENT:_AliveCheckScheduler(SchedulerName)
self:T2({SchedulerName,self.ClientName,self.ClientAlive2,self.ClientBriefingShown,self.ClientCallBack})
if self:IsAlive()then
if self.ClientAlive2==false then
self:ShowBriefing()
if self.ClientCallBack then
self:T("Calling Callback function")
self.ClientCallBack(self,unpack(self.ClientParameters))
end
self.ClientAlive2=true
end
else
if self.ClientAlive2==true then
self.ClientAlive2=false
end
end
return true
end
function CLIENT:GetDCSGroup()
self:F3()
local ClientUnit=Unit.getByName(self.ClientName)
local CoalitionsData={AlivePlayersRed=coalition.getPlayers(coalition.side.RED),AlivePlayersBlue=coalition.getPlayers(coalition.side.BLUE)}
for CoalitionId,CoalitionData in pairs(CoalitionsData)do
self:T3({"CoalitionData:",CoalitionData})
for UnitId,UnitData in pairs(CoalitionData)do
self:T3({"UnitData:",UnitData})
if UnitData and UnitData:isExist()then
if ClientUnit then
local ClientGroup=ClientUnit:getGroup()
if ClientGroup then
self:T3("ClientGroup = "..self.ClientName)
if ClientGroup:isExist()and UnitData:getGroup():isExist()then
if ClientGroup:getID()==UnitData:getGroup():getID()then
self:T3("Normal logic")
self:T3(self.ClientName.." : group found!")
self.ClientGroupID=ClientGroup:getID()
self.ClientGroupName=ClientGroup:getName()
return ClientGroup
end
else
self:T3("Bug 1.5 logic")
local ClientGroupTemplate=_DATABASE.Templates.Units[self.ClientName].GroupTemplate
self.ClientGroupID=ClientGroupTemplate.groupId
self.ClientGroupName=_DATABASE.Templates.Units[self.ClientName].GroupName
self:T3(self.ClientName.." : group found in bug 1.5 resolvement logic!")
return ClientGroup
end
end
else
end
end
end
end
if ClientUnit then
local ClientGroup=ClientUnit:getGroup()
if ClientGroup then
self:T3("ClientGroup = "..self.ClientName)
if ClientGroup:isExist()then
self:T3("Normal logic")
self:T3(self.ClientName.." : group found!")
return ClientGroup
end
end
end
self.ClientGroupID=nil
self.ClientGroupName=nil
return nil
end
function CLIENT:GetClientGroupID()
self:GetDCSGroup()
return self.ClientGroupID
end
function CLIENT:GetClientGroupName()
self:GetDCSGroup()
return self.ClientGroupName
end
function CLIENT:GetClientGroupUnit()
self:F2()
local ClientDCSUnit=Unit.getByName(self.ClientName)
self:T(self.ClientDCSUnit)
if ClientDCSUnit and ClientDCSUnit:isExist()then
local ClientUnit=_DATABASE:FindUnit(self.ClientName)
return ClientUnit
end
return nil
end
function CLIENT:GetClientGroupDCSUnit()
self:F2()
local ClientDCSUnit=Unit.getByName(self.ClientName)
if ClientDCSUnit and ClientDCSUnit:isExist()then
self:T2(ClientDCSUnit)
return ClientDCSUnit
end
end
function CLIENT:IsTransport()
self:F()
return self.ClientTransport
end
function CLIENT:ShowCargo()
self:F()
local CargoMsg=""
for CargoName,Cargo in pairs(CARGOS)do
if self==Cargo:IsLoadedInClient()then
CargoMsg=CargoMsg..Cargo.CargoName.." Type:"..Cargo.CargoType.." Weight: "..Cargo.CargoWeight.."\n"
end
end
if CargoMsg==""then
CargoMsg="empty"
end
self:Message(CargoMsg,15,"Co-Pilot: Cargo Status",30)
end
function CLIENT:Message(Message,MessageDuration,MessageCategory,MessageInterval,MessageID)
self:F({Message,MessageDuration,MessageCategory,MessageInterval})
if self.MessageSwitch==true then
if MessageCategory==nil then
MessageCategory="Messages"
end
if MessageID~=nil then
if self.Messages[MessageID]==nil then
self.Messages[MessageID]={}
self.Messages[MessageID].MessageId=MessageID
self.Messages[MessageID].MessageTime=timer.getTime()
self.Messages[MessageID].MessageDuration=MessageDuration
if MessageInterval==nil then
self.Messages[MessageID].MessageInterval=600
else
self.Messages[MessageID].MessageInterval=MessageInterval
end
MESSAGE:New(Message,MessageDuration,MessageCategory):ToClient(self)
else
if self:GetClientGroupDCSUnit()and not self:GetClientGroupDCSUnit():inAir()then
if timer.getTime()-self.Messages[MessageID].MessageTime>=self.Messages[MessageID].MessageDuration+10 then
MESSAGE:New(Message,MessageDuration,MessageCategory):ToClient(self)
self.Messages[MessageID].MessageTime=timer.getTime()
end
else
if timer.getTime()-self.Messages[MessageID].MessageTime>=self.Messages[MessageID].MessageDuration+self.Messages[MessageID].MessageInterval then
MESSAGE:New(Message,MessageDuration,MessageCategory):ToClient(self)
self.Messages[MessageID].MessageTime=timer.getTime()
end
end
end
else
MESSAGE:New(Message,MessageDuration,MessageCategory):ToClient(self)
end
end
end
function CLIENT:GetUCID()
local PID=NET.GetPlayerIDByName(nil,self:GetPlayerName())
return net.get_player_info(tonumber(PID),'ucid')
end
function CLIENT:GetPlayerInfo(Attribute)
local PID=NET.GetPlayerIDByName(nil,self:GetPlayerName())
if PID then
return net.get_player_info(tonumber(PID),Attribute)
else
return nil
end
end
STATIC={
ClassName="STATIC",
}
function STATIC:Register(StaticName)
local self=BASE:Inherit(self,POSITIONABLE:New(StaticName))
self.StaticName=StaticName
local DCSStatic=StaticObject.getByName(self.StaticName)
if DCSStatic then
local Life0=DCSStatic:getLife()or 1
self.Life0=Life0
else
self:E(string.format("Static object %s does not exist!",tostring(self.StaticName)))
end
return self
end
function STATIC:GetLife0()
return self.Life0 or 1
end
function STATIC:GetLife()
local DCSStatic=StaticObject.getByName(self.StaticName)
if DCSStatic then
return DCSStatic:getLife()or 1
end
return nil
end
function STATIC:Find(DCSStatic)
local StaticName=DCSStatic:getName()
local StaticFound=_DATABASE:FindStatic(StaticName)
return StaticFound
end
function STATIC:FindByName(StaticName,RaiseError)
local StaticFound=_DATABASE:FindStatic(StaticName)
self.StaticName=StaticName
if StaticFound then
return StaticFound
end
if RaiseError==nil or RaiseError==true then
error("STATIC not found for: "..StaticName)
end
return nil
end
function STATIC:Destroy(GenerateEvent)
self:F2(self.ObjectName)
local DCSObject=self:GetDCSObject()
if DCSObject then
local StaticName=DCSObject:getName()
self:F({StaticName=StaticName})
if GenerateEvent and GenerateEvent==true then
if self:IsAir()then
self:CreateEventCrash(timer.getTime(),DCSObject)
else
self:CreateEventDead(timer.getTime(),DCSObject)
end
elseif GenerateEvent==false then
else
self:CreateEventRemoveUnit(timer.getTime(),DCSObject)
end
DCSObject:destroy()
return true
end
return nil
end
function STATIC:GetDCSObject()
local DCSStatic=StaticObject.getByName(self.StaticName)
if DCSStatic then
return DCSStatic
end
return nil
end
function STATIC:GetUnits()
self:F2({self.StaticName})
local DCSStatic=self:GetDCSObject()
local Statics={}
if DCSStatic then
Statics[1]=STATIC:Find(DCSStatic)
self:T3(Statics)
return Statics
end
return nil
end
function STATIC:GetThreatLevel()
return 1,"Static"
end
function STATIC:SpawnAt(Coordinate,Heading,Delay)
Heading=Heading or 0
if Delay and Delay>0 then
SCHEDULER:New(nil,self.SpawnAt,{self,Coordinate,Heading},Delay)
else
local SpawnStatic=SPAWNSTATIC:NewFromStatic(self.StaticName)
SpawnStatic:SpawnFromPointVec2(Coordinate,Heading,self.StaticName)
end
return self
end
function STATIC:ReSpawn(CountryID,Delay)
if Delay and Delay>0 then
SCHEDULER:New(nil,self.ReSpawn,{self,CountryID},Delay)
else
CountryID=CountryID or self:GetCountry()
local SpawnStatic=SPAWNSTATIC:NewFromStatic(self.StaticName,CountryID)
SpawnStatic:Spawn(nil,self.StaticName)
end
return self
end
function STATIC:ReSpawnAt(Coordinate,Heading,Delay)
if Delay and Delay>0 then
SCHEDULER:New(nil,self.ReSpawnAt,{self,Coordinate,Heading},Delay)
else
local SpawnStatic=SPAWNSTATIC:NewFromStatic(self.StaticName,self:GetCountry())
SpawnStatic:SpawnFromCoordinate(Coordinate,Heading,self.StaticName)
end
return self
end
function STATIC:FindByMatching(Pattern)
local GroupFound=nil
for name,static in pairs(_DATABASE.STATICS)do
if string.match(name,Pattern)then
GroupFound=static
break
end
end
return GroupFound
end
function STATIC:FindAllByMatching(Pattern)
local GroupsFound={}
for name,static in pairs(_DATABASE.STATICS)do
if string.match(name,Pattern)then
GroupsFound[#GroupsFound+1]=static
end
end
return GroupsFound
end
function STATIC:GetStaticStorage()
local name=self:GetName()
local storage=STORAGE:NewFromStaticCargo(name)
return storage
end
function STATIC:GetCargoWeight()
local DCSObject=StaticObject.getByName(self.StaticName)
local mass=-1
if DCSObject then
mass=DCSObject:getCargoWeight()or 0
local masstxt=DCSObject:getCargoDisplayName()or"none"
end
return mass
end
AIRBASE={
ClassName="AIRBASE",
CategoryName={
[Airbase.Category.AIRDROME]="Airdrome",
[Airbase.Category.HELIPAD]="Helipad",
[Airbase.Category.SHIP]="Ship",
},
activerwyno=nil,
}
AIRBASE.Caucasus={
["Anapa_Vityazevo"]="Anapa-Vityazevo",
["Batumi"]="Batumi",
["Beslan"]="Beslan",
["Gelendzhik"]="Gelendzhik",
["Gudauta"]="Gudauta",
["Kobuleti"]="Kobuleti",
["Krasnodar_Center"]="Krasnodar-Center",
["Krasnodar_Pashkovsky"]="Krasnodar-Pashkovsky",
["Krymsk"]="Krymsk",
["Kutaisi"]="Kutaisi",
["Maykop_Khanskaya"]="Maykop-Khanskaya",
["Mineralnye_Vody"]="Mineralnye Vody",
["Mozdok"]="Mozdok",
["Nalchik"]="Nalchik",
["Novorossiysk"]="Novorossiysk",
["Senaki_Kolkhi"]="Senaki-Kolkhi",
["Sochi_Adler"]="Sochi-Adler",
["Soganlug"]="Soganlug",
["Sukhumi_Babushara"]="Sukhumi-Babushara",
["Tbilisi_Lochini"]="Tbilisi-Lochini",
["Vaziani"]="Vaziani",
}
AIRBASE.Nevada={
["Beatty"]="Beatty",
["Boulder_City"]="Boulder City",
["Creech"]="Creech",
["Echo_Bay"]="Echo Bay",
["Groom_Lake"]="Groom Lake",
["Henderson_Executive"]="Henderson Executive",
["Jean"]="Jean",
["Laughlin"]="Laughlin",
["Lincoln_County"]="Lincoln County",
["McCarran_International"]="McCarran International",
["Mesquite"]="Mesquite",
["Mina"]="Mina",
["Nellis"]="Nellis",
["North_Las_Vegas"]="North Las Vegas",
["Pahute_Mesa"]="Pahute Mesa",
["Tonopah"]="Tonopah",
["Tonopah_Test_Range"]="Tonopah Test Range",
}
AIRBASE.Normandy={
["Abbeville_Drucat"]="Abbeville Drucat",
["Amiens_Glisy"]="Amiens-Glisy",
["Argentan"]="Argentan",
["Avranches_Le_Val_Saint_Pere"]="Avranches Le Val-Saint-Pere",
["Azeville"]="Azeville",
["Barville"]="Barville",
["Bazenville"]="Bazenville",
["Beaumont_le_Roger"]="Beaumont-le-Roger",
["Beauvais_Tille"]="Beauvais-Tille",
["Beny_sur_Mer"]="Beny-sur-Mer",
["Bernay_Saint_Martin"]="Bernay Saint Martin",
["Beuzeville"]="Beuzeville",
["Biggin_Hill"]="Biggin Hill",
["Biniville"]="Biniville",
["Broglie"]="Broglie",
["Brucheville"]="Brucheville",
["Cardonville"]="Cardonville",
["Carpiquet"]="Carpiquet",
["Chailey"]="Chailey",
["Chippelle"]="Chippelle",
["Conches"]="Conches",
["Cormeilles_en_Vexin"]="Cormeilles-en-Vexin",
["Creil"]="Creil",
["Cretteville"]="Cretteville",
["Cricqueville_en_Bessin"]="Cricqueville-en-Bessin",
["Deanland"]="Deanland",
["Deauville"]="Deauville",
["Detling"]="Detling",
["Deux_Jumeaux"]="Deux Jumeaux",
["Dinan_Trelivan"]="Dinan-Trelivan",
["Dunkirk_Mardyck"]="Dunkirk-Mardyck",
["Essay"]="Essay",
["Evreux"]="Evreux",
["Farnborough"]="Farnborough",
["Fecamp_Benouville"]="Fecamp-Benouville",
["Flers"]="Flers",
["Ford"]="Ford",
["Friston"]="Friston",
["Funtington"]="Funtington",
["Goulet"]="Goulet",
["Gravesend"]="Gravesend",
["Guyancourt"]="Guyancourt",
["Hauterive"]="Hauterive",
["Heathrow"]="Heathrow",
["High_Halden"]="High Halden",
["Kenley"]="Kenley",
["Lantheuil"]="Lantheuil",
["Le_Molay"]="Le Molay",
["Lessay"]="Lessay",
["Lignerolles"]="Lignerolles",
["Longues_sur_Mer"]="Longues-sur-Mer",
["Lonrai"]="Lonrai",
["Lymington"]="Lymington",
["Lympne"]="Lympne",
["Manston"]="Manston",
["Maupertus"]="Maupertus",
["Meautis"]="Meautis",
["Merville_Calonne"]="Merville Calonne",
["Needs_Oar_Point"]="Needs Oar Point",
["Odiham"]="Odiham",
["Orly"]="Orly",
["Picauville"]="Picauville",
["Poix"]="Poix",
["Ronai"]="Ronai",
["Rouen_Boos"]="Rouen-Boos",
["Rucqueville"]="Rucqueville",
["Saint_Andre_de_lEure"]="Saint-Andre-de-lEure",
["Saint_Aubin"]="Saint-Aubin",
["Saint_Omer_Wizernes"]="Saint-Omer Wizernes",
["Saint_Pierre_du_Mont"]="Saint Pierre du Mont",
["Sainte_Croix_sur_Mer"]="Sainte-Croix-sur-Mer",
["Sainte_Laurent_sur_Mer"]="Sainte-Laurent-sur-Mer",
["Sommervieu"]="Sommervieu",
["Stoney_Cross"]="Stoney Cross",
["Tangmere"]="Tangmere",
["Triqueville"]="Triqueville",
["Villacoublay"]="Villacoublay",
["Vrigny"]="Vrigny",
["West_Malling"]="West Malling",
["Eastchurch"]="Eastchurch",
["Headcorn"]="Headcorn",
["Hawkinge"]="Hawkinge",
}
AIRBASE.PersianGulf={
["Abu_Dhabi_Intl"]="Abu Dhabi Intl",
["Abu_Musa_Island"]="Abu Musa Island",
["Al_Ain_Intl"]="Al Ain Intl",
["Al_Bateen"]="Al-Bateen",
["Al_Dhafra_AFB"]="Al Dhafra AFB",
["Al_Maktoum_Intl"]="Al Maktoum Intl",
["Al_Minhad_AFB"]="Al Minhad AFB",
["Bandar_Abbas_Intl"]="Bandar Abbas Intl",
["Bandar_Lengeh"]="Bandar Lengeh",
["Bandar_e_Jask"]="Bandar-e-Jask",
["Dubai_Intl"]="Dubai Intl",
["Fujairah_Intl"]="Fujairah Intl",
["Havadarya"]="Havadarya",
["Jiroft"]="Jiroft",
["Kerman"]="Kerman",
["Khasab"]="Khasab",
["Kish_Intl"]="Kish Intl",
["Lar"]="Lar",
["Lavan_Island"]="Lavan Island",
["Liwa_AFB"]="Liwa AFB",
["Qeshm_Island"]="Qeshm Island",
["Quasoura_airport"]="Quasoura_airport",
["Ras_Al_Khaimah_Intl"]="Ras Al Khaimah Intl",
["Sas_Al_Nakheel"]="Sas Al Nakheel",
["Sharjah_Intl"]="Sharjah Intl",
["Shiraz_Intl"]="Shiraz Intl",
["Sir_Abu_Nuayr"]="Sir Abu Nuayr",
["Sirri_Island"]="Sirri Island",
["Tunb_Island_AFB"]="Tunb Island AFB",
["Tunb_Kochak"]="Tunb Kochak",
}
AIRBASE.TheChannel={
["Abbeville_Drucat"]="Abbeville Drucat",
["Biggin_Hill"]="Biggin Hill",
["Detling"]="Detling",
["Dunkirk_Mardyck"]="Dunkirk Mardyck",
["Eastchurch"]="Eastchurch",
["Hawkinge"]="Hawkinge",
["Headcorn"]="Headcorn",
["High_Halden"]="High Halden",
["Lympne"]="Lympne",
["Manston"]="Manston",
["Merville_Calonne"]="Merville Calonne",
["Saint_Omer_Longuenesse"]="Saint Omer Longuenesse",
}
AIRBASE.Syria={
["Abu_al_Duhur"]="Abu al-Duhur",
["Adana_Sakirpasa"]="Adana Sakirpasa",
["Akrotiri"]="Akrotiri",
["Al_Dumayr"]="Al-Dumayr",
["Al_Qusayr"]="Al Qusayr",
["Aleppo"]="Aleppo",
["Amman"]="Amman",
["An_Nasiriyah"]="An Nasiriyah",
["At_Tanf"]="At Tanf",
["Bassel_Al_Assad"]="Bassel Al-Assad",
["Beirut_Rafic_Hariri"]="Beirut-Rafic Hariri",
["Damascus"]="Damascus",
["Deir_ez_Zor"]="Deir ez-Zor",
["Ercan"]="Ercan",
["Eyn_Shemer"]="Eyn Shemer",
["Gaziantep"]="Gaziantep",
["Gazipasa"]="Gazipasa",
["Gecitkale"]="Gecitkale",
["H"]="H",
["H3"]="H3",
["H3_Northwest"]="H3 Northwest",
["H3_Southwest"]="H3 Southwest",
["H4"]="H4",
["Haifa"]="Haifa",
["Hama"]="Hama",
["Hatay"]="Hatay",
["Herzliya"]="Herzliya",
["Incirlik"]="Incirlik",
["Jirah"]="Jirah",
["Khalkhalah"]="Khalkhalah",
["Kharab_Ishk"]="Kharab Ishk",
["King_Abdullah_II"]="King Abdullah II",
["King_Hussein_Air_College"]="King Hussein Air College",
["Kingsfield"]="Kingsfield",
["Kiryat_Shmona"]="Kiryat Shmona",
["Kuweires"]="Kuweires",
["Lakatamia"]="Lakatamia",
["Larnaca"]="Larnaca",
["Marj_Ruhayyil"]="Marj Ruhayyil",
["Marj_as_Sultan_North"]="Marj as Sultan North",
["Marj_as_Sultan_South"]="Marj as Sultan South",
["Megiddo"]="Megiddo",
["Mezzeh"]="Mezzeh",
["Minakh"]="Minakh",
["Muwaffaq_Salti"]="Muwaffaq Salti",
["Naqoura"]="Naqoura",
["Nicosia"]="Nicosia",
["Palmyra"]="Palmyra",
["Paphos"]="Paphos",
["Pinarbashi"]="Pinarbashi",
["Prince_Hassan"]="Prince Hassan",
["Qabr_as_Sitt"]="Qabr as Sitt",
["Ramat_David"]="Ramat David",
["Rayak"]="Rayak",
["Rene_Mouawad"]="Rene Mouawad",
["Rosh_Pina"]="Rosh Pina",
["Ruwayshid"]="Ruwayshid",
["Sanliurfa"]="Sanliurfa",
["Sayqal"]="Sayqal",
["Shayrat"]="Shayrat",
["Tabqa"]="Tabqa",
["Taftanaz"]="Taftanaz",
["Tal_Siman"]="Tal Siman",
["Tha_lah"]="Tha'lah",
["Tiyas"]="Tiyas",
["Wujah_Al_Hajar"]="Wujah Al Hajar",
["Ben_Gurion"]="Ben Gurion",
["Hatzor"]="Hatzor",
["Palmashim"]="Palmashim",
["Tel_Nof"]="Tel Nof",
}
AIRBASE.MarianaIslands={
["Andersen_AFB"]="Andersen AFB",
["Antonio_B_Won_Pat_Intl"]="Antonio B. Won Pat Intl",
["North_West_Field"]="North West Field",
["Olf_Orote"]="Olf Orote",
["Pagan_Airstrip"]="Pagan Airstrip",
["Rota_Intl"]="Rota Intl",
["Saipan_Intl"]="Saipan Intl",
["Tinian_Intl"]="Tinian Intl",
}
AIRBASE.SouthAtlantic={
["Almirante_Schroeders"]="Almirante Schroeders",
["Comandante_Luis_Piedrabuena"]="Comandante Luis Piedrabuena",
["Cullen"]="Cullen",
["El_Calafate"]="El Calafate",
["Franco_Bianco"]="Franco Bianco",
["Gobernador_Gregores"]="Gobernador Gregores",
["Goose_Green"]="Goose Green",
["Gull_Point"]="Gull Point",
["Hipico_Flying_Club"]="Hipico Flying Club",
["Mount_Pleasant"]="Mount Pleasant",
["O_Higgins"]="O'Higgins",
["Pampa_Guanaco"]="Pampa Guanaco",
["Port_Stanley"]="Port Stanley",
["Porvenir"]="Porvenir",
["Puerto_Natales"]="Puerto Natales",
["Puerto_Santa_Cruz"]="Puerto Santa Cruz",
["Puerto_Williams"]="Puerto Williams",
["Punta_Arenas"]="Punta Arenas",
["Rio_Chico"]="Rio Chico",
["Rio_Gallegos"]="Rio Gallegos",
["Rio_Grande"]="Rio Grande",
["Rio_Turbio"]="Rio Turbio",
["San_Carlos_FOB"]="San Carlos FOB",
["San_Julian"]="San Julian",
["Tolhuin"]="Tolhuin",
["Ushuaia"]="Ushuaia",
["Ushuaia_Helo_Port"]="Ushuaia Helo Port",
}
AIRBASE.Sinai={
["Abu_Rudeis"]="Abu Rudeis",
["Abu_Suwayr"]="Abu Suwayr",
["Al_Bahr_al_Ahmar"]="Al Bahr al Ahmar",
["Al_Ismailiyah"]="Al Ismailiyah",
["Al_Khatatbah"]="Al Khatatbah",
["Al_Mansurah"]="Al Mansurah",
["Al_Rahmaniyah_Air_Base"]="Al Rahmaniyah Air Base",
["As_Salihiyah"]="As Salihiyah",
["AzZaqaziq"]="AzZaqaziq",
["Baluza"]="Baluza",
["Ben_Gurion"]="Ben-Gurion",
["Beni_Suef"]="Beni Suef",
["Bilbeis_Air_Base"]="Bilbeis Air Base",
["Bir_Hasanah"]="Bir Hasanah",
["Birma_Air_Base"]="Birma Air Base",
["Borj_El_Arab_International_Airport"]="Borj El Arab International Airport",
["Cairo_International_Airport"]="Cairo International Airport",
["Cairo_West"]="Cairo West",
["Difarsuwar_Airfield"]="Difarsuwar Airfield",
["El_Arish"]="El Arish",
["El_Gora"]="El Gora",
["El_Minya"]="El Minya",
["Fayed"]="Fayed",
["Gebel_El_Basur_Air_Base"]="Gebel El Basur Air Base",
["Hatzerim"]="Hatzerim",
["Hatzor"]="Hatzor",
["Hurghada_International_Airport"]="Hurghada International Airport",
["Inshas_Airbase"]="Inshas Airbase",
["Jiyanklis_Air_Base"]="Jiyanklis Air Base",
["Kedem"]="Kedem",
["Kibrit_Air_Base"]="Kibrit Air Base",
["Kom_Awshim"]="Kom Awshim",
["Melez"]="Melez",
["Nevatim"]="Nevatim",
["Ovda"]="Ovda",
["Palmachim"]="Palmachim",
["Quwaysina"]="Quwaysina",
["Ramon_Airbase"]="Ramon Airbase",
["Ramon_International_Airport"]="Ramon International Airport",
["Sde_Dov"]="Sde Dov",
["Sharm_El_Sheikh_International_Airport"]="Sharm El Sheikh International Airport",
["St_Catherine"]="St Catherine",
["Tel_Nof"]="Tel Nof",
["Wadi_Abu_Rish"]="Wadi Abu Rish",
["Wadi_al_Jandali"]="Wadi al Jandali",
}
AIRBASE.Kola={
["Banak"]="Banak",
["Bodo"]="Bodo",
["Ivalo"]="Ivalo",
["Jokkmokk"]="Jokkmokk",
["Kalixfors"]="Kalixfors",
["Kallax"]="Kallax",
["Kemi_Tornio"]="Kemi Tornio",
["Kirkenes"]="Kirkenes",
["Kiruna"]="Kiruna",
["Kuusamo"]="Kuusamo",
["Monchegorsk"]="Monchegorsk",
["Murmansk_International"]="Murmansk International",
["Olenya"]="Olenya",
["Rovaniemi"]="Rovaniemi",
["Severomorsk_1"]="Severomorsk-1",
["Severomorsk_3"]="Severomorsk-3",
["Vidsel"]="Vidsel",
["Vuojarvi"]="Vuojarvi",
["Andoya"]="Andoya",
["Alakourtti"]="Alakourtti",
["Kittila"]="Kittila",
["Bardufoss"]="Bardufoss",
["Alta"]="Alta",
["Sodankyla"]="Sodankyla",
["Enontekio"]="Enontekio",
["Evenes"]="Evenes",
["Hosio"]="Hosio",
}
AIRBASE.Afghanistan={
["Bagram"]="Bagram",
["Bamyan"]="Bamyan",
["Bost"]="Bost",
["Camp_Bastion"]="Camp Bastion",
["Camp_Bastion_Heliport"]="Camp Bastion Heliport",
["Chaghcharan"]="Chaghcharan",
["Dwyer"]="Dwyer",
["Farah"]="Farah",
["Gardez"]="Gardez",
["Ghazni_Heliport"]="Ghazni Heliport",
["Herat"]="Herat",
["Jalalabad"]="Jalalabad",
["Kabul"]="Kabul",
["Kandahar"]="Kandahar",
["Kandahar_Heliport"]="Kandahar Heliport",
["Khost"]="Khost",
["Khost_Heliport"]="Khost Heliport",
["Maymana_Zahiraddin_Faryabi"]="Maymana Zahiraddin Faryabi",
["Nimroz"]="Nimroz",
["Qala_i_Naw"]="Qala i Naw",
["Sharana"]="Sharana",
["Shindand"]="Shindand",
["Shindand_Heliport"]="Shindand Heliport",
["Tarinkot"]="Tarinkot",
["Urgoon_Heliport"]="Urgoon Heliport",
}
AIRBASE.Iraq={
["Baghdad_International_Airport"]="Baghdad International Airport",
["Sulaimaniyah_International_Airport"]="Sulaimaniyah International Airport",
["Al_Sahra_Airport"]="Al-Sahra Airport",
["Erbil_International_Airport"]="Erbil International Airport",
["Al_Taji_Airport"]="Al-Taji Airport",
["Al_Asad_Airbase"]="Al-Asad Airbase",
["Al_Salam_Airbase"]="Al-Salam Airbase",
["Balad_Airbase"]="Balad Airbase",
["Kirkuk_International_Airport"]="Kirkuk International Airport",
["Bashur_Airport"]="Bashur Airport",
["Al_Taquddum_Airport"]="Al-Taquddum Airport",
["Qayyarah_Airfield_West"]="Qayyarah Airfield West",
["K1_Base"]="K1 Base",
}
AIRBASE.GermanyCW={
["Airracing_Frankfurt"]="Airracing Frankfurt",
["Airracing_Koblenz"]="Airracing Koblenz",
["Airracing_Luebeck"]="Airracing Lubeck",
["Allstedt"]="Allstedt",
["Altes_Lager"]="Altes Lager",
["Bad_Duerkheim"]="Bad Durkheim",
["Barth"]="Barth",
["Bienenfarm"]="Bienenfarm",
["Bindersleben"]="Bindersleben",
["Bitburg"]="Bitburg",
["Braunschweig"]="Braunschweig",
["Bremen"]="Bremen",
["Briest"]="Briest",
["Buechel"]="Buchel",
["Bueckeburg"]="Buckeburg",
["Celle"]="Celle",
["Cochstedt"]="Cochstedt",
["Damgarten"]="Damgarten",
["Dedelow"]="Dedelow",
["Dessau"]="Dessau",
["Fassberg"]="Fassberg",
["Finow"]="Finow",
["Frankfurt"]="Frankfurt",
["Fritzlar"]="Fritzlar",
["Fulda"]="Fulda",
["Gardelegen"]="Gardelegen",
["Garz"]="Garz",
["Gatow"]="Gatow",
["Gelnhausen"]="Gelnhausen",
["Giebelstadt"]="Giebelstadt",
["Glindbruchkippe"]="Glindbruchkippe ",
["Gross_Mohrdorf"]="Gross Mohrdorf",
["Grosse_Wiese"]="Grosse Wiese",
["Guetersloh"]="Gutersloh",
["H_FRG_01"]="H FRG 01",
["H_FRG_02"]="H FRG 02",
["H_FRG_03"]="H FRG 03",
["H_FRG_04"]="H FRG 04",
["H_FRG_05"]="H FRG 05",
["H_FRG_06"]="H FRG 06",
["H_FRG_07"]="H FRG 07",
["H_FRG_08"]="H FRG 08",
["H_FRG_09"]="H FRG 09",
["H_FRG_10"]="H FRG 10",
["H_FRG_11"]="H FRG 11",
["H_FRG_12"]="H FRG 12",
["H_FRG_13"]="H FRG 13",
["H_FRG_14"]="H FRG 14",
["H_FRG_15"]="H FRG 15",
["H_FRG_16"]="H FRG 16",
["H_FRG_17"]="H FRG 17",
["H_FRG_18"]="H FRG 18",
["H_FRG_19"]="H FRG 19",
["H_FRG_20"]="H FRG 20",
["H_FRG_21"]="H FRG 21",
["H_FRG_23"]="H FRG 23",
["H_FRG_25"]="H FRG 25",
["H_FRG_27"]="H FRG 27",
["H_FRG_30"]="H FRG 30",
["H_FRG_31"]="H FRG 31",
["H_FRG_32"]="H FRG 32",
["H_FRG_34"]="H FRG 34",
["H_FRG_38"]="H FRG 38",
["H_FRG_39"]="H FRG 39",
["H_FRG_40"]="H FRG 40",
["H_FRG_41"]="H FRG 41",
["H_FRG_42"]="H FRG 42",
["H_FRG_43"]="H FRG 43",
["H_FRG_44"]="H FRG 44",
["H_FRG_45"]="H FRG 45",
["H_FRG_46"]="H FRG 46",
["H_FRG_47"]="H FRG 47",
["H_FRG_48"]="H FRG 48",
["H_FRG_49"]="H FRG 49",
["H_FRG_50"]="H FRG 50",
["H_FRG_51"]="H FRG 51",
["H_GDR_01"]="H GDR 01",
["H_GDR_02"]="H GDR 02",
["H_GDR_03"]="H GDR 03",
["H_GDR_04"]="H GDR 04",
["H_GDR_05"]="H GDR 05",
["H_GDR_06"]="H GDR 06",
["H_GDR_07"]="H GDR 07",
["H_GDR_08"]="H GDR 08",
["H_GDR_09"]="H GDR 09",
["H_GDR_10"]="H GDR 10",
["H_GDR_11"]="H GDR 11",
["H_GDR_12"]="H GDR 12",
["H_GDR_13"]="H GDR 13",
["H_GDR_14"]="H GDR 14",
["H_GDR_15"]="H GDR 15",
["H_GDR_16"]="H GDR 16",
["H_GDR_17"]="H GDR 17",
["H_GDR_18"]="H GDR 18",
["H_GDR_19"]="H GDR 19",
["H_GDR_21"]="H GDR 21",
["H_GDR_22"]="H GDR 22",
["H_GDR_24"]="H GDR 24",
["H_GDR_25"]="H GDR 25",
["H_GDR_26"]="H GDR 26",
["H_GDR_30"]="H GDR 30",
["H_GDR_31"]="H GDR 31",
["H_GDR_32"]="H GDR 32",
["H_GDR_33"]="H GDR 33",
["H_GDR_34"]="H GDR 34",
["H_Med_FRG_01"]="H Med FRG 01",
["H_Med_FRG_02"]="H Med FRG 02",
["H_Med_FRG_04"]="H Med FRG 04",
["H_Med_FRG_06"]="H Med FRG 06",
["H_Med_FRG_11"]="H Med FRG 11",
["H_Med_FRG_12"]="H Med FRG 12",
["H_Med_FRG_13"]="H Med FRG 13",
["H_Med_FRG_14"]="H Med FRG 14",
["H_Med_FRG_15"]="H Med FRG 15",
["H_Med_FRG_16"]="H Med FRG 16",
["H_Med_FRG_17"]="H Med FRG 17",
["H_Med_FRG_21"]="H Med FRG 21",
["H_Med_FRG_24"]="H Med FRG 24",
["H_Med_FRG_26"]="H Med FRG 26",
["H_Med_FRG_27"]="H Med FRG 27",
["H_Med_FRG_29"]="H Med FRG 29",
["H_Med_GDR_01"]="H Med GDR 01",
["H_Med_GDR_02"]="H Med GDR 02",
["H_Med_GDR_03"]="H Med GDR 03",
["H_Med_GDR_08"]="H Med GDR 08",
["H_Med_GDR_09"]="H Med GDR 09",
["H_Med_GDR_10"]="H Med GDR 10",
["H_Med_GDR_11"]="H Med GDR 11",
["H_Med_GDR_12"]="H Med GDR 12",
["H_Med_GDR_13"]="H Med GDR 13",
["H_Med_GDR_14"]="H Med GDR 14",
["H_Med_GDR_16"]="H Med GDR 16",
["H_Radar_FRG_02"]="H Radar FRG 02",
["H_Radar_GDR_01"]="H Radar GDR 01",
["H_Radar_GDR_02"]="H Radar GDR 02",
["H_Radar_GDR_03"]="H Radar GDR 03",
["H_Radar_GDR_04"]="H Radar GDR 04",
["H_Radar_GDR_05"]="H Radar GDR 05",
["H_Radar_GDR_06"]="H Radar GDR 06",
["H_Radar_GDR_07"]="H Radar GDR 07",
["H_Radar_GDR_08"]="H Radar GDR 08",
["H_Radar_GDR_09"]="H Radar GDR 09",
["Hahn"]="Hahn",
["Haina"]="Haina",
["Hamburg"]="Hamburg",
["Hamburg_Finkenwerder"]="Hamburg Finkenwerder",
["Hannover"]="Hannover",
["Hasselfelde"]="Hasselfelde",
["Herrenteich"]="Herrenteich",
["Hildesheim"]="Hildesheim",
["Hockenheim"]="Hockenheim",
["Holzdorf"]="Holzdorf",
["Kammermark"]="Kammermark",
["Koethen"]="Kothen",
["Laage"]="Laage",
["Langenselbold"]="Langenselbold",
["Laerz"]="Larz",
["Leipzig_Halle"]="Leipzig Halle",
["Leipzig_Mockau"]="Leipzig Mockau",
["Luebeck"]="Lubeck",
["Lueneburg"]="Luneburg",
["Mahlwinkel"]="Mahlwinkel",
["Mendig"]="Mendig",
["Merseburg"]="Merseburg",
["Neubrandenburg"]="Neubrandenburg",
["Neuruppin"]="Neuruppin",
["Northeim"]="Northeim",
["Ober_Moerlen"]="Ober-Morlen",
["Obermehler_Schlotheim"]="Obermehler Schlotheim",
["Parchim"]="Parchim",
["Peenemuende"]="Peenemunde",
["Pferdsfeld"]="Pferdsfeld",
["Pinnow"]="Pinnow",
["Pottschutthoehe"]="Pottschutthohe",
["Ramstein"]="Ramstein",
["Rinteln"]="Rinteln",
["Schoenefeld"]="Schonefeld",
["Schweinfurt"]="Schweinfurt",
["Sembach"]="Sembach",
["Spangdahlem"]="Spangdahlem",
["Sperenberg"]="Sperenberg",
["Stendal"]="Stendal",
["Tegel"]="Tegel",
["Tempelhof"]="Tempelhof",
["Templin"]="Templin",
["Tutow"]="Tutow",
["Uelzen"]="Uelzen",
["Uetersen"]="Uetersen",
["Ummern"]="Ummern",
["Verden_Scharnhorst"]="Verden-Scharnhorst",
["Walldorf"]="Walldorf",
["Waren_Vielist"]="Waren Vielist",
["Werneuchen"]="Werneuchen",
["Weser_Wuemme"]="Weser Wumme",
["Wiesbaden"]="Wiesbaden",
["Wismar"]="Wismar",
["Wittstock"]="Wittstock",
["Worms"]="Worms",
["Wunstorf"]="Wunstorf",
["Zerbst"]="Zerbst",
["Zweibruecken"]="Zweibrucken",
}
AIRBASE.TerminalType={
Runway=16,
HelicopterOnly=40,
Shelter=68,
OpenMed=72,
SmallSizeFighter=100,
OpenBig=104,
OpenMedOrBig=176,
HelicopterUsable=216,
FighterAircraft=244,
FighterAircraftSmall=344,
}
AIRBASE.SpotStatus={
FREE="Free",
OCCUPIED="Occupied",
RESERVED="Reserved",
}
function AIRBASE:Register(AirbaseName)
local self=BASE:Inherit(self,POSITIONABLE:New(AirbaseName))
self.AirbaseName=AirbaseName
self.AirbaseID=self:GetID(true)
self.descriptors=self:GetDesc()
self.category=self.descriptors and self.descriptors.category or Airbase.Category.AIRDROME
if self.category==Airbase.Category.AIRDROME then
self.isAirdrome=true
elseif self.category==Airbase.Category.HELIPAD or self.descriptors.typeName=="FARP_SINGLE_01"then
self.isHelipad=true
self.category=Airbase.Category.HELIPAD
elseif self.category==Airbase.Category.SHIP then
self.isShip=true
if self.descriptors.typeName=="Oil rig"or self.descriptors.typeName=="Ga"then
self.isHelipad=true
self.isShip=false
self.category=Airbase.Category.HELIPAD
_DATABASE:AddStatic(AirbaseName)
end
else
self:E("ERROR: Unknown airbase category!")
end
self:_InitRunways()
local Nrunways=#self.runways
if Nrunways>0 then
self:SetActiveRunway()
end
self:_InitParkingSpots()
if self.category==Airbase.Category.AIRDROME and(Nrunways==0 or self.NparkingTotal==self.NparkingTerminal[AIRBASE.TerminalType.HelicopterOnly])then
self.category=Airbase.Category.HELIPAD
self.isAirdrome=true
self.isHelipad=true
end
local vec2=self:GetVec2()
self:GetCoordinate()
self.storage=_DATABASE:AddStorage(AirbaseName)
if vec2 then
if self.isShip then
local unit=UNIT:FindByName(AirbaseName)
if unit then
self.AirbaseZone=ZONE_UNIT:New(AirbaseName,unit,2500)
end
else
self.AirbaseZone=ZONE_RADIUS:New(AirbaseName,vec2,2500)
end
else
self:E(string.format("ERROR: Cound not get position Vec2 of airbase %s",AirbaseName))
end
self:T2(string.format("Registered airbase %s",tostring(self.AirbaseName)))
return self
end
function AIRBASE:_GetCategory()
local name=self.AirbaseName
local static=StaticObject.getByName(name)
local airbase=Airbase.getByName(name)
local unit=Unit.getByName(name)
local text=string.format("\n=====================================================")
text=text..string.format("\nAirbase %s:",name)
if static then
local oc,uc=static:getCategory()
local ex=static:getCategoryEx()
text=text..string.format("\nSTATIC: oc=%d, uc=%d, ex=%d",oc,uc,ex)
text=text..string.format("\n--------------------------------------------------")
end
if unit then
local oc,uc=unit:getCategory()
local ex=unit:getCategoryEx()
text=text..string.format("\nUNIT: oc=%d, uc=%d, ex=%d",oc,uc,ex)
text=text..string.format("\n--------------------------------------------------")
end
if airbase then
local oc,uc=airbase:getCategory()
local ex=airbase:getCategoryEx()
text=text..string.format("\nAIRBASE: oc=%d, uc=%d, ex=%d",oc,uc,ex)
text=text..string.format("\n--------------------------------------------------")
text=text..UTILS.PrintTableToLog(airbase:getDesc(),nil,true)
end
text=text..string.format("\n=====================================================")
env.info(text)
end
function AIRBASE:Find(DCSAirbase)
local AirbaseName=DCSAirbase:getName()
local AirbaseFound=_DATABASE:FindAirbase(AirbaseName)
return AirbaseFound
end
function AIRBASE:FindByName(AirbaseName)
local AirbaseFound=_DATABASE:FindAirbase(AirbaseName)
return AirbaseFound
end
function AIRBASE:FindByID(id)
for name,_airbase in pairs(_DATABASE.AIRBASES)do
local airbase=_airbase
local aid=tonumber(airbase:GetID(true))
if aid==id then
return airbase
end
end
return nil
end
function AIRBASE:GetDCSObject()
local DCSAirbase=Airbase.getByName(self.AirbaseName)
if DCSAirbase then
return DCSAirbase
end
return nil
end
function AIRBASE:GetZone()
return self.AirbaseZone
end
function AIRBASE:GetWarehouse()
local warehouse=nil
local airbase=self:GetDCSObject()
if airbase and Airbase.getWarehouse then
warehouse=airbase:getWarehouse()
end
return warehouse
end
function AIRBASE:GetStorage()
return self.storage
end
function AIRBASE:SetAutoCapture(Switch)
local airbase=self:GetDCSObject()
if airbase then
airbase:autoCapture(Switch)
end
return self
end
function AIRBASE:SetAutoCaptureON()
self:SetAutoCapture(true)
return self
end
function AIRBASE:SetAutoCaptureOFF()
self:SetAutoCapture(false)
return self
end
function AIRBASE:IsAutoCapture()
local airbase=self:GetDCSObject()
local auto=nil
if airbase then
auto=airbase:autoCaptureIsOn()
end
return auto
end
function AIRBASE:SetCoalition(Coal)
local airbase=self:GetDCSObject()
if airbase then
airbase:setCoalition(Coal)
end
return self
end
function AIRBASE.GetAllAirbases(coalition,category)
local airbases={}
for _,_airbase in pairs(_DATABASE.AIRBASES)do
local airbase=_airbase
if coalition==nil or airbase:GetCoalition()==coalition then
if category==nil or category==airbase:GetAirbaseCategory()then
table.insert(airbases,airbase)
end
end
end
return airbases
end
function AIRBASE.GetAllAirbaseNames(coalition,category)
local airbases={}
for airbasename,_airbase in pairs(_DATABASE.AIRBASES)do
local airbase=_airbase
if coalition==nil or airbase:GetCoalition()==coalition then
if category==nil or category==airbase:GetAirbaseCategory()then
table.insert(airbases,airbasename)
end
end
end
return airbases
end
function AIRBASE:GetID(unique)
if self.AirbaseID then
return unique and self.AirbaseID or math.abs(self.AirbaseID)
else
for DCSAirbaseId,DCSAirbase in ipairs(world.getAirbases())do
local AirbaseName=DCSAirbase:getName()
local airbaseID=tonumber(DCSAirbase:getID())
local airbaseCategory=self:GetAirbaseCategory()
if AirbaseName==self.AirbaseName then
if airbaseCategory==Airbase.Category.SHIP or airbaseCategory==Airbase.Category.HELIPAD then
return unique and-airbaseID or airbaseID
else
return airbaseID
end
end
end
end
return nil
end
function AIRBASE:SetParkingSpotWhitelist(TerminalIdWhitelist)
if TerminalIdWhitelist==nil then
self.parkingWhitelist={}
return self
end
if type(TerminalIdWhitelist)~="table"then
TerminalIdWhitelist={TerminalIdWhitelist}
end
self.parkingWhitelist=TerminalIdWhitelist
return self
end
function AIRBASE:SetParkingSpotBlacklist(TerminalIdBlacklist)
if TerminalIdBlacklist==nil then
self.parkingBlacklist={}
return self
end
if type(TerminalIdBlacklist)~="table"then
TerminalIdBlacklist={TerminalIdBlacklist}
end
self.parkingBlacklist=TerminalIdBlacklist
return self
end
function AIRBASE:SetRadioSilentMode(Silent)
local airbase=self:GetDCSObject()
if airbase then
airbase:setRadioSilentMode(Silent)
end
return self
end
function AIRBASE:GetRadioSilentMode()
local silent=nil
local airbase=self:GetDCSObject()
if airbase then
silent=airbase:getRadioSilentMode()
end
return silent
end
function AIRBASE:GetAirbaseCategory()
return self.category
end
function AIRBASE:IsAirdrome()
return self.isAirdrome
end
function AIRBASE:IsHelipad()
return self.isHelipad
end
function AIRBASE:IsShip()
return self.isShip
end
function AIRBASE:GetParkingData(available)
self:F2(available)
local DCSAirbase=self:GetDCSObject()
local parkingdata=nil
if DCSAirbase then
parkingdata=DCSAirbase:getParking(available)
end
self:T2({parkingdata=parkingdata})
return parkingdata
end
function AIRBASE:GetParkingSpotsNumber(termtype)
local parkingdata=self:GetParkingData(false)
local nspots=0
for _,parkingspot in pairs(parkingdata)do
if AIRBASE._CheckTerminalType(parkingspot.Term_Type,termtype)then
nspots=nspots+1
end
end
return nspots
end
function AIRBASE:GetFreeParkingSpotsNumber(termtype,allowTOAC)
local parkingdata=self:GetParkingData(true)
local nfree=0
for _,parkingspot in pairs(parkingdata)do
if AIRBASE._CheckTerminalType(parkingspot.Term_Type,termtype)then
if(allowTOAC and allowTOAC==true)or parkingspot.TO_AC==false then
nfree=nfree+1
end
end
end
return nfree
end
function AIRBASE:GetFreeParkingSpotsCoordinates(termtype,allowTOAC)
local parkingdata=self:GetParkingData(true)
local spots={}
for _,parkingspot in pairs(parkingdata)do
if AIRBASE._CheckTerminalType(parkingspot.Term_Type,termtype)then
if(allowTOAC and allowTOAC==true)or parkingspot.TO_AC==false then
table.insert(spots,COORDINATE:NewFromVec3(parkingspot.vTerminalPos))
end
end
end
return spots
end
function AIRBASE:GetParkingSpotsCoordinates(termtype)
local parkingdata=self:GetParkingData(false)
local spots={}
for _,parkingspot in ipairs(parkingdata)do
if AIRBASE._CheckTerminalType(parkingspot.Term_Type,termtype)then
local _coord=COORDINATE:NewFromVec3(parkingspot.vTerminalPos)
table.insert(spots,_coord)
end
end
return spots
end
function AIRBASE:_InitParkingSpots()
local parkingdata=self:GetParkingData(false)
self.parking={}
self.parkingByID={}
self.NparkingTotal=0
self.NparkingTerminal={}
for _,terminalType in pairs(AIRBASE.TerminalType)do
self.NparkingTerminal[terminalType]=0
end
local function isClient(coord)
local clients=_DATABASE.CLIENTS
for clientname,_client in pairs(clients)do
local client=_client
if client and client.SpawnCoord then
local dist=client.SpawnCoord:Get2DDistance(coord)
if dist<2 then
return true,clientname
end
end
end
return false,nil
end
for _,spot in pairs(parkingdata)do
local park={}
park.Vec3=spot.vTerminalPos
park.Coordinate=COORDINATE:NewFromVec3(spot.vTerminalPos)
park.DistToRwy=spot.fDistToRW
park.Free=nil
park.TerminalID=spot.Term_Index
park.TerminalID0=spot.Term_Index_0
park.TerminalType=spot.Term_Type
park.TOAC=spot.TO_AC
park.ClientSpot,park.ClientName=isClient(park.Coordinate)
park.AirbaseName=self.AirbaseName
self.NparkingTotal=self.NparkingTotal+1
for _,terminalType in pairs(AIRBASE.TerminalType)do
if self._CheckTerminalType(park.TerminalType,terminalType)then
self.NparkingTerminal[terminalType]=self.NparkingTerminal[terminalType]+1
end
end
self.parkingByID[park.TerminalID]=park
table.insert(self.parking,park)
end
self.NparkingTotal=self.NparkingTotal-self.NparkingTerminal[AIRBASE.TerminalType.Runway]
return self
end
function AIRBASE:_GetParkingSpotByID(TerminalID)
return self.parkingByID[TerminalID]
end
function AIRBASE:GetParkingSpotsTable(termtype)
local parkingdata=self:GetParkingData(false)
local parkingfree=self:GetParkingData(true)
local function _isfree(_tocheck)
for _,_spot in pairs(parkingfree)do
if _spot.Term_Index==_tocheck.Term_Index then
return true
end
end
return false
end
local spots={}
for _,_spot in pairs(parkingdata)do
if AIRBASE._CheckTerminalType(_spot.Term_Type,termtype)then
local spot=self:_GetParkingSpotByID(_spot.Term_Index)
if spot then
spot.Free=_isfree(_spot)
spot.TOAC=_spot.TO_AC
spot.AirbaseName=self.AirbaseName
table.insert(spots,spot)
else
self:E(string.format("ERROR: Parking spot %s is nil!",tostring(_spot.Term_Index)))
end
end
end
return spots
end
function AIRBASE:GetFreeParkingSpotsTable(termtype,allowTOAC)
local parkingfree=self:GetParkingData(true)
local freespots={}
for _,_spot in pairs(parkingfree)do
if AIRBASE._CheckTerminalType(_spot.Term_Type,termtype)then
if(allowTOAC and allowTOAC==true)or _spot.TO_AC==false then
local spot=self:_GetParkingSpotByID(_spot.Term_Index)
spot.Free=true
spot.TOAC=_spot.TO_AC
spot.AirbaseName=self.AirbaseName
table.insert(freespots,spot)
end
end
end
return freespots
end
function AIRBASE:GetParkingSpotData(TerminalID)
local parkingdata=self:GetParkingSpotsTable()
for _,_spot in pairs(parkingdata)do
local spot=_spot
self:T({TerminalID=spot.TerminalID,TerminalType=spot.TerminalType})
if TerminalID==spot.TerminalID then
return spot
end
end
self:E("ERROR: Could not find spot with Terminal ID="..tostring(TerminalID))
return nil
end
function AIRBASE:MarkParkingSpots(termtype,mark)
if mark==nil then
mark=true
end
local parkingdata=self:GetParkingSpotsTable(termtype)
local airbasename=self:GetName()
self:E(string.format("Parking spots at %s for terminal type %s:",airbasename,tostring(termtype)))
for _,_spot in pairs(parkingdata)do
local _text=string.format("Term Index=%d, Term Type=%d, Free=%s, TOAC=%s, Term ID0=%d, Dist2Rwy=%.1f m",
_spot.TerminalID,_spot.TerminalType,tostring(_spot.Free),tostring(_spot.TOAC),_spot.TerminalID0,_spot.DistToRwy)
if mark then
_spot.Coordinate:MarkToAll(_text)
end
local _text=string.format("%s, Term Index=%3d, Term Type=%03d, Free=%5s, TOAC=%5s, Term ID0=%3d, Dist2Rwy=%.1f m",
airbasename,_spot.TerminalID,_spot.TerminalType,tostring(_spot.Free),tostring(_spot.TOAC),_spot.TerminalID0,_spot.DistToRwy)
self:E(_text)
end
end
function AIRBASE:FindFreeParkingSpotForAircraft(group,terminaltype,scanradius,scanunits,scanstatics,scanscenery,verysafe,nspots,parkingdata)
scanradius=scanradius or 50
if scanunits==nil then
scanunits=true
end
if scanstatics==nil then
scanstatics=true
end
if scanscenery==nil then
scanscenery=false
end
if verysafe==nil then
verysafe=false
end
local function _overlap(object1,object2,dist)
local pos1=object1
local pos2=object2
local r1=pos1:GetBoundingRadius()
local r2=pos2:GetBoundingRadius()
if r1 and r2 then
local safedist=(r1+r2)*1.1
local safe=(dist>safedist)
self:T2(string.format("r1=%.1f r2=%.1f s=%.1f d=%.1f ==> safe=%s",r1,r2,safedist,dist,tostring(safe)))
return safe
else
return true
end
end
local airport=self:GetName()
parkingdata=parkingdata or self:GetParkingSpotsTable(terminaltype)
local aircraft=nil
local _aircraftsize=23
local ax=23
local ay=7
local az=17
if group and group.ClassName=="GROUP"then
aircraft=group:GetUnit(1)
if aircraft then
_aircraftsize,ax,ay,az=aircraft:GetObjectSize()
end
end
local _nspots=nspots or group:GetSize()
self:T(string.format("%s: Looking for %d parking spot(s) for aircraft of size %.1f m (x=%.1f,y=%.1f,z=%.1f) at terminal type %s.",airport,_nspots,_aircraftsize,ax,ay,az,tostring(terminaltype)))
local validspots={}
local nvalid=0
local _test=false
if _test then
return validspots
end
local markobstacles=false
for _,parkingspot in pairs(parkingdata)do
local _spot=parkingspot.Coordinate
local _termid=parkingspot.TerminalID
if AIRBASE._CheckTerminalType(parkingspot.TerminalType,terminaltype)and self:_CheckParkingLists(_termid)then
if verysafe and(parkingspot.Free==false or parkingspot.TOAC==true)then
self:T(string.format("%s: Parking spot id %d NOT free (or aircraft has not taken off yet). Free=%s, TOAC=%s.",airport,parkingspot.TerminalID,tostring(parkingspot.Free),tostring(parkingspot.TOAC)))
else
local _,_,_,_units,_statics,_sceneries=_spot:ScanObjects(scanradius,scanunits,scanstatics,scanscenery)
local occupied=false
for _,unit in pairs(_units)do
local _coord=unit:GetCoordinate()
local _dist=_coord:Get2DDistance(_spot)
local _safe=_overlap(aircraft,unit,_dist)
if markobstacles then
local l,x,y,z=unit:GetObjectSize()
_coord:MarkToAll(string.format("Unit %s\nx=%.1f y=%.1f z=%.1f\nl=%.1f d=%.1f\nspot %d safe=%s",unit:GetName(),x,y,z,l,_dist,_termid,tostring(_safe)))
end
if scanunits and not _safe then
occupied=true
end
end
for _,static in pairs(_statics)do
local _static=STATIC:Find(static)
local _vec3=static:getPoint()
local _coord=COORDINATE:NewFromVec3(_vec3)
local _dist=_coord:Get2DDistance(_spot)
local _safe=_overlap(aircraft,_static,_dist)
if markobstacles then
local l,x,y,z=_static:GetObjectSize()
_coord:MarkToAll(string.format("Static %s\nx=%.1f y=%.1f z=%.1f\nl=%.1f d=%.1f\nspot %d safe=%s",static:getName(),x,y,z,l,_dist,_termid,tostring(_safe)))
end
if scanstatics and not _safe then
occupied=true
end
end
for _,scenery in pairs(_sceneries)do
local _scenery=SCENERY:Register(scenery:getTypeName(),scenery)
local _vec3=scenery:getPoint()
local _coord=COORDINATE:NewFromVec3(_vec3)
local _dist=_coord:Get2DDistance(_spot)
local _safe=_overlap(aircraft,_scenery,_dist)
if markobstacles then
local l,x,y,z=scenery:GetObjectSize(scenery)
_coord:MarkToAll(string.format("Scenery %s\nx=%.1f y=%.1f z=%.1f\nl=%.1f d=%.1f\nspot %d safe=%s",scenery:getTypeName(),x,y,z,l,_dist,_termid,tostring(_safe)))
end
if scanscenery and not _safe then
occupied=true
end
end
for _,_takenspot in pairs(validspots)do
local _dist=_takenspot.Coordinate:Get2DDistance(_spot)
local _safe=_overlap(aircraft,aircraft,_dist)
if not _safe then
occupied=true
end
end
if occupied then
self:T(string.format("%s: Parking spot id %d occupied.",airport,_termid))
else
self:T(string.format("%s: Parking spot id %d free.",airport,_termid))
if nvalid<_nspots then
table.insert(validspots,{Coordinate=_spot,TerminalID=_termid})
end
nvalid=nvalid+1
self:T(string.format("%s: Parking spot id %d free. Nfree=%d/%d.",airport,_termid,nvalid,_nspots))
end
end
if nvalid>=_nspots then
return validspots
end
end
end
return validspots
end
function AIRBASE:_CheckParkingLists(TerminalID)
if self.parkingBlacklist and#self.parkingBlacklist>0 then
for _,terminalID in pairs(self.parkingBlacklist or{})do
if terminalID==TerminalID then
return false
end
end
end
if self.parkingWhitelist and#self.parkingWhitelist>0 then
for _,terminalID in pairs(self.parkingWhitelist or{})do
if terminalID==TerminalID then
return true
end
end
return false
end
return true
end
function AIRBASE._CheckTerminalType(Term_Type,termtype)
if Term_Type==nil then
return false
end
if termtype==nil then
if Term_Type==AIRBASE.TerminalType.Runway then
return false
else
return true
end
end
local match=false
if Term_Type==termtype then
match=true
end
if termtype==AIRBASE.TerminalType.OpenMedOrBig then
if Term_Type==AIRBASE.TerminalType.OpenMed or Term_Type==AIRBASE.TerminalType.OpenBig then
match=true
end
elseif termtype==AIRBASE.TerminalType.HelicopterUsable then
if Term_Type==AIRBASE.TerminalType.OpenMed or Term_Type==AIRBASE.TerminalType.OpenBig or Term_Type==AIRBASE.TerminalType.HelicopterOnly then
match=true
end
elseif termtype==AIRBASE.TerminalType.FighterAircraft then
if Term_Type==AIRBASE.TerminalType.OpenMed or Term_Type==AIRBASE.TerminalType.OpenBig or Term_Type==AIRBASE.TerminalType.Shelter then
match=true
end
elseif termtype==AIRBASE.TerminalType.FighterAircraftSmall then
if Term_Type==AIRBASE.TerminalType.OpenMed or Term_Type==AIRBASE.TerminalType.OpenBig or Term_Type==AIRBASE.TerminalType.Shelter or Term_Type==AIRBASE.TerminalType.SmallSizeFighter then
match=true
end
end
return match
end
function AIRBASE:GetRunways()
return self.runways or{}
end
function AIRBASE:GetRunwayByName(Name)
if Name==nil then
return
end
if Name then
for _,_runway in pairs(self.runways)do
local runway=_runway
local name=self:GetRunwayName(runway)
self:T("Check Runway Name: "..name)
if name==Name:upper()then
return runway
end
end
end
self:E("ERROR: Could not find runway with name "..tostring(Name))
return nil
end
function AIRBASE:_InitRunways(IncludeInverse)
if IncludeInverse==nil then
IncludeInverse=true
end
local Runways={}
local function _createRunway(name,course,width,length,center)
self:T("Create Runway: name = "..name)
local bearing=-1*course
local heading=math.deg(bearing)
local runway={}
local namefromheading=math.floor(heading/10)
if self.AirbaseName==AIRBASE.Syria.Beirut_Rafic_Hariri and math.abs(namefromheading-name)>1 then
runway.name=string.format("%02d",tonumber(namefromheading))
else
runway.name=string.format("%02d",tonumber(name))
end
runway.magheading=tonumber(runway.name)*10
runway.heading=heading
runway.width=width or 0
runway.length=length or 0
runway.center=COORDINATE:NewFromVec3(center)
if runway.heading>360 then
runway.heading=runway.heading-360
elseif runway.heading<0 then
runway.heading=runway.heading+360
end
if math.abs(runway.heading-runway.magheading)>60 then
self:T(string.format("WARNING: Runway %s: heading=%.1f magheading=%.1f",runway.name,runway.heading,runway.magheading))
runway.heading=runway.heading-180
end
if runway.heading>360 then
runway.heading=runway.heading-360
elseif runway.heading<0 then
runway.heading=runway.heading+360
end
runway.position=runway.center:Translate(-runway.length/2,runway.heading)
runway.endpoint=runway.center:Translate(runway.length/2,runway.heading)
local init=runway.center:GetVec3()
local width=runway.width/2
local L2=runway.length/2
local offset1={x=init.x+(math.cos(bearing+math.pi)*L2),y=init.z+(math.sin(bearing+math.pi)*L2)}
local offset2={x=init.x-(math.cos(bearing+math.pi)*L2),y=init.z-(math.sin(bearing+math.pi)*L2)}
local points={}
points[1]={x=offset1.x+(math.cos(bearing+(math.pi/2))*width),y=offset1.y+(math.sin(bearing+(math.pi/2))*width)}
points[2]={x=offset1.x+(math.cos(bearing-(math.pi/2))*width),y=offset1.y+(math.sin(bearing-(math.pi/2))*width)}
points[3]={x=offset2.x+(math.cos(bearing-(math.pi/2))*width),y=offset2.y+(math.sin(bearing-(math.pi/2))*width)}
points[4]={x=offset2.x+(math.cos(bearing+(math.pi/2))*width),y=offset2.y+(math.sin(bearing+(math.pi/2))*width)}
runway.zone=ZONE_POLYGON_BASE:New(string.format("%s Runway %s",self.AirbaseName,runway.name),points)
return runway
end
local airbase=self:GetDCSObject()
if airbase then
local runways=airbase:getRunways()
self:T2(runways)
if runways and#runways>0 then
for _,rwy in pairs(runways)do
self:T(rwy)
local runway=_createRunway(rwy.Name,rwy.course,rwy.width,rwy.length,rwy.position)
table.insert(Runways,runway)
if IncludeInverse then
local idx=tonumber(runway.name)
local name2=tostring(idx-18)
if idx<18 then
name2=tostring(idx+18)
end
local runway=_createRunway(name2,rwy.course-math.pi,rwy.width,rwy.length,rwy.position)
table.insert(Runways,runway)
end
end
else
self.runways={}
return{}
end
end
local rpairs={}
for i,_ri in pairs(Runways)do
local ri=_ri
for j,_rj in pairs(Runways)do
local rj=_rj
if i<j then
if ri.name==rj.name then
rpairs[i]=j
end
end
end
end
local function isLeft(a,b,c)
return((b.z-a.z)*(c.x-a.x)-(b.x-a.x)*(c.z-a.z))>0
end
for i,j in pairs(rpairs)do
local ri=Runways[i]
local rj=Runways[j]
local c0=ri.center
local a=UTILS.VecTranslate(c0,1000,ri.heading)
local b=UTILS.VecSubstract(rj.center,ri.center)
b=UTILS.VecAdd(ri.center,b)
local left=isLeft(c0,a,b)
if left then
ri.isLeft=false
rj.isLeft=true
else
ri.isLeft=true
rj.isLeft=false
end
end
self.runways=Runways
return Runways
end
function AIRBASE:GetRunwayData(magvar,mark)
local runways={}
if self:GetAirbaseCategory()~=Airbase.Category.AIRDROME then
return{}
end
local runwaycoords=self:GetParkingSpotsCoordinates(AIRBASE.TerminalType.Runway)
if false then
for i,_coord in pairs(runwaycoords)do
local coord=_coord
coord:Translate(100,0):MarkToAll("Runway i="..i)
end
end
magvar=magvar or UTILS.GetMagneticDeclination()
local N=#runwaycoords
local N2=N/2
local exception=false
local name=self:GetName()
if name==AIRBASE.Nevada.Jean_Airport or
name==AIRBASE.Nevada.Creech_AFB or
name==AIRBASE.PersianGulf.Abu_Dhabi_International_Airport or
name==AIRBASE.PersianGulf.Dubai_Intl or
name==AIRBASE.PersianGulf.Shiraz_International_Airport or
name==AIRBASE.PersianGulf.Kish_International_Airport or
name==AIRBASE.MarianaIslands.Andersen_AFB then
exception=1
elseif UTILS.GetDCSMap()==DCSMAP.Syria and N>=2 and
name~=AIRBASE.Syria.Minakh and
name~=AIRBASE.Syria.Damascus and
name~=AIRBASE.Syria.Khalkhalah and
name~=AIRBASE.Syria.Marj_Ruhayyil and
name~=AIRBASE.Syria.Beirut_Rafic_Hariri then
exception=2
end
local function f(i)
local j
if exception==1 then
j=N-(i-1)
elseif exception==2 then
if i<=N2 then
j=i+N2
else
j=i-N2
end
else
if i%2==0 then
j=i-1
else
j=i+1
end
end
if name==AIRBASE.Syria.Beirut_Rafic_Hariri then
if i==1 then
j=3
elseif i==2 then
j=6
elseif i==3 then
j=1
elseif i==4 then
j=5
elseif i==5 then
j=4
elseif i==6 then
j=2
end
end
if name==AIRBASE.Syria.Ramat_David then
if i==1 then
j=4
elseif i==2 then
j=6
elseif i==3 then
j=5
elseif i==4 then
j=1
elseif i==5 then
j=3
elseif i==6 then
j=2
end
end
return j
end
for i=1,N do
local j=f(i)
local c1=runwaycoords[i]
local c2=runwaycoords[j]
local hdg=c1:HeadingTo(c2)
local idx=string.format("%02d",UTILS.Round((hdg-magvar)/10,0))
local runway={}
runway.heading=hdg
runway.idx=idx
runway.length=c1:Get2DDistance(c2)
runway.position=c1
runway.endpoint=c2
self:T(string.format("Airbase %s: Adding runway id=%s, heading=%03d, length=%d m i=%d j=%d",self:GetName(),runway.idx,runway.heading,runway.length,i,j))
if mark then
runway.position:MarkToAll(string.format("Runway %s: true heading=%03d (magvar=%d), length=%d m, i=%d, j=%d",runway.idx,runway.heading,magvar,runway.length,i,j))
end
table.insert(runways,runway)
end
return runways
end
function AIRBASE:SetActiveRunway(Name,PreferLeft)
self:SetActiveRunwayTakeoff(Name,PreferLeft)
self:SetActiveRunwayLanding(Name,PreferLeft)
end
function AIRBASE:SetActiveRunwayLanding(Name,PreferLeft)
local runway=self:GetRunwayByName(Name)
if not runway then
runway=self:GetRunwayIntoWind(PreferLeft)
end
if runway then
self:T(string.format("%s: Setting active runway for landing as %s",self.AirbaseName,self:GetRunwayName(runway)))
else
self:E("ERROR: Could not set the runway for landing!")
end
self.runwayLanding=runway
return runway
end
function AIRBASE:GetActiveRunway()
return self.runwayLanding,self.runwayTakeoff
end
function AIRBASE:GetActiveRunwayLanding()
return self.runwayLanding
end
function AIRBASE:GetActiveRunwayTakeoff()
return self.runwayTakeoff
end
function AIRBASE:SetActiveRunwayTakeoff(Name,PreferLeft)
local runway=self:GetRunwayByName(Name)
if not runway then
runway=self:GetRunwayIntoWind(PreferLeft)
end
if runway then
self:T(string.format("%s: Setting active runway for takeoff as %s",self.AirbaseName,self:GetRunwayName(runway)))
else
self:E("ERROR: Could not set the runway for takeoff!")
end
self.runwayTakeoff=runway
return runway
end
function AIRBASE:GetRunwayIntoWind(PreferLeft)
local runways=self:GetRunways()
local Vwind=self:GetCoordinate():GetWindWithTurbulenceVec3()
local norm=UTILS.VecNorm(Vwind)
local iact=1
if norm>0 then
Vwind.x=Vwind.x/norm
Vwind.y=0
Vwind.z=Vwind.z/norm
local dotmin=nil
for i,_runway in pairs(runways)do
local runway=_runway
if PreferLeft==nil or PreferLeft==runway.isLeft then
local alpha=math.rad(runway.heading)
local Vrunway={x=math.cos(alpha),y=0,z=math.sin(alpha)}
local dot=UTILS.VecDot(Vwind,Vrunway)
if dotmin==nil or dot<dotmin then
dotmin=dot
iact=i
end
end
end
else
self:E("WARNING: Norm of wind is zero! Cannot determine runway based on wind direction")
end
return runways[iact]
end
function AIRBASE:GetRunwayName(Runway,LongLeftRight)
Runway=Runway or self:GetActiveRunway()
local name="XX"
if Runway then
name=Runway.name
if Runway.isLeft==true then
if LongLeftRight then
name=name.." Left"
else
name=name.."L"
end
elseif Runway.isLeft==false then
if LongLeftRight then
name=name.." Right"
else
name=name.."R"
end
end
end
return name
end
function AIRBASE:CheckOnRunWay(group,radius,despawn)
radius=radius or 50
if self:GetAirbaseCategory()~=Airbase.Category.AIRDROME then
return false
end
if group and group:IsAlive()then
self:T(string.format("%s, checking if group %s is on runway?",self:GetName(),group:GetName()))
local runwaypoints=self:GetParkingSpotsCoordinates(AIRBASE.TerminalType.Runway)
local units=group:GetUnits()
for _,_unit in pairs(units)do
local unit=_unit
if unit and unit:IsAlive()and not unit:InAir()then
self:T(string.format("%s, checking if unit %s is on runway?",self:GetName(),unit:GetName()))
for _i,_coord in pairs(runwaypoints)do
local dist=unit:GetCoordinate():Get2DDistance(_coord)
if dist<radius then
self:E(string.format("%s, unit %s of group %s was spawned on runway #%d. Distance %.1f < radius %.1f m. Despawn = %s.",self:GetName(),unit:GetName(),group:GetName(),_i,dist,radius,tostring(despawn)))
if despawn then
group:Destroy(true)
end
return true
else
self:T(string.format("%s, unit %s of group %s was NOT spawned on runway #%d. Distance %.1f > radius %.1f m. Despawn = %s.",self:GetName(),unit:GetName(),group:GetName(),_i,dist,radius,tostring(despawn)))
end
end
else
self:T(string.format("%s, checking if unit %s of group %s is on runway. Unit is NOT alive.",self:GetName(),unit:GetName(),group:GetName()))
end
end
else
self:T(string.format("%s, checking if group %s is on runway. Group is NOT alive.",self:GetName(),group:GetName()))
end
return false
end
function AIRBASE:GetCategory()
return self.category
end
function AIRBASE:GetCategoryName()
return AIRBASE.CategoryName[self.category]
end
SCENERY={
ClassName="SCENERY",
}
function SCENERY:Register(SceneryName,SceneryObject)
local self=BASE:Inherit(self,POSITIONABLE:New(SceneryName))
self.SceneryName=tostring(SceneryName)
self.SceneryObject=SceneryObject
if self.SceneryObject and self.SceneryObject.getLife then
self.Life0=self.SceneryObject:getLife()or 0
else
self.Life0=0
end
self.Properties={}
return self
end
function SCENERY:GetProperty(PropertyName)
return self.Properties[PropertyName]
end
function SCENERY:HasProperty(PropertyName)
return self.Properties[PropertyName]~=nil and true or false
end
function SCENERY:GetAllProperties()
return self.Properties
end
function SCENERY:SetProperty(PropertyName,PropertyValue)
self.Properties[PropertyName]=PropertyValue
return self
end
function SCENERY:GetName()
return self.SceneryName
end
function SCENERY:GetDCSObject()
return self.SceneryObject
end
function SCENERY:GetLife()
local life=0
if self.SceneryObject and self.SceneryObject.getLife then
life=self.SceneryObject:getLife()
if life>self.Life0 then
self.Life0=math.floor(life*1.2)
end
end
return life
end
function SCENERY:GetLife0()
return self.Life0 or 0
end
function SCENERY:IsAlive(Threshold)
if not Threshold then
return self:GetLife()>=1 and true or false
else
return self:GetRelativeLife()>Threshold and true or false
end
end
function SCENERY:IsDead(Threshold)
if not Threshold then
return self:GetLife()<1 and true or false
else
return self:GetRelativeLife()<=Threshold and true or false
end
end
function SCENERY:GetRelativeLife()
local life=self:GetLife()
local life0=self:GetLife0()
if life==0 or life0==0 then return 0 end
local rlife=math.floor((life/life0)*100)
return rlife
end
function SCENERY:GetThreatLevel()
return 0,"Scenery"
end
function SCENERY:FindByName(Name,Coordinate,Radius,Role)
local radius=Radius or 100
local name=Name or"unknown"
local scenery=nil
local function SceneryScan(scoordinate,sradius,sname)
if scoordinate~=nil then
local Vec2=scoordinate:GetVec2()
local scanzone=ZONE_RADIUS:New("Zone-"..sname,Vec2,sradius,true)
scanzone:Scan({Object.Category.SCENERY})
local scanned=scanzone:GetScannedSceneryObjects()
local rscenery=nil
for _,_scenery in pairs(scanned)do
local scenery=_scenery
if tostring(scenery.SceneryName)==tostring(sname)then
rscenery=scenery
if Role then rscenery:SetProperty("ROLE",Role)end
break
end
end
return rscenery
end
return nil
end
if Coordinate then
scenery=SceneryScan(Coordinate,radius,name)
end
return scenery
end
function SCENERY:FindByNameInZone(Name,Zone,Radius)
local radius=Radius or 100
local name=Name or"unknown"
if type(Zone)=="string"then
Zone=ZONE:FindByName(Zone)
end
local coordinate=Zone:GetCoordinate()
return self:FindByName(Name,coordinate,Radius,Zone:GetProperty("ROLE"))
end
function SCENERY:FindByZoneName(ZoneName)
local zone=ZoneName
if type(ZoneName)=="string"then
zone=ZONE:FindByName(ZoneName)
end
local _id=zone:GetProperty('OBJECT ID')
if not _id then
BASE:E("**** Zone without object ID: "..ZoneName.." | Type: "..tostring(zone.ClassName))
if string.find(zone.ClassName,"POLYGON")then
zone:Scan({Object.Category.SCENERY})
local scanned=zone:GetScannedSceneryObjects()
for _,_scenery in(scanned)do
local scenery=_scenery
if scenery:IsAlive()then
local role=zone:GetProperty("ROLE")
if role then scenery:SetProperty("ROLE",role)end
return scenery
end
end
return nil
else
return self:FindByName(_id,zone:GetCoordinate(),nil,zone:GetProperty("ROLE"))
end
else
return self:FindByName(_id,zone:GetCoordinate(),nil,zone:GetProperty("ROLE"))
end
end
function SCENERY:FindAllByZoneName(ZoneName)
local zone=ZoneName
if type(ZoneName)=="string"then
zone=ZONE:FindByName(ZoneName)
end
local _id=zone:GetProperty('OBJECT ID')
if not _id then
zone:Scan({Object.Category.SCENERY})
local scanned=zone:GetScannedSceneryObjects()
if#scanned>0 then
return scanned
else
return nil
end
else
local obj=self:FindByName(_id,zone:GetCoordinate(),nil,zone:GetProperty("ROLE"))
if obj then
return{obj}
else
return nil
end
end
end
function SCENERY:Destroy()
return self
end
MARKER={
ClassName="MARKER",
Debug=false,
lid=nil,
mid=nil,
coordinate=nil,
text=nil,
message=nil,
readonly=nil,
coalition=nil,
}
_MARKERID=0
MARKER.version="0.1.1"
function MARKER:New(Coordinate,Text)
local self=BASE:Inherit(self,FSM:New())
self.coordinate=UTILS.DeepCopy(Coordinate)
self.text=Text
self.readonly=false
self.message=""
_MARKERID=_MARKERID+1
self.myid=_MARKERID
self.lid=string.format("Marker #%d | ",self.myid)
self:SetStartState("Invisible")
self:AddTransition("Invisible","Added","Visible")
self:AddTransition("Visible","Removed","Invisible")
self:AddTransition("*","Changed","*")
self:AddTransition("*","TextUpdate","*")
self:AddTransition("*","CoordUpdate","*")
self:HandleEvent(EVENTS.MarkAdded)
self:HandleEvent(EVENTS.MarkRemoved)
self:HandleEvent(EVENTS.MarkChange)
return self
end
function MARKER:ReadOnly()
self.readonly=true
return self
end
function MARKER:ReadWrite()
self.readonly=false
return self
end
function MARKER:Message(Text)
self.message=Text or""
return self
end
function MARKER:ToAll(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.ToAll,self)
else
self.toall=true
self.tocoalition=nil
self.coalition=nil
self.togroup=nil
self.groupname=nil
self.groupid=nil
if self.shown then
self:Remove()
end
self.mid=UTILS.GetMarkID()
trigger.action.markToAll(self.mid,self.text,self.coordinate:GetVec3(),self.readonly,self.message)
end
return self
end
function MARKER:ToCoalition(Coalition,Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.ToCoalition,self,Coalition)
else
self.coalition=Coalition
self.tocoalition=true
self.toall=false
self.togroup=false
self.groupname=nil
self.groupid=nil
if self.shown then
self:Remove()
end
self.mid=UTILS.GetMarkID()
trigger.action.markToCoalition(self.mid,self.text,self.coordinate:GetVec3(),self.coalition,self.readonly,self.message)
end
return self
end
function MARKER:ToBlue(Delay)
self:ToCoalition(coalition.side.BLUE,Delay)
return self
end
function MARKER:ToRed(Delay)
self:ToCoalition(coalition.side.RED,Delay)
return self
end
function MARKER:ToNeutral(Delay)
self:ToCoalition(coalition.side.NEUTRAL,Delay)
return self
end
function MARKER:ToGroup(Group,Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.ToGroup,self,Group)
else
if Group and Group:IsAlive()~=nil then
self.groupid=Group:GetID()
if self.groupid then
self.groupname=Group:GetName()
self.togroup=true
self.tocoalition=nil
self.coalition=nil
self.toall=nil
if self.shown then
self:Remove()
end
self.mid=UTILS.GetMarkID()
trigger.action.markToGroup(self.mid,self.text,self.coordinate:GetVec3(),self.groupid,self.readonly,self.message)
end
else
end
end
return self
end
function MARKER:UpdateText(Text,Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.UpdateText,self,Text)
else
self.text=tostring(Text)
self:Refresh()
self:TextUpdate(tostring(Text))
end
return self
end
function MARKER:UpdateCoordinate(Coordinate,Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.UpdateCoordinate,self,Coordinate)
else
self.coordinate=Coordinate
self:Refresh()
self:CoordUpdate(Coordinate)
end
return self
end
function MARKER:Refresh(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.Refresh,self)
else
if self.toall then
self:ToAll()
elseif self.tocoalition then
self:ToCoalition(self.coalition)
elseif self.togroup then
local group=GROUP:FindByName(self.groupname)
self:ToGroup(group)
else
self:E(self.lid.."ERROR: unknown To in :Refresh()!")
end
end
return self
end
function MARKER:Remove(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,MARKER.Remove,self)
else
if self.shown then
trigger.action.removeMark(self.mid)
end
end
return self
end
function MARKER:GetCoordinate()
return self.coordinate
end
function MARKER:GetText()
return self.text
end
function MARKER:SetText(Text)
self.text=Text and tostring(Text)or""
return self
end
function MARKER:IsVisible()
return self:Is("Visible")
end
function MARKER:IsInvisible()
return self:Is("Invisible")
end
function MARKER:OnEventMarkAdded(EventData)
if EventData and EventData.MarkID then
local MarkID=EventData.MarkID
self:T3(self.lid..string.format("Captured event MarkAdded for Mark ID=%s",tostring(MarkID)))
if MarkID==self.mid then
self.shown=true
self:Added(EventData)
end
end
end
function MARKER:OnEventMarkRemoved(EventData)
if EventData and EventData.MarkID then
local MarkID=EventData.MarkID
local MarkID=EventData.MarkID
self:T3(self.lid..string.format("Captured event MarkRemoved for Mark ID=%s",tostring(MarkID)))
if MarkID==self.mid then
self.shown=false
self:Removed(EventData)
end
end
end
function MARKER:OnEventMarkChange(EventData)
if EventData and EventData.MarkID then
local MarkID=EventData.MarkID
self:T3(self.lid..string.format("Captured event MarkChange for Mark ID=%s",tostring(MarkID)))
if MarkID==self.mid then
local MarkID=EventData.MarkID
self:T3(self.lid..string.format("Captured event MarkChange for Mark ID=%s",tostring(MarkID)))
if MarkID==self.mid then
self.text=tostring(EventData.MarkText)
self:Changed(EventData)
end
end
end
end
function MARKER:onafterAdded(From,Event,To,EventData)
local text=string.format("Captured event MarkAdded for myself:\n")
text=text..string.format("Marker ID  = %s\n",tostring(EventData.MarkID))
text=text..string.format("Coalition  = %s\n",tostring(EventData.MarkCoalition))
text=text..string.format("Group  ID  = %s\n",tostring(EventData.MarkGroupID))
text=text..string.format("Initiator  = %s\n",EventData.IniUnit and EventData.IniUnit:GetName()or"Nobody")
text=text..string.format("Coordinate = %s\n",EventData.MarkCoordinate and EventData.MarkCoordinate:ToStringLLDMS()or"Nowhere")
text=text..string.format("Text:          \n%s",tostring(EventData.MarkText))
self:T2(self.lid..text)
end
function MARKER:onafterRemoved(From,Event,To,EventData)
local text=string.format("Captured event MarkRemoved for myself:\n")
text=text..string.format("Marker ID  = %s\n",tostring(EventData.MarkID))
text=text..string.format("Coalition  = %s\n",tostring(EventData.MarkCoalition))
text=text..string.format("Group  ID  = %s\n",tostring(EventData.MarkGroupID))
text=text..string.format("Initiator  = %s\n",EventData.IniUnit and EventData.IniUnit:GetName()or"Nobody")
text=text..string.format("Coordinate = %s\n",EventData.MarkCoordinate and EventData.MarkCoordinate:ToStringLLDMS()or"Nowhere")
text=text..string.format("Text:          \n%s",tostring(EventData.MarkText))
self:T2(self.lid..text)
end
function MARKER:onafterChanged(From,Event,To,EventData)
local text=string.format("Captured event MarkChange for myself:\n")
text=text..string.format("Marker ID  = %s\n",tostring(EventData.MarkID))
text=text..string.format("Coalition  = %s\n",tostring(EventData.MarkCoalition))
text=text..string.format("Group  ID  = %s\n",tostring(EventData.MarkGroupID))
text=text..string.format("Initiator  = %s\n",EventData.IniUnit and EventData.IniUnit:GetName()or"Nobody")
text=text..string.format("Coordinate = %s\n",EventData.MarkCoordinate and EventData.MarkCoordinate:ToStringLLDMS()or"Nowhere")
text=text..string.format("Text:          \n%s",tostring(EventData.MarkText))
self:T2(self.lid..text)
end
function MARKER:onafterTextUpdate(From,Event,To,Text)
self:T(self.lid..string.format("New Marker Text:\n%s",Text))
end
function MARKER:onafterCoordUpdate(From,Event,To,Coordinate)
self:T(self.lid..string.format("New Marker Coordinate in LL DMS: %s",Coordinate:ToStringLLDMS()))
end
WEAPON={
ClassName="WEAPON",
verbose=0,
}
WEAPON.version="0.1.0"
function WEAPON:New(WeaponObject)
if WeaponObject==nil then
env.error("ERROR: Weapon object does NOT exist")
return nil
end
local self=BASE:Inherit(self,POSITIONABLE:New("Weapon"))
self.weapon=WeaponObject
self.desc=WeaponObject:getDesc()
self.category=self.desc.category
if self:IsMissile()and self.desc.missileCategory then
self.categoryMissile=self.desc.missileCategory
if self.desc.guidance then
self.guidance=self.desc.guidance
end
end
self.typeName=WeaponObject:getTypeName()or"Unknown Type"
self.name=WeaponObject:getName()
self.coalition=WeaponObject:getCoalition()
self.country=WeaponObject:getCountry()
self.launcher=WeaponObject:getLauncher()
self.launcherName="Unknown Launcher"
if self.launcher then
self.launcherName=self.launcher:getName()
self.launcherUnit=UNIT:Find(self.launcher)
end
self.coordinate=COORDINATE:NewFromVec3(self.launcher:getPoint())
self.lid=string.format("[%s] %s | ",self.typeName,self.name)
if self.launcherUnit then
self.releaseHeading=self.launcherUnit:GetHeading()
self.releaseAltitudeASL=self.launcherUnit:GetAltitude()
self.releaseAltitudeAGL=self.launcherUnit:GetAltitude(true)
self.releaseCoordinate=self.launcherUnit:GetCoordinate()
self.releasePitch=self.launcherUnit:GetPitch()
end
self:SetTimeStepTrack()
self:SetDistanceInterceptPoint()
local text=string.format("Weapon v%s\nName=%s, TypeName=%s, Category=%s, Coalition=%d, Country=%d, Launcher=%s",
self.version,self.name,self.typeName,self.category,self.coalition,self.country,self.launcherName)
self:T(self.lid..text)
self:T2(self.desc)
return self
end
function WEAPON:SetVerbosity(VerbosityLevel)
self.verbose=VerbosityLevel or 0
return self
end
function WEAPON:SetTimeStepTrack(TimeStep)
self.dtTrack=TimeStep or 0.01
return self
end
function WEAPON:SetDistanceInterceptPoint(Distance)
self.distIP=Distance or 50
return self
end
function WEAPON:SetMarkImpact(Switch)
if Switch==false then
self.impactMark=false
else
self.impactMark=true
end
return self
end
function WEAPON:SetSmokeImpact(Switch,SmokeColor)
if Switch==false then
self.impactSmoke=false
else
self.impactSmoke=true
end
self.impactSmokeColor=SmokeColor or SMOKECOLOR.Red
return self
end
function WEAPON:SetFuncTrack(FuncTrack,...)
self.trackFunc=FuncTrack
self.trackArg=arg or{}
return self
end
function WEAPON:SetFuncImpact(FuncImpact,...)
self.impactFunc=FuncImpact
self.impactArg=arg or{}
return self
end
function WEAPON:GetLauncher()
return self.launcherUnit
end
function WEAPON:GetTarget()
local target=nil
if self.weapon then
local object=self.weapon:getTarget()
if object then
local category=Object.getCategory(object)
local name=object:getName()
if name then
self:T(self.lid..string.format("Got Target Object %s, category=%d",name,category))
if category==Object.Category.UNIT then
target=UNIT:FindByName(name)
elseif category==Object.Category.STATIC then
target=STATIC:FindByName(name,false)
elseif category==Object.Category.SCENERY then
self:E(self.lid..string.format("ERROR: Scenery target not implemented yet!"))
else
self:E(self.lid..string.format("ERROR: Object category=%d is not implemented yet!",category))
end
end
end
end
return target
end
function WEAPON:GetTargetDistance(ConversionFunction)
local target=self:GetTarget()
local distance=nil
if target then
local tv3=target:GetVec3()
local wv3=self:GetVec3()
if tv3 and wv3 then
distance=UTILS.VecDist3D(tv3,wv3)
if ConversionFunction then
distance=ConversionFunction(distance)
end
end
end
return distance
end
function WEAPON:GetTargetName()
local target=self:GetTarget()
local name="None"
if target then
name=target:GetName()
end
return name
end
function WEAPON:GetVelocityVec3()
local Vvec3=nil
if self.weapon then
Vvec3=self.weapon:getVelocity()
end
return Vvec3
end
function WEAPON:GetSpeed(ConversionFunction)
local speed=nil
if self.weapon then
local v=self:GetVelocityVec3()
speed=UTILS.VecNorm(v)
if ConversionFunction then
speed=ConversionFunction(speed)
end
end
return speed
end
function WEAPON:GetVec3()
local vec3=nil
if self.weapon then
vec3=self.weapon:getPoint()
end
return vec3
end
function WEAPON:GetVec2()
local vec3=self:GetVec3()
if vec3 then
local vec2={x=vec3.x,y=vec3.z}
return vec2
end
return nil
end
function WEAPON:GetTypeName()
return self.typeName
end
function WEAPON:GetCoalition()
return self.coalition
end
function WEAPON:GetCountry()
return self.country
end
function WEAPON:GetDCSObject()
return self.weapon
end
function WEAPON:GetImpactVec3()
return self.impactVec3
end
function WEAPON:GetImpactCoordinate()
return self.impactCoord
end
function WEAPON:GetReleaseHeading(AccountForMagneticInclination)
AccountForMagneticInclination=AccountForMagneticInclination or true
if AccountForMagneticInclination then return UTILS.ClampAngle(self.releaseHeading-UTILS.GetMagneticDeclination())else return UTILS.ClampAngle(self.releaseHeading)end
end
function WEAPON:GetReleaseAltitudeASL()
return self.releaseAltitudeASL
end
function WEAPON:GetReleaseAltitudeAGL()
return self.releaseAltitudeAGL
end
function WEAPON:GetReleaseCoordinate()
return self.releaseCoordinate
end
function WEAPON:GetReleasePitch()
return self.releasePitch
end
function WEAPON:GetImpactHeading(AccountForMagneticInclination)
AccountForMagneticInclination=AccountForMagneticInclination or true
if AccountForMagneticInclination then return UTILS.ClampAngle(self.impactHeading-UTILS.GetMagneticDeclination())else return self.impactHeading end
end
function WEAPON:InAir()
local inAir=nil
if self.weapon then
inAir=self.weapon:inAir()
end
return inAir
end
function WEAPON:IsExist()
local isExist=nil
if self.weapon then
isExist=self.weapon:isExist()
end
return isExist
end
function WEAPON:IsBomb()
return self.category==Weapon.Category.BOMB
end
function WEAPON:IsMissile()
return self.category==Weapon.Category.MISSILE
end
function WEAPON:IsRocket()
return self.category==Weapon.Category.ROCKET
end
function WEAPON:IsShell()
return self.category==Weapon.Category.SHELL
end
function WEAPON:IsTorpedo()
return self.category==Weapon.Category.TORPEDO
end
function WEAPON:IsFoxOne()
return self.guidance==Weapon.GuidanceType.RADAR_SEMI_ACTIVE
end
function WEAPON:IsFoxTwo()
return self.guidance==Weapon.GuidanceType.IR
end
function WEAPON:IsFoxThree()
return self.guidance==Weapon.GuidanceType.RADAR_ACTIVE
end
function WEAPON:Destroy(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,WEAPON.Destroy,self,0)
else
if self.weapon then
self:T(self.lid.."Destroying Weapon NOW!")
self:StopTrack()
self.weapon:destroy()
end
end
return self
end
function WEAPON:StartTrack(Delay)
Delay=math.max(Delay or 0.001,0.001)
self:T(self.lid..string.format("Start tracking weapon in %.4f sec",Delay))
self.trackScheduleID=timer.scheduleFunction(WEAPON._TrackWeapon,self,timer.getTime()+Delay)
return self
end
function WEAPON:StopTrack(Delay)
if Delay and Delay>0 then
self:ScheduleOnce(Delay,WEAPON.StopTrack,self,0)
else
if self.trackScheduleID then
timer.removeFunction(self.trackScheduleID)
end
end
return self
end
function WEAPON:_TrackWeapon(time)
if self.verbose>=20 then
self:I(self.lid..string.format("Tracking at T=%.5f",time))
end
local status,pos3=pcall(
function()
local point=self.weapon:getPosition()
return point
end
)
if status then
self.pos3=pos3
self.vec3=UTILS.DeepCopy(self.pos3.p)
self.coordinate:UpdateFromVec3(self.vec3)
self.last_velocity=self.weapon:getVelocity()
self.tracking=true
if self.trackFunc then
self.trackFunc(self,unpack(self.trackArg))
end
if self.verbose>=5 then
local vec2={x=self.vec3.x,y=self.vec3.z}
local height=land.getHeight(vec2)
local agl=self.vec3.y-height
local ip=self:_GetIP(self.distIP)
local d=0
if ip then
d=UTILS.VecDist3D(self.vec3,ip)
end
self:I(self.lid..string.format("T=%.3f: Height=%.3f m AGL=%.3f m, dIP=%.3f",time,height,agl,d))
end
else
local ip=self:_GetIP(self.distIP)
if self.verbose>=10 and ip then
self:I(self.lid.."Got intercept point!")
local coord=COORDINATE:NewFromVec3(ip)
coord:MarkToAll("Intercept point")
coord:SmokeBlue()
local d=UTILS.VecDist3D(ip,self.vec3)
self:I(self.lid..string.format("FF d(ip, vec3)=%.3f meters",d))
end
self.impactVec3=ip or self.vec3
self.impactCoord=COORDINATE:NewFromVec3(self.vec3)
self.impactHeading=UTILS.VecHdg(self.last_velocity)
if self.impactMark then
self.impactCoord:MarkToAll(string.format("Impact point of weapon %s\ntype=%s\nlauncher=%s",self.name,self.typeName,self.launcherName))
end
if self.impactSmoke then
self.impactCoord:Smoke(self.impactSmokeColor)
end
if self.impactFunc then
self.impactFunc(self,unpack(self.impactArg or{}))
end
self.tracking=false
end
if self.tracking then
if self.dtTrack and self.dtTrack>=0.00001 then
return time+self.dtTrack
else
return nil
end
end
return nil
end
function WEAPON:_GetIP(Distance)
Distance=Distance or 50
local ip=nil
if Distance>0 and self.pos3 then
ip=land.getIP(self.pos3.p,self.pos3.x,Distance or 20)
end
return ip
end
do
NET={
ClassName="NET",
Version="0.1.4",
BlockTime=600,
BlockedPilots={},
BlockedUCIDs={},
BlockedSides={},
BlockedSlots={},
KnownPilots={},
BlockMessage=nil,
UnblockMessage=nil,
lid=nil,
}
function NET:New()
local self=BASE:Inherit(self,FSM:New())
self.BlockTime=600
self.BlockedPilots={}
self.KnownPilots={}
self:SetBlockMessage()
self:SetUnblockMessage()
self.BlockedSides={}
self.BlockedSides[1]=false
self.BlockedSides[2]=false
self:SetStartState("Stopped")
self:AddTransition("Stopped","Run","Running")
self:AddTransition("*","PlayerJoined","*")
self:AddTransition("*","PlayerLeft","*")
self:AddTransition("*","PlayerDied","*")
self:AddTransition("*","PlayerEjected","*")
self:AddTransition("*","PlayerBlocked","*")
self:AddTransition("*","PlayerUnblocked","*")
self:AddTransition("*","Status","*")
self:AddTransition("*","Stop","Stopped")
self.lid=string.format("NET %s | ",self.Version)
self:Run()
return self
end
function NET:IsAnyBlocked(UCID,Name,PlayerID,PlayerSide,PlayerSlot)
self:T({UCID,Name,PlayerID,PlayerSide,PlayerSlot})
local blocked=false
local TNow=timer.getTime()
if UCID and self.BlockedUCIDs[UCID]and TNow<self.BlockedUCIDs[UCID]then
blocked=true
end
if PlayerID and not Name then
Name=self:GetPlayerIDByName(Name)
end
if Name and self.BlockedPilots[Name]and TNow<self.BlockedPilots[Name]then
blocked=true
end
self:T({time=self.BlockedSides[PlayerSide]})
if PlayerSide and type(self.BlockedSides[PlayerSide])=="number"and TNow<self.BlockedSides[PlayerSide]then
blocked=true
end
if PlayerSlot and self.BlockedSlots[PlayerSlot]and TNow<self.BlockedSlots[PlayerSlot]then
blocked=true
end
self:T("IsAnyBlocked: "..tostring(blocked))
return blocked
end
function NET:_EventHandler(EventData)
self:T(self.lid.." _EventHandler")
self:T2({Event=EventData.id})
local data=EventData
if data.id and data.IniUnit and(data.IniPlayerName or data.IniUnit:GetPlayerName())then
local name=data.IniPlayerName and data.IniPlayerName or data.IniUnit:GetPlayerName()
local ucid=self:GetPlayerUCID(nil,name)or"none"
local PlayerID=self:GetPlayerIDByName(name)or"none"
local PlayerSide,PlayerSlot=self:GetSlot(data.IniUnit)
if not PlayerSide then PlayerSide=EventData.IniCoalition end
if not PlayerSlot then PlayerSlot=EventData.IniUnit:GetID()or-1 end
local TNow=timer.getTime()
if data.id==EVENTS.PlayerEnterUnit or data.id==EVENTS.PlayerEnterAircraft then
self:T(self.lid.."Pilot Joining: "..name.." | UCID: "..ucid.." | Event ID: "..data.id)
local blocked=self:IsAnyBlocked(ucid,name,PlayerID,PlayerSide,PlayerSlot)
if blocked and PlayerID then
self:T("Player blocked")
local outcome=net.force_player_slot(tonumber(PlayerID),PlayerSide,data.IniUnit:GetID())
self:T({Blocked_worked=outcome})
if outcome==false then
local unit=data.IniUnit
local sched=TIMER:New(unit.Destroy,unit,3):Start(3)
self:__PlayerBlocked(5,unit,name,1)
end
else
local client=CLIENT:FindByPlayerName(name)or data.IniUnit
if not self.KnownPilots[name]or(self.KnownPilots[name]and TNow-self.KnownPilots[name].timestamp>3)then
self:__PlayerJoined(1,client,name)
self.KnownPilots[name]={
name=name,
ucid=ucid,
id=PlayerID,
side=PlayerSide,
slot=PlayerSlot,
timestamp=TNow,
}
end
return self
end
end
if data.id==EVENTS.PlayerLeaveUnit and self.KnownPilots[name]then
self:T(self.lid.."Pilot Leaving: "..name.." | UCID: "..ucid)
self:__PlayerLeft(1,data.IniUnit,name)
self.KnownPilots[name]=false
return self
end
if data.id==EVENTS.Ejection and self.KnownPilots[name]then
self:T(self.lid.."Pilot Ejecting: "..name.." | UCID: "..ucid)
self:__PlayerEjected(1,data.IniUnit,name)
self.KnownPilots[name]=false
return self
end
if(data.id==EVENTS.PilotDead or data.id==EVENTS.SelfKillPilot or data.id==EVENTS.Crash)and self.KnownPilots[name]then
self:T(self.lid.."Pilot Dead: "..name.." | UCID: "..ucid)
self:__PlayerDied(1,data.IniUnit,name)
self.KnownPilots[name]=false
return self
end
end
return self
end
function NET:BlockPlayer(Client,PlayerName,Seconds,Message)
self:T({PlayerName,Seconds,Message})
local name=PlayerName
if Client and(not PlayerName)then
name=Client:GetPlayerName()
elseif PlayerName then
name=PlayerName
else
self:F(self.lid.."Block: No Client or PlayerName given or nothing found!")
return self
end
local ucid=self:GetPlayerUCID(Client,name)
local addon=Seconds or self.BlockTime
self.BlockedPilots[name]=timer.getTime()+addon
self.BlockedUCIDs[ucid]=timer.getTime()+addon
local message=Message or self.BlockMessage
if name then
self:SendChatToPlayer(message,name)
else
self:SendChat(name..": "..message)
end
self:__PlayerBlocked(1,Client,name,Seconds)
local PlayerID=self:GetPlayerIDByName(name)
if PlayerID and tonumber(PlayerID)~=1 then
local outcome=net.force_player_slot(tonumber(PlayerID),0,'')
end
return self
end
function NET:BlockPlayerSet(PlayerSet,Seconds,Message)
self:T({PlayerSet.Set,Seconds,Message})
local addon=Seconds or self.BlockTime
local message=Message or self.BlockMessage
for _,_client in pairs(PlayerSet.Set)do
local name=_client:GetPlayerName()
self:BlockPlayer(_client,name,addon,message)
end
return self
end
function NET:UnblockPlayerSet(PlayerSet,Message)
self:T({PlayerSet.Set,Seconds,Message})
local message=Message or self.UnblockMessage
for _,_client in pairs(PlayerSet.Set)do
local name=_client:GetPlayerName()
self:UnblockPlayer(_client,name,message)
end
return self
end
function NET:BlockUCID(ucid,Seconds)
self:T({ucid,Seconds})
local addon=Seconds or self.BlockTime
self.BlockedUCIDs[ucid]=timer.getTime()+addon
return self
end
function NET:UnblockUCID(ucid)
self:T({ucid})
self.BlockedUCIDs[ucid]=nil
return self
end
function NET:BlockSide(Side,Seconds)
local addon=Seconds or self.BlockTime
if Side==1 or Side==2 then
self.BlockedSides[Side]=timer.getTime()+addon
end
return self
end
function NET:UnblockSide(Side,Seconds)
local addon=Seconds or self.BlockTime
if Side==1 or Side==2 then
self.BlockedSides[Side]=false
end
return self
end
function NET:BlockSlot(Slot,Seconds)
self:T({Slot,Seconds})
local addon=Seconds or self.BlockTime
self.BlockedSlots[Slot]=timer.getTime()+addon
return self
end
function NET:UnblockSlot(Slot)
self:T({Slot})
self.BlockedSlots[Slot]=nil
return self
end
function NET:UnblockPlayer(Client,PlayerName,Message)
local name=PlayerName
if Client then
name=Client:GetPlayerName()
elseif PlayerName then
name=PlayerName
else
self:F(self.lid.."Unblock: No PlayerName given or not found!")
return self
end
local ucid=self:GetPlayerUCID(Client,name)
self.BlockedPilots[name]=nil
self.BlockedUCIDs[ucid]=nil
local message=Message or self.UnblockMessage
if name then
self:SendChatToPlayer(message,name)
else
self:SendChat(name..": "..message)
end
self:__PlayerUnblocked(1,Client,name)
return self
end
function NET:SetBlockMessage(Text)
self.BlockMessage=Text or"You are blocked from joining. Wait time is: "..self.BlockTime.." seconds!"
return self
end
function NET:SetBlockTime(Seconds)
self.BlockTime=Seconds or 600
return self
end
function NET:SetUnblockMessage(Text)
self.UnblockMessage=Text or"You are unblocked now and can join again."
return self
end
function NET:SendChat(Message,ToAll)
if Message then
net.send_chat(Message,ToAll)
end
return self
end
function NET:GetPlayerIDByName(Name)
if not Name then return nil end
local playerList=net.get_player_list()
for i=1,#playerList do
local playerName=net.get_name(i)
if playerName==Name then
return playerList[i]
end
end
return nil
end
function NET:GetPlayerIDFromClient(Client)
self:T("GetPlayerIDFromClient")
self:T({Client=Client})
if Client then
local name=Client:GetPlayerName()
self:T({name=name})
local id=self:GetPlayerIDByName(name)
return id
else
return nil
end
end
function NET:SendChatToClient(Message,ToClient,FromClient)
local PlayerId=self:GetPlayerIDFromClient(ToClient)
local FromId=self:GetPlayerIDFromClient(FromClient)
if Message and PlayerId and FromId then
net.send_chat_to(Message,tonumber(PlayerId),tonumber(FromId))
elseif Message and PlayerId then
net.send_chat_to(Message,tonumber(PlayerId))
end
return self
end
function NET:SendChatToPlayer(Message,ToPlayer,FromPlayer)
local PlayerId=self:GetPlayerIDByName(ToPlayer)
local FromId=self:GetPlayerIDByName(FromPlayer)
if Message and PlayerId and FromId then
net.send_chat_to(Message,tonumber(PlayerId),tonumber(FromId))
elseif Message and PlayerId then
net.send_chat_to(Message,tonumber(PlayerId))
end
return self
end
function NET:GetPlayerList()
local plist=nil
plist=net.get_player_list()
return plist
end
function NET:GetMyPlayerID()
return net.get_my_player_id()
end
function NET:GetServerID()
return net.get_server_id()
end
function NET:GetPlayerInfo(Client,Attribute)
local PlayerID=self:GetPlayerIDFromClient(Client)
if PlayerID then
return net.get_player_info(tonumber(PlayerID),Attribute)
else
return nil
end
end
function NET:GetPlayerUCID(Client,Name)
local PlayerID=nil
if Client then
PlayerID=self:GetPlayerIDFromClient(Client)
elseif Name then
PlayerID=self:GetPlayerIDByName(Name)
else
self:E(self.lid.."Neither client nor name provided!")
end
local ucid=net.get_player_info(tonumber(PlayerID),'ucid')
return ucid
end
function NET:Kick(Client,Message)
local PlayerID=self:GetPlayerIDFromClient(Client)
if PlayerID and tonumber(PlayerID)~=1 then
return net.kick(tonumber(PlayerID),Message)
else
return false
end
end
function NET:GetPlayerStatistic(Client,StatisticID)
local PlayerID=self:GetPlayerIDFromClient(Client)
local stats=StatisticID or 0
if stats>7 or stats<0 then stats=0 end
if PlayerID then
return net.get_stat(tonumber(PlayerID),stats)
else
return nil
end
end
function NET:GetName(Client)
local PlayerID=self:GetPlayerIDFromClient(Client)
if PlayerID then
return net.get_name(tonumber(PlayerID))
else
return nil
end
end
function NET:GetSlot(Client)
self:T("NET.GetSlot")
local PlayerID=self:GetPlayerIDFromClient(Client)
self:T("NET.GetSlot PlayerID = "..tostring(PlayerID))
if PlayerID then
local side,slot=net.get_slot(tonumber(PlayerID))
self:T("NET.GetSlot side, slot = "..tostring(side)..","..tostring(slot))
return side,slot
else
return nil,nil
end
end
function NET:ForceSlot(Client,SideID,SlotID)
local PlayerID=self:GetPlayerIDFromClient(Client)
local SlotID=SlotID or Client:GetID()
if PlayerID then
return net.force_player_slot(tonumber(PlayerID),SideID,SlotID)
else
return false
end
end
function NET:ReturnToSpectators(Client)
local outcome=self:ForceSlot(Client,0)
local sched=TIMER:New(Client.Destroy,Client,1):Start(1)
return outcome
end
function NET.Lua2Json(Lua)
return net.lua2json(Lua)
end
function NET.Json2Lua(Json)
return net.json2lua(Json)
end
function NET:DoStringIn(State,DoString)
return net.dostring_in(State,DoString)
end
function NET:Log(Message)
net.log(Message)
return self
end
function NET:GetKnownPilotData(Client,Name)
local name=Name
if Client and not Name then
name=Client:GetPlayerName()
end
if name then
return self.KnownPilots[name]
else
return nil
end
end
function NET:onafterStatus(From,Event,To)
self:T({From,Event,To})
local function HouseHold(tavolo)
local TNow=timer.getTime()
for _,entry in pairs(tavolo)do
if type(entry)=="number"and entry>=TNow then entry=false end
end
end
HouseHold(self.BlockedPilots)
HouseHold(self.BlockedSides)
HouseHold(self.BlockedSlots)
HouseHold(self.BlockedUCIDs)
if self:Is("Running")then
self:__Status(-60)
end
return self
end
function NET:onafterRun(From,Event,To)
self:T({From,Event,To})
self:HandleEvent(EVENTS.PlayerEnterUnit,self._EventHandler)
self:HandleEvent(EVENTS.PlayerEnterAircraft,self._EventHandler)
self:HandleEvent(EVENTS.PlayerLeaveUnit,self._EventHandler)
self:HandleEvent(EVENTS.PilotDead,self._EventHandler)
self:HandleEvent(EVENTS.Ejection,self._EventHandler)
self:HandleEvent(EVENTS.Crash,self._EventHandler)
self:HandleEvent(EVENTS.SelfKillPilot,self._EventHandler)
self:__Status(-10)
end
function NET:onafterStop(From,Event,To)
self:T({From,Event,To})
self:UnHandleEvent(EVENTS.PlayerEnterUnit)
self:UnHandleEvent(EVENTS.PlayerEnterAircraft)
self:UnHandleEvent(EVENTS.PlayerLeaveUnit)
self:UnHandleEvent(EVENTS.PilotDead)
self:UnHandleEvent(EVENTS.Ejection)
self:UnHandleEvent(EVENTS.Crash)
self:UnHandleEvent(EVENTS.SelfKillPilot)
return self
end
end
STORAGE={
ClassName="STORAGE",
verbose=0,
}
STORAGE.Liquid={
JETFUEL=0,
GASOLINE=1,
MW50=2,
DIESEL=3,
}
STORAGE.LiquidName={
GASOLINE="gasoline",
DIESEL="diesel",
MW50="methanol_mixture",
JETFUEL="jet_fuel",
}
STORAGE.Type={
WEAPONS="weapons",
LIQUIDS="liquids",
AIRCRAFT="aircrafts",
}
STORAGE.version="0.1.5"
function STORAGE:New(AirbaseName)
local self=BASE:Inherit(self,BASE:New())
self.airbase=Airbase.getByName(AirbaseName)
if Airbase.getWarehouse and self.airbase then
self.warehouse=self.airbase:getWarehouse()
end
self.lid=string.format("STORAGE %s | ",AirbaseName)
return self
end
function STORAGE:NewFromStaticCargo(StaticCargoName)
local self=BASE:Inherit(self,BASE:New())
self.airbase=StaticObject.getByName(StaticCargoName)
if Airbase.getWarehouse then
self.warehouse=Warehouse.getCargoAsWarehouse(self.airbase)
end
self.lid=string.format("STORAGE %s | ",StaticCargoName)
return self
end
function STORAGE:NewFromDynamicCargo(DynamicCargoName)
local self=BASE:Inherit(self,BASE:New())
self.airbase=Unit.getByName(DynamicCargoName)or StaticObject.getByName(DynamicCargoName)
if Airbase.getWarehouse then
self.warehouse=Warehouse.getCargoAsWarehouse(self.airbase)
end
self.lid=string.format("STORAGE %s | ",DynamicCargoName)
return self
end
function STORAGE:FindByName(AirbaseName)
local storage=_DATABASE:FindStorage(AirbaseName)
return storage
end
function STORAGE:SetVerbosity(VerbosityLevel)
self.verbose=VerbosityLevel or 0
if self.verbose>1 then
BASE:TraceOn()
BASE:TraceClass("STORAGE")
end
return self
end
function STORAGE:AddItem(Name,Amount)
self:T(self.lid..string.format("Adding %d items of %s",Amount,UTILS.OneLineSerialize(Name)))
self.warehouse:addItem(Name,Amount)
return self
end
function STORAGE:SetItem(Name,Amount)
self:T(self.lid..string.format("Setting item %s to N=%d",UTILS.OneLineSerialize(Name),Amount))
self.warehouse:setItem(Name,Amount)
return self
end
function STORAGE:GetItemAmount(Name)
local N=self.warehouse:getItemCount(Name)
return N
end
function STORAGE:RemoveItem(Name,Amount)
self:T(self.lid..string.format("Removing N=%d of item %s",Amount,Name))
self.warehouse:removeItem(Name,Amount)
return self
end
function STORAGE:AddLiquid(Type,Amount)
self:T(self.lid..string.format("Adding %d liquids of %s",Amount,self:GetLiquidName(Type)))
self.warehouse:addLiquid(Type,Amount)
return self
end
function STORAGE:SetLiquid(Type,Amount)
self:T(self.lid..string.format("Setting liquid %s to N=%d",self:GetLiquidName(Type),Amount))
self.warehouse:setLiquidAmount(Type,Amount)
return self
end
function STORAGE:RemoveLiquid(Type,Amount)
self:T(self.lid..string.format("Removing N=%d of liquid %s",Amount,self:GetLiquidName(Type)))
self.warehouse:removeLiquid(Type,Amount)
return self
end
function STORAGE:GetLiquidAmount(Type)
local N=self.warehouse:getLiquidAmount(Type)
return N
end
function STORAGE:GetLiquidName(Type)
local name="Unknown"
if Type==STORAGE.Liquid.JETFUEL then
name="Jet fuel"
elseif Type==STORAGE.Liquid.GASOLINE then
name="Aircraft gasoline"
elseif Type==STORAGE.Liquid.MW50 then
name="MW 50"
elseif Type==STORAGE.Liquid.DIESEL then
name="Diesel"
else
self:E(self.lid..string.format("ERROR: Unknown liquid type %s",tostring(Type)))
end
return name
end
function STORAGE:AddAmount(Type,Amount)
if type(Type)=="number"then
self:AddLiquid(Type,Amount)
else
self:AddItem(Type,Amount)
end
return self
end
function STORAGE:RemoveAmount(Type,Amount)
if type(Type)=="number"then
self:RemoveLiquid(Type,Amount)
else
self:RemoveItem(Type,Amount)
end
return self
end
function STORAGE:SetAmount(Type,Amount)
if type(Type)=="number"then
self:SetLiquid(Type,Amount)
else
self:SetItem(Type,Amount)
end
return self
end
function STORAGE:GetAmount(Type)
local N=0
if type(Type)=="number"then
N=self:GetLiquidAmount(Type)
else
N=self:GetItemAmount(Type)
end
return N
end
function STORAGE:IsUnlimited(Type)
local N=self:GetAmount(Type)
local unlimited=false
if N>0 then
self:RemoveAmount(Type,1)
local n=self:GetAmount(Type)
unlimited=unlimited or n>2^29 or n==N
if not unlimited then
self:AddAmount(Type,1)
end
self:T(self.lid..string.format("Type=%s: unlimited=%s (N=%d n=%d)",tostring(Type),tostring(unlimited),N,n))
end
return unlimited
end
function STORAGE:IsLimited(Type)
local limited=not self:IsUnlimited(Type)
return limited
end
function STORAGE:IsUnlimitedAircraft()
local unlimited=self:IsUnlimited("A-10C")
return unlimited
end
function STORAGE:IsUnlimitedLiquids()
local unlimited=self:IsUnlimited(STORAGE.Liquid.DIESEL)
return unlimited
end
function STORAGE:IsUnlimitedWeapons()
local unlimited=self:IsUnlimited(ENUMS.Storage.weapons.bombs.Mk_82)
return unlimited
end
function STORAGE:IsLimitedAircraft()
local limited=self:IsLimited("A-10C")
return limited
end
function STORAGE:IsLimitedLiquids()
local limited=self:IsLimited(STORAGE.Liquid.DIESEL)
return limited
end
function STORAGE:IsLimitedWeapons()
local limited=self:IsLimited(ENUMS.Storage.weapons.bombs.Mk_82)
return limited
end
function STORAGE:GetInventory(Item)
local inventory=self.warehouse:getInventory(Item)
return inventory.aircraft,inventory.liquids,inventory.weapon
end
function STORAGE:SaveToFile(Path,Filename)
if not io then
BASE:E("ERROR: io not desanitized. Can't save the files.")
return false
end
if Path==nil and not lfs then
BASE:E("WARNING: lfs not desanitized. File will be saved in DCS installation root directory rather than your given path.")
end
local ac,lq,wp=self:GetInventory()
local DataAircraft=""
local DataLiquids=""
local DataWeapons=""
if#lq>0 then
DataLiquids=DataLiquids.."Liquids in Storage:\n"
for key,amount in pairs(lq)do
DataLiquids=DataLiquids..tostring(key).."="..tostring(amount).."\n"
end
UTILS.SaveToFile(Path,Filename.."_Liquids.csv",DataLiquids)
if self.verbose and self.verbose>0 then
self:I(self.lid.."Saving Liquids to "..tostring(Path).."\\"..tostring(Filename).."_Liquids.csv")
end
end
if UTILS.TableLength(ac)>0 then
DataAircraft=DataAircraft.."Aircraft in Storage:\n"
for key,amount in pairs(ac)do
DataAircraft=DataAircraft..tostring(key).."="..tostring(amount).."\n"
end
UTILS.SaveToFile(Path,Filename.."_Aircraft.csv",DataAircraft)
if self.verbose and self.verbose>0 then
self:I(self.lid.."Saving Aircraft to "..tostring(Path).."\\"..tostring(Filename).."_Aircraft.csv")
end
end
if UTILS.TableLength(wp)>0 then
DataWeapons=DataWeapons.."Weapons and Materiel in Storage:\n"
for _,_category in pairs(ENUMS.Storage.weapons)do
for _,_key in pairs(_category)do
local amount=self:GetAmount(_key)
if type(_key)=="table"then
_key="{"..table.concat(_key,",").."}"
end
DataWeapons=DataWeapons..tostring(_key).."="..tostring(amount).."\n"
end
end
for key,amount in pairs(ENUMS.Storage.weapons.Gazelle)do
amount=self:GetItemAmount(ENUMS.Storage.weapons.Gazelle[key])
DataWeapons=DataWeapons.."ENUMS.Storage.weapons.Gazelle."..tostring(key).."="..tostring(amount).."\n"
end
for key,amount in pairs(ENUMS.Storage.weapons.CH47)do
amount=self:GetItemAmount(ENUMS.Storage.weapons.CH47[key])
DataWeapons=DataWeapons.."ENUMS.Storage.weapons.CH47."..tostring(key).."="..tostring(amount).."\n"
end
for key,amount in pairs(ENUMS.Storage.weapons.UH1H)do
amount=self:GetItemAmount(ENUMS.Storage.weapons.UH1H[key])
DataWeapons=DataWeapons.."ENUMS.Storage.weapons.UH1H."..tostring(key).."="..tostring(amount).."\n"
end
for key,amount in pairs(ENUMS.Storage.weapons.OH58)do
amount=self:GetItemAmount(ENUMS.Storage.weapons.OH58[key])
DataWeapons=DataWeapons.."ENUMS.Storage.weapons.OH58."..tostring(key).."="..tostring(amount).."\n"
end
for key,amount in pairs(ENUMS.Storage.weapons.AH64D)do
amount=self:GetItemAmount(ENUMS.Storage.weapons.AH64D[key])
DataWeapons=DataWeapons.."ENUMS.Storage.weapons.AH64D."..tostring(key).."="..tostring(amount).."\n"
end
UTILS.SaveToFile(Path,Filename.."_Weapons.csv",DataWeapons)
if self.verbose and self.verbose>0 then
self:I(self.lid.."Saving Weapons to "..tostring(Path).."\\"..tostring(Filename).."_Weapons.csv")
end
end
return self
end
function STORAGE:LoadFromFile(Path,Filename)
if not io then
BASE:E("ERROR: io not desanitized. Can't read the files.")
return false
end
if Path==nil and not lfs then
BASE:E("WARNING: lfs not desanitized. File will be read from DCS installation root directory rather than your give path.")
end
if self:IsLimitedLiquids()then
local Ok,Liquids=UTILS.LoadFromFile(Path,Filename.."_Liquids.csv")
if Ok then
if self.verbose and self.verbose>0 then
self:I(self.lid.."Loading Liquids from "..tostring(Path).."\\"..tostring(Filename).."_Liquids.csv")
end
for _id,_line in pairs(Liquids)do
if string.find(_line,"Storage")==nil then
local tbl=UTILS.Split(_line,"=")
local lqno=tonumber(tbl[1])
local lqam=tonumber(tbl[2])
self:SetLiquid(lqno,lqam)
end
end
else
self:E("File for Liquids could not be found: "..tostring(Path).."\\"..tostring(Filename"_Liquids.csv"))
end
end
if self:IsLimitedAircraft()then
local Ok,Aircraft=UTILS.LoadFromFile(Path,Filename.."_Aircraft.csv")
if Ok then
if self.verbose and self.verbose>0 then
self:I(self.lid.."Loading Aircraft from "..tostring(Path).."\\"..tostring(Filename).."_Aircraft.csv")
end
for _id,_line in pairs(Aircraft)do
if string.find(_line,"Storage")==nil then
local tbl=UTILS.Split(_line,"=")
local acname=tbl[1]
local acnumber=tonumber(tbl[2])
self:SetAmount(acname,acnumber)
end
end
else
self:E("File for Aircraft could not be found: "..tostring(Path).."\\"..tostring(Filename"_Aircraft.csv"))
end
end
if self:IsLimitedWeapons()then
local Ok,Weapons=UTILS.LoadFromFile(Path,Filename.."_Weapons.csv")
if Ok then
if self.verbose and self.verbose>0 then
self:I(self.lid.."Loading Weapons from "..tostring(Path).."\\"..tostring(Filename).."_Weapons.csv")
end
for _id,_line in pairs(Weapons)do
if string.find(_line,"Storage")==nil then
local tbl=UTILS.Split(_line,"=")
local wpname=tbl[1]
local wpnumber=tonumber(tbl[2])
if string.find(wpname,"{")==1 then
wpname=string.gsub(wpname,"{","")
wpname=string.gsub(wpname,"}","")
local tbl=UTILS.Split(wpname,",")
local wptbl={}
for _id,_key in ipairs(tbl)do
table.insert(wptbl,_id,_key)
end
self:SetAmount(wptbl,wpnumber)
else
self:SetAmount(wpname,wpnumber)
end
end
end
else
self:E("File for Weapons could not be found: "..tostring(Path).."\\"..tostring(Filename"_Weapons.csv"))
end
end
return self
end
function STORAGE:StartAutoSave(Path,Filename,Interval,LoadOnce)
if LoadOnce~=false then
self:LoadFromFile(Path,Filename)
end
local interval=Interval or 300
self.SaverTimer=TIMER:New(STORAGE.SaveToFile,self,Path,Filename)
self.SaverTimer:Start(interval,interval)
return self
end
function STORAGE:StopAutoSave()
if self.SaverTimer and self.SaverTimer:IsRunning()then
self.SaverTimer:Stop()
self.SaverTimer=nil
end
return self
end
function STORAGE:FindSyriaHHelipadWarehouse(ZoneName)
local findzone=ZONE:New(ZoneName)
local base=world.getAirbases()
for i=1,#base do
local info={}
info.callsign=Airbase.getCallsign(base[i])
info.id=Airbase.getID(base[i])
info.point=Airbase.getPoint(base[i])
info.coordinate=COORDINATE:NewFromVec3(info.point)
info.DCSObject=base[i]
if info.callsign=="H"and findzone:IsCoordinateInZone(info.coordinate)then
info.warehouse=info.DCSObject:getWarehouse()
info.Storage=STORAGE:New(info.callsign..info.id)
info.Storage.airbase=info.DCSObject
info.Storage.warehouse=info.warehouse
return info.Storage
end
end
end
DYNAMICCARGO={
ClassName="DYNAMICCARGO",
verbose=0,
testing=false,
Interval=10,
}
DYNAMICCARGO.Liquid={
JETFUEL=0,
GASOLINE=1,
MW50=2,
DIESEL=3,
}
DYNAMICCARGO.LiquidName={
GASOLINE="gasoline",
DIESEL="diesel",
MW50="methanol_mixture",
JETFUEL="jet_fuel",
}
DYNAMICCARGO.Type={
WEAPONS="weapons",
LIQUIDS="liquids",
AIRCRAFT="aircrafts",
}
DYNAMICCARGO.State={
NEW="NEW",
LOADED="LOADED",
UNLOADED="UNLOADED",
REMOVED="REMOVED",
}
DYNAMICCARGO.AircraftTypes={
["CH-47Fbl1"]="CH-47Fbl1",
}
DYNAMICCARGO.AircraftDimensions={
["CH-47Fbl1"]={
["width"]=4,
["height"]=6,
["length"]=11,
["ropelength"]=30,
},
}
DYNAMICCARGO.version="0.0.7"
function DYNAMICCARGO:Register(CargoName)
local self=BASE:Inherit(self,POSITIONABLE:New(CargoName))
self.StaticName=CargoName
self.LastPosition=self:GetCoordinate()
self.CargoState=DYNAMICCARGO.State.NEW
self.Interval=DYNAMICCARGO.Interval or 10
local DCSObject=self:GetDCSObject()
if DCSObject then
local warehouse=STORAGE:NewFromDynamicCargo(CargoName)
self.warehouse=warehouse
end
self.lid=string.format("DYNAMICCARGO %s",CargoName)
self.Owner=string.match(CargoName,"^(.+)|%d%d:%d%d|PKG%d+")or"None"
self.timer=TIMER:New(DYNAMICCARGO._UpdatePosition,self)
self.timer:Start(self.Interval,self.Interval)
if not _DYNAMICCARGO_HELOS then
_DYNAMICCARGO_HELOS=SET_CLIENT:New():FilterAlive():FilterFunction(DYNAMICCARGO._FilterHeloTypes):FilterStart()
end
if self.testing then
BASE:TraceOn()
BASE:TraceClass("DYNAMICCARGO")
end
return self
end
function DYNAMICCARGO:GetDCSObject()
local DCSStatic=StaticObject.getByName(self.StaticName)or Unit.getByName(self.StaticName)
if DCSStatic then
return DCSStatic
end
return nil
end
function DYNAMICCARGO:GetLastOwner()
return self.Owner
end
function DYNAMICCARGO:IsNew()
if self.CargoState and self.CargoState==DYNAMICCARGO.State.NEW then
return true
else
return false
end
end
function DYNAMICCARGO:IsLoaded()
if self.CargoState and self.CargoState==DYNAMICCARGO.State.LOADED then
return true
else
return false
end
end
function DYNAMICCARGO:IsUnloaded()
if self.CargoState and self.CargoState==DYNAMICCARGO.State.UNLOADED then
return true
else
return false
end
end
function DYNAMICCARGO:IsRemoved()
if self.CargoState and self.CargoState==DYNAMICCARGO.State.REMOVED then
return true
else
return false
end
end
function DYNAMICCARGO:GetCratesNeeded()
return 1
end
function DYNAMICCARGO:WasDropped()
return self.CargoState==DYNAMICCARGO.State.UNLOADED and true or false
end
function DYNAMICCARGO:GetType()
return CTLD_CARGO.Enum.GCLOADABLE
end
function DYNAMICCARGO:GetLastPosition()
return self.LastPosition
end
function DYNAMICCARGO:GetState()
return self.CargoState
end
function DYNAMICCARGO:FindByName(Name)
local storage=_DATABASE:FindDynamicCargo(Name)
return storage
end
function DYNAMICCARGO:FindByMatching(Pattern)
local GroupFound=nil
for name,static in pairs(_DATABASE.DYNAMICCARGO)do
if string.match(name,Pattern)then
GroupFound=static
break
end
end
return GroupFound
end
function DYNAMICCARGO:FindAllByMatching(Pattern)
local GroupsFound={}
for name,static in pairs(_DATABASE.DYNAMICCARGO)do
if string.match(name,Pattern)then
GroupsFound[#GroupsFound+1]=static
end
end
return GroupsFound
end
function DYNAMICCARGO:GetStorageObject()
return self.warehouse
end
function DYNAMICCARGO:GetCargoWeight()
local DCSObject=self:GetDCSObject()
if DCSObject then
local weight=DCSObject:getCargoWeight()
return weight
else
return 0
end
end
function DYNAMICCARGO:GetCargoDisplayName()
local DCSObject=self:GetDCSObject()
if DCSObject then
local weight=DCSObject:getCargoDisplayName()
return weight
else
return self.StaticName
end
end
function DYNAMICCARGO:_HeloHovering(Unit,ropelength)
local DCSUnit=Unit:GetDCSObject()
local hovering=false
local Height=0
if DCSUnit then
local UnitInAir=DCSUnit:inAir()
local UnitCategory=DCSUnit:getDesc().category
if UnitInAir==true and UnitCategory==1 then
local VelocityVec3=DCSUnit:getVelocity()
local Velocity=UTILS.VecNorm(VelocityVec3)
local Coordinate=DCSUnit:getPoint()
local LandHeight=land.getHeight({x=Coordinate.x,y=Coordinate.z})
Height=Coordinate.y-LandHeight
if Velocity<1 and Height<=ropelength and Height>6 then
hovering=true
end
end
return hovering,Height
end
return false
end
function DYNAMICCARGO:_GetPossibleHeloNearby(pos,loading)
local set=_DYNAMICCARGO_HELOS:GetAliveSet()
local success=false
local Helo=nil
local Playername=nil
for _,_helo in pairs(set or{})do
local helo=_helo
local name=helo:GetPlayerName()or _DATABASE:_FindPlayerNameByUnitName(helo:GetName())or"None"
self:T(self.lid.." Checking: "..name)
local hpos=helo:GetCoordinate()
local typename=helo:GetTypeName()
local dimensions=DYNAMICCARGO.AircraftDimensions[typename]
local hovering,height=self:_HeloHovering(helo,dimensions.ropelength)
local helolanded=not helo:InAir()
self:T(self.lid.." InAir: AGL/Hovering: "..hpos.y-hpos:GetLandHeight().."/"..tostring(hovering))
if hpos and typename and dimensions then
local delta2D=hpos:Get2DDistance(pos)
local delta3D=hpos:Get3DDistance(pos)
if self.testing then
self:T(string.format("Cargo relative position: 2D %dm | 3D %dm",delta2D,delta3D))
self:T(string.format("Helo dimension: length %dm | width %dm | rope %dm",dimensions.length,dimensions.width,dimensions.ropelength))
self:T(string.format("Helo hovering: %s at %dm",tostring(hovering),height))
end
if loading~=true and(delta2D>dimensions.length or delta2D>dimensions.width)and helolanded then
success=true
Helo=helo
Playername=name
end
if loading~=true and delta3D>dimensions.ropelength then
success=true
Helo=helo
Playername=name
end
if loading==true and((delta2D<dimensions.length and delta2D<dimensions.width and helolanded)or(delta3D==dimensions.ropelength and helo:InAir()))then
success=true
Helo=helo
Playername=name
end
end
end
return success,Helo,Playername
end
function DYNAMICCARGO:_UpdatePosition()
self:T(self.lid.." _UpdatePositionAndState")
if self:IsAlive()then
local pos=self:GetCoordinate()
if self.testing then
self:T(string.format("Cargo position: x=%d, y=%d, z=%d",pos.x,pos.y,pos.z))
self:T(string.format("Last position: x=%d, y=%d, z=%d",self.LastPosition.x,self.LastPosition.y,self.LastPosition.z))
end
if UTILS.Round(UTILS.VecDist3D(pos,self.LastPosition),2)>0.5 then
if self.CargoState==DYNAMICCARGO.State.NEW or self.CargoState==DYNAMICCARGO.State.UNLOADED then
local isloaded,client,playername=self:_GetPossibleHeloNearby(pos,true)
self:T(self.lid.." moved! NEW -> LOADED by "..tostring(playername))
self.CargoState=DYNAMICCARGO.State.LOADED
self.Owner=playername
_DATABASE:CreateEventDynamicCargoLoaded(self)
end
elseif self.CargoState==DYNAMICCARGO.State.LOADED then
local count=_DYNAMICCARGO_HELOS:CountAlive()
local landheight=pos:GetLandHeight()
local agl=pos.y-landheight
agl=UTILS.Round(agl,2)
self:T(self.lid.." AGL: "..agl or-1)
local isunloaded=true
local client
local playername=self.Owner
if count>0 then
self:T(self.lid.." Possible alive helos: "..count or-1)
isunloaded,client,playername=self:_GetPossibleHeloNearby(pos,false)
if isunloaded then
self:T(self.lid.." moved! LOADED -> UNLOADED by "..tostring(playername))
self.CargoState=DYNAMICCARGO.State.UNLOADED
self.Owner=playername
_DATABASE:CreateEventDynamicCargoUnloaded(self)
end
end
end
self.LastPosition=pos
else
if self.timer and self.timer:IsRunning()then self.timer:Stop()end
self:T(self.lid.." dead! "..self.CargoState.."-> REMOVED")
self.CargoState=DYNAMICCARGO.State.REMOVED
_DATABASE:CreateEventDynamicCargoRemoved(self)
end
return self
end
function DYNAMICCARGO._FilterHeloTypes(client)
if not client then return false end
local typename=client:GetTypeName()
local isinclude=DYNAMICCARGO.AircraftTypes[typename]~=nil and true or false
return isinclude
end
SCORING={
ClassName="SCORING",
ClassID=0,
Players={},
AutoSave=true,
version="1.18.4"
}
local _SCORINGCoalition={
[1]="Red",
[2]="Blue",
}
local _SCORINGCategory={
[Unit.Category.AIRPLANE]="Plane",
[Unit.Category.HELICOPTER]="Helicopter",
[Unit.Category.GROUND_UNIT]="Vehicle",
[Unit.Category.SHIP]="Ship",
[Unit.Category.STRUCTURE]="Structure",
}
function SCORING:New(GameName,SavePath,AutoSave)
local self=BASE:Inherit(self,BASE:New())
if GameName then
self.GameName=GameName
else
error("A game name must be given to register the scoring results")
end
self.ScoringObjects={}
self.ScoringZones={}
self:SetMessagesToAll()
self:SetMessagesHit(false)
self:SetMessagesDestroy(true)
self:SetMessagesScore(true)
self:SetMessagesZone(true)
self:SetScaleDestroyScore(10)
self:SetScaleDestroyPenalty(30)
self:SetScoreIncrementOnHit(0)
self:SetFratricide(self.ScaleDestroyPenalty*3)
self.penaltyonfratricide=true
self:SetCoalitionChangePenalty(self.ScaleDestroyPenalty)
self.penaltyoncoalitionchange=true
self:SetDisplayMessagePrefix()
self:HandleEvent(EVENTS.Dead,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Crash,self._EventOnDeadOrCrash)
self:HandleEvent(EVENTS.Hit,self._EventOnHit)
self:HandleEvent(EVENTS.Birth)
self:HandleEvent(EVENTS.PlayerLeaveUnit)
self.ScoringPlayerScan=BASE:ScheduleOnce(1,function()
for PlayerName,PlayerUnit in pairs(_DATABASE:GetPlayerUnits())do
self:_AddPlayerFromUnit(PlayerUnit)
self:SetScoringMenu(PlayerUnit:GetGroup())
end
end)
self.AutoSavePath=SavePath
self.AutoSave=AutoSave or true
self:OpenCSV(GameName)
return self
end
function SCORING:SetDisplayMessagePrefix(DisplayMessagePrefix)
self.DisplayMessagePrefix=DisplayMessagePrefix or""
return self
end
function SCORING:SetScaleDestroyScore(Scale)
self.ScaleDestroyScore=Scale
return self
end
function SCORING:SetScaleDestroyPenalty(Scale)
self.ScaleDestroyPenalty=Scale
return self
end
function SCORING:AddUnitScore(ScoreUnit,Score)
local UnitName=ScoreUnit:GetName()
self.ScoringObjects[UnitName]=Score
return self
end
function SCORING:RemoveUnitScore(ScoreUnit)
local UnitName=ScoreUnit:GetName()
self.ScoringObjects[UnitName]=nil
return self
end
function SCORING:AddStaticScore(ScoreStatic,Score)
local StaticName=ScoreStatic:GetName()
self.ScoringObjects[StaticName]=Score
return self
end
function SCORING:RemoveStaticScore(ScoreStatic)
local StaticName=ScoreStatic:GetName()
self.ScoringObjects[StaticName]=nil
return self
end
function SCORING:AddScoreGroup(ScoreGroup,Score)
local ScoreUnits=ScoreGroup:GetUnits()
for ScoreUnitID,ScoreUnit in pairs(ScoreUnits)do
local UnitName=ScoreUnit:GetName()
self.ScoringObjects[UnitName]=Score
end
return self
end
function SCORING:AddScoreSetGroup(Set,Score)
local set=Set:GetSetObjects()
for _,_group in pairs(set)do
if _group and _group:IsAlive()then
self:AddScoreGroup(_group,Score)
end
end
local function AddScore(group)
self:AddScoreGroup(group,Score)
end
function Set:OnAfterAdded(From,Event,To,ObjectName,Object)
AddScore(Object)
end
return self
end
function SCORING:AddZoneScore(ScoreZone,Score)
local ZoneName=ScoreZone:GetName()
self.ScoringZones[ZoneName]={}
self.ScoringZones[ZoneName].ScoreZone=ScoreZone
self.ScoringZones[ZoneName].Score=Score
return self
end
function SCORING:RemoveZoneScore(ScoreZone)
local ZoneName=ScoreZone:GetName()
self.ScoringZones[ZoneName]=nil
return self
end
function SCORING:SetMessagesHit(OnOff)
self.MessagesHit=OnOff
return self
end
function SCORING:SetScoreIncrementOnHit(score)
self.ScoreIncrementOnHit=score
return self
end
function SCORING:IfMessagesHit()
return self.MessagesHit
end
function SCORING:SetMessagesDestroy(OnOff)
self.MessagesDestroy=OnOff
return self
end
function SCORING:IfMessagesDestroy()
return self.MessagesDestroy
end
function SCORING:SetMessagesScore(OnOff)
self.MessagesScore=OnOff
return self
end
function SCORING:IfMessagesScore()
return self.MessagesScore
end
function SCORING:SetMessagesZone(OnOff)
self.MessagesZone=OnOff
return self
end
function SCORING:IfMessagesZone()
return self.MessagesZone
end
function SCORING:SetMessagesToAll()
self.MessagesAudience=1
return self
end
function SCORING:IfMessagesToAll()
return self.MessagesAudience==1
end
function SCORING:SetMessagesToCoalition()
self.MessagesAudience=2
return self
end
function SCORING:IfMessagesToCoalition()
return self.MessagesAudience==2
end
function SCORING:SetFratricide(Fratricide)
self.Fratricide=Fratricide
return self
end
function SCORING:SwitchFratricide(OnOff)
self.penaltyonfratricide=OnOff
return self
end
function SCORING:SwitchTreason(OnOff)
self.penaltyoncoalitionchange=OnOff
return self
end
function SCORING:SetCoalitionChangePenalty(CoalitionChangePenalty)
self.CoalitionChangePenalty=CoalitionChangePenalty
return self
end
function SCORING:SetScoringMenu(ScoringGroup)
local Menu=MENU_GROUP:New(ScoringGroup,'Scoring and Statistics')
local ReportGroupSummary=MENU_GROUP_COMMAND:New(ScoringGroup,'Summary report players in group',Menu,SCORING.ReportScoreGroupSummary,self,ScoringGroup)
local ReportGroupDetailed=MENU_GROUP_COMMAND:New(ScoringGroup,'Detailed report players in group',Menu,SCORING.ReportScoreGroupDetailed,self,ScoringGroup)
local ReportToAllSummary=MENU_GROUP_COMMAND:New(ScoringGroup,'Summary report all players',Menu,SCORING.ReportScoreAllSummary,self,ScoringGroup)
self:SetState(ScoringGroup,"ScoringMenu",Menu)
return self
end
function SCORING:_AddPlayerFromUnit(UnitData)
self:F(UnitData)
if UnitData:IsAlive()then
local UnitName=UnitData:GetName()
local PlayerName=UnitData:GetPlayerName()
local UnitDesc=UnitData:GetDesc()
local UnitCategory=UnitDesc.category
local UnitCoalition=UnitData:GetCoalition()
local UnitTypeName=UnitData:GetTypeName()
local UnitThreatLevel,UnitThreatType=UnitData:GetThreatLevel()
self:T({PlayerName,UnitName,UnitCategory,UnitCoalition,UnitTypeName})
if self.Players[PlayerName]==nil then
self.Players[PlayerName]={}
self.Players[PlayerName].Hit={}
self.Players[PlayerName].Destroy={}
self.Players[PlayerName].Goals={}
self.Players[PlayerName].Mission={}
self.Players[PlayerName].HitPlayers={}
self.Players[PlayerName].Score=0
self.Players[PlayerName].Penalty=0
self.Players[PlayerName].PenaltyCoalition=0
self.Players[PlayerName].PenaltyWarning=0
end
if not self.Players[PlayerName].UnitCoalition then
self.Players[PlayerName].UnitCoalition=UnitCoalition
else
if self.Players[PlayerName].UnitCoalition~=UnitCoalition and self.penaltyoncoalitionchange then
self.Players[PlayerName].Penalty=self.Players[PlayerName].Penalty+self.CoalitionChangePenalty or 50
self.Players[PlayerName].PenaltyCoalition=self.Players[PlayerName].PenaltyCoalition+1
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' changed coalition from ".._SCORINGCoalition[self.Players[PlayerName].UnitCoalition].." to ".._SCORINGCoalition[UnitCoalition]..
"(changed "..self.Players[PlayerName].PenaltyCoalition.." times the coalition). "..self.CoalitionChangePenalty.." penalty points added.",
MESSAGE.Type.Information
):ToAll()
self:ScoreCSV(PlayerName,"","COALITION_PENALTY",1,-1*self.CoalitionChangePenalty,self.Players[PlayerName].UnitName,_SCORINGCoalition[self.Players[PlayerName].UnitCoalition],_SCORINGCategory[self.Players[PlayerName].UnitCategory],self.Players[PlayerName].UnitType,
UnitName,_SCORINGCoalition[UnitCoalition],_SCORINGCategory[UnitCategory],UnitData:GetTypeName())
end
end
self.Players[PlayerName].UnitName=UnitName
self.Players[PlayerName].UnitCoalition=UnitCoalition
self.Players[PlayerName].UnitCategory=UnitCategory
self.Players[PlayerName].UnitType=UnitTypeName
self.Players[PlayerName].UNIT=UnitData
self.Players[PlayerName].ThreatLevel=UnitThreatLevel
self.Players[PlayerName].ThreatType=UnitThreatType
if self.Players[PlayerName].Penalty>self.Fratricide*0.50 and self.penaltyonfratricide then
if self.Players[PlayerName].PenaltyWarning<1 then
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."': WARNING! If you continue to commit FRATRICIDE and have a PENALTY score higher than "..self.Fratricide..", you will be COURT MARTIALED and DISMISSED from this mission! \nYour total penalty is: "..self.Players[PlayerName].Penalty,
MESSAGE.Type.Information)
:ToAll()
self.Players[PlayerName].PenaltyWarning=self.Players[PlayerName].PenaltyWarning+1
end
end
if self.Players[PlayerName].Penalty>self.Fratricide and self.penaltyonfratricide then
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' committed FRATRICIDE, he will be COURT MARTIALED and is DISMISSED from this mission!",
MESSAGE.Type.Information)
:ToAll()
UnitData:GetGroup():Destroy()
end
end
end
function SCORING:AddGoalScorePlayer(PlayerName,GoalTag,Text,Score)
self:F({PlayerName,PlayerName,GoalTag,Text,Score})
if PlayerName then
local PlayerData=self.Players[PlayerName]
PlayerData.Goals[GoalTag]=PlayerData.Goals[GoalTag]or{Score=0}
PlayerData.Goals[GoalTag].Score=PlayerData.Goals[GoalTag].Score+Score
PlayerData.Score=PlayerData.Score+Score
if Text then
MESSAGE:NewType(self.DisplayMessagePrefix..Text,
MESSAGE.Type.Information)
:ToAll()
end
self:ScoreCSV(PlayerName,"","GOAL_"..string.upper(GoalTag),1,Score,nil)
end
end
function SCORING:AddGoalScore(PlayerUnit,GoalTag,Text,Score)
local PlayerName=PlayerUnit:GetPlayerName()
self:T2({PlayerUnit.UnitName,PlayerName,GoalTag,Text,Score})
if PlayerName then
local PlayerData=self.Players[PlayerName]
PlayerData.Goals[GoalTag]=PlayerData.Goals[GoalTag]or{Score=0}
PlayerData.Goals[GoalTag].Score=PlayerData.Goals[GoalTag].Score+Score
PlayerData.Score=PlayerData.Score+Score
if Text then
MESSAGE:NewType(self.DisplayMessagePrefix..Text,
MESSAGE.Type.Information)
:ToAll()
end
self:ScoreCSV(PlayerName,"","GOAL_"..string.upper(GoalTag),1,Score,PlayerUnit:GetName())
end
end
function SCORING:_AddMissionTaskScore(Mission,PlayerUnit,Text,Score)
local PlayerName=PlayerUnit:GetPlayerName()
local MissionName=Mission:GetName()
self:F({Mission:GetName(),PlayerUnit.UnitName,PlayerName,Text,Score})
if PlayerName then
local PlayerData=self.Players[PlayerName]
if not PlayerData.Mission[MissionName]then
PlayerData.Mission[MissionName]={}
PlayerData.Mission[MissionName].ScoreTask=0
PlayerData.Mission[MissionName].ScoreMission=0
end
self:T(PlayerName)
self:T(PlayerData.Mission[MissionName])
PlayerData.Score=self.Players[PlayerName].Score+Score
PlayerData.Mission[MissionName].ScoreTask=self.Players[PlayerName].Mission[MissionName].ScoreTask+Score
if Text then
MESSAGE:NewType(self.DisplayMessagePrefix..Mission:GetText().." : "..Text.." Score: "..Score,
MESSAGE.Type.Information)
:ToAll()
end
self:ScoreCSV(PlayerName,"","TASK_"..MissionName:gsub(' ','_'),1,Score,PlayerUnit:GetName())
end
end
function SCORING:_AddMissionGoalScore(Mission,PlayerName,Text,Score)
local MissionName=Mission:GetName()
self:F({Mission:GetName(),PlayerName,Text,Score})
if PlayerName then
local PlayerData=self.Players[PlayerName]
if not PlayerData.Mission[MissionName]then
PlayerData.Mission[MissionName]={}
PlayerData.Mission[MissionName].ScoreTask=0
PlayerData.Mission[MissionName].ScoreMission=0
end
self:T(PlayerName)
self:T(PlayerData.Mission[MissionName])
PlayerData.Score=self.Players[PlayerName].Score+Score
PlayerData.Mission[MissionName].ScoreTask=self.Players[PlayerName].Mission[MissionName].ScoreTask+Score
if Text then
MESSAGE:NewType(string.format("%s%s: %s! Player %s receives %d score!",self.DisplayMessagePrefix,Mission:GetText(),Text,PlayerName,Score),MESSAGE.Type.Information):ToAll()
end
self:ScoreCSV(PlayerName,"","TASK_"..MissionName:gsub(' ','_'),1,Score)
end
end
function SCORING:_AddMissionScore(Mission,Text,Score)
local MissionName=Mission:GetName()
self:F({Mission,Text,Score})
self:F(self.Players)
for PlayerName,PlayerData in pairs(self.Players)do
self:F(PlayerData)
if PlayerData.Mission[MissionName]then
PlayerData.Score=PlayerData.Score+Score
PlayerData.Mission[MissionName].ScoreMission=PlayerData.Mission[MissionName].ScoreMission+Score
if Text then
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' has "..Text.." in "..Mission:GetText()..". "..Score.." mission score!",
MESSAGE.Type.Information)
:ToAll()
end
self:ScoreCSV(PlayerName,"","MISSION_"..MissionName:gsub(' ','_'),1,Score)
end
end
end
function SCORING:OnEventBirth(Event)
if Event.IniUnit then
Event.IniUnit.ThreatLevel,Event.IniUnit.ThreatType=Event.IniUnit:GetThreatLevel()
if Event.IniObjectCategory==1 then
local PlayerName=Event.IniUnit:GetPlayerName()
Event.IniUnit.BirthTime=timer.getTime()
if PlayerName then
self:_AddPlayerFromUnit(Event.IniUnit)
self.Players[PlayerName].PlayerKills=0
self:SetScoringMenu(Event.IniGroup)
end
end
end
end
function SCORING:OnEventPlayerLeaveUnit(Event)
if Event.IniUnit then
local Menu=self:GetState(Event.IniUnit:GetGroup(),"ScoringMenu")
if Menu then
end
end
end
function SCORING:_EventOnHit(Event)
self:F({Event})
local InitUnit=nil
local InitUNIT=nil
local InitUnitName=""
local InitGroup=nil
local InitGroupName=""
local InitPlayerName=nil
local InitCoalition=nil
local InitCategory=nil
local InitType=nil
local InitUnitCoalition=nil
local InitUnitCategory=nil
local InitUnitType=nil
local TargetUnit=nil
local TargetUNIT=nil
local TargetUnitName=""
local TargetGroup=nil
local TargetGroupName=""
local TargetPlayerName=nil
local TargetCoalition=nil
local TargetCategory=nil
local TargetType=nil
local TargetUnitCoalition=nil
local TargetUnitCategory=nil
local TargetUnitType=nil
if Event.IniDCSUnit then
InitUnit=Event.IniDCSUnit
InitUNIT=Event.IniUnit
InitUnitName=Event.IniDCSUnitName
InitGroup=Event.IniDCSGroup
InitGroupName=Event.IniDCSGroupName
InitPlayerName=Event.IniPlayerName
InitCoalition=Event.IniCoalition
InitCategory=Event.IniCategory
InitType=Event.IniTypeName
InitUnitCoalition=_SCORINGCoalition[InitCoalition]
InitUnitCategory=_SCORINGCategory[InitCategory]
InitUnitType=InitType
self:T({InitUnitName,InitGroupName,InitPlayerName,InitCoalition,InitCategory,InitType,InitUnitCoalition,InitUnitCategory,InitUnitType})
end
if Event.TgtDCSUnit then
TargetUnit=Event.TgtDCSUnit
TargetUNIT=Event.TgtUnit
TargetUnitName=Event.TgtDCSUnitName
TargetGroup=Event.TgtDCSGroup
TargetGroupName=Event.TgtDCSGroupName
TargetPlayerName=Event.TgtPlayerName
TargetCoalition=Event.TgtCoalition
TargetCategory=Event.TgtCategory
TargetType=Event.TgtTypeName
TargetUnitCoalition=_SCORINGCoalition[TargetCoalition]
TargetUnitCategory=_SCORINGCategory[TargetCategory]
TargetUnitType=TargetType
self:T({TargetUnitName,TargetGroupName,TargetPlayerName,TargetCoalition,TargetCategory,TargetType,TargetUnitCoalition,TargetUnitCategory,TargetUnitType})
end
if InitPlayerName~=nil then
self:_AddPlayerFromUnit(InitUNIT)
if self.Players[InitPlayerName]then
if TargetPlayerName~=nil then
self:_AddPlayerFromUnit(TargetUNIT)
end
self:T("Hitting Something")
if TargetCategory then
local Player=self.Players[InitPlayerName]
Player.Hit[TargetCategory]=Player.Hit[TargetCategory]or{}
Player.Hit[TargetCategory][TargetUnitName]=Player.Hit[TargetCategory][TargetUnitName]or{}
local PlayerHit=Player.Hit[TargetCategory][TargetUnitName]
PlayerHit.Score=PlayerHit.Score or 0
PlayerHit.Penalty=PlayerHit.Penalty or 0
PlayerHit.ScoreHit=PlayerHit.ScoreHit or 0
PlayerHit.PenaltyHit=PlayerHit.PenaltyHit or 0
PlayerHit.TimeStamp=PlayerHit.TimeStamp or 0
PlayerHit.UNIT=PlayerHit.UNIT or TargetUNIT
if PlayerHit.UNIT.ThreatType==nil then
PlayerHit.ThreatLevel,PlayerHit.ThreatType=PlayerHit.UNIT:GetThreatLevel()
if PlayerHit.ThreatType==nil or PlayerHit.ThreatType==""then
PlayerHit.ThreatLevel=1
PlayerHit.ThreatType="Unknown"
end
else
PlayerHit.ThreatLevel=PlayerHit.UNIT.ThreatLevel
PlayerHit.ThreatType=PlayerHit.UNIT.ThreatType
end
if timer.getTime()-PlayerHit.TimeStamp>1 then
PlayerHit.TimeStamp=timer.getTime()
if TargetPlayerName~=nil then
Player.HitPlayers[TargetPlayerName]=true
end
local Score=0
if InitCoalition then
if InitCoalition==TargetCoalition then
local Penalty=10
Player.Penalty=Player.Penalty+Penalty
PlayerHit.Penalty=PlayerHit.Penalty+Penalty
PlayerHit.PenaltyHit=PlayerHit.PenaltyHit+1
if TargetPlayerName~=nil then
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..InitPlayerName.."' hit friendly player '"..TargetPlayerName.."' "..TargetUnitCategory.." ( "..TargetType.." ) "..PlayerHit.PenaltyHit.." times. "..
"Penalty: -"..Penalty..".  Score Total:"..Player.Score-Player.Penalty,
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
else
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..InitPlayerName.."' hit friendly target "..TargetUnitCategory.." ( "..TargetType.." ) "..PlayerHit.PenaltyHit.." times. "..
"Penalty: -"..Penalty..".  Score Total:"..Player.Score-Player.Penalty,
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
end
self:ScoreCSV(InitPlayerName,TargetPlayerName,"HIT_PENALTY",1,-10,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
else
Player.Score=Player.Score+self.ScoreIncrementOnHit
PlayerHit.Score=PlayerHit.Score+self.ScoreIncrementOnHit
PlayerHit.ScoreHit=PlayerHit.ScoreHit+1
if TargetPlayerName~=nil then
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..InitPlayerName.."' hit enemy player '"..TargetPlayerName.."' "..TargetUnitCategory.." ( "..TargetType.." ) "..PlayerHit.ScoreHit.." times. "..
"Score: "..PlayerHit.Score..".  Score Total:"..Player.Score-Player.Penalty,
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
else
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..InitPlayerName.."' hit enemy target "..TargetUnitCategory.." ( "..TargetType.." ) "..PlayerHit.ScoreHit.." times. "..
"Score: "..PlayerHit.Score..".  Score Total:"..Player.Score-Player.Penalty,
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
end
self:ScoreCSV(InitPlayerName,TargetPlayerName,"HIT_SCORE",1,1,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
end
else
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..InitPlayerName.."' hit scenery object.",
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
self:ScoreCSV(InitPlayerName,"","HIT_SCORE",1,0,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,"","Scenery",TargetUnitType)
end
end
end
end
elseif InitPlayerName==nil then
end
if Event.WeaponPlayerName~=nil then
self:_AddPlayerFromUnit(Event.WeaponUNIT)
if self.Players[Event.WeaponPlayerName]then
if TargetPlayerName~=nil then
self:_AddPlayerFromUnit(TargetUNIT)
end
self:T("Hitting Scenery")
if TargetCategory then
local Player=self.Players[Event.WeaponPlayerName]
Player.Hit[TargetCategory]=Player.Hit[TargetCategory]or{}
Player.Hit[TargetCategory][TargetUnitName]=Player.Hit[TargetCategory][TargetUnitName]or{}
local PlayerHit=Player.Hit[TargetCategory][TargetUnitName]
PlayerHit.Score=PlayerHit.Score or 0
PlayerHit.Penalty=PlayerHit.Penalty or 0
PlayerHit.ScoreHit=PlayerHit.ScoreHit or 0
PlayerHit.PenaltyHit=PlayerHit.PenaltyHit or 0
PlayerHit.TimeStamp=PlayerHit.TimeStamp or 0
PlayerHit.UNIT=PlayerHit.UNIT or TargetUNIT
if PlayerHit.UNIT.ThreatType==nil then
PlayerHit.ThreatLevel,PlayerHit.ThreatType=PlayerHit.UNIT:GetThreatLevel()
if PlayerHit.ThreatType==nil then
PlayerHit.ThreatLevel=1
PlayerHit.ThreatType="Unknown"
end
else
PlayerHit.ThreatLevel=PlayerHit.UNIT.ThreatLevel
PlayerHit.ThreatType=PlayerHit.UNIT.ThreatType
end
if timer.getTime()-PlayerHit.TimeStamp>1 then
PlayerHit.TimeStamp=timer.getTime()
local Score=0
if InitCoalition then
if InitCoalition==TargetCoalition then
local Penalty=10
Player.Penalty=Player.Penalty+Penalty
PlayerHit.Penalty=PlayerHit.Penalty+Penalty
PlayerHit.PenaltyHit=PlayerHit.PenaltyHit+1*self.ScaleDestroyPenalty
MESSAGE
:NewType(self.DisplayMessagePrefix.."Player '"..Event.WeaponPlayerName.."' hit friendly target "..
TargetUnitCategory.." ( "..TargetType.." ) "..
"Penalty: -"..Penalty.." = "..Player.Score-Player.Penalty,
MESSAGE.Type.Update
)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(Event.WeaponCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
self:ScoreCSV(Event.WeaponPlayerName,TargetPlayerName,"HIT_PENALTY",1,-10,Event.WeaponName,Event.WeaponCoalition,Event.WeaponCategory,Event.WeaponTypeName,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
else
Player.Score=Player.Score+self.ScoreIncrementOnHit
PlayerHit.Score=PlayerHit.Score+self.ScoreIncrementOnHit
PlayerHit.ScoreHit=PlayerHit.ScoreHit+1
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..Event.WeaponPlayerName.."' hit enemy target "..TargetUnitCategory.." ( "..TargetType.." ) "..
"Score: "..PlayerHit.Score..".  Score Total:"..Player.Score-Player.Penalty,
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(Event.WeaponCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
self:ScoreCSV(Event.WeaponPlayerName,TargetPlayerName,"HIT_SCORE",1,1,Event.WeaponName,Event.WeaponCoalition,Event.WeaponCategory,Event.WeaponTypeName,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
end
else
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..Event.WeaponPlayerName.."' hit scenery object.",
MESSAGE.Type.Update)
:ToAllIf(self:IfMessagesHit()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesHit()and self:IfMessagesToCoalition())
self:ScoreCSV(Event.WeaponPlayerName,"","HIT_SCORE",1,0,Event.WeaponName,Event.WeaponCoalition,Event.WeaponCategory,Event.WeaponTypeName,TargetUnitName,"","Scenery",TargetUnitType)
end
end
end
end
end
end
function SCORING:_EventOnDeadOrCrash(Event)
self:F({Event})
local TargetUnit=nil
local TargetGroup=nil
local TargetUnitName=""
local TargetGroupName=""
local TargetPlayerName=""
local TargetCoalition=nil
local TargetCategory=nil
local TargetType=nil
local TargetUnitCoalition=nil
local TargetUnitCategory=nil
local TargetUnitType=nil
if Event.IniDCSUnit then
TargetUnit=Event.IniUnit
TargetUnitName=Event.IniDCSUnitName
TargetGroup=Event.IniDCSGroup
TargetGroupName=Event.IniDCSGroupName
TargetPlayerName=Event.IniPlayerName
TargetCoalition=Event.IniCoalition
TargetCategory=Event.IniCategory
TargetType=Event.IniTypeName
TargetUnitCoalition=_SCORINGCoalition[TargetCoalition]
TargetUnitCategory=_SCORINGCategory[TargetCategory]
TargetUnitType=TargetType
self:T({TargetUnitName,TargetGroupName,TargetPlayerName,TargetCoalition,TargetCategory,TargetType})
end
for PlayerName,Player in pairs(self.Players)do
if Player then
self:T("Something got destroyed")
local InitUnitName=Player.UnitName
local InitUnitType=Player.UnitType
local InitCoalition=Player.UnitCoalition
local InitCategory=Player.UnitCategory
local InitUnitCoalition=_SCORINGCoalition[InitCoalition]
local InitUnitCategory=_SCORINGCategory[InitCategory]
self:T({InitUnitName,InitUnitType,InitUnitCoalition,InitCoalition,InitUnitCategory,InitCategory})
local Destroyed=false
if Player and Player.Hit and Player.Hit[TargetCategory]and Player.Hit[TargetCategory][TargetUnitName]and Player.Hit[TargetCategory][TargetUnitName].TimeStamp~=0 and(TargetUnit.BirthTime==nil or Player.Hit[TargetCategory][TargetUnitName].TimeStamp>TargetUnit.BirthTime)then
local TargetThreatLevel=Player.Hit[TargetCategory][TargetUnitName].ThreatLevel
local TargetThreatType=Player.Hit[TargetCategory][TargetUnitName].ThreatType
Player.Destroy[TargetCategory]=Player.Destroy[TargetCategory]or{}
Player.Destroy[TargetCategory][TargetType]=Player.Destroy[TargetCategory][TargetType]or{}
local TargetDestroy=Player.Destroy[TargetCategory][TargetType]
TargetDestroy.Score=TargetDestroy.Score or 0
TargetDestroy.ScoreDestroy=TargetDestroy.ScoreDestroy or 0
TargetDestroy.Penalty=TargetDestroy.Penalty or 0
TargetDestroy.PenaltyDestroy=TargetDestroy.PenaltyDestroy or 0
if TargetCoalition then
if InitCoalition==TargetCoalition then
local ThreatLevelTarget=TargetThreatLevel
local ThreatTypeTarget=TargetThreatType
local ThreatLevelPlayer=Player.ThreatLevel/10+1
local ThreatPenalty=math.ceil((ThreatLevelTarget/ThreatLevelPlayer)*self.ScaleDestroyPenalty/10)
self:F({ThreatLevel=ThreatPenalty,ThreatLevelTarget=ThreatLevelTarget,ThreatTypeTarget=ThreatTypeTarget,ThreatLevelPlayer=ThreatLevelPlayer})
Player.Penalty=Player.Penalty+ThreatPenalty
TargetDestroy.Penalty=TargetDestroy.Penalty+ThreatPenalty
TargetDestroy.PenaltyDestroy=TargetDestroy.PenaltyDestroy+1
if Player.HitPlayers[TargetPlayerName]then
self:OnKillPvP(PlayerName,TargetPlayerName,true)
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' destroyed friendly player '"..TargetPlayerName.."' "..TargetUnitCategory.." ( "..ThreatTypeTarget.." ) "..
"Penalty: -"..ThreatPenalty.." = "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesDestroy()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesDestroy()and self:IfMessagesToCoalition())
else
self:OnKillPvE(PlayerName,TargetUnitName,true,TargetThreatLevel,Player.ThreatLevel,ThreatPenalty)
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' destroyed friendly target "..TargetUnitCategory.." ( "..ThreatTypeTarget.." ) "..
"Penalty: -"..ThreatPenalty.." = "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesDestroy()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesDestroy()and self:IfMessagesToCoalition())
end
self:ScoreCSV(PlayerName,TargetPlayerName,"DESTROY_PENALTY",1,ThreatPenalty,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
Destroyed=true
else
local ThreatLevelTarget=TargetThreatLevel
local ThreatTypeTarget=TargetThreatType
local ThreatLevelPlayer=Player.ThreatLevel/10+1
local ThreatScore=math.ceil((ThreatLevelTarget/ThreatLevelPlayer)*self.ScaleDestroyScore/10)
self:F({ThreatLevel=ThreatScore,ThreatLevelTarget=ThreatLevelTarget,ThreatTypeTarget=ThreatTypeTarget,ThreatLevelPlayer=ThreatLevelPlayer})
Player.Score=Player.Score+ThreatScore
TargetDestroy.Score=TargetDestroy.Score+ThreatScore
TargetDestroy.ScoreDestroy=TargetDestroy.ScoreDestroy+1
if Player.HitPlayers[TargetPlayerName]then
if Player.PlayerKills~=nil then
Player.PlayerKills=Player.PlayerKills+1
else
Player.PlayerKills=1
end
self:OnKillPvP(PlayerName,TargetPlayerName,false,TargetThreatLevel,Player.ThreatLevel,ThreatScore)
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' destroyed enemy player '"..TargetPlayerName.."' "..TargetUnitCategory.." ( "..ThreatTypeTarget.." ) "..
"Score: +"..ThreatScore.." = "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesDestroy()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesDestroy()and self:IfMessagesToCoalition())
else
self:OnKillPvE(PlayerName,TargetUnitName,false,TargetThreatLevel,Player.ThreatLevel,ThreatScore)
MESSAGE:NewType(self.DisplayMessagePrefix.."Player '"..PlayerName.."' destroyed enemy "..TargetUnitCategory.." ( "..ThreatTypeTarget.." ) "..
"Score: +"..ThreatScore.." = "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesDestroy()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesDestroy()and self:IfMessagesToCoalition())
end
self:ScoreCSV(PlayerName,TargetPlayerName,"DESTROY_SCORE",1,ThreatScore,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
Destroyed=true
local UnitName=TargetUnit:GetName()
local Score=self.ScoringObjects[UnitName]
if Score then
Player.Score=Player.Score+Score
TargetDestroy.Score=TargetDestroy.Score+Score
MESSAGE:NewType(self.DisplayMessagePrefix.."Special target '"..TargetUnitCategory.." ( "..ThreatTypeTarget.." ) ".." destroyed! "..
"Player '"..PlayerName.."' receives an extra "..Score.." points! Total: "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesScore()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesScore()and self:IfMessagesToCoalition())
self:ScoreCSV(PlayerName,TargetPlayerName,"DESTROY_SCORE",1,Score,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
Destroyed=true
end
for ZoneName,ScoreZoneData in pairs(self.ScoringZones)do
self:F({ScoringZone=ScoreZoneData})
local ScoreZone=ScoreZoneData.ScoreZone
local Score=ScoreZoneData.Score
if ScoreZone:IsVec2InZone(TargetUnit:GetVec2())then
Player.Score=Player.Score+Score
TargetDestroy.Score=TargetDestroy.Score+Score
MESSAGE:NewType(self.DisplayMessagePrefix.."Target destroyed in zone '"..ScoreZone:GetName().."'."..
"Player '"..PlayerName.."' receives an extra "..Score.." points! ".."Total: "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesZone()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesZone()and self:IfMessagesToCoalition())
self:ScoreCSV(PlayerName,TargetPlayerName,"DESTROY_SCORE",1,Score,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
Destroyed=true
end
end
end
else
for ZoneName,ScoreZoneData in pairs(self.ScoringZones)do
self:F({ScoringZone=ScoreZoneData})
local ScoreZone=ScoreZoneData.ScoreZone
local Score=ScoreZoneData.Score
if ScoreZone:IsVec2InZone(TargetUnit:GetVec2())then
Player.Score=Player.Score+Score
TargetDestroy.Score=TargetDestroy.Score+Score
MESSAGE:NewType(self.DisplayMessagePrefix.."Scenery destroyed in zone '"..ScoreZone:GetName().."'."..
"Player '"..PlayerName.."' receives an extra "..Score.." points! ".."Total: "..Player.Score-Player.Penalty,
MESSAGE.Type.Information)
:ToAllIf(self:IfMessagesZone()and self:IfMessagesToAll())
:ToCoalitionIf(InitCoalition,self:IfMessagesZone()and self:IfMessagesToCoalition())
self:ScoreCSV(PlayerName,"","DESTROY_SCORE",1,Score,InitUnitName,InitUnitCoalition,InitUnitCategory,InitUnitType,TargetUnitName,"","Scenery",TargetUnitType)
Destroyed=true
end
end
end
if Destroyed then
Player.Hit[TargetCategory][TargetUnitName].TimeStamp=0
end
end
end
end
end
function SCORING:ReportDetailedPlayerHits(PlayerName)
local ScoreMessage=""
local PlayerScore=0
local PlayerPenalty=0
local PlayerData=self.Players[PlayerName]
if PlayerData then
self:T("Score Player: "..PlayerName)
local InitUnitCoalition=_SCORINGCoalition[PlayerData.UnitCoalition]
local InitUnitCategory=_SCORINGCategory[PlayerData.UnitCategory]
local InitUnitType=PlayerData.UnitType
local InitUnitName=PlayerData.UnitName
local ScoreMessageHits=""
for CategoryID,CategoryName in pairs(_SCORINGCategory)do
self:T(CategoryName)
if PlayerData.Hit[CategoryID]then
self:T("Hit scores exist for player "..PlayerName)
local Score=0
local ScoreHit=0
local Penalty=0
local PenaltyHit=0
for UnitName,UnitData in pairs(PlayerData.Hit[CategoryID])do
Score=Score+UnitData.Score
ScoreHit=ScoreHit+UnitData.ScoreHit
Penalty=Penalty+UnitData.Penalty
PenaltyHit=UnitData.PenaltyHit
end
local ScoreMessageHit=string.format("%s: %d  ",CategoryName,Score-Penalty)
self:T(ScoreMessageHit)
ScoreMessageHits=ScoreMessageHits..ScoreMessageHit
PlayerScore=PlayerScore+Score
PlayerPenalty=PlayerPenalty+Penalty
else
end
end
if ScoreMessageHits~=""then
ScoreMessage="Hits: "..ScoreMessageHits
end
end
return ScoreMessage,PlayerScore,PlayerPenalty
end
function SCORING:ReportDetailedPlayerDestroys(PlayerName)
local ScoreMessage=""
local PlayerScore=0
local PlayerPenalty=0
local PlayerData=self.Players[PlayerName]
if PlayerData then
self:T("Score Player: "..PlayerName)
local InitUnitCoalition=_SCORINGCoalition[PlayerData.UnitCoalition]
local InitUnitCategory=_SCORINGCategory[PlayerData.UnitCategory]
local InitUnitType=PlayerData.UnitType
local InitUnitName=PlayerData.UnitName
local ScoreMessageDestroys=""
for CategoryID,CategoryName in pairs(_SCORINGCategory)do
if PlayerData.Destroy[CategoryID]then
self:T("Destroy scores exist for player "..PlayerName)
local Score=0
local ScoreDestroy=0
local Penalty=0
local PenaltyDestroy=0
for UnitName,UnitData in pairs(PlayerData.Destroy[CategoryID])do
self:F({UnitData=UnitData})
if UnitData~={}then
Score=Score+UnitData.Score
ScoreDestroy=ScoreDestroy+UnitData.ScoreDestroy
Penalty=Penalty+UnitData.Penalty
PenaltyDestroy=PenaltyDestroy+UnitData.PenaltyDestroy
end
end
local ScoreMessageDestroy=string.format("  %s: %d  ",CategoryName,Score-Penalty)
self:T(ScoreMessageDestroy)
ScoreMessageDestroys=ScoreMessageDestroys..ScoreMessageDestroy
PlayerScore=PlayerScore+Score
PlayerPenalty=PlayerPenalty+Penalty
else
end
end
if ScoreMessageDestroys~=""then
ScoreMessage="Destroys: "..ScoreMessageDestroys
end
end
return ScoreMessage,PlayerScore,PlayerPenalty
end
function SCORING:ReportDetailedPlayerCoalitionChanges(PlayerName)
local ScoreMessage=""
local PlayerScore=0
local PlayerPenalty=0
local PlayerData=self.Players[PlayerName]
if PlayerData then
self:T("Score Player: "..PlayerName)
local InitUnitCoalition=_SCORINGCoalition[PlayerData.UnitCoalition]
local InitUnitCategory=_SCORINGCategory[PlayerData.UnitCategory]
local InitUnitType=PlayerData.UnitType
local InitUnitName=PlayerData.UnitName
local ScoreMessageCoalitionChangePenalties=""
if PlayerData.PenaltyCoalition~=0 then
ScoreMessageCoalitionChangePenalties=ScoreMessageCoalitionChangePenalties..string.format(" -%d (%d changed)",PlayerData.Penalty,PlayerData.PenaltyCoalition)
PlayerPenalty=PlayerPenalty+PlayerData.Penalty
end
if ScoreMessageCoalitionChangePenalties~=""then
ScoreMessage=ScoreMessage.."Coalition Penalties: "..ScoreMessageCoalitionChangePenalties
end
end
return ScoreMessage,PlayerScore,PlayerPenalty
end
function SCORING:ReportDetailedPlayerGoals(PlayerName)
local ScoreMessage=""
local PlayerScore=0
local PlayerPenalty=0
local PlayerData=self.Players[PlayerName]
if PlayerData then
self:T("Score Player: "..PlayerName)
local InitUnitCoalition=_SCORINGCoalition[PlayerData.UnitCoalition]
local InitUnitCategory=_SCORINGCategory[PlayerData.UnitCategory]
local InitUnitType=PlayerData.UnitType
local InitUnitName=PlayerData.UnitName
local ScoreMessageGoal=""
local ScoreGoal=0
local ScoreTask=0
for GoalName,GoalData in pairs(PlayerData.Goals)do
ScoreGoal=ScoreGoal+GoalData.Score
ScoreMessageGoal=ScoreMessageGoal.."'"..GoalName.."':"..GoalData.Score.."; "
end
PlayerScore=PlayerScore+ScoreGoal
if ScoreMessageGoal~=""then
ScoreMessage="Goals: "..ScoreMessageGoal
end
end
return ScoreMessage,PlayerScore,PlayerPenalty
end
function SCORING:ReportDetailedPlayerMissions(PlayerName)
local ScoreMessage=""
local PlayerScore=0
local PlayerPenalty=0
local PlayerData=self.Players[PlayerName]
if PlayerData then
self:T("Score Player: "..PlayerName)
local InitUnitCoalition=_SCORINGCoalition[PlayerData.UnitCoalition]
local InitUnitCategory=_SCORINGCategory[PlayerData.UnitCategory]
local InitUnitType=PlayerData.UnitType
local InitUnitName=PlayerData.UnitName
local ScoreMessageMission=""
local ScoreMission=0
local ScoreTask=0
for MissionName,MissionData in pairs(PlayerData.Mission)do
ScoreMission=ScoreMission+MissionData.ScoreMission
ScoreTask=ScoreTask+MissionData.ScoreTask
ScoreMessageMission=ScoreMessageMission.."'"..MissionName.."'; "
end
PlayerScore=PlayerScore+ScoreMission+ScoreTask
if ScoreMessageMission~=""then
ScoreMessage="Tasks: "..ScoreTask.." Mission: "..ScoreMission.." ( "..ScoreMessageMission..")"
end
end
return ScoreMessage,PlayerScore,PlayerPenalty
end
function SCORING:ReportScoreGroupSummary(PlayerGroup)
local PlayerMessage=""
self:T("Report Score Group Summary")
local PlayerUnits=PlayerGroup:GetUnits()
for UnitID,PlayerUnit in pairs(PlayerUnits)do
local PlayerUnit=PlayerUnit
local PlayerName=PlayerUnit:GetPlayerName()
if PlayerName then
local ReportHits,ScoreHits,PenaltyHits=self:ReportDetailedPlayerHits(PlayerName)
ReportHits=ReportHits~=""and"\n- "..ReportHits or ReportHits
self:F({ReportHits,ScoreHits,PenaltyHits})
local ReportDestroys,ScoreDestroys,PenaltyDestroys=self:ReportDetailedPlayerDestroys(PlayerName)
ReportDestroys=ReportDestroys~=""and"\n- "..ReportDestroys or ReportDestroys
self:F({ReportDestroys,ScoreDestroys,PenaltyDestroys})
local ReportCoalitionChanges,ScoreCoalitionChanges,PenaltyCoalitionChanges=self:ReportDetailedPlayerCoalitionChanges(PlayerName)
ReportCoalitionChanges=ReportCoalitionChanges~=""and"\n- "..ReportCoalitionChanges or ReportCoalitionChanges
self:F({ReportCoalitionChanges,ScoreCoalitionChanges,PenaltyCoalitionChanges})
local ReportGoals,ScoreGoals,PenaltyGoals=self:ReportDetailedPlayerGoals(PlayerName)
ReportGoals=ReportGoals~=""and"\n- "..ReportGoals or ReportGoals
self:F({ReportGoals,ScoreGoals,PenaltyGoals})
local ReportMissions,ScoreMissions,PenaltyMissions=self:ReportDetailedPlayerMissions(PlayerName)
ReportMissions=ReportMissions~=""and"\n- "..ReportMissions or ReportMissions
self:F({ReportMissions,ScoreMissions,PenaltyMissions})
local PlayerScore=ScoreHits+ScoreDestroys+ScoreCoalitionChanges+ScoreGoals+ScoreMissions
local PlayerPenalty=PenaltyHits+PenaltyDestroys+PenaltyCoalitionChanges+PenaltyGoals+PenaltyMissions
PlayerMessage=string.format("Player '%s' Score = %d ( %d Score, -%d Penalties )",
PlayerName,
PlayerScore-PlayerPenalty,
PlayerScore,
PlayerPenalty
)
MESSAGE:NewType(PlayerMessage,MESSAGE.Type.Detailed):ToGroup(PlayerGroup)
end
end
end
function SCORING:ReportScoreGroupDetailed(PlayerGroup)
local PlayerMessage=""
self:T("Report Score Group Detailed")
local PlayerUnits=PlayerGroup:GetUnits()
for UnitID,PlayerUnit in pairs(PlayerUnits)do
local PlayerUnit=PlayerUnit
local PlayerName=PlayerUnit:GetPlayerName()
if PlayerName then
local ReportHits,ScoreHits,PenaltyHits=self:ReportDetailedPlayerHits(PlayerName)
ReportHits=ReportHits~=""and"\n- "..ReportHits or ReportHits
self:F({ReportHits,ScoreHits,PenaltyHits})
local ReportDestroys,ScoreDestroys,PenaltyDestroys=self:ReportDetailedPlayerDestroys(PlayerName)
ReportDestroys=ReportDestroys~=""and"\n- "..ReportDestroys or ReportDestroys
self:F({ReportDestroys,ScoreDestroys,PenaltyDestroys})
local ReportCoalitionChanges,ScoreCoalitionChanges,PenaltyCoalitionChanges=self:ReportDetailedPlayerCoalitionChanges(PlayerName)
ReportCoalitionChanges=ReportCoalitionChanges~=""and"\n- "..ReportCoalitionChanges or ReportCoalitionChanges
self:F({ReportCoalitionChanges,ScoreCoalitionChanges,PenaltyCoalitionChanges})
local ReportGoals,ScoreGoals,PenaltyGoals=self:ReportDetailedPlayerGoals(PlayerName)
ReportGoals=ReportGoals~=""and"\n- "..ReportGoals or ReportGoals
self:F({ReportGoals,ScoreGoals,PenaltyGoals})
local ReportMissions,ScoreMissions,PenaltyMissions=self:ReportDetailedPlayerMissions(PlayerName)
ReportMissions=ReportMissions~=""and"\n- "..ReportMissions or ReportMissions
self:F({ReportMissions,ScoreMissions,PenaltyMissions})
local PlayerScore=ScoreHits+ScoreDestroys+ScoreCoalitionChanges+ScoreGoals+ScoreMissions
local PlayerPenalty=PenaltyHits+PenaltyDestroys+PenaltyCoalitionChanges+PenaltyGoals+PenaltyMissions
PlayerMessage=
string.format("Player '%s' Score = %d ( %d Score, -%d Penalties )%s%s%s%s%s",
PlayerName,
PlayerScore-PlayerPenalty,
PlayerScore,
PlayerPenalty,
ReportHits,
ReportDestroys,
ReportCoalitionChanges,
ReportGoals,
ReportMissions
)
MESSAGE:NewType(PlayerMessage,MESSAGE.Type.Detailed):ToGroup(PlayerGroup)
end
end
end
function SCORING:ReportScoreAllSummary(PlayerGroup)
local PlayerMessage=""
self:T({"Summary Score Report of All Players",Players=self.Players})
for PlayerName,PlayerData in pairs(self.Players)do
self:T({PlayerName=PlayerName,PlayerGroup=PlayerGroup})
if PlayerName then
local ReportHits,ScoreHits,PenaltyHits=self:ReportDetailedPlayerHits(PlayerName)
ReportHits=ReportHits~=""and"\n- "..ReportHits or ReportHits
self:F({ReportHits,ScoreHits,PenaltyHits})
local ReportDestroys,ScoreDestroys,PenaltyDestroys=self:ReportDetailedPlayerDestroys(PlayerName)
ReportDestroys=ReportDestroys~=""and"\n- "..ReportDestroys or ReportDestroys
self:F({ReportDestroys,ScoreDestroys,PenaltyDestroys})
local ReportCoalitionChanges,ScoreCoalitionChanges,PenaltyCoalitionChanges=self:ReportDetailedPlayerCoalitionChanges(PlayerName)
ReportCoalitionChanges=ReportCoalitionChanges~=""and"\n- "..ReportCoalitionChanges or ReportCoalitionChanges
self:F({ReportCoalitionChanges,ScoreCoalitionChanges,PenaltyCoalitionChanges})
local ReportGoals,ScoreGoals,PenaltyGoals=self:ReportDetailedPlayerGoals(PlayerName)
ReportGoals=ReportGoals~=""and"\n- "..ReportGoals or ReportGoals
self:F({ReportGoals,ScoreGoals,PenaltyGoals})
local ReportMissions,ScoreMissions,PenaltyMissions=self:ReportDetailedPlayerMissions(PlayerName)
ReportMissions=ReportMissions~=""and"\n- "..ReportMissions or ReportMissions
self:F({ReportMissions,ScoreMissions,PenaltyMissions})
local PlayerScore=ScoreHits+ScoreDestroys+ScoreCoalitionChanges+ScoreGoals+ScoreMissions
local PlayerPenalty=PenaltyHits+PenaltyDestroys+PenaltyCoalitionChanges+PenaltyGoals+PenaltyMissions
PlayerMessage=
string.format("Player '%s' Score = %d ( %d Score, -%d Penalties )",
PlayerName,
PlayerScore-PlayerPenalty,
PlayerScore,
PlayerPenalty
)
MESSAGE:NewType(PlayerMessage,MESSAGE.Type.Overview):ToGroup(PlayerGroup)
end
end
end
function SCORING:SecondsToClock(sSeconds)
local nSeconds=sSeconds
if nSeconds==0 then
return"00:00:00";
else
local nHours=string.format("%02.f",math.floor(nSeconds/3600));
local nMins=string.format("%02.f",math.floor(nSeconds/60-(nHours*60)));
local nSecs=string.format("%02.f",math.floor(nSeconds-nHours*3600-nMins*60));
return nHours..":"..nMins..":"..nSecs
end
end
function SCORING:OpenCSV(ScoringCSV)
self:F(ScoringCSV)
if lfs and io and os and self.AutoSave==true then
if ScoringCSV then
self.ScoringCSV=ScoringCSV
local path=self.AutoSavePath or lfs.writedir()..[[Logs\]]
local fdir=path..self.ScoringCSV.." "..os.date("%Y-%m-%d %H-%M-%S")..".csv"
self.CSVFile,self.err=io.open(fdir,"w+")
if not self.CSVFile then
error("Error: Cannot open CSV file in "..lfs.writedir())
end
self.CSVFile:write('"GameName","RunTime","Time","PlayerName","TargetPlayerName","ScoreType","PlayerUnitCoalition","PlayerUnitCategory","PlayerUnitType","PlayerUnitName","TargetUnitCoalition","TargetUnitCategory","TargetUnitType","TargetUnitName","Times","Score"\n')
self.RunTime=os.date("%y-%m-%d_%H-%M-%S")
else
error("A string containing the CSV file name must be given.")
end
else
self:F("The MissionScripting.lua file has not been changed to allow lfs, io and os modules to be used...")
end
return self
end
function SCORING:ScoreCSV(PlayerName,TargetPlayerName,ScoreType,ScoreTimes,ScoreAmount,PlayerUnitName,PlayerUnitCoalition,PlayerUnitCategory,PlayerUnitType,TargetUnitName,TargetUnitCoalition,TargetUnitCategory,TargetUnitType)
local ScoreTime=self:SecondsToClock(timer.getTime())
PlayerName=PlayerName:gsub('"','_')
TargetPlayerName=TargetPlayerName or""
TargetPlayerName=TargetPlayerName:gsub('"','_')
if PlayerUnitName and PlayerUnitName~=''then
local PlayerUnit=Unit.getByName(PlayerUnitName)
if PlayerUnit then
if not PlayerUnitCategory then
PlayerUnitCategory=_SCORINGCategory[PlayerUnit:getDesc().category]
end
if not PlayerUnitCoalition then
PlayerUnitCoalition=_SCORINGCoalition[PlayerUnit:getCoalition()]
end
if not PlayerUnitType then
PlayerUnitType=PlayerUnit:getTypeName()
end
else
PlayerUnitName=''
PlayerUnitCategory=''
PlayerUnitCoalition=''
PlayerUnitType=''
end
else
PlayerUnitName=''
PlayerUnitCategory=''
PlayerUnitCoalition=''
PlayerUnitType=''
end
TargetUnitCoalition=TargetUnitCoalition or""
TargetUnitCategory=TargetUnitCategory or""
TargetUnitType=TargetUnitType or""
TargetUnitName=TargetUnitName or""
if lfs and io and os and self.AutoSave then
self.CSVFile:write(
'"'..self.GameName..'"'..','..
'"'..self.RunTime..'"'..','..
''..ScoreTime..''..','..
'"'..PlayerName..'"'..','..
'"'..TargetPlayerName..'"'..','..
'"'..ScoreType..'"'..','..
'"'..PlayerUnitCoalition..'"'..','..
'"'..PlayerUnitCategory..'"'..','..
'"'..PlayerUnitType..'"'..','..
'"'..PlayerUnitName..'"'..','..
'"'..TargetUnitCoalition..'"'..','..
'"'..TargetUnitCategory..'"'..','..
'"'..TargetUnitType..'"'..','..
'"'..TargetUnitName..'"'..','..
''..ScoreTimes..''..','..
''..ScoreAmount
)
self.CSVFile:write("\n")
end
end
function SCORING:CloseCSV()
if lfs and io and os and self.AutoSave then
self.CSVFile:close()
end
end
function SCORING:SwitchAutoSave(OnOff)
self.AutoSave=OnOff
return self
end
function SCORING:OnKillPvP(PlayerName,TargetPlayerName,IsTeamKill,TargetThreatLevel,PlayerThreatLevel,Score)
end
function SCORING:OnKillPvE(PlayerName,TargetUnitName,IsTeamKill,TargetThreatLevel,PlayerThreatLevel,Score)
end
CLEANUP_AIRBASE={
ClassName="CLEANUP_AIRBASE",
TimeInterval=0.2,
CleanUpList={},
}
CLEANUP_AIRBASE.__={}
CLEANUP_AIRBASE.__.Airbases={}
function CLEANUP_AIRBASE:New(AirbaseNames)
local self=BASE:Inherit(self,BASE:New())
self:F({AirbaseNames})
if type(AirbaseNames)=='table'then
for AirbaseID,AirbaseName in pairs(AirbaseNames)do
self:AddAirbase(AirbaseName)
end
else
local AirbaseName=AirbaseNames
self:AddAirbase(AirbaseName)
end
self:HandleEvent(EVENTS.Birth,self.__.OnEventBirth)
self.__.CleanUpScheduler=SCHEDULER:New(self,self.__.CleanUpSchedule,{},1,self.TimeInterval)
self:HandleEvent(EVENTS.EngineShutdown,self.__.EventAddForCleanUp)
self:HandleEvent(EVENTS.EngineStartup,self.__.EventAddForCleanUp)
self:HandleEvent(EVENTS.Hit,self.__.EventAddForCleanUp)
self:HandleEvent(EVENTS.PilotDead,self.__.OnEventCrash)
self:HandleEvent(EVENTS.Dead,self.__.OnEventCrash)
self:HandleEvent(EVENTS.Crash,self.__.OnEventCrash)
for UnitName,Unit in pairs(_DATABASE.UNITS)do
local Unit=Unit
if Unit:IsAlive()~=nil then
if self:IsInAirbase(Unit:GetVec2())then
self:F({UnitName=UnitName})
self.CleanUpList[UnitName]={}
self.CleanUpList[UnitName].CleanUpUnit=Unit
self.CleanUpList[UnitName].CleanUpGroup=Unit:GetGroup()
self.CleanUpList[UnitName].CleanUpGroupName=Unit:GetGroup():GetName()
self.CleanUpList[UnitName].CleanUpUnitName=Unit:GetName()
end
end
end
return self
end
function CLEANUP_AIRBASE:AddAirbase(AirbaseName)
self.__.Airbases[AirbaseName]=AIRBASE:FindByName(AirbaseName)
self:F({"Airbase:",AirbaseName,self.__.Airbases[AirbaseName]:GetDesc()})
return self
end
function CLEANUP_AIRBASE:RemoveAirbase(AirbaseName)
self.__.Airbases[AirbaseName]=nil
return self
end
function CLEANUP_AIRBASE:SetCleanMissiles(CleanMissiles)
if CleanMissiles then
self:HandleEvent(EVENTS.Shot,self.__.OnEventShot)
else
self:UnHandleEvent(EVENTS.Shot)
end
end
function CLEANUP_AIRBASE.__:IsInAirbase(Vec2)
local InAirbase=false
for AirbaseName,Airbase in pairs(self.__.Airbases)do
local Airbase=Airbase
if Airbase:GetZone():IsVec2InZone(Vec2)then
InAirbase=true
break;
end
end
return InAirbase
end
function CLEANUP_AIRBASE.__:DestroyUnit(CleanUpUnit)
self:F({CleanUpUnit})
if CleanUpUnit then
local CleanUpUnitName=CleanUpUnit:GetName()
local CleanUpGroup=CleanUpUnit:GetGroup()
if CleanUpGroup:IsAlive()then
local CleanUpGroupUnits=CleanUpGroup:GetUnits()
if#CleanUpGroupUnits==1 then
local CleanUpGroupName=CleanUpGroup:GetName()
CleanUpGroup:Destroy()
else
CleanUpUnit:Destroy()
end
self.CleanUpList[CleanUpUnitName]=nil
end
end
end
function CLEANUP_AIRBASE.__:DestroyMissile(MissileObject)
self:F({MissileObject})
if MissileObject and MissileObject:isExist()then
MissileObject:destroy()
self:T("MissileObject Destroyed")
end
end
function CLEANUP_AIRBASE.__:OnEventBirth(EventData)
self:F({EventData})
if EventData and EventData.IniUnit and EventData.IniUnit:IsAlive()~=nil then
if self:IsInAirbase(EventData.IniUnit:GetVec2())then
self.CleanUpList[EventData.IniDCSUnitName]={}
self.CleanUpList[EventData.IniDCSUnitName].CleanUpUnit=EventData.IniUnit
self.CleanUpList[EventData.IniDCSUnitName].CleanUpGroup=EventData.IniGroup
self.CleanUpList[EventData.IniDCSUnitName].CleanUpGroupName=EventData.IniDCSGroupName
self.CleanUpList[EventData.IniDCSUnitName].CleanUpUnitName=EventData.IniDCSUnitName
end
end
end
function CLEANUP_AIRBASE.__:OnEventCrash(Event)
self:F({Event})
if Event.IniDCSUnitName and Event.IniCategory==Object.Category.UNIT then
self.CleanUpList[Event.IniDCSUnitName]={}
self.CleanUpList[Event.IniDCSUnitName].CleanUpUnit=Event.IniUnit
self.CleanUpList[Event.IniDCSUnitName].CleanUpGroup=Event.IniGroup
self.CleanUpList[Event.IniDCSUnitName].CleanUpGroupName=Event.IniDCSGroupName
self.CleanUpList[Event.IniDCSUnitName].CleanUpUnitName=Event.IniDCSUnitName
end
end
function CLEANUP_AIRBASE.__:OnEventShot(Event)
self:F({Event})
if self:IsInAirbase(Event.IniUnit:GetVec2())then
self:DestroyMissile(Event.Weapon)
end
end
function CLEANUP_AIRBASE.__:OnEventHit(Event)
self:F({Event})
if Event.IniUnit then
if self:IsInAirbase(Event.IniUnit:GetVec2())then
self:T({"Life: ",Event.IniDCSUnitName,' = ',Event.IniUnit:GetLife(),"/",Event.IniUnit:GetLife0()})
if Event.IniUnit:GetLife()<Event.IniUnit:GetLife0()then
self:T("CleanUp: Destroy: "..Event.IniDCSUnitName)
CLEANUP_AIRBASE.__:DestroyUnit(Event.IniUnit)
end
end
end
if Event.TgtUnit then
if self:IsInAirbase(Event.TgtUnit:GetVec2())then
self:T({"Life: ",Event.TgtDCSUnitName,' = ',Event.TgtUnit:GetLife(),"/",Event.TgtUnit:GetLife0()})
if Event.TgtUnit:GetLife()<Event.TgtUnit:GetLife0()then
self:T("CleanUp: Destroy: "..Event.TgtDCSUnitName)
CLEANUP_AIRBASE.__:DestroyUnit(Event.TgtUnit)
end
end
end
end
function CLEANUP_AIRBASE.__:AddForCleanUp(CleanUpUnit,CleanUpUnitName)
self:F({CleanUpUnit,CleanUpUnitName})
self.CleanUpList[CleanUpUnitName]={}
self.CleanUpList[CleanUpUnitName].CleanUpUnit=CleanUpUnit
self.CleanUpList[CleanUpUnitName].CleanUpUnitName=CleanUpUnitName
local CleanUpGroup=CleanUpUnit:GetGroup()
self.CleanUpList[CleanUpUnitName].CleanUpGroup=CleanUpGroup
self.CleanUpList[CleanUpUnitName].CleanUpGroupName=CleanUpGroup:GetName()
self.CleanUpList[CleanUpUnitName].CleanUpTime=timer.getTime()
self.CleanUpList[CleanUpUnitName].CleanUpMoved=false
self:T({"CleanUp: Add to CleanUpList: ",Clea