-- See https://f4.manuals.heatblur.se/dcs/modding/jester/lua_api.html for details on the API
--
-- Sample menu template for DCS F-4E Jester AI
-- Place this file in C:\Users\<username>\Saved Games\DCS_F4E\jester\mods\
local Class = require('base.Class')
local Behavior = require('base.Behavior')

local default_interval = s(5)

local MenuTemplate = Class(Behavior)

local isFirstTick = true

--- Sets up the menus.
-- Creates menu page "Menu" and subpage "Subpage" with a button "Button".
-- Adds the subpage to the main menu page.
-- Adds the menu page to the wheel root.
function SetupMenus()
    local menu_subpage = Wheel.Item.new({
        name = "Subpage",             --Name of the subpage
        menu = Wheel.Menu.new({       --Create the subpage menu
            name = "Subpage",
            items = {
                Wheel.Item.new({ 
                    name = "Button",            --Name of the button
                    action = "Button_1_Action", --Button action - Will be used in ListenTo() to detect Button 1 pressed
                    --action_value = "value"    --Action value - Optional, can be used to pass a value to the action
                })
            }
        })
    })

    local menu_page = Wheel.Item.new({
        name = "Menu",              --Name of the menu page
        menu = Wheel.Menu.new({
            name = "Menu",
            items = {
                menu_subpage        --Add the subpage to the menu page
            }
        })
    })

    Wheel.AddItem(menu_page, {})    --Add the menu page to the wheel root
end

function MenuTemplate:Constructor()
	Behavior.Constructor(self)
end

function MenuTemplate:Tick()
	if isFirstTick then	-- Run on first tick only
		isFirstTick = false

        -- Setup the menus
        -- Can be setup here instead, but I put them in a function for clarity
        SetupMenus()        

        --Create the ListenTo() functions for the actions.
        -- Listener is added global register. It isnt restricted to just this function scope.    
        ListenTo("Button_1_Action", "Btn1_Log", function()  
            Log("Button 1 pressed")
        end)
	end
end

MenuTemplate:Seal()
return MenuTemplate